// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.save');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('imcljs.fetch');
goog.require('imcljs.internal.utils');
goog.require('clojure.string');
goog.require('cljs.core.async');
/**
 * Creates a list using a plain text string of identifiers
 */
imcljs.save.im_list = (function imcljs$save$im_list(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8299 = arguments.length;
var i__4731__auto___8300 = (0);
while(true){
if((i__4731__auto___8300 < len__4730__auto___8299)){
args__4736__auto__.push((arguments[i__4731__auto___8300]));

var G__8301 = (i__4731__auto___8300 + (1));
i__4731__auto___8300 = G__8301;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((4) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((4)),(0),null)):null);
return imcljs.save.im_list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4737__auto__);
});

imcljs.save.im_list.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,type,identifiers,p__8295){
var vec__8296 = p__8295;
var options = cljs.core.nth.call(null,vec__8296,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post-body","post-body",-1481559189),["/lists?name=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"&type=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join(''),service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),identifiers,new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","text/plain"], null)], null));
});

imcljs.save.im_list.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
imcljs.save.im_list.cljs$lang$applyTo = (function (seq8290){
var G__8291 = cljs.core.first.call(null,seq8290);
var seq8290__$1 = cljs.core.next.call(null,seq8290);
var G__8292 = cljs.core.first.call(null,seq8290__$1);
var seq8290__$2 = cljs.core.next.call(null,seq8290__$1);
var G__8293 = cljs.core.first.call(null,seq8290__$2);
var seq8290__$3 = cljs.core.next.call(null,seq8290__$2);
var G__8294 = cljs.core.first.call(null,seq8290__$3);
var seq8290__$4 = cljs.core.next.call(null,seq8290__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8291,G__8292,G__8293,G__8294,seq8290__$4);
});

/**
 * Update an existing list. Currently, only updating the description by specifying
 *   `:newDescription` in the `options` map is supported.
 */
imcljs.save.im_list_update = (function imcljs$save$im_list_update(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8309 = arguments.length;
var i__4731__auto___8310 = (0);
while(true){
if((i__4731__auto___8310 < len__4730__auto___8309)){
args__4736__auto__.push((arguments[i__4731__auto___8310]));

var G__8311 = (i__4731__auto___8310 + (1));
i__4731__auto___8310 = G__8311;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.im_list_update.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.im_list_update.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,p__8305){
var vec__8306 = p__8305;
var options = cljs.core.nth.call(null,vec__8306,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"put","put",1299772570),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_update.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.im_list_update.cljs$lang$applyTo = (function (seq8302){
var G__8303 = cljs.core.first.call(null,seq8302);
var seq8302__$1 = cljs.core.next.call(null,seq8302);
var G__8304 = cljs.core.first.call(null,seq8302__$1);
var seq8302__$2 = cljs.core.next.call(null,seq8302__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8303,G__8304,seq8302__$2);
});

/**
 * Delete one or name lists.
 */
imcljs.save.im_list_delete = (function imcljs$save$im_list_delete(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8319 = arguments.length;
var i__4731__auto___8320 = (0);
while(true){
if((i__4731__auto___8320 < len__4730__auto___8319)){
args__4736__auto__.push((arguments[i__4731__auto___8320]));

var G__8321 = (i__4731__auto___8320 + (1));
i__4731__auto___8320 = G__8321;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.im_list_delete.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.im_list_delete.cljs$core$IFn$_invoke$arity$variadic = (function (service,names,p__8315){
var vec__8316 = p__8315;
var options = cljs.core.nth.call(null,vec__8316,(0),null);
if(cljs.core.coll_QMARK_.call(null,names)){
return imcljs.internal.utils._LT__LT__BANG_.call(null,cljs.core.map.call(null,((function (vec__8316,options){
return (function (name){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});})(vec__8316,options))
,names));
} else {
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),names,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
}
});

imcljs.save.im_list_delete.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.im_list_delete.cljs$lang$applyTo = (function (seq8312){
var G__8313 = cljs.core.first.call(null,seq8312);
var seq8312__$1 = cljs.core.next.call(null,seq8312);
var G__8314 = cljs.core.first.call(null,seq8312__$1);
var seq8312__$2 = cljs.core.next.call(null,seq8312__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8313,G__8314,seq8312__$2);
});

imcljs.save.im_list_rename = (function imcljs$save$im_list_rename(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8330 = arguments.length;
var i__4731__auto___8331 = (0);
while(true){
if((i__4731__auto___8331 < len__4730__auto___8330)){
args__4736__auto__.push((arguments[i__4731__auto___8331]));

var G__8332 = (i__4731__auto___8331 + (1));
i__4731__auto___8331 = G__8332;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_rename.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_rename.cljs$core$IFn$_invoke$arity$variadic = (function (service,old_name,new_name,p__8326){
var vec__8327 = p__8326;
var options = cljs.core.nth.call(null,vec__8327,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/rename",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"oldname","oldname",-234488026),old_name,new cljs.core.Keyword(null,"newname","newname",389205813),new_name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_rename.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_rename.cljs$lang$applyTo = (function (seq8322){
var G__8323 = cljs.core.first.call(null,seq8322);
var seq8322__$1 = cljs.core.next.call(null,seq8322);
var G__8324 = cljs.core.first.call(null,seq8322__$1);
var seq8322__$2 = cljs.core.next.call(null,seq8322__$1);
var G__8325 = cljs.core.first.call(null,seq8322__$2);
var seq8322__$3 = cljs.core.next.call(null,seq8322__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8323,G__8324,G__8325,seq8322__$3);
});

imcljs.save.im_list_union = (function imcljs$save$im_list_union(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8341 = arguments.length;
var i__4731__auto___8342 = (0);
while(true){
if((i__4731__auto___8342 < len__4730__auto___8341)){
args__4736__auto__.push((arguments[i__4731__auto___8342]));

var G__8343 = (i__4731__auto___8342 + (1));
i__4731__auto___8342 = G__8343;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_union.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_union.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__8337){
var vec__8338 = p__8337;
var options = cljs.core.nth.call(null,vec__8338,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/union",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_union.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_union.cljs$lang$applyTo = (function (seq8333){
var G__8334 = cljs.core.first.call(null,seq8333);
var seq8333__$1 = cljs.core.next.call(null,seq8333);
var G__8335 = cljs.core.first.call(null,seq8333__$1);
var seq8333__$2 = cljs.core.next.call(null,seq8333__$1);
var G__8336 = cljs.core.first.call(null,seq8333__$2);
var seq8333__$3 = cljs.core.next.call(null,seq8333__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8334,G__8335,G__8336,seq8333__$3);
});

imcljs.save.im_list_intersect = (function imcljs$save$im_list_intersect(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8352 = arguments.length;
var i__4731__auto___8353 = (0);
while(true){
if((i__4731__auto___8353 < len__4730__auto___8352)){
args__4736__auto__.push((arguments[i__4731__auto___8353]));

var G__8354 = (i__4731__auto___8353 + (1));
i__4731__auto___8353 = G__8354;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_intersect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_intersect.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__8348){
var vec__8349 = p__8348;
var options = cljs.core.nth.call(null,vec__8349,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/intersect",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_intersect.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_intersect.cljs$lang$applyTo = (function (seq8344){
var G__8345 = cljs.core.first.call(null,seq8344);
var seq8344__$1 = cljs.core.next.call(null,seq8344);
var G__8346 = cljs.core.first.call(null,seq8344__$1);
var seq8344__$2 = cljs.core.next.call(null,seq8344__$1);
var G__8347 = cljs.core.first.call(null,seq8344__$2);
var seq8344__$3 = cljs.core.next.call(null,seq8344__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8345,G__8346,G__8347,seq8344__$3);
});

imcljs.save.im_list_difference = (function imcljs$save$im_list_difference(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8363 = arguments.length;
var i__4731__auto___8364 = (0);
while(true){
if((i__4731__auto___8364 < len__4730__auto___8363)){
args__4736__auto__.push((arguments[i__4731__auto___8364]));

var G__8365 = (i__4731__auto___8364 + (1));
i__4731__auto___8364 = G__8365;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_difference.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_difference.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,lists,p__8359){
var vec__8360 = p__8359;
var options = cljs.core.nth.call(null,vec__8360,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/diff",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_difference.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_difference.cljs$lang$applyTo = (function (seq8355){
var G__8356 = cljs.core.first.call(null,seq8355);
var seq8355__$1 = cljs.core.next.call(null,seq8355);
var G__8357 = cljs.core.first.call(null,seq8355__$1);
var seq8355__$2 = cljs.core.next.call(null,seq8355__$1);
var G__8358 = cljs.core.first.call(null,seq8355__$2);
var seq8355__$3 = cljs.core.next.call(null,seq8355__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8356,G__8357,G__8358,seq8355__$3);
});

imcljs.save.im_list_subtraction = (function imcljs$save$im_list_subtraction(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8375 = arguments.length;
var i__4731__auto___8376 = (0);
while(true){
if((i__4731__auto___8376 < len__4730__auto___8375)){
args__4736__auto__.push((arguments[i__4731__auto___8376]));

var G__8377 = (i__4731__auto___8376 + (1));
i__4731__auto___8376 = G__8377;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((4) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((4)),(0),null)):null);
return imcljs.save.im_list_subtraction.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),argseq__4737__auto__);
});

imcljs.save.im_list_subtraction.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,source_lists,subtract_lists,p__8371){
var vec__8372 = p__8371;
var options = cljs.core.nth.call(null,vec__8372,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/lists/subtract",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"references","references",882562509),source_lists,new cljs.core.Keyword(null,"subtract","subtract",2136988635),subtract_lists,new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_subtraction.cljs$lang$maxFixedArity = (4);

/** @this {Function} */
imcljs.save.im_list_subtraction.cljs$lang$applyTo = (function (seq8366){
var G__8367 = cljs.core.first.call(null,seq8366);
var seq8366__$1 = cljs.core.next.call(null,seq8366);
var G__8368 = cljs.core.first.call(null,seq8366__$1);
var seq8366__$2 = cljs.core.next.call(null,seq8366__$1);
var G__8369 = cljs.core.first.call(null,seq8366__$2);
var seq8366__$3 = cljs.core.next.call(null,seq8366__$2);
var G__8370 = cljs.core.first.call(null,seq8366__$3);
var seq8366__$4 = cljs.core.next.call(null,seq8366__$3);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8367,G__8368,G__8369,G__8370,seq8366__$4);
});

imcljs.save.im_list_from_query = (function imcljs$save$im_list_from_query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8386 = arguments.length;
var i__4731__auto___8387 = (0);
while(true){
if((i__4731__auto___8387 < len__4730__auto___8386)){
args__4736__auto__.push((arguments[i__4731__auto___8387]));

var G__8388 = (i__4731__auto___8387 + (1));
i__4731__auto___8387 = G__8388;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_from_query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_from_query.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,query,p__8382){
var vec__8383 = p__8382;
var options = cljs.core.nth.call(null,vec__8383,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/tolist",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_from_query.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_from_query.cljs$lang$applyTo = (function (seq8378){
var G__8379 = cljs.core.first.call(null,seq8378);
var seq8378__$1 = cljs.core.next.call(null,seq8378);
var G__8380 = cljs.core.first.call(null,seq8378__$1);
var seq8378__$2 = cljs.core.next.call(null,seq8378__$1);
var G__8381 = cljs.core.first.call(null,seq8378__$2);
var seq8378__$3 = cljs.core.next.call(null,seq8378__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8379,G__8380,G__8381,seq8378__$3);
});

imcljs.save.im_list_add_tag = (function imcljs$save$im_list_add_tag(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8397 = arguments.length;
var i__4731__auto___8398 = (0);
while(true){
if((i__4731__auto___8398 < len__4730__auto___8397)){
args__4736__auto__.push((arguments[i__4731__auto___8398]));

var G__8399 = (i__4731__auto___8398 + (1));
i__4731__auto___8398 = G__8399;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_add_tag.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_add_tag.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,tags,p__8393){
var vec__8394 = p__8393;
var options = cljs.core.nth.call(null,vec__8394,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/tags",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"tags","tags",1771418977),((cljs.core.coll_QMARK_.call(null,tags))?clojure.string.join.call(null,";",tags):tags),new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_add_tag.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_add_tag.cljs$lang$applyTo = (function (seq8389){
var G__8390 = cljs.core.first.call(null,seq8389);
var seq8389__$1 = cljs.core.next.call(null,seq8389);
var G__8391 = cljs.core.first.call(null,seq8389__$1);
var seq8389__$2 = cljs.core.next.call(null,seq8389__$1);
var G__8392 = cljs.core.first.call(null,seq8389__$2);
var seq8389__$3 = cljs.core.next.call(null,seq8389__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8390,G__8391,G__8392,seq8389__$3);
});

imcljs.save.im_list_remove_tag = (function imcljs$save$im_list_remove_tag(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8408 = arguments.length;
var i__4731__auto___8409 = (0);
while(true){
if((i__4731__auto___8409 < len__4730__auto___8408)){
args__4736__auto__.push((arguments[i__4731__auto___8409]));

var G__8410 = (i__4731__auto___8409 + (1));
i__4731__auto___8409 = G__8410;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_remove_tag.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_remove_tag.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,tags,p__8404){
var vec__8405 = p__8404;
var options = cljs.core.nth.call(null,vec__8405,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/list/tags",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),name,new cljs.core.Keyword(null,"tags","tags",1771418977),((cljs.core.coll_QMARK_.call(null,tags))?clojure.string.join.call(null,";",tags):tags),new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.save.im_list_remove_tag.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_remove_tag.cljs$lang$applyTo = (function (seq8400){
var G__8401 = cljs.core.first.call(null,seq8400);
var seq8400__$1 = cljs.core.next.call(null,seq8400);
var G__8402 = cljs.core.first.call(null,seq8400__$1);
var seq8400__$2 = cljs.core.next.call(null,seq8400__$1);
var G__8403 = cljs.core.first.call(null,seq8400__$2);
var seq8400__$3 = cljs.core.next.call(null,seq8400__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8401,G__8402,G__8403,seq8400__$3);
});

/**
 * Copy a list by name
 */
imcljs.save.im_list_copy = (function imcljs$save$im_list_copy(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8433 = arguments.length;
var i__4731__auto___8434 = (0);
while(true){
if((i__4731__auto___8434 < len__4730__auto___8433)){
args__4736__auto__.push((arguments[i__4731__auto___8434]));

var G__8435 = (i__4731__auto___8434 + (1));
i__4731__auto___8434 = G__8435;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.im_list_copy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.im_list_copy.cljs$core$IFn$_invoke$arity$variadic = (function (service,old_name,new_name,p__8415){
var vec__8416 = p__8415;
var options = cljs.core.nth.call(null,vec__8416,(0),null);
var c__2324__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2324__auto__,vec__8416,options){
return (function (){
var f__2325__auto__ = (function (){var switch__2301__auto__ = ((function (c__2324__auto__,vec__8416,options){
return (function (state_8427){
var state_val_8428 = (state_8427[(1)]);
if((state_val_8428 === (1))){
var inst_8419 = imcljs.fetch.one_list.call(null,service,old_name);
var state_8427__$1 = state_8427;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8427__$1,(2),inst_8419);
} else {
if((state_val_8428 === (2))){
var inst_8421 = (state_8427[(2)]);
var inst_8422 = imcljs.internal.utils.copy_list_query.call(null,inst_8421);
var inst_8423 = imcljs.save.im_list_from_query.call(null,service,new_name,inst_8422);
var state_8427__$1 = state_8427;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8427__$1,(3),inst_8423);
} else {
if((state_val_8428 === (3))){
var inst_8425 = (state_8427[(2)]);
var state_8427__$1 = state_8427;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8427__$1,inst_8425);
} else {
return null;
}
}
}
});})(c__2324__auto__,vec__8416,options))
;
return ((function (switch__2301__auto__,c__2324__auto__,vec__8416,options){
return (function() {
var imcljs$save$state_machine__2302__auto__ = null;
var imcljs$save$state_machine__2302__auto____0 = (function (){
var statearr_8429 = [null,null,null,null,null,null,null];
(statearr_8429[(0)] = imcljs$save$state_machine__2302__auto__);

(statearr_8429[(1)] = (1));

return statearr_8429;
});
var imcljs$save$state_machine__2302__auto____1 = (function (state_8427){
while(true){
var ret_value__2303__auto__ = (function (){try{while(true){
var result__2304__auto__ = switch__2301__auto__.call(null,state_8427);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2304__auto__;
}
break;
}
}catch (e8430){if((e8430 instanceof Object)){
var ex__2305__auto__ = e8430;
var statearr_8431_8436 = state_8427;
(statearr_8431_8436[(5)] = ex__2305__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8427);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8430;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2303__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8437 = state_8427;
state_8427 = G__8437;
continue;
} else {
return ret_value__2303__auto__;
}
break;
}
});
imcljs$save$state_machine__2302__auto__ = function(state_8427){
switch(arguments.length){
case 0:
return imcljs$save$state_machine__2302__auto____0.call(this);
case 1:
return imcljs$save$state_machine__2302__auto____1.call(this,state_8427);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$save$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$save$state_machine__2302__auto____0;
imcljs$save$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$save$state_machine__2302__auto____1;
return imcljs$save$state_machine__2302__auto__;
})()
;})(switch__2301__auto__,c__2324__auto__,vec__8416,options))
})();
var state__2326__auto__ = (function (){var statearr_8432 = f__2325__auto__.call(null);
(statearr_8432[(6)] = c__2324__auto__);

return statearr_8432;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2326__auto__);
});})(c__2324__auto__,vec__8416,options))
);

return c__2324__auto__;
});

imcljs.save.im_list_copy.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.im_list_copy.cljs$lang$applyTo = (function (seq8411){
var G__8412 = cljs.core.first.call(null,seq8411);
var seq8411__$1 = cljs.core.next.call(null,seq8411);
var G__8413 = cljs.core.first.call(null,seq8411__$1);
var seq8411__$2 = cljs.core.next.call(null,seq8411__$1);
var G__8414 = cljs.core.first.call(null,seq8411__$2);
var seq8411__$3 = cljs.core.next.call(null,seq8411__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8412,G__8413,G__8414,seq8411__$3);
});

/**
 * Perform a list upgrade, replacing it with the specified up-to-date object IDs.
 */
imcljs.save.im_list_upgrade = (function imcljs$save$im_list_upgrade(service,name,object_ids){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post-body","post-body",-1481559189),["/upgradelist?name=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''),service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),clojure.string.join.call(null,", ",object_ids),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","text/plain"], null)], null));
});
/**
 * Set the preferences for the authenticated user by passing a map.
 *   Note that none of the values can be an empty string. For that you'll have to
 *   use `delete-preference` instead.
 */
imcljs.save.preferences = (function imcljs$save$preferences(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8445 = arguments.length;
var i__4731__auto___8446 = (0);
while(true){
if((i__4731__auto___8446 < len__4730__auto___8445)){
args__4736__auto__.push((arguments[i__4731__auto___8446]));

var G__8447 = (i__4731__auto___8446 + (1));
i__4731__auto___8446 = G__8447;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.preferences.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.preferences.cljs$core$IFn$_invoke$arity$variadic = (function (service,preferences,p__8441){
var vec__8442 = p__8441;
var options = cljs.core.nth.call(null,vec__8442,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/preferences",service,cljs.core.merge.call(null,preferences,options),new cljs.core.Keyword(null,"preferences","preferences",-484312211));
});

imcljs.save.preferences.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.preferences.cljs$lang$applyTo = (function (seq8438){
var G__8439 = cljs.core.first.call(null,seq8438);
var seq8438__$1 = cljs.core.next.call(null,seq8438);
var G__8440 = cljs.core.first.call(null,seq8438__$1);
var seq8438__$2 = cljs.core.next.call(null,seq8438__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8439,G__8440,seq8438__$2);
});

/**
 * Delete a single stored preference by key for the authenticated user.
 */
imcljs.save.delete_preference = (function imcljs$save$delete_preference(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8455 = arguments.length;
var i__4731__auto___8456 = (0);
while(true){
if((i__4731__auto___8456 < len__4730__auto___8455)){
args__4736__auto__.push((arguments[i__4731__auto___8456]));

var G__8457 = (i__4731__auto___8456 + (1));
i__4731__auto___8456 = G__8457;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.delete_preference.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.delete_preference.cljs$core$IFn$_invoke$arity$variadic = (function (service,preference,p__8451){
var vec__8452 = p__8451;
var options = cljs.core.nth.call(null,vec__8452,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),preference], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/user/preferences",service,params,new cljs.core.Keyword(null,"preferences","preferences",-484312211));
});

imcljs.save.delete_preference.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.delete_preference.cljs$lang$applyTo = (function (seq8448){
var G__8449 = cljs.core.first.call(null,seq8448);
var seq8448__$1 = cljs.core.next.call(null,seq8448);
var G__8450 = cljs.core.first.call(null,seq8448__$1);
var seq8448__$2 = cljs.core.next.call(null,seq8448__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8449,G__8450,seq8448__$2);
});

/**
 * Upload a query to be saved into the user's profile.
 *   As of InterMine 4.1.2, the webservice returns an invalid JSON response, hence
 *   why we use `:format 'text'` and no xform.
 */
imcljs.save.query = (function imcljs$save$query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8465 = arguments.length;
var i__4731__auto___8466 = (0);
while(true){
if((i__4731__auto___8466 < len__4730__auto___8465)){
args__4736__auto__.push((arguments[i__4731__auto___8466]));

var G__8467 = (i__4731__auto___8466 + (1));
i__4731__auto___8466 = G__8467;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.query.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__8461){
var vec__8462 = p__8461;
var options = cljs.core.nth.call(null,vec__8462,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/user/queries",service,params);
});

imcljs.save.query.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.query.cljs$lang$applyTo = (function (seq8458){
var G__8459 = cljs.core.first.call(null,seq8458);
var seq8458__$1 = cljs.core.next.call(null,seq8458);
var G__8460 = cljs.core.first.call(null,seq8458__$1);
var seq8458__$2 = cljs.core.next.call(null,seq8458__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8459,G__8460,seq8458__$2);
});

/**
 * Delete a query that has previously been saved into the user's profile.
 */
imcljs.save.delete_query = (function imcljs$save$delete_query(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8475 = arguments.length;
var i__4731__auto___8476 = (0);
while(true){
if((i__4731__auto___8476 < len__4730__auto___8475)){
args__4736__auto__.push((arguments[i__4731__auto___8476]));

var G__8477 = (i__4731__auto___8476 + (1));
i__4731__auto___8476 = G__8477;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.delete_query.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.delete_query.cljs$core$IFn$_invoke$arity$variadic = (function (service,title,p__8471){
var vec__8472 = p__8471;
var options = cljs.core.nth.call(null,vec__8472,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),title], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/user/queries",service,params);
});

imcljs.save.delete_query.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.delete_query.cljs$lang$applyTo = (function (seq8468){
var G__8469 = cljs.core.first.call(null,seq8468);
var seq8468__$1 = cljs.core.next.call(null,seq8468);
var G__8470 = cljs.core.first.call(null,seq8468__$1);
var seq8468__$2 = cljs.core.next.call(null,seq8468__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8469,G__8470,seq8468__$2);
});

/**
 * Add a new key to the BlueGenes-specific config for a mine.
 *   Requires that you are authenticated as an admin.
 */
imcljs.save.bluegenes_properties = (function imcljs$save$bluegenes_properties(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8486 = arguments.length;
var i__4731__auto___8487 = (0);
while(true){
if((i__4731__auto___8487 < len__4730__auto___8486)){
args__4736__auto__.push((arguments[i__4731__auto___8487]));

var G__8488 = (i__4731__auto___8487 + (1));
i__4731__auto___8487 = G__8488;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic = (function (service,key,value,p__8482){
var vec__8483 = p__8482;
var options = cljs.core.nth.call(null,vec__8483,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"value","value",305978217),value], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/bluegenes-properties",service,params);
});

imcljs.save.bluegenes_properties.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.bluegenes_properties.cljs$lang$applyTo = (function (seq8478){
var G__8479 = cljs.core.first.call(null,seq8478);
var seq8478__$1 = cljs.core.next.call(null,seq8478);
var G__8480 = cljs.core.first.call(null,seq8478__$1);
var seq8478__$2 = cljs.core.next.call(null,seq8478__$1);
var G__8481 = cljs.core.first.call(null,seq8478__$2);
var seq8478__$3 = cljs.core.next.call(null,seq8478__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8479,G__8480,G__8481,seq8478__$3);
});

/**
 * Update an existing key in the BlueGenes-specific config for a mine.
 *   Requires that you are authenticated as an admin.
 */
imcljs.save.update_bluegenes_properties = (function imcljs$save$update_bluegenes_properties(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8497 = arguments.length;
var i__4731__auto___8498 = (0);
while(true){
if((i__4731__auto___8498 < len__4730__auto___8497)){
args__4736__auto__.push((arguments[i__4731__auto___8498]));

var G__8499 = (i__4731__auto___8498 + (1));
i__4731__auto___8498 = G__8499;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.update_bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.update_bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic = (function (service,key,value,p__8493){
var vec__8494 = p__8493;
var options = cljs.core.nth.call(null,vec__8494,(0),null);
var legacy_QMARK_ = cljs.core.nth.call(null,vec__8494,(1),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"value","value",305978217),value], null),options);
var method = (cljs.core.truth_(legacy_QMARK_)?new cljs.core.Keyword(null,"put","put",1299772570):new cljs.core.Keyword(null,"put-body","put-body",-118601563));
return imcljs.internal.io.restful.call(null,method,"/bluegenes-properties",service,params);
});

imcljs.save.update_bluegenes_properties.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.update_bluegenes_properties.cljs$lang$applyTo = (function (seq8489){
var G__8490 = cljs.core.first.call(null,seq8489);
var seq8489__$1 = cljs.core.next.call(null,seq8489);
var G__8491 = cljs.core.first.call(null,seq8489__$1);
var seq8489__$2 = cljs.core.next.call(null,seq8489__$1);
var G__8492 = cljs.core.first.call(null,seq8489__$2);
var seq8489__$3 = cljs.core.next.call(null,seq8489__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8490,G__8491,G__8492,seq8489__$3);
});

/**
 * Delete an existing key in the BlueGenes-specific config for a mine.
 *   Requires that you are authenticated as an admin.
 */
imcljs.save.delete_bluegenes_properties = (function imcljs$save$delete_bluegenes_properties(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8507 = arguments.length;
var i__4731__auto___8508 = (0);
while(true){
if((i__4731__auto___8508 < len__4730__auto___8507)){
args__4736__auto__.push((arguments[i__4731__auto___8508]));

var G__8509 = (i__4731__auto___8508 + (1));
i__4731__auto___8508 = G__8509;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.delete_bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.delete_bluegenes_properties.cljs$core$IFn$_invoke$arity$variadic = (function (service,key,p__8503){
var vec__8504 = p__8503;
var options = cljs.core.nth.call(null,vec__8504,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),key], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/bluegenes-properties",service,params);
});

imcljs.save.delete_bluegenes_properties.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.delete_bluegenes_properties.cljs$lang$applyTo = (function (seq8500){
var G__8501 = cljs.core.first.call(null,seq8500);
var seq8500__$1 = cljs.core.next.call(null,seq8500);
var G__8502 = cljs.core.first.call(null,seq8500__$1);
var seq8500__$2 = cljs.core.next.call(null,seq8500__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8501,G__8502,seq8500__$2);
});

/**
 * Uses the mine's email service to send an email to the maintainers.
 *   Email is optional and will be excluded if nil or empty.
 */
imcljs.save.feedback = (function imcljs$save$feedback(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8519 = arguments.length;
var i__4731__auto___8520 = (0);
while(true){
if((i__4731__auto___8520 < len__4730__auto___8519)){
args__4736__auto__.push((arguments[i__4731__auto___8520]));

var G__8521 = (i__4731__auto___8520 + (1));
i__4731__auto___8520 = G__8521;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.feedback.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.feedback.cljs$core$IFn$_invoke$arity$variadic = (function (service,email,feedback,p__8514){
var vec__8515 = p__8514;
var options = cljs.core.nth.call(null,vec__8515,(0),null);
var params = (function (){var G__8518 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"feedback","feedback",1624587107),feedback], null);
if((!(clojure.string.blank_QMARK_.call(null,email)))){
return cljs.core.assoc.call(null,G__8518,new cljs.core.Keyword(null,"email","email",1415816706),email);
} else {
return G__8518;
}
})();
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/feedback",service,cljs.core.merge.call(null,params,options));
});

imcljs.save.feedback.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.feedback.cljs$lang$applyTo = (function (seq8510){
var G__8511 = cljs.core.first.call(null,seq8510);
var seq8510__$1 = cljs.core.next.call(null,seq8510);
var G__8512 = cljs.core.first.call(null,seq8510__$1);
var seq8510__$2 = cljs.core.next.call(null,seq8510__$1);
var G__8513 = cljs.core.first.call(null,seq8510__$2);
var seq8510__$3 = cljs.core.next.call(null,seq8510__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8511,G__8512,G__8513,seq8510__$3);
});

/**
 * Save a template, or overwrite an existing with the same name.
 *   Takes one or more templates each containing a query, serialised in XML or JSON.
 */
imcljs.save.template = (function imcljs$save$template(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8529 = arguments.length;
var i__4731__auto___8530 = (0);
while(true){
if((i__4731__auto___8530 < len__4730__auto___8529)){
args__4736__auto__.push((arguments[i__4731__auto___8530]));

var G__8531 = (i__4731__auto___8530 + (1));
i__4731__auto___8530 = G__8531;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.template.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.template.cljs$core$IFn$_invoke$arity$variadic = (function (service,template_query,p__8525){
var vec__8526 = p__8525;
var options = cljs.core.nth.call(null,vec__8526,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),template_query], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/template/upload",service,params);
});

imcljs.save.template.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.template.cljs$lang$applyTo = (function (seq8522){
var G__8523 = cljs.core.first.call(null,seq8522);
var seq8522__$1 = cljs.core.next.call(null,seq8522);
var G__8524 = cljs.core.first.call(null,seq8522__$1);
var seq8522__$2 = cljs.core.next.call(null,seq8522__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8523,G__8524,seq8522__$2);
});

/**
 * Delete a template by name.
 */
imcljs.save.delete_template = (function imcljs$save$delete_template(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8539 = arguments.length;
var i__4731__auto___8540 = (0);
while(true){
if((i__4731__auto___8540 < len__4730__auto___8539)){
args__4736__auto__.push((arguments[i__4731__auto___8540]));

var G__8541 = (i__4731__auto___8540 + (1));
i__4731__auto___8540 = G__8541;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.delete_template.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.delete_template.cljs$core$IFn$_invoke$arity$variadic = (function (service,template_name,p__8535){
var vec__8536 = p__8535;
var options = cljs.core.nth.call(null,vec__8536,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),template_name], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),["/templates/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(template_name)].join(''),service,params);
});

imcljs.save.delete_template.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.delete_template.cljs$lang$applyTo = (function (seq8532){
var G__8533 = cljs.core.first.call(null,seq8532);
var seq8532__$1 = cljs.core.next.call(null,seq8532);
var G__8534 = cljs.core.first.call(null,seq8532__$1);
var seq8532__$2 = cljs.core.next.call(null,seq8532__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8533,G__8534,seq8532__$2);
});

/**
 * Precompute a template by name. Must be owned by superuser.
 */
imcljs.save.precompute = (function imcljs$save$precompute(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8549 = arguments.length;
var i__4731__auto___8550 = (0);
while(true){
if((i__4731__auto___8550 < len__4730__auto___8549)){
args__4736__auto__.push((arguments[i__4731__auto___8550]));

var G__8551 = (i__4731__auto___8550 + (1));
i__4731__auto___8550 = G__8551;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.precompute.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.precompute.cljs$core$IFn$_invoke$arity$variadic = (function (service,template_name,p__8545){
var vec__8546 = p__8545;
var options = cljs.core.nth.call(null,vec__8546,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),template_name], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/template/precompute",service,params,new cljs.core.Keyword(null,"templates","templates",-1237401733));
});

imcljs.save.precompute.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.precompute.cljs$lang$applyTo = (function (seq8542){
var G__8543 = cljs.core.first.call(null,seq8542);
var seq8542__$1 = cljs.core.next.call(null,seq8542);
var G__8544 = cljs.core.first.call(null,seq8542__$1);
var seq8542__$2 = cljs.core.next.call(null,seq8542__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8543,G__8544,seq8542__$2);
});

/**
 * Summarise a template by name. Must be owned by superuser.
 */
imcljs.save.summarise = (function imcljs$save$summarise(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8559 = arguments.length;
var i__4731__auto___8560 = (0);
while(true){
if((i__4731__auto___8560 < len__4730__auto___8559)){
args__4736__auto__.push((arguments[i__4731__auto___8560]));

var G__8561 = (i__4731__auto___8560 + (1));
i__4731__auto___8560 = G__8561;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.save.summarise.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.save.summarise.cljs$core$IFn$_invoke$arity$variadic = (function (service,template_name,p__8555){
var vec__8556 = p__8555;
var options = cljs.core.nth.call(null,vec__8556,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),template_name], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/template/summarise",service,params,new cljs.core.Keyword(null,"templates","templates",-1237401733));
});

imcljs.save.summarise.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.save.summarise.cljs$lang$applyTo = (function (seq8552){
var G__8553 = cljs.core.first.call(null,seq8552);
var seq8552__$1 = cljs.core.next.call(null,seq8552);
var G__8554 = cljs.core.first.call(null,seq8552__$1);
var seq8552__$2 = cljs.core.next.call(null,seq8552__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8553,G__8554,seq8552__$2);
});

/**
 * Add one or more tags to a template.
 */
imcljs.save.template_add_tags = (function imcljs$save$template_add_tags(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8570 = arguments.length;
var i__4731__auto___8571 = (0);
while(true){
if((i__4731__auto___8571 < len__4730__auto___8570)){
args__4736__auto__.push((arguments[i__4731__auto___8571]));

var G__8572 = (i__4731__auto___8571 + (1));
i__4731__auto___8571 = G__8572;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.template_add_tags.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.template_add_tags.cljs$core$IFn$_invoke$arity$variadic = (function (service,template_name,tags,p__8566){
var vec__8567 = p__8566;
var options = cljs.core.nth.call(null,vec__8567,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),template_name,new cljs.core.Keyword(null,"tags","tags",1771418977),((cljs.core.coll_QMARK_.call(null,tags))?clojure.string.join.call(null,";",tags):tags)], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/template/tags",service,params);
});

imcljs.save.template_add_tags.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.template_add_tags.cljs$lang$applyTo = (function (seq8562){
var G__8563 = cljs.core.first.call(null,seq8562);
var seq8562__$1 = cljs.core.next.call(null,seq8562);
var G__8564 = cljs.core.first.call(null,seq8562__$1);
var seq8562__$2 = cljs.core.next.call(null,seq8562__$1);
var G__8565 = cljs.core.first.call(null,seq8562__$2);
var seq8562__$3 = cljs.core.next.call(null,seq8562__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8563,G__8564,G__8565,seq8562__$3);
});

/**
 * Delete one or more tags from a template.
 */
imcljs.save.template_remove_tags = (function imcljs$save$template_remove_tags(var_args){
var args__4736__auto__ = [];
var len__4730__auto___8581 = arguments.length;
var i__4731__auto___8582 = (0);
while(true){
if((i__4731__auto___8582 < len__4730__auto___8581)){
args__4736__auto__.push((arguments[i__4731__auto___8582]));

var G__8583 = (i__4731__auto___8582 + (1));
i__4731__auto___8582 = G__8583;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.save.template_remove_tags.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.save.template_remove_tags.cljs$core$IFn$_invoke$arity$variadic = (function (service,template_name,tags,p__8577){
var vec__8578 = p__8577;
var options = cljs.core.nth.call(null,vec__8578,(0),null);
var params = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),template_name,new cljs.core.Keyword(null,"tags","tags",1771418977),((cljs.core.coll_QMARK_.call(null,tags))?clojure.string.join.call(null,";",tags):tags)], null),options);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"delete","delete",-1768633620),"/template/tags",service,params);
});

imcljs.save.template_remove_tags.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.save.template_remove_tags.cljs$lang$applyTo = (function (seq8573){
var G__8574 = cljs.core.first.call(null,seq8573);
var seq8573__$1 = cljs.core.next.call(null,seq8573);
var G__8575 = cljs.core.first.call(null,seq8573__$1);
var seq8573__$2 = cljs.core.next.call(null,seq8573__$1);
var G__8576 = cljs.core.first.call(null,seq8573__$2);
var seq8573__$3 = cljs.core.next.call(null,seq8573__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8574,G__8575,G__8576,seq8573__$3);
});


//# sourceMappingURL=save.js.map
