// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.query');
goog.require('cljs.core');
goog.require('imcljs.path');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('imcljs.internal.utils');
imcljs.query.value = (function imcljs$query$value(x){
return ["<value>",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"</value>"].join('');
});
imcljs.query.rename_key = (function imcljs$query$rename_key(m,old_k,new_k){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,m,new_k,cljs.core.get.call(null,m,old_k)),old_k);
});
imcljs.query.add_id = (function imcljs$query$add_id(s){
if(cljs.core._EQ_.call(null,".id",cljs.core.subs.call(null,s,(cljs.core.count.call(null,s) - cljs.core.count.call(null,".id"))))){
return s;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),".id"].join('');
}
});
imcljs.query.ids__GT_constraint = (function imcljs$query$ids__GT_constraint(c){
return cljs.core.update.call(null,cljs.core.assoc.call(null,imcljs.query.rename_key.call(null,c,new cljs.core.Keyword(null,"ids","ids",-998535796),new cljs.core.Keyword(null,"values","values",372645556)),new cljs.core.Keyword(null,"op","op",-1882987955),"ONE OF"),new cljs.core.Keyword(null,"path","path",-188191168),imcljs.query.add_id);
});
imcljs.query.html_entities = new cljs.core.PersistentArrayMap(null, 4, ["<","&lt;","<=","&lt;=",">","&gt;",">=","&gt;="], null);
var cmap_2460 = new cljs.core.PersistentArrayMap(null, 4, ["\"","&quot;",">","&gt;","<","&lt;","&","&amp;"], null);
/**
 * Replace double quotation mark, angle brackets and ampersand characters with
 *  their HTML entity, as these are not permitted in XML attribute values.
 */
imcljs.query.escape_attribute = ((function (cmap_2460){
return (function imcljs$query$escape_attribute(s){
return clojure.string.escape.call(null,s,cmap_2460);
});})(cmap_2460))
;
/**
 * xml string representation of an edn map.
 *   (map->xlmstr constraint {:key1 val1 key2 val2}) => <constraint key1=val1 key2=val2 />
 */
imcljs.query.map__GT_xmlstr = (function imcljs$query$map__GT_xmlstr(elem,m){
var m__$1 = (function (){var G__2461 = m;
if(cljs.core.contains_QMARK_.call(null,m,new cljs.core.Keyword(null,"ids","ids",-998535796))){
return imcljs.query.ids__GT_constraint.call(null,G__2461);
} else {
return G__2461;
}
})();
var m__$2 = cljs.core.select_keys.call(null,m__$1,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"values","values",372645556),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"op","op",-1882987955),new cljs.core.Keyword(null,"code","code",1586293142),new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.Keyword(null,"editable","editable",1930280326),new cljs.core.Keyword(null,"switchable","switchable",-423573004)], null));
var values = new cljs.core.Keyword(null,"values","values",372645556).cljs$core$IFn$_invoke$arity$1(m__$2);
return ["\n   <",cljs.core.str.cljs$core$IFn$_invoke$arity$1(elem)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.reduce.call(null,((function (m__$1,m__$2,values){
return (function (total,p__2466){
var vec__2467 = p__2466;
var k = cljs.core.nth.call(null,vec__2467,(0),null);
var v = cljs.core.nth.call(null,vec__2467,(1),null);
if(cljs.core.not_EQ_.call(null,k,new cljs.core.Keyword(null,"values","values",372645556))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(total),(cljs.core.truth_(total)?" ":null),cljs.core.name.call(null,k),"=",["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(imcljs.query.escape_attribute.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(v))),"\""].join('')].join('');
} else {
return total;
}
});})(m__$1,m__$2,values))
,null,m__$2)),(cljs.core.truth_(values)?[">",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,imcljs.query.value,values))),"</",cljs.core.str.cljs$core$IFn$_invoke$arity$1(elem),">"].join(''):"/>")].join('');
});
imcljs.query.stringify_map = (function imcljs$query$stringify_map(m){
return cljs.core.reduce.call(null,(function (total,p__2470){
var vec__2471 = p__2470;
var k = cljs.core.nth.call(null,vec__2471,(0),null);
var v = cljs.core.nth.call(null,vec__2471,(1),null);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(total),(cljs.core.truth_(total)?" ":null),cljs.core.name.call(null,k),"=",["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(imcljs.query.escape_attribute.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(v))),"\""].join('')].join('');
}),null,m);
});
imcljs.query.enforce_origin = (function imcljs$query$enforce_origin(query){
if((new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query) == null)){
return cljs.core.assoc.call(null,query,new cljs.core.Keyword(null,"from","from",1815293044),cljs.core.first.call(null,clojure.string.split.call(null,cljs.core.first.call(null,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(query)),/\./)));
} else {
return query;
}
});
imcljs.query.enforce_views_have_class = (function imcljs$query$enforce_views_have_class(query){
return cljs.core.update.call(null,query,new cljs.core.Keyword(null,"select","select",1147833503),cljs.core.partial.call(null,cljs.core.mapv,(function (path){
var path__$1 = cljs.core.name.call(null,path);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query),cljs.core.first.call(null,clojure.string.split.call(null,path__$1,/\./)))){
return path__$1;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query)),".",path__$1].join('');
}
})));
});
imcljs.query.enforce_joins_have_class = (function imcljs$query$enforce_joins_have_class(query){
if(cljs.core.contains_QMARK_.call(null,query,new cljs.core.Keyword(null,"joins","joins",1033962699))){
return cljs.core.update.call(null,query,new cljs.core.Keyword(null,"joins","joins",1033962699),cljs.core.partial.call(null,cljs.core.mapv,(function (path){
var path__$1 = cljs.core.name.call(null,path);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query),cljs.core.first.call(null,clojure.string.split.call(null,path__$1,/\./)))){
return path__$1;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query)),".",path__$1].join('');
}
})));
} else {
return query;
}
});
imcljs.query.enforce_constraints_have_class = (function imcljs$query$enforce_constraints_have_class(query){
if(cljs.core.contains_QMARK_.call(null,query,new cljs.core.Keyword(null,"where","where",-2044795965))){
return cljs.core.update.call(null,query,new cljs.core.Keyword(null,"where","where",-2044795965),cljs.core.partial.call(null,cljs.core.mapv,(function (constraint){
var path = new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(constraint);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query),cljs.core.first.call(null,clojure.string.split.call(null,path,/\./)))){
return constraint;
} else {
return cljs.core.assoc.call(null,constraint,new cljs.core.Keyword(null,"path","path",-188191168),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query)),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(path)].join(''));
}
})));
} else {
return query;
}
});
imcljs.query.enforce_constraints_have_code = (function imcljs$query$enforce_constraints_have_code(query){
if(cljs.core.contains_QMARK_.call(null,query,new cljs.core.Keyword(null,"where","where",-2044795965))){
return cljs.core.update.call(null,query,new cljs.core.Keyword(null,"where","where",-2044795965),(function (constraints){
return cljs.core.reduce.call(null,(function (total,p__2474){
var map__2475 = p__2474;
var map__2475__$1 = (((((!((map__2475 == null))))?(((((map__2475.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2475.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2475):map__2475);
var constraint = map__2475__$1;
var code = cljs.core.get.call(null,map__2475__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var type = cljs.core.get.call(null,map__2475__$1,new cljs.core.Keyword(null,"type","type",1174270348));
if((((!((code == null)))) || ((!((type == null)))))){
return cljs.core.conj.call(null,total,constraint);
} else {
var existing_codes = cljs.core.set.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,cljs.core.concat.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"code","code",1586293142),constraints),cljs.core.map.call(null,new cljs.core.Keyword(null,"code","code",1586293142),total))));
var next_available_code = cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.complement.call(null,clojure.string.blank_QMARK_),clojure.set.difference.call(null,imcljs.internal.utils.alphabet,existing_codes)));
return cljs.core.conj.call(null,total,cljs.core.assoc.call(null,constraint,new cljs.core.Keyword(null,"code","code",1586293142),next_available_code));
}
}),cljs.core.PersistentVector.EMPTY,constraints);
}));
} else {
return query;
}
});
imcljs.query.enforce_constraints_loop_as_value = (function imcljs$query$enforce_constraints_loop_as_value(query){
if(cljs.core.contains_QMARK_.call(null,query,new cljs.core.Keyword(null,"where","where",-2044795965))){
return cljs.core.update.call(null,query,new cljs.core.Keyword(null,"where","where",-2044795965),cljs.core.partial.call(null,cljs.core.mapv,(function (p__2477){
var map__2478 = p__2477;
var map__2478__$1 = (((((!((map__2478 == null))))?(((((map__2478.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2478.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2478):map__2478);
var constraint = map__2478__$1;
var loopPath = cljs.core.get.call(null,map__2478__$1,new cljs.core.Keyword(null,"loopPath","loopPath",-1555334227));
var value = cljs.core.get.call(null,map__2478__$1,new cljs.core.Keyword(null,"value","value",305978217));
if((((!((loopPath == null)))) && ((value == null)))){
return cljs.core.dissoc.call(null,cljs.core.assoc.call(null,constraint,new cljs.core.Keyword(null,"value","value",305978217),((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query),cljs.core.first.call(null,clojure.string.split.call(null,loopPath,/\./))))?loopPath:[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query)),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(loopPath)].join(''))),new cljs.core.Keyword(null,"loopPath","loopPath",-1555334227));
} else {
return constraint;
}
})));
} else {
return query;
}
});
/**
 * IS NULL and IS NOT NULL constraints shouldn't have a value.
 */
imcljs.query.enforce_constraints_valueless = (function imcljs$query$enforce_constraints_valueless(query){
if(cljs.core.contains_QMARK_.call(null,query,new cljs.core.Keyword(null,"where","where",-2044795965))){
return cljs.core.update.call(null,query,new cljs.core.Keyword(null,"where","where",-2044795965),cljs.core.partial.call(null,cljs.core.mapv,(function (p__2480){
var map__2481 = p__2480;
var map__2481__$1 = (((((!((map__2481 == null))))?(((((map__2481.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2481.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2481):map__2481);
var constraint = map__2481__$1;
var op = cljs.core.get.call(null,map__2481__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["IS NULL",null,"IS NOT NULL",null], null), null),op)){
var G__2483 = constraint;
var G__2483__$1 = ((cljs.core.contains_QMARK_.call(null,constraint,new cljs.core.Keyword(null,"value","value",305978217)))?cljs.core.dissoc.call(null,G__2483,new cljs.core.Keyword(null,"value","value",305978217)):G__2483);
if(cljs.core.contains_QMARK_.call(null,constraint,new cljs.core.Keyword(null,"values","values",372645556))){
return cljs.core.dissoc.call(null,G__2483__$1,new cljs.core.Keyword(null,"values","values",372645556));
} else {
return G__2483__$1;
}
} else {
return constraint;
}
})));
} else {
return query;
}
});
/**
 * Makes sure the query XML will have a sortOrder attribute instead of orderBy.
 *   Only the former is supported as part of the PathQuery API.
 */
imcljs.query.enforce_sort_order = (function imcljs$query$enforce_sort_order(query){
if(((cljs.core.empty_QMARK_.call(null,new cljs.core.Keyword(null,"sortOrder","sortOrder",-931749514).cljs$core$IFn$_invoke$arity$1(query))) && (cljs.core.contains_QMARK_.call(null,query,new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793))))){
return clojure.set.rename_keys.call(null,query,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"orderBy","orderBy",-1329797793),new cljs.core.Keyword(null,"sortOrder","sortOrder",-931749514)], null));
} else {
return query;
}
});
imcljs.query.enforce_sorting = (function imcljs$query$enforce_sorting(query){
if(cljs.core.contains_QMARK_.call(null,query,new cljs.core.Keyword(null,"sortOrder","sortOrder",-931749514))){
return cljs.core.update.call(null,query,new cljs.core.Keyword(null,"sortOrder","sortOrder",-931749514),cljs.core.partial.call(null,cljs.core.mapv,(function (order){
var order__$1 = (((new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(order) == null))?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),cljs.core.name.call(null,cljs.core.first.call(null,cljs.core.first.call(null,cljs.core.seq.call(null,order)))),new cljs.core.Keyword(null,"direction","direction",-633359395),cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.seq.call(null,order)))], null):order);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query),cljs.core.first.call(null,clojure.string.split.call(null,new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(order__$1),/\./)))){
return order__$1;
} else {
return cljs.core.assoc.call(null,order__$1,new cljs.core.Keyword(null,"path","path",-188191168),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"from","from",1815293044).cljs$core$IFn$_invoke$arity$1(query)),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(order__$1))].join(''));
}
})));
} else {
return query;
}
});
imcljs.query.sterilize_query = cljs.core.comp.call(null,imcljs.query.enforce_sorting,imcljs.query.enforce_sort_order,imcljs.query.enforce_constraints_valueless,imcljs.query.enforce_constraints_loop_as_value,imcljs.query.enforce_constraints_have_class,imcljs.query.enforce_constraints_have_code,imcljs.query.enforce_joins_have_class,imcljs.query.enforce_views_have_class,imcljs.query.enforce_origin);
imcljs.query.make_join = (function imcljs$query$make_join(join_path){
return ["\n  <join path=\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(join_path),"\" style=\"OUTER\"/>"].join('');
});
/**
 * Returns the stringfied XML representation of an EDN intermine query.
 */
imcljs.query.__GT_xml = (function imcljs$query$__GT_xml(model,query){
var query__$1 = imcljs.query.sterilize_query.call(null,query);
var head_attributes = (function (){var G__2484 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"model","model",331153215),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(model),new cljs.core.Keyword(null,"view","view",1247994814),clojure.string.join.call(null," ",new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(query__$1))], null);
var G__2484__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"constraintLogic","constraintLogic",1960517918).cljs$core$IFn$_invoke$arity$1(query__$1))?cljs.core.assoc.call(null,G__2484,new cljs.core.Keyword(null,"constraintLogic","constraintLogic",1960517918),new cljs.core.Keyword(null,"constraintLogic","constraintLogic",1960517918).cljs$core$IFn$_invoke$arity$1(query__$1)):G__2484);
var G__2484__$2 = (cljs.core.truth_(new cljs.core.Keyword(null,"sortOrder","sortOrder",-931749514).cljs$core$IFn$_invoke$arity$1(query__$1))?cljs.core.assoc.call(null,G__2484__$1,new cljs.core.Keyword(null,"sortOrder","sortOrder",-931749514),clojure.string.join.call(null," ",cljs.core.flatten.call(null,cljs.core.map.call(null,cljs.core.juxt.call(null,new cljs.core.Keyword(null,"path","path",-188191168),new cljs.core.Keyword(null,"direction","direction",-633359395)),new cljs.core.Keyword(null,"sortOrder","sortOrder",-931749514).cljs$core$IFn$_invoke$arity$1(query__$1))))):G__2484__$1);
var G__2484__$3 = (cljs.core.truth_(new cljs.core.Keyword(null,"title","title",636505583).cljs$core$IFn$_invoke$arity$1(query__$1))?cljs.core.assoc.call(null,G__2484__$2,new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"title","title",636505583).cljs$core$IFn$_invoke$arity$1(query__$1)):G__2484__$2);
if(cljs.core.truth_(new cljs.core.Keyword(null,"longDescription","longDescription",-1558621957).cljs$core$IFn$_invoke$arity$1(query__$1))){
return cljs.core.assoc.call(null,G__2484__$3,new cljs.core.Keyword(null,"longDescription","longDescription",-1558621957),new cljs.core.Keyword(null,"longDescription","longDescription",-1558621957).cljs$core$IFn$_invoke$arity$1(query__$1));
} else {
return G__2484__$3;
}
})();
return ["<query ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(imcljs.query.stringify_map.call(null,head_attributes)),">",cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(new cljs.core.Keyword(null,"joins","joins",1033962699).cljs$core$IFn$_invoke$arity$1(query__$1))?cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,imcljs.query.make_join,new cljs.core.Keyword(null,"joins","joins",1033962699).cljs$core$IFn$_invoke$arity$1(query__$1))):null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.query.map__GT_xmlstr,"constraint"),new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(query__$1)))),"\n</query>"].join('');
});
/**
 * Deconstructs a query by its views and groups them by class.
 *   (deconstruct-by-class model query)
 *   {:Gene {Gene.homologues.homologue {:from Gene :select [Gene.homologues.homologue.id] :where [...]}
 *       {Gene {:from Gene :select [Gene.id] :where [...]}}}
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `imcljs.path/walk` for more information).
 */
imcljs.query.deconstruct_by_class = (function imcljs$query$deconstruct_by_class(model,query){
var query__$1 = imcljs.query.sterilize_query.call(null,query);
return cljs.core.reduce.call(null,((function (query__$1){
return (function (path_map,next_path){
return cljs.core.update.call(null,path_map,imcljs.path.class$.call(null,model,next_path),cljs.core.assoc,imcljs.path.trim_to_last_class.call(null,model,next_path),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),cljs.core.assoc.call(null,query__$1,new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(imcljs.path.trim_to_last_class.call(null,model,next_path)),".id"].join('')], null))], null));
});})(query__$1))
,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(query__$1));
});
/**
 * Group the views of a query by their Class and provide a query
 *   to retrieve just that column of data.
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `imcljs.path/walk` for more information).
 */
imcljs.query.group_views_by_class = (function imcljs$query$group_views_by_class(model,query){
var query__$1 = imcljs.query.sterilize_query.call(null,query);
return cljs.core.reduce.call(null,((function (query__$1){
return (function (path_map,next_path){
return cljs.core.update.call(null,path_map,imcljs.path.class$.call(null,model,next_path),cljs.core.comp.call(null,cljs.core.vec,cljs.core.set,cljs.core.conj),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(imcljs.path.trim_to_last_class.call(null,model,next_path)),".id"].join(''),new cljs.core.Keyword(null,"type","type",1174270348),imcljs.path.class$.call(null,model,next_path),new cljs.core.Keyword(null,"query","query",-1288509510),cljs.core.assoc.call(null,query__$1,new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(imcljs.path.trim_to_last_class.call(null,model,next_path)),".id"].join('')], null))], null));
});})(query__$1))
,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"select","select",1147833503).cljs$core$IFn$_invoke$arity$1(query__$1));
});

//# sourceMappingURL=query.js.map
