// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.path');
goog.require('cljs.core');
goog.require('imcljs.internal.utils');
goog.require('clojure.string');
/**
 * Split a string path into a vector of keywords.
 *   (split-path `Gene.organism.shortName`)
 *   => [:Gene :organism :shortName]
 */
imcljs.path.split_path = (function imcljs$path$split_path(path_str){
return cljs.core.mapv.call(null,cljs.core.keyword,clojure.string.split.call(null,path_str,/\./));
});
/**
 * Join a vector path of keywords to a string.
 *   (join-path [:Gene :organism :shortName])
 *   => Gene.organism.shortName
 */
imcljs.path.join_path = (function imcljs$path$join_path(path_str){
return clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.core.name,path_str));
});
/**
 * Given a model and a class, return its attributes, references and collections.
 */
imcljs.path.properties = (function imcljs$path$properties(model,class_kw){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_type = (function imcljs$path$referenced_type(model,field_kw,class_kw){
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw)));
});
/**
 * Given a model, a reference/collection, and a class,
 *   return the superclass of the reference/collection.
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.referenced_class = (function imcljs$path$referenced_class(model,field_kw,class_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_type,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__2402){
var vec__2403 = p__2402;
var _ = cljs.core.nth.call(null,vec__2403,(0),null);
var map__2406 = cljs.core.nth.call(null,vec__2403,(1),null);
var map__2406__$1 = (((((!((map__2406 == null))))?(((((map__2406.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2406.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2406):map__2406);
var extends$ = cljs.core.get.call(null,map__2406__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_values = (function imcljs$path$referenced_values(model,field_kw,class_kw){
return cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw);
});
/**
 * Given a model and a field, return that field from the data model.
 *   A field can be a reference, a collection, or an attribute
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.class_value = (function imcljs$path$class_value(model,class_kw,field_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_values,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__2408){
var vec__2409 = p__2408;
var _ = cljs.core.nth.call(null,vec__2409,(0),null);
var map__2412 = cljs.core.nth.call(null,vec__2409,(1),null);
var map__2412__$1 = (((((!((map__2412 == null))))?(((((map__2412.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2412.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2412):map__2412);
var extends$ = cljs.core.get.call(null,map__2412__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Returns the `prop` property of a model `class`. Lenient to nil arguments.
 */
imcljs.path.walk_get_property = (function imcljs$path$walk_get_property(class$,prop){
if(cljs.core.map_QMARK_.call(null,class$)){
var G__2414 = prop;
if((G__2414 == null)){
return null;
} else {
return cljs.core.get.call(null,cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,class$,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null))),G__2414);
}
} else {
return null;
}
});
/**
 * Returns the portion of `path` that has been consumed by `rem-path`.
 */
imcljs.path.walk_current_path = (function imcljs$path$walk_current_path(path,rem_path){
return cljs.core.subvec.call(null,path,(0),(cljs.core.count.call(null,path) - cljs.core.count.call(null,rem_path)));
});
imcljs.path.walk_loop = (function imcljs$path$walk_loop(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2421 = arguments.length;
var i__4731__auto___2422 = (0);
while(true){
if((i__4731__auto___2422 < len__4730__auto___2421)){
args__4736__auto__.push((arguments[i__4731__auto___2422]));

var G__2423 = (i__4731__auto___2422 + (1));
i__4731__auto___2422 = G__2423;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.path.walk_loop.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.path.walk_loop.cljs$core$IFn$_invoke$arity$variadic = (function (model,path,p__2418){
var map__2419 = p__2418;
var map__2419__$1 = (((((!((map__2419 == null))))?(((((map__2419.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2419.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2419):map__2419);
var path__GT_subclass = cljs.core.get.call(null,map__2419__$1,new cljs.core.Keyword(null,"path->subclass","path->subclass",-209144667));
var walk_properties_QMARK_ = cljs.core.get.call(null,map__2419__$1,new cljs.core.Keyword(null,"walk-properties?","walk-properties?",-1817786531));
var root_class = cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.first.call(null,path)], null));
var rem_path = cljs.core.next.call(null,cljs.core.next.call(null,path));
var property = imcljs.path.walk_get_property.call(null,root_class,cljs.core.second.call(null,path));
var walked = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [root_class], null);
while(true){
var next_class = (function (){var temp__5735__auto__ = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(property));
if(cljs.core.truth_(temp__5735__auto__)){
var reference = temp__5735__auto__;
var curr_path = imcljs.path.walk_current_path.call(null,path,rem_path);
var reference__$1 = cljs.core.get.call(null,path__GT_subclass,curr_path,reference);
return cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),reference__$1], null));
} else {
return null;
}
})();
var walked__$1 = cljs.core.conj.call(null,walked,(cljs.core.truth_(walk_properties_QMARK_)?property:(function (){var or__4131__auto__ = next_class;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return property;
}
})()));
if(cljs.core.empty_QMARK_.call(null,rem_path)){
return walked__$1;
} else {
if(cljs.core.empty_QMARK_.call(null,property)){
return null;
} else {
var G__2424 = cljs.core.next.call(null,rem_path);
var G__2425 = imcljs.path.walk_get_property.call(null,next_class,cljs.core.first.call(null,rem_path));
var G__2426 = walked__$1;
rem_path = G__2424;
property = G__2425;
walked = G__2426;
continue;

}
}
break;
}
});

imcljs.path.walk_loop.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.path.walk_loop.cljs$lang$applyTo = (function (seq2415){
var G__2416 = cljs.core.first.call(null,seq2415);
var seq2415__$1 = cljs.core.next.call(null,seq2415);
var G__2417 = cljs.core.first.call(null,seq2415__$1);
var seq2415__$2 = cljs.core.next.call(null,seq2415__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2416,G__2417,seq2415__$2);
});

/**
 * Return a vector representing each part of path.
 *   If any part of the path is unresolvable then a nil is returned.
 *   (walk im-model `Gene.organism.shortName`)
 *   => [{:name `Gene`, :collections {...}, :attributes {...}}
 *    {:name `Organism`, :collections {...} :attributes {...}
 *    {:name `shortName`, :type `java.lang.String`}]
 *   If the path traverses a subclass, you'll need to add a `:type-constraints`
 *   key to `model` with a value like
 *    [{:path `Gene.interactions.participant2`, :type `Gene`}]
 *   for the path to be resolvable.
 *    (walk im-model-with-type-constraints
 *     `Gene.interactions.participant2.proteinAtlasExpression.tissue.name`)
 *   Optional keyword arguments:
 *   walk-properties? - If true, each element will be the parent's property,
 *   instead of the referencedType.  The first element will still be a class as it
 *   has no parent.
 */
imcljs.path.walk = (function imcljs$path$walk(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2437 = arguments.length;
var i__4731__auto___2438 = (0);
while(true){
if((i__4731__auto___2438 < len__4730__auto___2437)){
args__4736__auto__.push((arguments[i__4731__auto___2438]));

var G__2439 = (i__4731__auto___2438 + (1));
i__4731__auto___2438 = G__2439;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$variadic = (function (model,path,p__2431){
var map__2432 = p__2431;
var map__2432__$1 = (((((!((map__2432 == null))))?(((((map__2432.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2432.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2432):map__2432);
var walk_properties_QMARK_ = cljs.core.get.call(null,map__2432__$1,new cljs.core.Keyword(null,"walk-properties?","walk-properties?",-1817786531));
var p = ((typeof path === 'string')?imcljs.path.split_path.call(null,path):cljs.core.mapv.call(null,cljs.core.keyword,path));
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,p))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.first.call(null,p)], null))], null);
} else {
return imcljs.path.walk_loop.call(null,model,p,new cljs.core.Keyword(null,"path->subclass","path->subclass",-209144667),cljs.core.reduce.call(null,((function (p,map__2432,map__2432__$1,walk_properties_QMARK_){
return (function (m,p__2434){
var map__2435 = p__2434;
var map__2435__$1 = (((((!((map__2435 == null))))?(((((map__2435.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2435.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2435):map__2435);
var path__$1 = cljs.core.get.call(null,map__2435__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var type = cljs.core.get.call(null,map__2435__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return cljs.core.assoc.call(null,m,imcljs.path.split_path.call(null,path__$1),cljs.core.keyword.call(null,type));
});})(p,map__2432,map__2432__$1,walk_properties_QMARK_))
,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,((function (p,map__2432,map__2432__$1,walk_properties_QMARK_){
return (function (p1__2427_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__2427_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
});})(p,map__2432,map__2432__$1,walk_properties_QMARK_))
,new cljs.core.Keyword(null,"type-constraints","type-constraints",957308697).cljs$core$IFn$_invoke$arity$1(model))),new cljs.core.Keyword(null,"walk-properties?","walk-properties?",-1817786531),walk_properties_QMARK_);
}
});

imcljs.path.walk.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.path.walk.cljs$lang$applyTo = (function (seq2428){
var G__2429 = cljs.core.first.call(null,seq2428);
var seq2428__$1 = cljs.core.next.call(null,seq2428);
var G__2430 = cljs.core.first.call(null,seq2428__$1);
var seq2428__$2 = cljs.core.next.call(null,seq2428__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2429,G__2430,seq2428__$2);
});

/**
 * Return the java type of a path representing an attribute.
 *   (attribute-type im-model `Gene.organism.shortName`)
 *   => java.lang.String
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.data_type = (function imcljs$path$data_type(model,path){
return new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,imcljs.path.walk.call(null,model,path)));
});
/**
 * Returns the class represented by the path.
 *   (class im-model `Gene.homologues.homologue.symbol`)
 *   => :Gene
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.class$ = (function imcljs$path$class(model,path){
var l = cljs.core.last.call(null,cljs.core.take_while.call(null,(function (p1__2440_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__2440_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path)));
return cljs.core.keyword.call(null,(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(l);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(l));
}
})());
});
/**
 * Returns all relationships (references and collections) for a given string path.
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.relationships = (function imcljs$path$relationships(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
imcljs.path.mapify = (function imcljs$path$mapify(coll){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,coll);
});
imcljs.path.un_camel_case = (function imcljs$path$un_camel_case(s){
var G__2442 = s;
var G__2442__$1 = (((G__2442 == null))?null:clojure.string.replace.call(null,G__2442,/([a-z])([A-Z])/,"$1 $2"));
var G__2442__$2 = (((G__2442__$1 == null))?null:clojure.string.replace.call(null,G__2442__$1,/([A-Z])([a-z])/," $1$2"));
var G__2442__$3 = (((G__2442__$2 == null))?null:clojure.string.replace.call(null,G__2442__$2,/\ +/," "));
if((G__2442__$3 == null)){
return null;
} else {
return clojure.string.replace.call(null,G__2442__$3,/^./,((function (G__2442,G__2442__$1,G__2442__$2,G__2442__$3){
return (function (p1__2441_SHARP_){
return clojure.string.upper_case.call(null,p1__2441_SHARP_);
});})(G__2442,G__2442__$1,G__2442__$2,G__2442__$3))
);
}
});
/**
 * Returns a vector of friendly names representing the path.
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.display_name = (function imcljs$path$display_name(model,path){
return cljs.core.mapv.call(null,(function (prop){
var or__4131__auto__ = new cljs.core.Keyword(null,"displayName","displayName",-809144601).cljs$core$IFn$_invoke$arity$1(prop);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return imcljs.path.un_camel_case.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(prop));
}
}),imcljs.path.walk.call(null,model,path,new cljs.core.Keyword(null,"walk-properties?","walk-properties?",-1817786531),true));
});
/**
 * Returns all attributes for a given string path.
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.attributes = (function imcljs$path$attributes(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604)], null)));
});
/**
 * Returns true if path is a class.
 *   (class im-model `Gene.diseases`)
 *   => true
 *   (class im-model `Gene.diseases.name`)
 *   => false
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.class_QMARK_ = (function imcljs$path$class_QMARK_(model,path){
var walked = imcljs.path.walk.call(null,model,path);
return (!(cljs.core.contains_QMARK_.call(null,cljs.core.last.call(null,walked),new cljs.core.Keyword(null,"type","type",1174270348))));
});
/**
 * Returns a path string trimmed to the last class
 *   (trim-to-last-class im-model `Gene.homologues.homologue.symbol`)
 *   => Gene.homologues.homologue
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.trim_to_last_class = (function imcljs$path$trim_to_last_class(model,path){
var done = cljs.core.take_while.call(null,(function (p1__2443_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__2443_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path));
return imcljs.path.join_path.call(null,cljs.core.take.call(null,cljs.core.count.call(null,done),imcljs.path.split_path.call(null,path)));
});
/**
 * Returns a path adjusted to its last class
 *   (adjust-path-to-last-class im-model `Gene.organism.name`)
 *   => Organism.name
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.adjust_path_to_last_class = (function imcljs$path$adjust_path_to_last_class(model,path){
var attribute_QMARK_ = (!(imcljs.path.class_QMARK_.call(null,model,path)));
var walked = cljs.core.reverse.call(null,imcljs.path.walk.call(null,model,path));
if(attribute_QMARK_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(1)))),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(0))))].join('');
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(0))));
}
});
/**
 * Returns a path as a strong
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.friendly = (function imcljs$path$friendly(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2451 = arguments.length;
var i__4731__auto___2452 = (0);
while(true){
if((i__4731__auto___2452 < len__4730__auto___2451)){
args__4736__auto__.push((arguments[i__4731__auto___2452]));

var G__2453 = (i__4731__auto___2452 + (1));
i__4731__auto___2452 = G__2453;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic = (function (model,path,p__2447){
var vec__2448 = p__2447;
var exclude_root_QMARK_ = cljs.core.nth.call(null,vec__2448,(0),null);
return cljs.core.reduce.call(null,((function (vec__2448,exclude_root_QMARK_){
return (function (total,next){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(total),(cljs.core.truth_(total)?" > ":null),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"displayName","displayName",-809144601).cljs$core$IFn$_invoke$arity$1(next);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(next);
}
})())].join('');
});})(vec__2448,exclude_root_QMARK_))
,null,(cljs.core.truth_(exclude_root_QMARK_)?cljs.core.rest.call(null,imcljs.path.walk.call(null,model,path)):imcljs.path.walk.call(null,model,path)));
});

imcljs.path.friendly.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.path.friendly.cljs$lang$applyTo = (function (seq2444){
var G__2445 = cljs.core.first.call(null,seq2444);
var seq2444__$1 = cljs.core.next.call(null,seq2444);
var G__2446 = cljs.core.first.call(null,seq2444__$1);
var seq2444__$2 = cljs.core.next.call(null,seq2444__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2445,G__2446,seq2444__$2);
});

imcljs.path.one_of_QMARK_ = (function imcljs$path$one_of_QMARK_(col,value){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([value]),col) == null)));
});
/**
 * Returns direct subclasses of the class.
 *   Tip: To get descendant subclasses, you will need to create a graph out of all
 *   the classes' extends key, which is costly and outside the scope of imcljs.
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.subclasses = (function imcljs$path$subclasses(model,path){
var path_class = imcljs.path.class$.call(null,model,path);
return cljs.core.not_empty.call(null,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,((function (path_class){
return (function (p__2454){
var vec__2455 = p__2454;
var _ = cljs.core.nth.call(null,vec__2455,(0),null);
var properties = cljs.core.nth.call(null,vec__2455,(1),null);
return imcljs.path.one_of_QMARK_.call(null,new cljs.core.Keyword(null,"extends","extends",-954903259).cljs$core$IFn$_invoke$arity$1(properties),cljs.core.name.call(null,path_class));
});})(path_class))
,new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model))));
});

//# sourceMappingURL=path.js.map
