// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.path');
goog.require('cljs.core');
goog.require('imcljs.internal.utils');
goog.require('clojure.string');
/**
 * Split a string path into a vector of keywords.
 *   (split-path `Gene.organism.shortName`)
 *   => [:Gene :organism :shortName]
 */
imcljs.path.split_path = (function imcljs$path$split_path(path_str){
return cljs.core.map.call(null,cljs.core.keyword,clojure.string.split.call(null,path_str,/\./));
});
/**
 * Join a vector path of keywords to a string.
 *   (join-path [:Gene :organism :shortName])
 *   => Gene.organism.shortName
 */
imcljs.path.join_path = (function imcljs$path$join_path(path_str){
return clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.core.name,path_str));
});
/**
 * Given a model and a class, return its attributes, references and collections.
 */
imcljs.path.properties = (function imcljs$path$properties(model,class_kw){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_type = (function imcljs$path$referenced_type(model,field_kw,class_kw){
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw)));
});
/**
 * Given a model, a reference/collection, and a class,
 *   return the superclass of the reference/collection.
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.referenced_class = (function imcljs$path$referenced_class(model,field_kw,class_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_type,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__7726){
var vec__7727 = p__7726;
var _ = cljs.core.nth.call(null,vec__7727,(0),null);
var map__7730 = cljs.core.nth.call(null,vec__7727,(1),null);
var map__7730__$1 = (((((!((map__7730 == null))))?(((((map__7730.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7730.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7730):map__7730);
var extends$ = cljs.core.get.call(null,map__7730__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_values = (function imcljs$path$referenced_values(model,field_kw,class_kw){
return cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw);
});
/**
 * Given a model and a field, return that field from the data model.
 *   A field can be a reference, a collection, or an attribute
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.class_value = (function imcljs$path$class_value(model,class_kw,field_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_values,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__7732){
var vec__7733 = p__7732;
var _ = cljs.core.nth.call(null,vec__7733,(0),null);
var map__7736 = cljs.core.nth.call(null,vec__7733,(1),null);
var map__7736__$1 = (((((!((map__7736 == null))))?(((((map__7736.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7736.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7736):map__7736);
var extends$ = cljs.core.get.call(null,map__7736__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
imcljs.path.walk_rec = (function imcljs$path$walk_rec(model,p__7738,trail,curr_path,path__GT_subclass){
while(true){
var vec__7739 = p__7738;
var seq__7740 = cljs.core.seq.call(null,vec__7739);
var first__7741 = cljs.core.first.call(null,seq__7740);
var seq__7740__$1 = cljs.core.next.call(null,seq__7740);
var class_kw = first__7741;
var vec__7742 = seq__7740__$1;
var seq__7743 = cljs.core.seq.call(null,vec__7742);
var first__7744 = cljs.core.first.call(null,seq__7743);
var seq__7743__$1 = cljs.core.next.call(null,seq__7743);
var path = first__7744;
var remaining = seq__7743__$1;
var class_kw__$1 = cljs.core.get.call(null,path__GT_subclass,curr_path,class_kw);
var cv = imcljs.path.class_value.call(null,model,class_kw__$1,path);
var reference = new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cv);
if(remaining){
if(cljs.core.truth_(reference)){
var G__7745 = model;
var G__7746 = cljs.core.cons.call(null,cljs.core.keyword.call(null,reference),remaining);
var G__7747 = cljs.core.conj.call(null,trail,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw__$1], null)));
var G__7748 = cljs.core.conj.call(null,curr_path,path);
var G__7749 = path__GT_subclass;
model = G__7745;
p__7738 = G__7746;
trail = G__7747;
curr_path = G__7748;
path__GT_subclass = G__7749;
continue;
} else {
return null;
}
} else {
return cljs.core.conj.call(null,trail,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw__$1], null)),(cljs.core.truth_(reference)?cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.keyword.call(null,reference)], null)):cv));
}
break;
}
});
/**
 * Return a vector representing each part of path.
 *   If any part of the path is unresolvable then a nil is returned.
 *   (walk im-model `Gene.organism.shortName`)
 *   => [{:name `Gene`, :collections {...}, :attributes {...}}
 *    {:name `Organism`, :collections {...} :attributes {...}
 *    {:name `shortName`, :type `java.lang.String`}]
 *   If the path traverses a subclass, you'll need to add a `:type-constraints`
 *   key to `model` with a value like
 *    [{:path `Gene.interactions.participant2`, :type `Gene`}]
 *   for the path to be resolvable.
 *    (walk im-model-with-type-constraints
 *     `Gene.interactions.participant2.proteinAtlasExpression.tissue.name`)
 */
imcljs.path.walk = (function imcljs$path$walk(model,path){
var p = ((typeof path === 'string')?imcljs.path.split_path.call(null,path):cljs.core.map.call(null,cljs.core.keyword,path));
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,p))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.first.call(null,p)], null))], null);
} else {
return imcljs.path.walk_rec.call(null,model,p,cljs.core.PersistentVector.EMPTY,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,p)], null),cljs.core.reduce.call(null,((function (p){
return (function (m,p__7751){
var map__7752 = p__7751;
var map__7752__$1 = (((((!((map__7752 == null))))?(((((map__7752.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__7752.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__7752):map__7752);
var path__$1 = cljs.core.get.call(null,map__7752__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var type = cljs.core.get.call(null,map__7752__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return cljs.core.assoc.call(null,m,imcljs.path.split_path.call(null,path__$1),cljs.core.keyword.call(null,type));
});})(p))
,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,((function (p){
return (function (p1__7750_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__7750_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
});})(p))
,new cljs.core.Keyword(null,"type-constraints","type-constraints",957308697).cljs$core$IFn$_invoke$arity$1(model))));
}
});
/**
 * Return the java type of a path representing an attribute.
 *   (attribute-type im-model `Gene.organism.shortName`)
 *   => java.lang.String
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.data_type = (function imcljs$path$data_type(model,path){
return new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,imcljs.path.walk.call(null,model,path)));
});
/**
 * Returns the class represented by the path.
 *   (class im-model `Gene.homologues.homologue.symbol`)
 *   => :Gene
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.class$ = (function imcljs$path$class(model,path){
var l = cljs.core.last.call(null,cljs.core.take_while.call(null,(function (p1__7754_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__7754_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path)));
return cljs.core.keyword.call(null,(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(l);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(l));
}
})());
});
/**
 * Returns all relationships (references and collections) for a given string path.
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.relationships = (function imcljs$path$relationships(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
imcljs.path.mapify = (function imcljs$path$mapify(coll){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,coll);
});
imcljs.path.un_camel_case = (function imcljs$path$un_camel_case(s){
var G__7756 = s;
var G__7756__$1 = (((G__7756 == null))?null:clojure.string.replace.call(null,G__7756,/([a-z])([A-Z])/,"$1 $2"));
var G__7756__$2 = (((G__7756__$1 == null))?null:clojure.string.replace.call(null,G__7756__$1,/([A-Z])([a-z])/," $1$2"));
var G__7756__$3 = (((G__7756__$2 == null))?null:clojure.string.replace.call(null,G__7756__$2,/\ +/," "));
if((G__7756__$3 == null)){
return null;
} else {
return clojure.string.replace.call(null,G__7756__$3,/^./,((function (G__7756,G__7756__$1,G__7756__$2,G__7756__$3){
return (function (p1__7755_SHARP_){
return clojure.string.upper_case.call(null,p1__7755_SHARP_);
});})(G__7756,G__7756__$1,G__7756__$2,G__7756__$3))
);
}
});
/**
 * Returns a vector of friendly names representing the path.
 *   ; TODO make this work with subclasses
 */
imcljs.path.display_name = (function imcljs$path$display_name(var_args){
var G__7758 = arguments.length;
switch (G__7758) {
case 2:
return imcljs.path.display_name.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return imcljs.path.display_name.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

imcljs.path.display_name.cljs$core$IFn$_invoke$arity$2 = (function (model,path){
var p = ((typeof path === 'string')?imcljs.path.split_path.call(null,path):path);
return imcljs.path.display_name.call(null,model,p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.first.call(null,p),new cljs.core.Keyword(null,"displayName","displayName",-809144601)], null))], null));
});

imcljs.path.display_name.cljs$core$IFn$_invoke$arity$3 = (function (model,p__7759,collected){
while(true){
var vec__7760 = p__7759;
var seq__7761 = cljs.core.seq.call(null,vec__7760);
var first__7762 = cljs.core.first.call(null,seq__7761);
var seq__7761__$1 = cljs.core.next.call(null,seq__7761);
var head = first__7762;
var first__7762__$1 = cljs.core.first.call(null,seq__7761__$1);
var seq__7761__$2 = cljs.core.next.call(null,seq__7761__$1);
var next = first__7762__$1;
var tail = seq__7761__$2;
if(cljs.core.truth_(next)){
var props = imcljs.path.mapify.call(null,cljs.core.vals.call(null,cljs.core.select_keys.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),head], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null))));
var collected_PLUS_ = cljs.core.conj.call(null,collected,(function (){var or__4131__auto__ = cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [next,new cljs.core.Keyword(null,"displayName","displayName",-809144601)], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return imcljs.path.un_camel_case.call(null,cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [next,new cljs.core.Keyword(null,"name","name",1843675177)], null)));
}
})());
if(cljs.core.truth_(cljs.core.not_empty.call(null,tail))){
var G__7764 = model;
var G__7765 = cljs.core.conj.call(null,tail,cljs.core.keyword.call(null,cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [next,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030)], null))));
var G__7766 = collected_PLUS_;
model = G__7764;
p__7759 = G__7765;
collected = G__7766;
continue;
} else {
return collected_PLUS_;
}
} else {
return null;
}
break;
}
});

imcljs.path.display_name.cljs$lang$maxFixedArity = 3;

/**
 * Returns all attributes for a given string path.
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.attributes = (function imcljs$path$attributes(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604)], null)));
});
/**
 * Returns true if path is a class.
 *   (class im-model `Gene.diseases`)
 *   => true
 *   (class im-model `Gene.diseases.name`)
 *   => false
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.class_QMARK_ = (function imcljs$path$class_QMARK_(model,path){
var walked = imcljs.path.walk.call(null,model,path);
return (!(cljs.core.contains_QMARK_.call(null,cljs.core.last.call(null,walked),new cljs.core.Keyword(null,"type","type",1174270348))));
});
/**
 * Returns a path string trimmed to the last class
 *   (trim-to-last-class im-model `Gene.homologues.homologue.symbol`)
 *   => Gene.homologues.homologue
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.trim_to_last_class = (function imcljs$path$trim_to_last_class(model,path){
var done = cljs.core.take_while.call(null,(function (p1__7767_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__7767_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path));
return imcljs.path.join_path.call(null,cljs.core.take.call(null,cljs.core.count.call(null,done),imcljs.path.split_path.call(null,path)));
});
/**
 * Returns a path adjusted to its last class
 *   (adjust-path-to-last-class im-model `Gene.organism.name`)
 *   => Organism.name
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.adjust_path_to_last_class = (function imcljs$path$adjust_path_to_last_class(model,path){
var attribute_QMARK_ = (!(imcljs.path.class_QMARK_.call(null,model,path)));
var walked = cljs.core.reverse.call(null,imcljs.path.walk.call(null,model,path));
if(attribute_QMARK_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(1)))),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(0))))].join('');
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(0))));
}
});
/**
 * Returns a path as a strong
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.friendly = (function imcljs$path$friendly(var_args){
var args__4736__auto__ = [];
var len__4730__auto___7775 = arguments.length;
var i__4731__auto___7776 = (0);
while(true){
if((i__4731__auto___7776 < len__4730__auto___7775)){
args__4736__auto__.push((arguments[i__4731__auto___7776]));

var G__7777 = (i__4731__auto___7776 + (1));
i__4731__auto___7776 = G__7777;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic = (function (model,path,p__7771){
var vec__7772 = p__7771;
var exclude_root_QMARK_ = cljs.core.nth.call(null,vec__7772,(0),null);
return cljs.core.reduce.call(null,((function (vec__7772,exclude_root_QMARK_){
return (function (total,next){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(total),(cljs.core.truth_(total)?" > ":null),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"displayName","displayName",-809144601).cljs$core$IFn$_invoke$arity$1(next);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(next);
}
})())].join('');
});})(vec__7772,exclude_root_QMARK_))
,null,(cljs.core.truth_(exclude_root_QMARK_)?cljs.core.rest.call(null,imcljs.path.walk.call(null,model,path)):imcljs.path.walk.call(null,model,path)));
});

imcljs.path.friendly.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.path.friendly.cljs$lang$applyTo = (function (seq7768){
var G__7769 = cljs.core.first.call(null,seq7768);
var seq7768__$1 = cljs.core.next.call(null,seq7768);
var G__7770 = cljs.core.first.call(null,seq7768__$1);
var seq7768__$2 = cljs.core.next.call(null,seq7768__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__7769,G__7770,seq7768__$2);
});

imcljs.path.one_of_QMARK_ = (function imcljs$path$one_of_QMARK_(col,value){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([value]),col) == null)));
});
/**
 * Returns direct subclasses of the class.
 *   Tip: To get descendant subclasses, you will need to create a graph out of all
 *   the classes' extends key, which is costly and outside the scope of imcljs.
 *   Make sure to add :type-constraints to the model if the path traverses a subclass
 *   (see docstring of `walk` for more information).
 */
imcljs.path.subclasses = (function imcljs$path$subclasses(model,path){
var path_class = imcljs.path.class$.call(null,model,path);
return cljs.core.not_empty.call(null,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,((function (path_class){
return (function (p__7778){
var vec__7779 = p__7778;
var _ = cljs.core.nth.call(null,vec__7779,(0),null);
var properties = cljs.core.nth.call(null,vec__7779,(1),null);
return imcljs.path.one_of_QMARK_.call(null,new cljs.core.Keyword(null,"extends","extends",-954903259).cljs$core$IFn$_invoke$arity$1(properties),cljs.core.name.call(null,path_class));
});})(path_class))
,new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model))));
});

//# sourceMappingURL=path.js.map
