// Compiled by ClojureScript 1.10.520 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__4869 = arguments.length;
switch (G__4869) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4870 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4870 = (function (f,blockable,meta4871){
this.f = f;
this.blockable = blockable;
this.meta4871 = meta4871;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async4870.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4872,meta4871__$1){
var self__ = this;
var _4872__$1 = this;
return (new cljs.core.async.t_cljs$core$async4870(self__.f,self__.blockable,meta4871__$1));
});

cljs.core.async.t_cljs$core$async4870.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4872){
var self__ = this;
var _4872__$1 = this;
return self__.meta4871;
});

cljs.core.async.t_cljs$core$async4870.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4870.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async4870.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async4870.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async4870.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta4871","meta4871",-223351100,null)], null);
});

cljs.core.async.t_cljs$core$async4870.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async4870.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4870";

cljs.core.async.t_cljs$core$async4870.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async4870");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4870.
 */
cljs.core.async.__GT_t_cljs$core$async4870 = (function cljs$core$async$__GT_t_cljs$core$async4870(f__$1,blockable__$1,meta4871){
return (new cljs.core.async.t_cljs$core$async4870(f__$1,blockable__$1,meta4871));
});

}

return (new cljs.core.async.t_cljs$core$async4870(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__4876 = arguments.length;
switch (G__4876) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__4879 = arguments.length;
switch (G__4879) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__4882 = arguments.length;
switch (G__4882) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_4884 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_4884);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_4884,ret){
return (function (){
return fn1.call(null,val_4884);
});})(val_4884,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__4886 = arguments.length;
switch (G__4886) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5733__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5733__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___4888 = n;
var x_4889 = (0);
while(true){
if((x_4889 < n__4607__auto___4888)){
(a[x_4889] = x_4889);

var G__4890 = (x_4889 + (1));
x_4889 = G__4890;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4891 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4891 = (function (flag,meta4892){
this.flag = flag;
this.meta4892 = meta4892;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async4891.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_4893,meta4892__$1){
var self__ = this;
var _4893__$1 = this;
return (new cljs.core.async.t_cljs$core$async4891(self__.flag,meta4892__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async4891.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_4893){
var self__ = this;
var _4893__$1 = this;
return self__.meta4892;
});})(flag))
;

cljs.core.async.t_cljs$core$async4891.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4891.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async4891.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async4891.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async4891.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta4892","meta4892",1059139738,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async4891.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async4891.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4891";

cljs.core.async.t_cljs$core$async4891.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async4891");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4891.
 */
cljs.core.async.__GT_t_cljs$core$async4891 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async4891(flag__$1,meta4892){
return (new cljs.core.async.t_cljs$core$async4891(flag__$1,meta4892));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async4891(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async4894 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async4894 = (function (flag,cb,meta4895){
this.flag = flag;
this.cb = cb;
this.meta4895 = meta4895;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async4894.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_4896,meta4895__$1){
var self__ = this;
var _4896__$1 = this;
return (new cljs.core.async.t_cljs$core$async4894(self__.flag,self__.cb,meta4895__$1));
});

cljs.core.async.t_cljs$core$async4894.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_4896){
var self__ = this;
var _4896__$1 = this;
return self__.meta4895;
});

cljs.core.async.t_cljs$core$async4894.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async4894.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async4894.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async4894.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async4894.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta4895","meta4895",1966905652,null)], null);
});

cljs.core.async.t_cljs$core$async4894.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async4894.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async4894";

cljs.core.async.t_cljs$core$async4894.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async4894");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async4894.
 */
cljs.core.async.__GT_t_cljs$core$async4894 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async4894(flag__$1,cb__$1,meta4895){
return (new cljs.core.async.t_cljs$core$async4894(flag__$1,cb__$1,meta4895));
});

}

return (new cljs.core.async.t_cljs$core$async4894(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__4897_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__4897_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__4898_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__4898_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__4899 = (i + (1));
i = G__4899;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___4905 = arguments.length;
var i__4731__auto___4906 = (0);
while(true){
if((i__4731__auto___4906 < len__4730__auto___4905)){
args__4736__auto__.push((arguments[i__4731__auto___4906]));

var G__4907 = (i__4731__auto___4906 + (1));
i__4731__auto___4906 = G__4907;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__4902){
var map__4903 = p__4902;
var map__4903__$1 = (((((!((map__4903 == null))))?(((((map__4903.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__4903.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__4903):map__4903);
var opts = map__4903__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq4900){
var G__4901 = cljs.core.first.call(null,seq4900);
var seq4900__$1 = cljs.core.next.call(null,seq4900);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__4901,seq4900__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__4909 = arguments.length;
switch (G__4909) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__4809__auto___4955 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___4955){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___4955){
return (function (state_4933){
var state_val_4934 = (state_4933[(1)]);
if((state_val_4934 === (7))){
var inst_4929 = (state_4933[(2)]);
var state_4933__$1 = state_4933;
var statearr_4935_4956 = state_4933__$1;
(statearr_4935_4956[(2)] = inst_4929);

(statearr_4935_4956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4934 === (1))){
var state_4933__$1 = state_4933;
var statearr_4936_4957 = state_4933__$1;
(statearr_4936_4957[(2)] = null);

(statearr_4936_4957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4934 === (4))){
var inst_4912 = (state_4933[(7)]);
var inst_4912__$1 = (state_4933[(2)]);
var inst_4913 = (inst_4912__$1 == null);
var state_4933__$1 = (function (){var statearr_4937 = state_4933;
(statearr_4937[(7)] = inst_4912__$1);

return statearr_4937;
})();
if(cljs.core.truth_(inst_4913)){
var statearr_4938_4958 = state_4933__$1;
(statearr_4938_4958[(1)] = (5));

} else {
var statearr_4939_4959 = state_4933__$1;
(statearr_4939_4959[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4934 === (13))){
var state_4933__$1 = state_4933;
var statearr_4940_4960 = state_4933__$1;
(statearr_4940_4960[(2)] = null);

(statearr_4940_4960[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4934 === (6))){
var inst_4912 = (state_4933[(7)]);
var state_4933__$1 = state_4933;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4933__$1,(11),to,inst_4912);
} else {
if((state_val_4934 === (3))){
var inst_4931 = (state_4933[(2)]);
var state_4933__$1 = state_4933;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4933__$1,inst_4931);
} else {
if((state_val_4934 === (12))){
var state_4933__$1 = state_4933;
var statearr_4941_4961 = state_4933__$1;
(statearr_4941_4961[(2)] = null);

(statearr_4941_4961[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4934 === (2))){
var state_4933__$1 = state_4933;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4933__$1,(4),from);
} else {
if((state_val_4934 === (11))){
var inst_4922 = (state_4933[(2)]);
var state_4933__$1 = state_4933;
if(cljs.core.truth_(inst_4922)){
var statearr_4942_4962 = state_4933__$1;
(statearr_4942_4962[(1)] = (12));

} else {
var statearr_4943_4963 = state_4933__$1;
(statearr_4943_4963[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4934 === (9))){
var state_4933__$1 = state_4933;
var statearr_4944_4964 = state_4933__$1;
(statearr_4944_4964[(2)] = null);

(statearr_4944_4964[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4934 === (5))){
var state_4933__$1 = state_4933;
if(cljs.core.truth_(close_QMARK_)){
var statearr_4945_4965 = state_4933__$1;
(statearr_4945_4965[(1)] = (8));

} else {
var statearr_4946_4966 = state_4933__$1;
(statearr_4946_4966[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4934 === (14))){
var inst_4927 = (state_4933[(2)]);
var state_4933__$1 = state_4933;
var statearr_4947_4967 = state_4933__$1;
(statearr_4947_4967[(2)] = inst_4927);

(statearr_4947_4967[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4934 === (10))){
var inst_4919 = (state_4933[(2)]);
var state_4933__$1 = state_4933;
var statearr_4948_4968 = state_4933__$1;
(statearr_4948_4968[(2)] = inst_4919);

(statearr_4948_4968[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4934 === (8))){
var inst_4916 = cljs.core.async.close_BANG_.call(null,to);
var state_4933__$1 = state_4933;
var statearr_4949_4969 = state_4933__$1;
(statearr_4949_4969[(2)] = inst_4916);

(statearr_4949_4969[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___4955))
;
return ((function (switch__4714__auto__,c__4809__auto___4955){
return (function() {
var cljs$core$async$state_machine__4715__auto__ = null;
var cljs$core$async$state_machine__4715__auto____0 = (function (){
var statearr_4950 = [null,null,null,null,null,null,null,null];
(statearr_4950[(0)] = cljs$core$async$state_machine__4715__auto__);

(statearr_4950[(1)] = (1));

return statearr_4950;
});
var cljs$core$async$state_machine__4715__auto____1 = (function (state_4933){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_4933);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e4951){if((e4951 instanceof Object)){
var ex__4718__auto__ = e4951;
var statearr_4952_4970 = state_4933;
(statearr_4952_4970[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4933);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4951;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4971 = state_4933;
state_4933 = G__4971;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$state_machine__4715__auto__ = function(state_4933){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__4715__auto____1.call(this,state_4933);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__4715__auto____0;
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__4715__auto____1;
return cljs$core$async$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___4955))
})();
var state__4811__auto__ = (function (){var statearr_4953 = f__4810__auto__.call(null);
(statearr_4953[(6)] = c__4809__auto___4955);

return statearr_4953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___4955))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__4972){
var vec__4973 = p__4972;
var v = cljs.core.nth.call(null,vec__4973,(0),null);
var p = cljs.core.nth.call(null,vec__4973,(1),null);
var job = vec__4973;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__4809__auto___5144 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___5144,res,vec__4973,v,p,job,jobs,results){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___5144,res,vec__4973,v,p,job,jobs,results){
return (function (state_4980){
var state_val_4981 = (state_4980[(1)]);
if((state_val_4981 === (1))){
var state_4980__$1 = state_4980;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4980__$1,(2),res,v);
} else {
if((state_val_4981 === (2))){
var inst_4977 = (state_4980[(2)]);
var inst_4978 = cljs.core.async.close_BANG_.call(null,res);
var state_4980__$1 = (function (){var statearr_4982 = state_4980;
(statearr_4982[(7)] = inst_4977);

return statearr_4982;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4980__$1,inst_4978);
} else {
return null;
}
}
});})(c__4809__auto___5144,res,vec__4973,v,p,job,jobs,results))
;
return ((function (switch__4714__auto__,c__4809__auto___5144,res,vec__4973,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0 = (function (){
var statearr_4983 = [null,null,null,null,null,null,null,null];
(statearr_4983[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__);

(statearr_4983[(1)] = (1));

return statearr_4983;
});
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1 = (function (state_4980){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_4980);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e4984){if((e4984 instanceof Object)){
var ex__4718__auto__ = e4984;
var statearr_4985_5145 = state_4980;
(statearr_4985_5145[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4980);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4984;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5146 = state_4980;
state_4980 = G__5146;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__ = function(state_4980){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1.call(this,state_4980);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___5144,res,vec__4973,v,p,job,jobs,results))
})();
var state__4811__auto__ = (function (){var statearr_4986 = f__4810__auto__.call(null);
(statearr_4986[(6)] = c__4809__auto___5144);

return statearr_4986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___5144,res,vec__4973,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__4987){
var vec__4988 = p__4987;
var v = cljs.core.nth.call(null,vec__4988,(0),null);
var p = cljs.core.nth.call(null,vec__4988,(1),null);
var job = vec__4988;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___5147 = n;
var __5148 = (0);
while(true){
if((__5148 < n__4607__auto___5147)){
var G__4991_5149 = type;
var G__4991_5150__$1 = (((G__4991_5149 instanceof cljs.core.Keyword))?G__4991_5149.fqn:null);
switch (G__4991_5150__$1) {
case "compute":
var c__4809__auto___5152 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__5148,c__4809__auto___5152,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (__5148,c__4809__auto___5152,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async){
return (function (state_5004){
var state_val_5005 = (state_5004[(1)]);
if((state_val_5005 === (1))){
var state_5004__$1 = state_5004;
var statearr_5006_5153 = state_5004__$1;
(statearr_5006_5153[(2)] = null);

(statearr_5006_5153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5005 === (2))){
var state_5004__$1 = state_5004;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5004__$1,(4),jobs);
} else {
if((state_val_5005 === (3))){
var inst_5002 = (state_5004[(2)]);
var state_5004__$1 = state_5004;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5004__$1,inst_5002);
} else {
if((state_val_5005 === (4))){
var inst_4994 = (state_5004[(2)]);
var inst_4995 = process.call(null,inst_4994);
var state_5004__$1 = state_5004;
if(cljs.core.truth_(inst_4995)){
var statearr_5007_5154 = state_5004__$1;
(statearr_5007_5154[(1)] = (5));

} else {
var statearr_5008_5155 = state_5004__$1;
(statearr_5008_5155[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5005 === (5))){
var state_5004__$1 = state_5004;
var statearr_5009_5156 = state_5004__$1;
(statearr_5009_5156[(2)] = null);

(statearr_5009_5156[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5005 === (6))){
var state_5004__$1 = state_5004;
var statearr_5010_5157 = state_5004__$1;
(statearr_5010_5157[(2)] = null);

(statearr_5010_5157[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5005 === (7))){
var inst_5000 = (state_5004[(2)]);
var state_5004__$1 = state_5004;
var statearr_5011_5158 = state_5004__$1;
(statearr_5011_5158[(2)] = inst_5000);

(statearr_5011_5158[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__5148,c__4809__auto___5152,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async))
;
return ((function (__5148,switch__4714__auto__,c__4809__auto___5152,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0 = (function (){
var statearr_5012 = [null,null,null,null,null,null,null];
(statearr_5012[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__);

(statearr_5012[(1)] = (1));

return statearr_5012;
});
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1 = (function (state_5004){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_5004);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e5013){if((e5013 instanceof Object)){
var ex__4718__auto__ = e5013;
var statearr_5014_5159 = state_5004;
(statearr_5014_5159[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5004);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5013;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5160 = state_5004;
state_5004 = G__5160;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__ = function(state_5004){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1.call(this,state_5004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__;
})()
;})(__5148,switch__4714__auto__,c__4809__auto___5152,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async))
})();
var state__4811__auto__ = (function (){var statearr_5015 = f__4810__auto__.call(null);
(statearr_5015[(6)] = c__4809__auto___5152);

return statearr_5015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(__5148,c__4809__auto___5152,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async))
);


break;
case "async":
var c__4809__auto___5161 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__5148,c__4809__auto___5161,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (__5148,c__4809__auto___5161,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async){
return (function (state_5028){
var state_val_5029 = (state_5028[(1)]);
if((state_val_5029 === (1))){
var state_5028__$1 = state_5028;
var statearr_5030_5162 = state_5028__$1;
(statearr_5030_5162[(2)] = null);

(statearr_5030_5162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5029 === (2))){
var state_5028__$1 = state_5028;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5028__$1,(4),jobs);
} else {
if((state_val_5029 === (3))){
var inst_5026 = (state_5028[(2)]);
var state_5028__$1 = state_5028;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5028__$1,inst_5026);
} else {
if((state_val_5029 === (4))){
var inst_5018 = (state_5028[(2)]);
var inst_5019 = async.call(null,inst_5018);
var state_5028__$1 = state_5028;
if(cljs.core.truth_(inst_5019)){
var statearr_5031_5163 = state_5028__$1;
(statearr_5031_5163[(1)] = (5));

} else {
var statearr_5032_5164 = state_5028__$1;
(statearr_5032_5164[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5029 === (5))){
var state_5028__$1 = state_5028;
var statearr_5033_5165 = state_5028__$1;
(statearr_5033_5165[(2)] = null);

(statearr_5033_5165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5029 === (6))){
var state_5028__$1 = state_5028;
var statearr_5034_5166 = state_5028__$1;
(statearr_5034_5166[(2)] = null);

(statearr_5034_5166[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5029 === (7))){
var inst_5024 = (state_5028[(2)]);
var state_5028__$1 = state_5028;
var statearr_5035_5167 = state_5028__$1;
(statearr_5035_5167[(2)] = inst_5024);

(statearr_5035_5167[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__5148,c__4809__auto___5161,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async))
;
return ((function (__5148,switch__4714__auto__,c__4809__auto___5161,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0 = (function (){
var statearr_5036 = [null,null,null,null,null,null,null];
(statearr_5036[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__);

(statearr_5036[(1)] = (1));

return statearr_5036;
});
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1 = (function (state_5028){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_5028);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e5037){if((e5037 instanceof Object)){
var ex__4718__auto__ = e5037;
var statearr_5038_5168 = state_5028;
(statearr_5038_5168[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5028);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5037;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5169 = state_5028;
state_5028 = G__5169;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__ = function(state_5028){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1.call(this,state_5028);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__;
})()
;})(__5148,switch__4714__auto__,c__4809__auto___5161,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async))
})();
var state__4811__auto__ = (function (){var statearr_5039 = f__4810__auto__.call(null);
(statearr_5039[(6)] = c__4809__auto___5161);

return statearr_5039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(__5148,c__4809__auto___5161,G__4991_5149,G__4991_5150__$1,n__4607__auto___5147,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__4991_5150__$1)].join('')));

}

var G__5170 = (__5148 + (1));
__5148 = G__5170;
continue;
} else {
}
break;
}

var c__4809__auto___5171 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___5171,jobs,results,process,async){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___5171,jobs,results,process,async){
return (function (state_5061){
var state_val_5062 = (state_5061[(1)]);
if((state_val_5062 === (7))){
var inst_5057 = (state_5061[(2)]);
var state_5061__$1 = state_5061;
var statearr_5063_5172 = state_5061__$1;
(statearr_5063_5172[(2)] = inst_5057);

(statearr_5063_5172[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5062 === (1))){
var state_5061__$1 = state_5061;
var statearr_5064_5173 = state_5061__$1;
(statearr_5064_5173[(2)] = null);

(statearr_5064_5173[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5062 === (4))){
var inst_5042 = (state_5061[(7)]);
var inst_5042__$1 = (state_5061[(2)]);
var inst_5043 = (inst_5042__$1 == null);
var state_5061__$1 = (function (){var statearr_5065 = state_5061;
(statearr_5065[(7)] = inst_5042__$1);

return statearr_5065;
})();
if(cljs.core.truth_(inst_5043)){
var statearr_5066_5174 = state_5061__$1;
(statearr_5066_5174[(1)] = (5));

} else {
var statearr_5067_5175 = state_5061__$1;
(statearr_5067_5175[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5062 === (6))){
var inst_5042 = (state_5061[(7)]);
var inst_5047 = (state_5061[(8)]);
var inst_5047__$1 = cljs.core.async.chan.call(null,(1));
var inst_5048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_5049 = [inst_5042,inst_5047__$1];
var inst_5050 = (new cljs.core.PersistentVector(null,2,(5),inst_5048,inst_5049,null));
var state_5061__$1 = (function (){var statearr_5068 = state_5061;
(statearr_5068[(8)] = inst_5047__$1);

return statearr_5068;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5061__$1,(8),jobs,inst_5050);
} else {
if((state_val_5062 === (3))){
var inst_5059 = (state_5061[(2)]);
var state_5061__$1 = state_5061;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5061__$1,inst_5059);
} else {
if((state_val_5062 === (2))){
var state_5061__$1 = state_5061;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5061__$1,(4),from);
} else {
if((state_val_5062 === (9))){
var inst_5054 = (state_5061[(2)]);
var state_5061__$1 = (function (){var statearr_5069 = state_5061;
(statearr_5069[(9)] = inst_5054);

return statearr_5069;
})();
var statearr_5070_5176 = state_5061__$1;
(statearr_5070_5176[(2)] = null);

(statearr_5070_5176[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5062 === (5))){
var inst_5045 = cljs.core.async.close_BANG_.call(null,jobs);
var state_5061__$1 = state_5061;
var statearr_5071_5177 = state_5061__$1;
(statearr_5071_5177[(2)] = inst_5045);

(statearr_5071_5177[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5062 === (8))){
var inst_5047 = (state_5061[(8)]);
var inst_5052 = (state_5061[(2)]);
var state_5061__$1 = (function (){var statearr_5072 = state_5061;
(statearr_5072[(10)] = inst_5052);

return statearr_5072;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5061__$1,(9),results,inst_5047);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___5171,jobs,results,process,async))
;
return ((function (switch__4714__auto__,c__4809__auto___5171,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0 = (function (){
var statearr_5073 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_5073[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__);

(statearr_5073[(1)] = (1));

return statearr_5073;
});
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1 = (function (state_5061){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_5061);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e5074){if((e5074 instanceof Object)){
var ex__4718__auto__ = e5074;
var statearr_5075_5178 = state_5061;
(statearr_5075_5178[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5061);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5074;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5179 = state_5061;
state_5061 = G__5179;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__ = function(state_5061){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1.call(this,state_5061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___5171,jobs,results,process,async))
})();
var state__4811__auto__ = (function (){var statearr_5076 = f__4810__auto__.call(null);
(statearr_5076[(6)] = c__4809__auto___5171);

return statearr_5076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___5171,jobs,results,process,async))
);


var c__4809__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto__,jobs,results,process,async){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto__,jobs,results,process,async){
return (function (state_5114){
var state_val_5115 = (state_5114[(1)]);
if((state_val_5115 === (7))){
var inst_5110 = (state_5114[(2)]);
var state_5114__$1 = state_5114;
var statearr_5116_5180 = state_5114__$1;
(statearr_5116_5180[(2)] = inst_5110);

(statearr_5116_5180[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (20))){
var state_5114__$1 = state_5114;
var statearr_5117_5181 = state_5114__$1;
(statearr_5117_5181[(2)] = null);

(statearr_5117_5181[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (1))){
var state_5114__$1 = state_5114;
var statearr_5118_5182 = state_5114__$1;
(statearr_5118_5182[(2)] = null);

(statearr_5118_5182[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (4))){
var inst_5079 = (state_5114[(7)]);
var inst_5079__$1 = (state_5114[(2)]);
var inst_5080 = (inst_5079__$1 == null);
var state_5114__$1 = (function (){var statearr_5119 = state_5114;
(statearr_5119[(7)] = inst_5079__$1);

return statearr_5119;
})();
if(cljs.core.truth_(inst_5080)){
var statearr_5120_5183 = state_5114__$1;
(statearr_5120_5183[(1)] = (5));

} else {
var statearr_5121_5184 = state_5114__$1;
(statearr_5121_5184[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (15))){
var inst_5092 = (state_5114[(8)]);
var state_5114__$1 = state_5114;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5114__$1,(18),to,inst_5092);
} else {
if((state_val_5115 === (21))){
var inst_5105 = (state_5114[(2)]);
var state_5114__$1 = state_5114;
var statearr_5122_5185 = state_5114__$1;
(statearr_5122_5185[(2)] = inst_5105);

(statearr_5122_5185[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (13))){
var inst_5107 = (state_5114[(2)]);
var state_5114__$1 = (function (){var statearr_5123 = state_5114;
(statearr_5123[(9)] = inst_5107);

return statearr_5123;
})();
var statearr_5124_5186 = state_5114__$1;
(statearr_5124_5186[(2)] = null);

(statearr_5124_5186[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (6))){
var inst_5079 = (state_5114[(7)]);
var state_5114__$1 = state_5114;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5114__$1,(11),inst_5079);
} else {
if((state_val_5115 === (17))){
var inst_5100 = (state_5114[(2)]);
var state_5114__$1 = state_5114;
if(cljs.core.truth_(inst_5100)){
var statearr_5125_5187 = state_5114__$1;
(statearr_5125_5187[(1)] = (19));

} else {
var statearr_5126_5188 = state_5114__$1;
(statearr_5126_5188[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (3))){
var inst_5112 = (state_5114[(2)]);
var state_5114__$1 = state_5114;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5114__$1,inst_5112);
} else {
if((state_val_5115 === (12))){
var inst_5089 = (state_5114[(10)]);
var state_5114__$1 = state_5114;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5114__$1,(14),inst_5089);
} else {
if((state_val_5115 === (2))){
var state_5114__$1 = state_5114;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5114__$1,(4),results);
} else {
if((state_val_5115 === (19))){
var state_5114__$1 = state_5114;
var statearr_5127_5189 = state_5114__$1;
(statearr_5127_5189[(2)] = null);

(statearr_5127_5189[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (11))){
var inst_5089 = (state_5114[(2)]);
var state_5114__$1 = (function (){var statearr_5128 = state_5114;
(statearr_5128[(10)] = inst_5089);

return statearr_5128;
})();
var statearr_5129_5190 = state_5114__$1;
(statearr_5129_5190[(2)] = null);

(statearr_5129_5190[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (9))){
var state_5114__$1 = state_5114;
var statearr_5130_5191 = state_5114__$1;
(statearr_5130_5191[(2)] = null);

(statearr_5130_5191[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (5))){
var state_5114__$1 = state_5114;
if(cljs.core.truth_(close_QMARK_)){
var statearr_5131_5192 = state_5114__$1;
(statearr_5131_5192[(1)] = (8));

} else {
var statearr_5132_5193 = state_5114__$1;
(statearr_5132_5193[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (14))){
var inst_5092 = (state_5114[(8)]);
var inst_5094 = (state_5114[(11)]);
var inst_5092__$1 = (state_5114[(2)]);
var inst_5093 = (inst_5092__$1 == null);
var inst_5094__$1 = cljs.core.not.call(null,inst_5093);
var state_5114__$1 = (function (){var statearr_5133 = state_5114;
(statearr_5133[(8)] = inst_5092__$1);

(statearr_5133[(11)] = inst_5094__$1);

return statearr_5133;
})();
if(inst_5094__$1){
var statearr_5134_5194 = state_5114__$1;
(statearr_5134_5194[(1)] = (15));

} else {
var statearr_5135_5195 = state_5114__$1;
(statearr_5135_5195[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (16))){
var inst_5094 = (state_5114[(11)]);
var state_5114__$1 = state_5114;
var statearr_5136_5196 = state_5114__$1;
(statearr_5136_5196[(2)] = inst_5094);

(statearr_5136_5196[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (10))){
var inst_5086 = (state_5114[(2)]);
var state_5114__$1 = state_5114;
var statearr_5137_5197 = state_5114__$1;
(statearr_5137_5197[(2)] = inst_5086);

(statearr_5137_5197[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (18))){
var inst_5097 = (state_5114[(2)]);
var state_5114__$1 = state_5114;
var statearr_5138_5198 = state_5114__$1;
(statearr_5138_5198[(2)] = inst_5097);

(statearr_5138_5198[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5115 === (8))){
var inst_5083 = cljs.core.async.close_BANG_.call(null,to);
var state_5114__$1 = state_5114;
var statearr_5139_5199 = state_5114__$1;
(statearr_5139_5199[(2)] = inst_5083);

(statearr_5139_5199[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto__,jobs,results,process,async))
;
return ((function (switch__4714__auto__,c__4809__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0 = (function (){
var statearr_5140 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_5140[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__);

(statearr_5140[(1)] = (1));

return statearr_5140;
});
var cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1 = (function (state_5114){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_5114);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e5141){if((e5141 instanceof Object)){
var ex__4718__auto__ = e5141;
var statearr_5142_5200 = state_5114;
(statearr_5142_5200[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5114);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5141;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5201 = state_5114;
state_5114 = G__5201;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__ = function(state_5114){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1.call(this,state_5114);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__4715__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto__,jobs,results,process,async))
})();
var state__4811__auto__ = (function (){var statearr_5143 = f__4810__auto__.call(null);
(statearr_5143[(6)] = c__4809__auto__);

return statearr_5143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto__,jobs,results,process,async))
);

return c__4809__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__5203 = arguments.length;
switch (G__5203) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__5206 = arguments.length;
switch (G__5206) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__5209 = arguments.length;
switch (G__5209) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__4809__auto___5258 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___5258,tc,fc){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___5258,tc,fc){
return (function (state_5235){
var state_val_5236 = (state_5235[(1)]);
if((state_val_5236 === (7))){
var inst_5231 = (state_5235[(2)]);
var state_5235__$1 = state_5235;
var statearr_5237_5259 = state_5235__$1;
(statearr_5237_5259[(2)] = inst_5231);

(statearr_5237_5259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5236 === (1))){
var state_5235__$1 = state_5235;
var statearr_5238_5260 = state_5235__$1;
(statearr_5238_5260[(2)] = null);

(statearr_5238_5260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5236 === (4))){
var inst_5212 = (state_5235[(7)]);
var inst_5212__$1 = (state_5235[(2)]);
var inst_5213 = (inst_5212__$1 == null);
var state_5235__$1 = (function (){var statearr_5239 = state_5235;
(statearr_5239[(7)] = inst_5212__$1);

return statearr_5239;
})();
if(cljs.core.truth_(inst_5213)){
var statearr_5240_5261 = state_5235__$1;
(statearr_5240_5261[(1)] = (5));

} else {
var statearr_5241_5262 = state_5235__$1;
(statearr_5241_5262[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5236 === (13))){
var state_5235__$1 = state_5235;
var statearr_5242_5263 = state_5235__$1;
(statearr_5242_5263[(2)] = null);

(statearr_5242_5263[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5236 === (6))){
var inst_5212 = (state_5235[(7)]);
var inst_5218 = p.call(null,inst_5212);
var state_5235__$1 = state_5235;
if(cljs.core.truth_(inst_5218)){
var statearr_5243_5264 = state_5235__$1;
(statearr_5243_5264[(1)] = (9));

} else {
var statearr_5244_5265 = state_5235__$1;
(statearr_5244_5265[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5236 === (3))){
var inst_5233 = (state_5235[(2)]);
var state_5235__$1 = state_5235;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5235__$1,inst_5233);
} else {
if((state_val_5236 === (12))){
var state_5235__$1 = state_5235;
var statearr_5245_5266 = state_5235__$1;
(statearr_5245_5266[(2)] = null);

(statearr_5245_5266[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5236 === (2))){
var state_5235__$1 = state_5235;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5235__$1,(4),ch);
} else {
if((state_val_5236 === (11))){
var inst_5212 = (state_5235[(7)]);
var inst_5222 = (state_5235[(2)]);
var state_5235__$1 = state_5235;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5235__$1,(8),inst_5222,inst_5212);
} else {
if((state_val_5236 === (9))){
var state_5235__$1 = state_5235;
var statearr_5246_5267 = state_5235__$1;
(statearr_5246_5267[(2)] = tc);

(statearr_5246_5267[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5236 === (5))){
var inst_5215 = cljs.core.async.close_BANG_.call(null,tc);
var inst_5216 = cljs.core.async.close_BANG_.call(null,fc);
var state_5235__$1 = (function (){var statearr_5247 = state_5235;
(statearr_5247[(8)] = inst_5215);

return statearr_5247;
})();
var statearr_5248_5268 = state_5235__$1;
(statearr_5248_5268[(2)] = inst_5216);

(statearr_5248_5268[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5236 === (14))){
var inst_5229 = (state_5235[(2)]);
var state_5235__$1 = state_5235;
var statearr_5249_5269 = state_5235__$1;
(statearr_5249_5269[(2)] = inst_5229);

(statearr_5249_5269[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5236 === (10))){
var state_5235__$1 = state_5235;
var statearr_5250_5270 = state_5235__$1;
(statearr_5250_5270[(2)] = fc);

(statearr_5250_5270[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5236 === (8))){
var inst_5224 = (state_5235[(2)]);
var state_5235__$1 = state_5235;
if(cljs.core.truth_(inst_5224)){
var statearr_5251_5271 = state_5235__$1;
(statearr_5251_5271[(1)] = (12));

} else {
var statearr_5252_5272 = state_5235__$1;
(statearr_5252_5272[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___5258,tc,fc))
;
return ((function (switch__4714__auto__,c__4809__auto___5258,tc,fc){
return (function() {
var cljs$core$async$state_machine__4715__auto__ = null;
var cljs$core$async$state_machine__4715__auto____0 = (function (){
var statearr_5253 = [null,null,null,null,null,null,null,null,null];
(statearr_5253[(0)] = cljs$core$async$state_machine__4715__auto__);

(statearr_5253[(1)] = (1));

return statearr_5253;
});
var cljs$core$async$state_machine__4715__auto____1 = (function (state_5235){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_5235);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e5254){if((e5254 instanceof Object)){
var ex__4718__auto__ = e5254;
var statearr_5255_5273 = state_5235;
(statearr_5255_5273[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5235);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5254;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5274 = state_5235;
state_5235 = G__5274;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$state_machine__4715__auto__ = function(state_5235){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__4715__auto____1.call(this,state_5235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__4715__auto____0;
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__4715__auto____1;
return cljs$core$async$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___5258,tc,fc))
})();
var state__4811__auto__ = (function (){var statearr_5256 = f__4810__auto__.call(null);
(statearr_5256[(6)] = c__4809__auto___5258);

return statearr_5256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___5258,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__4809__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto__){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto__){
return (function (state_5295){
var state_val_5296 = (state_5295[(1)]);
if((state_val_5296 === (7))){
var inst_5291 = (state_5295[(2)]);
var state_5295__$1 = state_5295;
var statearr_5297_5315 = state_5295__$1;
(statearr_5297_5315[(2)] = inst_5291);

(statearr_5297_5315[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (1))){
var inst_5275 = init;
var state_5295__$1 = (function (){var statearr_5298 = state_5295;
(statearr_5298[(7)] = inst_5275);

return statearr_5298;
})();
var statearr_5299_5316 = state_5295__$1;
(statearr_5299_5316[(2)] = null);

(statearr_5299_5316[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (4))){
var inst_5278 = (state_5295[(8)]);
var inst_5278__$1 = (state_5295[(2)]);
var inst_5279 = (inst_5278__$1 == null);
var state_5295__$1 = (function (){var statearr_5300 = state_5295;
(statearr_5300[(8)] = inst_5278__$1);

return statearr_5300;
})();
if(cljs.core.truth_(inst_5279)){
var statearr_5301_5317 = state_5295__$1;
(statearr_5301_5317[(1)] = (5));

} else {
var statearr_5302_5318 = state_5295__$1;
(statearr_5302_5318[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (6))){
var inst_5275 = (state_5295[(7)]);
var inst_5278 = (state_5295[(8)]);
var inst_5282 = (state_5295[(9)]);
var inst_5282__$1 = f.call(null,inst_5275,inst_5278);
var inst_5283 = cljs.core.reduced_QMARK_.call(null,inst_5282__$1);
var state_5295__$1 = (function (){var statearr_5303 = state_5295;
(statearr_5303[(9)] = inst_5282__$1);

return statearr_5303;
})();
if(inst_5283){
var statearr_5304_5319 = state_5295__$1;
(statearr_5304_5319[(1)] = (8));

} else {
var statearr_5305_5320 = state_5295__$1;
(statearr_5305_5320[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (3))){
var inst_5293 = (state_5295[(2)]);
var state_5295__$1 = state_5295;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5295__$1,inst_5293);
} else {
if((state_val_5296 === (2))){
var state_5295__$1 = state_5295;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5295__$1,(4),ch);
} else {
if((state_val_5296 === (9))){
var inst_5282 = (state_5295[(9)]);
var inst_5275 = inst_5282;
var state_5295__$1 = (function (){var statearr_5306 = state_5295;
(statearr_5306[(7)] = inst_5275);

return statearr_5306;
})();
var statearr_5307_5321 = state_5295__$1;
(statearr_5307_5321[(2)] = null);

(statearr_5307_5321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (5))){
var inst_5275 = (state_5295[(7)]);
var state_5295__$1 = state_5295;
var statearr_5308_5322 = state_5295__$1;
(statearr_5308_5322[(2)] = inst_5275);

(statearr_5308_5322[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (10))){
var inst_5289 = (state_5295[(2)]);
var state_5295__$1 = state_5295;
var statearr_5309_5323 = state_5295__$1;
(statearr_5309_5323[(2)] = inst_5289);

(statearr_5309_5323[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5296 === (8))){
var inst_5282 = (state_5295[(9)]);
var inst_5285 = cljs.core.deref.call(null,inst_5282);
var state_5295__$1 = state_5295;
var statearr_5310_5324 = state_5295__$1;
(statearr_5310_5324[(2)] = inst_5285);

(statearr_5310_5324[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto__))
;
return ((function (switch__4714__auto__,c__4809__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__4715__auto__ = null;
var cljs$core$async$reduce_$_state_machine__4715__auto____0 = (function (){
var statearr_5311 = [null,null,null,null,null,null,null,null,null,null];
(statearr_5311[(0)] = cljs$core$async$reduce_$_state_machine__4715__auto__);

(statearr_5311[(1)] = (1));

return statearr_5311;
});
var cljs$core$async$reduce_$_state_machine__4715__auto____1 = (function (state_5295){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_5295);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e5312){if((e5312 instanceof Object)){
var ex__4718__auto__ = e5312;
var statearr_5313_5325 = state_5295;
(statearr_5313_5325[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5295);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5312;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5326 = state_5295;
state_5295 = G__5326;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__4715__auto__ = function(state_5295){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__4715__auto____1.call(this,state_5295);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__4715__auto____0;
cljs$core$async$reduce_$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__4715__auto____1;
return cljs$core$async$reduce_$_state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto__))
})();
var state__4811__auto__ = (function (){var statearr_5314 = f__4810__auto__.call(null);
(statearr_5314[(6)] = c__4809__auto__);

return statearr_5314;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto__))
);

return c__4809__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__4809__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto__,f__$1){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto__,f__$1){
return (function (state_5332){
var state_val_5333 = (state_5332[(1)]);
if((state_val_5333 === (1))){
var inst_5327 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_5332__$1 = state_5332;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5332__$1,(2),inst_5327);
} else {
if((state_val_5333 === (2))){
var inst_5329 = (state_5332[(2)]);
var inst_5330 = f__$1.call(null,inst_5329);
var state_5332__$1 = state_5332;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5332__$1,inst_5330);
} else {
return null;
}
}
});})(c__4809__auto__,f__$1))
;
return ((function (switch__4714__auto__,c__4809__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__4715__auto__ = null;
var cljs$core$async$transduce_$_state_machine__4715__auto____0 = (function (){
var statearr_5334 = [null,null,null,null,null,null,null];
(statearr_5334[(0)] = cljs$core$async$transduce_$_state_machine__4715__auto__);

(statearr_5334[(1)] = (1));

return statearr_5334;
});
var cljs$core$async$transduce_$_state_machine__4715__auto____1 = (function (state_5332){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_5332);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e5335){if((e5335 instanceof Object)){
var ex__4718__auto__ = e5335;
var statearr_5336_5338 = state_5332;
(statearr_5336_5338[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5332);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5335;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5339 = state_5332;
state_5332 = G__5339;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__4715__auto__ = function(state_5332){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__4715__auto____1.call(this,state_5332);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__4715__auto____0;
cljs$core$async$transduce_$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__4715__auto____1;
return cljs$core$async$transduce_$_state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto__,f__$1))
})();
var state__4811__auto__ = (function (){var statearr_5337 = f__4810__auto__.call(null);
(statearr_5337[(6)] = c__4809__auto__);

return statearr_5337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto__,f__$1))
);

return c__4809__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__5341 = arguments.length;
switch (G__5341) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__4809__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto__){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto__){
return (function (state_5366){
var state_val_5367 = (state_5366[(1)]);
if((state_val_5367 === (7))){
var inst_5348 = (state_5366[(2)]);
var state_5366__$1 = state_5366;
var statearr_5368_5389 = state_5366__$1;
(statearr_5368_5389[(2)] = inst_5348);

(statearr_5368_5389[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (1))){
var inst_5342 = cljs.core.seq.call(null,coll);
var inst_5343 = inst_5342;
var state_5366__$1 = (function (){var statearr_5369 = state_5366;
(statearr_5369[(7)] = inst_5343);

return statearr_5369;
})();
var statearr_5370_5390 = state_5366__$1;
(statearr_5370_5390[(2)] = null);

(statearr_5370_5390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (4))){
var inst_5343 = (state_5366[(7)]);
var inst_5346 = cljs.core.first.call(null,inst_5343);
var state_5366__$1 = state_5366;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5366__$1,(7),ch,inst_5346);
} else {
if((state_val_5367 === (13))){
var inst_5360 = (state_5366[(2)]);
var state_5366__$1 = state_5366;
var statearr_5371_5391 = state_5366__$1;
(statearr_5371_5391[(2)] = inst_5360);

(statearr_5371_5391[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (6))){
var inst_5351 = (state_5366[(2)]);
var state_5366__$1 = state_5366;
if(cljs.core.truth_(inst_5351)){
var statearr_5372_5392 = state_5366__$1;
(statearr_5372_5392[(1)] = (8));

} else {
var statearr_5373_5393 = state_5366__$1;
(statearr_5373_5393[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (3))){
var inst_5364 = (state_5366[(2)]);
var state_5366__$1 = state_5366;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5366__$1,inst_5364);
} else {
if((state_val_5367 === (12))){
var state_5366__$1 = state_5366;
var statearr_5374_5394 = state_5366__$1;
(statearr_5374_5394[(2)] = null);

(statearr_5374_5394[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (2))){
var inst_5343 = (state_5366[(7)]);
var state_5366__$1 = state_5366;
if(cljs.core.truth_(inst_5343)){
var statearr_5375_5395 = state_5366__$1;
(statearr_5375_5395[(1)] = (4));

} else {
var statearr_5376_5396 = state_5366__$1;
(statearr_5376_5396[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (11))){
var inst_5357 = cljs.core.async.close_BANG_.call(null,ch);
var state_5366__$1 = state_5366;
var statearr_5377_5397 = state_5366__$1;
(statearr_5377_5397[(2)] = inst_5357);

(statearr_5377_5397[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (9))){
var state_5366__$1 = state_5366;
if(cljs.core.truth_(close_QMARK_)){
var statearr_5378_5398 = state_5366__$1;
(statearr_5378_5398[(1)] = (11));

} else {
var statearr_5379_5399 = state_5366__$1;
(statearr_5379_5399[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (5))){
var inst_5343 = (state_5366[(7)]);
var state_5366__$1 = state_5366;
var statearr_5380_5400 = state_5366__$1;
(statearr_5380_5400[(2)] = inst_5343);

(statearr_5380_5400[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (10))){
var inst_5362 = (state_5366[(2)]);
var state_5366__$1 = state_5366;
var statearr_5381_5401 = state_5366__$1;
(statearr_5381_5401[(2)] = inst_5362);

(statearr_5381_5401[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5367 === (8))){
var inst_5343 = (state_5366[(7)]);
var inst_5353 = cljs.core.next.call(null,inst_5343);
var inst_5343__$1 = inst_5353;
var state_5366__$1 = (function (){var statearr_5382 = state_5366;
(statearr_5382[(7)] = inst_5343__$1);

return statearr_5382;
})();
var statearr_5383_5402 = state_5366__$1;
(statearr_5383_5402[(2)] = null);

(statearr_5383_5402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto__))
;
return ((function (switch__4714__auto__,c__4809__auto__){
return (function() {
var cljs$core$async$state_machine__4715__auto__ = null;
var cljs$core$async$state_machine__4715__auto____0 = (function (){
var statearr_5384 = [null,null,null,null,null,null,null,null];
(statearr_5384[(0)] = cljs$core$async$state_machine__4715__auto__);

(statearr_5384[(1)] = (1));

return statearr_5384;
});
var cljs$core$async$state_machine__4715__auto____1 = (function (state_5366){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_5366);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e5385){if((e5385 instanceof Object)){
var ex__4718__auto__ = e5385;
var statearr_5386_5403 = state_5366;
(statearr_5386_5403[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5366);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5385;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5404 = state_5366;
state_5366 = G__5404;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$state_machine__4715__auto__ = function(state_5366){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__4715__auto____1.call(this,state_5366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__4715__auto____0;
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__4715__auto____1;
return cljs$core$async$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto__))
})();
var state__4811__auto__ = (function (){var statearr_5387 = f__4810__auto__.call(null);
(statearr_5387[(6)] = c__4809__auto__);

return statearr_5387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto__))
);

return c__4809__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async5405 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async5405 = (function (ch,cs,meta5406){
this.ch = ch;
this.cs = cs;
this.meta5406 = meta5406;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async5405.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_5407,meta5406__$1){
var self__ = this;
var _5407__$1 = this;
return (new cljs.core.async.t_cljs$core$async5405(self__.ch,self__.cs,meta5406__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async5405.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_5407){
var self__ = this;
var _5407__$1 = this;
return self__.meta5406;
});})(cs))
;

cljs.core.async.t_cljs$core$async5405.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5405.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async5405.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5405.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async5405.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async5405.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async5405.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta5406","meta5406",317686223,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async5405.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async5405.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async5405";

cljs.core.async.t_cljs$core$async5405.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async5405");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async5405.
 */
cljs.core.async.__GT_t_cljs$core$async5405 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async5405(ch__$1,cs__$1,meta5406){
return (new cljs.core.async.t_cljs$core$async5405(ch__$1,cs__$1,meta5406));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async5405(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__4809__auto___5627 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___5627,cs,m,dchan,dctr,done){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___5627,cs,m,dchan,dctr,done){
return (function (state_5542){
var state_val_5543 = (state_5542[(1)]);
if((state_val_5543 === (7))){
var inst_5538 = (state_5542[(2)]);
var state_5542__$1 = state_5542;
var statearr_5544_5628 = state_5542__$1;
(statearr_5544_5628[(2)] = inst_5538);

(statearr_5544_5628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (20))){
var inst_5441 = (state_5542[(7)]);
var inst_5453 = cljs.core.first.call(null,inst_5441);
var inst_5454 = cljs.core.nth.call(null,inst_5453,(0),null);
var inst_5455 = cljs.core.nth.call(null,inst_5453,(1),null);
var state_5542__$1 = (function (){var statearr_5545 = state_5542;
(statearr_5545[(8)] = inst_5454);

return statearr_5545;
})();
if(cljs.core.truth_(inst_5455)){
var statearr_5546_5629 = state_5542__$1;
(statearr_5546_5629[(1)] = (22));

} else {
var statearr_5547_5630 = state_5542__$1;
(statearr_5547_5630[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (27))){
var inst_5490 = (state_5542[(9)]);
var inst_5485 = (state_5542[(10)]);
var inst_5410 = (state_5542[(11)]);
var inst_5483 = (state_5542[(12)]);
var inst_5490__$1 = cljs.core._nth.call(null,inst_5483,inst_5485);
var inst_5491 = cljs.core.async.put_BANG_.call(null,inst_5490__$1,inst_5410,done);
var state_5542__$1 = (function (){var statearr_5548 = state_5542;
(statearr_5548[(9)] = inst_5490__$1);

return statearr_5548;
})();
if(cljs.core.truth_(inst_5491)){
var statearr_5549_5631 = state_5542__$1;
(statearr_5549_5631[(1)] = (30));

} else {
var statearr_5550_5632 = state_5542__$1;
(statearr_5550_5632[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (1))){
var state_5542__$1 = state_5542;
var statearr_5551_5633 = state_5542__$1;
(statearr_5551_5633[(2)] = null);

(statearr_5551_5633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (24))){
var inst_5441 = (state_5542[(7)]);
var inst_5460 = (state_5542[(2)]);
var inst_5461 = cljs.core.next.call(null,inst_5441);
var inst_5419 = inst_5461;
var inst_5420 = null;
var inst_5421 = (0);
var inst_5422 = (0);
var state_5542__$1 = (function (){var statearr_5552 = state_5542;
(statearr_5552[(13)] = inst_5460);

(statearr_5552[(14)] = inst_5421);

(statearr_5552[(15)] = inst_5419);

(statearr_5552[(16)] = inst_5422);

(statearr_5552[(17)] = inst_5420);

return statearr_5552;
})();
var statearr_5553_5634 = state_5542__$1;
(statearr_5553_5634[(2)] = null);

(statearr_5553_5634[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (39))){
var state_5542__$1 = state_5542;
var statearr_5557_5635 = state_5542__$1;
(statearr_5557_5635[(2)] = null);

(statearr_5557_5635[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (4))){
var inst_5410 = (state_5542[(11)]);
var inst_5410__$1 = (state_5542[(2)]);
var inst_5411 = (inst_5410__$1 == null);
var state_5542__$1 = (function (){var statearr_5558 = state_5542;
(statearr_5558[(11)] = inst_5410__$1);

return statearr_5558;
})();
if(cljs.core.truth_(inst_5411)){
var statearr_5559_5636 = state_5542__$1;
(statearr_5559_5636[(1)] = (5));

} else {
var statearr_5560_5637 = state_5542__$1;
(statearr_5560_5637[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (15))){
var inst_5421 = (state_5542[(14)]);
var inst_5419 = (state_5542[(15)]);
var inst_5422 = (state_5542[(16)]);
var inst_5420 = (state_5542[(17)]);
var inst_5437 = (state_5542[(2)]);
var inst_5438 = (inst_5422 + (1));
var tmp5554 = inst_5421;
var tmp5555 = inst_5419;
var tmp5556 = inst_5420;
var inst_5419__$1 = tmp5555;
var inst_5420__$1 = tmp5556;
var inst_5421__$1 = tmp5554;
var inst_5422__$1 = inst_5438;
var state_5542__$1 = (function (){var statearr_5561 = state_5542;
(statearr_5561[(14)] = inst_5421__$1);

(statearr_5561[(15)] = inst_5419__$1);

(statearr_5561[(16)] = inst_5422__$1);

(statearr_5561[(17)] = inst_5420__$1);

(statearr_5561[(18)] = inst_5437);

return statearr_5561;
})();
var statearr_5562_5638 = state_5542__$1;
(statearr_5562_5638[(2)] = null);

(statearr_5562_5638[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (21))){
var inst_5464 = (state_5542[(2)]);
var state_5542__$1 = state_5542;
var statearr_5566_5639 = state_5542__$1;
(statearr_5566_5639[(2)] = inst_5464);

(statearr_5566_5639[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (31))){
var inst_5490 = (state_5542[(9)]);
var inst_5494 = done.call(null,null);
var inst_5495 = cljs.core.async.untap_STAR_.call(null,m,inst_5490);
var state_5542__$1 = (function (){var statearr_5567 = state_5542;
(statearr_5567[(19)] = inst_5494);

return statearr_5567;
})();
var statearr_5568_5640 = state_5542__$1;
(statearr_5568_5640[(2)] = inst_5495);

(statearr_5568_5640[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (32))){
var inst_5484 = (state_5542[(20)]);
var inst_5485 = (state_5542[(10)]);
var inst_5482 = (state_5542[(21)]);
var inst_5483 = (state_5542[(12)]);
var inst_5497 = (state_5542[(2)]);
var inst_5498 = (inst_5485 + (1));
var tmp5563 = inst_5484;
var tmp5564 = inst_5482;
var tmp5565 = inst_5483;
var inst_5482__$1 = tmp5564;
var inst_5483__$1 = tmp5565;
var inst_5484__$1 = tmp5563;
var inst_5485__$1 = inst_5498;
var state_5542__$1 = (function (){var statearr_5569 = state_5542;
(statearr_5569[(20)] = inst_5484__$1);

(statearr_5569[(22)] = inst_5497);

(statearr_5569[(10)] = inst_5485__$1);

(statearr_5569[(21)] = inst_5482__$1);

(statearr_5569[(12)] = inst_5483__$1);

return statearr_5569;
})();
var statearr_5570_5641 = state_5542__$1;
(statearr_5570_5641[(2)] = null);

(statearr_5570_5641[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (40))){
var inst_5510 = (state_5542[(23)]);
var inst_5514 = done.call(null,null);
var inst_5515 = cljs.core.async.untap_STAR_.call(null,m,inst_5510);
var state_5542__$1 = (function (){var statearr_5571 = state_5542;
(statearr_5571[(24)] = inst_5514);

return statearr_5571;
})();
var statearr_5572_5642 = state_5542__$1;
(statearr_5572_5642[(2)] = inst_5515);

(statearr_5572_5642[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (33))){
var inst_5501 = (state_5542[(25)]);
var inst_5503 = cljs.core.chunked_seq_QMARK_.call(null,inst_5501);
var state_5542__$1 = state_5542;
if(inst_5503){
var statearr_5573_5643 = state_5542__$1;
(statearr_5573_5643[(1)] = (36));

} else {
var statearr_5574_5644 = state_5542__$1;
(statearr_5574_5644[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (13))){
var inst_5431 = (state_5542[(26)]);
var inst_5434 = cljs.core.async.close_BANG_.call(null,inst_5431);
var state_5542__$1 = state_5542;
var statearr_5575_5645 = state_5542__$1;
(statearr_5575_5645[(2)] = inst_5434);

(statearr_5575_5645[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (22))){
var inst_5454 = (state_5542[(8)]);
var inst_5457 = cljs.core.async.close_BANG_.call(null,inst_5454);
var state_5542__$1 = state_5542;
var statearr_5576_5646 = state_5542__$1;
(statearr_5576_5646[(2)] = inst_5457);

(statearr_5576_5646[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (36))){
var inst_5501 = (state_5542[(25)]);
var inst_5505 = cljs.core.chunk_first.call(null,inst_5501);
var inst_5506 = cljs.core.chunk_rest.call(null,inst_5501);
var inst_5507 = cljs.core.count.call(null,inst_5505);
var inst_5482 = inst_5506;
var inst_5483 = inst_5505;
var inst_5484 = inst_5507;
var inst_5485 = (0);
var state_5542__$1 = (function (){var statearr_5577 = state_5542;
(statearr_5577[(20)] = inst_5484);

(statearr_5577[(10)] = inst_5485);

(statearr_5577[(21)] = inst_5482);

(statearr_5577[(12)] = inst_5483);

return statearr_5577;
})();
var statearr_5578_5647 = state_5542__$1;
(statearr_5578_5647[(2)] = null);

(statearr_5578_5647[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (41))){
var inst_5501 = (state_5542[(25)]);
var inst_5517 = (state_5542[(2)]);
var inst_5518 = cljs.core.next.call(null,inst_5501);
var inst_5482 = inst_5518;
var inst_5483 = null;
var inst_5484 = (0);
var inst_5485 = (0);
var state_5542__$1 = (function (){var statearr_5579 = state_5542;
(statearr_5579[(20)] = inst_5484);

(statearr_5579[(10)] = inst_5485);

(statearr_5579[(27)] = inst_5517);

(statearr_5579[(21)] = inst_5482);

(statearr_5579[(12)] = inst_5483);

return statearr_5579;
})();
var statearr_5580_5648 = state_5542__$1;
(statearr_5580_5648[(2)] = null);

(statearr_5580_5648[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (43))){
var state_5542__$1 = state_5542;
var statearr_5581_5649 = state_5542__$1;
(statearr_5581_5649[(2)] = null);

(statearr_5581_5649[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (29))){
var inst_5526 = (state_5542[(2)]);
var state_5542__$1 = state_5542;
var statearr_5582_5650 = state_5542__$1;
(statearr_5582_5650[(2)] = inst_5526);

(statearr_5582_5650[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (44))){
var inst_5535 = (state_5542[(2)]);
var state_5542__$1 = (function (){var statearr_5583 = state_5542;
(statearr_5583[(28)] = inst_5535);

return statearr_5583;
})();
var statearr_5584_5651 = state_5542__$1;
(statearr_5584_5651[(2)] = null);

(statearr_5584_5651[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (6))){
var inst_5474 = (state_5542[(29)]);
var inst_5473 = cljs.core.deref.call(null,cs);
var inst_5474__$1 = cljs.core.keys.call(null,inst_5473);
var inst_5475 = cljs.core.count.call(null,inst_5474__$1);
var inst_5476 = cljs.core.reset_BANG_.call(null,dctr,inst_5475);
var inst_5481 = cljs.core.seq.call(null,inst_5474__$1);
var inst_5482 = inst_5481;
var inst_5483 = null;
var inst_5484 = (0);
var inst_5485 = (0);
var state_5542__$1 = (function (){var statearr_5585 = state_5542;
(statearr_5585[(20)] = inst_5484);

(statearr_5585[(30)] = inst_5476);

(statearr_5585[(10)] = inst_5485);

(statearr_5585[(29)] = inst_5474__$1);

(statearr_5585[(21)] = inst_5482);

(statearr_5585[(12)] = inst_5483);

return statearr_5585;
})();
var statearr_5586_5652 = state_5542__$1;
(statearr_5586_5652[(2)] = null);

(statearr_5586_5652[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (28))){
var inst_5501 = (state_5542[(25)]);
var inst_5482 = (state_5542[(21)]);
var inst_5501__$1 = cljs.core.seq.call(null,inst_5482);
var state_5542__$1 = (function (){var statearr_5587 = state_5542;
(statearr_5587[(25)] = inst_5501__$1);

return statearr_5587;
})();
if(inst_5501__$1){
var statearr_5588_5653 = state_5542__$1;
(statearr_5588_5653[(1)] = (33));

} else {
var statearr_5589_5654 = state_5542__$1;
(statearr_5589_5654[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (25))){
var inst_5484 = (state_5542[(20)]);
var inst_5485 = (state_5542[(10)]);
var inst_5487 = (inst_5485 < inst_5484);
var inst_5488 = inst_5487;
var state_5542__$1 = state_5542;
if(cljs.core.truth_(inst_5488)){
var statearr_5590_5655 = state_5542__$1;
(statearr_5590_5655[(1)] = (27));

} else {
var statearr_5591_5656 = state_5542__$1;
(statearr_5591_5656[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (34))){
var state_5542__$1 = state_5542;
var statearr_5592_5657 = state_5542__$1;
(statearr_5592_5657[(2)] = null);

(statearr_5592_5657[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (17))){
var state_5542__$1 = state_5542;
var statearr_5593_5658 = state_5542__$1;
(statearr_5593_5658[(2)] = null);

(statearr_5593_5658[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (3))){
var inst_5540 = (state_5542[(2)]);
var state_5542__$1 = state_5542;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5542__$1,inst_5540);
} else {
if((state_val_5543 === (12))){
var inst_5469 = (state_5542[(2)]);
var state_5542__$1 = state_5542;
var statearr_5594_5659 = state_5542__$1;
(statearr_5594_5659[(2)] = inst_5469);

(statearr_5594_5659[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (2))){
var state_5542__$1 = state_5542;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5542__$1,(4),ch);
} else {
if((state_val_5543 === (23))){
var state_5542__$1 = state_5542;
var statearr_5595_5660 = state_5542__$1;
(statearr_5595_5660[(2)] = null);

(statearr_5595_5660[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (35))){
var inst_5524 = (state_5542[(2)]);
var state_5542__$1 = state_5542;
var statearr_5596_5661 = state_5542__$1;
(statearr_5596_5661[(2)] = inst_5524);

(statearr_5596_5661[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (19))){
var inst_5441 = (state_5542[(7)]);
var inst_5445 = cljs.core.chunk_first.call(null,inst_5441);
var inst_5446 = cljs.core.chunk_rest.call(null,inst_5441);
var inst_5447 = cljs.core.count.call(null,inst_5445);
var inst_5419 = inst_5446;
var inst_5420 = inst_5445;
var inst_5421 = inst_5447;
var inst_5422 = (0);
var state_5542__$1 = (function (){var statearr_5597 = state_5542;
(statearr_5597[(14)] = inst_5421);

(statearr_5597[(15)] = inst_5419);

(statearr_5597[(16)] = inst_5422);

(statearr_5597[(17)] = inst_5420);

return statearr_5597;
})();
var statearr_5598_5662 = state_5542__$1;
(statearr_5598_5662[(2)] = null);

(statearr_5598_5662[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (11))){
var inst_5441 = (state_5542[(7)]);
var inst_5419 = (state_5542[(15)]);
var inst_5441__$1 = cljs.core.seq.call(null,inst_5419);
var state_5542__$1 = (function (){var statearr_5599 = state_5542;
(statearr_5599[(7)] = inst_5441__$1);

return statearr_5599;
})();
if(inst_5441__$1){
var statearr_5600_5663 = state_5542__$1;
(statearr_5600_5663[(1)] = (16));

} else {
var statearr_5601_5664 = state_5542__$1;
(statearr_5601_5664[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (9))){
var inst_5471 = (state_5542[(2)]);
var state_5542__$1 = state_5542;
var statearr_5602_5665 = state_5542__$1;
(statearr_5602_5665[(2)] = inst_5471);

(statearr_5602_5665[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (5))){
var inst_5417 = cljs.core.deref.call(null,cs);
var inst_5418 = cljs.core.seq.call(null,inst_5417);
var inst_5419 = inst_5418;
var inst_5420 = null;
var inst_5421 = (0);
var inst_5422 = (0);
var state_5542__$1 = (function (){var statearr_5603 = state_5542;
(statearr_5603[(14)] = inst_5421);

(statearr_5603[(15)] = inst_5419);

(statearr_5603[(16)] = inst_5422);

(statearr_5603[(17)] = inst_5420);

return statearr_5603;
})();
var statearr_5604_5666 = state_5542__$1;
(statearr_5604_5666[(2)] = null);

(statearr_5604_5666[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (14))){
var state_5542__$1 = state_5542;
var statearr_5605_5667 = state_5542__$1;
(statearr_5605_5667[(2)] = null);

(statearr_5605_5667[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (45))){
var inst_5532 = (state_5542[(2)]);
var state_5542__$1 = state_5542;
var statearr_5606_5668 = state_5542__$1;
(statearr_5606_5668[(2)] = inst_5532);

(statearr_5606_5668[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (26))){
var inst_5474 = (state_5542[(29)]);
var inst_5528 = (state_5542[(2)]);
var inst_5529 = cljs.core.seq.call(null,inst_5474);
var state_5542__$1 = (function (){var statearr_5607 = state_5542;
(statearr_5607[(31)] = inst_5528);

return statearr_5607;
})();
if(inst_5529){
var statearr_5608_5669 = state_5542__$1;
(statearr_5608_5669[(1)] = (42));

} else {
var statearr_5609_5670 = state_5542__$1;
(statearr_5609_5670[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (16))){
var inst_5441 = (state_5542[(7)]);
var inst_5443 = cljs.core.chunked_seq_QMARK_.call(null,inst_5441);
var state_5542__$1 = state_5542;
if(inst_5443){
var statearr_5610_5671 = state_5542__$1;
(statearr_5610_5671[(1)] = (19));

} else {
var statearr_5611_5672 = state_5542__$1;
(statearr_5611_5672[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (38))){
var inst_5521 = (state_5542[(2)]);
var state_5542__$1 = state_5542;
var statearr_5612_5673 = state_5542__$1;
(statearr_5612_5673[(2)] = inst_5521);

(statearr_5612_5673[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (30))){
var state_5542__$1 = state_5542;
var statearr_5613_5674 = state_5542__$1;
(statearr_5613_5674[(2)] = null);

(statearr_5613_5674[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (10))){
var inst_5422 = (state_5542[(16)]);
var inst_5420 = (state_5542[(17)]);
var inst_5430 = cljs.core._nth.call(null,inst_5420,inst_5422);
var inst_5431 = cljs.core.nth.call(null,inst_5430,(0),null);
var inst_5432 = cljs.core.nth.call(null,inst_5430,(1),null);
var state_5542__$1 = (function (){var statearr_5614 = state_5542;
(statearr_5614[(26)] = inst_5431);

return statearr_5614;
})();
if(cljs.core.truth_(inst_5432)){
var statearr_5615_5675 = state_5542__$1;
(statearr_5615_5675[(1)] = (13));

} else {
var statearr_5616_5676 = state_5542__$1;
(statearr_5616_5676[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (18))){
var inst_5467 = (state_5542[(2)]);
var state_5542__$1 = state_5542;
var statearr_5617_5677 = state_5542__$1;
(statearr_5617_5677[(2)] = inst_5467);

(statearr_5617_5677[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (42))){
var state_5542__$1 = state_5542;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5542__$1,(45),dchan);
} else {
if((state_val_5543 === (37))){
var inst_5510 = (state_5542[(23)]);
var inst_5501 = (state_5542[(25)]);
var inst_5410 = (state_5542[(11)]);
var inst_5510__$1 = cljs.core.first.call(null,inst_5501);
var inst_5511 = cljs.core.async.put_BANG_.call(null,inst_5510__$1,inst_5410,done);
var state_5542__$1 = (function (){var statearr_5618 = state_5542;
(statearr_5618[(23)] = inst_5510__$1);

return statearr_5618;
})();
if(cljs.core.truth_(inst_5511)){
var statearr_5619_5678 = state_5542__$1;
(statearr_5619_5678[(1)] = (39));

} else {
var statearr_5620_5679 = state_5542__$1;
(statearr_5620_5679[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5543 === (8))){
var inst_5421 = (state_5542[(14)]);
var inst_5422 = (state_5542[(16)]);
var inst_5424 = (inst_5422 < inst_5421);
var inst_5425 = inst_5424;
var state_5542__$1 = state_5542;
if(cljs.core.truth_(inst_5425)){
var statearr_5621_5680 = state_5542__$1;
(statearr_5621_5680[(1)] = (10));

} else {
var statearr_5622_5681 = state_5542__$1;
(statearr_5622_5681[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___5627,cs,m,dchan,dctr,done))
;
return ((function (switch__4714__auto__,c__4809__auto___5627,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__4715__auto__ = null;
var cljs$core$async$mult_$_state_machine__4715__auto____0 = (function (){
var statearr_5623 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_5623[(0)] = cljs$core$async$mult_$_state_machine__4715__auto__);

(statearr_5623[(1)] = (1));

return statearr_5623;
});
var cljs$core$async$mult_$_state_machine__4715__auto____1 = (function (state_5542){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_5542);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e5624){if((e5624 instanceof Object)){
var ex__4718__auto__ = e5624;
var statearr_5625_5682 = state_5542;
(statearr_5625_5682[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5542);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5624;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5683 = state_5542;
state_5542 = G__5683;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__4715__auto__ = function(state_5542){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__4715__auto____1.call(this,state_5542);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__4715__auto____0;
cljs$core$async$mult_$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__4715__auto____1;
return cljs$core$async$mult_$_state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___5627,cs,m,dchan,dctr,done))
})();
var state__4811__auto__ = (function (){var statearr_5626 = f__4810__auto__.call(null);
(statearr_5626[(6)] = c__4809__auto___5627);

return statearr_5626;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___5627,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__5685 = arguments.length;
switch (G__5685) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___5697 = arguments.length;
var i__4731__auto___5698 = (0);
while(true){
if((i__4731__auto___5698 < len__4730__auto___5697)){
args__4736__auto__.push((arguments[i__4731__auto___5698]));

var G__5699 = (i__4731__auto___5698 + (1));
i__4731__auto___5698 = G__5699;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__5691){
var map__5692 = p__5691;
var map__5692__$1 = (((((!((map__5692 == null))))?(((((map__5692.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__5692.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__5692):map__5692);
var opts = map__5692__$1;
var statearr_5694_5700 = state;
(statearr_5694_5700[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,((function (map__5692,map__5692__$1,opts){
return (function (val){
var statearr_5695_5701 = state;
(statearr_5695_5701[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__5692,map__5692__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_5696_5702 = state;
(statearr_5696_5702[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq5687){
var G__5688 = cljs.core.first.call(null,seq5687);
var seq5687__$1 = cljs.core.next.call(null,seq5687);
var G__5689 = cljs.core.first.call(null,seq5687__$1);
var seq5687__$2 = cljs.core.next.call(null,seq5687__$1);
var G__5690 = cljs.core.first.call(null,seq5687__$2);
var seq5687__$3 = cljs.core.next.call(null,seq5687__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__5688,G__5689,G__5690,seq5687__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async5703 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async5703 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta5704){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta5704 = meta5704;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async5703.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_5705,meta5704__$1){
var self__ = this;
var _5705__$1 = this;
return (new cljs.core.async.t_cljs$core$async5703(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta5704__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async5703.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_5705){
var self__ = this;
var _5705__$1 = this;
return self__.meta5704;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async5703.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5703.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async5703.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5703.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async5703.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async5703.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async5703.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async5703.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async5703.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta5704","meta5704",-34348347,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async5703.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async5703.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async5703";

cljs.core.async.t_cljs$core$async5703.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async5703");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async5703.
 */
cljs.core.async.__GT_t_cljs$core$async5703 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async5703(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta5704){
return (new cljs.core.async.t_cljs$core$async5703(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta5704));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async5703(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__4809__auto___5867 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___5867,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___5867,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_5807){
var state_val_5808 = (state_5807[(1)]);
if((state_val_5808 === (7))){
var inst_5722 = (state_5807[(2)]);
var state_5807__$1 = state_5807;
var statearr_5809_5868 = state_5807__$1;
(statearr_5809_5868[(2)] = inst_5722);

(statearr_5809_5868[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (20))){
var inst_5734 = (state_5807[(7)]);
var state_5807__$1 = state_5807;
var statearr_5810_5869 = state_5807__$1;
(statearr_5810_5869[(2)] = inst_5734);

(statearr_5810_5869[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (27))){
var state_5807__$1 = state_5807;
var statearr_5811_5870 = state_5807__$1;
(statearr_5811_5870[(2)] = null);

(statearr_5811_5870[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (1))){
var inst_5709 = (state_5807[(8)]);
var inst_5709__$1 = calc_state.call(null);
var inst_5711 = (inst_5709__$1 == null);
var inst_5712 = cljs.core.not.call(null,inst_5711);
var state_5807__$1 = (function (){var statearr_5812 = state_5807;
(statearr_5812[(8)] = inst_5709__$1);

return statearr_5812;
})();
if(inst_5712){
var statearr_5813_5871 = state_5807__$1;
(statearr_5813_5871[(1)] = (2));

} else {
var statearr_5814_5872 = state_5807__$1;
(statearr_5814_5872[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (24))){
var inst_5758 = (state_5807[(9)]);
var inst_5781 = (state_5807[(10)]);
var inst_5767 = (state_5807[(11)]);
var inst_5781__$1 = inst_5758.call(null,inst_5767);
var state_5807__$1 = (function (){var statearr_5815 = state_5807;
(statearr_5815[(10)] = inst_5781__$1);

return statearr_5815;
})();
if(cljs.core.truth_(inst_5781__$1)){
var statearr_5816_5873 = state_5807__$1;
(statearr_5816_5873[(1)] = (29));

} else {
var statearr_5817_5874 = state_5807__$1;
(statearr_5817_5874[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (4))){
var inst_5725 = (state_5807[(2)]);
var state_5807__$1 = state_5807;
if(cljs.core.truth_(inst_5725)){
var statearr_5818_5875 = state_5807__$1;
(statearr_5818_5875[(1)] = (8));

} else {
var statearr_5819_5876 = state_5807__$1;
(statearr_5819_5876[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (15))){
var inst_5752 = (state_5807[(2)]);
var state_5807__$1 = state_5807;
if(cljs.core.truth_(inst_5752)){
var statearr_5820_5877 = state_5807__$1;
(statearr_5820_5877[(1)] = (19));

} else {
var statearr_5821_5878 = state_5807__$1;
(statearr_5821_5878[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (21))){
var inst_5757 = (state_5807[(12)]);
var inst_5757__$1 = (state_5807[(2)]);
var inst_5758 = cljs.core.get.call(null,inst_5757__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_5759 = cljs.core.get.call(null,inst_5757__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_5760 = cljs.core.get.call(null,inst_5757__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_5807__$1 = (function (){var statearr_5822 = state_5807;
(statearr_5822[(9)] = inst_5758);

(statearr_5822[(12)] = inst_5757__$1);

(statearr_5822[(13)] = inst_5759);

return statearr_5822;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_5807__$1,(22),inst_5760);
} else {
if((state_val_5808 === (31))){
var inst_5789 = (state_5807[(2)]);
var state_5807__$1 = state_5807;
if(cljs.core.truth_(inst_5789)){
var statearr_5823_5879 = state_5807__$1;
(statearr_5823_5879[(1)] = (32));

} else {
var statearr_5824_5880 = state_5807__$1;
(statearr_5824_5880[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (32))){
var inst_5766 = (state_5807[(14)]);
var state_5807__$1 = state_5807;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5807__$1,(35),out,inst_5766);
} else {
if((state_val_5808 === (33))){
var inst_5757 = (state_5807[(12)]);
var inst_5734 = inst_5757;
var state_5807__$1 = (function (){var statearr_5825 = state_5807;
(statearr_5825[(7)] = inst_5734);

return statearr_5825;
})();
var statearr_5826_5881 = state_5807__$1;
(statearr_5826_5881[(2)] = null);

(statearr_5826_5881[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (13))){
var inst_5734 = (state_5807[(7)]);
var inst_5741 = inst_5734.cljs$lang$protocol_mask$partition0$;
var inst_5742 = (inst_5741 & (64));
var inst_5743 = inst_5734.cljs$core$ISeq$;
var inst_5744 = (cljs.core.PROTOCOL_SENTINEL === inst_5743);
var inst_5745 = ((inst_5742) || (inst_5744));
var state_5807__$1 = state_5807;
if(cljs.core.truth_(inst_5745)){
var statearr_5827_5882 = state_5807__$1;
(statearr_5827_5882[(1)] = (16));

} else {
var statearr_5828_5883 = state_5807__$1;
(statearr_5828_5883[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (22))){
var inst_5767 = (state_5807[(11)]);
var inst_5766 = (state_5807[(14)]);
var inst_5765 = (state_5807[(2)]);
var inst_5766__$1 = cljs.core.nth.call(null,inst_5765,(0),null);
var inst_5767__$1 = cljs.core.nth.call(null,inst_5765,(1),null);
var inst_5768 = (inst_5766__$1 == null);
var inst_5769 = cljs.core._EQ_.call(null,inst_5767__$1,change);
var inst_5770 = ((inst_5768) || (inst_5769));
var state_5807__$1 = (function (){var statearr_5829 = state_5807;
(statearr_5829[(11)] = inst_5767__$1);

(statearr_5829[(14)] = inst_5766__$1);

return statearr_5829;
})();
if(cljs.core.truth_(inst_5770)){
var statearr_5830_5884 = state_5807__$1;
(statearr_5830_5884[(1)] = (23));

} else {
var statearr_5831_5885 = state_5807__$1;
(statearr_5831_5885[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (36))){
var inst_5757 = (state_5807[(12)]);
var inst_5734 = inst_5757;
var state_5807__$1 = (function (){var statearr_5832 = state_5807;
(statearr_5832[(7)] = inst_5734);

return statearr_5832;
})();
var statearr_5833_5886 = state_5807__$1;
(statearr_5833_5886[(2)] = null);

(statearr_5833_5886[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (29))){
var inst_5781 = (state_5807[(10)]);
var state_5807__$1 = state_5807;
var statearr_5834_5887 = state_5807__$1;
(statearr_5834_5887[(2)] = inst_5781);

(statearr_5834_5887[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (6))){
var state_5807__$1 = state_5807;
var statearr_5835_5888 = state_5807__$1;
(statearr_5835_5888[(2)] = false);

(statearr_5835_5888[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (28))){
var inst_5777 = (state_5807[(2)]);
var inst_5778 = calc_state.call(null);
var inst_5734 = inst_5778;
var state_5807__$1 = (function (){var statearr_5836 = state_5807;
(statearr_5836[(7)] = inst_5734);

(statearr_5836[(15)] = inst_5777);

return statearr_5836;
})();
var statearr_5837_5889 = state_5807__$1;
(statearr_5837_5889[(2)] = null);

(statearr_5837_5889[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (25))){
var inst_5803 = (state_5807[(2)]);
var state_5807__$1 = state_5807;
var statearr_5838_5890 = state_5807__$1;
(statearr_5838_5890[(2)] = inst_5803);

(statearr_5838_5890[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (34))){
var inst_5801 = (state_5807[(2)]);
var state_5807__$1 = state_5807;
var statearr_5839_5891 = state_5807__$1;
(statearr_5839_5891[(2)] = inst_5801);

(statearr_5839_5891[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (17))){
var state_5807__$1 = state_5807;
var statearr_5840_5892 = state_5807__$1;
(statearr_5840_5892[(2)] = false);

(statearr_5840_5892[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (3))){
var state_5807__$1 = state_5807;
var statearr_5841_5893 = state_5807__$1;
(statearr_5841_5893[(2)] = false);

(statearr_5841_5893[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (12))){
var inst_5805 = (state_5807[(2)]);
var state_5807__$1 = state_5807;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5807__$1,inst_5805);
} else {
if((state_val_5808 === (2))){
var inst_5709 = (state_5807[(8)]);
var inst_5714 = inst_5709.cljs$lang$protocol_mask$partition0$;
var inst_5715 = (inst_5714 & (64));
var inst_5716 = inst_5709.cljs$core$ISeq$;
var inst_5717 = (cljs.core.PROTOCOL_SENTINEL === inst_5716);
var inst_5718 = ((inst_5715) || (inst_5717));
var state_5807__$1 = state_5807;
if(cljs.core.truth_(inst_5718)){
var statearr_5842_5894 = state_5807__$1;
(statearr_5842_5894[(1)] = (5));

} else {
var statearr_5843_5895 = state_5807__$1;
(statearr_5843_5895[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (23))){
var inst_5766 = (state_5807[(14)]);
var inst_5772 = (inst_5766 == null);
var state_5807__$1 = state_5807;
if(cljs.core.truth_(inst_5772)){
var statearr_5844_5896 = state_5807__$1;
(statearr_5844_5896[(1)] = (26));

} else {
var statearr_5845_5897 = state_5807__$1;
(statearr_5845_5897[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (35))){
var inst_5792 = (state_5807[(2)]);
var state_5807__$1 = state_5807;
if(cljs.core.truth_(inst_5792)){
var statearr_5846_5898 = state_5807__$1;
(statearr_5846_5898[(1)] = (36));

} else {
var statearr_5847_5899 = state_5807__$1;
(statearr_5847_5899[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (19))){
var inst_5734 = (state_5807[(7)]);
var inst_5754 = cljs.core.apply.call(null,cljs.core.hash_map,inst_5734);
var state_5807__$1 = state_5807;
var statearr_5848_5900 = state_5807__$1;
(statearr_5848_5900[(2)] = inst_5754);

(statearr_5848_5900[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (11))){
var inst_5734 = (state_5807[(7)]);
var inst_5738 = (inst_5734 == null);
var inst_5739 = cljs.core.not.call(null,inst_5738);
var state_5807__$1 = state_5807;
if(inst_5739){
var statearr_5849_5901 = state_5807__$1;
(statearr_5849_5901[(1)] = (13));

} else {
var statearr_5850_5902 = state_5807__$1;
(statearr_5850_5902[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (9))){
var inst_5709 = (state_5807[(8)]);
var state_5807__$1 = state_5807;
var statearr_5851_5903 = state_5807__$1;
(statearr_5851_5903[(2)] = inst_5709);

(statearr_5851_5903[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (5))){
var state_5807__$1 = state_5807;
var statearr_5852_5904 = state_5807__$1;
(statearr_5852_5904[(2)] = true);

(statearr_5852_5904[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (14))){
var state_5807__$1 = state_5807;
var statearr_5853_5905 = state_5807__$1;
(statearr_5853_5905[(2)] = false);

(statearr_5853_5905[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (26))){
var inst_5767 = (state_5807[(11)]);
var inst_5774 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_5767);
var state_5807__$1 = state_5807;
var statearr_5854_5906 = state_5807__$1;
(statearr_5854_5906[(2)] = inst_5774);

(statearr_5854_5906[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (16))){
var state_5807__$1 = state_5807;
var statearr_5855_5907 = state_5807__$1;
(statearr_5855_5907[(2)] = true);

(statearr_5855_5907[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (38))){
var inst_5797 = (state_5807[(2)]);
var state_5807__$1 = state_5807;
var statearr_5856_5908 = state_5807__$1;
(statearr_5856_5908[(2)] = inst_5797);

(statearr_5856_5908[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (30))){
var inst_5758 = (state_5807[(9)]);
var inst_5767 = (state_5807[(11)]);
var inst_5759 = (state_5807[(13)]);
var inst_5784 = cljs.core.empty_QMARK_.call(null,inst_5758);
var inst_5785 = inst_5759.call(null,inst_5767);
var inst_5786 = cljs.core.not.call(null,inst_5785);
var inst_5787 = ((inst_5784) && (inst_5786));
var state_5807__$1 = state_5807;
var statearr_5857_5909 = state_5807__$1;
(statearr_5857_5909[(2)] = inst_5787);

(statearr_5857_5909[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (10))){
var inst_5709 = (state_5807[(8)]);
var inst_5730 = (state_5807[(2)]);
var inst_5731 = cljs.core.get.call(null,inst_5730,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_5732 = cljs.core.get.call(null,inst_5730,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_5733 = cljs.core.get.call(null,inst_5730,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_5734 = inst_5709;
var state_5807__$1 = (function (){var statearr_5858 = state_5807;
(statearr_5858[(16)] = inst_5731);

(statearr_5858[(7)] = inst_5734);

(statearr_5858[(17)] = inst_5732);

(statearr_5858[(18)] = inst_5733);

return statearr_5858;
})();
var statearr_5859_5910 = state_5807__$1;
(statearr_5859_5910[(2)] = null);

(statearr_5859_5910[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (18))){
var inst_5749 = (state_5807[(2)]);
var state_5807__$1 = state_5807;
var statearr_5860_5911 = state_5807__$1;
(statearr_5860_5911[(2)] = inst_5749);

(statearr_5860_5911[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (37))){
var state_5807__$1 = state_5807;
var statearr_5861_5912 = state_5807__$1;
(statearr_5861_5912[(2)] = null);

(statearr_5861_5912[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5808 === (8))){
var inst_5709 = (state_5807[(8)]);
var inst_5727 = cljs.core.apply.call(null,cljs.core.hash_map,inst_5709);
var state_5807__$1 = state_5807;
var statearr_5862_5913 = state_5807__$1;
(statearr_5862_5913[(2)] = inst_5727);

(statearr_5862_5913[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___5867,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__4714__auto__,c__4809__auto___5867,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__4715__auto__ = null;
var cljs$core$async$mix_$_state_machine__4715__auto____0 = (function (){
var statearr_5863 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_5863[(0)] = cljs$core$async$mix_$_state_machine__4715__auto__);

(statearr_5863[(1)] = (1));

return statearr_5863;
});
var cljs$core$async$mix_$_state_machine__4715__auto____1 = (function (state_5807){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_5807);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e5864){if((e5864 instanceof Object)){
var ex__4718__auto__ = e5864;
var statearr_5865_5914 = state_5807;
(statearr_5865_5914[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5807);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e5864;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__5915 = state_5807;
state_5807 = G__5915;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__4715__auto__ = function(state_5807){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__4715__auto____1.call(this,state_5807);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__4715__auto____0;
cljs$core$async$mix_$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__4715__auto____1;
return cljs$core$async$mix_$_state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___5867,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__4811__auto__ = (function (){var statearr_5866 = f__4810__auto__.call(null);
(statearr_5866[(6)] = c__4809__auto___5867);

return statearr_5866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___5867,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__5917 = arguments.length;
switch (G__5917) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__5921 = arguments.length;
switch (G__5921) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__5919_SHARP_){
if(cljs.core.truth_(p1__5919_SHARP_.call(null,topic))){
return p1__5919_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__5919_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async5922 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async5922 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta5923){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta5923 = meta5923;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async5922.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_5924,meta5923__$1){
var self__ = this;
var _5924__$1 = this;
return (new cljs.core.async.t_cljs$core$async5922(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta5923__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async5922.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_5924){
var self__ = this;
var _5924__$1 = this;
return self__.meta5923;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async5922.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5922.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async5922.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async5922.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async5922.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async5922.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async5922.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async5922.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta5923","meta5923",-2109280932,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async5922.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async5922.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async5922";

cljs.core.async.t_cljs$core$async5922.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async5922");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async5922.
 */
cljs.core.async.__GT_t_cljs$core$async5922 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async5922(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta5923){
return (new cljs.core.async.t_cljs$core$async5922(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta5923));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async5922(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__4809__auto___6042 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___6042,mults,ensure_mult,p){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___6042,mults,ensure_mult,p){
return (function (state_5996){
var state_val_5997 = (state_5996[(1)]);
if((state_val_5997 === (7))){
var inst_5992 = (state_5996[(2)]);
var state_5996__$1 = state_5996;
var statearr_5998_6043 = state_5996__$1;
(statearr_5998_6043[(2)] = inst_5992);

(statearr_5998_6043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (20))){
var state_5996__$1 = state_5996;
var statearr_5999_6044 = state_5996__$1;
(statearr_5999_6044[(2)] = null);

(statearr_5999_6044[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (1))){
var state_5996__$1 = state_5996;
var statearr_6000_6045 = state_5996__$1;
(statearr_6000_6045[(2)] = null);

(statearr_6000_6045[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (24))){
var inst_5975 = (state_5996[(7)]);
var inst_5984 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_5975);
var state_5996__$1 = state_5996;
var statearr_6001_6046 = state_5996__$1;
(statearr_6001_6046[(2)] = inst_5984);

(statearr_6001_6046[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (4))){
var inst_5927 = (state_5996[(8)]);
var inst_5927__$1 = (state_5996[(2)]);
var inst_5928 = (inst_5927__$1 == null);
var state_5996__$1 = (function (){var statearr_6002 = state_5996;
(statearr_6002[(8)] = inst_5927__$1);

return statearr_6002;
})();
if(cljs.core.truth_(inst_5928)){
var statearr_6003_6047 = state_5996__$1;
(statearr_6003_6047[(1)] = (5));

} else {
var statearr_6004_6048 = state_5996__$1;
(statearr_6004_6048[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (15))){
var inst_5969 = (state_5996[(2)]);
var state_5996__$1 = state_5996;
var statearr_6005_6049 = state_5996__$1;
(statearr_6005_6049[(2)] = inst_5969);

(statearr_6005_6049[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (21))){
var inst_5989 = (state_5996[(2)]);
var state_5996__$1 = (function (){var statearr_6006 = state_5996;
(statearr_6006[(9)] = inst_5989);

return statearr_6006;
})();
var statearr_6007_6050 = state_5996__$1;
(statearr_6007_6050[(2)] = null);

(statearr_6007_6050[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (13))){
var inst_5951 = (state_5996[(10)]);
var inst_5953 = cljs.core.chunked_seq_QMARK_.call(null,inst_5951);
var state_5996__$1 = state_5996;
if(inst_5953){
var statearr_6008_6051 = state_5996__$1;
(statearr_6008_6051[(1)] = (16));

} else {
var statearr_6009_6052 = state_5996__$1;
(statearr_6009_6052[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (22))){
var inst_5981 = (state_5996[(2)]);
var state_5996__$1 = state_5996;
if(cljs.core.truth_(inst_5981)){
var statearr_6010_6053 = state_5996__$1;
(statearr_6010_6053[(1)] = (23));

} else {
var statearr_6011_6054 = state_5996__$1;
(statearr_6011_6054[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (6))){
var inst_5977 = (state_5996[(11)]);
var inst_5927 = (state_5996[(8)]);
var inst_5975 = (state_5996[(7)]);
var inst_5975__$1 = topic_fn.call(null,inst_5927);
var inst_5976 = cljs.core.deref.call(null,mults);
var inst_5977__$1 = cljs.core.get.call(null,inst_5976,inst_5975__$1);
var state_5996__$1 = (function (){var statearr_6012 = state_5996;
(statearr_6012[(11)] = inst_5977__$1);

(statearr_6012[(7)] = inst_5975__$1);

return statearr_6012;
})();
if(cljs.core.truth_(inst_5977__$1)){
var statearr_6013_6055 = state_5996__$1;
(statearr_6013_6055[(1)] = (19));

} else {
var statearr_6014_6056 = state_5996__$1;
(statearr_6014_6056[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (25))){
var inst_5986 = (state_5996[(2)]);
var state_5996__$1 = state_5996;
var statearr_6015_6057 = state_5996__$1;
(statearr_6015_6057[(2)] = inst_5986);

(statearr_6015_6057[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (17))){
var inst_5951 = (state_5996[(10)]);
var inst_5960 = cljs.core.first.call(null,inst_5951);
var inst_5961 = cljs.core.async.muxch_STAR_.call(null,inst_5960);
var inst_5962 = cljs.core.async.close_BANG_.call(null,inst_5961);
var inst_5963 = cljs.core.next.call(null,inst_5951);
var inst_5937 = inst_5963;
var inst_5938 = null;
var inst_5939 = (0);
var inst_5940 = (0);
var state_5996__$1 = (function (){var statearr_6016 = state_5996;
(statearr_6016[(12)] = inst_5938);

(statearr_6016[(13)] = inst_5940);

(statearr_6016[(14)] = inst_5962);

(statearr_6016[(15)] = inst_5939);

(statearr_6016[(16)] = inst_5937);

return statearr_6016;
})();
var statearr_6017_6058 = state_5996__$1;
(statearr_6017_6058[(2)] = null);

(statearr_6017_6058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (3))){
var inst_5994 = (state_5996[(2)]);
var state_5996__$1 = state_5996;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_5996__$1,inst_5994);
} else {
if((state_val_5997 === (12))){
var inst_5971 = (state_5996[(2)]);
var state_5996__$1 = state_5996;
var statearr_6018_6059 = state_5996__$1;
(statearr_6018_6059[(2)] = inst_5971);

(statearr_6018_6059[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (2))){
var state_5996__$1 = state_5996;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_5996__$1,(4),ch);
} else {
if((state_val_5997 === (23))){
var state_5996__$1 = state_5996;
var statearr_6019_6060 = state_5996__$1;
(statearr_6019_6060[(2)] = null);

(statearr_6019_6060[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (19))){
var inst_5977 = (state_5996[(11)]);
var inst_5927 = (state_5996[(8)]);
var inst_5979 = cljs.core.async.muxch_STAR_.call(null,inst_5977);
var state_5996__$1 = state_5996;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_5996__$1,(22),inst_5979,inst_5927);
} else {
if((state_val_5997 === (11))){
var inst_5951 = (state_5996[(10)]);
var inst_5937 = (state_5996[(16)]);
var inst_5951__$1 = cljs.core.seq.call(null,inst_5937);
var state_5996__$1 = (function (){var statearr_6020 = state_5996;
(statearr_6020[(10)] = inst_5951__$1);

return statearr_6020;
})();
if(inst_5951__$1){
var statearr_6021_6061 = state_5996__$1;
(statearr_6021_6061[(1)] = (13));

} else {
var statearr_6022_6062 = state_5996__$1;
(statearr_6022_6062[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (9))){
var inst_5973 = (state_5996[(2)]);
var state_5996__$1 = state_5996;
var statearr_6023_6063 = state_5996__$1;
(statearr_6023_6063[(2)] = inst_5973);

(statearr_6023_6063[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (5))){
var inst_5934 = cljs.core.deref.call(null,mults);
var inst_5935 = cljs.core.vals.call(null,inst_5934);
var inst_5936 = cljs.core.seq.call(null,inst_5935);
var inst_5937 = inst_5936;
var inst_5938 = null;
var inst_5939 = (0);
var inst_5940 = (0);
var state_5996__$1 = (function (){var statearr_6024 = state_5996;
(statearr_6024[(12)] = inst_5938);

(statearr_6024[(13)] = inst_5940);

(statearr_6024[(15)] = inst_5939);

(statearr_6024[(16)] = inst_5937);

return statearr_6024;
})();
var statearr_6025_6064 = state_5996__$1;
(statearr_6025_6064[(2)] = null);

(statearr_6025_6064[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (14))){
var state_5996__$1 = state_5996;
var statearr_6029_6065 = state_5996__$1;
(statearr_6029_6065[(2)] = null);

(statearr_6029_6065[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (16))){
var inst_5951 = (state_5996[(10)]);
var inst_5955 = cljs.core.chunk_first.call(null,inst_5951);
var inst_5956 = cljs.core.chunk_rest.call(null,inst_5951);
var inst_5957 = cljs.core.count.call(null,inst_5955);
var inst_5937 = inst_5956;
var inst_5938 = inst_5955;
var inst_5939 = inst_5957;
var inst_5940 = (0);
var state_5996__$1 = (function (){var statearr_6030 = state_5996;
(statearr_6030[(12)] = inst_5938);

(statearr_6030[(13)] = inst_5940);

(statearr_6030[(15)] = inst_5939);

(statearr_6030[(16)] = inst_5937);

return statearr_6030;
})();
var statearr_6031_6066 = state_5996__$1;
(statearr_6031_6066[(2)] = null);

(statearr_6031_6066[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (10))){
var inst_5938 = (state_5996[(12)]);
var inst_5940 = (state_5996[(13)]);
var inst_5939 = (state_5996[(15)]);
var inst_5937 = (state_5996[(16)]);
var inst_5945 = cljs.core._nth.call(null,inst_5938,inst_5940);
var inst_5946 = cljs.core.async.muxch_STAR_.call(null,inst_5945);
var inst_5947 = cljs.core.async.close_BANG_.call(null,inst_5946);
var inst_5948 = (inst_5940 + (1));
var tmp6026 = inst_5938;
var tmp6027 = inst_5939;
var tmp6028 = inst_5937;
var inst_5937__$1 = tmp6028;
var inst_5938__$1 = tmp6026;
var inst_5939__$1 = tmp6027;
var inst_5940__$1 = inst_5948;
var state_5996__$1 = (function (){var statearr_6032 = state_5996;
(statearr_6032[(17)] = inst_5947);

(statearr_6032[(12)] = inst_5938__$1);

(statearr_6032[(13)] = inst_5940__$1);

(statearr_6032[(15)] = inst_5939__$1);

(statearr_6032[(16)] = inst_5937__$1);

return statearr_6032;
})();
var statearr_6033_6067 = state_5996__$1;
(statearr_6033_6067[(2)] = null);

(statearr_6033_6067[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (18))){
var inst_5966 = (state_5996[(2)]);
var state_5996__$1 = state_5996;
var statearr_6034_6068 = state_5996__$1;
(statearr_6034_6068[(2)] = inst_5966);

(statearr_6034_6068[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_5997 === (8))){
var inst_5940 = (state_5996[(13)]);
var inst_5939 = (state_5996[(15)]);
var inst_5942 = (inst_5940 < inst_5939);
var inst_5943 = inst_5942;
var state_5996__$1 = state_5996;
if(cljs.core.truth_(inst_5943)){
var statearr_6035_6069 = state_5996__$1;
(statearr_6035_6069[(1)] = (10));

} else {
var statearr_6036_6070 = state_5996__$1;
(statearr_6036_6070[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___6042,mults,ensure_mult,p))
;
return ((function (switch__4714__auto__,c__4809__auto___6042,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__4715__auto__ = null;
var cljs$core$async$state_machine__4715__auto____0 = (function (){
var statearr_6037 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_6037[(0)] = cljs$core$async$state_machine__4715__auto__);

(statearr_6037[(1)] = (1));

return statearr_6037;
});
var cljs$core$async$state_machine__4715__auto____1 = (function (state_5996){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_5996);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e6038){if((e6038 instanceof Object)){
var ex__4718__auto__ = e6038;
var statearr_6039_6071 = state_5996;
(statearr_6039_6071[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_5996);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6038;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6072 = state_5996;
state_5996 = G__6072;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$state_machine__4715__auto__ = function(state_5996){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__4715__auto____1.call(this,state_5996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__4715__auto____0;
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__4715__auto____1;
return cljs$core$async$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___6042,mults,ensure_mult,p))
})();
var state__4811__auto__ = (function (){var statearr_6040 = f__4810__auto__.call(null);
(statearr_6040[(6)] = c__4809__auto___6042);

return statearr_6040;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___6042,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__6074 = arguments.length;
switch (G__6074) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__6077 = arguments.length;
switch (G__6077) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__6080 = arguments.length;
switch (G__6080) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__4809__auto___6147 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___6147,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___6147,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_6119){
var state_val_6120 = (state_6119[(1)]);
if((state_val_6120 === (7))){
var state_6119__$1 = state_6119;
var statearr_6121_6148 = state_6119__$1;
(statearr_6121_6148[(2)] = null);

(statearr_6121_6148[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (1))){
var state_6119__$1 = state_6119;
var statearr_6122_6149 = state_6119__$1;
(statearr_6122_6149[(2)] = null);

(statearr_6122_6149[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (4))){
var inst_6083 = (state_6119[(7)]);
var inst_6085 = (inst_6083 < cnt);
var state_6119__$1 = state_6119;
if(cljs.core.truth_(inst_6085)){
var statearr_6123_6150 = state_6119__$1;
(statearr_6123_6150[(1)] = (6));

} else {
var statearr_6124_6151 = state_6119__$1;
(statearr_6124_6151[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (15))){
var inst_6115 = (state_6119[(2)]);
var state_6119__$1 = state_6119;
var statearr_6125_6152 = state_6119__$1;
(statearr_6125_6152[(2)] = inst_6115);

(statearr_6125_6152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (13))){
var inst_6108 = cljs.core.async.close_BANG_.call(null,out);
var state_6119__$1 = state_6119;
var statearr_6126_6153 = state_6119__$1;
(statearr_6126_6153[(2)] = inst_6108);

(statearr_6126_6153[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (6))){
var state_6119__$1 = state_6119;
var statearr_6127_6154 = state_6119__$1;
(statearr_6127_6154[(2)] = null);

(statearr_6127_6154[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (3))){
var inst_6117 = (state_6119[(2)]);
var state_6119__$1 = state_6119;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_6119__$1,inst_6117);
} else {
if((state_val_6120 === (12))){
var inst_6105 = (state_6119[(8)]);
var inst_6105__$1 = (state_6119[(2)]);
var inst_6106 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_6105__$1);
var state_6119__$1 = (function (){var statearr_6128 = state_6119;
(statearr_6128[(8)] = inst_6105__$1);

return statearr_6128;
})();
if(cljs.core.truth_(inst_6106)){
var statearr_6129_6155 = state_6119__$1;
(statearr_6129_6155[(1)] = (13));

} else {
var statearr_6130_6156 = state_6119__$1;
(statearr_6130_6156[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (2))){
var inst_6082 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_6083 = (0);
var state_6119__$1 = (function (){var statearr_6131 = state_6119;
(statearr_6131[(9)] = inst_6082);

(statearr_6131[(7)] = inst_6083);

return statearr_6131;
})();
var statearr_6132_6157 = state_6119__$1;
(statearr_6132_6157[(2)] = null);

(statearr_6132_6157[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (11))){
var inst_6083 = (state_6119[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_6119,(10),Object,null,(9));
var inst_6092 = chs__$1.call(null,inst_6083);
var inst_6093 = done.call(null,inst_6083);
var inst_6094 = cljs.core.async.take_BANG_.call(null,inst_6092,inst_6093);
var state_6119__$1 = state_6119;
var statearr_6133_6158 = state_6119__$1;
(statearr_6133_6158[(2)] = inst_6094);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_6119__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (9))){
var inst_6083 = (state_6119[(7)]);
var inst_6096 = (state_6119[(2)]);
var inst_6097 = (inst_6083 + (1));
var inst_6083__$1 = inst_6097;
var state_6119__$1 = (function (){var statearr_6134 = state_6119;
(statearr_6134[(10)] = inst_6096);

(statearr_6134[(7)] = inst_6083__$1);

return statearr_6134;
})();
var statearr_6135_6159 = state_6119__$1;
(statearr_6135_6159[(2)] = null);

(statearr_6135_6159[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (5))){
var inst_6103 = (state_6119[(2)]);
var state_6119__$1 = (function (){var statearr_6136 = state_6119;
(statearr_6136[(11)] = inst_6103);

return statearr_6136;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_6119__$1,(12),dchan);
} else {
if((state_val_6120 === (14))){
var inst_6105 = (state_6119[(8)]);
var inst_6110 = cljs.core.apply.call(null,f,inst_6105);
var state_6119__$1 = state_6119;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_6119__$1,(16),out,inst_6110);
} else {
if((state_val_6120 === (16))){
var inst_6112 = (state_6119[(2)]);
var state_6119__$1 = (function (){var statearr_6137 = state_6119;
(statearr_6137[(12)] = inst_6112);

return statearr_6137;
})();
var statearr_6138_6160 = state_6119__$1;
(statearr_6138_6160[(2)] = null);

(statearr_6138_6160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (10))){
var inst_6087 = (state_6119[(2)]);
var inst_6088 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_6119__$1 = (function (){var statearr_6139 = state_6119;
(statearr_6139[(13)] = inst_6087);

return statearr_6139;
})();
var statearr_6140_6161 = state_6119__$1;
(statearr_6140_6161[(2)] = inst_6088);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_6119__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6120 === (8))){
var inst_6101 = (state_6119[(2)]);
var state_6119__$1 = state_6119;
var statearr_6141_6162 = state_6119__$1;
(statearr_6141_6162[(2)] = inst_6101);

(statearr_6141_6162[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___6147,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__4714__auto__,c__4809__auto___6147,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__4715__auto__ = null;
var cljs$core$async$state_machine__4715__auto____0 = (function (){
var statearr_6142 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_6142[(0)] = cljs$core$async$state_machine__4715__auto__);

(statearr_6142[(1)] = (1));

return statearr_6142;
});
var cljs$core$async$state_machine__4715__auto____1 = (function (state_6119){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_6119);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e6143){if((e6143 instanceof Object)){
var ex__4718__auto__ = e6143;
var statearr_6144_6163 = state_6119;
(statearr_6144_6163[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_6119);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6143;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6164 = state_6119;
state_6119 = G__6164;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$state_machine__4715__auto__ = function(state_6119){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__4715__auto____1.call(this,state_6119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__4715__auto____0;
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__4715__auto____1;
return cljs$core$async$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___6147,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__4811__auto__ = (function (){var statearr_6145 = f__4810__auto__.call(null);
(statearr_6145[(6)] = c__4809__auto___6147);

return statearr_6145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___6147,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__6167 = arguments.length;
switch (G__6167) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__4809__auto___6221 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___6221,out){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___6221,out){
return (function (state_6199){
var state_val_6200 = (state_6199[(1)]);
if((state_val_6200 === (7))){
var inst_6179 = (state_6199[(7)]);
var inst_6178 = (state_6199[(8)]);
var inst_6178__$1 = (state_6199[(2)]);
var inst_6179__$1 = cljs.core.nth.call(null,inst_6178__$1,(0),null);
var inst_6180 = cljs.core.nth.call(null,inst_6178__$1,(1),null);
var inst_6181 = (inst_6179__$1 == null);
var state_6199__$1 = (function (){var statearr_6201 = state_6199;
(statearr_6201[(9)] = inst_6180);

(statearr_6201[(7)] = inst_6179__$1);

(statearr_6201[(8)] = inst_6178__$1);

return statearr_6201;
})();
if(cljs.core.truth_(inst_6181)){
var statearr_6202_6222 = state_6199__$1;
(statearr_6202_6222[(1)] = (8));

} else {
var statearr_6203_6223 = state_6199__$1;
(statearr_6203_6223[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6200 === (1))){
var inst_6168 = cljs.core.vec.call(null,chs);
var inst_6169 = inst_6168;
var state_6199__$1 = (function (){var statearr_6204 = state_6199;
(statearr_6204[(10)] = inst_6169);

return statearr_6204;
})();
var statearr_6205_6224 = state_6199__$1;
(statearr_6205_6224[(2)] = null);

(statearr_6205_6224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6200 === (4))){
var inst_6169 = (state_6199[(10)]);
var state_6199__$1 = state_6199;
return cljs.core.async.ioc_alts_BANG_.call(null,state_6199__$1,(7),inst_6169);
} else {
if((state_val_6200 === (6))){
var inst_6195 = (state_6199[(2)]);
var state_6199__$1 = state_6199;
var statearr_6206_6225 = state_6199__$1;
(statearr_6206_6225[(2)] = inst_6195);

(statearr_6206_6225[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6200 === (3))){
var inst_6197 = (state_6199[(2)]);
var state_6199__$1 = state_6199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_6199__$1,inst_6197);
} else {
if((state_val_6200 === (2))){
var inst_6169 = (state_6199[(10)]);
var inst_6171 = cljs.core.count.call(null,inst_6169);
var inst_6172 = (inst_6171 > (0));
var state_6199__$1 = state_6199;
if(cljs.core.truth_(inst_6172)){
var statearr_6208_6226 = state_6199__$1;
(statearr_6208_6226[(1)] = (4));

} else {
var statearr_6209_6227 = state_6199__$1;
(statearr_6209_6227[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6200 === (11))){
var inst_6169 = (state_6199[(10)]);
var inst_6188 = (state_6199[(2)]);
var tmp6207 = inst_6169;
var inst_6169__$1 = tmp6207;
var state_6199__$1 = (function (){var statearr_6210 = state_6199;
(statearr_6210[(11)] = inst_6188);

(statearr_6210[(10)] = inst_6169__$1);

return statearr_6210;
})();
var statearr_6211_6228 = state_6199__$1;
(statearr_6211_6228[(2)] = null);

(statearr_6211_6228[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6200 === (9))){
var inst_6179 = (state_6199[(7)]);
var state_6199__$1 = state_6199;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_6199__$1,(11),out,inst_6179);
} else {
if((state_val_6200 === (5))){
var inst_6193 = cljs.core.async.close_BANG_.call(null,out);
var state_6199__$1 = state_6199;
var statearr_6212_6229 = state_6199__$1;
(statearr_6212_6229[(2)] = inst_6193);

(statearr_6212_6229[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6200 === (10))){
var inst_6191 = (state_6199[(2)]);
var state_6199__$1 = state_6199;
var statearr_6213_6230 = state_6199__$1;
(statearr_6213_6230[(2)] = inst_6191);

(statearr_6213_6230[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6200 === (8))){
var inst_6180 = (state_6199[(9)]);
var inst_6169 = (state_6199[(10)]);
var inst_6179 = (state_6199[(7)]);
var inst_6178 = (state_6199[(8)]);
var inst_6183 = (function (){var cs = inst_6169;
var vec__6174 = inst_6178;
var v = inst_6179;
var c = inst_6180;
return ((function (cs,vec__6174,v,c,inst_6180,inst_6169,inst_6179,inst_6178,state_val_6200,c__4809__auto___6221,out){
return (function (p1__6165_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__6165_SHARP_);
});
;})(cs,vec__6174,v,c,inst_6180,inst_6169,inst_6179,inst_6178,state_val_6200,c__4809__auto___6221,out))
})();
var inst_6184 = cljs.core.filterv.call(null,inst_6183,inst_6169);
var inst_6169__$1 = inst_6184;
var state_6199__$1 = (function (){var statearr_6214 = state_6199;
(statearr_6214[(10)] = inst_6169__$1);

return statearr_6214;
})();
var statearr_6215_6231 = state_6199__$1;
(statearr_6215_6231[(2)] = null);

(statearr_6215_6231[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___6221,out))
;
return ((function (switch__4714__auto__,c__4809__auto___6221,out){
return (function() {
var cljs$core$async$state_machine__4715__auto__ = null;
var cljs$core$async$state_machine__4715__auto____0 = (function (){
var statearr_6216 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_6216[(0)] = cljs$core$async$state_machine__4715__auto__);

(statearr_6216[(1)] = (1));

return statearr_6216;
});
var cljs$core$async$state_machine__4715__auto____1 = (function (state_6199){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_6199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e6217){if((e6217 instanceof Object)){
var ex__4718__auto__ = e6217;
var statearr_6218_6232 = state_6199;
(statearr_6218_6232[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_6199);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6217;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6233 = state_6199;
state_6199 = G__6233;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$state_machine__4715__auto__ = function(state_6199){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__4715__auto____1.call(this,state_6199);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__4715__auto____0;
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__4715__auto____1;
return cljs$core$async$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___6221,out))
})();
var state__4811__auto__ = (function (){var statearr_6219 = f__4810__auto__.call(null);
(statearr_6219[(6)] = c__4809__auto___6221);

return statearr_6219;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___6221,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__6235 = arguments.length;
switch (G__6235) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__4809__auto___6280 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___6280,out){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___6280,out){
return (function (state_6259){
var state_val_6260 = (state_6259[(1)]);
if((state_val_6260 === (7))){
var inst_6241 = (state_6259[(7)]);
var inst_6241__$1 = (state_6259[(2)]);
var inst_6242 = (inst_6241__$1 == null);
var inst_6243 = cljs.core.not.call(null,inst_6242);
var state_6259__$1 = (function (){var statearr_6261 = state_6259;
(statearr_6261[(7)] = inst_6241__$1);

return statearr_6261;
})();
if(inst_6243){
var statearr_6262_6281 = state_6259__$1;
(statearr_6262_6281[(1)] = (8));

} else {
var statearr_6263_6282 = state_6259__$1;
(statearr_6263_6282[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6260 === (1))){
var inst_6236 = (0);
var state_6259__$1 = (function (){var statearr_6264 = state_6259;
(statearr_6264[(8)] = inst_6236);

return statearr_6264;
})();
var statearr_6265_6283 = state_6259__$1;
(statearr_6265_6283[(2)] = null);

(statearr_6265_6283[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6260 === (4))){
var state_6259__$1 = state_6259;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_6259__$1,(7),ch);
} else {
if((state_val_6260 === (6))){
var inst_6254 = (state_6259[(2)]);
var state_6259__$1 = state_6259;
var statearr_6266_6284 = state_6259__$1;
(statearr_6266_6284[(2)] = inst_6254);

(statearr_6266_6284[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6260 === (3))){
var inst_6256 = (state_6259[(2)]);
var inst_6257 = cljs.core.async.close_BANG_.call(null,out);
var state_6259__$1 = (function (){var statearr_6267 = state_6259;
(statearr_6267[(9)] = inst_6256);

return statearr_6267;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_6259__$1,inst_6257);
} else {
if((state_val_6260 === (2))){
var inst_6236 = (state_6259[(8)]);
var inst_6238 = (inst_6236 < n);
var state_6259__$1 = state_6259;
if(cljs.core.truth_(inst_6238)){
var statearr_6268_6285 = state_6259__$1;
(statearr_6268_6285[(1)] = (4));

} else {
var statearr_6269_6286 = state_6259__$1;
(statearr_6269_6286[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6260 === (11))){
var inst_6236 = (state_6259[(8)]);
var inst_6246 = (state_6259[(2)]);
var inst_6247 = (inst_6236 + (1));
var inst_6236__$1 = inst_6247;
var state_6259__$1 = (function (){var statearr_6270 = state_6259;
(statearr_6270[(8)] = inst_6236__$1);

(statearr_6270[(10)] = inst_6246);

return statearr_6270;
})();
var statearr_6271_6287 = state_6259__$1;
(statearr_6271_6287[(2)] = null);

(statearr_6271_6287[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6260 === (9))){
var state_6259__$1 = state_6259;
var statearr_6272_6288 = state_6259__$1;
(statearr_6272_6288[(2)] = null);

(statearr_6272_6288[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6260 === (5))){
var state_6259__$1 = state_6259;
var statearr_6273_6289 = state_6259__$1;
(statearr_6273_6289[(2)] = null);

(statearr_6273_6289[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6260 === (10))){
var inst_6251 = (state_6259[(2)]);
var state_6259__$1 = state_6259;
var statearr_6274_6290 = state_6259__$1;
(statearr_6274_6290[(2)] = inst_6251);

(statearr_6274_6290[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6260 === (8))){
var inst_6241 = (state_6259[(7)]);
var state_6259__$1 = state_6259;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_6259__$1,(11),out,inst_6241);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___6280,out))
;
return ((function (switch__4714__auto__,c__4809__auto___6280,out){
return (function() {
var cljs$core$async$state_machine__4715__auto__ = null;
var cljs$core$async$state_machine__4715__auto____0 = (function (){
var statearr_6275 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_6275[(0)] = cljs$core$async$state_machine__4715__auto__);

(statearr_6275[(1)] = (1));

return statearr_6275;
});
var cljs$core$async$state_machine__4715__auto____1 = (function (state_6259){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_6259);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e6276){if((e6276 instanceof Object)){
var ex__4718__auto__ = e6276;
var statearr_6277_6291 = state_6259;
(statearr_6277_6291[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_6259);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6276;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6292 = state_6259;
state_6259 = G__6292;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$state_machine__4715__auto__ = function(state_6259){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__4715__auto____1.call(this,state_6259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__4715__auto____0;
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__4715__auto____1;
return cljs$core$async$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___6280,out))
})();
var state__4811__auto__ = (function (){var statearr_6278 = f__4810__auto__.call(null);
(statearr_6278[(6)] = c__4809__auto___6280);

return statearr_6278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___6280,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async6294 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async6294 = (function (f,ch,meta6295){
this.f = f;
this.ch = ch;
this.meta6295 = meta6295;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async6294.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_6296,meta6295__$1){
var self__ = this;
var _6296__$1 = this;
return (new cljs.core.async.t_cljs$core$async6294(self__.f,self__.ch,meta6295__$1));
});

cljs.core.async.t_cljs$core$async6294.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_6296){
var self__ = this;
var _6296__$1 = this;
return self__.meta6295;
});

cljs.core.async.t_cljs$core$async6294.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async6294.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async6294.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async6294.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async6294.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async6297 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async6297 = (function (f,ch,meta6295,_,fn1,meta6298){
this.f = f;
this.ch = ch;
this.meta6295 = meta6295;
this._ = _;
this.fn1 = fn1;
this.meta6298 = meta6298;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async6297.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_6299,meta6298__$1){
var self__ = this;
var _6299__$1 = this;
return (new cljs.core.async.t_cljs$core$async6297(self__.f,self__.ch,self__.meta6295,self__._,self__.fn1,meta6298__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async6297.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_6299){
var self__ = this;
var _6299__$1 = this;
return self__.meta6298;
});})(___$1))
;

cljs.core.async.t_cljs$core$async6297.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async6297.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async6297.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async6297.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__6293_SHARP_){
return f1.call(null,(((p1__6293_SHARP_ == null))?null:self__.f.call(null,p1__6293_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async6297.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta6295","meta6295",1561046497,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async6294","cljs.core.async/t_cljs$core$async6294",1792147641,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta6298","meta6298",-1931763063,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async6297.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async6297.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async6297";

cljs.core.async.t_cljs$core$async6297.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async6297");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async6297.
 */
cljs.core.async.__GT_t_cljs$core$async6297 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async6297(f__$1,ch__$1,meta6295__$1,___$2,fn1__$1,meta6298){
return (new cljs.core.async.t_cljs$core$async6297(f__$1,ch__$1,meta6295__$1,___$2,fn1__$1,meta6298));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async6297(self__.f,self__.ch,self__.meta6295,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async6294.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async6294.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async6294.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta6295","meta6295",1561046497,null)], null);
});

cljs.core.async.t_cljs$core$async6294.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async6294.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async6294";

cljs.core.async.t_cljs$core$async6294.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async6294");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async6294.
 */
cljs.core.async.__GT_t_cljs$core$async6294 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async6294(f__$1,ch__$1,meta6295){
return (new cljs.core.async.t_cljs$core$async6294(f__$1,ch__$1,meta6295));
});

}

return (new cljs.core.async.t_cljs$core$async6294(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async6300 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async6300 = (function (f,ch,meta6301){
this.f = f;
this.ch = ch;
this.meta6301 = meta6301;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async6300.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_6302,meta6301__$1){
var self__ = this;
var _6302__$1 = this;
return (new cljs.core.async.t_cljs$core$async6300(self__.f,self__.ch,meta6301__$1));
});

cljs.core.async.t_cljs$core$async6300.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_6302){
var self__ = this;
var _6302__$1 = this;
return self__.meta6301;
});

cljs.core.async.t_cljs$core$async6300.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async6300.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async6300.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async6300.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async6300.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async6300.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async6300.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta6301","meta6301",-1930446145,null)], null);
});

cljs.core.async.t_cljs$core$async6300.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async6300.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async6300";

cljs.core.async.t_cljs$core$async6300.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async6300");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async6300.
 */
cljs.core.async.__GT_t_cljs$core$async6300 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async6300(f__$1,ch__$1,meta6301){
return (new cljs.core.async.t_cljs$core$async6300(f__$1,ch__$1,meta6301));
});

}

return (new cljs.core.async.t_cljs$core$async6300(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async6303 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async6303 = (function (p,ch,meta6304){
this.p = p;
this.ch = ch;
this.meta6304 = meta6304;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async6303.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_6305,meta6304__$1){
var self__ = this;
var _6305__$1 = this;
return (new cljs.core.async.t_cljs$core$async6303(self__.p,self__.ch,meta6304__$1));
});

cljs.core.async.t_cljs$core$async6303.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_6305){
var self__ = this;
var _6305__$1 = this;
return self__.meta6304;
});

cljs.core.async.t_cljs$core$async6303.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async6303.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async6303.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async6303.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async6303.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async6303.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async6303.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async6303.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta6304","meta6304",1262829235,null)], null);
});

cljs.core.async.t_cljs$core$async6303.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async6303.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async6303";

cljs.core.async.t_cljs$core$async6303.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async6303");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async6303.
 */
cljs.core.async.__GT_t_cljs$core$async6303 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async6303(p__$1,ch__$1,meta6304){
return (new cljs.core.async.t_cljs$core$async6303(p__$1,ch__$1,meta6304));
});

}

return (new cljs.core.async.t_cljs$core$async6303(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__6307 = arguments.length;
switch (G__6307) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__4809__auto___6347 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___6347,out){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___6347,out){
return (function (state_6328){
var state_val_6329 = (state_6328[(1)]);
if((state_val_6329 === (7))){
var inst_6324 = (state_6328[(2)]);
var state_6328__$1 = state_6328;
var statearr_6330_6348 = state_6328__$1;
(statearr_6330_6348[(2)] = inst_6324);

(statearr_6330_6348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6329 === (1))){
var state_6328__$1 = state_6328;
var statearr_6331_6349 = state_6328__$1;
(statearr_6331_6349[(2)] = null);

(statearr_6331_6349[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6329 === (4))){
var inst_6310 = (state_6328[(7)]);
var inst_6310__$1 = (state_6328[(2)]);
var inst_6311 = (inst_6310__$1 == null);
var state_6328__$1 = (function (){var statearr_6332 = state_6328;
(statearr_6332[(7)] = inst_6310__$1);

return statearr_6332;
})();
if(cljs.core.truth_(inst_6311)){
var statearr_6333_6350 = state_6328__$1;
(statearr_6333_6350[(1)] = (5));

} else {
var statearr_6334_6351 = state_6328__$1;
(statearr_6334_6351[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6329 === (6))){
var inst_6310 = (state_6328[(7)]);
var inst_6315 = p.call(null,inst_6310);
var state_6328__$1 = state_6328;
if(cljs.core.truth_(inst_6315)){
var statearr_6335_6352 = state_6328__$1;
(statearr_6335_6352[(1)] = (8));

} else {
var statearr_6336_6353 = state_6328__$1;
(statearr_6336_6353[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6329 === (3))){
var inst_6326 = (state_6328[(2)]);
var state_6328__$1 = state_6328;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_6328__$1,inst_6326);
} else {
if((state_val_6329 === (2))){
var state_6328__$1 = state_6328;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_6328__$1,(4),ch);
} else {
if((state_val_6329 === (11))){
var inst_6318 = (state_6328[(2)]);
var state_6328__$1 = state_6328;
var statearr_6337_6354 = state_6328__$1;
(statearr_6337_6354[(2)] = inst_6318);

(statearr_6337_6354[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6329 === (9))){
var state_6328__$1 = state_6328;
var statearr_6338_6355 = state_6328__$1;
(statearr_6338_6355[(2)] = null);

(statearr_6338_6355[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6329 === (5))){
var inst_6313 = cljs.core.async.close_BANG_.call(null,out);
var state_6328__$1 = state_6328;
var statearr_6339_6356 = state_6328__$1;
(statearr_6339_6356[(2)] = inst_6313);

(statearr_6339_6356[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6329 === (10))){
var inst_6321 = (state_6328[(2)]);
var state_6328__$1 = (function (){var statearr_6340 = state_6328;
(statearr_6340[(8)] = inst_6321);

return statearr_6340;
})();
var statearr_6341_6357 = state_6328__$1;
(statearr_6341_6357[(2)] = null);

(statearr_6341_6357[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6329 === (8))){
var inst_6310 = (state_6328[(7)]);
var state_6328__$1 = state_6328;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_6328__$1,(11),out,inst_6310);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___6347,out))
;
return ((function (switch__4714__auto__,c__4809__auto___6347,out){
return (function() {
var cljs$core$async$state_machine__4715__auto__ = null;
var cljs$core$async$state_machine__4715__auto____0 = (function (){
var statearr_6342 = [null,null,null,null,null,null,null,null,null];
(statearr_6342[(0)] = cljs$core$async$state_machine__4715__auto__);

(statearr_6342[(1)] = (1));

return statearr_6342;
});
var cljs$core$async$state_machine__4715__auto____1 = (function (state_6328){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_6328);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e6343){if((e6343 instanceof Object)){
var ex__4718__auto__ = e6343;
var statearr_6344_6358 = state_6328;
(statearr_6344_6358[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_6328);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6343;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6359 = state_6328;
state_6328 = G__6359;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$state_machine__4715__auto__ = function(state_6328){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__4715__auto____1.call(this,state_6328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__4715__auto____0;
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__4715__auto____1;
return cljs$core$async$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___6347,out))
})();
var state__4811__auto__ = (function (){var statearr_6345 = f__4810__auto__.call(null);
(statearr_6345[(6)] = c__4809__auto___6347);

return statearr_6345;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___6347,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__6361 = arguments.length;
switch (G__6361) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__4809__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto__){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto__){
return (function (state_6424){
var state_val_6425 = (state_6424[(1)]);
if((state_val_6425 === (7))){
var inst_6420 = (state_6424[(2)]);
var state_6424__$1 = state_6424;
var statearr_6426_6464 = state_6424__$1;
(statearr_6426_6464[(2)] = inst_6420);

(statearr_6426_6464[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (20))){
var inst_6390 = (state_6424[(7)]);
var inst_6401 = (state_6424[(2)]);
var inst_6402 = cljs.core.next.call(null,inst_6390);
var inst_6376 = inst_6402;
var inst_6377 = null;
var inst_6378 = (0);
var inst_6379 = (0);
var state_6424__$1 = (function (){var statearr_6427 = state_6424;
(statearr_6427[(8)] = inst_6379);

(statearr_6427[(9)] = inst_6376);

(statearr_6427[(10)] = inst_6377);

(statearr_6427[(11)] = inst_6378);

(statearr_6427[(12)] = inst_6401);

return statearr_6427;
})();
var statearr_6428_6465 = state_6424__$1;
(statearr_6428_6465[(2)] = null);

(statearr_6428_6465[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (1))){
var state_6424__$1 = state_6424;
var statearr_6429_6466 = state_6424__$1;
(statearr_6429_6466[(2)] = null);

(statearr_6429_6466[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (4))){
var inst_6365 = (state_6424[(13)]);
var inst_6365__$1 = (state_6424[(2)]);
var inst_6366 = (inst_6365__$1 == null);
var state_6424__$1 = (function (){var statearr_6430 = state_6424;
(statearr_6430[(13)] = inst_6365__$1);

return statearr_6430;
})();
if(cljs.core.truth_(inst_6366)){
var statearr_6431_6467 = state_6424__$1;
(statearr_6431_6467[(1)] = (5));

} else {
var statearr_6432_6468 = state_6424__$1;
(statearr_6432_6468[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (15))){
var state_6424__$1 = state_6424;
var statearr_6436_6469 = state_6424__$1;
(statearr_6436_6469[(2)] = null);

(statearr_6436_6469[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (21))){
var state_6424__$1 = state_6424;
var statearr_6437_6470 = state_6424__$1;
(statearr_6437_6470[(2)] = null);

(statearr_6437_6470[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (13))){
var inst_6379 = (state_6424[(8)]);
var inst_6376 = (state_6424[(9)]);
var inst_6377 = (state_6424[(10)]);
var inst_6378 = (state_6424[(11)]);
var inst_6386 = (state_6424[(2)]);
var inst_6387 = (inst_6379 + (1));
var tmp6433 = inst_6376;
var tmp6434 = inst_6377;
var tmp6435 = inst_6378;
var inst_6376__$1 = tmp6433;
var inst_6377__$1 = tmp6434;
var inst_6378__$1 = tmp6435;
var inst_6379__$1 = inst_6387;
var state_6424__$1 = (function (){var statearr_6438 = state_6424;
(statearr_6438[(14)] = inst_6386);

(statearr_6438[(8)] = inst_6379__$1);

(statearr_6438[(9)] = inst_6376__$1);

(statearr_6438[(10)] = inst_6377__$1);

(statearr_6438[(11)] = inst_6378__$1);

return statearr_6438;
})();
var statearr_6439_6471 = state_6424__$1;
(statearr_6439_6471[(2)] = null);

(statearr_6439_6471[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (22))){
var state_6424__$1 = state_6424;
var statearr_6440_6472 = state_6424__$1;
(statearr_6440_6472[(2)] = null);

(statearr_6440_6472[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (6))){
var inst_6365 = (state_6424[(13)]);
var inst_6374 = f.call(null,inst_6365);
var inst_6375 = cljs.core.seq.call(null,inst_6374);
var inst_6376 = inst_6375;
var inst_6377 = null;
var inst_6378 = (0);
var inst_6379 = (0);
var state_6424__$1 = (function (){var statearr_6441 = state_6424;
(statearr_6441[(8)] = inst_6379);

(statearr_6441[(9)] = inst_6376);

(statearr_6441[(10)] = inst_6377);

(statearr_6441[(11)] = inst_6378);

return statearr_6441;
})();
var statearr_6442_6473 = state_6424__$1;
(statearr_6442_6473[(2)] = null);

(statearr_6442_6473[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (17))){
var inst_6390 = (state_6424[(7)]);
var inst_6394 = cljs.core.chunk_first.call(null,inst_6390);
var inst_6395 = cljs.core.chunk_rest.call(null,inst_6390);
var inst_6396 = cljs.core.count.call(null,inst_6394);
var inst_6376 = inst_6395;
var inst_6377 = inst_6394;
var inst_6378 = inst_6396;
var inst_6379 = (0);
var state_6424__$1 = (function (){var statearr_6443 = state_6424;
(statearr_6443[(8)] = inst_6379);

(statearr_6443[(9)] = inst_6376);

(statearr_6443[(10)] = inst_6377);

(statearr_6443[(11)] = inst_6378);

return statearr_6443;
})();
var statearr_6444_6474 = state_6424__$1;
(statearr_6444_6474[(2)] = null);

(statearr_6444_6474[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (3))){
var inst_6422 = (state_6424[(2)]);
var state_6424__$1 = state_6424;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_6424__$1,inst_6422);
} else {
if((state_val_6425 === (12))){
var inst_6410 = (state_6424[(2)]);
var state_6424__$1 = state_6424;
var statearr_6445_6475 = state_6424__$1;
(statearr_6445_6475[(2)] = inst_6410);

(statearr_6445_6475[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (2))){
var state_6424__$1 = state_6424;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_6424__$1,(4),in$);
} else {
if((state_val_6425 === (23))){
var inst_6418 = (state_6424[(2)]);
var state_6424__$1 = state_6424;
var statearr_6446_6476 = state_6424__$1;
(statearr_6446_6476[(2)] = inst_6418);

(statearr_6446_6476[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (19))){
var inst_6405 = (state_6424[(2)]);
var state_6424__$1 = state_6424;
var statearr_6447_6477 = state_6424__$1;
(statearr_6447_6477[(2)] = inst_6405);

(statearr_6447_6477[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (11))){
var inst_6390 = (state_6424[(7)]);
var inst_6376 = (state_6424[(9)]);
var inst_6390__$1 = cljs.core.seq.call(null,inst_6376);
var state_6424__$1 = (function (){var statearr_6448 = state_6424;
(statearr_6448[(7)] = inst_6390__$1);

return statearr_6448;
})();
if(inst_6390__$1){
var statearr_6449_6478 = state_6424__$1;
(statearr_6449_6478[(1)] = (14));

} else {
var statearr_6450_6479 = state_6424__$1;
(statearr_6450_6479[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (9))){
var inst_6412 = (state_6424[(2)]);
var inst_6413 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_6424__$1 = (function (){var statearr_6451 = state_6424;
(statearr_6451[(15)] = inst_6412);

return statearr_6451;
})();
if(cljs.core.truth_(inst_6413)){
var statearr_6452_6480 = state_6424__$1;
(statearr_6452_6480[(1)] = (21));

} else {
var statearr_6453_6481 = state_6424__$1;
(statearr_6453_6481[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (5))){
var inst_6368 = cljs.core.async.close_BANG_.call(null,out);
var state_6424__$1 = state_6424;
var statearr_6454_6482 = state_6424__$1;
(statearr_6454_6482[(2)] = inst_6368);

(statearr_6454_6482[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (14))){
var inst_6390 = (state_6424[(7)]);
var inst_6392 = cljs.core.chunked_seq_QMARK_.call(null,inst_6390);
var state_6424__$1 = state_6424;
if(inst_6392){
var statearr_6455_6483 = state_6424__$1;
(statearr_6455_6483[(1)] = (17));

} else {
var statearr_6456_6484 = state_6424__$1;
(statearr_6456_6484[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (16))){
var inst_6408 = (state_6424[(2)]);
var state_6424__$1 = state_6424;
var statearr_6457_6485 = state_6424__$1;
(statearr_6457_6485[(2)] = inst_6408);

(statearr_6457_6485[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6425 === (10))){
var inst_6379 = (state_6424[(8)]);
var inst_6377 = (state_6424[(10)]);
var inst_6384 = cljs.core._nth.call(null,inst_6377,inst_6379);
var state_6424__$1 = state_6424;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_6424__$1,(13),out,inst_6384);
} else {
if((state_val_6425 === (18))){
var inst_6390 = (state_6424[(7)]);
var inst_6399 = cljs.core.first.call(null,inst_6390);
var state_6424__$1 = state_6424;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_6424__$1,(20),out,inst_6399);
} else {
if((state_val_6425 === (8))){
var inst_6379 = (state_6424[(8)]);
var inst_6378 = (state_6424[(11)]);
var inst_6381 = (inst_6379 < inst_6378);
var inst_6382 = inst_6381;
var state_6424__$1 = state_6424;
if(cljs.core.truth_(inst_6382)){
var statearr_6458_6486 = state_6424__$1;
(statearr_6458_6486[(1)] = (10));

} else {
var statearr_6459_6487 = state_6424__$1;
(statearr_6459_6487[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto__))
;
return ((function (switch__4714__auto__,c__4809__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__4715__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__4715__auto____0 = (function (){
var statearr_6460 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_6460[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__4715__auto__);

(statearr_6460[(1)] = (1));

return statearr_6460;
});
var cljs$core$async$mapcat_STAR__$_state_machine__4715__auto____1 = (function (state_6424){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_6424);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e6461){if((e6461 instanceof Object)){
var ex__4718__auto__ = e6461;
var statearr_6462_6488 = state_6424;
(statearr_6462_6488[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_6424);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6461;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6489 = state_6424;
state_6424 = G__6489;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__4715__auto__ = function(state_6424){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__4715__auto____1.call(this,state_6424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__4715__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__4715__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto__))
})();
var state__4811__auto__ = (function (){var statearr_6463 = f__4810__auto__.call(null);
(statearr_6463[(6)] = c__4809__auto__);

return statearr_6463;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto__))
);

return c__4809__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__6491 = arguments.length;
switch (G__6491) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__6494 = arguments.length;
switch (G__6494) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__6497 = arguments.length;
switch (G__6497) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__4809__auto___6544 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___6544,out){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___6544,out){
return (function (state_6521){
var state_val_6522 = (state_6521[(1)]);
if((state_val_6522 === (7))){
var inst_6516 = (state_6521[(2)]);
var state_6521__$1 = state_6521;
var statearr_6523_6545 = state_6521__$1;
(statearr_6523_6545[(2)] = inst_6516);

(statearr_6523_6545[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6522 === (1))){
var inst_6498 = null;
var state_6521__$1 = (function (){var statearr_6524 = state_6521;
(statearr_6524[(7)] = inst_6498);

return statearr_6524;
})();
var statearr_6525_6546 = state_6521__$1;
(statearr_6525_6546[(2)] = null);

(statearr_6525_6546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6522 === (4))){
var inst_6501 = (state_6521[(8)]);
var inst_6501__$1 = (state_6521[(2)]);
var inst_6502 = (inst_6501__$1 == null);
var inst_6503 = cljs.core.not.call(null,inst_6502);
var state_6521__$1 = (function (){var statearr_6526 = state_6521;
(statearr_6526[(8)] = inst_6501__$1);

return statearr_6526;
})();
if(inst_6503){
var statearr_6527_6547 = state_6521__$1;
(statearr_6527_6547[(1)] = (5));

} else {
var statearr_6528_6548 = state_6521__$1;
(statearr_6528_6548[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6522 === (6))){
var state_6521__$1 = state_6521;
var statearr_6529_6549 = state_6521__$1;
(statearr_6529_6549[(2)] = null);

(statearr_6529_6549[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6522 === (3))){
var inst_6518 = (state_6521[(2)]);
var inst_6519 = cljs.core.async.close_BANG_.call(null,out);
var state_6521__$1 = (function (){var statearr_6530 = state_6521;
(statearr_6530[(9)] = inst_6518);

return statearr_6530;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_6521__$1,inst_6519);
} else {
if((state_val_6522 === (2))){
var state_6521__$1 = state_6521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_6521__$1,(4),ch);
} else {
if((state_val_6522 === (11))){
var inst_6501 = (state_6521[(8)]);
var inst_6510 = (state_6521[(2)]);
var inst_6498 = inst_6501;
var state_6521__$1 = (function (){var statearr_6531 = state_6521;
(statearr_6531[(10)] = inst_6510);

(statearr_6531[(7)] = inst_6498);

return statearr_6531;
})();
var statearr_6532_6550 = state_6521__$1;
(statearr_6532_6550[(2)] = null);

(statearr_6532_6550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6522 === (9))){
var inst_6501 = (state_6521[(8)]);
var state_6521__$1 = state_6521;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_6521__$1,(11),out,inst_6501);
} else {
if((state_val_6522 === (5))){
var inst_6501 = (state_6521[(8)]);
var inst_6498 = (state_6521[(7)]);
var inst_6505 = cljs.core._EQ_.call(null,inst_6501,inst_6498);
var state_6521__$1 = state_6521;
if(inst_6505){
var statearr_6534_6551 = state_6521__$1;
(statearr_6534_6551[(1)] = (8));

} else {
var statearr_6535_6552 = state_6521__$1;
(statearr_6535_6552[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6522 === (10))){
var inst_6513 = (state_6521[(2)]);
var state_6521__$1 = state_6521;
var statearr_6536_6553 = state_6521__$1;
(statearr_6536_6553[(2)] = inst_6513);

(statearr_6536_6553[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6522 === (8))){
var inst_6498 = (state_6521[(7)]);
var tmp6533 = inst_6498;
var inst_6498__$1 = tmp6533;
var state_6521__$1 = (function (){var statearr_6537 = state_6521;
(statearr_6537[(7)] = inst_6498__$1);

return statearr_6537;
})();
var statearr_6538_6554 = state_6521__$1;
(statearr_6538_6554[(2)] = null);

(statearr_6538_6554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___6544,out))
;
return ((function (switch__4714__auto__,c__4809__auto___6544,out){
return (function() {
var cljs$core$async$state_machine__4715__auto__ = null;
var cljs$core$async$state_machine__4715__auto____0 = (function (){
var statearr_6539 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_6539[(0)] = cljs$core$async$state_machine__4715__auto__);

(statearr_6539[(1)] = (1));

return statearr_6539;
});
var cljs$core$async$state_machine__4715__auto____1 = (function (state_6521){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_6521);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e6540){if((e6540 instanceof Object)){
var ex__4718__auto__ = e6540;
var statearr_6541_6555 = state_6521;
(statearr_6541_6555[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_6521);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6540;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6556 = state_6521;
state_6521 = G__6556;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$state_machine__4715__auto__ = function(state_6521){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__4715__auto____1.call(this,state_6521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__4715__auto____0;
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__4715__auto____1;
return cljs$core$async$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___6544,out))
})();
var state__4811__auto__ = (function (){var statearr_6542 = f__4810__auto__.call(null);
(statearr_6542[(6)] = c__4809__auto___6544);

return statearr_6542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___6544,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__6558 = arguments.length;
switch (G__6558) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__4809__auto___6624 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___6624,out){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___6624,out){
return (function (state_6596){
var state_val_6597 = (state_6596[(1)]);
if((state_val_6597 === (7))){
var inst_6592 = (state_6596[(2)]);
var state_6596__$1 = state_6596;
var statearr_6598_6625 = state_6596__$1;
(statearr_6598_6625[(2)] = inst_6592);

(statearr_6598_6625[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6597 === (1))){
var inst_6559 = (new Array(n));
var inst_6560 = inst_6559;
var inst_6561 = (0);
var state_6596__$1 = (function (){var statearr_6599 = state_6596;
(statearr_6599[(7)] = inst_6561);

(statearr_6599[(8)] = inst_6560);

return statearr_6599;
})();
var statearr_6600_6626 = state_6596__$1;
(statearr_6600_6626[(2)] = null);

(statearr_6600_6626[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6597 === (4))){
var inst_6564 = (state_6596[(9)]);
var inst_6564__$1 = (state_6596[(2)]);
var inst_6565 = (inst_6564__$1 == null);
var inst_6566 = cljs.core.not.call(null,inst_6565);
var state_6596__$1 = (function (){var statearr_6601 = state_6596;
(statearr_6601[(9)] = inst_6564__$1);

return statearr_6601;
})();
if(inst_6566){
var statearr_6602_6627 = state_6596__$1;
(statearr_6602_6627[(1)] = (5));

} else {
var statearr_6603_6628 = state_6596__$1;
(statearr_6603_6628[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6597 === (15))){
var inst_6586 = (state_6596[(2)]);
var state_6596__$1 = state_6596;
var statearr_6604_6629 = state_6596__$1;
(statearr_6604_6629[(2)] = inst_6586);

(statearr_6604_6629[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6597 === (13))){
var state_6596__$1 = state_6596;
var statearr_6605_6630 = state_6596__$1;
(statearr_6605_6630[(2)] = null);

(statearr_6605_6630[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6597 === (6))){
var inst_6561 = (state_6596[(7)]);
var inst_6582 = (inst_6561 > (0));
var state_6596__$1 = state_6596;
if(cljs.core.truth_(inst_6582)){
var statearr_6606_6631 = state_6596__$1;
(statearr_6606_6631[(1)] = (12));

} else {
var statearr_6607_6632 = state_6596__$1;
(statearr_6607_6632[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6597 === (3))){
var inst_6594 = (state_6596[(2)]);
var state_6596__$1 = state_6596;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_6596__$1,inst_6594);
} else {
if((state_val_6597 === (12))){
var inst_6560 = (state_6596[(8)]);
var inst_6584 = cljs.core.vec.call(null,inst_6560);
var state_6596__$1 = state_6596;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_6596__$1,(15),out,inst_6584);
} else {
if((state_val_6597 === (2))){
var state_6596__$1 = state_6596;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_6596__$1,(4),ch);
} else {
if((state_val_6597 === (11))){
var inst_6576 = (state_6596[(2)]);
var inst_6577 = (new Array(n));
var inst_6560 = inst_6577;
var inst_6561 = (0);
var state_6596__$1 = (function (){var statearr_6608 = state_6596;
(statearr_6608[(7)] = inst_6561);

(statearr_6608[(8)] = inst_6560);

(statearr_6608[(10)] = inst_6576);

return statearr_6608;
})();
var statearr_6609_6633 = state_6596__$1;
(statearr_6609_6633[(2)] = null);

(statearr_6609_6633[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6597 === (9))){
var inst_6560 = (state_6596[(8)]);
var inst_6574 = cljs.core.vec.call(null,inst_6560);
var state_6596__$1 = state_6596;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_6596__$1,(11),out,inst_6574);
} else {
if((state_val_6597 === (5))){
var inst_6564 = (state_6596[(9)]);
var inst_6561 = (state_6596[(7)]);
var inst_6569 = (state_6596[(11)]);
var inst_6560 = (state_6596[(8)]);
var inst_6568 = (inst_6560[inst_6561] = inst_6564);
var inst_6569__$1 = (inst_6561 + (1));
var inst_6570 = (inst_6569__$1 < n);
var state_6596__$1 = (function (){var statearr_6610 = state_6596;
(statearr_6610[(12)] = inst_6568);

(statearr_6610[(11)] = inst_6569__$1);

return statearr_6610;
})();
if(cljs.core.truth_(inst_6570)){
var statearr_6611_6634 = state_6596__$1;
(statearr_6611_6634[(1)] = (8));

} else {
var statearr_6612_6635 = state_6596__$1;
(statearr_6612_6635[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6597 === (14))){
var inst_6589 = (state_6596[(2)]);
var inst_6590 = cljs.core.async.close_BANG_.call(null,out);
var state_6596__$1 = (function (){var statearr_6614 = state_6596;
(statearr_6614[(13)] = inst_6589);

return statearr_6614;
})();
var statearr_6615_6636 = state_6596__$1;
(statearr_6615_6636[(2)] = inst_6590);

(statearr_6615_6636[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6597 === (10))){
var inst_6580 = (state_6596[(2)]);
var state_6596__$1 = state_6596;
var statearr_6616_6637 = state_6596__$1;
(statearr_6616_6637[(2)] = inst_6580);

(statearr_6616_6637[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6597 === (8))){
var inst_6569 = (state_6596[(11)]);
var inst_6560 = (state_6596[(8)]);
var tmp6613 = inst_6560;
var inst_6560__$1 = tmp6613;
var inst_6561 = inst_6569;
var state_6596__$1 = (function (){var statearr_6617 = state_6596;
(statearr_6617[(7)] = inst_6561);

(statearr_6617[(8)] = inst_6560__$1);

return statearr_6617;
})();
var statearr_6618_6638 = state_6596__$1;
(statearr_6618_6638[(2)] = null);

(statearr_6618_6638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___6624,out))
;
return ((function (switch__4714__auto__,c__4809__auto___6624,out){
return (function() {
var cljs$core$async$state_machine__4715__auto__ = null;
var cljs$core$async$state_machine__4715__auto____0 = (function (){
var statearr_6619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_6619[(0)] = cljs$core$async$state_machine__4715__auto__);

(statearr_6619[(1)] = (1));

return statearr_6619;
});
var cljs$core$async$state_machine__4715__auto____1 = (function (state_6596){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_6596);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e6620){if((e6620 instanceof Object)){
var ex__4718__auto__ = e6620;
var statearr_6621_6639 = state_6596;
(statearr_6621_6639[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_6596);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6620;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6640 = state_6596;
state_6596 = G__6640;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$state_machine__4715__auto__ = function(state_6596){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__4715__auto____1.call(this,state_6596);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__4715__auto____0;
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__4715__auto____1;
return cljs$core$async$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___6624,out))
})();
var state__4811__auto__ = (function (){var statearr_6622 = f__4810__auto__.call(null);
(statearr_6622[(6)] = c__4809__auto___6624);

return statearr_6622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___6624,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__6642 = arguments.length;
switch (G__6642) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__4809__auto___6712 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__4809__auto___6712,out){
return (function (){
var f__4810__auto__ = (function (){var switch__4714__auto__ = ((function (c__4809__auto___6712,out){
return (function (state_6684){
var state_val_6685 = (state_6684[(1)]);
if((state_val_6685 === (7))){
var inst_6680 = (state_6684[(2)]);
var state_6684__$1 = state_6684;
var statearr_6686_6713 = state_6684__$1;
(statearr_6686_6713[(2)] = inst_6680);

(statearr_6686_6713[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6685 === (1))){
var inst_6643 = [];
var inst_6644 = inst_6643;
var inst_6645 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_6684__$1 = (function (){var statearr_6687 = state_6684;
(statearr_6687[(7)] = inst_6644);

(statearr_6687[(8)] = inst_6645);

return statearr_6687;
})();
var statearr_6688_6714 = state_6684__$1;
(statearr_6688_6714[(2)] = null);

(statearr_6688_6714[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6685 === (4))){
var inst_6648 = (state_6684[(9)]);
var inst_6648__$1 = (state_6684[(2)]);
var inst_6649 = (inst_6648__$1 == null);
var inst_6650 = cljs.core.not.call(null,inst_6649);
var state_6684__$1 = (function (){var statearr_6689 = state_6684;
(statearr_6689[(9)] = inst_6648__$1);

return statearr_6689;
})();
if(inst_6650){
var statearr_6690_6715 = state_6684__$1;
(statearr_6690_6715[(1)] = (5));

} else {
var statearr_6691_6716 = state_6684__$1;
(statearr_6691_6716[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6685 === (15))){
var inst_6674 = (state_6684[(2)]);
var state_6684__$1 = state_6684;
var statearr_6692_6717 = state_6684__$1;
(statearr_6692_6717[(2)] = inst_6674);

(statearr_6692_6717[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6685 === (13))){
var state_6684__$1 = state_6684;
var statearr_6693_6718 = state_6684__$1;
(statearr_6693_6718[(2)] = null);

(statearr_6693_6718[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6685 === (6))){
var inst_6644 = (state_6684[(7)]);
var inst_6669 = inst_6644.length;
var inst_6670 = (inst_6669 > (0));
var state_6684__$1 = state_6684;
if(cljs.core.truth_(inst_6670)){
var statearr_6694_6719 = state_6684__$1;
(statearr_6694_6719[(1)] = (12));

} else {
var statearr_6695_6720 = state_6684__$1;
(statearr_6695_6720[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6685 === (3))){
var inst_6682 = (state_6684[(2)]);
var state_6684__$1 = state_6684;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_6684__$1,inst_6682);
} else {
if((state_val_6685 === (12))){
var inst_6644 = (state_6684[(7)]);
var inst_6672 = cljs.core.vec.call(null,inst_6644);
var state_6684__$1 = state_6684;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_6684__$1,(15),out,inst_6672);
} else {
if((state_val_6685 === (2))){
var state_6684__$1 = state_6684;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_6684__$1,(4),ch);
} else {
if((state_val_6685 === (11))){
var inst_6648 = (state_6684[(9)]);
var inst_6652 = (state_6684[(10)]);
var inst_6662 = (state_6684[(2)]);
var inst_6663 = [];
var inst_6664 = inst_6663.push(inst_6648);
var inst_6644 = inst_6663;
var inst_6645 = inst_6652;
var state_6684__$1 = (function (){var statearr_6696 = state_6684;
(statearr_6696[(7)] = inst_6644);

(statearr_6696[(8)] = inst_6645);

(statearr_6696[(11)] = inst_6662);

(statearr_6696[(12)] = inst_6664);

return statearr_6696;
})();
var statearr_6697_6721 = state_6684__$1;
(statearr_6697_6721[(2)] = null);

(statearr_6697_6721[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6685 === (9))){
var inst_6644 = (state_6684[(7)]);
var inst_6660 = cljs.core.vec.call(null,inst_6644);
var state_6684__$1 = state_6684;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_6684__$1,(11),out,inst_6660);
} else {
if((state_val_6685 === (5))){
var inst_6648 = (state_6684[(9)]);
var inst_6652 = (state_6684[(10)]);
var inst_6645 = (state_6684[(8)]);
var inst_6652__$1 = f.call(null,inst_6648);
var inst_6653 = cljs.core._EQ_.call(null,inst_6652__$1,inst_6645);
var inst_6654 = cljs.core.keyword_identical_QMARK_.call(null,inst_6645,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_6655 = ((inst_6653) || (inst_6654));
var state_6684__$1 = (function (){var statearr_6698 = state_6684;
(statearr_6698[(10)] = inst_6652__$1);

return statearr_6698;
})();
if(cljs.core.truth_(inst_6655)){
var statearr_6699_6722 = state_6684__$1;
(statearr_6699_6722[(1)] = (8));

} else {
var statearr_6700_6723 = state_6684__$1;
(statearr_6700_6723[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6685 === (14))){
var inst_6677 = (state_6684[(2)]);
var inst_6678 = cljs.core.async.close_BANG_.call(null,out);
var state_6684__$1 = (function (){var statearr_6702 = state_6684;
(statearr_6702[(13)] = inst_6677);

return statearr_6702;
})();
var statearr_6703_6724 = state_6684__$1;
(statearr_6703_6724[(2)] = inst_6678);

(statearr_6703_6724[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6685 === (10))){
var inst_6667 = (state_6684[(2)]);
var state_6684__$1 = state_6684;
var statearr_6704_6725 = state_6684__$1;
(statearr_6704_6725[(2)] = inst_6667);

(statearr_6704_6725[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_6685 === (8))){
var inst_6644 = (state_6684[(7)]);
var inst_6648 = (state_6684[(9)]);
var inst_6652 = (state_6684[(10)]);
var inst_6657 = inst_6644.push(inst_6648);
var tmp6701 = inst_6644;
var inst_6644__$1 = tmp6701;
var inst_6645 = inst_6652;
var state_6684__$1 = (function (){var statearr_6705 = state_6684;
(statearr_6705[(7)] = inst_6644__$1);

(statearr_6705[(14)] = inst_6657);

(statearr_6705[(8)] = inst_6645);

return statearr_6705;
})();
var statearr_6706_6726 = state_6684__$1;
(statearr_6706_6726[(2)] = null);

(statearr_6706_6726[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__4809__auto___6712,out))
;
return ((function (switch__4714__auto__,c__4809__auto___6712,out){
return (function() {
var cljs$core$async$state_machine__4715__auto__ = null;
var cljs$core$async$state_machine__4715__auto____0 = (function (){
var statearr_6707 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_6707[(0)] = cljs$core$async$state_machine__4715__auto__);

(statearr_6707[(1)] = (1));

return statearr_6707;
});
var cljs$core$async$state_machine__4715__auto____1 = (function (state_6684){
while(true){
var ret_value__4716__auto__ = (function (){try{while(true){
var result__4717__auto__ = switch__4714__auto__.call(null,state_6684);
if(cljs.core.keyword_identical_QMARK_.call(null,result__4717__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__4717__auto__;
}
break;
}
}catch (e6708){if((e6708 instanceof Object)){
var ex__4718__auto__ = e6708;
var statearr_6709_6727 = state_6684;
(statearr_6709_6727[(5)] = ex__4718__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_6684);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e6708;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__4716__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__6728 = state_6684;
state_6684 = G__6728;
continue;
} else {
return ret_value__4716__auto__;
}
break;
}
});
cljs$core$async$state_machine__4715__auto__ = function(state_6684){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__4715__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__4715__auto____1.call(this,state_6684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__4715__auto____0;
cljs$core$async$state_machine__4715__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__4715__auto____1;
return cljs$core$async$state_machine__4715__auto__;
})()
;})(switch__4714__auto__,c__4809__auto___6712,out))
})();
var state__4811__auto__ = (function (){var statearr_6710 = f__4810__auto__.call(null);
(statearr_6710[(6)] = c__4809__auto___6712);

return statearr_6710;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__4811__auto__);
});})(c__4809__auto___6712,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map
