// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.path');
goog.require('cljs.core');
goog.require('imcljs.internal.utils');
goog.require('clojure.string');
/**
 * Split a string path into a vector of keywords.
 *   (split-path `Gene.organism.shortName`)
 *   => [:Gene :organism :shortName]
 */
imcljs.path.split_path = (function imcljs$path$split_path(path_str){
return cljs.core.map.call(null,cljs.core.keyword,clojure.string.split.call(null,path_str,/\./));
});
/**
 * Join a vector path of keywords to a string.
 *   (join-path [:Gene :organism :shortName])
 *   => Gene.organism.shortName
 */
imcljs.path.join_path = (function imcljs$path$join_path(path_str){
return clojure.string.join.call(null,".",cljs.core.map.call(null,cljs.core.name,path_str));
});
/**
 * Given a model and a class, return its attributes, references and collections.
 */
imcljs.path.properties = (function imcljs$path$properties(model,class_kw){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_type = (function imcljs$path$referenced_type(model,field_kw,class_kw){
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw)));
});
/**
 * Given a model, a reference/collection, and a class,
 *   return the superclass of the reference/collection.
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.referenced_class = (function imcljs$path$referenced_class(model,field_kw,class_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_type,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__2460){
var vec__2461 = p__2460;
var _ = cljs.core.nth.call(null,vec__2461,(0),null);
var map__2464 = cljs.core.nth.call(null,vec__2461,(1),null);
var map__2464__$1 = (((((!((map__2464 == null))))?(((((map__2464.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2464.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2464):map__2464);
var extends$ = cljs.core.get.call(null,map__2464__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_values = (function imcljs$path$referenced_values(model,field_kw,class_kw){
return cljs.core.get.call(null,imcljs.path.properties.call(null,model,class_kw),field_kw);
});
/**
 * Given a model and a field, return that field from the data model.
 *   A field can be a reference, a collection, or an attribute
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.class_value = (function imcljs$path$class_value(model,class_kw,field_kw){
return cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.identity,cljs.core.map.call(null,cljs.core.partial.call(null,imcljs.path.referenced_values,model,field_kw),cljs.core.cons.call(null,class_kw,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,(function (p__2466){
var vec__2467 = p__2466;
var _ = cljs.core.nth.call(null,vec__2467,(0),null);
var map__2470 = cljs.core.nth.call(null,vec__2467,(1),null);
var map__2470__$1 = (((((!((map__2470 == null))))?(((((map__2470.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2470.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2470):map__2470);
var extends$ = cljs.core.get.call(null,map__2470__$1,new cljs.core.Keyword(null,"extends","extends",-954903259));
return cljs.core.some.call(null,cljs.core.partial.call(null,cljs.core._EQ_,class_kw),cljs.core.map.call(null,cljs.core.keyword,extends$));
}),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Return a vector representing each part of path.
 *   If any part of the path is unresolvable then a nil is returned.
 *   (walk im-model `Gene.organism.shortName`)
 *   => [{:name `Gene`, :collections {...}, :attributes {...}}
 *    {:name `Organism`, :collections {...} :attributes {...}
 *    {:name `shortName`, :type `java.lang.String`}]
 */
imcljs.path.walk = (function imcljs$path$walk(var_args){
var G__2473 = arguments.length;
switch (G__2473) {
case 2:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$2 = (function (model,path){
var p = ((typeof path === 'string')?imcljs.path.split_path.call(null,path):path);
if(cljs.core._EQ_.call(null,(1),cljs.core.count.call(null,p))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.first.call(null,p)], null))], null);
} else {
return imcljs.path.walk.call(null,model,p,cljs.core.PersistentVector.EMPTY);
}
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$3 = (function (model,p__2474,trail){
while(true){
var vec__2475 = p__2474;
var seq__2476 = cljs.core.seq.call(null,vec__2475);
var first__2477 = cljs.core.first.call(null,seq__2476);
var seq__2476__$1 = cljs.core.next.call(null,seq__2476);
var class_kw = first__2477;
var vec__2478 = seq__2476__$1;
var seq__2479 = cljs.core.seq.call(null,vec__2478);
var first__2480 = cljs.core.first.call(null,seq__2479);
var seq__2479__$1 = cljs.core.next.call(null,seq__2479);
var path = first__2480;
var remaining = seq__2479__$1;
var cv = imcljs.path.class_value.call(null,model,class_kw,path);
if(remaining){
if(cljs.core.contains_QMARK_.call(null,cv,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030))){
var G__2482 = model;
var G__2483 = cljs.core.cons.call(null,cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cv)),remaining);
var G__2484 = cljs.core.conj.call(null,trail,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)));
model = G__2482;
p__2474 = G__2483;
trail = G__2484;
continue;
} else {
return null;
}
} else {
return cljs.core.conj.call(null,trail,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),class_kw], null)),((cljs.core.contains_QMARK_.call(null,cv,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030)))?cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(cv))], null)):cv));
}
break;
}
});

imcljs.path.walk.cljs$lang$maxFixedArity = 3;

/**
 * Return the java type of a path representing an attribute.
 *   (attribute-type im-model `Gene.organism.shortName`)
 *   => java.lang.String
 */
imcljs.path.data_type = (function imcljs$path$data_type(model,path){
return new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.last.call(null,imcljs.path.walk.call(null,model,path)));
});
/**
 * Returns the class represented by the path.
 *   (class im-model `Gene.homologues.homologue.symbol`)
 *   => :Gene
 */
imcljs.path.class$ = (function imcljs$path$class(model,path){
var l = cljs.core.last.call(null,cljs.core.take_while.call(null,(function (p1__2485_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__2485_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path)));
return cljs.core.keyword.call(null,(function (){var or__4131__auto__ = new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(l);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.keyword.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(l));
}
})());
});
/**
 * Returns all relationships (references and collections) for a given string path.
 */
imcljs.path.relationships = (function imcljs$path$relationships(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null)));
});
imcljs.path.mapify = (function imcljs$path$mapify(coll){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,coll);
});
imcljs.path.un_camel_case = (function imcljs$path$un_camel_case(s){
var G__2487 = s;
var G__2487__$1 = (((G__2487 == null))?null:clojure.string.replace.call(null,G__2487,/([a-z])([A-Z])/,"$1 $2"));
var G__2487__$2 = (((G__2487__$1 == null))?null:clojure.string.replace.call(null,G__2487__$1,/([A-Z])([a-z])/," $1$2"));
var G__2487__$3 = (((G__2487__$2 == null))?null:clojure.string.replace.call(null,G__2487__$2,/\ +/," "));
if((G__2487__$3 == null)){
return null;
} else {
return clojure.string.replace.call(null,G__2487__$3,/^./,((function (G__2487,G__2487__$1,G__2487__$2,G__2487__$3){
return (function (p1__2486_SHARP_){
return clojure.string.upper_case.call(null,p1__2486_SHARP_);
});})(G__2487,G__2487__$1,G__2487__$2,G__2487__$3))
);
}
});
/**
 * Returns a vector of friendly names representing the path
 *   ; TODO make this work with subclasses
 */
imcljs.path.display_name = (function imcljs$path$display_name(var_args){
var G__2489 = arguments.length;
switch (G__2489) {
case 2:
return imcljs.path.display_name.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return imcljs.path.display_name.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

imcljs.path.display_name.cljs$core$IFn$_invoke$arity$2 = (function (model,path){
var p = ((typeof path === 'string')?imcljs.path.split_path.call(null,path):path);
return imcljs.path.display_name.call(null,model,p,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),cljs.core.first.call(null,p),new cljs.core.Keyword(null,"displayName","displayName",-809144601)], null))], null));
});

imcljs.path.display_name.cljs$core$IFn$_invoke$arity$3 = (function (model,p__2490,collected){
while(true){
var vec__2491 = p__2490;
var seq__2492 = cljs.core.seq.call(null,vec__2491);
var first__2493 = cljs.core.first.call(null,seq__2492);
var seq__2492__$1 = cljs.core.next.call(null,seq__2492);
var head = first__2493;
var first__2493__$1 = cljs.core.first.call(null,seq__2492__$1);
var seq__2492__$2 = cljs.core.next.call(null,seq__2492__$1);
var next = first__2493__$1;
var tail = seq__2492__$2;
if(cljs.core.truth_(next)){
var props = imcljs.path.mapify.call(null,cljs.core.vals.call(null,cljs.core.select_keys.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),head], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604),new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null))));
var collected_PLUS_ = cljs.core.conj.call(null,collected,(function (){var or__4131__auto__ = cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [next,new cljs.core.Keyword(null,"displayName","displayName",-809144601)], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return imcljs.path.un_camel_case.call(null,cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [next,new cljs.core.Keyword(null,"name","name",1843675177)], null)));
}
})());
if(cljs.core.truth_(cljs.core.not_empty.call(null,tail))){
var G__2495 = model;
var G__2496 = cljs.core.conj.call(null,tail,cljs.core.keyword.call(null,cljs.core.get_in.call(null,props,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [next,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030)], null))));
var G__2497 = collected_PLUS_;
model = G__2495;
p__2490 = G__2496;
collected = G__2497;
continue;
} else {
return collected_PLUS_;
}
} else {
return null;
}
break;
}
});

imcljs.path.display_name.cljs$lang$maxFixedArity = 3;

/**
 * Returns all attributes for a given string path.
 */
imcljs.path.attributes = (function imcljs$path$attributes(model,path){
return cljs.core.apply.call(null,cljs.core.merge,cljs.core.map.call(null,cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"classes","classes",2037804510),imcljs.path.class$.call(null,model,path)], null)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"attributes","attributes",-74013604)], null)));
});
/**
 * Returns true if path is a class.
 *   (class im-model `Gene.diseases`)
 *   => true
 *   (class im-model `Gene.diseases.name`)
 *   => false
 */
imcljs.path.class_QMARK_ = (function imcljs$path$class_QMARK_(model,path){
var walked = imcljs.path.walk.call(null,model,path);
return (!(cljs.core.contains_QMARK_.call(null,cljs.core.last.call(null,walked),new cljs.core.Keyword(null,"type","type",1174270348))));
});
/**
 * Returns a path string trimmed to the last class
 *   (trim-to-last-class im-model `Gene.homologues.homologue.symbol`)
 *   => Gene.homologues.homologue
 */
imcljs.path.trim_to_last_class = (function imcljs$path$trim_to_last_class(model,path){
var done = cljs.core.take_while.call(null,(function (p1__2498_SHARP_){
return imcljs.internal.utils.does_not_contain_QMARK_.call(null,p1__2498_SHARP_,new cljs.core.Keyword(null,"type","type",1174270348));
}),imcljs.path.walk.call(null,model,path));
return imcljs.path.join_path.call(null,cljs.core.take.call(null,cljs.core.count.call(null,done),imcljs.path.split_path.call(null,path)));
});
/**
 * Returns a path adjusted to its last class
 *   (adjust-path-to-last-class im-model `Gene.organism.name`)
 *   => Organism.name
 */
imcljs.path.adjust_path_to_last_class = (function imcljs$path$adjust_path_to_last_class(model,path){
var attribute_QMARK_ = (!(imcljs.path.class_QMARK_.call(null,model,path)));
var walked = cljs.core.reverse.call(null,imcljs.path.walk.call(null,model,path));
if(attribute_QMARK_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(1)))),".",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(0))))].join('');
} else {
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,walked,(0))));
}
});
/**
 * Returns a path as a strong
 */
imcljs.path.friendly = (function imcljs$path$friendly(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2506 = arguments.length;
var i__4731__auto___2507 = (0);
while(true){
if((i__4731__auto___2507 < len__4730__auto___2506)){
args__4736__auto__.push((arguments[i__4731__auto___2507]));

var G__2508 = (i__4731__auto___2507 + (1));
i__4731__auto___2507 = G__2508;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic = (function (model,path,p__2502){
var vec__2503 = p__2502;
var exclude_root_QMARK_ = cljs.core.nth.call(null,vec__2503,(0),null);
return cljs.core.reduce.call(null,((function (vec__2503,exclude_root_QMARK_){
return (function (total,next){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(total),(cljs.core.truth_(total)?" > ":null),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4131__auto__ = new cljs.core.Keyword(null,"displayName","displayName",-809144601).cljs$core$IFn$_invoke$arity$1(next);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(next);
}
})())].join('');
});})(vec__2503,exclude_root_QMARK_))
,null,(cljs.core.truth_(exclude_root_QMARK_)?cljs.core.rest.call(null,imcljs.path.walk.call(null,model,path)):imcljs.path.walk.call(null,model,path)));
});

imcljs.path.friendly.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.path.friendly.cljs$lang$applyTo = (function (seq2499){
var G__2500 = cljs.core.first.call(null,seq2499);
var seq2499__$1 = cljs.core.next.call(null,seq2499);
var G__2501 = cljs.core.first.call(null,seq2499__$1);
var seq2499__$2 = cljs.core.next.call(null,seq2499__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2500,G__2501,seq2499__$2);
});

imcljs.path.one_of_QMARK_ = (function imcljs$path$one_of_QMARK_(col,value){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([value]),col) == null)));
});
/**
 * Returns subclasses of the class
 */
imcljs.path.subclasses = (function imcljs$path$subclasses(model,path){
var path_class = imcljs.path.class$.call(null,model,path);
return cljs.core.not_empty.call(null,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,((function (path_class){
return (function (p__2509){
var vec__2510 = p__2509;
var _ = cljs.core.nth.call(null,vec__2510,(0),null);
var properties = cljs.core.nth.call(null,vec__2510,(1),null);
return imcljs.path.one_of_QMARK_.call(null,new cljs.core.Keyword(null,"extends","extends",-954903259).cljs$core$IFn$_invoke$arity$1(properties),cljs.core.name.call(null,path_class));
});})(path_class))
,new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model))));
});

//# sourceMappingURL=path.js.map
