// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.fetch');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('imcljs.query');
goog.require('cljs.core.async');
/**
 * Returns quicksearch results.
 */
imcljs.fetch.quicksearch = (function imcljs$fetch$quicksearch(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3038 = arguments.length;
var i__4731__auto___3039 = (0);
while(true){
if((i__4731__auto___3039 < len__4730__auto___3038)){
args__4736__auto__.push((arguments[i__4731__auto___3039]));

var G__3040 = (i__4731__auto___3039 + (1));
i__4731__auto___3039 = G__3040;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic = (function (service,search_term,p__3034){
var vec__3035 = p__3034;
var options = cljs.core.nth.call(null,vec__3035,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/search",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"q","q",689001697),search_term], null),options));
});

imcljs.fetch.quicksearch.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.quicksearch.cljs$lang$applyTo = (function (seq3031){
var G__3032 = cljs.core.first.call(null,seq3031);
var seq3031__$1 = cljs.core.next.call(null,seq3031);
var G__3033 = cljs.core.first.call(null,seq3031__$1);
var seq3031__$2 = cljs.core.next.call(null,seq3031__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3032,G__3033,seq3031__$2);
});

imcljs.fetch.table_rows = (function imcljs$fetch$table_rows(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3048 = arguments.length;
var i__4731__auto___3049 = (0);
while(true){
if((i__4731__auto___3049 < len__4730__auto___3048)){
args__4736__auto__.push((arguments[i__4731__auto___3049]));

var G__3050 = (i__4731__auto___3049 + (1));
i__4731__auto___3049 = G__3050;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3044){
var vec__3045 = p__3044;
var options = cljs.core.nth.call(null,vec__3045,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/tablerows",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.table_rows.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.table_rows.cljs$lang$applyTo = (function (seq3041){
var G__3042 = cljs.core.first.call(null,seq3041);
var seq3041__$1 = cljs.core.next.call(null,seq3041);
var G__3043 = cljs.core.first.call(null,seq3041__$1);
var seq3041__$2 = cljs.core.next.call(null,seq3041__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3042,G__3043,seq3041__$2);
});

imcljs.fetch.fasta = (function imcljs$fetch$fasta(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3058 = arguments.length;
var i__4731__auto___3059 = (0);
while(true){
if((i__4731__auto___3059 < len__4730__auto___3058)){
args__4736__auto__.push((arguments[i__4731__auto___3059]));

var G__3060 = (i__4731__auto___3059 + (1));
i__4731__auto___3059 = G__3060;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3054){
var vec__3055 = p__3054;
var options = cljs.core.nth.call(null,vec__3055,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/fasta",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fasta.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fasta.cljs$lang$applyTo = (function (seq3051){
var G__3052 = cljs.core.first.call(null,seq3051);
var seq3051__$1 = cljs.core.next.call(null,seq3051);
var G__3053 = cljs.core.first.call(null,seq3051__$1);
var seq3051__$2 = cljs.core.next.call(null,seq3051__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3052,G__3053,seq3051__$2);
});

imcljs.fetch.fetch_custom_format = (function imcljs$fetch$fetch_custom_format(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3068 = arguments.length;
var i__4731__auto___3069 = (0);
while(true){
if((i__4731__auto___3069 < len__4730__auto___3068)){
args__4736__auto__.push((arguments[i__4731__auto___3069]));

var G__3070 = (i__4731__auto___3069 + (1));
i__4731__auto___3069 = G__3070;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3064){
var vec__3065 = p__3064;
var options = cljs.core.nth.call(null,vec__3065,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fetch_custom_format.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.fetch_custom_format.cljs$lang$applyTo = (function (seq3061){
var G__3062 = cljs.core.first.call(null,seq3061);
var seq3061__$1 = cljs.core.next.call(null,seq3061);
var G__3063 = cljs.core.first.call(null,seq3061__$1);
var seq3061__$2 = cljs.core.next.call(null,seq3061__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3062,G__3063,seq3061__$2);
});

imcljs.fetch.records = (function imcljs$fetch$records(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3078 = arguments.length;
var i__4731__auto___3079 = (0);
while(true){
if((i__4731__auto___3079 < len__4730__auto___3078)){
args__4736__auto__.push((arguments[i__4731__auto___3079]));

var G__3080 = (i__4731__auto___3079 + (1));
i__4731__auto___3079 = G__3080;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3074){
var vec__3075 = p__3074;
var options = cljs.core.nth.call(null,vec__3075,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"jsonobjects"], null),options));
});

imcljs.fetch.records.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.records.cljs$lang$applyTo = (function (seq3071){
var G__3072 = cljs.core.first.call(null,seq3071);
var seq3071__$1 = cljs.core.next.call(null,seq3071);
var G__3073 = cljs.core.first.call(null,seq3071__$1);
var seq3071__$2 = cljs.core.next.call(null,seq3071__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3072,G__3073,seq3071__$2);
});

imcljs.fetch.rows = (function imcljs$fetch$rows(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3088 = arguments.length;
var i__4731__auto___3089 = (0);
while(true){
if((i__4731__auto___3089 < len__4730__auto___3088)){
args__4736__auto__.push((arguments[i__4731__auto___3089]));

var G__3090 = (i__4731__auto___3089 + (1));
i__4731__auto___3089 = G__3090;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3084){
var vec__3085 = p__3084;
var options = cljs.core.nth.call(null,vec__3085,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.rows.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.rows.cljs$lang$applyTo = (function (seq3081){
var G__3082 = cljs.core.first.call(null,seq3081);
var seq3081__$1 = cljs.core.next.call(null,seq3081);
var G__3083 = cljs.core.first.call(null,seq3081__$1);
var seq3081__$2 = cljs.core.next.call(null,seq3081__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3082,G__3083,seq3081__$2);
});

imcljs.fetch.row_count = (function imcljs$fetch$row_count(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3098 = arguments.length;
var i__4731__auto___3099 = (0);
while(true){
if((i__4731__auto___3099 < len__4730__auto___3098)){
args__4736__auto__.push((arguments[i__4731__auto___3099]));

var G__3100 = (i__4731__auto___3099 + (1));
i__4731__auto___3099 = G__3100;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__3094){
var vec__3095 = p__3094;
var options = cljs.core.nth.call(null,vec__3095,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"count"], null),options));
});

imcljs.fetch.row_count.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.row_count.cljs$lang$applyTo = (function (seq3091){
var G__3092 = cljs.core.first.call(null,seq3091);
var seq3091__$1 = cljs.core.next.call(null,seq3091);
var G__3093 = cljs.core.first.call(null,seq3091__$1);
var seq3091__$2 = cljs.core.next.call(null,seq3091__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3092,G__3093,seq3091__$2);
});

imcljs.fetch.possible_values = (function imcljs$fetch$possible_values(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3108 = arguments.length;
var i__4731__auto___3109 = (0);
while(true){
if((i__4731__auto___3109 < len__4730__auto___3108)){
args__4736__auto__.push((arguments[i__4731__auto___3109]));

var G__3110 = (i__4731__auto___3109 + (1));
i__4731__auto___3109 = G__3110;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,path,p__3104){
var vec__3105 = p__3104;
var options = cljs.core.nth.call(null,vec__3105,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/path/values",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),path,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.possible_values.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.possible_values.cljs$lang$applyTo = (function (seq3101){
var G__3102 = cljs.core.first.call(null,seq3101);
var seq3101__$1 = cljs.core.next.call(null,seq3101);
var G__3103 = cljs.core.first.call(null,seq3101__$1);
var seq3101__$2 = cljs.core.next.call(null,seq3101__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3102,G__3103,seq3101__$2);
});

/**
 * Fetches unique values for a path within a query. Providing a limit shortcircuits the request
 *   and returns false if the unique values exceed the limit
 */
imcljs.fetch.unique_values = (function imcljs$fetch$unique_values(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3189 = arguments.length;
var i__4731__auto___3190 = (0);
while(true){
if((i__4731__auto___3190 < len__4730__auto___3189)){
args__4736__auto__.push((arguments[i__4731__auto___3190]));

var G__3191 = (i__4731__auto___3190 + (1));
i__4731__auto___3190 = G__3191;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,path,p__3115){
var vec__3116 = p__3115;
var limit = cljs.core.nth.call(null,vec__3116,(0),null);
var return_chan = cljs.core.async.chan.call(null);
var c__2324__auto___3192 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2324__auto___3192,return_chan,vec__3116,limit){
return (function (){
var f__2325__auto__ = (function (){var switch__2301__auto__ = ((function (c__2324__auto___3192,return_chan,vec__3116,limit){
return (function (state_3166){
var state_val_3167 = (state_3166[(1)]);
if((state_val_3167 === (7))){
var state_3166__$1 = state_3166;
var statearr_3168_3193 = state_3166__$1;
(statearr_3168_3193[(2)] = false);

(statearr_3168_3193[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3167 === (1))){
var inst_3120 = [new cljs.core.Keyword(null,"summaryPath","summaryPath",599411983),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_3121 = [path,(1),"jsonrows"];
var inst_3122 = cljs.core.PersistentHashMap.fromArrays(inst_3120,inst_3121);
var inst_3123 = imcljs.fetch.rows.call(null,service,query,inst_3122);
var state_3166__$1 = state_3166;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3166__$1,(2),inst_3123);
} else {
if((state_val_3167 === (4))){
var state_3166__$1 = state_3166;
var statearr_3169_3194 = state_3166__$1;
(statearr_3169_3194[(2)] = false);

(statearr_3169_3194[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3167 === (15))){
var inst_3159 = (state_3166[(2)]);
var state_3166__$1 = state_3166;
var statearr_3170_3195 = state_3166__$1;
(statearr_3170_3195[(2)] = inst_3159);

(statearr_3170_3195[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3167 === (13))){
var state_3166__$1 = state_3166;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3166__$1,(17),return_chan,false);
} else {
if((state_val_3167 === (6))){
var state_3166__$1 = state_3166;
var statearr_3171_3196 = state_3166__$1;
(statearr_3171_3196[(2)] = true);

(statearr_3171_3196[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3167 === (17))){
var inst_3162 = (state_3166[(2)]);
var state_3166__$1 = state_3166;
var statearr_3172_3197 = state_3166__$1;
(statearr_3172_3197[(2)] = inst_3162);

(statearr_3172_3197[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3167 === (3))){
var inst_3125 = (state_3166[(7)]);
var inst_3130 = inst_3125.cljs$lang$protocol_mask$partition0$;
var inst_3131 = (inst_3130 & (64));
var inst_3132 = inst_3125.cljs$core$ISeq$;
var inst_3133 = (cljs.core.PROTOCOL_SENTINEL === inst_3132);
var inst_3134 = ((inst_3131) || (inst_3133));
var state_3166__$1 = state_3166;
if(cljs.core.truth_(inst_3134)){
var statearr_3173_3198 = state_3166__$1;
(statearr_3173_3198[(1)] = (6));

} else {
var statearr_3174_3199 = state_3166__$1;
(statearr_3174_3199[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3167 === (12))){
var inst_3152 = [new cljs.core.Keyword(null,"summaryPath","summaryPath",599411983),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_3153 = [path,limit,"jsonrows"];
var inst_3154 = cljs.core.PersistentHashMap.fromArrays(inst_3152,inst_3153);
var inst_3155 = imcljs.fetch.rows.call(null,service,query,inst_3154);
var state_3166__$1 = state_3166;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3166__$1,(16),inst_3155);
} else {
if((state_val_3167 === (2))){
var inst_3125 = (state_3166[(7)]);
var inst_3125__$1 = (state_3166[(2)]);
var inst_3127 = (inst_3125__$1 == null);
var inst_3128 = cljs.core.not.call(null,inst_3127);
var state_3166__$1 = (function (){var statearr_3175 = state_3166;
(statearr_3175[(7)] = inst_3125__$1);

return statearr_3175;
})();
if(inst_3128){
var statearr_3176_3200 = state_3166__$1;
(statearr_3176_3200[(1)] = (3));

} else {
var statearr_3177_3201 = state_3166__$1;
(statearr_3177_3201[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3167 === (11))){
var inst_3146 = (state_3166[(2)]);
var inst_3147 = cljs.core.get.call(null,inst_3146,new cljs.core.Keyword(null,"uniqueValues","uniqueValues",1661070646));
var inst_3148 = cljs.core.not.call(null,limit);
var inst_3149 = (inst_3147 <= limit);
var inst_3150 = ((inst_3148) || (inst_3149));
var state_3166__$1 = state_3166;
if(cljs.core.truth_(inst_3150)){
var statearr_3178_3202 = state_3166__$1;
(statearr_3178_3202[(1)] = (12));

} else {
var statearr_3179_3203 = state_3166__$1;
(statearr_3179_3203[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3167 === (9))){
var inst_3125 = (state_3166[(7)]);
var inst_3143 = cljs.core.apply.call(null,cljs.core.hash_map,inst_3125);
var state_3166__$1 = state_3166;
var statearr_3180_3204 = state_3166__$1;
(statearr_3180_3204[(2)] = inst_3143);

(statearr_3180_3204[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3167 === (5))){
var inst_3141 = (state_3166[(2)]);
var state_3166__$1 = state_3166;
if(cljs.core.truth_(inst_3141)){
var statearr_3181_3205 = state_3166__$1;
(statearr_3181_3205[(1)] = (9));

} else {
var statearr_3182_3206 = state_3166__$1;
(statearr_3182_3206[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3167 === (14))){
var inst_3164 = (state_3166[(2)]);
var state_3166__$1 = state_3166;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3166__$1,inst_3164);
} else {
if((state_val_3167 === (16))){
var inst_3157 = (state_3166[(2)]);
var state_3166__$1 = state_3166;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3166__$1,(15),return_chan,inst_3157);
} else {
if((state_val_3167 === (10))){
var inst_3125 = (state_3166[(7)]);
var state_3166__$1 = state_3166;
var statearr_3183_3207 = state_3166__$1;
(statearr_3183_3207[(2)] = inst_3125);

(statearr_3183_3207[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3167 === (8))){
var inst_3138 = (state_3166[(2)]);
var state_3166__$1 = state_3166;
var statearr_3184_3208 = state_3166__$1;
(statearr_3184_3208[(2)] = inst_3138);

(statearr_3184_3208[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2324__auto___3192,return_chan,vec__3116,limit))
;
return ((function (switch__2301__auto__,c__2324__auto___3192,return_chan,vec__3116,limit){
return (function() {
var imcljs$fetch$state_machine__2302__auto__ = null;
var imcljs$fetch$state_machine__2302__auto____0 = (function (){
var statearr_3185 = [null,null,null,null,null,null,null,null];
(statearr_3185[(0)] = imcljs$fetch$state_machine__2302__auto__);

(statearr_3185[(1)] = (1));

return statearr_3185;
});
var imcljs$fetch$state_machine__2302__auto____1 = (function (state_3166){
while(true){
var ret_value__2303__auto__ = (function (){try{while(true){
var result__2304__auto__ = switch__2301__auto__.call(null,state_3166);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2304__auto__;
}
break;
}
}catch (e3186){if((e3186 instanceof Object)){
var ex__2305__auto__ = e3186;
var statearr_3187_3209 = state_3166;
(statearr_3187_3209[(5)] = ex__2305__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3166);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3186;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2303__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3210 = state_3166;
state_3166 = G__3210;
continue;
} else {
return ret_value__2303__auto__;
}
break;
}
});
imcljs$fetch$state_machine__2302__auto__ = function(state_3166){
switch(arguments.length){
case 0:
return imcljs$fetch$state_machine__2302__auto____0.call(this);
case 1:
return imcljs$fetch$state_machine__2302__auto____1.call(this,state_3166);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$state_machine__2302__auto____0;
imcljs$fetch$state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$state_machine__2302__auto____1;
return imcljs$fetch$state_machine__2302__auto__;
})()
;})(switch__2301__auto__,c__2324__auto___3192,return_chan,vec__3116,limit))
})();
var state__2326__auto__ = (function (){var statearr_3188 = f__2325__auto__.call(null);
(statearr_3188[(6)] = c__2324__auto___3192);

return statearr_3188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2326__auto__);
});})(c__2324__auto___3192,return_chan,vec__3116,limit))
);


return return_chan;
});

imcljs.fetch.unique_values.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
imcljs.fetch.unique_values.cljs$lang$applyTo = (function (seq3111){
var G__3112 = cljs.core.first.call(null,seq3111);
var seq3111__$1 = cljs.core.next.call(null,seq3111);
var G__3113 = cljs.core.first.call(null,seq3111__$1);
var seq3111__$2 = cljs.core.next.call(null,seq3111__$1);
var G__3114 = cljs.core.first.call(null,seq3111__$2);
var seq3111__$3 = cljs.core.next.call(null,seq3111__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3112,G__3113,G__3114,seq3111__$3);
});

imcljs.fetch.lists = (function imcljs$fetch$lists(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3217 = arguments.length;
var i__4731__auto___3218 = (0);
while(true){
if((i__4731__auto___3218 < len__4730__auto___3217)){
args__4736__auto__.push((arguments[i__4731__auto___3218]));

var G__3219 = (i__4731__auto___3218 + (1));
i__4731__auto___3218 = G__3219;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3213){
var vec__3214 = p__3213;
var options = cljs.core.nth.call(null,vec__3214,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,options,new cljs.core.Keyword(null,"lists","lists",-884730684));
});

imcljs.fetch.lists.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.lists.cljs$lang$applyTo = (function (seq3211){
var G__3212 = cljs.core.first.call(null,seq3211);
var seq3211__$1 = cljs.core.next.call(null,seq3211);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3212,seq3211__$1);
});

imcljs.fetch.one_list = (function imcljs$fetch$one_list(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3227 = arguments.length;
var i__4731__auto___3228 = (0);
while(true){
if((i__4731__auto___3228 < len__4730__auto___3227)){
args__4736__auto__.push((arguments[i__4731__auto___3228]));

var G__3229 = (i__4731__auto___3228 + (1));
i__4731__auto___3228 = G__3229;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,p__3223){
var vec__3224 = p__3223;
var options = cljs.core.nth.call(null,vec__3224,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null),options),cljs.core.comp.call(null,cljs.core.first,new cljs.core.Keyword(null,"lists","lists",-884730684)));
});

imcljs.fetch.one_list.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.one_list.cljs$lang$applyTo = (function (seq3220){
var G__3221 = cljs.core.first.call(null,seq3220);
var seq3220__$1 = cljs.core.next.call(null,seq3220);
var G__3222 = cljs.core.first.call(null,seq3220__$1);
var seq3220__$2 = cljs.core.next.call(null,seq3220__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3221,G__3222,seq3220__$2);
});

imcljs.fetch.model = (function imcljs$fetch$model(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3236 = arguments.length;
var i__4731__auto___3237 = (0);
while(true){
if((i__4731__auto___3237 < len__4730__auto___3236)){
args__4736__auto__.push((arguments[i__4731__auto___3237]));

var G__3238 = (i__4731__auto___3237 + (1));
i__4731__auto___3237 = G__3238;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3232){
var vec__3233 = p__3232;
var options = cljs.core.nth.call(null,vec__3233,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/model",service,options,new cljs.core.Keyword(null,"model","model",331153215));
});

imcljs.fetch.model.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.model.cljs$lang$applyTo = (function (seq3230){
var G__3231 = cljs.core.first.call(null,seq3230);
var seq3230__$1 = cljs.core.next.call(null,seq3230);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3231,seq3230__$1);
});

imcljs.fetch.class_keys = (function imcljs$fetch$class_keys(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3245 = arguments.length;
var i__4731__auto___3246 = (0);
while(true){
if((i__4731__auto___3246 < len__4730__auto___3245)){
args__4736__auto__.push((arguments[i__4731__auto___3246]));

var G__3247 = (i__4731__auto___3246 + (1));
i__4731__auto___3246 = G__3247;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3241){
var vec__3242 = p__3241;
var options = cljs.core.nth.call(null,vec__3242,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/classkeys",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.class_keys.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.class_keys.cljs$lang$applyTo = (function (seq3239){
var G__3240 = cljs.core.first.call(null,seq3239);
var seq3239__$1 = cljs.core.next.call(null,seq3239);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3240,seq3239__$1);
});

imcljs.fetch.summary_fields = (function imcljs$fetch$summary_fields(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3254 = arguments.length;
var i__4731__auto___3255 = (0);
while(true){
if((i__4731__auto___3255 < len__4730__auto___3254)){
args__4736__auto__.push((arguments[i__4731__auto___3255]));

var G__3256 = (i__4731__auto___3255 + (1));
i__4731__auto___3255 = G__3256;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3250){
var vec__3251 = p__3250;
var options = cljs.core.nth.call(null,vec__3251,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/summaryfields",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.summary_fields.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.summary_fields.cljs$lang$applyTo = (function (seq3248){
var G__3249 = cljs.core.first.call(null,seq3248);
var seq3248__$1 = cljs.core.next.call(null,seq3248);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3249,seq3248__$1);
});

imcljs.fetch.templates = (function imcljs$fetch$templates(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3263 = arguments.length;
var i__4731__auto___3264 = (0);
while(true){
if((i__4731__auto___3264 < len__4730__auto___3263)){
args__4736__auto__.push((arguments[i__4731__auto___3264]));

var G__3265 = (i__4731__auto___3264 + (1));
i__4731__auto___3264 = G__3265;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3259){
var vec__3260 = p__3259;
var options = cljs.core.nth.call(null,vec__3260,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/templates",service,options,new cljs.core.Keyword(null,"templates","templates",-1237401733));
});

imcljs.fetch.templates.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.templates.cljs$lang$applyTo = (function (seq3257){
var G__3258 = cljs.core.first.call(null,seq3257);
var seq3257__$1 = cljs.core.next.call(null,seq3257);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3258,seq3257__$1);
});

/**
 * Returns a temporary API token.
 */
imcljs.fetch.session = (function imcljs$fetch$session(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3272 = arguments.length;
var i__4731__auto___3273 = (0);
while(true){
if((i__4731__auto___3273 < len__4730__auto___3272)){
args__4736__auto__.push((arguments[i__4731__auto___3273]));

var G__3274 = (i__4731__auto___3273 + (1));
i__4731__auto___3273 = G__3274;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3268){
var vec__3269 = p__3268;
var options = cljs.core.nth.call(null,vec__3269,(0),null);
var token_free_service = cljs.core.dissoc.call(null,service,new cljs.core.Keyword(null,"token","token",-1211463215));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/session",token_free_service,options,new cljs.core.Keyword(null,"token","token",-1211463215));
});

imcljs.fetch.session.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.session.cljs$lang$applyTo = (function (seq3266){
var G__3267 = cljs.core.first.call(null,seq3266);
var seq3266__$1 = cljs.core.next.call(null,seq3266);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3267,seq3266__$1);
});

/**
 * Returns list of widgets available for a given mine
 */
imcljs.fetch.widgets = (function imcljs$fetch$widgets(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3281 = arguments.length;
var i__4731__auto___3282 = (0);
while(true){
if((i__4731__auto___3282 < len__4730__auto___3281)){
args__4736__auto__.push((arguments[i__4731__auto___3282]));

var G__3283 = (i__4731__auto___3282 + (1));
i__4731__auto___3282 = G__3283;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3277){
var vec__3278 = p__3277;
var options = cljs.core.nth.call(null,vec__3278,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/widgets",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),new cljs.core.Keyword(null,"widgets","widgets",-159098978));
});

imcljs.fetch.widgets.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.widgets.cljs$lang$applyTo = (function (seq3275){
var G__3276 = cljs.core.first.call(null,seq3275);
var seq3275__$1 = cljs.core.next.call(null,seq3275);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3276,seq3275__$1);
});

/**
 * Returns enrichment results
 */
imcljs.fetch.enrichment = (function imcljs$fetch$enrichment(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3290 = arguments.length;
var i__4731__auto___3291 = (0);
while(true){
if((i__4731__auto___3291 < len__4730__auto___3290)){
args__4736__auto__.push((arguments[i__4731__auto___3291]));

var G__3292 = (i__4731__auto___3291 + (1));
i__4731__auto___3291 = G__3292;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__3286){
var vec__3287 = p__3286;
var options = cljs.core.nth.call(null,vec__3287,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/enrichment",service,cljs.core.merge.call(null,imcljs.internal.defaults.default_enrichment,options));
});

imcljs.fetch.enrichment.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.fetch.enrichment.cljs$lang$applyTo = (function (seq3284){
var G__3285 = cljs.core.first.call(null,seq3284);
var seq3284__$1 = cljs.core.next.call(null,seq3284);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3285,seq3284__$1);
});

/**
 * Returns the version of the InterMine WebService being run, e.g. '27'
 */
imcljs.fetch.version_web_service = (function imcljs$fetch$version_web_service(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
imcljs.fetch.version_release = (function imcljs$fetch$version_release(service){

return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/release",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the version of InterMine being run, e.g. '1.6.6'
 */
imcljs.fetch.version_intermine = (function imcljs$fetch$version_intermine(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/intermine",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the default configs for a given mine. These are important as they're
 * used to initialise most bluegenes page sections! 
 */
imcljs.fetch.web_properties = (function imcljs$fetch$web_properties(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/web-properties",service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"web-properties","web-properties",-1421911737));
});
/**
 * Fetches the results of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_results = (function imcljs$fetch$fetch_id_resolution_job_results(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),["/ids/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),"/results"].join(''),service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"results","results",-1134170113));
});
/**
 * Fetches the status of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_status = (function imcljs$fetch$fetch_id_resolution_job_status(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),["/ids/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),"/status"].join(''),service);
});
/**
 * Starts an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job = (function imcljs$fetch$fetch_id_resolution_job(service,p__3293){
var map__3294 = p__3293;
var map__3294__$1 = (((((!((map__3294 == null))))?(((((map__3294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3294.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3294):map__3294);
var options = map__3294__$1;
var identifiers = cljs.core.get.call(null,map__3294__$1,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722));
var type = cljs.core.get.call(null,map__3294__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__3294__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var wild_cards = cljs.core.get.call(null,map__3294__$1,new cljs.core.Keyword(null,"wild-cards","wild-cards",681119344));
var extra = cljs.core.get.call(null,map__3294__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post-body","post-body",-1481559189),"/ids",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),(function (){var G__3296 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722),identifiers], null);
var G__3296__$1 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__3296,new cljs.core.Keyword(null,"type","type",1174270348),type):G__3296);
var G__3296__$2 = (cljs.core.truth_(case_sensitive)?cljs.core.assoc.call(null,G__3296__$1,new cljs.core.Keyword(null,"caseSensitive","caseSensitive",-586669673),true):G__3296__$1);
var G__3296__$3 = (cljs.core.truth_(wild_cards)?cljs.core.assoc.call(null,G__3296__$2,new cljs.core.Keyword(null,"wildCards","wildCards",-2054689560),true):G__3296__$2);
if(cljs.core.truth_(extra)){
return cljs.core.assoc.call(null,G__3296__$3,new cljs.core.Keyword(null,"extra","extra",1612569067),extra);
} else {
return G__3296__$3;
}
})(),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null)], null));
});
/**
 * Resolves identifiers. Automatically handles polling
 */
imcljs.fetch.resolve_identifiers = (function imcljs$fetch$resolve_identifiers(service,p__3297){
var map__3298 = p__3297;
var map__3298__$1 = (((((!((map__3298 == null))))?(((((map__3298.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3298.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3298):map__3298);
var options = map__3298__$1;
var identifiers = cljs.core.get.call(null,map__3298__$1,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722));
var type = cljs.core.get.call(null,map__3298__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__3298__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var wild_cards = cljs.core.get.call(null,map__3298__$1,new cljs.core.Keyword(null,"wild-cards","wild-cards",681119344));
var extra = cljs.core.get.call(null,map__3298__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
var timeout_ms = cljs.core.get.call(null,map__3298__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var return_chan = cljs.core.async.chan.call(null,(1));
var c__2324__auto___3410 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (){
var f__2325__auto__ = (function (){var switch__2301__auto__ = ((function (c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (state_3368){
var state_val_3369 = (state_3368[(1)]);
if((state_val_3369 === (1))){
var inst_3300 = imcljs.fetch.fetch_id_resolution_job.call(null,service,options);
var state_3368__$1 = state_3368;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3368__$1,(2),inst_3300);
} else {
if((state_val_3369 === (2))){
var inst_3302 = (state_3368[(2)]);
var inst_3364 = cljs.core.async.chan.call(null,(1));
var inst_3365 = (function (){var job = inst_3302;
var c__2324__auto____$1 = inst_3364;
return ((function (job,c__2324__auto____$1,inst_3302,inst_3364,state_val_3369,c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (){
var f__2325__auto__ = (function (){var switch__2301__auto__ = ((function (job,c__2324__auto____$1,inst_3302,inst_3364,state_val_3369,c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (state_3362){
var state_val_3363 = (state_3362[(1)]);
if((state_val_3363 === (7))){
var inst_3325 = (state_3362[(2)]);
var state_3362__$1 = state_3362;
if(cljs.core.truth_(inst_3325)){
var statearr_3370_3411 = state_3362__$1;
(statearr_3370_3411[(1)] = (11));

} else {
var statearr_3371_3412 = state_3362__$1;
(statearr_3371_3412[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (20))){
var state_3362__$1 = state_3362;
var statearr_3372_3413 = state_3362__$1;
(statearr_3372_3413[(2)] = timeout_ms);

(statearr_3372_3413[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (1))){
var inst_3303 = (100);
var state_3362__$1 = (function (){var statearr_3373 = state_3362;
(statearr_3373[(7)] = inst_3303);

return statearr_3373;
})();
var statearr_3374_3414 = state_3362__$1;
(statearr_3374_3414[(2)] = null);

(statearr_3374_3414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (24))){
var state_3362__$1 = state_3362;
var statearr_3375_3415 = state_3362__$1;
(statearr_3375_3415[(2)] = null);

(statearr_3375_3415[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (4))){
var inst_3309 = (state_3362[(8)]);
var inst_3309__$1 = (state_3362[(2)]);
var inst_3311 = (inst_3309__$1 == null);
var inst_3312 = cljs.core.not.call(null,inst_3311);
var state_3362__$1 = (function (){var statearr_3376 = state_3362;
(statearr_3376[(8)] = inst_3309__$1);

return statearr_3376;
})();
if(inst_3312){
var statearr_3377_3416 = state_3362__$1;
(statearr_3377_3416[(1)] = (5));

} else {
var statearr_3378_3417 = state_3362__$1;
(statearr_3378_3417[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (15))){
var inst_3303 = (state_3362[(7)]);
var inst_3342 = cljs.core.async.timeout.call(null,inst_3303);
var state_3362__$1 = state_3362;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3362__$1,(19),inst_3342);
} else {
if((state_val_3363 === (21))){
var state_3362__$1 = state_3362;
var statearr_3379_3418 = state_3362__$1;
(statearr_3379_3418[(2)] = (30000));

(statearr_3379_3418[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (13))){
var inst_3330 = (state_3362[(2)]);
var inst_3331 = cljs.core.get.call(null,inst_3330,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_3332 = cljs.core.get.call(null,inst_3330,new cljs.core.Keyword(null,"uid","uid",-1447769400));
var inst_3333 = cljs.core._EQ_.call(null,"SUCCESS",inst_3331);
var state_3362__$1 = (function (){var statearr_3380 = state_3362;
(statearr_3380[(9)] = inst_3332);

return statearr_3380;
})();
if(inst_3333){
var statearr_3381_3419 = state_3362__$1;
(statearr_3381_3419[(1)] = (14));

} else {
var statearr_3382_3420 = state_3362__$1;
(statearr_3382_3420[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (22))){
var inst_3303 = (state_3362[(7)]);
var inst_3348 = (state_3362[(2)]);
var inst_3349 = (inst_3303 < inst_3348);
var state_3362__$1 = state_3362;
if(cljs.core.truth_(inst_3349)){
var statearr_3383_3421 = state_3362__$1;
(statearr_3383_3421[(1)] = (23));

} else {
var statearr_3384_3422 = state_3362__$1;
(statearr_3384_3422[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (6))){
var state_3362__$1 = state_3362;
var statearr_3385_3423 = state_3362__$1;
(statearr_3385_3423[(2)] = false);

(statearr_3385_3423[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (25))){
var inst_3356 = (state_3362[(2)]);
var state_3362__$1 = state_3362;
var statearr_3386_3424 = state_3362__$1;
(statearr_3386_3424[(2)] = inst_3356);

(statearr_3386_3424[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (17))){
var inst_3338 = (state_3362[(2)]);
var state_3362__$1 = state_3362;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3362__$1,(18),return_chan,inst_3338);
} else {
if((state_val_3363 === (3))){
var inst_3360 = (state_3362[(2)]);
var state_3362__$1 = state_3362;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3362__$1,inst_3360);
} else {
if((state_val_3363 === (12))){
var inst_3309 = (state_3362[(8)]);
var state_3362__$1 = state_3362;
var statearr_3387_3425 = state_3362__$1;
(statearr_3387_3425[(2)] = inst_3309);

(statearr_3387_3425[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (2))){
var inst_3306 = new cljs.core.Keyword(null,"uid","uid",-1447769400).cljs$core$IFn$_invoke$arity$1(job);
var inst_3307 = imcljs.fetch.fetch_id_resolution_job_status.call(null,service,inst_3306);
var state_3362__$1 = state_3362;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3362__$1,(4),inst_3307);
} else {
if((state_val_3363 === (23))){
var inst_3303 = (state_3362[(7)]);
var inst_3351 = (inst_3303 * 1.5);
var inst_3352 = (((1000) < inst_3351) ? (1000) : inst_3351);
var inst_3303__$1 = inst_3352;
var state_3362__$1 = (function (){var statearr_3388 = state_3362;
(statearr_3388[(7)] = inst_3303__$1);

return statearr_3388;
})();
var statearr_3389_3426 = state_3362__$1;
(statearr_3389_3426[(2)] = null);

(statearr_3389_3426[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (19))){
var inst_3344 = (state_3362[(2)]);
var state_3362__$1 = (function (){var statearr_3390 = state_3362;
(statearr_3390[(10)] = inst_3344);

return statearr_3390;
})();
if(cljs.core.truth_(timeout_ms)){
var statearr_3391_3427 = state_3362__$1;
(statearr_3391_3427[(1)] = (20));

} else {
var statearr_3392_3428 = state_3362__$1;
(statearr_3392_3428[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (11))){
var inst_3309 = (state_3362[(8)]);
var inst_3327 = cljs.core.apply.call(null,cljs.core.hash_map,inst_3309);
var state_3362__$1 = state_3362;
var statearr_3393_3429 = state_3362__$1;
(statearr_3393_3429[(2)] = inst_3327);

(statearr_3393_3429[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (9))){
var state_3362__$1 = state_3362;
var statearr_3394_3430 = state_3362__$1;
(statearr_3394_3430[(2)] = false);

(statearr_3394_3430[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (5))){
var inst_3309 = (state_3362[(8)]);
var inst_3314 = inst_3309.cljs$lang$protocol_mask$partition0$;
var inst_3315 = (inst_3314 & (64));
var inst_3316 = inst_3309.cljs$core$ISeq$;
var inst_3317 = (cljs.core.PROTOCOL_SENTINEL === inst_3316);
var inst_3318 = ((inst_3315) || (inst_3317));
var state_3362__$1 = state_3362;
if(cljs.core.truth_(inst_3318)){
var statearr_3395_3431 = state_3362__$1;
(statearr_3395_3431[(1)] = (8));

} else {
var statearr_3396_3432 = state_3362__$1;
(statearr_3396_3432[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (14))){
var inst_3335 = new cljs.core.Keyword(null,"uid","uid",-1447769400).cljs$core$IFn$_invoke$arity$1(job);
var inst_3336 = imcljs.fetch.fetch_id_resolution_job_results.call(null,service,inst_3335);
var state_3362__$1 = state_3362;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3362__$1,(17),inst_3336);
} else {
if((state_val_3363 === (16))){
var inst_3358 = (state_3362[(2)]);
var state_3362__$1 = state_3362;
var statearr_3397_3433 = state_3362__$1;
(statearr_3397_3433[(2)] = inst_3358);

(statearr_3397_3433[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (10))){
var inst_3322 = (state_3362[(2)]);
var state_3362__$1 = state_3362;
var statearr_3398_3434 = state_3362__$1;
(statearr_3398_3434[(2)] = inst_3322);

(statearr_3398_3434[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (18))){
var inst_3340 = (state_3362[(2)]);
var state_3362__$1 = state_3362;
var statearr_3399_3435 = state_3362__$1;
(statearr_3399_3435[(2)] = inst_3340);

(statearr_3399_3435[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3363 === (8))){
var state_3362__$1 = state_3362;
var statearr_3400_3436 = state_3362__$1;
(statearr_3400_3436[(2)] = true);

(statearr_3400_3436[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(job,c__2324__auto____$1,inst_3302,inst_3364,state_val_3369,c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
;
return ((function (switch__2301__auto__,job,c__2324__auto____$1,inst_3302,inst_3364,state_val_3369,c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function() {
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__ = null;
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0 = (function (){
var statearr_3401 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_3401[(0)] = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__);

(statearr_3401[(1)] = (1));

return statearr_3401;
});
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1 = (function (state_3362){
while(true){
var ret_value__2303__auto__ = (function (){try{while(true){
var result__2304__auto__ = switch__2301__auto__.call(null,state_3362);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2304__auto__;
}
break;
}
}catch (e3402){if((e3402 instanceof Object)){
var ex__2305__auto__ = e3402;
var statearr_3403_3437 = state_3362;
(statearr_3403_3437[(5)] = ex__2305__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3362);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3402;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2303__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3438 = state_3362;
state_3362 = G__3438;
continue;
} else {
return ret_value__2303__auto__;
}
break;
}
});
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__ = function(state_3362){
switch(arguments.length){
case 0:
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0.call(this);
case 1:
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1.call(this,state_3362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0;
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1;
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__;
})()
;})(switch__2301__auto__,job,c__2324__auto____$1,inst_3302,inst_3364,state_val_3369,c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var state__2326__auto__ = (function (){var statearr_3404 = f__2325__auto__.call(null);
(statearr_3404[(6)] = c__2324__auto____$1);

return statearr_3404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2326__auto__);
});
;})(job,c__2324__auto____$1,inst_3302,inst_3364,state_val_3369,c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var inst_3366 = cljs.core.async.impl.dispatch.run.call(null,inst_3365);
var state_3368__$1 = (function (){var statearr_3405 = state_3368;
(statearr_3405[(7)] = inst_3366);

return statearr_3405;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3368__$1,inst_3364);
} else {
return null;
}
}
});})(c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
;
return ((function (switch__2301__auto__,c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function() {
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__ = null;
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0 = (function (){
var statearr_3406 = [null,null,null,null,null,null,null,null];
(statearr_3406[(0)] = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__);

(statearr_3406[(1)] = (1));

return statearr_3406;
});
var imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1 = (function (state_3368){
while(true){
var ret_value__2303__auto__ = (function (){try{while(true){
var result__2304__auto__ = switch__2301__auto__.call(null,state_3368);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2304__auto__;
}
break;
}
}catch (e3407){if((e3407 instanceof Object)){
var ex__2305__auto__ = e3407;
var statearr_3408_3439 = state_3368;
(statearr_3408_3439[(5)] = ex__2305__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3368);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3407;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2303__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3440 = state_3368;
state_3368 = G__3440;
continue;
} else {
return ret_value__2303__auto__;
}
break;
}
});
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__ = function(state_3368){
switch(arguments.length){
case 0:
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0.call(this);
case 1:
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1.call(this,state_3368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____0;
imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto____1;
return imcljs$fetch$resolve_identifiers_$_state_machine__2302__auto__;
})()
;})(switch__2301__auto__,c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var state__2326__auto__ = (function (){var statearr_3409 = f__2325__auto__.call(null);
(statearr_3409[(6)] = c__2324__auto___3410);

return statearr_3409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2326__auto__);
});})(c__2324__auto___3410,return_chan,map__3298,map__3298__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
);


return return_chan;
});
/**
 * Returns generated code to run the query in a given language
 */
imcljs.fetch.code = (function imcljs$fetch$code(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3450 = arguments.length;
var i__4731__auto___3451 = (0);
while(true){
if((i__4731__auto___3451 < len__4730__auto___3450)){
args__4736__auto__.push((arguments[i__4731__auto___3451]));

var G__3452 = (i__4731__auto___3451 + (1));
i__4731__auto___3451 = G__3452;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((2) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4737__auto__);
});

imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic = (function (service,model,p__3444){
var vec__3445 = p__3444;
var map__3448 = cljs.core.nth.call(null,vec__3445,(0),null);
var map__3448__$1 = (((((!((map__3448 == null))))?(((((map__3448.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3448.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3448):map__3448);
var options = map__3448__$1;
var lang = cljs.core.get.call(null,map__3448__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
var query = cljs.core.get.call(null,map__3448__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/query/code",service,cljs.core.update.call(null,cljs.core.merge.call(null,options,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null)),new cljs.core.Keyword(null,"query","query",-1288509510),cljs.core.partial.call(null,imcljs.query.__GT_xml,model)),new cljs.core.Keyword(null,"code","code",1586293142));
});

imcljs.fetch.code.cljs$lang$maxFixedArity = (2);

/** @this {Function} */
imcljs.fetch.code.cljs$lang$applyTo = (function (seq3441){
var G__3442 = cljs.core.first.call(null,seq3441);
var seq3441__$1 = cljs.core.next.call(null,seq3441);
var G__3443 = cljs.core.first.call(null,seq3441__$1);
var seq3441__$2 = cljs.core.next.call(null,seq3441__$1);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3442,G__3443,seq3441__$2);
});

/**
 * Returns list of InterMines from the InterMine registry. dev-mines? needs to
 * be set to true if you want to return non-prod mines, or otherwise set to false
 */
imcljs.fetch.registry = (function imcljs$fetch$registry(dev_mines_QMARK_){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"raw","raw",1604651272),new cljs.core.Keyword(null,"get","get",1683182755),"/instances",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"root","root",-448657453),"http://registry.intermine.org/service"], null),(cljs.core.truth_(dev_mines_QMARK_)?new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query-params","query-params",900640534),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mines","mines",-1960796490),"all"], null)], null):null),new cljs.core.Keyword(null,"instances","instances",-335364781));
});

//# sourceMappingURL=fetch.js.map
