// Compiled by ClojureScript 1.10.520 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__28454 = arguments.length;
switch (G__28454) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28455 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28455 = (function (f,blockable,meta28456){
this.f = f;
this.blockable = blockable;
this.meta28456 = meta28456;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28455.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28457,meta28456__$1){
var self__ = this;
var _28457__$1 = this;
return (new cljs.core.async.t_cljs$core$async28455(self__.f,self__.blockable,meta28456__$1));
});

cljs.core.async.t_cljs$core$async28455.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28457){
var self__ = this;
var _28457__$1 = this;
return self__.meta28456;
});

cljs.core.async.t_cljs$core$async28455.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28455.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async28455.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async28455.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async28455.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta28456","meta28456",-455703268,null)], null);
});

cljs.core.async.t_cljs$core$async28455.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28455.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28455";

cljs.core.async.t_cljs$core$async28455.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async28455");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28455.
 */
cljs.core.async.__GT_t_cljs$core$async28455 = (function cljs$core$async$__GT_t_cljs$core$async28455(f__$1,blockable__$1,meta28456){
return (new cljs.core.async.t_cljs$core$async28455(f__$1,blockable__$1,meta28456));
});

}

return (new cljs.core.async.t_cljs$core$async28455(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__28461 = arguments.length;
switch (G__28461) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__28464 = arguments.length;
switch (G__28464) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__28467 = arguments.length;
switch (G__28467) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_28469 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_28469);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_28469,ret){
return (function (){
return fn1.call(null,val_28469);
});})(val_28469,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__28471 = arguments.length;
switch (G__28471) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5733__auto__)){
var ret = temp__5733__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5733__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5733__auto__)){
var retb = temp__5733__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5733__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5733__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___28473 = n;
var x_28474 = (0);
while(true){
if((x_28474 < n__4607__auto___28473)){
(a[x_28474] = x_28474);

var G__28475 = (x_28474 + (1));
x_28474 = G__28475;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28476 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28476 = (function (flag,meta28477){
this.flag = flag;
this.meta28477 = meta28477;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28476.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_28478,meta28477__$1){
var self__ = this;
var _28478__$1 = this;
return (new cljs.core.async.t_cljs$core$async28476(self__.flag,meta28477__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async28476.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_28478){
var self__ = this;
var _28478__$1 = this;
return self__.meta28477;
});})(flag))
;

cljs.core.async.t_cljs$core$async28476.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28476.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async28476.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async28476.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async28476.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta28477","meta28477",-1272062400,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async28476.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28476.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28476";

cljs.core.async.t_cljs$core$async28476.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async28476");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28476.
 */
cljs.core.async.__GT_t_cljs$core$async28476 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async28476(flag__$1,meta28477){
return (new cljs.core.async.t_cljs$core$async28476(flag__$1,meta28477));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async28476(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28479 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28479 = (function (flag,cb,meta28480){
this.flag = flag;
this.cb = cb;
this.meta28480 = meta28480;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28479.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28481,meta28480__$1){
var self__ = this;
var _28481__$1 = this;
return (new cljs.core.async.t_cljs$core$async28479(self__.flag,self__.cb,meta28480__$1));
});

cljs.core.async.t_cljs$core$async28479.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28481){
var self__ = this;
var _28481__$1 = this;
return self__.meta28480;
});

cljs.core.async.t_cljs$core$async28479.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28479.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async28479.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async28479.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async28479.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta28480","meta28480",-483998124,null)], null);
});

cljs.core.async.t_cljs$core$async28479.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28479.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28479";

cljs.core.async.t_cljs$core$async28479.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async28479");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28479.
 */
cljs.core.async.__GT_t_cljs$core$async28479 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async28479(flag__$1,cb__$1,meta28480){
return (new cljs.core.async.t_cljs$core$async28479(flag__$1,cb__$1,meta28480));
});

}

return (new cljs.core.async.t_cljs$core$async28479(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count.call(null,ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28482_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28482_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__28483_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28483_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__28484 = (i + (1));
i = G__28484;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5735__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5735__auto__)){
var got = temp__5735__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___28490 = arguments.length;
var i__4731__auto___28491 = (0);
while(true){
if((i__4731__auto___28491 < len__4730__auto___28490)){
args__4736__auto__.push((arguments[i__4731__auto___28491]));

var G__28492 = (i__4731__auto___28491 + (1));
i__4731__auto___28491 = G__28492;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__28487){
var map__28488 = p__28487;
var map__28488__$1 = (((((!((map__28488 == null))))?(((((map__28488.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28488.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__28488):map__28488);
var opts = map__28488__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq28485){
var G__28486 = cljs.core.first.call(null,seq28485);
var seq28485__$1 = cljs.core.next.call(null,seq28485);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28486,seq28485__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__28494 = arguments.length;
switch (G__28494) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__26531__auto___28540 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___28540){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___28540){
return (function (state_28518){
var state_val_28519 = (state_28518[(1)]);
if((state_val_28519 === (7))){
var inst_28514 = (state_28518[(2)]);
var state_28518__$1 = state_28518;
var statearr_28520_28541 = state_28518__$1;
(statearr_28520_28541[(2)] = inst_28514);

(statearr_28520_28541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28519 === (1))){
var state_28518__$1 = state_28518;
var statearr_28521_28542 = state_28518__$1;
(statearr_28521_28542[(2)] = null);

(statearr_28521_28542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28519 === (4))){
var inst_28497 = (state_28518[(7)]);
var inst_28497__$1 = (state_28518[(2)]);
var inst_28498 = (inst_28497__$1 == null);
var state_28518__$1 = (function (){var statearr_28522 = state_28518;
(statearr_28522[(7)] = inst_28497__$1);

return statearr_28522;
})();
if(cljs.core.truth_(inst_28498)){
var statearr_28523_28543 = state_28518__$1;
(statearr_28523_28543[(1)] = (5));

} else {
var statearr_28524_28544 = state_28518__$1;
(statearr_28524_28544[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28519 === (13))){
var state_28518__$1 = state_28518;
var statearr_28525_28545 = state_28518__$1;
(statearr_28525_28545[(2)] = null);

(statearr_28525_28545[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28519 === (6))){
var inst_28497 = (state_28518[(7)]);
var state_28518__$1 = state_28518;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28518__$1,(11),to,inst_28497);
} else {
if((state_val_28519 === (3))){
var inst_28516 = (state_28518[(2)]);
var state_28518__$1 = state_28518;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28518__$1,inst_28516);
} else {
if((state_val_28519 === (12))){
var state_28518__$1 = state_28518;
var statearr_28526_28546 = state_28518__$1;
(statearr_28526_28546[(2)] = null);

(statearr_28526_28546[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28519 === (2))){
var state_28518__$1 = state_28518;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28518__$1,(4),from);
} else {
if((state_val_28519 === (11))){
var inst_28507 = (state_28518[(2)]);
var state_28518__$1 = state_28518;
if(cljs.core.truth_(inst_28507)){
var statearr_28527_28547 = state_28518__$1;
(statearr_28527_28547[(1)] = (12));

} else {
var statearr_28528_28548 = state_28518__$1;
(statearr_28528_28548[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28519 === (9))){
var state_28518__$1 = state_28518;
var statearr_28529_28549 = state_28518__$1;
(statearr_28529_28549[(2)] = null);

(statearr_28529_28549[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28519 === (5))){
var state_28518__$1 = state_28518;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28530_28550 = state_28518__$1;
(statearr_28530_28550[(1)] = (8));

} else {
var statearr_28531_28551 = state_28518__$1;
(statearr_28531_28551[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28519 === (14))){
var inst_28512 = (state_28518[(2)]);
var state_28518__$1 = state_28518;
var statearr_28532_28552 = state_28518__$1;
(statearr_28532_28552[(2)] = inst_28512);

(statearr_28532_28552[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28519 === (10))){
var inst_28504 = (state_28518[(2)]);
var state_28518__$1 = state_28518;
var statearr_28533_28553 = state_28518__$1;
(statearr_28533_28553[(2)] = inst_28504);

(statearr_28533_28553[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28519 === (8))){
var inst_28501 = cljs.core.async.close_BANG_.call(null,to);
var state_28518__$1 = state_28518;
var statearr_28534_28554 = state_28518__$1;
(statearr_28534_28554[(2)] = inst_28501);

(statearr_28534_28554[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___28540))
;
return ((function (switch__26364__auto__,c__26531__auto___28540){
return (function() {
var cljs$core$async$state_machine__26365__auto__ = null;
var cljs$core$async$state_machine__26365__auto____0 = (function (){
var statearr_28535 = [null,null,null,null,null,null,null,null];
(statearr_28535[(0)] = cljs$core$async$state_machine__26365__auto__);

(statearr_28535[(1)] = (1));

return statearr_28535;
});
var cljs$core$async$state_machine__26365__auto____1 = (function (state_28518){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_28518);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e28536){if((e28536 instanceof Object)){
var ex__26368__auto__ = e28536;
var statearr_28537_28555 = state_28518;
(statearr_28537_28555[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28518);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28536;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28556 = state_28518;
state_28518 = G__28556;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$state_machine__26365__auto__ = function(state_28518){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26365__auto____1.call(this,state_28518);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26365__auto____0;
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26365__auto____1;
return cljs$core$async$state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___28540))
})();
var state__26533__auto__ = (function (){var statearr_28538 = f__26532__auto__.call(null);
(statearr_28538[(6)] = c__26531__auto___28540);

return statearr_28538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___28540))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__28557){
var vec__28558 = p__28557;
var v = cljs.core.nth.call(null,vec__28558,(0),null);
var p = cljs.core.nth.call(null,vec__28558,(1),null);
var job = vec__28558;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__26531__auto___28729 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___28729,res,vec__28558,v,p,job,jobs,results){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___28729,res,vec__28558,v,p,job,jobs,results){
return (function (state_28565){
var state_val_28566 = (state_28565[(1)]);
if((state_val_28566 === (1))){
var state_28565__$1 = state_28565;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28565__$1,(2),res,v);
} else {
if((state_val_28566 === (2))){
var inst_28562 = (state_28565[(2)]);
var inst_28563 = cljs.core.async.close_BANG_.call(null,res);
var state_28565__$1 = (function (){var statearr_28567 = state_28565;
(statearr_28567[(7)] = inst_28562);

return statearr_28567;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28565__$1,inst_28563);
} else {
return null;
}
}
});})(c__26531__auto___28729,res,vec__28558,v,p,job,jobs,results))
;
return ((function (switch__26364__auto__,c__26531__auto___28729,res,vec__28558,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0 = (function (){
var statearr_28568 = [null,null,null,null,null,null,null,null];
(statearr_28568[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__);

(statearr_28568[(1)] = (1));

return statearr_28568;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1 = (function (state_28565){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_28565);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e28569){if((e28569 instanceof Object)){
var ex__26368__auto__ = e28569;
var statearr_28570_28730 = state_28565;
(statearr_28570_28730[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28565);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28569;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28731 = state_28565;
state_28565 = G__28731;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__ = function(state_28565){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1.call(this,state_28565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___28729,res,vec__28558,v,p,job,jobs,results))
})();
var state__26533__auto__ = (function (){var statearr_28571 = f__26532__auto__.call(null);
(statearr_28571[(6)] = c__26531__auto___28729);

return statearr_28571;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___28729,res,vec__28558,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__28572){
var vec__28573 = p__28572;
var v = cljs.core.nth.call(null,vec__28573,(0),null);
var p = cljs.core.nth.call(null,vec__28573,(1),null);
var job = vec__28573;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___28732 = n;
var __28733 = (0);
while(true){
if((__28733 < n__4607__auto___28732)){
var G__28576_28734 = type;
var G__28576_28735__$1 = (((G__28576_28734 instanceof cljs.core.Keyword))?G__28576_28734.fqn:null);
switch (G__28576_28735__$1) {
case "compute":
var c__26531__auto___28737 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__28733,c__26531__auto___28737,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (__28733,c__26531__auto___28737,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async){
return (function (state_28589){
var state_val_28590 = (state_28589[(1)]);
if((state_val_28590 === (1))){
var state_28589__$1 = state_28589;
var statearr_28591_28738 = state_28589__$1;
(statearr_28591_28738[(2)] = null);

(statearr_28591_28738[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28590 === (2))){
var state_28589__$1 = state_28589;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28589__$1,(4),jobs);
} else {
if((state_val_28590 === (3))){
var inst_28587 = (state_28589[(2)]);
var state_28589__$1 = state_28589;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28589__$1,inst_28587);
} else {
if((state_val_28590 === (4))){
var inst_28579 = (state_28589[(2)]);
var inst_28580 = process.call(null,inst_28579);
var state_28589__$1 = state_28589;
if(cljs.core.truth_(inst_28580)){
var statearr_28592_28739 = state_28589__$1;
(statearr_28592_28739[(1)] = (5));

} else {
var statearr_28593_28740 = state_28589__$1;
(statearr_28593_28740[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28590 === (5))){
var state_28589__$1 = state_28589;
var statearr_28594_28741 = state_28589__$1;
(statearr_28594_28741[(2)] = null);

(statearr_28594_28741[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28590 === (6))){
var state_28589__$1 = state_28589;
var statearr_28595_28742 = state_28589__$1;
(statearr_28595_28742[(2)] = null);

(statearr_28595_28742[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28590 === (7))){
var inst_28585 = (state_28589[(2)]);
var state_28589__$1 = state_28589;
var statearr_28596_28743 = state_28589__$1;
(statearr_28596_28743[(2)] = inst_28585);

(statearr_28596_28743[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__28733,c__26531__auto___28737,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async))
;
return ((function (__28733,switch__26364__auto__,c__26531__auto___28737,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0 = (function (){
var statearr_28597 = [null,null,null,null,null,null,null];
(statearr_28597[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__);

(statearr_28597[(1)] = (1));

return statearr_28597;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1 = (function (state_28589){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_28589);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e28598){if((e28598 instanceof Object)){
var ex__26368__auto__ = e28598;
var statearr_28599_28744 = state_28589;
(statearr_28599_28744[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28589);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28598;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28745 = state_28589;
state_28589 = G__28745;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__ = function(state_28589){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1.call(this,state_28589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__;
})()
;})(__28733,switch__26364__auto__,c__26531__auto___28737,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async))
})();
var state__26533__auto__ = (function (){var statearr_28600 = f__26532__auto__.call(null);
(statearr_28600[(6)] = c__26531__auto___28737);

return statearr_28600;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(__28733,c__26531__auto___28737,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async))
);


break;
case "async":
var c__26531__auto___28746 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__28733,c__26531__auto___28746,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (__28733,c__26531__auto___28746,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async){
return (function (state_28613){
var state_val_28614 = (state_28613[(1)]);
if((state_val_28614 === (1))){
var state_28613__$1 = state_28613;
var statearr_28615_28747 = state_28613__$1;
(statearr_28615_28747[(2)] = null);

(statearr_28615_28747[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28614 === (2))){
var state_28613__$1 = state_28613;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28613__$1,(4),jobs);
} else {
if((state_val_28614 === (3))){
var inst_28611 = (state_28613[(2)]);
var state_28613__$1 = state_28613;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28613__$1,inst_28611);
} else {
if((state_val_28614 === (4))){
var inst_28603 = (state_28613[(2)]);
var inst_28604 = async.call(null,inst_28603);
var state_28613__$1 = state_28613;
if(cljs.core.truth_(inst_28604)){
var statearr_28616_28748 = state_28613__$1;
(statearr_28616_28748[(1)] = (5));

} else {
var statearr_28617_28749 = state_28613__$1;
(statearr_28617_28749[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28614 === (5))){
var state_28613__$1 = state_28613;
var statearr_28618_28750 = state_28613__$1;
(statearr_28618_28750[(2)] = null);

(statearr_28618_28750[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28614 === (6))){
var state_28613__$1 = state_28613;
var statearr_28619_28751 = state_28613__$1;
(statearr_28619_28751[(2)] = null);

(statearr_28619_28751[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28614 === (7))){
var inst_28609 = (state_28613[(2)]);
var state_28613__$1 = state_28613;
var statearr_28620_28752 = state_28613__$1;
(statearr_28620_28752[(2)] = inst_28609);

(statearr_28620_28752[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__28733,c__26531__auto___28746,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async))
;
return ((function (__28733,switch__26364__auto__,c__26531__auto___28746,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0 = (function (){
var statearr_28621 = [null,null,null,null,null,null,null];
(statearr_28621[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__);

(statearr_28621[(1)] = (1));

return statearr_28621;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1 = (function (state_28613){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_28613);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e28622){if((e28622 instanceof Object)){
var ex__26368__auto__ = e28622;
var statearr_28623_28753 = state_28613;
(statearr_28623_28753[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28613);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28622;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28754 = state_28613;
state_28613 = G__28754;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__ = function(state_28613){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1.call(this,state_28613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__;
})()
;})(__28733,switch__26364__auto__,c__26531__auto___28746,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async))
})();
var state__26533__auto__ = (function (){var statearr_28624 = f__26532__auto__.call(null);
(statearr_28624[(6)] = c__26531__auto___28746);

return statearr_28624;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(__28733,c__26531__auto___28746,G__28576_28734,G__28576_28735__$1,n__4607__auto___28732,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28576_28735__$1)].join('')));

}

var G__28755 = (__28733 + (1));
__28733 = G__28755;
continue;
} else {
}
break;
}

var c__26531__auto___28756 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___28756,jobs,results,process,async){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___28756,jobs,results,process,async){
return (function (state_28646){
var state_val_28647 = (state_28646[(1)]);
if((state_val_28647 === (7))){
var inst_28642 = (state_28646[(2)]);
var state_28646__$1 = state_28646;
var statearr_28648_28757 = state_28646__$1;
(statearr_28648_28757[(2)] = inst_28642);

(statearr_28648_28757[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (1))){
var state_28646__$1 = state_28646;
var statearr_28649_28758 = state_28646__$1;
(statearr_28649_28758[(2)] = null);

(statearr_28649_28758[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (4))){
var inst_28627 = (state_28646[(7)]);
var inst_28627__$1 = (state_28646[(2)]);
var inst_28628 = (inst_28627__$1 == null);
var state_28646__$1 = (function (){var statearr_28650 = state_28646;
(statearr_28650[(7)] = inst_28627__$1);

return statearr_28650;
})();
if(cljs.core.truth_(inst_28628)){
var statearr_28651_28759 = state_28646__$1;
(statearr_28651_28759[(1)] = (5));

} else {
var statearr_28652_28760 = state_28646__$1;
(statearr_28652_28760[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (6))){
var inst_28632 = (state_28646[(8)]);
var inst_28627 = (state_28646[(7)]);
var inst_28632__$1 = cljs.core.async.chan.call(null,(1));
var inst_28633 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28634 = [inst_28627,inst_28632__$1];
var inst_28635 = (new cljs.core.PersistentVector(null,2,(5),inst_28633,inst_28634,null));
var state_28646__$1 = (function (){var statearr_28653 = state_28646;
(statearr_28653[(8)] = inst_28632__$1);

return statearr_28653;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28646__$1,(8),jobs,inst_28635);
} else {
if((state_val_28647 === (3))){
var inst_28644 = (state_28646[(2)]);
var state_28646__$1 = state_28646;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28646__$1,inst_28644);
} else {
if((state_val_28647 === (2))){
var state_28646__$1 = state_28646;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28646__$1,(4),from);
} else {
if((state_val_28647 === (9))){
var inst_28639 = (state_28646[(2)]);
var state_28646__$1 = (function (){var statearr_28654 = state_28646;
(statearr_28654[(9)] = inst_28639);

return statearr_28654;
})();
var statearr_28655_28761 = state_28646__$1;
(statearr_28655_28761[(2)] = null);

(statearr_28655_28761[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (5))){
var inst_28630 = cljs.core.async.close_BANG_.call(null,jobs);
var state_28646__$1 = state_28646;
var statearr_28656_28762 = state_28646__$1;
(statearr_28656_28762[(2)] = inst_28630);

(statearr_28656_28762[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28647 === (8))){
var inst_28632 = (state_28646[(8)]);
var inst_28637 = (state_28646[(2)]);
var state_28646__$1 = (function (){var statearr_28657 = state_28646;
(statearr_28657[(10)] = inst_28637);

return statearr_28657;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28646__$1,(9),results,inst_28632);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___28756,jobs,results,process,async))
;
return ((function (switch__26364__auto__,c__26531__auto___28756,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0 = (function (){
var statearr_28658 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28658[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__);

(statearr_28658[(1)] = (1));

return statearr_28658;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1 = (function (state_28646){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_28646);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e28659){if((e28659 instanceof Object)){
var ex__26368__auto__ = e28659;
var statearr_28660_28763 = state_28646;
(statearr_28660_28763[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28646);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28659;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28764 = state_28646;
state_28646 = G__28764;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__ = function(state_28646){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1.call(this,state_28646);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___28756,jobs,results,process,async))
})();
var state__26533__auto__ = (function (){var statearr_28661 = f__26532__auto__.call(null);
(statearr_28661[(6)] = c__26531__auto___28756);

return statearr_28661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___28756,jobs,results,process,async))
);


var c__26531__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto__,jobs,results,process,async){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto__,jobs,results,process,async){
return (function (state_28699){
var state_val_28700 = (state_28699[(1)]);
if((state_val_28700 === (7))){
var inst_28695 = (state_28699[(2)]);
var state_28699__$1 = state_28699;
var statearr_28701_28765 = state_28699__$1;
(statearr_28701_28765[(2)] = inst_28695);

(statearr_28701_28765[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (20))){
var state_28699__$1 = state_28699;
var statearr_28702_28766 = state_28699__$1;
(statearr_28702_28766[(2)] = null);

(statearr_28702_28766[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (1))){
var state_28699__$1 = state_28699;
var statearr_28703_28767 = state_28699__$1;
(statearr_28703_28767[(2)] = null);

(statearr_28703_28767[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (4))){
var inst_28664 = (state_28699[(7)]);
var inst_28664__$1 = (state_28699[(2)]);
var inst_28665 = (inst_28664__$1 == null);
var state_28699__$1 = (function (){var statearr_28704 = state_28699;
(statearr_28704[(7)] = inst_28664__$1);

return statearr_28704;
})();
if(cljs.core.truth_(inst_28665)){
var statearr_28705_28768 = state_28699__$1;
(statearr_28705_28768[(1)] = (5));

} else {
var statearr_28706_28769 = state_28699__$1;
(statearr_28706_28769[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (15))){
var inst_28677 = (state_28699[(8)]);
var state_28699__$1 = state_28699;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28699__$1,(18),to,inst_28677);
} else {
if((state_val_28700 === (21))){
var inst_28690 = (state_28699[(2)]);
var state_28699__$1 = state_28699;
var statearr_28707_28770 = state_28699__$1;
(statearr_28707_28770[(2)] = inst_28690);

(statearr_28707_28770[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (13))){
var inst_28692 = (state_28699[(2)]);
var state_28699__$1 = (function (){var statearr_28708 = state_28699;
(statearr_28708[(9)] = inst_28692);

return statearr_28708;
})();
var statearr_28709_28771 = state_28699__$1;
(statearr_28709_28771[(2)] = null);

(statearr_28709_28771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (6))){
var inst_28664 = (state_28699[(7)]);
var state_28699__$1 = state_28699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28699__$1,(11),inst_28664);
} else {
if((state_val_28700 === (17))){
var inst_28685 = (state_28699[(2)]);
var state_28699__$1 = state_28699;
if(cljs.core.truth_(inst_28685)){
var statearr_28710_28772 = state_28699__$1;
(statearr_28710_28772[(1)] = (19));

} else {
var statearr_28711_28773 = state_28699__$1;
(statearr_28711_28773[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (3))){
var inst_28697 = (state_28699[(2)]);
var state_28699__$1 = state_28699;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28699__$1,inst_28697);
} else {
if((state_val_28700 === (12))){
var inst_28674 = (state_28699[(10)]);
var state_28699__$1 = state_28699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28699__$1,(14),inst_28674);
} else {
if((state_val_28700 === (2))){
var state_28699__$1 = state_28699;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28699__$1,(4),results);
} else {
if((state_val_28700 === (19))){
var state_28699__$1 = state_28699;
var statearr_28712_28774 = state_28699__$1;
(statearr_28712_28774[(2)] = null);

(statearr_28712_28774[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (11))){
var inst_28674 = (state_28699[(2)]);
var state_28699__$1 = (function (){var statearr_28713 = state_28699;
(statearr_28713[(10)] = inst_28674);

return statearr_28713;
})();
var statearr_28714_28775 = state_28699__$1;
(statearr_28714_28775[(2)] = null);

(statearr_28714_28775[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (9))){
var state_28699__$1 = state_28699;
var statearr_28715_28776 = state_28699__$1;
(statearr_28715_28776[(2)] = null);

(statearr_28715_28776[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (5))){
var state_28699__$1 = state_28699;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28716_28777 = state_28699__$1;
(statearr_28716_28777[(1)] = (8));

} else {
var statearr_28717_28778 = state_28699__$1;
(statearr_28717_28778[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (14))){
var inst_28677 = (state_28699[(8)]);
var inst_28679 = (state_28699[(11)]);
var inst_28677__$1 = (state_28699[(2)]);
var inst_28678 = (inst_28677__$1 == null);
var inst_28679__$1 = cljs.core.not.call(null,inst_28678);
var state_28699__$1 = (function (){var statearr_28718 = state_28699;
(statearr_28718[(8)] = inst_28677__$1);

(statearr_28718[(11)] = inst_28679__$1);

return statearr_28718;
})();
if(inst_28679__$1){
var statearr_28719_28779 = state_28699__$1;
(statearr_28719_28779[(1)] = (15));

} else {
var statearr_28720_28780 = state_28699__$1;
(statearr_28720_28780[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (16))){
var inst_28679 = (state_28699[(11)]);
var state_28699__$1 = state_28699;
var statearr_28721_28781 = state_28699__$1;
(statearr_28721_28781[(2)] = inst_28679);

(statearr_28721_28781[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (10))){
var inst_28671 = (state_28699[(2)]);
var state_28699__$1 = state_28699;
var statearr_28722_28782 = state_28699__$1;
(statearr_28722_28782[(2)] = inst_28671);

(statearr_28722_28782[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (18))){
var inst_28682 = (state_28699[(2)]);
var state_28699__$1 = state_28699;
var statearr_28723_28783 = state_28699__$1;
(statearr_28723_28783[(2)] = inst_28682);

(statearr_28723_28783[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28700 === (8))){
var inst_28668 = cljs.core.async.close_BANG_.call(null,to);
var state_28699__$1 = state_28699;
var statearr_28724_28784 = state_28699__$1;
(statearr_28724_28784[(2)] = inst_28668);

(statearr_28724_28784[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto__,jobs,results,process,async))
;
return ((function (switch__26364__auto__,c__26531__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0 = (function (){
var statearr_28725 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28725[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__);

(statearr_28725[(1)] = (1));

return statearr_28725;
});
var cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1 = (function (state_28699){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_28699);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e28726){if((e28726 instanceof Object)){
var ex__26368__auto__ = e28726;
var statearr_28727_28785 = state_28699;
(statearr_28727_28785[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28699);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28726;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28786 = state_28699;
state_28699 = G__28786;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__ = function(state_28699){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1.call(this,state_28699);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__26365__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto__,jobs,results,process,async))
})();
var state__26533__auto__ = (function (){var statearr_28728 = f__26532__auto__.call(null);
(statearr_28728[(6)] = c__26531__auto__);

return statearr_28728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto__,jobs,results,process,async))
);

return c__26531__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__28788 = arguments.length;
switch (G__28788) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__28791 = arguments.length;
switch (G__28791) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__28794 = arguments.length;
switch (G__28794) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__26531__auto___28843 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___28843,tc,fc){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___28843,tc,fc){
return (function (state_28820){
var state_val_28821 = (state_28820[(1)]);
if((state_val_28821 === (7))){
var inst_28816 = (state_28820[(2)]);
var state_28820__$1 = state_28820;
var statearr_28822_28844 = state_28820__$1;
(statearr_28822_28844[(2)] = inst_28816);

(statearr_28822_28844[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (1))){
var state_28820__$1 = state_28820;
var statearr_28823_28845 = state_28820__$1;
(statearr_28823_28845[(2)] = null);

(statearr_28823_28845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (4))){
var inst_28797 = (state_28820[(7)]);
var inst_28797__$1 = (state_28820[(2)]);
var inst_28798 = (inst_28797__$1 == null);
var state_28820__$1 = (function (){var statearr_28824 = state_28820;
(statearr_28824[(7)] = inst_28797__$1);

return statearr_28824;
})();
if(cljs.core.truth_(inst_28798)){
var statearr_28825_28846 = state_28820__$1;
(statearr_28825_28846[(1)] = (5));

} else {
var statearr_28826_28847 = state_28820__$1;
(statearr_28826_28847[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (13))){
var state_28820__$1 = state_28820;
var statearr_28827_28848 = state_28820__$1;
(statearr_28827_28848[(2)] = null);

(statearr_28827_28848[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (6))){
var inst_28797 = (state_28820[(7)]);
var inst_28803 = p.call(null,inst_28797);
var state_28820__$1 = state_28820;
if(cljs.core.truth_(inst_28803)){
var statearr_28828_28849 = state_28820__$1;
(statearr_28828_28849[(1)] = (9));

} else {
var statearr_28829_28850 = state_28820__$1;
(statearr_28829_28850[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (3))){
var inst_28818 = (state_28820[(2)]);
var state_28820__$1 = state_28820;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28820__$1,inst_28818);
} else {
if((state_val_28821 === (12))){
var state_28820__$1 = state_28820;
var statearr_28830_28851 = state_28820__$1;
(statearr_28830_28851[(2)] = null);

(statearr_28830_28851[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (2))){
var state_28820__$1 = state_28820;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28820__$1,(4),ch);
} else {
if((state_val_28821 === (11))){
var inst_28797 = (state_28820[(7)]);
var inst_28807 = (state_28820[(2)]);
var state_28820__$1 = state_28820;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28820__$1,(8),inst_28807,inst_28797);
} else {
if((state_val_28821 === (9))){
var state_28820__$1 = state_28820;
var statearr_28831_28852 = state_28820__$1;
(statearr_28831_28852[(2)] = tc);

(statearr_28831_28852[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (5))){
var inst_28800 = cljs.core.async.close_BANG_.call(null,tc);
var inst_28801 = cljs.core.async.close_BANG_.call(null,fc);
var state_28820__$1 = (function (){var statearr_28832 = state_28820;
(statearr_28832[(8)] = inst_28800);

return statearr_28832;
})();
var statearr_28833_28853 = state_28820__$1;
(statearr_28833_28853[(2)] = inst_28801);

(statearr_28833_28853[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (14))){
var inst_28814 = (state_28820[(2)]);
var state_28820__$1 = state_28820;
var statearr_28834_28854 = state_28820__$1;
(statearr_28834_28854[(2)] = inst_28814);

(statearr_28834_28854[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (10))){
var state_28820__$1 = state_28820;
var statearr_28835_28855 = state_28820__$1;
(statearr_28835_28855[(2)] = fc);

(statearr_28835_28855[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28821 === (8))){
var inst_28809 = (state_28820[(2)]);
var state_28820__$1 = state_28820;
if(cljs.core.truth_(inst_28809)){
var statearr_28836_28856 = state_28820__$1;
(statearr_28836_28856[(1)] = (12));

} else {
var statearr_28837_28857 = state_28820__$1;
(statearr_28837_28857[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___28843,tc,fc))
;
return ((function (switch__26364__auto__,c__26531__auto___28843,tc,fc){
return (function() {
var cljs$core$async$state_machine__26365__auto__ = null;
var cljs$core$async$state_machine__26365__auto____0 = (function (){
var statearr_28838 = [null,null,null,null,null,null,null,null,null];
(statearr_28838[(0)] = cljs$core$async$state_machine__26365__auto__);

(statearr_28838[(1)] = (1));

return statearr_28838;
});
var cljs$core$async$state_machine__26365__auto____1 = (function (state_28820){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_28820);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e28839){if((e28839 instanceof Object)){
var ex__26368__auto__ = e28839;
var statearr_28840_28858 = state_28820;
(statearr_28840_28858[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28820);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28839;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28859 = state_28820;
state_28820 = G__28859;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$state_machine__26365__auto__ = function(state_28820){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26365__auto____1.call(this,state_28820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26365__auto____0;
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26365__auto____1;
return cljs$core$async$state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___28843,tc,fc))
})();
var state__26533__auto__ = (function (){var statearr_28841 = f__26532__auto__.call(null);
(statearr_28841[(6)] = c__26531__auto___28843);

return statearr_28841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___28843,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__26531__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto__){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto__){
return (function (state_28880){
var state_val_28881 = (state_28880[(1)]);
if((state_val_28881 === (7))){
var inst_28876 = (state_28880[(2)]);
var state_28880__$1 = state_28880;
var statearr_28882_28900 = state_28880__$1;
(statearr_28882_28900[(2)] = inst_28876);

(statearr_28882_28900[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (1))){
var inst_28860 = init;
var state_28880__$1 = (function (){var statearr_28883 = state_28880;
(statearr_28883[(7)] = inst_28860);

return statearr_28883;
})();
var statearr_28884_28901 = state_28880__$1;
(statearr_28884_28901[(2)] = null);

(statearr_28884_28901[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (4))){
var inst_28863 = (state_28880[(8)]);
var inst_28863__$1 = (state_28880[(2)]);
var inst_28864 = (inst_28863__$1 == null);
var state_28880__$1 = (function (){var statearr_28885 = state_28880;
(statearr_28885[(8)] = inst_28863__$1);

return statearr_28885;
})();
if(cljs.core.truth_(inst_28864)){
var statearr_28886_28902 = state_28880__$1;
(statearr_28886_28902[(1)] = (5));

} else {
var statearr_28887_28903 = state_28880__$1;
(statearr_28887_28903[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (6))){
var inst_28867 = (state_28880[(9)]);
var inst_28863 = (state_28880[(8)]);
var inst_28860 = (state_28880[(7)]);
var inst_28867__$1 = f.call(null,inst_28860,inst_28863);
var inst_28868 = cljs.core.reduced_QMARK_.call(null,inst_28867__$1);
var state_28880__$1 = (function (){var statearr_28888 = state_28880;
(statearr_28888[(9)] = inst_28867__$1);

return statearr_28888;
})();
if(inst_28868){
var statearr_28889_28904 = state_28880__$1;
(statearr_28889_28904[(1)] = (8));

} else {
var statearr_28890_28905 = state_28880__$1;
(statearr_28890_28905[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (3))){
var inst_28878 = (state_28880[(2)]);
var state_28880__$1 = state_28880;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28880__$1,inst_28878);
} else {
if((state_val_28881 === (2))){
var state_28880__$1 = state_28880;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28880__$1,(4),ch);
} else {
if((state_val_28881 === (9))){
var inst_28867 = (state_28880[(9)]);
var inst_28860 = inst_28867;
var state_28880__$1 = (function (){var statearr_28891 = state_28880;
(statearr_28891[(7)] = inst_28860);

return statearr_28891;
})();
var statearr_28892_28906 = state_28880__$1;
(statearr_28892_28906[(2)] = null);

(statearr_28892_28906[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (5))){
var inst_28860 = (state_28880[(7)]);
var state_28880__$1 = state_28880;
var statearr_28893_28907 = state_28880__$1;
(statearr_28893_28907[(2)] = inst_28860);

(statearr_28893_28907[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (10))){
var inst_28874 = (state_28880[(2)]);
var state_28880__$1 = state_28880;
var statearr_28894_28908 = state_28880__$1;
(statearr_28894_28908[(2)] = inst_28874);

(statearr_28894_28908[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28881 === (8))){
var inst_28867 = (state_28880[(9)]);
var inst_28870 = cljs.core.deref.call(null,inst_28867);
var state_28880__$1 = state_28880;
var statearr_28895_28909 = state_28880__$1;
(statearr_28895_28909[(2)] = inst_28870);

(statearr_28895_28909[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto__))
;
return ((function (switch__26364__auto__,c__26531__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__26365__auto__ = null;
var cljs$core$async$reduce_$_state_machine__26365__auto____0 = (function (){
var statearr_28896 = [null,null,null,null,null,null,null,null,null,null];
(statearr_28896[(0)] = cljs$core$async$reduce_$_state_machine__26365__auto__);

(statearr_28896[(1)] = (1));

return statearr_28896;
});
var cljs$core$async$reduce_$_state_machine__26365__auto____1 = (function (state_28880){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_28880);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e28897){if((e28897 instanceof Object)){
var ex__26368__auto__ = e28897;
var statearr_28898_28910 = state_28880;
(statearr_28898_28910[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28880);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28897;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28911 = state_28880;
state_28880 = G__28911;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__26365__auto__ = function(state_28880){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__26365__auto____1.call(this,state_28880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__26365__auto____0;
cljs$core$async$reduce_$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__26365__auto____1;
return cljs$core$async$reduce_$_state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto__))
})();
var state__26533__auto__ = (function (){var statearr_28899 = f__26532__auto__.call(null);
(statearr_28899[(6)] = c__26531__auto__);

return statearr_28899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto__))
);

return c__26531__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__26531__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto__,f__$1){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto__,f__$1){
return (function (state_28917){
var state_val_28918 = (state_28917[(1)]);
if((state_val_28918 === (1))){
var inst_28912 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_28917__$1 = state_28917;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_28917__$1,(2),inst_28912);
} else {
if((state_val_28918 === (2))){
var inst_28914 = (state_28917[(2)]);
var inst_28915 = f__$1.call(null,inst_28914);
var state_28917__$1 = state_28917;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28917__$1,inst_28915);
} else {
return null;
}
}
});})(c__26531__auto__,f__$1))
;
return ((function (switch__26364__auto__,c__26531__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__26365__auto__ = null;
var cljs$core$async$transduce_$_state_machine__26365__auto____0 = (function (){
var statearr_28919 = [null,null,null,null,null,null,null];
(statearr_28919[(0)] = cljs$core$async$transduce_$_state_machine__26365__auto__);

(statearr_28919[(1)] = (1));

return statearr_28919;
});
var cljs$core$async$transduce_$_state_machine__26365__auto____1 = (function (state_28917){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_28917);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e28920){if((e28920 instanceof Object)){
var ex__26368__auto__ = e28920;
var statearr_28921_28923 = state_28917;
(statearr_28921_28923[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28917);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28920;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28924 = state_28917;
state_28917 = G__28924;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__26365__auto__ = function(state_28917){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__26365__auto____1.call(this,state_28917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__26365__auto____0;
cljs$core$async$transduce_$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__26365__auto____1;
return cljs$core$async$transduce_$_state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto__,f__$1))
})();
var state__26533__auto__ = (function (){var statearr_28922 = f__26532__auto__.call(null);
(statearr_28922[(6)] = c__26531__auto__);

return statearr_28922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto__,f__$1))
);

return c__26531__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__28926 = arguments.length;
switch (G__28926) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__26531__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto__){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto__){
return (function (state_28951){
var state_val_28952 = (state_28951[(1)]);
if((state_val_28952 === (7))){
var inst_28933 = (state_28951[(2)]);
var state_28951__$1 = state_28951;
var statearr_28953_28974 = state_28951__$1;
(statearr_28953_28974[(2)] = inst_28933);

(statearr_28953_28974[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28952 === (1))){
var inst_28927 = cljs.core.seq.call(null,coll);
var inst_28928 = inst_28927;
var state_28951__$1 = (function (){var statearr_28954 = state_28951;
(statearr_28954[(7)] = inst_28928);

return statearr_28954;
})();
var statearr_28955_28975 = state_28951__$1;
(statearr_28955_28975[(2)] = null);

(statearr_28955_28975[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28952 === (4))){
var inst_28928 = (state_28951[(7)]);
var inst_28931 = cljs.core.first.call(null,inst_28928);
var state_28951__$1 = state_28951;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_28951__$1,(7),ch,inst_28931);
} else {
if((state_val_28952 === (13))){
var inst_28945 = (state_28951[(2)]);
var state_28951__$1 = state_28951;
var statearr_28956_28976 = state_28951__$1;
(statearr_28956_28976[(2)] = inst_28945);

(statearr_28956_28976[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28952 === (6))){
var inst_28936 = (state_28951[(2)]);
var state_28951__$1 = state_28951;
if(cljs.core.truth_(inst_28936)){
var statearr_28957_28977 = state_28951__$1;
(statearr_28957_28977[(1)] = (8));

} else {
var statearr_28958_28978 = state_28951__$1;
(statearr_28958_28978[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28952 === (3))){
var inst_28949 = (state_28951[(2)]);
var state_28951__$1 = state_28951;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_28951__$1,inst_28949);
} else {
if((state_val_28952 === (12))){
var state_28951__$1 = state_28951;
var statearr_28959_28979 = state_28951__$1;
(statearr_28959_28979[(2)] = null);

(statearr_28959_28979[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28952 === (2))){
var inst_28928 = (state_28951[(7)]);
var state_28951__$1 = state_28951;
if(cljs.core.truth_(inst_28928)){
var statearr_28960_28980 = state_28951__$1;
(statearr_28960_28980[(1)] = (4));

} else {
var statearr_28961_28981 = state_28951__$1;
(statearr_28961_28981[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28952 === (11))){
var inst_28942 = cljs.core.async.close_BANG_.call(null,ch);
var state_28951__$1 = state_28951;
var statearr_28962_28982 = state_28951__$1;
(statearr_28962_28982[(2)] = inst_28942);

(statearr_28962_28982[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28952 === (9))){
var state_28951__$1 = state_28951;
if(cljs.core.truth_(close_QMARK_)){
var statearr_28963_28983 = state_28951__$1;
(statearr_28963_28983[(1)] = (11));

} else {
var statearr_28964_28984 = state_28951__$1;
(statearr_28964_28984[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28952 === (5))){
var inst_28928 = (state_28951[(7)]);
var state_28951__$1 = state_28951;
var statearr_28965_28985 = state_28951__$1;
(statearr_28965_28985[(2)] = inst_28928);

(statearr_28965_28985[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28952 === (10))){
var inst_28947 = (state_28951[(2)]);
var state_28951__$1 = state_28951;
var statearr_28966_28986 = state_28951__$1;
(statearr_28966_28986[(2)] = inst_28947);

(statearr_28966_28986[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_28952 === (8))){
var inst_28928 = (state_28951[(7)]);
var inst_28938 = cljs.core.next.call(null,inst_28928);
var inst_28928__$1 = inst_28938;
var state_28951__$1 = (function (){var statearr_28967 = state_28951;
(statearr_28967[(7)] = inst_28928__$1);

return statearr_28967;
})();
var statearr_28968_28987 = state_28951__$1;
(statearr_28968_28987[(2)] = null);

(statearr_28968_28987[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto__))
;
return ((function (switch__26364__auto__,c__26531__auto__){
return (function() {
var cljs$core$async$state_machine__26365__auto__ = null;
var cljs$core$async$state_machine__26365__auto____0 = (function (){
var statearr_28969 = [null,null,null,null,null,null,null,null];
(statearr_28969[(0)] = cljs$core$async$state_machine__26365__auto__);

(statearr_28969[(1)] = (1));

return statearr_28969;
});
var cljs$core$async$state_machine__26365__auto____1 = (function (state_28951){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_28951);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e28970){if((e28970 instanceof Object)){
var ex__26368__auto__ = e28970;
var statearr_28971_28988 = state_28951;
(statearr_28971_28988[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_28951);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e28970;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__28989 = state_28951;
state_28951 = G__28989;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$state_machine__26365__auto__ = function(state_28951){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26365__auto____1.call(this,state_28951);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26365__auto____0;
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26365__auto____1;
return cljs$core$async$state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto__))
})();
var state__26533__auto__ = (function (){var statearr_28972 = f__26532__auto__.call(null);
(statearr_28972[(6)] = c__26531__auto__);

return statearr_28972;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto__))
);

return c__26531__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async28990 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async28990 = (function (ch,cs,meta28991){
this.ch = ch;
this.cs = cs;
this.meta28991 = meta28991;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async28990.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_28992,meta28991__$1){
var self__ = this;
var _28992__$1 = this;
return (new cljs.core.async.t_cljs$core$async28990(self__.ch,self__.cs,meta28991__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async28990.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_28992){
var self__ = this;
var _28992__$1 = this;
return self__.meta28991;
});})(cs))
;

cljs.core.async.t_cljs$core$async28990.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28990.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async28990.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async28990.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async28990.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async28990.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async28990.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta28991","meta28991",1626505302,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async28990.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async28990.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async28990";

cljs.core.async.t_cljs$core$async28990.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async28990");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async28990.
 */
cljs.core.async.__GT_t_cljs$core$async28990 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async28990(ch__$1,cs__$1,meta28991){
return (new cljs.core.async.t_cljs$core$async28990(ch__$1,cs__$1,meta28991));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async28990(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__26531__auto___29212 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___29212,cs,m,dchan,dctr,done){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___29212,cs,m,dchan,dctr,done){
return (function (state_29127){
var state_val_29128 = (state_29127[(1)]);
if((state_val_29128 === (7))){
var inst_29123 = (state_29127[(2)]);
var state_29127__$1 = state_29127;
var statearr_29129_29213 = state_29127__$1;
(statearr_29129_29213[(2)] = inst_29123);

(statearr_29129_29213[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (20))){
var inst_29026 = (state_29127[(7)]);
var inst_29038 = cljs.core.first.call(null,inst_29026);
var inst_29039 = cljs.core.nth.call(null,inst_29038,(0),null);
var inst_29040 = cljs.core.nth.call(null,inst_29038,(1),null);
var state_29127__$1 = (function (){var statearr_29130 = state_29127;
(statearr_29130[(8)] = inst_29039);

return statearr_29130;
})();
if(cljs.core.truth_(inst_29040)){
var statearr_29131_29214 = state_29127__$1;
(statearr_29131_29214[(1)] = (22));

} else {
var statearr_29132_29215 = state_29127__$1;
(statearr_29132_29215[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (27))){
var inst_29068 = (state_29127[(9)]);
var inst_29070 = (state_29127[(10)]);
var inst_28995 = (state_29127[(11)]);
var inst_29075 = (state_29127[(12)]);
var inst_29075__$1 = cljs.core._nth.call(null,inst_29068,inst_29070);
var inst_29076 = cljs.core.async.put_BANG_.call(null,inst_29075__$1,inst_28995,done);
var state_29127__$1 = (function (){var statearr_29133 = state_29127;
(statearr_29133[(12)] = inst_29075__$1);

return statearr_29133;
})();
if(cljs.core.truth_(inst_29076)){
var statearr_29134_29216 = state_29127__$1;
(statearr_29134_29216[(1)] = (30));

} else {
var statearr_29135_29217 = state_29127__$1;
(statearr_29135_29217[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (1))){
var state_29127__$1 = state_29127;
var statearr_29136_29218 = state_29127__$1;
(statearr_29136_29218[(2)] = null);

(statearr_29136_29218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (24))){
var inst_29026 = (state_29127[(7)]);
var inst_29045 = (state_29127[(2)]);
var inst_29046 = cljs.core.next.call(null,inst_29026);
var inst_29004 = inst_29046;
var inst_29005 = null;
var inst_29006 = (0);
var inst_29007 = (0);
var state_29127__$1 = (function (){var statearr_29137 = state_29127;
(statearr_29137[(13)] = inst_29045);

(statearr_29137[(14)] = inst_29007);

(statearr_29137[(15)] = inst_29005);

(statearr_29137[(16)] = inst_29004);

(statearr_29137[(17)] = inst_29006);

return statearr_29137;
})();
var statearr_29138_29219 = state_29127__$1;
(statearr_29138_29219[(2)] = null);

(statearr_29138_29219[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (39))){
var state_29127__$1 = state_29127;
var statearr_29142_29220 = state_29127__$1;
(statearr_29142_29220[(2)] = null);

(statearr_29142_29220[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (4))){
var inst_28995 = (state_29127[(11)]);
var inst_28995__$1 = (state_29127[(2)]);
var inst_28996 = (inst_28995__$1 == null);
var state_29127__$1 = (function (){var statearr_29143 = state_29127;
(statearr_29143[(11)] = inst_28995__$1);

return statearr_29143;
})();
if(cljs.core.truth_(inst_28996)){
var statearr_29144_29221 = state_29127__$1;
(statearr_29144_29221[(1)] = (5));

} else {
var statearr_29145_29222 = state_29127__$1;
(statearr_29145_29222[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (15))){
var inst_29007 = (state_29127[(14)]);
var inst_29005 = (state_29127[(15)]);
var inst_29004 = (state_29127[(16)]);
var inst_29006 = (state_29127[(17)]);
var inst_29022 = (state_29127[(2)]);
var inst_29023 = (inst_29007 + (1));
var tmp29139 = inst_29005;
var tmp29140 = inst_29004;
var tmp29141 = inst_29006;
var inst_29004__$1 = tmp29140;
var inst_29005__$1 = tmp29139;
var inst_29006__$1 = tmp29141;
var inst_29007__$1 = inst_29023;
var state_29127__$1 = (function (){var statearr_29146 = state_29127;
(statearr_29146[(18)] = inst_29022);

(statearr_29146[(14)] = inst_29007__$1);

(statearr_29146[(15)] = inst_29005__$1);

(statearr_29146[(16)] = inst_29004__$1);

(statearr_29146[(17)] = inst_29006__$1);

return statearr_29146;
})();
var statearr_29147_29223 = state_29127__$1;
(statearr_29147_29223[(2)] = null);

(statearr_29147_29223[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (21))){
var inst_29049 = (state_29127[(2)]);
var state_29127__$1 = state_29127;
var statearr_29151_29224 = state_29127__$1;
(statearr_29151_29224[(2)] = inst_29049);

(statearr_29151_29224[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (31))){
var inst_29075 = (state_29127[(12)]);
var inst_29079 = done.call(null,null);
var inst_29080 = cljs.core.async.untap_STAR_.call(null,m,inst_29075);
var state_29127__$1 = (function (){var statearr_29152 = state_29127;
(statearr_29152[(19)] = inst_29079);

return statearr_29152;
})();
var statearr_29153_29225 = state_29127__$1;
(statearr_29153_29225[(2)] = inst_29080);

(statearr_29153_29225[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (32))){
var inst_29067 = (state_29127[(20)]);
var inst_29068 = (state_29127[(9)]);
var inst_29070 = (state_29127[(10)]);
var inst_29069 = (state_29127[(21)]);
var inst_29082 = (state_29127[(2)]);
var inst_29083 = (inst_29070 + (1));
var tmp29148 = inst_29067;
var tmp29149 = inst_29068;
var tmp29150 = inst_29069;
var inst_29067__$1 = tmp29148;
var inst_29068__$1 = tmp29149;
var inst_29069__$1 = tmp29150;
var inst_29070__$1 = inst_29083;
var state_29127__$1 = (function (){var statearr_29154 = state_29127;
(statearr_29154[(20)] = inst_29067__$1);

(statearr_29154[(22)] = inst_29082);

(statearr_29154[(9)] = inst_29068__$1);

(statearr_29154[(10)] = inst_29070__$1);

(statearr_29154[(21)] = inst_29069__$1);

return statearr_29154;
})();
var statearr_29155_29226 = state_29127__$1;
(statearr_29155_29226[(2)] = null);

(statearr_29155_29226[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (40))){
var inst_29095 = (state_29127[(23)]);
var inst_29099 = done.call(null,null);
var inst_29100 = cljs.core.async.untap_STAR_.call(null,m,inst_29095);
var state_29127__$1 = (function (){var statearr_29156 = state_29127;
(statearr_29156[(24)] = inst_29099);

return statearr_29156;
})();
var statearr_29157_29227 = state_29127__$1;
(statearr_29157_29227[(2)] = inst_29100);

(statearr_29157_29227[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (33))){
var inst_29086 = (state_29127[(25)]);
var inst_29088 = cljs.core.chunked_seq_QMARK_.call(null,inst_29086);
var state_29127__$1 = state_29127;
if(inst_29088){
var statearr_29158_29228 = state_29127__$1;
(statearr_29158_29228[(1)] = (36));

} else {
var statearr_29159_29229 = state_29127__$1;
(statearr_29159_29229[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (13))){
var inst_29016 = (state_29127[(26)]);
var inst_29019 = cljs.core.async.close_BANG_.call(null,inst_29016);
var state_29127__$1 = state_29127;
var statearr_29160_29230 = state_29127__$1;
(statearr_29160_29230[(2)] = inst_29019);

(statearr_29160_29230[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (22))){
var inst_29039 = (state_29127[(8)]);
var inst_29042 = cljs.core.async.close_BANG_.call(null,inst_29039);
var state_29127__$1 = state_29127;
var statearr_29161_29231 = state_29127__$1;
(statearr_29161_29231[(2)] = inst_29042);

(statearr_29161_29231[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (36))){
var inst_29086 = (state_29127[(25)]);
var inst_29090 = cljs.core.chunk_first.call(null,inst_29086);
var inst_29091 = cljs.core.chunk_rest.call(null,inst_29086);
var inst_29092 = cljs.core.count.call(null,inst_29090);
var inst_29067 = inst_29091;
var inst_29068 = inst_29090;
var inst_29069 = inst_29092;
var inst_29070 = (0);
var state_29127__$1 = (function (){var statearr_29162 = state_29127;
(statearr_29162[(20)] = inst_29067);

(statearr_29162[(9)] = inst_29068);

(statearr_29162[(10)] = inst_29070);

(statearr_29162[(21)] = inst_29069);

return statearr_29162;
})();
var statearr_29163_29232 = state_29127__$1;
(statearr_29163_29232[(2)] = null);

(statearr_29163_29232[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (41))){
var inst_29086 = (state_29127[(25)]);
var inst_29102 = (state_29127[(2)]);
var inst_29103 = cljs.core.next.call(null,inst_29086);
var inst_29067 = inst_29103;
var inst_29068 = null;
var inst_29069 = (0);
var inst_29070 = (0);
var state_29127__$1 = (function (){var statearr_29164 = state_29127;
(statearr_29164[(20)] = inst_29067);

(statearr_29164[(9)] = inst_29068);

(statearr_29164[(10)] = inst_29070);

(statearr_29164[(21)] = inst_29069);

(statearr_29164[(27)] = inst_29102);

return statearr_29164;
})();
var statearr_29165_29233 = state_29127__$1;
(statearr_29165_29233[(2)] = null);

(statearr_29165_29233[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (43))){
var state_29127__$1 = state_29127;
var statearr_29166_29234 = state_29127__$1;
(statearr_29166_29234[(2)] = null);

(statearr_29166_29234[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (29))){
var inst_29111 = (state_29127[(2)]);
var state_29127__$1 = state_29127;
var statearr_29167_29235 = state_29127__$1;
(statearr_29167_29235[(2)] = inst_29111);

(statearr_29167_29235[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (44))){
var inst_29120 = (state_29127[(2)]);
var state_29127__$1 = (function (){var statearr_29168 = state_29127;
(statearr_29168[(28)] = inst_29120);

return statearr_29168;
})();
var statearr_29169_29236 = state_29127__$1;
(statearr_29169_29236[(2)] = null);

(statearr_29169_29236[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (6))){
var inst_29059 = (state_29127[(29)]);
var inst_29058 = cljs.core.deref.call(null,cs);
var inst_29059__$1 = cljs.core.keys.call(null,inst_29058);
var inst_29060 = cljs.core.count.call(null,inst_29059__$1);
var inst_29061 = cljs.core.reset_BANG_.call(null,dctr,inst_29060);
var inst_29066 = cljs.core.seq.call(null,inst_29059__$1);
var inst_29067 = inst_29066;
var inst_29068 = null;
var inst_29069 = (0);
var inst_29070 = (0);
var state_29127__$1 = (function (){var statearr_29170 = state_29127;
(statearr_29170[(20)] = inst_29067);

(statearr_29170[(9)] = inst_29068);

(statearr_29170[(10)] = inst_29070);

(statearr_29170[(30)] = inst_29061);

(statearr_29170[(21)] = inst_29069);

(statearr_29170[(29)] = inst_29059__$1);

return statearr_29170;
})();
var statearr_29171_29237 = state_29127__$1;
(statearr_29171_29237[(2)] = null);

(statearr_29171_29237[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (28))){
var inst_29067 = (state_29127[(20)]);
var inst_29086 = (state_29127[(25)]);
var inst_29086__$1 = cljs.core.seq.call(null,inst_29067);
var state_29127__$1 = (function (){var statearr_29172 = state_29127;
(statearr_29172[(25)] = inst_29086__$1);

return statearr_29172;
})();
if(inst_29086__$1){
var statearr_29173_29238 = state_29127__$1;
(statearr_29173_29238[(1)] = (33));

} else {
var statearr_29174_29239 = state_29127__$1;
(statearr_29174_29239[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (25))){
var inst_29070 = (state_29127[(10)]);
var inst_29069 = (state_29127[(21)]);
var inst_29072 = (inst_29070 < inst_29069);
var inst_29073 = inst_29072;
var state_29127__$1 = state_29127;
if(cljs.core.truth_(inst_29073)){
var statearr_29175_29240 = state_29127__$1;
(statearr_29175_29240[(1)] = (27));

} else {
var statearr_29176_29241 = state_29127__$1;
(statearr_29176_29241[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (34))){
var state_29127__$1 = state_29127;
var statearr_29177_29242 = state_29127__$1;
(statearr_29177_29242[(2)] = null);

(statearr_29177_29242[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (17))){
var state_29127__$1 = state_29127;
var statearr_29178_29243 = state_29127__$1;
(statearr_29178_29243[(2)] = null);

(statearr_29178_29243[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (3))){
var inst_29125 = (state_29127[(2)]);
var state_29127__$1 = state_29127;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29127__$1,inst_29125);
} else {
if((state_val_29128 === (12))){
var inst_29054 = (state_29127[(2)]);
var state_29127__$1 = state_29127;
var statearr_29179_29244 = state_29127__$1;
(statearr_29179_29244[(2)] = inst_29054);

(statearr_29179_29244[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (2))){
var state_29127__$1 = state_29127;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29127__$1,(4),ch);
} else {
if((state_val_29128 === (23))){
var state_29127__$1 = state_29127;
var statearr_29180_29245 = state_29127__$1;
(statearr_29180_29245[(2)] = null);

(statearr_29180_29245[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (35))){
var inst_29109 = (state_29127[(2)]);
var state_29127__$1 = state_29127;
var statearr_29181_29246 = state_29127__$1;
(statearr_29181_29246[(2)] = inst_29109);

(statearr_29181_29246[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (19))){
var inst_29026 = (state_29127[(7)]);
var inst_29030 = cljs.core.chunk_first.call(null,inst_29026);
var inst_29031 = cljs.core.chunk_rest.call(null,inst_29026);
var inst_29032 = cljs.core.count.call(null,inst_29030);
var inst_29004 = inst_29031;
var inst_29005 = inst_29030;
var inst_29006 = inst_29032;
var inst_29007 = (0);
var state_29127__$1 = (function (){var statearr_29182 = state_29127;
(statearr_29182[(14)] = inst_29007);

(statearr_29182[(15)] = inst_29005);

(statearr_29182[(16)] = inst_29004);

(statearr_29182[(17)] = inst_29006);

return statearr_29182;
})();
var statearr_29183_29247 = state_29127__$1;
(statearr_29183_29247[(2)] = null);

(statearr_29183_29247[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (11))){
var inst_29026 = (state_29127[(7)]);
var inst_29004 = (state_29127[(16)]);
var inst_29026__$1 = cljs.core.seq.call(null,inst_29004);
var state_29127__$1 = (function (){var statearr_29184 = state_29127;
(statearr_29184[(7)] = inst_29026__$1);

return statearr_29184;
})();
if(inst_29026__$1){
var statearr_29185_29248 = state_29127__$1;
(statearr_29185_29248[(1)] = (16));

} else {
var statearr_29186_29249 = state_29127__$1;
(statearr_29186_29249[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (9))){
var inst_29056 = (state_29127[(2)]);
var state_29127__$1 = state_29127;
var statearr_29187_29250 = state_29127__$1;
(statearr_29187_29250[(2)] = inst_29056);

(statearr_29187_29250[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (5))){
var inst_29002 = cljs.core.deref.call(null,cs);
var inst_29003 = cljs.core.seq.call(null,inst_29002);
var inst_29004 = inst_29003;
var inst_29005 = null;
var inst_29006 = (0);
var inst_29007 = (0);
var state_29127__$1 = (function (){var statearr_29188 = state_29127;
(statearr_29188[(14)] = inst_29007);

(statearr_29188[(15)] = inst_29005);

(statearr_29188[(16)] = inst_29004);

(statearr_29188[(17)] = inst_29006);

return statearr_29188;
})();
var statearr_29189_29251 = state_29127__$1;
(statearr_29189_29251[(2)] = null);

(statearr_29189_29251[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (14))){
var state_29127__$1 = state_29127;
var statearr_29190_29252 = state_29127__$1;
(statearr_29190_29252[(2)] = null);

(statearr_29190_29252[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (45))){
var inst_29117 = (state_29127[(2)]);
var state_29127__$1 = state_29127;
var statearr_29191_29253 = state_29127__$1;
(statearr_29191_29253[(2)] = inst_29117);

(statearr_29191_29253[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (26))){
var inst_29059 = (state_29127[(29)]);
var inst_29113 = (state_29127[(2)]);
var inst_29114 = cljs.core.seq.call(null,inst_29059);
var state_29127__$1 = (function (){var statearr_29192 = state_29127;
(statearr_29192[(31)] = inst_29113);

return statearr_29192;
})();
if(inst_29114){
var statearr_29193_29254 = state_29127__$1;
(statearr_29193_29254[(1)] = (42));

} else {
var statearr_29194_29255 = state_29127__$1;
(statearr_29194_29255[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (16))){
var inst_29026 = (state_29127[(7)]);
var inst_29028 = cljs.core.chunked_seq_QMARK_.call(null,inst_29026);
var state_29127__$1 = state_29127;
if(inst_29028){
var statearr_29195_29256 = state_29127__$1;
(statearr_29195_29256[(1)] = (19));

} else {
var statearr_29196_29257 = state_29127__$1;
(statearr_29196_29257[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (38))){
var inst_29106 = (state_29127[(2)]);
var state_29127__$1 = state_29127;
var statearr_29197_29258 = state_29127__$1;
(statearr_29197_29258[(2)] = inst_29106);

(statearr_29197_29258[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (30))){
var state_29127__$1 = state_29127;
var statearr_29198_29259 = state_29127__$1;
(statearr_29198_29259[(2)] = null);

(statearr_29198_29259[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (10))){
var inst_29007 = (state_29127[(14)]);
var inst_29005 = (state_29127[(15)]);
var inst_29015 = cljs.core._nth.call(null,inst_29005,inst_29007);
var inst_29016 = cljs.core.nth.call(null,inst_29015,(0),null);
var inst_29017 = cljs.core.nth.call(null,inst_29015,(1),null);
var state_29127__$1 = (function (){var statearr_29199 = state_29127;
(statearr_29199[(26)] = inst_29016);

return statearr_29199;
})();
if(cljs.core.truth_(inst_29017)){
var statearr_29200_29260 = state_29127__$1;
(statearr_29200_29260[(1)] = (13));

} else {
var statearr_29201_29261 = state_29127__$1;
(statearr_29201_29261[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (18))){
var inst_29052 = (state_29127[(2)]);
var state_29127__$1 = state_29127;
var statearr_29202_29262 = state_29127__$1;
(statearr_29202_29262[(2)] = inst_29052);

(statearr_29202_29262[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (42))){
var state_29127__$1 = state_29127;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29127__$1,(45),dchan);
} else {
if((state_val_29128 === (37))){
var inst_29086 = (state_29127[(25)]);
var inst_28995 = (state_29127[(11)]);
var inst_29095 = (state_29127[(23)]);
var inst_29095__$1 = cljs.core.first.call(null,inst_29086);
var inst_29096 = cljs.core.async.put_BANG_.call(null,inst_29095__$1,inst_28995,done);
var state_29127__$1 = (function (){var statearr_29203 = state_29127;
(statearr_29203[(23)] = inst_29095__$1);

return statearr_29203;
})();
if(cljs.core.truth_(inst_29096)){
var statearr_29204_29263 = state_29127__$1;
(statearr_29204_29263[(1)] = (39));

} else {
var statearr_29205_29264 = state_29127__$1;
(statearr_29205_29264[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29128 === (8))){
var inst_29007 = (state_29127[(14)]);
var inst_29006 = (state_29127[(17)]);
var inst_29009 = (inst_29007 < inst_29006);
var inst_29010 = inst_29009;
var state_29127__$1 = state_29127;
if(cljs.core.truth_(inst_29010)){
var statearr_29206_29265 = state_29127__$1;
(statearr_29206_29265[(1)] = (10));

} else {
var statearr_29207_29266 = state_29127__$1;
(statearr_29207_29266[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___29212,cs,m,dchan,dctr,done))
;
return ((function (switch__26364__auto__,c__26531__auto___29212,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__26365__auto__ = null;
var cljs$core$async$mult_$_state_machine__26365__auto____0 = (function (){
var statearr_29208 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29208[(0)] = cljs$core$async$mult_$_state_machine__26365__auto__);

(statearr_29208[(1)] = (1));

return statearr_29208;
});
var cljs$core$async$mult_$_state_machine__26365__auto____1 = (function (state_29127){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_29127);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e29209){if((e29209 instanceof Object)){
var ex__26368__auto__ = e29209;
var statearr_29210_29267 = state_29127;
(statearr_29210_29267[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29127);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29209;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29268 = state_29127;
state_29127 = G__29268;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__26365__auto__ = function(state_29127){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__26365__auto____1.call(this,state_29127);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__26365__auto____0;
cljs$core$async$mult_$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__26365__auto____1;
return cljs$core$async$mult_$_state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___29212,cs,m,dchan,dctr,done))
})();
var state__26533__auto__ = (function (){var statearr_29211 = f__26532__auto__.call(null);
(statearr_29211[(6)] = c__26531__auto___29212);

return statearr_29211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___29212,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__29270 = arguments.length;
switch (G__29270) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___29282 = arguments.length;
var i__4731__auto___29283 = (0);
while(true){
if((i__4731__auto___29283 < len__4730__auto___29282)){
args__4736__auto__.push((arguments[i__4731__auto___29283]));

var G__29284 = (i__4731__auto___29283 + (1));
i__4731__auto___29283 = G__29284;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__29276){
var map__29277 = p__29276;
var map__29277__$1 = (((((!((map__29277 == null))))?(((((map__29277.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29277.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__29277):map__29277);
var opts = map__29277__$1;
var statearr_29279_29285 = state;
(statearr_29279_29285[(1)] = cont_block);


var temp__5735__auto__ = cljs.core.async.do_alts.call(null,((function (map__29277,map__29277__$1,opts){
return (function (val){
var statearr_29280_29286 = state;
(statearr_29280_29286[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__29277,map__29277__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5735__auto__)){
var cb = temp__5735__auto__;
var statearr_29281_29287 = state;
(statearr_29281_29287[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq29272){
var G__29273 = cljs.core.first.call(null,seq29272);
var seq29272__$1 = cljs.core.next.call(null,seq29272);
var G__29274 = cljs.core.first.call(null,seq29272__$1);
var seq29272__$2 = cljs.core.next.call(null,seq29272__$1);
var G__29275 = cljs.core.first.call(null,seq29272__$2);
var seq29272__$3 = cljs.core.next.call(null,seq29272__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__29273,G__29274,G__29275,seq29272__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29288 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29288 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta29289){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta29289 = meta29289;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async29288.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_29290,meta29289__$1){
var self__ = this;
var _29290__$1 = this;
return (new cljs.core.async.t_cljs$core$async29288(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta29289__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29288.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_29290){
var self__ = this;
var _29290__$1 = this;
return self__.meta29289;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29288.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29288.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29288.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29288.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29288.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29288.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29288.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29288.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29288.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta29289","meta29289",-903896462,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async29288.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29288.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29288";

cljs.core.async.t_cljs$core$async29288.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async29288");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29288.
 */
cljs.core.async.__GT_t_cljs$core$async29288 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async29288(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29289){
return (new cljs.core.async.t_cljs$core$async29288(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta29289));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async29288(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__26531__auto___29452 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___29452,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___29452,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_29392){
var state_val_29393 = (state_29392[(1)]);
if((state_val_29393 === (7))){
var inst_29307 = (state_29392[(2)]);
var state_29392__$1 = state_29392;
var statearr_29394_29453 = state_29392__$1;
(statearr_29394_29453[(2)] = inst_29307);

(statearr_29394_29453[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (20))){
var inst_29319 = (state_29392[(7)]);
var state_29392__$1 = state_29392;
var statearr_29395_29454 = state_29392__$1;
(statearr_29395_29454[(2)] = inst_29319);

(statearr_29395_29454[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (27))){
var state_29392__$1 = state_29392;
var statearr_29396_29455 = state_29392__$1;
(statearr_29396_29455[(2)] = null);

(statearr_29396_29455[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (1))){
var inst_29294 = (state_29392[(8)]);
var inst_29294__$1 = calc_state.call(null);
var inst_29296 = (inst_29294__$1 == null);
var inst_29297 = cljs.core.not.call(null,inst_29296);
var state_29392__$1 = (function (){var statearr_29397 = state_29392;
(statearr_29397[(8)] = inst_29294__$1);

return statearr_29397;
})();
if(inst_29297){
var statearr_29398_29456 = state_29392__$1;
(statearr_29398_29456[(1)] = (2));

} else {
var statearr_29399_29457 = state_29392__$1;
(statearr_29399_29457[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (24))){
var inst_29366 = (state_29392[(9)]);
var inst_29352 = (state_29392[(10)]);
var inst_29343 = (state_29392[(11)]);
var inst_29366__$1 = inst_29343.call(null,inst_29352);
var state_29392__$1 = (function (){var statearr_29400 = state_29392;
(statearr_29400[(9)] = inst_29366__$1);

return statearr_29400;
})();
if(cljs.core.truth_(inst_29366__$1)){
var statearr_29401_29458 = state_29392__$1;
(statearr_29401_29458[(1)] = (29));

} else {
var statearr_29402_29459 = state_29392__$1;
(statearr_29402_29459[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (4))){
var inst_29310 = (state_29392[(2)]);
var state_29392__$1 = state_29392;
if(cljs.core.truth_(inst_29310)){
var statearr_29403_29460 = state_29392__$1;
(statearr_29403_29460[(1)] = (8));

} else {
var statearr_29404_29461 = state_29392__$1;
(statearr_29404_29461[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (15))){
var inst_29337 = (state_29392[(2)]);
var state_29392__$1 = state_29392;
if(cljs.core.truth_(inst_29337)){
var statearr_29405_29462 = state_29392__$1;
(statearr_29405_29462[(1)] = (19));

} else {
var statearr_29406_29463 = state_29392__$1;
(statearr_29406_29463[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (21))){
var inst_29342 = (state_29392[(12)]);
var inst_29342__$1 = (state_29392[(2)]);
var inst_29343 = cljs.core.get.call(null,inst_29342__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29344 = cljs.core.get.call(null,inst_29342__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29345 = cljs.core.get.call(null,inst_29342__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_29392__$1 = (function (){var statearr_29407 = state_29392;
(statearr_29407[(13)] = inst_29344);

(statearr_29407[(11)] = inst_29343);

(statearr_29407[(12)] = inst_29342__$1);

return statearr_29407;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_29392__$1,(22),inst_29345);
} else {
if((state_val_29393 === (31))){
var inst_29374 = (state_29392[(2)]);
var state_29392__$1 = state_29392;
if(cljs.core.truth_(inst_29374)){
var statearr_29408_29464 = state_29392__$1;
(statearr_29408_29464[(1)] = (32));

} else {
var statearr_29409_29465 = state_29392__$1;
(statearr_29409_29465[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (32))){
var inst_29351 = (state_29392[(14)]);
var state_29392__$1 = state_29392;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29392__$1,(35),out,inst_29351);
} else {
if((state_val_29393 === (33))){
var inst_29342 = (state_29392[(12)]);
var inst_29319 = inst_29342;
var state_29392__$1 = (function (){var statearr_29410 = state_29392;
(statearr_29410[(7)] = inst_29319);

return statearr_29410;
})();
var statearr_29411_29466 = state_29392__$1;
(statearr_29411_29466[(2)] = null);

(statearr_29411_29466[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (13))){
var inst_29319 = (state_29392[(7)]);
var inst_29326 = inst_29319.cljs$lang$protocol_mask$partition0$;
var inst_29327 = (inst_29326 & (64));
var inst_29328 = inst_29319.cljs$core$ISeq$;
var inst_29329 = (cljs.core.PROTOCOL_SENTINEL === inst_29328);
var inst_29330 = ((inst_29327) || (inst_29329));
var state_29392__$1 = state_29392;
if(cljs.core.truth_(inst_29330)){
var statearr_29412_29467 = state_29392__$1;
(statearr_29412_29467[(1)] = (16));

} else {
var statearr_29413_29468 = state_29392__$1;
(statearr_29413_29468[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (22))){
var inst_29351 = (state_29392[(14)]);
var inst_29352 = (state_29392[(10)]);
var inst_29350 = (state_29392[(2)]);
var inst_29351__$1 = cljs.core.nth.call(null,inst_29350,(0),null);
var inst_29352__$1 = cljs.core.nth.call(null,inst_29350,(1),null);
var inst_29353 = (inst_29351__$1 == null);
var inst_29354 = cljs.core._EQ_.call(null,inst_29352__$1,change);
var inst_29355 = ((inst_29353) || (inst_29354));
var state_29392__$1 = (function (){var statearr_29414 = state_29392;
(statearr_29414[(14)] = inst_29351__$1);

(statearr_29414[(10)] = inst_29352__$1);

return statearr_29414;
})();
if(cljs.core.truth_(inst_29355)){
var statearr_29415_29469 = state_29392__$1;
(statearr_29415_29469[(1)] = (23));

} else {
var statearr_29416_29470 = state_29392__$1;
(statearr_29416_29470[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (36))){
var inst_29342 = (state_29392[(12)]);
var inst_29319 = inst_29342;
var state_29392__$1 = (function (){var statearr_29417 = state_29392;
(statearr_29417[(7)] = inst_29319);

return statearr_29417;
})();
var statearr_29418_29471 = state_29392__$1;
(statearr_29418_29471[(2)] = null);

(statearr_29418_29471[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (29))){
var inst_29366 = (state_29392[(9)]);
var state_29392__$1 = state_29392;
var statearr_29419_29472 = state_29392__$1;
(statearr_29419_29472[(2)] = inst_29366);

(statearr_29419_29472[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (6))){
var state_29392__$1 = state_29392;
var statearr_29420_29473 = state_29392__$1;
(statearr_29420_29473[(2)] = false);

(statearr_29420_29473[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (28))){
var inst_29362 = (state_29392[(2)]);
var inst_29363 = calc_state.call(null);
var inst_29319 = inst_29363;
var state_29392__$1 = (function (){var statearr_29421 = state_29392;
(statearr_29421[(15)] = inst_29362);

(statearr_29421[(7)] = inst_29319);

return statearr_29421;
})();
var statearr_29422_29474 = state_29392__$1;
(statearr_29422_29474[(2)] = null);

(statearr_29422_29474[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (25))){
var inst_29388 = (state_29392[(2)]);
var state_29392__$1 = state_29392;
var statearr_29423_29475 = state_29392__$1;
(statearr_29423_29475[(2)] = inst_29388);

(statearr_29423_29475[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (34))){
var inst_29386 = (state_29392[(2)]);
var state_29392__$1 = state_29392;
var statearr_29424_29476 = state_29392__$1;
(statearr_29424_29476[(2)] = inst_29386);

(statearr_29424_29476[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (17))){
var state_29392__$1 = state_29392;
var statearr_29425_29477 = state_29392__$1;
(statearr_29425_29477[(2)] = false);

(statearr_29425_29477[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (3))){
var state_29392__$1 = state_29392;
var statearr_29426_29478 = state_29392__$1;
(statearr_29426_29478[(2)] = false);

(statearr_29426_29478[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (12))){
var inst_29390 = (state_29392[(2)]);
var state_29392__$1 = state_29392;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29392__$1,inst_29390);
} else {
if((state_val_29393 === (2))){
var inst_29294 = (state_29392[(8)]);
var inst_29299 = inst_29294.cljs$lang$protocol_mask$partition0$;
var inst_29300 = (inst_29299 & (64));
var inst_29301 = inst_29294.cljs$core$ISeq$;
var inst_29302 = (cljs.core.PROTOCOL_SENTINEL === inst_29301);
var inst_29303 = ((inst_29300) || (inst_29302));
var state_29392__$1 = state_29392;
if(cljs.core.truth_(inst_29303)){
var statearr_29427_29479 = state_29392__$1;
(statearr_29427_29479[(1)] = (5));

} else {
var statearr_29428_29480 = state_29392__$1;
(statearr_29428_29480[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (23))){
var inst_29351 = (state_29392[(14)]);
var inst_29357 = (inst_29351 == null);
var state_29392__$1 = state_29392;
if(cljs.core.truth_(inst_29357)){
var statearr_29429_29481 = state_29392__$1;
(statearr_29429_29481[(1)] = (26));

} else {
var statearr_29430_29482 = state_29392__$1;
(statearr_29430_29482[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (35))){
var inst_29377 = (state_29392[(2)]);
var state_29392__$1 = state_29392;
if(cljs.core.truth_(inst_29377)){
var statearr_29431_29483 = state_29392__$1;
(statearr_29431_29483[(1)] = (36));

} else {
var statearr_29432_29484 = state_29392__$1;
(statearr_29432_29484[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (19))){
var inst_29319 = (state_29392[(7)]);
var inst_29339 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29319);
var state_29392__$1 = state_29392;
var statearr_29433_29485 = state_29392__$1;
(statearr_29433_29485[(2)] = inst_29339);

(statearr_29433_29485[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (11))){
var inst_29319 = (state_29392[(7)]);
var inst_29323 = (inst_29319 == null);
var inst_29324 = cljs.core.not.call(null,inst_29323);
var state_29392__$1 = state_29392;
if(inst_29324){
var statearr_29434_29486 = state_29392__$1;
(statearr_29434_29486[(1)] = (13));

} else {
var statearr_29435_29487 = state_29392__$1;
(statearr_29435_29487[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (9))){
var inst_29294 = (state_29392[(8)]);
var state_29392__$1 = state_29392;
var statearr_29436_29488 = state_29392__$1;
(statearr_29436_29488[(2)] = inst_29294);

(statearr_29436_29488[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (5))){
var state_29392__$1 = state_29392;
var statearr_29437_29489 = state_29392__$1;
(statearr_29437_29489[(2)] = true);

(statearr_29437_29489[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (14))){
var state_29392__$1 = state_29392;
var statearr_29438_29490 = state_29392__$1;
(statearr_29438_29490[(2)] = false);

(statearr_29438_29490[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (26))){
var inst_29352 = (state_29392[(10)]);
var inst_29359 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_29352);
var state_29392__$1 = state_29392;
var statearr_29439_29491 = state_29392__$1;
(statearr_29439_29491[(2)] = inst_29359);

(statearr_29439_29491[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (16))){
var state_29392__$1 = state_29392;
var statearr_29440_29492 = state_29392__$1;
(statearr_29440_29492[(2)] = true);

(statearr_29440_29492[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (38))){
var inst_29382 = (state_29392[(2)]);
var state_29392__$1 = state_29392;
var statearr_29441_29493 = state_29392__$1;
(statearr_29441_29493[(2)] = inst_29382);

(statearr_29441_29493[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (30))){
var inst_29344 = (state_29392[(13)]);
var inst_29352 = (state_29392[(10)]);
var inst_29343 = (state_29392[(11)]);
var inst_29369 = cljs.core.empty_QMARK_.call(null,inst_29343);
var inst_29370 = inst_29344.call(null,inst_29352);
var inst_29371 = cljs.core.not.call(null,inst_29370);
var inst_29372 = ((inst_29369) && (inst_29371));
var state_29392__$1 = state_29392;
var statearr_29442_29494 = state_29392__$1;
(statearr_29442_29494[(2)] = inst_29372);

(statearr_29442_29494[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (10))){
var inst_29294 = (state_29392[(8)]);
var inst_29315 = (state_29392[(2)]);
var inst_29316 = cljs.core.get.call(null,inst_29315,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_29317 = cljs.core.get.call(null,inst_29315,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_29318 = cljs.core.get.call(null,inst_29315,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_29319 = inst_29294;
var state_29392__$1 = (function (){var statearr_29443 = state_29392;
(statearr_29443[(16)] = inst_29318);

(statearr_29443[(17)] = inst_29316);

(statearr_29443[(7)] = inst_29319);

(statearr_29443[(18)] = inst_29317);

return statearr_29443;
})();
var statearr_29444_29495 = state_29392__$1;
(statearr_29444_29495[(2)] = null);

(statearr_29444_29495[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (18))){
var inst_29334 = (state_29392[(2)]);
var state_29392__$1 = state_29392;
var statearr_29445_29496 = state_29392__$1;
(statearr_29445_29496[(2)] = inst_29334);

(statearr_29445_29496[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (37))){
var state_29392__$1 = state_29392;
var statearr_29446_29497 = state_29392__$1;
(statearr_29446_29497[(2)] = null);

(statearr_29446_29497[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29393 === (8))){
var inst_29294 = (state_29392[(8)]);
var inst_29312 = cljs.core.apply.call(null,cljs.core.hash_map,inst_29294);
var state_29392__$1 = state_29392;
var statearr_29447_29498 = state_29392__$1;
(statearr_29447_29498[(2)] = inst_29312);

(statearr_29447_29498[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___29452,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__26364__auto__,c__26531__auto___29452,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__26365__auto__ = null;
var cljs$core$async$mix_$_state_machine__26365__auto____0 = (function (){
var statearr_29448 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29448[(0)] = cljs$core$async$mix_$_state_machine__26365__auto__);

(statearr_29448[(1)] = (1));

return statearr_29448;
});
var cljs$core$async$mix_$_state_machine__26365__auto____1 = (function (state_29392){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_29392);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e29449){if((e29449 instanceof Object)){
var ex__26368__auto__ = e29449;
var statearr_29450_29499 = state_29392;
(statearr_29450_29499[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29392);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29449;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29500 = state_29392;
state_29392 = G__29500;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__26365__auto__ = function(state_29392){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__26365__auto____1.call(this,state_29392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__26365__auto____0;
cljs$core$async$mix_$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__26365__auto____1;
return cljs$core$async$mix_$_state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___29452,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__26533__auto__ = (function (){var statearr_29451 = f__26532__auto__.call(null);
(statearr_29451[(6)] = c__26531__auto___29452);

return statearr_29451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___29452,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__29502 = arguments.length;
switch (G__29502) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__29506 = arguments.length;
switch (G__29506) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__29504_SHARP_){
if(cljs.core.truth_(p1__29504_SHARP_.call(null,topic))){
return p1__29504_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__29504_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29507 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29507 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta29508){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta29508 = meta29508;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async29507.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_29509,meta29508__$1){
var self__ = this;
var _29509__$1 = this;
return (new cljs.core.async.t_cljs$core$async29507(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta29508__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29507.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_29509){
var self__ = this;
var _29509__$1 = this;
return self__.meta29508;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29507.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29507.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29507.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29507.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29507.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5735__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5735__auto__)){
var m = temp__5735__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29507.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29507.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29507.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta29508","meta29508",-1028225744,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async29507.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29507.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29507";

cljs.core.async.t_cljs$core$async29507.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async29507");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29507.
 */
cljs.core.async.__GT_t_cljs$core$async29507 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async29507(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29508){
return (new cljs.core.async.t_cljs$core$async29507(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta29508));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async29507(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__26531__auto___29627 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___29627,mults,ensure_mult,p){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___29627,mults,ensure_mult,p){
return (function (state_29581){
var state_val_29582 = (state_29581[(1)]);
if((state_val_29582 === (7))){
var inst_29577 = (state_29581[(2)]);
var state_29581__$1 = state_29581;
var statearr_29583_29628 = state_29581__$1;
(statearr_29583_29628[(2)] = inst_29577);

(statearr_29583_29628[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (20))){
var state_29581__$1 = state_29581;
var statearr_29584_29629 = state_29581__$1;
(statearr_29584_29629[(2)] = null);

(statearr_29584_29629[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (1))){
var state_29581__$1 = state_29581;
var statearr_29585_29630 = state_29581__$1;
(statearr_29585_29630[(2)] = null);

(statearr_29585_29630[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (24))){
var inst_29560 = (state_29581[(7)]);
var inst_29569 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_29560);
var state_29581__$1 = state_29581;
var statearr_29586_29631 = state_29581__$1;
(statearr_29586_29631[(2)] = inst_29569);

(statearr_29586_29631[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (4))){
var inst_29512 = (state_29581[(8)]);
var inst_29512__$1 = (state_29581[(2)]);
var inst_29513 = (inst_29512__$1 == null);
var state_29581__$1 = (function (){var statearr_29587 = state_29581;
(statearr_29587[(8)] = inst_29512__$1);

return statearr_29587;
})();
if(cljs.core.truth_(inst_29513)){
var statearr_29588_29632 = state_29581__$1;
(statearr_29588_29632[(1)] = (5));

} else {
var statearr_29589_29633 = state_29581__$1;
(statearr_29589_29633[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (15))){
var inst_29554 = (state_29581[(2)]);
var state_29581__$1 = state_29581;
var statearr_29590_29634 = state_29581__$1;
(statearr_29590_29634[(2)] = inst_29554);

(statearr_29590_29634[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (21))){
var inst_29574 = (state_29581[(2)]);
var state_29581__$1 = (function (){var statearr_29591 = state_29581;
(statearr_29591[(9)] = inst_29574);

return statearr_29591;
})();
var statearr_29592_29635 = state_29581__$1;
(statearr_29592_29635[(2)] = null);

(statearr_29592_29635[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (13))){
var inst_29536 = (state_29581[(10)]);
var inst_29538 = cljs.core.chunked_seq_QMARK_.call(null,inst_29536);
var state_29581__$1 = state_29581;
if(inst_29538){
var statearr_29593_29636 = state_29581__$1;
(statearr_29593_29636[(1)] = (16));

} else {
var statearr_29594_29637 = state_29581__$1;
(statearr_29594_29637[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (22))){
var inst_29566 = (state_29581[(2)]);
var state_29581__$1 = state_29581;
if(cljs.core.truth_(inst_29566)){
var statearr_29595_29638 = state_29581__$1;
(statearr_29595_29638[(1)] = (23));

} else {
var statearr_29596_29639 = state_29581__$1;
(statearr_29596_29639[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (6))){
var inst_29560 = (state_29581[(7)]);
var inst_29562 = (state_29581[(11)]);
var inst_29512 = (state_29581[(8)]);
var inst_29560__$1 = topic_fn.call(null,inst_29512);
var inst_29561 = cljs.core.deref.call(null,mults);
var inst_29562__$1 = cljs.core.get.call(null,inst_29561,inst_29560__$1);
var state_29581__$1 = (function (){var statearr_29597 = state_29581;
(statearr_29597[(7)] = inst_29560__$1);

(statearr_29597[(11)] = inst_29562__$1);

return statearr_29597;
})();
if(cljs.core.truth_(inst_29562__$1)){
var statearr_29598_29640 = state_29581__$1;
(statearr_29598_29640[(1)] = (19));

} else {
var statearr_29599_29641 = state_29581__$1;
(statearr_29599_29641[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (25))){
var inst_29571 = (state_29581[(2)]);
var state_29581__$1 = state_29581;
var statearr_29600_29642 = state_29581__$1;
(statearr_29600_29642[(2)] = inst_29571);

(statearr_29600_29642[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (17))){
var inst_29536 = (state_29581[(10)]);
var inst_29545 = cljs.core.first.call(null,inst_29536);
var inst_29546 = cljs.core.async.muxch_STAR_.call(null,inst_29545);
var inst_29547 = cljs.core.async.close_BANG_.call(null,inst_29546);
var inst_29548 = cljs.core.next.call(null,inst_29536);
var inst_29522 = inst_29548;
var inst_29523 = null;
var inst_29524 = (0);
var inst_29525 = (0);
var state_29581__$1 = (function (){var statearr_29601 = state_29581;
(statearr_29601[(12)] = inst_29524);

(statearr_29601[(13)] = inst_29547);

(statearr_29601[(14)] = inst_29522);

(statearr_29601[(15)] = inst_29525);

(statearr_29601[(16)] = inst_29523);

return statearr_29601;
})();
var statearr_29602_29643 = state_29581__$1;
(statearr_29602_29643[(2)] = null);

(statearr_29602_29643[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (3))){
var inst_29579 = (state_29581[(2)]);
var state_29581__$1 = state_29581;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29581__$1,inst_29579);
} else {
if((state_val_29582 === (12))){
var inst_29556 = (state_29581[(2)]);
var state_29581__$1 = state_29581;
var statearr_29603_29644 = state_29581__$1;
(statearr_29603_29644[(2)] = inst_29556);

(statearr_29603_29644[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (2))){
var state_29581__$1 = state_29581;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29581__$1,(4),ch);
} else {
if((state_val_29582 === (23))){
var state_29581__$1 = state_29581;
var statearr_29604_29645 = state_29581__$1;
(statearr_29604_29645[(2)] = null);

(statearr_29604_29645[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (19))){
var inst_29562 = (state_29581[(11)]);
var inst_29512 = (state_29581[(8)]);
var inst_29564 = cljs.core.async.muxch_STAR_.call(null,inst_29562);
var state_29581__$1 = state_29581;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29581__$1,(22),inst_29564,inst_29512);
} else {
if((state_val_29582 === (11))){
var inst_29522 = (state_29581[(14)]);
var inst_29536 = (state_29581[(10)]);
var inst_29536__$1 = cljs.core.seq.call(null,inst_29522);
var state_29581__$1 = (function (){var statearr_29605 = state_29581;
(statearr_29605[(10)] = inst_29536__$1);

return statearr_29605;
})();
if(inst_29536__$1){
var statearr_29606_29646 = state_29581__$1;
(statearr_29606_29646[(1)] = (13));

} else {
var statearr_29607_29647 = state_29581__$1;
(statearr_29607_29647[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (9))){
var inst_29558 = (state_29581[(2)]);
var state_29581__$1 = state_29581;
var statearr_29608_29648 = state_29581__$1;
(statearr_29608_29648[(2)] = inst_29558);

(statearr_29608_29648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (5))){
var inst_29519 = cljs.core.deref.call(null,mults);
var inst_29520 = cljs.core.vals.call(null,inst_29519);
var inst_29521 = cljs.core.seq.call(null,inst_29520);
var inst_29522 = inst_29521;
var inst_29523 = null;
var inst_29524 = (0);
var inst_29525 = (0);
var state_29581__$1 = (function (){var statearr_29609 = state_29581;
(statearr_29609[(12)] = inst_29524);

(statearr_29609[(14)] = inst_29522);

(statearr_29609[(15)] = inst_29525);

(statearr_29609[(16)] = inst_29523);

return statearr_29609;
})();
var statearr_29610_29649 = state_29581__$1;
(statearr_29610_29649[(2)] = null);

(statearr_29610_29649[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (14))){
var state_29581__$1 = state_29581;
var statearr_29614_29650 = state_29581__$1;
(statearr_29614_29650[(2)] = null);

(statearr_29614_29650[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (16))){
var inst_29536 = (state_29581[(10)]);
var inst_29540 = cljs.core.chunk_first.call(null,inst_29536);
var inst_29541 = cljs.core.chunk_rest.call(null,inst_29536);
var inst_29542 = cljs.core.count.call(null,inst_29540);
var inst_29522 = inst_29541;
var inst_29523 = inst_29540;
var inst_29524 = inst_29542;
var inst_29525 = (0);
var state_29581__$1 = (function (){var statearr_29615 = state_29581;
(statearr_29615[(12)] = inst_29524);

(statearr_29615[(14)] = inst_29522);

(statearr_29615[(15)] = inst_29525);

(statearr_29615[(16)] = inst_29523);

return statearr_29615;
})();
var statearr_29616_29651 = state_29581__$1;
(statearr_29616_29651[(2)] = null);

(statearr_29616_29651[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (10))){
var inst_29524 = (state_29581[(12)]);
var inst_29522 = (state_29581[(14)]);
var inst_29525 = (state_29581[(15)]);
var inst_29523 = (state_29581[(16)]);
var inst_29530 = cljs.core._nth.call(null,inst_29523,inst_29525);
var inst_29531 = cljs.core.async.muxch_STAR_.call(null,inst_29530);
var inst_29532 = cljs.core.async.close_BANG_.call(null,inst_29531);
var inst_29533 = (inst_29525 + (1));
var tmp29611 = inst_29524;
var tmp29612 = inst_29522;
var tmp29613 = inst_29523;
var inst_29522__$1 = tmp29612;
var inst_29523__$1 = tmp29613;
var inst_29524__$1 = tmp29611;
var inst_29525__$1 = inst_29533;
var state_29581__$1 = (function (){var statearr_29617 = state_29581;
(statearr_29617[(12)] = inst_29524__$1);

(statearr_29617[(14)] = inst_29522__$1);

(statearr_29617[(17)] = inst_29532);

(statearr_29617[(15)] = inst_29525__$1);

(statearr_29617[(16)] = inst_29523__$1);

return statearr_29617;
})();
var statearr_29618_29652 = state_29581__$1;
(statearr_29618_29652[(2)] = null);

(statearr_29618_29652[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (18))){
var inst_29551 = (state_29581[(2)]);
var state_29581__$1 = state_29581;
var statearr_29619_29653 = state_29581__$1;
(statearr_29619_29653[(2)] = inst_29551);

(statearr_29619_29653[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29582 === (8))){
var inst_29524 = (state_29581[(12)]);
var inst_29525 = (state_29581[(15)]);
var inst_29527 = (inst_29525 < inst_29524);
var inst_29528 = inst_29527;
var state_29581__$1 = state_29581;
if(cljs.core.truth_(inst_29528)){
var statearr_29620_29654 = state_29581__$1;
(statearr_29620_29654[(1)] = (10));

} else {
var statearr_29621_29655 = state_29581__$1;
(statearr_29621_29655[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___29627,mults,ensure_mult,p))
;
return ((function (switch__26364__auto__,c__26531__auto___29627,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__26365__auto__ = null;
var cljs$core$async$state_machine__26365__auto____0 = (function (){
var statearr_29622 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29622[(0)] = cljs$core$async$state_machine__26365__auto__);

(statearr_29622[(1)] = (1));

return statearr_29622;
});
var cljs$core$async$state_machine__26365__auto____1 = (function (state_29581){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_29581);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e29623){if((e29623 instanceof Object)){
var ex__26368__auto__ = e29623;
var statearr_29624_29656 = state_29581;
(statearr_29624_29656[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29581);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29623;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29657 = state_29581;
state_29581 = G__29657;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$state_machine__26365__auto__ = function(state_29581){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26365__auto____1.call(this,state_29581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26365__auto____0;
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26365__auto____1;
return cljs$core$async$state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___29627,mults,ensure_mult,p))
})();
var state__26533__auto__ = (function (){var statearr_29625 = f__26532__auto__.call(null);
(statearr_29625[(6)] = c__26531__auto___29627);

return statearr_29625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___29627,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__29659 = arguments.length;
switch (G__29659) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__29662 = arguments.length;
switch (G__29662) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__29665 = arguments.length;
switch (G__29665) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__26531__auto___29732 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___29732,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___29732,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_29704){
var state_val_29705 = (state_29704[(1)]);
if((state_val_29705 === (7))){
var state_29704__$1 = state_29704;
var statearr_29706_29733 = state_29704__$1;
(statearr_29706_29733[(2)] = null);

(statearr_29706_29733[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (1))){
var state_29704__$1 = state_29704;
var statearr_29707_29734 = state_29704__$1;
(statearr_29707_29734[(2)] = null);

(statearr_29707_29734[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (4))){
var inst_29668 = (state_29704[(7)]);
var inst_29670 = (inst_29668 < cnt);
var state_29704__$1 = state_29704;
if(cljs.core.truth_(inst_29670)){
var statearr_29708_29735 = state_29704__$1;
(statearr_29708_29735[(1)] = (6));

} else {
var statearr_29709_29736 = state_29704__$1;
(statearr_29709_29736[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (15))){
var inst_29700 = (state_29704[(2)]);
var state_29704__$1 = state_29704;
var statearr_29710_29737 = state_29704__$1;
(statearr_29710_29737[(2)] = inst_29700);

(statearr_29710_29737[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (13))){
var inst_29693 = cljs.core.async.close_BANG_.call(null,out);
var state_29704__$1 = state_29704;
var statearr_29711_29738 = state_29704__$1;
(statearr_29711_29738[(2)] = inst_29693);

(statearr_29711_29738[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (6))){
var state_29704__$1 = state_29704;
var statearr_29712_29739 = state_29704__$1;
(statearr_29712_29739[(2)] = null);

(statearr_29712_29739[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (3))){
var inst_29702 = (state_29704[(2)]);
var state_29704__$1 = state_29704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29704__$1,inst_29702);
} else {
if((state_val_29705 === (12))){
var inst_29690 = (state_29704[(8)]);
var inst_29690__$1 = (state_29704[(2)]);
var inst_29691 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_29690__$1);
var state_29704__$1 = (function (){var statearr_29713 = state_29704;
(statearr_29713[(8)] = inst_29690__$1);

return statearr_29713;
})();
if(cljs.core.truth_(inst_29691)){
var statearr_29714_29740 = state_29704__$1;
(statearr_29714_29740[(1)] = (13));

} else {
var statearr_29715_29741 = state_29704__$1;
(statearr_29715_29741[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (2))){
var inst_29667 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_29668 = (0);
var state_29704__$1 = (function (){var statearr_29716 = state_29704;
(statearr_29716[(9)] = inst_29667);

(statearr_29716[(7)] = inst_29668);

return statearr_29716;
})();
var statearr_29717_29742 = state_29704__$1;
(statearr_29717_29742[(2)] = null);

(statearr_29717_29742[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (11))){
var inst_29668 = (state_29704[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_29704,(10),Object,null,(9));
var inst_29677 = chs__$1.call(null,inst_29668);
var inst_29678 = done.call(null,inst_29668);
var inst_29679 = cljs.core.async.take_BANG_.call(null,inst_29677,inst_29678);
var state_29704__$1 = state_29704;
var statearr_29718_29743 = state_29704__$1;
(statearr_29718_29743[(2)] = inst_29679);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29704__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (9))){
var inst_29668 = (state_29704[(7)]);
var inst_29681 = (state_29704[(2)]);
var inst_29682 = (inst_29668 + (1));
var inst_29668__$1 = inst_29682;
var state_29704__$1 = (function (){var statearr_29719 = state_29704;
(statearr_29719[(10)] = inst_29681);

(statearr_29719[(7)] = inst_29668__$1);

return statearr_29719;
})();
var statearr_29720_29744 = state_29704__$1;
(statearr_29720_29744[(2)] = null);

(statearr_29720_29744[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (5))){
var inst_29688 = (state_29704[(2)]);
var state_29704__$1 = (function (){var statearr_29721 = state_29704;
(statearr_29721[(11)] = inst_29688);

return statearr_29721;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29704__$1,(12),dchan);
} else {
if((state_val_29705 === (14))){
var inst_29690 = (state_29704[(8)]);
var inst_29695 = cljs.core.apply.call(null,f,inst_29690);
var state_29704__$1 = state_29704;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29704__$1,(16),out,inst_29695);
} else {
if((state_val_29705 === (16))){
var inst_29697 = (state_29704[(2)]);
var state_29704__$1 = (function (){var statearr_29722 = state_29704;
(statearr_29722[(12)] = inst_29697);

return statearr_29722;
})();
var statearr_29723_29745 = state_29704__$1;
(statearr_29723_29745[(2)] = null);

(statearr_29723_29745[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (10))){
var inst_29672 = (state_29704[(2)]);
var inst_29673 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_29704__$1 = (function (){var statearr_29724 = state_29704;
(statearr_29724[(13)] = inst_29672);

return statearr_29724;
})();
var statearr_29725_29746 = state_29704__$1;
(statearr_29725_29746[(2)] = inst_29673);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29704__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29705 === (8))){
var inst_29686 = (state_29704[(2)]);
var state_29704__$1 = state_29704;
var statearr_29726_29747 = state_29704__$1;
(statearr_29726_29747[(2)] = inst_29686);

(statearr_29726_29747[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___29732,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__26364__auto__,c__26531__auto___29732,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__26365__auto__ = null;
var cljs$core$async$state_machine__26365__auto____0 = (function (){
var statearr_29727 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29727[(0)] = cljs$core$async$state_machine__26365__auto__);

(statearr_29727[(1)] = (1));

return statearr_29727;
});
var cljs$core$async$state_machine__26365__auto____1 = (function (state_29704){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_29704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e29728){if((e29728 instanceof Object)){
var ex__26368__auto__ = e29728;
var statearr_29729_29748 = state_29704;
(statearr_29729_29748[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29704);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29728;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29749 = state_29704;
state_29704 = G__29749;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$state_machine__26365__auto__ = function(state_29704){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26365__auto____1.call(this,state_29704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26365__auto____0;
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26365__auto____1;
return cljs$core$async$state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___29732,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__26533__auto__ = (function (){var statearr_29730 = f__26532__auto__.call(null);
(statearr_29730[(6)] = c__26531__auto___29732);

return statearr_29730;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___29732,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__29752 = arguments.length;
switch (G__29752) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26531__auto___29806 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___29806,out){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___29806,out){
return (function (state_29784){
var state_val_29785 = (state_29784[(1)]);
if((state_val_29785 === (7))){
var inst_29763 = (state_29784[(7)]);
var inst_29764 = (state_29784[(8)]);
var inst_29763__$1 = (state_29784[(2)]);
var inst_29764__$1 = cljs.core.nth.call(null,inst_29763__$1,(0),null);
var inst_29765 = cljs.core.nth.call(null,inst_29763__$1,(1),null);
var inst_29766 = (inst_29764__$1 == null);
var state_29784__$1 = (function (){var statearr_29786 = state_29784;
(statearr_29786[(7)] = inst_29763__$1);

(statearr_29786[(8)] = inst_29764__$1);

(statearr_29786[(9)] = inst_29765);

return statearr_29786;
})();
if(cljs.core.truth_(inst_29766)){
var statearr_29787_29807 = state_29784__$1;
(statearr_29787_29807[(1)] = (8));

} else {
var statearr_29788_29808 = state_29784__$1;
(statearr_29788_29808[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29785 === (1))){
var inst_29753 = cljs.core.vec.call(null,chs);
var inst_29754 = inst_29753;
var state_29784__$1 = (function (){var statearr_29789 = state_29784;
(statearr_29789[(10)] = inst_29754);

return statearr_29789;
})();
var statearr_29790_29809 = state_29784__$1;
(statearr_29790_29809[(2)] = null);

(statearr_29790_29809[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29785 === (4))){
var inst_29754 = (state_29784[(10)]);
var state_29784__$1 = state_29784;
return cljs.core.async.ioc_alts_BANG_.call(null,state_29784__$1,(7),inst_29754);
} else {
if((state_val_29785 === (6))){
var inst_29780 = (state_29784[(2)]);
var state_29784__$1 = state_29784;
var statearr_29791_29810 = state_29784__$1;
(statearr_29791_29810[(2)] = inst_29780);

(statearr_29791_29810[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29785 === (3))){
var inst_29782 = (state_29784[(2)]);
var state_29784__$1 = state_29784;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29784__$1,inst_29782);
} else {
if((state_val_29785 === (2))){
var inst_29754 = (state_29784[(10)]);
var inst_29756 = cljs.core.count.call(null,inst_29754);
var inst_29757 = (inst_29756 > (0));
var state_29784__$1 = state_29784;
if(cljs.core.truth_(inst_29757)){
var statearr_29793_29811 = state_29784__$1;
(statearr_29793_29811[(1)] = (4));

} else {
var statearr_29794_29812 = state_29784__$1;
(statearr_29794_29812[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29785 === (11))){
var inst_29754 = (state_29784[(10)]);
var inst_29773 = (state_29784[(2)]);
var tmp29792 = inst_29754;
var inst_29754__$1 = tmp29792;
var state_29784__$1 = (function (){var statearr_29795 = state_29784;
(statearr_29795[(11)] = inst_29773);

(statearr_29795[(10)] = inst_29754__$1);

return statearr_29795;
})();
var statearr_29796_29813 = state_29784__$1;
(statearr_29796_29813[(2)] = null);

(statearr_29796_29813[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29785 === (9))){
var inst_29764 = (state_29784[(8)]);
var state_29784__$1 = state_29784;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29784__$1,(11),out,inst_29764);
} else {
if((state_val_29785 === (5))){
var inst_29778 = cljs.core.async.close_BANG_.call(null,out);
var state_29784__$1 = state_29784;
var statearr_29797_29814 = state_29784__$1;
(statearr_29797_29814[(2)] = inst_29778);

(statearr_29797_29814[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29785 === (10))){
var inst_29776 = (state_29784[(2)]);
var state_29784__$1 = state_29784;
var statearr_29798_29815 = state_29784__$1;
(statearr_29798_29815[(2)] = inst_29776);

(statearr_29798_29815[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29785 === (8))){
var inst_29763 = (state_29784[(7)]);
var inst_29764 = (state_29784[(8)]);
var inst_29754 = (state_29784[(10)]);
var inst_29765 = (state_29784[(9)]);
var inst_29768 = (function (){var cs = inst_29754;
var vec__29759 = inst_29763;
var v = inst_29764;
var c = inst_29765;
return ((function (cs,vec__29759,v,c,inst_29763,inst_29764,inst_29754,inst_29765,state_val_29785,c__26531__auto___29806,out){
return (function (p1__29750_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__29750_SHARP_);
});
;})(cs,vec__29759,v,c,inst_29763,inst_29764,inst_29754,inst_29765,state_val_29785,c__26531__auto___29806,out))
})();
var inst_29769 = cljs.core.filterv.call(null,inst_29768,inst_29754);
var inst_29754__$1 = inst_29769;
var state_29784__$1 = (function (){var statearr_29799 = state_29784;
(statearr_29799[(10)] = inst_29754__$1);

return statearr_29799;
})();
var statearr_29800_29816 = state_29784__$1;
(statearr_29800_29816[(2)] = null);

(statearr_29800_29816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___29806,out))
;
return ((function (switch__26364__auto__,c__26531__auto___29806,out){
return (function() {
var cljs$core$async$state_machine__26365__auto__ = null;
var cljs$core$async$state_machine__26365__auto____0 = (function (){
var statearr_29801 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29801[(0)] = cljs$core$async$state_machine__26365__auto__);

(statearr_29801[(1)] = (1));

return statearr_29801;
});
var cljs$core$async$state_machine__26365__auto____1 = (function (state_29784){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_29784);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e29802){if((e29802 instanceof Object)){
var ex__26368__auto__ = e29802;
var statearr_29803_29817 = state_29784;
(statearr_29803_29817[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29784);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29802;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29818 = state_29784;
state_29784 = G__29818;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$state_machine__26365__auto__ = function(state_29784){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26365__auto____1.call(this,state_29784);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26365__auto____0;
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26365__auto____1;
return cljs$core$async$state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___29806,out))
})();
var state__26533__auto__ = (function (){var statearr_29804 = f__26532__auto__.call(null);
(statearr_29804[(6)] = c__26531__auto___29806);

return statearr_29804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___29806,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__29820 = arguments.length;
switch (G__29820) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26531__auto___29865 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___29865,out){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___29865,out){
return (function (state_29844){
var state_val_29845 = (state_29844[(1)]);
if((state_val_29845 === (7))){
var inst_29826 = (state_29844[(7)]);
var inst_29826__$1 = (state_29844[(2)]);
var inst_29827 = (inst_29826__$1 == null);
var inst_29828 = cljs.core.not.call(null,inst_29827);
var state_29844__$1 = (function (){var statearr_29846 = state_29844;
(statearr_29846[(7)] = inst_29826__$1);

return statearr_29846;
})();
if(inst_29828){
var statearr_29847_29866 = state_29844__$1;
(statearr_29847_29866[(1)] = (8));

} else {
var statearr_29848_29867 = state_29844__$1;
(statearr_29848_29867[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (1))){
var inst_29821 = (0);
var state_29844__$1 = (function (){var statearr_29849 = state_29844;
(statearr_29849[(8)] = inst_29821);

return statearr_29849;
})();
var statearr_29850_29868 = state_29844__$1;
(statearr_29850_29868[(2)] = null);

(statearr_29850_29868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (4))){
var state_29844__$1 = state_29844;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29844__$1,(7),ch);
} else {
if((state_val_29845 === (6))){
var inst_29839 = (state_29844[(2)]);
var state_29844__$1 = state_29844;
var statearr_29851_29869 = state_29844__$1;
(statearr_29851_29869[(2)] = inst_29839);

(statearr_29851_29869[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (3))){
var inst_29841 = (state_29844[(2)]);
var inst_29842 = cljs.core.async.close_BANG_.call(null,out);
var state_29844__$1 = (function (){var statearr_29852 = state_29844;
(statearr_29852[(9)] = inst_29841);

return statearr_29852;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29844__$1,inst_29842);
} else {
if((state_val_29845 === (2))){
var inst_29821 = (state_29844[(8)]);
var inst_29823 = (inst_29821 < n);
var state_29844__$1 = state_29844;
if(cljs.core.truth_(inst_29823)){
var statearr_29853_29870 = state_29844__$1;
(statearr_29853_29870[(1)] = (4));

} else {
var statearr_29854_29871 = state_29844__$1;
(statearr_29854_29871[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (11))){
var inst_29821 = (state_29844[(8)]);
var inst_29831 = (state_29844[(2)]);
var inst_29832 = (inst_29821 + (1));
var inst_29821__$1 = inst_29832;
var state_29844__$1 = (function (){var statearr_29855 = state_29844;
(statearr_29855[(8)] = inst_29821__$1);

(statearr_29855[(10)] = inst_29831);

return statearr_29855;
})();
var statearr_29856_29872 = state_29844__$1;
(statearr_29856_29872[(2)] = null);

(statearr_29856_29872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (9))){
var state_29844__$1 = state_29844;
var statearr_29857_29873 = state_29844__$1;
(statearr_29857_29873[(2)] = null);

(statearr_29857_29873[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (5))){
var state_29844__$1 = state_29844;
var statearr_29858_29874 = state_29844__$1;
(statearr_29858_29874[(2)] = null);

(statearr_29858_29874[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (10))){
var inst_29836 = (state_29844[(2)]);
var state_29844__$1 = state_29844;
var statearr_29859_29875 = state_29844__$1;
(statearr_29859_29875[(2)] = inst_29836);

(statearr_29859_29875[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29845 === (8))){
var inst_29826 = (state_29844[(7)]);
var state_29844__$1 = state_29844;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29844__$1,(11),out,inst_29826);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___29865,out))
;
return ((function (switch__26364__auto__,c__26531__auto___29865,out){
return (function() {
var cljs$core$async$state_machine__26365__auto__ = null;
var cljs$core$async$state_machine__26365__auto____0 = (function (){
var statearr_29860 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_29860[(0)] = cljs$core$async$state_machine__26365__auto__);

(statearr_29860[(1)] = (1));

return statearr_29860;
});
var cljs$core$async$state_machine__26365__auto____1 = (function (state_29844){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_29844);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e29861){if((e29861 instanceof Object)){
var ex__26368__auto__ = e29861;
var statearr_29862_29876 = state_29844;
(statearr_29862_29876[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29844);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29861;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29877 = state_29844;
state_29844 = G__29877;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$state_machine__26365__auto__ = function(state_29844){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26365__auto____1.call(this,state_29844);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26365__auto____0;
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26365__auto____1;
return cljs$core$async$state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___29865,out))
})();
var state__26533__auto__ = (function (){var statearr_29863 = f__26532__auto__.call(null);
(statearr_29863[(6)] = c__26531__auto___29865);

return statearr_29863;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___29865,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29879 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29879 = (function (f,ch,meta29880){
this.f = f;
this.ch = ch;
this.meta29880 = meta29880;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async29879.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29881,meta29880__$1){
var self__ = this;
var _29881__$1 = this;
return (new cljs.core.async.t_cljs$core$async29879(self__.f,self__.ch,meta29880__$1));
});

cljs.core.async.t_cljs$core$async29879.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29881){
var self__ = this;
var _29881__$1 = this;
return self__.meta29880;
});

cljs.core.async.t_cljs$core$async29879.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29879.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async29879.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async29879.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29879.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29882 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29882 = (function (f,ch,meta29880,_,fn1,meta29883){
this.f = f;
this.ch = ch;
this.meta29880 = meta29880;
this._ = _;
this.fn1 = fn1;
this.meta29883 = meta29883;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async29882.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_29884,meta29883__$1){
var self__ = this;
var _29884__$1 = this;
return (new cljs.core.async.t_cljs$core$async29882(self__.f,self__.ch,self__.meta29880,self__._,self__.fn1,meta29883__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async29882.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_29884){
var self__ = this;
var _29884__$1 = this;
return self__.meta29883;
});})(___$1))
;

cljs.core.async.t_cljs$core$async29882.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29882.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async29882.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async29882.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__29878_SHARP_){
return f1.call(null,(((p1__29878_SHARP_ == null))?null:self__.f.call(null,p1__29878_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async29882.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29880","meta29880",-1534521773,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async29879","cljs.core.async/t_cljs$core$async29879",1576179680,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta29883","meta29883",83497563,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async29882.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29882.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29882";

cljs.core.async.t_cljs$core$async29882.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async29882");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29882.
 */
cljs.core.async.__GT_t_cljs$core$async29882 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async29882(f__$1,ch__$1,meta29880__$1,___$2,fn1__$1,meta29883){
return (new cljs.core.async.t_cljs$core$async29882(f__$1,ch__$1,meta29880__$1,___$2,fn1__$1,meta29883));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async29882(self__.f,self__.ch,self__.meta29880,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async29879.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29879.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async29879.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29880","meta29880",-1534521773,null)], null);
});

cljs.core.async.t_cljs$core$async29879.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29879.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29879";

cljs.core.async.t_cljs$core$async29879.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async29879");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29879.
 */
cljs.core.async.__GT_t_cljs$core$async29879 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async29879(f__$1,ch__$1,meta29880){
return (new cljs.core.async.t_cljs$core$async29879(f__$1,ch__$1,meta29880));
});

}

return (new cljs.core.async.t_cljs$core$async29879(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29885 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29885 = (function (f,ch,meta29886){
this.f = f;
this.ch = ch;
this.meta29886 = meta29886;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async29885.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29887,meta29886__$1){
var self__ = this;
var _29887__$1 = this;
return (new cljs.core.async.t_cljs$core$async29885(self__.f,self__.ch,meta29886__$1));
});

cljs.core.async.t_cljs$core$async29885.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29887){
var self__ = this;
var _29887__$1 = this;
return self__.meta29886;
});

cljs.core.async.t_cljs$core$async29885.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29885.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async29885.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29885.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async29885.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29885.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async29885.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29886","meta29886",891185770,null)], null);
});

cljs.core.async.t_cljs$core$async29885.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29885.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29885";

cljs.core.async.t_cljs$core$async29885.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async29885");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29885.
 */
cljs.core.async.__GT_t_cljs$core$async29885 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async29885(f__$1,ch__$1,meta29886){
return (new cljs.core.async.t_cljs$core$async29885(f__$1,ch__$1,meta29886));
});

}

return (new cljs.core.async.t_cljs$core$async29885(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async29888 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async29888 = (function (p,ch,meta29889){
this.p = p;
this.ch = ch;
this.meta29889 = meta29889;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async29888.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_29890,meta29889__$1){
var self__ = this;
var _29890__$1 = this;
return (new cljs.core.async.t_cljs$core$async29888(self__.p,self__.ch,meta29889__$1));
});

cljs.core.async.t_cljs$core$async29888.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_29890){
var self__ = this;
var _29890__$1 = this;
return self__.meta29889;
});

cljs.core.async.t_cljs$core$async29888.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29888.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async29888.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async29888.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29888.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async29888.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async29888.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async29888.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta29889","meta29889",-694031117,null)], null);
});

cljs.core.async.t_cljs$core$async29888.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async29888.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async29888";

cljs.core.async.t_cljs$core$async29888.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async29888");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async29888.
 */
cljs.core.async.__GT_t_cljs$core$async29888 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async29888(p__$1,ch__$1,meta29889){
return (new cljs.core.async.t_cljs$core$async29888(p__$1,ch__$1,meta29889));
});

}

return (new cljs.core.async.t_cljs$core$async29888(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__29892 = arguments.length;
switch (G__29892) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26531__auto___29932 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___29932,out){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___29932,out){
return (function (state_29913){
var state_val_29914 = (state_29913[(1)]);
if((state_val_29914 === (7))){
var inst_29909 = (state_29913[(2)]);
var state_29913__$1 = state_29913;
var statearr_29915_29933 = state_29913__$1;
(statearr_29915_29933[(2)] = inst_29909);

(statearr_29915_29933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29914 === (1))){
var state_29913__$1 = state_29913;
var statearr_29916_29934 = state_29913__$1;
(statearr_29916_29934[(2)] = null);

(statearr_29916_29934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29914 === (4))){
var inst_29895 = (state_29913[(7)]);
var inst_29895__$1 = (state_29913[(2)]);
var inst_29896 = (inst_29895__$1 == null);
var state_29913__$1 = (function (){var statearr_29917 = state_29913;
(statearr_29917[(7)] = inst_29895__$1);

return statearr_29917;
})();
if(cljs.core.truth_(inst_29896)){
var statearr_29918_29935 = state_29913__$1;
(statearr_29918_29935[(1)] = (5));

} else {
var statearr_29919_29936 = state_29913__$1;
(statearr_29919_29936[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29914 === (6))){
var inst_29895 = (state_29913[(7)]);
var inst_29900 = p.call(null,inst_29895);
var state_29913__$1 = state_29913;
if(cljs.core.truth_(inst_29900)){
var statearr_29920_29937 = state_29913__$1;
(statearr_29920_29937[(1)] = (8));

} else {
var statearr_29921_29938 = state_29913__$1;
(statearr_29921_29938[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29914 === (3))){
var inst_29911 = (state_29913[(2)]);
var state_29913__$1 = state_29913;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_29913__$1,inst_29911);
} else {
if((state_val_29914 === (2))){
var state_29913__$1 = state_29913;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_29913__$1,(4),ch);
} else {
if((state_val_29914 === (11))){
var inst_29903 = (state_29913[(2)]);
var state_29913__$1 = state_29913;
var statearr_29922_29939 = state_29913__$1;
(statearr_29922_29939[(2)] = inst_29903);

(statearr_29922_29939[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29914 === (9))){
var state_29913__$1 = state_29913;
var statearr_29923_29940 = state_29913__$1;
(statearr_29923_29940[(2)] = null);

(statearr_29923_29940[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29914 === (5))){
var inst_29898 = cljs.core.async.close_BANG_.call(null,out);
var state_29913__$1 = state_29913;
var statearr_29924_29941 = state_29913__$1;
(statearr_29924_29941[(2)] = inst_29898);

(statearr_29924_29941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29914 === (10))){
var inst_29906 = (state_29913[(2)]);
var state_29913__$1 = (function (){var statearr_29925 = state_29913;
(statearr_29925[(8)] = inst_29906);

return statearr_29925;
})();
var statearr_29926_29942 = state_29913__$1;
(statearr_29926_29942[(2)] = null);

(statearr_29926_29942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_29914 === (8))){
var inst_29895 = (state_29913[(7)]);
var state_29913__$1 = state_29913;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_29913__$1,(11),out,inst_29895);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___29932,out))
;
return ((function (switch__26364__auto__,c__26531__auto___29932,out){
return (function() {
var cljs$core$async$state_machine__26365__auto__ = null;
var cljs$core$async$state_machine__26365__auto____0 = (function (){
var statearr_29927 = [null,null,null,null,null,null,null,null,null];
(statearr_29927[(0)] = cljs$core$async$state_machine__26365__auto__);

(statearr_29927[(1)] = (1));

return statearr_29927;
});
var cljs$core$async$state_machine__26365__auto____1 = (function (state_29913){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_29913);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e29928){if((e29928 instanceof Object)){
var ex__26368__auto__ = e29928;
var statearr_29929_29943 = state_29913;
(statearr_29929_29943[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_29913);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e29928;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__29944 = state_29913;
state_29913 = G__29944;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$state_machine__26365__auto__ = function(state_29913){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26365__auto____1.call(this,state_29913);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26365__auto____0;
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26365__auto____1;
return cljs$core$async$state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___29932,out))
})();
var state__26533__auto__ = (function (){var statearr_29930 = f__26532__auto__.call(null);
(statearr_29930[(6)] = c__26531__auto___29932);

return statearr_29930;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___29932,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__29946 = arguments.length;
switch (G__29946) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__26531__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto__){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto__){
return (function (state_30009){
var state_val_30010 = (state_30009[(1)]);
if((state_val_30010 === (7))){
var inst_30005 = (state_30009[(2)]);
var state_30009__$1 = state_30009;
var statearr_30011_30049 = state_30009__$1;
(statearr_30011_30049[(2)] = inst_30005);

(statearr_30011_30049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (20))){
var inst_29975 = (state_30009[(7)]);
var inst_29986 = (state_30009[(2)]);
var inst_29987 = cljs.core.next.call(null,inst_29975);
var inst_29961 = inst_29987;
var inst_29962 = null;
var inst_29963 = (0);
var inst_29964 = (0);
var state_30009__$1 = (function (){var statearr_30012 = state_30009;
(statearr_30012[(8)] = inst_29986);

(statearr_30012[(9)] = inst_29964);

(statearr_30012[(10)] = inst_29962);

(statearr_30012[(11)] = inst_29963);

(statearr_30012[(12)] = inst_29961);

return statearr_30012;
})();
var statearr_30013_30050 = state_30009__$1;
(statearr_30013_30050[(2)] = null);

(statearr_30013_30050[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (1))){
var state_30009__$1 = state_30009;
var statearr_30014_30051 = state_30009__$1;
(statearr_30014_30051[(2)] = null);

(statearr_30014_30051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (4))){
var inst_29950 = (state_30009[(13)]);
var inst_29950__$1 = (state_30009[(2)]);
var inst_29951 = (inst_29950__$1 == null);
var state_30009__$1 = (function (){var statearr_30015 = state_30009;
(statearr_30015[(13)] = inst_29950__$1);

return statearr_30015;
})();
if(cljs.core.truth_(inst_29951)){
var statearr_30016_30052 = state_30009__$1;
(statearr_30016_30052[(1)] = (5));

} else {
var statearr_30017_30053 = state_30009__$1;
(statearr_30017_30053[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (15))){
var state_30009__$1 = state_30009;
var statearr_30021_30054 = state_30009__$1;
(statearr_30021_30054[(2)] = null);

(statearr_30021_30054[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (21))){
var state_30009__$1 = state_30009;
var statearr_30022_30055 = state_30009__$1;
(statearr_30022_30055[(2)] = null);

(statearr_30022_30055[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (13))){
var inst_29964 = (state_30009[(9)]);
var inst_29962 = (state_30009[(10)]);
var inst_29963 = (state_30009[(11)]);
var inst_29961 = (state_30009[(12)]);
var inst_29971 = (state_30009[(2)]);
var inst_29972 = (inst_29964 + (1));
var tmp30018 = inst_29962;
var tmp30019 = inst_29963;
var tmp30020 = inst_29961;
var inst_29961__$1 = tmp30020;
var inst_29962__$1 = tmp30018;
var inst_29963__$1 = tmp30019;
var inst_29964__$1 = inst_29972;
var state_30009__$1 = (function (){var statearr_30023 = state_30009;
(statearr_30023[(14)] = inst_29971);

(statearr_30023[(9)] = inst_29964__$1);

(statearr_30023[(10)] = inst_29962__$1);

(statearr_30023[(11)] = inst_29963__$1);

(statearr_30023[(12)] = inst_29961__$1);

return statearr_30023;
})();
var statearr_30024_30056 = state_30009__$1;
(statearr_30024_30056[(2)] = null);

(statearr_30024_30056[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (22))){
var state_30009__$1 = state_30009;
var statearr_30025_30057 = state_30009__$1;
(statearr_30025_30057[(2)] = null);

(statearr_30025_30057[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (6))){
var inst_29950 = (state_30009[(13)]);
var inst_29959 = f.call(null,inst_29950);
var inst_29960 = cljs.core.seq.call(null,inst_29959);
var inst_29961 = inst_29960;
var inst_29962 = null;
var inst_29963 = (0);
var inst_29964 = (0);
var state_30009__$1 = (function (){var statearr_30026 = state_30009;
(statearr_30026[(9)] = inst_29964);

(statearr_30026[(10)] = inst_29962);

(statearr_30026[(11)] = inst_29963);

(statearr_30026[(12)] = inst_29961);

return statearr_30026;
})();
var statearr_30027_30058 = state_30009__$1;
(statearr_30027_30058[(2)] = null);

(statearr_30027_30058[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (17))){
var inst_29975 = (state_30009[(7)]);
var inst_29979 = cljs.core.chunk_first.call(null,inst_29975);
var inst_29980 = cljs.core.chunk_rest.call(null,inst_29975);
var inst_29981 = cljs.core.count.call(null,inst_29979);
var inst_29961 = inst_29980;
var inst_29962 = inst_29979;
var inst_29963 = inst_29981;
var inst_29964 = (0);
var state_30009__$1 = (function (){var statearr_30028 = state_30009;
(statearr_30028[(9)] = inst_29964);

(statearr_30028[(10)] = inst_29962);

(statearr_30028[(11)] = inst_29963);

(statearr_30028[(12)] = inst_29961);

return statearr_30028;
})();
var statearr_30029_30059 = state_30009__$1;
(statearr_30029_30059[(2)] = null);

(statearr_30029_30059[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (3))){
var inst_30007 = (state_30009[(2)]);
var state_30009__$1 = state_30009;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30009__$1,inst_30007);
} else {
if((state_val_30010 === (12))){
var inst_29995 = (state_30009[(2)]);
var state_30009__$1 = state_30009;
var statearr_30030_30060 = state_30009__$1;
(statearr_30030_30060[(2)] = inst_29995);

(statearr_30030_30060[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (2))){
var state_30009__$1 = state_30009;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30009__$1,(4),in$);
} else {
if((state_val_30010 === (23))){
var inst_30003 = (state_30009[(2)]);
var state_30009__$1 = state_30009;
var statearr_30031_30061 = state_30009__$1;
(statearr_30031_30061[(2)] = inst_30003);

(statearr_30031_30061[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (19))){
var inst_29990 = (state_30009[(2)]);
var state_30009__$1 = state_30009;
var statearr_30032_30062 = state_30009__$1;
(statearr_30032_30062[(2)] = inst_29990);

(statearr_30032_30062[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (11))){
var inst_29975 = (state_30009[(7)]);
var inst_29961 = (state_30009[(12)]);
var inst_29975__$1 = cljs.core.seq.call(null,inst_29961);
var state_30009__$1 = (function (){var statearr_30033 = state_30009;
(statearr_30033[(7)] = inst_29975__$1);

return statearr_30033;
})();
if(inst_29975__$1){
var statearr_30034_30063 = state_30009__$1;
(statearr_30034_30063[(1)] = (14));

} else {
var statearr_30035_30064 = state_30009__$1;
(statearr_30035_30064[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (9))){
var inst_29997 = (state_30009[(2)]);
var inst_29998 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_30009__$1 = (function (){var statearr_30036 = state_30009;
(statearr_30036[(15)] = inst_29997);

return statearr_30036;
})();
if(cljs.core.truth_(inst_29998)){
var statearr_30037_30065 = state_30009__$1;
(statearr_30037_30065[(1)] = (21));

} else {
var statearr_30038_30066 = state_30009__$1;
(statearr_30038_30066[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (5))){
var inst_29953 = cljs.core.async.close_BANG_.call(null,out);
var state_30009__$1 = state_30009;
var statearr_30039_30067 = state_30009__$1;
(statearr_30039_30067[(2)] = inst_29953);

(statearr_30039_30067[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (14))){
var inst_29975 = (state_30009[(7)]);
var inst_29977 = cljs.core.chunked_seq_QMARK_.call(null,inst_29975);
var state_30009__$1 = state_30009;
if(inst_29977){
var statearr_30040_30068 = state_30009__$1;
(statearr_30040_30068[(1)] = (17));

} else {
var statearr_30041_30069 = state_30009__$1;
(statearr_30041_30069[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (16))){
var inst_29993 = (state_30009[(2)]);
var state_30009__$1 = state_30009;
var statearr_30042_30070 = state_30009__$1;
(statearr_30042_30070[(2)] = inst_29993);

(statearr_30042_30070[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30010 === (10))){
var inst_29964 = (state_30009[(9)]);
var inst_29962 = (state_30009[(10)]);
var inst_29969 = cljs.core._nth.call(null,inst_29962,inst_29964);
var state_30009__$1 = state_30009;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30009__$1,(13),out,inst_29969);
} else {
if((state_val_30010 === (18))){
var inst_29975 = (state_30009[(7)]);
var inst_29984 = cljs.core.first.call(null,inst_29975);
var state_30009__$1 = state_30009;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30009__$1,(20),out,inst_29984);
} else {
if((state_val_30010 === (8))){
var inst_29964 = (state_30009[(9)]);
var inst_29963 = (state_30009[(11)]);
var inst_29966 = (inst_29964 < inst_29963);
var inst_29967 = inst_29966;
var state_30009__$1 = state_30009;
if(cljs.core.truth_(inst_29967)){
var statearr_30043_30071 = state_30009__$1;
(statearr_30043_30071[(1)] = (10));

} else {
var statearr_30044_30072 = state_30009__$1;
(statearr_30044_30072[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto__))
;
return ((function (switch__26364__auto__,c__26531__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__26365__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__26365__auto____0 = (function (){
var statearr_30045 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30045[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__26365__auto__);

(statearr_30045[(1)] = (1));

return statearr_30045;
});
var cljs$core$async$mapcat_STAR__$_state_machine__26365__auto____1 = (function (state_30009){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_30009);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e30046){if((e30046 instanceof Object)){
var ex__26368__auto__ = e30046;
var statearr_30047_30073 = state_30009;
(statearr_30047_30073[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30009);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30046;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30074 = state_30009;
state_30009 = G__30074;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__26365__auto__ = function(state_30009){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__26365__auto____1.call(this,state_30009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__26365__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__26365__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto__))
})();
var state__26533__auto__ = (function (){var statearr_30048 = f__26532__auto__.call(null);
(statearr_30048[(6)] = c__26531__auto__);

return statearr_30048;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto__))
);

return c__26531__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__30076 = arguments.length;
switch (G__30076) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__30079 = arguments.length;
switch (G__30079) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__30082 = arguments.length;
switch (G__30082) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26531__auto___30129 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___30129,out){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___30129,out){
return (function (state_30106){
var state_val_30107 = (state_30106[(1)]);
if((state_val_30107 === (7))){
var inst_30101 = (state_30106[(2)]);
var state_30106__$1 = state_30106;
var statearr_30108_30130 = state_30106__$1;
(statearr_30108_30130[(2)] = inst_30101);

(statearr_30108_30130[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30107 === (1))){
var inst_30083 = null;
var state_30106__$1 = (function (){var statearr_30109 = state_30106;
(statearr_30109[(7)] = inst_30083);

return statearr_30109;
})();
var statearr_30110_30131 = state_30106__$1;
(statearr_30110_30131[(2)] = null);

(statearr_30110_30131[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30107 === (4))){
var inst_30086 = (state_30106[(8)]);
var inst_30086__$1 = (state_30106[(2)]);
var inst_30087 = (inst_30086__$1 == null);
var inst_30088 = cljs.core.not.call(null,inst_30087);
var state_30106__$1 = (function (){var statearr_30111 = state_30106;
(statearr_30111[(8)] = inst_30086__$1);

return statearr_30111;
})();
if(inst_30088){
var statearr_30112_30132 = state_30106__$1;
(statearr_30112_30132[(1)] = (5));

} else {
var statearr_30113_30133 = state_30106__$1;
(statearr_30113_30133[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30107 === (6))){
var state_30106__$1 = state_30106;
var statearr_30114_30134 = state_30106__$1;
(statearr_30114_30134[(2)] = null);

(statearr_30114_30134[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30107 === (3))){
var inst_30103 = (state_30106[(2)]);
var inst_30104 = cljs.core.async.close_BANG_.call(null,out);
var state_30106__$1 = (function (){var statearr_30115 = state_30106;
(statearr_30115[(9)] = inst_30103);

return statearr_30115;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30106__$1,inst_30104);
} else {
if((state_val_30107 === (2))){
var state_30106__$1 = state_30106;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30106__$1,(4),ch);
} else {
if((state_val_30107 === (11))){
var inst_30086 = (state_30106[(8)]);
var inst_30095 = (state_30106[(2)]);
var inst_30083 = inst_30086;
var state_30106__$1 = (function (){var statearr_30116 = state_30106;
(statearr_30116[(10)] = inst_30095);

(statearr_30116[(7)] = inst_30083);

return statearr_30116;
})();
var statearr_30117_30135 = state_30106__$1;
(statearr_30117_30135[(2)] = null);

(statearr_30117_30135[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30107 === (9))){
var inst_30086 = (state_30106[(8)]);
var state_30106__$1 = state_30106;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30106__$1,(11),out,inst_30086);
} else {
if((state_val_30107 === (5))){
var inst_30086 = (state_30106[(8)]);
var inst_30083 = (state_30106[(7)]);
var inst_30090 = cljs.core._EQ_.call(null,inst_30086,inst_30083);
var state_30106__$1 = state_30106;
if(inst_30090){
var statearr_30119_30136 = state_30106__$1;
(statearr_30119_30136[(1)] = (8));

} else {
var statearr_30120_30137 = state_30106__$1;
(statearr_30120_30137[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30107 === (10))){
var inst_30098 = (state_30106[(2)]);
var state_30106__$1 = state_30106;
var statearr_30121_30138 = state_30106__$1;
(statearr_30121_30138[(2)] = inst_30098);

(statearr_30121_30138[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30107 === (8))){
var inst_30083 = (state_30106[(7)]);
var tmp30118 = inst_30083;
var inst_30083__$1 = tmp30118;
var state_30106__$1 = (function (){var statearr_30122 = state_30106;
(statearr_30122[(7)] = inst_30083__$1);

return statearr_30122;
})();
var statearr_30123_30139 = state_30106__$1;
(statearr_30123_30139[(2)] = null);

(statearr_30123_30139[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___30129,out))
;
return ((function (switch__26364__auto__,c__26531__auto___30129,out){
return (function() {
var cljs$core$async$state_machine__26365__auto__ = null;
var cljs$core$async$state_machine__26365__auto____0 = (function (){
var statearr_30124 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30124[(0)] = cljs$core$async$state_machine__26365__auto__);

(statearr_30124[(1)] = (1));

return statearr_30124;
});
var cljs$core$async$state_machine__26365__auto____1 = (function (state_30106){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_30106);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e30125){if((e30125 instanceof Object)){
var ex__26368__auto__ = e30125;
var statearr_30126_30140 = state_30106;
(statearr_30126_30140[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30106);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30125;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30141 = state_30106;
state_30106 = G__30141;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$state_machine__26365__auto__ = function(state_30106){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26365__auto____1.call(this,state_30106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26365__auto____0;
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26365__auto____1;
return cljs$core$async$state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___30129,out))
})();
var state__26533__auto__ = (function (){var statearr_30127 = f__26532__auto__.call(null);
(statearr_30127[(6)] = c__26531__auto___30129);

return statearr_30127;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___30129,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__30143 = arguments.length;
switch (G__30143) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26531__auto___30209 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___30209,out){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___30209,out){
return (function (state_30181){
var state_val_30182 = (state_30181[(1)]);
if((state_val_30182 === (7))){
var inst_30177 = (state_30181[(2)]);
var state_30181__$1 = state_30181;
var statearr_30183_30210 = state_30181__$1;
(statearr_30183_30210[(2)] = inst_30177);

(statearr_30183_30210[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30182 === (1))){
var inst_30144 = (new Array(n));
var inst_30145 = inst_30144;
var inst_30146 = (0);
var state_30181__$1 = (function (){var statearr_30184 = state_30181;
(statearr_30184[(7)] = inst_30146);

(statearr_30184[(8)] = inst_30145);

return statearr_30184;
})();
var statearr_30185_30211 = state_30181__$1;
(statearr_30185_30211[(2)] = null);

(statearr_30185_30211[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30182 === (4))){
var inst_30149 = (state_30181[(9)]);
var inst_30149__$1 = (state_30181[(2)]);
var inst_30150 = (inst_30149__$1 == null);
var inst_30151 = cljs.core.not.call(null,inst_30150);
var state_30181__$1 = (function (){var statearr_30186 = state_30181;
(statearr_30186[(9)] = inst_30149__$1);

return statearr_30186;
})();
if(inst_30151){
var statearr_30187_30212 = state_30181__$1;
(statearr_30187_30212[(1)] = (5));

} else {
var statearr_30188_30213 = state_30181__$1;
(statearr_30188_30213[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30182 === (15))){
var inst_30171 = (state_30181[(2)]);
var state_30181__$1 = state_30181;
var statearr_30189_30214 = state_30181__$1;
(statearr_30189_30214[(2)] = inst_30171);

(statearr_30189_30214[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30182 === (13))){
var state_30181__$1 = state_30181;
var statearr_30190_30215 = state_30181__$1;
(statearr_30190_30215[(2)] = null);

(statearr_30190_30215[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30182 === (6))){
var inst_30146 = (state_30181[(7)]);
var inst_30167 = (inst_30146 > (0));
var state_30181__$1 = state_30181;
if(cljs.core.truth_(inst_30167)){
var statearr_30191_30216 = state_30181__$1;
(statearr_30191_30216[(1)] = (12));

} else {
var statearr_30192_30217 = state_30181__$1;
(statearr_30192_30217[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30182 === (3))){
var inst_30179 = (state_30181[(2)]);
var state_30181__$1 = state_30181;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30181__$1,inst_30179);
} else {
if((state_val_30182 === (12))){
var inst_30145 = (state_30181[(8)]);
var inst_30169 = cljs.core.vec.call(null,inst_30145);
var state_30181__$1 = state_30181;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30181__$1,(15),out,inst_30169);
} else {
if((state_val_30182 === (2))){
var state_30181__$1 = state_30181;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30181__$1,(4),ch);
} else {
if((state_val_30182 === (11))){
var inst_30161 = (state_30181[(2)]);
var inst_30162 = (new Array(n));
var inst_30145 = inst_30162;
var inst_30146 = (0);
var state_30181__$1 = (function (){var statearr_30193 = state_30181;
(statearr_30193[(7)] = inst_30146);

(statearr_30193[(8)] = inst_30145);

(statearr_30193[(10)] = inst_30161);

return statearr_30193;
})();
var statearr_30194_30218 = state_30181__$1;
(statearr_30194_30218[(2)] = null);

(statearr_30194_30218[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30182 === (9))){
var inst_30145 = (state_30181[(8)]);
var inst_30159 = cljs.core.vec.call(null,inst_30145);
var state_30181__$1 = state_30181;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30181__$1,(11),out,inst_30159);
} else {
if((state_val_30182 === (5))){
var inst_30146 = (state_30181[(7)]);
var inst_30149 = (state_30181[(9)]);
var inst_30154 = (state_30181[(11)]);
var inst_30145 = (state_30181[(8)]);
var inst_30153 = (inst_30145[inst_30146] = inst_30149);
var inst_30154__$1 = (inst_30146 + (1));
var inst_30155 = (inst_30154__$1 < n);
var state_30181__$1 = (function (){var statearr_30195 = state_30181;
(statearr_30195[(11)] = inst_30154__$1);

(statearr_30195[(12)] = inst_30153);

return statearr_30195;
})();
if(cljs.core.truth_(inst_30155)){
var statearr_30196_30219 = state_30181__$1;
(statearr_30196_30219[(1)] = (8));

} else {
var statearr_30197_30220 = state_30181__$1;
(statearr_30197_30220[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30182 === (14))){
var inst_30174 = (state_30181[(2)]);
var inst_30175 = cljs.core.async.close_BANG_.call(null,out);
var state_30181__$1 = (function (){var statearr_30199 = state_30181;
(statearr_30199[(13)] = inst_30174);

return statearr_30199;
})();
var statearr_30200_30221 = state_30181__$1;
(statearr_30200_30221[(2)] = inst_30175);

(statearr_30200_30221[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30182 === (10))){
var inst_30165 = (state_30181[(2)]);
var state_30181__$1 = state_30181;
var statearr_30201_30222 = state_30181__$1;
(statearr_30201_30222[(2)] = inst_30165);

(statearr_30201_30222[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30182 === (8))){
var inst_30154 = (state_30181[(11)]);
var inst_30145 = (state_30181[(8)]);
var tmp30198 = inst_30145;
var inst_30145__$1 = tmp30198;
var inst_30146 = inst_30154;
var state_30181__$1 = (function (){var statearr_30202 = state_30181;
(statearr_30202[(7)] = inst_30146);

(statearr_30202[(8)] = inst_30145__$1);

return statearr_30202;
})();
var statearr_30203_30223 = state_30181__$1;
(statearr_30203_30223[(2)] = null);

(statearr_30203_30223[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___30209,out))
;
return ((function (switch__26364__auto__,c__26531__auto___30209,out){
return (function() {
var cljs$core$async$state_machine__26365__auto__ = null;
var cljs$core$async$state_machine__26365__auto____0 = (function (){
var statearr_30204 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30204[(0)] = cljs$core$async$state_machine__26365__auto__);

(statearr_30204[(1)] = (1));

return statearr_30204;
});
var cljs$core$async$state_machine__26365__auto____1 = (function (state_30181){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_30181);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e30205){if((e30205 instanceof Object)){
var ex__26368__auto__ = e30205;
var statearr_30206_30224 = state_30181;
(statearr_30206_30224[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30181);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30205;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30225 = state_30181;
state_30181 = G__30225;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$state_machine__26365__auto__ = function(state_30181){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26365__auto____1.call(this,state_30181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26365__auto____0;
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26365__auto____1;
return cljs$core$async$state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___30209,out))
})();
var state__26533__auto__ = (function (){var statearr_30207 = f__26532__auto__.call(null);
(statearr_30207[(6)] = c__26531__auto___30209);

return statearr_30207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___30209,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__30227 = arguments.length;
switch (G__30227) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__26531__auto___30297 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__26531__auto___30297,out){
return (function (){
var f__26532__auto__ = (function (){var switch__26364__auto__ = ((function (c__26531__auto___30297,out){
return (function (state_30269){
var state_val_30270 = (state_30269[(1)]);
if((state_val_30270 === (7))){
var inst_30265 = (state_30269[(2)]);
var state_30269__$1 = state_30269;
var statearr_30271_30298 = state_30269__$1;
(statearr_30271_30298[(2)] = inst_30265);

(statearr_30271_30298[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30270 === (1))){
var inst_30228 = [];
var inst_30229 = inst_30228;
var inst_30230 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_30269__$1 = (function (){var statearr_30272 = state_30269;
(statearr_30272[(7)] = inst_30230);

(statearr_30272[(8)] = inst_30229);

return statearr_30272;
})();
var statearr_30273_30299 = state_30269__$1;
(statearr_30273_30299[(2)] = null);

(statearr_30273_30299[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30270 === (4))){
var inst_30233 = (state_30269[(9)]);
var inst_30233__$1 = (state_30269[(2)]);
var inst_30234 = (inst_30233__$1 == null);
var inst_30235 = cljs.core.not.call(null,inst_30234);
var state_30269__$1 = (function (){var statearr_30274 = state_30269;
(statearr_30274[(9)] = inst_30233__$1);

return statearr_30274;
})();
if(inst_30235){
var statearr_30275_30300 = state_30269__$1;
(statearr_30275_30300[(1)] = (5));

} else {
var statearr_30276_30301 = state_30269__$1;
(statearr_30276_30301[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30270 === (15))){
var inst_30259 = (state_30269[(2)]);
var state_30269__$1 = state_30269;
var statearr_30277_30302 = state_30269__$1;
(statearr_30277_30302[(2)] = inst_30259);

(statearr_30277_30302[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30270 === (13))){
var state_30269__$1 = state_30269;
var statearr_30278_30303 = state_30269__$1;
(statearr_30278_30303[(2)] = null);

(statearr_30278_30303[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30270 === (6))){
var inst_30229 = (state_30269[(8)]);
var inst_30254 = inst_30229.length;
var inst_30255 = (inst_30254 > (0));
var state_30269__$1 = state_30269;
if(cljs.core.truth_(inst_30255)){
var statearr_30279_30304 = state_30269__$1;
(statearr_30279_30304[(1)] = (12));

} else {
var statearr_30280_30305 = state_30269__$1;
(statearr_30280_30305[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30270 === (3))){
var inst_30267 = (state_30269[(2)]);
var state_30269__$1 = state_30269;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30269__$1,inst_30267);
} else {
if((state_val_30270 === (12))){
var inst_30229 = (state_30269[(8)]);
var inst_30257 = cljs.core.vec.call(null,inst_30229);
var state_30269__$1 = state_30269;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30269__$1,(15),out,inst_30257);
} else {
if((state_val_30270 === (2))){
var state_30269__$1 = state_30269;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30269__$1,(4),ch);
} else {
if((state_val_30270 === (11))){
var inst_30237 = (state_30269[(10)]);
var inst_30233 = (state_30269[(9)]);
var inst_30247 = (state_30269[(2)]);
var inst_30248 = [];
var inst_30249 = inst_30248.push(inst_30233);
var inst_30229 = inst_30248;
var inst_30230 = inst_30237;
var state_30269__$1 = (function (){var statearr_30281 = state_30269;
(statearr_30281[(7)] = inst_30230);

(statearr_30281[(11)] = inst_30249);

(statearr_30281[(12)] = inst_30247);

(statearr_30281[(8)] = inst_30229);

return statearr_30281;
})();
var statearr_30282_30306 = state_30269__$1;
(statearr_30282_30306[(2)] = null);

(statearr_30282_30306[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30270 === (9))){
var inst_30229 = (state_30269[(8)]);
var inst_30245 = cljs.core.vec.call(null,inst_30229);
var state_30269__$1 = state_30269;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_30269__$1,(11),out,inst_30245);
} else {
if((state_val_30270 === (5))){
var inst_30230 = (state_30269[(7)]);
var inst_30237 = (state_30269[(10)]);
var inst_30233 = (state_30269[(9)]);
var inst_30237__$1 = f.call(null,inst_30233);
var inst_30238 = cljs.core._EQ_.call(null,inst_30237__$1,inst_30230);
var inst_30239 = cljs.core.keyword_identical_QMARK_.call(null,inst_30230,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_30240 = ((inst_30238) || (inst_30239));
var state_30269__$1 = (function (){var statearr_30283 = state_30269;
(statearr_30283[(10)] = inst_30237__$1);

return statearr_30283;
})();
if(cljs.core.truth_(inst_30240)){
var statearr_30284_30307 = state_30269__$1;
(statearr_30284_30307[(1)] = (8));

} else {
var statearr_30285_30308 = state_30269__$1;
(statearr_30285_30308[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30270 === (14))){
var inst_30262 = (state_30269[(2)]);
var inst_30263 = cljs.core.async.close_BANG_.call(null,out);
var state_30269__$1 = (function (){var statearr_30287 = state_30269;
(statearr_30287[(13)] = inst_30262);

return statearr_30287;
})();
var statearr_30288_30309 = state_30269__$1;
(statearr_30288_30309[(2)] = inst_30263);

(statearr_30288_30309[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30270 === (10))){
var inst_30252 = (state_30269[(2)]);
var state_30269__$1 = state_30269;
var statearr_30289_30310 = state_30269__$1;
(statearr_30289_30310[(2)] = inst_30252);

(statearr_30289_30310[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30270 === (8))){
var inst_30229 = (state_30269[(8)]);
var inst_30237 = (state_30269[(10)]);
var inst_30233 = (state_30269[(9)]);
var inst_30242 = inst_30229.push(inst_30233);
var tmp30286 = inst_30229;
var inst_30229__$1 = tmp30286;
var inst_30230 = inst_30237;
var state_30269__$1 = (function (){var statearr_30290 = state_30269;
(statearr_30290[(7)] = inst_30230);

(statearr_30290[(14)] = inst_30242);

(statearr_30290[(8)] = inst_30229__$1);

return statearr_30290;
})();
var statearr_30291_30311 = state_30269__$1;
(statearr_30291_30311[(2)] = null);

(statearr_30291_30311[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__26531__auto___30297,out))
;
return ((function (switch__26364__auto__,c__26531__auto___30297,out){
return (function() {
var cljs$core$async$state_machine__26365__auto__ = null;
var cljs$core$async$state_machine__26365__auto____0 = (function (){
var statearr_30292 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30292[(0)] = cljs$core$async$state_machine__26365__auto__);

(statearr_30292[(1)] = (1));

return statearr_30292;
});
var cljs$core$async$state_machine__26365__auto____1 = (function (state_30269){
while(true){
var ret_value__26366__auto__ = (function (){try{while(true){
var result__26367__auto__ = switch__26364__auto__.call(null,state_30269);
if(cljs.core.keyword_identical_QMARK_.call(null,result__26367__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__26367__auto__;
}
break;
}
}catch (e30293){if((e30293 instanceof Object)){
var ex__26368__auto__ = e30293;
var statearr_30294_30312 = state_30269;
(statearr_30294_30312[(5)] = ex__26368__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30269);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30293;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__26366__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30313 = state_30269;
state_30269 = G__30313;
continue;
} else {
return ret_value__26366__auto__;
}
break;
}
});
cljs$core$async$state_machine__26365__auto__ = function(state_30269){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__26365__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__26365__auto____1.call(this,state_30269);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__26365__auto____0;
cljs$core$async$state_machine__26365__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__26365__auto____1;
return cljs$core$async$state_machine__26365__auto__;
})()
;})(switch__26364__auto__,c__26531__auto___30297,out))
})();
var state__26533__auto__ = (function (){var statearr_30295 = f__26532__auto__.call(null);
(statearr_30295[(6)] = c__26531__auto___30297);

return statearr_30295;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__26533__auto__);
});})(c__26531__auto___30297,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map
