// Compiled by ClojureScript 1.10.520 {}
goog.provide('imcljs.internal.utils');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
imcljs.internal.utils.does_not_contain_QMARK_ = cljs.core.complement.call(null,cljs.core.contains_QMARK_);
imcljs.internal.utils.one_of_QMARK_ = (function imcljs$internal$utils$one_of_QMARK_(haystack,needle){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack) == null)));
});
imcljs.internal.utils.missing_http_QMARK__ = (function imcljs$internal$utils$missing_http_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/^https?:\/\//,val));
});
imcljs.internal.utils.missing_service_QMARK__ = (function imcljs$internal$utils$missing_service_QMARK__(val){
return cljs.core.not.call(null,cljs.core.re_find.call(null,/\/service$/,val));
});
imcljs.internal.utils.append_ = (function imcljs$internal$utils$append_(text,val){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(val),cljs.core.str.cljs$core$IFn$_invoke$arity$1(text)].join('');
});
imcljs.internal.utils.alphabet = cljs.core.apply.call(null,cljs.core.sorted_set,clojure.string.split.call(null,"ABCDEFGHIJKLMNOPQRSTUVWXYZ",(new RegExp(""))));
/**
 * Ensures that a url starts with an http protocol and ends with /service
 */
imcljs.internal.utils.scrub_url = (function imcljs$internal$utils$scrub_url(url){
var G__2402 = url;
var G__2402__$1 = ((imcljs.internal.utils.missing_http_QMARK__.call(null,url))?["http://",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__2402)].join(''):G__2402);
if(imcljs.internal.utils.missing_service_QMARK__.call(null,url)){
return imcljs.internal.utils.append_.call(null,"/service",G__2402__$1);
} else {
return G__2402__$1;
}
});
imcljs.internal.utils.copy_list_query = (function imcljs$internal$utils$copy_list_query(p__2403){
var map__2404 = p__2403;
var map__2404__$1 = (((((!((map__2404 == null))))?(((((map__2404.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2404.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2404):map__2404);
var old_list_details = map__2404__$1;
var old_list_name = cljs.core.get.call(null,map__2404__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var old_list_type = cljs.core.get.call(null,map__2404__$1,new cljs.core.Keyword(null,"type","type",1174270348));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"from","from",1815293044),old_list_type,new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(old_list_type),".id"].join('')], null),new cljs.core.Keyword(null,"where","where",-2044795965),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),old_list_type,new cljs.core.Keyword(null,"op","op",-1882987955),"IN",new cljs.core.Keyword(null,"value","value",305978217),old_list_name], null)], null)], null);
});
/**
 * Given a collection of channels, returns a collection containing
 *   the first result of each channel (similiar to JS Promise.all)
 */
imcljs.internal.utils._LT__LT__BANG_ = (function imcljs$internal$utils$_LT__LT__BANG_(chans){
var c__2324__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2324__auto__){
return (function (){
var f__2325__auto__ = (function (){var switch__2301__auto__ = ((function (c__2324__auto__){
return (function (state_2424){
var state_val_2425 = (state_2424[(1)]);
if((state_val_2425 === (1))){
var inst_2406 = cljs.core.List.EMPTY;
var inst_2407 = inst_2406;
var inst_2408 = chans;
var state_2424__$1 = (function (){var statearr_2426 = state_2424;
(statearr_2426[(7)] = inst_2407);

(statearr_2426[(8)] = inst_2408);

return statearr_2426;
})();
var statearr_2427_2438 = state_2424__$1;
(statearr_2427_2438[(2)] = null);

(statearr_2427_2438[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2425 === (2))){
var inst_2408 = (state_2424[(8)]);
var inst_2410 = cljs.core.seq.call(null,inst_2408);
var state_2424__$1 = state_2424;
if(inst_2410){
var statearr_2428_2439 = state_2424__$1;
(statearr_2428_2439[(1)] = (4));

} else {
var statearr_2429_2440 = state_2424__$1;
(statearr_2429_2440[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2425 === (3))){
var inst_2422 = (state_2424[(2)]);
var state_2424__$1 = state_2424;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2424__$1,inst_2422);
} else {
if((state_val_2425 === (4))){
var inst_2408 = (state_2424[(8)]);
var inst_2412 = cljs.core.first.call(null,inst_2408);
var state_2424__$1 = state_2424;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2424__$1,(7),inst_2412);
} else {
if((state_val_2425 === (5))){
var inst_2407 = (state_2424[(7)]);
var state_2424__$1 = state_2424;
var statearr_2430_2441 = state_2424__$1;
(statearr_2430_2441[(2)] = inst_2407);

(statearr_2430_2441[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2425 === (6))){
var inst_2420 = (state_2424[(2)]);
var state_2424__$1 = state_2424;
var statearr_2431_2442 = state_2424__$1;
(statearr_2431_2442[(2)] = inst_2420);

(statearr_2431_2442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2425 === (7))){
var inst_2407 = (state_2424[(7)]);
var inst_2408 = (state_2424[(8)]);
var inst_2414 = (state_2424[(2)]);
var inst_2415 = cljs.core.conj.call(null,inst_2407,inst_2414);
var inst_2416 = cljs.core.rest.call(null,inst_2408);
var inst_2407__$1 = inst_2415;
var inst_2408__$1 = inst_2416;
var state_2424__$1 = (function (){var statearr_2432 = state_2424;
(statearr_2432[(7)] = inst_2407__$1);

(statearr_2432[(8)] = inst_2408__$1);

return statearr_2432;
})();
var statearr_2433_2443 = state_2424__$1;
(statearr_2433_2443[(2)] = null);

(statearr_2433_2443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__2324__auto__))
;
return ((function (switch__2301__auto__,c__2324__auto__){
return (function() {
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto__ = null;
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto____0 = (function (){
var statearr_2434 = [null,null,null,null,null,null,null,null,null];
(statearr_2434[(0)] = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto__);

(statearr_2434[(1)] = (1));

return statearr_2434;
});
var imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto____1 = (function (state_2424){
while(true){
var ret_value__2303__auto__ = (function (){try{while(true){
var result__2304__auto__ = switch__2301__auto__.call(null,state_2424);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2304__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2304__auto__;
}
break;
}
}catch (e2435){if((e2435 instanceof Object)){
var ex__2305__auto__ = e2435;
var statearr_2436_2444 = state_2424;
(statearr_2436_2444[(5)] = ex__2305__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2424);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e2435;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2303__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__2445 = state_2424;
state_2424 = G__2445;
continue;
} else {
return ret_value__2303__auto__;
}
break;
}
});
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto__ = function(state_2424){
switch(arguments.length){
case 0:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto____0.call(this);
case 1:
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto____1.call(this,state_2424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto____0;
imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto____1;
return imcljs$internal$utils$_LT__LT__BANG__$_state_machine__2302__auto__;
})()
;})(switch__2301__auto__,c__2324__auto__))
})();
var state__2326__auto__ = (function (){var statearr_2437 = f__2325__auto__.call(null);
(statearr_2437[(6)] = c__2324__auto__);

return statearr_2437;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2326__auto__);
});})(c__2324__auto__))
);

return c__2324__auto__;
});
imcljs.internal.utils.assert_args = (function imcljs$internal$utils$assert_args(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2455 = arguments.length;
var i__4731__auto___2456 = (0);
while(true){
if((i__4731__auto___2456 < len__4730__auto___2455)){
args__4736__auto__.push((arguments[i__4731__auto___2456]));

var G__2457 = (i__4731__auto___2456 + (1));
i__4731__auto___2456 = G__2457;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return imcljs.internal.utils.assert_args.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

imcljs.internal.utils.assert_args.cljs$core$IFn$_invoke$arity$variadic = (function (method,args){
var vec__2448 = (function (){var G__2454 = args;
if(cljs.core._EQ_.call(null,method,new cljs.core.Keyword(null,"raw","raw",1604651272))){
return cljs.core.drop.call(null,(1),G__2454);
} else {
return G__2454;
}
})();
var seq__2449 = cljs.core.seq.call(null,vec__2448);
var first__2450 = cljs.core.first.call(null,seq__2449);
var seq__2449__$1 = cljs.core.next.call(null,seq__2449);
var path = first__2450;
var first__2450__$1 = cljs.core.first.call(null,seq__2449__$1);
var seq__2449__$2 = cljs.core.next.call(null,seq__2449__$1);
var service = first__2450__$1;
var first__2450__$2 = cljs.core.first.call(null,seq__2449__$2);
var seq__2449__$3 = cljs.core.next.call(null,seq__2449__$2);
var options = first__2450__$2;
var vec__2451 = seq__2449__$3;
var xform = cljs.core.nth.call(null,vec__2451,(0),null);
if(cljs.core.truth_(cljs.core.every_pred.call(null,cljs.core.string_QMARK_,cljs.core.not_empty).call(null,path))){
} else {
throw (new Error(["Assert failed: ","path should be a non-empty string.","\n","((every-pred string? not-empty) path)"].join('')));
}

if(cljs.core.truth_(cljs.core.every_pred.call(null,cljs.core.string_QMARK_,cljs.core.not_empty).call(null,new cljs.core.Keyword(null,"root","root",-448657453).cljs$core$IFn$_invoke$arity$1(service)))){
} else {
throw (new Error(["Assert failed: ","service should always have a root URL.","\n","((every-pred string? not-empty) (:root service))"].join('')));
}

if(cljs.core.truth_(cljs.core.some_fn.call(null,cljs.core.map_QMARK_,cljs.core.nil_QMARK_).call(null,options))){
} else {
throw (new Error(["Assert failed: ","options should be a map if non-nil.","\n","((some-fn map? nil?) options)"].join('')));
}

if(cljs.core.truth_(cljs.core.some_fn.call(null,cljs.core.ifn_QMARK_,cljs.core.nil_QMARK_).call(null,xform))){
return null;
} else {
throw (new Error(["Assert failed: ","xform should be a callable function if non-nil.","\n","((some-fn ifn? nil?) xform)"].join('')));
}
});

imcljs.internal.utils.assert_args.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
imcljs.internal.utils.assert_args.cljs$lang$applyTo = (function (seq2446){
var G__2447 = cljs.core.first.call(null,seq2446);
var seq2446__$1 = cljs.core.next.call(null,seq2446);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2447,seq2446__$1);
});


//# sourceMappingURL=utils.js.map
