// Compiled by ClojureScript 1.9.671 {}
goog.provide('imcljs.fetch');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('imcljs.query');
goog.require('cljs.core.async');
/**
 * Returns quicksearch results.
 */
imcljs.fetch.quicksearch = (function imcljs$fetch$quicksearch(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31741 = arguments.length;
var i__29867__auto___31742 = (0);
while(true){
if((i__29867__auto___31742 < len__29866__auto___31741)){
args__29873__auto__.push((arguments[i__29867__auto___31742]));

var G__31743 = (i__29867__auto___31742 + (1));
i__29867__auto___31742 = G__31743;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic = (function (service,search_term,p__31737){
var vec__31738 = p__31737;
var options = cljs.core.nth.call(null,vec__31738,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/search",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"q","q",689001697),search_term], null),options));
});

imcljs.fetch.quicksearch.cljs$lang$maxFixedArity = (2);

imcljs.fetch.quicksearch.cljs$lang$applyTo = (function (seq31734){
var G__31735 = cljs.core.first.call(null,seq31734);
var seq31734__$1 = cljs.core.next.call(null,seq31734);
var G__31736 = cljs.core.first.call(null,seq31734__$1);
var seq31734__$2 = cljs.core.next.call(null,seq31734__$1);
return imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic(G__31735,G__31736,seq31734__$2);
});

imcljs.fetch.table_rows = (function imcljs$fetch$table_rows(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31751 = arguments.length;
var i__29867__auto___31752 = (0);
while(true){
if((i__29867__auto___31752 < len__29866__auto___31751)){
args__29873__auto__.push((arguments[i__29867__auto___31752]));

var G__31753 = (i__29867__auto___31752 + (1));
i__29867__auto___31752 = G__31753;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__31747){
var vec__31748 = p__31747;
var options = cljs.core.nth.call(null,vec__31748,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/tablerows",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.table_rows.cljs$lang$maxFixedArity = (2);

imcljs.fetch.table_rows.cljs$lang$applyTo = (function (seq31744){
var G__31745 = cljs.core.first.call(null,seq31744);
var seq31744__$1 = cljs.core.next.call(null,seq31744);
var G__31746 = cljs.core.first.call(null,seq31744__$1);
var seq31744__$2 = cljs.core.next.call(null,seq31744__$1);
return imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic(G__31745,G__31746,seq31744__$2);
});

imcljs.fetch.fasta = (function imcljs$fetch$fasta(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31761 = arguments.length;
var i__29867__auto___31762 = (0);
while(true){
if((i__29867__auto___31762 < len__29866__auto___31761)){
args__29873__auto__.push((arguments[i__29867__auto___31762]));

var G__31763 = (i__29867__auto___31762 + (1));
i__29867__auto___31762 = G__31763;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__31757){
var vec__31758 = p__31757;
var options = cljs.core.nth.call(null,vec__31758,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/fasta",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fasta.cljs$lang$maxFixedArity = (2);

imcljs.fetch.fasta.cljs$lang$applyTo = (function (seq31754){
var G__31755 = cljs.core.first.call(null,seq31754);
var seq31754__$1 = cljs.core.next.call(null,seq31754);
var G__31756 = cljs.core.first.call(null,seq31754__$1);
var seq31754__$2 = cljs.core.next.call(null,seq31754__$1);
return imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic(G__31755,G__31756,seq31754__$2);
});

imcljs.fetch.fetch_custom_format = (function imcljs$fetch$fetch_custom_format(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31771 = arguments.length;
var i__29867__auto___31772 = (0);
while(true){
if((i__29867__auto___31772 < len__29866__auto___31771)){
args__29873__auto__.push((arguments[i__29867__auto___31772]));

var G__31773 = (i__29867__auto___31772 + (1));
i__29867__auto___31772 = G__31773;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__31767){
var vec__31768 = p__31767;
var options = cljs.core.nth.call(null,vec__31768,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fetch_custom_format.cljs$lang$maxFixedArity = (2);

imcljs.fetch.fetch_custom_format.cljs$lang$applyTo = (function (seq31764){
var G__31765 = cljs.core.first.call(null,seq31764);
var seq31764__$1 = cljs.core.next.call(null,seq31764);
var G__31766 = cljs.core.first.call(null,seq31764__$1);
var seq31764__$2 = cljs.core.next.call(null,seq31764__$1);
return imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic(G__31765,G__31766,seq31764__$2);
});

imcljs.fetch.records = (function imcljs$fetch$records(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31781 = arguments.length;
var i__29867__auto___31782 = (0);
while(true){
if((i__29867__auto___31782 < len__29866__auto___31781)){
args__29873__auto__.push((arguments[i__29867__auto___31782]));

var G__31783 = (i__29867__auto___31782 + (1));
i__29867__auto___31782 = G__31783;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__31777){
var vec__31778 = p__31777;
var options = cljs.core.nth.call(null,vec__31778,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"jsonobjects"], null),options));
});

imcljs.fetch.records.cljs$lang$maxFixedArity = (2);

imcljs.fetch.records.cljs$lang$applyTo = (function (seq31774){
var G__31775 = cljs.core.first.call(null,seq31774);
var seq31774__$1 = cljs.core.next.call(null,seq31774);
var G__31776 = cljs.core.first.call(null,seq31774__$1);
var seq31774__$2 = cljs.core.next.call(null,seq31774__$1);
return imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic(G__31775,G__31776,seq31774__$2);
});

imcljs.fetch.rows = (function imcljs$fetch$rows(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31791 = arguments.length;
var i__29867__auto___31792 = (0);
while(true){
if((i__29867__auto___31792 < len__29866__auto___31791)){
args__29873__auto__.push((arguments[i__29867__auto___31792]));

var G__31793 = (i__29867__auto___31792 + (1));
i__29867__auto___31792 = G__31793;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__31787){
var vec__31788 = p__31787;
var options = cljs.core.nth.call(null,vec__31788,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.rows.cljs$lang$maxFixedArity = (2);

imcljs.fetch.rows.cljs$lang$applyTo = (function (seq31784){
var G__31785 = cljs.core.first.call(null,seq31784);
var seq31784__$1 = cljs.core.next.call(null,seq31784);
var G__31786 = cljs.core.first.call(null,seq31784__$1);
var seq31784__$2 = cljs.core.next.call(null,seq31784__$1);
return imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic(G__31785,G__31786,seq31784__$2);
});

imcljs.fetch.row_count = (function imcljs$fetch$row_count(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31801 = arguments.length;
var i__29867__auto___31802 = (0);
while(true){
if((i__29867__auto___31802 < len__29866__auto___31801)){
args__29873__auto__.push((arguments[i__29867__auto___31802]));

var G__31803 = (i__29867__auto___31802 + (1));
i__29867__auto___31802 = G__31803;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__31797){
var vec__31798 = p__31797;
var options = cljs.core.nth.call(null,vec__31798,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"count"], null),options));
});

imcljs.fetch.row_count.cljs$lang$maxFixedArity = (2);

imcljs.fetch.row_count.cljs$lang$applyTo = (function (seq31794){
var G__31795 = cljs.core.first.call(null,seq31794);
var seq31794__$1 = cljs.core.next.call(null,seq31794);
var G__31796 = cljs.core.first.call(null,seq31794__$1);
var seq31794__$2 = cljs.core.next.call(null,seq31794__$1);
return imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic(G__31795,G__31796,seq31794__$2);
});

imcljs.fetch.possible_values = (function imcljs$fetch$possible_values(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31811 = arguments.length;
var i__29867__auto___31812 = (0);
while(true){
if((i__29867__auto___31812 < len__29866__auto___31811)){
args__29873__auto__.push((arguments[i__29867__auto___31812]));

var G__31813 = (i__29867__auto___31812 + (1));
i__29867__auto___31812 = G__31813;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,path,p__31807){
var vec__31808 = p__31807;
var options = cljs.core.nth.call(null,vec__31808,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/path/values",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),path,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.possible_values.cljs$lang$maxFixedArity = (2);

imcljs.fetch.possible_values.cljs$lang$applyTo = (function (seq31804){
var G__31805 = cljs.core.first.call(null,seq31804);
var seq31804__$1 = cljs.core.next.call(null,seq31804);
var G__31806 = cljs.core.first.call(null,seq31804__$1);
var seq31804__$2 = cljs.core.next.call(null,seq31804__$1);
return imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic(G__31805,G__31806,seq31804__$2);
});

/**
 * Fetches unique values for a path within a query. Providing a limit shortcircuits the request
 *   and returns false if the unique values exceed the limit
 */
imcljs.fetch.unique_values = (function imcljs$fetch$unique_values(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31892 = arguments.length;
var i__29867__auto___31893 = (0);
while(true){
if((i__29867__auto___31893 < len__29866__auto___31892)){
args__29873__auto__.push((arguments[i__29867__auto___31893]));

var G__31894 = (i__29867__auto___31893 + (1));
i__29867__auto___31893 = G__31894;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((3) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((3)),(0),null)):null);
return imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29874__auto__);
});

imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,path,p__31818){
var vec__31819 = p__31818;
var limit = cljs.core.nth.call(null,vec__31819,(0),null);
var return_chan = cljs.core.async.chan.call(null);
var c__31541__auto___31895 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31541__auto___31895,return_chan,vec__31819,limit){
return (function (){
var f__31542__auto__ = (function (){var switch__31518__auto__ = ((function (c__31541__auto___31895,return_chan,vec__31819,limit){
return (function (state_31869){
var state_val_31870 = (state_31869[(1)]);
if((state_val_31870 === (7))){
var state_31869__$1 = state_31869;
var statearr_31871_31896 = state_31869__$1;
(statearr_31871_31896[(2)] = false);

(statearr_31871_31896[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (1))){
var inst_31823 = [new cljs.core.Keyword(null,"summaryPath","summaryPath",599411983),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_31824 = [path,(1),"jsonrows"];
var inst_31825 = cljs.core.PersistentHashMap.fromArrays(inst_31823,inst_31824);
var inst_31826 = imcljs.fetch.rows.call(null,service,query,inst_31825);
var state_31869__$1 = state_31869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31869__$1,(2),inst_31826);
} else {
if((state_val_31870 === (4))){
var state_31869__$1 = state_31869;
var statearr_31872_31897 = state_31869__$1;
(statearr_31872_31897[(2)] = false);

(statearr_31872_31897[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (15))){
var inst_31862 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
var statearr_31873_31898 = state_31869__$1;
(statearr_31873_31898[(2)] = inst_31862);

(statearr_31873_31898[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (13))){
var state_31869__$1 = state_31869;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31869__$1,(17),return_chan,false);
} else {
if((state_val_31870 === (6))){
var state_31869__$1 = state_31869;
var statearr_31874_31899 = state_31869__$1;
(statearr_31874_31899[(2)] = true);

(statearr_31874_31899[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (17))){
var inst_31865 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
var statearr_31875_31900 = state_31869__$1;
(statearr_31875_31900[(2)] = inst_31865);

(statearr_31875_31900[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (3))){
var inst_31828 = (state_31869[(7)]);
var inst_31833 = inst_31828.cljs$lang$protocol_mask$partition0$;
var inst_31834 = (inst_31833 & (64));
var inst_31835 = inst_31828.cljs$core$ISeq$;
var inst_31836 = (cljs.core.PROTOCOL_SENTINEL === inst_31835);
var inst_31837 = (inst_31834) || (inst_31836);
var state_31869__$1 = state_31869;
if(cljs.core.truth_(inst_31837)){
var statearr_31876_31901 = state_31869__$1;
(statearr_31876_31901[(1)] = (6));

} else {
var statearr_31877_31902 = state_31869__$1;
(statearr_31877_31902[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (12))){
var inst_31855 = [new cljs.core.Keyword(null,"summaryPath","summaryPath",599411983),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_31856 = [path,limit,"jsonrows"];
var inst_31857 = cljs.core.PersistentHashMap.fromArrays(inst_31855,inst_31856);
var inst_31858 = imcljs.fetch.rows.call(null,service,query,inst_31857);
var state_31869__$1 = state_31869;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31869__$1,(16),inst_31858);
} else {
if((state_val_31870 === (2))){
var inst_31828 = (state_31869[(7)]);
var inst_31828__$1 = (state_31869[(2)]);
var inst_31830 = (inst_31828__$1 == null);
var inst_31831 = cljs.core.not.call(null,inst_31830);
var state_31869__$1 = (function (){var statearr_31878 = state_31869;
(statearr_31878[(7)] = inst_31828__$1);

return statearr_31878;
})();
if(inst_31831){
var statearr_31879_31903 = state_31869__$1;
(statearr_31879_31903[(1)] = (3));

} else {
var statearr_31880_31904 = state_31869__$1;
(statearr_31880_31904[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (11))){
var inst_31849 = (state_31869[(2)]);
var inst_31850 = cljs.core.get.call(null,inst_31849,new cljs.core.Keyword(null,"uniqueValues","uniqueValues",1661070646));
var inst_31851 = cljs.core.not.call(null,limit);
var inst_31852 = (inst_31850 <= limit);
var inst_31853 = (inst_31851) || (inst_31852);
var state_31869__$1 = state_31869;
if(cljs.core.truth_(inst_31853)){
var statearr_31881_31905 = state_31869__$1;
(statearr_31881_31905[(1)] = (12));

} else {
var statearr_31882_31906 = state_31869__$1;
(statearr_31882_31906[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (9))){
var inst_31828 = (state_31869[(7)]);
var inst_31846 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31828);
var state_31869__$1 = state_31869;
var statearr_31883_31907 = state_31869__$1;
(statearr_31883_31907[(2)] = inst_31846);

(statearr_31883_31907[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (5))){
var inst_31844 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
if(cljs.core.truth_(inst_31844)){
var statearr_31884_31908 = state_31869__$1;
(statearr_31884_31908[(1)] = (9));

} else {
var statearr_31885_31909 = state_31869__$1;
(statearr_31885_31909[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (14))){
var inst_31867 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31869__$1,inst_31867);
} else {
if((state_val_31870 === (16))){
var inst_31860 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31869__$1,(15),return_chan,inst_31860);
} else {
if((state_val_31870 === (10))){
var inst_31828 = (state_31869[(7)]);
var state_31869__$1 = state_31869;
var statearr_31886_31910 = state_31869__$1;
(statearr_31886_31910[(2)] = inst_31828);

(statearr_31886_31910[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31870 === (8))){
var inst_31841 = (state_31869[(2)]);
var state_31869__$1 = state_31869;
var statearr_31887_31911 = state_31869__$1;
(statearr_31887_31911[(2)] = inst_31841);

(statearr_31887_31911[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31541__auto___31895,return_chan,vec__31819,limit))
;
return ((function (switch__31518__auto__,c__31541__auto___31895,return_chan,vec__31819,limit){
return (function() {
var imcljs$fetch$state_machine__31519__auto__ = null;
var imcljs$fetch$state_machine__31519__auto____0 = (function (){
var statearr_31888 = [null,null,null,null,null,null,null,null];
(statearr_31888[(0)] = imcljs$fetch$state_machine__31519__auto__);

(statearr_31888[(1)] = (1));

return statearr_31888;
});
var imcljs$fetch$state_machine__31519__auto____1 = (function (state_31869){
while(true){
var ret_value__31520__auto__ = (function (){try{while(true){
var result__31521__auto__ = switch__31518__auto__.call(null,state_31869);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31521__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31521__auto__;
}
break;
}
}catch (e31889){if((e31889 instanceof Object)){
var ex__31522__auto__ = e31889;
var statearr_31890_31912 = state_31869;
(statearr_31890_31912[(5)] = ex__31522__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31869);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31889;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31520__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31913 = state_31869;
state_31869 = G__31913;
continue;
} else {
return ret_value__31520__auto__;
}
break;
}
});
imcljs$fetch$state_machine__31519__auto__ = function(state_31869){
switch(arguments.length){
case 0:
return imcljs$fetch$state_machine__31519__auto____0.call(this);
case 1:
return imcljs$fetch$state_machine__31519__auto____1.call(this,state_31869);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
imcljs$fetch$state_machine__31519__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$state_machine__31519__auto____0;
imcljs$fetch$state_machine__31519__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$state_machine__31519__auto____1;
return imcljs$fetch$state_machine__31519__auto__;
})()
;})(switch__31518__auto__,c__31541__auto___31895,return_chan,vec__31819,limit))
})();
var state__31543__auto__ = (function (){var statearr_31891 = f__31542__auto__.call(null);
(statearr_31891[(6)] = c__31541__auto___31895);

return statearr_31891;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31543__auto__);
});})(c__31541__auto___31895,return_chan,vec__31819,limit))
);


return return_chan;
});

imcljs.fetch.unique_values.cljs$lang$maxFixedArity = (3);

imcljs.fetch.unique_values.cljs$lang$applyTo = (function (seq31814){
var G__31815 = cljs.core.first.call(null,seq31814);
var seq31814__$1 = cljs.core.next.call(null,seq31814);
var G__31816 = cljs.core.first.call(null,seq31814__$1);
var seq31814__$2 = cljs.core.next.call(null,seq31814__$1);
var G__31817 = cljs.core.first.call(null,seq31814__$2);
var seq31814__$3 = cljs.core.next.call(null,seq31814__$2);
return imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic(G__31815,G__31816,G__31817,seq31814__$3);
});

imcljs.fetch.lists = (function imcljs$fetch$lists(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31920 = arguments.length;
var i__29867__auto___31921 = (0);
while(true){
if((i__29867__auto___31921 < len__29866__auto___31920)){
args__29873__auto__.push((arguments[i__29867__auto___31921]));

var G__31922 = (i__29867__auto___31921 + (1));
i__29867__auto___31921 = G__31922;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__31916){
var vec__31917 = p__31916;
var options = cljs.core.nth.call(null,vec__31917,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,options,new cljs.core.Keyword(null,"lists","lists",-884730684));
});

imcljs.fetch.lists.cljs$lang$maxFixedArity = (1);

imcljs.fetch.lists.cljs$lang$applyTo = (function (seq31914){
var G__31915 = cljs.core.first.call(null,seq31914);
var seq31914__$1 = cljs.core.next.call(null,seq31914);
return imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic(G__31915,seq31914__$1);
});

imcljs.fetch.one_list = (function imcljs$fetch$one_list(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31930 = arguments.length;
var i__29867__auto___31931 = (0);
while(true){
if((i__29867__auto___31931 < len__29866__auto___31930)){
args__29873__auto__.push((arguments[i__29867__auto___31931]));

var G__31932 = (i__29867__auto___31931 + (1));
i__29867__auto___31931 = G__31932;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,p__31926){
var vec__31927 = p__31926;
var options = cljs.core.nth.call(null,vec__31927,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null),options),cljs.core.comp.call(null,cljs.core.first,new cljs.core.Keyword(null,"lists","lists",-884730684)));
});

imcljs.fetch.one_list.cljs$lang$maxFixedArity = (2);

imcljs.fetch.one_list.cljs$lang$applyTo = (function (seq31923){
var G__31924 = cljs.core.first.call(null,seq31923);
var seq31923__$1 = cljs.core.next.call(null,seq31923);
var G__31925 = cljs.core.first.call(null,seq31923__$1);
var seq31923__$2 = cljs.core.next.call(null,seq31923__$1);
return imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic(G__31924,G__31925,seq31923__$2);
});

imcljs.fetch.model = (function imcljs$fetch$model(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31939 = arguments.length;
var i__29867__auto___31940 = (0);
while(true){
if((i__29867__auto___31940 < len__29866__auto___31939)){
args__29873__auto__.push((arguments[i__29867__auto___31940]));

var G__31941 = (i__29867__auto___31940 + (1));
i__29867__auto___31940 = G__31941;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__31935){
var vec__31936 = p__31935;
var options = cljs.core.nth.call(null,vec__31936,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/model",service,options,new cljs.core.Keyword(null,"model","model",331153215));
});

imcljs.fetch.model.cljs$lang$maxFixedArity = (1);

imcljs.fetch.model.cljs$lang$applyTo = (function (seq31933){
var G__31934 = cljs.core.first.call(null,seq31933);
var seq31933__$1 = cljs.core.next.call(null,seq31933);
return imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic(G__31934,seq31933__$1);
});

imcljs.fetch.class_keys = (function imcljs$fetch$class_keys(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31948 = arguments.length;
var i__29867__auto___31949 = (0);
while(true){
if((i__29867__auto___31949 < len__29866__auto___31948)){
args__29873__auto__.push((arguments[i__29867__auto___31949]));

var G__31950 = (i__29867__auto___31949 + (1));
i__29867__auto___31949 = G__31950;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__31944){
var vec__31945 = p__31944;
var options = cljs.core.nth.call(null,vec__31945,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/classkeys",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.class_keys.cljs$lang$maxFixedArity = (1);

imcljs.fetch.class_keys.cljs$lang$applyTo = (function (seq31942){
var G__31943 = cljs.core.first.call(null,seq31942);
var seq31942__$1 = cljs.core.next.call(null,seq31942);
return imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic(G__31943,seq31942__$1);
});

imcljs.fetch.summary_fields = (function imcljs$fetch$summary_fields(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31957 = arguments.length;
var i__29867__auto___31958 = (0);
while(true){
if((i__29867__auto___31958 < len__29866__auto___31957)){
args__29873__auto__.push((arguments[i__29867__auto___31958]));

var G__31959 = (i__29867__auto___31958 + (1));
i__29867__auto___31958 = G__31959;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__31953){
var vec__31954 = p__31953;
var options = cljs.core.nth.call(null,vec__31954,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/summaryfields",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.summary_fields.cljs$lang$maxFixedArity = (1);

imcljs.fetch.summary_fields.cljs$lang$applyTo = (function (seq31951){
var G__31952 = cljs.core.first.call(null,seq31951);
var seq31951__$1 = cljs.core.next.call(null,seq31951);
return imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic(G__31952,seq31951__$1);
});

imcljs.fetch.templates = (function imcljs$fetch$templates(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31966 = arguments.length;
var i__29867__auto___31967 = (0);
while(true){
if((i__29867__auto___31967 < len__29866__auto___31966)){
args__29873__auto__.push((arguments[i__29867__auto___31967]));

var G__31968 = (i__29867__auto___31967 + (1));
i__29867__auto___31967 = G__31968;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__31962){
var vec__31963 = p__31962;
var options = cljs.core.nth.call(null,vec__31963,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/templates",service,options,new cljs.core.Keyword(null,"templates","templates",-1237401733));
});

imcljs.fetch.templates.cljs$lang$maxFixedArity = (1);

imcljs.fetch.templates.cljs$lang$applyTo = (function (seq31960){
var G__31961 = cljs.core.first.call(null,seq31960);
var seq31960__$1 = cljs.core.next.call(null,seq31960);
return imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic(G__31961,seq31960__$1);
});

/**
 * Returns a temporary API token.
 */
imcljs.fetch.session = (function imcljs$fetch$session(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31975 = arguments.length;
var i__29867__auto___31976 = (0);
while(true){
if((i__29867__auto___31976 < len__29866__auto___31975)){
args__29873__auto__.push((arguments[i__29867__auto___31976]));

var G__31977 = (i__29867__auto___31976 + (1));
i__29867__auto___31976 = G__31977;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__31971){
var vec__31972 = p__31971;
var options = cljs.core.nth.call(null,vec__31972,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/session",service,options,new cljs.core.Keyword(null,"token","token",-1211463215));
});

imcljs.fetch.session.cljs$lang$maxFixedArity = (1);

imcljs.fetch.session.cljs$lang$applyTo = (function (seq31969){
var G__31970 = cljs.core.first.call(null,seq31969);
var seq31969__$1 = cljs.core.next.call(null,seq31969);
return imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic(G__31970,seq31969__$1);
});

/**
 * Returns list of widgets available for a given mine
 */
imcljs.fetch.widgets = (function imcljs$fetch$widgets(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31984 = arguments.length;
var i__29867__auto___31985 = (0);
while(true){
if((i__29867__auto___31985 < len__29866__auto___31984)){
args__29873__auto__.push((arguments[i__29867__auto___31985]));

var G__31986 = (i__29867__auto___31985 + (1));
i__29867__auto___31985 = G__31986;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__31980){
var vec__31981 = p__31980;
var options = cljs.core.nth.call(null,vec__31981,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/widgets",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),new cljs.core.Keyword(null,"widgets","widgets",-159098978));
});

imcljs.fetch.widgets.cljs$lang$maxFixedArity = (1);

imcljs.fetch.widgets.cljs$lang$applyTo = (function (seq31978){
var G__31979 = cljs.core.first.call(null,seq31978);
var seq31978__$1 = cljs.core.next.call(null,seq31978);
return imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic(G__31979,seq31978__$1);
});

/**
 * Returns enrichment results
 */
imcljs.fetch.enrichment = (function imcljs$fetch$enrichment(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31993 = arguments.length;
var i__29867__auto___31994 = (0);
while(true){
if((i__29867__auto___31994 < len__29866__auto___31993)){
args__29873__auto__.push((arguments[i__29867__auto___31994]));

var G__31995 = (i__29867__auto___31994 + (1));
i__29867__auto___31994 = G__31995;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__31989){
var vec__31990 = p__31989;
var options = cljs.core.nth.call(null,vec__31990,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/enrichment",service,cljs.core.merge.call(null,imcljs.internal.defaults.default_enrichment,options));
});

imcljs.fetch.enrichment.cljs$lang$maxFixedArity = (1);

imcljs.fetch.enrichment.cljs$lang$applyTo = (function (seq31987){
var G__31988 = cljs.core.first.call(null,seq31987);
var seq31987__$1 = cljs.core.next.call(null,seq31987);
return imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic(G__31988,seq31987__$1);
});

/**
 * Returns the version of the InterMine WebService being run, e.g. '27'
 */
imcljs.fetch.version_web_service = (function imcljs$fetch$version_web_service(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
imcljs.fetch.version_release = (function imcljs$fetch$version_release(service){

return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/release",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the version of InterMine being run, e.g. '1.6.6'
 */
imcljs.fetch.version_intermine = (function imcljs$fetch$version_intermine(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/intermine",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the default configs for a given mine. These are important as they're
 * used to initialise most bluegenes page sections! 
 */
imcljs.fetch.web_properties = (function imcljs$fetch$web_properties(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/web-properties",service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"web-properties","web-properties",-1421911737));
});
/**
 * Fetches the results of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_results = (function imcljs$fetch$fetch_id_resolution_job_results(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("/ids/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/results")].join(''),service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"results","results",-1134170113));
});
/**
 * Fetches the status of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_status = (function imcljs$fetch$fetch_id_resolution_job_status(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("/ids/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/status")].join(''),service);
});
/**
 * Starts an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job = (function imcljs$fetch$fetch_id_resolution_job(service,p__31996){
var map__31997 = p__31996;
var map__31997__$1 = ((((!((map__31997 == null)))?((((map__31997.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31997.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31997):map__31997);
var options = map__31997__$1;
var identifiers = cljs.core.get.call(null,map__31997__$1,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722));
var type = cljs.core.get.call(null,map__31997__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__31997__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var wild_cards = cljs.core.get.call(null,map__31997__$1,new cljs.core.Keyword(null,"wild-cards","wild-cards",681119344));
var extra = cljs.core.get.call(null,map__31997__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post-body","post-body",-1481559189),"/ids",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),(function (){var G__31999 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722),identifiers], null);
var G__31999__$1 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__31999,new cljs.core.Keyword(null,"type","type",1174270348),type):G__31999);
var G__31999__$2 = (cljs.core.truth_(case_sensitive)?cljs.core.assoc.call(null,G__31999__$1,new cljs.core.Keyword(null,"caseSensitive","caseSensitive",-586669673),true):G__31999__$1);
var G__31999__$3 = (cljs.core.truth_(wild_cards)?cljs.core.assoc.call(null,G__31999__$2,new cljs.core.Keyword(null,"wildCards","wildCards",-2054689560),true):G__31999__$2);
if(cljs.core.truth_(extra)){
return cljs.core.assoc.call(null,G__31999__$3,new cljs.core.Keyword(null,"extra","extra",1612569067),extra);
} else {
return G__31999__$3;
}
})(),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null)], null));
});
/**
 * Resolves identifiers. Automatically handles polling
 */
imcljs.fetch.resolve_identifiers = (function imcljs$fetch$resolve_identifiers(service,p__32000){
var map__32001 = p__32000;
var map__32001__$1 = ((((!((map__32001 == null)))?((((map__32001.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32001.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32001):map__32001);
var options = map__32001__$1;
var identifiers = cljs.core.get.call(null,map__32001__$1,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722));
var type = cljs.core.get.call(null,map__32001__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__32001__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var wild_cards = cljs.core.get.call(null,map__32001__$1,new cljs.core.Keyword(null,"wild-cards","wild-cards",681119344));
var extra = cljs.core.get.call(null,map__32001__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
var timeout_ms = cljs.core.get.call(null,map__32001__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var return_chan = cljs.core.async.chan.call(null,(1));
var c__31541__auto___32113 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (){
var f__31542__auto__ = (function (){var switch__31518__auto__ = ((function (c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (state_32071){
var state_val_32072 = (state_32071[(1)]);
if((state_val_32072 === (1))){
var inst_32003 = imcljs.fetch.fetch_id_resolution_job.call(null,service,options);
var state_32071__$1 = state_32071;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32071__$1,(2),inst_32003);
} else {
if((state_val_32072 === (2))){
var inst_32005 = (state_32071[(2)]);
var inst_32067 = cljs.core.async.chan.call(null,(1));
var inst_32068 = (function (){var job = inst_32005;
var c__31541__auto____$1 = inst_32067;
return ((function (job,c__31541__auto____$1,inst_32005,inst_32067,state_val_32072,c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (){
var f__31542__auto__ = (function (){var switch__31518__auto__ = ((function (job,c__31541__auto____$1,inst_32005,inst_32067,state_val_32072,c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (state_32065){
var state_val_32066 = (state_32065[(1)]);
if((state_val_32066 === (7))){
var inst_32028 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
if(cljs.core.truth_(inst_32028)){
var statearr_32073_32114 = state_32065__$1;
(statearr_32073_32114[(1)] = (11));

} else {
var statearr_32074_32115 = state_32065__$1;
(statearr_32074_32115[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (20))){
var state_32065__$1 = state_32065;
var statearr_32075_32116 = state_32065__$1;
(statearr_32075_32116[(2)] = timeout_ms);

(statearr_32075_32116[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (1))){
var inst_32006 = (100);
var state_32065__$1 = (function (){var statearr_32076 = state_32065;
(statearr_32076[(7)] = inst_32006);

return statearr_32076;
})();
var statearr_32077_32117 = state_32065__$1;
(statearr_32077_32117[(2)] = null);

(statearr_32077_32117[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (24))){
var state_32065__$1 = state_32065;
var statearr_32078_32118 = state_32065__$1;
(statearr_32078_32118[(2)] = null);

(statearr_32078_32118[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (4))){
var inst_32012 = (state_32065[(8)]);
var inst_32012__$1 = (state_32065[(2)]);
var inst_32014 = (inst_32012__$1 == null);
var inst_32015 = cljs.core.not.call(null,inst_32014);
var state_32065__$1 = (function (){var statearr_32079 = state_32065;
(statearr_32079[(8)] = inst_32012__$1);

return statearr_32079;
})();
if(inst_32015){
var statearr_32080_32119 = state_32065__$1;
(statearr_32080_32119[(1)] = (5));

} else {
var statearr_32081_32120 = state_32065__$1;
(statearr_32081_32120[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (15))){
var inst_32006 = (state_32065[(7)]);
var inst_32045 = cljs.core.async.timeout.call(null,inst_32006);
var state_32065__$1 = state_32065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32065__$1,(19),inst_32045);
} else {
if((state_val_32066 === (21))){
var state_32065__$1 = state_32065;
var statearr_32082_32121 = state_32065__$1;
(statearr_32082_32121[(2)] = (30000));

(statearr_32082_32121[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (13))){
var inst_32033 = (state_32065[(2)]);
var inst_32034 = cljs.core.get.call(null,inst_32033,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_32035 = cljs.core.get.call(null,inst_32033,new cljs.core.Keyword(null,"uid","uid",-1447769400));
var inst_32036 = cljs.core._EQ_.call(null,"SUCCESS",inst_32034);
var state_32065__$1 = (function (){var statearr_32083 = state_32065;
(statearr_32083[(9)] = inst_32035);

return statearr_32083;
})();
if(inst_32036){
var statearr_32084_32122 = state_32065__$1;
(statearr_32084_32122[(1)] = (14));

} else {
var statearr_32085_32123 = state_32065__$1;
(statearr_32085_32123[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (22))){
var inst_32006 = (state_32065[(7)]);
var inst_32051 = (state_32065[(2)]);
var inst_32052 = (inst_32006 < inst_32051);
var state_32065__$1 = state_32065;
if(cljs.core.truth_(inst_32052)){
var statearr_32086_32124 = state_32065__$1;
(statearr_32086_32124[(1)] = (23));

} else {
var statearr_32087_32125 = state_32065__$1;
(statearr_32087_32125[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (6))){
var state_32065__$1 = state_32065;
var statearr_32088_32126 = state_32065__$1;
(statearr_32088_32126[(2)] = false);

(statearr_32088_32126[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (25))){
var inst_32059 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32089_32127 = state_32065__$1;
(statearr_32089_32127[(2)] = inst_32059);

(statearr_32089_32127[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (17))){
var inst_32041 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32065__$1,(18),return_chan,inst_32041);
} else {
if((state_val_32066 === (3))){
var inst_32063 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32065__$1,inst_32063);
} else {
if((state_val_32066 === (12))){
var inst_32012 = (state_32065[(8)]);
var state_32065__$1 = state_32065;
var statearr_32090_32128 = state_32065__$1;
(statearr_32090_32128[(2)] = inst_32012);

(statearr_32090_32128[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (2))){
var inst_32009 = new cljs.core.Keyword(null,"uid","uid",-1447769400).cljs$core$IFn$_invoke$arity$1(job);
var inst_32010 = imcljs.fetch.fetch_id_resolution_job_status.call(null,service,inst_32009);
var state_32065__$1 = state_32065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32065__$1,(4),inst_32010);
} else {
if((state_val_32066 === (23))){
var inst_32006 = (state_32065[(7)]);
var inst_32054 = (inst_32006 * 1.5);
var inst_32055 = (((1000) < inst_32054) ? (1000) : inst_32054);
var inst_32006__$1 = inst_32055;
var state_32065__$1 = (function (){var statearr_32091 = state_32065;
(statearr_32091[(7)] = inst_32006__$1);

return statearr_32091;
})();
var statearr_32092_32129 = state_32065__$1;
(statearr_32092_32129[(2)] = null);

(statearr_32092_32129[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (19))){
var inst_32047 = (state_32065[(2)]);
var state_32065__$1 = (function (){var statearr_32093 = state_32065;
(statearr_32093[(10)] = inst_32047);

return statearr_32093;
})();
if(cljs.core.truth_(timeout_ms)){
var statearr_32094_32130 = state_32065__$1;
(statearr_32094_32130[(1)] = (20));

} else {
var statearr_32095_32131 = state_32065__$1;
(statearr_32095_32131[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (11))){
var inst_32012 = (state_32065[(8)]);
var inst_32030 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32012);
var state_32065__$1 = state_32065;
var statearr_32096_32132 = state_32065__$1;
(statearr_32096_32132[(2)] = inst_32030);

(statearr_32096_32132[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (9))){
var state_32065__$1 = state_32065;
var statearr_32097_32133 = state_32065__$1;
(statearr_32097_32133[(2)] = false);

(statearr_32097_32133[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (5))){
var inst_32012 = (state_32065[(8)]);
var inst_32017 = inst_32012.cljs$lang$protocol_mask$partition0$;
var inst_32018 = (inst_32017 & (64));
var inst_32019 = inst_32012.cljs$core$ISeq$;
var inst_32020 = (cljs.core.PROTOCOL_SENTINEL === inst_32019);
var inst_32021 = (inst_32018) || (inst_32020);
var state_32065__$1 = state_32065;
if(cljs.core.truth_(inst_32021)){
var statearr_32098_32134 = state_32065__$1;
(statearr_32098_32134[(1)] = (8));

} else {
var statearr_32099_32135 = state_32065__$1;
(statearr_32099_32135[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (14))){
var inst_32038 = new cljs.core.Keyword(null,"uid","uid",-1447769400).cljs$core$IFn$_invoke$arity$1(job);
var inst_32039 = imcljs.fetch.fetch_id_resolution_job_results.call(null,service,inst_32038);
var state_32065__$1 = state_32065;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32065__$1,(17),inst_32039);
} else {
if((state_val_32066 === (16))){
var inst_32061 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32100_32136 = state_32065__$1;
(statearr_32100_32136[(2)] = inst_32061);

(statearr_32100_32136[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (10))){
var inst_32025 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32101_32137 = state_32065__$1;
(statearr_32101_32137[(2)] = inst_32025);

(statearr_32101_32137[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (18))){
var inst_32043 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32102_32138 = state_32065__$1;
(statearr_32102_32138[(2)] = inst_32043);

(statearr_32102_32138[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32066 === (8))){
var state_32065__$1 = state_32065;
var statearr_32103_32139 = state_32065__$1;
(statearr_32103_32139[(2)] = true);

(statearr_32103_32139[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(job,c__31541__auto____$1,inst_32005,inst_32067,state_val_32072,c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
;
return ((function (switch__31518__auto__,job,c__31541__auto____$1,inst_32005,inst_32067,state_val_32072,c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function() {
var imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__ = null;
var imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____0 = (function (){
var statearr_32104 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_32104[(0)] = imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__);

(statearr_32104[(1)] = (1));

return statearr_32104;
});
var imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____1 = (function (state_32065){
while(true){
var ret_value__31520__auto__ = (function (){try{while(true){
var result__31521__auto__ = switch__31518__auto__.call(null,state_32065);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31521__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31521__auto__;
}
break;
}
}catch (e32105){if((e32105 instanceof Object)){
var ex__31522__auto__ = e32105;
var statearr_32106_32140 = state_32065;
(statearr_32106_32140[(5)] = ex__31522__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32065);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32105;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31520__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32141 = state_32065;
state_32065 = G__32141;
continue;
} else {
return ret_value__31520__auto__;
}
break;
}
});
imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__ = function(state_32065){
switch(arguments.length){
case 0:
return imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____0.call(this);
case 1:
return imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____1.call(this,state_32065);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____0;
imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____1;
return imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__;
})()
;})(switch__31518__auto__,job,c__31541__auto____$1,inst_32005,inst_32067,state_val_32072,c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var state__31543__auto__ = (function (){var statearr_32107 = f__31542__auto__.call(null);
(statearr_32107[(6)] = c__31541__auto____$1);

return statearr_32107;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31543__auto__);
});
;})(job,c__31541__auto____$1,inst_32005,inst_32067,state_val_32072,c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var inst_32069 = cljs.core.async.impl.dispatch.run.call(null,inst_32068);
var state_32071__$1 = (function (){var statearr_32108 = state_32071;
(statearr_32108[(7)] = inst_32069);

return statearr_32108;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32071__$1,inst_32067);
} else {
return null;
}
}
});})(c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
;
return ((function (switch__31518__auto__,c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function() {
var imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__ = null;
var imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____0 = (function (){
var statearr_32109 = [null,null,null,null,null,null,null,null];
(statearr_32109[(0)] = imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__);

(statearr_32109[(1)] = (1));

return statearr_32109;
});
var imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____1 = (function (state_32071){
while(true){
var ret_value__31520__auto__ = (function (){try{while(true){
var result__31521__auto__ = switch__31518__auto__.call(null,state_32071);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31521__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31521__auto__;
}
break;
}
}catch (e32110){if((e32110 instanceof Object)){
var ex__31522__auto__ = e32110;
var statearr_32111_32142 = state_32071;
(statearr_32111_32142[(5)] = ex__31522__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32071);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32110;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31520__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32143 = state_32071;
state_32071 = G__32143;
continue;
} else {
return ret_value__31520__auto__;
}
break;
}
});
imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__ = function(state_32071){
switch(arguments.length){
case 0:
return imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____0.call(this);
case 1:
return imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____1.call(this,state_32071);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____0;
imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto____1;
return imcljs$fetch$resolve_identifiers_$_state_machine__31519__auto__;
})()
;})(switch__31518__auto__,c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var state__31543__auto__ = (function (){var statearr_32112 = f__31542__auto__.call(null);
(statearr_32112[(6)] = c__31541__auto___32113);

return statearr_32112;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31543__auto__);
});})(c__31541__auto___32113,return_chan,map__32001,map__32001__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
);


return return_chan;
});
/**
 * Returns generated code to run the query in a given language
 */
imcljs.fetch.code = (function imcljs$fetch$code(var_args){
var args__29873__auto__ = [];
var len__29866__auto___32153 = arguments.length;
var i__29867__auto___32154 = (0);
while(true){
if((i__29867__auto___32154 < len__29866__auto___32153)){
args__29873__auto__.push((arguments[i__29867__auto___32154]));

var G__32155 = (i__29867__auto___32154 + (1));
i__29867__auto___32154 = G__32155;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic = (function (service,model,p__32147){
var vec__32148 = p__32147;
var map__32151 = cljs.core.nth.call(null,vec__32148,(0),null);
var map__32151__$1 = ((((!((map__32151 == null)))?((((map__32151.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32151.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32151):map__32151);
var options = map__32151__$1;
var lang = cljs.core.get.call(null,map__32151__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
var query = cljs.core.get.call(null,map__32151__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/query/code",service,cljs.core.update.call(null,cljs.core.merge.call(null,options,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null)),new cljs.core.Keyword(null,"query","query",-1288509510),cljs.core.partial.call(null,imcljs.query.__GT_xml,model)),new cljs.core.Keyword(null,"code","code",1586293142));
});

imcljs.fetch.code.cljs$lang$maxFixedArity = (2);

imcljs.fetch.code.cljs$lang$applyTo = (function (seq32144){
var G__32145 = cljs.core.first.call(null,seq32144);
var seq32144__$1 = cljs.core.next.call(null,seq32144);
var G__32146 = cljs.core.first.call(null,seq32144__$1);
var seq32144__$2 = cljs.core.next.call(null,seq32144__$1);
return imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic(G__32145,G__32146,seq32144__$2);
});

/**
 * Returns list of InterMines from the InterMine registry.
 */
imcljs.fetch.registry = (function imcljs$fetch$registry(dev_mines_QMARK_){
return imcljs.internal.io.get_plain.call(null,"http://registry.intermine.org/service/instances",(cljs.core.truth_(dev_mines_QMARK_)?new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222),false,new cljs.core.Keyword(null,"query-params","query-params",900640534),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mines","mines",-1960796490),"all"], null)], null):new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"with-credentials?","with-credentials?",-1773202222),false], null)));
});

//# sourceMappingURL=fetch.js.map