// Compiled by ClojureScript 1.9.671 {}
goog.provide('imcljs.fetch');
goog.require('cljs.core');
goog.require('imcljs.internal.io');
goog.require('imcljs.query');
goog.require('cljs.core.async');
/**
 * Returns quicksearch results.
 */
imcljs.fetch.quicksearch = (function imcljs$fetch$quicksearch(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34561 = arguments.length;
var i__29867__auto___34562 = (0);
while(true){
if((i__29867__auto___34562 < len__29866__auto___34561)){
args__29873__auto__.push((arguments[i__29867__auto___34562]));

var G__34563 = (i__29867__auto___34562 + (1));
i__29867__auto___34562 = G__34563;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic = (function (service,search_term,p__34557){
var vec__34558 = p__34557;
var options = cljs.core.nth.call(null,vec__34558,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/search",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"q","q",689001697),search_term], null),options));
});

imcljs.fetch.quicksearch.cljs$lang$maxFixedArity = (2);

imcljs.fetch.quicksearch.cljs$lang$applyTo = (function (seq34554){
var G__34555 = cljs.core.first.call(null,seq34554);
var seq34554__$1 = cljs.core.next.call(null,seq34554);
var G__34556 = cljs.core.first.call(null,seq34554__$1);
var seq34554__$2 = cljs.core.next.call(null,seq34554__$1);
return imcljs.fetch.quicksearch.cljs$core$IFn$_invoke$arity$variadic(G__34555,G__34556,seq34554__$2);
});

imcljs.fetch.table_rows = (function imcljs$fetch$table_rows(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34571 = arguments.length;
var i__29867__auto___34572 = (0);
while(true){
if((i__29867__auto___34572 < len__29866__auto___34571)){
args__29873__auto__.push((arguments[i__29867__auto___34572]));

var G__34573 = (i__29867__auto___34572 + (1));
i__29867__auto___34572 = G__34573;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__34567){
var vec__34568 = p__34567;
var options = cljs.core.nth.call(null,vec__34568,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/tablerows",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.table_rows.cljs$lang$maxFixedArity = (2);

imcljs.fetch.table_rows.cljs$lang$applyTo = (function (seq34564){
var G__34565 = cljs.core.first.call(null,seq34564);
var seq34564__$1 = cljs.core.next.call(null,seq34564);
var G__34566 = cljs.core.first.call(null,seq34564__$1);
var seq34564__$2 = cljs.core.next.call(null,seq34564__$1);
return imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic(G__34565,G__34566,seq34564__$2);
});

imcljs.fetch.fasta = (function imcljs$fetch$fasta(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34581 = arguments.length;
var i__29867__auto___34582 = (0);
while(true){
if((i__29867__auto___34582 < len__29866__auto___34581)){
args__29873__auto__.push((arguments[i__29867__auto___34582]));

var G__34583 = (i__29867__auto___34582 + (1));
i__29867__auto___34582 = G__34583;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__34577){
var vec__34578 = p__34577;
var options = cljs.core.nth.call(null,vec__34578,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results/fasta",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fasta.cljs$lang$maxFixedArity = (2);

imcljs.fetch.fasta.cljs$lang$applyTo = (function (seq34574){
var G__34575 = cljs.core.first.call(null,seq34574);
var seq34574__$1 = cljs.core.next.call(null,seq34574);
var G__34576 = cljs.core.first.call(null,seq34574__$1);
var seq34574__$2 = cljs.core.next.call(null,seq34574__$1);
return imcljs.fetch.fasta.cljs$core$IFn$_invoke$arity$variadic(G__34575,G__34576,seq34574__$2);
});

imcljs.fetch.fetch_custom_format = (function imcljs$fetch$fetch_custom_format(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34591 = arguments.length;
var i__29867__auto___34592 = (0);
while(true){
if((i__29867__auto___34592 < len__29866__auto___34591)){
args__29873__auto__.push((arguments[i__29867__auto___34592]));

var G__34593 = (i__29867__auto___34592 + (1));
i__29867__auto___34592 = G__34593;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__34587){
var vec__34588 = p__34587;
var options = cljs.core.nth.call(null,vec__34588,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"query","query",-1288509510),query], null),options));
});

imcljs.fetch.fetch_custom_format.cljs$lang$maxFixedArity = (2);

imcljs.fetch.fetch_custom_format.cljs$lang$applyTo = (function (seq34584){
var G__34585 = cljs.core.first.call(null,seq34584);
var seq34584__$1 = cljs.core.next.call(null,seq34584);
var G__34586 = cljs.core.first.call(null,seq34584__$1);
var seq34584__$2 = cljs.core.next.call(null,seq34584__$1);
return imcljs.fetch.fetch_custom_format.cljs$core$IFn$_invoke$arity$variadic(G__34585,G__34586,seq34584__$2);
});

imcljs.fetch.records = (function imcljs$fetch$records(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34601 = arguments.length;
var i__29867__auto___34602 = (0);
while(true){
if((i__29867__auto___34602 < len__29866__auto___34601)){
args__29873__auto__.push((arguments[i__29867__auto___34602]));

var G__34603 = (i__29867__auto___34602 + (1));
i__29867__auto___34602 = G__34603;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__34597){
var vec__34598 = p__34597;
var options = cljs.core.nth.call(null,vec__34598,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"jsonobjects"], null),options));
});

imcljs.fetch.records.cljs$lang$maxFixedArity = (2);

imcljs.fetch.records.cljs$lang$applyTo = (function (seq34594){
var G__34595 = cljs.core.first.call(null,seq34594);
var seq34594__$1 = cljs.core.next.call(null,seq34594);
var G__34596 = cljs.core.first.call(null,seq34594__$1);
var seq34594__$2 = cljs.core.next.call(null,seq34594__$1);
return imcljs.fetch.records.cljs$core$IFn$_invoke$arity$variadic(G__34595,G__34596,seq34594__$2);
});

imcljs.fetch.rows = (function imcljs$fetch$rows(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34611 = arguments.length;
var i__29867__auto___34612 = (0);
while(true){
if((i__29867__auto___34612 < len__29866__auto___34611)){
args__29873__auto__.push((arguments[i__29867__auto___34612]));

var G__34613 = (i__29867__auto___34612 + (1));
i__29867__auto___34612 = G__34613;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__34607){
var vec__34608 = p__34607;
var options = cljs.core.nth.call(null,vec__34608,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.rows.cljs$lang$maxFixedArity = (2);

imcljs.fetch.rows.cljs$lang$applyTo = (function (seq34604){
var G__34605 = cljs.core.first.call(null,seq34604);
var seq34604__$1 = cljs.core.next.call(null,seq34604);
var G__34606 = cljs.core.first.call(null,seq34604__$1);
var seq34604__$2 = cljs.core.next.call(null,seq34604__$1);
return imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic(G__34605,G__34606,seq34604__$2);
});

imcljs.fetch.row_count = (function imcljs$fetch$row_count(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34621 = arguments.length;
var i__29867__auto___34622 = (0);
while(true){
if((i__29867__auto___34622 < len__29866__auto___34621)){
args__29873__auto__.push((arguments[i__29867__auto___34622]));

var G__34623 = (i__29867__auto___34622 + (1));
i__29867__auto___34622 = G__34623;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,p__34617){
var vec__34618 = p__34617;
var options = cljs.core.nth.call(null,vec__34618,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/query/results",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"query","query",-1288509510),query,new cljs.core.Keyword(null,"format","format",-1306924766),"count"], null),options));
});

imcljs.fetch.row_count.cljs$lang$maxFixedArity = (2);

imcljs.fetch.row_count.cljs$lang$applyTo = (function (seq34614){
var G__34615 = cljs.core.first.call(null,seq34614);
var seq34614__$1 = cljs.core.next.call(null,seq34614);
var G__34616 = cljs.core.first.call(null,seq34614__$1);
var seq34614__$2 = cljs.core.next.call(null,seq34614__$1);
return imcljs.fetch.row_count.cljs$core$IFn$_invoke$arity$variadic(G__34615,G__34616,seq34614__$2);
});

imcljs.fetch.possible_values = (function imcljs$fetch$possible_values(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34631 = arguments.length;
var i__29867__auto___34632 = (0);
while(true){
if((i__29867__auto___34632 < len__29866__auto___34631)){
args__29873__auto__.push((arguments[i__29867__auto___34632]));

var G__34633 = (i__29867__auto___34632 + (1));
i__29867__auto___34632 = G__34633;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,path,p__34627){
var vec__34628 = p__34627;
var options = cljs.core.nth.call(null,vec__34628,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/path/values",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),path,new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),options));
});

imcljs.fetch.possible_values.cljs$lang$maxFixedArity = (2);

imcljs.fetch.possible_values.cljs$lang$applyTo = (function (seq34624){
var G__34625 = cljs.core.first.call(null,seq34624);
var seq34624__$1 = cljs.core.next.call(null,seq34624);
var G__34626 = cljs.core.first.call(null,seq34624__$1);
var seq34624__$2 = cljs.core.next.call(null,seq34624__$1);
return imcljs.fetch.possible_values.cljs$core$IFn$_invoke$arity$variadic(G__34625,G__34626,seq34624__$2);
});

/**
 * Fetches unique values for a path within a query. Providing a limit shortcircuits the request
 *   and returns false if the unique values exceed the limit
 */
imcljs.fetch.unique_values = (function imcljs$fetch$unique_values(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34712 = arguments.length;
var i__29867__auto___34713 = (0);
while(true){
if((i__29867__auto___34713 < len__29866__auto___34712)){
args__29873__auto__.push((arguments[i__29867__auto___34713]));

var G__34714 = (i__29867__auto___34713 + (1));
i__29867__auto___34713 = G__34714;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((3) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((3)),(0),null)):null);
return imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29874__auto__);
});

imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic = (function (service,query,path,p__34638){
var vec__34639 = p__34638;
var limit = cljs.core.nth.call(null,vec__34639,(0),null);
var return_chan = cljs.core.async.chan.call(null);
var c__31675__auto___34715 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___34715,return_chan,vec__34639,limit){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___34715,return_chan,vec__34639,limit){
return (function (state_34689){
var state_val_34690 = (state_34689[(1)]);
if((state_val_34690 === (7))){
var state_34689__$1 = state_34689;
var statearr_34691_34716 = state_34689__$1;
(statearr_34691_34716[(2)] = false);

(statearr_34691_34716[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34690 === (1))){
var inst_34643 = [new cljs.core.Keyword(null,"summaryPath","summaryPath",599411983),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_34644 = [path,(1),"jsonrows"];
var inst_34645 = cljs.core.PersistentHashMap.fromArrays(inst_34643,inst_34644);
var inst_34646 = imcljs.fetch.rows.call(null,service,query,inst_34645);
var state_34689__$1 = state_34689;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34689__$1,(2),inst_34646);
} else {
if((state_val_34690 === (4))){
var state_34689__$1 = state_34689;
var statearr_34692_34717 = state_34689__$1;
(statearr_34692_34717[(2)] = false);

(statearr_34692_34717[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34690 === (15))){
var inst_34682 = (state_34689[(2)]);
var state_34689__$1 = state_34689;
var statearr_34693_34718 = state_34689__$1;
(statearr_34693_34718[(2)] = inst_34682);

(statearr_34693_34718[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34690 === (13))){
var state_34689__$1 = state_34689;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34689__$1,(17),return_chan,false);
} else {
if((state_val_34690 === (6))){
var state_34689__$1 = state_34689;
var statearr_34694_34719 = state_34689__$1;
(statearr_34694_34719[(2)] = true);

(statearr_34694_34719[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34690 === (17))){
var inst_34685 = (state_34689[(2)]);
var state_34689__$1 = state_34689;
var statearr_34695_34720 = state_34689__$1;
(statearr_34695_34720[(2)] = inst_34685);

(statearr_34695_34720[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34690 === (3))){
var inst_34648 = (state_34689[(7)]);
var inst_34653 = inst_34648.cljs$lang$protocol_mask$partition0$;
var inst_34654 = (inst_34653 & (64));
var inst_34655 = inst_34648.cljs$core$ISeq$;
var inst_34656 = (cljs.core.PROTOCOL_SENTINEL === inst_34655);
var inst_34657 = (inst_34654) || (inst_34656);
var state_34689__$1 = state_34689;
if(cljs.core.truth_(inst_34657)){
var statearr_34696_34721 = state_34689__$1;
(statearr_34696_34721[(1)] = (6));

} else {
var statearr_34697_34722 = state_34689__$1;
(statearr_34697_34722[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34690 === (12))){
var inst_34675 = [new cljs.core.Keyword(null,"summaryPath","summaryPath",599411983),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_34676 = [path,limit,"jsonrows"];
var inst_34677 = cljs.core.PersistentHashMap.fromArrays(inst_34675,inst_34676);
var inst_34678 = imcljs.fetch.rows.call(null,service,query,inst_34677);
var state_34689__$1 = state_34689;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34689__$1,(16),inst_34678);
} else {
if((state_val_34690 === (2))){
var inst_34648 = (state_34689[(7)]);
var inst_34648__$1 = (state_34689[(2)]);
var inst_34650 = (inst_34648__$1 == null);
var inst_34651 = cljs.core.not.call(null,inst_34650);
var state_34689__$1 = (function (){var statearr_34698 = state_34689;
(statearr_34698[(7)] = inst_34648__$1);

return statearr_34698;
})();
if(inst_34651){
var statearr_34699_34723 = state_34689__$1;
(statearr_34699_34723[(1)] = (3));

} else {
var statearr_34700_34724 = state_34689__$1;
(statearr_34700_34724[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34690 === (11))){
var inst_34669 = (state_34689[(2)]);
var inst_34670 = cljs.core.get.call(null,inst_34669,new cljs.core.Keyword(null,"uniqueValues","uniqueValues",1661070646));
var inst_34671 = cljs.core.not.call(null,limit);
var inst_34672 = (inst_34670 <= limit);
var inst_34673 = (inst_34671) || (inst_34672);
var state_34689__$1 = state_34689;
if(cljs.core.truth_(inst_34673)){
var statearr_34701_34725 = state_34689__$1;
(statearr_34701_34725[(1)] = (12));

} else {
var statearr_34702_34726 = state_34689__$1;
(statearr_34702_34726[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34690 === (9))){
var inst_34648 = (state_34689[(7)]);
var inst_34666 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34648);
var state_34689__$1 = state_34689;
var statearr_34703_34727 = state_34689__$1;
(statearr_34703_34727[(2)] = inst_34666);

(statearr_34703_34727[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34690 === (5))){
var inst_34664 = (state_34689[(2)]);
var state_34689__$1 = state_34689;
if(cljs.core.truth_(inst_34664)){
var statearr_34704_34728 = state_34689__$1;
(statearr_34704_34728[(1)] = (9));

} else {
var statearr_34705_34729 = state_34689__$1;
(statearr_34705_34729[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34690 === (14))){
var inst_34687 = (state_34689[(2)]);
var state_34689__$1 = state_34689;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34689__$1,inst_34687);
} else {
if((state_val_34690 === (16))){
var inst_34680 = (state_34689[(2)]);
var state_34689__$1 = state_34689;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34689__$1,(15),return_chan,inst_34680);
} else {
if((state_val_34690 === (10))){
var inst_34648 = (state_34689[(7)]);
var state_34689__$1 = state_34689;
var statearr_34706_34730 = state_34689__$1;
(statearr_34706_34730[(2)] = inst_34648);

(statearr_34706_34730[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34690 === (8))){
var inst_34661 = (state_34689[(2)]);
var state_34689__$1 = state_34689;
var statearr_34707_34731 = state_34689__$1;
(statearr_34707_34731[(2)] = inst_34661);

(statearr_34707_34731[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___34715,return_chan,vec__34639,limit))
;
return ((function (switch__31585__auto__,c__31675__auto___34715,return_chan,vec__34639,limit){
return (function() {
var imcljs$fetch$state_machine__31586__auto__ = null;
var imcljs$fetch$state_machine__31586__auto____0 = (function (){
var statearr_34708 = [null,null,null,null,null,null,null,null];
(statearr_34708[(0)] = imcljs$fetch$state_machine__31586__auto__);

(statearr_34708[(1)] = (1));

return statearr_34708;
});
var imcljs$fetch$state_machine__31586__auto____1 = (function (state_34689){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_34689);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e34709){if((e34709 instanceof Object)){
var ex__31589__auto__ = e34709;
var statearr_34710_34732 = state_34689;
(statearr_34710_34732[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34689);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34709;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34733 = state_34689;
state_34689 = G__34733;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
imcljs$fetch$state_machine__31586__auto__ = function(state_34689){
switch(arguments.length){
case 0:
return imcljs$fetch$state_machine__31586__auto____0.call(this);
case 1:
return imcljs$fetch$state_machine__31586__auto____1.call(this,state_34689);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
imcljs$fetch$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$state_machine__31586__auto____0;
imcljs$fetch$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$state_machine__31586__auto____1;
return imcljs$fetch$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___34715,return_chan,vec__34639,limit))
})();
var state__31677__auto__ = (function (){var statearr_34711 = f__31676__auto__.call(null);
(statearr_34711[(6)] = c__31675__auto___34715);

return statearr_34711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___34715,return_chan,vec__34639,limit))
);


return return_chan;
});

imcljs.fetch.unique_values.cljs$lang$maxFixedArity = (3);

imcljs.fetch.unique_values.cljs$lang$applyTo = (function (seq34634){
var G__34635 = cljs.core.first.call(null,seq34634);
var seq34634__$1 = cljs.core.next.call(null,seq34634);
var G__34636 = cljs.core.first.call(null,seq34634__$1);
var seq34634__$2 = cljs.core.next.call(null,seq34634__$1);
var G__34637 = cljs.core.first.call(null,seq34634__$2);
var seq34634__$3 = cljs.core.next.call(null,seq34634__$2);
return imcljs.fetch.unique_values.cljs$core$IFn$_invoke$arity$variadic(G__34635,G__34636,G__34637,seq34634__$3);
});

imcljs.fetch.lists = (function imcljs$fetch$lists(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34740 = arguments.length;
var i__29867__auto___34741 = (0);
while(true){
if((i__29867__auto___34741 < len__29866__auto___34740)){
args__29873__auto__.push((arguments[i__29867__auto___34741]));

var G__34742 = (i__29867__auto___34741 + (1));
i__29867__auto___34741 = G__34742;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__34736){
var vec__34737 = p__34736;
var options = cljs.core.nth.call(null,vec__34737,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,options,new cljs.core.Keyword(null,"lists","lists",-884730684));
});

imcljs.fetch.lists.cljs$lang$maxFixedArity = (1);

imcljs.fetch.lists.cljs$lang$applyTo = (function (seq34734){
var G__34735 = cljs.core.first.call(null,seq34734);
var seq34734__$1 = cljs.core.next.call(null,seq34734);
return imcljs.fetch.lists.cljs$core$IFn$_invoke$arity$variadic(G__34735,seq34734__$1);
});

imcljs.fetch.one_list = (function imcljs$fetch$one_list(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34750 = arguments.length;
var i__29867__auto___34751 = (0);
while(true){
if((i__29867__auto___34751 < len__29866__auto___34750)){
args__29873__auto__.push((arguments[i__29867__auto___34751]));

var G__34752 = (i__29867__auto___34751 + (1));
i__29867__auto___34751 = G__34752;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic = (function (service,name,p__34746){
var vec__34747 = p__34746;
var options = cljs.core.nth.call(null,vec__34747,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/lists",service,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"name","name",1843675177),name], null),options),cljs.core.comp.call(null,cljs.core.first,new cljs.core.Keyword(null,"lists","lists",-884730684)));
});

imcljs.fetch.one_list.cljs$lang$maxFixedArity = (2);

imcljs.fetch.one_list.cljs$lang$applyTo = (function (seq34743){
var G__34744 = cljs.core.first.call(null,seq34743);
var seq34743__$1 = cljs.core.next.call(null,seq34743);
var G__34745 = cljs.core.first.call(null,seq34743__$1);
var seq34743__$2 = cljs.core.next.call(null,seq34743__$1);
return imcljs.fetch.one_list.cljs$core$IFn$_invoke$arity$variadic(G__34744,G__34745,seq34743__$2);
});

imcljs.fetch.model = (function imcljs$fetch$model(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34759 = arguments.length;
var i__29867__auto___34760 = (0);
while(true){
if((i__29867__auto___34760 < len__29866__auto___34759)){
args__29873__auto__.push((arguments[i__29867__auto___34760]));

var G__34761 = (i__29867__auto___34760 + (1));
i__29867__auto___34760 = G__34761;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__34755){
var vec__34756 = p__34755;
var options = cljs.core.nth.call(null,vec__34756,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/model",service,options,new cljs.core.Keyword(null,"model","model",331153215));
});

imcljs.fetch.model.cljs$lang$maxFixedArity = (1);

imcljs.fetch.model.cljs$lang$applyTo = (function (seq34753){
var G__34754 = cljs.core.first.call(null,seq34753);
var seq34753__$1 = cljs.core.next.call(null,seq34753);
return imcljs.fetch.model.cljs$core$IFn$_invoke$arity$variadic(G__34754,seq34753__$1);
});

imcljs.fetch.class_keys = (function imcljs$fetch$class_keys(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34768 = arguments.length;
var i__29867__auto___34769 = (0);
while(true){
if((i__29867__auto___34769 < len__29866__auto___34768)){
args__29873__auto__.push((arguments[i__29867__auto___34769]));

var G__34770 = (i__29867__auto___34769 + (1));
i__29867__auto___34769 = G__34770;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__34764){
var vec__34765 = p__34764;
var options = cljs.core.nth.call(null,vec__34765,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/classkeys",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.class_keys.cljs$lang$maxFixedArity = (1);

imcljs.fetch.class_keys.cljs$lang$applyTo = (function (seq34762){
var G__34763 = cljs.core.first.call(null,seq34762);
var seq34762__$1 = cljs.core.next.call(null,seq34762);
return imcljs.fetch.class_keys.cljs$core$IFn$_invoke$arity$variadic(G__34763,seq34762__$1);
});

imcljs.fetch.summary_fields = (function imcljs$fetch$summary_fields(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34777 = arguments.length;
var i__29867__auto___34778 = (0);
while(true){
if((i__29867__auto___34778 < len__29866__auto___34777)){
args__29873__auto__.push((arguments[i__29867__auto___34778]));

var G__34779 = (i__29867__auto___34778 + (1));
i__29867__auto___34778 = G__34779;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__34773){
var vec__34774 = p__34773;
var options = cljs.core.nth.call(null,vec__34774,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/summaryfields",service,options,new cljs.core.Keyword(null,"classes","classes",2037804510));
});

imcljs.fetch.summary_fields.cljs$lang$maxFixedArity = (1);

imcljs.fetch.summary_fields.cljs$lang$applyTo = (function (seq34771){
var G__34772 = cljs.core.first.call(null,seq34771);
var seq34771__$1 = cljs.core.next.call(null,seq34771);
return imcljs.fetch.summary_fields.cljs$core$IFn$_invoke$arity$variadic(G__34772,seq34771__$1);
});

imcljs.fetch.templates = (function imcljs$fetch$templates(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34786 = arguments.length;
var i__29867__auto___34787 = (0);
while(true){
if((i__29867__auto___34787 < len__29866__auto___34786)){
args__29873__auto__.push((arguments[i__29867__auto___34787]));

var G__34788 = (i__29867__auto___34787 + (1));
i__29867__auto___34787 = G__34788;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__34782){
var vec__34783 = p__34782;
var options = cljs.core.nth.call(null,vec__34783,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/templates",service,options,new cljs.core.Keyword(null,"templates","templates",-1237401733));
});

imcljs.fetch.templates.cljs$lang$maxFixedArity = (1);

imcljs.fetch.templates.cljs$lang$applyTo = (function (seq34780){
var G__34781 = cljs.core.first.call(null,seq34780);
var seq34780__$1 = cljs.core.next.call(null,seq34780);
return imcljs.fetch.templates.cljs$core$IFn$_invoke$arity$variadic(G__34781,seq34780__$1);
});

/**
 * Returns a temporary API token.
 */
imcljs.fetch.session = (function imcljs$fetch$session(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34795 = arguments.length;
var i__29867__auto___34796 = (0);
while(true){
if((i__29867__auto___34796 < len__29866__auto___34795)){
args__29873__auto__.push((arguments[i__29867__auto___34796]));

var G__34797 = (i__29867__auto___34796 + (1));
i__29867__auto___34796 = G__34797;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__34791){
var vec__34792 = p__34791;
var options = cljs.core.nth.call(null,vec__34792,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/session",service,options,new cljs.core.Keyword(null,"token","token",-1211463215));
});

imcljs.fetch.session.cljs$lang$maxFixedArity = (1);

imcljs.fetch.session.cljs$lang$applyTo = (function (seq34789){
var G__34790 = cljs.core.first.call(null,seq34789);
var seq34789__$1 = cljs.core.next.call(null,seq34789);
return imcljs.fetch.session.cljs$core$IFn$_invoke$arity$variadic(G__34790,seq34789__$1);
});

/**
 * Returns list of widgets available for a given mine
 */
imcljs.fetch.widgets = (function imcljs$fetch$widgets(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34804 = arguments.length;
var i__29867__auto___34805 = (0);
while(true){
if((i__29867__auto___34805 < len__29866__auto___34804)){
args__29873__auto__.push((arguments[i__29867__auto___34805]));

var G__34806 = (i__29867__auto___34805 + (1));
i__29867__auto___34805 = G__34806;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__34800){
var vec__34801 = p__34800;
var options = cljs.core.nth.call(null,vec__34801,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/widgets",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null),new cljs.core.Keyword(null,"widgets","widgets",-159098978));
});

imcljs.fetch.widgets.cljs$lang$maxFixedArity = (1);

imcljs.fetch.widgets.cljs$lang$applyTo = (function (seq34798){
var G__34799 = cljs.core.first.call(null,seq34798);
var seq34798__$1 = cljs.core.next.call(null,seq34798);
return imcljs.fetch.widgets.cljs$core$IFn$_invoke$arity$variadic(G__34799,seq34798__$1);
});

/**
 * Returns enrichment results
 */
imcljs.fetch.enrichment = (function imcljs$fetch$enrichment(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34813 = arguments.length;
var i__29867__auto___34814 = (0);
while(true){
if((i__29867__auto___34814 < len__29866__auto___34813)){
args__29873__auto__.push((arguments[i__29867__auto___34814]));

var G__34815 = (i__29867__auto___34814 + (1));
i__29867__auto___34814 = G__34815;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic = (function (service,p__34809){
var vec__34810 = p__34809;
var options = cljs.core.nth.call(null,vec__34810,(0),null);
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post","post",269697687),"/list/enrichment",service,cljs.core.merge.call(null,imcljs.internal.defaults.default_enrichment,options));
});

imcljs.fetch.enrichment.cljs$lang$maxFixedArity = (1);

imcljs.fetch.enrichment.cljs$lang$applyTo = (function (seq34807){
var G__34808 = cljs.core.first.call(null,seq34807);
var seq34807__$1 = cljs.core.next.call(null,seq34807);
return imcljs.fetch.enrichment.cljs$core$IFn$_invoke$arity$variadic(G__34808,seq34807__$1);
});

/**
 * Returns the version of the InterMine WebService being run, e.g. '27'
 */
imcljs.fetch.version_web_service = (function imcljs$fetch$version_web_service(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
imcljs.fetch.version_release = (function imcljs$fetch$version_release(service){

return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/release",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the version of InterMine being run, e.g. '1.6.6'
 */
imcljs.fetch.version_intermine = (function imcljs$fetch$version_intermine(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/version/intermine",service,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"text"], null));
});
/**
 * Returns the default configs for a given mine. These are important as they're
 * used to initialise most bluegenes page sections! 
 */
imcljs.fetch.web_properties = (function imcljs$fetch$web_properties(service){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/web-properties",service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"web-properties","web-properties",-1421911737));
});
/**
 * Fetches the results of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_results = (function imcljs$fetch$fetch_id_resolution_job_results(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("/ids/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/results")].join(''),service,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"results","results",-1134170113));
});
/**
 * Fetches the status of an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job_status = (function imcljs$fetch$fetch_id_resolution_job_status(service,uid){
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("/ids/"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(uid),cljs.core.str.cljs$core$IFn$_invoke$arity$1("/status")].join(''),service);
});
/**
 * Starts an id resolution job
 */
imcljs.fetch.fetch_id_resolution_job = (function imcljs$fetch$fetch_id_resolution_job(service,p__34816){
var map__34817 = p__34816;
var map__34817__$1 = ((((!((map__34817 == null)))?((((map__34817.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34817.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34817):map__34817);
var options = map__34817__$1;
var identifiers = cljs.core.get.call(null,map__34817__$1,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722));
var type = cljs.core.get.call(null,map__34817__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__34817__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var wild_cards = cljs.core.get.call(null,map__34817__$1,new cljs.core.Keyword(null,"wild-cards","wild-cards",681119344));
var extra = cljs.core.get.call(null,map__34817__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"post-body","post-body",-1481559189),"/ids",service,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"body","body",-2049205669),(function (){var G__34819 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722),identifiers], null);
var G__34819__$1 = (cljs.core.truth_(type)?cljs.core.assoc.call(null,G__34819,new cljs.core.Keyword(null,"type","type",1174270348),type):G__34819);
var G__34819__$2 = (cljs.core.truth_(case_sensitive)?cljs.core.assoc.call(null,G__34819__$1,new cljs.core.Keyword(null,"caseSensitive","caseSensitive",-586669673),true):G__34819__$1);
var G__34819__$3 = (cljs.core.truth_(wild_cards)?cljs.core.assoc.call(null,G__34819__$2,new cljs.core.Keyword(null,"wildCards","wildCards",-2054689560),true):G__34819__$2);
if(cljs.core.truth_(extra)){
return cljs.core.assoc.call(null,G__34819__$3,new cljs.core.Keyword(null,"extra","extra",1612569067),extra);
} else {
return G__34819__$3;
}
})(),new cljs.core.Keyword(null,"headers","headers",-835030129),new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null)], null));
});
/**
 * Resolves identifiers. Automatically handles polling
 */
imcljs.fetch.resolve_identifiers = (function imcljs$fetch$resolve_identifiers(service,p__34820){
var map__34821 = p__34820;
var map__34821__$1 = ((((!((map__34821 == null)))?((((map__34821.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34821.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34821):map__34821);
var options = map__34821__$1;
var identifiers = cljs.core.get.call(null,map__34821__$1,new cljs.core.Keyword(null,"identifiers","identifiers",-2057597722));
var type = cljs.core.get.call(null,map__34821__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__34821__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var wild_cards = cljs.core.get.call(null,map__34821__$1,new cljs.core.Keyword(null,"wild-cards","wild-cards",681119344));
var extra = cljs.core.get.call(null,map__34821__$1,new cljs.core.Keyword(null,"extra","extra",1612569067));
var timeout_ms = cljs.core.get.call(null,map__34821__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var return_chan = cljs.core.async.chan.call(null,(1));
var c__31675__auto___34933 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (state_34891){
var state_val_34892 = (state_34891[(1)]);
if((state_val_34892 === (1))){
var inst_34823 = imcljs.fetch.fetch_id_resolution_job.call(null,service,options);
var state_34891__$1 = state_34891;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34891__$1,(2),inst_34823);
} else {
if((state_val_34892 === (2))){
var inst_34825 = (state_34891[(2)]);
var inst_34887 = cljs.core.async.chan.call(null,(1));
var inst_34888 = (function (){var job = inst_34825;
var c__31675__auto____$1 = inst_34887;
return ((function (job,c__31675__auto____$1,inst_34825,inst_34887,state_val_34892,c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (job,c__31675__auto____$1,inst_34825,inst_34887,state_val_34892,c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function (state_34885){
var state_val_34886 = (state_34885[(1)]);
if((state_val_34886 === (7))){
var inst_34848 = (state_34885[(2)]);
var state_34885__$1 = state_34885;
if(cljs.core.truth_(inst_34848)){
var statearr_34893_34934 = state_34885__$1;
(statearr_34893_34934[(1)] = (11));

} else {
var statearr_34894_34935 = state_34885__$1;
(statearr_34894_34935[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (20))){
var state_34885__$1 = state_34885;
var statearr_34895_34936 = state_34885__$1;
(statearr_34895_34936[(2)] = timeout_ms);

(statearr_34895_34936[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (1))){
var inst_34826 = (100);
var state_34885__$1 = (function (){var statearr_34896 = state_34885;
(statearr_34896[(7)] = inst_34826);

return statearr_34896;
})();
var statearr_34897_34937 = state_34885__$1;
(statearr_34897_34937[(2)] = null);

(statearr_34897_34937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (24))){
var state_34885__$1 = state_34885;
var statearr_34898_34938 = state_34885__$1;
(statearr_34898_34938[(2)] = null);

(statearr_34898_34938[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (4))){
var inst_34832 = (state_34885[(8)]);
var inst_34832__$1 = (state_34885[(2)]);
var inst_34834 = (inst_34832__$1 == null);
var inst_34835 = cljs.core.not.call(null,inst_34834);
var state_34885__$1 = (function (){var statearr_34899 = state_34885;
(statearr_34899[(8)] = inst_34832__$1);

return statearr_34899;
})();
if(inst_34835){
var statearr_34900_34939 = state_34885__$1;
(statearr_34900_34939[(1)] = (5));

} else {
var statearr_34901_34940 = state_34885__$1;
(statearr_34901_34940[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (15))){
var inst_34826 = (state_34885[(7)]);
var inst_34865 = cljs.core.async.timeout.call(null,inst_34826);
var state_34885__$1 = state_34885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34885__$1,(19),inst_34865);
} else {
if((state_val_34886 === (21))){
var state_34885__$1 = state_34885;
var statearr_34902_34941 = state_34885__$1;
(statearr_34902_34941[(2)] = (30000));

(statearr_34902_34941[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (13))){
var inst_34853 = (state_34885[(2)]);
var inst_34854 = cljs.core.get.call(null,inst_34853,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_34855 = cljs.core.get.call(null,inst_34853,new cljs.core.Keyword(null,"uid","uid",-1447769400));
var inst_34856 = cljs.core._EQ_.call(null,"SUCCESS",inst_34854);
var state_34885__$1 = (function (){var statearr_34903 = state_34885;
(statearr_34903[(9)] = inst_34855);

return statearr_34903;
})();
if(inst_34856){
var statearr_34904_34942 = state_34885__$1;
(statearr_34904_34942[(1)] = (14));

} else {
var statearr_34905_34943 = state_34885__$1;
(statearr_34905_34943[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (22))){
var inst_34826 = (state_34885[(7)]);
var inst_34871 = (state_34885[(2)]);
var inst_34872 = (inst_34826 < inst_34871);
var state_34885__$1 = state_34885;
if(cljs.core.truth_(inst_34872)){
var statearr_34906_34944 = state_34885__$1;
(statearr_34906_34944[(1)] = (23));

} else {
var statearr_34907_34945 = state_34885__$1;
(statearr_34907_34945[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (6))){
var state_34885__$1 = state_34885;
var statearr_34908_34946 = state_34885__$1;
(statearr_34908_34946[(2)] = false);

(statearr_34908_34946[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (25))){
var inst_34879 = (state_34885[(2)]);
var state_34885__$1 = state_34885;
var statearr_34909_34947 = state_34885__$1;
(statearr_34909_34947[(2)] = inst_34879);

(statearr_34909_34947[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (17))){
var inst_34861 = (state_34885[(2)]);
var state_34885__$1 = state_34885;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_34885__$1,(18),return_chan,inst_34861);
} else {
if((state_val_34886 === (3))){
var inst_34883 = (state_34885[(2)]);
var state_34885__$1 = state_34885;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34885__$1,inst_34883);
} else {
if((state_val_34886 === (12))){
var inst_34832 = (state_34885[(8)]);
var state_34885__$1 = state_34885;
var statearr_34910_34948 = state_34885__$1;
(statearr_34910_34948[(2)] = inst_34832);

(statearr_34910_34948[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (2))){
var inst_34829 = new cljs.core.Keyword(null,"uid","uid",-1447769400).cljs$core$IFn$_invoke$arity$1(job);
var inst_34830 = imcljs.fetch.fetch_id_resolution_job_status.call(null,service,inst_34829);
var state_34885__$1 = state_34885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34885__$1,(4),inst_34830);
} else {
if((state_val_34886 === (23))){
var inst_34826 = (state_34885[(7)]);
var inst_34874 = (inst_34826 * 1.5);
var inst_34875 = (((1000) < inst_34874) ? (1000) : inst_34874);
var inst_34826__$1 = inst_34875;
var state_34885__$1 = (function (){var statearr_34911 = state_34885;
(statearr_34911[(7)] = inst_34826__$1);

return statearr_34911;
})();
var statearr_34912_34949 = state_34885__$1;
(statearr_34912_34949[(2)] = null);

(statearr_34912_34949[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (19))){
var inst_34867 = (state_34885[(2)]);
var state_34885__$1 = (function (){var statearr_34913 = state_34885;
(statearr_34913[(10)] = inst_34867);

return statearr_34913;
})();
if(cljs.core.truth_(timeout_ms)){
var statearr_34914_34950 = state_34885__$1;
(statearr_34914_34950[(1)] = (20));

} else {
var statearr_34915_34951 = state_34885__$1;
(statearr_34915_34951[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (11))){
var inst_34832 = (state_34885[(8)]);
var inst_34850 = cljs.core.apply.call(null,cljs.core.hash_map,inst_34832);
var state_34885__$1 = state_34885;
var statearr_34916_34952 = state_34885__$1;
(statearr_34916_34952[(2)] = inst_34850);

(statearr_34916_34952[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (9))){
var state_34885__$1 = state_34885;
var statearr_34917_34953 = state_34885__$1;
(statearr_34917_34953[(2)] = false);

(statearr_34917_34953[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (5))){
var inst_34832 = (state_34885[(8)]);
var inst_34837 = inst_34832.cljs$lang$protocol_mask$partition0$;
var inst_34838 = (inst_34837 & (64));
var inst_34839 = inst_34832.cljs$core$ISeq$;
var inst_34840 = (cljs.core.PROTOCOL_SENTINEL === inst_34839);
var inst_34841 = (inst_34838) || (inst_34840);
var state_34885__$1 = state_34885;
if(cljs.core.truth_(inst_34841)){
var statearr_34918_34954 = state_34885__$1;
(statearr_34918_34954[(1)] = (8));

} else {
var statearr_34919_34955 = state_34885__$1;
(statearr_34919_34955[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (14))){
var inst_34858 = new cljs.core.Keyword(null,"uid","uid",-1447769400).cljs$core$IFn$_invoke$arity$1(job);
var inst_34859 = imcljs.fetch.fetch_id_resolution_job_results.call(null,service,inst_34858);
var state_34885__$1 = state_34885;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_34885__$1,(17),inst_34859);
} else {
if((state_val_34886 === (16))){
var inst_34881 = (state_34885[(2)]);
var state_34885__$1 = state_34885;
var statearr_34920_34956 = state_34885__$1;
(statearr_34920_34956[(2)] = inst_34881);

(statearr_34920_34956[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (10))){
var inst_34845 = (state_34885[(2)]);
var state_34885__$1 = state_34885;
var statearr_34921_34957 = state_34885__$1;
(statearr_34921_34957[(2)] = inst_34845);

(statearr_34921_34957[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (18))){
var inst_34863 = (state_34885[(2)]);
var state_34885__$1 = state_34885;
var statearr_34922_34958 = state_34885__$1;
(statearr_34922_34958[(2)] = inst_34863);

(statearr_34922_34958[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_34886 === (8))){
var state_34885__$1 = state_34885;
var statearr_34923_34959 = state_34885__$1;
(statearr_34923_34959[(2)] = true);

(statearr_34923_34959[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(job,c__31675__auto____$1,inst_34825,inst_34887,state_val_34892,c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
;
return ((function (switch__31585__auto__,job,c__31675__auto____$1,inst_34825,inst_34887,state_val_34892,c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function() {
var imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__ = null;
var imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____0 = (function (){
var statearr_34924 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34924[(0)] = imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__);

(statearr_34924[(1)] = (1));

return statearr_34924;
});
var imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____1 = (function (state_34885){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_34885);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e34925){if((e34925 instanceof Object)){
var ex__31589__auto__ = e34925;
var statearr_34926_34960 = state_34885;
(statearr_34926_34960[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34885);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34925;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34961 = state_34885;
state_34885 = G__34961;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__ = function(state_34885){
switch(arguments.length){
case 0:
return imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____0.call(this);
case 1:
return imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____1.call(this,state_34885);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____0;
imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____1;
return imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__;
})()
;})(switch__31585__auto__,job,c__31675__auto____$1,inst_34825,inst_34887,state_val_34892,c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var state__31677__auto__ = (function (){var statearr_34927 = f__31676__auto__.call(null);
(statearr_34927[(6)] = c__31675__auto____$1);

return statearr_34927;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});
;})(job,c__31675__auto____$1,inst_34825,inst_34887,state_val_34892,c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var inst_34889 = cljs.core.async.impl.dispatch.run.call(null,inst_34888);
var state_34891__$1 = (function (){var statearr_34928 = state_34891;
(statearr_34928[(7)] = inst_34889);

return statearr_34928;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_34891__$1,inst_34887);
} else {
return null;
}
}
});})(c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
;
return ((function (switch__31585__auto__,c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms){
return (function() {
var imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__ = null;
var imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____0 = (function (){
var statearr_34929 = [null,null,null,null,null,null,null,null];
(statearr_34929[(0)] = imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__);

(statearr_34929[(1)] = (1));

return statearr_34929;
});
var imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____1 = (function (state_34891){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_34891);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e34930){if((e34930 instanceof Object)){
var ex__31589__auto__ = e34930;
var statearr_34931_34962 = state_34891;
(statearr_34931_34962[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_34891);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e34930;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__34963 = state_34891;
state_34891 = G__34963;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__ = function(state_34891){
switch(arguments.length){
case 0:
return imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____0.call(this);
case 1:
return imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____1.call(this,state_34891);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____0;
imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto____1;
return imcljs$fetch$resolve_identifiers_$_state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
})();
var state__31677__auto__ = (function (){var statearr_34932 = f__31676__auto__.call(null);
(statearr_34932[(6)] = c__31675__auto___34933);

return statearr_34932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___34933,return_chan,map__34821,map__34821__$1,options,identifiers,type,case_sensitive,wild_cards,extra,timeout_ms))
);


return return_chan;
});
/**
 * Returns generate code to run the query in a given language
 */
imcljs.fetch.code = (function imcljs$fetch$code(var_args){
var args__29873__auto__ = [];
var len__29866__auto___34973 = arguments.length;
var i__29867__auto___34974 = (0);
while(true){
if((i__29867__auto___34974 < len__29866__auto___34973)){
args__29873__auto__.push((arguments[i__29867__auto___34974]));

var G__34975 = (i__29867__auto___34974 + (1));
i__29867__auto___34974 = G__34975;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((2) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((2)),(0),null)):null);
return imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__29874__auto__);
});

imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic = (function (service,model,p__34967){
var vec__34968 = p__34967;
var map__34971 = cljs.core.nth.call(null,vec__34968,(0),null);
var map__34971__$1 = ((((!((map__34971 == null)))?((((map__34971.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34971.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__34971):map__34971);
var options = map__34971__$1;
var lang = cljs.core.get.call(null,map__34971__$1,new cljs.core.Keyword(null,"lang","lang",-1819677104));
var query = cljs.core.get.call(null,map__34971__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
return imcljs.internal.io.restful.call(null,new cljs.core.Keyword(null,"get","get",1683182755),"/query/code",service,cljs.core.update.call(null,cljs.core.merge.call(null,options,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"format","format",-1306924766),"json"], null)),new cljs.core.Keyword(null,"query","query",-1288509510),cljs.core.partial.call(null,imcljs.query.__GT_xml,model)),new cljs.core.Keyword(null,"code","code",1586293142));
});

imcljs.fetch.code.cljs$lang$maxFixedArity = (2);

imcljs.fetch.code.cljs$lang$applyTo = (function (seq34964){
var G__34965 = cljs.core.first.call(null,seq34964);
var seq34964__$1 = cljs.core.next.call(null,seq34964);
var G__34966 = cljs.core.first.call(null,seq34964__$1);
var seq34964__$2 = cljs.core.next.call(null,seq34964__$1);
return imcljs.fetch.code.cljs$core$IFn$_invoke$arity$variadic(G__34965,G__34966,seq34964__$2);
});


//# sourceMappingURL=fetch.js.map