// Compiled by ClojureScript 1.9.671 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__31735 = arguments.length;
switch (G__31735) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async31736 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31736 = (function (f,blockable,meta31737){
this.f = f;
this.blockable = blockable;
this.meta31737 = meta31737;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31736.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31738,meta31737__$1){
var self__ = this;
var _31738__$1 = this;
return (new cljs.core.async.t_cljs$core$async31736(self__.f,self__.blockable,meta31737__$1));
});

cljs.core.async.t_cljs$core$async31736.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31738){
var self__ = this;
var _31738__$1 = this;
return self__.meta31737;
});

cljs.core.async.t_cljs$core$async31736.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31736.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31736.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async31736.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async31736.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta31737","meta31737",-1390292890,null)], null);
});

cljs.core.async.t_cljs$core$async31736.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31736.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31736";

cljs.core.async.t_cljs$core$async31736.cljs$lang$ctorPrWriter = (function (this__29290__auto__,writer__29291__auto__,opt__29292__auto__){
return cljs.core._write.call(null,writer__29291__auto__,"cljs.core.async/t_cljs$core$async31736");
});

cljs.core.async.__GT_t_cljs$core$async31736 = (function cljs$core$async$__GT_t_cljs$core$async31736(f__$1,blockable__$1,meta31737){
return (new cljs.core.async.t_cljs$core$async31736(f__$1,blockable__$1,meta31737));
});

}

return (new cljs.core.async.t_cljs$core$async31736(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__31742 = arguments.length;
switch (G__31742) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__31745 = arguments.length;
switch (G__31745) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__31748 = arguments.length;
switch (G__31748) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_31750 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_31750);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_31750,ret){
return (function (){
return fn1.call(null,val_31750);
});})(val_31750,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__31752 = arguments.length;
switch (G__31752) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5276__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5276__auto__)){
var ret = temp__5276__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5276__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5276__auto__)){
var retb = temp__5276__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5276__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5276__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__29655__auto___31754 = n;
var x_31755 = (0);
while(true){
if((x_31755 < n__29655__auto___31754)){
(a[x_31755] = (0));

var G__31756 = (x_31755 + (1));
x_31755 = G__31756;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__31757 = (i + (1));
i = G__31757;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async31758 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31758 = (function (flag,meta31759){
this.flag = flag;
this.meta31759 = meta31759;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31758.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_31760,meta31759__$1){
var self__ = this;
var _31760__$1 = this;
return (new cljs.core.async.t_cljs$core$async31758(self__.flag,meta31759__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async31758.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_31760){
var self__ = this;
var _31760__$1 = this;
return self__.meta31759;
});})(flag))
;

cljs.core.async.t_cljs$core$async31758.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31758.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async31758.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31758.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async31758.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta31759","meta31759",-2042008783,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async31758.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31758.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31758";

cljs.core.async.t_cljs$core$async31758.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__29290__auto__,writer__29291__auto__,opt__29292__auto__){
return cljs.core._write.call(null,writer__29291__auto__,"cljs.core.async/t_cljs$core$async31758");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async31758 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async31758(flag__$1,meta31759){
return (new cljs.core.async.t_cljs$core$async31758(flag__$1,meta31759));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async31758(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async31761 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async31761 = (function (flag,cb,meta31762){
this.flag = flag;
this.cb = cb;
this.meta31762 = meta31762;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async31761.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_31763,meta31762__$1){
var self__ = this;
var _31763__$1 = this;
return (new cljs.core.async.t_cljs$core$async31761(self__.flag,self__.cb,meta31762__$1));
});

cljs.core.async.t_cljs$core$async31761.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_31763){
var self__ = this;
var _31763__$1 = this;
return self__.meta31762;
});

cljs.core.async.t_cljs$core$async31761.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async31761.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async31761.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async31761.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async31761.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta31762","meta31762",31438442,null)], null);
});

cljs.core.async.t_cljs$core$async31761.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async31761.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async31761";

cljs.core.async.t_cljs$core$async31761.cljs$lang$ctorPrWriter = (function (this__29290__auto__,writer__29291__auto__,opt__29292__auto__){
return cljs.core._write.call(null,writer__29291__auto__,"cljs.core.async/t_cljs$core$async31761");
});

cljs.core.async.__GT_t_cljs$core$async31761 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async31761(flag__$1,cb__$1,meta31762){
return (new cljs.core.async.t_cljs$core$async31761(flag__$1,cb__$1,meta31762));
});

}

return (new cljs.core.async.t_cljs$core$async31761(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31764_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31764_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__31765_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__31765_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__28633__auto__ = wport;
if(cljs.core.truth_(or__28633__auto__)){
return or__28633__auto__;
} else {
return port;
}
})()], null));
} else {
var G__31766 = (i + (1));
i = G__31766;
continue;
}
} else {
return null;
}
break;
}
})();
var or__28633__auto__ = ret;
if(cljs.core.truth_(or__28633__auto__)){
return or__28633__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5278__auto__ = (function (){var and__28621__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__28621__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__28621__auto__;
}
})();
if(cljs.core.truth_(temp__5278__auto__)){
var got = temp__5278__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__29873__auto__ = [];
var len__29866__auto___31772 = arguments.length;
var i__29867__auto___31773 = (0);
while(true){
if((i__29867__auto___31773 < len__29866__auto___31772)){
args__29873__auto__.push((arguments[i__29867__auto___31773]));

var G__31774 = (i__29867__auto___31773 + (1));
i__29867__auto___31773 = G__31774;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((1) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__29874__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__31769){
var map__31770 = p__31769;
var map__31770__$1 = ((((!((map__31770 == null)))?((((map__31770.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31770.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31770):map__31770);
var opts = map__31770__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq31767){
var G__31768 = cljs.core.first.call(null,seq31767);
var seq31767__$1 = cljs.core.next.call(null,seq31767);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__31768,seq31767__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__31776 = arguments.length;
switch (G__31776) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__31675__auto___31822 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___31822){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___31822){
return (function (state_31800){
var state_val_31801 = (state_31800[(1)]);
if((state_val_31801 === (7))){
var inst_31796 = (state_31800[(2)]);
var state_31800__$1 = state_31800;
var statearr_31802_31823 = state_31800__$1;
(statearr_31802_31823[(2)] = inst_31796);

(statearr_31802_31823[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31801 === (1))){
var state_31800__$1 = state_31800;
var statearr_31803_31824 = state_31800__$1;
(statearr_31803_31824[(2)] = null);

(statearr_31803_31824[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31801 === (4))){
var inst_31779 = (state_31800[(7)]);
var inst_31779__$1 = (state_31800[(2)]);
var inst_31780 = (inst_31779__$1 == null);
var state_31800__$1 = (function (){var statearr_31804 = state_31800;
(statearr_31804[(7)] = inst_31779__$1);

return statearr_31804;
})();
if(cljs.core.truth_(inst_31780)){
var statearr_31805_31825 = state_31800__$1;
(statearr_31805_31825[(1)] = (5));

} else {
var statearr_31806_31826 = state_31800__$1;
(statearr_31806_31826[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31801 === (13))){
var state_31800__$1 = state_31800;
var statearr_31807_31827 = state_31800__$1;
(statearr_31807_31827[(2)] = null);

(statearr_31807_31827[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31801 === (6))){
var inst_31779 = (state_31800[(7)]);
var state_31800__$1 = state_31800;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31800__$1,(11),to,inst_31779);
} else {
if((state_val_31801 === (3))){
var inst_31798 = (state_31800[(2)]);
var state_31800__$1 = state_31800;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31800__$1,inst_31798);
} else {
if((state_val_31801 === (12))){
var state_31800__$1 = state_31800;
var statearr_31808_31828 = state_31800__$1;
(statearr_31808_31828[(2)] = null);

(statearr_31808_31828[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31801 === (2))){
var state_31800__$1 = state_31800;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31800__$1,(4),from);
} else {
if((state_val_31801 === (11))){
var inst_31789 = (state_31800[(2)]);
var state_31800__$1 = state_31800;
if(cljs.core.truth_(inst_31789)){
var statearr_31809_31829 = state_31800__$1;
(statearr_31809_31829[(1)] = (12));

} else {
var statearr_31810_31830 = state_31800__$1;
(statearr_31810_31830[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31801 === (9))){
var state_31800__$1 = state_31800;
var statearr_31811_31831 = state_31800__$1;
(statearr_31811_31831[(2)] = null);

(statearr_31811_31831[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31801 === (5))){
var state_31800__$1 = state_31800;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31812_31832 = state_31800__$1;
(statearr_31812_31832[(1)] = (8));

} else {
var statearr_31813_31833 = state_31800__$1;
(statearr_31813_31833[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31801 === (14))){
var inst_31794 = (state_31800[(2)]);
var state_31800__$1 = state_31800;
var statearr_31814_31834 = state_31800__$1;
(statearr_31814_31834[(2)] = inst_31794);

(statearr_31814_31834[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31801 === (10))){
var inst_31786 = (state_31800[(2)]);
var state_31800__$1 = state_31800;
var statearr_31815_31835 = state_31800__$1;
(statearr_31815_31835[(2)] = inst_31786);

(statearr_31815_31835[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31801 === (8))){
var inst_31783 = cljs.core.async.close_BANG_.call(null,to);
var state_31800__$1 = state_31800;
var statearr_31816_31836 = state_31800__$1;
(statearr_31816_31836[(2)] = inst_31783);

(statearr_31816_31836[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___31822))
;
return ((function (switch__31585__auto__,c__31675__auto___31822){
return (function() {
var cljs$core$async$state_machine__31586__auto__ = null;
var cljs$core$async$state_machine__31586__auto____0 = (function (){
var statearr_31817 = [null,null,null,null,null,null,null,null];
(statearr_31817[(0)] = cljs$core$async$state_machine__31586__auto__);

(statearr_31817[(1)] = (1));

return statearr_31817;
});
var cljs$core$async$state_machine__31586__auto____1 = (function (state_31800){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_31800);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e31818){if((e31818 instanceof Object)){
var ex__31589__auto__ = e31818;
var statearr_31819_31837 = state_31800;
(statearr_31819_31837[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31800);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31818;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31838 = state_31800;
state_31800 = G__31838;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$state_machine__31586__auto__ = function(state_31800){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31586__auto____1.call(this,state_31800);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31586__auto____0;
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31586__auto____1;
return cljs$core$async$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___31822))
})();
var state__31677__auto__ = (function (){var statearr_31820 = f__31676__auto__.call(null);
(statearr_31820[(6)] = c__31675__auto___31822);

return statearr_31820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___31822))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__31839){
var vec__31840 = p__31839;
var v = cljs.core.nth.call(null,vec__31840,(0),null);
var p = cljs.core.nth.call(null,vec__31840,(1),null);
var job = vec__31840;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__31675__auto___32011 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___32011,res,vec__31840,v,p,job,jobs,results){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___32011,res,vec__31840,v,p,job,jobs,results){
return (function (state_31847){
var state_val_31848 = (state_31847[(1)]);
if((state_val_31848 === (1))){
var state_31847__$1 = state_31847;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31847__$1,(2),res,v);
} else {
if((state_val_31848 === (2))){
var inst_31844 = (state_31847[(2)]);
var inst_31845 = cljs.core.async.close_BANG_.call(null,res);
var state_31847__$1 = (function (){var statearr_31849 = state_31847;
(statearr_31849[(7)] = inst_31844);

return statearr_31849;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31847__$1,inst_31845);
} else {
return null;
}
}
});})(c__31675__auto___32011,res,vec__31840,v,p,job,jobs,results))
;
return ((function (switch__31585__auto__,c__31675__auto___32011,res,vec__31840,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0 = (function (){
var statearr_31850 = [null,null,null,null,null,null,null,null];
(statearr_31850[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__);

(statearr_31850[(1)] = (1));

return statearr_31850;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1 = (function (state_31847){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_31847);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e31851){if((e31851 instanceof Object)){
var ex__31589__auto__ = e31851;
var statearr_31852_32012 = state_31847;
(statearr_31852_32012[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31847);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31851;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32013 = state_31847;
state_31847 = G__32013;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__ = function(state_31847){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1.call(this,state_31847);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___32011,res,vec__31840,v,p,job,jobs,results))
})();
var state__31677__auto__ = (function (){var statearr_31853 = f__31676__auto__.call(null);
(statearr_31853[(6)] = c__31675__auto___32011);

return statearr_31853;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___32011,res,vec__31840,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__31854){
var vec__31855 = p__31854;
var v = cljs.core.nth.call(null,vec__31855,(0),null);
var p = cljs.core.nth.call(null,vec__31855,(1),null);
var job = vec__31855;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__29655__auto___32014 = n;
var __32015 = (0);
while(true){
if((__32015 < n__29655__auto___32014)){
var G__31858_32016 = type;
var G__31858_32017__$1 = (((G__31858_32016 instanceof cljs.core.Keyword))?G__31858_32016.fqn:null);
switch (G__31858_32017__$1) {
case "compute":
var c__31675__auto___32019 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__32015,c__31675__auto___32019,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (__32015,c__31675__auto___32019,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async){
return (function (state_31871){
var state_val_31872 = (state_31871[(1)]);
if((state_val_31872 === (1))){
var state_31871__$1 = state_31871;
var statearr_31873_32020 = state_31871__$1;
(statearr_31873_32020[(2)] = null);

(statearr_31873_32020[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31872 === (2))){
var state_31871__$1 = state_31871;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31871__$1,(4),jobs);
} else {
if((state_val_31872 === (3))){
var inst_31869 = (state_31871[(2)]);
var state_31871__$1 = state_31871;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31871__$1,inst_31869);
} else {
if((state_val_31872 === (4))){
var inst_31861 = (state_31871[(2)]);
var inst_31862 = process.call(null,inst_31861);
var state_31871__$1 = state_31871;
if(cljs.core.truth_(inst_31862)){
var statearr_31874_32021 = state_31871__$1;
(statearr_31874_32021[(1)] = (5));

} else {
var statearr_31875_32022 = state_31871__$1;
(statearr_31875_32022[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31872 === (5))){
var state_31871__$1 = state_31871;
var statearr_31876_32023 = state_31871__$1;
(statearr_31876_32023[(2)] = null);

(statearr_31876_32023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31872 === (6))){
var state_31871__$1 = state_31871;
var statearr_31877_32024 = state_31871__$1;
(statearr_31877_32024[(2)] = null);

(statearr_31877_32024[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31872 === (7))){
var inst_31867 = (state_31871[(2)]);
var state_31871__$1 = state_31871;
var statearr_31878_32025 = state_31871__$1;
(statearr_31878_32025[(2)] = inst_31867);

(statearr_31878_32025[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32015,c__31675__auto___32019,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async))
;
return ((function (__32015,switch__31585__auto__,c__31675__auto___32019,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0 = (function (){
var statearr_31879 = [null,null,null,null,null,null,null];
(statearr_31879[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__);

(statearr_31879[(1)] = (1));

return statearr_31879;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1 = (function (state_31871){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_31871);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e31880){if((e31880 instanceof Object)){
var ex__31589__auto__ = e31880;
var statearr_31881_32026 = state_31871;
(statearr_31881_32026[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31871);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31880;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32027 = state_31871;
state_31871 = G__32027;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__ = function(state_31871){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1.call(this,state_31871);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__;
})()
;})(__32015,switch__31585__auto__,c__31675__auto___32019,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async))
})();
var state__31677__auto__ = (function (){var statearr_31882 = f__31676__auto__.call(null);
(statearr_31882[(6)] = c__31675__auto___32019);

return statearr_31882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(__32015,c__31675__auto___32019,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async))
);


break;
case "async":
var c__31675__auto___32028 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__32015,c__31675__auto___32028,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (__32015,c__31675__auto___32028,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async){
return (function (state_31895){
var state_val_31896 = (state_31895[(1)]);
if((state_val_31896 === (1))){
var state_31895__$1 = state_31895;
var statearr_31897_32029 = state_31895__$1;
(statearr_31897_32029[(2)] = null);

(statearr_31897_32029[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31896 === (2))){
var state_31895__$1 = state_31895;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31895__$1,(4),jobs);
} else {
if((state_val_31896 === (3))){
var inst_31893 = (state_31895[(2)]);
var state_31895__$1 = state_31895;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31895__$1,inst_31893);
} else {
if((state_val_31896 === (4))){
var inst_31885 = (state_31895[(2)]);
var inst_31886 = async.call(null,inst_31885);
var state_31895__$1 = state_31895;
if(cljs.core.truth_(inst_31886)){
var statearr_31898_32030 = state_31895__$1;
(statearr_31898_32030[(1)] = (5));

} else {
var statearr_31899_32031 = state_31895__$1;
(statearr_31899_32031[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31896 === (5))){
var state_31895__$1 = state_31895;
var statearr_31900_32032 = state_31895__$1;
(statearr_31900_32032[(2)] = null);

(statearr_31900_32032[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31896 === (6))){
var state_31895__$1 = state_31895;
var statearr_31901_32033 = state_31895__$1;
(statearr_31901_32033[(2)] = null);

(statearr_31901_32033[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31896 === (7))){
var inst_31891 = (state_31895[(2)]);
var state_31895__$1 = state_31895;
var statearr_31902_32034 = state_31895__$1;
(statearr_31902_32034[(2)] = inst_31891);

(statearr_31902_32034[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__32015,c__31675__auto___32028,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async))
;
return ((function (__32015,switch__31585__auto__,c__31675__auto___32028,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0 = (function (){
var statearr_31903 = [null,null,null,null,null,null,null];
(statearr_31903[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__);

(statearr_31903[(1)] = (1));

return statearr_31903;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1 = (function (state_31895){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_31895);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e31904){if((e31904 instanceof Object)){
var ex__31589__auto__ = e31904;
var statearr_31905_32035 = state_31895;
(statearr_31905_32035[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31895);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31904;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32036 = state_31895;
state_31895 = G__32036;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__ = function(state_31895){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1.call(this,state_31895);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__;
})()
;})(__32015,switch__31585__auto__,c__31675__auto___32028,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async))
})();
var state__31677__auto__ = (function (){var statearr_31906 = f__31676__auto__.call(null);
(statearr_31906[(6)] = c__31675__auto___32028);

return statearr_31906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(__32015,c__31675__auto___32028,G__31858_32016,G__31858_32017__$1,n__29655__auto___32014,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__31858_32017__$1)].join('')));

}

var G__32037 = (__32015 + (1));
__32015 = G__32037;
continue;
} else {
}
break;
}

var c__31675__auto___32038 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___32038,jobs,results,process,async){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___32038,jobs,results,process,async){
return (function (state_31928){
var state_val_31929 = (state_31928[(1)]);
if((state_val_31929 === (1))){
var state_31928__$1 = state_31928;
var statearr_31930_32039 = state_31928__$1;
(statearr_31930_32039[(2)] = null);

(statearr_31930_32039[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31929 === (2))){
var state_31928__$1 = state_31928;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31928__$1,(4),from);
} else {
if((state_val_31929 === (3))){
var inst_31926 = (state_31928[(2)]);
var state_31928__$1 = state_31928;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31928__$1,inst_31926);
} else {
if((state_val_31929 === (4))){
var inst_31909 = (state_31928[(7)]);
var inst_31909__$1 = (state_31928[(2)]);
var inst_31910 = (inst_31909__$1 == null);
var state_31928__$1 = (function (){var statearr_31931 = state_31928;
(statearr_31931[(7)] = inst_31909__$1);

return statearr_31931;
})();
if(cljs.core.truth_(inst_31910)){
var statearr_31932_32040 = state_31928__$1;
(statearr_31932_32040[(1)] = (5));

} else {
var statearr_31933_32041 = state_31928__$1;
(statearr_31933_32041[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31929 === (5))){
var inst_31912 = cljs.core.async.close_BANG_.call(null,jobs);
var state_31928__$1 = state_31928;
var statearr_31934_32042 = state_31928__$1;
(statearr_31934_32042[(2)] = inst_31912);

(statearr_31934_32042[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31929 === (6))){
var inst_31909 = (state_31928[(7)]);
var inst_31914 = (state_31928[(8)]);
var inst_31914__$1 = cljs.core.async.chan.call(null,(1));
var inst_31915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31916 = [inst_31909,inst_31914__$1];
var inst_31917 = (new cljs.core.PersistentVector(null,2,(5),inst_31915,inst_31916,null));
var state_31928__$1 = (function (){var statearr_31935 = state_31928;
(statearr_31935[(8)] = inst_31914__$1);

return statearr_31935;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31928__$1,(8),jobs,inst_31917);
} else {
if((state_val_31929 === (7))){
var inst_31924 = (state_31928[(2)]);
var state_31928__$1 = state_31928;
var statearr_31936_32043 = state_31928__$1;
(statearr_31936_32043[(2)] = inst_31924);

(statearr_31936_32043[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31929 === (8))){
var inst_31914 = (state_31928[(8)]);
var inst_31919 = (state_31928[(2)]);
var state_31928__$1 = (function (){var statearr_31937 = state_31928;
(statearr_31937[(9)] = inst_31919);

return statearr_31937;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31928__$1,(9),results,inst_31914);
} else {
if((state_val_31929 === (9))){
var inst_31921 = (state_31928[(2)]);
var state_31928__$1 = (function (){var statearr_31938 = state_31928;
(statearr_31938[(10)] = inst_31921);

return statearr_31938;
})();
var statearr_31939_32044 = state_31928__$1;
(statearr_31939_32044[(2)] = null);

(statearr_31939_32044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___32038,jobs,results,process,async))
;
return ((function (switch__31585__auto__,c__31675__auto___32038,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0 = (function (){
var statearr_31940 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_31940[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__);

(statearr_31940[(1)] = (1));

return statearr_31940;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1 = (function (state_31928){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_31928);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e31941){if((e31941 instanceof Object)){
var ex__31589__auto__ = e31941;
var statearr_31942_32045 = state_31928;
(statearr_31942_32045[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31928);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31941;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32046 = state_31928;
state_31928 = G__32046;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__ = function(state_31928){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1.call(this,state_31928);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___32038,jobs,results,process,async))
})();
var state__31677__auto__ = (function (){var statearr_31943 = f__31676__auto__.call(null);
(statearr_31943[(6)] = c__31675__auto___32038);

return statearr_31943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___32038,jobs,results,process,async))
);


var c__31675__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto__,jobs,results,process,async){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto__,jobs,results,process,async){
return (function (state_31981){
var state_val_31982 = (state_31981[(1)]);
if((state_val_31982 === (7))){
var inst_31977 = (state_31981[(2)]);
var state_31981__$1 = state_31981;
var statearr_31983_32047 = state_31981__$1;
(statearr_31983_32047[(2)] = inst_31977);

(statearr_31983_32047[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (20))){
var state_31981__$1 = state_31981;
var statearr_31984_32048 = state_31981__$1;
(statearr_31984_32048[(2)] = null);

(statearr_31984_32048[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (1))){
var state_31981__$1 = state_31981;
var statearr_31985_32049 = state_31981__$1;
(statearr_31985_32049[(2)] = null);

(statearr_31985_32049[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (4))){
var inst_31946 = (state_31981[(7)]);
var inst_31946__$1 = (state_31981[(2)]);
var inst_31947 = (inst_31946__$1 == null);
var state_31981__$1 = (function (){var statearr_31986 = state_31981;
(statearr_31986[(7)] = inst_31946__$1);

return statearr_31986;
})();
if(cljs.core.truth_(inst_31947)){
var statearr_31987_32050 = state_31981__$1;
(statearr_31987_32050[(1)] = (5));

} else {
var statearr_31988_32051 = state_31981__$1;
(statearr_31988_32051[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (15))){
var inst_31959 = (state_31981[(8)]);
var state_31981__$1 = state_31981;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_31981__$1,(18),to,inst_31959);
} else {
if((state_val_31982 === (21))){
var inst_31972 = (state_31981[(2)]);
var state_31981__$1 = state_31981;
var statearr_31989_32052 = state_31981__$1;
(statearr_31989_32052[(2)] = inst_31972);

(statearr_31989_32052[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (13))){
var inst_31974 = (state_31981[(2)]);
var state_31981__$1 = (function (){var statearr_31990 = state_31981;
(statearr_31990[(9)] = inst_31974);

return statearr_31990;
})();
var statearr_31991_32053 = state_31981__$1;
(statearr_31991_32053[(2)] = null);

(statearr_31991_32053[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (6))){
var inst_31946 = (state_31981[(7)]);
var state_31981__$1 = state_31981;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31981__$1,(11),inst_31946);
} else {
if((state_val_31982 === (17))){
var inst_31967 = (state_31981[(2)]);
var state_31981__$1 = state_31981;
if(cljs.core.truth_(inst_31967)){
var statearr_31992_32054 = state_31981__$1;
(statearr_31992_32054[(1)] = (19));

} else {
var statearr_31993_32055 = state_31981__$1;
(statearr_31993_32055[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (3))){
var inst_31979 = (state_31981[(2)]);
var state_31981__$1 = state_31981;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31981__$1,inst_31979);
} else {
if((state_val_31982 === (12))){
var inst_31956 = (state_31981[(10)]);
var state_31981__$1 = state_31981;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31981__$1,(14),inst_31956);
} else {
if((state_val_31982 === (2))){
var state_31981__$1 = state_31981;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31981__$1,(4),results);
} else {
if((state_val_31982 === (19))){
var state_31981__$1 = state_31981;
var statearr_31994_32056 = state_31981__$1;
(statearr_31994_32056[(2)] = null);

(statearr_31994_32056[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (11))){
var inst_31956 = (state_31981[(2)]);
var state_31981__$1 = (function (){var statearr_31995 = state_31981;
(statearr_31995[(10)] = inst_31956);

return statearr_31995;
})();
var statearr_31996_32057 = state_31981__$1;
(statearr_31996_32057[(2)] = null);

(statearr_31996_32057[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (9))){
var state_31981__$1 = state_31981;
var statearr_31997_32058 = state_31981__$1;
(statearr_31997_32058[(2)] = null);

(statearr_31997_32058[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (5))){
var state_31981__$1 = state_31981;
if(cljs.core.truth_(close_QMARK_)){
var statearr_31998_32059 = state_31981__$1;
(statearr_31998_32059[(1)] = (8));

} else {
var statearr_31999_32060 = state_31981__$1;
(statearr_31999_32060[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (14))){
var inst_31959 = (state_31981[(8)]);
var inst_31961 = (state_31981[(11)]);
var inst_31959__$1 = (state_31981[(2)]);
var inst_31960 = (inst_31959__$1 == null);
var inst_31961__$1 = cljs.core.not.call(null,inst_31960);
var state_31981__$1 = (function (){var statearr_32000 = state_31981;
(statearr_32000[(8)] = inst_31959__$1);

(statearr_32000[(11)] = inst_31961__$1);

return statearr_32000;
})();
if(inst_31961__$1){
var statearr_32001_32061 = state_31981__$1;
(statearr_32001_32061[(1)] = (15));

} else {
var statearr_32002_32062 = state_31981__$1;
(statearr_32002_32062[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (16))){
var inst_31961 = (state_31981[(11)]);
var state_31981__$1 = state_31981;
var statearr_32003_32063 = state_31981__$1;
(statearr_32003_32063[(2)] = inst_31961);

(statearr_32003_32063[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (10))){
var inst_31953 = (state_31981[(2)]);
var state_31981__$1 = state_31981;
var statearr_32004_32064 = state_31981__$1;
(statearr_32004_32064[(2)] = inst_31953);

(statearr_32004_32064[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (18))){
var inst_31964 = (state_31981[(2)]);
var state_31981__$1 = state_31981;
var statearr_32005_32065 = state_31981__$1;
(statearr_32005_32065[(2)] = inst_31964);

(statearr_32005_32065[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31982 === (8))){
var inst_31950 = cljs.core.async.close_BANG_.call(null,to);
var state_31981__$1 = state_31981;
var statearr_32006_32066 = state_31981__$1;
(statearr_32006_32066[(2)] = inst_31950);

(statearr_32006_32066[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto__,jobs,results,process,async))
;
return ((function (switch__31585__auto__,c__31675__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0 = (function (){
var statearr_32007 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32007[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__);

(statearr_32007[(1)] = (1));

return statearr_32007;
});
var cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1 = (function (state_31981){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_31981);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e32008){if((e32008 instanceof Object)){
var ex__31589__auto__ = e32008;
var statearr_32009_32067 = state_31981;
(statearr_32009_32067[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31981);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32008;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32068 = state_31981;
state_31981 = G__32068;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__ = function(state_31981){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1.call(this,state_31981);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__31586__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto__,jobs,results,process,async))
})();
var state__31677__auto__ = (function (){var statearr_32010 = f__31676__auto__.call(null);
(statearr_32010[(6)] = c__31675__auto__);

return statearr_32010;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto__,jobs,results,process,async))
);

return c__31675__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__32070 = arguments.length;
switch (G__32070) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__32073 = arguments.length;
switch (G__32073) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__32076 = arguments.length;
switch (G__32076) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__31675__auto___32125 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___32125,tc,fc){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___32125,tc,fc){
return (function (state_32102){
var state_val_32103 = (state_32102[(1)]);
if((state_val_32103 === (7))){
var inst_32098 = (state_32102[(2)]);
var state_32102__$1 = state_32102;
var statearr_32104_32126 = state_32102__$1;
(statearr_32104_32126[(2)] = inst_32098);

(statearr_32104_32126[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32103 === (1))){
var state_32102__$1 = state_32102;
var statearr_32105_32127 = state_32102__$1;
(statearr_32105_32127[(2)] = null);

(statearr_32105_32127[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32103 === (4))){
var inst_32079 = (state_32102[(7)]);
var inst_32079__$1 = (state_32102[(2)]);
var inst_32080 = (inst_32079__$1 == null);
var state_32102__$1 = (function (){var statearr_32106 = state_32102;
(statearr_32106[(7)] = inst_32079__$1);

return statearr_32106;
})();
if(cljs.core.truth_(inst_32080)){
var statearr_32107_32128 = state_32102__$1;
(statearr_32107_32128[(1)] = (5));

} else {
var statearr_32108_32129 = state_32102__$1;
(statearr_32108_32129[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32103 === (13))){
var state_32102__$1 = state_32102;
var statearr_32109_32130 = state_32102__$1;
(statearr_32109_32130[(2)] = null);

(statearr_32109_32130[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32103 === (6))){
var inst_32079 = (state_32102[(7)]);
var inst_32085 = p.call(null,inst_32079);
var state_32102__$1 = state_32102;
if(cljs.core.truth_(inst_32085)){
var statearr_32110_32131 = state_32102__$1;
(statearr_32110_32131[(1)] = (9));

} else {
var statearr_32111_32132 = state_32102__$1;
(statearr_32111_32132[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32103 === (3))){
var inst_32100 = (state_32102[(2)]);
var state_32102__$1 = state_32102;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32102__$1,inst_32100);
} else {
if((state_val_32103 === (12))){
var state_32102__$1 = state_32102;
var statearr_32112_32133 = state_32102__$1;
(statearr_32112_32133[(2)] = null);

(statearr_32112_32133[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32103 === (2))){
var state_32102__$1 = state_32102;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32102__$1,(4),ch);
} else {
if((state_val_32103 === (11))){
var inst_32079 = (state_32102[(7)]);
var inst_32089 = (state_32102[(2)]);
var state_32102__$1 = state_32102;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32102__$1,(8),inst_32089,inst_32079);
} else {
if((state_val_32103 === (9))){
var state_32102__$1 = state_32102;
var statearr_32113_32134 = state_32102__$1;
(statearr_32113_32134[(2)] = tc);

(statearr_32113_32134[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32103 === (5))){
var inst_32082 = cljs.core.async.close_BANG_.call(null,tc);
var inst_32083 = cljs.core.async.close_BANG_.call(null,fc);
var state_32102__$1 = (function (){var statearr_32114 = state_32102;
(statearr_32114[(8)] = inst_32082);

return statearr_32114;
})();
var statearr_32115_32135 = state_32102__$1;
(statearr_32115_32135[(2)] = inst_32083);

(statearr_32115_32135[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32103 === (14))){
var inst_32096 = (state_32102[(2)]);
var state_32102__$1 = state_32102;
var statearr_32116_32136 = state_32102__$1;
(statearr_32116_32136[(2)] = inst_32096);

(statearr_32116_32136[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32103 === (10))){
var state_32102__$1 = state_32102;
var statearr_32117_32137 = state_32102__$1;
(statearr_32117_32137[(2)] = fc);

(statearr_32117_32137[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32103 === (8))){
var inst_32091 = (state_32102[(2)]);
var state_32102__$1 = state_32102;
if(cljs.core.truth_(inst_32091)){
var statearr_32118_32138 = state_32102__$1;
(statearr_32118_32138[(1)] = (12));

} else {
var statearr_32119_32139 = state_32102__$1;
(statearr_32119_32139[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___32125,tc,fc))
;
return ((function (switch__31585__auto__,c__31675__auto___32125,tc,fc){
return (function() {
var cljs$core$async$state_machine__31586__auto__ = null;
var cljs$core$async$state_machine__31586__auto____0 = (function (){
var statearr_32120 = [null,null,null,null,null,null,null,null,null];
(statearr_32120[(0)] = cljs$core$async$state_machine__31586__auto__);

(statearr_32120[(1)] = (1));

return statearr_32120;
});
var cljs$core$async$state_machine__31586__auto____1 = (function (state_32102){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_32102);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e32121){if((e32121 instanceof Object)){
var ex__31589__auto__ = e32121;
var statearr_32122_32140 = state_32102;
(statearr_32122_32140[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32102);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32121;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32141 = state_32102;
state_32102 = G__32141;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$state_machine__31586__auto__ = function(state_32102){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31586__auto____1.call(this,state_32102);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31586__auto____0;
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31586__auto____1;
return cljs$core$async$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___32125,tc,fc))
})();
var state__31677__auto__ = (function (){var statearr_32123 = f__31676__auto__.call(null);
(statearr_32123[(6)] = c__31675__auto___32125);

return statearr_32123;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___32125,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__31675__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto__){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto__){
return (function (state_32162){
var state_val_32163 = (state_32162[(1)]);
if((state_val_32163 === (7))){
var inst_32158 = (state_32162[(2)]);
var state_32162__$1 = state_32162;
var statearr_32164_32182 = state_32162__$1;
(statearr_32164_32182[(2)] = inst_32158);

(statearr_32164_32182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (1))){
var inst_32142 = init;
var state_32162__$1 = (function (){var statearr_32165 = state_32162;
(statearr_32165[(7)] = inst_32142);

return statearr_32165;
})();
var statearr_32166_32183 = state_32162__$1;
(statearr_32166_32183[(2)] = null);

(statearr_32166_32183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (4))){
var inst_32145 = (state_32162[(8)]);
var inst_32145__$1 = (state_32162[(2)]);
var inst_32146 = (inst_32145__$1 == null);
var state_32162__$1 = (function (){var statearr_32167 = state_32162;
(statearr_32167[(8)] = inst_32145__$1);

return statearr_32167;
})();
if(cljs.core.truth_(inst_32146)){
var statearr_32168_32184 = state_32162__$1;
(statearr_32168_32184[(1)] = (5));

} else {
var statearr_32169_32185 = state_32162__$1;
(statearr_32169_32185[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (6))){
var inst_32142 = (state_32162[(7)]);
var inst_32149 = (state_32162[(9)]);
var inst_32145 = (state_32162[(8)]);
var inst_32149__$1 = f.call(null,inst_32142,inst_32145);
var inst_32150 = cljs.core.reduced_QMARK_.call(null,inst_32149__$1);
var state_32162__$1 = (function (){var statearr_32170 = state_32162;
(statearr_32170[(9)] = inst_32149__$1);

return statearr_32170;
})();
if(inst_32150){
var statearr_32171_32186 = state_32162__$1;
(statearr_32171_32186[(1)] = (8));

} else {
var statearr_32172_32187 = state_32162__$1;
(statearr_32172_32187[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (3))){
var inst_32160 = (state_32162[(2)]);
var state_32162__$1 = state_32162;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32162__$1,inst_32160);
} else {
if((state_val_32163 === (2))){
var state_32162__$1 = state_32162;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32162__$1,(4),ch);
} else {
if((state_val_32163 === (9))){
var inst_32149 = (state_32162[(9)]);
var inst_32142 = inst_32149;
var state_32162__$1 = (function (){var statearr_32173 = state_32162;
(statearr_32173[(7)] = inst_32142);

return statearr_32173;
})();
var statearr_32174_32188 = state_32162__$1;
(statearr_32174_32188[(2)] = null);

(statearr_32174_32188[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (5))){
var inst_32142 = (state_32162[(7)]);
var state_32162__$1 = state_32162;
var statearr_32175_32189 = state_32162__$1;
(statearr_32175_32189[(2)] = inst_32142);

(statearr_32175_32189[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (10))){
var inst_32156 = (state_32162[(2)]);
var state_32162__$1 = state_32162;
var statearr_32176_32190 = state_32162__$1;
(statearr_32176_32190[(2)] = inst_32156);

(statearr_32176_32190[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32163 === (8))){
var inst_32149 = (state_32162[(9)]);
var inst_32152 = cljs.core.deref.call(null,inst_32149);
var state_32162__$1 = state_32162;
var statearr_32177_32191 = state_32162__$1;
(statearr_32177_32191[(2)] = inst_32152);

(statearr_32177_32191[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto__))
;
return ((function (switch__31585__auto__,c__31675__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__31586__auto__ = null;
var cljs$core$async$reduce_$_state_machine__31586__auto____0 = (function (){
var statearr_32178 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32178[(0)] = cljs$core$async$reduce_$_state_machine__31586__auto__);

(statearr_32178[(1)] = (1));

return statearr_32178;
});
var cljs$core$async$reduce_$_state_machine__31586__auto____1 = (function (state_32162){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_32162);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e32179){if((e32179 instanceof Object)){
var ex__31589__auto__ = e32179;
var statearr_32180_32192 = state_32162;
(statearr_32180_32192[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32162);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32179;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32193 = state_32162;
state_32162 = G__32193;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__31586__auto__ = function(state_32162){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__31586__auto____1.call(this,state_32162);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__31586__auto____0;
cljs$core$async$reduce_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__31586__auto____1;
return cljs$core$async$reduce_$_state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto__))
})();
var state__31677__auto__ = (function (){var statearr_32181 = f__31676__auto__.call(null);
(statearr_32181[(6)] = c__31675__auto__);

return statearr_32181;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto__))
);

return c__31675__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__31675__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto__,f__$1){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto__,f__$1){
return (function (state_32199){
var state_val_32200 = (state_32199[(1)]);
if((state_val_32200 === (1))){
var inst_32194 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_32199__$1 = state_32199;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32199__$1,(2),inst_32194);
} else {
if((state_val_32200 === (2))){
var inst_32196 = (state_32199[(2)]);
var inst_32197 = f__$1.call(null,inst_32196);
var state_32199__$1 = state_32199;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32199__$1,inst_32197);
} else {
return null;
}
}
});})(c__31675__auto__,f__$1))
;
return ((function (switch__31585__auto__,c__31675__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__31586__auto__ = null;
var cljs$core$async$transduce_$_state_machine__31586__auto____0 = (function (){
var statearr_32201 = [null,null,null,null,null,null,null];
(statearr_32201[(0)] = cljs$core$async$transduce_$_state_machine__31586__auto__);

(statearr_32201[(1)] = (1));

return statearr_32201;
});
var cljs$core$async$transduce_$_state_machine__31586__auto____1 = (function (state_32199){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_32199);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e32202){if((e32202 instanceof Object)){
var ex__31589__auto__ = e32202;
var statearr_32203_32205 = state_32199;
(statearr_32203_32205[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32199);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32202;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32206 = state_32199;
state_32199 = G__32206;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__31586__auto__ = function(state_32199){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__31586__auto____1.call(this,state_32199);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__31586__auto____0;
cljs$core$async$transduce_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__31586__auto____1;
return cljs$core$async$transduce_$_state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto__,f__$1))
})();
var state__31677__auto__ = (function (){var statearr_32204 = f__31676__auto__.call(null);
(statearr_32204[(6)] = c__31675__auto__);

return statearr_32204;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto__,f__$1))
);

return c__31675__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__32208 = arguments.length;
switch (G__32208) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__31675__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto__){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto__){
return (function (state_32233){
var state_val_32234 = (state_32233[(1)]);
if((state_val_32234 === (7))){
var inst_32215 = (state_32233[(2)]);
var state_32233__$1 = state_32233;
var statearr_32235_32256 = state_32233__$1;
(statearr_32235_32256[(2)] = inst_32215);

(statearr_32235_32256[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32234 === (1))){
var inst_32209 = cljs.core.seq.call(null,coll);
var inst_32210 = inst_32209;
var state_32233__$1 = (function (){var statearr_32236 = state_32233;
(statearr_32236[(7)] = inst_32210);

return statearr_32236;
})();
var statearr_32237_32257 = state_32233__$1;
(statearr_32237_32257[(2)] = null);

(statearr_32237_32257[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32234 === (4))){
var inst_32210 = (state_32233[(7)]);
var inst_32213 = cljs.core.first.call(null,inst_32210);
var state_32233__$1 = state_32233;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32233__$1,(7),ch,inst_32213);
} else {
if((state_val_32234 === (13))){
var inst_32227 = (state_32233[(2)]);
var state_32233__$1 = state_32233;
var statearr_32238_32258 = state_32233__$1;
(statearr_32238_32258[(2)] = inst_32227);

(statearr_32238_32258[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32234 === (6))){
var inst_32218 = (state_32233[(2)]);
var state_32233__$1 = state_32233;
if(cljs.core.truth_(inst_32218)){
var statearr_32239_32259 = state_32233__$1;
(statearr_32239_32259[(1)] = (8));

} else {
var statearr_32240_32260 = state_32233__$1;
(statearr_32240_32260[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32234 === (3))){
var inst_32231 = (state_32233[(2)]);
var state_32233__$1 = state_32233;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32233__$1,inst_32231);
} else {
if((state_val_32234 === (12))){
var state_32233__$1 = state_32233;
var statearr_32241_32261 = state_32233__$1;
(statearr_32241_32261[(2)] = null);

(statearr_32241_32261[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32234 === (2))){
var inst_32210 = (state_32233[(7)]);
var state_32233__$1 = state_32233;
if(cljs.core.truth_(inst_32210)){
var statearr_32242_32262 = state_32233__$1;
(statearr_32242_32262[(1)] = (4));

} else {
var statearr_32243_32263 = state_32233__$1;
(statearr_32243_32263[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32234 === (11))){
var inst_32224 = cljs.core.async.close_BANG_.call(null,ch);
var state_32233__$1 = state_32233;
var statearr_32244_32264 = state_32233__$1;
(statearr_32244_32264[(2)] = inst_32224);

(statearr_32244_32264[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32234 === (9))){
var state_32233__$1 = state_32233;
if(cljs.core.truth_(close_QMARK_)){
var statearr_32245_32265 = state_32233__$1;
(statearr_32245_32265[(1)] = (11));

} else {
var statearr_32246_32266 = state_32233__$1;
(statearr_32246_32266[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32234 === (5))){
var inst_32210 = (state_32233[(7)]);
var state_32233__$1 = state_32233;
var statearr_32247_32267 = state_32233__$1;
(statearr_32247_32267[(2)] = inst_32210);

(statearr_32247_32267[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32234 === (10))){
var inst_32229 = (state_32233[(2)]);
var state_32233__$1 = state_32233;
var statearr_32248_32268 = state_32233__$1;
(statearr_32248_32268[(2)] = inst_32229);

(statearr_32248_32268[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32234 === (8))){
var inst_32210 = (state_32233[(7)]);
var inst_32220 = cljs.core.next.call(null,inst_32210);
var inst_32210__$1 = inst_32220;
var state_32233__$1 = (function (){var statearr_32249 = state_32233;
(statearr_32249[(7)] = inst_32210__$1);

return statearr_32249;
})();
var statearr_32250_32269 = state_32233__$1;
(statearr_32250_32269[(2)] = null);

(statearr_32250_32269[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto__))
;
return ((function (switch__31585__auto__,c__31675__auto__){
return (function() {
var cljs$core$async$state_machine__31586__auto__ = null;
var cljs$core$async$state_machine__31586__auto____0 = (function (){
var statearr_32251 = [null,null,null,null,null,null,null,null];
(statearr_32251[(0)] = cljs$core$async$state_machine__31586__auto__);

(statearr_32251[(1)] = (1));

return statearr_32251;
});
var cljs$core$async$state_machine__31586__auto____1 = (function (state_32233){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_32233);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e32252){if((e32252 instanceof Object)){
var ex__31589__auto__ = e32252;
var statearr_32253_32270 = state_32233;
(statearr_32253_32270[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32233);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32252;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32271 = state_32233;
state_32233 = G__32271;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$state_machine__31586__auto__ = function(state_32233){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31586__auto____1.call(this,state_32233);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31586__auto____0;
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31586__auto____1;
return cljs$core$async$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto__))
})();
var state__31677__auto__ = (function (){var statearr_32254 = f__31676__auto__.call(null);
(statearr_32254[(6)] = c__31675__auto__);

return statearr_32254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto__))
);

return c__31675__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__29352__auto__ = (((_ == null))?null:_);
var m__29353__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,_);
} else {
var m__29353__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__29352__auto__ = (((m == null))?null:m);
var m__29353__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__29353__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__29352__auto__ = (((m == null))?null:m);
var m__29353__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,m,ch);
} else {
var m__29353__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__29352__auto__ = (((m == null))?null:m);
var m__29353__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,m);
} else {
var m__29353__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32272 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32272 = (function (ch,cs,meta32273){
this.ch = ch;
this.cs = cs;
this.meta32273 = meta32273;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32272.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_32274,meta32273__$1){
var self__ = this;
var _32274__$1 = this;
return (new cljs.core.async.t_cljs$core$async32272(self__.ch,self__.cs,meta32273__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async32272.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_32274){
var self__ = this;
var _32274__$1 = this;
return self__.meta32273;
});})(cs))
;

cljs.core.async.t_cljs$core$async32272.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32272.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async32272.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32272.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32272.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32272.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async32272.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta32273","meta32273",1189889860,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async32272.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32272.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32272";

cljs.core.async.t_cljs$core$async32272.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__29290__auto__,writer__29291__auto__,opt__29292__auto__){
return cljs.core._write.call(null,writer__29291__auto__,"cljs.core.async/t_cljs$core$async32272");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async32272 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async32272(ch__$1,cs__$1,meta32273){
return (new cljs.core.async.t_cljs$core$async32272(ch__$1,cs__$1,meta32273));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async32272(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__31675__auto___32494 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___32494,cs,m,dchan,dctr,done){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___32494,cs,m,dchan,dctr,done){
return (function (state_32409){
var state_val_32410 = (state_32409[(1)]);
if((state_val_32410 === (7))){
var inst_32405 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32411_32495 = state_32409__$1;
(statearr_32411_32495[(2)] = inst_32405);

(statearr_32411_32495[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (20))){
var inst_32308 = (state_32409[(7)]);
var inst_32320 = cljs.core.first.call(null,inst_32308);
var inst_32321 = cljs.core.nth.call(null,inst_32320,(0),null);
var inst_32322 = cljs.core.nth.call(null,inst_32320,(1),null);
var state_32409__$1 = (function (){var statearr_32412 = state_32409;
(statearr_32412[(8)] = inst_32321);

return statearr_32412;
})();
if(cljs.core.truth_(inst_32322)){
var statearr_32413_32496 = state_32409__$1;
(statearr_32413_32496[(1)] = (22));

} else {
var statearr_32414_32497 = state_32409__$1;
(statearr_32414_32497[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (27))){
var inst_32350 = (state_32409[(9)]);
var inst_32357 = (state_32409[(10)]);
var inst_32277 = (state_32409[(11)]);
var inst_32352 = (state_32409[(12)]);
var inst_32357__$1 = cljs.core._nth.call(null,inst_32350,inst_32352);
var inst_32358 = cljs.core.async.put_BANG_.call(null,inst_32357__$1,inst_32277,done);
var state_32409__$1 = (function (){var statearr_32415 = state_32409;
(statearr_32415[(10)] = inst_32357__$1);

return statearr_32415;
})();
if(cljs.core.truth_(inst_32358)){
var statearr_32416_32498 = state_32409__$1;
(statearr_32416_32498[(1)] = (30));

} else {
var statearr_32417_32499 = state_32409__$1;
(statearr_32417_32499[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (1))){
var state_32409__$1 = state_32409;
var statearr_32418_32500 = state_32409__$1;
(statearr_32418_32500[(2)] = null);

(statearr_32418_32500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (24))){
var inst_32308 = (state_32409[(7)]);
var inst_32327 = (state_32409[(2)]);
var inst_32328 = cljs.core.next.call(null,inst_32308);
var inst_32286 = inst_32328;
var inst_32287 = null;
var inst_32288 = (0);
var inst_32289 = (0);
var state_32409__$1 = (function (){var statearr_32419 = state_32409;
(statearr_32419[(13)] = inst_32286);

(statearr_32419[(14)] = inst_32327);

(statearr_32419[(15)] = inst_32289);

(statearr_32419[(16)] = inst_32287);

(statearr_32419[(17)] = inst_32288);

return statearr_32419;
})();
var statearr_32420_32501 = state_32409__$1;
(statearr_32420_32501[(2)] = null);

(statearr_32420_32501[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (39))){
var state_32409__$1 = state_32409;
var statearr_32424_32502 = state_32409__$1;
(statearr_32424_32502[(2)] = null);

(statearr_32424_32502[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (4))){
var inst_32277 = (state_32409[(11)]);
var inst_32277__$1 = (state_32409[(2)]);
var inst_32278 = (inst_32277__$1 == null);
var state_32409__$1 = (function (){var statearr_32425 = state_32409;
(statearr_32425[(11)] = inst_32277__$1);

return statearr_32425;
})();
if(cljs.core.truth_(inst_32278)){
var statearr_32426_32503 = state_32409__$1;
(statearr_32426_32503[(1)] = (5));

} else {
var statearr_32427_32504 = state_32409__$1;
(statearr_32427_32504[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (15))){
var inst_32286 = (state_32409[(13)]);
var inst_32289 = (state_32409[(15)]);
var inst_32287 = (state_32409[(16)]);
var inst_32288 = (state_32409[(17)]);
var inst_32304 = (state_32409[(2)]);
var inst_32305 = (inst_32289 + (1));
var tmp32421 = inst_32286;
var tmp32422 = inst_32287;
var tmp32423 = inst_32288;
var inst_32286__$1 = tmp32421;
var inst_32287__$1 = tmp32422;
var inst_32288__$1 = tmp32423;
var inst_32289__$1 = inst_32305;
var state_32409__$1 = (function (){var statearr_32428 = state_32409;
(statearr_32428[(13)] = inst_32286__$1);

(statearr_32428[(15)] = inst_32289__$1);

(statearr_32428[(16)] = inst_32287__$1);

(statearr_32428[(18)] = inst_32304);

(statearr_32428[(17)] = inst_32288__$1);

return statearr_32428;
})();
var statearr_32429_32505 = state_32409__$1;
(statearr_32429_32505[(2)] = null);

(statearr_32429_32505[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (21))){
var inst_32331 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32433_32506 = state_32409__$1;
(statearr_32433_32506[(2)] = inst_32331);

(statearr_32433_32506[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (31))){
var inst_32357 = (state_32409[(10)]);
var inst_32361 = done.call(null,null);
var inst_32362 = cljs.core.async.untap_STAR_.call(null,m,inst_32357);
var state_32409__$1 = (function (){var statearr_32434 = state_32409;
(statearr_32434[(19)] = inst_32361);

return statearr_32434;
})();
var statearr_32435_32507 = state_32409__$1;
(statearr_32435_32507[(2)] = inst_32362);

(statearr_32435_32507[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (32))){
var inst_32350 = (state_32409[(9)]);
var inst_32351 = (state_32409[(20)]);
var inst_32352 = (state_32409[(12)]);
var inst_32349 = (state_32409[(21)]);
var inst_32364 = (state_32409[(2)]);
var inst_32365 = (inst_32352 + (1));
var tmp32430 = inst_32350;
var tmp32431 = inst_32351;
var tmp32432 = inst_32349;
var inst_32349__$1 = tmp32432;
var inst_32350__$1 = tmp32430;
var inst_32351__$1 = tmp32431;
var inst_32352__$1 = inst_32365;
var state_32409__$1 = (function (){var statearr_32436 = state_32409;
(statearr_32436[(9)] = inst_32350__$1);

(statearr_32436[(20)] = inst_32351__$1);

(statearr_32436[(12)] = inst_32352__$1);

(statearr_32436[(22)] = inst_32364);

(statearr_32436[(21)] = inst_32349__$1);

return statearr_32436;
})();
var statearr_32437_32508 = state_32409__$1;
(statearr_32437_32508[(2)] = null);

(statearr_32437_32508[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (40))){
var inst_32377 = (state_32409[(23)]);
var inst_32381 = done.call(null,null);
var inst_32382 = cljs.core.async.untap_STAR_.call(null,m,inst_32377);
var state_32409__$1 = (function (){var statearr_32438 = state_32409;
(statearr_32438[(24)] = inst_32381);

return statearr_32438;
})();
var statearr_32439_32509 = state_32409__$1;
(statearr_32439_32509[(2)] = inst_32382);

(statearr_32439_32509[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (33))){
var inst_32368 = (state_32409[(25)]);
var inst_32370 = cljs.core.chunked_seq_QMARK_.call(null,inst_32368);
var state_32409__$1 = state_32409;
if(inst_32370){
var statearr_32440_32510 = state_32409__$1;
(statearr_32440_32510[(1)] = (36));

} else {
var statearr_32441_32511 = state_32409__$1;
(statearr_32441_32511[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (13))){
var inst_32298 = (state_32409[(26)]);
var inst_32301 = cljs.core.async.close_BANG_.call(null,inst_32298);
var state_32409__$1 = state_32409;
var statearr_32442_32512 = state_32409__$1;
(statearr_32442_32512[(2)] = inst_32301);

(statearr_32442_32512[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (22))){
var inst_32321 = (state_32409[(8)]);
var inst_32324 = cljs.core.async.close_BANG_.call(null,inst_32321);
var state_32409__$1 = state_32409;
var statearr_32443_32513 = state_32409__$1;
(statearr_32443_32513[(2)] = inst_32324);

(statearr_32443_32513[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (36))){
var inst_32368 = (state_32409[(25)]);
var inst_32372 = cljs.core.chunk_first.call(null,inst_32368);
var inst_32373 = cljs.core.chunk_rest.call(null,inst_32368);
var inst_32374 = cljs.core.count.call(null,inst_32372);
var inst_32349 = inst_32373;
var inst_32350 = inst_32372;
var inst_32351 = inst_32374;
var inst_32352 = (0);
var state_32409__$1 = (function (){var statearr_32444 = state_32409;
(statearr_32444[(9)] = inst_32350);

(statearr_32444[(20)] = inst_32351);

(statearr_32444[(12)] = inst_32352);

(statearr_32444[(21)] = inst_32349);

return statearr_32444;
})();
var statearr_32445_32514 = state_32409__$1;
(statearr_32445_32514[(2)] = null);

(statearr_32445_32514[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (41))){
var inst_32368 = (state_32409[(25)]);
var inst_32384 = (state_32409[(2)]);
var inst_32385 = cljs.core.next.call(null,inst_32368);
var inst_32349 = inst_32385;
var inst_32350 = null;
var inst_32351 = (0);
var inst_32352 = (0);
var state_32409__$1 = (function (){var statearr_32446 = state_32409;
(statearr_32446[(9)] = inst_32350);

(statearr_32446[(20)] = inst_32351);

(statearr_32446[(12)] = inst_32352);

(statearr_32446[(21)] = inst_32349);

(statearr_32446[(27)] = inst_32384);

return statearr_32446;
})();
var statearr_32447_32515 = state_32409__$1;
(statearr_32447_32515[(2)] = null);

(statearr_32447_32515[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (43))){
var state_32409__$1 = state_32409;
var statearr_32448_32516 = state_32409__$1;
(statearr_32448_32516[(2)] = null);

(statearr_32448_32516[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (29))){
var inst_32393 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32449_32517 = state_32409__$1;
(statearr_32449_32517[(2)] = inst_32393);

(statearr_32449_32517[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (44))){
var inst_32402 = (state_32409[(2)]);
var state_32409__$1 = (function (){var statearr_32450 = state_32409;
(statearr_32450[(28)] = inst_32402);

return statearr_32450;
})();
var statearr_32451_32518 = state_32409__$1;
(statearr_32451_32518[(2)] = null);

(statearr_32451_32518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (6))){
var inst_32341 = (state_32409[(29)]);
var inst_32340 = cljs.core.deref.call(null,cs);
var inst_32341__$1 = cljs.core.keys.call(null,inst_32340);
var inst_32342 = cljs.core.count.call(null,inst_32341__$1);
var inst_32343 = cljs.core.reset_BANG_.call(null,dctr,inst_32342);
var inst_32348 = cljs.core.seq.call(null,inst_32341__$1);
var inst_32349 = inst_32348;
var inst_32350 = null;
var inst_32351 = (0);
var inst_32352 = (0);
var state_32409__$1 = (function (){var statearr_32452 = state_32409;
(statearr_32452[(9)] = inst_32350);

(statearr_32452[(20)] = inst_32351);

(statearr_32452[(12)] = inst_32352);

(statearr_32452[(30)] = inst_32343);

(statearr_32452[(21)] = inst_32349);

(statearr_32452[(29)] = inst_32341__$1);

return statearr_32452;
})();
var statearr_32453_32519 = state_32409__$1;
(statearr_32453_32519[(2)] = null);

(statearr_32453_32519[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (28))){
var inst_32368 = (state_32409[(25)]);
var inst_32349 = (state_32409[(21)]);
var inst_32368__$1 = cljs.core.seq.call(null,inst_32349);
var state_32409__$1 = (function (){var statearr_32454 = state_32409;
(statearr_32454[(25)] = inst_32368__$1);

return statearr_32454;
})();
if(inst_32368__$1){
var statearr_32455_32520 = state_32409__$1;
(statearr_32455_32520[(1)] = (33));

} else {
var statearr_32456_32521 = state_32409__$1;
(statearr_32456_32521[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (25))){
var inst_32351 = (state_32409[(20)]);
var inst_32352 = (state_32409[(12)]);
var inst_32354 = (inst_32352 < inst_32351);
var inst_32355 = inst_32354;
var state_32409__$1 = state_32409;
if(cljs.core.truth_(inst_32355)){
var statearr_32457_32522 = state_32409__$1;
(statearr_32457_32522[(1)] = (27));

} else {
var statearr_32458_32523 = state_32409__$1;
(statearr_32458_32523[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (34))){
var state_32409__$1 = state_32409;
var statearr_32459_32524 = state_32409__$1;
(statearr_32459_32524[(2)] = null);

(statearr_32459_32524[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (17))){
var state_32409__$1 = state_32409;
var statearr_32460_32525 = state_32409__$1;
(statearr_32460_32525[(2)] = null);

(statearr_32460_32525[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (3))){
var inst_32407 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32409__$1,inst_32407);
} else {
if((state_val_32410 === (12))){
var inst_32336 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32461_32526 = state_32409__$1;
(statearr_32461_32526[(2)] = inst_32336);

(statearr_32461_32526[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (2))){
var state_32409__$1 = state_32409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32409__$1,(4),ch);
} else {
if((state_val_32410 === (23))){
var state_32409__$1 = state_32409;
var statearr_32462_32527 = state_32409__$1;
(statearr_32462_32527[(2)] = null);

(statearr_32462_32527[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (35))){
var inst_32391 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32463_32528 = state_32409__$1;
(statearr_32463_32528[(2)] = inst_32391);

(statearr_32463_32528[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (19))){
var inst_32308 = (state_32409[(7)]);
var inst_32312 = cljs.core.chunk_first.call(null,inst_32308);
var inst_32313 = cljs.core.chunk_rest.call(null,inst_32308);
var inst_32314 = cljs.core.count.call(null,inst_32312);
var inst_32286 = inst_32313;
var inst_32287 = inst_32312;
var inst_32288 = inst_32314;
var inst_32289 = (0);
var state_32409__$1 = (function (){var statearr_32464 = state_32409;
(statearr_32464[(13)] = inst_32286);

(statearr_32464[(15)] = inst_32289);

(statearr_32464[(16)] = inst_32287);

(statearr_32464[(17)] = inst_32288);

return statearr_32464;
})();
var statearr_32465_32529 = state_32409__$1;
(statearr_32465_32529[(2)] = null);

(statearr_32465_32529[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (11))){
var inst_32286 = (state_32409[(13)]);
var inst_32308 = (state_32409[(7)]);
var inst_32308__$1 = cljs.core.seq.call(null,inst_32286);
var state_32409__$1 = (function (){var statearr_32466 = state_32409;
(statearr_32466[(7)] = inst_32308__$1);

return statearr_32466;
})();
if(inst_32308__$1){
var statearr_32467_32530 = state_32409__$1;
(statearr_32467_32530[(1)] = (16));

} else {
var statearr_32468_32531 = state_32409__$1;
(statearr_32468_32531[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (9))){
var inst_32338 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32469_32532 = state_32409__$1;
(statearr_32469_32532[(2)] = inst_32338);

(statearr_32469_32532[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (5))){
var inst_32284 = cljs.core.deref.call(null,cs);
var inst_32285 = cljs.core.seq.call(null,inst_32284);
var inst_32286 = inst_32285;
var inst_32287 = null;
var inst_32288 = (0);
var inst_32289 = (0);
var state_32409__$1 = (function (){var statearr_32470 = state_32409;
(statearr_32470[(13)] = inst_32286);

(statearr_32470[(15)] = inst_32289);

(statearr_32470[(16)] = inst_32287);

(statearr_32470[(17)] = inst_32288);

return statearr_32470;
})();
var statearr_32471_32533 = state_32409__$1;
(statearr_32471_32533[(2)] = null);

(statearr_32471_32533[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (14))){
var state_32409__$1 = state_32409;
var statearr_32472_32534 = state_32409__$1;
(statearr_32472_32534[(2)] = null);

(statearr_32472_32534[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (45))){
var inst_32399 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32473_32535 = state_32409__$1;
(statearr_32473_32535[(2)] = inst_32399);

(statearr_32473_32535[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (26))){
var inst_32341 = (state_32409[(29)]);
var inst_32395 = (state_32409[(2)]);
var inst_32396 = cljs.core.seq.call(null,inst_32341);
var state_32409__$1 = (function (){var statearr_32474 = state_32409;
(statearr_32474[(31)] = inst_32395);

return statearr_32474;
})();
if(inst_32396){
var statearr_32475_32536 = state_32409__$1;
(statearr_32475_32536[(1)] = (42));

} else {
var statearr_32476_32537 = state_32409__$1;
(statearr_32476_32537[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (16))){
var inst_32308 = (state_32409[(7)]);
var inst_32310 = cljs.core.chunked_seq_QMARK_.call(null,inst_32308);
var state_32409__$1 = state_32409;
if(inst_32310){
var statearr_32477_32538 = state_32409__$1;
(statearr_32477_32538[(1)] = (19));

} else {
var statearr_32478_32539 = state_32409__$1;
(statearr_32478_32539[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (38))){
var inst_32388 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32479_32540 = state_32409__$1;
(statearr_32479_32540[(2)] = inst_32388);

(statearr_32479_32540[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (30))){
var state_32409__$1 = state_32409;
var statearr_32480_32541 = state_32409__$1;
(statearr_32480_32541[(2)] = null);

(statearr_32480_32541[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (10))){
var inst_32289 = (state_32409[(15)]);
var inst_32287 = (state_32409[(16)]);
var inst_32297 = cljs.core._nth.call(null,inst_32287,inst_32289);
var inst_32298 = cljs.core.nth.call(null,inst_32297,(0),null);
var inst_32299 = cljs.core.nth.call(null,inst_32297,(1),null);
var state_32409__$1 = (function (){var statearr_32481 = state_32409;
(statearr_32481[(26)] = inst_32298);

return statearr_32481;
})();
if(cljs.core.truth_(inst_32299)){
var statearr_32482_32542 = state_32409__$1;
(statearr_32482_32542[(1)] = (13));

} else {
var statearr_32483_32543 = state_32409__$1;
(statearr_32483_32543[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (18))){
var inst_32334 = (state_32409[(2)]);
var state_32409__$1 = state_32409;
var statearr_32484_32544 = state_32409__$1;
(statearr_32484_32544[(2)] = inst_32334);

(statearr_32484_32544[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (42))){
var state_32409__$1 = state_32409;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32409__$1,(45),dchan);
} else {
if((state_val_32410 === (37))){
var inst_32277 = (state_32409[(11)]);
var inst_32368 = (state_32409[(25)]);
var inst_32377 = (state_32409[(23)]);
var inst_32377__$1 = cljs.core.first.call(null,inst_32368);
var inst_32378 = cljs.core.async.put_BANG_.call(null,inst_32377__$1,inst_32277,done);
var state_32409__$1 = (function (){var statearr_32485 = state_32409;
(statearr_32485[(23)] = inst_32377__$1);

return statearr_32485;
})();
if(cljs.core.truth_(inst_32378)){
var statearr_32486_32545 = state_32409__$1;
(statearr_32486_32545[(1)] = (39));

} else {
var statearr_32487_32546 = state_32409__$1;
(statearr_32487_32546[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32410 === (8))){
var inst_32289 = (state_32409[(15)]);
var inst_32288 = (state_32409[(17)]);
var inst_32291 = (inst_32289 < inst_32288);
var inst_32292 = inst_32291;
var state_32409__$1 = state_32409;
if(cljs.core.truth_(inst_32292)){
var statearr_32488_32547 = state_32409__$1;
(statearr_32488_32547[(1)] = (10));

} else {
var statearr_32489_32548 = state_32409__$1;
(statearr_32489_32548[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___32494,cs,m,dchan,dctr,done))
;
return ((function (switch__31585__auto__,c__31675__auto___32494,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__31586__auto__ = null;
var cljs$core$async$mult_$_state_machine__31586__auto____0 = (function (){
var statearr_32490 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32490[(0)] = cljs$core$async$mult_$_state_machine__31586__auto__);

(statearr_32490[(1)] = (1));

return statearr_32490;
});
var cljs$core$async$mult_$_state_machine__31586__auto____1 = (function (state_32409){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_32409);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e32491){if((e32491 instanceof Object)){
var ex__31589__auto__ = e32491;
var statearr_32492_32549 = state_32409;
(statearr_32492_32549[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32409);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32491;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32550 = state_32409;
state_32409 = G__32550;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__31586__auto__ = function(state_32409){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__31586__auto____1.call(this,state_32409);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__31586__auto____0;
cljs$core$async$mult_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__31586__auto____1;
return cljs$core$async$mult_$_state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___32494,cs,m,dchan,dctr,done))
})();
var state__31677__auto__ = (function (){var statearr_32493 = f__31676__auto__.call(null);
(statearr_32493[(6)] = c__31675__auto___32494);

return statearr_32493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___32494,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__32552 = arguments.length;
switch (G__32552) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__29352__auto__ = (((m == null))?null:m);
var m__29353__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,m,ch);
} else {
var m__29353__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__29352__auto__ = (((m == null))?null:m);
var m__29353__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,m,ch);
} else {
var m__29353__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__29352__auto__ = (((m == null))?null:m);
var m__29353__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,m);
} else {
var m__29353__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__29352__auto__ = (((m == null))?null:m);
var m__29353__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,m,state_map);
} else {
var m__29353__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__29352__auto__ = (((m == null))?null:m);
var m__29353__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,m,mode);
} else {
var m__29353__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__29873__auto__ = [];
var len__29866__auto___32564 = arguments.length;
var i__29867__auto___32565 = (0);
while(true){
if((i__29867__auto___32565 < len__29866__auto___32564)){
args__29873__auto__.push((arguments[i__29867__auto___32565]));

var G__32566 = (i__29867__auto___32565 + (1));
i__29867__auto___32565 = G__32566;
continue;
} else {
}
break;
}

var argseq__29874__auto__ = ((((3) < args__29873__auto__.length))?(new cljs.core.IndexedSeq(args__29873__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__29874__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__32558){
var map__32559 = p__32558;
var map__32559__$1 = ((((!((map__32559 == null)))?((((map__32559.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__32559.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__32559):map__32559);
var opts = map__32559__$1;
var statearr_32561_32567 = state;
(statearr_32561_32567[(1)] = cont_block);


var temp__5278__auto__ = cljs.core.async.do_alts.call(null,((function (map__32559,map__32559__$1,opts){
return (function (val){
var statearr_32562_32568 = state;
(statearr_32562_32568[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__32559,map__32559__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5278__auto__)){
var cb = temp__5278__auto__;
var statearr_32563_32569 = state;
(statearr_32563_32569[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq32554){
var G__32555 = cljs.core.first.call(null,seq32554);
var seq32554__$1 = cljs.core.next.call(null,seq32554);
var G__32556 = cljs.core.first.call(null,seq32554__$1);
var seq32554__$2 = cljs.core.next.call(null,seq32554__$1);
var G__32557 = cljs.core.first.call(null,seq32554__$2);
var seq32554__$3 = cljs.core.next.call(null,seq32554__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__32555,G__32556,G__32557,seq32554__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async32570 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32570 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta32571){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta32571 = meta32571;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32570.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32572,meta32571__$1){
var self__ = this;
var _32572__$1 = this;
return (new cljs.core.async.t_cljs$core$async32570(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta32571__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32570.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_32572){
var self__ = this;
var _32572__$1 = this;
return self__.meta32571;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32570.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32570.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32570.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32570.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32570.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32570.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32570.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32570.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32570.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta32571","meta32571",-1980405709,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async32570.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32570.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32570";

cljs.core.async.t_cljs$core$async32570.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__29290__auto__,writer__29291__auto__,opt__29292__auto__){
return cljs.core._write.call(null,writer__29291__auto__,"cljs.core.async/t_cljs$core$async32570");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async32570 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async32570(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta32571){
return (new cljs.core.async.t_cljs$core$async32570(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta32571));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async32570(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31675__auto___32734 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___32734,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___32734,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_32674){
var state_val_32675 = (state_32674[(1)]);
if((state_val_32675 === (7))){
var inst_32589 = (state_32674[(2)]);
var state_32674__$1 = state_32674;
var statearr_32676_32735 = state_32674__$1;
(statearr_32676_32735[(2)] = inst_32589);

(statearr_32676_32735[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (20))){
var inst_32601 = (state_32674[(7)]);
var state_32674__$1 = state_32674;
var statearr_32677_32736 = state_32674__$1;
(statearr_32677_32736[(2)] = inst_32601);

(statearr_32677_32736[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (27))){
var state_32674__$1 = state_32674;
var statearr_32678_32737 = state_32674__$1;
(statearr_32678_32737[(2)] = null);

(statearr_32678_32737[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (1))){
var inst_32576 = (state_32674[(8)]);
var inst_32576__$1 = calc_state.call(null);
var inst_32578 = (inst_32576__$1 == null);
var inst_32579 = cljs.core.not.call(null,inst_32578);
var state_32674__$1 = (function (){var statearr_32679 = state_32674;
(statearr_32679[(8)] = inst_32576__$1);

return statearr_32679;
})();
if(inst_32579){
var statearr_32680_32738 = state_32674__$1;
(statearr_32680_32738[(1)] = (2));

} else {
var statearr_32681_32739 = state_32674__$1;
(statearr_32681_32739[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (24))){
var inst_32625 = (state_32674[(9)]);
var inst_32634 = (state_32674[(10)]);
var inst_32648 = (state_32674[(11)]);
var inst_32648__$1 = inst_32625.call(null,inst_32634);
var state_32674__$1 = (function (){var statearr_32682 = state_32674;
(statearr_32682[(11)] = inst_32648__$1);

return statearr_32682;
})();
if(cljs.core.truth_(inst_32648__$1)){
var statearr_32683_32740 = state_32674__$1;
(statearr_32683_32740[(1)] = (29));

} else {
var statearr_32684_32741 = state_32674__$1;
(statearr_32684_32741[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (4))){
var inst_32592 = (state_32674[(2)]);
var state_32674__$1 = state_32674;
if(cljs.core.truth_(inst_32592)){
var statearr_32685_32742 = state_32674__$1;
(statearr_32685_32742[(1)] = (8));

} else {
var statearr_32686_32743 = state_32674__$1;
(statearr_32686_32743[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (15))){
var inst_32619 = (state_32674[(2)]);
var state_32674__$1 = state_32674;
if(cljs.core.truth_(inst_32619)){
var statearr_32687_32744 = state_32674__$1;
(statearr_32687_32744[(1)] = (19));

} else {
var statearr_32688_32745 = state_32674__$1;
(statearr_32688_32745[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (21))){
var inst_32624 = (state_32674[(12)]);
var inst_32624__$1 = (state_32674[(2)]);
var inst_32625 = cljs.core.get.call(null,inst_32624__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32626 = cljs.core.get.call(null,inst_32624__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32627 = cljs.core.get.call(null,inst_32624__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_32674__$1 = (function (){var statearr_32689 = state_32674;
(statearr_32689[(13)] = inst_32626);

(statearr_32689[(12)] = inst_32624__$1);

(statearr_32689[(9)] = inst_32625);

return statearr_32689;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_32674__$1,(22),inst_32627);
} else {
if((state_val_32675 === (31))){
var inst_32656 = (state_32674[(2)]);
var state_32674__$1 = state_32674;
if(cljs.core.truth_(inst_32656)){
var statearr_32690_32746 = state_32674__$1;
(statearr_32690_32746[(1)] = (32));

} else {
var statearr_32691_32747 = state_32674__$1;
(statearr_32691_32747[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (32))){
var inst_32633 = (state_32674[(14)]);
var state_32674__$1 = state_32674;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32674__$1,(35),out,inst_32633);
} else {
if((state_val_32675 === (33))){
var inst_32624 = (state_32674[(12)]);
var inst_32601 = inst_32624;
var state_32674__$1 = (function (){var statearr_32692 = state_32674;
(statearr_32692[(7)] = inst_32601);

return statearr_32692;
})();
var statearr_32693_32748 = state_32674__$1;
(statearr_32693_32748[(2)] = null);

(statearr_32693_32748[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (13))){
var inst_32601 = (state_32674[(7)]);
var inst_32608 = inst_32601.cljs$lang$protocol_mask$partition0$;
var inst_32609 = (inst_32608 & (64));
var inst_32610 = inst_32601.cljs$core$ISeq$;
var inst_32611 = (cljs.core.PROTOCOL_SENTINEL === inst_32610);
var inst_32612 = (inst_32609) || (inst_32611);
var state_32674__$1 = state_32674;
if(cljs.core.truth_(inst_32612)){
var statearr_32694_32749 = state_32674__$1;
(statearr_32694_32749[(1)] = (16));

} else {
var statearr_32695_32750 = state_32674__$1;
(statearr_32695_32750[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (22))){
var inst_32634 = (state_32674[(10)]);
var inst_32633 = (state_32674[(14)]);
var inst_32632 = (state_32674[(2)]);
var inst_32633__$1 = cljs.core.nth.call(null,inst_32632,(0),null);
var inst_32634__$1 = cljs.core.nth.call(null,inst_32632,(1),null);
var inst_32635 = (inst_32633__$1 == null);
var inst_32636 = cljs.core._EQ_.call(null,inst_32634__$1,change);
var inst_32637 = (inst_32635) || (inst_32636);
var state_32674__$1 = (function (){var statearr_32696 = state_32674;
(statearr_32696[(10)] = inst_32634__$1);

(statearr_32696[(14)] = inst_32633__$1);

return statearr_32696;
})();
if(cljs.core.truth_(inst_32637)){
var statearr_32697_32751 = state_32674__$1;
(statearr_32697_32751[(1)] = (23));

} else {
var statearr_32698_32752 = state_32674__$1;
(statearr_32698_32752[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (36))){
var inst_32624 = (state_32674[(12)]);
var inst_32601 = inst_32624;
var state_32674__$1 = (function (){var statearr_32699 = state_32674;
(statearr_32699[(7)] = inst_32601);

return statearr_32699;
})();
var statearr_32700_32753 = state_32674__$1;
(statearr_32700_32753[(2)] = null);

(statearr_32700_32753[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (29))){
var inst_32648 = (state_32674[(11)]);
var state_32674__$1 = state_32674;
var statearr_32701_32754 = state_32674__$1;
(statearr_32701_32754[(2)] = inst_32648);

(statearr_32701_32754[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (6))){
var state_32674__$1 = state_32674;
var statearr_32702_32755 = state_32674__$1;
(statearr_32702_32755[(2)] = false);

(statearr_32702_32755[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (28))){
var inst_32644 = (state_32674[(2)]);
var inst_32645 = calc_state.call(null);
var inst_32601 = inst_32645;
var state_32674__$1 = (function (){var statearr_32703 = state_32674;
(statearr_32703[(7)] = inst_32601);

(statearr_32703[(15)] = inst_32644);

return statearr_32703;
})();
var statearr_32704_32756 = state_32674__$1;
(statearr_32704_32756[(2)] = null);

(statearr_32704_32756[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (25))){
var inst_32670 = (state_32674[(2)]);
var state_32674__$1 = state_32674;
var statearr_32705_32757 = state_32674__$1;
(statearr_32705_32757[(2)] = inst_32670);

(statearr_32705_32757[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (34))){
var inst_32668 = (state_32674[(2)]);
var state_32674__$1 = state_32674;
var statearr_32706_32758 = state_32674__$1;
(statearr_32706_32758[(2)] = inst_32668);

(statearr_32706_32758[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (17))){
var state_32674__$1 = state_32674;
var statearr_32707_32759 = state_32674__$1;
(statearr_32707_32759[(2)] = false);

(statearr_32707_32759[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (3))){
var state_32674__$1 = state_32674;
var statearr_32708_32760 = state_32674__$1;
(statearr_32708_32760[(2)] = false);

(statearr_32708_32760[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (12))){
var inst_32672 = (state_32674[(2)]);
var state_32674__$1 = state_32674;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32674__$1,inst_32672);
} else {
if((state_val_32675 === (2))){
var inst_32576 = (state_32674[(8)]);
var inst_32581 = inst_32576.cljs$lang$protocol_mask$partition0$;
var inst_32582 = (inst_32581 & (64));
var inst_32583 = inst_32576.cljs$core$ISeq$;
var inst_32584 = (cljs.core.PROTOCOL_SENTINEL === inst_32583);
var inst_32585 = (inst_32582) || (inst_32584);
var state_32674__$1 = state_32674;
if(cljs.core.truth_(inst_32585)){
var statearr_32709_32761 = state_32674__$1;
(statearr_32709_32761[(1)] = (5));

} else {
var statearr_32710_32762 = state_32674__$1;
(statearr_32710_32762[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (23))){
var inst_32633 = (state_32674[(14)]);
var inst_32639 = (inst_32633 == null);
var state_32674__$1 = state_32674;
if(cljs.core.truth_(inst_32639)){
var statearr_32711_32763 = state_32674__$1;
(statearr_32711_32763[(1)] = (26));

} else {
var statearr_32712_32764 = state_32674__$1;
(statearr_32712_32764[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (35))){
var inst_32659 = (state_32674[(2)]);
var state_32674__$1 = state_32674;
if(cljs.core.truth_(inst_32659)){
var statearr_32713_32765 = state_32674__$1;
(statearr_32713_32765[(1)] = (36));

} else {
var statearr_32714_32766 = state_32674__$1;
(statearr_32714_32766[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (19))){
var inst_32601 = (state_32674[(7)]);
var inst_32621 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32601);
var state_32674__$1 = state_32674;
var statearr_32715_32767 = state_32674__$1;
(statearr_32715_32767[(2)] = inst_32621);

(statearr_32715_32767[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (11))){
var inst_32601 = (state_32674[(7)]);
var inst_32605 = (inst_32601 == null);
var inst_32606 = cljs.core.not.call(null,inst_32605);
var state_32674__$1 = state_32674;
if(inst_32606){
var statearr_32716_32768 = state_32674__$1;
(statearr_32716_32768[(1)] = (13));

} else {
var statearr_32717_32769 = state_32674__$1;
(statearr_32717_32769[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (9))){
var inst_32576 = (state_32674[(8)]);
var state_32674__$1 = state_32674;
var statearr_32718_32770 = state_32674__$1;
(statearr_32718_32770[(2)] = inst_32576);

(statearr_32718_32770[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (5))){
var state_32674__$1 = state_32674;
var statearr_32719_32771 = state_32674__$1;
(statearr_32719_32771[(2)] = true);

(statearr_32719_32771[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (14))){
var state_32674__$1 = state_32674;
var statearr_32720_32772 = state_32674__$1;
(statearr_32720_32772[(2)] = false);

(statearr_32720_32772[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (26))){
var inst_32634 = (state_32674[(10)]);
var inst_32641 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_32634);
var state_32674__$1 = state_32674;
var statearr_32721_32773 = state_32674__$1;
(statearr_32721_32773[(2)] = inst_32641);

(statearr_32721_32773[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (16))){
var state_32674__$1 = state_32674;
var statearr_32722_32774 = state_32674__$1;
(statearr_32722_32774[(2)] = true);

(statearr_32722_32774[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (38))){
var inst_32664 = (state_32674[(2)]);
var state_32674__$1 = state_32674;
var statearr_32723_32775 = state_32674__$1;
(statearr_32723_32775[(2)] = inst_32664);

(statearr_32723_32775[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (30))){
var inst_32626 = (state_32674[(13)]);
var inst_32625 = (state_32674[(9)]);
var inst_32634 = (state_32674[(10)]);
var inst_32651 = cljs.core.empty_QMARK_.call(null,inst_32625);
var inst_32652 = inst_32626.call(null,inst_32634);
var inst_32653 = cljs.core.not.call(null,inst_32652);
var inst_32654 = (inst_32651) && (inst_32653);
var state_32674__$1 = state_32674;
var statearr_32724_32776 = state_32674__$1;
(statearr_32724_32776[(2)] = inst_32654);

(statearr_32724_32776[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (10))){
var inst_32576 = (state_32674[(8)]);
var inst_32597 = (state_32674[(2)]);
var inst_32598 = cljs.core.get.call(null,inst_32597,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_32599 = cljs.core.get.call(null,inst_32597,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_32600 = cljs.core.get.call(null,inst_32597,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_32601 = inst_32576;
var state_32674__$1 = (function (){var statearr_32725 = state_32674;
(statearr_32725[(16)] = inst_32598);

(statearr_32725[(17)] = inst_32599);

(statearr_32725[(7)] = inst_32601);

(statearr_32725[(18)] = inst_32600);

return statearr_32725;
})();
var statearr_32726_32777 = state_32674__$1;
(statearr_32726_32777[(2)] = null);

(statearr_32726_32777[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (18))){
var inst_32616 = (state_32674[(2)]);
var state_32674__$1 = state_32674;
var statearr_32727_32778 = state_32674__$1;
(statearr_32727_32778[(2)] = inst_32616);

(statearr_32727_32778[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (37))){
var state_32674__$1 = state_32674;
var statearr_32728_32779 = state_32674__$1;
(statearr_32728_32779[(2)] = null);

(statearr_32728_32779[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32675 === (8))){
var inst_32576 = (state_32674[(8)]);
var inst_32594 = cljs.core.apply.call(null,cljs.core.hash_map,inst_32576);
var state_32674__$1 = state_32674;
var statearr_32729_32780 = state_32674__$1;
(statearr_32729_32780[(2)] = inst_32594);

(statearr_32729_32780[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___32734,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__31585__auto__,c__31675__auto___32734,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__31586__auto__ = null;
var cljs$core$async$mix_$_state_machine__31586__auto____0 = (function (){
var statearr_32730 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32730[(0)] = cljs$core$async$mix_$_state_machine__31586__auto__);

(statearr_32730[(1)] = (1));

return statearr_32730;
});
var cljs$core$async$mix_$_state_machine__31586__auto____1 = (function (state_32674){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_32674);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e32731){if((e32731 instanceof Object)){
var ex__31589__auto__ = e32731;
var statearr_32732_32781 = state_32674;
(statearr_32732_32781[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32674);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32731;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32782 = state_32674;
state_32674 = G__32782;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__31586__auto__ = function(state_32674){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__31586__auto____1.call(this,state_32674);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__31586__auto____0;
cljs$core$async$mix_$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__31586__auto____1;
return cljs$core$async$mix_$_state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___32734,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__31677__auto__ = (function (){var statearr_32733 = f__31676__auto__.call(null);
(statearr_32733[(6)] = c__31675__auto___32734);

return statearr_32733;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___32734,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__29352__auto__ = (((p == null))?null:p);
var m__29353__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__29353__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__29352__auto__ = (((p == null))?null:p);
var m__29353__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,p,v,ch);
} else {
var m__29353__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__32784 = arguments.length;
switch (G__32784) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__29352__auto__ = (((p == null))?null:p);
var m__29353__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,p);
} else {
var m__29353__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__29352__auto__ = (((p == null))?null:p);
var m__29353__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__29352__auto__)]);
if(!((m__29353__auto__ == null))){
return m__29353__auto__.call(null,p,v);
} else {
var m__29353__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__29353__auto____$1 == null))){
return m__29353__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__32788 = arguments.length;
switch (G__32788) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__28633__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__28633__auto__)){
return or__28633__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__28633__auto__,mults){
return (function (p1__32786_SHARP_){
if(cljs.core.truth_(p1__32786_SHARP_.call(null,topic))){
return p1__32786_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__32786_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__28633__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async32789 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async32789 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta32790){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta32790 = meta32790;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async32789.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_32791,meta32790__$1){
var self__ = this;
var _32791__$1 = this;
return (new cljs.core.async.t_cljs$core$async32789(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta32790__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32789.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_32791){
var self__ = this;
var _32791__$1 = this;
return self__.meta32790;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32789.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32789.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32789.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async32789.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32789.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5278__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5278__auto__)){
var m = temp__5278__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32789.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32789.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32789.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta32790","meta32790",1502979359,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async32789.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async32789.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async32789";

cljs.core.async.t_cljs$core$async32789.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__29290__auto__,writer__29291__auto__,opt__29292__auto__){
return cljs.core._write.call(null,writer__29291__auto__,"cljs.core.async/t_cljs$core$async32789");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async32789 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async32789(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32790){
return (new cljs.core.async.t_cljs$core$async32789(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta32790));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async32789(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__31675__auto___32909 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___32909,mults,ensure_mult,p){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___32909,mults,ensure_mult,p){
return (function (state_32863){
var state_val_32864 = (state_32863[(1)]);
if((state_val_32864 === (7))){
var inst_32859 = (state_32863[(2)]);
var state_32863__$1 = state_32863;
var statearr_32865_32910 = state_32863__$1;
(statearr_32865_32910[(2)] = inst_32859);

(statearr_32865_32910[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (20))){
var state_32863__$1 = state_32863;
var statearr_32866_32911 = state_32863__$1;
(statearr_32866_32911[(2)] = null);

(statearr_32866_32911[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (1))){
var state_32863__$1 = state_32863;
var statearr_32867_32912 = state_32863__$1;
(statearr_32867_32912[(2)] = null);

(statearr_32867_32912[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (24))){
var inst_32842 = (state_32863[(7)]);
var inst_32851 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_32842);
var state_32863__$1 = state_32863;
var statearr_32868_32913 = state_32863__$1;
(statearr_32868_32913[(2)] = inst_32851);

(statearr_32868_32913[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (4))){
var inst_32794 = (state_32863[(8)]);
var inst_32794__$1 = (state_32863[(2)]);
var inst_32795 = (inst_32794__$1 == null);
var state_32863__$1 = (function (){var statearr_32869 = state_32863;
(statearr_32869[(8)] = inst_32794__$1);

return statearr_32869;
})();
if(cljs.core.truth_(inst_32795)){
var statearr_32870_32914 = state_32863__$1;
(statearr_32870_32914[(1)] = (5));

} else {
var statearr_32871_32915 = state_32863__$1;
(statearr_32871_32915[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (15))){
var inst_32836 = (state_32863[(2)]);
var state_32863__$1 = state_32863;
var statearr_32872_32916 = state_32863__$1;
(statearr_32872_32916[(2)] = inst_32836);

(statearr_32872_32916[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (21))){
var inst_32856 = (state_32863[(2)]);
var state_32863__$1 = (function (){var statearr_32873 = state_32863;
(statearr_32873[(9)] = inst_32856);

return statearr_32873;
})();
var statearr_32874_32917 = state_32863__$1;
(statearr_32874_32917[(2)] = null);

(statearr_32874_32917[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (13))){
var inst_32818 = (state_32863[(10)]);
var inst_32820 = cljs.core.chunked_seq_QMARK_.call(null,inst_32818);
var state_32863__$1 = state_32863;
if(inst_32820){
var statearr_32875_32918 = state_32863__$1;
(statearr_32875_32918[(1)] = (16));

} else {
var statearr_32876_32919 = state_32863__$1;
(statearr_32876_32919[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (22))){
var inst_32848 = (state_32863[(2)]);
var state_32863__$1 = state_32863;
if(cljs.core.truth_(inst_32848)){
var statearr_32877_32920 = state_32863__$1;
(statearr_32877_32920[(1)] = (23));

} else {
var statearr_32878_32921 = state_32863__$1;
(statearr_32878_32921[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (6))){
var inst_32844 = (state_32863[(11)]);
var inst_32842 = (state_32863[(7)]);
var inst_32794 = (state_32863[(8)]);
var inst_32842__$1 = topic_fn.call(null,inst_32794);
var inst_32843 = cljs.core.deref.call(null,mults);
var inst_32844__$1 = cljs.core.get.call(null,inst_32843,inst_32842__$1);
var state_32863__$1 = (function (){var statearr_32879 = state_32863;
(statearr_32879[(11)] = inst_32844__$1);

(statearr_32879[(7)] = inst_32842__$1);

return statearr_32879;
})();
if(cljs.core.truth_(inst_32844__$1)){
var statearr_32880_32922 = state_32863__$1;
(statearr_32880_32922[(1)] = (19));

} else {
var statearr_32881_32923 = state_32863__$1;
(statearr_32881_32923[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (25))){
var inst_32853 = (state_32863[(2)]);
var state_32863__$1 = state_32863;
var statearr_32882_32924 = state_32863__$1;
(statearr_32882_32924[(2)] = inst_32853);

(statearr_32882_32924[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (17))){
var inst_32818 = (state_32863[(10)]);
var inst_32827 = cljs.core.first.call(null,inst_32818);
var inst_32828 = cljs.core.async.muxch_STAR_.call(null,inst_32827);
var inst_32829 = cljs.core.async.close_BANG_.call(null,inst_32828);
var inst_32830 = cljs.core.next.call(null,inst_32818);
var inst_32804 = inst_32830;
var inst_32805 = null;
var inst_32806 = (0);
var inst_32807 = (0);
var state_32863__$1 = (function (){var statearr_32883 = state_32863;
(statearr_32883[(12)] = inst_32806);

(statearr_32883[(13)] = inst_32807);

(statearr_32883[(14)] = inst_32829);

(statearr_32883[(15)] = inst_32804);

(statearr_32883[(16)] = inst_32805);

return statearr_32883;
})();
var statearr_32884_32925 = state_32863__$1;
(statearr_32884_32925[(2)] = null);

(statearr_32884_32925[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (3))){
var inst_32861 = (state_32863[(2)]);
var state_32863__$1 = state_32863;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32863__$1,inst_32861);
} else {
if((state_val_32864 === (12))){
var inst_32838 = (state_32863[(2)]);
var state_32863__$1 = state_32863;
var statearr_32885_32926 = state_32863__$1;
(statearr_32885_32926[(2)] = inst_32838);

(statearr_32885_32926[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (2))){
var state_32863__$1 = state_32863;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32863__$1,(4),ch);
} else {
if((state_val_32864 === (23))){
var state_32863__$1 = state_32863;
var statearr_32886_32927 = state_32863__$1;
(statearr_32886_32927[(2)] = null);

(statearr_32886_32927[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (19))){
var inst_32844 = (state_32863[(11)]);
var inst_32794 = (state_32863[(8)]);
var inst_32846 = cljs.core.async.muxch_STAR_.call(null,inst_32844);
var state_32863__$1 = state_32863;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32863__$1,(22),inst_32846,inst_32794);
} else {
if((state_val_32864 === (11))){
var inst_32818 = (state_32863[(10)]);
var inst_32804 = (state_32863[(15)]);
var inst_32818__$1 = cljs.core.seq.call(null,inst_32804);
var state_32863__$1 = (function (){var statearr_32887 = state_32863;
(statearr_32887[(10)] = inst_32818__$1);

return statearr_32887;
})();
if(inst_32818__$1){
var statearr_32888_32928 = state_32863__$1;
(statearr_32888_32928[(1)] = (13));

} else {
var statearr_32889_32929 = state_32863__$1;
(statearr_32889_32929[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (9))){
var inst_32840 = (state_32863[(2)]);
var state_32863__$1 = state_32863;
var statearr_32890_32930 = state_32863__$1;
(statearr_32890_32930[(2)] = inst_32840);

(statearr_32890_32930[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (5))){
var inst_32801 = cljs.core.deref.call(null,mults);
var inst_32802 = cljs.core.vals.call(null,inst_32801);
var inst_32803 = cljs.core.seq.call(null,inst_32802);
var inst_32804 = inst_32803;
var inst_32805 = null;
var inst_32806 = (0);
var inst_32807 = (0);
var state_32863__$1 = (function (){var statearr_32891 = state_32863;
(statearr_32891[(12)] = inst_32806);

(statearr_32891[(13)] = inst_32807);

(statearr_32891[(15)] = inst_32804);

(statearr_32891[(16)] = inst_32805);

return statearr_32891;
})();
var statearr_32892_32931 = state_32863__$1;
(statearr_32892_32931[(2)] = null);

(statearr_32892_32931[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (14))){
var state_32863__$1 = state_32863;
var statearr_32896_32932 = state_32863__$1;
(statearr_32896_32932[(2)] = null);

(statearr_32896_32932[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (16))){
var inst_32818 = (state_32863[(10)]);
var inst_32822 = cljs.core.chunk_first.call(null,inst_32818);
var inst_32823 = cljs.core.chunk_rest.call(null,inst_32818);
var inst_32824 = cljs.core.count.call(null,inst_32822);
var inst_32804 = inst_32823;
var inst_32805 = inst_32822;
var inst_32806 = inst_32824;
var inst_32807 = (0);
var state_32863__$1 = (function (){var statearr_32897 = state_32863;
(statearr_32897[(12)] = inst_32806);

(statearr_32897[(13)] = inst_32807);

(statearr_32897[(15)] = inst_32804);

(statearr_32897[(16)] = inst_32805);

return statearr_32897;
})();
var statearr_32898_32933 = state_32863__$1;
(statearr_32898_32933[(2)] = null);

(statearr_32898_32933[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (10))){
var inst_32806 = (state_32863[(12)]);
var inst_32807 = (state_32863[(13)]);
var inst_32804 = (state_32863[(15)]);
var inst_32805 = (state_32863[(16)]);
var inst_32812 = cljs.core._nth.call(null,inst_32805,inst_32807);
var inst_32813 = cljs.core.async.muxch_STAR_.call(null,inst_32812);
var inst_32814 = cljs.core.async.close_BANG_.call(null,inst_32813);
var inst_32815 = (inst_32807 + (1));
var tmp32893 = inst_32806;
var tmp32894 = inst_32804;
var tmp32895 = inst_32805;
var inst_32804__$1 = tmp32894;
var inst_32805__$1 = tmp32895;
var inst_32806__$1 = tmp32893;
var inst_32807__$1 = inst_32815;
var state_32863__$1 = (function (){var statearr_32899 = state_32863;
(statearr_32899[(12)] = inst_32806__$1);

(statearr_32899[(13)] = inst_32807__$1);

(statearr_32899[(17)] = inst_32814);

(statearr_32899[(15)] = inst_32804__$1);

(statearr_32899[(16)] = inst_32805__$1);

return statearr_32899;
})();
var statearr_32900_32934 = state_32863__$1;
(statearr_32900_32934[(2)] = null);

(statearr_32900_32934[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (18))){
var inst_32833 = (state_32863[(2)]);
var state_32863__$1 = state_32863;
var statearr_32901_32935 = state_32863__$1;
(statearr_32901_32935[(2)] = inst_32833);

(statearr_32901_32935[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32864 === (8))){
var inst_32806 = (state_32863[(12)]);
var inst_32807 = (state_32863[(13)]);
var inst_32809 = (inst_32807 < inst_32806);
var inst_32810 = inst_32809;
var state_32863__$1 = state_32863;
if(cljs.core.truth_(inst_32810)){
var statearr_32902_32936 = state_32863__$1;
(statearr_32902_32936[(1)] = (10));

} else {
var statearr_32903_32937 = state_32863__$1;
(statearr_32903_32937[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___32909,mults,ensure_mult,p))
;
return ((function (switch__31585__auto__,c__31675__auto___32909,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__31586__auto__ = null;
var cljs$core$async$state_machine__31586__auto____0 = (function (){
var statearr_32904 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32904[(0)] = cljs$core$async$state_machine__31586__auto__);

(statearr_32904[(1)] = (1));

return statearr_32904;
});
var cljs$core$async$state_machine__31586__auto____1 = (function (state_32863){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_32863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e32905){if((e32905 instanceof Object)){
var ex__31589__auto__ = e32905;
var statearr_32906_32938 = state_32863;
(statearr_32906_32938[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32863);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e32905;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__32939 = state_32863;
state_32863 = G__32939;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$state_machine__31586__auto__ = function(state_32863){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31586__auto____1.call(this,state_32863);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31586__auto____0;
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31586__auto____1;
return cljs$core$async$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___32909,mults,ensure_mult,p))
})();
var state__31677__auto__ = (function (){var statearr_32907 = f__31676__auto__.call(null);
(statearr_32907[(6)] = c__31675__auto___32909);

return statearr_32907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___32909,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__32941 = arguments.length;
switch (G__32941) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__32944 = arguments.length;
switch (G__32944) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__32947 = arguments.length;
switch (G__32947) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__31675__auto___33014 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___33014,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___33014,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_32986){
var state_val_32987 = (state_32986[(1)]);
if((state_val_32987 === (7))){
var state_32986__$1 = state_32986;
var statearr_32988_33015 = state_32986__$1;
(statearr_32988_33015[(2)] = null);

(statearr_32988_33015[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (1))){
var state_32986__$1 = state_32986;
var statearr_32989_33016 = state_32986__$1;
(statearr_32989_33016[(2)] = null);

(statearr_32989_33016[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (4))){
var inst_32950 = (state_32986[(7)]);
var inst_32952 = (inst_32950 < cnt);
var state_32986__$1 = state_32986;
if(cljs.core.truth_(inst_32952)){
var statearr_32990_33017 = state_32986__$1;
(statearr_32990_33017[(1)] = (6));

} else {
var statearr_32991_33018 = state_32986__$1;
(statearr_32991_33018[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (15))){
var inst_32982 = (state_32986[(2)]);
var state_32986__$1 = state_32986;
var statearr_32992_33019 = state_32986__$1;
(statearr_32992_33019[(2)] = inst_32982);

(statearr_32992_33019[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (13))){
var inst_32975 = cljs.core.async.close_BANG_.call(null,out);
var state_32986__$1 = state_32986;
var statearr_32993_33020 = state_32986__$1;
(statearr_32993_33020[(2)] = inst_32975);

(statearr_32993_33020[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (6))){
var state_32986__$1 = state_32986;
var statearr_32994_33021 = state_32986__$1;
(statearr_32994_33021[(2)] = null);

(statearr_32994_33021[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (3))){
var inst_32984 = (state_32986[(2)]);
var state_32986__$1 = state_32986;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_32986__$1,inst_32984);
} else {
if((state_val_32987 === (12))){
var inst_32972 = (state_32986[(8)]);
var inst_32972__$1 = (state_32986[(2)]);
var inst_32973 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_32972__$1);
var state_32986__$1 = (function (){var statearr_32995 = state_32986;
(statearr_32995[(8)] = inst_32972__$1);

return statearr_32995;
})();
if(cljs.core.truth_(inst_32973)){
var statearr_32996_33022 = state_32986__$1;
(statearr_32996_33022[(1)] = (13));

} else {
var statearr_32997_33023 = state_32986__$1;
(statearr_32997_33023[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (2))){
var inst_32949 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_32950 = (0);
var state_32986__$1 = (function (){var statearr_32998 = state_32986;
(statearr_32998[(9)] = inst_32949);

(statearr_32998[(7)] = inst_32950);

return statearr_32998;
})();
var statearr_32999_33024 = state_32986__$1;
(statearr_32999_33024[(2)] = null);

(statearr_32999_33024[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (11))){
var inst_32950 = (state_32986[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_32986,(10),Object,null,(9));
var inst_32959 = chs__$1.call(null,inst_32950);
var inst_32960 = done.call(null,inst_32950);
var inst_32961 = cljs.core.async.take_BANG_.call(null,inst_32959,inst_32960);
var state_32986__$1 = state_32986;
var statearr_33000_33025 = state_32986__$1;
(statearr_33000_33025[(2)] = inst_32961);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32986__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (9))){
var inst_32950 = (state_32986[(7)]);
var inst_32963 = (state_32986[(2)]);
var inst_32964 = (inst_32950 + (1));
var inst_32950__$1 = inst_32964;
var state_32986__$1 = (function (){var statearr_33001 = state_32986;
(statearr_33001[(10)] = inst_32963);

(statearr_33001[(7)] = inst_32950__$1);

return statearr_33001;
})();
var statearr_33002_33026 = state_32986__$1;
(statearr_33002_33026[(2)] = null);

(statearr_33002_33026[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (5))){
var inst_32970 = (state_32986[(2)]);
var state_32986__$1 = (function (){var statearr_33003 = state_32986;
(statearr_33003[(11)] = inst_32970);

return statearr_33003;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_32986__$1,(12),dchan);
} else {
if((state_val_32987 === (14))){
var inst_32972 = (state_32986[(8)]);
var inst_32977 = cljs.core.apply.call(null,f,inst_32972);
var state_32986__$1 = state_32986;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_32986__$1,(16),out,inst_32977);
} else {
if((state_val_32987 === (16))){
var inst_32979 = (state_32986[(2)]);
var state_32986__$1 = (function (){var statearr_33004 = state_32986;
(statearr_33004[(12)] = inst_32979);

return statearr_33004;
})();
var statearr_33005_33027 = state_32986__$1;
(statearr_33005_33027[(2)] = null);

(statearr_33005_33027[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (10))){
var inst_32954 = (state_32986[(2)]);
var inst_32955 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_32986__$1 = (function (){var statearr_33006 = state_32986;
(statearr_33006[(13)] = inst_32954);

return statearr_33006;
})();
var statearr_33007_33028 = state_32986__$1;
(statearr_33007_33028[(2)] = inst_32955);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32986__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_32987 === (8))){
var inst_32968 = (state_32986[(2)]);
var state_32986__$1 = state_32986;
var statearr_33008_33029 = state_32986__$1;
(statearr_33008_33029[(2)] = inst_32968);

(statearr_33008_33029[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___33014,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__31585__auto__,c__31675__auto___33014,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__31586__auto__ = null;
var cljs$core$async$state_machine__31586__auto____0 = (function (){
var statearr_33009 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33009[(0)] = cljs$core$async$state_machine__31586__auto__);

(statearr_33009[(1)] = (1));

return statearr_33009;
});
var cljs$core$async$state_machine__31586__auto____1 = (function (state_32986){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_32986);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e33010){if((e33010 instanceof Object)){
var ex__31589__auto__ = e33010;
var statearr_33011_33030 = state_32986;
(statearr_33011_33030[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_32986);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33010;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33031 = state_32986;
state_32986 = G__33031;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$state_machine__31586__auto__ = function(state_32986){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31586__auto____1.call(this,state_32986);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31586__auto____0;
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31586__auto____1;
return cljs$core$async$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___33014,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__31677__auto__ = (function (){var statearr_33012 = f__31676__auto__.call(null);
(statearr_33012[(6)] = c__31675__auto___33014);

return statearr_33012;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___33014,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__33034 = arguments.length;
switch (G__33034) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31675__auto___33088 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___33088,out){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___33088,out){
return (function (state_33066){
var state_val_33067 = (state_33066[(1)]);
if((state_val_33067 === (7))){
var inst_33046 = (state_33066[(7)]);
var inst_33045 = (state_33066[(8)]);
var inst_33045__$1 = (state_33066[(2)]);
var inst_33046__$1 = cljs.core.nth.call(null,inst_33045__$1,(0),null);
var inst_33047 = cljs.core.nth.call(null,inst_33045__$1,(1),null);
var inst_33048 = (inst_33046__$1 == null);
var state_33066__$1 = (function (){var statearr_33068 = state_33066;
(statearr_33068[(7)] = inst_33046__$1);

(statearr_33068[(8)] = inst_33045__$1);

(statearr_33068[(9)] = inst_33047);

return statearr_33068;
})();
if(cljs.core.truth_(inst_33048)){
var statearr_33069_33089 = state_33066__$1;
(statearr_33069_33089[(1)] = (8));

} else {
var statearr_33070_33090 = state_33066__$1;
(statearr_33070_33090[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (1))){
var inst_33035 = cljs.core.vec.call(null,chs);
var inst_33036 = inst_33035;
var state_33066__$1 = (function (){var statearr_33071 = state_33066;
(statearr_33071[(10)] = inst_33036);

return statearr_33071;
})();
var statearr_33072_33091 = state_33066__$1;
(statearr_33072_33091[(2)] = null);

(statearr_33072_33091[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (4))){
var inst_33036 = (state_33066[(10)]);
var state_33066__$1 = state_33066;
return cljs.core.async.ioc_alts_BANG_.call(null,state_33066__$1,(7),inst_33036);
} else {
if((state_val_33067 === (6))){
var inst_33062 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
var statearr_33073_33092 = state_33066__$1;
(statearr_33073_33092[(2)] = inst_33062);

(statearr_33073_33092[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (3))){
var inst_33064 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33066__$1,inst_33064);
} else {
if((state_val_33067 === (2))){
var inst_33036 = (state_33066[(10)]);
var inst_33038 = cljs.core.count.call(null,inst_33036);
var inst_33039 = (inst_33038 > (0));
var state_33066__$1 = state_33066;
if(cljs.core.truth_(inst_33039)){
var statearr_33075_33093 = state_33066__$1;
(statearr_33075_33093[(1)] = (4));

} else {
var statearr_33076_33094 = state_33066__$1;
(statearr_33076_33094[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (11))){
var inst_33036 = (state_33066[(10)]);
var inst_33055 = (state_33066[(2)]);
var tmp33074 = inst_33036;
var inst_33036__$1 = tmp33074;
var state_33066__$1 = (function (){var statearr_33077 = state_33066;
(statearr_33077[(10)] = inst_33036__$1);

(statearr_33077[(11)] = inst_33055);

return statearr_33077;
})();
var statearr_33078_33095 = state_33066__$1;
(statearr_33078_33095[(2)] = null);

(statearr_33078_33095[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (9))){
var inst_33046 = (state_33066[(7)]);
var state_33066__$1 = state_33066;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33066__$1,(11),out,inst_33046);
} else {
if((state_val_33067 === (5))){
var inst_33060 = cljs.core.async.close_BANG_.call(null,out);
var state_33066__$1 = state_33066;
var statearr_33079_33096 = state_33066__$1;
(statearr_33079_33096[(2)] = inst_33060);

(statearr_33079_33096[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (10))){
var inst_33058 = (state_33066[(2)]);
var state_33066__$1 = state_33066;
var statearr_33080_33097 = state_33066__$1;
(statearr_33080_33097[(2)] = inst_33058);

(statearr_33080_33097[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33067 === (8))){
var inst_33036 = (state_33066[(10)]);
var inst_33046 = (state_33066[(7)]);
var inst_33045 = (state_33066[(8)]);
var inst_33047 = (state_33066[(9)]);
var inst_33050 = (function (){var cs = inst_33036;
var vec__33041 = inst_33045;
var v = inst_33046;
var c = inst_33047;
return ((function (cs,vec__33041,v,c,inst_33036,inst_33046,inst_33045,inst_33047,state_val_33067,c__31675__auto___33088,out){
return (function (p1__33032_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__33032_SHARP_);
});
;})(cs,vec__33041,v,c,inst_33036,inst_33046,inst_33045,inst_33047,state_val_33067,c__31675__auto___33088,out))
})();
var inst_33051 = cljs.core.filterv.call(null,inst_33050,inst_33036);
var inst_33036__$1 = inst_33051;
var state_33066__$1 = (function (){var statearr_33081 = state_33066;
(statearr_33081[(10)] = inst_33036__$1);

return statearr_33081;
})();
var statearr_33082_33098 = state_33066__$1;
(statearr_33082_33098[(2)] = null);

(statearr_33082_33098[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___33088,out))
;
return ((function (switch__31585__auto__,c__31675__auto___33088,out){
return (function() {
var cljs$core$async$state_machine__31586__auto__ = null;
var cljs$core$async$state_machine__31586__auto____0 = (function (){
var statearr_33083 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33083[(0)] = cljs$core$async$state_machine__31586__auto__);

(statearr_33083[(1)] = (1));

return statearr_33083;
});
var cljs$core$async$state_machine__31586__auto____1 = (function (state_33066){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_33066);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e33084){if((e33084 instanceof Object)){
var ex__31589__auto__ = e33084;
var statearr_33085_33099 = state_33066;
(statearr_33085_33099[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33066);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33084;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33100 = state_33066;
state_33066 = G__33100;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$state_machine__31586__auto__ = function(state_33066){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31586__auto____1.call(this,state_33066);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31586__auto____0;
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31586__auto____1;
return cljs$core$async$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___33088,out))
})();
var state__31677__auto__ = (function (){var statearr_33086 = f__31676__auto__.call(null);
(statearr_33086[(6)] = c__31675__auto___33088);

return statearr_33086;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___33088,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__33102 = arguments.length;
switch (G__33102) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31675__auto___33147 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___33147,out){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___33147,out){
return (function (state_33126){
var state_val_33127 = (state_33126[(1)]);
if((state_val_33127 === (7))){
var inst_33108 = (state_33126[(7)]);
var inst_33108__$1 = (state_33126[(2)]);
var inst_33109 = (inst_33108__$1 == null);
var inst_33110 = cljs.core.not.call(null,inst_33109);
var state_33126__$1 = (function (){var statearr_33128 = state_33126;
(statearr_33128[(7)] = inst_33108__$1);

return statearr_33128;
})();
if(inst_33110){
var statearr_33129_33148 = state_33126__$1;
(statearr_33129_33148[(1)] = (8));

} else {
var statearr_33130_33149 = state_33126__$1;
(statearr_33130_33149[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33127 === (1))){
var inst_33103 = (0);
var state_33126__$1 = (function (){var statearr_33131 = state_33126;
(statearr_33131[(8)] = inst_33103);

return statearr_33131;
})();
var statearr_33132_33150 = state_33126__$1;
(statearr_33132_33150[(2)] = null);

(statearr_33132_33150[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33127 === (4))){
var state_33126__$1 = state_33126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33126__$1,(7),ch);
} else {
if((state_val_33127 === (6))){
var inst_33121 = (state_33126[(2)]);
var state_33126__$1 = state_33126;
var statearr_33133_33151 = state_33126__$1;
(statearr_33133_33151[(2)] = inst_33121);

(statearr_33133_33151[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33127 === (3))){
var inst_33123 = (state_33126[(2)]);
var inst_33124 = cljs.core.async.close_BANG_.call(null,out);
var state_33126__$1 = (function (){var statearr_33134 = state_33126;
(statearr_33134[(9)] = inst_33123);

return statearr_33134;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33126__$1,inst_33124);
} else {
if((state_val_33127 === (2))){
var inst_33103 = (state_33126[(8)]);
var inst_33105 = (inst_33103 < n);
var state_33126__$1 = state_33126;
if(cljs.core.truth_(inst_33105)){
var statearr_33135_33152 = state_33126__$1;
(statearr_33135_33152[(1)] = (4));

} else {
var statearr_33136_33153 = state_33126__$1;
(statearr_33136_33153[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33127 === (11))){
var inst_33103 = (state_33126[(8)]);
var inst_33113 = (state_33126[(2)]);
var inst_33114 = (inst_33103 + (1));
var inst_33103__$1 = inst_33114;
var state_33126__$1 = (function (){var statearr_33137 = state_33126;
(statearr_33137[(8)] = inst_33103__$1);

(statearr_33137[(10)] = inst_33113);

return statearr_33137;
})();
var statearr_33138_33154 = state_33126__$1;
(statearr_33138_33154[(2)] = null);

(statearr_33138_33154[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33127 === (9))){
var state_33126__$1 = state_33126;
var statearr_33139_33155 = state_33126__$1;
(statearr_33139_33155[(2)] = null);

(statearr_33139_33155[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33127 === (5))){
var state_33126__$1 = state_33126;
var statearr_33140_33156 = state_33126__$1;
(statearr_33140_33156[(2)] = null);

(statearr_33140_33156[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33127 === (10))){
var inst_33118 = (state_33126[(2)]);
var state_33126__$1 = state_33126;
var statearr_33141_33157 = state_33126__$1;
(statearr_33141_33157[(2)] = inst_33118);

(statearr_33141_33157[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33127 === (8))){
var inst_33108 = (state_33126[(7)]);
var state_33126__$1 = state_33126;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33126__$1,(11),out,inst_33108);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___33147,out))
;
return ((function (switch__31585__auto__,c__31675__auto___33147,out){
return (function() {
var cljs$core$async$state_machine__31586__auto__ = null;
var cljs$core$async$state_machine__31586__auto____0 = (function (){
var statearr_33142 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33142[(0)] = cljs$core$async$state_machine__31586__auto__);

(statearr_33142[(1)] = (1));

return statearr_33142;
});
var cljs$core$async$state_machine__31586__auto____1 = (function (state_33126){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_33126);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e33143){if((e33143 instanceof Object)){
var ex__31589__auto__ = e33143;
var statearr_33144_33158 = state_33126;
(statearr_33144_33158[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33126);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33143;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33159 = state_33126;
state_33126 = G__33159;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$state_machine__31586__auto__ = function(state_33126){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31586__auto____1.call(this,state_33126);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31586__auto____0;
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31586__auto____1;
return cljs$core$async$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___33147,out))
})();
var state__31677__auto__ = (function (){var statearr_33145 = f__31676__auto__.call(null);
(statearr_33145[(6)] = c__31675__auto___33147);

return statearr_33145;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___33147,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33161 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33161 = (function (f,ch,meta33162){
this.f = f;
this.ch = ch;
this.meta33162 = meta33162;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33161.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33163,meta33162__$1){
var self__ = this;
var _33163__$1 = this;
return (new cljs.core.async.t_cljs$core$async33161(self__.f,self__.ch,meta33162__$1));
});

cljs.core.async.t_cljs$core$async33161.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33163){
var self__ = this;
var _33163__$1 = this;
return self__.meta33162;
});

cljs.core.async.t_cljs$core$async33161.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33161.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33161.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33161.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33161.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async33164 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33164 = (function (f,ch,meta33162,_,fn1,meta33165){
this.f = f;
this.ch = ch;
this.meta33162 = meta33162;
this._ = _;
this.fn1 = fn1;
this.meta33165 = meta33165;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33164.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_33166,meta33165__$1){
var self__ = this;
var _33166__$1 = this;
return (new cljs.core.async.t_cljs$core$async33164(self__.f,self__.ch,self__.meta33162,self__._,self__.fn1,meta33165__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async33164.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_33166){
var self__ = this;
var _33166__$1 = this;
return self__.meta33165;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33164.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33164.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33164.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async33164.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__33160_SHARP_){
return f1.call(null,(((p1__33160_SHARP_ == null))?null:self__.f.call(null,p1__33160_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async33164.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33162","meta33162",-342123171,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async33161","cljs.core.async/t_cljs$core$async33161",84848560,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta33165","meta33165",-54500903,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async33164.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33164.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33164";

cljs.core.async.t_cljs$core$async33164.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__29290__auto__,writer__29291__auto__,opt__29292__auto__){
return cljs.core._write.call(null,writer__29291__auto__,"cljs.core.async/t_cljs$core$async33164");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async33164 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33164(f__$1,ch__$1,meta33162__$1,___$2,fn1__$1,meta33165){
return (new cljs.core.async.t_cljs$core$async33164(f__$1,ch__$1,meta33162__$1,___$2,fn1__$1,meta33165));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async33164(self__.f,self__.ch,self__.meta33162,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__28621__auto__ = ret;
if(cljs.core.truth_(and__28621__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__28621__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async33161.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33161.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async33161.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33162","meta33162",-342123171,null)], null);
});

cljs.core.async.t_cljs$core$async33161.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33161.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33161";

cljs.core.async.t_cljs$core$async33161.cljs$lang$ctorPrWriter = (function (this__29290__auto__,writer__29291__auto__,opt__29292__auto__){
return cljs.core._write.call(null,writer__29291__auto__,"cljs.core.async/t_cljs$core$async33161");
});

cljs.core.async.__GT_t_cljs$core$async33161 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async33161(f__$1,ch__$1,meta33162){
return (new cljs.core.async.t_cljs$core$async33161(f__$1,ch__$1,meta33162));
});

}

return (new cljs.core.async.t_cljs$core$async33161(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async33167 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33167 = (function (f,ch,meta33168){
this.f = f;
this.ch = ch;
this.meta33168 = meta33168;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33167.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33169,meta33168__$1){
var self__ = this;
var _33169__$1 = this;
return (new cljs.core.async.t_cljs$core$async33167(self__.f,self__.ch,meta33168__$1));
});

cljs.core.async.t_cljs$core$async33167.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33169){
var self__ = this;
var _33169__$1 = this;
return self__.meta33168;
});

cljs.core.async.t_cljs$core$async33167.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33167.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33167.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33167.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33167.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33167.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async33167.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33168","meta33168",1370537809,null)], null);
});

cljs.core.async.t_cljs$core$async33167.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33167.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33167";

cljs.core.async.t_cljs$core$async33167.cljs$lang$ctorPrWriter = (function (this__29290__auto__,writer__29291__auto__,opt__29292__auto__){
return cljs.core._write.call(null,writer__29291__auto__,"cljs.core.async/t_cljs$core$async33167");
});

cljs.core.async.__GT_t_cljs$core$async33167 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async33167(f__$1,ch__$1,meta33168){
return (new cljs.core.async.t_cljs$core$async33167(f__$1,ch__$1,meta33168));
});

}

return (new cljs.core.async.t_cljs$core$async33167(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async33170 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async33170 = (function (p,ch,meta33171){
this.p = p;
this.ch = ch;
this.meta33171 = meta33171;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async33170.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_33172,meta33171__$1){
var self__ = this;
var _33172__$1 = this;
return (new cljs.core.async.t_cljs$core$async33170(self__.p,self__.ch,meta33171__$1));
});

cljs.core.async.t_cljs$core$async33170.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_33172){
var self__ = this;
var _33172__$1 = this;
return self__.meta33171;
});

cljs.core.async.t_cljs$core$async33170.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33170.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33170.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async33170.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33170.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async33170.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async33170.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async33170.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta33171","meta33171",-1974359847,null)], null);
});

cljs.core.async.t_cljs$core$async33170.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async33170.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async33170";

cljs.core.async.t_cljs$core$async33170.cljs$lang$ctorPrWriter = (function (this__29290__auto__,writer__29291__auto__,opt__29292__auto__){
return cljs.core._write.call(null,writer__29291__auto__,"cljs.core.async/t_cljs$core$async33170");
});

cljs.core.async.__GT_t_cljs$core$async33170 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async33170(p__$1,ch__$1,meta33171){
return (new cljs.core.async.t_cljs$core$async33170(p__$1,ch__$1,meta33171));
});

}

return (new cljs.core.async.t_cljs$core$async33170(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__33174 = arguments.length;
switch (G__33174) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31675__auto___33214 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___33214,out){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___33214,out){
return (function (state_33195){
var state_val_33196 = (state_33195[(1)]);
if((state_val_33196 === (7))){
var inst_33191 = (state_33195[(2)]);
var state_33195__$1 = state_33195;
var statearr_33197_33215 = state_33195__$1;
(statearr_33197_33215[(2)] = inst_33191);

(statearr_33197_33215[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33196 === (1))){
var state_33195__$1 = state_33195;
var statearr_33198_33216 = state_33195__$1;
(statearr_33198_33216[(2)] = null);

(statearr_33198_33216[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33196 === (4))){
var inst_33177 = (state_33195[(7)]);
var inst_33177__$1 = (state_33195[(2)]);
var inst_33178 = (inst_33177__$1 == null);
var state_33195__$1 = (function (){var statearr_33199 = state_33195;
(statearr_33199[(7)] = inst_33177__$1);

return statearr_33199;
})();
if(cljs.core.truth_(inst_33178)){
var statearr_33200_33217 = state_33195__$1;
(statearr_33200_33217[(1)] = (5));

} else {
var statearr_33201_33218 = state_33195__$1;
(statearr_33201_33218[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33196 === (6))){
var inst_33177 = (state_33195[(7)]);
var inst_33182 = p.call(null,inst_33177);
var state_33195__$1 = state_33195;
if(cljs.core.truth_(inst_33182)){
var statearr_33202_33219 = state_33195__$1;
(statearr_33202_33219[(1)] = (8));

} else {
var statearr_33203_33220 = state_33195__$1;
(statearr_33203_33220[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33196 === (3))){
var inst_33193 = (state_33195[(2)]);
var state_33195__$1 = state_33195;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33195__$1,inst_33193);
} else {
if((state_val_33196 === (2))){
var state_33195__$1 = state_33195;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33195__$1,(4),ch);
} else {
if((state_val_33196 === (11))){
var inst_33185 = (state_33195[(2)]);
var state_33195__$1 = state_33195;
var statearr_33204_33221 = state_33195__$1;
(statearr_33204_33221[(2)] = inst_33185);

(statearr_33204_33221[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33196 === (9))){
var state_33195__$1 = state_33195;
var statearr_33205_33222 = state_33195__$1;
(statearr_33205_33222[(2)] = null);

(statearr_33205_33222[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33196 === (5))){
var inst_33180 = cljs.core.async.close_BANG_.call(null,out);
var state_33195__$1 = state_33195;
var statearr_33206_33223 = state_33195__$1;
(statearr_33206_33223[(2)] = inst_33180);

(statearr_33206_33223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33196 === (10))){
var inst_33188 = (state_33195[(2)]);
var state_33195__$1 = (function (){var statearr_33207 = state_33195;
(statearr_33207[(8)] = inst_33188);

return statearr_33207;
})();
var statearr_33208_33224 = state_33195__$1;
(statearr_33208_33224[(2)] = null);

(statearr_33208_33224[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33196 === (8))){
var inst_33177 = (state_33195[(7)]);
var state_33195__$1 = state_33195;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33195__$1,(11),out,inst_33177);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___33214,out))
;
return ((function (switch__31585__auto__,c__31675__auto___33214,out){
return (function() {
var cljs$core$async$state_machine__31586__auto__ = null;
var cljs$core$async$state_machine__31586__auto____0 = (function (){
var statearr_33209 = [null,null,null,null,null,null,null,null,null];
(statearr_33209[(0)] = cljs$core$async$state_machine__31586__auto__);

(statearr_33209[(1)] = (1));

return statearr_33209;
});
var cljs$core$async$state_machine__31586__auto____1 = (function (state_33195){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_33195);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e33210){if((e33210 instanceof Object)){
var ex__31589__auto__ = e33210;
var statearr_33211_33225 = state_33195;
(statearr_33211_33225[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33195);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33210;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33226 = state_33195;
state_33195 = G__33226;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$state_machine__31586__auto__ = function(state_33195){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31586__auto____1.call(this,state_33195);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31586__auto____0;
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31586__auto____1;
return cljs$core$async$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___33214,out))
})();
var state__31677__auto__ = (function (){var statearr_33212 = f__31676__auto__.call(null);
(statearr_33212[(6)] = c__31675__auto___33214);

return statearr_33212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___33214,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__33228 = arguments.length;
switch (G__33228) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__31675__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto__){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto__){
return (function (state_33291){
var state_val_33292 = (state_33291[(1)]);
if((state_val_33292 === (7))){
var inst_33287 = (state_33291[(2)]);
var state_33291__$1 = state_33291;
var statearr_33293_33331 = state_33291__$1;
(statearr_33293_33331[(2)] = inst_33287);

(statearr_33293_33331[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (20))){
var inst_33257 = (state_33291[(7)]);
var inst_33268 = (state_33291[(2)]);
var inst_33269 = cljs.core.next.call(null,inst_33257);
var inst_33243 = inst_33269;
var inst_33244 = null;
var inst_33245 = (0);
var inst_33246 = (0);
var state_33291__$1 = (function (){var statearr_33294 = state_33291;
(statearr_33294[(8)] = inst_33246);

(statearr_33294[(9)] = inst_33268);

(statearr_33294[(10)] = inst_33243);

(statearr_33294[(11)] = inst_33245);

(statearr_33294[(12)] = inst_33244);

return statearr_33294;
})();
var statearr_33295_33332 = state_33291__$1;
(statearr_33295_33332[(2)] = null);

(statearr_33295_33332[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (1))){
var state_33291__$1 = state_33291;
var statearr_33296_33333 = state_33291__$1;
(statearr_33296_33333[(2)] = null);

(statearr_33296_33333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (4))){
var inst_33232 = (state_33291[(13)]);
var inst_33232__$1 = (state_33291[(2)]);
var inst_33233 = (inst_33232__$1 == null);
var state_33291__$1 = (function (){var statearr_33297 = state_33291;
(statearr_33297[(13)] = inst_33232__$1);

return statearr_33297;
})();
if(cljs.core.truth_(inst_33233)){
var statearr_33298_33334 = state_33291__$1;
(statearr_33298_33334[(1)] = (5));

} else {
var statearr_33299_33335 = state_33291__$1;
(statearr_33299_33335[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (15))){
var state_33291__$1 = state_33291;
var statearr_33303_33336 = state_33291__$1;
(statearr_33303_33336[(2)] = null);

(statearr_33303_33336[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (21))){
var state_33291__$1 = state_33291;
var statearr_33304_33337 = state_33291__$1;
(statearr_33304_33337[(2)] = null);

(statearr_33304_33337[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (13))){
var inst_33246 = (state_33291[(8)]);
var inst_33243 = (state_33291[(10)]);
var inst_33245 = (state_33291[(11)]);
var inst_33244 = (state_33291[(12)]);
var inst_33253 = (state_33291[(2)]);
var inst_33254 = (inst_33246 + (1));
var tmp33300 = inst_33243;
var tmp33301 = inst_33245;
var tmp33302 = inst_33244;
var inst_33243__$1 = tmp33300;
var inst_33244__$1 = tmp33302;
var inst_33245__$1 = tmp33301;
var inst_33246__$1 = inst_33254;
var state_33291__$1 = (function (){var statearr_33305 = state_33291;
(statearr_33305[(8)] = inst_33246__$1);

(statearr_33305[(10)] = inst_33243__$1);

(statearr_33305[(11)] = inst_33245__$1);

(statearr_33305[(14)] = inst_33253);

(statearr_33305[(12)] = inst_33244__$1);

return statearr_33305;
})();
var statearr_33306_33338 = state_33291__$1;
(statearr_33306_33338[(2)] = null);

(statearr_33306_33338[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (22))){
var state_33291__$1 = state_33291;
var statearr_33307_33339 = state_33291__$1;
(statearr_33307_33339[(2)] = null);

(statearr_33307_33339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (6))){
var inst_33232 = (state_33291[(13)]);
var inst_33241 = f.call(null,inst_33232);
var inst_33242 = cljs.core.seq.call(null,inst_33241);
var inst_33243 = inst_33242;
var inst_33244 = null;
var inst_33245 = (0);
var inst_33246 = (0);
var state_33291__$1 = (function (){var statearr_33308 = state_33291;
(statearr_33308[(8)] = inst_33246);

(statearr_33308[(10)] = inst_33243);

(statearr_33308[(11)] = inst_33245);

(statearr_33308[(12)] = inst_33244);

return statearr_33308;
})();
var statearr_33309_33340 = state_33291__$1;
(statearr_33309_33340[(2)] = null);

(statearr_33309_33340[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (17))){
var inst_33257 = (state_33291[(7)]);
var inst_33261 = cljs.core.chunk_first.call(null,inst_33257);
var inst_33262 = cljs.core.chunk_rest.call(null,inst_33257);
var inst_33263 = cljs.core.count.call(null,inst_33261);
var inst_33243 = inst_33262;
var inst_33244 = inst_33261;
var inst_33245 = inst_33263;
var inst_33246 = (0);
var state_33291__$1 = (function (){var statearr_33310 = state_33291;
(statearr_33310[(8)] = inst_33246);

(statearr_33310[(10)] = inst_33243);

(statearr_33310[(11)] = inst_33245);

(statearr_33310[(12)] = inst_33244);

return statearr_33310;
})();
var statearr_33311_33341 = state_33291__$1;
(statearr_33311_33341[(2)] = null);

(statearr_33311_33341[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (3))){
var inst_33289 = (state_33291[(2)]);
var state_33291__$1 = state_33291;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33291__$1,inst_33289);
} else {
if((state_val_33292 === (12))){
var inst_33277 = (state_33291[(2)]);
var state_33291__$1 = state_33291;
var statearr_33312_33342 = state_33291__$1;
(statearr_33312_33342[(2)] = inst_33277);

(statearr_33312_33342[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (2))){
var state_33291__$1 = state_33291;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33291__$1,(4),in$);
} else {
if((state_val_33292 === (23))){
var inst_33285 = (state_33291[(2)]);
var state_33291__$1 = state_33291;
var statearr_33313_33343 = state_33291__$1;
(statearr_33313_33343[(2)] = inst_33285);

(statearr_33313_33343[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (19))){
var inst_33272 = (state_33291[(2)]);
var state_33291__$1 = state_33291;
var statearr_33314_33344 = state_33291__$1;
(statearr_33314_33344[(2)] = inst_33272);

(statearr_33314_33344[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (11))){
var inst_33257 = (state_33291[(7)]);
var inst_33243 = (state_33291[(10)]);
var inst_33257__$1 = cljs.core.seq.call(null,inst_33243);
var state_33291__$1 = (function (){var statearr_33315 = state_33291;
(statearr_33315[(7)] = inst_33257__$1);

return statearr_33315;
})();
if(inst_33257__$1){
var statearr_33316_33345 = state_33291__$1;
(statearr_33316_33345[(1)] = (14));

} else {
var statearr_33317_33346 = state_33291__$1;
(statearr_33317_33346[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (9))){
var inst_33279 = (state_33291[(2)]);
var inst_33280 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_33291__$1 = (function (){var statearr_33318 = state_33291;
(statearr_33318[(15)] = inst_33279);

return statearr_33318;
})();
if(cljs.core.truth_(inst_33280)){
var statearr_33319_33347 = state_33291__$1;
(statearr_33319_33347[(1)] = (21));

} else {
var statearr_33320_33348 = state_33291__$1;
(statearr_33320_33348[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (5))){
var inst_33235 = cljs.core.async.close_BANG_.call(null,out);
var state_33291__$1 = state_33291;
var statearr_33321_33349 = state_33291__$1;
(statearr_33321_33349[(2)] = inst_33235);

(statearr_33321_33349[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (14))){
var inst_33257 = (state_33291[(7)]);
var inst_33259 = cljs.core.chunked_seq_QMARK_.call(null,inst_33257);
var state_33291__$1 = state_33291;
if(inst_33259){
var statearr_33322_33350 = state_33291__$1;
(statearr_33322_33350[(1)] = (17));

} else {
var statearr_33323_33351 = state_33291__$1;
(statearr_33323_33351[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (16))){
var inst_33275 = (state_33291[(2)]);
var state_33291__$1 = state_33291;
var statearr_33324_33352 = state_33291__$1;
(statearr_33324_33352[(2)] = inst_33275);

(statearr_33324_33352[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33292 === (10))){
var inst_33246 = (state_33291[(8)]);
var inst_33244 = (state_33291[(12)]);
var inst_33251 = cljs.core._nth.call(null,inst_33244,inst_33246);
var state_33291__$1 = state_33291;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33291__$1,(13),out,inst_33251);
} else {
if((state_val_33292 === (18))){
var inst_33257 = (state_33291[(7)]);
var inst_33266 = cljs.core.first.call(null,inst_33257);
var state_33291__$1 = state_33291;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33291__$1,(20),out,inst_33266);
} else {
if((state_val_33292 === (8))){
var inst_33246 = (state_33291[(8)]);
var inst_33245 = (state_33291[(11)]);
var inst_33248 = (inst_33246 < inst_33245);
var inst_33249 = inst_33248;
var state_33291__$1 = state_33291;
if(cljs.core.truth_(inst_33249)){
var statearr_33325_33353 = state_33291__$1;
(statearr_33325_33353[(1)] = (10));

} else {
var statearr_33326_33354 = state_33291__$1;
(statearr_33326_33354[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto__))
;
return ((function (switch__31585__auto__,c__31675__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__31586__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__31586__auto____0 = (function (){
var statearr_33327 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33327[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__31586__auto__);

(statearr_33327[(1)] = (1));

return statearr_33327;
});
var cljs$core$async$mapcat_STAR__$_state_machine__31586__auto____1 = (function (state_33291){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_33291);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e33328){if((e33328 instanceof Object)){
var ex__31589__auto__ = e33328;
var statearr_33329_33355 = state_33291;
(statearr_33329_33355[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33291);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33328;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33356 = state_33291;
state_33291 = G__33356;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__31586__auto__ = function(state_33291){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__31586__auto____1.call(this,state_33291);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__31586__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__31586__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto__))
})();
var state__31677__auto__ = (function (){var statearr_33330 = f__31676__auto__.call(null);
(statearr_33330[(6)] = c__31675__auto__);

return statearr_33330;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto__))
);

return c__31675__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__33358 = arguments.length;
switch (G__33358) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__33361 = arguments.length;
switch (G__33361) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__33364 = arguments.length;
switch (G__33364) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31675__auto___33411 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___33411,out){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___33411,out){
return (function (state_33388){
var state_val_33389 = (state_33388[(1)]);
if((state_val_33389 === (7))){
var inst_33383 = (state_33388[(2)]);
var state_33388__$1 = state_33388;
var statearr_33390_33412 = state_33388__$1;
(statearr_33390_33412[(2)] = inst_33383);

(statearr_33390_33412[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33389 === (1))){
var inst_33365 = null;
var state_33388__$1 = (function (){var statearr_33391 = state_33388;
(statearr_33391[(7)] = inst_33365);

return statearr_33391;
})();
var statearr_33392_33413 = state_33388__$1;
(statearr_33392_33413[(2)] = null);

(statearr_33392_33413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33389 === (4))){
var inst_33368 = (state_33388[(8)]);
var inst_33368__$1 = (state_33388[(2)]);
var inst_33369 = (inst_33368__$1 == null);
var inst_33370 = cljs.core.not.call(null,inst_33369);
var state_33388__$1 = (function (){var statearr_33393 = state_33388;
(statearr_33393[(8)] = inst_33368__$1);

return statearr_33393;
})();
if(inst_33370){
var statearr_33394_33414 = state_33388__$1;
(statearr_33394_33414[(1)] = (5));

} else {
var statearr_33395_33415 = state_33388__$1;
(statearr_33395_33415[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33389 === (6))){
var state_33388__$1 = state_33388;
var statearr_33396_33416 = state_33388__$1;
(statearr_33396_33416[(2)] = null);

(statearr_33396_33416[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33389 === (3))){
var inst_33385 = (state_33388[(2)]);
var inst_33386 = cljs.core.async.close_BANG_.call(null,out);
var state_33388__$1 = (function (){var statearr_33397 = state_33388;
(statearr_33397[(9)] = inst_33385);

return statearr_33397;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33388__$1,inst_33386);
} else {
if((state_val_33389 === (2))){
var state_33388__$1 = state_33388;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33388__$1,(4),ch);
} else {
if((state_val_33389 === (11))){
var inst_33368 = (state_33388[(8)]);
var inst_33377 = (state_33388[(2)]);
var inst_33365 = inst_33368;
var state_33388__$1 = (function (){var statearr_33398 = state_33388;
(statearr_33398[(10)] = inst_33377);

(statearr_33398[(7)] = inst_33365);

return statearr_33398;
})();
var statearr_33399_33417 = state_33388__$1;
(statearr_33399_33417[(2)] = null);

(statearr_33399_33417[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33389 === (9))){
var inst_33368 = (state_33388[(8)]);
var state_33388__$1 = state_33388;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33388__$1,(11),out,inst_33368);
} else {
if((state_val_33389 === (5))){
var inst_33368 = (state_33388[(8)]);
var inst_33365 = (state_33388[(7)]);
var inst_33372 = cljs.core._EQ_.call(null,inst_33368,inst_33365);
var state_33388__$1 = state_33388;
if(inst_33372){
var statearr_33401_33418 = state_33388__$1;
(statearr_33401_33418[(1)] = (8));

} else {
var statearr_33402_33419 = state_33388__$1;
(statearr_33402_33419[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33389 === (10))){
var inst_33380 = (state_33388[(2)]);
var state_33388__$1 = state_33388;
var statearr_33403_33420 = state_33388__$1;
(statearr_33403_33420[(2)] = inst_33380);

(statearr_33403_33420[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33389 === (8))){
var inst_33365 = (state_33388[(7)]);
var tmp33400 = inst_33365;
var inst_33365__$1 = tmp33400;
var state_33388__$1 = (function (){var statearr_33404 = state_33388;
(statearr_33404[(7)] = inst_33365__$1);

return statearr_33404;
})();
var statearr_33405_33421 = state_33388__$1;
(statearr_33405_33421[(2)] = null);

(statearr_33405_33421[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___33411,out))
;
return ((function (switch__31585__auto__,c__31675__auto___33411,out){
return (function() {
var cljs$core$async$state_machine__31586__auto__ = null;
var cljs$core$async$state_machine__31586__auto____0 = (function (){
var statearr_33406 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33406[(0)] = cljs$core$async$state_machine__31586__auto__);

(statearr_33406[(1)] = (1));

return statearr_33406;
});
var cljs$core$async$state_machine__31586__auto____1 = (function (state_33388){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_33388);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e33407){if((e33407 instanceof Object)){
var ex__31589__auto__ = e33407;
var statearr_33408_33422 = state_33388;
(statearr_33408_33422[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33388);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33407;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33423 = state_33388;
state_33388 = G__33423;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$state_machine__31586__auto__ = function(state_33388){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31586__auto____1.call(this,state_33388);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31586__auto____0;
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31586__auto____1;
return cljs$core$async$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___33411,out))
})();
var state__31677__auto__ = (function (){var statearr_33409 = f__31676__auto__.call(null);
(statearr_33409[(6)] = c__31675__auto___33411);

return statearr_33409;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___33411,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__33425 = arguments.length;
switch (G__33425) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31675__auto___33491 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___33491,out){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___33491,out){
return (function (state_33463){
var state_val_33464 = (state_33463[(1)]);
if((state_val_33464 === (7))){
var inst_33459 = (state_33463[(2)]);
var state_33463__$1 = state_33463;
var statearr_33465_33492 = state_33463__$1;
(statearr_33465_33492[(2)] = inst_33459);

(statearr_33465_33492[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33464 === (1))){
var inst_33426 = (new Array(n));
var inst_33427 = inst_33426;
var inst_33428 = (0);
var state_33463__$1 = (function (){var statearr_33466 = state_33463;
(statearr_33466[(7)] = inst_33427);

(statearr_33466[(8)] = inst_33428);

return statearr_33466;
})();
var statearr_33467_33493 = state_33463__$1;
(statearr_33467_33493[(2)] = null);

(statearr_33467_33493[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33464 === (4))){
var inst_33431 = (state_33463[(9)]);
var inst_33431__$1 = (state_33463[(2)]);
var inst_33432 = (inst_33431__$1 == null);
var inst_33433 = cljs.core.not.call(null,inst_33432);
var state_33463__$1 = (function (){var statearr_33468 = state_33463;
(statearr_33468[(9)] = inst_33431__$1);

return statearr_33468;
})();
if(inst_33433){
var statearr_33469_33494 = state_33463__$1;
(statearr_33469_33494[(1)] = (5));

} else {
var statearr_33470_33495 = state_33463__$1;
(statearr_33470_33495[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33464 === (15))){
var inst_33453 = (state_33463[(2)]);
var state_33463__$1 = state_33463;
var statearr_33471_33496 = state_33463__$1;
(statearr_33471_33496[(2)] = inst_33453);

(statearr_33471_33496[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33464 === (13))){
var state_33463__$1 = state_33463;
var statearr_33472_33497 = state_33463__$1;
(statearr_33472_33497[(2)] = null);

(statearr_33472_33497[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33464 === (6))){
var inst_33428 = (state_33463[(8)]);
var inst_33449 = (inst_33428 > (0));
var state_33463__$1 = state_33463;
if(cljs.core.truth_(inst_33449)){
var statearr_33473_33498 = state_33463__$1;
(statearr_33473_33498[(1)] = (12));

} else {
var statearr_33474_33499 = state_33463__$1;
(statearr_33474_33499[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33464 === (3))){
var inst_33461 = (state_33463[(2)]);
var state_33463__$1 = state_33463;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33463__$1,inst_33461);
} else {
if((state_val_33464 === (12))){
var inst_33427 = (state_33463[(7)]);
var inst_33451 = cljs.core.vec.call(null,inst_33427);
var state_33463__$1 = state_33463;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33463__$1,(15),out,inst_33451);
} else {
if((state_val_33464 === (2))){
var state_33463__$1 = state_33463;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33463__$1,(4),ch);
} else {
if((state_val_33464 === (11))){
var inst_33443 = (state_33463[(2)]);
var inst_33444 = (new Array(n));
var inst_33427 = inst_33444;
var inst_33428 = (0);
var state_33463__$1 = (function (){var statearr_33475 = state_33463;
(statearr_33475[(10)] = inst_33443);

(statearr_33475[(7)] = inst_33427);

(statearr_33475[(8)] = inst_33428);

return statearr_33475;
})();
var statearr_33476_33500 = state_33463__$1;
(statearr_33476_33500[(2)] = null);

(statearr_33476_33500[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33464 === (9))){
var inst_33427 = (state_33463[(7)]);
var inst_33441 = cljs.core.vec.call(null,inst_33427);
var state_33463__$1 = state_33463;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33463__$1,(11),out,inst_33441);
} else {
if((state_val_33464 === (5))){
var inst_33436 = (state_33463[(11)]);
var inst_33427 = (state_33463[(7)]);
var inst_33428 = (state_33463[(8)]);
var inst_33431 = (state_33463[(9)]);
var inst_33435 = (inst_33427[inst_33428] = inst_33431);
var inst_33436__$1 = (inst_33428 + (1));
var inst_33437 = (inst_33436__$1 < n);
var state_33463__$1 = (function (){var statearr_33477 = state_33463;
(statearr_33477[(11)] = inst_33436__$1);

(statearr_33477[(12)] = inst_33435);

return statearr_33477;
})();
if(cljs.core.truth_(inst_33437)){
var statearr_33478_33501 = state_33463__$1;
(statearr_33478_33501[(1)] = (8));

} else {
var statearr_33479_33502 = state_33463__$1;
(statearr_33479_33502[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33464 === (14))){
var inst_33456 = (state_33463[(2)]);
var inst_33457 = cljs.core.async.close_BANG_.call(null,out);
var state_33463__$1 = (function (){var statearr_33481 = state_33463;
(statearr_33481[(13)] = inst_33456);

return statearr_33481;
})();
var statearr_33482_33503 = state_33463__$1;
(statearr_33482_33503[(2)] = inst_33457);

(statearr_33482_33503[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33464 === (10))){
var inst_33447 = (state_33463[(2)]);
var state_33463__$1 = state_33463;
var statearr_33483_33504 = state_33463__$1;
(statearr_33483_33504[(2)] = inst_33447);

(statearr_33483_33504[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33464 === (8))){
var inst_33436 = (state_33463[(11)]);
var inst_33427 = (state_33463[(7)]);
var tmp33480 = inst_33427;
var inst_33427__$1 = tmp33480;
var inst_33428 = inst_33436;
var state_33463__$1 = (function (){var statearr_33484 = state_33463;
(statearr_33484[(7)] = inst_33427__$1);

(statearr_33484[(8)] = inst_33428);

return statearr_33484;
})();
var statearr_33485_33505 = state_33463__$1;
(statearr_33485_33505[(2)] = null);

(statearr_33485_33505[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___33491,out))
;
return ((function (switch__31585__auto__,c__31675__auto___33491,out){
return (function() {
var cljs$core$async$state_machine__31586__auto__ = null;
var cljs$core$async$state_machine__31586__auto____0 = (function (){
var statearr_33486 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33486[(0)] = cljs$core$async$state_machine__31586__auto__);

(statearr_33486[(1)] = (1));

return statearr_33486;
});
var cljs$core$async$state_machine__31586__auto____1 = (function (state_33463){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_33463);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e33487){if((e33487 instanceof Object)){
var ex__31589__auto__ = e33487;
var statearr_33488_33506 = state_33463;
(statearr_33488_33506[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33463);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33487;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33507 = state_33463;
state_33463 = G__33507;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$state_machine__31586__auto__ = function(state_33463){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31586__auto____1.call(this,state_33463);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31586__auto____0;
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31586__auto____1;
return cljs$core$async$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___33491,out))
})();
var state__31677__auto__ = (function (){var statearr_33489 = f__31676__auto__.call(null);
(statearr_33489[(6)] = c__31675__auto___33491);

return statearr_33489;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___33491,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__33509 = arguments.length;
switch (G__33509) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__31675__auto___33579 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__31675__auto___33579,out){
return (function (){
var f__31676__auto__ = (function (){var switch__31585__auto__ = ((function (c__31675__auto___33579,out){
return (function (state_33551){
var state_val_33552 = (state_33551[(1)]);
if((state_val_33552 === (7))){
var inst_33547 = (state_33551[(2)]);
var state_33551__$1 = state_33551;
var statearr_33553_33580 = state_33551__$1;
(statearr_33553_33580[(2)] = inst_33547);

(statearr_33553_33580[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33552 === (1))){
var inst_33510 = [];
var inst_33511 = inst_33510;
var inst_33512 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_33551__$1 = (function (){var statearr_33554 = state_33551;
(statearr_33554[(7)] = inst_33512);

(statearr_33554[(8)] = inst_33511);

return statearr_33554;
})();
var statearr_33555_33581 = state_33551__$1;
(statearr_33555_33581[(2)] = null);

(statearr_33555_33581[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33552 === (4))){
var inst_33515 = (state_33551[(9)]);
var inst_33515__$1 = (state_33551[(2)]);
var inst_33516 = (inst_33515__$1 == null);
var inst_33517 = cljs.core.not.call(null,inst_33516);
var state_33551__$1 = (function (){var statearr_33556 = state_33551;
(statearr_33556[(9)] = inst_33515__$1);

return statearr_33556;
})();
if(inst_33517){
var statearr_33557_33582 = state_33551__$1;
(statearr_33557_33582[(1)] = (5));

} else {
var statearr_33558_33583 = state_33551__$1;
(statearr_33558_33583[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33552 === (15))){
var inst_33541 = (state_33551[(2)]);
var state_33551__$1 = state_33551;
var statearr_33559_33584 = state_33551__$1;
(statearr_33559_33584[(2)] = inst_33541);

(statearr_33559_33584[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33552 === (13))){
var state_33551__$1 = state_33551;
var statearr_33560_33585 = state_33551__$1;
(statearr_33560_33585[(2)] = null);

(statearr_33560_33585[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33552 === (6))){
var inst_33511 = (state_33551[(8)]);
var inst_33536 = inst_33511.length;
var inst_33537 = (inst_33536 > (0));
var state_33551__$1 = state_33551;
if(cljs.core.truth_(inst_33537)){
var statearr_33561_33586 = state_33551__$1;
(statearr_33561_33586[(1)] = (12));

} else {
var statearr_33562_33587 = state_33551__$1;
(statearr_33562_33587[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33552 === (3))){
var inst_33549 = (state_33551[(2)]);
var state_33551__$1 = state_33551;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_33551__$1,inst_33549);
} else {
if((state_val_33552 === (12))){
var inst_33511 = (state_33551[(8)]);
var inst_33539 = cljs.core.vec.call(null,inst_33511);
var state_33551__$1 = state_33551;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33551__$1,(15),out,inst_33539);
} else {
if((state_val_33552 === (2))){
var state_33551__$1 = state_33551;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_33551__$1,(4),ch);
} else {
if((state_val_33552 === (11))){
var inst_33519 = (state_33551[(10)]);
var inst_33515 = (state_33551[(9)]);
var inst_33529 = (state_33551[(2)]);
var inst_33530 = [];
var inst_33531 = inst_33530.push(inst_33515);
var inst_33511 = inst_33530;
var inst_33512 = inst_33519;
var state_33551__$1 = (function (){var statearr_33563 = state_33551;
(statearr_33563[(7)] = inst_33512);

(statearr_33563[(11)] = inst_33531);

(statearr_33563[(8)] = inst_33511);

(statearr_33563[(12)] = inst_33529);

return statearr_33563;
})();
var statearr_33564_33588 = state_33551__$1;
(statearr_33564_33588[(2)] = null);

(statearr_33564_33588[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33552 === (9))){
var inst_33511 = (state_33551[(8)]);
var inst_33527 = cljs.core.vec.call(null,inst_33511);
var state_33551__$1 = state_33551;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_33551__$1,(11),out,inst_33527);
} else {
if((state_val_33552 === (5))){
var inst_33512 = (state_33551[(7)]);
var inst_33519 = (state_33551[(10)]);
var inst_33515 = (state_33551[(9)]);
var inst_33519__$1 = f.call(null,inst_33515);
var inst_33520 = cljs.core._EQ_.call(null,inst_33519__$1,inst_33512);
var inst_33521 = cljs.core.keyword_identical_QMARK_.call(null,inst_33512,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_33522 = (inst_33520) || (inst_33521);
var state_33551__$1 = (function (){var statearr_33565 = state_33551;
(statearr_33565[(10)] = inst_33519__$1);

return statearr_33565;
})();
if(cljs.core.truth_(inst_33522)){
var statearr_33566_33589 = state_33551__$1;
(statearr_33566_33589[(1)] = (8));

} else {
var statearr_33567_33590 = state_33551__$1;
(statearr_33567_33590[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33552 === (14))){
var inst_33544 = (state_33551[(2)]);
var inst_33545 = cljs.core.async.close_BANG_.call(null,out);
var state_33551__$1 = (function (){var statearr_33569 = state_33551;
(statearr_33569[(13)] = inst_33544);

return statearr_33569;
})();
var statearr_33570_33591 = state_33551__$1;
(statearr_33570_33591[(2)] = inst_33545);

(statearr_33570_33591[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33552 === (10))){
var inst_33534 = (state_33551[(2)]);
var state_33551__$1 = state_33551;
var statearr_33571_33592 = state_33551__$1;
(statearr_33571_33592[(2)] = inst_33534);

(statearr_33571_33592[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_33552 === (8))){
var inst_33511 = (state_33551[(8)]);
var inst_33519 = (state_33551[(10)]);
var inst_33515 = (state_33551[(9)]);
var inst_33524 = inst_33511.push(inst_33515);
var tmp33568 = inst_33511;
var inst_33511__$1 = tmp33568;
var inst_33512 = inst_33519;
var state_33551__$1 = (function (){var statearr_33572 = state_33551;
(statearr_33572[(7)] = inst_33512);

(statearr_33572[(14)] = inst_33524);

(statearr_33572[(8)] = inst_33511__$1);

return statearr_33572;
})();
var statearr_33573_33593 = state_33551__$1;
(statearr_33573_33593[(2)] = null);

(statearr_33573_33593[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__31675__auto___33579,out))
;
return ((function (switch__31585__auto__,c__31675__auto___33579,out){
return (function() {
var cljs$core$async$state_machine__31586__auto__ = null;
var cljs$core$async$state_machine__31586__auto____0 = (function (){
var statearr_33574 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33574[(0)] = cljs$core$async$state_machine__31586__auto__);

(statearr_33574[(1)] = (1));

return statearr_33574;
});
var cljs$core$async$state_machine__31586__auto____1 = (function (state_33551){
while(true){
var ret_value__31587__auto__ = (function (){try{while(true){
var result__31588__auto__ = switch__31585__auto__.call(null,state_33551);
if(cljs.core.keyword_identical_QMARK_.call(null,result__31588__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__31588__auto__;
}
break;
}
}catch (e33575){if((e33575 instanceof Object)){
var ex__31589__auto__ = e33575;
var statearr_33576_33594 = state_33551;
(statearr_33576_33594[(5)] = ex__31589__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_33551);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e33575;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__31587__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__33595 = state_33551;
state_33551 = G__33595;
continue;
} else {
return ret_value__31587__auto__;
}
break;
}
});
cljs$core$async$state_machine__31586__auto__ = function(state_33551){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__31586__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__31586__auto____1.call(this,state_33551);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__31586__auto____0;
cljs$core$async$state_machine__31586__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__31586__auto____1;
return cljs$core$async$state_machine__31586__auto__;
})()
;})(switch__31585__auto__,c__31675__auto___33579,out))
})();
var state__31677__auto__ = (function (){var statearr_33577 = f__31676__auto__.call(null);
(statearr_33577[(6)] = c__31675__auto___33579);

return statearr_33577;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__31677__auto__);
});})(c__31675__auto___33579,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map