// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('imcljs.path');
goog.require('cljs.core');
goog.require('imcljs.internal.utils');
goog.require('clojure.string');
/**
 * Split a string path into a vector of keywords.
 *   (split-path `Gene.organism.shortName`)
 *   => [:Gene :organism :shortName]
 */
imcljs.path.split_path = (function imcljs$path$split_path(path_str){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword,clojure.string.split.cljs$core$IFn$_invoke$arity$2(path_str,"."));
});
/**
 * Join a vector path of keywords to a string.
 *   (join-path [:Gene :organism :shortName])
 *   => Gene.organism.shortName
 */
imcljs.path.join_path = (function imcljs$path$join_path(path_str){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.name,path_str));
});
/**
 * Given a model and a class, return its collections and references.
 */
imcljs.path.relationships = (function imcljs$path$relationships(model,class_kw){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.merge,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$classes,class_kw], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$attributes,cljs.core.cst$kw$references,cljs.core.cst$kw$collections], null)));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_type = (function imcljs$path$referenced_type(model,field_kw,class_kw){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$referencedType.cljs$core$IFn$_invoke$arity$1(cljs.core.get.cljs$core$IFn$_invoke$arity$2(imcljs.path.relationships(model,class_kw),field_kw)));
});
/**
 * Given a model, a reference/collection, and a class,
 *   return the superclass of the reference/collection.
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.referenced_class = (function imcljs$path$referenced_class(model,field_kw,class_kw){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(imcljs.path.referenced_type,model,field_kw),cljs.core.cons(class_kw,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__23890){
var vec__23891 = p__23890;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23891,(0),null);
var map__23894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23891,(1),null);
var map__23894__$1 = ((((!((map__23894 == null)))?((((map__23894.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23894.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23894):map__23894);
var extends$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23894__$1,cljs.core.cst$kw$extends);
return cljs.core.some(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,class_kw),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword,extends$));
}),cljs.core.cst$kw$classes.cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Given a model, a class, and a collection or reference, return the class of the collection or reference.
 *   (referenced-class im-model :Gene :homologues)
 *   => :Gene
 */
imcljs.path.referenced_values = (function imcljs$path$referenced_values(model,field_kw,class_kw){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(imcljs.path.relationships(model,class_kw),field_kw);
});
/**
 * Given a model and a field, return that field from the data model.
 *   A field can be a reference, a collection, or an attribute
 *   In the example :tissue is an attribute of the subclass :FlyAtlasResult
 *   (referenced-class im-model :MicroArrayResult :tissue)
 *   => :Tissue
 */
imcljs.path.class_value = (function imcljs$path$class_value(model,class_kw,field_kw){
return cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(imcljs.path.referenced_values,model,field_kw),cljs.core.cons(class_kw,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p__23902){
var vec__23903 = p__23902;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23903,(0),null);
var map__23906 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23903,(1),null);
var map__23906__$1 = ((((!((map__23906 == null)))?((((map__23906.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23906.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23906):map__23906);
var extends$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23906__$1,cljs.core.cst$kw$extends);
return cljs.core.some(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,class_kw),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword,extends$));
}),cljs.core.cst$kw$classes.cljs$core$IFn$_invoke$arity$1(model)))))));
});
/**
 * Return a vector representing each part of path.
 *   If any part of the path is unresolvable then a nil is returned.
 *   (walk im-model `Gene.organism.shortName`)
 *   => [{:name `Gene`, :collections {...}, :attributes {...}}
 *    {:name `Organism`, :collections {...} :attributes {...}
 *    {:name `shortName`, :type `java.lang.String`}]
 */
imcljs.path.walk = (function imcljs$path$walk(var_args){
var args23908 = [];
var len__8435__auto___23918 = arguments.length;
var i__8436__auto___23919 = (0);
while(true){
if((i__8436__auto___23919 < len__8435__auto___23918)){
args23908.push((arguments[i__8436__auto___23919]));

var G__23920 = (i__8436__auto___23919 + (1));
i__8436__auto___23919 = G__23920;
continue;
} else {
}
break;
}

var G__23910 = args23908.length;
switch (G__23910) {
case 2:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args23908.length)].join('')));

}
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$2 = (function (model,path){
var p = ((typeof path === 'string')?imcljs.path.split_path(path):path);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(p))){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$classes,cljs.core.first(p)], null))], null);
} else {
return imcljs.path.walk.cljs$core$IFn$_invoke$arity$3(model,p,cljs.core.PersistentVector.EMPTY);
}
});

imcljs.path.walk.cljs$core$IFn$_invoke$arity$3 = (function (model,p__23911,trail){
while(true){
var vec__23912 = p__23911;
var seq__23913 = cljs.core.seq(vec__23912);
var first__23914 = cljs.core.first(seq__23913);
var seq__23913__$1 = cljs.core.next(seq__23913);
var class_kw = first__23914;
var vec__23915 = seq__23913__$1;
var seq__23916 = cljs.core.seq(vec__23915);
var first__23917 = cljs.core.first(seq__23916);
var seq__23916__$1 = cljs.core.next(seq__23916);
var path = first__23917;
var remaining = seq__23916__$1;
var cv = imcljs.path.class_value(model,class_kw,path);
if(remaining){
if(cljs.core.contains_QMARK_(cv,cljs.core.cst$kw$referencedType)){
var G__23922 = model;
var G__23923 = cljs.core.cons(cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$referencedType.cljs$core$IFn$_invoke$arity$1(cv)),remaining);
var G__23924 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(trail,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$classes,class_kw], null)));
model = G__23922;
p__23911 = G__23923;
trail = G__23924;
continue;
} else {
return null;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(trail,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$classes,class_kw], null)),cljs.core.array_seq([((cljs.core.contains_QMARK_(cv,cljs.core.cst$kw$referencedType))?cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(model,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$classes,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$referencedType.cljs$core$IFn$_invoke$arity$1(cv))], null)):cv)], 0));
}
break;
}
});

imcljs.path.walk.cljs$lang$maxFixedArity = 3;

/**
 * Return the java type of a path representing an attribute.
 *   (attribute-type im-model `Gene.organism.shortName`)
 *   => java.lang.String
 */
imcljs.path.data_type = (function imcljs$path$data_type(model,path){
return cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(cljs.core.last(imcljs.path.walk.cljs$core$IFn$_invoke$arity$2(model,path)));
});
/**
 * Returns the class represented by the path.
 *   (class im-model `Gene.homologues.homologue.symbol`)
 *   => :Gene
 */
imcljs.path.class$ = (function imcljs$path$class(model,path){
var l = cljs.core.last(cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__23925_SHARP_){
var G__23928 = p1__23925_SHARP_;
var G__23929 = cljs.core.cst$kw$type;
return (imcljs.internal.utils.does_not_contain_QMARK_.cljs$core$IFn$_invoke$arity$2 ? imcljs.internal.utils.does_not_contain_QMARK_.cljs$core$IFn$_invoke$arity$2(G__23928,G__23929) : imcljs.internal.utils.does_not_contain_QMARK_.call(null,G__23928,G__23929));
}),imcljs.path.walk.cljs$core$IFn$_invoke$arity$2(model,path)));
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1((function (){var or__7219__auto__ = cljs.core.cst$kw$referencedType.cljs$core$IFn$_invoke$arity$1(l);
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(l));
}
})());
});
/**
 * Returns true if path is a class.
 *   (class im-model `Gene.diseases`)
 *   => true
 *   (class im-model `Gene.diseases.name`)
 *   => false
 */
imcljs.path.class_QMARK_ = (function imcljs$path$class_QMARK_(model,path){
var walked = imcljs.path.walk.cljs$core$IFn$_invoke$arity$2(model,path);
return !(cljs.core.contains_QMARK_(cljs.core.last(walked),cljs.core.cst$kw$type));
});
/**
 * Returns a path string trimmed to the last class
 *   (trim-to-last-class im-model `Gene.homologues.homologue.symbol`)
 *   => Gene.homologues.homologue
 */
imcljs.path.trim_to_last_class = (function imcljs$path$trim_to_last_class(model,path){
var done = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2((function (p1__23930_SHARP_){
var G__23933 = p1__23930_SHARP_;
var G__23934 = cljs.core.cst$kw$type;
return (imcljs.internal.utils.does_not_contain_QMARK_.cljs$core$IFn$_invoke$arity$2 ? imcljs.internal.utils.does_not_contain_QMARK_.cljs$core$IFn$_invoke$arity$2(G__23933,G__23934) : imcljs.internal.utils.does_not_contain_QMARK_.call(null,G__23933,G__23934));
}),imcljs.path.walk.cljs$core$IFn$_invoke$arity$2(model,path));
return imcljs.path.join_path(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(done),imcljs.path.split_path(path)));
});
/**
 * Returns a path as a strong
 */
imcljs.path.friendly = (function imcljs$path$friendly(var_args){
var args__8442__auto__ = [];
var len__8435__auto___23942 = arguments.length;
var i__8436__auto___23943 = (0);
while(true){
if((i__8436__auto___23943 < len__8435__auto___23942)){
args__8442__auto__.push((arguments[i__8436__auto___23943]));

var G__23944 = (i__8436__auto___23943 + (1));
i__8436__auto___23943 = G__23944;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((2) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((2)),(0),null)):null);
return imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8443__auto__);
});

imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic = (function (model,path,p__23938){
var vec__23939 = p__23938;
var exclude_root_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23939,(0),null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (vec__23939,exclude_root_QMARK_){
return (function (total,next){
return [cljs.core.str(total),cljs.core.str((cljs.core.truth_(total)?" > ":null)),cljs.core.str((function (){var or__7219__auto__ = cljs.core.cst$kw$displayName.cljs$core$IFn$_invoke$arity$1(next);
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(next);
}
})())].join('');
});})(vec__23939,exclude_root_QMARK_))
,null,(cljs.core.truth_(exclude_root_QMARK_)?cljs.core.rest(imcljs.path.walk.cljs$core$IFn$_invoke$arity$2(model,path)):imcljs.path.walk.cljs$core$IFn$_invoke$arity$2(model,path)));
});

imcljs.path.friendly.cljs$lang$maxFixedArity = (2);

imcljs.path.friendly.cljs$lang$applyTo = (function (seq23935){
var G__23936 = cljs.core.first(seq23935);
var seq23935__$1 = cljs.core.next(seq23935);
var G__23937 = cljs.core.first(seq23935__$1);
var seq23935__$2 = cljs.core.next(seq23935__$1);
return imcljs.path.friendly.cljs$core$IFn$_invoke$arity$variadic(G__23936,G__23937,seq23935__$2);
});

