// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('day8.re_frame.undo');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('re_frame.db');
day8.re_frame.undo.config = (function (){var G__29000 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$max_DASH_undos,(50),cljs.core.cst$kw$harvest_DASH_fn,cljs.core.deref,cljs.core.cst$kw$reinstate_DASH_fn,cljs.core.reset_BANG_], null);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__29000) : cljs.core.atom.call(null,G__29000));
})();
/**
 * Set configuration parameters for library.
 * 
 *   Should be called on app startup.
 */
day8.re_frame.undo.undo_config_BANG_ = (function day8$re_frame$undo$undo_config_BANG_(new_config){
var temp__6751__auto__ = cljs.core.seq(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.keys(new_config)),cljs.core.set(cljs.core.keys((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.config) : cljs.core.deref.call(null,day8.re_frame.undo.config))))));
if(temp__6751__auto__){
var unknown_keys = temp__6751__auto__;
var G__29004 = cljs.core.cst$kw$error;
var G__29005 = "re-frame-undo: undo-config! called within unknown keys: ";
var G__29006 = unknown_keys;
return (re_frame.core.console.cljs$core$IFn$_invoke$arity$3 ? re_frame.core.console.cljs$core$IFn$_invoke$arity$3(G__29004,G__29005,G__29006) : re_frame.core.console.call(null,G__29004,G__29005,G__29006));
} else {
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(day8.re_frame.undo.config,cljs.core.merge,new_config);
}
});
day8.re_frame.undo.max_undos = (function day8$re_frame$undo$max_undos(){
return cljs.core.cst$kw$max_DASH_undos.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.config) : cljs.core.deref.call(null,day8.re_frame.undo.config)));
});
/**
 * A list of history states
 */
day8.re_frame.undo.undo_list = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
/**
 * A list of future states, caused by undoing
 */
day8.re_frame.undo.redo_list = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
/**
 * Mirrors app-db
 */
day8.re_frame.undo.app_explain = reagent.core.atom.cljs$core$IFn$_invoke$arity$1("");
/**
 * Mirrors undo-list
 */
day8.re_frame.undo.undo_explain_list = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
/**
 * Mirrors redo-list
 */
day8.re_frame.undo.redo_explain_list = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY);
day8.re_frame.undo.clear_undos_BANG_ = (function day8$re_frame$undo$clear_undos_BANG_(){
var G__29011_29015 = day8.re_frame.undo.undo_list;
var G__29012_29016 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29011_29015,G__29012_29016) : cljs.core.reset_BANG_.call(null,G__29011_29015,G__29012_29016));

var G__29013 = day8.re_frame.undo.undo_explain_list;
var G__29014 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29013,G__29014) : cljs.core.reset_BANG_.call(null,G__29013,G__29014));
});
day8.re_frame.undo.clear_redos_BANG_ = (function day8$re_frame$undo$clear_redos_BANG_(){
var G__29021_29025 = day8.re_frame.undo.redo_list;
var G__29022_29026 = cljs.core.PersistentVector.EMPTY;
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29021_29025,G__29022_29026) : cljs.core.reset_BANG_.call(null,G__29021_29025,G__29022_29026));

var G__29023 = day8.re_frame.undo.redo_explain_list;
var G__29024 = cljs.core.PersistentVector.EMPTY;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29023,G__29024) : cljs.core.reset_BANG_.call(null,G__29023,G__29024));
});
day8.re_frame.undo.clear_history_BANG_ = (function day8$re_frame$undo$clear_history_BANG_(){
day8.re_frame.undo.clear_undos_BANG_();

day8.re_frame.undo.clear_redos_BANG_();

return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(day8.re_frame.undo.app_explain,"") : cljs.core.reset_BANG_.call(null,day8.re_frame.undo.app_explain,""));
});
/**
 * Stores the value currently in app-db, so the user can later undo
 */
day8.re_frame.undo.store_now_BANG_ = (function day8$re_frame$undo$store_now_BANG_(explanation){
day8.re_frame.undo.clear_redos_BANG_();

var G__29031_29035 = day8.re_frame.undo.undo_list;
var G__29032_29036 = cljs.core.vec(cljs.core.take_last(day8.re_frame.undo.max_undos(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.undo_list) : cljs.core.deref.call(null,day8.re_frame.undo.undo_list)),cljs.core.cst$kw$harvest_DASH_fn.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.config) : cljs.core.deref.call(null,day8.re_frame.undo.config))).call(null,re_frame.db.app_db))));
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29031_29035,G__29032_29036) : cljs.core.reset_BANG_.call(null,G__29031_29035,G__29032_29036));

var G__29033_29037 = day8.re_frame.undo.undo_explain_list;
var G__29034_29038 = cljs.core.vec(cljs.core.take_last(day8.re_frame.undo.max_undos(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.undo_explain_list) : cljs.core.deref.call(null,day8.re_frame.undo.undo_explain_list)),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.app_explain) : cljs.core.deref.call(null,day8.re_frame.undo.app_explain)))));
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29033_29037,G__29034_29038) : cljs.core.reset_BANG_.call(null,G__29033_29037,G__29034_29038));

return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(day8.re_frame.undo.app_explain,explanation) : cljs.core.reset_BANG_.call(null,day8.re_frame.undo.app_explain,explanation));
});
/**
 * Returns true if undos exist, false otherwise
 */
day8.re_frame.undo.undos_QMARK_ = (function day8$re_frame$undo$undos_QMARK_(){
return cljs.core.seq((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.undo_list) : cljs.core.deref.call(null,day8.re_frame.undo.undo_list)));
});
/**
 * Returns true if redos exist, false otherwise
 */
day8.re_frame.undo.redos_QMARK_ = (function day8$re_frame$undo$redos_QMARK_(){
return cljs.core.seq((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.redo_list) : cljs.core.deref.call(null,day8.re_frame.undo.redo_list)));
});
/**
 * Returns a vector of undo descriptions, perhaps empty
 */
day8.re_frame.undo.undo_explanations = (function day8$re_frame$undo$undo_explanations(){
if(cljs.core.truth_(day8.re_frame.undo.undos_QMARK_())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.undo_explain_list) : cljs.core.deref.call(null,day8.re_frame.undo.undo_explain_list)),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.app_explain) : cljs.core.deref.call(null,day8.re_frame.undo.app_explain)));
} else {
return cljs.core.PersistentVector.EMPTY;
}
});
var G__29039_29041 = cljs.core.cst$kw$undos_QMARK_;
var G__29040_29042 = ((function (G__29039_29041){
return (function day8$re_frame$undo$handler(_,___$1){
return reagent.ratom.make_reaction(((function (G__29039_29041){
return (function (){
return day8.re_frame.undo.undos_QMARK_();
});})(G__29039_29041))
);
});})(G__29039_29041))
;
(re_frame.core.reg_sub_raw.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_sub_raw.cljs$core$IFn$_invoke$arity$2(G__29039_29041,G__29040_29042) : re_frame.core.reg_sub_raw.call(null,G__29039_29041,G__29040_29042));
var G__29043_29045 = cljs.core.cst$kw$redos_QMARK_;
var G__29044_29046 = ((function (G__29043_29045){
return (function day8$re_frame$undo$handler(_,___$1){
return reagent.ratom.make_reaction(((function (G__29043_29045){
return (function (){
return day8.re_frame.undo.redos_QMARK_();
});})(G__29043_29045))
);
});})(G__29043_29045))
;
(re_frame.core.reg_sub_raw.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_sub_raw.cljs$core$IFn$_invoke$arity$2(G__29043_29045,G__29044_29046) : re_frame.core.reg_sub_raw.call(null,G__29043_29045,G__29044_29046));
var G__29047_29049 = cljs.core.cst$kw$undo_DASH_explanations;
var G__29048_29050 = ((function (G__29047_29049){
return (function day8$re_frame$undo$handler(_,___$1){
return reagent.ratom.make_reaction(((function (G__29047_29049){
return (function (){
return day8.re_frame.undo.undo_explanations();
});})(G__29047_29049))
);
});})(G__29047_29049))
;
(re_frame.core.reg_sub_raw.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_sub_raw.cljs$core$IFn$_invoke$arity$2(G__29047_29049,G__29048_29050) : re_frame.core.reg_sub_raw.call(null,G__29047_29049,G__29048_29050));
var G__29051_29053 = cljs.core.cst$kw$redo_DASH_explanations;
var G__29052_29054 = ((function (G__29051_29053){
return (function day8$re_frame$undo$handler(_,___$1){
return reagent.ratom.make_reaction(((function (G__29051_29053){
return (function (){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.redo_explain_list) : cljs.core.deref.call(null,day8.re_frame.undo.redo_explain_list));
});})(G__29051_29053))
);
});})(G__29051_29053))
;
(re_frame.core.reg_sub_raw.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_sub_raw.cljs$core$IFn$_invoke$arity$2(G__29051_29053,G__29052_29054) : re_frame.core.reg_sub_raw.call(null,G__29051_29053,G__29052_29054));
day8.re_frame.undo.undo = (function day8$re_frame$undo$undo(harvester,reinstater,undos,cur,redos){
var u = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(undos) : cljs.core.deref.call(null,undos));
var r = cljs.core.cons((harvester.cljs$core$IFn$_invoke$arity$1 ? harvester.cljs$core$IFn$_invoke$arity$1(cur) : harvester.call(null,cur)),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(redos) : cljs.core.deref.call(null,redos)));
var G__29059_29063 = cur;
var G__29060_29064 = cljs.core.last(u);
(reinstater.cljs$core$IFn$_invoke$arity$2 ? reinstater.cljs$core$IFn$_invoke$arity$2(G__29059_29063,G__29060_29064) : reinstater.call(null,G__29059_29063,G__29060_29064));

(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(redos,r) : cljs.core.reset_BANG_.call(null,redos,r));

var G__29061 = undos;
var G__29062 = cljs.core.pop(u);
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29061,G__29062) : cljs.core.reset_BANG_.call(null,G__29061,G__29062));
});
/**
 * undo n steps or until we run out of undos
 */
day8.re_frame.undo.undo_n = (function day8$re_frame$undo$undo_n(n){
while(true){
if(cljs.core.truth_((function (){var and__7207__auto__ = (n > (0));
if(and__7207__auto__){
return day8.re_frame.undo.undos_QMARK_();
} else {
return and__7207__auto__;
}
})())){
day8.re_frame.undo.undo(cljs.core.cst$kw$harvest_DASH_fn.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.config) : cljs.core.deref.call(null,day8.re_frame.undo.config))),cljs.core.cst$kw$reinstate_DASH_fn.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.config) : cljs.core.deref.call(null,day8.re_frame.undo.config))),day8.re_frame.undo.undo_list,re_frame.db.app_db,day8.re_frame.undo.redo_list);

day8.re_frame.undo.undo(cljs.core.deref,cljs.core.reset_BANG_,day8.re_frame.undo.undo_explain_list,day8.re_frame.undo.app_explain,day8.re_frame.undo.redo_explain_list);

var G__29065 = (n - (1));
n = G__29065;
continue;
} else {
return null;
}
break;
}
});
day8.re_frame.undo.undo_handler = (function day8$re_frame$undo$undo_handler(_,p__29066){
var vec__29072 = p__29066;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29072,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29072,(1),null);
if(cljs.core.not(day8.re_frame.undo.undos_QMARK_())){
var G__29075_29077 = cljs.core.cst$kw$warn;
var G__29076_29078 = "re-frame: you did a (dispatch [:undo]), but there is nothing to undo.";
(re_frame.core.console.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.console.cljs$core$IFn$_invoke$arity$2(G__29075_29077,G__29076_29078) : re_frame.core.console.call(null,G__29075_29077,G__29076_29078));
} else {
day8.re_frame.undo.undo_n((function (){var or__7219__auto__ = n;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return (1);
}
})());
}

return cljs.core.PersistentArrayMap.EMPTY;
});
day8.re_frame.undo.redo = (function day8$re_frame$undo$redo(harvester,reinstater,undos,cur,redos){
var u = cljs.core.conj.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(undos) : cljs.core.deref.call(null,undos)),(harvester.cljs$core$IFn$_invoke$arity$1 ? harvester.cljs$core$IFn$_invoke$arity$1(cur) : harvester.call(null,cur)));
var r = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(redos) : cljs.core.deref.call(null,redos));
var G__29083_29087 = cur;
var G__29084_29088 = cljs.core.first(r);
(reinstater.cljs$core$IFn$_invoke$arity$2 ? reinstater.cljs$core$IFn$_invoke$arity$2(G__29083_29087,G__29084_29088) : reinstater.call(null,G__29083_29087,G__29084_29088));

var G__29085_29089 = redos;
var G__29086_29090 = cljs.core.rest(r);
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__29085_29089,G__29086_29090) : cljs.core.reset_BANG_.call(null,G__29085_29089,G__29086_29090));

return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(undos,u) : cljs.core.reset_BANG_.call(null,undos,u));
});
/**
 * redo n steps or until we run out of redos
 */
day8.re_frame.undo.redo_n = (function day8$re_frame$undo$redo_n(n){
while(true){
if(cljs.core.truth_((function (){var and__7207__auto__ = (n > (0));
if(and__7207__auto__){
return day8.re_frame.undo.redos_QMARK_();
} else {
return and__7207__auto__;
}
})())){
day8.re_frame.undo.redo(cljs.core.cst$kw$harvest_DASH_fn.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.config) : cljs.core.deref.call(null,day8.re_frame.undo.config))),cljs.core.cst$kw$reinstate_DASH_fn.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(day8.re_frame.undo.config) : cljs.core.deref.call(null,day8.re_frame.undo.config))),day8.re_frame.undo.undo_list,re_frame.db.app_db,day8.re_frame.undo.redo_list);

day8.re_frame.undo.redo(cljs.core.deref,cljs.core.reset_BANG_,day8.re_frame.undo.undo_explain_list,day8.re_frame.undo.app_explain,day8.re_frame.undo.redo_explain_list);

var G__29091 = (n - (1));
n = G__29091;
continue;
} else {
return null;
}
break;
}
});
day8.re_frame.undo.redo_handler = (function day8$re_frame$undo$redo_handler(_,p__29092){
var vec__29098 = p__29092;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29098,(0),null);
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29098,(1),null);
if(cljs.core.not(day8.re_frame.undo.redos_QMARK_())){
var G__29101_29103 = cljs.core.cst$kw$warn;
var G__29102_29104 = "re-frame: you did a (dispatch [:redo]), but there is nothing to redo.";
(re_frame.core.console.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.console.cljs$core$IFn$_invoke$arity$2(G__29101_29103,G__29102_29104) : re_frame.core.console.call(null,G__29101_29103,G__29102_29104));
} else {
day8.re_frame.undo.redo_n((function (){var or__7219__auto__ = n;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return (1);
}
})());
}

return cljs.core.PersistentArrayMap.EMPTY;
});
day8.re_frame.undo.purge_redo_handler = (function day8$re_frame$undo$purge_redo_handler(db,_){
if(cljs.core.not(day8.re_frame.undo.redos_QMARK_())){
var G__29107_29109 = cljs.core.cst$kw$warn;
var G__29108_29110 = "re-frame: you did a (dispatch [:purge-redos]), but there is nothing to redo.";
(re_frame.core.console.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.console.cljs$core$IFn$_invoke$arity$2(G__29107_29109,G__29108_29110) : re_frame.core.console.call(null,G__29107_29109,G__29108_29110));
} else {
day8.re_frame.undo.clear_redos_BANG_();
}

return db;
});
/**
 * returns a side-effecting Interceptor, which stores an undo checkpoint in
 *   `:after` processing.
 * If the `:effect` cotnains an `:undo` key, then use the explanation provided
 * by it. Otherwise, `explanation` can be:
 *   - a string (of explanation)
 *   - a function expected to return a string of explanation. It will be called
 *     with two arguments: `db` and `event-vec`.
 *   - a nil, in which case "" is recorded as the explanation
 *   
 */
day8.re_frame.undo.undoable = (function day8$re_frame$undo$undoable(var_args){
var args29111 = [];
var len__8435__auto___29131 = arguments.length;
var i__8436__auto___29132 = (0);
while(true){
if((i__8436__auto___29132 < len__8435__auto___29131)){
args29111.push((arguments[i__8436__auto___29132]));

var G__29133 = (i__8436__auto___29132 + (1));
i__8436__auto___29132 = G__29133;
continue;
} else {
}
break;
}

var G__29113 = args29111.length;
switch (G__29113) {
case 0:
return day8.re_frame.undo.undoable.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return day8.re_frame.undo.undoable.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29111.length)].join('')));

}
});

day8.re_frame.undo.undoable.cljs$core$IFn$_invoke$arity$0 = (function (){
return day8.re_frame.undo.undoable.cljs$core$IFn$_invoke$arity$1(null);
});

day8.re_frame.undo.undoable.cljs$core$IFn$_invoke$arity$1 = (function (explanation){
var G__29114 = cljs.core.cst$kw$id;
var G__29115 = cljs.core.cst$kw$undoable;
var G__29116 = cljs.core.cst$kw$after;
var G__29117 = ((function (G__29114,G__29115,G__29116){
return (function (context){
var event = (function (){var G__29118 = context;
var G__29119 = cljs.core.cst$kw$event;
return (re_frame.core.get_coeffect.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.get_coeffect.cljs$core$IFn$_invoke$arity$2(G__29118,G__29119) : re_frame.core.get_coeffect.call(null,G__29118,G__29119));
})();
var undo_effect = (function (){var G__29120 = context;
var G__29121 = cljs.core.cst$kw$undo;
return (re_frame.core.get_effect.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.get_effect.cljs$core$IFn$_invoke$arity$2(G__29120,G__29121) : re_frame.core.get_effect.call(null,G__29120,G__29121));
})();
var explanation__$1 = ((cljs.core.some_QMARK_(undo_effect))?undo_effect:((cljs.core.fn_QMARK_(explanation))?(function (){var G__29122 = (function (){var G__29124 = context;
var G__29125 = cljs.core.cst$kw$db;
return (re_frame.core.get_coeffect.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.get_coeffect.cljs$core$IFn$_invoke$arity$2(G__29124,G__29125) : re_frame.core.get_coeffect.call(null,G__29124,G__29125));
})();
var G__29123 = event;
return (explanation.cljs$core$IFn$_invoke$arity$2 ? explanation.cljs$core$IFn$_invoke$arity$2(G__29122,G__29123) : explanation.call(null,G__29122,G__29123));
})():((typeof explanation === 'string')?explanation:(((explanation == null))?"":(function (){var G__29126 = cljs.core.cst$kw$error;
var G__29127 = "re-frame-undo: \"undoable\" interceptor on event ";
var G__29128 = event;
var G__29129 = " given a bad parameter. Got: ";
var G__29130 = explanation;
return (re_frame.core.console.cljs$core$IFn$_invoke$arity$5 ? re_frame.core.console.cljs$core$IFn$_invoke$arity$5(G__29126,G__29127,G__29128,G__29129,G__29130) : re_frame.core.console.call(null,G__29126,G__29127,G__29128,G__29129,G__29130));
})()
))));
day8.re_frame.undo.store_now_BANG_(explanation__$1);

return cljs.core.update.cljs$core$IFn$_invoke$arity$4(context,cljs.core.cst$kw$effects,cljs.core.dissoc,cljs.core.cst$kw$undo);
});})(G__29114,G__29115,G__29116))
;
return (re_frame.core.__GT_interceptor.cljs$core$IFn$_invoke$arity$4 ? re_frame.core.__GT_interceptor.cljs$core$IFn$_invoke$arity$4(G__29114,G__29115,G__29116,G__29117) : re_frame.core.__GT_interceptor.call(null,G__29114,G__29115,G__29116,G__29117));
});

day8.re_frame.undo.undoable.cljs$lang$maxFixedArity = 1;

day8.re_frame.undo.register_events_subs_BANG_ = (function day8$re_frame$undo$register_events_subs_BANG_(){
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$undo,day8.re_frame.undo.undo_handler);

re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$redo,day8.re_frame.undo.redo_handler);

return re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$purge_DASH_redos,day8.re_frame.undo.purge_redo_handler);
});
day8.re_frame.undo.register_events_subs_BANG_();
