// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.components.lighttable');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('dommy.core');
goog.require('cljs.core.async');
goog.require('imcljs.fetch');
goog.require('imcljs.path');
/**
 * Returns a sequence of true / false indicating that all values in each
 *   column of a table are equal. Assumes all rows are the same length.
 *   [[A B C] [X B Y]]
 * => (false true false)
 */
bluegenes.components.lighttable.homogeneous_columns = (function bluegenes$components$lighttable$homogeneous_columns(table){
return cljs.core.map.call(null,(function (column){
return cljs.core.apply.call(null,cljs.core._EQ_,cljs.core.map.call(null,(function (row){
return cljs.core.nth.call(null,row,column);
}),table));
}),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.first.call(null,table))));
});
/**
 * a basic results table without imtables complexity. optional second arg options allows you to specify whether or not to show a title for the table, as {:title true}. 
 */
bluegenes.components.lighttable.table = (function bluegenes$components$lighttable$table(){
var current_model = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-model","current-model",-1288511749)], null));
return ((function (current_model){
return (function() {
var G__8198 = null;
var G__8198__1 = (function (results){
var skip_columns = null;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.table.small","table.table.small",-2143262832),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646)], null),cljs.core.map.call(null,((function (skip_columns,current_model){
return (function (header){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),cljs.core.last.call(null,clojure.string.split.call(null,header," > "))], null);
});})(skip_columns,current_model))
,new cljs.core.Keyword(null,"columnHeaders","columnHeaders",953900997).cljs$core$IFn$_invoke$arity$1(results)))], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300)], null),cljs.core.map.call(null,((function (skip_columns,current_model){
return (function (row){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646)], null),cljs.core.map_indexed.call(null,((function (skip_columns,current_model){
return (function (idx,value){
if(cljs.core.truth_(cljs.core.nth.call(null,skip_columns,idx))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.skipped","td.skipped",-1956779939),"..."], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),((((50) < cljs.core.count.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(value))))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.call(null,cljs.core.str,cljs.core.take.call(null,(50),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value)))),"..."].join(''):cljs.core.str.cljs$core$IFn$_invoke$arity$1(value))], null);
}
});})(skip_columns,current_model))
,row));
});})(skip_columns,current_model))
,new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(results)))], null);
});
var G__8198__2 = (function (results,options){
if(cljs.core.truth_(new cljs.core.Keyword(null,"title","title",636505583).cljs$core$IFn$_invoke$arity$1(options))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.Keyword(null,"displayName","displayName",-809144601).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,imcljs.path.walk.call(null,cljs.core.deref.call(null,current_model),new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(results))))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.lighttable.table,results], null)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.lighttable.table,results], null);
}
});
G__8198 = function(results,options){
switch(arguments.length){
case 1:
return G__8198__1.call(this,results);
case 2:
return G__8198__2.call(this,results,options);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8198.cljs$core$IFn$_invoke$arity$1 = G__8198__1;
G__8198.cljs$core$IFn$_invoke$arity$2 = G__8198__2;
return G__8198;
})()
;})(current_model))
});
bluegenes.components.lighttable.shell = (function bluegenes$components$lighttable$shell(){
return (function (state,package$,options){
if(cljs.core.empty_QMARK_.call(null,new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.small.no-results","div.small.no-results",-995985117),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state)))," - No Results"].join('')], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.lt","div.lt",691473373),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.lighttable.table,cljs.core.deref.call(null,state),options], null)], null);
}
});
});
bluegenes.components.lighttable.handler = (function bluegenes$components$lighttable$handler(state,e){
var props = reagent.core.props.call(null,e);
var node = (dommy.utils.__GT_Array.call(null,reagent.core.dom_node.call(null,e).getElementsByClassName("im-target"))[(0)]);
var missing_values = cljs.core.filter.call(null,((function (props,node){
return (function (p1__8199_SHARP_){
return ((cljs.core._EQ_.call(null,null,new cljs.core.Keyword(null,"value","value",305978217).cljs$core$IFn$_invoke$arity$1(p1__8199_SHARP_))) && ((!((new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__8199_SHARP_) == null)))));
});})(props,node))
,new cljs.core.Keyword(null,"where","where",-2044795965).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"query","query",-1288509510).cljs$core$IFn$_invoke$arity$1(props)));
if(cljs.core.empty_QMARK_.call(null,missing_values)){
var c__2429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto__,props,node,missing_values){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto__,props,node,missing_values){
return (function (state_8212){
var state_val_8213 = (state_8212[(1)]);
if((state_val_8213 === (1))){
var inst_8200 = new cljs.core.Keyword(null,"service","service",-1963054559).cljs$core$IFn$_invoke$arity$1(props);
var inst_8201 = new cljs.core.Keyword(null,"query","query",-1288509510).cljs$core$IFn$_invoke$arity$1(props);
var inst_8202 = [new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_8203 = [(5),"json"];
var inst_8204 = cljs.core.PersistentHashMap.fromArrays(inst_8202,inst_8203);
var inst_8205 = imcljs.fetch.rows.call(null,inst_8200,inst_8201,inst_8204);
var state_8212__$1 = state_8212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_8212__$1,(2),inst_8205);
} else {
if((state_val_8213 === (2))){
var inst_8207 = (state_8212[(2)]);
var inst_8208 = new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props);
var inst_8209 = cljs.core.assoc.call(null,inst_8207,new cljs.core.Keyword(null,"class","class",-2030961996),inst_8208);
var inst_8210 = cljs.core.reset_BANG_.call(null,state,inst_8209);
var state_8212__$1 = state_8212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_8212__$1,inst_8210);
} else {
return null;
}
}
});})(c__2429__auto__,props,node,missing_values))
;
return ((function (switch__2334__auto__,c__2429__auto__,props,node,missing_values){
return (function() {
var bluegenes$components$lighttable$handler_$_state_machine__2335__auto__ = null;
var bluegenes$components$lighttable$handler_$_state_machine__2335__auto____0 = (function (){
var statearr_8214 = [null,null,null,null,null,null,null];
(statearr_8214[(0)] = bluegenes$components$lighttable$handler_$_state_machine__2335__auto__);

(statearr_8214[(1)] = (1));

return statearr_8214;
});
var bluegenes$components$lighttable$handler_$_state_machine__2335__auto____1 = (function (state_8212){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_8212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e8215){if((e8215 instanceof Object)){
var ex__2338__auto__ = e8215;
var statearr_8216_8218 = state_8212;
(statearr_8216_8218[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_8212);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e8215;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__8219 = state_8212;
state_8212 = G__8219;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
bluegenes$components$lighttable$handler_$_state_machine__2335__auto__ = function(state_8212){
switch(arguments.length){
case 0:
return bluegenes$components$lighttable$handler_$_state_machine__2335__auto____0.call(this);
case 1:
return bluegenes$components$lighttable$handler_$_state_machine__2335__auto____1.call(this,state_8212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
bluegenes$components$lighttable$handler_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = bluegenes$components$lighttable$handler_$_state_machine__2335__auto____0;
bluegenes$components$lighttable$handler_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = bluegenes$components$lighttable$handler_$_state_machine__2335__auto____1;
return bluegenes$components$lighttable$handler_$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto__,props,node,missing_values))
})();
var state__2431__auto__ = (function (){var statearr_8217 = f__2430__auto__.call(null);
(statearr_8217[(6)] = c__2429__auto__);

return statearr_8217;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto__,props,node,missing_values))
);

return c__2429__auto__;
} else {
return null;
}
});
bluegenes.components.lighttable.main = (function bluegenes$components$lighttable$main(){
var state = reagent.core.atom.call(null,null);
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),cljs.core.partial.call(null,bluegenes.components.lighttable.handler,state),new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),cljs.core.partial.call(null,bluegenes.components.lighttable.handler,state),new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (state){
return (function (package$,options){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.lighttable.shell,state,package$,options], null);
});})(state))
], null));
});

//# sourceMappingURL=lighttable.js.map
