// Compiled by ClojureScript 1.10.520 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__2489 = arguments.length;
switch (G__2489) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async2490 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async2490 = (function (f,blockable,meta2491){
this.f = f;
this.blockable = blockable;
this.meta2491 = meta2491;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async2490.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_2492,meta2491__$1){
var self__ = this;
var _2492__$1 = this;
return (new cljs.core.async.t_cljs$core$async2490(self__.f,self__.blockable,meta2491__$1));
});

cljs.core.async.t_cljs$core$async2490.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_2492){
var self__ = this;
var _2492__$1 = this;
return self__.meta2491;
});

cljs.core.async.t_cljs$core$async2490.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async2490.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async2490.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async2490.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async2490.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta2491","meta2491",-1119919568,null)], null);
});

cljs.core.async.t_cljs$core$async2490.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async2490.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async2490";

cljs.core.async.t_cljs$core$async2490.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async2490");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async2490.
 */
cljs.core.async.__GT_t_cljs$core$async2490 = (function cljs$core$async$__GT_t_cljs$core$async2490(f__$1,blockable__$1,meta2491){
return (new cljs.core.async.t_cljs$core$async2490(f__$1,blockable__$1,meta2491));
});

}

return (new cljs.core.async.t_cljs$core$async2490(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__2496 = arguments.length;
switch (G__2496) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__2499 = arguments.length;
switch (G__2499) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__2502 = arguments.length;
switch (G__2502) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_2504 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_2504);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_2504,ret){
return (function (){
return fn1.call(null,val_2504);
});})(val_2504,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__2506 = arguments.length;
switch (G__2506) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5455__auto__)){
var ret = temp__5455__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5455__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__5455__auto__)){
var retb = temp__5455__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__5455__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__5455__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4607__auto___2508 = n;
var x_2509 = (0);
while(true){
if((x_2509 < n__4607__auto___2508)){
(a[x_2509] = (0));

var G__2510 = (x_2509 + (1));
x_2509 = G__2510;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__2511 = (i + (1));
i = G__2511;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async2512 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async2512 = (function (flag,meta2513){
this.flag = flag;
this.meta2513 = meta2513;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async2512.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_2514,meta2513__$1){
var self__ = this;
var _2514__$1 = this;
return (new cljs.core.async.t_cljs$core$async2512(self__.flag,meta2513__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async2512.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_2514){
var self__ = this;
var _2514__$1 = this;
return self__.meta2513;
});})(flag))
;

cljs.core.async.t_cljs$core$async2512.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async2512.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async2512.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async2512.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async2512.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta2513","meta2513",1551461636,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async2512.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async2512.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async2512";

cljs.core.async.t_cljs$core$async2512.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async2512");
});})(flag))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async2512.
 */
cljs.core.async.__GT_t_cljs$core$async2512 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async2512(flag__$1,meta2513){
return (new cljs.core.async.t_cljs$core$async2512(flag__$1,meta2513));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async2512(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async2515 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async2515 = (function (flag,cb,meta2516){
this.flag = flag;
this.cb = cb;
this.meta2516 = meta2516;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async2515.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_2517,meta2516__$1){
var self__ = this;
var _2517__$1 = this;
return (new cljs.core.async.t_cljs$core$async2515(self__.flag,self__.cb,meta2516__$1));
});

cljs.core.async.t_cljs$core$async2515.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_2517){
var self__ = this;
var _2517__$1 = this;
return self__.meta2516;
});

cljs.core.async.t_cljs$core$async2515.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async2515.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async2515.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async2515.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async2515.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta2516","meta2516",746874355,null)], null);
});

cljs.core.async.t_cljs$core$async2515.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async2515.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async2515";

cljs.core.async.t_cljs$core$async2515.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async2515");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async2515.
 */
cljs.core.async.__GT_t_cljs$core$async2515 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async2515(flag__$1,cb__$1,meta2516){
return (new cljs.core.async.t_cljs$core$async2515(flag__$1,cb__$1,meta2516));
});

}

return (new cljs.core.async.t_cljs$core$async2515(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__2518_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__2518_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__2519_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__2519_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__4131__auto__ = wport;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return port;
}
})()], null));
} else {
var G__2520 = (i + (1));
i = G__2520;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4131__auto__ = ret;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5457__auto__ = (function (){var and__4120__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(temp__5457__auto__)){
var got = temp__5457__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___2526 = arguments.length;
var i__4731__auto___2527 = (0);
while(true){
if((i__4731__auto___2527 < len__4730__auto___2526)){
args__4736__auto__.push((arguments[i__4731__auto___2527]));

var G__2528 = (i__4731__auto___2527 + (1));
i__4731__auto___2527 = G__2528;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((1) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4737__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__2523){
var map__2524 = p__2523;
var map__2524__$1 = (((((!((map__2524 == null))))?(((((map__2524.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__2524.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__2524):map__2524);
var opts = map__2524__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

/** @this {Function} */
cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq2521){
var G__2522 = cljs.core.first.call(null,seq2521);
var seq2521__$1 = cljs.core.next.call(null,seq2521);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__2522,seq2521__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__2530 = arguments.length;
switch (G__2530) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__2429__auto___2576 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___2576){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___2576){
return (function (state_2554){
var state_val_2555 = (state_2554[(1)]);
if((state_val_2555 === (7))){
var inst_2550 = (state_2554[(2)]);
var state_2554__$1 = state_2554;
var statearr_2556_2577 = state_2554__$1;
(statearr_2556_2577[(2)] = inst_2550);

(statearr_2556_2577[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2555 === (1))){
var state_2554__$1 = state_2554;
var statearr_2557_2578 = state_2554__$1;
(statearr_2557_2578[(2)] = null);

(statearr_2557_2578[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2555 === (4))){
var inst_2533 = (state_2554[(7)]);
var inst_2533__$1 = (state_2554[(2)]);
var inst_2534 = (inst_2533__$1 == null);
var state_2554__$1 = (function (){var statearr_2558 = state_2554;
(statearr_2558[(7)] = inst_2533__$1);

return statearr_2558;
})();
if(cljs.core.truth_(inst_2534)){
var statearr_2559_2579 = state_2554__$1;
(statearr_2559_2579[(1)] = (5));

} else {
var statearr_2560_2580 = state_2554__$1;
(statearr_2560_2580[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2555 === (13))){
var state_2554__$1 = state_2554;
var statearr_2561_2581 = state_2554__$1;
(statearr_2561_2581[(2)] = null);

(statearr_2561_2581[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2555 === (6))){
var inst_2533 = (state_2554[(7)]);
var state_2554__$1 = state_2554;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_2554__$1,(11),to,inst_2533);
} else {
if((state_val_2555 === (3))){
var inst_2552 = (state_2554[(2)]);
var state_2554__$1 = state_2554;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2554__$1,inst_2552);
} else {
if((state_val_2555 === (12))){
var state_2554__$1 = state_2554;
var statearr_2562_2582 = state_2554__$1;
(statearr_2562_2582[(2)] = null);

(statearr_2562_2582[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2555 === (2))){
var state_2554__$1 = state_2554;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2554__$1,(4),from);
} else {
if((state_val_2555 === (11))){
var inst_2543 = (state_2554[(2)]);
var state_2554__$1 = state_2554;
if(cljs.core.truth_(inst_2543)){
var statearr_2563_2583 = state_2554__$1;
(statearr_2563_2583[(1)] = (12));

} else {
var statearr_2564_2584 = state_2554__$1;
(statearr_2564_2584[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2555 === (9))){
var state_2554__$1 = state_2554;
var statearr_2565_2585 = state_2554__$1;
(statearr_2565_2585[(2)] = null);

(statearr_2565_2585[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2555 === (5))){
var state_2554__$1 = state_2554;
if(cljs.core.truth_(close_QMARK_)){
var statearr_2566_2586 = state_2554__$1;
(statearr_2566_2586[(1)] = (8));

} else {
var statearr_2567_2587 = state_2554__$1;
(statearr_2567_2587[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2555 === (14))){
var inst_2548 = (state_2554[(2)]);
var state_2554__$1 = state_2554;
var statearr_2568_2588 = state_2554__$1;
(statearr_2568_2588[(2)] = inst_2548);

(statearr_2568_2588[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2555 === (10))){
var inst_2540 = (state_2554[(2)]);
var state_2554__$1 = state_2554;
var statearr_2569_2589 = state_2554__$1;
(statearr_2569_2589[(2)] = inst_2540);

(statearr_2569_2589[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2555 === (8))){
var inst_2537 = cljs.core.async.close_BANG_.call(null,to);
var state_2554__$1 = state_2554;
var statearr_2570_2590 = state_2554__$1;
(statearr_2570_2590[(2)] = inst_2537);

(statearr_2570_2590[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___2576))
;
return ((function (switch__2334__auto__,c__2429__auto___2576){
return (function() {
var cljs$core$async$state_machine__2335__auto__ = null;
var cljs$core$async$state_machine__2335__auto____0 = (function (){
var statearr_2571 = [null,null,null,null,null,null,null,null];
(statearr_2571[(0)] = cljs$core$async$state_machine__2335__auto__);

(statearr_2571[(1)] = (1));

return statearr_2571;
});
var cljs$core$async$state_machine__2335__auto____1 = (function (state_2554){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_2554);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e2572){if((e2572 instanceof Object)){
var ex__2338__auto__ = e2572;
var statearr_2573_2591 = state_2554;
(statearr_2573_2591[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2554);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e2572;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__2592 = state_2554;
state_2554 = G__2592;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$state_machine__2335__auto__ = function(state_2554){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2335__auto____1.call(this,state_2554);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2335__auto____0;
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2335__auto____1;
return cljs$core$async$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___2576))
})();
var state__2431__auto__ = (function (){var statearr_2574 = f__2430__auto__.call(null);
(statearr_2574[(6)] = c__2429__auto___2576);

return statearr_2574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___2576))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__2593){
var vec__2594 = p__2593;
var v = cljs.core.nth.call(null,vec__2594,(0),null);
var p = cljs.core.nth.call(null,vec__2594,(1),null);
var job = vec__2594;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__2429__auto___2765 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___2765,res,vec__2594,v,p,job,jobs,results){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___2765,res,vec__2594,v,p,job,jobs,results){
return (function (state_2601){
var state_val_2602 = (state_2601[(1)]);
if((state_val_2602 === (1))){
var state_2601__$1 = state_2601;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_2601__$1,(2),res,v);
} else {
if((state_val_2602 === (2))){
var inst_2598 = (state_2601[(2)]);
var inst_2599 = cljs.core.async.close_BANG_.call(null,res);
var state_2601__$1 = (function (){var statearr_2603 = state_2601;
(statearr_2603[(7)] = inst_2598);

return statearr_2603;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2601__$1,inst_2599);
} else {
return null;
}
}
});})(c__2429__auto___2765,res,vec__2594,v,p,job,jobs,results))
;
return ((function (switch__2334__auto__,c__2429__auto___2765,res,vec__2594,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0 = (function (){
var statearr_2604 = [null,null,null,null,null,null,null,null];
(statearr_2604[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__);

(statearr_2604[(1)] = (1));

return statearr_2604;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1 = (function (state_2601){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_2601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e2605){if((e2605 instanceof Object)){
var ex__2338__auto__ = e2605;
var statearr_2606_2766 = state_2601;
(statearr_2606_2766[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2601);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e2605;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__2767 = state_2601;
state_2601 = G__2767;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__ = function(state_2601){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1.call(this,state_2601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___2765,res,vec__2594,v,p,job,jobs,results))
})();
var state__2431__auto__ = (function (){var statearr_2607 = f__2430__auto__.call(null);
(statearr_2607[(6)] = c__2429__auto___2765);

return statearr_2607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___2765,res,vec__2594,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__2608){
var vec__2609 = p__2608;
var v = cljs.core.nth.call(null,vec__2609,(0),null);
var p = cljs.core.nth.call(null,vec__2609,(1),null);
var job = vec__2609;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__4607__auto___2768 = n;
var __2769 = (0);
while(true){
if((__2769 < n__4607__auto___2768)){
var G__2612_2770 = type;
var G__2612_2771__$1 = (((G__2612_2770 instanceof cljs.core.Keyword))?G__2612_2770.fqn:null);
switch (G__2612_2771__$1) {
case "compute":
var c__2429__auto___2773 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__2769,c__2429__auto___2773,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (__2769,c__2429__auto___2773,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async){
return (function (state_2625){
var state_val_2626 = (state_2625[(1)]);
if((state_val_2626 === (1))){
var state_2625__$1 = state_2625;
var statearr_2627_2774 = state_2625__$1;
(statearr_2627_2774[(2)] = null);

(statearr_2627_2774[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2626 === (2))){
var state_2625__$1 = state_2625;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2625__$1,(4),jobs);
} else {
if((state_val_2626 === (3))){
var inst_2623 = (state_2625[(2)]);
var state_2625__$1 = state_2625;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2625__$1,inst_2623);
} else {
if((state_val_2626 === (4))){
var inst_2615 = (state_2625[(2)]);
var inst_2616 = process.call(null,inst_2615);
var state_2625__$1 = state_2625;
if(cljs.core.truth_(inst_2616)){
var statearr_2628_2775 = state_2625__$1;
(statearr_2628_2775[(1)] = (5));

} else {
var statearr_2629_2776 = state_2625__$1;
(statearr_2629_2776[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2626 === (5))){
var state_2625__$1 = state_2625;
var statearr_2630_2777 = state_2625__$1;
(statearr_2630_2777[(2)] = null);

(statearr_2630_2777[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2626 === (6))){
var state_2625__$1 = state_2625;
var statearr_2631_2778 = state_2625__$1;
(statearr_2631_2778[(2)] = null);

(statearr_2631_2778[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2626 === (7))){
var inst_2621 = (state_2625[(2)]);
var state_2625__$1 = state_2625;
var statearr_2632_2779 = state_2625__$1;
(statearr_2632_2779[(2)] = inst_2621);

(statearr_2632_2779[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__2769,c__2429__auto___2773,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async))
;
return ((function (__2769,switch__2334__auto__,c__2429__auto___2773,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0 = (function (){
var statearr_2633 = [null,null,null,null,null,null,null];
(statearr_2633[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__);

(statearr_2633[(1)] = (1));

return statearr_2633;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1 = (function (state_2625){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_2625);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e2634){if((e2634 instanceof Object)){
var ex__2338__auto__ = e2634;
var statearr_2635_2780 = state_2625;
(statearr_2635_2780[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2625);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e2634;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__2781 = state_2625;
state_2625 = G__2781;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__ = function(state_2625){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1.call(this,state_2625);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__;
})()
;})(__2769,switch__2334__auto__,c__2429__auto___2773,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async))
})();
var state__2431__auto__ = (function (){var statearr_2636 = f__2430__auto__.call(null);
(statearr_2636[(6)] = c__2429__auto___2773);

return statearr_2636;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(__2769,c__2429__auto___2773,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async))
);


break;
case "async":
var c__2429__auto___2782 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__2769,c__2429__auto___2782,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (__2769,c__2429__auto___2782,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async){
return (function (state_2649){
var state_val_2650 = (state_2649[(1)]);
if((state_val_2650 === (1))){
var state_2649__$1 = state_2649;
var statearr_2651_2783 = state_2649__$1;
(statearr_2651_2783[(2)] = null);

(statearr_2651_2783[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2650 === (2))){
var state_2649__$1 = state_2649;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2649__$1,(4),jobs);
} else {
if((state_val_2650 === (3))){
var inst_2647 = (state_2649[(2)]);
var state_2649__$1 = state_2649;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2649__$1,inst_2647);
} else {
if((state_val_2650 === (4))){
var inst_2639 = (state_2649[(2)]);
var inst_2640 = async.call(null,inst_2639);
var state_2649__$1 = state_2649;
if(cljs.core.truth_(inst_2640)){
var statearr_2652_2784 = state_2649__$1;
(statearr_2652_2784[(1)] = (5));

} else {
var statearr_2653_2785 = state_2649__$1;
(statearr_2653_2785[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2650 === (5))){
var state_2649__$1 = state_2649;
var statearr_2654_2786 = state_2649__$1;
(statearr_2654_2786[(2)] = null);

(statearr_2654_2786[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2650 === (6))){
var state_2649__$1 = state_2649;
var statearr_2655_2787 = state_2649__$1;
(statearr_2655_2787[(2)] = null);

(statearr_2655_2787[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2650 === (7))){
var inst_2645 = (state_2649[(2)]);
var state_2649__$1 = state_2649;
var statearr_2656_2788 = state_2649__$1;
(statearr_2656_2788[(2)] = inst_2645);

(statearr_2656_2788[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__2769,c__2429__auto___2782,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async))
;
return ((function (__2769,switch__2334__auto__,c__2429__auto___2782,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0 = (function (){
var statearr_2657 = [null,null,null,null,null,null,null];
(statearr_2657[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__);

(statearr_2657[(1)] = (1));

return statearr_2657;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1 = (function (state_2649){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_2649);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e2658){if((e2658 instanceof Object)){
var ex__2338__auto__ = e2658;
var statearr_2659_2789 = state_2649;
(statearr_2659_2789[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2649);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e2658;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__2790 = state_2649;
state_2649 = G__2790;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__ = function(state_2649){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1.call(this,state_2649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__;
})()
;})(__2769,switch__2334__auto__,c__2429__auto___2782,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async))
})();
var state__2431__auto__ = (function (){var statearr_2660 = f__2430__auto__.call(null);
(statearr_2660[(6)] = c__2429__auto___2782);

return statearr_2660;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(__2769,c__2429__auto___2782,G__2612_2770,G__2612_2771__$1,n__4607__auto___2768,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__2612_2771__$1)].join('')));

}

var G__2791 = (__2769 + (1));
__2769 = G__2791;
continue;
} else {
}
break;
}

var c__2429__auto___2792 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___2792,jobs,results,process,async){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___2792,jobs,results,process,async){
return (function (state_2682){
var state_val_2683 = (state_2682[(1)]);
if((state_val_2683 === (1))){
var state_2682__$1 = state_2682;
var statearr_2684_2793 = state_2682__$1;
(statearr_2684_2793[(2)] = null);

(statearr_2684_2793[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2683 === (2))){
var state_2682__$1 = state_2682;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2682__$1,(4),from);
} else {
if((state_val_2683 === (3))){
var inst_2680 = (state_2682[(2)]);
var state_2682__$1 = state_2682;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2682__$1,inst_2680);
} else {
if((state_val_2683 === (4))){
var inst_2663 = (state_2682[(7)]);
var inst_2663__$1 = (state_2682[(2)]);
var inst_2664 = (inst_2663__$1 == null);
var state_2682__$1 = (function (){var statearr_2685 = state_2682;
(statearr_2685[(7)] = inst_2663__$1);

return statearr_2685;
})();
if(cljs.core.truth_(inst_2664)){
var statearr_2686_2794 = state_2682__$1;
(statearr_2686_2794[(1)] = (5));

} else {
var statearr_2687_2795 = state_2682__$1;
(statearr_2687_2795[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2683 === (5))){
var inst_2666 = cljs.core.async.close_BANG_.call(null,jobs);
var state_2682__$1 = state_2682;
var statearr_2688_2796 = state_2682__$1;
(statearr_2688_2796[(2)] = inst_2666);

(statearr_2688_2796[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2683 === (6))){
var inst_2668 = (state_2682[(8)]);
var inst_2663 = (state_2682[(7)]);
var inst_2668__$1 = cljs.core.async.chan.call(null,(1));
var inst_2669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_2670 = [inst_2663,inst_2668__$1];
var inst_2671 = (new cljs.core.PersistentVector(null,2,(5),inst_2669,inst_2670,null));
var state_2682__$1 = (function (){var statearr_2689 = state_2682;
(statearr_2689[(8)] = inst_2668__$1);

return statearr_2689;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_2682__$1,(8),jobs,inst_2671);
} else {
if((state_val_2683 === (7))){
var inst_2678 = (state_2682[(2)]);
var state_2682__$1 = state_2682;
var statearr_2690_2797 = state_2682__$1;
(statearr_2690_2797[(2)] = inst_2678);

(statearr_2690_2797[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2683 === (8))){
var inst_2668 = (state_2682[(8)]);
var inst_2673 = (state_2682[(2)]);
var state_2682__$1 = (function (){var statearr_2691 = state_2682;
(statearr_2691[(9)] = inst_2673);

return statearr_2691;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_2682__$1,(9),results,inst_2668);
} else {
if((state_val_2683 === (9))){
var inst_2675 = (state_2682[(2)]);
var state_2682__$1 = (function (){var statearr_2692 = state_2682;
(statearr_2692[(10)] = inst_2675);

return statearr_2692;
})();
var statearr_2693_2798 = state_2682__$1;
(statearr_2693_2798[(2)] = null);

(statearr_2693_2798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___2792,jobs,results,process,async))
;
return ((function (switch__2334__auto__,c__2429__auto___2792,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0 = (function (){
var statearr_2694 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_2694[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__);

(statearr_2694[(1)] = (1));

return statearr_2694;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1 = (function (state_2682){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_2682);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e2695){if((e2695 instanceof Object)){
var ex__2338__auto__ = e2695;
var statearr_2696_2799 = state_2682;
(statearr_2696_2799[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2682);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e2695;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__2800 = state_2682;
state_2682 = G__2800;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__ = function(state_2682){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1.call(this,state_2682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___2792,jobs,results,process,async))
})();
var state__2431__auto__ = (function (){var statearr_2697 = f__2430__auto__.call(null);
(statearr_2697[(6)] = c__2429__auto___2792);

return statearr_2697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___2792,jobs,results,process,async))
);


var c__2429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto__,jobs,results,process,async){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto__,jobs,results,process,async){
return (function (state_2735){
var state_val_2736 = (state_2735[(1)]);
if((state_val_2736 === (7))){
var inst_2731 = (state_2735[(2)]);
var state_2735__$1 = state_2735;
var statearr_2737_2801 = state_2735__$1;
(statearr_2737_2801[(2)] = inst_2731);

(statearr_2737_2801[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (20))){
var state_2735__$1 = state_2735;
var statearr_2738_2802 = state_2735__$1;
(statearr_2738_2802[(2)] = null);

(statearr_2738_2802[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (1))){
var state_2735__$1 = state_2735;
var statearr_2739_2803 = state_2735__$1;
(statearr_2739_2803[(2)] = null);

(statearr_2739_2803[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (4))){
var inst_2700 = (state_2735[(7)]);
var inst_2700__$1 = (state_2735[(2)]);
var inst_2701 = (inst_2700__$1 == null);
var state_2735__$1 = (function (){var statearr_2740 = state_2735;
(statearr_2740[(7)] = inst_2700__$1);

return statearr_2740;
})();
if(cljs.core.truth_(inst_2701)){
var statearr_2741_2804 = state_2735__$1;
(statearr_2741_2804[(1)] = (5));

} else {
var statearr_2742_2805 = state_2735__$1;
(statearr_2742_2805[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (15))){
var inst_2713 = (state_2735[(8)]);
var state_2735__$1 = state_2735;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_2735__$1,(18),to,inst_2713);
} else {
if((state_val_2736 === (21))){
var inst_2726 = (state_2735[(2)]);
var state_2735__$1 = state_2735;
var statearr_2743_2806 = state_2735__$1;
(statearr_2743_2806[(2)] = inst_2726);

(statearr_2743_2806[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (13))){
var inst_2728 = (state_2735[(2)]);
var state_2735__$1 = (function (){var statearr_2744 = state_2735;
(statearr_2744[(9)] = inst_2728);

return statearr_2744;
})();
var statearr_2745_2807 = state_2735__$1;
(statearr_2745_2807[(2)] = null);

(statearr_2745_2807[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (6))){
var inst_2700 = (state_2735[(7)]);
var state_2735__$1 = state_2735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2735__$1,(11),inst_2700);
} else {
if((state_val_2736 === (17))){
var inst_2721 = (state_2735[(2)]);
var state_2735__$1 = state_2735;
if(cljs.core.truth_(inst_2721)){
var statearr_2746_2808 = state_2735__$1;
(statearr_2746_2808[(1)] = (19));

} else {
var statearr_2747_2809 = state_2735__$1;
(statearr_2747_2809[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (3))){
var inst_2733 = (state_2735[(2)]);
var state_2735__$1 = state_2735;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2735__$1,inst_2733);
} else {
if((state_val_2736 === (12))){
var inst_2710 = (state_2735[(10)]);
var state_2735__$1 = state_2735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2735__$1,(14),inst_2710);
} else {
if((state_val_2736 === (2))){
var state_2735__$1 = state_2735;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2735__$1,(4),results);
} else {
if((state_val_2736 === (19))){
var state_2735__$1 = state_2735;
var statearr_2748_2810 = state_2735__$1;
(statearr_2748_2810[(2)] = null);

(statearr_2748_2810[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (11))){
var inst_2710 = (state_2735[(2)]);
var state_2735__$1 = (function (){var statearr_2749 = state_2735;
(statearr_2749[(10)] = inst_2710);

return statearr_2749;
})();
var statearr_2750_2811 = state_2735__$1;
(statearr_2750_2811[(2)] = null);

(statearr_2750_2811[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (9))){
var state_2735__$1 = state_2735;
var statearr_2751_2812 = state_2735__$1;
(statearr_2751_2812[(2)] = null);

(statearr_2751_2812[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (5))){
var state_2735__$1 = state_2735;
if(cljs.core.truth_(close_QMARK_)){
var statearr_2752_2813 = state_2735__$1;
(statearr_2752_2813[(1)] = (8));

} else {
var statearr_2753_2814 = state_2735__$1;
(statearr_2753_2814[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (14))){
var inst_2715 = (state_2735[(11)]);
var inst_2713 = (state_2735[(8)]);
var inst_2713__$1 = (state_2735[(2)]);
var inst_2714 = (inst_2713__$1 == null);
var inst_2715__$1 = cljs.core.not.call(null,inst_2714);
var state_2735__$1 = (function (){var statearr_2754 = state_2735;
(statearr_2754[(11)] = inst_2715__$1);

(statearr_2754[(8)] = inst_2713__$1);

return statearr_2754;
})();
if(inst_2715__$1){
var statearr_2755_2815 = state_2735__$1;
(statearr_2755_2815[(1)] = (15));

} else {
var statearr_2756_2816 = state_2735__$1;
(statearr_2756_2816[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (16))){
var inst_2715 = (state_2735[(11)]);
var state_2735__$1 = state_2735;
var statearr_2757_2817 = state_2735__$1;
(statearr_2757_2817[(2)] = inst_2715);

(statearr_2757_2817[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (10))){
var inst_2707 = (state_2735[(2)]);
var state_2735__$1 = state_2735;
var statearr_2758_2818 = state_2735__$1;
(statearr_2758_2818[(2)] = inst_2707);

(statearr_2758_2818[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (18))){
var inst_2718 = (state_2735[(2)]);
var state_2735__$1 = state_2735;
var statearr_2759_2819 = state_2735__$1;
(statearr_2759_2819[(2)] = inst_2718);

(statearr_2759_2819[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2736 === (8))){
var inst_2704 = cljs.core.async.close_BANG_.call(null,to);
var state_2735__$1 = state_2735;
var statearr_2760_2820 = state_2735__$1;
(statearr_2760_2820[(2)] = inst_2704);

(statearr_2760_2820[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto__,jobs,results,process,async))
;
return ((function (switch__2334__auto__,c__2429__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0 = (function (){
var statearr_2761 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_2761[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__);

(statearr_2761[(1)] = (1));

return statearr_2761;
});
var cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1 = (function (state_2735){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_2735);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e2762){if((e2762 instanceof Object)){
var ex__2338__auto__ = e2762;
var statearr_2763_2821 = state_2735;
(statearr_2763_2821[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2735);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e2762;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__2822 = state_2735;
state_2735 = G__2822;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__ = function(state_2735){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1.call(this,state_2735);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__2335__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto__,jobs,results,process,async))
})();
var state__2431__auto__ = (function (){var statearr_2764 = f__2430__auto__.call(null);
(statearr_2764[(6)] = c__2429__auto__);

return statearr_2764;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto__,jobs,results,process,async))
);

return c__2429__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__2824 = arguments.length;
switch (G__2824) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__2827 = arguments.length;
switch (G__2827) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__2830 = arguments.length;
switch (G__2830) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__2429__auto___2879 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___2879,tc,fc){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___2879,tc,fc){
return (function (state_2856){
var state_val_2857 = (state_2856[(1)]);
if((state_val_2857 === (7))){
var inst_2852 = (state_2856[(2)]);
var state_2856__$1 = state_2856;
var statearr_2858_2880 = state_2856__$1;
(statearr_2858_2880[(2)] = inst_2852);

(statearr_2858_2880[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2857 === (1))){
var state_2856__$1 = state_2856;
var statearr_2859_2881 = state_2856__$1;
(statearr_2859_2881[(2)] = null);

(statearr_2859_2881[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2857 === (4))){
var inst_2833 = (state_2856[(7)]);
var inst_2833__$1 = (state_2856[(2)]);
var inst_2834 = (inst_2833__$1 == null);
var state_2856__$1 = (function (){var statearr_2860 = state_2856;
(statearr_2860[(7)] = inst_2833__$1);

return statearr_2860;
})();
if(cljs.core.truth_(inst_2834)){
var statearr_2861_2882 = state_2856__$1;
(statearr_2861_2882[(1)] = (5));

} else {
var statearr_2862_2883 = state_2856__$1;
(statearr_2862_2883[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2857 === (13))){
var state_2856__$1 = state_2856;
var statearr_2863_2884 = state_2856__$1;
(statearr_2863_2884[(2)] = null);

(statearr_2863_2884[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2857 === (6))){
var inst_2833 = (state_2856[(7)]);
var inst_2839 = p.call(null,inst_2833);
var state_2856__$1 = state_2856;
if(cljs.core.truth_(inst_2839)){
var statearr_2864_2885 = state_2856__$1;
(statearr_2864_2885[(1)] = (9));

} else {
var statearr_2865_2886 = state_2856__$1;
(statearr_2865_2886[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2857 === (3))){
var inst_2854 = (state_2856[(2)]);
var state_2856__$1 = state_2856;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2856__$1,inst_2854);
} else {
if((state_val_2857 === (12))){
var state_2856__$1 = state_2856;
var statearr_2866_2887 = state_2856__$1;
(statearr_2866_2887[(2)] = null);

(statearr_2866_2887[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2857 === (2))){
var state_2856__$1 = state_2856;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2856__$1,(4),ch);
} else {
if((state_val_2857 === (11))){
var inst_2833 = (state_2856[(7)]);
var inst_2843 = (state_2856[(2)]);
var state_2856__$1 = state_2856;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_2856__$1,(8),inst_2843,inst_2833);
} else {
if((state_val_2857 === (9))){
var state_2856__$1 = state_2856;
var statearr_2867_2888 = state_2856__$1;
(statearr_2867_2888[(2)] = tc);

(statearr_2867_2888[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2857 === (5))){
var inst_2836 = cljs.core.async.close_BANG_.call(null,tc);
var inst_2837 = cljs.core.async.close_BANG_.call(null,fc);
var state_2856__$1 = (function (){var statearr_2868 = state_2856;
(statearr_2868[(8)] = inst_2836);

return statearr_2868;
})();
var statearr_2869_2889 = state_2856__$1;
(statearr_2869_2889[(2)] = inst_2837);

(statearr_2869_2889[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2857 === (14))){
var inst_2850 = (state_2856[(2)]);
var state_2856__$1 = state_2856;
var statearr_2870_2890 = state_2856__$1;
(statearr_2870_2890[(2)] = inst_2850);

(statearr_2870_2890[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2857 === (10))){
var state_2856__$1 = state_2856;
var statearr_2871_2891 = state_2856__$1;
(statearr_2871_2891[(2)] = fc);

(statearr_2871_2891[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2857 === (8))){
var inst_2845 = (state_2856[(2)]);
var state_2856__$1 = state_2856;
if(cljs.core.truth_(inst_2845)){
var statearr_2872_2892 = state_2856__$1;
(statearr_2872_2892[(1)] = (12));

} else {
var statearr_2873_2893 = state_2856__$1;
(statearr_2873_2893[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___2879,tc,fc))
;
return ((function (switch__2334__auto__,c__2429__auto___2879,tc,fc){
return (function() {
var cljs$core$async$state_machine__2335__auto__ = null;
var cljs$core$async$state_machine__2335__auto____0 = (function (){
var statearr_2874 = [null,null,null,null,null,null,null,null,null];
(statearr_2874[(0)] = cljs$core$async$state_machine__2335__auto__);

(statearr_2874[(1)] = (1));

return statearr_2874;
});
var cljs$core$async$state_machine__2335__auto____1 = (function (state_2856){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_2856);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e2875){if((e2875 instanceof Object)){
var ex__2338__auto__ = e2875;
var statearr_2876_2894 = state_2856;
(statearr_2876_2894[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2856);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e2875;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__2895 = state_2856;
state_2856 = G__2895;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$state_machine__2335__auto__ = function(state_2856){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2335__auto____1.call(this,state_2856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2335__auto____0;
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2335__auto____1;
return cljs$core$async$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___2879,tc,fc))
})();
var state__2431__auto__ = (function (){var statearr_2877 = f__2430__auto__.call(null);
(statearr_2877[(6)] = c__2429__auto___2879);

return statearr_2877;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___2879,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__2429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto__){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto__){
return (function (state_2916){
var state_val_2917 = (state_2916[(1)]);
if((state_val_2917 === (7))){
var inst_2912 = (state_2916[(2)]);
var state_2916__$1 = state_2916;
var statearr_2918_2936 = state_2916__$1;
(statearr_2918_2936[(2)] = inst_2912);

(statearr_2918_2936[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2917 === (1))){
var inst_2896 = init;
var state_2916__$1 = (function (){var statearr_2919 = state_2916;
(statearr_2919[(7)] = inst_2896);

return statearr_2919;
})();
var statearr_2920_2937 = state_2916__$1;
(statearr_2920_2937[(2)] = null);

(statearr_2920_2937[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2917 === (4))){
var inst_2899 = (state_2916[(8)]);
var inst_2899__$1 = (state_2916[(2)]);
var inst_2900 = (inst_2899__$1 == null);
var state_2916__$1 = (function (){var statearr_2921 = state_2916;
(statearr_2921[(8)] = inst_2899__$1);

return statearr_2921;
})();
if(cljs.core.truth_(inst_2900)){
var statearr_2922_2938 = state_2916__$1;
(statearr_2922_2938[(1)] = (5));

} else {
var statearr_2923_2939 = state_2916__$1;
(statearr_2923_2939[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2917 === (6))){
var inst_2903 = (state_2916[(9)]);
var inst_2899 = (state_2916[(8)]);
var inst_2896 = (state_2916[(7)]);
var inst_2903__$1 = f.call(null,inst_2896,inst_2899);
var inst_2904 = cljs.core.reduced_QMARK_.call(null,inst_2903__$1);
var state_2916__$1 = (function (){var statearr_2924 = state_2916;
(statearr_2924[(9)] = inst_2903__$1);

return statearr_2924;
})();
if(inst_2904){
var statearr_2925_2940 = state_2916__$1;
(statearr_2925_2940[(1)] = (8));

} else {
var statearr_2926_2941 = state_2916__$1;
(statearr_2926_2941[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2917 === (3))){
var inst_2914 = (state_2916[(2)]);
var state_2916__$1 = state_2916;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2916__$1,inst_2914);
} else {
if((state_val_2917 === (2))){
var state_2916__$1 = state_2916;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2916__$1,(4),ch);
} else {
if((state_val_2917 === (9))){
var inst_2903 = (state_2916[(9)]);
var inst_2896 = inst_2903;
var state_2916__$1 = (function (){var statearr_2927 = state_2916;
(statearr_2927[(7)] = inst_2896);

return statearr_2927;
})();
var statearr_2928_2942 = state_2916__$1;
(statearr_2928_2942[(2)] = null);

(statearr_2928_2942[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2917 === (5))){
var inst_2896 = (state_2916[(7)]);
var state_2916__$1 = state_2916;
var statearr_2929_2943 = state_2916__$1;
(statearr_2929_2943[(2)] = inst_2896);

(statearr_2929_2943[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2917 === (10))){
var inst_2910 = (state_2916[(2)]);
var state_2916__$1 = state_2916;
var statearr_2930_2944 = state_2916__$1;
(statearr_2930_2944[(2)] = inst_2910);

(statearr_2930_2944[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2917 === (8))){
var inst_2903 = (state_2916[(9)]);
var inst_2906 = cljs.core.deref.call(null,inst_2903);
var state_2916__$1 = state_2916;
var statearr_2931_2945 = state_2916__$1;
(statearr_2931_2945[(2)] = inst_2906);

(statearr_2931_2945[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto__))
;
return ((function (switch__2334__auto__,c__2429__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__2335__auto__ = null;
var cljs$core$async$reduce_$_state_machine__2335__auto____0 = (function (){
var statearr_2932 = [null,null,null,null,null,null,null,null,null,null];
(statearr_2932[(0)] = cljs$core$async$reduce_$_state_machine__2335__auto__);

(statearr_2932[(1)] = (1));

return statearr_2932;
});
var cljs$core$async$reduce_$_state_machine__2335__auto____1 = (function (state_2916){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_2916);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e2933){if((e2933 instanceof Object)){
var ex__2338__auto__ = e2933;
var statearr_2934_2946 = state_2916;
(statearr_2934_2946[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2916);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e2933;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__2947 = state_2916;
state_2916 = G__2947;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__2335__auto__ = function(state_2916){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__2335__auto____1.call(this,state_2916);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__2335__auto____0;
cljs$core$async$reduce_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__2335__auto____1;
return cljs$core$async$reduce_$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto__))
})();
var state__2431__auto__ = (function (){var statearr_2935 = f__2430__auto__.call(null);
(statearr_2935[(6)] = c__2429__auto__);

return statearr_2935;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto__))
);

return c__2429__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__2429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto__,f__$1){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto__,f__$1){
return (function (state_2953){
var state_val_2954 = (state_2953[(1)]);
if((state_val_2954 === (1))){
var inst_2948 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_2953__$1 = state_2953;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_2953__$1,(2),inst_2948);
} else {
if((state_val_2954 === (2))){
var inst_2950 = (state_2953[(2)]);
var inst_2951 = f__$1.call(null,inst_2950);
var state_2953__$1 = state_2953;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2953__$1,inst_2951);
} else {
return null;
}
}
});})(c__2429__auto__,f__$1))
;
return ((function (switch__2334__auto__,c__2429__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__2335__auto__ = null;
var cljs$core$async$transduce_$_state_machine__2335__auto____0 = (function (){
var statearr_2955 = [null,null,null,null,null,null,null];
(statearr_2955[(0)] = cljs$core$async$transduce_$_state_machine__2335__auto__);

(statearr_2955[(1)] = (1));

return statearr_2955;
});
var cljs$core$async$transduce_$_state_machine__2335__auto____1 = (function (state_2953){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_2953);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e2956){if((e2956 instanceof Object)){
var ex__2338__auto__ = e2956;
var statearr_2957_2959 = state_2953;
(statearr_2957_2959[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2953);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e2956;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__2960 = state_2953;
state_2953 = G__2960;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__2335__auto__ = function(state_2953){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__2335__auto____1.call(this,state_2953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__2335__auto____0;
cljs$core$async$transduce_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__2335__auto____1;
return cljs$core$async$transduce_$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto__,f__$1))
})();
var state__2431__auto__ = (function (){var statearr_2958 = f__2430__auto__.call(null);
(statearr_2958[(6)] = c__2429__auto__);

return statearr_2958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto__,f__$1))
);

return c__2429__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__2962 = arguments.length;
switch (G__2962) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__2429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto__){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto__){
return (function (state_2987){
var state_val_2988 = (state_2987[(1)]);
if((state_val_2988 === (7))){
var inst_2969 = (state_2987[(2)]);
var state_2987__$1 = state_2987;
var statearr_2989_3010 = state_2987__$1;
(statearr_2989_3010[(2)] = inst_2969);

(statearr_2989_3010[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2988 === (1))){
var inst_2963 = cljs.core.seq.call(null,coll);
var inst_2964 = inst_2963;
var state_2987__$1 = (function (){var statearr_2990 = state_2987;
(statearr_2990[(7)] = inst_2964);

return statearr_2990;
})();
var statearr_2991_3011 = state_2987__$1;
(statearr_2991_3011[(2)] = null);

(statearr_2991_3011[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2988 === (4))){
var inst_2964 = (state_2987[(7)]);
var inst_2967 = cljs.core.first.call(null,inst_2964);
var state_2987__$1 = state_2987;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_2987__$1,(7),ch,inst_2967);
} else {
if((state_val_2988 === (13))){
var inst_2981 = (state_2987[(2)]);
var state_2987__$1 = state_2987;
var statearr_2992_3012 = state_2987__$1;
(statearr_2992_3012[(2)] = inst_2981);

(statearr_2992_3012[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2988 === (6))){
var inst_2972 = (state_2987[(2)]);
var state_2987__$1 = state_2987;
if(cljs.core.truth_(inst_2972)){
var statearr_2993_3013 = state_2987__$1;
(statearr_2993_3013[(1)] = (8));

} else {
var statearr_2994_3014 = state_2987__$1;
(statearr_2994_3014[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2988 === (3))){
var inst_2985 = (state_2987[(2)]);
var state_2987__$1 = state_2987;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_2987__$1,inst_2985);
} else {
if((state_val_2988 === (12))){
var state_2987__$1 = state_2987;
var statearr_2995_3015 = state_2987__$1;
(statearr_2995_3015[(2)] = null);

(statearr_2995_3015[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2988 === (2))){
var inst_2964 = (state_2987[(7)]);
var state_2987__$1 = state_2987;
if(cljs.core.truth_(inst_2964)){
var statearr_2996_3016 = state_2987__$1;
(statearr_2996_3016[(1)] = (4));

} else {
var statearr_2997_3017 = state_2987__$1;
(statearr_2997_3017[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2988 === (11))){
var inst_2978 = cljs.core.async.close_BANG_.call(null,ch);
var state_2987__$1 = state_2987;
var statearr_2998_3018 = state_2987__$1;
(statearr_2998_3018[(2)] = inst_2978);

(statearr_2998_3018[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2988 === (9))){
var state_2987__$1 = state_2987;
if(cljs.core.truth_(close_QMARK_)){
var statearr_2999_3019 = state_2987__$1;
(statearr_2999_3019[(1)] = (11));

} else {
var statearr_3000_3020 = state_2987__$1;
(statearr_3000_3020[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2988 === (5))){
var inst_2964 = (state_2987[(7)]);
var state_2987__$1 = state_2987;
var statearr_3001_3021 = state_2987__$1;
(statearr_3001_3021[(2)] = inst_2964);

(statearr_3001_3021[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2988 === (10))){
var inst_2983 = (state_2987[(2)]);
var state_2987__$1 = state_2987;
var statearr_3002_3022 = state_2987__$1;
(statearr_3002_3022[(2)] = inst_2983);

(statearr_3002_3022[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_2988 === (8))){
var inst_2964 = (state_2987[(7)]);
var inst_2974 = cljs.core.next.call(null,inst_2964);
var inst_2964__$1 = inst_2974;
var state_2987__$1 = (function (){var statearr_3003 = state_2987;
(statearr_3003[(7)] = inst_2964__$1);

return statearr_3003;
})();
var statearr_3004_3023 = state_2987__$1;
(statearr_3004_3023[(2)] = null);

(statearr_3004_3023[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto__))
;
return ((function (switch__2334__auto__,c__2429__auto__){
return (function() {
var cljs$core$async$state_machine__2335__auto__ = null;
var cljs$core$async$state_machine__2335__auto____0 = (function (){
var statearr_3005 = [null,null,null,null,null,null,null,null];
(statearr_3005[(0)] = cljs$core$async$state_machine__2335__auto__);

(statearr_3005[(1)] = (1));

return statearr_3005;
});
var cljs$core$async$state_machine__2335__auto____1 = (function (state_2987){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_2987);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e3006){if((e3006 instanceof Object)){
var ex__2338__auto__ = e3006;
var statearr_3007_3024 = state_2987;
(statearr_3007_3024[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_2987);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3006;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3025 = state_2987;
state_2987 = G__3025;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$state_machine__2335__auto__ = function(state_2987){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2335__auto____1.call(this,state_2987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2335__auto____0;
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2335__auto____1;
return cljs$core$async$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto__))
})();
var state__2431__auto__ = (function (){var statearr_3008 = f__2430__auto__.call(null);
(statearr_3008[(6)] = c__2429__auto__);

return statearr_3008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto__))
);

return c__2429__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__4433__auto__ = (((_ == null))?null:_);
var m__4434__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,_);
} else {
var m__4431__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3026 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3026 = (function (ch,cs,meta3027){
this.ch = ch;
this.cs = cs;
this.meta3027 = meta3027;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3026.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_3028,meta3027__$1){
var self__ = this;
var _3028__$1 = this;
return (new cljs.core.async.t_cljs$core$async3026(self__.ch,self__.cs,meta3027__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async3026.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_3028){
var self__ = this;
var _3028__$1 = this;
return self__.meta3027;
});})(cs))
;

cljs.core.async.t_cljs$core$async3026.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3026.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async3026.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3026.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async3026.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async3026.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async3026.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta3027","meta3027",-1069759621,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async3026.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3026.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3026";

cljs.core.async.t_cljs$core$async3026.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async3026");
});})(cs))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3026.
 */
cljs.core.async.__GT_t_cljs$core$async3026 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async3026(ch__$1,cs__$1,meta3027){
return (new cljs.core.async.t_cljs$core$async3026(ch__$1,cs__$1,meta3027));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async3026(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__2429__auto___3248 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___3248,cs,m,dchan,dctr,done){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___3248,cs,m,dchan,dctr,done){
return (function (state_3163){
var state_val_3164 = (state_3163[(1)]);
if((state_val_3164 === (7))){
var inst_3159 = (state_3163[(2)]);
var state_3163__$1 = state_3163;
var statearr_3165_3249 = state_3163__$1;
(statearr_3165_3249[(2)] = inst_3159);

(statearr_3165_3249[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (20))){
var inst_3062 = (state_3163[(7)]);
var inst_3074 = cljs.core.first.call(null,inst_3062);
var inst_3075 = cljs.core.nth.call(null,inst_3074,(0),null);
var inst_3076 = cljs.core.nth.call(null,inst_3074,(1),null);
var state_3163__$1 = (function (){var statearr_3166 = state_3163;
(statearr_3166[(8)] = inst_3075);

return statearr_3166;
})();
if(cljs.core.truth_(inst_3076)){
var statearr_3167_3250 = state_3163__$1;
(statearr_3167_3250[(1)] = (22));

} else {
var statearr_3168_3251 = state_3163__$1;
(statearr_3168_3251[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (27))){
var inst_3104 = (state_3163[(9)]);
var inst_3106 = (state_3163[(10)]);
var inst_3111 = (state_3163[(11)]);
var inst_3031 = (state_3163[(12)]);
var inst_3111__$1 = cljs.core._nth.call(null,inst_3104,inst_3106);
var inst_3112 = cljs.core.async.put_BANG_.call(null,inst_3111__$1,inst_3031,done);
var state_3163__$1 = (function (){var statearr_3169 = state_3163;
(statearr_3169[(11)] = inst_3111__$1);

return statearr_3169;
})();
if(cljs.core.truth_(inst_3112)){
var statearr_3170_3252 = state_3163__$1;
(statearr_3170_3252[(1)] = (30));

} else {
var statearr_3171_3253 = state_3163__$1;
(statearr_3171_3253[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (1))){
var state_3163__$1 = state_3163;
var statearr_3172_3254 = state_3163__$1;
(statearr_3172_3254[(2)] = null);

(statearr_3172_3254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (24))){
var inst_3062 = (state_3163[(7)]);
var inst_3081 = (state_3163[(2)]);
var inst_3082 = cljs.core.next.call(null,inst_3062);
var inst_3040 = inst_3082;
var inst_3041 = null;
var inst_3042 = (0);
var inst_3043 = (0);
var state_3163__$1 = (function (){var statearr_3173 = state_3163;
(statearr_3173[(13)] = inst_3081);

(statearr_3173[(14)] = inst_3043);

(statearr_3173[(15)] = inst_3042);

(statearr_3173[(16)] = inst_3041);

(statearr_3173[(17)] = inst_3040);

return statearr_3173;
})();
var statearr_3174_3255 = state_3163__$1;
(statearr_3174_3255[(2)] = null);

(statearr_3174_3255[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (39))){
var state_3163__$1 = state_3163;
var statearr_3178_3256 = state_3163__$1;
(statearr_3178_3256[(2)] = null);

(statearr_3178_3256[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (4))){
var inst_3031 = (state_3163[(12)]);
var inst_3031__$1 = (state_3163[(2)]);
var inst_3032 = (inst_3031__$1 == null);
var state_3163__$1 = (function (){var statearr_3179 = state_3163;
(statearr_3179[(12)] = inst_3031__$1);

return statearr_3179;
})();
if(cljs.core.truth_(inst_3032)){
var statearr_3180_3257 = state_3163__$1;
(statearr_3180_3257[(1)] = (5));

} else {
var statearr_3181_3258 = state_3163__$1;
(statearr_3181_3258[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (15))){
var inst_3043 = (state_3163[(14)]);
var inst_3042 = (state_3163[(15)]);
var inst_3041 = (state_3163[(16)]);
var inst_3040 = (state_3163[(17)]);
var inst_3058 = (state_3163[(2)]);
var inst_3059 = (inst_3043 + (1));
var tmp3175 = inst_3042;
var tmp3176 = inst_3041;
var tmp3177 = inst_3040;
var inst_3040__$1 = tmp3177;
var inst_3041__$1 = tmp3176;
var inst_3042__$1 = tmp3175;
var inst_3043__$1 = inst_3059;
var state_3163__$1 = (function (){var statearr_3182 = state_3163;
(statearr_3182[(14)] = inst_3043__$1);

(statearr_3182[(15)] = inst_3042__$1);

(statearr_3182[(18)] = inst_3058);

(statearr_3182[(16)] = inst_3041__$1);

(statearr_3182[(17)] = inst_3040__$1);

return statearr_3182;
})();
var statearr_3183_3259 = state_3163__$1;
(statearr_3183_3259[(2)] = null);

(statearr_3183_3259[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (21))){
var inst_3085 = (state_3163[(2)]);
var state_3163__$1 = state_3163;
var statearr_3187_3260 = state_3163__$1;
(statearr_3187_3260[(2)] = inst_3085);

(statearr_3187_3260[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (31))){
var inst_3111 = (state_3163[(11)]);
var inst_3115 = done.call(null,null);
var inst_3116 = cljs.core.async.untap_STAR_.call(null,m,inst_3111);
var state_3163__$1 = (function (){var statearr_3188 = state_3163;
(statearr_3188[(19)] = inst_3115);

return statearr_3188;
})();
var statearr_3189_3261 = state_3163__$1;
(statearr_3189_3261[(2)] = inst_3116);

(statearr_3189_3261[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (32))){
var inst_3103 = (state_3163[(20)]);
var inst_3105 = (state_3163[(21)]);
var inst_3104 = (state_3163[(9)]);
var inst_3106 = (state_3163[(10)]);
var inst_3118 = (state_3163[(2)]);
var inst_3119 = (inst_3106 + (1));
var tmp3184 = inst_3103;
var tmp3185 = inst_3105;
var tmp3186 = inst_3104;
var inst_3103__$1 = tmp3184;
var inst_3104__$1 = tmp3186;
var inst_3105__$1 = tmp3185;
var inst_3106__$1 = inst_3119;
var state_3163__$1 = (function (){var statearr_3190 = state_3163;
(statearr_3190[(20)] = inst_3103__$1);

(statearr_3190[(21)] = inst_3105__$1);

(statearr_3190[(9)] = inst_3104__$1);

(statearr_3190[(10)] = inst_3106__$1);

(statearr_3190[(22)] = inst_3118);

return statearr_3190;
})();
var statearr_3191_3262 = state_3163__$1;
(statearr_3191_3262[(2)] = null);

(statearr_3191_3262[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (40))){
var inst_3131 = (state_3163[(23)]);
var inst_3135 = done.call(null,null);
var inst_3136 = cljs.core.async.untap_STAR_.call(null,m,inst_3131);
var state_3163__$1 = (function (){var statearr_3192 = state_3163;
(statearr_3192[(24)] = inst_3135);

return statearr_3192;
})();
var statearr_3193_3263 = state_3163__$1;
(statearr_3193_3263[(2)] = inst_3136);

(statearr_3193_3263[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (33))){
var inst_3122 = (state_3163[(25)]);
var inst_3124 = cljs.core.chunked_seq_QMARK_.call(null,inst_3122);
var state_3163__$1 = state_3163;
if(inst_3124){
var statearr_3194_3264 = state_3163__$1;
(statearr_3194_3264[(1)] = (36));

} else {
var statearr_3195_3265 = state_3163__$1;
(statearr_3195_3265[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (13))){
var inst_3052 = (state_3163[(26)]);
var inst_3055 = cljs.core.async.close_BANG_.call(null,inst_3052);
var state_3163__$1 = state_3163;
var statearr_3196_3266 = state_3163__$1;
(statearr_3196_3266[(2)] = inst_3055);

(statearr_3196_3266[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (22))){
var inst_3075 = (state_3163[(8)]);
var inst_3078 = cljs.core.async.close_BANG_.call(null,inst_3075);
var state_3163__$1 = state_3163;
var statearr_3197_3267 = state_3163__$1;
(statearr_3197_3267[(2)] = inst_3078);

(statearr_3197_3267[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (36))){
var inst_3122 = (state_3163[(25)]);
var inst_3126 = cljs.core.chunk_first.call(null,inst_3122);
var inst_3127 = cljs.core.chunk_rest.call(null,inst_3122);
var inst_3128 = cljs.core.count.call(null,inst_3126);
var inst_3103 = inst_3127;
var inst_3104 = inst_3126;
var inst_3105 = inst_3128;
var inst_3106 = (0);
var state_3163__$1 = (function (){var statearr_3198 = state_3163;
(statearr_3198[(20)] = inst_3103);

(statearr_3198[(21)] = inst_3105);

(statearr_3198[(9)] = inst_3104);

(statearr_3198[(10)] = inst_3106);

return statearr_3198;
})();
var statearr_3199_3268 = state_3163__$1;
(statearr_3199_3268[(2)] = null);

(statearr_3199_3268[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (41))){
var inst_3122 = (state_3163[(25)]);
var inst_3138 = (state_3163[(2)]);
var inst_3139 = cljs.core.next.call(null,inst_3122);
var inst_3103 = inst_3139;
var inst_3104 = null;
var inst_3105 = (0);
var inst_3106 = (0);
var state_3163__$1 = (function (){var statearr_3200 = state_3163;
(statearr_3200[(20)] = inst_3103);

(statearr_3200[(21)] = inst_3105);

(statearr_3200[(27)] = inst_3138);

(statearr_3200[(9)] = inst_3104);

(statearr_3200[(10)] = inst_3106);

return statearr_3200;
})();
var statearr_3201_3269 = state_3163__$1;
(statearr_3201_3269[(2)] = null);

(statearr_3201_3269[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (43))){
var state_3163__$1 = state_3163;
var statearr_3202_3270 = state_3163__$1;
(statearr_3202_3270[(2)] = null);

(statearr_3202_3270[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (29))){
var inst_3147 = (state_3163[(2)]);
var state_3163__$1 = state_3163;
var statearr_3203_3271 = state_3163__$1;
(statearr_3203_3271[(2)] = inst_3147);

(statearr_3203_3271[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (44))){
var inst_3156 = (state_3163[(2)]);
var state_3163__$1 = (function (){var statearr_3204 = state_3163;
(statearr_3204[(28)] = inst_3156);

return statearr_3204;
})();
var statearr_3205_3272 = state_3163__$1;
(statearr_3205_3272[(2)] = null);

(statearr_3205_3272[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (6))){
var inst_3095 = (state_3163[(29)]);
var inst_3094 = cljs.core.deref.call(null,cs);
var inst_3095__$1 = cljs.core.keys.call(null,inst_3094);
var inst_3096 = cljs.core.count.call(null,inst_3095__$1);
var inst_3097 = cljs.core.reset_BANG_.call(null,dctr,inst_3096);
var inst_3102 = cljs.core.seq.call(null,inst_3095__$1);
var inst_3103 = inst_3102;
var inst_3104 = null;
var inst_3105 = (0);
var inst_3106 = (0);
var state_3163__$1 = (function (){var statearr_3206 = state_3163;
(statearr_3206[(20)] = inst_3103);

(statearr_3206[(21)] = inst_3105);

(statearr_3206[(9)] = inst_3104);

(statearr_3206[(29)] = inst_3095__$1);

(statearr_3206[(10)] = inst_3106);

(statearr_3206[(30)] = inst_3097);

return statearr_3206;
})();
var statearr_3207_3273 = state_3163__$1;
(statearr_3207_3273[(2)] = null);

(statearr_3207_3273[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (28))){
var inst_3103 = (state_3163[(20)]);
var inst_3122 = (state_3163[(25)]);
var inst_3122__$1 = cljs.core.seq.call(null,inst_3103);
var state_3163__$1 = (function (){var statearr_3208 = state_3163;
(statearr_3208[(25)] = inst_3122__$1);

return statearr_3208;
})();
if(inst_3122__$1){
var statearr_3209_3274 = state_3163__$1;
(statearr_3209_3274[(1)] = (33));

} else {
var statearr_3210_3275 = state_3163__$1;
(statearr_3210_3275[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (25))){
var inst_3105 = (state_3163[(21)]);
var inst_3106 = (state_3163[(10)]);
var inst_3108 = (inst_3106 < inst_3105);
var inst_3109 = inst_3108;
var state_3163__$1 = state_3163;
if(cljs.core.truth_(inst_3109)){
var statearr_3211_3276 = state_3163__$1;
(statearr_3211_3276[(1)] = (27));

} else {
var statearr_3212_3277 = state_3163__$1;
(statearr_3212_3277[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (34))){
var state_3163__$1 = state_3163;
var statearr_3213_3278 = state_3163__$1;
(statearr_3213_3278[(2)] = null);

(statearr_3213_3278[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (17))){
var state_3163__$1 = state_3163;
var statearr_3214_3279 = state_3163__$1;
(statearr_3214_3279[(2)] = null);

(statearr_3214_3279[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (3))){
var inst_3161 = (state_3163[(2)]);
var state_3163__$1 = state_3163;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3163__$1,inst_3161);
} else {
if((state_val_3164 === (12))){
var inst_3090 = (state_3163[(2)]);
var state_3163__$1 = state_3163;
var statearr_3215_3280 = state_3163__$1;
(statearr_3215_3280[(2)] = inst_3090);

(statearr_3215_3280[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (2))){
var state_3163__$1 = state_3163;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3163__$1,(4),ch);
} else {
if((state_val_3164 === (23))){
var state_3163__$1 = state_3163;
var statearr_3216_3281 = state_3163__$1;
(statearr_3216_3281[(2)] = null);

(statearr_3216_3281[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (35))){
var inst_3145 = (state_3163[(2)]);
var state_3163__$1 = state_3163;
var statearr_3217_3282 = state_3163__$1;
(statearr_3217_3282[(2)] = inst_3145);

(statearr_3217_3282[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (19))){
var inst_3062 = (state_3163[(7)]);
var inst_3066 = cljs.core.chunk_first.call(null,inst_3062);
var inst_3067 = cljs.core.chunk_rest.call(null,inst_3062);
var inst_3068 = cljs.core.count.call(null,inst_3066);
var inst_3040 = inst_3067;
var inst_3041 = inst_3066;
var inst_3042 = inst_3068;
var inst_3043 = (0);
var state_3163__$1 = (function (){var statearr_3218 = state_3163;
(statearr_3218[(14)] = inst_3043);

(statearr_3218[(15)] = inst_3042);

(statearr_3218[(16)] = inst_3041);

(statearr_3218[(17)] = inst_3040);

return statearr_3218;
})();
var statearr_3219_3283 = state_3163__$1;
(statearr_3219_3283[(2)] = null);

(statearr_3219_3283[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (11))){
var inst_3040 = (state_3163[(17)]);
var inst_3062 = (state_3163[(7)]);
var inst_3062__$1 = cljs.core.seq.call(null,inst_3040);
var state_3163__$1 = (function (){var statearr_3220 = state_3163;
(statearr_3220[(7)] = inst_3062__$1);

return statearr_3220;
})();
if(inst_3062__$1){
var statearr_3221_3284 = state_3163__$1;
(statearr_3221_3284[(1)] = (16));

} else {
var statearr_3222_3285 = state_3163__$1;
(statearr_3222_3285[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (9))){
var inst_3092 = (state_3163[(2)]);
var state_3163__$1 = state_3163;
var statearr_3223_3286 = state_3163__$1;
(statearr_3223_3286[(2)] = inst_3092);

(statearr_3223_3286[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (5))){
var inst_3038 = cljs.core.deref.call(null,cs);
var inst_3039 = cljs.core.seq.call(null,inst_3038);
var inst_3040 = inst_3039;
var inst_3041 = null;
var inst_3042 = (0);
var inst_3043 = (0);
var state_3163__$1 = (function (){var statearr_3224 = state_3163;
(statearr_3224[(14)] = inst_3043);

(statearr_3224[(15)] = inst_3042);

(statearr_3224[(16)] = inst_3041);

(statearr_3224[(17)] = inst_3040);

return statearr_3224;
})();
var statearr_3225_3287 = state_3163__$1;
(statearr_3225_3287[(2)] = null);

(statearr_3225_3287[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (14))){
var state_3163__$1 = state_3163;
var statearr_3226_3288 = state_3163__$1;
(statearr_3226_3288[(2)] = null);

(statearr_3226_3288[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (45))){
var inst_3153 = (state_3163[(2)]);
var state_3163__$1 = state_3163;
var statearr_3227_3289 = state_3163__$1;
(statearr_3227_3289[(2)] = inst_3153);

(statearr_3227_3289[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (26))){
var inst_3095 = (state_3163[(29)]);
var inst_3149 = (state_3163[(2)]);
var inst_3150 = cljs.core.seq.call(null,inst_3095);
var state_3163__$1 = (function (){var statearr_3228 = state_3163;
(statearr_3228[(31)] = inst_3149);

return statearr_3228;
})();
if(inst_3150){
var statearr_3229_3290 = state_3163__$1;
(statearr_3229_3290[(1)] = (42));

} else {
var statearr_3230_3291 = state_3163__$1;
(statearr_3230_3291[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (16))){
var inst_3062 = (state_3163[(7)]);
var inst_3064 = cljs.core.chunked_seq_QMARK_.call(null,inst_3062);
var state_3163__$1 = state_3163;
if(inst_3064){
var statearr_3231_3292 = state_3163__$1;
(statearr_3231_3292[(1)] = (19));

} else {
var statearr_3232_3293 = state_3163__$1;
(statearr_3232_3293[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (38))){
var inst_3142 = (state_3163[(2)]);
var state_3163__$1 = state_3163;
var statearr_3233_3294 = state_3163__$1;
(statearr_3233_3294[(2)] = inst_3142);

(statearr_3233_3294[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (30))){
var state_3163__$1 = state_3163;
var statearr_3234_3295 = state_3163__$1;
(statearr_3234_3295[(2)] = null);

(statearr_3234_3295[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (10))){
var inst_3043 = (state_3163[(14)]);
var inst_3041 = (state_3163[(16)]);
var inst_3051 = cljs.core._nth.call(null,inst_3041,inst_3043);
var inst_3052 = cljs.core.nth.call(null,inst_3051,(0),null);
var inst_3053 = cljs.core.nth.call(null,inst_3051,(1),null);
var state_3163__$1 = (function (){var statearr_3235 = state_3163;
(statearr_3235[(26)] = inst_3052);

return statearr_3235;
})();
if(cljs.core.truth_(inst_3053)){
var statearr_3236_3296 = state_3163__$1;
(statearr_3236_3296[(1)] = (13));

} else {
var statearr_3237_3297 = state_3163__$1;
(statearr_3237_3297[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (18))){
var inst_3088 = (state_3163[(2)]);
var state_3163__$1 = state_3163;
var statearr_3238_3298 = state_3163__$1;
(statearr_3238_3298[(2)] = inst_3088);

(statearr_3238_3298[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (42))){
var state_3163__$1 = state_3163;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3163__$1,(45),dchan);
} else {
if((state_val_3164 === (37))){
var inst_3122 = (state_3163[(25)]);
var inst_3131 = (state_3163[(23)]);
var inst_3031 = (state_3163[(12)]);
var inst_3131__$1 = cljs.core.first.call(null,inst_3122);
var inst_3132 = cljs.core.async.put_BANG_.call(null,inst_3131__$1,inst_3031,done);
var state_3163__$1 = (function (){var statearr_3239 = state_3163;
(statearr_3239[(23)] = inst_3131__$1);

return statearr_3239;
})();
if(cljs.core.truth_(inst_3132)){
var statearr_3240_3299 = state_3163__$1;
(statearr_3240_3299[(1)] = (39));

} else {
var statearr_3241_3300 = state_3163__$1;
(statearr_3241_3300[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3164 === (8))){
var inst_3043 = (state_3163[(14)]);
var inst_3042 = (state_3163[(15)]);
var inst_3045 = (inst_3043 < inst_3042);
var inst_3046 = inst_3045;
var state_3163__$1 = state_3163;
if(cljs.core.truth_(inst_3046)){
var statearr_3242_3301 = state_3163__$1;
(statearr_3242_3301[(1)] = (10));

} else {
var statearr_3243_3302 = state_3163__$1;
(statearr_3243_3302[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___3248,cs,m,dchan,dctr,done))
;
return ((function (switch__2334__auto__,c__2429__auto___3248,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__2335__auto__ = null;
var cljs$core$async$mult_$_state_machine__2335__auto____0 = (function (){
var statearr_3244 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_3244[(0)] = cljs$core$async$mult_$_state_machine__2335__auto__);

(statearr_3244[(1)] = (1));

return statearr_3244;
});
var cljs$core$async$mult_$_state_machine__2335__auto____1 = (function (state_3163){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_3163);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e3245){if((e3245 instanceof Object)){
var ex__2338__auto__ = e3245;
var statearr_3246_3303 = state_3163;
(statearr_3246_3303[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3163);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3245;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3304 = state_3163;
state_3163 = G__3304;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__2335__auto__ = function(state_3163){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__2335__auto____1.call(this,state_3163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__2335__auto____0;
cljs$core$async$mult_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__2335__auto____1;
return cljs$core$async$mult_$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___3248,cs,m,dchan,dctr,done))
})();
var state__2431__auto__ = (function (){var statearr_3247 = f__2430__auto__.call(null);
(statearr_3247[(6)] = c__2429__auto___3248);

return statearr_3247;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___3248,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__3306 = arguments.length;
switch (G__3306) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m);
} else {
var m__4431__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,state_map);
} else {
var m__4431__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__4433__auto__ = (((m == null))?null:m);
var m__4434__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,m,mode);
} else {
var m__4431__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4736__auto__ = [];
var len__4730__auto___3318 = arguments.length;
var i__4731__auto___3319 = (0);
while(true){
if((i__4731__auto___3319 < len__4730__auto___3318)){
args__4736__auto__.push((arguments[i__4731__auto___3319]));

var G__3320 = (i__4731__auto___3319 + (1));
i__4731__auto___3319 = G__3320;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((3) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4737__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__3312){
var map__3313 = p__3312;
var map__3313__$1 = (((((!((map__3313 == null))))?(((((map__3313.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__3313.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__3313):map__3313);
var opts = map__3313__$1;
var statearr_3315_3321 = state;
(statearr_3315_3321[(1)] = cont_block);


var temp__5457__auto__ = cljs.core.async.do_alts.call(null,((function (map__3313,map__3313__$1,opts){
return (function (val){
var statearr_3316_3322 = state;
(statearr_3316_3322[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__3313,map__3313__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__5457__auto__)){
var cb = temp__5457__auto__;
var statearr_3317_3323 = state;
(statearr_3317_3323[(2)] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

/** @this {Function} */
cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq3308){
var G__3309 = cljs.core.first.call(null,seq3308);
var seq3308__$1 = cljs.core.next.call(null,seq3308);
var G__3310 = cljs.core.first.call(null,seq3308__$1);
var seq3308__$2 = cljs.core.next.call(null,seq3308__$1);
var G__3311 = cljs.core.first.call(null,seq3308__$2);
var seq3308__$3 = cljs.core.next.call(null,seq3308__$2);
var self__4717__auto__ = this;
return self__4717__auto__.cljs$core$IFn$_invoke$arity$variadic(G__3309,G__3310,G__3311,seq3308__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,((((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && ((!(cljs.core.empty_QMARK_.call(null,solos))))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3324 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3324 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta3325){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta3325 = meta3325;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3324.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_3326,meta3325__$1){
var self__ = this;
var _3326__$1 = this;
return (new cljs.core.async.t_cljs$core$async3324(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta3325__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3324.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_3326){
var self__ = this;
var _3326__$1 = this;
return self__.meta3325;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3324.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3324.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3324.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3324.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3324.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3324.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3324.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3324.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3324.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta3325","meta3325",-36320298,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async3324.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3324.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3324";

cljs.core.async.t_cljs$core$async3324.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async3324");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3324.
 */
cljs.core.async.__GT_t_cljs$core$async3324 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async3324(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta3325){
return (new cljs.core.async.t_cljs$core$async3324(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta3325));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async3324(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__2429__auto___3488 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___3488,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___3488,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_3428){
var state_val_3429 = (state_3428[(1)]);
if((state_val_3429 === (7))){
var inst_3343 = (state_3428[(2)]);
var state_3428__$1 = state_3428;
var statearr_3430_3489 = state_3428__$1;
(statearr_3430_3489[(2)] = inst_3343);

(statearr_3430_3489[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (20))){
var inst_3355 = (state_3428[(7)]);
var state_3428__$1 = state_3428;
var statearr_3431_3490 = state_3428__$1;
(statearr_3431_3490[(2)] = inst_3355);

(statearr_3431_3490[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (27))){
var state_3428__$1 = state_3428;
var statearr_3432_3491 = state_3428__$1;
(statearr_3432_3491[(2)] = null);

(statearr_3432_3491[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (1))){
var inst_3330 = (state_3428[(8)]);
var inst_3330__$1 = calc_state.call(null);
var inst_3332 = (inst_3330__$1 == null);
var inst_3333 = cljs.core.not.call(null,inst_3332);
var state_3428__$1 = (function (){var statearr_3433 = state_3428;
(statearr_3433[(8)] = inst_3330__$1);

return statearr_3433;
})();
if(inst_3333){
var statearr_3434_3492 = state_3428__$1;
(statearr_3434_3492[(1)] = (2));

} else {
var statearr_3435_3493 = state_3428__$1;
(statearr_3435_3493[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (24))){
var inst_3402 = (state_3428[(9)]);
var inst_3388 = (state_3428[(10)]);
var inst_3379 = (state_3428[(11)]);
var inst_3402__$1 = inst_3379.call(null,inst_3388);
var state_3428__$1 = (function (){var statearr_3436 = state_3428;
(statearr_3436[(9)] = inst_3402__$1);

return statearr_3436;
})();
if(cljs.core.truth_(inst_3402__$1)){
var statearr_3437_3494 = state_3428__$1;
(statearr_3437_3494[(1)] = (29));

} else {
var statearr_3438_3495 = state_3428__$1;
(statearr_3438_3495[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (4))){
var inst_3346 = (state_3428[(2)]);
var state_3428__$1 = state_3428;
if(cljs.core.truth_(inst_3346)){
var statearr_3439_3496 = state_3428__$1;
(statearr_3439_3496[(1)] = (8));

} else {
var statearr_3440_3497 = state_3428__$1;
(statearr_3440_3497[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (15))){
var inst_3373 = (state_3428[(2)]);
var state_3428__$1 = state_3428;
if(cljs.core.truth_(inst_3373)){
var statearr_3441_3498 = state_3428__$1;
(statearr_3441_3498[(1)] = (19));

} else {
var statearr_3442_3499 = state_3428__$1;
(statearr_3442_3499[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (21))){
var inst_3378 = (state_3428[(12)]);
var inst_3378__$1 = (state_3428[(2)]);
var inst_3379 = cljs.core.get.call(null,inst_3378__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_3380 = cljs.core.get.call(null,inst_3378__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_3381 = cljs.core.get.call(null,inst_3378__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_3428__$1 = (function (){var statearr_3443 = state_3428;
(statearr_3443[(12)] = inst_3378__$1);

(statearr_3443[(13)] = inst_3380);

(statearr_3443[(11)] = inst_3379);

return statearr_3443;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_3428__$1,(22),inst_3381);
} else {
if((state_val_3429 === (31))){
var inst_3410 = (state_3428[(2)]);
var state_3428__$1 = state_3428;
if(cljs.core.truth_(inst_3410)){
var statearr_3444_3500 = state_3428__$1;
(statearr_3444_3500[(1)] = (32));

} else {
var statearr_3445_3501 = state_3428__$1;
(statearr_3445_3501[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (32))){
var inst_3387 = (state_3428[(14)]);
var state_3428__$1 = state_3428;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3428__$1,(35),out,inst_3387);
} else {
if((state_val_3429 === (33))){
var inst_3378 = (state_3428[(12)]);
var inst_3355 = inst_3378;
var state_3428__$1 = (function (){var statearr_3446 = state_3428;
(statearr_3446[(7)] = inst_3355);

return statearr_3446;
})();
var statearr_3447_3502 = state_3428__$1;
(statearr_3447_3502[(2)] = null);

(statearr_3447_3502[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (13))){
var inst_3355 = (state_3428[(7)]);
var inst_3362 = inst_3355.cljs$lang$protocol_mask$partition0$;
var inst_3363 = (inst_3362 & (64));
var inst_3364 = inst_3355.cljs$core$ISeq$;
var inst_3365 = (cljs.core.PROTOCOL_SENTINEL === inst_3364);
var inst_3366 = ((inst_3363) || (inst_3365));
var state_3428__$1 = state_3428;
if(cljs.core.truth_(inst_3366)){
var statearr_3448_3503 = state_3428__$1;
(statearr_3448_3503[(1)] = (16));

} else {
var statearr_3449_3504 = state_3428__$1;
(statearr_3449_3504[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (22))){
var inst_3388 = (state_3428[(10)]);
var inst_3387 = (state_3428[(14)]);
var inst_3386 = (state_3428[(2)]);
var inst_3387__$1 = cljs.core.nth.call(null,inst_3386,(0),null);
var inst_3388__$1 = cljs.core.nth.call(null,inst_3386,(1),null);
var inst_3389 = (inst_3387__$1 == null);
var inst_3390 = cljs.core._EQ_.call(null,inst_3388__$1,change);
var inst_3391 = ((inst_3389) || (inst_3390));
var state_3428__$1 = (function (){var statearr_3450 = state_3428;
(statearr_3450[(10)] = inst_3388__$1);

(statearr_3450[(14)] = inst_3387__$1);

return statearr_3450;
})();
if(cljs.core.truth_(inst_3391)){
var statearr_3451_3505 = state_3428__$1;
(statearr_3451_3505[(1)] = (23));

} else {
var statearr_3452_3506 = state_3428__$1;
(statearr_3452_3506[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (36))){
var inst_3378 = (state_3428[(12)]);
var inst_3355 = inst_3378;
var state_3428__$1 = (function (){var statearr_3453 = state_3428;
(statearr_3453[(7)] = inst_3355);

return statearr_3453;
})();
var statearr_3454_3507 = state_3428__$1;
(statearr_3454_3507[(2)] = null);

(statearr_3454_3507[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (29))){
var inst_3402 = (state_3428[(9)]);
var state_3428__$1 = state_3428;
var statearr_3455_3508 = state_3428__$1;
(statearr_3455_3508[(2)] = inst_3402);

(statearr_3455_3508[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (6))){
var state_3428__$1 = state_3428;
var statearr_3456_3509 = state_3428__$1;
(statearr_3456_3509[(2)] = false);

(statearr_3456_3509[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (28))){
var inst_3398 = (state_3428[(2)]);
var inst_3399 = calc_state.call(null);
var inst_3355 = inst_3399;
var state_3428__$1 = (function (){var statearr_3457 = state_3428;
(statearr_3457[(7)] = inst_3355);

(statearr_3457[(15)] = inst_3398);

return statearr_3457;
})();
var statearr_3458_3510 = state_3428__$1;
(statearr_3458_3510[(2)] = null);

(statearr_3458_3510[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (25))){
var inst_3424 = (state_3428[(2)]);
var state_3428__$1 = state_3428;
var statearr_3459_3511 = state_3428__$1;
(statearr_3459_3511[(2)] = inst_3424);

(statearr_3459_3511[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (34))){
var inst_3422 = (state_3428[(2)]);
var state_3428__$1 = state_3428;
var statearr_3460_3512 = state_3428__$1;
(statearr_3460_3512[(2)] = inst_3422);

(statearr_3460_3512[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (17))){
var state_3428__$1 = state_3428;
var statearr_3461_3513 = state_3428__$1;
(statearr_3461_3513[(2)] = false);

(statearr_3461_3513[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (3))){
var state_3428__$1 = state_3428;
var statearr_3462_3514 = state_3428__$1;
(statearr_3462_3514[(2)] = false);

(statearr_3462_3514[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (12))){
var inst_3426 = (state_3428[(2)]);
var state_3428__$1 = state_3428;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3428__$1,inst_3426);
} else {
if((state_val_3429 === (2))){
var inst_3330 = (state_3428[(8)]);
var inst_3335 = inst_3330.cljs$lang$protocol_mask$partition0$;
var inst_3336 = (inst_3335 & (64));
var inst_3337 = inst_3330.cljs$core$ISeq$;
var inst_3338 = (cljs.core.PROTOCOL_SENTINEL === inst_3337);
var inst_3339 = ((inst_3336) || (inst_3338));
var state_3428__$1 = state_3428;
if(cljs.core.truth_(inst_3339)){
var statearr_3463_3515 = state_3428__$1;
(statearr_3463_3515[(1)] = (5));

} else {
var statearr_3464_3516 = state_3428__$1;
(statearr_3464_3516[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (23))){
var inst_3387 = (state_3428[(14)]);
var inst_3393 = (inst_3387 == null);
var state_3428__$1 = state_3428;
if(cljs.core.truth_(inst_3393)){
var statearr_3465_3517 = state_3428__$1;
(statearr_3465_3517[(1)] = (26));

} else {
var statearr_3466_3518 = state_3428__$1;
(statearr_3466_3518[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (35))){
var inst_3413 = (state_3428[(2)]);
var state_3428__$1 = state_3428;
if(cljs.core.truth_(inst_3413)){
var statearr_3467_3519 = state_3428__$1;
(statearr_3467_3519[(1)] = (36));

} else {
var statearr_3468_3520 = state_3428__$1;
(statearr_3468_3520[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (19))){
var inst_3355 = (state_3428[(7)]);
var inst_3375 = cljs.core.apply.call(null,cljs.core.hash_map,inst_3355);
var state_3428__$1 = state_3428;
var statearr_3469_3521 = state_3428__$1;
(statearr_3469_3521[(2)] = inst_3375);

(statearr_3469_3521[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (11))){
var inst_3355 = (state_3428[(7)]);
var inst_3359 = (inst_3355 == null);
var inst_3360 = cljs.core.not.call(null,inst_3359);
var state_3428__$1 = state_3428;
if(inst_3360){
var statearr_3470_3522 = state_3428__$1;
(statearr_3470_3522[(1)] = (13));

} else {
var statearr_3471_3523 = state_3428__$1;
(statearr_3471_3523[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (9))){
var inst_3330 = (state_3428[(8)]);
var state_3428__$1 = state_3428;
var statearr_3472_3524 = state_3428__$1;
(statearr_3472_3524[(2)] = inst_3330);

(statearr_3472_3524[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (5))){
var state_3428__$1 = state_3428;
var statearr_3473_3525 = state_3428__$1;
(statearr_3473_3525[(2)] = true);

(statearr_3473_3525[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (14))){
var state_3428__$1 = state_3428;
var statearr_3474_3526 = state_3428__$1;
(statearr_3474_3526[(2)] = false);

(statearr_3474_3526[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (26))){
var inst_3388 = (state_3428[(10)]);
var inst_3395 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_3388);
var state_3428__$1 = state_3428;
var statearr_3475_3527 = state_3428__$1;
(statearr_3475_3527[(2)] = inst_3395);

(statearr_3475_3527[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (16))){
var state_3428__$1 = state_3428;
var statearr_3476_3528 = state_3428__$1;
(statearr_3476_3528[(2)] = true);

(statearr_3476_3528[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (38))){
var inst_3418 = (state_3428[(2)]);
var state_3428__$1 = state_3428;
var statearr_3477_3529 = state_3428__$1;
(statearr_3477_3529[(2)] = inst_3418);

(statearr_3477_3529[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (30))){
var inst_3388 = (state_3428[(10)]);
var inst_3380 = (state_3428[(13)]);
var inst_3379 = (state_3428[(11)]);
var inst_3405 = cljs.core.empty_QMARK_.call(null,inst_3379);
var inst_3406 = inst_3380.call(null,inst_3388);
var inst_3407 = cljs.core.not.call(null,inst_3406);
var inst_3408 = ((inst_3405) && (inst_3407));
var state_3428__$1 = state_3428;
var statearr_3478_3530 = state_3428__$1;
(statearr_3478_3530[(2)] = inst_3408);

(statearr_3478_3530[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (10))){
var inst_3330 = (state_3428[(8)]);
var inst_3351 = (state_3428[(2)]);
var inst_3352 = cljs.core.get.call(null,inst_3351,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_3353 = cljs.core.get.call(null,inst_3351,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_3354 = cljs.core.get.call(null,inst_3351,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_3355 = inst_3330;
var state_3428__$1 = (function (){var statearr_3479 = state_3428;
(statearr_3479[(16)] = inst_3354);

(statearr_3479[(17)] = inst_3352);

(statearr_3479[(18)] = inst_3353);

(statearr_3479[(7)] = inst_3355);

return statearr_3479;
})();
var statearr_3480_3531 = state_3428__$1;
(statearr_3480_3531[(2)] = null);

(statearr_3480_3531[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (18))){
var inst_3370 = (state_3428[(2)]);
var state_3428__$1 = state_3428;
var statearr_3481_3532 = state_3428__$1;
(statearr_3481_3532[(2)] = inst_3370);

(statearr_3481_3532[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (37))){
var state_3428__$1 = state_3428;
var statearr_3482_3533 = state_3428__$1;
(statearr_3482_3533[(2)] = null);

(statearr_3482_3533[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3429 === (8))){
var inst_3330 = (state_3428[(8)]);
var inst_3348 = cljs.core.apply.call(null,cljs.core.hash_map,inst_3330);
var state_3428__$1 = state_3428;
var statearr_3483_3534 = state_3428__$1;
(statearr_3483_3534[(2)] = inst_3348);

(statearr_3483_3534[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___3488,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__2334__auto__,c__2429__auto___3488,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__2335__auto__ = null;
var cljs$core$async$mix_$_state_machine__2335__auto____0 = (function (){
var statearr_3484 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_3484[(0)] = cljs$core$async$mix_$_state_machine__2335__auto__);

(statearr_3484[(1)] = (1));

return statearr_3484;
});
var cljs$core$async$mix_$_state_machine__2335__auto____1 = (function (state_3428){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_3428);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e3485){if((e3485 instanceof Object)){
var ex__2338__auto__ = e3485;
var statearr_3486_3535 = state_3428;
(statearr_3486_3535[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3428);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3485;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3536 = state_3428;
state_3428 = G__3536;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__2335__auto__ = function(state_3428){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__2335__auto____1.call(this,state_3428);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__2335__auto____0;
cljs$core$async$mix_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__2335__auto____1;
return cljs$core$async$mix_$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___3488,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__2431__auto__ = (function (){var statearr_3487 = f__2430__auto__.call(null);
(statearr_3487[(6)] = c__2429__auto___3488);

return statearr_3487;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___3488,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__4431__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v,ch);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__3538 = arguments.length;
switch (G__3538) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__4433__auto__ = (((p == null))?null:p);
var m__4434__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4433__auto__)]);
if((!((m__4434__auto__ == null)))){
return m__4434__auto__.call(null,p,v);
} else {
var m__4431__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4431__auto__ == null)))){
return m__4431__auto__.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__3542 = arguments.length;
switch (G__3542) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__4131__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__4131__auto__,mults){
return (function (p1__3540_SHARP_){
if(cljs.core.truth_(p1__3540_SHARP_.call(null,topic))){
return p1__3540_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__3540_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__4131__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3543 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3543 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta3544){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta3544 = meta3544;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3543.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_3545,meta3544__$1){
var self__ = this;
var _3545__$1 = this;
return (new cljs.core.async.t_cljs$core$async3543(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta3544__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async3543.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_3545){
var self__ = this;
var _3545__$1 = this;
return self__.meta3544;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async3543.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3543.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async3543.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3543.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async3543.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5457__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__5457__auto__)){
var m = temp__5457__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async3543.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async3543.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async3543.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta3544","meta3544",2107168901,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async3543.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3543.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3543";

cljs.core.async.t_cljs$core$async3543.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async3543");
});})(mults,ensure_mult))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3543.
 */
cljs.core.async.__GT_t_cljs$core$async3543 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async3543(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta3544){
return (new cljs.core.async.t_cljs$core$async3543(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta3544));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async3543(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__2429__auto___3663 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___3663,mults,ensure_mult,p){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___3663,mults,ensure_mult,p){
return (function (state_3617){
var state_val_3618 = (state_3617[(1)]);
if((state_val_3618 === (7))){
var inst_3613 = (state_3617[(2)]);
var state_3617__$1 = state_3617;
var statearr_3619_3664 = state_3617__$1;
(statearr_3619_3664[(2)] = inst_3613);

(statearr_3619_3664[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (20))){
var state_3617__$1 = state_3617;
var statearr_3620_3665 = state_3617__$1;
(statearr_3620_3665[(2)] = null);

(statearr_3620_3665[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (1))){
var state_3617__$1 = state_3617;
var statearr_3621_3666 = state_3617__$1;
(statearr_3621_3666[(2)] = null);

(statearr_3621_3666[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (24))){
var inst_3596 = (state_3617[(7)]);
var inst_3605 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_3596);
var state_3617__$1 = state_3617;
var statearr_3622_3667 = state_3617__$1;
(statearr_3622_3667[(2)] = inst_3605);

(statearr_3622_3667[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (4))){
var inst_3548 = (state_3617[(8)]);
var inst_3548__$1 = (state_3617[(2)]);
var inst_3549 = (inst_3548__$1 == null);
var state_3617__$1 = (function (){var statearr_3623 = state_3617;
(statearr_3623[(8)] = inst_3548__$1);

return statearr_3623;
})();
if(cljs.core.truth_(inst_3549)){
var statearr_3624_3668 = state_3617__$1;
(statearr_3624_3668[(1)] = (5));

} else {
var statearr_3625_3669 = state_3617__$1;
(statearr_3625_3669[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (15))){
var inst_3590 = (state_3617[(2)]);
var state_3617__$1 = state_3617;
var statearr_3626_3670 = state_3617__$1;
(statearr_3626_3670[(2)] = inst_3590);

(statearr_3626_3670[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (21))){
var inst_3610 = (state_3617[(2)]);
var state_3617__$1 = (function (){var statearr_3627 = state_3617;
(statearr_3627[(9)] = inst_3610);

return statearr_3627;
})();
var statearr_3628_3671 = state_3617__$1;
(statearr_3628_3671[(2)] = null);

(statearr_3628_3671[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (13))){
var inst_3572 = (state_3617[(10)]);
var inst_3574 = cljs.core.chunked_seq_QMARK_.call(null,inst_3572);
var state_3617__$1 = state_3617;
if(inst_3574){
var statearr_3629_3672 = state_3617__$1;
(statearr_3629_3672[(1)] = (16));

} else {
var statearr_3630_3673 = state_3617__$1;
(statearr_3630_3673[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (22))){
var inst_3602 = (state_3617[(2)]);
var state_3617__$1 = state_3617;
if(cljs.core.truth_(inst_3602)){
var statearr_3631_3674 = state_3617__$1;
(statearr_3631_3674[(1)] = (23));

} else {
var statearr_3632_3675 = state_3617__$1;
(statearr_3632_3675[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (6))){
var inst_3596 = (state_3617[(7)]);
var inst_3598 = (state_3617[(11)]);
var inst_3548 = (state_3617[(8)]);
var inst_3596__$1 = topic_fn.call(null,inst_3548);
var inst_3597 = cljs.core.deref.call(null,mults);
var inst_3598__$1 = cljs.core.get.call(null,inst_3597,inst_3596__$1);
var state_3617__$1 = (function (){var statearr_3633 = state_3617;
(statearr_3633[(7)] = inst_3596__$1);

(statearr_3633[(11)] = inst_3598__$1);

return statearr_3633;
})();
if(cljs.core.truth_(inst_3598__$1)){
var statearr_3634_3676 = state_3617__$1;
(statearr_3634_3676[(1)] = (19));

} else {
var statearr_3635_3677 = state_3617__$1;
(statearr_3635_3677[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (25))){
var inst_3607 = (state_3617[(2)]);
var state_3617__$1 = state_3617;
var statearr_3636_3678 = state_3617__$1;
(statearr_3636_3678[(2)] = inst_3607);

(statearr_3636_3678[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (17))){
var inst_3572 = (state_3617[(10)]);
var inst_3581 = cljs.core.first.call(null,inst_3572);
var inst_3582 = cljs.core.async.muxch_STAR_.call(null,inst_3581);
var inst_3583 = cljs.core.async.close_BANG_.call(null,inst_3582);
var inst_3584 = cljs.core.next.call(null,inst_3572);
var inst_3558 = inst_3584;
var inst_3559 = null;
var inst_3560 = (0);
var inst_3561 = (0);
var state_3617__$1 = (function (){var statearr_3637 = state_3617;
(statearr_3637[(12)] = inst_3558);

(statearr_3637[(13)] = inst_3583);

(statearr_3637[(14)] = inst_3561);

(statearr_3637[(15)] = inst_3560);

(statearr_3637[(16)] = inst_3559);

return statearr_3637;
})();
var statearr_3638_3679 = state_3617__$1;
(statearr_3638_3679[(2)] = null);

(statearr_3638_3679[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (3))){
var inst_3615 = (state_3617[(2)]);
var state_3617__$1 = state_3617;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3617__$1,inst_3615);
} else {
if((state_val_3618 === (12))){
var inst_3592 = (state_3617[(2)]);
var state_3617__$1 = state_3617;
var statearr_3639_3680 = state_3617__$1;
(statearr_3639_3680[(2)] = inst_3592);

(statearr_3639_3680[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (2))){
var state_3617__$1 = state_3617;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3617__$1,(4),ch);
} else {
if((state_val_3618 === (23))){
var state_3617__$1 = state_3617;
var statearr_3640_3681 = state_3617__$1;
(statearr_3640_3681[(2)] = null);

(statearr_3640_3681[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (19))){
var inst_3598 = (state_3617[(11)]);
var inst_3548 = (state_3617[(8)]);
var inst_3600 = cljs.core.async.muxch_STAR_.call(null,inst_3598);
var state_3617__$1 = state_3617;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3617__$1,(22),inst_3600,inst_3548);
} else {
if((state_val_3618 === (11))){
var inst_3558 = (state_3617[(12)]);
var inst_3572 = (state_3617[(10)]);
var inst_3572__$1 = cljs.core.seq.call(null,inst_3558);
var state_3617__$1 = (function (){var statearr_3641 = state_3617;
(statearr_3641[(10)] = inst_3572__$1);

return statearr_3641;
})();
if(inst_3572__$1){
var statearr_3642_3682 = state_3617__$1;
(statearr_3642_3682[(1)] = (13));

} else {
var statearr_3643_3683 = state_3617__$1;
(statearr_3643_3683[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (9))){
var inst_3594 = (state_3617[(2)]);
var state_3617__$1 = state_3617;
var statearr_3644_3684 = state_3617__$1;
(statearr_3644_3684[(2)] = inst_3594);

(statearr_3644_3684[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (5))){
var inst_3555 = cljs.core.deref.call(null,mults);
var inst_3556 = cljs.core.vals.call(null,inst_3555);
var inst_3557 = cljs.core.seq.call(null,inst_3556);
var inst_3558 = inst_3557;
var inst_3559 = null;
var inst_3560 = (0);
var inst_3561 = (0);
var state_3617__$1 = (function (){var statearr_3645 = state_3617;
(statearr_3645[(12)] = inst_3558);

(statearr_3645[(14)] = inst_3561);

(statearr_3645[(15)] = inst_3560);

(statearr_3645[(16)] = inst_3559);

return statearr_3645;
})();
var statearr_3646_3685 = state_3617__$1;
(statearr_3646_3685[(2)] = null);

(statearr_3646_3685[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (14))){
var state_3617__$1 = state_3617;
var statearr_3650_3686 = state_3617__$1;
(statearr_3650_3686[(2)] = null);

(statearr_3650_3686[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (16))){
var inst_3572 = (state_3617[(10)]);
var inst_3576 = cljs.core.chunk_first.call(null,inst_3572);
var inst_3577 = cljs.core.chunk_rest.call(null,inst_3572);
var inst_3578 = cljs.core.count.call(null,inst_3576);
var inst_3558 = inst_3577;
var inst_3559 = inst_3576;
var inst_3560 = inst_3578;
var inst_3561 = (0);
var state_3617__$1 = (function (){var statearr_3651 = state_3617;
(statearr_3651[(12)] = inst_3558);

(statearr_3651[(14)] = inst_3561);

(statearr_3651[(15)] = inst_3560);

(statearr_3651[(16)] = inst_3559);

return statearr_3651;
})();
var statearr_3652_3687 = state_3617__$1;
(statearr_3652_3687[(2)] = null);

(statearr_3652_3687[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (10))){
var inst_3558 = (state_3617[(12)]);
var inst_3561 = (state_3617[(14)]);
var inst_3560 = (state_3617[(15)]);
var inst_3559 = (state_3617[(16)]);
var inst_3566 = cljs.core._nth.call(null,inst_3559,inst_3561);
var inst_3567 = cljs.core.async.muxch_STAR_.call(null,inst_3566);
var inst_3568 = cljs.core.async.close_BANG_.call(null,inst_3567);
var inst_3569 = (inst_3561 + (1));
var tmp3647 = inst_3558;
var tmp3648 = inst_3560;
var tmp3649 = inst_3559;
var inst_3558__$1 = tmp3647;
var inst_3559__$1 = tmp3649;
var inst_3560__$1 = tmp3648;
var inst_3561__$1 = inst_3569;
var state_3617__$1 = (function (){var statearr_3653 = state_3617;
(statearr_3653[(12)] = inst_3558__$1);

(statearr_3653[(14)] = inst_3561__$1);

(statearr_3653[(15)] = inst_3560__$1);

(statearr_3653[(16)] = inst_3559__$1);

(statearr_3653[(17)] = inst_3568);

return statearr_3653;
})();
var statearr_3654_3688 = state_3617__$1;
(statearr_3654_3688[(2)] = null);

(statearr_3654_3688[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (18))){
var inst_3587 = (state_3617[(2)]);
var state_3617__$1 = state_3617;
var statearr_3655_3689 = state_3617__$1;
(statearr_3655_3689[(2)] = inst_3587);

(statearr_3655_3689[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3618 === (8))){
var inst_3561 = (state_3617[(14)]);
var inst_3560 = (state_3617[(15)]);
var inst_3563 = (inst_3561 < inst_3560);
var inst_3564 = inst_3563;
var state_3617__$1 = state_3617;
if(cljs.core.truth_(inst_3564)){
var statearr_3656_3690 = state_3617__$1;
(statearr_3656_3690[(1)] = (10));

} else {
var statearr_3657_3691 = state_3617__$1;
(statearr_3657_3691[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___3663,mults,ensure_mult,p))
;
return ((function (switch__2334__auto__,c__2429__auto___3663,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__2335__auto__ = null;
var cljs$core$async$state_machine__2335__auto____0 = (function (){
var statearr_3658 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_3658[(0)] = cljs$core$async$state_machine__2335__auto__);

(statearr_3658[(1)] = (1));

return statearr_3658;
});
var cljs$core$async$state_machine__2335__auto____1 = (function (state_3617){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_3617);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e3659){if((e3659 instanceof Object)){
var ex__2338__auto__ = e3659;
var statearr_3660_3692 = state_3617;
(statearr_3660_3692[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3617);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3659;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3693 = state_3617;
state_3617 = G__3693;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$state_machine__2335__auto__ = function(state_3617){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2335__auto____1.call(this,state_3617);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2335__auto____0;
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2335__auto____1;
return cljs$core$async$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___3663,mults,ensure_mult,p))
})();
var state__2431__auto__ = (function (){var statearr_3661 = f__2430__auto__.call(null);
(statearr_3661[(6)] = c__2429__auto___3663);

return statearr_3661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___3663,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__3695 = arguments.length;
switch (G__3695) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__3698 = arguments.length;
switch (G__3698) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__3701 = arguments.length;
switch (G__3701) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__2429__auto___3768 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___3768,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___3768,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_3740){
var state_val_3741 = (state_3740[(1)]);
if((state_val_3741 === (7))){
var state_3740__$1 = state_3740;
var statearr_3742_3769 = state_3740__$1;
(statearr_3742_3769[(2)] = null);

(statearr_3742_3769[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (1))){
var state_3740__$1 = state_3740;
var statearr_3743_3770 = state_3740__$1;
(statearr_3743_3770[(2)] = null);

(statearr_3743_3770[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (4))){
var inst_3704 = (state_3740[(7)]);
var inst_3706 = (inst_3704 < cnt);
var state_3740__$1 = state_3740;
if(cljs.core.truth_(inst_3706)){
var statearr_3744_3771 = state_3740__$1;
(statearr_3744_3771[(1)] = (6));

} else {
var statearr_3745_3772 = state_3740__$1;
(statearr_3745_3772[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (15))){
var inst_3736 = (state_3740[(2)]);
var state_3740__$1 = state_3740;
var statearr_3746_3773 = state_3740__$1;
(statearr_3746_3773[(2)] = inst_3736);

(statearr_3746_3773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (13))){
var inst_3729 = cljs.core.async.close_BANG_.call(null,out);
var state_3740__$1 = state_3740;
var statearr_3747_3774 = state_3740__$1;
(statearr_3747_3774[(2)] = inst_3729);

(statearr_3747_3774[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (6))){
var state_3740__$1 = state_3740;
var statearr_3748_3775 = state_3740__$1;
(statearr_3748_3775[(2)] = null);

(statearr_3748_3775[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (3))){
var inst_3738 = (state_3740[(2)]);
var state_3740__$1 = state_3740;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3740__$1,inst_3738);
} else {
if((state_val_3741 === (12))){
var inst_3726 = (state_3740[(8)]);
var inst_3726__$1 = (state_3740[(2)]);
var inst_3727 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_3726__$1);
var state_3740__$1 = (function (){var statearr_3749 = state_3740;
(statearr_3749[(8)] = inst_3726__$1);

return statearr_3749;
})();
if(cljs.core.truth_(inst_3727)){
var statearr_3750_3776 = state_3740__$1;
(statearr_3750_3776[(1)] = (13));

} else {
var statearr_3751_3777 = state_3740__$1;
(statearr_3751_3777[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (2))){
var inst_3703 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_3704 = (0);
var state_3740__$1 = (function (){var statearr_3752 = state_3740;
(statearr_3752[(9)] = inst_3703);

(statearr_3752[(7)] = inst_3704);

return statearr_3752;
})();
var statearr_3753_3778 = state_3740__$1;
(statearr_3753_3778[(2)] = null);

(statearr_3753_3778[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (11))){
var inst_3704 = (state_3740[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_3740,(10),Object,null,(9));
var inst_3713 = chs__$1.call(null,inst_3704);
var inst_3714 = done.call(null,inst_3704);
var inst_3715 = cljs.core.async.take_BANG_.call(null,inst_3713,inst_3714);
var state_3740__$1 = state_3740;
var statearr_3754_3779 = state_3740__$1;
(statearr_3754_3779[(2)] = inst_3715);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3740__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (9))){
var inst_3704 = (state_3740[(7)]);
var inst_3717 = (state_3740[(2)]);
var inst_3718 = (inst_3704 + (1));
var inst_3704__$1 = inst_3718;
var state_3740__$1 = (function (){var statearr_3755 = state_3740;
(statearr_3755[(10)] = inst_3717);

(statearr_3755[(7)] = inst_3704__$1);

return statearr_3755;
})();
var statearr_3756_3780 = state_3740__$1;
(statearr_3756_3780[(2)] = null);

(statearr_3756_3780[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (5))){
var inst_3724 = (state_3740[(2)]);
var state_3740__$1 = (function (){var statearr_3757 = state_3740;
(statearr_3757[(11)] = inst_3724);

return statearr_3757;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3740__$1,(12),dchan);
} else {
if((state_val_3741 === (14))){
var inst_3726 = (state_3740[(8)]);
var inst_3731 = cljs.core.apply.call(null,f,inst_3726);
var state_3740__$1 = state_3740;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3740__$1,(16),out,inst_3731);
} else {
if((state_val_3741 === (16))){
var inst_3733 = (state_3740[(2)]);
var state_3740__$1 = (function (){var statearr_3758 = state_3740;
(statearr_3758[(12)] = inst_3733);

return statearr_3758;
})();
var statearr_3759_3781 = state_3740__$1;
(statearr_3759_3781[(2)] = null);

(statearr_3759_3781[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (10))){
var inst_3708 = (state_3740[(2)]);
var inst_3709 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_3740__$1 = (function (){var statearr_3760 = state_3740;
(statearr_3760[(13)] = inst_3708);

return statearr_3760;
})();
var statearr_3761_3782 = state_3740__$1;
(statearr_3761_3782[(2)] = inst_3709);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3740__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3741 === (8))){
var inst_3722 = (state_3740[(2)]);
var state_3740__$1 = state_3740;
var statearr_3762_3783 = state_3740__$1;
(statearr_3762_3783[(2)] = inst_3722);

(statearr_3762_3783[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___3768,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__2334__auto__,c__2429__auto___3768,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__2335__auto__ = null;
var cljs$core$async$state_machine__2335__auto____0 = (function (){
var statearr_3763 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_3763[(0)] = cljs$core$async$state_machine__2335__auto__);

(statearr_3763[(1)] = (1));

return statearr_3763;
});
var cljs$core$async$state_machine__2335__auto____1 = (function (state_3740){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_3740);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e3764){if((e3764 instanceof Object)){
var ex__2338__auto__ = e3764;
var statearr_3765_3784 = state_3740;
(statearr_3765_3784[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3740);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3764;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3785 = state_3740;
state_3740 = G__3785;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$state_machine__2335__auto__ = function(state_3740){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2335__auto____1.call(this,state_3740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2335__auto____0;
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2335__auto____1;
return cljs$core$async$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___3768,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__2431__auto__ = (function (){var statearr_3766 = f__2430__auto__.call(null);
(statearr_3766[(6)] = c__2429__auto___3768);

return statearr_3766;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___3768,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__3788 = arguments.length;
switch (G__3788) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2429__auto___3842 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___3842,out){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___3842,out){
return (function (state_3820){
var state_val_3821 = (state_3820[(1)]);
if((state_val_3821 === (7))){
var inst_3800 = (state_3820[(7)]);
var inst_3799 = (state_3820[(8)]);
var inst_3799__$1 = (state_3820[(2)]);
var inst_3800__$1 = cljs.core.nth.call(null,inst_3799__$1,(0),null);
var inst_3801 = cljs.core.nth.call(null,inst_3799__$1,(1),null);
var inst_3802 = (inst_3800__$1 == null);
var state_3820__$1 = (function (){var statearr_3822 = state_3820;
(statearr_3822[(7)] = inst_3800__$1);

(statearr_3822[(9)] = inst_3801);

(statearr_3822[(8)] = inst_3799__$1);

return statearr_3822;
})();
if(cljs.core.truth_(inst_3802)){
var statearr_3823_3843 = state_3820__$1;
(statearr_3823_3843[(1)] = (8));

} else {
var statearr_3824_3844 = state_3820__$1;
(statearr_3824_3844[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3821 === (1))){
var inst_3789 = cljs.core.vec.call(null,chs);
var inst_3790 = inst_3789;
var state_3820__$1 = (function (){var statearr_3825 = state_3820;
(statearr_3825[(10)] = inst_3790);

return statearr_3825;
})();
var statearr_3826_3845 = state_3820__$1;
(statearr_3826_3845[(2)] = null);

(statearr_3826_3845[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3821 === (4))){
var inst_3790 = (state_3820[(10)]);
var state_3820__$1 = state_3820;
return cljs.core.async.ioc_alts_BANG_.call(null,state_3820__$1,(7),inst_3790);
} else {
if((state_val_3821 === (6))){
var inst_3816 = (state_3820[(2)]);
var state_3820__$1 = state_3820;
var statearr_3827_3846 = state_3820__$1;
(statearr_3827_3846[(2)] = inst_3816);

(statearr_3827_3846[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3821 === (3))){
var inst_3818 = (state_3820[(2)]);
var state_3820__$1 = state_3820;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3820__$1,inst_3818);
} else {
if((state_val_3821 === (2))){
var inst_3790 = (state_3820[(10)]);
var inst_3792 = cljs.core.count.call(null,inst_3790);
var inst_3793 = (inst_3792 > (0));
var state_3820__$1 = state_3820;
if(cljs.core.truth_(inst_3793)){
var statearr_3829_3847 = state_3820__$1;
(statearr_3829_3847[(1)] = (4));

} else {
var statearr_3830_3848 = state_3820__$1;
(statearr_3830_3848[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3821 === (11))){
var inst_3790 = (state_3820[(10)]);
var inst_3809 = (state_3820[(2)]);
var tmp3828 = inst_3790;
var inst_3790__$1 = tmp3828;
var state_3820__$1 = (function (){var statearr_3831 = state_3820;
(statearr_3831[(10)] = inst_3790__$1);

(statearr_3831[(11)] = inst_3809);

return statearr_3831;
})();
var statearr_3832_3849 = state_3820__$1;
(statearr_3832_3849[(2)] = null);

(statearr_3832_3849[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3821 === (9))){
var inst_3800 = (state_3820[(7)]);
var state_3820__$1 = state_3820;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3820__$1,(11),out,inst_3800);
} else {
if((state_val_3821 === (5))){
var inst_3814 = cljs.core.async.close_BANG_.call(null,out);
var state_3820__$1 = state_3820;
var statearr_3833_3850 = state_3820__$1;
(statearr_3833_3850[(2)] = inst_3814);

(statearr_3833_3850[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3821 === (10))){
var inst_3812 = (state_3820[(2)]);
var state_3820__$1 = state_3820;
var statearr_3834_3851 = state_3820__$1;
(statearr_3834_3851[(2)] = inst_3812);

(statearr_3834_3851[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3821 === (8))){
var inst_3800 = (state_3820[(7)]);
var inst_3790 = (state_3820[(10)]);
var inst_3801 = (state_3820[(9)]);
var inst_3799 = (state_3820[(8)]);
var inst_3804 = (function (){var cs = inst_3790;
var vec__3795 = inst_3799;
var v = inst_3800;
var c = inst_3801;
return ((function (cs,vec__3795,v,c,inst_3800,inst_3790,inst_3801,inst_3799,state_val_3821,c__2429__auto___3842,out){
return (function (p1__3786_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__3786_SHARP_);
});
;})(cs,vec__3795,v,c,inst_3800,inst_3790,inst_3801,inst_3799,state_val_3821,c__2429__auto___3842,out))
})();
var inst_3805 = cljs.core.filterv.call(null,inst_3804,inst_3790);
var inst_3790__$1 = inst_3805;
var state_3820__$1 = (function (){var statearr_3835 = state_3820;
(statearr_3835[(10)] = inst_3790__$1);

return statearr_3835;
})();
var statearr_3836_3852 = state_3820__$1;
(statearr_3836_3852[(2)] = null);

(statearr_3836_3852[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___3842,out))
;
return ((function (switch__2334__auto__,c__2429__auto___3842,out){
return (function() {
var cljs$core$async$state_machine__2335__auto__ = null;
var cljs$core$async$state_machine__2335__auto____0 = (function (){
var statearr_3837 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_3837[(0)] = cljs$core$async$state_machine__2335__auto__);

(statearr_3837[(1)] = (1));

return statearr_3837;
});
var cljs$core$async$state_machine__2335__auto____1 = (function (state_3820){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_3820);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e3838){if((e3838 instanceof Object)){
var ex__2338__auto__ = e3838;
var statearr_3839_3853 = state_3820;
(statearr_3839_3853[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3820);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3838;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3854 = state_3820;
state_3820 = G__3854;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$state_machine__2335__auto__ = function(state_3820){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2335__auto____1.call(this,state_3820);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2335__auto____0;
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2335__auto____1;
return cljs$core$async$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___3842,out))
})();
var state__2431__auto__ = (function (){var statearr_3840 = f__2430__auto__.call(null);
(statearr_3840[(6)] = c__2429__auto___3842);

return statearr_3840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___3842,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__3856 = arguments.length;
switch (G__3856) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2429__auto___3901 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___3901,out){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___3901,out){
return (function (state_3880){
var state_val_3881 = (state_3880[(1)]);
if((state_val_3881 === (7))){
var inst_3862 = (state_3880[(7)]);
var inst_3862__$1 = (state_3880[(2)]);
var inst_3863 = (inst_3862__$1 == null);
var inst_3864 = cljs.core.not.call(null,inst_3863);
var state_3880__$1 = (function (){var statearr_3882 = state_3880;
(statearr_3882[(7)] = inst_3862__$1);

return statearr_3882;
})();
if(inst_3864){
var statearr_3883_3902 = state_3880__$1;
(statearr_3883_3902[(1)] = (8));

} else {
var statearr_3884_3903 = state_3880__$1;
(statearr_3884_3903[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3881 === (1))){
var inst_3857 = (0);
var state_3880__$1 = (function (){var statearr_3885 = state_3880;
(statearr_3885[(8)] = inst_3857);

return statearr_3885;
})();
var statearr_3886_3904 = state_3880__$1;
(statearr_3886_3904[(2)] = null);

(statearr_3886_3904[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3881 === (4))){
var state_3880__$1 = state_3880;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3880__$1,(7),ch);
} else {
if((state_val_3881 === (6))){
var inst_3875 = (state_3880[(2)]);
var state_3880__$1 = state_3880;
var statearr_3887_3905 = state_3880__$1;
(statearr_3887_3905[(2)] = inst_3875);

(statearr_3887_3905[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3881 === (3))){
var inst_3877 = (state_3880[(2)]);
var inst_3878 = cljs.core.async.close_BANG_.call(null,out);
var state_3880__$1 = (function (){var statearr_3888 = state_3880;
(statearr_3888[(9)] = inst_3877);

return statearr_3888;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3880__$1,inst_3878);
} else {
if((state_val_3881 === (2))){
var inst_3857 = (state_3880[(8)]);
var inst_3859 = (inst_3857 < n);
var state_3880__$1 = state_3880;
if(cljs.core.truth_(inst_3859)){
var statearr_3889_3906 = state_3880__$1;
(statearr_3889_3906[(1)] = (4));

} else {
var statearr_3890_3907 = state_3880__$1;
(statearr_3890_3907[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3881 === (11))){
var inst_3857 = (state_3880[(8)]);
var inst_3867 = (state_3880[(2)]);
var inst_3868 = (inst_3857 + (1));
var inst_3857__$1 = inst_3868;
var state_3880__$1 = (function (){var statearr_3891 = state_3880;
(statearr_3891[(8)] = inst_3857__$1);

(statearr_3891[(10)] = inst_3867);

return statearr_3891;
})();
var statearr_3892_3908 = state_3880__$1;
(statearr_3892_3908[(2)] = null);

(statearr_3892_3908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3881 === (9))){
var state_3880__$1 = state_3880;
var statearr_3893_3909 = state_3880__$1;
(statearr_3893_3909[(2)] = null);

(statearr_3893_3909[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3881 === (5))){
var state_3880__$1 = state_3880;
var statearr_3894_3910 = state_3880__$1;
(statearr_3894_3910[(2)] = null);

(statearr_3894_3910[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3881 === (10))){
var inst_3872 = (state_3880[(2)]);
var state_3880__$1 = state_3880;
var statearr_3895_3911 = state_3880__$1;
(statearr_3895_3911[(2)] = inst_3872);

(statearr_3895_3911[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3881 === (8))){
var inst_3862 = (state_3880[(7)]);
var state_3880__$1 = state_3880;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3880__$1,(11),out,inst_3862);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___3901,out))
;
return ((function (switch__2334__auto__,c__2429__auto___3901,out){
return (function() {
var cljs$core$async$state_machine__2335__auto__ = null;
var cljs$core$async$state_machine__2335__auto____0 = (function (){
var statearr_3896 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_3896[(0)] = cljs$core$async$state_machine__2335__auto__);

(statearr_3896[(1)] = (1));

return statearr_3896;
});
var cljs$core$async$state_machine__2335__auto____1 = (function (state_3880){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_3880);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e3897){if((e3897 instanceof Object)){
var ex__2338__auto__ = e3897;
var statearr_3898_3912 = state_3880;
(statearr_3898_3912[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3880);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3897;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3913 = state_3880;
state_3880 = G__3913;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$state_machine__2335__auto__ = function(state_3880){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2335__auto____1.call(this,state_3880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2335__auto____0;
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2335__auto____1;
return cljs$core$async$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___3901,out))
})();
var state__2431__auto__ = (function (){var statearr_3899 = f__2430__auto__.call(null);
(statearr_3899[(6)] = c__2429__auto___3901);

return statearr_3899;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___3901,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3915 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3915 = (function (f,ch,meta3916){
this.f = f;
this.ch = ch;
this.meta3916 = meta3916;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3915.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3917,meta3916__$1){
var self__ = this;
var _3917__$1 = this;
return (new cljs.core.async.t_cljs$core$async3915(self__.f,self__.ch,meta3916__$1));
});

cljs.core.async.t_cljs$core$async3915.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3917){
var self__ = this;
var _3917__$1 = this;
return self__.meta3916;
});

cljs.core.async.t_cljs$core$async3915.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3915.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async3915.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async3915.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3915.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3918 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3918 = (function (f,ch,meta3916,_,fn1,meta3919){
this.f = f;
this.ch = ch;
this.meta3916 = meta3916;
this._ = _;
this.fn1 = fn1;
this.meta3919 = meta3919;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3918.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_3920,meta3919__$1){
var self__ = this;
var _3920__$1 = this;
return (new cljs.core.async.t_cljs$core$async3918(self__.f,self__.ch,self__.meta3916,self__._,self__.fn1,meta3919__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async3918.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_3920){
var self__ = this;
var _3920__$1 = this;
return self__.meta3919;
});})(___$1))
;

cljs.core.async.t_cljs$core$async3918.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3918.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async3918.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async3918.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__3914_SHARP_){
return f1.call(null,(((p1__3914_SHARP_ == null))?null:self__.f.call(null,p1__3914_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async3918.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta3916","meta3916",674416067,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async3915","cljs.core.async/t_cljs$core$async3915",-314818590,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta3919","meta3919",-1206574934,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async3918.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3918.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3918";

cljs.core.async.t_cljs$core$async3918.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async3918");
});})(___$1))
;

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3918.
 */
cljs.core.async.__GT_t_cljs$core$async3918 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async3918(f__$1,ch__$1,meta3916__$1,___$2,fn1__$1,meta3919){
return (new cljs.core.async.t_cljs$core$async3918(f__$1,ch__$1,meta3916__$1,___$2,fn1__$1,meta3919));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async3918(self__.f,self__.ch,self__.meta3916,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4120__auto__ = ret;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.deref.call(null,ret) == null)));
} else {
return and__4120__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async3915.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3915.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async3915.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta3916","meta3916",674416067,null)], null);
});

cljs.core.async.t_cljs$core$async3915.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3915.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3915";

cljs.core.async.t_cljs$core$async3915.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async3915");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3915.
 */
cljs.core.async.__GT_t_cljs$core$async3915 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async3915(f__$1,ch__$1,meta3916){
return (new cljs.core.async.t_cljs$core$async3915(f__$1,ch__$1,meta3916));
});

}

return (new cljs.core.async.t_cljs$core$async3915(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3921 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3921 = (function (f,ch,meta3922){
this.f = f;
this.ch = ch;
this.meta3922 = meta3922;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3921.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3923,meta3922__$1){
var self__ = this;
var _3923__$1 = this;
return (new cljs.core.async.t_cljs$core$async3921(self__.f,self__.ch,meta3922__$1));
});

cljs.core.async.t_cljs$core$async3921.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3923){
var self__ = this;
var _3923__$1 = this;
return self__.meta3922;
});

cljs.core.async.t_cljs$core$async3921.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3921.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async3921.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3921.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async3921.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3921.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async3921.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta3922","meta3922",80138487,null)], null);
});

cljs.core.async.t_cljs$core$async3921.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3921.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3921";

cljs.core.async.t_cljs$core$async3921.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async3921");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3921.
 */
cljs.core.async.__GT_t_cljs$core$async3921 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async3921(f__$1,ch__$1,meta3922){
return (new cljs.core.async.t_cljs$core$async3921(f__$1,ch__$1,meta3922));
});

}

return (new cljs.core.async.t_cljs$core$async3921(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async3924 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async3924 = (function (p,ch,meta3925){
this.p = p;
this.ch = ch;
this.meta3925 = meta3925;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
cljs.core.async.t_cljs$core$async3924.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_3926,meta3925__$1){
var self__ = this;
var _3926__$1 = this;
return (new cljs.core.async.t_cljs$core$async3924(self__.p,self__.ch,meta3925__$1));
});

cljs.core.async.t_cljs$core$async3924.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_3926){
var self__ = this;
var _3926__$1 = this;
return self__.meta3925;
});

cljs.core.async.t_cljs$core$async3924.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3924.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async3924.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async3924.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3924.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async3924.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async3924.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async3924.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta3925","meta3925",-1753494691,null)], null);
});

cljs.core.async.t_cljs$core$async3924.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async3924.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async3924";

cljs.core.async.t_cljs$core$async3924.cljs$lang$ctorPrWriter = (function (this__4374__auto__,writer__4375__auto__,opt__4376__auto__){
return cljs.core._write.call(null,writer__4375__auto__,"cljs.core.async/t_cljs$core$async3924");
});

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async3924.
 */
cljs.core.async.__GT_t_cljs$core$async3924 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async3924(p__$1,ch__$1,meta3925){
return (new cljs.core.async.t_cljs$core$async3924(p__$1,ch__$1,meta3925));
});

}

return (new cljs.core.async.t_cljs$core$async3924(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__3928 = arguments.length;
switch (G__3928) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2429__auto___3968 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___3968,out){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___3968,out){
return (function (state_3949){
var state_val_3950 = (state_3949[(1)]);
if((state_val_3950 === (7))){
var inst_3945 = (state_3949[(2)]);
var state_3949__$1 = state_3949;
var statearr_3951_3969 = state_3949__$1;
(statearr_3951_3969[(2)] = inst_3945);

(statearr_3951_3969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3950 === (1))){
var state_3949__$1 = state_3949;
var statearr_3952_3970 = state_3949__$1;
(statearr_3952_3970[(2)] = null);

(statearr_3952_3970[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3950 === (4))){
var inst_3931 = (state_3949[(7)]);
var inst_3931__$1 = (state_3949[(2)]);
var inst_3932 = (inst_3931__$1 == null);
var state_3949__$1 = (function (){var statearr_3953 = state_3949;
(statearr_3953[(7)] = inst_3931__$1);

return statearr_3953;
})();
if(cljs.core.truth_(inst_3932)){
var statearr_3954_3971 = state_3949__$1;
(statearr_3954_3971[(1)] = (5));

} else {
var statearr_3955_3972 = state_3949__$1;
(statearr_3955_3972[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3950 === (6))){
var inst_3931 = (state_3949[(7)]);
var inst_3936 = p.call(null,inst_3931);
var state_3949__$1 = state_3949;
if(cljs.core.truth_(inst_3936)){
var statearr_3956_3973 = state_3949__$1;
(statearr_3956_3973[(1)] = (8));

} else {
var statearr_3957_3974 = state_3949__$1;
(statearr_3957_3974[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3950 === (3))){
var inst_3947 = (state_3949[(2)]);
var state_3949__$1 = state_3949;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_3949__$1,inst_3947);
} else {
if((state_val_3950 === (2))){
var state_3949__$1 = state_3949;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_3949__$1,(4),ch);
} else {
if((state_val_3950 === (11))){
var inst_3939 = (state_3949[(2)]);
var state_3949__$1 = state_3949;
var statearr_3958_3975 = state_3949__$1;
(statearr_3958_3975[(2)] = inst_3939);

(statearr_3958_3975[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3950 === (9))){
var state_3949__$1 = state_3949;
var statearr_3959_3976 = state_3949__$1;
(statearr_3959_3976[(2)] = null);

(statearr_3959_3976[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3950 === (5))){
var inst_3934 = cljs.core.async.close_BANG_.call(null,out);
var state_3949__$1 = state_3949;
var statearr_3960_3977 = state_3949__$1;
(statearr_3960_3977[(2)] = inst_3934);

(statearr_3960_3977[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3950 === (10))){
var inst_3942 = (state_3949[(2)]);
var state_3949__$1 = (function (){var statearr_3961 = state_3949;
(statearr_3961[(8)] = inst_3942);

return statearr_3961;
})();
var statearr_3962_3978 = state_3949__$1;
(statearr_3962_3978[(2)] = null);

(statearr_3962_3978[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_3950 === (8))){
var inst_3931 = (state_3949[(7)]);
var state_3949__$1 = state_3949;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_3949__$1,(11),out,inst_3931);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___3968,out))
;
return ((function (switch__2334__auto__,c__2429__auto___3968,out){
return (function() {
var cljs$core$async$state_machine__2335__auto__ = null;
var cljs$core$async$state_machine__2335__auto____0 = (function (){
var statearr_3963 = [null,null,null,null,null,null,null,null,null];
(statearr_3963[(0)] = cljs$core$async$state_machine__2335__auto__);

(statearr_3963[(1)] = (1));

return statearr_3963;
});
var cljs$core$async$state_machine__2335__auto____1 = (function (state_3949){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_3949);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e3964){if((e3964 instanceof Object)){
var ex__2338__auto__ = e3964;
var statearr_3965_3979 = state_3949;
(statearr_3965_3979[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_3949);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e3964;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__3980 = state_3949;
state_3949 = G__3980;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$state_machine__2335__auto__ = function(state_3949){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2335__auto____1.call(this,state_3949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2335__auto____0;
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2335__auto____1;
return cljs$core$async$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___3968,out))
})();
var state__2431__auto__ = (function (){var statearr_3966 = f__2430__auto__.call(null);
(statearr_3966[(6)] = c__2429__auto___3968);

return statearr_3966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___3968,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__3982 = arguments.length;
switch (G__3982) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__2429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto__){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto__){
return (function (state_4045){
var state_val_4046 = (state_4045[(1)]);
if((state_val_4046 === (7))){
var inst_4041 = (state_4045[(2)]);
var state_4045__$1 = state_4045;
var statearr_4047_4085 = state_4045__$1;
(statearr_4047_4085[(2)] = inst_4041);

(statearr_4047_4085[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (20))){
var inst_4011 = (state_4045[(7)]);
var inst_4022 = (state_4045[(2)]);
var inst_4023 = cljs.core.next.call(null,inst_4011);
var inst_3997 = inst_4023;
var inst_3998 = null;
var inst_3999 = (0);
var inst_4000 = (0);
var state_4045__$1 = (function (){var statearr_4048 = state_4045;
(statearr_4048[(8)] = inst_3999);

(statearr_4048[(9)] = inst_4000);

(statearr_4048[(10)] = inst_3998);

(statearr_4048[(11)] = inst_4022);

(statearr_4048[(12)] = inst_3997);

return statearr_4048;
})();
var statearr_4049_4086 = state_4045__$1;
(statearr_4049_4086[(2)] = null);

(statearr_4049_4086[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (1))){
var state_4045__$1 = state_4045;
var statearr_4050_4087 = state_4045__$1;
(statearr_4050_4087[(2)] = null);

(statearr_4050_4087[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (4))){
var inst_3986 = (state_4045[(13)]);
var inst_3986__$1 = (state_4045[(2)]);
var inst_3987 = (inst_3986__$1 == null);
var state_4045__$1 = (function (){var statearr_4051 = state_4045;
(statearr_4051[(13)] = inst_3986__$1);

return statearr_4051;
})();
if(cljs.core.truth_(inst_3987)){
var statearr_4052_4088 = state_4045__$1;
(statearr_4052_4088[(1)] = (5));

} else {
var statearr_4053_4089 = state_4045__$1;
(statearr_4053_4089[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (15))){
var state_4045__$1 = state_4045;
var statearr_4057_4090 = state_4045__$1;
(statearr_4057_4090[(2)] = null);

(statearr_4057_4090[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (21))){
var state_4045__$1 = state_4045;
var statearr_4058_4091 = state_4045__$1;
(statearr_4058_4091[(2)] = null);

(statearr_4058_4091[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (13))){
var inst_3999 = (state_4045[(8)]);
var inst_4000 = (state_4045[(9)]);
var inst_3998 = (state_4045[(10)]);
var inst_3997 = (state_4045[(12)]);
var inst_4007 = (state_4045[(2)]);
var inst_4008 = (inst_4000 + (1));
var tmp4054 = inst_3999;
var tmp4055 = inst_3998;
var tmp4056 = inst_3997;
var inst_3997__$1 = tmp4056;
var inst_3998__$1 = tmp4055;
var inst_3999__$1 = tmp4054;
var inst_4000__$1 = inst_4008;
var state_4045__$1 = (function (){var statearr_4059 = state_4045;
(statearr_4059[(8)] = inst_3999__$1);

(statearr_4059[(9)] = inst_4000__$1);

(statearr_4059[(10)] = inst_3998__$1);

(statearr_4059[(14)] = inst_4007);

(statearr_4059[(12)] = inst_3997__$1);

return statearr_4059;
})();
var statearr_4060_4092 = state_4045__$1;
(statearr_4060_4092[(2)] = null);

(statearr_4060_4092[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (22))){
var state_4045__$1 = state_4045;
var statearr_4061_4093 = state_4045__$1;
(statearr_4061_4093[(2)] = null);

(statearr_4061_4093[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (6))){
var inst_3986 = (state_4045[(13)]);
var inst_3995 = f.call(null,inst_3986);
var inst_3996 = cljs.core.seq.call(null,inst_3995);
var inst_3997 = inst_3996;
var inst_3998 = null;
var inst_3999 = (0);
var inst_4000 = (0);
var state_4045__$1 = (function (){var statearr_4062 = state_4045;
(statearr_4062[(8)] = inst_3999);

(statearr_4062[(9)] = inst_4000);

(statearr_4062[(10)] = inst_3998);

(statearr_4062[(12)] = inst_3997);

return statearr_4062;
})();
var statearr_4063_4094 = state_4045__$1;
(statearr_4063_4094[(2)] = null);

(statearr_4063_4094[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (17))){
var inst_4011 = (state_4045[(7)]);
var inst_4015 = cljs.core.chunk_first.call(null,inst_4011);
var inst_4016 = cljs.core.chunk_rest.call(null,inst_4011);
var inst_4017 = cljs.core.count.call(null,inst_4015);
var inst_3997 = inst_4016;
var inst_3998 = inst_4015;
var inst_3999 = inst_4017;
var inst_4000 = (0);
var state_4045__$1 = (function (){var statearr_4064 = state_4045;
(statearr_4064[(8)] = inst_3999);

(statearr_4064[(9)] = inst_4000);

(statearr_4064[(10)] = inst_3998);

(statearr_4064[(12)] = inst_3997);

return statearr_4064;
})();
var statearr_4065_4095 = state_4045__$1;
(statearr_4065_4095[(2)] = null);

(statearr_4065_4095[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (3))){
var inst_4043 = (state_4045[(2)]);
var state_4045__$1 = state_4045;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4045__$1,inst_4043);
} else {
if((state_val_4046 === (12))){
var inst_4031 = (state_4045[(2)]);
var state_4045__$1 = state_4045;
var statearr_4066_4096 = state_4045__$1;
(statearr_4066_4096[(2)] = inst_4031);

(statearr_4066_4096[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (2))){
var state_4045__$1 = state_4045;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4045__$1,(4),in$);
} else {
if((state_val_4046 === (23))){
var inst_4039 = (state_4045[(2)]);
var state_4045__$1 = state_4045;
var statearr_4067_4097 = state_4045__$1;
(statearr_4067_4097[(2)] = inst_4039);

(statearr_4067_4097[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (19))){
var inst_4026 = (state_4045[(2)]);
var state_4045__$1 = state_4045;
var statearr_4068_4098 = state_4045__$1;
(statearr_4068_4098[(2)] = inst_4026);

(statearr_4068_4098[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (11))){
var inst_4011 = (state_4045[(7)]);
var inst_3997 = (state_4045[(12)]);
var inst_4011__$1 = cljs.core.seq.call(null,inst_3997);
var state_4045__$1 = (function (){var statearr_4069 = state_4045;
(statearr_4069[(7)] = inst_4011__$1);

return statearr_4069;
})();
if(inst_4011__$1){
var statearr_4070_4099 = state_4045__$1;
(statearr_4070_4099[(1)] = (14));

} else {
var statearr_4071_4100 = state_4045__$1;
(statearr_4071_4100[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (9))){
var inst_4033 = (state_4045[(2)]);
var inst_4034 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_4045__$1 = (function (){var statearr_4072 = state_4045;
(statearr_4072[(15)] = inst_4033);

return statearr_4072;
})();
if(cljs.core.truth_(inst_4034)){
var statearr_4073_4101 = state_4045__$1;
(statearr_4073_4101[(1)] = (21));

} else {
var statearr_4074_4102 = state_4045__$1;
(statearr_4074_4102[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (5))){
var inst_3989 = cljs.core.async.close_BANG_.call(null,out);
var state_4045__$1 = state_4045;
var statearr_4075_4103 = state_4045__$1;
(statearr_4075_4103[(2)] = inst_3989);

(statearr_4075_4103[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (14))){
var inst_4011 = (state_4045[(7)]);
var inst_4013 = cljs.core.chunked_seq_QMARK_.call(null,inst_4011);
var state_4045__$1 = state_4045;
if(inst_4013){
var statearr_4076_4104 = state_4045__$1;
(statearr_4076_4104[(1)] = (17));

} else {
var statearr_4077_4105 = state_4045__$1;
(statearr_4077_4105[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (16))){
var inst_4029 = (state_4045[(2)]);
var state_4045__$1 = state_4045;
var statearr_4078_4106 = state_4045__$1;
(statearr_4078_4106[(2)] = inst_4029);

(statearr_4078_4106[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4046 === (10))){
var inst_4000 = (state_4045[(9)]);
var inst_3998 = (state_4045[(10)]);
var inst_4005 = cljs.core._nth.call(null,inst_3998,inst_4000);
var state_4045__$1 = state_4045;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4045__$1,(13),out,inst_4005);
} else {
if((state_val_4046 === (18))){
var inst_4011 = (state_4045[(7)]);
var inst_4020 = cljs.core.first.call(null,inst_4011);
var state_4045__$1 = state_4045;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4045__$1,(20),out,inst_4020);
} else {
if((state_val_4046 === (8))){
var inst_3999 = (state_4045[(8)]);
var inst_4000 = (state_4045[(9)]);
var inst_4002 = (inst_4000 < inst_3999);
var inst_4003 = inst_4002;
var state_4045__$1 = state_4045;
if(cljs.core.truth_(inst_4003)){
var statearr_4079_4107 = state_4045__$1;
(statearr_4079_4107[(1)] = (10));

} else {
var statearr_4080_4108 = state_4045__$1;
(statearr_4080_4108[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto__))
;
return ((function (switch__2334__auto__,c__2429__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__2335__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__2335__auto____0 = (function (){
var statearr_4081 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4081[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__2335__auto__);

(statearr_4081[(1)] = (1));

return statearr_4081;
});
var cljs$core$async$mapcat_STAR__$_state_machine__2335__auto____1 = (function (state_4045){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_4045);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e4082){if((e4082 instanceof Object)){
var ex__2338__auto__ = e4082;
var statearr_4083_4109 = state_4045;
(statearr_4083_4109[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4045);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4082;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4110 = state_4045;
state_4045 = G__4110;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__2335__auto__ = function(state_4045){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__2335__auto____1.call(this,state_4045);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__2335__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__2335__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto__))
})();
var state__2431__auto__ = (function (){var statearr_4084 = f__2430__auto__.call(null);
(statearr_4084[(6)] = c__2429__auto__);

return statearr_4084;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto__))
);

return c__2429__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__4112 = arguments.length;
switch (G__4112) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__4115 = arguments.length;
switch (G__4115) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__4118 = arguments.length;
switch (G__4118) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2429__auto___4165 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___4165,out){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___4165,out){
return (function (state_4142){
var state_val_4143 = (state_4142[(1)]);
if((state_val_4143 === (7))){
var inst_4137 = (state_4142[(2)]);
var state_4142__$1 = state_4142;
var statearr_4144_4166 = state_4142__$1;
(statearr_4144_4166[(2)] = inst_4137);

(statearr_4144_4166[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4143 === (1))){
var inst_4119 = null;
var state_4142__$1 = (function (){var statearr_4145 = state_4142;
(statearr_4145[(7)] = inst_4119);

return statearr_4145;
})();
var statearr_4146_4167 = state_4142__$1;
(statearr_4146_4167[(2)] = null);

(statearr_4146_4167[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4143 === (4))){
var inst_4122 = (state_4142[(8)]);
var inst_4122__$1 = (state_4142[(2)]);
var inst_4123 = (inst_4122__$1 == null);
var inst_4124 = cljs.core.not.call(null,inst_4123);
var state_4142__$1 = (function (){var statearr_4147 = state_4142;
(statearr_4147[(8)] = inst_4122__$1);

return statearr_4147;
})();
if(inst_4124){
var statearr_4148_4168 = state_4142__$1;
(statearr_4148_4168[(1)] = (5));

} else {
var statearr_4149_4169 = state_4142__$1;
(statearr_4149_4169[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4143 === (6))){
var state_4142__$1 = state_4142;
var statearr_4150_4170 = state_4142__$1;
(statearr_4150_4170[(2)] = null);

(statearr_4150_4170[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4143 === (3))){
var inst_4139 = (state_4142[(2)]);
var inst_4140 = cljs.core.async.close_BANG_.call(null,out);
var state_4142__$1 = (function (){var statearr_4151 = state_4142;
(statearr_4151[(9)] = inst_4139);

return statearr_4151;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4142__$1,inst_4140);
} else {
if((state_val_4143 === (2))){
var state_4142__$1 = state_4142;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4142__$1,(4),ch);
} else {
if((state_val_4143 === (11))){
var inst_4122 = (state_4142[(8)]);
var inst_4131 = (state_4142[(2)]);
var inst_4119 = inst_4122;
var state_4142__$1 = (function (){var statearr_4152 = state_4142;
(statearr_4152[(10)] = inst_4131);

(statearr_4152[(7)] = inst_4119);

return statearr_4152;
})();
var statearr_4153_4171 = state_4142__$1;
(statearr_4153_4171[(2)] = null);

(statearr_4153_4171[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4143 === (9))){
var inst_4122 = (state_4142[(8)]);
var state_4142__$1 = state_4142;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4142__$1,(11),out,inst_4122);
} else {
if((state_val_4143 === (5))){
var inst_4122 = (state_4142[(8)]);
var inst_4119 = (state_4142[(7)]);
var inst_4126 = cljs.core._EQ_.call(null,inst_4122,inst_4119);
var state_4142__$1 = state_4142;
if(inst_4126){
var statearr_4155_4172 = state_4142__$1;
(statearr_4155_4172[(1)] = (8));

} else {
var statearr_4156_4173 = state_4142__$1;
(statearr_4156_4173[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4143 === (10))){
var inst_4134 = (state_4142[(2)]);
var state_4142__$1 = state_4142;
var statearr_4157_4174 = state_4142__$1;
(statearr_4157_4174[(2)] = inst_4134);

(statearr_4157_4174[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4143 === (8))){
var inst_4119 = (state_4142[(7)]);
var tmp4154 = inst_4119;
var inst_4119__$1 = tmp4154;
var state_4142__$1 = (function (){var statearr_4158 = state_4142;
(statearr_4158[(7)] = inst_4119__$1);

return statearr_4158;
})();
var statearr_4159_4175 = state_4142__$1;
(statearr_4159_4175[(2)] = null);

(statearr_4159_4175[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___4165,out))
;
return ((function (switch__2334__auto__,c__2429__auto___4165,out){
return (function() {
var cljs$core$async$state_machine__2335__auto__ = null;
var cljs$core$async$state_machine__2335__auto____0 = (function (){
var statearr_4160 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_4160[(0)] = cljs$core$async$state_machine__2335__auto__);

(statearr_4160[(1)] = (1));

return statearr_4160;
});
var cljs$core$async$state_machine__2335__auto____1 = (function (state_4142){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_4142);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e4161){if((e4161 instanceof Object)){
var ex__2338__auto__ = e4161;
var statearr_4162_4176 = state_4142;
(statearr_4162_4176[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4142);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4161;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4177 = state_4142;
state_4142 = G__4177;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$state_machine__2335__auto__ = function(state_4142){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2335__auto____1.call(this,state_4142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2335__auto____0;
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2335__auto____1;
return cljs$core$async$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___4165,out))
})();
var state__2431__auto__ = (function (){var statearr_4163 = f__2430__auto__.call(null);
(statearr_4163[(6)] = c__2429__auto___4165);

return statearr_4163;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___4165,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__4179 = arguments.length;
switch (G__4179) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2429__auto___4245 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___4245,out){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___4245,out){
return (function (state_4217){
var state_val_4218 = (state_4217[(1)]);
if((state_val_4218 === (7))){
var inst_4213 = (state_4217[(2)]);
var state_4217__$1 = state_4217;
var statearr_4219_4246 = state_4217__$1;
(statearr_4219_4246[(2)] = inst_4213);

(statearr_4219_4246[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4218 === (1))){
var inst_4180 = (new Array(n));
var inst_4181 = inst_4180;
var inst_4182 = (0);
var state_4217__$1 = (function (){var statearr_4220 = state_4217;
(statearr_4220[(7)] = inst_4182);

(statearr_4220[(8)] = inst_4181);

return statearr_4220;
})();
var statearr_4221_4247 = state_4217__$1;
(statearr_4221_4247[(2)] = null);

(statearr_4221_4247[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4218 === (4))){
var inst_4185 = (state_4217[(9)]);
var inst_4185__$1 = (state_4217[(2)]);
var inst_4186 = (inst_4185__$1 == null);
var inst_4187 = cljs.core.not.call(null,inst_4186);
var state_4217__$1 = (function (){var statearr_4222 = state_4217;
(statearr_4222[(9)] = inst_4185__$1);

return statearr_4222;
})();
if(inst_4187){
var statearr_4223_4248 = state_4217__$1;
(statearr_4223_4248[(1)] = (5));

} else {
var statearr_4224_4249 = state_4217__$1;
(statearr_4224_4249[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4218 === (15))){
var inst_4207 = (state_4217[(2)]);
var state_4217__$1 = state_4217;
var statearr_4225_4250 = state_4217__$1;
(statearr_4225_4250[(2)] = inst_4207);

(statearr_4225_4250[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4218 === (13))){
var state_4217__$1 = state_4217;
var statearr_4226_4251 = state_4217__$1;
(statearr_4226_4251[(2)] = null);

(statearr_4226_4251[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4218 === (6))){
var inst_4182 = (state_4217[(7)]);
var inst_4203 = (inst_4182 > (0));
var state_4217__$1 = state_4217;
if(cljs.core.truth_(inst_4203)){
var statearr_4227_4252 = state_4217__$1;
(statearr_4227_4252[(1)] = (12));

} else {
var statearr_4228_4253 = state_4217__$1;
(statearr_4228_4253[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4218 === (3))){
var inst_4215 = (state_4217[(2)]);
var state_4217__$1 = state_4217;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4217__$1,inst_4215);
} else {
if((state_val_4218 === (12))){
var inst_4181 = (state_4217[(8)]);
var inst_4205 = cljs.core.vec.call(null,inst_4181);
var state_4217__$1 = state_4217;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4217__$1,(15),out,inst_4205);
} else {
if((state_val_4218 === (2))){
var state_4217__$1 = state_4217;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4217__$1,(4),ch);
} else {
if((state_val_4218 === (11))){
var inst_4197 = (state_4217[(2)]);
var inst_4198 = (new Array(n));
var inst_4181 = inst_4198;
var inst_4182 = (0);
var state_4217__$1 = (function (){var statearr_4229 = state_4217;
(statearr_4229[(10)] = inst_4197);

(statearr_4229[(7)] = inst_4182);

(statearr_4229[(8)] = inst_4181);

return statearr_4229;
})();
var statearr_4230_4254 = state_4217__$1;
(statearr_4230_4254[(2)] = null);

(statearr_4230_4254[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4218 === (9))){
var inst_4181 = (state_4217[(8)]);
var inst_4195 = cljs.core.vec.call(null,inst_4181);
var state_4217__$1 = state_4217;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4217__$1,(11),out,inst_4195);
} else {
if((state_val_4218 === (5))){
var inst_4185 = (state_4217[(9)]);
var inst_4182 = (state_4217[(7)]);
var inst_4181 = (state_4217[(8)]);
var inst_4190 = (state_4217[(11)]);
var inst_4189 = (inst_4181[inst_4182] = inst_4185);
var inst_4190__$1 = (inst_4182 + (1));
var inst_4191 = (inst_4190__$1 < n);
var state_4217__$1 = (function (){var statearr_4231 = state_4217;
(statearr_4231[(12)] = inst_4189);

(statearr_4231[(11)] = inst_4190__$1);

return statearr_4231;
})();
if(cljs.core.truth_(inst_4191)){
var statearr_4232_4255 = state_4217__$1;
(statearr_4232_4255[(1)] = (8));

} else {
var statearr_4233_4256 = state_4217__$1;
(statearr_4233_4256[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4218 === (14))){
var inst_4210 = (state_4217[(2)]);
var inst_4211 = cljs.core.async.close_BANG_.call(null,out);
var state_4217__$1 = (function (){var statearr_4235 = state_4217;
(statearr_4235[(13)] = inst_4210);

return statearr_4235;
})();
var statearr_4236_4257 = state_4217__$1;
(statearr_4236_4257[(2)] = inst_4211);

(statearr_4236_4257[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4218 === (10))){
var inst_4201 = (state_4217[(2)]);
var state_4217__$1 = state_4217;
var statearr_4237_4258 = state_4217__$1;
(statearr_4237_4258[(2)] = inst_4201);

(statearr_4237_4258[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4218 === (8))){
var inst_4181 = (state_4217[(8)]);
var inst_4190 = (state_4217[(11)]);
var tmp4234 = inst_4181;
var inst_4181__$1 = tmp4234;
var inst_4182 = inst_4190;
var state_4217__$1 = (function (){var statearr_4238 = state_4217;
(statearr_4238[(7)] = inst_4182);

(statearr_4238[(8)] = inst_4181__$1);

return statearr_4238;
})();
var statearr_4239_4259 = state_4217__$1;
(statearr_4239_4259[(2)] = null);

(statearr_4239_4259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___4245,out))
;
return ((function (switch__2334__auto__,c__2429__auto___4245,out){
return (function() {
var cljs$core$async$state_machine__2335__auto__ = null;
var cljs$core$async$state_machine__2335__auto____0 = (function (){
var statearr_4240 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4240[(0)] = cljs$core$async$state_machine__2335__auto__);

(statearr_4240[(1)] = (1));

return statearr_4240;
});
var cljs$core$async$state_machine__2335__auto____1 = (function (state_4217){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_4217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e4241){if((e4241 instanceof Object)){
var ex__2338__auto__ = e4241;
var statearr_4242_4260 = state_4217;
(statearr_4242_4260[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4217);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4241;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4261 = state_4217;
state_4217 = G__4261;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$state_machine__2335__auto__ = function(state_4217){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2335__auto____1.call(this,state_4217);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2335__auto____0;
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2335__auto____1;
return cljs$core$async$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___4245,out))
})();
var state__2431__auto__ = (function (){var statearr_4243 = f__2430__auto__.call(null);
(statearr_4243[(6)] = c__2429__auto___4245);

return statearr_4243;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___4245,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__4263 = arguments.length;
switch (G__4263) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__2429__auto___4333 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___4333,out){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___4333,out){
return (function (state_4305){
var state_val_4306 = (state_4305[(1)]);
if((state_val_4306 === (7))){
var inst_4301 = (state_4305[(2)]);
var state_4305__$1 = state_4305;
var statearr_4307_4334 = state_4305__$1;
(statearr_4307_4334[(2)] = inst_4301);

(statearr_4307_4334[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4306 === (1))){
var inst_4264 = [];
var inst_4265 = inst_4264;
var inst_4266 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_4305__$1 = (function (){var statearr_4308 = state_4305;
(statearr_4308[(7)] = inst_4265);

(statearr_4308[(8)] = inst_4266);

return statearr_4308;
})();
var statearr_4309_4335 = state_4305__$1;
(statearr_4309_4335[(2)] = null);

(statearr_4309_4335[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4306 === (4))){
var inst_4269 = (state_4305[(9)]);
var inst_4269__$1 = (state_4305[(2)]);
var inst_4270 = (inst_4269__$1 == null);
var inst_4271 = cljs.core.not.call(null,inst_4270);
var state_4305__$1 = (function (){var statearr_4310 = state_4305;
(statearr_4310[(9)] = inst_4269__$1);

return statearr_4310;
})();
if(inst_4271){
var statearr_4311_4336 = state_4305__$1;
(statearr_4311_4336[(1)] = (5));

} else {
var statearr_4312_4337 = state_4305__$1;
(statearr_4312_4337[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4306 === (15))){
var inst_4295 = (state_4305[(2)]);
var state_4305__$1 = state_4305;
var statearr_4313_4338 = state_4305__$1;
(statearr_4313_4338[(2)] = inst_4295);

(statearr_4313_4338[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4306 === (13))){
var state_4305__$1 = state_4305;
var statearr_4314_4339 = state_4305__$1;
(statearr_4314_4339[(2)] = null);

(statearr_4314_4339[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4306 === (6))){
var inst_4265 = (state_4305[(7)]);
var inst_4290 = inst_4265.length;
var inst_4291 = (inst_4290 > (0));
var state_4305__$1 = state_4305;
if(cljs.core.truth_(inst_4291)){
var statearr_4315_4340 = state_4305__$1;
(statearr_4315_4340[(1)] = (12));

} else {
var statearr_4316_4341 = state_4305__$1;
(statearr_4316_4341[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4306 === (3))){
var inst_4303 = (state_4305[(2)]);
var state_4305__$1 = state_4305;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_4305__$1,inst_4303);
} else {
if((state_val_4306 === (12))){
var inst_4265 = (state_4305[(7)]);
var inst_4293 = cljs.core.vec.call(null,inst_4265);
var state_4305__$1 = state_4305;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4305__$1,(15),out,inst_4293);
} else {
if((state_val_4306 === (2))){
var state_4305__$1 = state_4305;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_4305__$1,(4),ch);
} else {
if((state_val_4306 === (11))){
var inst_4269 = (state_4305[(9)]);
var inst_4273 = (state_4305[(10)]);
var inst_4283 = (state_4305[(2)]);
var inst_4284 = [];
var inst_4285 = inst_4284.push(inst_4269);
var inst_4265 = inst_4284;
var inst_4266 = inst_4273;
var state_4305__$1 = (function (){var statearr_4317 = state_4305;
(statearr_4317[(11)] = inst_4283);

(statearr_4317[(7)] = inst_4265);

(statearr_4317[(8)] = inst_4266);

(statearr_4317[(12)] = inst_4285);

return statearr_4317;
})();
var statearr_4318_4342 = state_4305__$1;
(statearr_4318_4342[(2)] = null);

(statearr_4318_4342[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4306 === (9))){
var inst_4265 = (state_4305[(7)]);
var inst_4281 = cljs.core.vec.call(null,inst_4265);
var state_4305__$1 = state_4305;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_4305__$1,(11),out,inst_4281);
} else {
if((state_val_4306 === (5))){
var inst_4269 = (state_4305[(9)]);
var inst_4273 = (state_4305[(10)]);
var inst_4266 = (state_4305[(8)]);
var inst_4273__$1 = f.call(null,inst_4269);
var inst_4274 = cljs.core._EQ_.call(null,inst_4273__$1,inst_4266);
var inst_4275 = cljs.core.keyword_identical_QMARK_.call(null,inst_4266,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_4276 = ((inst_4274) || (inst_4275));
var state_4305__$1 = (function (){var statearr_4319 = state_4305;
(statearr_4319[(10)] = inst_4273__$1);

return statearr_4319;
})();
if(cljs.core.truth_(inst_4276)){
var statearr_4320_4343 = state_4305__$1;
(statearr_4320_4343[(1)] = (8));

} else {
var statearr_4321_4344 = state_4305__$1;
(statearr_4321_4344[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4306 === (14))){
var inst_4298 = (state_4305[(2)]);
var inst_4299 = cljs.core.async.close_BANG_.call(null,out);
var state_4305__$1 = (function (){var statearr_4323 = state_4305;
(statearr_4323[(13)] = inst_4298);

return statearr_4323;
})();
var statearr_4324_4345 = state_4305__$1;
(statearr_4324_4345[(2)] = inst_4299);

(statearr_4324_4345[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4306 === (10))){
var inst_4288 = (state_4305[(2)]);
var state_4305__$1 = state_4305;
var statearr_4325_4346 = state_4305__$1;
(statearr_4325_4346[(2)] = inst_4288);

(statearr_4325_4346[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_4306 === (8))){
var inst_4265 = (state_4305[(7)]);
var inst_4269 = (state_4305[(9)]);
var inst_4273 = (state_4305[(10)]);
var inst_4278 = inst_4265.push(inst_4269);
var tmp4322 = inst_4265;
var inst_4265__$1 = tmp4322;
var inst_4266 = inst_4273;
var state_4305__$1 = (function (){var statearr_4326 = state_4305;
(statearr_4326[(7)] = inst_4265__$1);

(statearr_4326[(8)] = inst_4266);

(statearr_4326[(14)] = inst_4278);

return statearr_4326;
})();
var statearr_4327_4347 = state_4305__$1;
(statearr_4327_4347[(2)] = null);

(statearr_4327_4347[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___4333,out))
;
return ((function (switch__2334__auto__,c__2429__auto___4333,out){
return (function() {
var cljs$core$async$state_machine__2335__auto__ = null;
var cljs$core$async$state_machine__2335__auto____0 = (function (){
var statearr_4328 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_4328[(0)] = cljs$core$async$state_machine__2335__auto__);

(statearr_4328[(1)] = (1));

return statearr_4328;
});
var cljs$core$async$state_machine__2335__auto____1 = (function (state_4305){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_4305);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e4329){if((e4329 instanceof Object)){
var ex__2338__auto__ = e4329;
var statearr_4330_4348 = state_4305;
(statearr_4330_4348[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_4305);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e4329;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__4349 = state_4305;
state_4305 = G__4349;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
cljs$core$async$state_machine__2335__auto__ = function(state_4305){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__2335__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__2335__auto____1.call(this,state_4305);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__2335__auto____0;
cljs$core$async$state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__2335__auto____1;
return cljs$core$async$state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___4333,out))
})();
var state__2431__auto__ = (function (){var statearr_4331 = f__2430__auto__.call(null);
(statearr_4331[(6)] = c__2429__auto___4333);

return statearr_4331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___4333,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map
