// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.pages.developer.tools');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('bluegenes.pages.developer.events');
goog.require('bluegenes.pages.developer.subs');
bluegenes.pages.developer.tools.page_types = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"report-page","report-page",-1163609257),"Report page",new cljs.core.Keyword(null,"list-results-page","list-results-page",202795974),"List results page"], null);
bluegenes.pages.developer.tools.tool_types = new cljs.core.PersistentArrayMap(null, 7, ["id",new cljs.core.Keyword(null,"report-page","report-page",-1163609257),"ids",new cljs.core.Keyword(null,"list-results-page","list-results-page",202795974),"list",new cljs.core.Keyword(null,"list-results-page","list-results-page",202795974),"lists",new cljs.core.Keyword(null,"list-results-page","list-results-page",202795974),"records",new cljs.core.Keyword(null,"list-results-page","list-results-page",202795974),"rows",new cljs.core.Keyword(null,"list-results-page","list-results-page",202795974),"query",new cljs.core.Keyword(null,"list-results-page","list-results-page",202795974)], null);
/**
 * Check what classes pages a given tool will be able to display on. Currently somewhat defunct, given that we only have report page tools, but will come in handy when we extend to the list results page.
 */
bluegenes.pages.developer.tools.get_tool_types = (function bluegenes$pages$developer$tools$get_tool_types(tool){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991)], null),cljs.core.map.call(null,(function (tool_type){
var the_type = cljs.core.get.call(null,bluegenes.pages.developer.tools.tool_types,tool_type);
return cljs.core.get.call(null,bluegenes.pages.developer.tools.page_types,the_type);
}),cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"accepts","accepts",1429714104)], null))));
});
/**
 * Show all object type classes a single tool will be displayed for. 
 */
bluegenes.pages.developer.tools.output_tool_classes = (function bluegenes$pages$developer$tools$output_tool_classes(classes){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tool-class","div.tool-class",-128190214),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h3","h3",2067611163),"This tool will display on the following page types:"], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403)], null),cljs.core.map.call(null,(function (the_class){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),["type-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(the_class)].join('')], null),the_class], null);
}),classes))], null);
});
/**
 * Display all tool types to the user.
 */
bluegenes.pages.developer.tools.tool_list = (function bluegenes$pages$developer$tools$tool_list(){
var tools = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.developer.subs","tools","bluegenes.pages.developer.subs/tools",1838690179)], null));
console.log("%c@tools","color:mediumorchid;font-weight:bold;",cljs.core.clj__GT_js.call(null,cljs.core.deref.call(null,tools)));

return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tool-list","div.tool-list",175169912)], null),cljs.core.map.call(null,((function (tools){
return (function (tool){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tool","div.tool",-666931346),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h2","h2",-372662728),cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"names","names",-1943074658),new cljs.core.Keyword(null,"human","human",-772334390)], null))], null),(cljs.core.truth_(new cljs.core.Keyword(null,"hasimage","hasimage",884676303).cljs$core$IFn$_invoke$arity$1(tool))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tool-preview","div.tool-preview",144950705),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),new cljs.core.Keyword(null,"hasimage","hasimage",884676303).cljs$core$IFn$_invoke$arity$1(tool),new cljs.core.Keyword(null,"height","height",1025178622),"220px"], null)], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tool-no-preview","div.tool-no-preview",218715198),"No tool preview available"], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.details","div.details",-1501667044),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.description","div.description",1049154676),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-info","svg.icon.icon-info",-297708043),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-info"], null)], null)], null),cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"package","package",1189062786),new cljs.core.Keyword(null,"description","description",-1428560544)], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.developer.tools.output_tool_classes,cljs.core.get_in.call(null,tool,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"classes","classes",2037804510)], null))], null)], null)], null);
});})(tools))
,new cljs.core.Keyword(null,"tools","tools",-1241731990).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,tools))));
});
/**
 * Page structure for tool store UI
 */
bluegenes.pages.developer.tools.tool_store = (function bluegenes$pages$developer$tools$tool_store(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.tool-store","div.tool-store",-1745586606),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h1","h1",-1896887462),"Tool Store"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.info","div.info",-1023482078),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-info","svg.icon.icon-info",-297708043),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-info"], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"Showing all tools that are currently installed for Report Pages. To add more tools, see the ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),"https://github.com/intermine/bluegenes/tree/dev/docs"], null),"BlueGenes Documentation"], null),"."], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.pages.developer.tools.tool_list], null)], null)], null);
});

//# sourceMappingURL=tools.js.map
