// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.components.ui.constraint');
goog.require('cljs.core');
goog.require('imcljs.path');
goog.require('re_frame.core');
goog.require('oops.core');
goog.require('clojure.string');
goog.require('bluegenes.components.loader');
goog.require('reagent.core');
goog.require('dommy.core');
goog.require('bluegenes.components.ui.list_dropdown');
bluegenes.components.ui.constraint.operators = new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"LOOKUP",new cljs.core.Keyword(null,"label","label",1718410804),"Lookup",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"IN",new cljs.core.Keyword(null,"label","label",1718410804),"In list",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"NOT IN",new cljs.core.Keyword(null,"label","label",1718410804),"Not in list",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"=",new cljs.core.Keyword(null,"label","label",1718410804),"=",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["java.lang.String","java.lang.Boolean","java.lang.Integer","java.lang.Double","java.lang.Float"], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"!=",new cljs.core.Keyword(null,"label","label",1718410804),"!=",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["java.lang.String","java.lang.Boolean","java.lang.Integer","java.lang.Double","java.lang.Float"], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"CONTAINS",new cljs.core.Keyword(null,"label","label",1718410804),"Contains",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["java.lang.String"], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"<",new cljs.core.Keyword(null,"label","label",1718410804),"<",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["java.lang.Integer","java.lang.Double","java.lang.Float"], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"<=",new cljs.core.Keyword(null,"label","label",1718410804),"<=",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["java.lang.Integer","java.lang.Double","java.lang.Float"], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),">",new cljs.core.Keyword(null,"label","label",1718410804),">",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["java.lang.Integer","java.lang.Double","java.lang.Float"], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),">=",new cljs.core.Keyword(null,"label","label",1718410804),">=",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["java.lang.Integer","java.lang.Double","java.lang.Float"], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"LIKE",new cljs.core.Keyword(null,"label","label",1718410804),"Like",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["java.lang.String"], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"NOT LIKE",new cljs.core.Keyword(null,"label","label",1718410804),"Not like",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["java.lang.String"], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"ONE OF",new cljs.core.Keyword(null,"label","label",1718410804),"One of",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["java.lang.String"], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"op","op",-1882987955),"NONE OF",new cljs.core.Keyword(null,"label","label",1718410804),"None of",new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["java.lang.String"], null)], null)], null);
/**
 * Given a field type (ex java.lang.Double) return all constraint maps that support that type
 */
bluegenes.components.ui.constraint.applies_to_QMARK_ = (function bluegenes$components$ui$constraint$applies_to_QMARK_(type,op){
return cljs.core.some.call(null,cljs.core.true_QMARK_,cljs.core.map.call(null,cljs.core.partial.call(null,cljs.core._EQ_,type),new cljs.core.Keyword(null,"applies-to","applies-to",-1687000823).cljs$core$IFn$_invoke$arity$1(op)));
});
/**
 * Return the label for a given operator.
 *   This looks a little complicated because we want our constraints to have order
 *   so we need to filter the collection, get the first constraint map (they should all be unique anyway)
 *   then gets its label
 */
bluegenes.components.ui.constraint.constraint_label = (function bluegenes$components$ui$constraint$constraint_label(op){
return new cljs.core.Keyword(null,"label","label",1718410804).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,cljs.core.filter.call(null,(function (p1__23285_SHARP_){
return cljs.core._EQ_.call(null,op,new cljs.core.Keyword(null,"op","op",-1882987955).cljs$core$IFn$_invoke$arity$1(p1__23285_SHARP_));
}),bluegenes.components.ui.constraint.operators)));
});
/**
 * Return true v contains a string
 */
bluegenes.components.ui.constraint.has_text_QMARK_ = (function bluegenes$components$ui$constraint$has_text_QMARK_(string,v){
if(cljs.core.truth_(string)){
if(cljs.core.truth_(v)){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,["(?i)",cljs.core.str.cljs$core$IFn$_invoke$arity$1(string)].join('')),v);
} else {
return false;
}
} else {
return true;
}
});
/**
 * Return true if v contains a string and that string is 3 or more characters.
 *   (Silly but it speeds up text filtering)
 */
bluegenes.components.ui.constraint.has_three_matching_letters_QMARK_ = (function bluegenes$components$ui$constraint$has_three_matching_letters_QMARK_(string,v){
if(cljs.core.truth_((function (){var and__4120__auto__ = string;
if(cljs.core.truth_(and__4120__auto__)){
return (cljs.core.count.call(null,string) >= (3));
} else {
return and__4120__auto__;
}
})())){
if(cljs.core.truth_(v)){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,["(?i)",cljs.core.str.cljs$core$IFn$_invoke$arity$1(string)].join('')),v);
} else {
return false;
}
} else {
return false;
}
});
NodeList.prototype.cljs$core$ISeqable$ = cljs.core.PROTOCOL_SENTINEL;

NodeList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (array){
var array__$1 = this;
return cljs.core.array_seq.call(null,array__$1,(0));
});
bluegenes.components.ui.constraint.set_text_value = (function bluegenes$components$ui$constraint$set_text_value(node,value){
if(cljs.core.truth_(node)){
return dommy.core.set_value_BANG_.call(null,(dommy.utils.__GT_Array.call(null,node.getElementsByTagName("input"))[(0)]),value);
} else {
return null;
}
});
/**
 * A component that represents the freeform textbox for String / Lookup constraints
 */
bluegenes.components.ui.constraint.constraint_text_input = (function bluegenes$components$ui$constraint$constraint_text_input(){
var multiselects = reagent.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var focused_QMARK_ = reagent.core.atom.call(null,false);
return ((function (multiselects,focused_QMARK_){
return (function() { 
var G__23327__delegate = function (p__23286){
var map__23287 = p__23286;
var map__23287__$1 = (((((!((map__23287 == null))))?(((((map__23287.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23287.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23287):map__23287);
var x = map__23287__$1;
var on_change = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var on_select_list = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"on-select-list","on-select-list",-1791427492));
var model = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"model","model",331153215));
var path = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var allow_possible_values = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"allow-possible-values","allow-possible-values",1512535684));
var lists = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"lists","lists",-884730684));
var disabled = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
var value = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"value","value",305978217));
var typeahead_QMARK_ = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"typeahead?","typeahead?",1981777322));
var on_blur = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var op = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var possible_values = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"possible-values","possible-values",-819180652));
var code = cljs.core.get.call(null,map__23287__$1,new cljs.core.Keyword(null,"code","code",1586293142));
if(cljs.core.truth_((function (){var and__4120__auto__ = (function (){var and__4120__auto__ = typeahead_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.seq_QMARK_.call(null,possible_values);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(and__4120__auto__)){
return ((cljs.core._EQ_.call(null,op,"=")) || (cljs.core._EQ_.call(null,op,"!=")));
} else {
return and__4120__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.constraint-text-input","div.constraint-text-input",230317411),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(cljs.core.deref.call(null,focused_QMARK_))?"open":null)], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select.form-control","select.form-control",696610397),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled,new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(disabled)?"disabled":null),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4131__auto__ = value;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "";
}
})(),new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_){
return (function (e){
on_change.call(null,(function (){var target_obj_23289 = e;
var _STAR_runtime_state_STAR__orig_val__23292 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23293 = oops.state.prepare_state.call(null,target_obj_23289,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23293;

try{var next_obj_23290 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23289,(0),"target",true))?(target_obj_23289["target"]):null);
var next_obj_23291 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_23290,(0),"value",true))?(next_obj_23290["value"]):null);
return next_obj_23291;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23292;
}})());

return on_blur.call(null,(function (){var target_obj_23294 = e;
var _STAR_runtime_state_STAR__orig_val__23297 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23298 = oops.state.prepare_state.call(null,target_obj_23294,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23298;

try{var next_obj_23295 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23294,(0),"target",true))?(target_obj_23294["target"]):null);
var next_obj_23296 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_23295,(0),"value",true))?(next_obj_23295["value"]):null);
return next_obj_23296;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23297;
}})());
});})(map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_))
], null)], null),(function (){var G__23299 = cljs.core.map.call(null,((function (map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_){
return (function (v){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),v], null),v], null);
});})(map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,possible_values));
if(clojure.string.blank_QMARK_.call(null,value)){
return cljs.core.conj.call(null,G__23299,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),true,new cljs.core.Keyword(null,"value","value",305978217),""], null),["Choose ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clojure.string.join.call(null," > ",cljs.core.take_last.call(null,(2),clojure.string.split.call(null,imcljs.path.friendly.call(null,model,path)," > "))))].join('')], null));
} else {
return G__23299;
}
})())], null);
} else {
if(cljs.core.truth_((function (){var and__4120__auto__ = (function (){var and__4120__auto__ = typeahead_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.seq_QMARK_.call(null,possible_values);
} else {
return and__4120__auto__;
}
})();
if(cljs.core.truth_(and__4120__auto__)){
return ((cljs.core._EQ_.call(null,op,"ONE OF")) || (cljs.core._EQ_.call(null,op,"NONE OF")));
} else {
return and__4120__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.constraint-text-input","div.constraint-text-input",230317411),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(cljs.core.deref.call(null,focused_QMARK_))?"open":null)], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select.form-control","select.form-control",696610397),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"multiple","multiple",1244445549),true,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled,new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(disabled)?"disabled":null),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__4131__auto__ = value;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_){
return (function (e){
var value__$1 = cljs.core.doall.call(null,cljs.core.map.call(null,cljs.core.first,cljs.core.filter.call(null,((function (map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_){
return (function (p__23300){
var vec__23301 = p__23300;
var k = cljs.core.nth.call(null,vec__23301,(0),null);
var elem = cljs.core.nth.call(null,vec__23301,(1),null);
var target_obj_23304 = elem;
var _STAR_runtime_state_STAR__orig_val__23306 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23307 = oops.state.prepare_state.call(null,target_obj_23304,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23307;

try{var next_obj_23305 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23304,(0),"selected",true))?(target_obj_23304["selected"]):null);
return next_obj_23305;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23306;
}});})(map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_))
,cljs.core.deref.call(null,multiselects))));
on_change.call(null,value__$1);

return on_blur.call(null,value__$1);
});})(map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_))
], null)], null),cljs.core.map.call(null,((function (map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_){
return (function (v){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ref","ref",1289896967),((function (map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_){
return (function (e){
if(cljs.core.truth_(e)){
return cljs.core.swap_BANG_.call(null,multiselects,cljs.core.assoc,v,e);
} else {
return null;
}
});})(map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_))
,new cljs.core.Keyword(null,"value","value",305978217),v], null),v], null);
});})(map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_))
,cljs.core.remove.call(null,cljs.core.nil_QMARK_,possible_values)))], null);
} else {
if(((cljs.core._EQ_.call(null,op,"IN")) || (cljs.core._EQ_.call(null,op,"NOT IN")))){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.ui.list_dropdown.list_dropdown,new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled,new cljs.core.Keyword(null,"restrict-type","restrict-type",-607357079),imcljs.path.class$.call(null,model,path),new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_){
return (function (list){
(function (){var or__4131__auto__ = on_select_list;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return on_change;
}
})().call(null,list);

return on_blur.call(null,list);
});})(map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_))
], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input.form-control","input.form-control",-1123419636),cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"disabled","disabled",-1529784218),new cljs.core.Keyword(null,"on-focus","on-focus",-13737624),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"on-blur","on-blur",814300747),new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"on-key-down","on-key-down",-1374733765),new cljs.core.Keyword(null,"data-toggle","data-toggle",436966687)],[disabled,((function (map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_){
return (function (e){
return cljs.core.reset_BANG_.call(null,focused_QMARK_,true);
});})(map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_))
,value,((function (map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_){
return (function (e){
on_blur.call(null,(function (){var target_obj_23308 = e;
var _STAR_runtime_state_STAR__orig_val__23311 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23312 = oops.state.prepare_state.call(null,target_obj_23308,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23312;

try{var next_obj_23309 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23308,(0),"target",true))?(target_obj_23308["target"]):null);
var next_obj_23310 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_23309,(0),"value",true))?(next_obj_23309["value"]):null);
return next_obj_23310;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23311;
}})());

return cljs.core.reset_BANG_.call(null,focused_QMARK_,false);
});})(map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_))
,"text",(cljs.core.truth_(disabled)?"disabled":null),((function (map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_){
return (function (e){
return on_change.call(null,(function (){var target_obj_23313 = e;
var _STAR_runtime_state_STAR__orig_val__23316 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23317 = oops.state.prepare_state.call(null,target_obj_23313,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23317;

try{var next_obj_23314 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23313,(0),"target",true))?(target_obj_23313["target"]):null);
var next_obj_23315 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_23314,(0),"value",true))?(next_obj_23314["value"]):null);
return next_obj_23315;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23316;
}})());
});})(map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_))
,((function (map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_){
return (function (e){
if(cljs.core._EQ_.call(null,(function (){var target_obj_23318 = e;
var _STAR_runtime_state_STAR__orig_val__23320 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23321 = oops.state.prepare_state.call(null,target_obj_23318,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23321;

try{var next_obj_23319 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23318,(0),"keyCode",true))?(target_obj_23318["keyCode"]):null);
return next_obj_23319;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23320;
}})(),(13))){
on_blur.call(null,(function (){var target_obj_23322 = e;
var _STAR_runtime_state_STAR__orig_val__23325 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23326 = oops.state.prepare_state.call(null,target_obj_23322,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23326;

try{var next_obj_23323 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23322,(0),"target",true))?(target_obj_23322["target"]):null);
var next_obj_23324 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_23323,(0),"value",true))?(next_obj_23323["value"]):null);
return next_obj_23324;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23325;
}})());

return cljs.core.reset_BANG_.call(null,focused_QMARK_,false);
} else {
return null;
}
});})(map__23287,map__23287__$1,x,on_change,on_select_list,model,path,allow_possible_values,lists,disabled,value,typeahead_QMARK_,on_blur,op,possible_values,code,multiselects,focused_QMARK_))
,"none"])], null);

}
}
}
};
var G__23327 = function (var_args){
var p__23286 = null;
if (arguments.length > 0) {
var G__23328__i = 0, G__23328__a = new Array(arguments.length -  0);
while (G__23328__i < G__23328__a.length) {G__23328__a[G__23328__i] = arguments[G__23328__i + 0]; ++G__23328__i;}
  p__23286 = new cljs.core.IndexedSeq(G__23328__a,0,null);
} 
return G__23327__delegate.call(this,p__23286);};
G__23327.cljs$lang$maxFixedArity = 0;
G__23327.cljs$lang$applyTo = (function (arglist__23329){
var p__23286 = cljs.core.seq(arglist__23329);
return G__23327__delegate(p__23286);
});
G__23327.cljs$core$IFn$_invoke$arity$variadic = G__23327__delegate;
return G__23327;
})()
;
;})(multiselects,focused_QMARK_))
});
bluegenes.components.ui.constraint.one_of_QMARK_ = (function bluegenes$components$ui$constraint$one_of_QMARK_(value,col){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([value]),col) == null)));
});
bluegenes.components.ui.constraint.not_one_of_QMARK_ = cljs.core.complement.call(null,bluegenes.components.ui.constraint.one_of_QMARK_);
bluegenes.components.ui.constraint.constraint_operator = (function bluegenes$components$ui$constraint$constraint_operator(){

return (function() { 
var G__23352__delegate = function (p__23330){
var map__23331 = p__23330;
var map__23331__$1 = (((((!((map__23331 == null))))?(((((map__23331.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23331.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23331):map__23331);
var model = cljs.core.get.call(null,map__23331__$1,new cljs.core.Keyword(null,"model","model",331153215));
var path = cljs.core.get.call(null,map__23331__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var op = cljs.core.get.call(null,map__23331__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var on_change = cljs.core.get.call(null,map__23331__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var on_blur = cljs.core.get.call(null,map__23331__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var lists = cljs.core.get.call(null,map__23331__$1,new cljs.core.Keyword(null,"lists","lists",-884730684));
var disabled = cljs.core.get.call(null,map__23331__$1,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
var value = cljs.core.get.call(null,map__23331__$1,new cljs.core.Keyword(null,"value","value",305978217));
var path_class = imcljs.path.class$.call(null,model,path);
var any_lists_with_class_QMARK_ = (!((cljs.core.some.call(null,((function (path_class,map__23331,map__23331__$1,model,path,op,on_change,on_blur,lists,disabled,value){
return (function (list){
return cljs.core._EQ_.call(null,path_class,cljs.core.keyword.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(list)));
});})(path_class,map__23331,map__23331__$1,model,path,op,on_change,on_blur,lists,disabled,value))
,lists) == null)));
var disable_lists_QMARK_ = (function (){var and__4120__auto__ = lists;
if(cljs.core.truth_(and__4120__auto__)){
return (!(any_lists_with_class_QMARK_));
} else {
return and__4120__auto__;
}
})();
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select.form-control.constraint-chooser","select.form-control.constraint-chooser",-1881361622),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled,new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(disabled)?"disabled":null),new cljs.core.Keyword(null,"value","value",305978217),op,new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (path_class,any_lists_with_class_QMARK_,disable_lists_QMARK_,map__23331,map__23331__$1,model,path,op,on_change,on_blur,lists,disabled,value){
return (function (e){
var new_op = (function (){var target_obj_23333 = e;
var _STAR_runtime_state_STAR__orig_val__23336 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23337 = oops.state.prepare_state.call(null,target_obj_23333,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23337;

try{var next_obj_23334 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23333,(0),"target",true))?(target_obj_23333["target"]):null);
var next_obj_23335 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_23334,(0),"value",true))?(next_obj_23334["value"]):null);
return next_obj_23335;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23336;
}})();
on_change.call(null,(function (){var target_obj_23338 = e;
var _STAR_runtime_state_STAR__orig_val__23341 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23342 = oops.state.prepare_state.call(null,target_obj_23338,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23342;

try{var next_obj_23339 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23338,(0),"target",true))?(target_obj_23338["target"]):null);
var next_obj_23340 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_23339,(0),"value",true))?(next_obj_23339["value"]):null);
return next_obj_23340;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23341;
}})());

if(cljs.core.truth_((function (){var and__4120__auto__ = bluegenes.components.ui.constraint.one_of_QMARK_.call(null,new_op,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["IN","NOT IN"], null));
if(and__4120__auto__){
return bluegenes.components.ui.constraint.not_one_of_QMARK_.call(null,op,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["IN","NOT IN"], null));
} else {
return and__4120__auto__;
}
})())){
return null;
} else {
return on_blur.call(null,(function (){var target_obj_23343 = e;
var _STAR_runtime_state_STAR__orig_val__23346 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__23347 = oops.state.prepare_state.call(null,target_obj_23343,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__23347;

try{var next_obj_23344 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_23343,(0),"target",true))?(target_obj_23343["target"]):null);
var next_obj_23345 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_23344,(0),"value",true))?(next_obj_23344["value"]):null);
return next_obj_23345;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__23346;
}})());
}
});})(path_class,any_lists_with_class_QMARK_,disable_lists_QMARK_,map__23331,map__23331__$1,model,path,op,on_change,on_blur,lists,disabled,value))
], null)], null),(function (){var $ = bluegenes.components.ui.constraint.operators;
var $__$1 = cljs.core.filter.call(null,cljs.core.partial.call(null,bluegenes.components.ui.constraint.applies_to_QMARK_,imcljs.path.data_type.call(null,model,path)),$);
var $__$2 = cljs.core.map.call(null,((function ($,$__$1,path_class,any_lists_with_class_QMARK_,disable_lists_QMARK_,map__23331,map__23331__$1,model,path,op,on_change,on_blur,lists,disabled,value){
return (function (p__23348){
var map__23349 = p__23348;
var map__23349__$1 = (((((!((map__23349 == null))))?(((((map__23349.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23349.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23349):map__23349);
var operator = map__23349__$1;
var op__$1 = cljs.core.get.call(null,map__23349__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var label = cljs.core.get.call(null,map__23349__$1,new cljs.core.Keyword(null,"label","label",1718410804));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),op__$1], null),label], null);
});})($,$__$1,path_class,any_lists_with_class_QMARK_,disable_lists_QMARK_,map__23331,map__23331__$1,model,path,op,on_change,on_blur,lists,disabled,value))
,$__$1);
var G__23351 = $__$2;
if(cljs.core.truth_((function (){var and__4120__auto__ = disable_lists_QMARK_;
if(cljs.core.truth_(and__4120__auto__)){
return (imcljs.path.data_type.call(null,model,path) == null);
} else {
return and__4120__auto__;
}
})())){
return cljs.core.concat.call(null,G__23351,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),"disabled"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),["(No ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"displayName","displayName",-809144601).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,imcljs.path.walk.call(null,model,cljs.core.name.call(null,path_class)))))," lists)"].join('')], null)], null)], null));
} else {
return G__23351;
}
})());
};
var G__23352 = function (var_args){
var p__23330 = null;
if (arguments.length > 0) {
var G__23353__i = 0, G__23353__a = new Array(arguments.length -  0);
while (G__23353__i < G__23353__a.length) {G__23353__a[G__23353__i] = arguments[G__23353__i + 0]; ++G__23353__i;}
  p__23330 = new cljs.core.IndexedSeq(G__23353__a,0,null);
} 
return G__23352__delegate.call(this,p__23330);};
G__23352.cljs$lang$maxFixedArity = 0;
G__23352.cljs$lang$applyTo = (function (arglist__23354){
var p__23330 = cljs.core.seq(arglist__23354);
return G__23352__delegate(p__23330);
});
G__23352.cljs$core$IFn$_invoke$arity$variadic = G__23352__delegate;
return G__23352;
})()
;
});
bluegenes.components.ui.constraint.constraint = (function bluegenes$components$ui$constraint$constraint(var_args){
var args__4736__auto__ = [];
var len__4730__auto___23366 = arguments.length;
var i__4731__auto___23367 = (0);
while(true){
if((i__4731__auto___23367 < len__4730__auto___23366)){
args__4736__auto__.push((arguments[i__4731__auto___23367]));

var G__23368 = (i__4731__auto___23367 + (1));
i__4731__auto___23367 = G__23368;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return bluegenes.components.ui.constraint.constraint.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

bluegenes.components.ui.constraint.constraint.cljs$core$IFn$_invoke$arity$variadic = (function (p__23356){
var map__23357 = p__23356;
var map__23357__$1 = (((((!((map__23357 == null))))?(((((map__23357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23357.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23357):map__23357);
var model = cljs.core.get.call(null,map__23357__$1,new cljs.core.Keyword(null,"model","model",331153215));
var path = cljs.core.get.call(null,map__23357__$1,new cljs.core.Keyword(null,"path","path",-188191168));

var pv = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-possible-values","current-possible-values",-407828006),path], null));
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (pv,map__23357,map__23357__$1,model,path){
return (function (){
if((cljs.core.deref.call(null,pv) == null)){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cache","fetch-possible-values","cache/fetch-possible-values",237476028),path], null));
} else {
return null;
}
});})(pv,map__23357,map__23357__$1,model,path))
,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (pv,map__23357,map__23357__$1,model,path){
return (function() { 
var G__23369__delegate = function (p__23359){
var map__23360 = p__23359;
var map__23360__$1 = (((((!((map__23360 == null))))?(((((map__23360.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23360.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__23360):map__23360);
var con = map__23360__$1;
var on_change = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var on_select_list = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"on-select-list","on-select-list",-1791427492));
var on_remove = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"on-remove","on-remove",-268656163));
var model__$1 = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"model","model",331153215));
var path__$1 = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var hide_code_QMARK_ = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"hide-code?","hide-code?",1496273121));
var lists = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"lists","lists",-884730684));
var on_change_operator = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"on-change-operator","on-change-operator",973101285));
var disabled = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
var value = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"value","value",305978217));
var typeahead_QMARK_ = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"typeahead?","typeahead?",1981777322));
var on_blur = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"on-blur","on-blur",814300747));
var op = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"op","op",-1882987955));
var label_QMARK_ = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"label?","label?",90640173));
var label = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"label","label",1718410804));
var possible_values = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"possible-values","possible-values",-819180652));
var code = cljs.core.get.call(null,map__23360__$1,new cljs.core.Keyword(null,"code","code",1586293142));
var class_QMARK_ = imcljs.path.class_QMARK_.call(null,model__$1,path__$1);
var op__$1 = (function (){var or__4131__auto__ = op;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
if(class_QMARK_){
return "LOOKUP";
} else {
return "=";
}
}
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.constraint-container","div.constraint-container",2087820810),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.row.no-gutter","div.row.no-gutter",1529568524),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col-sm-12","div.col-sm-12",-1900061411),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),label], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.row.no-gutter","div.row.no-gutter",1529568524),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col-sm-4","div.col-sm-4",1703492594),new cljs.core.PersistentVector(null, 17, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.ui.constraint.constraint_operator,new cljs.core.Keyword(null,"model","model",331153215),model__$1,new cljs.core.Keyword(null,"path","path",-188191168),path__$1,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled,new cljs.core.Keyword(null,"op","op",-1882987955),op__$1,new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),((function (class_QMARK_,op__$1,map__23360,map__23360__$1,con,on_change,on_select_list,on_remove,model__$1,path__$1,hide_code_QMARK_,lists,on_change_operator,disabled,value,typeahead_QMARK_,on_blur,op,label_QMARK_,label,possible_values,code,pv,map__23357,map__23357__$1,model,path){
return (function (op__$2){
if(((cljs.core._EQ_.call(null,op__$2,"ONE OF")) || (cljs.core._EQ_.call(null,op__$2,"NONE OF")))){
return (function (){var or__4131__auto__ = on_blur;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return on_change;
}
})().call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"code","code",1586293142),code,new cljs.core.Keyword(null,"path","path",-188191168),path__$1,new cljs.core.Keyword(null,"values","values",372645556),(function (){var G__23362 = value;
if(cljs.core.string_QMARK_){
return (new cljs.core.List(null,G__23362,null,(1),null));
} else {
return G__23362;
}
})(),new cljs.core.Keyword(null,"op","op",-1882987955),op__$2], null));
} else {
return (function (){var or__4131__auto__ = on_blur;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return on_change;
}
})().call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"code","code",1586293142),code,new cljs.core.Keyword(null,"path","path",-188191168),path__$1,new cljs.core.Keyword(null,"value","value",305978217),(function (){var G__23363 = value;
if(cljs.core.seq_QMARK_.call(null,value)){
return cljs.core.first.call(null,G__23363);
} else {
return G__23363;
}
})(),new cljs.core.Keyword(null,"op","op",-1882987955),op__$2], null));
}
});})(class_QMARK_,op__$1,map__23360,map__23360__$1,con,on_change,on_select_list,on_remove,model__$1,path__$1,hide_code_QMARK_,lists,on_change_operator,disabled,value,typeahead_QMARK_,on_blur,op,label_QMARK_,label,possible_values,code,pv,map__23357,map__23357__$1,model,path))
,new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (class_QMARK_,op__$1,map__23360,map__23360__$1,con,on_change,on_select_list,on_remove,model__$1,path__$1,hide_code_QMARK_,lists,on_change_operator,disabled,value,typeahead_QMARK_,on_blur,op,label_QMARK_,label,possible_values,code,pv,map__23357,map__23357__$1,model,path){
return (function (op__$2){
if(((cljs.core._EQ_.call(null,op__$2,"ONE OF")) || (cljs.core._EQ_.call(null,op__$2,"NONE OF")))){
return (function (){var or__4131__auto__ = on_change_operator;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return on_change;
}
})().call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"code","code",1586293142),code,new cljs.core.Keyword(null,"path","path",-188191168),path__$1,new cljs.core.Keyword(null,"values","values",372645556),(function (){var G__23364 = value;
if(cljs.core.string_QMARK_){
return (new cljs.core.List(null,G__23364,null,(1),null));
} else {
return G__23364;
}
})(),new cljs.core.Keyword(null,"op","op",-1882987955),op__$2], null));
} else {
return (function (){var or__4131__auto__ = on_change_operator;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return on_change;
}
})().call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"code","code",1586293142),code,new cljs.core.Keyword(null,"path","path",-188191168),path__$1,new cljs.core.Keyword(null,"value","value",305978217),(function (){var G__23365 = value;
if(cljs.core.seq_QMARK_.call(null,value)){
return cljs.core.first.call(null,G__23365);
} else {
return G__23365;
}
})(),new cljs.core.Keyword(null,"op","op",-1882987955),op__$2], null));
}
});})(class_QMARK_,op__$1,map__23360,map__23360__$1,con,on_change,on_select_list,on_remove,model__$1,path__$1,hide_code_QMARK_,lists,on_change_operator,disabled,value,typeahead_QMARK_,on_blur,op,label_QMARK_,label,possible_values,code,pv,map__23357,map__23357__$1,model,path))
], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.col-sm-8","div.col-sm-8",-1138088481),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null)], null),new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.ui.constraint.constraint_text_input,new cljs.core.Keyword(null,"model","model",331153215),model__$1,new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"op","op",-1882987955),op__$1,new cljs.core.Keyword(null,"on-select-list","on-select-list",-1791427492),on_select_list,new cljs.core.Keyword(null,"typeahead?","typeahead?",1981777322),typeahead_QMARK_,new cljs.core.Keyword(null,"path","path",-188191168),path__$1,new cljs.core.Keyword(null,"code","code",1586293142),code,new cljs.core.Keyword(null,"lists","lists",-884730684),lists,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled,new cljs.core.Keyword(null,"allow-possible-values","allow-possible-values",1512535684),((cljs.core.not_EQ_.call(null,op__$1,"IN")) && (cljs.core.not_EQ_.call(null,op__$1,"NOT IN"))),new cljs.core.Keyword(null,"possible-values","possible-values",-819180652),cljs.core.deref.call(null,pv),new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (class_QMARK_,op__$1,map__23360,map__23360__$1,con,on_change,on_select_list,on_remove,model__$1,path__$1,hide_code_QMARK_,lists,on_change_operator,disabled,value,typeahead_QMARK_,on_blur,op,label_QMARK_,label,possible_values,code,pv,map__23357,map__23357__$1,model,path){
return (function (val){
if((((!((val == null)))) && (((cljs.core._EQ_.call(null,op__$1,"ONE OF")) || (cljs.core._EQ_.call(null,op__$1,"NONE OF")))))){
return on_change.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"path","path",-188191168),path__$1,new cljs.core.Keyword(null,"values","values",372645556),val,new cljs.core.Keyword(null,"op","op",-1882987955),op__$1,new cljs.core.Keyword(null,"code","code",1586293142),code], null));
} else {
return on_change.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"path","path",-188191168),path__$1,new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"op","op",-1882987955),op__$1,new cljs.core.Keyword(null,"code","code",1586293142),code], null));
}
});})(class_QMARK_,op__$1,map__23360,map__23360__$1,con,on_change,on_select_list,on_remove,model__$1,path__$1,hide_code_QMARK_,lists,on_change_operator,disabled,value,typeahead_QMARK_,on_blur,op,label_QMARK_,label,possible_values,code,pv,map__23357,map__23357__$1,model,path))
,new cljs.core.Keyword(null,"on-blur","on-blur",814300747),((function (class_QMARK_,op__$1,map__23360,map__23360__$1,con,on_change,on_select_list,on_remove,model__$1,path__$1,hide_code_QMARK_,lists,on_change_operator,disabled,value,typeahead_QMARK_,on_blur,op,label_QMARK_,label,possible_values,code,pv,map__23357,map__23357__$1,model,path){
return (function (val){
if((((!((val == null)))) && (((cljs.core._EQ_.call(null,op__$1,"ONE OF")) || (cljs.core._EQ_.call(null,op__$1,"NONE OF")))))){
return (function (){var or__4131__auto__ = on_blur;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return on_change;
}
})().call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"path","path",-188191168),path__$1,new cljs.core.Keyword(null,"values","values",372645556),val,new cljs.core.Keyword(null,"op","op",-1882987955),op__$1,new cljs.core.Keyword(null,"code","code",1586293142),code], null));
} else {
return (function (){var or__4131__auto__ = on_blur;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return on_change;
}
})().call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"path","path",-188191168),path__$1,new cljs.core.Keyword(null,"value","value",305978217),val,new cljs.core.Keyword(null,"op","op",-1882987955),op__$1,new cljs.core.Keyword(null,"code","code",1586293142),code], null));
}
});})(class_QMARK_,op__$1,map__23360,map__23360__$1,con,on_change,on_select_list,on_remove,model__$1,path__$1,hide_code_QMARK_,lists,on_change_operator,disabled,value,typeahead_QMARK_,on_blur,op,label_QMARK_,label,possible_values,code,pv,map__23357,map__23357__$1,model,path))
], null),(cljs.core.truth_(on_remove)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-bin","svg.icon.icon-bin",-1121071045),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"position","position",-2011731912),"absolute"], null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (class_QMARK_,op__$1,map__23360,map__23360__$1,con,on_change,on_select_list,on_remove,model__$1,path__$1,hide_code_QMARK_,lists,on_change_operator,disabled,value,typeahead_QMARK_,on_blur,op,label_QMARK_,label,possible_values,code,pv,map__23357,map__23357__$1,model,path){
return (function (op__$2){
return on_remove.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"path","path",-188191168),path__$1,new cljs.core.Keyword(null,"value","value",305978217),value,new cljs.core.Keyword(null,"op","op",-1882987955),op__$2], null));
});})(class_QMARK_,op__$1,map__23360,map__23360__$1,con,on_change,on_select_list,on_remove,model__$1,path__$1,hide_code_QMARK_,lists,on_change_operator,disabled,value,typeahead_QMARK_,on_blur,op,label_QMARK_,label,possible_values,code,pv,map__23357,map__23357__$1,model,path))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-bin"], null)], null)], null):null)], null)], null)], null)], null);
};
var G__23369 = function (var_args){
var p__23359 = null;
if (arguments.length > 0) {
var G__23370__i = 0, G__23370__a = new Array(arguments.length -  0);
while (G__23370__i < G__23370__a.length) {G__23370__a[G__23370__i] = arguments[G__23370__i + 0]; ++G__23370__i;}
  p__23359 = new cljs.core.IndexedSeq(G__23370__a,0,null);
} 
return G__23369__delegate.call(this,p__23359);};
G__23369.cljs$lang$maxFixedArity = 0;
G__23369.cljs$lang$applyTo = (function (arglist__23371){
var p__23359 = cljs.core.seq(arglist__23371);
return G__23369__delegate(p__23359);
});
G__23369.cljs$core$IFn$_invoke$arity$variadic = G__23369__delegate;
return G__23369;
})()
;})(pv,map__23357,map__23357__$1,model,path))
], null));
});

bluegenes.components.ui.constraint.constraint.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
bluegenes.components.ui.constraint.constraint.cljs$lang$applyTo = (function (seq23355){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq23355));
});


//# sourceMappingURL=constraint.js.map
