// Compiled by ClojureScript 1.9.89 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args16514 = [];
var len__13324__auto___16520 = arguments.length;
var i__13325__auto___16521 = (0);
while(true){
if((i__13325__auto___16521 < len__13324__auto___16520)){
args16514.push((arguments[i__13325__auto___16521]));

var G__16522 = (i__13325__auto___16521 + (1));
i__13325__auto___16521 = G__16522;
continue;
} else {
}
break;
}

var G__16516 = args16514.length;
switch (G__16516) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16514.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async16517 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16517 = (function (f,blockable,meta16518){
this.f = f;
this.blockable = blockable;
this.meta16518 = meta16518;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16517.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16519,meta16518__$1){
var self__ = this;
var _16519__$1 = this;
return (new cljs.core.async.t_cljs$core$async16517(self__.f,self__.blockable,meta16518__$1));
});

cljs.core.async.t_cljs$core$async16517.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16519){
var self__ = this;
var _16519__$1 = this;
return self__.meta16518;
});

cljs.core.async.t_cljs$core$async16517.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16517.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16517.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async16517.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async16517.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta16518","meta16518",-1428543177,null)], null);
});

cljs.core.async.t_cljs$core$async16517.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16517.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16517";

cljs.core.async.t_cljs$core$async16517.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cljs.core.async/t_cljs$core$async16517");
});

cljs.core.async.__GT_t_cljs$core$async16517 = (function cljs$core$async$__GT_t_cljs$core$async16517(f__$1,blockable__$1,meta16518){
return (new cljs.core.async.t_cljs$core$async16517(f__$1,blockable__$1,meta16518));
});

}

return (new cljs.core.async.t_cljs$core$async16517(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || (buff.cljs$core$async$impl$protocols$UnblockingBuffer$)){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args16526 = [];
var len__13324__auto___16529 = arguments.length;
var i__13325__auto___16530 = (0);
while(true){
if((i__13325__auto___16530 < len__13324__auto___16529)){
args16526.push((arguments[i__13325__auto___16530]));

var G__16531 = (i__13325__auto___16530 + (1));
i__13325__auto___16530 = G__16531;
continue;
} else {
}
break;
}

var G__16528 = args16526.length;
switch (G__16528) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16526.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args16533 = [];
var len__13324__auto___16536 = arguments.length;
var i__13325__auto___16537 = (0);
while(true){
if((i__13325__auto___16537 < len__13324__auto___16536)){
args16533.push((arguments[i__13325__auto___16537]));

var G__16538 = (i__13325__auto___16537 + (1));
i__13325__auto___16537 = G__16538;
continue;
} else {
}
break;
}

var G__16535 = args16533.length;
switch (G__16535) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16533.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args16540 = [];
var len__13324__auto___16543 = arguments.length;
var i__13325__auto___16544 = (0);
while(true){
if((i__13325__auto___16544 < len__13324__auto___16543)){
args16540.push((arguments[i__13325__auto___16544]));

var G__16545 = (i__13325__auto___16544 + (1));
i__13325__auto___16544 = G__16545;
continue;
} else {
}
break;
}

var G__16542 = args16540.length;
switch (G__16542) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16540.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_16547 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_16547);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_16547,ret){
return (function (){
return fn1.call(null,val_16547);
});})(val_16547,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args16548 = [];
var len__13324__auto___16551 = arguments.length;
var i__13325__auto___16552 = (0);
while(true){
if((i__13325__auto___16552 < len__13324__auto___16551)){
args16548.push((arguments[i__13325__auto___16552]));

var G__16553 = (i__13325__auto___16552 + (1));
i__13325__auto___16552 = G__16553;
continue;
} else {
}
break;
}

var G__16550 = args16548.length;
switch (G__16550) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16548.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__13164__auto___16555 = n;
var x_16556 = (0);
while(true){
if((x_16556 < n__13164__auto___16555)){
(a[x_16556] = (0));

var G__16557 = (x_16556 + (1));
x_16556 = G__16557;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__16558 = (i + (1));
i = G__16558;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async16562 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16562 = (function (alt_flag,flag,meta16563){
this.alt_flag = alt_flag;
this.flag = flag;
this.meta16563 = meta16563;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16562.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_16564,meta16563__$1){
var self__ = this;
var _16564__$1 = this;
return (new cljs.core.async.t_cljs$core$async16562(self__.alt_flag,self__.flag,meta16563__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async16562.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_16564){
var self__ = this;
var _16564__$1 = this;
return self__.meta16563;
});})(flag))
;

cljs.core.async.t_cljs$core$async16562.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16562.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async16562.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16562.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async16562.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-flag","alt-flag",-1794972754,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(cljs.core.PersistentVector.EMPTY))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta16563","meta16563",-1838158851,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async16562.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16562.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16562";

cljs.core.async.t_cljs$core$async16562.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cljs.core.async/t_cljs$core$async16562");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async16562 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async16562(alt_flag__$1,flag__$1,meta16563){
return (new cljs.core.async.t_cljs$core$async16562(alt_flag__$1,flag__$1,meta16563));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async16562(cljs$core$async$alt_flag,flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async16568 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async16568 = (function (alt_handler,flag,cb,meta16569){
this.alt_handler = alt_handler;
this.flag = flag;
this.cb = cb;
this.meta16569 = meta16569;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async16568.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_16570,meta16569__$1){
var self__ = this;
var _16570__$1 = this;
return (new cljs.core.async.t_cljs$core$async16568(self__.alt_handler,self__.flag,self__.cb,meta16569__$1));
});

cljs.core.async.t_cljs$core$async16568.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_16570){
var self__ = this;
var _16570__$1 = this;
return self__.meta16569;
});

cljs.core.async.t_cljs$core$async16568.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async16568.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async16568.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async16568.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async16568.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"alt-handler","alt-handler",963786170,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"private","private",-558947994),true,new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null)], null)))], null)),new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta16569","meta16569",2109483950,null)], null);
});

cljs.core.async.t_cljs$core$async16568.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async16568.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async16568";

cljs.core.async.t_cljs$core$async16568.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cljs.core.async/t_cljs$core$async16568");
});

cljs.core.async.__GT_t_cljs$core$async16568 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async16568(alt_handler__$1,flag__$1,cb__$1,meta16569){
return (new cljs.core.async.t_cljs$core$async16568(alt_handler__$1,flag__$1,cb__$1,meta16569));
});

}

return (new cljs.core.async.t_cljs$core$async16568(cljs$core$async$alt_handler,flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16571_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16571_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__16572_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__16572_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__12249__auto__ = wport;
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return port;
}
})()], null));
} else {
var G__16573 = (i + (1));
i = G__16573;
continue;
}
} else {
return null;
}
break;
}
})();
var or__12249__auto__ = ret;
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__12237__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__12237__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__12237__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__13331__auto__ = [];
var len__13324__auto___16579 = arguments.length;
var i__13325__auto___16580 = (0);
while(true){
if((i__13325__auto___16580 < len__13324__auto___16579)){
args__13331__auto__.push((arguments[i__13325__auto___16580]));

var G__16581 = (i__13325__auto___16580 + (1));
i__13325__auto___16580 = G__16581;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__16576){
var map__16577 = p__16576;
var map__16577__$1 = ((((!((map__16577 == null)))?((((map__16577.cljs$lang$protocol_mask$partition0$ & (64))) || (map__16577.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16577):map__16577);
var opts = map__16577__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq16574){
var G__16575 = cljs.core.first.call(null,seq16574);
var seq16574__$1 = cljs.core.next.call(null,seq16574);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__16575,seq16574__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args16582 = [];
var len__13324__auto___16632 = arguments.length;
var i__13325__auto___16633 = (0);
while(true){
if((i__13325__auto___16633 < len__13324__auto___16632)){
args16582.push((arguments[i__13325__auto___16633]));

var G__16634 = (i__13325__auto___16633 + (1));
i__13325__auto___16633 = G__16634;
continue;
} else {
}
break;
}

var G__16584 = args16582.length;
switch (G__16584) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args16582.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__16469__auto___16636 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___16636){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___16636){
return (function (state_16608){
var state_val_16609 = (state_16608[(1)]);
if((state_val_16609 === (7))){
var inst_16604 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16610_16637 = state_16608__$1;
(statearr_16610_16637[(2)] = inst_16604);

(statearr_16610_16637[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (1))){
var state_16608__$1 = state_16608;
var statearr_16611_16638 = state_16608__$1;
(statearr_16611_16638[(2)] = null);

(statearr_16611_16638[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (4))){
var inst_16587 = (state_16608[(7)]);
var inst_16587__$1 = (state_16608[(2)]);
var inst_16588 = (inst_16587__$1 == null);
var state_16608__$1 = (function (){var statearr_16612 = state_16608;
(statearr_16612[(7)] = inst_16587__$1);

return statearr_16612;
})();
if(cljs.core.truth_(inst_16588)){
var statearr_16613_16639 = state_16608__$1;
(statearr_16613_16639[(1)] = (5));

} else {
var statearr_16614_16640 = state_16608__$1;
(statearr_16614_16640[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (13))){
var state_16608__$1 = state_16608;
var statearr_16615_16641 = state_16608__$1;
(statearr_16615_16641[(2)] = null);

(statearr_16615_16641[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (6))){
var inst_16587 = (state_16608[(7)]);
var state_16608__$1 = state_16608;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16608__$1,(11),to,inst_16587);
} else {
if((state_val_16609 === (3))){
var inst_16606 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16608__$1,inst_16606);
} else {
if((state_val_16609 === (12))){
var state_16608__$1 = state_16608;
var statearr_16616_16642 = state_16608__$1;
(statearr_16616_16642[(2)] = null);

(statearr_16616_16642[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (2))){
var state_16608__$1 = state_16608;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16608__$1,(4),from);
} else {
if((state_val_16609 === (11))){
var inst_16597 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
if(cljs.core.truth_(inst_16597)){
var statearr_16617_16643 = state_16608__$1;
(statearr_16617_16643[(1)] = (12));

} else {
var statearr_16618_16644 = state_16608__$1;
(statearr_16618_16644[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (9))){
var state_16608__$1 = state_16608;
var statearr_16619_16645 = state_16608__$1;
(statearr_16619_16645[(2)] = null);

(statearr_16619_16645[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (5))){
var state_16608__$1 = state_16608;
if(cljs.core.truth_(close_QMARK_)){
var statearr_16620_16646 = state_16608__$1;
(statearr_16620_16646[(1)] = (8));

} else {
var statearr_16621_16647 = state_16608__$1;
(statearr_16621_16647[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (14))){
var inst_16602 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16622_16648 = state_16608__$1;
(statearr_16622_16648[(2)] = inst_16602);

(statearr_16622_16648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (10))){
var inst_16594 = (state_16608[(2)]);
var state_16608__$1 = state_16608;
var statearr_16623_16649 = state_16608__$1;
(statearr_16623_16649[(2)] = inst_16594);

(statearr_16623_16649[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16609 === (8))){
var inst_16591 = cljs.core.async.close_BANG_.call(null,to);
var state_16608__$1 = state_16608;
var statearr_16624_16650 = state_16608__$1;
(statearr_16624_16650[(2)] = inst_16591);

(statearr_16624_16650[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___16636))
;
return ((function (switch__16357__auto__,c__16469__auto___16636){
return (function() {
var cljs$core$async$state_machine__16358__auto__ = null;
var cljs$core$async$state_machine__16358__auto____0 = (function (){
var statearr_16628 = [null,null,null,null,null,null,null,null];
(statearr_16628[(0)] = cljs$core$async$state_machine__16358__auto__);

(statearr_16628[(1)] = (1));

return statearr_16628;
});
var cljs$core$async$state_machine__16358__auto____1 = (function (state_16608){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_16608);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e16629){if((e16629 instanceof Object)){
var ex__16361__auto__ = e16629;
var statearr_16630_16651 = state_16608;
(statearr_16630_16651[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16608);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16629;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__16652 = state_16608;
state_16608 = G__16652;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$state_machine__16358__auto__ = function(state_16608){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16358__auto____1.call(this,state_16608);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16358__auto____0;
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16358__auto____1;
return cljs$core$async$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___16636))
})();
var state__16471__auto__ = (function (){var statearr_16631 = f__16470__auto__.call(null);
(statearr_16631[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___16636);

return statearr_16631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___16636))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__16840){
var vec__16841 = p__16840;
var v = cljs.core.nth.call(null,vec__16841,(0),null);
var p = cljs.core.nth.call(null,vec__16841,(1),null);
var job = vec__16841;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__16469__auto___17027 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___17027,res,vec__16841,v,p,job,jobs,results){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___17027,res,vec__16841,v,p,job,jobs,results){
return (function (state_16848){
var state_val_16849 = (state_16848[(1)]);
if((state_val_16849 === (1))){
var state_16848__$1 = state_16848;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16848__$1,(2),res,v);
} else {
if((state_val_16849 === (2))){
var inst_16845 = (state_16848[(2)]);
var inst_16846 = cljs.core.async.close_BANG_.call(null,res);
var state_16848__$1 = (function (){var statearr_16850 = state_16848;
(statearr_16850[(7)] = inst_16845);

return statearr_16850;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16848__$1,inst_16846);
} else {
return null;
}
}
});})(c__16469__auto___17027,res,vec__16841,v,p,job,jobs,results))
;
return ((function (switch__16357__auto__,c__16469__auto___17027,res,vec__16841,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0 = (function (){
var statearr_16854 = [null,null,null,null,null,null,null,null];
(statearr_16854[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__);

(statearr_16854[(1)] = (1));

return statearr_16854;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1 = (function (state_16848){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_16848);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e16855){if((e16855 instanceof Object)){
var ex__16361__auto__ = e16855;
var statearr_16856_17028 = state_16848;
(statearr_16856_17028[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16848);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16855;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17029 = state_16848;
state_16848 = G__17029;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__ = function(state_16848){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1.call(this,state_16848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___17027,res,vec__16841,v,p,job,jobs,results))
})();
var state__16471__auto__ = (function (){var statearr_16857 = f__16470__auto__.call(null);
(statearr_16857[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___17027);

return statearr_16857;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___17027,res,vec__16841,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__16858){
var vec__16859 = p__16858;
var v = cljs.core.nth.call(null,vec__16859,(0),null);
var p = cljs.core.nth.call(null,vec__16859,(1),null);
var job = vec__16859;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__13164__auto___17030 = n;
var __17031 = (0);
while(true){
if((__17031 < n__13164__auto___17030)){
var G__16862_17032 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__16862_17032) {
case "compute":
var c__16469__auto___17034 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17031,c__16469__auto___17034,G__16862_17032,n__13164__auto___17030,jobs,results,process,async){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (__17031,c__16469__auto___17034,G__16862_17032,n__13164__auto___17030,jobs,results,process,async){
return (function (state_16875){
var state_val_16876 = (state_16875[(1)]);
if((state_val_16876 === (1))){
var state_16875__$1 = state_16875;
var statearr_16877_17035 = state_16875__$1;
(statearr_16877_17035[(2)] = null);

(statearr_16877_17035[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16876 === (2))){
var state_16875__$1 = state_16875;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16875__$1,(4),jobs);
} else {
if((state_val_16876 === (3))){
var inst_16873 = (state_16875[(2)]);
var state_16875__$1 = state_16875;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16875__$1,inst_16873);
} else {
if((state_val_16876 === (4))){
var inst_16865 = (state_16875[(2)]);
var inst_16866 = process.call(null,inst_16865);
var state_16875__$1 = state_16875;
if(cljs.core.truth_(inst_16866)){
var statearr_16878_17036 = state_16875__$1;
(statearr_16878_17036[(1)] = (5));

} else {
var statearr_16879_17037 = state_16875__$1;
(statearr_16879_17037[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16876 === (5))){
var state_16875__$1 = state_16875;
var statearr_16880_17038 = state_16875__$1;
(statearr_16880_17038[(2)] = null);

(statearr_16880_17038[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16876 === (6))){
var state_16875__$1 = state_16875;
var statearr_16881_17039 = state_16875__$1;
(statearr_16881_17039[(2)] = null);

(statearr_16881_17039[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16876 === (7))){
var inst_16871 = (state_16875[(2)]);
var state_16875__$1 = state_16875;
var statearr_16882_17040 = state_16875__$1;
(statearr_16882_17040[(2)] = inst_16871);

(statearr_16882_17040[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17031,c__16469__auto___17034,G__16862_17032,n__13164__auto___17030,jobs,results,process,async))
;
return ((function (__17031,switch__16357__auto__,c__16469__auto___17034,G__16862_17032,n__13164__auto___17030,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0 = (function (){
var statearr_16886 = [null,null,null,null,null,null,null];
(statearr_16886[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__);

(statearr_16886[(1)] = (1));

return statearr_16886;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1 = (function (state_16875){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_16875);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e16887){if((e16887 instanceof Object)){
var ex__16361__auto__ = e16887;
var statearr_16888_17041 = state_16875;
(statearr_16888_17041[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16875);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16887;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17042 = state_16875;
state_16875 = G__17042;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__ = function(state_16875){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1.call(this,state_16875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__;
})()
;})(__17031,switch__16357__auto__,c__16469__auto___17034,G__16862_17032,n__13164__auto___17030,jobs,results,process,async))
})();
var state__16471__auto__ = (function (){var statearr_16889 = f__16470__auto__.call(null);
(statearr_16889[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___17034);

return statearr_16889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(__17031,c__16469__auto___17034,G__16862_17032,n__13164__auto___17030,jobs,results,process,async))
);


break;
case "async":
var c__16469__auto___17043 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__17031,c__16469__auto___17043,G__16862_17032,n__13164__auto___17030,jobs,results,process,async){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (__17031,c__16469__auto___17043,G__16862_17032,n__13164__auto___17030,jobs,results,process,async){
return (function (state_16902){
var state_val_16903 = (state_16902[(1)]);
if((state_val_16903 === (1))){
var state_16902__$1 = state_16902;
var statearr_16904_17044 = state_16902__$1;
(statearr_16904_17044[(2)] = null);

(statearr_16904_17044[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16903 === (2))){
var state_16902__$1 = state_16902;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16902__$1,(4),jobs);
} else {
if((state_val_16903 === (3))){
var inst_16900 = (state_16902[(2)]);
var state_16902__$1 = state_16902;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16902__$1,inst_16900);
} else {
if((state_val_16903 === (4))){
var inst_16892 = (state_16902[(2)]);
var inst_16893 = async.call(null,inst_16892);
var state_16902__$1 = state_16902;
if(cljs.core.truth_(inst_16893)){
var statearr_16905_17045 = state_16902__$1;
(statearr_16905_17045[(1)] = (5));

} else {
var statearr_16906_17046 = state_16902__$1;
(statearr_16906_17046[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16903 === (5))){
var state_16902__$1 = state_16902;
var statearr_16907_17047 = state_16902__$1;
(statearr_16907_17047[(2)] = null);

(statearr_16907_17047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16903 === (6))){
var state_16902__$1 = state_16902;
var statearr_16908_17048 = state_16902__$1;
(statearr_16908_17048[(2)] = null);

(statearr_16908_17048[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16903 === (7))){
var inst_16898 = (state_16902[(2)]);
var state_16902__$1 = state_16902;
var statearr_16909_17049 = state_16902__$1;
(statearr_16909_17049[(2)] = inst_16898);

(statearr_16909_17049[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__17031,c__16469__auto___17043,G__16862_17032,n__13164__auto___17030,jobs,results,process,async))
;
return ((function (__17031,switch__16357__auto__,c__16469__auto___17043,G__16862_17032,n__13164__auto___17030,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0 = (function (){
var statearr_16913 = [null,null,null,null,null,null,null];
(statearr_16913[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__);

(statearr_16913[(1)] = (1));

return statearr_16913;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1 = (function (state_16902){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_16902);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e16914){if((e16914 instanceof Object)){
var ex__16361__auto__ = e16914;
var statearr_16915_17050 = state_16902;
(statearr_16915_17050[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16902);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16914;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17051 = state_16902;
state_16902 = G__17051;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__ = function(state_16902){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1.call(this,state_16902);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__;
})()
;})(__17031,switch__16357__auto__,c__16469__auto___17043,G__16862_17032,n__13164__auto___17030,jobs,results,process,async))
})();
var state__16471__auto__ = (function (){var statearr_16916 = f__16470__auto__.call(null);
(statearr_16916[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___17043);

return statearr_16916;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(__17031,c__16469__auto___17043,G__16862_17032,n__13164__auto___17030,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__17052 = (__17031 + (1));
__17031 = G__17052;
continue;
} else {
}
break;
}

var c__16469__auto___17053 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___17053,jobs,results,process,async){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___17053,jobs,results,process,async){
return (function (state_16938){
var state_val_16939 = (state_16938[(1)]);
if((state_val_16939 === (1))){
var state_16938__$1 = state_16938;
var statearr_16940_17054 = state_16938__$1;
(statearr_16940_17054[(2)] = null);

(statearr_16940_17054[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16939 === (2))){
var state_16938__$1 = state_16938;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16938__$1,(4),from);
} else {
if((state_val_16939 === (3))){
var inst_16936 = (state_16938[(2)]);
var state_16938__$1 = state_16938;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16938__$1,inst_16936);
} else {
if((state_val_16939 === (4))){
var inst_16919 = (state_16938[(7)]);
var inst_16919__$1 = (state_16938[(2)]);
var inst_16920 = (inst_16919__$1 == null);
var state_16938__$1 = (function (){var statearr_16941 = state_16938;
(statearr_16941[(7)] = inst_16919__$1);

return statearr_16941;
})();
if(cljs.core.truth_(inst_16920)){
var statearr_16942_17055 = state_16938__$1;
(statearr_16942_17055[(1)] = (5));

} else {
var statearr_16943_17056 = state_16938__$1;
(statearr_16943_17056[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16939 === (5))){
var inst_16922 = cljs.core.async.close_BANG_.call(null,jobs);
var state_16938__$1 = state_16938;
var statearr_16944_17057 = state_16938__$1;
(statearr_16944_17057[(2)] = inst_16922);

(statearr_16944_17057[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16939 === (6))){
var inst_16924 = (state_16938[(8)]);
var inst_16919 = (state_16938[(7)]);
var inst_16924__$1 = cljs.core.async.chan.call(null,(1));
var inst_16925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_16926 = [inst_16919,inst_16924__$1];
var inst_16927 = (new cljs.core.PersistentVector(null,2,(5),inst_16925,inst_16926,null));
var state_16938__$1 = (function (){var statearr_16945 = state_16938;
(statearr_16945[(8)] = inst_16924__$1);

return statearr_16945;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16938__$1,(8),jobs,inst_16927);
} else {
if((state_val_16939 === (7))){
var inst_16934 = (state_16938[(2)]);
var state_16938__$1 = state_16938;
var statearr_16946_17058 = state_16938__$1;
(statearr_16946_17058[(2)] = inst_16934);

(statearr_16946_17058[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16939 === (8))){
var inst_16924 = (state_16938[(8)]);
var inst_16929 = (state_16938[(2)]);
var state_16938__$1 = (function (){var statearr_16947 = state_16938;
(statearr_16947[(9)] = inst_16929);

return statearr_16947;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16938__$1,(9),results,inst_16924);
} else {
if((state_val_16939 === (9))){
var inst_16931 = (state_16938[(2)]);
var state_16938__$1 = (function (){var statearr_16948 = state_16938;
(statearr_16948[(10)] = inst_16931);

return statearr_16948;
})();
var statearr_16949_17059 = state_16938__$1;
(statearr_16949_17059[(2)] = null);

(statearr_16949_17059[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___17053,jobs,results,process,async))
;
return ((function (switch__16357__auto__,c__16469__auto___17053,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0 = (function (){
var statearr_16953 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_16953[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__);

(statearr_16953[(1)] = (1));

return statearr_16953;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1 = (function (state_16938){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_16938);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e16954){if((e16954 instanceof Object)){
var ex__16361__auto__ = e16954;
var statearr_16955_17060 = state_16938;
(statearr_16955_17060[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16938);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e16954;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17061 = state_16938;
state_16938 = G__17061;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__ = function(state_16938){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1.call(this,state_16938);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___17053,jobs,results,process,async))
})();
var state__16471__auto__ = (function (){var statearr_16956 = f__16470__auto__.call(null);
(statearr_16956[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___17053);

return statearr_16956;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___17053,jobs,results,process,async))
);


var c__16469__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto__,jobs,results,process,async){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto__,jobs,results,process,async){
return (function (state_16994){
var state_val_16995 = (state_16994[(1)]);
if((state_val_16995 === (7))){
var inst_16990 = (state_16994[(2)]);
var state_16994__$1 = state_16994;
var statearr_16996_17062 = state_16994__$1;
(statearr_16996_17062[(2)] = inst_16990);

(statearr_16996_17062[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (20))){
var state_16994__$1 = state_16994;
var statearr_16997_17063 = state_16994__$1;
(statearr_16997_17063[(2)] = null);

(statearr_16997_17063[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (1))){
var state_16994__$1 = state_16994;
var statearr_16998_17064 = state_16994__$1;
(statearr_16998_17064[(2)] = null);

(statearr_16998_17064[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (4))){
var inst_16959 = (state_16994[(7)]);
var inst_16959__$1 = (state_16994[(2)]);
var inst_16960 = (inst_16959__$1 == null);
var state_16994__$1 = (function (){var statearr_16999 = state_16994;
(statearr_16999[(7)] = inst_16959__$1);

return statearr_16999;
})();
if(cljs.core.truth_(inst_16960)){
var statearr_17000_17065 = state_16994__$1;
(statearr_17000_17065[(1)] = (5));

} else {
var statearr_17001_17066 = state_16994__$1;
(statearr_17001_17066[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (15))){
var inst_16972 = (state_16994[(8)]);
var state_16994__$1 = state_16994;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_16994__$1,(18),to,inst_16972);
} else {
if((state_val_16995 === (21))){
var inst_16985 = (state_16994[(2)]);
var state_16994__$1 = state_16994;
var statearr_17002_17067 = state_16994__$1;
(statearr_17002_17067[(2)] = inst_16985);

(statearr_17002_17067[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (13))){
var inst_16987 = (state_16994[(2)]);
var state_16994__$1 = (function (){var statearr_17003 = state_16994;
(statearr_17003[(9)] = inst_16987);

return statearr_17003;
})();
var statearr_17004_17068 = state_16994__$1;
(statearr_17004_17068[(2)] = null);

(statearr_17004_17068[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (6))){
var inst_16959 = (state_16994[(7)]);
var state_16994__$1 = state_16994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16994__$1,(11),inst_16959);
} else {
if((state_val_16995 === (17))){
var inst_16980 = (state_16994[(2)]);
var state_16994__$1 = state_16994;
if(cljs.core.truth_(inst_16980)){
var statearr_17005_17069 = state_16994__$1;
(statearr_17005_17069[(1)] = (19));

} else {
var statearr_17006_17070 = state_16994__$1;
(statearr_17006_17070[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (3))){
var inst_16992 = (state_16994[(2)]);
var state_16994__$1 = state_16994;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_16994__$1,inst_16992);
} else {
if((state_val_16995 === (12))){
var inst_16969 = (state_16994[(10)]);
var state_16994__$1 = state_16994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16994__$1,(14),inst_16969);
} else {
if((state_val_16995 === (2))){
var state_16994__$1 = state_16994;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_16994__$1,(4),results);
} else {
if((state_val_16995 === (19))){
var state_16994__$1 = state_16994;
var statearr_17007_17071 = state_16994__$1;
(statearr_17007_17071[(2)] = null);

(statearr_17007_17071[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (11))){
var inst_16969 = (state_16994[(2)]);
var state_16994__$1 = (function (){var statearr_17008 = state_16994;
(statearr_17008[(10)] = inst_16969);

return statearr_17008;
})();
var statearr_17009_17072 = state_16994__$1;
(statearr_17009_17072[(2)] = null);

(statearr_17009_17072[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (9))){
var state_16994__$1 = state_16994;
var statearr_17010_17073 = state_16994__$1;
(statearr_17010_17073[(2)] = null);

(statearr_17010_17073[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (5))){
var state_16994__$1 = state_16994;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17011_17074 = state_16994__$1;
(statearr_17011_17074[(1)] = (8));

} else {
var statearr_17012_17075 = state_16994__$1;
(statearr_17012_17075[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (14))){
var inst_16974 = (state_16994[(11)]);
var inst_16972 = (state_16994[(8)]);
var inst_16972__$1 = (state_16994[(2)]);
var inst_16973 = (inst_16972__$1 == null);
var inst_16974__$1 = cljs.core.not.call(null,inst_16973);
var state_16994__$1 = (function (){var statearr_17013 = state_16994;
(statearr_17013[(11)] = inst_16974__$1);

(statearr_17013[(8)] = inst_16972__$1);

return statearr_17013;
})();
if(inst_16974__$1){
var statearr_17014_17076 = state_16994__$1;
(statearr_17014_17076[(1)] = (15));

} else {
var statearr_17015_17077 = state_16994__$1;
(statearr_17015_17077[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (16))){
var inst_16974 = (state_16994[(11)]);
var state_16994__$1 = state_16994;
var statearr_17016_17078 = state_16994__$1;
(statearr_17016_17078[(2)] = inst_16974);

(statearr_17016_17078[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (10))){
var inst_16966 = (state_16994[(2)]);
var state_16994__$1 = state_16994;
var statearr_17017_17079 = state_16994__$1;
(statearr_17017_17079[(2)] = inst_16966);

(statearr_17017_17079[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (18))){
var inst_16977 = (state_16994[(2)]);
var state_16994__$1 = state_16994;
var statearr_17018_17080 = state_16994__$1;
(statearr_17018_17080[(2)] = inst_16977);

(statearr_17018_17080[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_16995 === (8))){
var inst_16963 = cljs.core.async.close_BANG_.call(null,to);
var state_16994__$1 = state_16994;
var statearr_17019_17081 = state_16994__$1;
(statearr_17019_17081[(2)] = inst_16963);

(statearr_17019_17081[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto__,jobs,results,process,async))
;
return ((function (switch__16357__auto__,c__16469__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0 = (function (){
var statearr_17023 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17023[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__);

(statearr_17023[(1)] = (1));

return statearr_17023;
});
var cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1 = (function (state_16994){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_16994);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e17024){if((e17024 instanceof Object)){
var ex__16361__auto__ = e17024;
var statearr_17025_17082 = state_16994;
(statearr_17025_17082[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_16994);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17024;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17083 = state_16994;
state_16994 = G__17083;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__ = function(state_16994){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1.call(this,state_16994);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__16358__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto__,jobs,results,process,async))
})();
var state__16471__auto__ = (function (){var statearr_17026 = f__16470__auto__.call(null);
(statearr_17026[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto__);

return statearr_17026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto__,jobs,results,process,async))
);

return c__16469__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args17084 = [];
var len__13324__auto___17087 = arguments.length;
var i__13325__auto___17088 = (0);
while(true){
if((i__13325__auto___17088 < len__13324__auto___17087)){
args17084.push((arguments[i__13325__auto___17088]));

var G__17089 = (i__13325__auto___17088 + (1));
i__13325__auto___17088 = G__17089;
continue;
} else {
}
break;
}

var G__17086 = args17084.length;
switch (G__17086) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17084.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args17091 = [];
var len__13324__auto___17094 = arguments.length;
var i__13325__auto___17095 = (0);
while(true){
if((i__13325__auto___17095 < len__13324__auto___17094)){
args17091.push((arguments[i__13325__auto___17095]));

var G__17096 = (i__13325__auto___17095 + (1));
i__13325__auto___17095 = G__17096;
continue;
} else {
}
break;
}

var G__17093 = args17091.length;
switch (G__17093) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17091.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args17098 = [];
var len__13324__auto___17151 = arguments.length;
var i__13325__auto___17152 = (0);
while(true){
if((i__13325__auto___17152 < len__13324__auto___17151)){
args17098.push((arguments[i__13325__auto___17152]));

var G__17153 = (i__13325__auto___17152 + (1));
i__13325__auto___17152 = G__17153;
continue;
} else {
}
break;
}

var G__17100 = args17098.length;
switch (G__17100) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17098.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__16469__auto___17155 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___17155,tc,fc){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___17155,tc,fc){
return (function (state_17126){
var state_val_17127 = (state_17126[(1)]);
if((state_val_17127 === (7))){
var inst_17122 = (state_17126[(2)]);
var state_17126__$1 = state_17126;
var statearr_17128_17156 = state_17126__$1;
(statearr_17128_17156[(2)] = inst_17122);

(statearr_17128_17156[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (1))){
var state_17126__$1 = state_17126;
var statearr_17129_17157 = state_17126__$1;
(statearr_17129_17157[(2)] = null);

(statearr_17129_17157[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (4))){
var inst_17103 = (state_17126[(7)]);
var inst_17103__$1 = (state_17126[(2)]);
var inst_17104 = (inst_17103__$1 == null);
var state_17126__$1 = (function (){var statearr_17130 = state_17126;
(statearr_17130[(7)] = inst_17103__$1);

return statearr_17130;
})();
if(cljs.core.truth_(inst_17104)){
var statearr_17131_17158 = state_17126__$1;
(statearr_17131_17158[(1)] = (5));

} else {
var statearr_17132_17159 = state_17126__$1;
(statearr_17132_17159[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (13))){
var state_17126__$1 = state_17126;
var statearr_17133_17160 = state_17126__$1;
(statearr_17133_17160[(2)] = null);

(statearr_17133_17160[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (6))){
var inst_17103 = (state_17126[(7)]);
var inst_17109 = p.call(null,inst_17103);
var state_17126__$1 = state_17126;
if(cljs.core.truth_(inst_17109)){
var statearr_17134_17161 = state_17126__$1;
(statearr_17134_17161[(1)] = (9));

} else {
var statearr_17135_17162 = state_17126__$1;
(statearr_17135_17162[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (3))){
var inst_17124 = (state_17126[(2)]);
var state_17126__$1 = state_17126;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17126__$1,inst_17124);
} else {
if((state_val_17127 === (12))){
var state_17126__$1 = state_17126;
var statearr_17136_17163 = state_17126__$1;
(statearr_17136_17163[(2)] = null);

(statearr_17136_17163[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (2))){
var state_17126__$1 = state_17126;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17126__$1,(4),ch);
} else {
if((state_val_17127 === (11))){
var inst_17103 = (state_17126[(7)]);
var inst_17113 = (state_17126[(2)]);
var state_17126__$1 = state_17126;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17126__$1,(8),inst_17113,inst_17103);
} else {
if((state_val_17127 === (9))){
var state_17126__$1 = state_17126;
var statearr_17137_17164 = state_17126__$1;
(statearr_17137_17164[(2)] = tc);

(statearr_17137_17164[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (5))){
var inst_17106 = cljs.core.async.close_BANG_.call(null,tc);
var inst_17107 = cljs.core.async.close_BANG_.call(null,fc);
var state_17126__$1 = (function (){var statearr_17138 = state_17126;
(statearr_17138[(8)] = inst_17106);

return statearr_17138;
})();
var statearr_17139_17165 = state_17126__$1;
(statearr_17139_17165[(2)] = inst_17107);

(statearr_17139_17165[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (14))){
var inst_17120 = (state_17126[(2)]);
var state_17126__$1 = state_17126;
var statearr_17140_17166 = state_17126__$1;
(statearr_17140_17166[(2)] = inst_17120);

(statearr_17140_17166[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (10))){
var state_17126__$1 = state_17126;
var statearr_17141_17167 = state_17126__$1;
(statearr_17141_17167[(2)] = fc);

(statearr_17141_17167[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17127 === (8))){
var inst_17115 = (state_17126[(2)]);
var state_17126__$1 = state_17126;
if(cljs.core.truth_(inst_17115)){
var statearr_17142_17168 = state_17126__$1;
(statearr_17142_17168[(1)] = (12));

} else {
var statearr_17143_17169 = state_17126__$1;
(statearr_17143_17169[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___17155,tc,fc))
;
return ((function (switch__16357__auto__,c__16469__auto___17155,tc,fc){
return (function() {
var cljs$core$async$state_machine__16358__auto__ = null;
var cljs$core$async$state_machine__16358__auto____0 = (function (){
var statearr_17147 = [null,null,null,null,null,null,null,null,null];
(statearr_17147[(0)] = cljs$core$async$state_machine__16358__auto__);

(statearr_17147[(1)] = (1));

return statearr_17147;
});
var cljs$core$async$state_machine__16358__auto____1 = (function (state_17126){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_17126);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e17148){if((e17148 instanceof Object)){
var ex__16361__auto__ = e17148;
var statearr_17149_17170 = state_17126;
(statearr_17149_17170[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17126);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17148;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17171 = state_17126;
state_17126 = G__17171;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$state_machine__16358__auto__ = function(state_17126){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16358__auto____1.call(this,state_17126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16358__auto____0;
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16358__auto____1;
return cljs$core$async$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___17155,tc,fc))
})();
var state__16471__auto__ = (function (){var statearr_17150 = f__16470__auto__.call(null);
(statearr_17150[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___17155);

return statearr_17150;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___17155,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__16469__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto__){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto__){
return (function (state_17235){
var state_val_17236 = (state_17235[(1)]);
if((state_val_17236 === (7))){
var inst_17231 = (state_17235[(2)]);
var state_17235__$1 = state_17235;
var statearr_17237_17258 = state_17235__$1;
(statearr_17237_17258[(2)] = inst_17231);

(statearr_17237_17258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (1))){
var inst_17215 = init;
var state_17235__$1 = (function (){var statearr_17238 = state_17235;
(statearr_17238[(7)] = inst_17215);

return statearr_17238;
})();
var statearr_17239_17259 = state_17235__$1;
(statearr_17239_17259[(2)] = null);

(statearr_17239_17259[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (4))){
var inst_17218 = (state_17235[(8)]);
var inst_17218__$1 = (state_17235[(2)]);
var inst_17219 = (inst_17218__$1 == null);
var state_17235__$1 = (function (){var statearr_17240 = state_17235;
(statearr_17240[(8)] = inst_17218__$1);

return statearr_17240;
})();
if(cljs.core.truth_(inst_17219)){
var statearr_17241_17260 = state_17235__$1;
(statearr_17241_17260[(1)] = (5));

} else {
var statearr_17242_17261 = state_17235__$1;
(statearr_17242_17261[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (6))){
var inst_17218 = (state_17235[(8)]);
var inst_17215 = (state_17235[(7)]);
var inst_17222 = (state_17235[(9)]);
var inst_17222__$1 = f.call(null,inst_17215,inst_17218);
var inst_17223 = cljs.core.reduced_QMARK_.call(null,inst_17222__$1);
var state_17235__$1 = (function (){var statearr_17243 = state_17235;
(statearr_17243[(9)] = inst_17222__$1);

return statearr_17243;
})();
if(inst_17223){
var statearr_17244_17262 = state_17235__$1;
(statearr_17244_17262[(1)] = (8));

} else {
var statearr_17245_17263 = state_17235__$1;
(statearr_17245_17263[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (3))){
var inst_17233 = (state_17235[(2)]);
var state_17235__$1 = state_17235;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17235__$1,inst_17233);
} else {
if((state_val_17236 === (2))){
var state_17235__$1 = state_17235;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17235__$1,(4),ch);
} else {
if((state_val_17236 === (9))){
var inst_17222 = (state_17235[(9)]);
var inst_17215 = inst_17222;
var state_17235__$1 = (function (){var statearr_17246 = state_17235;
(statearr_17246[(7)] = inst_17215);

return statearr_17246;
})();
var statearr_17247_17264 = state_17235__$1;
(statearr_17247_17264[(2)] = null);

(statearr_17247_17264[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (5))){
var inst_17215 = (state_17235[(7)]);
var state_17235__$1 = state_17235;
var statearr_17248_17265 = state_17235__$1;
(statearr_17248_17265[(2)] = inst_17215);

(statearr_17248_17265[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (10))){
var inst_17229 = (state_17235[(2)]);
var state_17235__$1 = state_17235;
var statearr_17249_17266 = state_17235__$1;
(statearr_17249_17266[(2)] = inst_17229);

(statearr_17249_17266[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17236 === (8))){
var inst_17222 = (state_17235[(9)]);
var inst_17225 = cljs.core.deref.call(null,inst_17222);
var state_17235__$1 = state_17235;
var statearr_17250_17267 = state_17235__$1;
(statearr_17250_17267[(2)] = inst_17225);

(statearr_17250_17267[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto__))
;
return ((function (switch__16357__auto__,c__16469__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__16358__auto__ = null;
var cljs$core$async$reduce_$_state_machine__16358__auto____0 = (function (){
var statearr_17254 = [null,null,null,null,null,null,null,null,null,null];
(statearr_17254[(0)] = cljs$core$async$reduce_$_state_machine__16358__auto__);

(statearr_17254[(1)] = (1));

return statearr_17254;
});
var cljs$core$async$reduce_$_state_machine__16358__auto____1 = (function (state_17235){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_17235);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e17255){if((e17255 instanceof Object)){
var ex__16361__auto__ = e17255;
var statearr_17256_17268 = state_17235;
(statearr_17256_17268[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17235);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17255;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17269 = state_17235;
state_17235 = G__17269;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__16358__auto__ = function(state_17235){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__16358__auto____1.call(this,state_17235);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__16358__auto____0;
cljs$core$async$reduce_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__16358__auto____1;
return cljs$core$async$reduce_$_state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto__))
})();
var state__16471__auto__ = (function (){var statearr_17257 = f__16470__auto__.call(null);
(statearr_17257[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto__);

return statearr_17257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto__))
);

return c__16469__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args17270 = [];
var len__13324__auto___17322 = arguments.length;
var i__13325__auto___17323 = (0);
while(true){
if((i__13325__auto___17323 < len__13324__auto___17322)){
args17270.push((arguments[i__13325__auto___17323]));

var G__17324 = (i__13325__auto___17323 + (1));
i__13325__auto___17323 = G__17324;
continue;
} else {
}
break;
}

var G__17272 = args17270.length;
switch (G__17272) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17270.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto__){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto__){
return (function (state_17297){
var state_val_17298 = (state_17297[(1)]);
if((state_val_17298 === (7))){
var inst_17279 = (state_17297[(2)]);
var state_17297__$1 = state_17297;
var statearr_17299_17326 = state_17297__$1;
(statearr_17299_17326[(2)] = inst_17279);

(statearr_17299_17326[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (1))){
var inst_17273 = cljs.core.seq.call(null,coll);
var inst_17274 = inst_17273;
var state_17297__$1 = (function (){var statearr_17300 = state_17297;
(statearr_17300[(7)] = inst_17274);

return statearr_17300;
})();
var statearr_17301_17327 = state_17297__$1;
(statearr_17301_17327[(2)] = null);

(statearr_17301_17327[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (4))){
var inst_17274 = (state_17297[(7)]);
var inst_17277 = cljs.core.first.call(null,inst_17274);
var state_17297__$1 = state_17297;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_17297__$1,(7),ch,inst_17277);
} else {
if((state_val_17298 === (13))){
var inst_17291 = (state_17297[(2)]);
var state_17297__$1 = state_17297;
var statearr_17302_17328 = state_17297__$1;
(statearr_17302_17328[(2)] = inst_17291);

(statearr_17302_17328[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (6))){
var inst_17282 = (state_17297[(2)]);
var state_17297__$1 = state_17297;
if(cljs.core.truth_(inst_17282)){
var statearr_17303_17329 = state_17297__$1;
(statearr_17303_17329[(1)] = (8));

} else {
var statearr_17304_17330 = state_17297__$1;
(statearr_17304_17330[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (3))){
var inst_17295 = (state_17297[(2)]);
var state_17297__$1 = state_17297;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17297__$1,inst_17295);
} else {
if((state_val_17298 === (12))){
var state_17297__$1 = state_17297;
var statearr_17305_17331 = state_17297__$1;
(statearr_17305_17331[(2)] = null);

(statearr_17305_17331[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (2))){
var inst_17274 = (state_17297[(7)]);
var state_17297__$1 = state_17297;
if(cljs.core.truth_(inst_17274)){
var statearr_17306_17332 = state_17297__$1;
(statearr_17306_17332[(1)] = (4));

} else {
var statearr_17307_17333 = state_17297__$1;
(statearr_17307_17333[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (11))){
var inst_17288 = cljs.core.async.close_BANG_.call(null,ch);
var state_17297__$1 = state_17297;
var statearr_17308_17334 = state_17297__$1;
(statearr_17308_17334[(2)] = inst_17288);

(statearr_17308_17334[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (9))){
var state_17297__$1 = state_17297;
if(cljs.core.truth_(close_QMARK_)){
var statearr_17309_17335 = state_17297__$1;
(statearr_17309_17335[(1)] = (11));

} else {
var statearr_17310_17336 = state_17297__$1;
(statearr_17310_17336[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (5))){
var inst_17274 = (state_17297[(7)]);
var state_17297__$1 = state_17297;
var statearr_17311_17337 = state_17297__$1;
(statearr_17311_17337[(2)] = inst_17274);

(statearr_17311_17337[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (10))){
var inst_17293 = (state_17297[(2)]);
var state_17297__$1 = state_17297;
var statearr_17312_17338 = state_17297__$1;
(statearr_17312_17338[(2)] = inst_17293);

(statearr_17312_17338[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17298 === (8))){
var inst_17274 = (state_17297[(7)]);
var inst_17284 = cljs.core.next.call(null,inst_17274);
var inst_17274__$1 = inst_17284;
var state_17297__$1 = (function (){var statearr_17313 = state_17297;
(statearr_17313[(7)] = inst_17274__$1);

return statearr_17313;
})();
var statearr_17314_17339 = state_17297__$1;
(statearr_17314_17339[(2)] = null);

(statearr_17314_17339[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto__))
;
return ((function (switch__16357__auto__,c__16469__auto__){
return (function() {
var cljs$core$async$state_machine__16358__auto__ = null;
var cljs$core$async$state_machine__16358__auto____0 = (function (){
var statearr_17318 = [null,null,null,null,null,null,null,null];
(statearr_17318[(0)] = cljs$core$async$state_machine__16358__auto__);

(statearr_17318[(1)] = (1));

return statearr_17318;
});
var cljs$core$async$state_machine__16358__auto____1 = (function (state_17297){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_17297);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e17319){if((e17319 instanceof Object)){
var ex__16361__auto__ = e17319;
var statearr_17320_17340 = state_17297;
(statearr_17320_17340[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17297);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17319;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17341 = state_17297;
state_17297 = G__17341;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$state_machine__16358__auto__ = function(state_17297){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16358__auto____1.call(this,state_17297);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16358__auto____0;
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16358__auto____1;
return cljs$core$async$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto__))
})();
var state__16471__auto__ = (function (){var statearr_17321 = f__16470__auto__.call(null);
(statearr_17321[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto__);

return statearr_17321;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto__))
);

return c__16469__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__12912__auto__ = (((_ == null))?null:_);
var m__12913__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,_);
} else {
var m__12913__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__12912__auto__ = (((m == null))?null:m);
var m__12913__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__12913__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__12912__auto__ = (((m == null))?null:m);
var m__12913__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,m,ch);
} else {
var m__12913__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__12912__auto__ = (((m == null))?null:m);
var m__12913__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,m);
} else {
var m__12913__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async17567 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async17567 = (function (mult,ch,cs,meta17568){
this.mult = mult;
this.ch = ch;
this.cs = cs;
this.meta17568 = meta17568;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async17567.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_17569,meta17568__$1){
var self__ = this;
var _17569__$1 = this;
return (new cljs.core.async.t_cljs$core$async17567(self__.mult,self__.ch,self__.cs,meta17568__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async17567.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_17569){
var self__ = this;
var _17569__$1 = this;
return self__.meta17568;
});})(cs))
;

cljs.core.async.t_cljs$core$async17567.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async17567.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async17567.prototype.cljs$core$async$Mult$ = true;

cljs.core.async.t_cljs$core$async17567.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17567.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17567.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async17567.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"mult","mult",-1187640995,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mult(iple) of the supplied channel. Channels\n  containing copies of the channel can be created with 'tap', and\n  detached with 'untap'.\n\n  Each item is distributed to all taps in parallel and synchronously,\n  i.e. each tap must accept before the next item is distributed. Use\n  buffering/windowing to prevent slow taps from holding up the mult.\n\n  Items received when there are no taps get dropped.\n\n  If a tap puts to a closed channel, it will be removed from the mult."], null)),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta17568","meta17568",-2088744038,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async17567.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async17567.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async17567";

cljs.core.async.t_cljs$core$async17567.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cljs.core.async/t_cljs$core$async17567");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async17567 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async17567(mult__$1,ch__$1,cs__$1,meta17568){
return (new cljs.core.async.t_cljs$core$async17567(mult__$1,ch__$1,cs__$1,meta17568));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async17567(cljs$core$async$mult,ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__16469__auto___17792 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___17792,cs,m,dchan,dctr,done){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___17792,cs,m,dchan,dctr,done){
return (function (state_17704){
var state_val_17705 = (state_17704[(1)]);
if((state_val_17705 === (7))){
var inst_17700 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17706_17793 = state_17704__$1;
(statearr_17706_17793[(2)] = inst_17700);

(statearr_17706_17793[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (20))){
var inst_17603 = (state_17704[(7)]);
var inst_17615 = cljs.core.first.call(null,inst_17603);
var inst_17616 = cljs.core.nth.call(null,inst_17615,(0),null);
var inst_17617 = cljs.core.nth.call(null,inst_17615,(1),null);
var state_17704__$1 = (function (){var statearr_17707 = state_17704;
(statearr_17707[(8)] = inst_17616);

return statearr_17707;
})();
if(cljs.core.truth_(inst_17617)){
var statearr_17708_17794 = state_17704__$1;
(statearr_17708_17794[(1)] = (22));

} else {
var statearr_17709_17795 = state_17704__$1;
(statearr_17709_17795[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (27))){
var inst_17647 = (state_17704[(9)]);
var inst_17572 = (state_17704[(10)]);
var inst_17645 = (state_17704[(11)]);
var inst_17652 = (state_17704[(12)]);
var inst_17652__$1 = cljs.core._nth.call(null,inst_17645,inst_17647);
var inst_17653 = cljs.core.async.put_BANG_.call(null,inst_17652__$1,inst_17572,done);
var state_17704__$1 = (function (){var statearr_17710 = state_17704;
(statearr_17710[(12)] = inst_17652__$1);

return statearr_17710;
})();
if(cljs.core.truth_(inst_17653)){
var statearr_17711_17796 = state_17704__$1;
(statearr_17711_17796[(1)] = (30));

} else {
var statearr_17712_17797 = state_17704__$1;
(statearr_17712_17797[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (1))){
var state_17704__$1 = state_17704;
var statearr_17713_17798 = state_17704__$1;
(statearr_17713_17798[(2)] = null);

(statearr_17713_17798[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (24))){
var inst_17603 = (state_17704[(7)]);
var inst_17622 = (state_17704[(2)]);
var inst_17623 = cljs.core.next.call(null,inst_17603);
var inst_17581 = inst_17623;
var inst_17582 = null;
var inst_17583 = (0);
var inst_17584 = (0);
var state_17704__$1 = (function (){var statearr_17714 = state_17704;
(statearr_17714[(13)] = inst_17582);

(statearr_17714[(14)] = inst_17584);

(statearr_17714[(15)] = inst_17583);

(statearr_17714[(16)] = inst_17581);

(statearr_17714[(17)] = inst_17622);

return statearr_17714;
})();
var statearr_17715_17799 = state_17704__$1;
(statearr_17715_17799[(2)] = null);

(statearr_17715_17799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (39))){
var state_17704__$1 = state_17704;
var statearr_17719_17800 = state_17704__$1;
(statearr_17719_17800[(2)] = null);

(statearr_17719_17800[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (4))){
var inst_17572 = (state_17704[(10)]);
var inst_17572__$1 = (state_17704[(2)]);
var inst_17573 = (inst_17572__$1 == null);
var state_17704__$1 = (function (){var statearr_17720 = state_17704;
(statearr_17720[(10)] = inst_17572__$1);

return statearr_17720;
})();
if(cljs.core.truth_(inst_17573)){
var statearr_17721_17801 = state_17704__$1;
(statearr_17721_17801[(1)] = (5));

} else {
var statearr_17722_17802 = state_17704__$1;
(statearr_17722_17802[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (15))){
var inst_17582 = (state_17704[(13)]);
var inst_17584 = (state_17704[(14)]);
var inst_17583 = (state_17704[(15)]);
var inst_17581 = (state_17704[(16)]);
var inst_17599 = (state_17704[(2)]);
var inst_17600 = (inst_17584 + (1));
var tmp17716 = inst_17582;
var tmp17717 = inst_17583;
var tmp17718 = inst_17581;
var inst_17581__$1 = tmp17718;
var inst_17582__$1 = tmp17716;
var inst_17583__$1 = tmp17717;
var inst_17584__$1 = inst_17600;
var state_17704__$1 = (function (){var statearr_17723 = state_17704;
(statearr_17723[(13)] = inst_17582__$1);

(statearr_17723[(14)] = inst_17584__$1);

(statearr_17723[(15)] = inst_17583__$1);

(statearr_17723[(16)] = inst_17581__$1);

(statearr_17723[(18)] = inst_17599);

return statearr_17723;
})();
var statearr_17724_17803 = state_17704__$1;
(statearr_17724_17803[(2)] = null);

(statearr_17724_17803[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (21))){
var inst_17626 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17728_17804 = state_17704__$1;
(statearr_17728_17804[(2)] = inst_17626);

(statearr_17728_17804[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (31))){
var inst_17652 = (state_17704[(12)]);
var inst_17656 = done.call(null,null);
var inst_17657 = cljs.core.async.untap_STAR_.call(null,m,inst_17652);
var state_17704__$1 = (function (){var statearr_17729 = state_17704;
(statearr_17729[(19)] = inst_17656);

return statearr_17729;
})();
var statearr_17730_17805 = state_17704__$1;
(statearr_17730_17805[(2)] = inst_17657);

(statearr_17730_17805[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (32))){
var inst_17647 = (state_17704[(9)]);
var inst_17645 = (state_17704[(11)]);
var inst_17646 = (state_17704[(20)]);
var inst_17644 = (state_17704[(21)]);
var inst_17659 = (state_17704[(2)]);
var inst_17660 = (inst_17647 + (1));
var tmp17725 = inst_17645;
var tmp17726 = inst_17646;
var tmp17727 = inst_17644;
var inst_17644__$1 = tmp17727;
var inst_17645__$1 = tmp17725;
var inst_17646__$1 = tmp17726;
var inst_17647__$1 = inst_17660;
var state_17704__$1 = (function (){var statearr_17731 = state_17704;
(statearr_17731[(22)] = inst_17659);

(statearr_17731[(9)] = inst_17647__$1);

(statearr_17731[(11)] = inst_17645__$1);

(statearr_17731[(20)] = inst_17646__$1);

(statearr_17731[(21)] = inst_17644__$1);

return statearr_17731;
})();
var statearr_17732_17806 = state_17704__$1;
(statearr_17732_17806[(2)] = null);

(statearr_17732_17806[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (40))){
var inst_17672 = (state_17704[(23)]);
var inst_17676 = done.call(null,null);
var inst_17677 = cljs.core.async.untap_STAR_.call(null,m,inst_17672);
var state_17704__$1 = (function (){var statearr_17733 = state_17704;
(statearr_17733[(24)] = inst_17676);

return statearr_17733;
})();
var statearr_17734_17807 = state_17704__$1;
(statearr_17734_17807[(2)] = inst_17677);

(statearr_17734_17807[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (33))){
var inst_17663 = (state_17704[(25)]);
var inst_17665 = cljs.core.chunked_seq_QMARK_.call(null,inst_17663);
var state_17704__$1 = state_17704;
if(inst_17665){
var statearr_17735_17808 = state_17704__$1;
(statearr_17735_17808[(1)] = (36));

} else {
var statearr_17736_17809 = state_17704__$1;
(statearr_17736_17809[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (13))){
var inst_17593 = (state_17704[(26)]);
var inst_17596 = cljs.core.async.close_BANG_.call(null,inst_17593);
var state_17704__$1 = state_17704;
var statearr_17737_17810 = state_17704__$1;
(statearr_17737_17810[(2)] = inst_17596);

(statearr_17737_17810[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (22))){
var inst_17616 = (state_17704[(8)]);
var inst_17619 = cljs.core.async.close_BANG_.call(null,inst_17616);
var state_17704__$1 = state_17704;
var statearr_17738_17811 = state_17704__$1;
(statearr_17738_17811[(2)] = inst_17619);

(statearr_17738_17811[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (36))){
var inst_17663 = (state_17704[(25)]);
var inst_17667 = cljs.core.chunk_first.call(null,inst_17663);
var inst_17668 = cljs.core.chunk_rest.call(null,inst_17663);
var inst_17669 = cljs.core.count.call(null,inst_17667);
var inst_17644 = inst_17668;
var inst_17645 = inst_17667;
var inst_17646 = inst_17669;
var inst_17647 = (0);
var state_17704__$1 = (function (){var statearr_17739 = state_17704;
(statearr_17739[(9)] = inst_17647);

(statearr_17739[(11)] = inst_17645);

(statearr_17739[(20)] = inst_17646);

(statearr_17739[(21)] = inst_17644);

return statearr_17739;
})();
var statearr_17740_17812 = state_17704__$1;
(statearr_17740_17812[(2)] = null);

(statearr_17740_17812[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (41))){
var inst_17663 = (state_17704[(25)]);
var inst_17679 = (state_17704[(2)]);
var inst_17680 = cljs.core.next.call(null,inst_17663);
var inst_17644 = inst_17680;
var inst_17645 = null;
var inst_17646 = (0);
var inst_17647 = (0);
var state_17704__$1 = (function (){var statearr_17741 = state_17704;
(statearr_17741[(9)] = inst_17647);

(statearr_17741[(11)] = inst_17645);

(statearr_17741[(20)] = inst_17646);

(statearr_17741[(21)] = inst_17644);

(statearr_17741[(27)] = inst_17679);

return statearr_17741;
})();
var statearr_17742_17813 = state_17704__$1;
(statearr_17742_17813[(2)] = null);

(statearr_17742_17813[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (43))){
var state_17704__$1 = state_17704;
var statearr_17743_17814 = state_17704__$1;
(statearr_17743_17814[(2)] = null);

(statearr_17743_17814[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (29))){
var inst_17688 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17744_17815 = state_17704__$1;
(statearr_17744_17815[(2)] = inst_17688);

(statearr_17744_17815[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (44))){
var inst_17697 = (state_17704[(2)]);
var state_17704__$1 = (function (){var statearr_17745 = state_17704;
(statearr_17745[(28)] = inst_17697);

return statearr_17745;
})();
var statearr_17746_17816 = state_17704__$1;
(statearr_17746_17816[(2)] = null);

(statearr_17746_17816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (6))){
var inst_17636 = (state_17704[(29)]);
var inst_17635 = cljs.core.deref.call(null,cs);
var inst_17636__$1 = cljs.core.keys.call(null,inst_17635);
var inst_17637 = cljs.core.count.call(null,inst_17636__$1);
var inst_17638 = cljs.core.reset_BANG_.call(null,dctr,inst_17637);
var inst_17643 = cljs.core.seq.call(null,inst_17636__$1);
var inst_17644 = inst_17643;
var inst_17645 = null;
var inst_17646 = (0);
var inst_17647 = (0);
var state_17704__$1 = (function (){var statearr_17747 = state_17704;
(statearr_17747[(29)] = inst_17636__$1);

(statearr_17747[(9)] = inst_17647);

(statearr_17747[(11)] = inst_17645);

(statearr_17747[(20)] = inst_17646);

(statearr_17747[(21)] = inst_17644);

(statearr_17747[(30)] = inst_17638);

return statearr_17747;
})();
var statearr_17748_17817 = state_17704__$1;
(statearr_17748_17817[(2)] = null);

(statearr_17748_17817[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (28))){
var inst_17644 = (state_17704[(21)]);
var inst_17663 = (state_17704[(25)]);
var inst_17663__$1 = cljs.core.seq.call(null,inst_17644);
var state_17704__$1 = (function (){var statearr_17749 = state_17704;
(statearr_17749[(25)] = inst_17663__$1);

return statearr_17749;
})();
if(inst_17663__$1){
var statearr_17750_17818 = state_17704__$1;
(statearr_17750_17818[(1)] = (33));

} else {
var statearr_17751_17819 = state_17704__$1;
(statearr_17751_17819[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (25))){
var inst_17647 = (state_17704[(9)]);
var inst_17646 = (state_17704[(20)]);
var inst_17649 = (inst_17647 < inst_17646);
var inst_17650 = inst_17649;
var state_17704__$1 = state_17704;
if(cljs.core.truth_(inst_17650)){
var statearr_17752_17820 = state_17704__$1;
(statearr_17752_17820[(1)] = (27));

} else {
var statearr_17753_17821 = state_17704__$1;
(statearr_17753_17821[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (34))){
var state_17704__$1 = state_17704;
var statearr_17754_17822 = state_17704__$1;
(statearr_17754_17822[(2)] = null);

(statearr_17754_17822[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (17))){
var state_17704__$1 = state_17704;
var statearr_17755_17823 = state_17704__$1;
(statearr_17755_17823[(2)] = null);

(statearr_17755_17823[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (3))){
var inst_17702 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_17704__$1,inst_17702);
} else {
if((state_val_17705 === (12))){
var inst_17631 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17756_17824 = state_17704__$1;
(statearr_17756_17824[(2)] = inst_17631);

(statearr_17756_17824[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (2))){
var state_17704__$1 = state_17704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17704__$1,(4),ch);
} else {
if((state_val_17705 === (23))){
var state_17704__$1 = state_17704;
var statearr_17757_17825 = state_17704__$1;
(statearr_17757_17825[(2)] = null);

(statearr_17757_17825[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (35))){
var inst_17686 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17758_17826 = state_17704__$1;
(statearr_17758_17826[(2)] = inst_17686);

(statearr_17758_17826[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (19))){
var inst_17603 = (state_17704[(7)]);
var inst_17607 = cljs.core.chunk_first.call(null,inst_17603);
var inst_17608 = cljs.core.chunk_rest.call(null,inst_17603);
var inst_17609 = cljs.core.count.call(null,inst_17607);
var inst_17581 = inst_17608;
var inst_17582 = inst_17607;
var inst_17583 = inst_17609;
var inst_17584 = (0);
var state_17704__$1 = (function (){var statearr_17759 = state_17704;
(statearr_17759[(13)] = inst_17582);

(statearr_17759[(14)] = inst_17584);

(statearr_17759[(15)] = inst_17583);

(statearr_17759[(16)] = inst_17581);

return statearr_17759;
})();
var statearr_17760_17827 = state_17704__$1;
(statearr_17760_17827[(2)] = null);

(statearr_17760_17827[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (11))){
var inst_17603 = (state_17704[(7)]);
var inst_17581 = (state_17704[(16)]);
var inst_17603__$1 = cljs.core.seq.call(null,inst_17581);
var state_17704__$1 = (function (){var statearr_17761 = state_17704;
(statearr_17761[(7)] = inst_17603__$1);

return statearr_17761;
})();
if(inst_17603__$1){
var statearr_17762_17828 = state_17704__$1;
(statearr_17762_17828[(1)] = (16));

} else {
var statearr_17763_17829 = state_17704__$1;
(statearr_17763_17829[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (9))){
var inst_17633 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17764_17830 = state_17704__$1;
(statearr_17764_17830[(2)] = inst_17633);

(statearr_17764_17830[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (5))){
var inst_17579 = cljs.core.deref.call(null,cs);
var inst_17580 = cljs.core.seq.call(null,inst_17579);
var inst_17581 = inst_17580;
var inst_17582 = null;
var inst_17583 = (0);
var inst_17584 = (0);
var state_17704__$1 = (function (){var statearr_17765 = state_17704;
(statearr_17765[(13)] = inst_17582);

(statearr_17765[(14)] = inst_17584);

(statearr_17765[(15)] = inst_17583);

(statearr_17765[(16)] = inst_17581);

return statearr_17765;
})();
var statearr_17766_17831 = state_17704__$1;
(statearr_17766_17831[(2)] = null);

(statearr_17766_17831[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (14))){
var state_17704__$1 = state_17704;
var statearr_17767_17832 = state_17704__$1;
(statearr_17767_17832[(2)] = null);

(statearr_17767_17832[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (45))){
var inst_17694 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17768_17833 = state_17704__$1;
(statearr_17768_17833[(2)] = inst_17694);

(statearr_17768_17833[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (26))){
var inst_17636 = (state_17704[(29)]);
var inst_17690 = (state_17704[(2)]);
var inst_17691 = cljs.core.seq.call(null,inst_17636);
var state_17704__$1 = (function (){var statearr_17769 = state_17704;
(statearr_17769[(31)] = inst_17690);

return statearr_17769;
})();
if(inst_17691){
var statearr_17770_17834 = state_17704__$1;
(statearr_17770_17834[(1)] = (42));

} else {
var statearr_17771_17835 = state_17704__$1;
(statearr_17771_17835[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (16))){
var inst_17603 = (state_17704[(7)]);
var inst_17605 = cljs.core.chunked_seq_QMARK_.call(null,inst_17603);
var state_17704__$1 = state_17704;
if(inst_17605){
var statearr_17772_17836 = state_17704__$1;
(statearr_17772_17836[(1)] = (19));

} else {
var statearr_17773_17837 = state_17704__$1;
(statearr_17773_17837[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (38))){
var inst_17683 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17774_17838 = state_17704__$1;
(statearr_17774_17838[(2)] = inst_17683);

(statearr_17774_17838[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (30))){
var state_17704__$1 = state_17704;
var statearr_17775_17839 = state_17704__$1;
(statearr_17775_17839[(2)] = null);

(statearr_17775_17839[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (10))){
var inst_17582 = (state_17704[(13)]);
var inst_17584 = (state_17704[(14)]);
var inst_17592 = cljs.core._nth.call(null,inst_17582,inst_17584);
var inst_17593 = cljs.core.nth.call(null,inst_17592,(0),null);
var inst_17594 = cljs.core.nth.call(null,inst_17592,(1),null);
var state_17704__$1 = (function (){var statearr_17776 = state_17704;
(statearr_17776[(26)] = inst_17593);

return statearr_17776;
})();
if(cljs.core.truth_(inst_17594)){
var statearr_17777_17840 = state_17704__$1;
(statearr_17777_17840[(1)] = (13));

} else {
var statearr_17778_17841 = state_17704__$1;
(statearr_17778_17841[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (18))){
var inst_17629 = (state_17704[(2)]);
var state_17704__$1 = state_17704;
var statearr_17779_17842 = state_17704__$1;
(statearr_17779_17842[(2)] = inst_17629);

(statearr_17779_17842[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (42))){
var state_17704__$1 = state_17704;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_17704__$1,(45),dchan);
} else {
if((state_val_17705 === (37))){
var inst_17572 = (state_17704[(10)]);
var inst_17663 = (state_17704[(25)]);
var inst_17672 = (state_17704[(23)]);
var inst_17672__$1 = cljs.core.first.call(null,inst_17663);
var inst_17673 = cljs.core.async.put_BANG_.call(null,inst_17672__$1,inst_17572,done);
var state_17704__$1 = (function (){var statearr_17780 = state_17704;
(statearr_17780[(23)] = inst_17672__$1);

return statearr_17780;
})();
if(cljs.core.truth_(inst_17673)){
var statearr_17781_17843 = state_17704__$1;
(statearr_17781_17843[(1)] = (39));

} else {
var statearr_17782_17844 = state_17704__$1;
(statearr_17782_17844[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_17705 === (8))){
var inst_17584 = (state_17704[(14)]);
var inst_17583 = (state_17704[(15)]);
var inst_17586 = (inst_17584 < inst_17583);
var inst_17587 = inst_17586;
var state_17704__$1 = state_17704;
if(cljs.core.truth_(inst_17587)){
var statearr_17783_17845 = state_17704__$1;
(statearr_17783_17845[(1)] = (10));

} else {
var statearr_17784_17846 = state_17704__$1;
(statearr_17784_17846[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___17792,cs,m,dchan,dctr,done))
;
return ((function (switch__16357__auto__,c__16469__auto___17792,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__16358__auto__ = null;
var cljs$core$async$mult_$_state_machine__16358__auto____0 = (function (){
var statearr_17788 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_17788[(0)] = cljs$core$async$mult_$_state_machine__16358__auto__);

(statearr_17788[(1)] = (1));

return statearr_17788;
});
var cljs$core$async$mult_$_state_machine__16358__auto____1 = (function (state_17704){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_17704);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e17789){if((e17789 instanceof Object)){
var ex__16361__auto__ = e17789;
var statearr_17790_17847 = state_17704;
(statearr_17790_17847[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_17704);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e17789;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__17848 = state_17704;
state_17704 = G__17848;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__16358__auto__ = function(state_17704){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__16358__auto____1.call(this,state_17704);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__16358__auto____0;
cljs$core$async$mult_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__16358__auto____1;
return cljs$core$async$mult_$_state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___17792,cs,m,dchan,dctr,done))
})();
var state__16471__auto__ = (function (){var statearr_17791 = f__16470__auto__.call(null);
(statearr_17791[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___17792);

return statearr_17791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___17792,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args17849 = [];
var len__13324__auto___17852 = arguments.length;
var i__13325__auto___17853 = (0);
while(true){
if((i__13325__auto___17853 < len__13324__auto___17852)){
args17849.push((arguments[i__13325__auto___17853]));

var G__17854 = (i__13325__auto___17853 + (1));
i__13325__auto___17853 = G__17854;
continue;
} else {
}
break;
}

var G__17851 = args17849.length;
switch (G__17851) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args17849.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__12912__auto__ = (((m == null))?null:m);
var m__12913__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,m,ch);
} else {
var m__12913__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__12912__auto__ = (((m == null))?null:m);
var m__12913__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,m,ch);
} else {
var m__12913__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__12912__auto__ = (((m == null))?null:m);
var m__12913__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,m);
} else {
var m__12913__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__12912__auto__ = (((m == null))?null:m);
var m__12913__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,m,state_map);
} else {
var m__12913__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__12912__auto__ = (((m == null))?null:m);
var m__12913__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,m,mode);
} else {
var m__12913__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__13331__auto__ = [];
var len__13324__auto___17866 = arguments.length;
var i__13325__auto___17867 = (0);
while(true){
if((i__13325__auto___17867 < len__13324__auto___17866)){
args__13331__auto__.push((arguments[i__13325__auto___17867]));

var G__17868 = (i__13325__auto___17867 + (1));
i__13325__auto___17867 = G__17868;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((3) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__13332__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__17860){
var map__17861 = p__17860;
var map__17861__$1 = ((((!((map__17861 == null)))?((((map__17861.cljs$lang$protocol_mask$partition0$ & (64))) || (map__17861.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17861):map__17861);
var opts = map__17861__$1;
var statearr_17863_17869 = state;
(statearr_17863_17869[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__17861,map__17861__$1,opts){
return (function (val){
var statearr_17864_17870 = state;
(statearr_17864_17870[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__17861,map__17861__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_17865_17871 = state;
(statearr_17865_17871[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq17856){
var G__17857 = cljs.core.first.call(null,seq17856);
var seq17856__$1 = cljs.core.next.call(null,seq17856);
var G__17858 = cljs.core.first.call(null,seq17856__$1);
var seq17856__$2 = cljs.core.next.call(null,seq17856__$1);
var G__17859 = cljs.core.first.call(null,seq17856__$2);
var seq17856__$3 = cljs.core.next.call(null,seq17856__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__17857,G__17858,G__17859,seq17856__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async18037 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18037 = (function (change,mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta18038){
this.change = change;
this.mix = mix;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta18038 = meta18038;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18037.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18039,meta18038__$1){
var self__ = this;
var _18039__$1 = this;
return (new cljs.core.async.t_cljs$core$async18037(self__.change,self__.mix,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta18038__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18037.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_18039){
var self__ = this;
var _18039__$1 = this;
return self__.meta18038;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18037.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18037.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18037.prototype.cljs$core$async$Mix$ = true;

cljs.core.async.t_cljs$core$async18037.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18037.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18037.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18037.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18037.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18037.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),cljs.core.with_meta(new cljs.core.Symbol(null,"mix","mix",2121373763,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Creates and returns a mix of one or more input channels which will\n  be put on the supplied out channel. Input sources can be added to\n  the mix with 'admix', and removed with 'unmix'. A mix supports\n  soloing, muting and pausing multiple inputs atomically using\n  'toggle', and can solo using either muting or pausing as determined\n  by 'solo-mode'.\n\n  Each channel can have zero or more boolean modes set via 'toggle':\n\n  :solo - when true, only this (ond other soloed) channel(s) will appear\n          in the mix output channel. :mute and :pause states of soloed\n          channels are ignored. If solo-mode is :mute, non-soloed\n          channels are muted, if :pause, non-soloed channels are\n          paused.\n\n  :mute - muted channels will have their contents consumed but not included in the mix\n  :pause - paused channels will not have their contents consumed (and thus also not included in the mix)\n"], null)),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta18038","meta18038",950566968,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async18037.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18037.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18037";

cljs.core.async.t_cljs$core$async18037.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cljs.core.async/t_cljs$core$async18037");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async18037 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async18037(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18038){
return (new cljs.core.async.t_cljs$core$async18037(change__$1,mix__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta18038));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async18037(change,cljs$core$async$mix,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16469__auto___18202 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___18202,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___18202,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_18139){
var state_val_18140 = (state_18139[(1)]);
if((state_val_18140 === (7))){
var inst_18055 = (state_18139[(2)]);
var state_18139__$1 = state_18139;
var statearr_18141_18203 = state_18139__$1;
(statearr_18141_18203[(2)] = inst_18055);

(statearr_18141_18203[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (20))){
var inst_18067 = (state_18139[(7)]);
var state_18139__$1 = state_18139;
var statearr_18142_18204 = state_18139__$1;
(statearr_18142_18204[(2)] = inst_18067);

(statearr_18142_18204[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (27))){
var state_18139__$1 = state_18139;
var statearr_18143_18205 = state_18139__$1;
(statearr_18143_18205[(2)] = null);

(statearr_18143_18205[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (1))){
var inst_18043 = (state_18139[(8)]);
var inst_18043__$1 = calc_state.call(null);
var inst_18045 = (inst_18043__$1 == null);
var inst_18046 = cljs.core.not.call(null,inst_18045);
var state_18139__$1 = (function (){var statearr_18144 = state_18139;
(statearr_18144[(8)] = inst_18043__$1);

return statearr_18144;
})();
if(inst_18046){
var statearr_18145_18206 = state_18139__$1;
(statearr_18145_18206[(1)] = (2));

} else {
var statearr_18146_18207 = state_18139__$1;
(statearr_18146_18207[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (24))){
var inst_18099 = (state_18139[(9)]);
var inst_18090 = (state_18139[(10)]);
var inst_18113 = (state_18139[(11)]);
var inst_18113__$1 = inst_18090.call(null,inst_18099);
var state_18139__$1 = (function (){var statearr_18147 = state_18139;
(statearr_18147[(11)] = inst_18113__$1);

return statearr_18147;
})();
if(cljs.core.truth_(inst_18113__$1)){
var statearr_18148_18208 = state_18139__$1;
(statearr_18148_18208[(1)] = (29));

} else {
var statearr_18149_18209 = state_18139__$1;
(statearr_18149_18209[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (4))){
var inst_18058 = (state_18139[(2)]);
var state_18139__$1 = state_18139;
if(cljs.core.truth_(inst_18058)){
var statearr_18150_18210 = state_18139__$1;
(statearr_18150_18210[(1)] = (8));

} else {
var statearr_18151_18211 = state_18139__$1;
(statearr_18151_18211[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (15))){
var inst_18084 = (state_18139[(2)]);
var state_18139__$1 = state_18139;
if(cljs.core.truth_(inst_18084)){
var statearr_18152_18212 = state_18139__$1;
(statearr_18152_18212[(1)] = (19));

} else {
var statearr_18153_18213 = state_18139__$1;
(statearr_18153_18213[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (21))){
var inst_18089 = (state_18139[(12)]);
var inst_18089__$1 = (state_18139[(2)]);
var inst_18090 = cljs.core.get.call(null,inst_18089__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18091 = cljs.core.get.call(null,inst_18089__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18092 = cljs.core.get.call(null,inst_18089__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_18139__$1 = (function (){var statearr_18154 = state_18139;
(statearr_18154[(10)] = inst_18090);

(statearr_18154[(13)] = inst_18091);

(statearr_18154[(12)] = inst_18089__$1);

return statearr_18154;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_18139__$1,(22),inst_18092);
} else {
if((state_val_18140 === (31))){
var inst_18121 = (state_18139[(2)]);
var state_18139__$1 = state_18139;
if(cljs.core.truth_(inst_18121)){
var statearr_18155_18214 = state_18139__$1;
(statearr_18155_18214[(1)] = (32));

} else {
var statearr_18156_18215 = state_18139__$1;
(statearr_18156_18215[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (32))){
var inst_18098 = (state_18139[(14)]);
var state_18139__$1 = state_18139;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18139__$1,(35),out,inst_18098);
} else {
if((state_val_18140 === (33))){
var inst_18089 = (state_18139[(12)]);
var inst_18067 = inst_18089;
var state_18139__$1 = (function (){var statearr_18157 = state_18139;
(statearr_18157[(7)] = inst_18067);

return statearr_18157;
})();
var statearr_18158_18216 = state_18139__$1;
(statearr_18158_18216[(2)] = null);

(statearr_18158_18216[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (13))){
var inst_18067 = (state_18139[(7)]);
var inst_18074 = inst_18067.cljs$lang$protocol_mask$partition0$;
var inst_18075 = (inst_18074 & (64));
var inst_18076 = inst_18067.cljs$core$ISeq$;
var inst_18077 = (inst_18075) || (inst_18076);
var state_18139__$1 = state_18139;
if(cljs.core.truth_(inst_18077)){
var statearr_18159_18217 = state_18139__$1;
(statearr_18159_18217[(1)] = (16));

} else {
var statearr_18160_18218 = state_18139__$1;
(statearr_18160_18218[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (22))){
var inst_18099 = (state_18139[(9)]);
var inst_18098 = (state_18139[(14)]);
var inst_18097 = (state_18139[(2)]);
var inst_18098__$1 = cljs.core.nth.call(null,inst_18097,(0),null);
var inst_18099__$1 = cljs.core.nth.call(null,inst_18097,(1),null);
var inst_18100 = (inst_18098__$1 == null);
var inst_18101 = cljs.core._EQ_.call(null,inst_18099__$1,change);
var inst_18102 = (inst_18100) || (inst_18101);
var state_18139__$1 = (function (){var statearr_18161 = state_18139;
(statearr_18161[(9)] = inst_18099__$1);

(statearr_18161[(14)] = inst_18098__$1);

return statearr_18161;
})();
if(cljs.core.truth_(inst_18102)){
var statearr_18162_18219 = state_18139__$1;
(statearr_18162_18219[(1)] = (23));

} else {
var statearr_18163_18220 = state_18139__$1;
(statearr_18163_18220[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (36))){
var inst_18089 = (state_18139[(12)]);
var inst_18067 = inst_18089;
var state_18139__$1 = (function (){var statearr_18164 = state_18139;
(statearr_18164[(7)] = inst_18067);

return statearr_18164;
})();
var statearr_18165_18221 = state_18139__$1;
(statearr_18165_18221[(2)] = null);

(statearr_18165_18221[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (29))){
var inst_18113 = (state_18139[(11)]);
var state_18139__$1 = state_18139;
var statearr_18166_18222 = state_18139__$1;
(statearr_18166_18222[(2)] = inst_18113);

(statearr_18166_18222[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (6))){
var state_18139__$1 = state_18139;
var statearr_18167_18223 = state_18139__$1;
(statearr_18167_18223[(2)] = false);

(statearr_18167_18223[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (28))){
var inst_18109 = (state_18139[(2)]);
var inst_18110 = calc_state.call(null);
var inst_18067 = inst_18110;
var state_18139__$1 = (function (){var statearr_18168 = state_18139;
(statearr_18168[(7)] = inst_18067);

(statearr_18168[(15)] = inst_18109);

return statearr_18168;
})();
var statearr_18169_18224 = state_18139__$1;
(statearr_18169_18224[(2)] = null);

(statearr_18169_18224[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (25))){
var inst_18135 = (state_18139[(2)]);
var state_18139__$1 = state_18139;
var statearr_18170_18225 = state_18139__$1;
(statearr_18170_18225[(2)] = inst_18135);

(statearr_18170_18225[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (34))){
var inst_18133 = (state_18139[(2)]);
var state_18139__$1 = state_18139;
var statearr_18171_18226 = state_18139__$1;
(statearr_18171_18226[(2)] = inst_18133);

(statearr_18171_18226[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (17))){
var state_18139__$1 = state_18139;
var statearr_18172_18227 = state_18139__$1;
(statearr_18172_18227[(2)] = false);

(statearr_18172_18227[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (3))){
var state_18139__$1 = state_18139;
var statearr_18173_18228 = state_18139__$1;
(statearr_18173_18228[(2)] = false);

(statearr_18173_18228[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (12))){
var inst_18137 = (state_18139[(2)]);
var state_18139__$1 = state_18139;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18139__$1,inst_18137);
} else {
if((state_val_18140 === (2))){
var inst_18043 = (state_18139[(8)]);
var inst_18048 = inst_18043.cljs$lang$protocol_mask$partition0$;
var inst_18049 = (inst_18048 & (64));
var inst_18050 = inst_18043.cljs$core$ISeq$;
var inst_18051 = (inst_18049) || (inst_18050);
var state_18139__$1 = state_18139;
if(cljs.core.truth_(inst_18051)){
var statearr_18174_18229 = state_18139__$1;
(statearr_18174_18229[(1)] = (5));

} else {
var statearr_18175_18230 = state_18139__$1;
(statearr_18175_18230[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (23))){
var inst_18098 = (state_18139[(14)]);
var inst_18104 = (inst_18098 == null);
var state_18139__$1 = state_18139;
if(cljs.core.truth_(inst_18104)){
var statearr_18176_18231 = state_18139__$1;
(statearr_18176_18231[(1)] = (26));

} else {
var statearr_18177_18232 = state_18139__$1;
(statearr_18177_18232[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (35))){
var inst_18124 = (state_18139[(2)]);
var state_18139__$1 = state_18139;
if(cljs.core.truth_(inst_18124)){
var statearr_18178_18233 = state_18139__$1;
(statearr_18178_18233[(1)] = (36));

} else {
var statearr_18179_18234 = state_18139__$1;
(statearr_18179_18234[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (19))){
var inst_18067 = (state_18139[(7)]);
var inst_18086 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18067);
var state_18139__$1 = state_18139;
var statearr_18180_18235 = state_18139__$1;
(statearr_18180_18235[(2)] = inst_18086);

(statearr_18180_18235[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (11))){
var inst_18067 = (state_18139[(7)]);
var inst_18071 = (inst_18067 == null);
var inst_18072 = cljs.core.not.call(null,inst_18071);
var state_18139__$1 = state_18139;
if(inst_18072){
var statearr_18181_18236 = state_18139__$1;
(statearr_18181_18236[(1)] = (13));

} else {
var statearr_18182_18237 = state_18139__$1;
(statearr_18182_18237[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (9))){
var inst_18043 = (state_18139[(8)]);
var state_18139__$1 = state_18139;
var statearr_18183_18238 = state_18139__$1;
(statearr_18183_18238[(2)] = inst_18043);

(statearr_18183_18238[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (5))){
var state_18139__$1 = state_18139;
var statearr_18184_18239 = state_18139__$1;
(statearr_18184_18239[(2)] = true);

(statearr_18184_18239[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (14))){
var state_18139__$1 = state_18139;
var statearr_18185_18240 = state_18139__$1;
(statearr_18185_18240[(2)] = false);

(statearr_18185_18240[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (26))){
var inst_18099 = (state_18139[(9)]);
var inst_18106 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_18099);
var state_18139__$1 = state_18139;
var statearr_18186_18241 = state_18139__$1;
(statearr_18186_18241[(2)] = inst_18106);

(statearr_18186_18241[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (16))){
var state_18139__$1 = state_18139;
var statearr_18187_18242 = state_18139__$1;
(statearr_18187_18242[(2)] = true);

(statearr_18187_18242[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (38))){
var inst_18129 = (state_18139[(2)]);
var state_18139__$1 = state_18139;
var statearr_18188_18243 = state_18139__$1;
(statearr_18188_18243[(2)] = inst_18129);

(statearr_18188_18243[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (30))){
var inst_18099 = (state_18139[(9)]);
var inst_18090 = (state_18139[(10)]);
var inst_18091 = (state_18139[(13)]);
var inst_18116 = cljs.core.empty_QMARK_.call(null,inst_18090);
var inst_18117 = inst_18091.call(null,inst_18099);
var inst_18118 = cljs.core.not.call(null,inst_18117);
var inst_18119 = (inst_18116) && (inst_18118);
var state_18139__$1 = state_18139;
var statearr_18189_18244 = state_18139__$1;
(statearr_18189_18244[(2)] = inst_18119);

(statearr_18189_18244[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (10))){
var inst_18043 = (state_18139[(8)]);
var inst_18063 = (state_18139[(2)]);
var inst_18064 = cljs.core.get.call(null,inst_18063,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_18065 = cljs.core.get.call(null,inst_18063,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_18066 = cljs.core.get.call(null,inst_18063,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_18067 = inst_18043;
var state_18139__$1 = (function (){var statearr_18190 = state_18139;
(statearr_18190[(16)] = inst_18066);

(statearr_18190[(17)] = inst_18065);

(statearr_18190[(7)] = inst_18067);

(statearr_18190[(18)] = inst_18064);

return statearr_18190;
})();
var statearr_18191_18245 = state_18139__$1;
(statearr_18191_18245[(2)] = null);

(statearr_18191_18245[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (18))){
var inst_18081 = (state_18139[(2)]);
var state_18139__$1 = state_18139;
var statearr_18192_18246 = state_18139__$1;
(statearr_18192_18246[(2)] = inst_18081);

(statearr_18192_18246[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (37))){
var state_18139__$1 = state_18139;
var statearr_18193_18247 = state_18139__$1;
(statearr_18193_18247[(2)] = null);

(statearr_18193_18247[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18140 === (8))){
var inst_18043 = (state_18139[(8)]);
var inst_18060 = cljs.core.apply.call(null,cljs.core.hash_map,inst_18043);
var state_18139__$1 = state_18139;
var statearr_18194_18248 = state_18139__$1;
(statearr_18194_18248[(2)] = inst_18060);

(statearr_18194_18248[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___18202,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__16357__auto__,c__16469__auto___18202,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__16358__auto__ = null;
var cljs$core$async$mix_$_state_machine__16358__auto____0 = (function (){
var statearr_18198 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18198[(0)] = cljs$core$async$mix_$_state_machine__16358__auto__);

(statearr_18198[(1)] = (1));

return statearr_18198;
});
var cljs$core$async$mix_$_state_machine__16358__auto____1 = (function (state_18139){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_18139);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e18199){if((e18199 instanceof Object)){
var ex__16361__auto__ = e18199;
var statearr_18200_18249 = state_18139;
(statearr_18200_18249[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18139);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18199;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18250 = state_18139;
state_18139 = G__18250;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__16358__auto__ = function(state_18139){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__16358__auto____1.call(this,state_18139);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__16358__auto____0;
cljs$core$async$mix_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__16358__auto____1;
return cljs$core$async$mix_$_state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___18202,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__16471__auto__ = (function (){var statearr_18201 = f__16470__auto__.call(null);
(statearr_18201[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___18202);

return statearr_18201;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___18202,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__12912__auto__ = (((p == null))?null:p);
var m__12913__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__12913__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__12912__auto__ = (((p == null))?null:p);
var m__12913__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,p,v,ch);
} else {
var m__12913__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args18251 = [];
var len__13324__auto___18254 = arguments.length;
var i__13325__auto___18255 = (0);
while(true){
if((i__13325__auto___18255 < len__13324__auto___18254)){
args18251.push((arguments[i__13325__auto___18255]));

var G__18256 = (i__13325__auto___18255 + (1));
i__13325__auto___18255 = G__18256;
continue;
} else {
}
break;
}

var G__18253 = args18251.length;
switch (G__18253) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18251.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__12912__auto__ = (((p == null))?null:p);
var m__12913__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,p);
} else {
var m__12913__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__12912__auto__ = (((p == null))?null:p);
var m__12913__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__12912__auto__)]);
if(!((m__12913__auto__ == null))){
return m__12913__auto__.call(null,p,v);
} else {
var m__12913__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__12913__auto____$1 == null))){
return m__12913__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args18259 = [];
var len__13324__auto___18384 = arguments.length;
var i__13325__auto___18385 = (0);
while(true){
if((i__13325__auto___18385 < len__13324__auto___18384)){
args18259.push((arguments[i__13325__auto___18385]));

var G__18386 = (i__13325__auto___18385 + (1));
i__13325__auto___18385 = G__18386;
continue;
} else {
}
break;
}

var G__18261 = args18259.length;
switch (G__18261) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18259.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__12249__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__12249__auto__,mults){
return (function (p1__18258_SHARP_){
if(cljs.core.truth_(p1__18258_SHARP_.call(null,topic))){
return p1__18258_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__18258_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__12249__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async18262 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18262 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta18263){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta18263 = meta18263;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18262.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_18264,meta18263__$1){
var self__ = this;
var _18264__$1 = this;
return (new cljs.core.async.t_cljs$core$async18262(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta18263__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18262.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_18264){
var self__ = this;
var _18264__$1 = this;
return self__.meta18263;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18262.prototype.cljs$core$async$Mux$ = true;

cljs.core.async.t_cljs$core$async18262.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18262.prototype.cljs$core$async$Pub$ = true;

cljs.core.async.t_cljs$core$async18262.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18262.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18262.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18262.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18262.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta18263","meta18263",-961944468,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async18262.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18262.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18262";

cljs.core.async.t_cljs$core$async18262.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cljs.core.async/t_cljs$core$async18262");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async18262 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async18262(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18263){
return (new cljs.core.async.t_cljs$core$async18262(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta18263));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async18262(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__16469__auto___18388 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___18388,mults,ensure_mult,p){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___18388,mults,ensure_mult,p){
return (function (state_18336){
var state_val_18337 = (state_18336[(1)]);
if((state_val_18337 === (7))){
var inst_18332 = (state_18336[(2)]);
var state_18336__$1 = state_18336;
var statearr_18338_18389 = state_18336__$1;
(statearr_18338_18389[(2)] = inst_18332);

(statearr_18338_18389[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (20))){
var state_18336__$1 = state_18336;
var statearr_18339_18390 = state_18336__$1;
(statearr_18339_18390[(2)] = null);

(statearr_18339_18390[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (1))){
var state_18336__$1 = state_18336;
var statearr_18340_18391 = state_18336__$1;
(statearr_18340_18391[(2)] = null);

(statearr_18340_18391[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (24))){
var inst_18315 = (state_18336[(7)]);
var inst_18324 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_18315);
var state_18336__$1 = state_18336;
var statearr_18341_18392 = state_18336__$1;
(statearr_18341_18392[(2)] = inst_18324);

(statearr_18341_18392[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (4))){
var inst_18267 = (state_18336[(8)]);
var inst_18267__$1 = (state_18336[(2)]);
var inst_18268 = (inst_18267__$1 == null);
var state_18336__$1 = (function (){var statearr_18342 = state_18336;
(statearr_18342[(8)] = inst_18267__$1);

return statearr_18342;
})();
if(cljs.core.truth_(inst_18268)){
var statearr_18343_18393 = state_18336__$1;
(statearr_18343_18393[(1)] = (5));

} else {
var statearr_18344_18394 = state_18336__$1;
(statearr_18344_18394[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (15))){
var inst_18309 = (state_18336[(2)]);
var state_18336__$1 = state_18336;
var statearr_18345_18395 = state_18336__$1;
(statearr_18345_18395[(2)] = inst_18309);

(statearr_18345_18395[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (21))){
var inst_18329 = (state_18336[(2)]);
var state_18336__$1 = (function (){var statearr_18346 = state_18336;
(statearr_18346[(9)] = inst_18329);

return statearr_18346;
})();
var statearr_18347_18396 = state_18336__$1;
(statearr_18347_18396[(2)] = null);

(statearr_18347_18396[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (13))){
var inst_18291 = (state_18336[(10)]);
var inst_18293 = cljs.core.chunked_seq_QMARK_.call(null,inst_18291);
var state_18336__$1 = state_18336;
if(inst_18293){
var statearr_18348_18397 = state_18336__$1;
(statearr_18348_18397[(1)] = (16));

} else {
var statearr_18349_18398 = state_18336__$1;
(statearr_18349_18398[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (22))){
var inst_18321 = (state_18336[(2)]);
var state_18336__$1 = state_18336;
if(cljs.core.truth_(inst_18321)){
var statearr_18350_18399 = state_18336__$1;
(statearr_18350_18399[(1)] = (23));

} else {
var statearr_18351_18400 = state_18336__$1;
(statearr_18351_18400[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (6))){
var inst_18315 = (state_18336[(7)]);
var inst_18317 = (state_18336[(11)]);
var inst_18267 = (state_18336[(8)]);
var inst_18315__$1 = topic_fn.call(null,inst_18267);
var inst_18316 = cljs.core.deref.call(null,mults);
var inst_18317__$1 = cljs.core.get.call(null,inst_18316,inst_18315__$1);
var state_18336__$1 = (function (){var statearr_18352 = state_18336;
(statearr_18352[(7)] = inst_18315__$1);

(statearr_18352[(11)] = inst_18317__$1);

return statearr_18352;
})();
if(cljs.core.truth_(inst_18317__$1)){
var statearr_18353_18401 = state_18336__$1;
(statearr_18353_18401[(1)] = (19));

} else {
var statearr_18354_18402 = state_18336__$1;
(statearr_18354_18402[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (25))){
var inst_18326 = (state_18336[(2)]);
var state_18336__$1 = state_18336;
var statearr_18355_18403 = state_18336__$1;
(statearr_18355_18403[(2)] = inst_18326);

(statearr_18355_18403[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (17))){
var inst_18291 = (state_18336[(10)]);
var inst_18300 = cljs.core.first.call(null,inst_18291);
var inst_18301 = cljs.core.async.muxch_STAR_.call(null,inst_18300);
var inst_18302 = cljs.core.async.close_BANG_.call(null,inst_18301);
var inst_18303 = cljs.core.next.call(null,inst_18291);
var inst_18277 = inst_18303;
var inst_18278 = null;
var inst_18279 = (0);
var inst_18280 = (0);
var state_18336__$1 = (function (){var statearr_18356 = state_18336;
(statearr_18356[(12)] = inst_18278);

(statearr_18356[(13)] = inst_18279);

(statearr_18356[(14)] = inst_18277);

(statearr_18356[(15)] = inst_18280);

(statearr_18356[(16)] = inst_18302);

return statearr_18356;
})();
var statearr_18357_18404 = state_18336__$1;
(statearr_18357_18404[(2)] = null);

(statearr_18357_18404[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (3))){
var inst_18334 = (state_18336[(2)]);
var state_18336__$1 = state_18336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18336__$1,inst_18334);
} else {
if((state_val_18337 === (12))){
var inst_18311 = (state_18336[(2)]);
var state_18336__$1 = state_18336;
var statearr_18358_18405 = state_18336__$1;
(statearr_18358_18405[(2)] = inst_18311);

(statearr_18358_18405[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (2))){
var state_18336__$1 = state_18336;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18336__$1,(4),ch);
} else {
if((state_val_18337 === (23))){
var state_18336__$1 = state_18336;
var statearr_18359_18406 = state_18336__$1;
(statearr_18359_18406[(2)] = null);

(statearr_18359_18406[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (19))){
var inst_18317 = (state_18336[(11)]);
var inst_18267 = (state_18336[(8)]);
var inst_18319 = cljs.core.async.muxch_STAR_.call(null,inst_18317);
var state_18336__$1 = state_18336;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18336__$1,(22),inst_18319,inst_18267);
} else {
if((state_val_18337 === (11))){
var inst_18291 = (state_18336[(10)]);
var inst_18277 = (state_18336[(14)]);
var inst_18291__$1 = cljs.core.seq.call(null,inst_18277);
var state_18336__$1 = (function (){var statearr_18360 = state_18336;
(statearr_18360[(10)] = inst_18291__$1);

return statearr_18360;
})();
if(inst_18291__$1){
var statearr_18361_18407 = state_18336__$1;
(statearr_18361_18407[(1)] = (13));

} else {
var statearr_18362_18408 = state_18336__$1;
(statearr_18362_18408[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (9))){
var inst_18313 = (state_18336[(2)]);
var state_18336__$1 = state_18336;
var statearr_18363_18409 = state_18336__$1;
(statearr_18363_18409[(2)] = inst_18313);

(statearr_18363_18409[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (5))){
var inst_18274 = cljs.core.deref.call(null,mults);
var inst_18275 = cljs.core.vals.call(null,inst_18274);
var inst_18276 = cljs.core.seq.call(null,inst_18275);
var inst_18277 = inst_18276;
var inst_18278 = null;
var inst_18279 = (0);
var inst_18280 = (0);
var state_18336__$1 = (function (){var statearr_18364 = state_18336;
(statearr_18364[(12)] = inst_18278);

(statearr_18364[(13)] = inst_18279);

(statearr_18364[(14)] = inst_18277);

(statearr_18364[(15)] = inst_18280);

return statearr_18364;
})();
var statearr_18365_18410 = state_18336__$1;
(statearr_18365_18410[(2)] = null);

(statearr_18365_18410[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (14))){
var state_18336__$1 = state_18336;
var statearr_18369_18411 = state_18336__$1;
(statearr_18369_18411[(2)] = null);

(statearr_18369_18411[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (16))){
var inst_18291 = (state_18336[(10)]);
var inst_18295 = cljs.core.chunk_first.call(null,inst_18291);
var inst_18296 = cljs.core.chunk_rest.call(null,inst_18291);
var inst_18297 = cljs.core.count.call(null,inst_18295);
var inst_18277 = inst_18296;
var inst_18278 = inst_18295;
var inst_18279 = inst_18297;
var inst_18280 = (0);
var state_18336__$1 = (function (){var statearr_18370 = state_18336;
(statearr_18370[(12)] = inst_18278);

(statearr_18370[(13)] = inst_18279);

(statearr_18370[(14)] = inst_18277);

(statearr_18370[(15)] = inst_18280);

return statearr_18370;
})();
var statearr_18371_18412 = state_18336__$1;
(statearr_18371_18412[(2)] = null);

(statearr_18371_18412[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (10))){
var inst_18278 = (state_18336[(12)]);
var inst_18279 = (state_18336[(13)]);
var inst_18277 = (state_18336[(14)]);
var inst_18280 = (state_18336[(15)]);
var inst_18285 = cljs.core._nth.call(null,inst_18278,inst_18280);
var inst_18286 = cljs.core.async.muxch_STAR_.call(null,inst_18285);
var inst_18287 = cljs.core.async.close_BANG_.call(null,inst_18286);
var inst_18288 = (inst_18280 + (1));
var tmp18366 = inst_18278;
var tmp18367 = inst_18279;
var tmp18368 = inst_18277;
var inst_18277__$1 = tmp18368;
var inst_18278__$1 = tmp18366;
var inst_18279__$1 = tmp18367;
var inst_18280__$1 = inst_18288;
var state_18336__$1 = (function (){var statearr_18372 = state_18336;
(statearr_18372[(12)] = inst_18278__$1);

(statearr_18372[(17)] = inst_18287);

(statearr_18372[(13)] = inst_18279__$1);

(statearr_18372[(14)] = inst_18277__$1);

(statearr_18372[(15)] = inst_18280__$1);

return statearr_18372;
})();
var statearr_18373_18413 = state_18336__$1;
(statearr_18373_18413[(2)] = null);

(statearr_18373_18413[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (18))){
var inst_18306 = (state_18336[(2)]);
var state_18336__$1 = state_18336;
var statearr_18374_18414 = state_18336__$1;
(statearr_18374_18414[(2)] = inst_18306);

(statearr_18374_18414[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18337 === (8))){
var inst_18279 = (state_18336[(13)]);
var inst_18280 = (state_18336[(15)]);
var inst_18282 = (inst_18280 < inst_18279);
var inst_18283 = inst_18282;
var state_18336__$1 = state_18336;
if(cljs.core.truth_(inst_18283)){
var statearr_18375_18415 = state_18336__$1;
(statearr_18375_18415[(1)] = (10));

} else {
var statearr_18376_18416 = state_18336__$1;
(statearr_18376_18416[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___18388,mults,ensure_mult,p))
;
return ((function (switch__16357__auto__,c__16469__auto___18388,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__16358__auto__ = null;
var cljs$core$async$state_machine__16358__auto____0 = (function (){
var statearr_18380 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18380[(0)] = cljs$core$async$state_machine__16358__auto__);

(statearr_18380[(1)] = (1));

return statearr_18380;
});
var cljs$core$async$state_machine__16358__auto____1 = (function (state_18336){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_18336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e18381){if((e18381 instanceof Object)){
var ex__16361__auto__ = e18381;
var statearr_18382_18417 = state_18336;
(statearr_18382_18417[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18336);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18381;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18418 = state_18336;
state_18336 = G__18418;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$state_machine__16358__auto__ = function(state_18336){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16358__auto____1.call(this,state_18336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16358__auto____0;
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16358__auto____1;
return cljs$core$async$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___18388,mults,ensure_mult,p))
})();
var state__16471__auto__ = (function (){var statearr_18383 = f__16470__auto__.call(null);
(statearr_18383[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___18388);

return statearr_18383;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___18388,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args18419 = [];
var len__13324__auto___18422 = arguments.length;
var i__13325__auto___18423 = (0);
while(true){
if((i__13325__auto___18423 < len__13324__auto___18422)){
args18419.push((arguments[i__13325__auto___18423]));

var G__18424 = (i__13325__auto___18423 + (1));
i__13325__auto___18423 = G__18424;
continue;
} else {
}
break;
}

var G__18421 = args18419.length;
switch (G__18421) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18419.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args18426 = [];
var len__13324__auto___18429 = arguments.length;
var i__13325__auto___18430 = (0);
while(true){
if((i__13325__auto___18430 < len__13324__auto___18429)){
args18426.push((arguments[i__13325__auto___18430]));

var G__18431 = (i__13325__auto___18430 + (1));
i__13325__auto___18430 = G__18431;
continue;
} else {
}
break;
}

var G__18428 = args18426.length;
switch (G__18428) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18426.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args18433 = [];
var len__13324__auto___18504 = arguments.length;
var i__13325__auto___18505 = (0);
while(true){
if((i__13325__auto___18505 < len__13324__auto___18504)){
args18433.push((arguments[i__13325__auto___18505]));

var G__18506 = (i__13325__auto___18505 + (1));
i__13325__auto___18505 = G__18506;
continue;
} else {
}
break;
}

var G__18435 = args18433.length;
switch (G__18435) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18433.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__16469__auto___18508 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___18508,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___18508,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_18474){
var state_val_18475 = (state_18474[(1)]);
if((state_val_18475 === (7))){
var state_18474__$1 = state_18474;
var statearr_18476_18509 = state_18474__$1;
(statearr_18476_18509[(2)] = null);

(statearr_18476_18509[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (1))){
var state_18474__$1 = state_18474;
var statearr_18477_18510 = state_18474__$1;
(statearr_18477_18510[(2)] = null);

(statearr_18477_18510[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (4))){
var inst_18438 = (state_18474[(7)]);
var inst_18440 = (inst_18438 < cnt);
var state_18474__$1 = state_18474;
if(cljs.core.truth_(inst_18440)){
var statearr_18478_18511 = state_18474__$1;
(statearr_18478_18511[(1)] = (6));

} else {
var statearr_18479_18512 = state_18474__$1;
(statearr_18479_18512[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (15))){
var inst_18470 = (state_18474[(2)]);
var state_18474__$1 = state_18474;
var statearr_18480_18513 = state_18474__$1;
(statearr_18480_18513[(2)] = inst_18470);

(statearr_18480_18513[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (13))){
var inst_18463 = cljs.core.async.close_BANG_.call(null,out);
var state_18474__$1 = state_18474;
var statearr_18481_18514 = state_18474__$1;
(statearr_18481_18514[(2)] = inst_18463);

(statearr_18481_18514[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (6))){
var state_18474__$1 = state_18474;
var statearr_18482_18515 = state_18474__$1;
(statearr_18482_18515[(2)] = null);

(statearr_18482_18515[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (3))){
var inst_18472 = (state_18474[(2)]);
var state_18474__$1 = state_18474;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18474__$1,inst_18472);
} else {
if((state_val_18475 === (12))){
var inst_18460 = (state_18474[(8)]);
var inst_18460__$1 = (state_18474[(2)]);
var inst_18461 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_18460__$1);
var state_18474__$1 = (function (){var statearr_18483 = state_18474;
(statearr_18483[(8)] = inst_18460__$1);

return statearr_18483;
})();
if(cljs.core.truth_(inst_18461)){
var statearr_18484_18516 = state_18474__$1;
(statearr_18484_18516[(1)] = (13));

} else {
var statearr_18485_18517 = state_18474__$1;
(statearr_18485_18517[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (2))){
var inst_18437 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_18438 = (0);
var state_18474__$1 = (function (){var statearr_18486 = state_18474;
(statearr_18486[(7)] = inst_18438);

(statearr_18486[(9)] = inst_18437);

return statearr_18486;
})();
var statearr_18487_18518 = state_18474__$1;
(statearr_18487_18518[(2)] = null);

(statearr_18487_18518[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (11))){
var inst_18438 = (state_18474[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_18474,(10),Object,null,(9));
var inst_18447 = chs__$1.call(null,inst_18438);
var inst_18448 = done.call(null,inst_18438);
var inst_18449 = cljs.core.async.take_BANG_.call(null,inst_18447,inst_18448);
var state_18474__$1 = state_18474;
var statearr_18488_18519 = state_18474__$1;
(statearr_18488_18519[(2)] = inst_18449);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18474__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (9))){
var inst_18438 = (state_18474[(7)]);
var inst_18451 = (state_18474[(2)]);
var inst_18452 = (inst_18438 + (1));
var inst_18438__$1 = inst_18452;
var state_18474__$1 = (function (){var statearr_18489 = state_18474;
(statearr_18489[(7)] = inst_18438__$1);

(statearr_18489[(10)] = inst_18451);

return statearr_18489;
})();
var statearr_18490_18520 = state_18474__$1;
(statearr_18490_18520[(2)] = null);

(statearr_18490_18520[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (5))){
var inst_18458 = (state_18474[(2)]);
var state_18474__$1 = (function (){var statearr_18491 = state_18474;
(statearr_18491[(11)] = inst_18458);

return statearr_18491;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18474__$1,(12),dchan);
} else {
if((state_val_18475 === (14))){
var inst_18460 = (state_18474[(8)]);
var inst_18465 = cljs.core.apply.call(null,f,inst_18460);
var state_18474__$1 = state_18474;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18474__$1,(16),out,inst_18465);
} else {
if((state_val_18475 === (16))){
var inst_18467 = (state_18474[(2)]);
var state_18474__$1 = (function (){var statearr_18492 = state_18474;
(statearr_18492[(12)] = inst_18467);

return statearr_18492;
})();
var statearr_18493_18521 = state_18474__$1;
(statearr_18493_18521[(2)] = null);

(statearr_18493_18521[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (10))){
var inst_18442 = (state_18474[(2)]);
var inst_18443 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_18474__$1 = (function (){var statearr_18494 = state_18474;
(statearr_18494[(13)] = inst_18442);

return statearr_18494;
})();
var statearr_18495_18522 = state_18474__$1;
(statearr_18495_18522[(2)] = inst_18443);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18474__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18475 === (8))){
var inst_18456 = (state_18474[(2)]);
var state_18474__$1 = state_18474;
var statearr_18496_18523 = state_18474__$1;
(statearr_18496_18523[(2)] = inst_18456);

(statearr_18496_18523[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___18508,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__16357__auto__,c__16469__auto___18508,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__16358__auto__ = null;
var cljs$core$async$state_machine__16358__auto____0 = (function (){
var statearr_18500 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18500[(0)] = cljs$core$async$state_machine__16358__auto__);

(statearr_18500[(1)] = (1));

return statearr_18500;
});
var cljs$core$async$state_machine__16358__auto____1 = (function (state_18474){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_18474);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e18501){if((e18501 instanceof Object)){
var ex__16361__auto__ = e18501;
var statearr_18502_18524 = state_18474;
(statearr_18502_18524[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18474);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18501;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18525 = state_18474;
state_18474 = G__18525;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$state_machine__16358__auto__ = function(state_18474){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16358__auto____1.call(this,state_18474);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16358__auto____0;
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16358__auto____1;
return cljs$core$async$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___18508,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__16471__auto__ = (function (){var statearr_18503 = f__16470__auto__.call(null);
(statearr_18503[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___18508);

return statearr_18503;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___18508,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args18527 = [];
var len__13324__auto___18585 = arguments.length;
var i__13325__auto___18586 = (0);
while(true){
if((i__13325__auto___18586 < len__13324__auto___18585)){
args18527.push((arguments[i__13325__auto___18586]));

var G__18587 = (i__13325__auto___18586 + (1));
i__13325__auto___18586 = G__18587;
continue;
} else {
}
break;
}

var G__18529 = args18527.length;
switch (G__18529) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18527.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16469__auto___18589 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___18589,out){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___18589,out){
return (function (state_18561){
var state_val_18562 = (state_18561[(1)]);
if((state_val_18562 === (7))){
var inst_18540 = (state_18561[(7)]);
var inst_18541 = (state_18561[(8)]);
var inst_18540__$1 = (state_18561[(2)]);
var inst_18541__$1 = cljs.core.nth.call(null,inst_18540__$1,(0),null);
var inst_18542 = cljs.core.nth.call(null,inst_18540__$1,(1),null);
var inst_18543 = (inst_18541__$1 == null);
var state_18561__$1 = (function (){var statearr_18563 = state_18561;
(statearr_18563[(7)] = inst_18540__$1);

(statearr_18563[(8)] = inst_18541__$1);

(statearr_18563[(9)] = inst_18542);

return statearr_18563;
})();
if(cljs.core.truth_(inst_18543)){
var statearr_18564_18590 = state_18561__$1;
(statearr_18564_18590[(1)] = (8));

} else {
var statearr_18565_18591 = state_18561__$1;
(statearr_18565_18591[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18562 === (1))){
var inst_18530 = cljs.core.vec.call(null,chs);
var inst_18531 = inst_18530;
var state_18561__$1 = (function (){var statearr_18566 = state_18561;
(statearr_18566[(10)] = inst_18531);

return statearr_18566;
})();
var statearr_18567_18592 = state_18561__$1;
(statearr_18567_18592[(2)] = null);

(statearr_18567_18592[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18562 === (4))){
var inst_18531 = (state_18561[(10)]);
var state_18561__$1 = state_18561;
return cljs.core.async.ioc_alts_BANG_.call(null,state_18561__$1,(7),inst_18531);
} else {
if((state_val_18562 === (6))){
var inst_18557 = (state_18561[(2)]);
var state_18561__$1 = state_18561;
var statearr_18568_18593 = state_18561__$1;
(statearr_18568_18593[(2)] = inst_18557);

(statearr_18568_18593[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18562 === (3))){
var inst_18559 = (state_18561[(2)]);
var state_18561__$1 = state_18561;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18561__$1,inst_18559);
} else {
if((state_val_18562 === (2))){
var inst_18531 = (state_18561[(10)]);
var inst_18533 = cljs.core.count.call(null,inst_18531);
var inst_18534 = (inst_18533 > (0));
var state_18561__$1 = state_18561;
if(cljs.core.truth_(inst_18534)){
var statearr_18570_18594 = state_18561__$1;
(statearr_18570_18594[(1)] = (4));

} else {
var statearr_18571_18595 = state_18561__$1;
(statearr_18571_18595[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18562 === (11))){
var inst_18531 = (state_18561[(10)]);
var inst_18550 = (state_18561[(2)]);
var tmp18569 = inst_18531;
var inst_18531__$1 = tmp18569;
var state_18561__$1 = (function (){var statearr_18572 = state_18561;
(statearr_18572[(11)] = inst_18550);

(statearr_18572[(10)] = inst_18531__$1);

return statearr_18572;
})();
var statearr_18573_18596 = state_18561__$1;
(statearr_18573_18596[(2)] = null);

(statearr_18573_18596[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18562 === (9))){
var inst_18541 = (state_18561[(8)]);
var state_18561__$1 = state_18561;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18561__$1,(11),out,inst_18541);
} else {
if((state_val_18562 === (5))){
var inst_18555 = cljs.core.async.close_BANG_.call(null,out);
var state_18561__$1 = state_18561;
var statearr_18574_18597 = state_18561__$1;
(statearr_18574_18597[(2)] = inst_18555);

(statearr_18574_18597[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18562 === (10))){
var inst_18553 = (state_18561[(2)]);
var state_18561__$1 = state_18561;
var statearr_18575_18598 = state_18561__$1;
(statearr_18575_18598[(2)] = inst_18553);

(statearr_18575_18598[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18562 === (8))){
var inst_18540 = (state_18561[(7)]);
var inst_18531 = (state_18561[(10)]);
var inst_18541 = (state_18561[(8)]);
var inst_18542 = (state_18561[(9)]);
var inst_18545 = (function (){var cs = inst_18531;
var vec__18536 = inst_18540;
var v = inst_18541;
var c = inst_18542;
return ((function (cs,vec__18536,v,c,inst_18540,inst_18531,inst_18541,inst_18542,state_val_18562,c__16469__auto___18589,out){
return (function (p1__18526_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__18526_SHARP_);
});
;})(cs,vec__18536,v,c,inst_18540,inst_18531,inst_18541,inst_18542,state_val_18562,c__16469__auto___18589,out))
})();
var inst_18546 = cljs.core.filterv.call(null,inst_18545,inst_18531);
var inst_18531__$1 = inst_18546;
var state_18561__$1 = (function (){var statearr_18576 = state_18561;
(statearr_18576[(10)] = inst_18531__$1);

return statearr_18576;
})();
var statearr_18577_18599 = state_18561__$1;
(statearr_18577_18599[(2)] = null);

(statearr_18577_18599[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___18589,out))
;
return ((function (switch__16357__auto__,c__16469__auto___18589,out){
return (function() {
var cljs$core$async$state_machine__16358__auto__ = null;
var cljs$core$async$state_machine__16358__auto____0 = (function (){
var statearr_18581 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18581[(0)] = cljs$core$async$state_machine__16358__auto__);

(statearr_18581[(1)] = (1));

return statearr_18581;
});
var cljs$core$async$state_machine__16358__auto____1 = (function (state_18561){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_18561);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e18582){if((e18582 instanceof Object)){
var ex__16361__auto__ = e18582;
var statearr_18583_18600 = state_18561;
(statearr_18583_18600[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18561);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18582;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18601 = state_18561;
state_18561 = G__18601;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$state_machine__16358__auto__ = function(state_18561){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16358__auto____1.call(this,state_18561);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16358__auto____0;
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16358__auto____1;
return cljs$core$async$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___18589,out))
})();
var state__16471__auto__ = (function (){var statearr_18584 = f__16470__auto__.call(null);
(statearr_18584[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___18589);

return statearr_18584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___18589,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args18602 = [];
var len__13324__auto___18651 = arguments.length;
var i__13325__auto___18652 = (0);
while(true){
if((i__13325__auto___18652 < len__13324__auto___18651)){
args18602.push((arguments[i__13325__auto___18652]));

var G__18653 = (i__13325__auto___18652 + (1));
i__13325__auto___18652 = G__18653;
continue;
} else {
}
break;
}

var G__18604 = args18602.length;
switch (G__18604) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18602.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16469__auto___18655 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___18655,out){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___18655,out){
return (function (state_18628){
var state_val_18629 = (state_18628[(1)]);
if((state_val_18629 === (7))){
var inst_18610 = (state_18628[(7)]);
var inst_18610__$1 = (state_18628[(2)]);
var inst_18611 = (inst_18610__$1 == null);
var inst_18612 = cljs.core.not.call(null,inst_18611);
var state_18628__$1 = (function (){var statearr_18630 = state_18628;
(statearr_18630[(7)] = inst_18610__$1);

return statearr_18630;
})();
if(inst_18612){
var statearr_18631_18656 = state_18628__$1;
(statearr_18631_18656[(1)] = (8));

} else {
var statearr_18632_18657 = state_18628__$1;
(statearr_18632_18657[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18629 === (1))){
var inst_18605 = (0);
var state_18628__$1 = (function (){var statearr_18633 = state_18628;
(statearr_18633[(8)] = inst_18605);

return statearr_18633;
})();
var statearr_18634_18658 = state_18628__$1;
(statearr_18634_18658[(2)] = null);

(statearr_18634_18658[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18629 === (4))){
var state_18628__$1 = state_18628;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18628__$1,(7),ch);
} else {
if((state_val_18629 === (6))){
var inst_18623 = (state_18628[(2)]);
var state_18628__$1 = state_18628;
var statearr_18635_18659 = state_18628__$1;
(statearr_18635_18659[(2)] = inst_18623);

(statearr_18635_18659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18629 === (3))){
var inst_18625 = (state_18628[(2)]);
var inst_18626 = cljs.core.async.close_BANG_.call(null,out);
var state_18628__$1 = (function (){var statearr_18636 = state_18628;
(statearr_18636[(9)] = inst_18625);

return statearr_18636;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18628__$1,inst_18626);
} else {
if((state_val_18629 === (2))){
var inst_18605 = (state_18628[(8)]);
var inst_18607 = (inst_18605 < n);
var state_18628__$1 = state_18628;
if(cljs.core.truth_(inst_18607)){
var statearr_18637_18660 = state_18628__$1;
(statearr_18637_18660[(1)] = (4));

} else {
var statearr_18638_18661 = state_18628__$1;
(statearr_18638_18661[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18629 === (11))){
var inst_18605 = (state_18628[(8)]);
var inst_18615 = (state_18628[(2)]);
var inst_18616 = (inst_18605 + (1));
var inst_18605__$1 = inst_18616;
var state_18628__$1 = (function (){var statearr_18639 = state_18628;
(statearr_18639[(10)] = inst_18615);

(statearr_18639[(8)] = inst_18605__$1);

return statearr_18639;
})();
var statearr_18640_18662 = state_18628__$1;
(statearr_18640_18662[(2)] = null);

(statearr_18640_18662[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18629 === (9))){
var state_18628__$1 = state_18628;
var statearr_18641_18663 = state_18628__$1;
(statearr_18641_18663[(2)] = null);

(statearr_18641_18663[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18629 === (5))){
var state_18628__$1 = state_18628;
var statearr_18642_18664 = state_18628__$1;
(statearr_18642_18664[(2)] = null);

(statearr_18642_18664[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18629 === (10))){
var inst_18620 = (state_18628[(2)]);
var state_18628__$1 = state_18628;
var statearr_18643_18665 = state_18628__$1;
(statearr_18643_18665[(2)] = inst_18620);

(statearr_18643_18665[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18629 === (8))){
var inst_18610 = (state_18628[(7)]);
var state_18628__$1 = state_18628;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18628__$1,(11),out,inst_18610);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___18655,out))
;
return ((function (switch__16357__auto__,c__16469__auto___18655,out){
return (function() {
var cljs$core$async$state_machine__16358__auto__ = null;
var cljs$core$async$state_machine__16358__auto____0 = (function (){
var statearr_18647 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_18647[(0)] = cljs$core$async$state_machine__16358__auto__);

(statearr_18647[(1)] = (1));

return statearr_18647;
});
var cljs$core$async$state_machine__16358__auto____1 = (function (state_18628){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_18628);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e18648){if((e18648 instanceof Object)){
var ex__16361__auto__ = e18648;
var statearr_18649_18666 = state_18628;
(statearr_18649_18666[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18628);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18648;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18667 = state_18628;
state_18628 = G__18667;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$state_machine__16358__auto__ = function(state_18628){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16358__auto____1.call(this,state_18628);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16358__auto____0;
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16358__auto____1;
return cljs$core$async$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___18655,out))
})();
var state__16471__auto__ = (function (){var statearr_18650 = f__16470__auto__.call(null);
(statearr_18650[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___18655);

return statearr_18650;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___18655,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18675 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18675 = (function (map_LT_,f,ch,meta18676){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta18676 = meta18676;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18675.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18677,meta18676__$1){
var self__ = this;
var _18677__$1 = this;
return (new cljs.core.async.t_cljs$core$async18675(self__.map_LT_,self__.f,self__.ch,meta18676__$1));
});

cljs.core.async.t_cljs$core$async18675.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18677){
var self__ = this;
var _18677__$1 = this;
return self__.meta18676;
});

cljs.core.async.t_cljs$core$async18675.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async18675.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18675.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18675.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async18675.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async18678 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18678 = (function (map_LT_,f,ch,meta18676,_,fn1,meta18679){
this.map_LT_ = map_LT_;
this.f = f;
this.ch = ch;
this.meta18676 = meta18676;
this._ = _;
this.fn1 = fn1;
this.meta18679 = meta18679;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18678.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_18680,meta18679__$1){
var self__ = this;
var _18680__$1 = this;
return (new cljs.core.async.t_cljs$core$async18678(self__.map_LT_,self__.f,self__.ch,self__.meta18676,self__._,self__.fn1,meta18679__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async18678.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_18680){
var self__ = this;
var _18680__$1 = this;
return self__.meta18679;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18678.prototype.cljs$core$async$impl$protocols$Handler$ = true;

cljs.core.async.t_cljs$core$async18678.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18678.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async18678.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__18668_SHARP_){
return f1.call(null,(((p1__18668_SHARP_ == null))?null:self__.f.call(null,p1__18668_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async18678.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18676","meta18676",2051703812,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async18675","cljs.core.async/t_cljs$core$async18675",1865643740,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta18679","meta18679",-423714622,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async18678.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18678.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18678";

cljs.core.async.t_cljs$core$async18678.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cljs.core.async/t_cljs$core$async18678");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async18678 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18678(map_LT___$1,f__$1,ch__$1,meta18676__$1,___$2,fn1__$1,meta18679){
return (new cljs.core.async.t_cljs$core$async18678(map_LT___$1,f__$1,ch__$1,meta18676__$1,___$2,fn1__$1,meta18679));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async18678(self__.map_LT_,self__.f,self__.ch,self__.meta18676,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__12237__auto__ = ret;
if(cljs.core.truth_(and__12237__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__12237__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async18675.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async18675.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async18675.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map<","map<",-1235808357,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18676","meta18676",2051703812,null)], null);
});

cljs.core.async.t_cljs$core$async18675.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18675.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18675";

cljs.core.async.t_cljs$core$async18675.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cljs.core.async/t_cljs$core$async18675");
});

cljs.core.async.__GT_t_cljs$core$async18675 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async18675(map_LT___$1,f__$1,ch__$1,meta18676){
return (new cljs.core.async.t_cljs$core$async18675(map_LT___$1,f__$1,ch__$1,meta18676));
});

}

return (new cljs.core.async.t_cljs$core$async18675(cljs$core$async$map_LT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async18684 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18684 = (function (map_GT_,f,ch,meta18685){
this.map_GT_ = map_GT_;
this.f = f;
this.ch = ch;
this.meta18685 = meta18685;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18684.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18686,meta18685__$1){
var self__ = this;
var _18686__$1 = this;
return (new cljs.core.async.t_cljs$core$async18684(self__.map_GT_,self__.f,self__.ch,meta18685__$1));
});

cljs.core.async.t_cljs$core$async18684.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18686){
var self__ = this;
var _18686__$1 = this;
return self__.meta18685;
});

cljs.core.async.t_cljs$core$async18684.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async18684.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18684.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async18684.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18684.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async18684.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async18684.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"map>","map>",1676369295,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18685","meta18685",-2143521046,null)], null);
});

cljs.core.async.t_cljs$core$async18684.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18684.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18684";

cljs.core.async.t_cljs$core$async18684.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cljs.core.async/t_cljs$core$async18684");
});

cljs.core.async.__GT_t_cljs$core$async18684 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async18684(map_GT___$1,f__$1,ch__$1,meta18685){
return (new cljs.core.async.t_cljs$core$async18684(map_GT___$1,f__$1,ch__$1,meta18685));
});

}

return (new cljs.core.async.t_cljs$core$async18684(cljs$core$async$map_GT_,f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async18690 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async18690 = (function (filter_GT_,p,ch,meta18691){
this.filter_GT_ = filter_GT_;
this.p = p;
this.ch = ch;
this.meta18691 = meta18691;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async18690.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_18692,meta18691__$1){
var self__ = this;
var _18692__$1 = this;
return (new cljs.core.async.t_cljs$core$async18690(self__.filter_GT_,self__.p,self__.ch,meta18691__$1));
});

cljs.core.async.t_cljs$core$async18690.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_18692){
var self__ = this;
var _18692__$1 = this;
return self__.meta18691;
});

cljs.core.async.t_cljs$core$async18690.prototype.cljs$core$async$impl$protocols$Channel$ = true;

cljs.core.async.t_cljs$core$async18690.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18690.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async18690.prototype.cljs$core$async$impl$protocols$ReadPort$ = true;

cljs.core.async.t_cljs$core$async18690.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async18690.prototype.cljs$core$async$impl$protocols$WritePort$ = true;

cljs.core.async.t_cljs$core$async18690.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async18690.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.with_meta(new cljs.core.Symbol(null,"filter>","filter>",-37644455,null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"arglists","arglists",1661989754),cljs.core.list(new cljs.core.Symbol(null,"quote","quote",1377916282,null),cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null)], null))),new cljs.core.Keyword(null,"doc","doc",1913296891),"Deprecated - this function will be removed. Use transducer instead"], null)),new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta18691","meta18691",-1552105983,null)], null);
});

cljs.core.async.t_cljs$core$async18690.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async18690.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async18690";

cljs.core.async.t_cljs$core$async18690.cljs$lang$ctorPrWriter = (function (this__12855__auto__,writer__12856__auto__,opt__12857__auto__){
return cljs.core._write.call(null,writer__12856__auto__,"cljs.core.async/t_cljs$core$async18690");
});

cljs.core.async.__GT_t_cljs$core$async18690 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async18690(filter_GT___$1,p__$1,ch__$1,meta18691){
return (new cljs.core.async.t_cljs$core$async18690(filter_GT___$1,p__$1,ch__$1,meta18691));
});

}

return (new cljs.core.async.t_cljs$core$async18690(cljs$core$async$filter_GT_,p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args18693 = [];
var len__13324__auto___18737 = arguments.length;
var i__13325__auto___18738 = (0);
while(true){
if((i__13325__auto___18738 < len__13324__auto___18737)){
args18693.push((arguments[i__13325__auto___18738]));

var G__18739 = (i__13325__auto___18738 + (1));
i__13325__auto___18738 = G__18739;
continue;
} else {
}
break;
}

var G__18695 = args18693.length;
switch (G__18695) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18693.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16469__auto___18741 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___18741,out){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___18741,out){
return (function (state_18716){
var state_val_18717 = (state_18716[(1)]);
if((state_val_18717 === (7))){
var inst_18712 = (state_18716[(2)]);
var state_18716__$1 = state_18716;
var statearr_18718_18742 = state_18716__$1;
(statearr_18718_18742[(2)] = inst_18712);

(statearr_18718_18742[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18717 === (1))){
var state_18716__$1 = state_18716;
var statearr_18719_18743 = state_18716__$1;
(statearr_18719_18743[(2)] = null);

(statearr_18719_18743[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18717 === (4))){
var inst_18698 = (state_18716[(7)]);
var inst_18698__$1 = (state_18716[(2)]);
var inst_18699 = (inst_18698__$1 == null);
var state_18716__$1 = (function (){var statearr_18720 = state_18716;
(statearr_18720[(7)] = inst_18698__$1);

return statearr_18720;
})();
if(cljs.core.truth_(inst_18699)){
var statearr_18721_18744 = state_18716__$1;
(statearr_18721_18744[(1)] = (5));

} else {
var statearr_18722_18745 = state_18716__$1;
(statearr_18722_18745[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18717 === (6))){
var inst_18698 = (state_18716[(7)]);
var inst_18703 = p.call(null,inst_18698);
var state_18716__$1 = state_18716;
if(cljs.core.truth_(inst_18703)){
var statearr_18723_18746 = state_18716__$1;
(statearr_18723_18746[(1)] = (8));

} else {
var statearr_18724_18747 = state_18716__$1;
(statearr_18724_18747[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18717 === (3))){
var inst_18714 = (state_18716[(2)]);
var state_18716__$1 = state_18716;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18716__$1,inst_18714);
} else {
if((state_val_18717 === (2))){
var state_18716__$1 = state_18716;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18716__$1,(4),ch);
} else {
if((state_val_18717 === (11))){
var inst_18706 = (state_18716[(2)]);
var state_18716__$1 = state_18716;
var statearr_18725_18748 = state_18716__$1;
(statearr_18725_18748[(2)] = inst_18706);

(statearr_18725_18748[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18717 === (9))){
var state_18716__$1 = state_18716;
var statearr_18726_18749 = state_18716__$1;
(statearr_18726_18749[(2)] = null);

(statearr_18726_18749[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18717 === (5))){
var inst_18701 = cljs.core.async.close_BANG_.call(null,out);
var state_18716__$1 = state_18716;
var statearr_18727_18750 = state_18716__$1;
(statearr_18727_18750[(2)] = inst_18701);

(statearr_18727_18750[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18717 === (10))){
var inst_18709 = (state_18716[(2)]);
var state_18716__$1 = (function (){var statearr_18728 = state_18716;
(statearr_18728[(8)] = inst_18709);

return statearr_18728;
})();
var statearr_18729_18751 = state_18716__$1;
(statearr_18729_18751[(2)] = null);

(statearr_18729_18751[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18717 === (8))){
var inst_18698 = (state_18716[(7)]);
var state_18716__$1 = state_18716;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18716__$1,(11),out,inst_18698);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___18741,out))
;
return ((function (switch__16357__auto__,c__16469__auto___18741,out){
return (function() {
var cljs$core$async$state_machine__16358__auto__ = null;
var cljs$core$async$state_machine__16358__auto____0 = (function (){
var statearr_18733 = [null,null,null,null,null,null,null,null,null];
(statearr_18733[(0)] = cljs$core$async$state_machine__16358__auto__);

(statearr_18733[(1)] = (1));

return statearr_18733;
});
var cljs$core$async$state_machine__16358__auto____1 = (function (state_18716){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_18716);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e18734){if((e18734 instanceof Object)){
var ex__16361__auto__ = e18734;
var statearr_18735_18752 = state_18716;
(statearr_18735_18752[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18716);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18734;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18753 = state_18716;
state_18716 = G__18753;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$state_machine__16358__auto__ = function(state_18716){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16358__auto____1.call(this,state_18716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16358__auto____0;
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16358__auto____1;
return cljs$core$async$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___18741,out))
})();
var state__16471__auto__ = (function (){var statearr_18736 = f__16470__auto__.call(null);
(statearr_18736[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___18741);

return statearr_18736;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___18741,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args18754 = [];
var len__13324__auto___18757 = arguments.length;
var i__13325__auto___18758 = (0);
while(true){
if((i__13325__auto___18758 < len__13324__auto___18757)){
args18754.push((arguments[i__13325__auto___18758]));

var G__18759 = (i__13325__auto___18758 + (1));
i__13325__auto___18758 = G__18759;
continue;
} else {
}
break;
}

var G__18756 = args18754.length;
switch (G__18756) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18754.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__16469__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto__){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto__){
return (function (state_18926){
var state_val_18927 = (state_18926[(1)]);
if((state_val_18927 === (7))){
var inst_18922 = (state_18926[(2)]);
var state_18926__$1 = state_18926;
var statearr_18928_18969 = state_18926__$1;
(statearr_18928_18969[(2)] = inst_18922);

(statearr_18928_18969[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (20))){
var inst_18892 = (state_18926[(7)]);
var inst_18903 = (state_18926[(2)]);
var inst_18904 = cljs.core.next.call(null,inst_18892);
var inst_18878 = inst_18904;
var inst_18879 = null;
var inst_18880 = (0);
var inst_18881 = (0);
var state_18926__$1 = (function (){var statearr_18929 = state_18926;
(statearr_18929[(8)] = inst_18878);

(statearr_18929[(9)] = inst_18903);

(statearr_18929[(10)] = inst_18879);

(statearr_18929[(11)] = inst_18880);

(statearr_18929[(12)] = inst_18881);

return statearr_18929;
})();
var statearr_18930_18970 = state_18926__$1;
(statearr_18930_18970[(2)] = null);

(statearr_18930_18970[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (1))){
var state_18926__$1 = state_18926;
var statearr_18931_18971 = state_18926__$1;
(statearr_18931_18971[(2)] = null);

(statearr_18931_18971[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (4))){
var inst_18867 = (state_18926[(13)]);
var inst_18867__$1 = (state_18926[(2)]);
var inst_18868 = (inst_18867__$1 == null);
var state_18926__$1 = (function (){var statearr_18932 = state_18926;
(statearr_18932[(13)] = inst_18867__$1);

return statearr_18932;
})();
if(cljs.core.truth_(inst_18868)){
var statearr_18933_18972 = state_18926__$1;
(statearr_18933_18972[(1)] = (5));

} else {
var statearr_18934_18973 = state_18926__$1;
(statearr_18934_18973[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (15))){
var state_18926__$1 = state_18926;
var statearr_18938_18974 = state_18926__$1;
(statearr_18938_18974[(2)] = null);

(statearr_18938_18974[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (21))){
var state_18926__$1 = state_18926;
var statearr_18939_18975 = state_18926__$1;
(statearr_18939_18975[(2)] = null);

(statearr_18939_18975[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (13))){
var inst_18878 = (state_18926[(8)]);
var inst_18879 = (state_18926[(10)]);
var inst_18880 = (state_18926[(11)]);
var inst_18881 = (state_18926[(12)]);
var inst_18888 = (state_18926[(2)]);
var inst_18889 = (inst_18881 + (1));
var tmp18935 = inst_18878;
var tmp18936 = inst_18879;
var tmp18937 = inst_18880;
var inst_18878__$1 = tmp18935;
var inst_18879__$1 = tmp18936;
var inst_18880__$1 = tmp18937;
var inst_18881__$1 = inst_18889;
var state_18926__$1 = (function (){var statearr_18940 = state_18926;
(statearr_18940[(8)] = inst_18878__$1);

(statearr_18940[(14)] = inst_18888);

(statearr_18940[(10)] = inst_18879__$1);

(statearr_18940[(11)] = inst_18880__$1);

(statearr_18940[(12)] = inst_18881__$1);

return statearr_18940;
})();
var statearr_18941_18976 = state_18926__$1;
(statearr_18941_18976[(2)] = null);

(statearr_18941_18976[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (22))){
var state_18926__$1 = state_18926;
var statearr_18942_18977 = state_18926__$1;
(statearr_18942_18977[(2)] = null);

(statearr_18942_18977[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (6))){
var inst_18867 = (state_18926[(13)]);
var inst_18876 = f.call(null,inst_18867);
var inst_18877 = cljs.core.seq.call(null,inst_18876);
var inst_18878 = inst_18877;
var inst_18879 = null;
var inst_18880 = (0);
var inst_18881 = (0);
var state_18926__$1 = (function (){var statearr_18943 = state_18926;
(statearr_18943[(8)] = inst_18878);

(statearr_18943[(10)] = inst_18879);

(statearr_18943[(11)] = inst_18880);

(statearr_18943[(12)] = inst_18881);

return statearr_18943;
})();
var statearr_18944_18978 = state_18926__$1;
(statearr_18944_18978[(2)] = null);

(statearr_18944_18978[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (17))){
var inst_18892 = (state_18926[(7)]);
var inst_18896 = cljs.core.chunk_first.call(null,inst_18892);
var inst_18897 = cljs.core.chunk_rest.call(null,inst_18892);
var inst_18898 = cljs.core.count.call(null,inst_18896);
var inst_18878 = inst_18897;
var inst_18879 = inst_18896;
var inst_18880 = inst_18898;
var inst_18881 = (0);
var state_18926__$1 = (function (){var statearr_18945 = state_18926;
(statearr_18945[(8)] = inst_18878);

(statearr_18945[(10)] = inst_18879);

(statearr_18945[(11)] = inst_18880);

(statearr_18945[(12)] = inst_18881);

return statearr_18945;
})();
var statearr_18946_18979 = state_18926__$1;
(statearr_18946_18979[(2)] = null);

(statearr_18946_18979[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (3))){
var inst_18924 = (state_18926[(2)]);
var state_18926__$1 = state_18926;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_18926__$1,inst_18924);
} else {
if((state_val_18927 === (12))){
var inst_18912 = (state_18926[(2)]);
var state_18926__$1 = state_18926;
var statearr_18947_18980 = state_18926__$1;
(statearr_18947_18980[(2)] = inst_18912);

(statearr_18947_18980[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (2))){
var state_18926__$1 = state_18926;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_18926__$1,(4),in$);
} else {
if((state_val_18927 === (23))){
var inst_18920 = (state_18926[(2)]);
var state_18926__$1 = state_18926;
var statearr_18948_18981 = state_18926__$1;
(statearr_18948_18981[(2)] = inst_18920);

(statearr_18948_18981[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (19))){
var inst_18907 = (state_18926[(2)]);
var state_18926__$1 = state_18926;
var statearr_18949_18982 = state_18926__$1;
(statearr_18949_18982[(2)] = inst_18907);

(statearr_18949_18982[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (11))){
var inst_18878 = (state_18926[(8)]);
var inst_18892 = (state_18926[(7)]);
var inst_18892__$1 = cljs.core.seq.call(null,inst_18878);
var state_18926__$1 = (function (){var statearr_18950 = state_18926;
(statearr_18950[(7)] = inst_18892__$1);

return statearr_18950;
})();
if(inst_18892__$1){
var statearr_18951_18983 = state_18926__$1;
(statearr_18951_18983[(1)] = (14));

} else {
var statearr_18952_18984 = state_18926__$1;
(statearr_18952_18984[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (9))){
var inst_18914 = (state_18926[(2)]);
var inst_18915 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_18926__$1 = (function (){var statearr_18953 = state_18926;
(statearr_18953[(15)] = inst_18914);

return statearr_18953;
})();
if(cljs.core.truth_(inst_18915)){
var statearr_18954_18985 = state_18926__$1;
(statearr_18954_18985[(1)] = (21));

} else {
var statearr_18955_18986 = state_18926__$1;
(statearr_18955_18986[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (5))){
var inst_18870 = cljs.core.async.close_BANG_.call(null,out);
var state_18926__$1 = state_18926;
var statearr_18956_18987 = state_18926__$1;
(statearr_18956_18987[(2)] = inst_18870);

(statearr_18956_18987[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (14))){
var inst_18892 = (state_18926[(7)]);
var inst_18894 = cljs.core.chunked_seq_QMARK_.call(null,inst_18892);
var state_18926__$1 = state_18926;
if(inst_18894){
var statearr_18957_18988 = state_18926__$1;
(statearr_18957_18988[(1)] = (17));

} else {
var statearr_18958_18989 = state_18926__$1;
(statearr_18958_18989[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (16))){
var inst_18910 = (state_18926[(2)]);
var state_18926__$1 = state_18926;
var statearr_18959_18990 = state_18926__$1;
(statearr_18959_18990[(2)] = inst_18910);

(statearr_18959_18990[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_18927 === (10))){
var inst_18879 = (state_18926[(10)]);
var inst_18881 = (state_18926[(12)]);
var inst_18886 = cljs.core._nth.call(null,inst_18879,inst_18881);
var state_18926__$1 = state_18926;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18926__$1,(13),out,inst_18886);
} else {
if((state_val_18927 === (18))){
var inst_18892 = (state_18926[(7)]);
var inst_18901 = cljs.core.first.call(null,inst_18892);
var state_18926__$1 = state_18926;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_18926__$1,(20),out,inst_18901);
} else {
if((state_val_18927 === (8))){
var inst_18880 = (state_18926[(11)]);
var inst_18881 = (state_18926[(12)]);
var inst_18883 = (inst_18881 < inst_18880);
var inst_18884 = inst_18883;
var state_18926__$1 = state_18926;
if(cljs.core.truth_(inst_18884)){
var statearr_18960_18991 = state_18926__$1;
(statearr_18960_18991[(1)] = (10));

} else {
var statearr_18961_18992 = state_18926__$1;
(statearr_18961_18992[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto__))
;
return ((function (switch__16357__auto__,c__16469__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__16358__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__16358__auto____0 = (function (){
var statearr_18965 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_18965[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__16358__auto__);

(statearr_18965[(1)] = (1));

return statearr_18965;
});
var cljs$core$async$mapcat_STAR__$_state_machine__16358__auto____1 = (function (state_18926){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_18926);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e18966){if((e18966 instanceof Object)){
var ex__16361__auto__ = e18966;
var statearr_18967_18993 = state_18926;
(statearr_18967_18993[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_18926);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e18966;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__18994 = state_18926;
state_18926 = G__18994;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__16358__auto__ = function(state_18926){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__16358__auto____1.call(this,state_18926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__16358__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__16358__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto__))
})();
var state__16471__auto__ = (function (){var statearr_18968 = f__16470__auto__.call(null);
(statearr_18968[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto__);

return statearr_18968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto__))
);

return c__16469__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args18995 = [];
var len__13324__auto___18998 = arguments.length;
var i__13325__auto___18999 = (0);
while(true){
if((i__13325__auto___18999 < len__13324__auto___18998)){
args18995.push((arguments[i__13325__auto___18999]));

var G__19000 = (i__13325__auto___18999 + (1));
i__13325__auto___18999 = G__19000;
continue;
} else {
}
break;
}

var G__18997 = args18995.length;
switch (G__18997) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args18995.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args19002 = [];
var len__13324__auto___19005 = arguments.length;
var i__13325__auto___19006 = (0);
while(true){
if((i__13325__auto___19006 < len__13324__auto___19005)){
args19002.push((arguments[i__13325__auto___19006]));

var G__19007 = (i__13325__auto___19006 + (1));
i__13325__auto___19006 = G__19007;
continue;
} else {
}
break;
}

var G__19004 = args19002.length;
switch (G__19004) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19002.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args19009 = [];
var len__13324__auto___19060 = arguments.length;
var i__13325__auto___19061 = (0);
while(true){
if((i__13325__auto___19061 < len__13324__auto___19060)){
args19009.push((arguments[i__13325__auto___19061]));

var G__19062 = (i__13325__auto___19061 + (1));
i__13325__auto___19061 = G__19062;
continue;
} else {
}
break;
}

var G__19011 = args19009.length;
switch (G__19011) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19009.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16469__auto___19064 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___19064,out){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___19064,out){
return (function (state_19035){
var state_val_19036 = (state_19035[(1)]);
if((state_val_19036 === (7))){
var inst_19030 = (state_19035[(2)]);
var state_19035__$1 = state_19035;
var statearr_19037_19065 = state_19035__$1;
(statearr_19037_19065[(2)] = inst_19030);

(statearr_19037_19065[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19036 === (1))){
var inst_19012 = null;
var state_19035__$1 = (function (){var statearr_19038 = state_19035;
(statearr_19038[(7)] = inst_19012);

return statearr_19038;
})();
var statearr_19039_19066 = state_19035__$1;
(statearr_19039_19066[(2)] = null);

(statearr_19039_19066[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19036 === (4))){
var inst_19015 = (state_19035[(8)]);
var inst_19015__$1 = (state_19035[(2)]);
var inst_19016 = (inst_19015__$1 == null);
var inst_19017 = cljs.core.not.call(null,inst_19016);
var state_19035__$1 = (function (){var statearr_19040 = state_19035;
(statearr_19040[(8)] = inst_19015__$1);

return statearr_19040;
})();
if(inst_19017){
var statearr_19041_19067 = state_19035__$1;
(statearr_19041_19067[(1)] = (5));

} else {
var statearr_19042_19068 = state_19035__$1;
(statearr_19042_19068[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19036 === (6))){
var state_19035__$1 = state_19035;
var statearr_19043_19069 = state_19035__$1;
(statearr_19043_19069[(2)] = null);

(statearr_19043_19069[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19036 === (3))){
var inst_19032 = (state_19035[(2)]);
var inst_19033 = cljs.core.async.close_BANG_.call(null,out);
var state_19035__$1 = (function (){var statearr_19044 = state_19035;
(statearr_19044[(9)] = inst_19032);

return statearr_19044;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19035__$1,inst_19033);
} else {
if((state_val_19036 === (2))){
var state_19035__$1 = state_19035;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19035__$1,(4),ch);
} else {
if((state_val_19036 === (11))){
var inst_19015 = (state_19035[(8)]);
var inst_19024 = (state_19035[(2)]);
var inst_19012 = inst_19015;
var state_19035__$1 = (function (){var statearr_19045 = state_19035;
(statearr_19045[(7)] = inst_19012);

(statearr_19045[(10)] = inst_19024);

return statearr_19045;
})();
var statearr_19046_19070 = state_19035__$1;
(statearr_19046_19070[(2)] = null);

(statearr_19046_19070[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19036 === (9))){
var inst_19015 = (state_19035[(8)]);
var state_19035__$1 = state_19035;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19035__$1,(11),out,inst_19015);
} else {
if((state_val_19036 === (5))){
var inst_19012 = (state_19035[(7)]);
var inst_19015 = (state_19035[(8)]);
var inst_19019 = cljs.core._EQ_.call(null,inst_19015,inst_19012);
var state_19035__$1 = state_19035;
if(inst_19019){
var statearr_19048_19071 = state_19035__$1;
(statearr_19048_19071[(1)] = (8));

} else {
var statearr_19049_19072 = state_19035__$1;
(statearr_19049_19072[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19036 === (10))){
var inst_19027 = (state_19035[(2)]);
var state_19035__$1 = state_19035;
var statearr_19050_19073 = state_19035__$1;
(statearr_19050_19073[(2)] = inst_19027);

(statearr_19050_19073[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19036 === (8))){
var inst_19012 = (state_19035[(7)]);
var tmp19047 = inst_19012;
var inst_19012__$1 = tmp19047;
var state_19035__$1 = (function (){var statearr_19051 = state_19035;
(statearr_19051[(7)] = inst_19012__$1);

return statearr_19051;
})();
var statearr_19052_19074 = state_19035__$1;
(statearr_19052_19074[(2)] = null);

(statearr_19052_19074[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___19064,out))
;
return ((function (switch__16357__auto__,c__16469__auto___19064,out){
return (function() {
var cljs$core$async$state_machine__16358__auto__ = null;
var cljs$core$async$state_machine__16358__auto____0 = (function (){
var statearr_19056 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_19056[(0)] = cljs$core$async$state_machine__16358__auto__);

(statearr_19056[(1)] = (1));

return statearr_19056;
});
var cljs$core$async$state_machine__16358__auto____1 = (function (state_19035){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_19035);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e19057){if((e19057 instanceof Object)){
var ex__16361__auto__ = e19057;
var statearr_19058_19075 = state_19035;
(statearr_19058_19075[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19035);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19057;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19076 = state_19035;
state_19035 = G__19076;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$state_machine__16358__auto__ = function(state_19035){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16358__auto____1.call(this,state_19035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16358__auto____0;
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16358__auto____1;
return cljs$core$async$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___19064,out))
})();
var state__16471__auto__ = (function (){var statearr_19059 = f__16470__auto__.call(null);
(statearr_19059[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___19064);

return statearr_19059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___19064,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args19077 = [];
var len__13324__auto___19147 = arguments.length;
var i__13325__auto___19148 = (0);
while(true){
if((i__13325__auto___19148 < len__13324__auto___19147)){
args19077.push((arguments[i__13325__auto___19148]));

var G__19149 = (i__13325__auto___19148 + (1));
i__13325__auto___19148 = G__19149;
continue;
} else {
}
break;
}

var G__19079 = args19077.length;
switch (G__19079) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19077.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16469__auto___19151 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___19151,out){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___19151,out){
return (function (state_19117){
var state_val_19118 = (state_19117[(1)]);
if((state_val_19118 === (7))){
var inst_19113 = (state_19117[(2)]);
var state_19117__$1 = state_19117;
var statearr_19119_19152 = state_19117__$1;
(statearr_19119_19152[(2)] = inst_19113);

(statearr_19119_19152[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19118 === (1))){
var inst_19080 = (new Array(n));
var inst_19081 = inst_19080;
var inst_19082 = (0);
var state_19117__$1 = (function (){var statearr_19120 = state_19117;
(statearr_19120[(7)] = inst_19082);

(statearr_19120[(8)] = inst_19081);

return statearr_19120;
})();
var statearr_19121_19153 = state_19117__$1;
(statearr_19121_19153[(2)] = null);

(statearr_19121_19153[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19118 === (4))){
var inst_19085 = (state_19117[(9)]);
var inst_19085__$1 = (state_19117[(2)]);
var inst_19086 = (inst_19085__$1 == null);
var inst_19087 = cljs.core.not.call(null,inst_19086);
var state_19117__$1 = (function (){var statearr_19122 = state_19117;
(statearr_19122[(9)] = inst_19085__$1);

return statearr_19122;
})();
if(inst_19087){
var statearr_19123_19154 = state_19117__$1;
(statearr_19123_19154[(1)] = (5));

} else {
var statearr_19124_19155 = state_19117__$1;
(statearr_19124_19155[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19118 === (15))){
var inst_19107 = (state_19117[(2)]);
var state_19117__$1 = state_19117;
var statearr_19125_19156 = state_19117__$1;
(statearr_19125_19156[(2)] = inst_19107);

(statearr_19125_19156[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19118 === (13))){
var state_19117__$1 = state_19117;
var statearr_19126_19157 = state_19117__$1;
(statearr_19126_19157[(2)] = null);

(statearr_19126_19157[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19118 === (6))){
var inst_19082 = (state_19117[(7)]);
var inst_19103 = (inst_19082 > (0));
var state_19117__$1 = state_19117;
if(cljs.core.truth_(inst_19103)){
var statearr_19127_19158 = state_19117__$1;
(statearr_19127_19158[(1)] = (12));

} else {
var statearr_19128_19159 = state_19117__$1;
(statearr_19128_19159[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19118 === (3))){
var inst_19115 = (state_19117[(2)]);
var state_19117__$1 = state_19117;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19117__$1,inst_19115);
} else {
if((state_val_19118 === (12))){
var inst_19081 = (state_19117[(8)]);
var inst_19105 = cljs.core.vec.call(null,inst_19081);
var state_19117__$1 = state_19117;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19117__$1,(15),out,inst_19105);
} else {
if((state_val_19118 === (2))){
var state_19117__$1 = state_19117;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19117__$1,(4),ch);
} else {
if((state_val_19118 === (11))){
var inst_19097 = (state_19117[(2)]);
var inst_19098 = (new Array(n));
var inst_19081 = inst_19098;
var inst_19082 = (0);
var state_19117__$1 = (function (){var statearr_19129 = state_19117;
(statearr_19129[(10)] = inst_19097);

(statearr_19129[(7)] = inst_19082);

(statearr_19129[(8)] = inst_19081);

return statearr_19129;
})();
var statearr_19130_19160 = state_19117__$1;
(statearr_19130_19160[(2)] = null);

(statearr_19130_19160[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19118 === (9))){
var inst_19081 = (state_19117[(8)]);
var inst_19095 = cljs.core.vec.call(null,inst_19081);
var state_19117__$1 = state_19117;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19117__$1,(11),out,inst_19095);
} else {
if((state_val_19118 === (5))){
var inst_19082 = (state_19117[(7)]);
var inst_19090 = (state_19117[(11)]);
var inst_19081 = (state_19117[(8)]);
var inst_19085 = (state_19117[(9)]);
var inst_19089 = (inst_19081[inst_19082] = inst_19085);
var inst_19090__$1 = (inst_19082 + (1));
var inst_19091 = (inst_19090__$1 < n);
var state_19117__$1 = (function (){var statearr_19131 = state_19117;
(statearr_19131[(11)] = inst_19090__$1);

(statearr_19131[(12)] = inst_19089);

return statearr_19131;
})();
if(cljs.core.truth_(inst_19091)){
var statearr_19132_19161 = state_19117__$1;
(statearr_19132_19161[(1)] = (8));

} else {
var statearr_19133_19162 = state_19117__$1;
(statearr_19133_19162[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19118 === (14))){
var inst_19110 = (state_19117[(2)]);
var inst_19111 = cljs.core.async.close_BANG_.call(null,out);
var state_19117__$1 = (function (){var statearr_19135 = state_19117;
(statearr_19135[(13)] = inst_19110);

return statearr_19135;
})();
var statearr_19136_19163 = state_19117__$1;
(statearr_19136_19163[(2)] = inst_19111);

(statearr_19136_19163[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19118 === (10))){
var inst_19101 = (state_19117[(2)]);
var state_19117__$1 = state_19117;
var statearr_19137_19164 = state_19117__$1;
(statearr_19137_19164[(2)] = inst_19101);

(statearr_19137_19164[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19118 === (8))){
var inst_19090 = (state_19117[(11)]);
var inst_19081 = (state_19117[(8)]);
var tmp19134 = inst_19081;
var inst_19081__$1 = tmp19134;
var inst_19082 = inst_19090;
var state_19117__$1 = (function (){var statearr_19138 = state_19117;
(statearr_19138[(7)] = inst_19082);

(statearr_19138[(8)] = inst_19081__$1);

return statearr_19138;
})();
var statearr_19139_19165 = state_19117__$1;
(statearr_19139_19165[(2)] = null);

(statearr_19139_19165[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___19151,out))
;
return ((function (switch__16357__auto__,c__16469__auto___19151,out){
return (function() {
var cljs$core$async$state_machine__16358__auto__ = null;
var cljs$core$async$state_machine__16358__auto____0 = (function (){
var statearr_19143 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19143[(0)] = cljs$core$async$state_machine__16358__auto__);

(statearr_19143[(1)] = (1));

return statearr_19143;
});
var cljs$core$async$state_machine__16358__auto____1 = (function (state_19117){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_19117);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e19144){if((e19144 instanceof Object)){
var ex__16361__auto__ = e19144;
var statearr_19145_19166 = state_19117;
(statearr_19145_19166[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19117);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19144;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19167 = state_19117;
state_19117 = G__19167;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$state_machine__16358__auto__ = function(state_19117){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16358__auto____1.call(this,state_19117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16358__auto____0;
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16358__auto____1;
return cljs$core$async$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___19151,out))
})();
var state__16471__auto__ = (function (){var statearr_19146 = f__16470__auto__.call(null);
(statearr_19146[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___19151);

return statearr_19146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___19151,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args19168 = [];
var len__13324__auto___19242 = arguments.length;
var i__13325__auto___19243 = (0);
while(true){
if((i__13325__auto___19243 < len__13324__auto___19242)){
args19168.push((arguments[i__13325__auto___19243]));

var G__19244 = (i__13325__auto___19243 + (1));
i__13325__auto___19243 = G__19244;
continue;
} else {
}
break;
}

var G__19170 = args19168.length;
switch (G__19170) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args19168.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__16469__auto___19246 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___19246,out){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___19246,out){
return (function (state_19212){
var state_val_19213 = (state_19212[(1)]);
if((state_val_19213 === (7))){
var inst_19208 = (state_19212[(2)]);
var state_19212__$1 = state_19212;
var statearr_19214_19247 = state_19212__$1;
(statearr_19214_19247[(2)] = inst_19208);

(statearr_19214_19247[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19213 === (1))){
var inst_19171 = [];
var inst_19172 = inst_19171;
var inst_19173 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_19212__$1 = (function (){var statearr_19215 = state_19212;
(statearr_19215[(7)] = inst_19173);

(statearr_19215[(8)] = inst_19172);

return statearr_19215;
})();
var statearr_19216_19248 = state_19212__$1;
(statearr_19216_19248[(2)] = null);

(statearr_19216_19248[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19213 === (4))){
var inst_19176 = (state_19212[(9)]);
var inst_19176__$1 = (state_19212[(2)]);
var inst_19177 = (inst_19176__$1 == null);
var inst_19178 = cljs.core.not.call(null,inst_19177);
var state_19212__$1 = (function (){var statearr_19217 = state_19212;
(statearr_19217[(9)] = inst_19176__$1);

return statearr_19217;
})();
if(inst_19178){
var statearr_19218_19249 = state_19212__$1;
(statearr_19218_19249[(1)] = (5));

} else {
var statearr_19219_19250 = state_19212__$1;
(statearr_19219_19250[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19213 === (15))){
var inst_19202 = (state_19212[(2)]);
var state_19212__$1 = state_19212;
var statearr_19220_19251 = state_19212__$1;
(statearr_19220_19251[(2)] = inst_19202);

(statearr_19220_19251[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19213 === (13))){
var state_19212__$1 = state_19212;
var statearr_19221_19252 = state_19212__$1;
(statearr_19221_19252[(2)] = null);

(statearr_19221_19252[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19213 === (6))){
var inst_19172 = (state_19212[(8)]);
var inst_19197 = inst_19172.length;
var inst_19198 = (inst_19197 > (0));
var state_19212__$1 = state_19212;
if(cljs.core.truth_(inst_19198)){
var statearr_19222_19253 = state_19212__$1;
(statearr_19222_19253[(1)] = (12));

} else {
var statearr_19223_19254 = state_19212__$1;
(statearr_19223_19254[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19213 === (3))){
var inst_19210 = (state_19212[(2)]);
var state_19212__$1 = state_19212;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_19212__$1,inst_19210);
} else {
if((state_val_19213 === (12))){
var inst_19172 = (state_19212[(8)]);
var inst_19200 = cljs.core.vec.call(null,inst_19172);
var state_19212__$1 = state_19212;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19212__$1,(15),out,inst_19200);
} else {
if((state_val_19213 === (2))){
var state_19212__$1 = state_19212;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_19212__$1,(4),ch);
} else {
if((state_val_19213 === (11))){
var inst_19176 = (state_19212[(9)]);
var inst_19180 = (state_19212[(10)]);
var inst_19190 = (state_19212[(2)]);
var inst_19191 = [];
var inst_19192 = inst_19191.push(inst_19176);
var inst_19172 = inst_19191;
var inst_19173 = inst_19180;
var state_19212__$1 = (function (){var statearr_19224 = state_19212;
(statearr_19224[(11)] = inst_19190);

(statearr_19224[(7)] = inst_19173);

(statearr_19224[(8)] = inst_19172);

(statearr_19224[(12)] = inst_19192);

return statearr_19224;
})();
var statearr_19225_19255 = state_19212__$1;
(statearr_19225_19255[(2)] = null);

(statearr_19225_19255[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19213 === (9))){
var inst_19172 = (state_19212[(8)]);
var inst_19188 = cljs.core.vec.call(null,inst_19172);
var state_19212__$1 = state_19212;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_19212__$1,(11),out,inst_19188);
} else {
if((state_val_19213 === (5))){
var inst_19176 = (state_19212[(9)]);
var inst_19173 = (state_19212[(7)]);
var inst_19180 = (state_19212[(10)]);
var inst_19180__$1 = f.call(null,inst_19176);
var inst_19181 = cljs.core._EQ_.call(null,inst_19180__$1,inst_19173);
var inst_19182 = cljs.core.keyword_identical_QMARK_.call(null,inst_19173,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_19183 = (inst_19181) || (inst_19182);
var state_19212__$1 = (function (){var statearr_19226 = state_19212;
(statearr_19226[(10)] = inst_19180__$1);

return statearr_19226;
})();
if(cljs.core.truth_(inst_19183)){
var statearr_19227_19256 = state_19212__$1;
(statearr_19227_19256[(1)] = (8));

} else {
var statearr_19228_19257 = state_19212__$1;
(statearr_19228_19257[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19213 === (14))){
var inst_19205 = (state_19212[(2)]);
var inst_19206 = cljs.core.async.close_BANG_.call(null,out);
var state_19212__$1 = (function (){var statearr_19230 = state_19212;
(statearr_19230[(13)] = inst_19205);

return statearr_19230;
})();
var statearr_19231_19258 = state_19212__$1;
(statearr_19231_19258[(2)] = inst_19206);

(statearr_19231_19258[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19213 === (10))){
var inst_19195 = (state_19212[(2)]);
var state_19212__$1 = state_19212;
var statearr_19232_19259 = state_19212__$1;
(statearr_19232_19259[(2)] = inst_19195);

(statearr_19232_19259[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19213 === (8))){
var inst_19176 = (state_19212[(9)]);
var inst_19172 = (state_19212[(8)]);
var inst_19180 = (state_19212[(10)]);
var inst_19185 = inst_19172.push(inst_19176);
var tmp19229 = inst_19172;
var inst_19172__$1 = tmp19229;
var inst_19173 = inst_19180;
var state_19212__$1 = (function (){var statearr_19233 = state_19212;
(statearr_19233[(14)] = inst_19185);

(statearr_19233[(7)] = inst_19173);

(statearr_19233[(8)] = inst_19172__$1);

return statearr_19233;
})();
var statearr_19234_19260 = state_19212__$1;
(statearr_19234_19260[(2)] = null);

(statearr_19234_19260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto___19246,out))
;
return ((function (switch__16357__auto__,c__16469__auto___19246,out){
return (function() {
var cljs$core$async$state_machine__16358__auto__ = null;
var cljs$core$async$state_machine__16358__auto____0 = (function (){
var statearr_19238 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19238[(0)] = cljs$core$async$state_machine__16358__auto__);

(statearr_19238[(1)] = (1));

return statearr_19238;
});
var cljs$core$async$state_machine__16358__auto____1 = (function (state_19212){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_19212);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e19239){if((e19239 instanceof Object)){
var ex__16361__auto__ = e19239;
var statearr_19240_19261 = state_19212;
(statearr_19240_19261[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_19212);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e19239;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19262 = state_19212;
state_19212 = G__19262;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
cljs$core$async$state_machine__16358__auto__ = function(state_19212){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__16358__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__16358__auto____1.call(this,state_19212);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__16358__auto____0;
cljs$core$async$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__16358__auto____1;
return cljs$core$async$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___19246,out))
})();
var state__16471__auto__ = (function (){var statearr_19241 = f__16470__auto__.call(null);
(statearr_19241[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___19246);

return statearr_19241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___19246,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1473935450635