// Compiled by ClojureScript 1.9.89 {}
goog.provide('redgenes.components.lighttable');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('dommy.core');
goog.require('cljs.core.async');
goog.require('imcljs.search');
/**
 * Returns a sequence of true / false indicating that all values in each
 *   column of a table are equal. Assumes all rows are the same length.
 *   [[A B C] [X B Y]]
 * => (false true false)
 */
redgenes.components.lighttable.homogeneous_columns = (function redgenes$components$lighttable$homogeneous_columns(table){
return cljs.core.map.call(null,(function (column){
return cljs.core.apply.call(null,cljs.core._EQ_,cljs.core.map.call(null,(function (row){
return cljs.core.nth.call(null,row,column);
}),table));
}),cljs.core.range.call(null,cljs.core.count.call(null,cljs.core.first.call(null,table))));
});
redgenes.components.lighttable.table = (function redgenes$components$lighttable$table(){
return (function (results){
var skip_columns = null;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.table.small","table.table.small",-2143262832),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646)], null),cljs.core.map.call(null,((function (skip_columns){
return (function (header){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),cljs.core.last.call(null,clojure.string.split.call(null,header," > "))], null);
});})(skip_columns))
,new cljs.core.Keyword(null,"columnHeaders","columnHeaders",953900997).cljs$core$IFn$_invoke$arity$1(results)))], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300)], null),cljs.core.map.call(null,((function (skip_columns){
return (function (row){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646)], null),cljs.core.map_indexed.call(null,((function (skip_columns){
return (function (idx,value){
if(cljs.core.truth_(cljs.core.nth.call(null,skip_columns,idx))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.skipped","td.skipped",-1956779939),"..."], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),((((50) < cljs.core.count.call(null,[cljs.core.str(value)].join(''))))?[cljs.core.str(cljs.core.apply.call(null,cljs.core.str,cljs.core.take.call(null,(50),[cljs.core.str(value)].join('')))),cljs.core.str("...")].join(''):[cljs.core.str(value)].join(''))], null);
}
});})(skip_columns))
,row));
});})(skip_columns))
,new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(results)))], null);
});
});
redgenes.components.lighttable.shell = (function redgenes$components$lighttable$shell(){
return (function (state){
if(cljs.core.empty_QMARK_.call(null,new cljs.core.Keyword(null,"results","results",-1134170113).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.small","div.small",111791725),[cljs.core.str(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(state)),cljs.core.str(" - No Results")].join('')], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.lighttable.table,cljs.core.deref.call(null,state)], null)], null);
}
});
});
redgenes.components.lighttable.handler = (function redgenes$components$lighttable$handler(state,e){
var props = reagent.core.props.call(null,e);
var node = (dommy.utils.__GT_Array.call(null,reagent.core.dom_node.call(null,e).getElementsByClassName("im-target"))[(0)]);
var c__16469__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto__,props,node){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto__,props,node){
return (function (state_27356){
var state_val_27357 = (state_27356[(1)]);
if((state_val_27357 === (1))){
var inst_27339 = [new cljs.core.Keyword(null,"root","root",-448657453)];
var inst_27340 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27341 = [new cljs.core.Keyword(null,"mine-url","mine-url",1768733452)];
var inst_27342 = (new cljs.core.PersistentVector(null,1,(5),inst_27340,inst_27341,null));
var inst_27343 = re_frame.core.subscribe.call(null,inst_27342);
var inst_27344 = cljs.core.deref.call(null,inst_27343);
var inst_27345 = [inst_27344];
var inst_27346 = cljs.core.PersistentHashMap.fromArrays(inst_27339,inst_27345);
var inst_27347 = new cljs.core.Keyword(null,"query","query",-1288509510).cljs$core$IFn$_invoke$arity$1(props);
var inst_27348 = [new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"format","format",-1306924766)];
var inst_27349 = [(5),"json"];
var inst_27350 = cljs.core.PersistentHashMap.fromArrays(inst_27348,inst_27349);
var inst_27351 = imcljs.search.raw_query_rows.call(null,inst_27346,inst_27347,inst_27350);
var state_27356__$1 = state_27356;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_27356__$1,(2),inst_27351);
} else {
if((state_val_27357 === (2))){
var inst_27353 = (state_27356[(2)]);
var inst_27354 = cljs.core.reset_BANG_.call(null,state,inst_27353);
var state_27356__$1 = state_27356;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_27356__$1,inst_27354);
} else {
return null;
}
}
});})(c__16469__auto__,props,node))
;
return ((function (switch__16357__auto__,c__16469__auto__,props,node){
return (function() {
var redgenes$components$lighttable$handler_$_state_machine__16358__auto__ = null;
var redgenes$components$lighttable$handler_$_state_machine__16358__auto____0 = (function (){
var statearr_27361 = [null,null,null,null,null,null,null];
(statearr_27361[(0)] = redgenes$components$lighttable$handler_$_state_machine__16358__auto__);

(statearr_27361[(1)] = (1));

return statearr_27361;
});
var redgenes$components$lighttable$handler_$_state_machine__16358__auto____1 = (function (state_27356){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_27356);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e27362){if((e27362 instanceof Object)){
var ex__16361__auto__ = e27362;
var statearr_27363_27365 = state_27356;
(statearr_27363_27365[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_27356);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e27362;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__27366 = state_27356;
state_27356 = G__27366;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
redgenes$components$lighttable$handler_$_state_machine__16358__auto__ = function(state_27356){
switch(arguments.length){
case 0:
return redgenes$components$lighttable$handler_$_state_machine__16358__auto____0.call(this);
case 1:
return redgenes$components$lighttable$handler_$_state_machine__16358__auto____1.call(this,state_27356);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
redgenes$components$lighttable$handler_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = redgenes$components$lighttable$handler_$_state_machine__16358__auto____0;
redgenes$components$lighttable$handler_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = redgenes$components$lighttable$handler_$_state_machine__16358__auto____1;
return redgenes$components$lighttable$handler_$_state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto__,props,node))
})();
var state__16471__auto__ = (function (){var statearr_27364 = f__16470__auto__.call(null);
(statearr_27364[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto__);

return statearr_27364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto__,props,node))
);

return c__16469__auto__;
});
redgenes.components.lighttable.main = (function redgenes$components$lighttable$main(){
var state = reagent.core.atom.call(null,null);
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),cljs.core.partial.call(null,redgenes.components.lighttable.handler,state),new cljs.core.Keyword(null,"component-did-update","component-did-update",-1468549173),cljs.core.partial.call(null,redgenes.components.lighttable.handler,state),new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (state){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.lighttable.shell,state], null);
});})(state))
], null));
});

//# sourceMappingURL=lighttable.js.map?rel=1473935460201