// Compiled by ClojureScript 1.9.89 {}
goog.provide('re_frame.fx');
goog.require('cljs.core');
goog.require('re_frame.router');
goog.require('re_frame.db');
goog.require('re_frame.interceptor');
goog.require('re_frame.interop');
goog.require('re_frame.events');
goog.require('re_frame.registrar');
goog.require('re_frame.loggers');
re_frame.fx.kind = new cljs.core.Keyword(null,"fx","fx",-1237829572);
if(cljs.core.truth_(re_frame.registrar.kinds.call(null,re_frame.fx.kind))){
} else {
throw (new Error("Assert failed: (re-frame.registrar/kinds kind)"));
}
re_frame.fx.register = cljs.core.partial.call(null,re_frame.registrar.register_handler,re_frame.fx.kind);
/**
 * An interceptor which actions a `context's` (side) `:effects`.
 * 
 *   For each key in the `:effects` map, call the `effects handler` previously
 *   registered using `reg-fx`.
 * 
 *   So, if `:effects` was:
 *    {:dispatch  [:hello 42]
 *     :db        {...}
 *     :undo      "set flag"}
 *   call the registered effects handlers for each of the map's keys:
 *   `:dispatch`, `:undo` and `:db`.
 */
re_frame.fx.do_fx = re_frame.interceptor.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"do-fx","do-fx",1194163050),new cljs.core.Keyword(null,"after","after",594996914),(function re_frame$fx$do_fx_after(context){
return cljs.core.doall.call(null,cljs.core.map.call(null,(function (p__14301){
var vec__14302 = p__14301;
var k = cljs.core.nth.call(null,vec__14302,(0),null);
var value = cljs.core.nth.call(null,vec__14302,(1),null);
var temp__4655__auto__ = re_frame.registrar.get_handler.call(null,re_frame.fx.kind,k,true);
if(cljs.core.truth_(temp__4655__auto__)){
var effect_fn = temp__4655__auto__;
return effect_fn.call(null,value);
} else {
return null;
}
}),new cljs.core.Keyword(null,"effects","effects",-282369292).cljs$core$IFn$_invoke$arity$1(context)));
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"dispatch-later","dispatch-later",291951390),(function (value){
var seq__14305 = cljs.core.seq.call(null,value);
var chunk__14306 = null;
var count__14307 = (0);
var i__14308 = (0);
while(true){
if((i__14308 < count__14307)){
var map__14309 = cljs.core._nth.call(null,chunk__14306,i__14308);
var map__14309__$1 = ((((!((map__14309 == null)))?((((map__14309.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14309.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14309):map__14309);
var effect = map__14309__$1;
var ms = cljs.core.get.call(null,map__14309__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__14309__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value: ",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__14305,chunk__14306,count__14307,i__14308,map__14309,map__14309__$1,effect,ms,dispatch){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__14305,chunk__14306,count__14307,i__14308,map__14309,map__14309__$1,effect,ms,dispatch))
,ms);
}

var G__14313 = seq__14305;
var G__14314 = chunk__14306;
var G__14315 = count__14307;
var G__14316 = (i__14308 + (1));
seq__14305 = G__14313;
chunk__14306 = G__14314;
count__14307 = G__14315;
i__14308 = G__14316;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__14305);
if(temp__4657__auto__){
var seq__14305__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14305__$1)){
var c__13060__auto__ = cljs.core.chunk_first.call(null,seq__14305__$1);
var G__14317 = cljs.core.chunk_rest.call(null,seq__14305__$1);
var G__14318 = c__13060__auto__;
var G__14319 = cljs.core.count.call(null,c__13060__auto__);
var G__14320 = (0);
seq__14305 = G__14317;
chunk__14306 = G__14318;
count__14307 = G__14319;
i__14308 = G__14320;
continue;
} else {
var map__14311 = cljs.core.first.call(null,seq__14305__$1);
var map__14311__$1 = ((((!((map__14311 == null)))?((((map__14311.cljs$lang$protocol_mask$partition0$ & (64))) || (map__14311.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14311):map__14311);
var effect = map__14311__$1;
var ms = cljs.core.get.call(null,map__14311__$1,new cljs.core.Keyword(null,"ms","ms",-1152709733));
var dispatch = cljs.core.get.call(null,map__14311__$1,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009));
if((cljs.core.empty_QMARK_.call(null,dispatch)) || (!(typeof ms === 'number'))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-later value: ",effect);
} else {
re_frame.interop.set_timeout_BANG_.call(null,((function (seq__14305,chunk__14306,count__14307,i__14308,map__14311,map__14311__$1,effect,ms,dispatch,seq__14305__$1,temp__4657__auto__){
return (function (){
return re_frame.router.dispatch.call(null,dispatch);
});})(seq__14305,chunk__14306,count__14307,i__14308,map__14311,map__14311__$1,effect,ms,dispatch,seq__14305__$1,temp__4657__auto__))
,ms);
}

var G__14321 = cljs.core.next.call(null,seq__14305__$1);
var G__14322 = null;
var G__14323 = (0);
var G__14324 = (0);
seq__14305 = G__14321;
chunk__14306 = G__14322;
count__14307 = G__14323;
i__14308 = G__14324;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),(function (value){
if(!(cljs.core.vector_QMARK_.call(null,value))){
return re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch value. Expected a vector, but got: ",value);
} else {
return re_frame.router.dispatch.call(null,value);
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),(function (value){
if(!(cljs.core.sequential_QMARK_.call(null,value))){
re_frame.loggers.console.call(null,new cljs.core.Keyword(null,"error","error",-978969032),"re-frame: ignoring bad :dispatch-n value. Expected a collection, got got: ",value);
} else {
}

var seq__14325 = cljs.core.seq.call(null,value);
var chunk__14326 = null;
var count__14327 = (0);
var i__14328 = (0);
while(true){
if((i__14328 < count__14327)){
var event = cljs.core._nth.call(null,chunk__14326,i__14328);
re_frame.router.dispatch.call(null,event);

var G__14329 = seq__14325;
var G__14330 = chunk__14326;
var G__14331 = count__14327;
var G__14332 = (i__14328 + (1));
seq__14325 = G__14329;
chunk__14326 = G__14330;
count__14327 = G__14331;
i__14328 = G__14332;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__14325);
if(temp__4657__auto__){
var seq__14325__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14325__$1)){
var c__13060__auto__ = cljs.core.chunk_first.call(null,seq__14325__$1);
var G__14333 = cljs.core.chunk_rest.call(null,seq__14325__$1);
var G__14334 = c__13060__auto__;
var G__14335 = cljs.core.count.call(null,c__13060__auto__);
var G__14336 = (0);
seq__14325 = G__14333;
chunk__14326 = G__14334;
count__14327 = G__14335;
i__14328 = G__14336;
continue;
} else {
var event = cljs.core.first.call(null,seq__14325__$1);
re_frame.router.dispatch.call(null,event);

var G__14337 = cljs.core.next.call(null,seq__14325__$1);
var G__14338 = null;
var G__14339 = (0);
var G__14340 = (0);
seq__14325 = G__14337;
chunk__14326 = G__14338;
count__14327 = G__14339;
i__14328 = G__14340;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"deregister-event-handler","deregister-event-handler",-1096518994),(function (value){
var clear_event = cljs.core.partial.call(null,re_frame.registrar.clear_handlers,re_frame.events.kind);
if(cljs.core.sequential_QMARK_.call(null,value)){
return cljs.core.doall.call(null,cljs.core.map.call(null,clear_event,value));
} else {
return clear_event.call(null,value);
}
}));
re_frame.fx.register.call(null,new cljs.core.Keyword(null,"db","db",993250759),(function (value){
return cljs.core.reset_BANG_.call(null,re_frame.db.app_db,value);
}));

//# sourceMappingURL=fx.js.map?rel=1473935446600