// Compiled by ClojureScript 1.9.89 {}
goog.provide('imcljs.filters');
goog.require('cljs.core');
goog.require('ajax.core');
goog.require('cljs_http.client');
goog.require('imcljs.utils');
goog.require('cljs.core.async');
/**
 * Returns the deepest class from a query path.
 *   Example:
 *   (end-class Gene.proteins flymine-model) ;; Protein
 *   (end-class Gene.goAnnotation.ontologyTerm.name ;; OntologyTerm
 */
imcljs.filters.end_class = (function imcljs$filters$end_class(model,path){
var parts = cljs.core.map.call(null,cljs.core.keyword,clojure.string.split.call(null,path,"."));
var class$ = cljs.core.first.call(null,parts);
var parts_remaining = cljs.core.rest.call(null,parts);
while(true){
var temp__4655__auto__ = cljs.core.get_in.call(null,model,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [class$], null));
if(cljs.core.truth_(temp__4655__auto__)){
var found = temp__4655__auto__;
if(cljs.core.empty_QMARK_.call(null,parts_remaining)){
return cljs.core.name.call(null,class$);
} else {
var related = cljs.core.merge.call(null,new cljs.core.Keyword(null,"references","references",882562509).cljs$core$IFn$_invoke$arity$1(found),new cljs.core.Keyword(null,"collections","collections",-2114643505).cljs$core$IFn$_invoke$arity$1(found));
var map__19615 = cljs.core.get_in.call(null,related,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first.call(null,parts_remaining)], null));
var map__19615__$1 = ((((!((map__19615 == null)))?((((map__19615.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19615.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19615):map__19615);
var refType = cljs.core.get.call(null,map__19615__$1,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030));
if((refType == null)){
return cljs.core.name.call(null,class$);
} else {
var G__19617 = cljs.core.keyword.call(null,refType);
var G__19618 = cljs.core.rest.call(null,parts_remaining);
class$ = G__19617;
parts_remaining = G__19618;
continue;
}
}
} else {
return null;
}
break;
}
});
imcljs.filters.path_types = new cljs.core.PersistentArrayMap(null, 6, ["class",new cljs.core.Keyword(null,"class","class",-2030961996),"java.lang.String",new cljs.core.Keyword(null,"string","string",-1989541586),"java.lang.Boolean",new cljs.core.Keyword(null,"boolean","boolean",-1919418404),"java.lang.Integer",new cljs.core.Keyword(null,"integer","integer",-604721710),"java.lang.Double",new cljs.core.Keyword(null,"double","double",884886883),"java.lang.Float",new cljs.core.Keyword(null,"float","float",-1732389368)], null);
/**
 * Returns a keyword representing the type of the path
 *   (see path-types for possible types
 *   TODO: This is atrocious and needs to be reassessed. But it works.
 */
imcljs.filters.path_type = (function imcljs$filters$path_type(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19625 = arguments.length;
var i__13325__auto___19626 = (0);
while(true){
if((i__13325__auto___19626 < len__13324__auto___19625)){
args__13331__auto__.push((arguments[i__13325__auto___19626]));

var G__19627 = (i__13325__auto___19626 + (1));
i__13325__auto___19626 = G__19627;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((2) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((2)),(0),null)):null);
return imcljs.filters.path_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__13332__auto__);
});

imcljs.filters.path_type.cljs$core$IFn$_invoke$arity$variadic = (function (model,path,subclasses){
while(true){
if(typeof path === 'string'){
var G__19628 = model;
var G__19629 = cljs.core.map.call(null,cljs.core.keyword,clojure.string.split.call(null,path,"."));
var G__19630 = subclasses;
model = G__19628;
path = G__19629;
subclasses = G__19630;
continue;
} else {
if(cljs.core.truth_(cljs.core.some.call(null,cljs.core.comp.call(null,cljs.core.string_QMARK_,new cljs.core.Keyword(null,"path","path",-188191168)),subclasses))){
var G__19631 = model;
var G__19632 = path;
var G__19633 = cljs.core.map.call(null,((function (model,path,subclasses){
return (function (subclass){
if(typeof new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(subclass) === 'string'){
return cljs.core.update_in.call(null,subclass,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"path","path",-188191168)], null),((function (model,path,subclasses){
return (function (p){
return cljs.core.map.call(null,cljs.core.keyword,clojure.string.split.call(null,p,"."));
});})(model,path,subclasses))
);
} else {
return subclass;
}
});})(model,path,subclasses))
,subclasses);
model = G__19631;
path = G__19632;
subclasses = G__19633;
continue;
} else {
var vec__19622 = path;
var seq__19623 = cljs.core.seq.call(null,vec__19622);
var first__19624 = cljs.core.first.call(null,seq__19623);
var seq__19623__$1 = cljs.core.next.call(null,seq__19623);
var class$ = first__19624;
var first__19624__$1 = cljs.core.first.call(null,seq__19623__$1);
var seq__19623__$2 = cljs.core.next.call(null,seq__19623__$1);
var child = first__19624__$1;
var remaining = seq__19623__$2;
if((child == null)){
return new cljs.core.Keyword(null,"class","class",-2030961996);
} else {
var temp__4655__auto__ = cljs.core.keyword.call(null,new cljs.core.Keyword(null,"referencedType","referencedType",-303824030).cljs$core$IFn$_invoke$arity$1(child.call(null,cljs.core.reduce.call(null,cljs.core.merge,cljs.core.map.call(null,class$.call(null,model),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"references","references",882562509),new cljs.core.Keyword(null,"collections","collections",-2114643505)], null))))));
if(cljs.core.truth_(temp__4655__auto__)){
var child_class = temp__4655__auto__;
if(remaining){
var sc = ((cljs.core._EQ_.call(null,child,cljs.core.second.call(null,new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,subclasses)))))?cljs.core.map.call(null,((function (model,path,subclasses,child_class,temp__4655__auto__,vec__19622,seq__19623,first__19624,seq__19623__$1,class$,first__19624__$1,seq__19623__$2,child,remaining){
return (function (x){
return cljs.core.update.call(null,x,new cljs.core.Keyword(null,"path","path",-188191168),cljs.core.rest);
});})(model,path,subclasses,child_class,temp__4655__auto__,vec__19622,seq__19623,first__19624,seq__19623__$1,class$,first__19624__$1,seq__19623__$2,child,remaining))
,subclasses):subclasses);
var subclass_path = new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,sc));
var child_class__$1 = (((cljs.core.empty_QMARK_.call(null,cljs.core.rest.call(null,subclass_path))) && (cljs.core._EQ_.call(null,child,cljs.core.first.call(null,subclass_path))))?cljs.core.keyword.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,sc))):child_class);
var G__19634 = model;
var G__19635 = cljs.core.cons.call(null,child_class__$1,remaining);
var G__19636 = sc;
model = G__19634;
path = G__19635;
subclasses = G__19636;
continue;
} else {
return new cljs.core.Keyword(null,"class","class",-2030961996);
}
} else {
return cljs.core.get.call(null,imcljs.filters.path_types,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(child.call(null,new cljs.core.Keyword(null,"attributes","attributes",-74013604).cljs$core$IFn$_invoke$arity$1(class$.call(null,model)))));
}
}

}
}
break;
}
});

imcljs.filters.path_type.cljs$lang$maxFixedArity = (2);

imcljs.filters.path_type.cljs$lang$applyTo = (function (seq19619){
var G__19620 = cljs.core.first.call(null,seq19619);
var seq19619__$1 = cljs.core.next.call(null,seq19619);
var G__19621 = cljs.core.first.call(null,seq19619__$1);
var seq19619__$2 = cljs.core.next.call(null,seq19619__$1);
return imcljs.filters.path_type.cljs$core$IFn$_invoke$arity$variadic(G__19620,G__19621,seq19619__$2);
});


//# sourceMappingURL=filters.js.map?rel=1473935451205