// Compiled by ClojureScript 1.9.89 {}
goog.provide('figwheel.client.file_reloading');
goog.require('cljs.core');
goog.require('goog.string');
goog.require('goog.Uri');
goog.require('goog.net.jsloader');
goog.require('cljs.core.async');
goog.require('goog.object');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('figwheel.client.utils');
if(typeof figwheel.client.file_reloading.figwheel_meta_pragmas !== 'undefined'){
} else {
figwheel.client.file_reloading.figwheel_meta_pragmas = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
figwheel.client.file_reloading.on_jsload_custom_event = (function figwheel$client$file_reloading$on_jsload_custom_event(url){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.js-reload",url);
});
figwheel.client.file_reloading.before_jsload_custom_event = (function figwheel$client$file_reloading$before_jsload_custom_event(files){
return figwheel.client.utils.dispatch_custom_event.call(null,"figwheel.before-js-reload",files);
});
figwheel.client.file_reloading.namespace_file_map_QMARK_ = (function figwheel$client$file_reloading$namespace_file_map_QMARK_(m){
var or__12249__auto__ = (cljs.core.map_QMARK_.call(null,m)) && (typeof new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(m) === 'string') && (((new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) == null)) || (typeof new cljs.core.Keyword(null,"file","file",-1269645878).cljs$core$IFn$_invoke$arity$1(m) === 'string')) && (cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"namespace","namespace",-377510372)));
if(or__12249__auto__){
return or__12249__auto__;
} else {
cljs.core.println.call(null,"Error not namespace-file-map",cljs.core.pr_str.call(null,m));

return false;
}
});
figwheel.client.file_reloading.add_cache_buster = (function figwheel$client$file_reloading$add_cache_buster(url){

return goog.Uri.parse(url).makeUnique();
});
figwheel.client.file_reloading.name__GT_path = (function figwheel$client$file_reloading$name__GT_path(ns){

return (goog.dependencies_.nameToPath[ns]);
});
figwheel.client.file_reloading.provided_QMARK_ = (function figwheel$client$file_reloading$provided_QMARK_(ns){
return (goog.dependencies_.written[figwheel.client.file_reloading.name__GT_path.call(null,ns)]);
});
figwheel.client.file_reloading.fix_node_request_url = (function figwheel$client$file_reloading$fix_node_request_url(url){

if(cljs.core.truth_(goog.string.startsWith(url,"../"))){
return clojure.string.replace.call(null,url,"../","");
} else {
return [cljs.core.str("goog/"),cljs.core.str(url)].join('');
}
});
figwheel.client.file_reloading.immutable_ns_QMARK_ = (function figwheel$client$file_reloading$immutable_ns_QMARK_(name){
var or__12249__auto__ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, ["svgpan.SvgPan",null,"far.out",null,"testDep.bar",null,"someprotopackage.TestPackageTypes",null,"goog",null,"an.existing.path",null,"cljs.core",null,"ns",null,"dup.base",null], null), null).call(null,name);
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return cljs.core.some.call(null,cljs.core.partial.call(null,goog.string.startsWith,name),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["goog.","cljs.","clojure.","fake.","proto2."], null));
}
});
figwheel.client.file_reloading.get_requires = (function figwheel$client$file_reloading$get_requires(ns){
return cljs.core.set.call(null,cljs.core.filter.call(null,(function (p1__30600_SHARP_){
return cljs.core.not.call(null,figwheel.client.file_reloading.immutable_ns_QMARK_.call(null,p1__30600_SHARP_));
}),goog.object.getKeys((goog.dependencies_.requires[figwheel.client.file_reloading.name__GT_path.call(null,ns)]))));
});
if(typeof figwheel.client.file_reloading.dependency_data !== 'undefined'){
} else {
figwheel.client.file_reloading.dependency_data = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"dependents","dependents",136812837),cljs.core.PersistentArrayMap.EMPTY], null));
}
figwheel.client.file_reloading.path_to_name_BANG_ = (function figwheel$client$file_reloading$path_to_name_BANG_(path,name){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([name], true));
});
/**
 * Setup a path to name dependencies map.
 * That goes from path -> #{ ns-names }
 */
figwheel.client.file_reloading.setup_path__GT_name_BANG_ = (function figwheel$client$file_reloading$setup_path__GT_name_BANG_(){
var nameToPath = goog.object.filter(goog.dependencies_.nameToPath,(function (v,k,o){
return goog.string.startsWith(v,"../");
}));
return goog.object.forEach(nameToPath,((function (nameToPath){
return (function (v,k,o){
return figwheel.client.file_reloading.path_to_name_BANG_.call(null,v,k);
});})(nameToPath))
);
});
/**
 * returns a set of namespaces defined by a path
 */
figwheel.client.file_reloading.path__GT_name = (function figwheel$client$file_reloading$path__GT_name(path){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"pathToName","pathToName",-1236616181),path], null));
});
figwheel.client.file_reloading.name_to_parent_BANG_ = (function figwheel$client$file_reloading$name_to_parent_BANG_(ns,parent_ns){
return cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependency_data,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null),cljs.core.fnil.call(null,clojure.set.union,cljs.core.PersistentHashSet.EMPTY),cljs.core.PersistentHashSet.fromArray([parent_ns], true));
});
/**
 * This reverses the goog.dependencies_.requires for looking up ns-dependents.
 */
figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_ = (function figwheel$client$file_reloading$setup_ns__GT_dependents_BANG_(){
var requires = goog.object.filter(goog.dependencies_.requires,(function (v,k,o){
return goog.string.startsWith(k,"../");
}));
return goog.object.forEach(requires,((function (requires){
return (function (v,k,_){
return goog.object.forEach(v,((function (requires){
return (function (v_SINGLEQUOTE_,k_SINGLEQUOTE_,___$1){
var seq__30605 = cljs.core.seq.call(null,figwheel.client.file_reloading.path__GT_name.call(null,k));
var chunk__30606 = null;
var count__30607 = (0);
var i__30608 = (0);
while(true){
if((i__30608 < count__30607)){
var n = cljs.core._nth.call(null,chunk__30606,i__30608);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__30609 = seq__30605;
var G__30610 = chunk__30606;
var G__30611 = count__30607;
var G__30612 = (i__30608 + (1));
seq__30605 = G__30609;
chunk__30606 = G__30610;
count__30607 = G__30611;
i__30608 = G__30612;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__30605);
if(temp__4657__auto__){
var seq__30605__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30605__$1)){
var c__13060__auto__ = cljs.core.chunk_first.call(null,seq__30605__$1);
var G__30613 = cljs.core.chunk_rest.call(null,seq__30605__$1);
var G__30614 = c__13060__auto__;
var G__30615 = cljs.core.count.call(null,c__13060__auto__);
var G__30616 = (0);
seq__30605 = G__30613;
chunk__30606 = G__30614;
count__30607 = G__30615;
i__30608 = G__30616;
continue;
} else {
var n = cljs.core.first.call(null,seq__30605__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,k_SINGLEQUOTE_,n);

var G__30617 = cljs.core.next.call(null,seq__30605__$1);
var G__30618 = null;
var G__30619 = (0);
var G__30620 = (0);
seq__30605 = G__30617;
chunk__30606 = G__30618;
count__30607 = G__30619;
i__30608 = G__30620;
continue;
}
} else {
return null;
}
}
break;
}
});})(requires))
);
});})(requires))
);
});
figwheel.client.file_reloading.ns__GT_dependents = (function figwheel$client$file_reloading$ns__GT_dependents(ns){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.dependency_data),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"dependents","dependents",136812837),ns], null));
});
figwheel.client.file_reloading.build_topo_sort = (function figwheel$client$file_reloading$build_topo_sort(get_deps){
var get_deps__$1 = cljs.core.memoize.call(null,get_deps);
var topo_sort_helper_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_topo_sort_helper_STAR_(x,depth,state){
var deps = get_deps__$1.call(null,x);
if(cljs.core.empty_QMARK_.call(null,deps)){
return null;
} else {
return topo_sort_STAR_.call(null,deps,depth,state);
}
});})(get_deps__$1))
;
var topo_sort_STAR_ = ((function (get_deps__$1){
return (function() {
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = null;
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1 = (function (deps){
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.call(null,deps,(0),cljs.core.atom.call(null,cljs.core.sorted_map.call(null)));
});
var figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3 = (function (deps,depth,state){
cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [depth], null),cljs.core.fnil.call(null,cljs.core.into,cljs.core.PersistentHashSet.EMPTY),deps);

var seq__30671_30682 = cljs.core.seq.call(null,deps);
var chunk__30672_30683 = null;
var count__30673_30684 = (0);
var i__30674_30685 = (0);
while(true){
if((i__30674_30685 < count__30673_30684)){
var dep_30686 = cljs.core._nth.call(null,chunk__30672_30683,i__30674_30685);
topo_sort_helper_STAR_.call(null,dep_30686,(depth + (1)),state);

var G__30687 = seq__30671_30682;
var G__30688 = chunk__30672_30683;
var G__30689 = count__30673_30684;
var G__30690 = (i__30674_30685 + (1));
seq__30671_30682 = G__30687;
chunk__30672_30683 = G__30688;
count__30673_30684 = G__30689;
i__30674_30685 = G__30690;
continue;
} else {
var temp__4657__auto___30691 = cljs.core.seq.call(null,seq__30671_30682);
if(temp__4657__auto___30691){
var seq__30671_30692__$1 = temp__4657__auto___30691;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30671_30692__$1)){
var c__13060__auto___30693 = cljs.core.chunk_first.call(null,seq__30671_30692__$1);
var G__30694 = cljs.core.chunk_rest.call(null,seq__30671_30692__$1);
var G__30695 = c__13060__auto___30693;
var G__30696 = cljs.core.count.call(null,c__13060__auto___30693);
var G__30697 = (0);
seq__30671_30682 = G__30694;
chunk__30672_30683 = G__30695;
count__30673_30684 = G__30696;
i__30674_30685 = G__30697;
continue;
} else {
var dep_30698 = cljs.core.first.call(null,seq__30671_30692__$1);
topo_sort_helper_STAR_.call(null,dep_30698,(depth + (1)),state);

var G__30699 = cljs.core.next.call(null,seq__30671_30692__$1);
var G__30700 = null;
var G__30701 = (0);
var G__30702 = (0);
seq__30671_30682 = G__30699;
chunk__30672_30683 = G__30700;
count__30673_30684 = G__30701;
i__30674_30685 = G__30702;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.call(null,depth,(0))){
return elim_dups_STAR_.call(null,cljs.core.reverse.call(null,cljs.core.vals.call(null,cljs.core.deref.call(null,state))));
} else {
return null;
}
});
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_ = function(deps,depth,state){
switch(arguments.length){
case 1:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1.call(this,deps);
case 3:
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3.call(this,deps,depth,state);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___1;
figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_.cljs$core$IFn$_invoke$arity$3 = figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR___3;
return figwheel$client$file_reloading$build_topo_sort_$_topo_sort_STAR_;
})()
;})(get_deps__$1))
;
var elim_dups_STAR_ = ((function (get_deps__$1){
return (function figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_(p__30675){
var vec__30679 = p__30675;
var seq__30680 = cljs.core.seq.call(null,vec__30679);
var first__30681 = cljs.core.first.call(null,seq__30680);
var seq__30680__$1 = cljs.core.next.call(null,seq__30680);
var x = first__30681;
var xs = seq__30680__$1;
if((x == null)){
return cljs.core.List.EMPTY;
} else {
return cljs.core.cons.call(null,x,figwheel$client$file_reloading$build_topo_sort_$_elim_dups_STAR_.call(null,cljs.core.map.call(null,((function (vec__30679,seq__30680,first__30681,seq__30680__$1,x,xs,get_deps__$1){
return (function (p1__30621_SHARP_){
return clojure.set.difference.call(null,p1__30621_SHARP_,x);
});})(vec__30679,seq__30680,first__30681,seq__30680__$1,x,xs,get_deps__$1))
,xs)));
}
});})(get_deps__$1))
;
return topo_sort_STAR_;
});
figwheel.client.file_reloading.get_all_dependencies = (function figwheel$client$file_reloading$get_all_dependencies(ns){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.get_requires);
return cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ns], null))));
});
figwheel.client.file_reloading.get_all_dependents = (function figwheel$client$file_reloading$get_all_dependents(nss){
var topo_sort_SINGLEQUOTE_ = figwheel.client.file_reloading.build_topo_sort.call(null,figwheel.client.file_reloading.ns__GT_dependents);
return cljs.core.reverse.call(null,cljs.core.apply.call(null,cljs.core.concat,topo_sort_SINGLEQUOTE_.call(null,cljs.core.set.call(null,nss))));
});
figwheel.client.file_reloading.unprovide_BANG_ = (function figwheel$client$file_reloading$unprovide_BANG_(ns){
var path = figwheel.client.file_reloading.name__GT_path.call(null,ns);
goog.object.remove(goog.dependencies_.visited,path);

goog.object.remove(goog.dependencies_.written,path);

return goog.object.remove(goog.dependencies_.written,[cljs.core.str(goog.basePath),cljs.core.str(path)].join(''));
});
figwheel.client.file_reloading.resolve_ns = (function figwheel$client$file_reloading$resolve_ns(ns){
return [cljs.core.str(goog.basePath),cljs.core.str(figwheel.client.file_reloading.name__GT_path.call(null,ns))].join('');
});
figwheel.client.file_reloading.addDependency = (function figwheel$client$file_reloading$addDependency(path,provides,requires){
var seq__30715 = cljs.core.seq.call(null,provides);
var chunk__30716 = null;
var count__30717 = (0);
var i__30718 = (0);
while(true){
if((i__30718 < count__30717)){
var prov = cljs.core._nth.call(null,chunk__30716,i__30718);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__30719_30727 = cljs.core.seq.call(null,requires);
var chunk__30720_30728 = null;
var count__30721_30729 = (0);
var i__30722_30730 = (0);
while(true){
if((i__30722_30730 < count__30721_30729)){
var req_30731 = cljs.core._nth.call(null,chunk__30720_30728,i__30722_30730);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30731,prov);

var G__30732 = seq__30719_30727;
var G__30733 = chunk__30720_30728;
var G__30734 = count__30721_30729;
var G__30735 = (i__30722_30730 + (1));
seq__30719_30727 = G__30732;
chunk__30720_30728 = G__30733;
count__30721_30729 = G__30734;
i__30722_30730 = G__30735;
continue;
} else {
var temp__4657__auto___30736 = cljs.core.seq.call(null,seq__30719_30727);
if(temp__4657__auto___30736){
var seq__30719_30737__$1 = temp__4657__auto___30736;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30719_30737__$1)){
var c__13060__auto___30738 = cljs.core.chunk_first.call(null,seq__30719_30737__$1);
var G__30739 = cljs.core.chunk_rest.call(null,seq__30719_30737__$1);
var G__30740 = c__13060__auto___30738;
var G__30741 = cljs.core.count.call(null,c__13060__auto___30738);
var G__30742 = (0);
seq__30719_30727 = G__30739;
chunk__30720_30728 = G__30740;
count__30721_30729 = G__30741;
i__30722_30730 = G__30742;
continue;
} else {
var req_30743 = cljs.core.first.call(null,seq__30719_30737__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30743,prov);

var G__30744 = cljs.core.next.call(null,seq__30719_30737__$1);
var G__30745 = null;
var G__30746 = (0);
var G__30747 = (0);
seq__30719_30727 = G__30744;
chunk__30720_30728 = G__30745;
count__30721_30729 = G__30746;
i__30722_30730 = G__30747;
continue;
}
} else {
}
}
break;
}

var G__30748 = seq__30715;
var G__30749 = chunk__30716;
var G__30750 = count__30717;
var G__30751 = (i__30718 + (1));
seq__30715 = G__30748;
chunk__30716 = G__30749;
count__30717 = G__30750;
i__30718 = G__30751;
continue;
} else {
var temp__4657__auto__ = cljs.core.seq.call(null,seq__30715);
if(temp__4657__auto__){
var seq__30715__$1 = temp__4657__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30715__$1)){
var c__13060__auto__ = cljs.core.chunk_first.call(null,seq__30715__$1);
var G__30752 = cljs.core.chunk_rest.call(null,seq__30715__$1);
var G__30753 = c__13060__auto__;
var G__30754 = cljs.core.count.call(null,c__13060__auto__);
var G__30755 = (0);
seq__30715 = G__30752;
chunk__30716 = G__30753;
count__30717 = G__30754;
i__30718 = G__30755;
continue;
} else {
var prov = cljs.core.first.call(null,seq__30715__$1);
figwheel.client.file_reloading.path_to_name_BANG_.call(null,path,prov);

var seq__30723_30756 = cljs.core.seq.call(null,requires);
var chunk__30724_30757 = null;
var count__30725_30758 = (0);
var i__30726_30759 = (0);
while(true){
if((i__30726_30759 < count__30725_30758)){
var req_30760 = cljs.core._nth.call(null,chunk__30724_30757,i__30726_30759);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30760,prov);

var G__30761 = seq__30723_30756;
var G__30762 = chunk__30724_30757;
var G__30763 = count__30725_30758;
var G__30764 = (i__30726_30759 + (1));
seq__30723_30756 = G__30761;
chunk__30724_30757 = G__30762;
count__30725_30758 = G__30763;
i__30726_30759 = G__30764;
continue;
} else {
var temp__4657__auto___30765__$1 = cljs.core.seq.call(null,seq__30723_30756);
if(temp__4657__auto___30765__$1){
var seq__30723_30766__$1 = temp__4657__auto___30765__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30723_30766__$1)){
var c__13060__auto___30767 = cljs.core.chunk_first.call(null,seq__30723_30766__$1);
var G__30768 = cljs.core.chunk_rest.call(null,seq__30723_30766__$1);
var G__30769 = c__13060__auto___30767;
var G__30770 = cljs.core.count.call(null,c__13060__auto___30767);
var G__30771 = (0);
seq__30723_30756 = G__30768;
chunk__30724_30757 = G__30769;
count__30725_30758 = G__30770;
i__30726_30759 = G__30771;
continue;
} else {
var req_30772 = cljs.core.first.call(null,seq__30723_30766__$1);
figwheel.client.file_reloading.name_to_parent_BANG_.call(null,req_30772,prov);

var G__30773 = cljs.core.next.call(null,seq__30723_30766__$1);
var G__30774 = null;
var G__30775 = (0);
var G__30776 = (0);
seq__30723_30756 = G__30773;
chunk__30724_30757 = G__30774;
count__30725_30758 = G__30775;
i__30726_30759 = G__30776;
continue;
}
} else {
}
}
break;
}

var G__30777 = cljs.core.next.call(null,seq__30715__$1);
var G__30778 = null;
var G__30779 = (0);
var G__30780 = (0);
seq__30715 = G__30777;
chunk__30716 = G__30778;
count__30717 = G__30779;
i__30718 = G__30780;
continue;
}
} else {
return null;
}
}
break;
}
});
figwheel.client.file_reloading.figwheel_require = (function figwheel$client$file_reloading$figwheel_require(src,reload){
goog.require = figwheel$client$file_reloading$figwheel_require;

if(cljs.core._EQ_.call(null,reload,"reload-all")){
var seq__30785_30789 = cljs.core.seq.call(null,figwheel.client.file_reloading.get_all_dependencies.call(null,src));
var chunk__30786_30790 = null;
var count__30787_30791 = (0);
var i__30788_30792 = (0);
while(true){
if((i__30788_30792 < count__30787_30791)){
var ns_30793 = cljs.core._nth.call(null,chunk__30786_30790,i__30788_30792);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_30793);

var G__30794 = seq__30785_30789;
var G__30795 = chunk__30786_30790;
var G__30796 = count__30787_30791;
var G__30797 = (i__30788_30792 + (1));
seq__30785_30789 = G__30794;
chunk__30786_30790 = G__30795;
count__30787_30791 = G__30796;
i__30788_30792 = G__30797;
continue;
} else {
var temp__4657__auto___30798 = cljs.core.seq.call(null,seq__30785_30789);
if(temp__4657__auto___30798){
var seq__30785_30799__$1 = temp__4657__auto___30798;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__30785_30799__$1)){
var c__13060__auto___30800 = cljs.core.chunk_first.call(null,seq__30785_30799__$1);
var G__30801 = cljs.core.chunk_rest.call(null,seq__30785_30799__$1);
var G__30802 = c__13060__auto___30800;
var G__30803 = cljs.core.count.call(null,c__13060__auto___30800);
var G__30804 = (0);
seq__30785_30789 = G__30801;
chunk__30786_30790 = G__30802;
count__30787_30791 = G__30803;
i__30788_30792 = G__30804;
continue;
} else {
var ns_30805 = cljs.core.first.call(null,seq__30785_30799__$1);
figwheel.client.file_reloading.unprovide_BANG_.call(null,ns_30805);

var G__30806 = cljs.core.next.call(null,seq__30785_30799__$1);
var G__30807 = null;
var G__30808 = (0);
var G__30809 = (0);
seq__30785_30789 = G__30806;
chunk__30786_30790 = G__30807;
count__30787_30791 = G__30808;
i__30788_30792 = G__30809;
continue;
}
} else {
}
}
break;
}
} else {
}

if(cljs.core.truth_(reload)){
figwheel.client.file_reloading.unprovide_BANG_.call(null,src);
} else {
}

return goog.require_figwheel_backup_(src);
});
/**
 * Reusable browser REPL bootstrapping. Patches the essential functions
 *   in goog.base to support re-loading of namespaces after page load.
 */
figwheel.client.file_reloading.bootstrap_goog_base = (function figwheel$client$file_reloading$bootstrap_goog_base(){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
goog.require_figwheel_backup_ = (function (){var or__12249__auto__ = goog.require__;
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return goog.require;
}
})();

goog.isProvided_ = (function (name){
return false;
});

figwheel.client.file_reloading.setup_path__GT_name_BANG_.call(null);

figwheel.client.file_reloading.setup_ns__GT_dependents_BANG_.call(null);

goog.addDependency_figwheel_backup_ = goog.addDependency;

goog.addDependency = (function() { 
var G__30810__delegate = function (args){
cljs.core.apply.call(null,figwheel.client.file_reloading.addDependency,args);

return cljs.core.apply.call(null,goog.addDependency_figwheel_backup_,args);
};
var G__30810 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__30811__i = 0, G__30811__a = new Array(arguments.length -  0);
while (G__30811__i < G__30811__a.length) {G__30811__a[G__30811__i] = arguments[G__30811__i + 0]; ++G__30811__i;}
  args = new cljs.core.IndexedSeq(G__30811__a,0);
} 
return G__30810__delegate.call(this,args);};
G__30810.cljs$lang$maxFixedArity = 0;
G__30810.cljs$lang$applyTo = (function (arglist__30812){
var args = cljs.core.seq(arglist__30812);
return G__30810__delegate(args);
});
G__30810.cljs$core$IFn$_invoke$arity$variadic = G__30810__delegate;
return G__30810;
})()
;

goog.constructNamespace_("cljs.user");

goog.global.CLOSURE_IMPORT_SCRIPT = figwheel.client.file_reloading.queued_file_reload;

return goog.require = figwheel.client.file_reloading.figwheel_require;
}
});
figwheel.client.file_reloading.patch_goog_base = (function figwheel$client$file_reloading$patch_goog_base(){
if(typeof figwheel.client.file_reloading.bootstrapped_cljs !== 'undefined'){
return null;
} else {
figwheel.client.file_reloading.bootstrapped_cljs = (function (){
figwheel.client.file_reloading.bootstrap_goog_base.call(null);

return true;
})()
;
}
});
figwheel.client.file_reloading.reload_file_STAR_ = (function (){var pred__30814 = cljs.core._EQ_;
var expr__30815 = figwheel.client.utils.host_env_QMARK_.call(null);
if(cljs.core.truth_(pred__30814.call(null,new cljs.core.Keyword(null,"node","node",581201198),expr__30815))){
var path_parts = ((function (pred__30814,expr__30815){
return (function (p1__30813_SHARP_){
return clojure.string.split.call(null,p1__30813_SHARP_,/[\/\\]/);
});})(pred__30814,expr__30815))
;
var sep = (cljs.core.truth_(cljs.core.re_matches.call(null,/win.*/,process.platform))?"\\":"/");
var root = clojure.string.join.call(null,sep,cljs.core.pop.call(null,cljs.core.pop.call(null,path_parts.call(null,__dirname))));
return ((function (path_parts,sep,root,pred__30814,expr__30815){
return (function (request_url,callback){

var cache_path = clojure.string.join.call(null,sep,cljs.core.cons.call(null,root,path_parts.call(null,figwheel.client.file_reloading.fix_node_request_url.call(null,request_url))));
(require.cache[cache_path] = null);

return callback.call(null,(function (){try{return require(cache_path);
}catch (e30817){if((e30817 instanceof Error)){
var e = e30817;
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(cache_path)].join(''));

figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),e.stack);

return false;
} else {
throw e30817;

}
}})());
});
;})(path_parts,sep,root,pred__30814,expr__30815))
} else {
if(cljs.core.truth_(pred__30814.call(null,new cljs.core.Keyword(null,"html","html",-998796897),expr__30815))){
return ((function (pred__30814,expr__30815){
return (function (request_url,callback){

var deferred = goog.net.jsloader.load(figwheel.client.file_reloading.add_cache_buster.call(null,request_url),{"cleanupWhenDone": true});
deferred.addCallback(((function (deferred,pred__30814,expr__30815){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [true], null));
});})(deferred,pred__30814,expr__30815))
);

return deferred.addErrback(((function (deferred,pred__30814,expr__30815){
return (function (){
return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [false], null));
});})(deferred,pred__30814,expr__30815))
);
});
;})(pred__30814,expr__30815))
} else {
return ((function (pred__30814,expr__30815){
return (function (a,b){
throw "Reload not defined for this platform";
});
;})(pred__30814,expr__30815))
}
}
})();
figwheel.client.file_reloading.reload_file = (function figwheel$client$file_reloading$reload_file(p__30818,callback){
var map__30821 = p__30818;
var map__30821__$1 = ((((!((map__30821 == null)))?((((map__30821.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30821.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30821):map__30821);
var file_msg = map__30821__$1;
var request_url = cljs.core.get.call(null,map__30821__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));

figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Attempting to load "),cljs.core.str(request_url)].join(''));

return figwheel.client.file_reloading.reload_file_STAR_.call(null,request_url,((function (map__30821,map__30821__$1,file_msg,request_url){
return (function (success_QMARK_){
if(cljs.core.truth_(success_QMARK_)){
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("FigWheel: Successfully loaded "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.call(null,file_msg,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),true)], null));
} else {
figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Figwheel: Error loading file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});})(map__30821,map__30821__$1,file_msg,request_url))
);
});
if(typeof figwheel.client.file_reloading.reload_chan !== 'undefined'){
} else {
figwheel.client.file_reloading.reload_chan = cljs.core.async.chan.call(null);
}
if(typeof figwheel.client.file_reloading.on_load_callbacks !== 'undefined'){
} else {
figwheel.client.file_reloading.on_load_callbacks = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
}
if(typeof figwheel.client.file_reloading.dependencies_loaded !== 'undefined'){
} else {
figwheel.client.file_reloading.dependencies_loaded = cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY);
}
figwheel.client.file_reloading.blocking_load = (function figwheel$client$file_reloading$blocking_load(url){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.reload_file.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"request-url","request-url",2100346596),url], null),((function (out){
return (function (file_msg){
cljs.core.async.put_BANG_.call(null,out,file_msg);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
if(typeof figwheel.client.file_reloading.reloader_loop !== 'undefined'){
} else {
figwheel.client.file_reloading.reloader_loop = (function (){var c__16469__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto__){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto__){
return (function (state_30845){
var state_val_30846 = (state_30845[(1)]);
if((state_val_30846 === (7))){
var inst_30841 = (state_30845[(2)]);
var state_30845__$1 = state_30845;
var statearr_30847_30867 = state_30845__$1;
(statearr_30847_30867[(2)] = inst_30841);

(statearr_30847_30867[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30846 === (1))){
var state_30845__$1 = state_30845;
var statearr_30848_30868 = state_30845__$1;
(statearr_30848_30868[(2)] = null);

(statearr_30848_30868[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30846 === (4))){
var inst_30825 = (state_30845[(7)]);
var inst_30825__$1 = (state_30845[(2)]);
var state_30845__$1 = (function (){var statearr_30849 = state_30845;
(statearr_30849[(7)] = inst_30825__$1);

return statearr_30849;
})();
if(cljs.core.truth_(inst_30825__$1)){
var statearr_30850_30869 = state_30845__$1;
(statearr_30850_30869[(1)] = (5));

} else {
var statearr_30851_30870 = state_30845__$1;
(statearr_30851_30870[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30846 === (6))){
var state_30845__$1 = state_30845;
var statearr_30852_30871 = state_30845__$1;
(statearr_30852_30871[(2)] = null);

(statearr_30852_30871[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30846 === (3))){
var inst_30843 = (state_30845[(2)]);
var state_30845__$1 = state_30845;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30845__$1,inst_30843);
} else {
if((state_val_30846 === (2))){
var state_30845__$1 = state_30845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30845__$1,(4),figwheel.client.file_reloading.reload_chan);
} else {
if((state_val_30846 === (11))){
var inst_30837 = (state_30845[(2)]);
var state_30845__$1 = (function (){var statearr_30853 = state_30845;
(statearr_30853[(8)] = inst_30837);

return statearr_30853;
})();
var statearr_30854_30872 = state_30845__$1;
(statearr_30854_30872[(2)] = null);

(statearr_30854_30872[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30846 === (9))){
var inst_30829 = (state_30845[(9)]);
var inst_30831 = (state_30845[(10)]);
var inst_30833 = inst_30831.call(null,inst_30829);
var state_30845__$1 = state_30845;
var statearr_30855_30873 = state_30845__$1;
(statearr_30855_30873[(2)] = inst_30833);

(statearr_30855_30873[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30846 === (5))){
var inst_30825 = (state_30845[(7)]);
var inst_30827 = figwheel.client.file_reloading.blocking_load.call(null,inst_30825);
var state_30845__$1 = state_30845;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30845__$1,(8),inst_30827);
} else {
if((state_val_30846 === (10))){
var inst_30829 = (state_30845[(9)]);
var inst_30835 = cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,cljs.core.conj,inst_30829);
var state_30845__$1 = state_30845;
var statearr_30856_30874 = state_30845__$1;
(statearr_30856_30874[(2)] = inst_30835);

(statearr_30856_30874[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30846 === (8))){
var inst_30825 = (state_30845[(7)]);
var inst_30831 = (state_30845[(10)]);
var inst_30829 = (state_30845[(2)]);
var inst_30830 = cljs.core.deref.call(null,figwheel.client.file_reloading.on_load_callbacks);
var inst_30831__$1 = cljs.core.get.call(null,inst_30830,inst_30825);
var state_30845__$1 = (function (){var statearr_30857 = state_30845;
(statearr_30857[(9)] = inst_30829);

(statearr_30857[(10)] = inst_30831__$1);

return statearr_30857;
})();
if(cljs.core.truth_(inst_30831__$1)){
var statearr_30858_30875 = state_30845__$1;
(statearr_30858_30875[(1)] = (9));

} else {
var statearr_30859_30876 = state_30845__$1;
(statearr_30859_30876[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto__))
;
return ((function (switch__16357__auto__,c__16469__auto__){
return (function() {
var figwheel$client$file_reloading$state_machine__16358__auto__ = null;
var figwheel$client$file_reloading$state_machine__16358__auto____0 = (function (){
var statearr_30863 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30863[(0)] = figwheel$client$file_reloading$state_machine__16358__auto__);

(statearr_30863[(1)] = (1));

return statearr_30863;
});
var figwheel$client$file_reloading$state_machine__16358__auto____1 = (function (state_30845){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_30845);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e30864){if((e30864 instanceof Object)){
var ex__16361__auto__ = e30864;
var statearr_30865_30877 = state_30845;
(statearr_30865_30877[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30845);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30864;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__30878 = state_30845;
state_30845 = G__30878;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
figwheel$client$file_reloading$state_machine__16358__auto__ = function(state_30845){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$state_machine__16358__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$state_machine__16358__auto____1.call(this,state_30845);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$state_machine__16358__auto____0;
figwheel$client$file_reloading$state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$state_machine__16358__auto____1;
return figwheel$client$file_reloading$state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto__))
})();
var state__16471__auto__ = (function (){var statearr_30866 = f__16470__auto__.call(null);
(statearr_30866[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto__);

return statearr_30866;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto__))
);

return c__16469__auto__;
})();
}
figwheel.client.file_reloading.queued_file_reload = (function figwheel$client$file_reloading$queued_file_reload(url){
return cljs.core.async.put_BANG_.call(null,figwheel.client.file_reloading.reload_chan,url);
});
figwheel.client.file_reloading.require_with_callback = (function figwheel$client$file_reloading$require_with_callback(p__30879,callback){
var map__30882 = p__30879;
var map__30882__$1 = ((((!((map__30882 == null)))?((((map__30882.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30882.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30882):map__30882);
var file_msg = map__30882__$1;
var namespace = cljs.core.get.call(null,map__30882__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var request_url = figwheel.client.file_reloading.resolve_ns.call(null,namespace);
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.assoc,request_url,((function (request_url,map__30882,map__30882__$1,file_msg,namespace){
return (function (file_msg_SINGLEQUOTE_){
cljs.core.swap_BANG_.call(null,figwheel.client.file_reloading.on_load_callbacks,cljs.core.dissoc,request_url);

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.merge.call(null,file_msg,cljs.core.select_keys.call(null,file_msg_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375)], null)))], null));
});})(request_url,map__30882,map__30882__$1,file_msg,namespace))
);

return figwheel.client.file_reloading.figwheel_require.call(null,cljs.core.name.call(null,namespace),true);
});
figwheel.client.file_reloading.reload_file_QMARK_ = (function figwheel$client$file_reloading$reload_file_QMARK_(p__30884){
var map__30887 = p__30884;
var map__30887__$1 = ((((!((map__30887 == null)))?((((map__30887.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30887.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30887):map__30887);
var file_msg = map__30887__$1;
var namespace = cljs.core.get.call(null,map__30887__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

var meta_pragmas = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
var and__12237__auto__ = cljs.core.not.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179).cljs$core$IFn$_invoke$arity$1(meta_pragmas));
if(and__12237__auto__){
var or__12249__auto__ = new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
var or__12249__auto____$1 = new cljs.core.Keyword(null,"figwheel-load","figwheel-load",1316089175).cljs$core$IFn$_invoke$arity$1(meta_pragmas);
if(cljs.core.truth_(or__12249__auto____$1)){
return or__12249__auto____$1;
} else {
return figwheel.client.file_reloading.provided_QMARK_.call(null,cljs.core.name.call(null,namespace));
}
}
} else {
return and__12237__auto__;
}
});
figwheel.client.file_reloading.js_reload = (function figwheel$client$file_reloading$js_reload(p__30889,callback){
var map__30892 = p__30889;
var map__30892__$1 = ((((!((map__30892 == null)))?((((map__30892.cljs$lang$protocol_mask$partition0$ & (64))) || (map__30892.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__30892):map__30892);
var file_msg = map__30892__$1;
var request_url = cljs.core.get.call(null,map__30892__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
var namespace = cljs.core.get.call(null,map__30892__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));

if(cljs.core.truth_(figwheel.client.file_reloading.reload_file_QMARK_.call(null,file_msg))){
return figwheel.client.file_reloading.require_with_callback.call(null,file_msg,callback);
} else {
figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Figwheel: Not trying to load file "),cljs.core.str(request_url)].join(''));

return cljs.core.apply.call(null,callback,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [file_msg], null));
}
});
figwheel.client.file_reloading.reload_js_file = (function figwheel$client$file_reloading$reload_js_file(file_msg){
var out = cljs.core.async.chan.call(null);
figwheel.client.file_reloading.js_reload.call(null,file_msg,((function (out){
return (function (url){
cljs.core.async.put_BANG_.call(null,out,url);

return cljs.core.async.close_BANG_.call(null,out);
});})(out))
);

return out;
});
/**
 * Returns a chanel with one collection of loaded filenames on it.
 */
figwheel.client.file_reloading.load_all_js_files = (function figwheel$client$file_reloading$load_all_js_files(files){
var out = cljs.core.async.chan.call(null);
var c__16469__auto___30996 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto___30996,out){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto___30996,out){
return (function (state_30978){
var state_val_30979 = (state_30978[(1)]);
if((state_val_30979 === (1))){
var inst_30952 = cljs.core.seq.call(null,files);
var inst_30953 = cljs.core.first.call(null,inst_30952);
var inst_30954 = cljs.core.next.call(null,inst_30952);
var inst_30955 = files;
var state_30978__$1 = (function (){var statearr_30980 = state_30978;
(statearr_30980[(7)] = inst_30954);

(statearr_30980[(8)] = inst_30955);

(statearr_30980[(9)] = inst_30953);

return statearr_30980;
})();
var statearr_30981_30997 = state_30978__$1;
(statearr_30981_30997[(2)] = null);

(statearr_30981_30997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30979 === (2))){
var inst_30955 = (state_30978[(8)]);
var inst_30961 = (state_30978[(10)]);
var inst_30960 = cljs.core.seq.call(null,inst_30955);
var inst_30961__$1 = cljs.core.first.call(null,inst_30960);
var inst_30962 = cljs.core.next.call(null,inst_30960);
var inst_30963 = (inst_30961__$1 == null);
var inst_30964 = cljs.core.not.call(null,inst_30963);
var state_30978__$1 = (function (){var statearr_30982 = state_30978;
(statearr_30982[(11)] = inst_30962);

(statearr_30982[(10)] = inst_30961__$1);

return statearr_30982;
})();
if(inst_30964){
var statearr_30983_30998 = state_30978__$1;
(statearr_30983_30998[(1)] = (4));

} else {
var statearr_30984_30999 = state_30978__$1;
(statearr_30984_30999[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30979 === (3))){
var inst_30976 = (state_30978[(2)]);
var state_30978__$1 = state_30978;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_30978__$1,inst_30976);
} else {
if((state_val_30979 === (4))){
var inst_30961 = (state_30978[(10)]);
var inst_30966 = figwheel.client.file_reloading.reload_js_file.call(null,inst_30961);
var state_30978__$1 = state_30978;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_30978__$1,(7),inst_30966);
} else {
if((state_val_30979 === (5))){
var inst_30972 = cljs.core.async.close_BANG_.call(null,out);
var state_30978__$1 = state_30978;
var statearr_30985_31000 = state_30978__$1;
(statearr_30985_31000[(2)] = inst_30972);

(statearr_30985_31000[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30979 === (6))){
var inst_30974 = (state_30978[(2)]);
var state_30978__$1 = state_30978;
var statearr_30986_31001 = state_30978__$1;
(statearr_30986_31001[(2)] = inst_30974);

(statearr_30986_31001[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_30979 === (7))){
var inst_30962 = (state_30978[(11)]);
var inst_30968 = (state_30978[(2)]);
var inst_30969 = cljs.core.async.put_BANG_.call(null,out,inst_30968);
var inst_30955 = inst_30962;
var state_30978__$1 = (function (){var statearr_30987 = state_30978;
(statearr_30987[(12)] = inst_30969);

(statearr_30987[(8)] = inst_30955);

return statearr_30987;
})();
var statearr_30988_31002 = state_30978__$1;
(statearr_30988_31002[(2)] = null);

(statearr_30988_31002[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__16469__auto___30996,out))
;
return ((function (switch__16357__auto__,c__16469__auto___30996,out){
return (function() {
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto__ = null;
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto____0 = (function (){
var statearr_30992 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30992[(0)] = figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto__);

(statearr_30992[(1)] = (1));

return statearr_30992;
});
var figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto____1 = (function (state_30978){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_30978);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e30993){if((e30993 instanceof Object)){
var ex__16361__auto__ = e30993;
var statearr_30994_31003 = state_30978;
(statearr_30994_31003[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_30978);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e30993;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31004 = state_30978;
state_30978 = G__31004;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto__ = function(state_30978){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto____1.call(this,state_30978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto____0;
figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto____1;
return figwheel$client$file_reloading$load_all_js_files_$_state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto___30996,out))
})();
var state__16471__auto__ = (function (){var statearr_30995 = f__16470__auto__.call(null);
(statearr_30995[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto___30996);

return statearr_30995;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto___30996,out))
);


return cljs.core.async.into.call(null,cljs.core.PersistentVector.EMPTY,out);
});
figwheel.client.file_reloading.eval_body = (function figwheel$client$file_reloading$eval_body(p__31005,opts){
var map__31009 = p__31005;
var map__31009__$1 = ((((!((map__31009 == null)))?((((map__31009.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31009.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31009):map__31009);
var eval_body__$1 = cljs.core.get.call(null,map__31009__$1,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883));
var file = cljs.core.get.call(null,map__31009__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_((function (){var and__12237__auto__ = eval_body__$1;
if(cljs.core.truth_(and__12237__auto__)){
return typeof eval_body__$1 === 'string';
} else {
return and__12237__auto__;
}
})())){
var code = eval_body__$1;
try{figwheel.client.utils.debug_prn.call(null,[cljs.core.str("Evaling file "),cljs.core.str(file)].join(''));

return figwheel.client.utils.eval_helper.call(null,code,opts);
}catch (e31011){var e = e31011;
return figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"error","error",-978969032),[cljs.core.str("Unable to evaluate "),cljs.core.str(file)].join(''));
}} else {
return null;
}
});
figwheel.client.file_reloading.expand_files = (function figwheel$client$file_reloading$expand_files(files){
var deps = figwheel.client.file_reloading.get_all_dependents.call(null,cljs.core.map.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.not,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["figwheel.connect",null], null), null),new cljs.core.Keyword(null,"namespace","namespace",-377510372)),cljs.core.map.call(null,((function (deps){
return (function (n){
var temp__4655__auto__ = cljs.core.first.call(null,cljs.core.filter.call(null,((function (deps){
return (function (p1__31012_SHARP_){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__31012_SHARP_),n);
});})(deps))
,files));
if(cljs.core.truth_(temp__4655__auto__)){
var file_msg = temp__4655__auto__;
return file_msg;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372),new cljs.core.Keyword(null,"namespace","namespace",-377510372),n], null);
}
});})(deps))
,deps));
});
figwheel.client.file_reloading.sort_files = (function figwheel$client$file_reloading$sort_files(files){
if((cljs.core.count.call(null,files) <= (1))){
return files;
} else {
var keep_files = cljs.core.set.call(null,cljs.core.keep.call(null,new cljs.core.Keyword(null,"namespace","namespace",-377510372),files));
return cljs.core.filter.call(null,cljs.core.comp.call(null,keep_files,new cljs.core.Keyword(null,"namespace","namespace",-377510372)),figwheel.client.file_reloading.expand_files.call(null,files));
}
});
figwheel.client.file_reloading.get_figwheel_always = (function figwheel$client$file_reloading$get_figwheel_always(){
return cljs.core.map.call(null,(function (p__31021){
var vec__31022 = p__31021;
var k = cljs.core.nth.call(null,vec__31022,(0),null);
var v = cljs.core.nth.call(null,vec__31022,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"namespace","namespace",-377510372),k,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"namespace","namespace",-377510372)], null);
}),cljs.core.filter.call(null,(function (p__31025){
var vec__31026 = p__31025;
var k = cljs.core.nth.call(null,vec__31026,(0),null);
var v = cljs.core.nth.call(null,vec__31026,(1),null);
return new cljs.core.Keyword(null,"figwheel-always","figwheel-always",799819691).cljs$core$IFn$_invoke$arity$1(v);
}),cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas)));
});
figwheel.client.file_reloading.reload_js_files = (function figwheel$client$file_reloading$reload_js_files(p__31032,p__31033){
var map__31280 = p__31032;
var map__31280__$1 = ((((!((map__31280 == null)))?((((map__31280.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31280.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31280):map__31280);
var opts = map__31280__$1;
var before_jsload = cljs.core.get.call(null,map__31280__$1,new cljs.core.Keyword(null,"before-jsload","before-jsload",-847513128));
var on_jsload = cljs.core.get.call(null,map__31280__$1,new cljs.core.Keyword(null,"on-jsload","on-jsload",-395756602));
var reload_dependents = cljs.core.get.call(null,map__31280__$1,new cljs.core.Keyword(null,"reload-dependents","reload-dependents",-956865430));
var map__31281 = p__31033;
var map__31281__$1 = ((((!((map__31281 == null)))?((((map__31281.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31281.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31281):map__31281);
var msg = map__31281__$1;
var files = cljs.core.get.call(null,map__31281__$1,new cljs.core.Keyword(null,"files","files",-472457450));
var figwheel_meta = cljs.core.get.call(null,map__31281__$1,new cljs.core.Keyword(null,"figwheel-meta","figwheel-meta",-225970237));
var recompile_dependents = cljs.core.get.call(null,map__31281__$1,new cljs.core.Keyword(null,"recompile-dependents","recompile-dependents",523804171));
if(cljs.core.empty_QMARK_.call(null,figwheel_meta)){
} else {
cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas,figwheel_meta);
}

var c__16469__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
var f__16470__auto__ = (function (){var switch__16357__auto__ = ((function (c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (state_31434){
var state_val_31435 = (state_31434[(1)]);
if((state_val_31435 === (7))){
var inst_31296 = (state_31434[(7)]);
var inst_31295 = (state_31434[(8)]);
var inst_31297 = (state_31434[(9)]);
var inst_31298 = (state_31434[(10)]);
var inst_31303 = cljs.core._nth.call(null,inst_31296,inst_31298);
var inst_31304 = figwheel.client.file_reloading.eval_body.call(null,inst_31303,opts);
var inst_31305 = (inst_31298 + (1));
var tmp31436 = inst_31296;
var tmp31437 = inst_31295;
var tmp31438 = inst_31297;
var inst_31295__$1 = tmp31437;
var inst_31296__$1 = tmp31436;
var inst_31297__$1 = tmp31438;
var inst_31298__$1 = inst_31305;
var state_31434__$1 = (function (){var statearr_31439 = state_31434;
(statearr_31439[(7)] = inst_31296__$1);

(statearr_31439[(8)] = inst_31295__$1);

(statearr_31439[(9)] = inst_31297__$1);

(statearr_31439[(11)] = inst_31304);

(statearr_31439[(10)] = inst_31298__$1);

return statearr_31439;
})();
var statearr_31440_31526 = state_31434__$1;
(statearr_31440_31526[(2)] = null);

(statearr_31440_31526[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (20))){
var inst_31338 = (state_31434[(12)]);
var inst_31346 = figwheel.client.file_reloading.sort_files.call(null,inst_31338);
var state_31434__$1 = state_31434;
var statearr_31441_31527 = state_31434__$1;
(statearr_31441_31527[(2)] = inst_31346);

(statearr_31441_31527[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (27))){
var state_31434__$1 = state_31434;
var statearr_31442_31528 = state_31434__$1;
(statearr_31442_31528[(2)] = null);

(statearr_31442_31528[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (1))){
var inst_31287 = (state_31434[(13)]);
var inst_31284 = before_jsload.call(null,files);
var inst_31285 = figwheel.client.file_reloading.before_jsload_custom_event.call(null,files);
var inst_31286 = (function (){return ((function (inst_31287,inst_31284,inst_31285,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31029_SHARP_){
return new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__31029_SHARP_);
});
;})(inst_31287,inst_31284,inst_31285,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31287__$1 = cljs.core.filter.call(null,inst_31286,files);
var inst_31288 = cljs.core.not_empty.call(null,inst_31287__$1);
var state_31434__$1 = (function (){var statearr_31443 = state_31434;
(statearr_31443[(14)] = inst_31285);

(statearr_31443[(15)] = inst_31284);

(statearr_31443[(13)] = inst_31287__$1);

return statearr_31443;
})();
if(cljs.core.truth_(inst_31288)){
var statearr_31444_31529 = state_31434__$1;
(statearr_31444_31529[(1)] = (2));

} else {
var statearr_31445_31530 = state_31434__$1;
(statearr_31445_31530[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (24))){
var state_31434__$1 = state_31434;
var statearr_31446_31531 = state_31434__$1;
(statearr_31446_31531[(2)] = null);

(statearr_31446_31531[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (39))){
var inst_31388 = (state_31434[(16)]);
var state_31434__$1 = state_31434;
var statearr_31447_31532 = state_31434__$1;
(statearr_31447_31532[(2)] = inst_31388);

(statearr_31447_31532[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (46))){
var inst_31429 = (state_31434[(2)]);
var state_31434__$1 = state_31434;
var statearr_31448_31533 = state_31434__$1;
(statearr_31448_31533[(2)] = inst_31429);

(statearr_31448_31533[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (4))){
var inst_31332 = (state_31434[(2)]);
var inst_31333 = cljs.core.List.EMPTY;
var inst_31334 = cljs.core.reset_BANG_.call(null,figwheel.client.file_reloading.dependencies_loaded,inst_31333);
var inst_31335 = (function (){return ((function (inst_31332,inst_31333,inst_31334,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31030_SHARP_){
var and__12237__auto__ = new cljs.core.Keyword(null,"namespace","namespace",-377510372).cljs$core$IFn$_invoke$arity$1(p1__31030_SHARP_);
if(cljs.core.truth_(and__12237__auto__)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"eval-body","eval-body",-907279883).cljs$core$IFn$_invoke$arity$1(p1__31030_SHARP_));
} else {
return and__12237__auto__;
}
});
;})(inst_31332,inst_31333,inst_31334,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31336 = cljs.core.filter.call(null,inst_31335,files);
var inst_31337 = figwheel.client.file_reloading.get_figwheel_always.call(null);
var inst_31338 = cljs.core.concat.call(null,inst_31336,inst_31337);
var state_31434__$1 = (function (){var statearr_31449 = state_31434;
(statearr_31449[(12)] = inst_31338);

(statearr_31449[(17)] = inst_31334);

(statearr_31449[(18)] = inst_31332);

return statearr_31449;
})();
if(cljs.core.truth_(reload_dependents)){
var statearr_31450_31534 = state_31434__$1;
(statearr_31450_31534[(1)] = (16));

} else {
var statearr_31451_31535 = state_31434__$1;
(statearr_31451_31535[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (15))){
var inst_31322 = (state_31434[(2)]);
var state_31434__$1 = state_31434;
var statearr_31452_31536 = state_31434__$1;
(statearr_31452_31536[(2)] = inst_31322);

(statearr_31452_31536[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (21))){
var inst_31348 = (state_31434[(19)]);
var inst_31348__$1 = (state_31434[(2)]);
var inst_31349 = figwheel.client.file_reloading.load_all_js_files.call(null,inst_31348__$1);
var state_31434__$1 = (function (){var statearr_31453 = state_31434;
(statearr_31453[(19)] = inst_31348__$1);

return statearr_31453;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_31434__$1,(22),inst_31349);
} else {
if((state_val_31435 === (31))){
var inst_31432 = (state_31434[(2)]);
var state_31434__$1 = state_31434;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_31434__$1,inst_31432);
} else {
if((state_val_31435 === (32))){
var inst_31388 = (state_31434[(16)]);
var inst_31393 = inst_31388.cljs$lang$protocol_mask$partition0$;
var inst_31394 = (inst_31393 & (64));
var inst_31395 = inst_31388.cljs$core$ISeq$;
var inst_31396 = (inst_31394) || (inst_31395);
var state_31434__$1 = state_31434;
if(cljs.core.truth_(inst_31396)){
var statearr_31454_31537 = state_31434__$1;
(statearr_31454_31537[(1)] = (35));

} else {
var statearr_31455_31538 = state_31434__$1;
(statearr_31455_31538[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (40))){
var inst_31409 = (state_31434[(20)]);
var inst_31408 = (state_31434[(2)]);
var inst_31409__$1 = cljs.core.get.call(null,inst_31408,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179));
var inst_31410 = cljs.core.get.call(null,inst_31408,new cljs.core.Keyword(null,"not-required","not-required",-950359114));
var inst_31411 = cljs.core.not_empty.call(null,inst_31409__$1);
var state_31434__$1 = (function (){var statearr_31456 = state_31434;
(statearr_31456[(20)] = inst_31409__$1);

(statearr_31456[(21)] = inst_31410);

return statearr_31456;
})();
if(cljs.core.truth_(inst_31411)){
var statearr_31457_31539 = state_31434__$1;
(statearr_31457_31539[(1)] = (41));

} else {
var statearr_31458_31540 = state_31434__$1;
(statearr_31458_31540[(1)] = (42));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (33))){
var state_31434__$1 = state_31434;
var statearr_31459_31541 = state_31434__$1;
(statearr_31459_31541[(2)] = false);

(statearr_31459_31541[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (13))){
var inst_31308 = (state_31434[(22)]);
var inst_31312 = cljs.core.chunk_first.call(null,inst_31308);
var inst_31313 = cljs.core.chunk_rest.call(null,inst_31308);
var inst_31314 = cljs.core.count.call(null,inst_31312);
var inst_31295 = inst_31313;
var inst_31296 = inst_31312;
var inst_31297 = inst_31314;
var inst_31298 = (0);
var state_31434__$1 = (function (){var statearr_31460 = state_31434;
(statearr_31460[(7)] = inst_31296);

(statearr_31460[(8)] = inst_31295);

(statearr_31460[(9)] = inst_31297);

(statearr_31460[(10)] = inst_31298);

return statearr_31460;
})();
var statearr_31461_31542 = state_31434__$1;
(statearr_31461_31542[(2)] = null);

(statearr_31461_31542[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (22))){
var inst_31352 = (state_31434[(23)]);
var inst_31348 = (state_31434[(19)]);
var inst_31356 = (state_31434[(24)]);
var inst_31351 = (state_31434[(25)]);
var inst_31351__$1 = (state_31434[(2)]);
var inst_31352__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_31351__$1);
var inst_31353 = (function (){var all_files = inst_31348;
var res_SINGLEQUOTE_ = inst_31351__$1;
var res = inst_31352__$1;
return ((function (all_files,res_SINGLEQUOTE_,res,inst_31352,inst_31348,inst_31356,inst_31351,inst_31351__$1,inst_31352__$1,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p1__31031_SHARP_){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375).cljs$core$IFn$_invoke$arity$1(p1__31031_SHARP_));
});
;})(all_files,res_SINGLEQUOTE_,res,inst_31352,inst_31348,inst_31356,inst_31351,inst_31351__$1,inst_31352__$1,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31354 = cljs.core.filter.call(null,inst_31353,inst_31351__$1);
var inst_31355 = cljs.core.deref.call(null,figwheel.client.file_reloading.dependencies_loaded);
var inst_31356__$1 = cljs.core.filter.call(null,new cljs.core.Keyword(null,"loaded-file","loaded-file",-168399375),inst_31355);
var inst_31357 = cljs.core.not_empty.call(null,inst_31356__$1);
var state_31434__$1 = (function (){var statearr_31462 = state_31434;
(statearr_31462[(23)] = inst_31352__$1);

(statearr_31462[(26)] = inst_31354);

(statearr_31462[(24)] = inst_31356__$1);

(statearr_31462[(25)] = inst_31351__$1);

return statearr_31462;
})();
if(cljs.core.truth_(inst_31357)){
var statearr_31463_31543 = state_31434__$1;
(statearr_31463_31543[(1)] = (23));

} else {
var statearr_31464_31544 = state_31434__$1;
(statearr_31464_31544[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (36))){
var state_31434__$1 = state_31434;
var statearr_31465_31545 = state_31434__$1;
(statearr_31465_31545[(2)] = false);

(statearr_31465_31545[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (41))){
var inst_31409 = (state_31434[(20)]);
var inst_31413 = cljs.core.comp.call(null,figwheel.client.file_reloading.name__GT_path,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var inst_31414 = cljs.core.map.call(null,inst_31413,inst_31409);
var inst_31415 = cljs.core.pr_str.call(null,inst_31414);
var inst_31416 = [cljs.core.str("figwheel-no-load meta-data: "),cljs.core.str(inst_31415)].join('');
var inst_31417 = figwheel.client.utils.log.call(null,inst_31416);
var state_31434__$1 = state_31434;
var statearr_31466_31546 = state_31434__$1;
(statearr_31466_31546[(2)] = inst_31417);

(statearr_31466_31546[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (43))){
var inst_31410 = (state_31434[(21)]);
var inst_31420 = (state_31434[(2)]);
var inst_31421 = cljs.core.not_empty.call(null,inst_31410);
var state_31434__$1 = (function (){var statearr_31467 = state_31434;
(statearr_31467[(27)] = inst_31420);

return statearr_31467;
})();
if(cljs.core.truth_(inst_31421)){
var statearr_31468_31547 = state_31434__$1;
(statearr_31468_31547[(1)] = (44));

} else {
var statearr_31469_31548 = state_31434__$1;
(statearr_31469_31548[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (29))){
var inst_31352 = (state_31434[(23)]);
var inst_31354 = (state_31434[(26)]);
var inst_31348 = (state_31434[(19)]);
var inst_31388 = (state_31434[(16)]);
var inst_31356 = (state_31434[(24)]);
var inst_31351 = (state_31434[(25)]);
var inst_31384 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: NOT loading these files ");
var inst_31387 = (function (){var all_files = inst_31348;
var res_SINGLEQUOTE_ = inst_31351;
var res = inst_31352;
var files_not_loaded = inst_31354;
var dependencies_that_loaded = inst_31356;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31352,inst_31354,inst_31348,inst_31388,inst_31356,inst_31351,inst_31384,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31386){
var map__31470 = p__31386;
var map__31470__$1 = ((((!((map__31470 == null)))?((((map__31470.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31470.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31470):map__31470);
var namespace = cljs.core.get.call(null,map__31470__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var meta_data = cljs.core.get.call(null,cljs.core.deref.call(null,figwheel.client.file_reloading.figwheel_meta_pragmas),cljs.core.name.call(null,namespace));
if((meta_data == null)){
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);
} else {
if(cljs.core.truth_(meta_data.call(null,new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179)))){
return new cljs.core.Keyword(null,"figwheel-no-load","figwheel-no-load",-555840179);
} else {
return new cljs.core.Keyword(null,"not-required","not-required",-950359114);

}
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31352,inst_31354,inst_31348,inst_31388,inst_31356,inst_31351,inst_31384,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31388__$1 = cljs.core.group_by.call(null,inst_31387,inst_31354);
var inst_31390 = (inst_31388__$1 == null);
var inst_31391 = cljs.core.not.call(null,inst_31390);
var state_31434__$1 = (function (){var statearr_31472 = state_31434;
(statearr_31472[(28)] = inst_31384);

(statearr_31472[(16)] = inst_31388__$1);

return statearr_31472;
})();
if(inst_31391){
var statearr_31473_31549 = state_31434__$1;
(statearr_31473_31549[(1)] = (32));

} else {
var statearr_31474_31550 = state_31434__$1;
(statearr_31474_31550[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (44))){
var inst_31410 = (state_31434[(21)]);
var inst_31423 = cljs.core.map.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),inst_31410);
var inst_31424 = cljs.core.pr_str.call(null,inst_31423);
var inst_31425 = [cljs.core.str("not required: "),cljs.core.str(inst_31424)].join('');
var inst_31426 = figwheel.client.utils.log.call(null,inst_31425);
var state_31434__$1 = state_31434;
var statearr_31475_31551 = state_31434__$1;
(statearr_31475_31551[(2)] = inst_31426);

(statearr_31475_31551[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (6))){
var inst_31329 = (state_31434[(2)]);
var state_31434__$1 = state_31434;
var statearr_31476_31552 = state_31434__$1;
(statearr_31476_31552[(2)] = inst_31329);

(statearr_31476_31552[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (28))){
var inst_31354 = (state_31434[(26)]);
var inst_31381 = (state_31434[(2)]);
var inst_31382 = cljs.core.not_empty.call(null,inst_31354);
var state_31434__$1 = (function (){var statearr_31477 = state_31434;
(statearr_31477[(29)] = inst_31381);

return statearr_31477;
})();
if(cljs.core.truth_(inst_31382)){
var statearr_31478_31553 = state_31434__$1;
(statearr_31478_31553[(1)] = (29));

} else {
var statearr_31479_31554 = state_31434__$1;
(statearr_31479_31554[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (25))){
var inst_31352 = (state_31434[(23)]);
var inst_31368 = (state_31434[(2)]);
var inst_31369 = cljs.core.not_empty.call(null,inst_31352);
var state_31434__$1 = (function (){var statearr_31480 = state_31434;
(statearr_31480[(30)] = inst_31368);

return statearr_31480;
})();
if(cljs.core.truth_(inst_31369)){
var statearr_31481_31555 = state_31434__$1;
(statearr_31481_31555[(1)] = (26));

} else {
var statearr_31482_31556 = state_31434__$1;
(statearr_31482_31556[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (34))){
var inst_31403 = (state_31434[(2)]);
var state_31434__$1 = state_31434;
if(cljs.core.truth_(inst_31403)){
var statearr_31483_31557 = state_31434__$1;
(statearr_31483_31557[(1)] = (38));

} else {
var statearr_31484_31558 = state_31434__$1;
(statearr_31484_31558[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (17))){
var state_31434__$1 = state_31434;
var statearr_31485_31559 = state_31434__$1;
(statearr_31485_31559[(2)] = recompile_dependents);

(statearr_31485_31559[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (3))){
var state_31434__$1 = state_31434;
var statearr_31486_31560 = state_31434__$1;
(statearr_31486_31560[(2)] = null);

(statearr_31486_31560[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (12))){
var inst_31325 = (state_31434[(2)]);
var state_31434__$1 = state_31434;
var statearr_31487_31561 = state_31434__$1;
(statearr_31487_31561[(2)] = inst_31325);

(statearr_31487_31561[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (2))){
var inst_31287 = (state_31434[(13)]);
var inst_31294 = cljs.core.seq.call(null,inst_31287);
var inst_31295 = inst_31294;
var inst_31296 = null;
var inst_31297 = (0);
var inst_31298 = (0);
var state_31434__$1 = (function (){var statearr_31488 = state_31434;
(statearr_31488[(7)] = inst_31296);

(statearr_31488[(8)] = inst_31295);

(statearr_31488[(9)] = inst_31297);

(statearr_31488[(10)] = inst_31298);

return statearr_31488;
})();
var statearr_31489_31562 = state_31434__$1;
(statearr_31489_31562[(2)] = null);

(statearr_31489_31562[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (23))){
var inst_31352 = (state_31434[(23)]);
var inst_31354 = (state_31434[(26)]);
var inst_31348 = (state_31434[(19)]);
var inst_31356 = (state_31434[(24)]);
var inst_31351 = (state_31434[(25)]);
var inst_31359 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these dependencies");
var inst_31361 = (function (){var all_files = inst_31348;
var res_SINGLEQUOTE_ = inst_31351;
var res = inst_31352;
var files_not_loaded = inst_31354;
var dependencies_that_loaded = inst_31356;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31352,inst_31354,inst_31348,inst_31356,inst_31351,inst_31359,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31360){
var map__31490 = p__31360;
var map__31490__$1 = ((((!((map__31490 == null)))?((((map__31490.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31490.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31490):map__31490);
var request_url = cljs.core.get.call(null,map__31490__$1,new cljs.core.Keyword(null,"request-url","request-url",2100346596));
return clojure.string.replace.call(null,request_url,goog.basePath,"");
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31352,inst_31354,inst_31348,inst_31356,inst_31351,inst_31359,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31362 = cljs.core.reverse.call(null,inst_31356);
var inst_31363 = cljs.core.map.call(null,inst_31361,inst_31362);
var inst_31364 = cljs.core.pr_str.call(null,inst_31363);
var inst_31365 = figwheel.client.utils.log.call(null,inst_31364);
var state_31434__$1 = (function (){var statearr_31492 = state_31434;
(statearr_31492[(31)] = inst_31359);

return statearr_31492;
})();
var statearr_31493_31563 = state_31434__$1;
(statearr_31493_31563[(2)] = inst_31365);

(statearr_31493_31563[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (35))){
var state_31434__$1 = state_31434;
var statearr_31494_31564 = state_31434__$1;
(statearr_31494_31564[(2)] = true);

(statearr_31494_31564[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (19))){
var inst_31338 = (state_31434[(12)]);
var inst_31344 = figwheel.client.file_reloading.expand_files.call(null,inst_31338);
var state_31434__$1 = state_31434;
var statearr_31495_31565 = state_31434__$1;
(statearr_31495_31565[(2)] = inst_31344);

(statearr_31495_31565[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (11))){
var state_31434__$1 = state_31434;
var statearr_31496_31566 = state_31434__$1;
(statearr_31496_31566[(2)] = null);

(statearr_31496_31566[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (9))){
var inst_31327 = (state_31434[(2)]);
var state_31434__$1 = state_31434;
var statearr_31497_31567 = state_31434__$1;
(statearr_31497_31567[(2)] = inst_31327);

(statearr_31497_31567[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (5))){
var inst_31297 = (state_31434[(9)]);
var inst_31298 = (state_31434[(10)]);
var inst_31300 = (inst_31298 < inst_31297);
var inst_31301 = inst_31300;
var state_31434__$1 = state_31434;
if(cljs.core.truth_(inst_31301)){
var statearr_31498_31568 = state_31434__$1;
(statearr_31498_31568[(1)] = (7));

} else {
var statearr_31499_31569 = state_31434__$1;
(statearr_31499_31569[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (14))){
var inst_31308 = (state_31434[(22)]);
var inst_31317 = cljs.core.first.call(null,inst_31308);
var inst_31318 = figwheel.client.file_reloading.eval_body.call(null,inst_31317,opts);
var inst_31319 = cljs.core.next.call(null,inst_31308);
var inst_31295 = inst_31319;
var inst_31296 = null;
var inst_31297 = (0);
var inst_31298 = (0);
var state_31434__$1 = (function (){var statearr_31500 = state_31434;
(statearr_31500[(32)] = inst_31318);

(statearr_31500[(7)] = inst_31296);

(statearr_31500[(8)] = inst_31295);

(statearr_31500[(9)] = inst_31297);

(statearr_31500[(10)] = inst_31298);

return statearr_31500;
})();
var statearr_31501_31570 = state_31434__$1;
(statearr_31501_31570[(2)] = null);

(statearr_31501_31570[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (45))){
var state_31434__$1 = state_31434;
var statearr_31502_31571 = state_31434__$1;
(statearr_31502_31571[(2)] = null);

(statearr_31502_31571[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (26))){
var inst_31352 = (state_31434[(23)]);
var inst_31354 = (state_31434[(26)]);
var inst_31348 = (state_31434[(19)]);
var inst_31356 = (state_31434[(24)]);
var inst_31351 = (state_31434[(25)]);
var inst_31371 = figwheel.client.utils.log.call(null,new cljs.core.Keyword(null,"debug","debug",-1608172596),"Figwheel: loaded these files");
var inst_31373 = (function (){var all_files = inst_31348;
var res_SINGLEQUOTE_ = inst_31351;
var res = inst_31352;
var files_not_loaded = inst_31354;
var dependencies_that_loaded = inst_31356;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31352,inst_31354,inst_31348,inst_31356,inst_31351,inst_31371,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (p__31372){
var map__31503 = p__31372;
var map__31503__$1 = ((((!((map__31503 == null)))?((((map__31503.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31503.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31503):map__31503);
var namespace = cljs.core.get.call(null,map__31503__$1,new cljs.core.Keyword(null,"namespace","namespace",-377510372));
var file = cljs.core.get.call(null,map__31503__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
if(cljs.core.truth_(namespace)){
return figwheel.client.file_reloading.name__GT_path.call(null,cljs.core.name.call(null,namespace));
} else {
return file;
}
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31352,inst_31354,inst_31348,inst_31356,inst_31351,inst_31371,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31374 = cljs.core.map.call(null,inst_31373,inst_31352);
var inst_31375 = cljs.core.pr_str.call(null,inst_31374);
var inst_31376 = figwheel.client.utils.log.call(null,inst_31375);
var inst_31377 = (function (){var all_files = inst_31348;
var res_SINGLEQUOTE_ = inst_31351;
var res = inst_31352;
var files_not_loaded = inst_31354;
var dependencies_that_loaded = inst_31356;
return ((function (all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31352,inst_31354,inst_31348,inst_31356,inst_31351,inst_31371,inst_31373,inst_31374,inst_31375,inst_31376,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents){
return (function (){
figwheel.client.file_reloading.on_jsload_custom_event.call(null,res);

return cljs.core.apply.call(null,on_jsload,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res], null));
});
;})(all_files,res_SINGLEQUOTE_,res,files_not_loaded,dependencies_that_loaded,inst_31352,inst_31354,inst_31348,inst_31356,inst_31351,inst_31371,inst_31373,inst_31374,inst_31375,inst_31376,state_val_31435,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var inst_31378 = setTimeout(inst_31377,(10));
var state_31434__$1 = (function (){var statearr_31505 = state_31434;
(statearr_31505[(33)] = inst_31371);

(statearr_31505[(34)] = inst_31376);

return statearr_31505;
})();
var statearr_31506_31572 = state_31434__$1;
(statearr_31506_31572[(2)] = inst_31378);

(statearr_31506_31572[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (16))){
var state_31434__$1 = state_31434;
var statearr_31507_31573 = state_31434__$1;
(statearr_31507_31573[(2)] = reload_dependents);

(statearr_31507_31573[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (38))){
var inst_31388 = (state_31434[(16)]);
var inst_31405 = cljs.core.apply.call(null,cljs.core.hash_map,inst_31388);
var state_31434__$1 = state_31434;
var statearr_31508_31574 = state_31434__$1;
(statearr_31508_31574[(2)] = inst_31405);

(statearr_31508_31574[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (30))){
var state_31434__$1 = state_31434;
var statearr_31509_31575 = state_31434__$1;
(statearr_31509_31575[(2)] = null);

(statearr_31509_31575[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (10))){
var inst_31308 = (state_31434[(22)]);
var inst_31310 = cljs.core.chunked_seq_QMARK_.call(null,inst_31308);
var state_31434__$1 = state_31434;
if(inst_31310){
var statearr_31510_31576 = state_31434__$1;
(statearr_31510_31576[(1)] = (13));

} else {
var statearr_31511_31577 = state_31434__$1;
(statearr_31511_31577[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (18))){
var inst_31342 = (state_31434[(2)]);
var state_31434__$1 = state_31434;
if(cljs.core.truth_(inst_31342)){
var statearr_31512_31578 = state_31434__$1;
(statearr_31512_31578[(1)] = (19));

} else {
var statearr_31513_31579 = state_31434__$1;
(statearr_31513_31579[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (42))){
var state_31434__$1 = state_31434;
var statearr_31514_31580 = state_31434__$1;
(statearr_31514_31580[(2)] = null);

(statearr_31514_31580[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (37))){
var inst_31400 = (state_31434[(2)]);
var state_31434__$1 = state_31434;
var statearr_31515_31581 = state_31434__$1;
(statearr_31515_31581[(2)] = inst_31400);

(statearr_31515_31581[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_31435 === (8))){
var inst_31308 = (state_31434[(22)]);
var inst_31295 = (state_31434[(8)]);
var inst_31308__$1 = cljs.core.seq.call(null,inst_31295);
var state_31434__$1 = (function (){var statearr_31516 = state_31434;
(statearr_31516[(22)] = inst_31308__$1);

return statearr_31516;
})();
if(inst_31308__$1){
var statearr_31517_31582 = state_31434__$1;
(statearr_31517_31582[(1)] = (10));

} else {
var statearr_31518_31583 = state_31434__$1;
(statearr_31518_31583[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents))
;
return ((function (switch__16357__auto__,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents){
return (function() {
var figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto__ = null;
var figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto____0 = (function (){
var statearr_31522 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31522[(0)] = figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto__);

(statearr_31522[(1)] = (1));

return statearr_31522;
});
var figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto____1 = (function (state_31434){
while(true){
var ret_value__16359__auto__ = (function (){try{while(true){
var result__16360__auto__ = switch__16357__auto__.call(null,state_31434);
if(cljs.core.keyword_identical_QMARK_.call(null,result__16360__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__16360__auto__;
}
break;
}
}catch (e31523){if((e31523 instanceof Object)){
var ex__16361__auto__ = e31523;
var statearr_31524_31584 = state_31434;
(statearr_31524_31584[(5)] = ex__16361__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_31434);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e31523;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__16359__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__31585 = state_31434;
state_31434 = G__31585;
continue;
} else {
return ret_value__16359__auto__;
}
break;
}
});
figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto__ = function(state_31434){
switch(arguments.length){
case 0:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto____0.call(this);
case 1:
return figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto____1.call(this,state_31434);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$0 = figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto____0;
figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto__.cljs$core$IFn$_invoke$arity$1 = figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto____1;
return figwheel$client$file_reloading$reload_js_files_$_state_machine__16358__auto__;
})()
;})(switch__16357__auto__,c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents))
})();
var state__16471__auto__ = (function (){var statearr_31525 = f__16470__auto__.call(null);
(statearr_31525[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__16469__auto__);

return statearr_31525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__16471__auto__);
});})(c__16469__auto__,map__31280,map__31280__$1,opts,before_jsload,on_jsload,reload_dependents,map__31281,map__31281__$1,msg,files,figwheel_meta,recompile_dependents))
);

return c__16469__auto__;
});
figwheel.client.file_reloading.current_links = (function figwheel$client$file_reloading$current_links(){
return Array.prototype.slice.call(document.getElementsByTagName("link"));
});
figwheel.client.file_reloading.truncate_url = (function figwheel$client$file_reloading$truncate_url(url){
return clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,clojure.string.replace_first.call(null,cljs.core.first.call(null,clojure.string.split.call(null,url,/\?/)),[cljs.core.str(location.protocol),cljs.core.str("//")].join(''),""),".*://",""),/^\/\//,""),/[^\\/]*/,"");
});
figwheel.client.file_reloading.matches_file_QMARK_ = (function figwheel$client$file_reloading$matches_file_QMARK_(p__31588,link){
var map__31591 = p__31588;
var map__31591__$1 = ((((!((map__31591 == null)))?((((map__31591.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31591.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31591):map__31591);
var file = cljs.core.get.call(null,map__31591__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = link.href;
if(cljs.core.truth_(temp__4657__auto__)){
var link_href = temp__4657__auto__;
var match = clojure.string.join.call(null,"/",cljs.core.take_while.call(null,cljs.core.identity,cljs.core.map.call(null,((function (link_href,temp__4657__auto__,map__31591,map__31591__$1,file){
return (function (p1__31586_SHARP_,p2__31587_SHARP_){
if(cljs.core._EQ_.call(null,p1__31586_SHARP_,p2__31587_SHARP_)){
return p1__31586_SHARP_;
} else {
return false;
}
});})(link_href,temp__4657__auto__,map__31591,map__31591__$1,file))
,cljs.core.reverse.call(null,clojure.string.split.call(null,file,"/")),cljs.core.reverse.call(null,clojure.string.split.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href),"/")))));
var match_length = cljs.core.count.call(null,match);
var file_name_length = cljs.core.count.call(null,cljs.core.last.call(null,clojure.string.split.call(null,file,"/")));
if((match_length >= file_name_length)){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"link","link",-1769163468),link,new cljs.core.Keyword(null,"link-href","link-href",-250644450),link_href,new cljs.core.Keyword(null,"match-length","match-length",1101537310),match_length,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083),cljs.core.count.call(null,figwheel.client.file_reloading.truncate_url.call(null,link_href))], null);
} else {
return null;
}
} else {
return null;
}
});
figwheel.client.file_reloading.get_correct_link = (function figwheel$client$file_reloading$get_correct_link(f_data){
var temp__4657__auto__ = cljs.core.first.call(null,cljs.core.sort_by.call(null,(function (p__31597){
var map__31598 = p__31597;
var map__31598__$1 = ((((!((map__31598 == null)))?((((map__31598.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31598.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31598):map__31598);
var match_length = cljs.core.get.call(null,map__31598__$1,new cljs.core.Keyword(null,"match-length","match-length",1101537310));
var current_url_length = cljs.core.get.call(null,map__31598__$1,new cljs.core.Keyword(null,"current-url-length","current-url-length",380404083));
return (current_url_length - match_length);
}),cljs.core.keep.call(null,(function (p1__31593_SHARP_){
return figwheel.client.file_reloading.matches_file_QMARK_.call(null,f_data,p1__31593_SHARP_);
}),figwheel.client.file_reloading.current_links.call(null))));
if(cljs.core.truth_(temp__4657__auto__)){
var res = temp__4657__auto__;
return new cljs.core.Keyword(null,"link","link",-1769163468).cljs$core$IFn$_invoke$arity$1(res);
} else {
return null;
}
});
figwheel.client.file_reloading.clone_link = (function figwheel$client$file_reloading$clone_link(link,url){
var clone = document.createElement("link");
clone.rel = "stylesheet";

clone.media = link.media;

clone.disabled = link.disabled;

clone.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return clone;
});
figwheel.client.file_reloading.create_link = (function figwheel$client$file_reloading$create_link(url){
var link = document.createElement("link");
link.rel = "stylesheet";

link.href = figwheel.client.file_reloading.add_cache_buster.call(null,url);

return link;
});
figwheel.client.file_reloading.add_link_to_doc = (function figwheel$client$file_reloading$add_link_to_doc(var_args){
var args31600 = [];
var len__13324__auto___31603 = arguments.length;
var i__13325__auto___31604 = (0);
while(true){
if((i__13325__auto___31604 < len__13324__auto___31603)){
args31600.push((arguments[i__13325__auto___31604]));

var G__31605 = (i__13325__auto___31604 + (1));
i__13325__auto___31604 = G__31605;
continue;
} else {
}
break;
}

var G__31602 = args31600.length;
switch (G__31602) {
case 1:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31600.length)].join('')));

}
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$1 = (function (new_link){
return (document.getElementsByTagName("head")[(0)]).appendChild(new_link);
});

figwheel.client.file_reloading.add_link_to_doc.cljs$core$IFn$_invoke$arity$2 = (function (orig_link,klone){
var parent = orig_link.parentNode;
if(cljs.core._EQ_.call(null,orig_link,parent.lastChild)){
parent.appendChild(klone);
} else {
parent.insertBefore(klone,orig_link.nextSibling);
}

return setTimeout(((function (parent){
return (function (){
return parent.removeChild(orig_link);
});})(parent))
,(300));
});

figwheel.client.file_reloading.add_link_to_doc.cljs$lang$maxFixedArity = 2;

figwheel.client.file_reloading.distictify = (function figwheel$client$file_reloading$distictify(key,seqq){
return cljs.core.vals.call(null,cljs.core.reduce.call(null,(function (p1__31607_SHARP_,p2__31608_SHARP_){
return cljs.core.assoc.call(null,p1__31607_SHARP_,cljs.core.get.call(null,p2__31608_SHARP_,key),p2__31608_SHARP_);
}),cljs.core.PersistentArrayMap.EMPTY,seqq));
});
figwheel.client.file_reloading.reload_css_file = (function figwheel$client$file_reloading$reload_css_file(p__31609){
var map__31612 = p__31609;
var map__31612__$1 = ((((!((map__31612 == null)))?((((map__31612.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31612.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31612):map__31612);
var f_data = map__31612__$1;
var file = cljs.core.get.call(null,map__31612__$1,new cljs.core.Keyword(null,"file","file",-1269645878));
var temp__4657__auto__ = figwheel.client.file_reloading.get_correct_link.call(null,f_data);
if(cljs.core.truth_(temp__4657__auto__)){
var link = temp__4657__auto__;
return figwheel.client.file_reloading.add_link_to_doc.call(null,link,figwheel.client.file_reloading.clone_link.call(null,link,link.href));
} else {
return null;
}
});
figwheel.client.file_reloading.reload_css_files = (function figwheel$client$file_reloading$reload_css_files(p__31614,files_msg){
var map__31621 = p__31614;
var map__31621__$1 = ((((!((map__31621 == null)))?((((map__31621.cljs$lang$protocol_mask$partition0$ & (64))) || (map__31621.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__31621):map__31621);
var opts = map__31621__$1;
var on_cssload = cljs.core.get.call(null,map__31621__$1,new cljs.core.Keyword(null,"on-cssload","on-cssload",1825432318));
if(cljs.core.truth_(figwheel.client.utils.html_env_QMARK_.call(null))){
var seq__31623_31627 = cljs.core.seq.call(null,figwheel.client.file_reloading.distictify.call(null,new cljs.core.Keyword(null,"file","file",-1269645878),new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg)));
var chunk__31624_31628 = null;
var count__31625_31629 = (0);
var i__31626_31630 = (0);
while(true){
if((i__31626_31630 < count__31625_31629)){
var f_31631 = cljs.core._nth.call(null,chunk__31624_31628,i__31626_31630);
figwheel.client.file_reloading.reload_css_file.call(null,f_31631);

var G__31632 = seq__31623_31627;
var G__31633 = chunk__31624_31628;
var G__31634 = count__31625_31629;
var G__31635 = (i__31626_31630 + (1));
seq__31623_31627 = G__31632;
chunk__31624_31628 = G__31633;
count__31625_31629 = G__31634;
i__31626_31630 = G__31635;
continue;
} else {
var temp__4657__auto___31636 = cljs.core.seq.call(null,seq__31623_31627);
if(temp__4657__auto___31636){
var seq__31623_31637__$1 = temp__4657__auto___31636;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__31623_31637__$1)){
var c__13060__auto___31638 = cljs.core.chunk_first.call(null,seq__31623_31637__$1);
var G__31639 = cljs.core.chunk_rest.call(null,seq__31623_31637__$1);
var G__31640 = c__13060__auto___31638;
var G__31641 = cljs.core.count.call(null,c__13060__auto___31638);
var G__31642 = (0);
seq__31623_31627 = G__31639;
chunk__31624_31628 = G__31640;
count__31625_31629 = G__31641;
i__31626_31630 = G__31642;
continue;
} else {
var f_31643 = cljs.core.first.call(null,seq__31623_31637__$1);
figwheel.client.file_reloading.reload_css_file.call(null,f_31643);

var G__31644 = cljs.core.next.call(null,seq__31623_31637__$1);
var G__31645 = null;
var G__31646 = (0);
var G__31647 = (0);
seq__31623_31627 = G__31644;
chunk__31624_31628 = G__31645;
count__31625_31629 = G__31646;
i__31626_31630 = G__31647;
continue;
}
} else {
}
}
break;
}

return setTimeout(((function (map__31621,map__31621__$1,opts,on_cssload){
return (function (){
return on_cssload.call(null,new cljs.core.Keyword(null,"files","files",-472457450).cljs$core$IFn$_invoke$arity$1(files_msg));
});})(map__31621,map__31621__$1,opts,on_cssload))
,(100));
} else {
return null;
}
});

//# sourceMappingURL=file_reloading.js.map?rel=1473935471813