// Compiled by ClojureScript 1.9.89 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('cljs.core.async');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__12237__auto__ = v;
if(cljs.core.truth_(and__12237__auto__)){
return (v > (0));
} else {
return and__12237__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__19391_SHARP_,p2__19390_SHARP_){
var vec__19395 = clojure.string.split.call(null,p2__19390_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__19395,(0),null);
var v = cljs.core.nth.call(null,vec__19395,(1),null);
return cljs.core.assoc.call(null,p1__19391_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode.call(null,[cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__19398_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__19398_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__19399){
var vec__19403 = p__19399;
var k = cljs.core.nth.call(null,vec__19403,(0),null);
var v = cljs.core.nth.call(null,vec__19403,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__19406_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__19406_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__12237__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__12237__auto__){
var and__12237__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__12237__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__12237__auto____$1;
}
} else {
return and__12237__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__19407_SHARP_){
return cljs_http.client.decode_body.call(null,p1__19407_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19414 = arguments.length;
var i__13325__auto___19415 = (0);
while(true){
if((i__13325__auto___19415 < len__13324__auto___19414)){
args__13331__auto__.push((arguments[i__13325__auto___19415]));

var G__19416 = (i__13325__auto___19415 + (1));
i__13325__auto___19415 = G__19416;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__19410){
var vec__19411 = p__19410;
var default_headers = cljs.core.nth.call(null,vec__19411,(0),null);
return ((function (vec__19411,default_headers){
return (function (request){
var temp__4655__auto__ = (function (){var or__12249__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var default_headers__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__19411,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq19408){
var G__19409 = cljs.core.first.call(null,seq19408);
var seq19408__$1 = cljs.core.next.call(null,seq19408);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__19409,seq19408__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19423 = arguments.length;
var i__13325__auto___19424 = (0);
while(true){
if((i__13325__auto___19424 < len__13324__auto___19423)){
args__13331__auto__.push((arguments[i__13325__auto___19424]));

var G__19425 = (i__13325__auto___19424 + (1));
i__13325__auto___19424 = G__19425;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__19419){
var vec__19420 = p__19419;
var accept = cljs.core.nth.call(null,vec__19420,(0),null);
return ((function (vec__19420,accept){
return (function (request){
var temp__4655__auto__ = (function (){var or__12249__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var accept__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__19420,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq19417){
var G__19418 = cljs.core.first.call(null,seq19417);
var seq19417__$1 = cljs.core.next.call(null,seq19417);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__19418,seq19417__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19432 = arguments.length;
var i__13325__auto___19433 = (0);
while(true){
if((i__13325__auto___19433 < len__13324__auto___19432)){
args__13331__auto__.push((arguments[i__13325__auto___19433]));

var G__19434 = (i__13325__auto___19433 + (1));
i__13325__auto___19433 = G__19434;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__19428){
var vec__19429 = p__19428;
var content_type = cljs.core.nth.call(null,vec__19429,(0),null);
return ((function (vec__19429,content_type){
return (function (request){
var temp__4655__auto__ = (function (){var or__12249__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var content_type__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__19429,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq19426){
var G__19427 = cljs.core.first.call(null,seq19426);
var seq19426__$1 = cljs.core.next.call(null,seq19426);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__19427,seq19426__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var map__19437 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__19437__$1 = ((((!((map__19437 == null)))?((((map__19437.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19437.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19437):map__19437);
var encoding = cljs.core.get.call(null,map__19437__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__19437__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__19443 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__19443__$1 = ((((!((map__19443 == null)))?((((map__19443.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19443.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19443):map__19443);
var decoding = cljs.core.get.call(null,map__19443__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__19443__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__19443,map__19443__$1,decoding,decoding_opts){
return (function (p1__19439_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__19439_SHARP_,decoding,decoding_opts);
});})(map__19443,map__19443__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__19443,map__19443__$1,decoding,decoding_opts,transit_decode){
return (function (p1__19440_SHARP_){
return cljs_http.client.decode_body.call(null,p1__19440_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__19443,map__19443__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__19445_SHARP_){
return cljs_http.client.decode_body.call(null,p1__19445_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__19449){
var map__19450 = p__19449;
var map__19450__$1 = ((((!((map__19450 == null)))?((((map__19450.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19450.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19450):map__19450);
var req = map__19450__$1;
var query_params = cljs.core.get.call(null,map__19450__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__19455){
var map__19456 = p__19455;
var map__19456__$1 = ((((!((map__19456 == null)))?((((map__19456.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19456.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19456):map__19456);
var request = map__19456__$1;
var form_params = cljs.core.get.call(null,map__19456__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__19456__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__19456__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__12237__auto__ = form_params;
if(cljs.core.truth_(and__12237__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__12237__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__19468_19478 = cljs.core.seq.call(null,params);
var chunk__19469_19479 = null;
var count__19470_19480 = (0);
var i__19471_19481 = (0);
while(true){
if((i__19471_19481 < count__19470_19480)){
var vec__19472_19482 = cljs.core._nth.call(null,chunk__19469_19479,i__19471_19481);
var k_19483 = cljs.core.nth.call(null,vec__19472_19482,(0),null);
var v_19484 = cljs.core.nth.call(null,vec__19472_19482,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_19484)){
form_data.append(cljs.core.name.call(null,k_19483),cljs.core.first.call(null,v_19484),cljs.core.second.call(null,v_19484));
} else {
form_data.append(cljs.core.name.call(null,k_19483),v_19484);
}

var G__19485 = seq__19468_19478;
var G__19486 = chunk__19469_19479;
var G__19487 = count__19470_19480;
var G__19488 = (i__19471_19481 + (1));
seq__19468_19478 = G__19485;
chunk__19469_19479 = G__19486;
count__19470_19480 = G__19487;
i__19471_19481 = G__19488;
continue;
} else {
var temp__4657__auto___19489 = cljs.core.seq.call(null,seq__19468_19478);
if(temp__4657__auto___19489){
var seq__19468_19490__$1 = temp__4657__auto___19489;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__19468_19490__$1)){
var c__13060__auto___19491 = cljs.core.chunk_first.call(null,seq__19468_19490__$1);
var G__19492 = cljs.core.chunk_rest.call(null,seq__19468_19490__$1);
var G__19493 = c__13060__auto___19491;
var G__19494 = cljs.core.count.call(null,c__13060__auto___19491);
var G__19495 = (0);
seq__19468_19478 = G__19492;
chunk__19469_19479 = G__19493;
count__19470_19480 = G__19494;
i__19471_19481 = G__19495;
continue;
} else {
var vec__19475_19496 = cljs.core.first.call(null,seq__19468_19490__$1);
var k_19497 = cljs.core.nth.call(null,vec__19475_19496,(0),null);
var v_19498 = cljs.core.nth.call(null,vec__19475_19496,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_19498)){
form_data.append(cljs.core.name.call(null,k_19497),cljs.core.first.call(null,v_19498),cljs.core.second.call(null,v_19498));
} else {
form_data.append(cljs.core.name.call(null,k_19497),v_19498);
}

var G__19499 = cljs.core.next.call(null,seq__19468_19490__$1);
var G__19500 = null;
var G__19501 = (0);
var G__19502 = (0);
seq__19468_19478 = G__19499;
chunk__19469_19479 = G__19500;
count__19470_19480 = G__19501;
i__19471_19481 = G__19502;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__19506){
var map__19507 = p__19506;
var map__19507__$1 = ((((!((map__19507 == null)))?((((map__19507.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19507.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19507):map__19507);
var request = map__19507__$1;
var multipart_params = cljs.core.get.call(null,map__19507__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__19507__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__12237__auto__ = multipart_params;
if(cljs.core.truth_(and__12237__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__12237__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var m = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__19509_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__19509_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__19514){
var map__19515 = p__19514;
var map__19515__$1 = ((((!((map__19515 == null)))?((((map__19515.cljs$lang$protocol_mask$partition0$ & (64))) || (map__19515.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__19515):map__19515);
var req = map__19515__$1;
var query_params = cljs.core.get.call(null,map__19515__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__4655__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4655__auto__)){
var spec = temp__4655__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__4655__auto__,map__19515,map__19515__$1,req,query_params){
return (function (p1__19510_SHARP_){
return cljs.core.merge.call(null,p1__19510_SHARP_,query_params);
});})(spec,temp__4655__auto__,map__19515,map__19515__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19523 = arguments.length;
var i__13325__auto___19524 = (0);
while(true){
if((i__13325__auto___19524 < len__13324__auto___19523)){
args__13331__auto__.push((arguments[i__13325__auto___19524]));

var G__19525 = (i__13325__auto___19524 + (1));
i__13325__auto___19524 = G__19525;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__19519){
var vec__19520 = p__19519;
var credentials = cljs.core.nth.call(null,vec__19520,(0),null);
return ((function (vec__19520,credentials){
return (function (req){
var credentials__$1 = (function (){var or__12249__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__12249__auto__)){
return or__12249__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__19520,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq19517){
var G__19518 = cljs.core.first.call(null,seq19517);
var seq19517__$1 = cljs.core.next.call(null,seq19517);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__19518,seq19517__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var oauth_token = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var custom_channel = temp__4655__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19532 = arguments.length;
var i__13325__auto___19533 = (0);
while(true){
if((i__13325__auto___19533 < len__13324__auto___19532)){
args__13331__auto__.push((arguments[i__13325__auto___19533]));

var G__19534 = (i__13325__auto___19533 + (1));
i__13325__auto___19533 = G__19534;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19528){
var vec__19529 = p__19528;
var req = cljs.core.nth.call(null,vec__19529,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq19526){
var G__19527 = cljs.core.first.call(null,seq19526);
var seq19526__$1 = cljs.core.next.call(null,seq19526);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__19527,seq19526__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19541 = arguments.length;
var i__13325__auto___19542 = (0);
while(true){
if((i__13325__auto___19542 < len__13324__auto___19541)){
args__13331__auto__.push((arguments[i__13325__auto___19542]));

var G__19543 = (i__13325__auto___19542 + (1));
i__13325__auto___19542 = G__19543;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19537){
var vec__19538 = p__19537;
var req = cljs.core.nth.call(null,vec__19538,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq19535){
var G__19536 = cljs.core.first.call(null,seq19535);
var seq19535__$1 = cljs.core.next.call(null,seq19535);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__19536,seq19535__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19550 = arguments.length;
var i__13325__auto___19551 = (0);
while(true){
if((i__13325__auto___19551 < len__13324__auto___19550)){
args__13331__auto__.push((arguments[i__13325__auto___19551]));

var G__19552 = (i__13325__auto___19551 + (1));
i__13325__auto___19551 = G__19552;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19546){
var vec__19547 = p__19546;
var req = cljs.core.nth.call(null,vec__19547,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq19544){
var G__19545 = cljs.core.first.call(null,seq19544);
var seq19544__$1 = cljs.core.next.call(null,seq19544);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__19545,seq19544__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19559 = arguments.length;
var i__13325__auto___19560 = (0);
while(true){
if((i__13325__auto___19560 < len__13324__auto___19559)){
args__13331__auto__.push((arguments[i__13325__auto___19560]));

var G__19561 = (i__13325__auto___19560 + (1));
i__13325__auto___19560 = G__19561;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19555){
var vec__19556 = p__19555;
var req = cljs.core.nth.call(null,vec__19556,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq19553){
var G__19554 = cljs.core.first.call(null,seq19553);
var seq19553__$1 = cljs.core.next.call(null,seq19553);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__19554,seq19553__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19568 = arguments.length;
var i__13325__auto___19569 = (0);
while(true){
if((i__13325__auto___19569 < len__13324__auto___19568)){
args__13331__auto__.push((arguments[i__13325__auto___19569]));

var G__19570 = (i__13325__auto___19569 + (1));
i__13325__auto___19569 = G__19570;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19564){
var vec__19565 = p__19564;
var req = cljs.core.nth.call(null,vec__19565,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq19562){
var G__19563 = cljs.core.first.call(null,seq19562);
var seq19562__$1 = cljs.core.next.call(null,seq19562);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__19563,seq19562__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19577 = arguments.length;
var i__13325__auto___19578 = (0);
while(true){
if((i__13325__auto___19578 < len__13324__auto___19577)){
args__13331__auto__.push((arguments[i__13325__auto___19578]));

var G__19579 = (i__13325__auto___19578 + (1));
i__13325__auto___19578 = G__19579;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19573){
var vec__19574 = p__19573;
var req = cljs.core.nth.call(null,vec__19574,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq19571){
var G__19572 = cljs.core.first.call(null,seq19571);
var seq19571__$1 = cljs.core.next.call(null,seq19571);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__19572,seq19571__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19586 = arguments.length;
var i__13325__auto___19587 = (0);
while(true){
if((i__13325__auto___19587 < len__13324__auto___19586)){
args__13331__auto__.push((arguments[i__13325__auto___19587]));

var G__19588 = (i__13325__auto___19587 + (1));
i__13325__auto___19587 = G__19588;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19582){
var vec__19583 = p__19582;
var req = cljs.core.nth.call(null,vec__19583,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq19580){
var G__19581 = cljs.core.first.call(null,seq19580);
var seq19580__$1 = cljs.core.next.call(null,seq19580);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__19581,seq19580__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19595 = arguments.length;
var i__13325__auto___19596 = (0);
while(true){
if((i__13325__auto___19596 < len__13324__auto___19595)){
args__13331__auto__.push((arguments[i__13325__auto___19596]));

var G__19597 = (i__13325__auto___19596 + (1));
i__13325__auto___19596 = G__19597;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19591){
var vec__19592 = p__19591;
var req = cljs.core.nth.call(null,vec__19592,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq19589){
var G__19590 = cljs.core.first.call(null,seq19589);
var seq19589__$1 = cljs.core.next.call(null,seq19589);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__19590,seq19589__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__13331__auto__ = [];
var len__13324__auto___19604 = arguments.length;
var i__13325__auto___19605 = (0);
while(true){
if((i__13325__auto___19605 < len__13324__auto___19604)){
args__13331__auto__.push((arguments[i__13325__auto___19605]));

var G__19606 = (i__13325__auto___19605 + (1));
i__13325__auto___19605 = G__19606;
continue;
} else {
}
break;
}

var argseq__13332__auto__ = ((((1) < args__13331__auto__.length))?(new cljs.core.IndexedSeq(args__13331__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__13332__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__19600){
var vec__19601 = p__19600;
var req = cljs.core.nth.call(null,vec__19601,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq19598){
var G__19599 = cljs.core.first.call(null,seq19598);
var seq19598__$1 = cljs.core.next.call(null,seq19598);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__19599,seq19598__$1);
});


//# sourceMappingURL=client.js.map?rel=1473935451096