// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.sections.regions.results');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('redgenes.sections.regions.graphs');
goog.require('redgenes.components.imcontrols.views');
goog.require('redgenes.sections.regions.subs');
goog.require('redgenes.components.table');
goog.require('oops.core');
goog.require('redgenes.components.loader');
goog.require('accountant.core');
goog.require('redgenes.sections.regions.events');
goog.require('redgenes.components.bootstrap');
goog.require('clojure.string');
goog.require('re_frame.core');
redgenes.sections.regions.results.feature_to_uid = (function redgenes$sections$regions$results$feature_to_uid(p__30443){
var map__30447 = p__30443;
var map__30447__$1 = ((((!((map__30447 == null)))?((((map__30447.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30447.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30447):map__30447);
var feature = map__30447__$1;
var chromosome = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30447__$1,cljs.core.cst$kw$chromosome);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30447__$1,cljs.core.cst$kw$from);
var to = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30447__$1,cljs.core.cst$kw$to);
var results = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30447__$1,cljs.core.cst$kw$results);
var regions_searched = (function (){var G__30449 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_regions_DASH_searched], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30449) : re_frame.core.subscribe.call(null,G__30449));
})();
if(cljs.core.truth_(from)){
return [cljs.core.str(chromosome),cljs.core.str(from),cljs.core.str(to)].join('');
} else {
var the_feature = cljs.core.first(cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (regions_searched,map__30447,map__30447__$1,feature,chromosome,from,to,results){
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$chromosome.cljs$core$IFn$_invoke$arity$1(x),feature);
});})(regions_searched,map__30447,map__30447__$1,feature,chromosome,from,to,results))
,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(regions_searched) : cljs.core.deref.call(null,regions_searched))));
return [cljs.core.str(cljs.core.cst$kw$chromosome.cljs$core$IFn$_invoke$arity$1(the_feature)),cljs.core.str(cljs.core.cst$kw$from.cljs$core$IFn$_invoke$arity$1(the_feature)),cljs.core.str(cljs.core.cst$kw$to.cljs$core$IFn$_invoke$arity$1(the_feature))].join('');
}
});
/**
 * Header for each region. includes paginator and number of features.
 */
redgenes.sections.regions.results.region_header = (function redgenes$sections$regions$results$region_header(p__30450,paginator){
var map__30453 = p__30450;
var map__30453__$1 = ((((!((map__30453 == null)))?((((map__30453.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30453.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30453):map__30453);
var feature = map__30453__$1;
var chromosome = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30453__$1,cljs.core.cst$kw$chromosome);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30453__$1,cljs.core.cst$kw$from);
var to = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30453__$1,cljs.core.cst$kw$to);
var results = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30453__$1,cljs.core.cst$kw$results);
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h3,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$id,redgenes.sections.regions.results.feature_to_uid(feature)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,"Region: "], null),(cljs.core.truth_(chromosome)?new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,chromosome," ",from,"..",to," "], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span,feature," "], null)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$small$features_DASH_count,cljs.core.count(results)," overlapping features"], null),(((cljs.core.count(results) > (0)))?paginator:null)], null);
});
/**
 * UI component to switch between pages of results
 */
redgenes.sections.regions.results.table_paginator = (function redgenes$sections$regions$results$table_paginator(pager,results){
var page_count = (Math.ceil((cljs.core.count(results) / cljs.core.cst$kw$show.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pager) : cljs.core.deref.call(null,pager))))) | (0));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$pull_DASH_right$paginator,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$disabled,(cljs.core.cst$kw$page.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pager) : cljs.core.deref.call(null,pager))) < (1)),cljs.core.cst$kw$on_DASH_click,((function (page_count){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pager,cljs.core.update,cljs.core.cst$kw$page,cljs.core.dec);
});})(page_count))
], null),"< Previous"], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$currentpage,"Page ",(cljs.core.cst$kw$page.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pager) : cljs.core.deref.call(null,pager))) + (1))," of ",page_count], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$disabled,(cljs.core.count(results) < (cljs.core.cst$kw$show.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pager) : cljs.core.deref.call(null,pager))) * (cljs.core.cst$kw$page.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pager) : cljs.core.deref.call(null,pager))) + (1)))),cljs.core.cst$kw$on_DASH_click,((function (page_count){
return (function (){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(pager,cljs.core.update,cljs.core.cst$kw$page,cljs.core.inc);
});})(page_count))
], null),"Next >"], null)], null);
});
/**
 * Header for results table.
 */
redgenes.sections.regions.results.table_header = (function redgenes$sections$regions$results$table_header(){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$grid_DASH_3_xs_DASH_3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Feature"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Feature Type"], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,"Location"], null)], null)], null);
});
/**
 * A single result row for a single region feature.
 */
redgenes.sections.regions.results.table_row = (function redgenes$sections$regions$results$table_row(chromosome,p__30455){
var map__30460 = p__30455;
var map__30460__$1 = ((((!((map__30460 == null)))?((((map__30460.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30460.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30460):map__30460);
var result = map__30460__$1;
var primaryIdentifier = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30460__$1,cljs.core.cst$kw$primaryIdentifier);
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30460__$1,cljs.core.cst$kw$class);
var chromosomeLocation = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30460__$1,cljs.core.cst$kw$chromosomeLocation);
var objectId = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30460__$1,cljs.core.cst$kw$objectId);
var model = (function (){var G__30462 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$model], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30462) : re_frame.core.subscribe.call(null,G__30462));
})();
var current_mine = (function (){var G__30463 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$current_DASH_mine], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30463) : re_frame.core.subscribe.call(null,G__30463));
})();
var the_type = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(model) : cljs.core.deref.call(null,model)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(class$),cljs.core.cst$kw$displayName], null));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$grid_DASH_3_xs_DASH_3$single_DASH_feature,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (model,current_mine,the_type,map__30460,map__30460__$1,result,primaryIdentifier,class$,chromosomeLocation,objectId){
return (function (){
return accountant.core.navigate_BANG_.cljs$core$IFn$_invoke$arity$1([cljs.core.str("/reportpage/"),cljs.core.str(cljs.core.name(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(current_mine) : cljs.core.deref.call(null,current_mine))))),cljs.core.str("/"),cljs.core.str(class$),cljs.core.str("/"),cljs.core.str(objectId)].join(''));
});})(model,current_mine,the_type,map__30460,map__30460__$1,result,primaryIdentifier,class$,chromosomeLocation,objectId))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$word_DASH_wrap,"break-word"], null)], null),primaryIdentifier], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col,the_type], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$col,[cljs.core.str(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(chromosomeLocation,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$locatedOn,cljs.core.cst$kw$primaryIdentifier], null))),cljs.core.str(":"),cljs.core.str(cljs.core.cst$kw$start.cljs$core$IFn$_invoke$arity$1(chromosomeLocation)),cljs.core.str(".."),cljs.core.str(cljs.core.cst$kw$end.cljs$core$IFn$_invoke$arity$1(chromosomeLocation))].join('')], null)], null);
});
/**
 * The result table for a region - all features
 */
redgenes.sections.regions.results.result_table = (function redgenes$sections$regions$results$result_table(){
var pager = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$show,(20),cljs.core.cst$kw$page,(0)], null));
return ((function (pager){
return (function (p__30467){
var map__30468 = p__30467;
var map__30468__$1 = ((((!((map__30468 == null)))?((((map__30468.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30468.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30468):map__30468);
var feature = map__30468__$1;
var chromosome = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30468__$1,cljs.core.cst$kw$chromosome);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30468__$1,cljs.core.cst$kw$from);
var to = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30468__$1,cljs.core.cst$kw$to);
var results = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30468__$1,cljs.core.cst$kw$results);
if((cljs.core.count(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(feature)) > (0))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$results,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.results.region_header,feature,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.results.table_paginator,pager,results], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$tabulated,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.results.table_header], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$results_DASH_body], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__30468,map__30468__$1,feature,chromosome,from,to,results,pager){
return (function (result){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.results.table_row,chromosome,result], null);
});})(map__30468,map__30468__$1,feature,chromosome,from,to,results,pager))
,cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$show.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pager) : cljs.core.deref.call(null,pager))),cljs.core.drop.cljs$core$IFn$_invoke$arity$2((cljs.core.cst$kw$show.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pager) : cljs.core.deref.call(null,pager))) * cljs.core.cst$kw$page.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(pager) : cljs.core.deref.call(null,pager)))),cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$start,cljs.core.cst$kw$chromosomeLocation),results)))))], null)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$results$noresults,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.results.region_header,chromosome,from,to], null),"No features returned for this region"], null);
}
});
;})(pager))
});
redgenes.sections.regions.results.error_loading_results = (function redgenes$sections$regions$results$error_loading_results(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$results$error,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg$icon$icon_DASH_wondering,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$use,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$xlinkHref,"#icon-wondering"], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$errordetails,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h3,"Houston, we've had a problem. "], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"Looks like there was a problem fetching results."], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,"Please check that your search regions are in the correct format."], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,"Please check you're connected to the internet."], null)], null)], null)], null);
});
redgenes.sections.regions.results.results_count_summary = (function redgenes$sections$regions$results$results_count_summary(results){
if((cljs.core.count(results) > (0))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (new_div,result){
var num = cljs.core.count(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(result));
var feature = redgenes.sections.regions.results.feature_to_uid(result);
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new_div,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$results_DASH_count,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,(((num === (0)))?"noresults":null),cljs.core.cst$kw$on_DASH_click,((function (num,feature){
return (function (){
document.getElementById(feature).scrollIntoView(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$behavior,"smooth"], null));

return window.scrollBy((0),(-80));
});})(num,feature))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$strong,cljs.core.cst$kw$chromosome.cljs$core$IFn$_invoke$arity$1(result)], null),": ",num," results"], null));
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$results_DASH_counts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$skip_DASH_to,"Skip to:"], null)], null),results);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div], null);
}
});
redgenes.sections.regions.results.results_section = (function redgenes$sections$regions$results$results_section(){
var results = (function (){var G__30473 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_results], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30473) : re_frame.core.subscribe.call(null,G__30473));
})();
var loading_QMARK_ = (function (){var G__30474 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_loading], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30474) : re_frame.core.subscribe.call(null,G__30474));
})();
var error = (function (){var G__30475 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$regions_SLASH_error], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__30475) : re_frame.core.subscribe.call(null,G__30475));
})();
if(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(loading_QMARK_) : cljs.core.deref.call(null,loading_QMARK_)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.loader.loader,"Regions"], null);
} else {
if(cljs.core.not((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(error) : cljs.core.deref.call(null,error)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$results_DASH_summary,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h2,"Results"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.results.results_count_summary,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(results) : cljs.core.deref.call(null,results))], null)], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$allresults], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (results,loading_QMARK_,error){
return (function (result){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.results.result_table,result], null);
});})(results,loading_QMARK_,error))
,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(results) : cljs.core.deref.call(null,results))))], null);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.regions.results.error_loading_results], null);
}
}
});
