// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.components.lighttable');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('imcljs.fetch');
goog.require('imcljsold.search');
goog.require('dommy.core');
goog.require('cljs.core.async');
goog.require('imcljsold.names');
goog.require('re_frame.core');
/**
 * Returns a sequence of true / false indicating that all values in each
 *   column of a table are equal. Assumes all rows are the same length.
 *   [[A B C] [X B Y]]
 * => (false true false)
 */
redgenes.components.lighttable.homogeneous_columns = (function redgenes$components$lighttable$homogeneous_columns(table){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (column){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,column);
}),table));
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.first(table))));
});
/**
 * a basic results table without imtables complexity. optional second arg options allows you to specify whether or not to show a title for the table, as {:title true}. 
 */
redgenes.components.lighttable.table = (function redgenes$components$lighttable$table(){
return (function() {
var G__28716 = null;
var G__28716__1 = (function (results){
var skip_columns = null;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$table$table$small,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$thead,cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (skip_columns){
return (function (header){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$th,cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(header," > "))], null);
});})(skip_columns))
,cljs.core.cst$kw$columnHeaders.cljs$core$IFn$_invoke$arity$1(results)))], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tbody], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (skip_columns){
return (function (row){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$tr], null),cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (skip_columns){
return (function (idx,value){
if(cljs.core.truth_(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(skip_columns,idx))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td$skipped,"..."], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$td,((((50) < cljs.core.count([cljs.core.str(value)].join(''))))?[cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take.cljs$core$IFn$_invoke$arity$2((50),[cljs.core.str(value)].join('')))),cljs.core.str("...")].join(''):[cljs.core.str(value)].join(''))], null);
}
});})(skip_columns))
,row));
});})(skip_columns))
,cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(results)))], null);
});
var G__28716__2 = (function (results,options){
if(cljs.core.truth_(cljs.core.cst$kw$title.cljs$core$IFn$_invoke$arity$1(options))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4,imcljsold.names.find_name(cljs.core.cst$kw$class.cljs$core$IFn$_invoke$arity$1(results))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.lighttable.table,results], null)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.lighttable.table,results], null);
}
});
G__28716 = function(results,options){
switch(arguments.length){
case 1:
return G__28716__1.call(this,results);
case 2:
return G__28716__2.call(this,results,options);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28716.cljs$core$IFn$_invoke$arity$1 = G__28716__1;
G__28716.cljs$core$IFn$_invoke$arity$2 = G__28716__2;
return G__28716;
})()
});
redgenes.components.lighttable.shell = (function redgenes$components$lighttable$shell(){
return (function (state,package$,options){
if(cljs.core.empty_QMARK_(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$small$no_DASH_results,[cljs.core.str(cljs.core.cst$kw$class.cljs$core$IFn$_invoke$arity$1((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state)))),cljs.core.str(" - No Results")].join('')], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$lt,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.lighttable.table,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(state) : cljs.core.deref.call(null,state)),options], null)], null);
}
});
});
redgenes.components.lighttable.handler = (function redgenes$components$lighttable$handler(state,e){
var props = reagent.core.props(e);
var node = (dommy.utils.__GT_Array(reagent.core.dom_node(e).getElementsByClassName("im-target"))[(0)]);
var missing_values = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (props,node){
return (function (p1__28717_SHARP_){
return (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(null,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(p1__28717_SHARP_))) && (cljs.core.some_QMARK_(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__28717_SHARP_)));
});})(props,node))
,cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$query.cljs$core$IFn$_invoke$arity$1(props)));
if(cljs.core.empty_QMARK_(missing_values)){
var c__14702__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14702__auto__,props,node,missing_values){
return (function (){
var f__14703__auto__ = (function (){var switch__14623__auto__ = ((function (c__14702__auto__,props,node,missing_values){
return (function (state_28751){
var state_val_28752 = (state_28751[(1)]);
if((state_val_28752 === (1))){
var inst_28739 = cljs.core.cst$kw$service.cljs$core$IFn$_invoke$arity$1(props);
var inst_28740 = cljs.core.cst$kw$query.cljs$core$IFn$_invoke$arity$1(props);
var inst_28741 = [cljs.core.cst$kw$size,cljs.core.cst$kw$format];
var inst_28742 = [(5),"json"];
var inst_28743 = cljs.core.PersistentHashMap.fromArrays(inst_28741,inst_28742);
var inst_28744 = imcljs.fetch.rows.cljs$core$IFn$_invoke$arity$variadic(inst_28739,inst_28740,cljs.core.array_seq([inst_28743], 0));
var state_28751__$1 = state_28751;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28751__$1,(2),inst_28744);
} else {
if((state_val_28752 === (2))){
var inst_28746 = (state_28751[(2)]);
var inst_28747 = cljs.core.cst$kw$class.cljs$core$IFn$_invoke$arity$1(props);
var inst_28748 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_28746,cljs.core.cst$kw$class,inst_28747);
var inst_28749 = (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(state,inst_28748) : cljs.core.reset_BANG_.call(null,state,inst_28748));
var state_28751__$1 = state_28751;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28751__$1,inst_28749);
} else {
return null;
}
}
});})(c__14702__auto__,props,node,missing_values))
;
return ((function (switch__14623__auto__,c__14702__auto__,props,node,missing_values){
return (function() {
var redgenes$components$lighttable$handler_$_state_machine__14624__auto__ = null;
var redgenes$components$lighttable$handler_$_state_machine__14624__auto____0 = (function (){
var statearr_28756 = [null,null,null,null,null,null,null];
(statearr_28756[(0)] = redgenes$components$lighttable$handler_$_state_machine__14624__auto__);

(statearr_28756[(1)] = (1));

return statearr_28756;
});
var redgenes$components$lighttable$handler_$_state_machine__14624__auto____1 = (function (state_28751){
while(true){
var ret_value__14625__auto__ = (function (){try{while(true){
var result__14626__auto__ = switch__14623__auto__(state_28751);
if(cljs.core.keyword_identical_QMARK_(result__14626__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14626__auto__;
}
break;
}
}catch (e28757){if((e28757 instanceof Object)){
var ex__14627__auto__ = e28757;
var statearr_28758_28760 = state_28751;
(statearr_28758_28760[(5)] = ex__14627__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_28751);

return cljs.core.cst$kw$recur;
} else {
throw e28757;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14625__auto__,cljs.core.cst$kw$recur)){
var G__28761 = state_28751;
state_28751 = G__28761;
continue;
} else {
return ret_value__14625__auto__;
}
break;
}
});
redgenes$components$lighttable$handler_$_state_machine__14624__auto__ = function(state_28751){
switch(arguments.length){
case 0:
return redgenes$components$lighttable$handler_$_state_machine__14624__auto____0.call(this);
case 1:
return redgenes$components$lighttable$handler_$_state_machine__14624__auto____1.call(this,state_28751);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
redgenes$components$lighttable$handler_$_state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$0 = redgenes$components$lighttable$handler_$_state_machine__14624__auto____0;
redgenes$components$lighttable$handler_$_state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$1 = redgenes$components$lighttable$handler_$_state_machine__14624__auto____1;
return redgenes$components$lighttable$handler_$_state_machine__14624__auto__;
})()
;})(switch__14623__auto__,c__14702__auto__,props,node,missing_values))
})();
var state__14704__auto__ = (function (){var statearr_28759 = (f__14703__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14703__auto__.cljs$core$IFn$_invoke$arity$0() : f__14703__auto__.call(null));
(statearr_28759[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14702__auto__);

return statearr_28759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14704__auto__);
});})(c__14702__auto__,props,node,missing_values))
);

return c__14702__auto__;
} else {
return null;
}
});
redgenes.components.lighttable.main = (function redgenes$components$lighttable$main(){
var state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$component_DASH_did_DASH_mount,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(redgenes.components.lighttable.handler,state),cljs.core.cst$kw$component_DASH_did_DASH_update,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(redgenes.components.lighttable.handler,state),cljs.core.cst$kw$reagent_DASH_render,((function (state){
return (function (package$,options){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.lighttable.shell,state,package$,options], null);
});})(state))
], null));
});
