// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('com.rpl.specter');
goog.require('cljs.core');
goog.require('com.rpl.specter.protocols');
goog.require('com.rpl.specter.impl');
goog.require('com.rpl.specter.navs');
goog.require('clojure.set');
/**
 * Returns a compiled version of the given path for use with
 * compiled-{select/transform/setval/etc.} functions. This can compile navigators
 * (defined with `defnav`) without their parameters, and the resulting compiled
 * path will require parameters for all such navigators in the order in which
 * they were declared.
 */
com.rpl.specter.comp_paths = (function com$rpl$specter$comp_paths(var_args){
var args__8442__auto__ = [];
var len__8435__auto___28697 = arguments.length;
var i__8436__auto___28698 = (0);
while(true){
if((i__8436__auto___28698 < len__8435__auto___28697)){
args__8442__auto__.push((arguments[i__8436__auto___28698]));

var G__28699 = (i__8436__auto___28698 + (1));
i__8436__auto___28698 = G__28699;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((0) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((0)),(0),null)):null);
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(argseq__8443__auto__);
});

com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic = (function (apath){
return com.rpl.specter.impl.comp_paths_STAR_(cljs.core.vec(apath));
});

com.rpl.specter.comp_paths.cljs$lang$maxFixedArity = (0);

com.rpl.specter.comp_paths.cljs$lang$applyTo = (function (seq28696){
return com.rpl.specter.comp_paths.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28696));
});

/**
 * Version of select that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select = com.rpl.specter.impl.compiled_select_STAR_;
/**
 * Navigates to and returns a sequence of all the elements specified by the path.
 */
com.rpl.specter.select_STAR_ = (function com$rpl$specter$select_STAR_(path,structure){
var G__28702 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__28703 = structure;
return (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(G__28702,G__28703) : com.rpl.specter.compiled_select.call(null,G__28702,G__28703));
});
/**
 * Version of select-one that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one = com.rpl.specter.impl.compiled_select_one_STAR_;
/**
 * Like select, but returns either one element or nil. Throws exception if multiple elements found
 */
com.rpl.specter.select_one_STAR_ = (function com$rpl$specter$select_one_STAR_(path,structure){
var G__28706 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__28707 = structure;
return (com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(G__28706,G__28707) : com.rpl.specter.compiled_select_one.call(null,G__28706,G__28707));
});
/**
 * Version of select-one! that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_one_BANG_ = com.rpl.specter.impl.compiled_select_one_BANG__STAR_;
/**
 * Returns exactly one element, throws exception if zero or multiple elements found
 */
com.rpl.specter.select_one_BANG__STAR_ = (function com$rpl$specter$select_one_BANG__STAR_(path,structure){
var G__28710 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__28711 = structure;
return (com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one_BANG_.cljs$core$IFn$_invoke$arity$2(G__28710,G__28711) : com.rpl.specter.compiled_select_one_BANG_.call(null,G__28710,G__28711));
});
/**
 * Version of select-first that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_first = com.rpl.specter.impl.compiled_select_first_STAR_;
/**
 * Returns first element found.
 */
com.rpl.specter.select_first_STAR_ = (function com$rpl$specter$select_first_STAR_(path,structure){
var G__28714 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__28715 = structure;
return (com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_first.cljs$core$IFn$_invoke$arity$2(G__28714,G__28715) : com.rpl.specter.compiled_select_first.call(null,G__28714,G__28715));
});
/**
 * Version of select-any that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_select_any = com.rpl.specter.impl.compiled_select_any_STAR_;
/**
 * Global value used to indicate no elements selected during
 *           [[select-any]].
 */
com.rpl.specter.NONE = com.rpl.specter.impl.NONE;
/**
 * Returns any element found or [[NONE]] if nothing selected. This is the most
 * efficient of the various selection operations.
 */
com.rpl.specter.select_any_STAR_ = (function com$rpl$specter$select_any_STAR_(path,structure){
var G__28718 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__28719 = structure;
return (com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_any.cljs$core$IFn$_invoke$arity$2(G__28718,G__28719) : com.rpl.specter.compiled_select_any.call(null,G__28718,G__28719));
});
/**
 * Version of selected-any? that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_selected_any_QMARK_ = com.rpl.specter.impl.compiled_selected_any_QMARK__STAR_;
/**
 * Returns true if any element was selected, false otherwise.
 */
com.rpl.specter.selected_any_QMARK__STAR_ = (function com$rpl$specter$selected_any_QMARK__STAR_(path,structure){
var G__28722 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__28723 = structure;
return (com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_selected_any_QMARK_.cljs$core$IFn$_invoke$arity$2(G__28722,G__28723) : com.rpl.specter.compiled_selected_any_QMARK_.call(null,G__28722,G__28723));
});
/**
 * Version of traverse that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_traverse = com.rpl.specter.impl.do_compiled_traverse;
/**
 * Return a reducible object that traverses over `structure` to every element
 * specified by the path
 */
com.rpl.specter.traverse_STAR_ = (function com$rpl$specter$traverse_STAR_(apath,structure){
var G__28726 = com.rpl.specter.impl.comp_paths_STAR_(apath);
var G__28727 = structure;
return (com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_traverse.cljs$core$IFn$_invoke$arity$2(G__28726,G__28727) : com.rpl.specter.compiled_traverse.call(null,G__28726,G__28727));
});
/**
 * Version of transform that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_transform = com.rpl.specter.impl.compiled_transform_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by the result of running
 *   the transform-fn on it
 */
com.rpl.specter.transform_STAR_ = (function com$rpl$specter$transform_STAR_(path,transform_fn,structure){
var G__28731 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__28732 = transform_fn;
var G__28733 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__28731,G__28732,G__28733) : com.rpl.specter.compiled_transform.call(null,G__28731,G__28732,G__28733));
});
/**
 * Version of `multi-transform` that takes in a path precompiled with `comp-paths`
 */
com.rpl.specter.compiled_multi_transform = com.rpl.specter.impl.compiled_multi_transform_STAR_;
/**
 * Just like `transform` but expects transform functions to be specified
 * inline in the path using `terminal`. Error is thrown if navigation finishes
 * at a non-`terminal` navigator. `terminal-val` is a wrapper around `terminal` and is
 * the `multi-transform` equivalent of `setval`.
 */
com.rpl.specter.multi_transform_STAR_ = (function com$rpl$specter$multi_transform_STAR_(path,structure){
var G__28736 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__28737 = structure;
return (com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_multi_transform.cljs$core$IFn$_invoke$arity$2(G__28736,G__28737) : com.rpl.specter.compiled_multi_transform.call(null,G__28736,G__28737));
});
/**
 * Version of setval that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_setval = com.rpl.specter.impl.compiled_setval_STAR_;
/**
 * Navigates to each value specified by the path and replaces it by val
 */
com.rpl.specter.setval_STAR_ = (function com$rpl$specter$setval_STAR_(path,val,structure){
var G__28741 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__28742 = val;
var G__28743 = structure;
return (com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_setval.cljs$core$IFn$_invoke$arity$3(G__28741,G__28742,G__28743) : com.rpl.specter.compiled_setval.call(null,G__28741,G__28742,G__28743));
});
/**
 * Version of replace-in that takes in a path precompiled with comp-paths
 */
com.rpl.specter.compiled_replace_in = com.rpl.specter.impl.compiled_replace_in_STAR_;
/**
 * Similar to transform, except returns a pair of [transformed-structure sequence-of-user-ret].
 * The transform-fn in this case is expected to return [ret user-ret]. ret is
 * what's used to transform the data structure, while user-ret will be added to the user-ret sequence
 * in the final return. replace-in is useful for situations where you need to know the specific values
 * of what was transformed in the data structure.
 */
com.rpl.specter.replace_in_STAR_ = (function com$rpl$specter$replace_in_STAR_(var_args){
var args__8442__auto__ = [];
var len__8435__auto___28756 = arguments.length;
var i__8436__auto___28757 = (0);
while(true){
if((i__8436__auto___28757 < len__8435__auto___28756)){
args__8442__auto__.push((arguments[i__8436__auto___28757]));

var G__28758 = (i__8436__auto___28757 + (1));
i__8436__auto___28757 = G__28758;
continue;
} else {
}
break;
}

var argseq__8443__auto__ = ((((3) < args__8442__auto__.length))?(new cljs.core.IndexedSeq(args__8442__auto__.slice((3)),(0),null)):null);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__8443__auto__);
});

com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (path,transform_fn,structure,p__28748){
var map__28749 = p__28748;
var map__28749__$1 = ((((!((map__28749 == null)))?((((map__28749.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__28749.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__28749):map__28749);
var merge_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__28749__$1,cljs.core.cst$kw$merge_DASH_fn,cljs.core.concat);
var G__28751 = com.rpl.specter.impl.comp_paths_STAR_(path);
var G__28752 = transform_fn;
var G__28753 = structure;
var G__28754 = cljs.core.cst$kw$merge_DASH_fn;
var G__28755 = merge_fn;
return (com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5 ? com.rpl.specter.compiled_replace_in.cljs$core$IFn$_invoke$arity$5(G__28751,G__28752,G__28753,G__28754,G__28755) : com.rpl.specter.compiled_replace_in.call(null,G__28751,G__28752,G__28753,G__28754,G__28755));
});

com.rpl.specter.replace_in_STAR_.cljs$lang$maxFixedArity = (3);

com.rpl.specter.replace_in_STAR_.cljs$lang$applyTo = (function (seq28744){
var G__28745 = cljs.core.first(seq28744);
var seq28744__$1 = cljs.core.next(seq28744);
var G__28746 = cljs.core.first(seq28744__$1);
var seq28744__$2 = cljs.core.next(seq28744__$1);
var G__28747 = cljs.core.first(seq28744__$2);
var seq28744__$3 = cljs.core.next(seq28744__$2);
return com.rpl.specter.replace_in_STAR_.cljs$core$IFn$_invoke$arity$variadic(G__28745,G__28746,G__28747,seq28744__$3);
});

com.rpl.specter.late_path = com.rpl.specter.impl.late_path;
com.rpl.specter.dynamic_param_QMARK_ = com.rpl.specter.impl.dynamic_param_QMARK_;
com.rpl.specter.local_declarepath = com.rpl.specter.impl.local_declarepath;


com.rpl.specter.STOP_select_STAR_ = (function com$rpl$specter$STOP_select_STAR_(structure,next_fn){
return com.rpl.specter.NONE;
});

com.rpl.specter.STOP_transform_STAR_ = (function com$rpl$specter$STOP_transform_STAR_(structure,next_fn){
return structure;
});

/**
 * Stops navigation at this point. For selection returns nothing and for
 *        transformation returns the structure unchanged
 */
com.rpl.specter.STOP = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter28759 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28759 = (function (meta28760){
this.meta28760 = meta28760;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28759.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28761,meta28760__$1){
var self__ = this;
var _28761__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28759(meta28760__$1));
});

com.rpl.specter.t_com$rpl$specter28759.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28761){
var self__ = this;
var _28761__$1 = this;
return self__.meta28760;
});

com.rpl.specter.t_com$rpl$specter28759.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28759.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return com.rpl.specter.NONE;
});

com.rpl.specter.t_com$rpl$specter28759.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return structure;
});

com.rpl.specter.t_com$rpl$specter28759.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta28760], null);
});

com.rpl.specter.t_com$rpl$specter28759.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28759.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28759";

com.rpl.specter.t_com$rpl$specter28759.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28759");
});

com.rpl.specter.__GT_t_com$rpl$specter28759 = (function com$rpl$specter$__GT_t_com$rpl$specter28759(meta28760){
return (new com.rpl.specter.t_com$rpl$specter28759(meta28760));
});

}

return (new com.rpl.specter.t_com$rpl$specter28759(null));
})()
;
/**
 * Stays navigated at the current point. Essentially a no-op navigator.
 */
com.rpl.specter.STAY = com.rpl.specter.impl.STAY_STAR_;
/**
 * For usage with `multi-transform`, defines an endpoint in the navigation
 *        that will have the parameterized transform function run. The transform
 *        function works just like it does in `transform`, with collected values
 *        given as the first arguments
 */
com.rpl.specter.terminal = com.rpl.specter.impl.direct_nav_obj((function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter28762 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28762 = (function (afn,meta28763){
this.afn = afn;
this.meta28763 = meta28763;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28762.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28764,meta28763__$1){
var self__ = this;
var _28764__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28762(self__.afn,meta28763__$1));
});

com.rpl.specter.t_com$rpl$specter28762.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28764){
var self__ = this;
var _28764__$1 = this;
return self__.meta28763;
});

com.rpl.specter.t_com$rpl$specter28762.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28762.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
throw (new java.lang.IllegalArgumentException(com.rpl.specter.impl.smart_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["'terminal' should only be used in multi-transform"], 0))));
});

com.rpl.specter.t_com$rpl$specter28762.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.impl.terminal_STAR_(self__.afn,vals,structure);
});

com.rpl.specter.t_com$rpl$specter28762.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta28763], null);
});

com.rpl.specter.t_com$rpl$specter28762.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28762.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28762";

com.rpl.specter.t_com$rpl$specter28762.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28762");
});

com.rpl.specter.__GT_t_com$rpl$specter28762 = (function com$rpl$specter$__GT_t_com$rpl$specter28762(afn__$1,meta28763){
return (new com.rpl.specter.t_com$rpl$specter28762(afn__$1,meta28763));
});

}

return (new com.rpl.specter.t_com$rpl$specter28762(afn,null));
}));
/**
 * Like `terminal` but specifies a val to set at the location regardless of
 * the collected values or the value at the location.
 */
com.rpl.specter.terminal_val = (function com$rpl$specter$terminal_val(v){
var G__28766 = com.rpl.specter.impl.fast_constantly(v);
return (com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.terminal.cljs$core$IFn$_invoke$arity$1(G__28766) : com.rpl.specter.terminal.call(null,G__28766));
});


com.rpl.specter.ALL_select_STAR_ = (function com$rpl$specter$ALL_select_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.ALL_transform_STAR_ = (function com$rpl$specter$ALL_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

/**
 * Navigate to every element of the collection. For maps navigates to
 *        a vector of `[key value]`.
 */
com.rpl.specter.ALL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter28767 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28767 = (function (meta28768){
this.meta28768 = meta28768;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28767.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28769,meta28768__$1){
var self__ = this;
var _28769__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28767(meta28768__$1));
});

com.rpl.specter.t_com$rpl$specter28767.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28769){
var self__ = this;
var _28769__$1 = this;
return self__.meta28768;
});

com.rpl.specter.t_com$rpl$specter28767.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28767.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return com.rpl.specter.navs.all_select(structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter28767.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return com.rpl.specter.navs.all_transform(structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter28767.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta28768], null);
});

com.rpl.specter.t_com$rpl$specter28767.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28767.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28767";

com.rpl.specter.t_com$rpl$specter28767.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28767");
});

com.rpl.specter.__GT_t_com$rpl$specter28767 = (function com$rpl$specter$__GT_t_com$rpl$specter28767(meta28768){
return (new com.rpl.specter.t_com$rpl$specter28767(meta28768));
});

}

return (new com.rpl.specter.t_com$rpl$specter28767(null));
})()
;


com.rpl.specter.MAP_VALS_select_STAR_ = (function com$rpl$specter$MAP_VALS_select_STAR_(structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__8831__auto__,v){
var ret__8832__auto__ = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(v) : next_fn.call(null,v));
if((ret__8832__auto__ === com.rpl.specter.NONE)){
return curr__8831__auto__;
} else {
return ret__8832__auto__;
}
}),com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.MAP_VALS_transform_STAR_ = (function com$rpl$specter$MAP_VALS_transform_STAR_(structure,next_fn){
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

/**
 * Navigate to each value of the map. This is more efficient than
 *        navigating via [ALL LAST]
 */
com.rpl.specter.MAP_VALS = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter28770 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28770 = (function (meta28771){
this.meta28771 = meta28771;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28770.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28772,meta28771__$1){
var self__ = this;
var _28772__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28770(meta28771__$1));
});

com.rpl.specter.t_com$rpl$specter28770.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28772){
var self__ = this;
var _28772__$1 = this;
return self__.meta28771;
});

com.rpl.specter.t_com$rpl$specter28770.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28770.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (next_fn,this__9904__auto____$1){
return (function (curr__8831__auto__,v){
var ret__8832__auto__ = next_fn(v);
if((ret__8832__auto__ === com.rpl.specter.NONE)){
return curr__8831__auto__;
} else {
return ret__8832__auto__;
}
});})(next_fn,this__9904__auto____$1))
,com.rpl.specter.NONE,cljs.core.vals(structure));
});

com.rpl.specter.t_com$rpl$specter28770.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return com.rpl.specter.navs.map_vals_transform(structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter28770.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta28771], null);
});

com.rpl.specter.t_com$rpl$specter28770.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28770.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28770";

com.rpl.specter.t_com$rpl$specter28770.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28770");
});

com.rpl.specter.__GT_t_com$rpl$specter28770 = (function com$rpl$specter$__GT_t_com$rpl$specter28770(meta28771){
return (new com.rpl.specter.t_com$rpl$specter28770(meta28771));
});

}

return (new com.rpl.specter.t_com$rpl$specter28770(null));
})()
;
com.rpl.specter.VAL = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter28773 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28773 = (function (meta28774){
this.meta28774 = meta28774;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28773.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28775,meta28774__$1){
var self__ = this;
var _28775__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28773(meta28774__$1));
});

com.rpl.specter.t_com$rpl$specter28773.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28775){
var self__ = this;
var _28775__$1 = this;
return self__.meta28774;
});

com.rpl.specter.t_com$rpl$specter28773.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28773.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__10560__auto__,vals__10561__auto__,structure,next_fn__10562__auto__){
var self__ = this;
var this__10560__auto____$1 = this;
var G__28776 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__10561__auto__,structure);
var G__28777 = structure;
return (next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2(G__28776,G__28777) : next_fn__10562__auto__.call(null,G__28776,G__28777));
});

com.rpl.specter.t_com$rpl$specter28773.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__10560__auto__,vals__10561__auto__,structure,next_fn__10562__auto__){
var self__ = this;
var this__10560__auto____$1 = this;
var G__28778 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__10561__auto__,structure);
var G__28779 = structure;
return (next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2(G__28778,G__28779) : next_fn__10562__auto__.call(null,G__28778,G__28779));
});

com.rpl.specter.t_com$rpl$specter28773.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta28774], null);
});

com.rpl.specter.t_com$rpl$specter28773.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28773.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28773";

com.rpl.specter.t_com$rpl$specter28773.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28773");
});

com.rpl.specter.__GT_t_com$rpl$specter28773 = (function com$rpl$specter$__GT_t_com$rpl$specter28773(meta28774){
return (new com.rpl.specter.t_com$rpl$specter28773(meta28774));
});

}

return (new com.rpl.specter.t_com$rpl$specter28773(null));
})()
;
/**
 * Navigate to the last element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.LAST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_last,com.rpl.specter.navs.update_last));
/**
 * Navigate to the first element of the collection. If the collection is
 *        empty navigation is stopped at this point.
 */
com.rpl.specter.FIRST = (com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.navs.PosNavigator.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first) : com.rpl.specter.navs.PosNavigator.call(null,com.rpl.specter.navs.get_first,com.rpl.specter.navs.update_first));


com.rpl.specter.srange_dynamic_select_STAR_ = (function com$rpl$specter$srange_dynamic_select_STAR_(start_fn,end_fn,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,(start_fn.cljs$core$IFn$_invoke$arity$1 ? start_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_fn.call(null,structure)),(end_fn.cljs$core$IFn$_invoke$arity$1 ? end_fn.cljs$core$IFn$_invoke$arity$1(structure) : end_fn.call(null,structure)),next_fn);
});

com.rpl.specter.srange_dynamic_transform_STAR_ = (function com$rpl$specter$srange_dynamic_transform_STAR_(start_fn,end_fn,structure,next_fn){
var G__28784 = structure;
var G__28785 = (start_fn.cljs$core$IFn$_invoke$arity$1 ? start_fn.cljs$core$IFn$_invoke$arity$1(structure) : start_fn.call(null,structure));
var G__28786 = (end_fn.cljs$core$IFn$_invoke$arity$1 ? end_fn.cljs$core$IFn$_invoke$arity$1(structure) : end_fn.call(null,structure));
var G__28787 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__28784,G__28785,G__28786,G__28787) : com.rpl.specter.navs.srange_transform.call(null,G__28784,G__28785,G__28786,G__28787));
});

/**
 * Uses start-fn and end-fn to determine the bounds of the subsequence
 *        to select when navigating. Each function takes in the structure as input.
 */
com.rpl.specter.srange_dynamic = com.rpl.specter.impl.direct_nav_obj((function (start_fn,end_fn){
if(typeof com.rpl.specter.t_com$rpl$specter28788 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28788 = (function (start_fn,end_fn,meta28789){
this.start_fn = start_fn;
this.end_fn = end_fn;
this.meta28789 = meta28789;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28788.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28790,meta28789__$1){
var self__ = this;
var _28790__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28788(self__.start_fn,self__.end_fn,meta28789__$1));
});

com.rpl.specter.t_com$rpl$specter28788.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28790){
var self__ = this;
var _28790__$1 = this;
return self__.meta28789;
});

com.rpl.specter.t_com$rpl$specter28788.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28788.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return com.rpl.specter.navs.srange_select(structure,(self__.start_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_fn.call(null,structure)),(self__.end_fn.cljs$core$IFn$_invoke$arity$1 ? self__.end_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.end_fn.call(null,structure)),next_fn);
});

com.rpl.specter.t_com$rpl$specter28788.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
var G__28791 = structure;
var G__28792 = (self__.start_fn.cljs$core$IFn$_invoke$arity$1 ? self__.start_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.start_fn.call(null,structure));
var G__28793 = (self__.end_fn.cljs$core$IFn$_invoke$arity$1 ? self__.end_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.end_fn.call(null,structure));
var G__28794 = next_fn;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(G__28791,G__28792,G__28793,G__28794) : com.rpl.specter.navs.srange_transform.call(null,G__28791,G__28792,G__28793,G__28794));
});

com.rpl.specter.t_com$rpl$specter28788.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start_DASH_fn,cljs.core.cst$sym$end_DASH_fn,cljs.core.cst$sym$meta28789], null);
});

com.rpl.specter.t_com$rpl$specter28788.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28788.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28788";

com.rpl.specter.t_com$rpl$specter28788.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28788");
});

com.rpl.specter.__GT_t_com$rpl$specter28788 = (function com$rpl$specter$__GT_t_com$rpl$specter28788(start_fn__$1,end_fn__$1,meta28789){
return (new com.rpl.specter.t_com$rpl$specter28788(start_fn__$1,end_fn__$1,meta28789));
});

}

return (new com.rpl.specter.t_com$rpl$specter28788(start_fn,end_fn,null));
}));


com.rpl.specter.srange_select_STAR_ = (function com$rpl$specter$srange_select_STAR_(start,end,structure,next_fn){
return com.rpl.specter.navs.srange_select(structure,start,end,next_fn);
});

com.rpl.specter.srange_transform_STAR_ = (function com$rpl$specter$srange_transform_STAR_(start,end,structure,next_fn){
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,start,end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,start,end,next_fn));
});

/**
 * Navigates to the subsequence bound by the indexes start (inclusive)
 *        and end (exclusive)
 */
com.rpl.specter.srange = com.rpl.specter.impl.direct_nav_obj((function (start,end){
if(typeof com.rpl.specter.t_com$rpl$specter28795 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28795 = (function (start,end,meta28796){
this.start = start;
this.end = end;
this.meta28796 = meta28796;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28795.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28797,meta28796__$1){
var self__ = this;
var _28797__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28795(self__.start,self__.end,meta28796__$1));
});

com.rpl.specter.t_com$rpl$specter28795.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28797){
var self__ = this;
var _28797__$1 = this;
return self__.meta28796;
});

com.rpl.specter.t_com$rpl$specter28795.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28795.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return com.rpl.specter.navs.srange_select(structure,self__.start,self__.end,next_fn);
});

com.rpl.specter.t_com$rpl$specter28795.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return (com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4 ? com.rpl.specter.navs.srange_transform.cljs$core$IFn$_invoke$arity$4(structure,self__.start,self__.end,next_fn) : com.rpl.specter.navs.srange_transform.call(null,structure,self__.start,self__.end,next_fn));
});

com.rpl.specter.t_com$rpl$specter28795.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$start,cljs.core.cst$sym$end,cljs.core.cst$sym$meta28796], null);
});

com.rpl.specter.t_com$rpl$specter28795.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28795.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28795";

com.rpl.specter.t_com$rpl$specter28795.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28795");
});

com.rpl.specter.__GT_t_com$rpl$specter28795 = (function com$rpl$specter$__GT_t_com$rpl$specter28795(start__$1,end__$1,meta28796){
return (new com.rpl.specter.t_com$rpl$specter28795(start__$1,end__$1,meta28796));
});

}

return (new com.rpl.specter.t_com$rpl$specter28795(start,end,null));
}));


com.rpl.specter.continuous_subseqs_select_STAR_ = (function com$rpl$specter$continuous_subseqs_select_STAR_(pred,structure,next_fn){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (curr__8831__auto__,p__28802){
var vec__28803 = p__28802;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28803,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28803,(1),null);
var ret__8832__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__8832__auto__ === com.rpl.specter.NONE)){
return curr__8831__auto__;
} else {
return ret__8832__auto__;
}
}),com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,pred));
});

com.rpl.specter.continuous_subseqs_transform_STAR_ = (function com$rpl$specter$continuous_subseqs_transform_STAR_(pred,structure,next_fn){
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(pred,structure,next_fn);
});

/**
 * Navigates to every continuous subsequence of elements matching `pred`
 */
com.rpl.specter.continuous_subseqs = com.rpl.specter.impl.direct_nav_obj((function (pred){
if(typeof com.rpl.specter.t_com$rpl$specter28806 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28806 = (function (pred,meta28807){
this.pred = pred;
this.meta28807 = meta28807;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28806.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28808,meta28807__$1){
var self__ = this;
var _28808__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28806(self__.pred,meta28807__$1));
});

com.rpl.specter.t_com$rpl$specter28806.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28808){
var self__ = this;
var _28808__$1 = this;
return self__.meta28807;
});

com.rpl.specter.t_com$rpl$specter28806.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28806.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (next_fn,this__9904__auto____$1){
return (function (curr__8831__auto__,p__28809){
var vec__28810 = p__28809;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28810,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28810,(1),null);
var ret__8832__auto__ = com.rpl.specter.navs.srange_select(structure,s,e,next_fn);
if((ret__8832__auto__ === com.rpl.specter.NONE)){
return curr__8831__auto__;
} else {
return ret__8832__auto__;
}
});})(next_fn,this__9904__auto____$1))
,com.rpl.specter.NONE,com.rpl.specter.impl.matching_ranges(structure,self__.pred));
});

com.rpl.specter.t_com$rpl$specter28806.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return com.rpl.specter.impl.continuous_subseqs_transform_STAR_(self__.pred,structure,next_fn);
});

com.rpl.specter.t_com$rpl$specter28806.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$pred,cljs.core.cst$sym$meta28807], null);
});

com.rpl.specter.t_com$rpl$specter28806.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28806.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28806";

com.rpl.specter.t_com$rpl$specter28806.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28806");
});

com.rpl.specter.__GT_t_com$rpl$specter28806 = (function com$rpl$specter$__GT_t_com$rpl$specter28806(pred__$1,meta28807){
return (new com.rpl.specter.t_com$rpl$specter28806(pred__$1,meta28807));
});

}

return (new com.rpl.specter.t_com$rpl$specter28806(pred,null));
}));


com.rpl.specter.BEGINNING_select_STAR_ = (function com$rpl$specter$BEGINNING_select_STAR_(structure,next_fn){
var G__28814 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28814) : next_fn.call(null,G__28814));
});

com.rpl.specter.BEGINNING_transform_STAR_ = (function com$rpl$specter$BEGINNING_transform_STAR_(structure,next_fn){
var to_prepend = (function (){var G__28816 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28816) : next_fn.call(null,G__28816));
})();
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
});

/**
 * Navigate to the empty subsequence before the first element of the collection.
 */
com.rpl.specter.BEGINNING = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter28817 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28817 = (function (meta28818){
this.meta28818 = meta28818;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28817.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28819,meta28818__$1){
var self__ = this;
var _28819__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28817(meta28818__$1));
});

com.rpl.specter.t_com$rpl$specter28817.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28819){
var self__ = this;
var _28819__$1 = this;
return self__.meta28818;
});

com.rpl.specter.t_com$rpl$specter28817.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28817.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn(cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.t_com$rpl$specter28817.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
var to_prepend = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.prepend_all(structure,to_prepend);
});

com.rpl.specter.t_com$rpl$specter28817.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta28818], null);
});

com.rpl.specter.t_com$rpl$specter28817.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28817.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28817";

com.rpl.specter.t_com$rpl$specter28817.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28817");
});

com.rpl.specter.__GT_t_com$rpl$specter28817 = (function com$rpl$specter$__GT_t_com$rpl$specter28817(meta28818){
return (new com.rpl.specter.t_com$rpl$specter28817(meta28818));
});

}

return (new com.rpl.specter.t_com$rpl$specter28817(null));
})()
;


com.rpl.specter.END_select_STAR_ = (function com$rpl$specter$END_select_STAR_(structure,next_fn){
var G__28821 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28821) : next_fn.call(null,G__28821));
});

com.rpl.specter.END_transform_STAR_ = (function com$rpl$specter$END_transform_STAR_(structure,next_fn){
var to_append = (function (){var G__28823 = cljs.core.PersistentVector.EMPTY;
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28823) : next_fn.call(null,G__28823));
})();
return com.rpl.specter.navs.append_all(structure,to_append);
});

/**
 * Navigate to the empty subsequence after the last element of the collection.
 */
com.rpl.specter.END = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter28824 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28824 = (function (meta28825){
this.meta28825 = meta28825;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28824.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28826,meta28825__$1){
var self__ = this;
var _28826__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28824(meta28825__$1));
});

com.rpl.specter.t_com$rpl$specter28824.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28826){
var self__ = this;
var _28826__$1 = this;
return self__.meta28825;
});

com.rpl.specter.t_com$rpl$specter28824.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28824.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn(cljs.core.PersistentVector.EMPTY);
});

com.rpl.specter.t_com$rpl$specter28824.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
var to_append = next_fn(cljs.core.PersistentVector.EMPTY);
return com.rpl.specter.navs.append_all(structure,to_append);
});

com.rpl.specter.t_com$rpl$specter28824.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta28825], null);
});

com.rpl.specter.t_com$rpl$specter28824.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28824.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28824";

com.rpl.specter.t_com$rpl$specter28824.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28824");
});

com.rpl.specter.__GT_t_com$rpl$specter28824 = (function com$rpl$specter$__GT_t_com$rpl$specter28824(meta28825){
return (new com.rpl.specter.t_com$rpl$specter28824(meta28825));
});

}

return (new com.rpl.specter.t_com$rpl$specter28824(null));
})()
;


com.rpl.specter.subset_select_STAR_ = (function com$rpl$specter$subset_select_STAR_(aset,structure,next_fn){
var G__28828 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28828) : next_fn.call(null,G__28828));
});

com.rpl.specter.subset_transform_STAR_ = (function com$rpl$specter$subset_transform_STAR_(aset,structure,next_fn){
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,aset);
var newset = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(subset) : next_fn.call(null,subset));
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

/**
 * Navigates to the specified subset (by taking an intersection).
 *        In a transform, that subset in the original set is changed to the
 *        new value of the subset.
 */
com.rpl.specter.subset = com.rpl.specter.impl.direct_nav_obj((function (aset){
if(typeof com.rpl.specter.t_com$rpl$specter28829 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28829 = (function (aset,meta28830){
this.aset = aset;
this.meta28830 = meta28830;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28829.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28831,meta28830__$1){
var self__ = this;
var _28831__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28829(self__.aset,meta28830__$1));
});

com.rpl.specter.t_com$rpl$specter28829.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28831){
var self__ = this;
var _28831__$1 = this;
return self__.meta28830;
});

com.rpl.specter.t_com$rpl$specter28829.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28829.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset));
});

com.rpl.specter.t_com$rpl$specter28829.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
var subset = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(structure,self__.aset);
var newset = next_fn(subset);
return clojure.set.union.cljs$core$IFn$_invoke$arity$2(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(structure,subset),newset);
});

com.rpl.specter.t_com$rpl$specter28829.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$aset,cljs.core.cst$sym$meta28830], null);
});

com.rpl.specter.t_com$rpl$specter28829.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28829.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28829";

com.rpl.specter.t_com$rpl$specter28829.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28829");
});

com.rpl.specter.__GT_t_com$rpl$specter28829 = (function com$rpl$specter$__GT_t_com$rpl$specter28829(aset__$1,meta28830){
return (new com.rpl.specter.t_com$rpl$specter28829(aset__$1,meta28830));
});

}

return (new com.rpl.specter.t_com$rpl$specter28829(aset,null));
}));


com.rpl.specter.submap_select_STAR_ = (function com$rpl$specter$submap_select_STAR_(m_keys,structure,next_fn){
var G__28833 = cljs.core.select_keys(structure,m_keys);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28833) : next_fn.call(null,G__28833));
});

com.rpl.specter.submap_transform_STAR_ = (function com$rpl$specter$submap_transform_STAR_(m_keys,structure,next_fn){
var submap = cljs.core.select_keys(structure,m_keys);
var newmap = (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(submap) : next_fn.call(null,submap));
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,m_keys),newmap], 0));
});

/**
 * Navigates to the specified submap (using select-keys).
 *        In a transform, that submap in the original map is changed to the new
 *        value of the submap.
 */
com.rpl.specter.submap = com.rpl.specter.impl.direct_nav_obj((function (m_keys){
if(typeof com.rpl.specter.t_com$rpl$specter28834 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28834 = (function (m_keys,meta28835){
this.m_keys = m_keys;
this.meta28835 = meta28835;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28834.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28836,meta28835__$1){
var self__ = this;
var _28836__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28834(self__.m_keys,meta28835__$1));
});

com.rpl.specter.t_com$rpl$specter28834.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28836){
var self__ = this;
var _28836__$1 = this;
return self__.meta28835;
});

com.rpl.specter.t_com$rpl$specter28834.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28834.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn(cljs.core.select_keys(structure,self__.m_keys));
});

com.rpl.specter.t_com$rpl$specter28834.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
var submap = cljs.core.select_keys(structure,self__.m_keys);
var newmap = next_fn(submap);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc,structure,self__.m_keys),newmap], 0));
});

com.rpl.specter.t_com$rpl$specter28834.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$m_DASH_keys,cljs.core.cst$sym$meta28835], null);
});

com.rpl.specter.t_com$rpl$specter28834.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28834.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28834";

com.rpl.specter.t_com$rpl$specter28834.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28834");
});

com.rpl.specter.__GT_t_com$rpl$specter28834 = (function com$rpl$specter$__GT_t_com$rpl$specter28834(m_keys__$1,meta28835){
return (new com.rpl.specter.t_com$rpl$specter28834(m_keys__$1,meta28835));
});

}

return (new com.rpl.specter.t_com$rpl$specter28834(m_keys,null));
}));


com.rpl.specter.walker_select_STAR_ = (function com$rpl$specter$walker_select_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_select(afn,next_fn,structure);
});

com.rpl.specter.walker_transform_STAR_ = (function com$rpl$specter$walker_transform_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_until(afn,next_fn,structure);
});

/**
 * Using clojure.walk, navigate the data structure until reaching
 *        a value for which `afn` returns truthy.
 */
com.rpl.specter.walker = com.rpl.specter.impl.direct_nav_obj((function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter28837 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28837 = (function (afn,meta28838){
this.afn = afn;
this.meta28838 = meta28838;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28837.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28839,meta28838__$1){
var self__ = this;
var _28839__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28837(self__.afn,meta28838__$1));
});

com.rpl.specter.t_com$rpl$specter28837.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28839){
var self__ = this;
var _28839__$1 = this;
return self__.meta28838;
});

com.rpl.specter.t_com$rpl$specter28837.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28837.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return com.rpl.specter.navs.walk_select(self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter28837.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return com.rpl.specter.navs.walk_until(self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter28837.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta28838], null);
});

com.rpl.specter.t_com$rpl$specter28837.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28837.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28837";

com.rpl.specter.t_com$rpl$specter28837.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28837");
});

com.rpl.specter.__GT_t_com$rpl$specter28837 = (function com$rpl$specter$__GT_t_com$rpl$specter28837(afn__$1,meta28838){
return (new com.rpl.specter.t_com$rpl$specter28837(afn__$1,meta28838));
});

}

return (new com.rpl.specter.t_com$rpl$specter28837(afn,null));
}));


com.rpl.specter.codewalker_select_STAR_ = (function com$rpl$specter$codewalker_select_STAR_(afn,structure,next_fn){
return com.rpl.specter.navs.walk_select(afn,next_fn,structure);
});

com.rpl.specter.codewalker_transform_STAR_ = (function com$rpl$specter$codewalker_transform_STAR_(afn,structure,next_fn){
return com.rpl.specter.impl.codewalk_until(afn,next_fn,structure);
});

/**
 * Like `walker` but maintains metadata of any forms traversed.
 */
com.rpl.specter.codewalker = com.rpl.specter.impl.direct_nav_obj((function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter28840 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28840 = (function (afn,meta28841){
this.afn = afn;
this.meta28841 = meta28841;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28840.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28842,meta28841__$1){
var self__ = this;
var _28842__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28840(self__.afn,meta28841__$1));
});

com.rpl.specter.t_com$rpl$specter28840.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28842){
var self__ = this;
var _28842__$1 = this;
return self__.meta28841;
});

com.rpl.specter.t_com$rpl$specter28840.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28840.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return com.rpl.specter.navs.walk_select(self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter28840.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return com.rpl.specter.impl.codewalk_until(self__.afn,next_fn,structure);
});

com.rpl.specter.t_com$rpl$specter28840.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta28841], null);
});

com.rpl.specter.t_com$rpl$specter28840.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28840.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28840";

com.rpl.specter.t_com$rpl$specter28840.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28840");
});

com.rpl.specter.__GT_t_com$rpl$specter28840 = (function com$rpl$specter$__GT_t_com$rpl$specter28840(afn__$1,meta28841){
return (new com.rpl.specter.t_com$rpl$specter28840(afn__$1,meta28841));
});

}

return (new com.rpl.specter.t_com$rpl$specter28840(afn,null));
}));
/**
 * Navigates to a sequence that contains the results of (select ...),
 *   but is a view to the original structure that can be transformed.
 * 
 *   Requires that the input navigators will walk the structure's
 *   children in the same order when executed on "select" and then
 *   "transform".
 */
com.rpl.specter.subselect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function() { 
var G__28849__delegate = function (path){
var builder__10563__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if(typeof com.rpl.specter.t_com$rpl$specter28843 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28843 = (function (path,late,meta28844){
this.path = path;
this.late = late;
this.meta28844 = meta28844;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28843.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28845,meta28844__$1){
var self__ = this;
var _28845__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28843(self__.path,self__.late,meta28844__$1));
});

com.rpl.specter.t_com$rpl$specter28843.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28845){
var self__ = this;
var _28845__$1 = this;
return self__.meta28844;
});

com.rpl.specter.t_com$rpl$specter28843.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28843.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn((com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
});

com.rpl.specter.t_com$rpl$specter28843.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
var select_result = (com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure));
var transformed = next_fn(select_result);
var values_to_insert = com.rpl.specter.impl.mutable_cell.cljs$core$IFn$_invoke$arity$1(transformed);
var G__28846 = self__.late;
var G__28847 = ((function (G__28846,select_result,transformed,values_to_insert,next_fn,this__9904__auto____$1){
return (function (_){
var next_val = cljs.core.first(com.rpl.specter.impl.get_cell(values_to_insert));
com.rpl.specter.impl.update_cell_BANG_(values_to_insert,cljs.core.rest);

return next_val;
});})(G__28846,select_result,transformed,values_to_insert,next_fn,this__9904__auto____$1))
;
var G__28848 = structure;
return (com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(G__28846,G__28847,G__28848) : com.rpl.specter.compiled_transform.call(null,G__28846,G__28847,G__28848));
});

com.rpl.specter.t_com$rpl$specter28843.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$path,cljs.core.cst$sym$late,cljs.core.cst$sym$meta28844], null);
});

com.rpl.specter.t_com$rpl$specter28843.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28843.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28843";

com.rpl.specter.t_com$rpl$specter28843.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28843");
});

com.rpl.specter.__GT_t_com$rpl$specter28843 = (function com$rpl$specter$__GT_t_com$rpl$specter28843(path__$1,late__$1,meta28844){
return (new com.rpl.specter.t_com$rpl$specter28843(path__$1,late__$1,meta28844));
});

}

return (new com.rpl.specter.t_com$rpl$specter28843(path,late,null));
}));
var curr_params__10564__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__10564__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__10563__auto__,curr_params__10564__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__10563__auto__,curr_params__10564__auto__);
}
};
var G__28849 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__28850__i = 0, G__28850__a = new Array(arguments.length -  0);
while (G__28850__i < G__28850__a.length) {G__28850__a[G__28850__i] = arguments[G__28850__i + 0]; ++G__28850__i;}
  path = new cljs.core.IndexedSeq(G__28850__a,0);
} 
return G__28849__delegate.call(this,path);};
G__28849.cljs$lang$maxFixedArity = 0;
G__28849.cljs$lang$applyTo = (function (arglist__28851){
var path = cljs.core.seq(arglist__28851);
return G__28849__delegate(path);
});
G__28849.cljs$core$IFn$_invoke$arity$variadic = G__28849__delegate;
return G__28849;
})()
,cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
/**
 * Navigates to the specified key, navigating to nil if it does not exist.
 */
com.rpl.specter.keypath = com.rpl.specter.impl.direct_nav_obj((function (key){
if(typeof com.rpl.specter.t_com$rpl$specter28852 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28852 = (function (key,meta28853){
this.key = key;
this.meta28853 = meta28853;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28852.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28854,meta28853__$1){
var self__ = this;
var _28854__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28852(self__.key,meta28853__$1));
});

com.rpl.specter.t_com$rpl$specter28852.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28854){
var self__ = this;
var _28854__$1 = this;
return self__.meta28853;
});

com.rpl.specter.t_com$rpl$specter28852.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28852.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__28855 = vals;
var G__28856 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__28855,G__28856) : next_fn.call(null,G__28855,G__28856));
});

com.rpl.specter.t_com$rpl$specter28852.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(structure,self__.key,(function (){var G__28857 = vals;
var G__28858 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.key);
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__28857,G__28858) : next_fn.call(null,G__28857,G__28858));
})());
});

com.rpl.specter.t_com$rpl$specter28852.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$key,cljs.core.cst$sym$meta28853], null);
});

com.rpl.specter.t_com$rpl$specter28852.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28852.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28852";

com.rpl.specter.t_com$rpl$specter28852.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28852");
});

com.rpl.specter.__GT_t_com$rpl$specter28852 = (function com$rpl$specter$__GT_t_com$rpl$specter28852(key__$1,meta28853){
return (new com.rpl.specter.t_com$rpl$specter28852(key__$1,meta28853));
});

}

return (new com.rpl.specter.t_com$rpl$specter28852(key,null));
}));
/**
 * Navigates to the key only if it exists in the map.
 */
com.rpl.specter.must = com.rpl.specter.impl.direct_nav_obj((function (k){
if(typeof com.rpl.specter.t_com$rpl$specter28859 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28859 = (function (k,meta28860){
this.k = k;
this.meta28860 = meta28860;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28859.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28861,meta28860__$1){
var self__ = this;
var _28861__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28859(self__.k,meta28860__$1));
});

com.rpl.specter.t_com$rpl$specter28859.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28861){
var self__ = this;
var _28861__$1 = this;
return self__.meta28860;
});

com.rpl.specter.t_com$rpl$specter28859.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28859.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.k)){
var G__28862 = vals;
var G__28863 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.k);
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__28862,G__28863) : next_fn.call(null,G__28862,G__28863));
} else {
return com.rpl.specter.NONE;
}
});

com.rpl.specter.t_com$rpl$specter28859.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
if(cljs.core.contains_QMARK_(structure,self__.k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(structure,self__.k,(function (){var G__28864 = vals;
var G__28865 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(structure,self__.k);
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__28864,G__28865) : next_fn.call(null,G__28864,G__28865));
})());
} else {
return structure;
}
});

com.rpl.specter.t_com$rpl$specter28859.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$k,cljs.core.cst$sym$meta28860], null);
});

com.rpl.specter.t_com$rpl$specter28859.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28859.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28859";

com.rpl.specter.t_com$rpl$specter28859.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28859");
});

com.rpl.specter.__GT_t_com$rpl$specter28859 = (function com$rpl$specter$__GT_t_com$rpl$specter28859(k__$1,meta28860){
return (new com.rpl.specter.t_com$rpl$specter28859(k__$1,meta28860));
});

}

return (new com.rpl.specter.t_com$rpl$specter28859(k,null));
}));
/**
 * Navigates to result of running `afn` on the currently navigated value.
 */
com.rpl.specter.view = com.rpl.specter.impl.direct_nav_obj((function (afn){
if(typeof com.rpl.specter.t_com$rpl$specter28866 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28866 = (function (afn,meta28867){
this.afn = afn;
this.meta28867 = meta28867;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28866.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28868,meta28867__$1){
var self__ = this;
var _28868__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28866(self__.afn,meta28867__$1));
});

com.rpl.specter.t_com$rpl$specter28866.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28868){
var self__ = this;
var _28868__$1 = this;
return self__.meta28867;
});

com.rpl.specter.t_com$rpl$specter28866.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28866.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__28869 = vals;
var G__28870 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__28869,G__28870) : next_fn.call(null,G__28869,G__28870));
});

com.rpl.specter.t_com$rpl$specter28866.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__28871 = vals;
var G__28872 = (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(structure) : self__.afn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__28871,G__28872) : next_fn.call(null,G__28871,G__28872));
});

com.rpl.specter.t_com$rpl$specter28866.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$afn,cljs.core.cst$sym$meta28867], null);
});

com.rpl.specter.t_com$rpl$specter28866.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28866.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28866";

com.rpl.specter.t_com$rpl$specter28866.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28866");
});

com.rpl.specter.__GT_t_com$rpl$specter28866 = (function com$rpl$specter$__GT_t_com$rpl$specter28866(afn__$1,meta28867){
return (new com.rpl.specter.t_com$rpl$specter28866(afn__$1,meta28867));
});

}

return (new com.rpl.specter.t_com$rpl$specter28866(afn,null));
}));


com.rpl.specter.parser_select_STAR_ = (function com$rpl$specter$parser_select_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__28874 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28874) : next_fn.call(null,G__28874));
});

com.rpl.specter.parser_transform_STAR_ = (function com$rpl$specter$parser_transform_STAR_(parse_fn,unparse_fn,structure,next_fn){
var G__28877 = (function (){var G__28878 = (parse_fn.cljs$core$IFn$_invoke$arity$1 ? parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : parse_fn.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28878) : next_fn.call(null,G__28878));
})();
return (unparse_fn.cljs$core$IFn$_invoke$arity$1 ? unparse_fn.cljs$core$IFn$_invoke$arity$1(G__28877) : unparse_fn.call(null,G__28877));
});

/**
 * Navigate to the result of running `parse-fn` on the value. For
 *        transforms, the transformed value then has `unparse-fn` run on
 *        it to get the final value at this point.
 */
com.rpl.specter.parser = com.rpl.specter.impl.direct_nav_obj((function (parse_fn,unparse_fn){
if(typeof com.rpl.specter.t_com$rpl$specter28879 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28879 = (function (parse_fn,unparse_fn,meta28880){
this.parse_fn = parse_fn;
this.unparse_fn = unparse_fn;
this.meta28880 = meta28880;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28879.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28881,meta28880__$1){
var self__ = this;
var _28881__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28879(self__.parse_fn,self__.unparse_fn,meta28880__$1));
});

com.rpl.specter.t_com$rpl$specter28879.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28881){
var self__ = this;
var _28881__$1 = this;
return self__.meta28880;
});

com.rpl.specter.t_com$rpl$specter28879.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28879.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter28879.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
var G__28882 = next_fn((self__.parse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.parse_fn.cljs$core$IFn$_invoke$arity$1(structure) : self__.parse_fn.call(null,structure)));
return (self__.unparse_fn.cljs$core$IFn$_invoke$arity$1 ? self__.unparse_fn.cljs$core$IFn$_invoke$arity$1(G__28882) : self__.unparse_fn.call(null,G__28882));
});

com.rpl.specter.t_com$rpl$specter28879.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$parse_DASH_fn,cljs.core.cst$sym$unparse_DASH_fn,cljs.core.cst$sym$meta28880], null);
});

com.rpl.specter.t_com$rpl$specter28879.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28879.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28879";

com.rpl.specter.t_com$rpl$specter28879.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28879");
});

com.rpl.specter.__GT_t_com$rpl$specter28879 = (function com$rpl$specter$__GT_t_com$rpl$specter28879(parse_fn__$1,unparse_fn__$1,meta28880){
return (new com.rpl.specter.t_com$rpl$specter28879(parse_fn__$1,unparse_fn__$1,meta28880));
});

}

return (new com.rpl.specter.t_com$rpl$specter28879(parse_fn,unparse_fn,null));
}));


com.rpl.specter.ATOM_select_STAR_ = (function com$rpl$specter$ATOM_select_STAR_(structure,next_fn){
var G__28884 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(structure) : cljs.core.deref.call(null,structure));
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28884) : next_fn.call(null,G__28884));
});

com.rpl.specter.ATOM_transform_STAR_ = (function com$rpl$specter$ATOM_transform_STAR_(structure,next_fn){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

/**
 * Navigates to atom value.
 */
com.rpl.specter.ATOM = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter28885 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28885 = (function (meta28886){
this.meta28886 = meta28886;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28885.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28887,meta28886__$1){
var self__ = this;
var _28887__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28885(meta28886__$1));
});

com.rpl.specter.t_com$rpl$specter28885.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28887){
var self__ = this;
var _28887__$1 = this;
return self__.meta28886;
});

com.rpl.specter.t_com$rpl$specter28885.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28885.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(structure) : cljs.core.deref.call(null,structure)));
});

com.rpl.specter.t_com$rpl$specter28885.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(structure,next_fn);

return structure;
});

com.rpl.specter.t_com$rpl$specter28885.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta28886], null);
});

com.rpl.specter.t_com$rpl$specter28885.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28885.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28885";

com.rpl.specter.t_com$rpl$specter28885.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28885");
});

com.rpl.specter.__GT_t_com$rpl$specter28885 = (function com$rpl$specter$__GT_t_com$rpl$specter28885(meta28886){
return (new com.rpl.specter.t_com$rpl$specter28885(meta28886));
});

}

return (new com.rpl.specter.t_com$rpl$specter28885(null));
})()
;
/**
 * Filters the current value based on whether a path finds anything.
 *   e.g. (selected? :vals ALL even?) keeps the current element only if an
 *   even number exists for the :vals key.
 */
com.rpl.specter.selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function() { 
var G__28893__delegate = function (path){
var temp__6751__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__6751__auto__)){
var afn = temp__6751__auto__;
return afn;
} else {
var builder__10563__auto__ = com.rpl.specter.impl.direct_nav_obj(((function (temp__6751__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter28890 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28890 = (function (path,temp__6751__auto__,late,meta28891){
this.path = path;
this.temp__6751__auto__ = temp__6751__auto__;
this.late = late;
this.meta28891 = meta28891;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28890.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__6751__auto__){
return (function (_28892,meta28891__$1){
var self__ = this;
var _28892__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28890(self__.path,self__.temp__6751__auto__,self__.late,meta28891__$1));
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28890.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__6751__auto__){
return (function (_28892){
var self__ = this;
var _28892__$1 = this;
return self__.meta28891;
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28890.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28890.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__6751__auto__){
return (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1,temp__6751__auto__){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1,temp__6751__auto__))
;
return com.rpl.specter.impl.filter_select(((function (next_fn,this__9904__auto____$1,temp__6751__auto__){
return (function (p1__28888_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,p1__28888_SHARP_);
});})(next_fn,this__9904__auto____$1,temp__6751__auto__))
,structure,next_fn);
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28890.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__6751__auto__){
return (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1,temp__6751__auto__){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1,temp__6751__auto__))
;
return com.rpl.specter.impl.filter_transform(((function (next_fn,this__9904__auto____$1,temp__6751__auto__){
return (function (p1__28889_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late,p1__28889_SHARP_);
});})(next_fn,this__9904__auto____$1,temp__6751__auto__))
,structure,next_fn);
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28890.getBasis = ((function (temp__6751__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$path,cljs.core.cst$sym$temp__6751__auto__,cljs.core.cst$sym$late,cljs.core.cst$sym$meta28891], null);
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28890.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28890.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28890";

com.rpl.specter.t_com$rpl$specter28890.cljs$lang$ctorPrWriter = ((function (temp__6751__auto__){
return (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28890");
});})(temp__6751__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter28890 = ((function (temp__6751__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter28890(path__$1,temp__6751__auto____$1,late__$1,meta28891){
return (new com.rpl.specter.t_com$rpl$specter28890(path__$1,temp__6751__auto____$1,late__$1,meta28891));
});})(temp__6751__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter28890(path,temp__6751__auto__,late,null));
});})(temp__6751__auto__))
);
var curr_params__10564__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__10564__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__10563__auto__,curr_params__10564__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__10563__auto__,curr_params__10564__auto__);
}
}
};
var G__28893 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__28894__i = 0, G__28894__a = new Array(arguments.length -  0);
while (G__28894__i < G__28894__a.length) {G__28894__a[G__28894__i] = arguments[G__28894__i + 0]; ++G__28894__i;}
  path = new cljs.core.IndexedSeq(G__28894__a,0);
} 
return G__28893__delegate.call(this,path);};
G__28893.cljs$lang$maxFixedArity = 0;
G__28893.cljs$lang$applyTo = (function (arglist__28895){
var path = cljs.core.seq(arglist__28895);
return G__28893__delegate(path);
});
G__28893.cljs$core$IFn$_invoke$arity$variadic = G__28893__delegate;
return G__28893;
})()
,cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
com.rpl.specter.not_selected_QMARK_ = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function() { 
var G__28901__delegate = function (path){
var temp__6751__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(path);
if(cljs.core.truth_(temp__6751__auto__)){
var afn = temp__6751__auto__;
return ((function (afn,temp__6751__auto__){
return (function (s){
return cljs.core.not((afn.cljs$core$IFn$_invoke$arity$1 ? afn.cljs$core$IFn$_invoke$arity$1(s) : afn.call(null,s)));
});
;})(afn,temp__6751__auto__))
} else {
var builder__10563__auto__ = com.rpl.specter.impl.direct_nav_obj(((function (temp__6751__auto__){
return (function (late){
if(typeof com.rpl.specter.t_com$rpl$specter28898 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28898 = (function (path,temp__6751__auto__,late,meta28899){
this.path = path;
this.temp__6751__auto__ = temp__6751__auto__;
this.late = late;
this.meta28899 = meta28899;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28898.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__6751__auto__){
return (function (_28900,meta28899__$1){
var self__ = this;
var _28900__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28898(self__.path,self__.temp__6751__auto__,self__.late,meta28899__$1));
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28898.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__6751__auto__){
return (function (_28900){
var self__ = this;
var _28900__$1 = this;
return self__.meta28899;
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28898.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28898.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__6751__auto__){
return (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1,temp__6751__auto__){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1,temp__6751__auto__))
;
return com.rpl.specter.impl.filter_select(((function (next_fn,this__9904__auto____$1,temp__6751__auto__){
return (function (p1__28896_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,p1__28896_SHARP_);
});})(next_fn,this__9904__auto____$1,temp__6751__auto__))
,structure,next_fn);
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28898.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__6751__auto__){
return (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1,temp__6751__auto__){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1,temp__6751__auto__))
;
return com.rpl.specter.impl.filter_transform(((function (next_fn,this__9904__auto____$1,temp__6751__auto__){
return (function (p1__28897_SHARP_){
return com.rpl.specter.navs.not_selected_QMARK__STAR_(self__.late,p1__28897_SHARP_);
});})(next_fn,this__9904__auto____$1,temp__6751__auto__))
,structure,next_fn);
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28898.getBasis = ((function (temp__6751__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$path,cljs.core.cst$sym$temp__6751__auto__,cljs.core.cst$sym$late,cljs.core.cst$sym$meta28899], null);
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28898.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28898.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28898";

com.rpl.specter.t_com$rpl$specter28898.cljs$lang$ctorPrWriter = ((function (temp__6751__auto__){
return (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28898");
});})(temp__6751__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter28898 = ((function (temp__6751__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter28898(path__$1,temp__6751__auto____$1,late__$1,meta28899){
return (new com.rpl.specter.t_com$rpl$specter28898(path__$1,temp__6751__auto____$1,late__$1,meta28899));
});})(temp__6751__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter28898(path,temp__6751__auto__,late,null));
});})(temp__6751__auto__))
);
var curr_params__10564__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__10564__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__10563__auto__,curr_params__10564__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__10563__auto__,curr_params__10564__auto__);
}
}
};
var G__28901 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__28902__i = 0, G__28902__a = new Array(arguments.length -  0);
while (G__28902__i < G__28902__a.length) {G__28902__a[G__28902__i] = arguments[G__28902__i + 0]; ++G__28902__i;}
  path = new cljs.core.IndexedSeq(G__28902__a,0);
} 
return G__28901__delegate.call(this,path);};
G__28901.cljs$lang$maxFixedArity = 0;
G__28901.cljs$lang$applyTo = (function (arglist__28903){
var path = cljs.core.seq(arglist__28903);
return G__28901__delegate(path);
});
G__28901.cljs$core$IFn$_invoke$arity$variadic = G__28901__delegate;
return G__28901;
})()
,cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
/**
 * Navigates to a view of the current sequence that only contains elements that
 *   match the given path. An element matches the selector path if calling select
 *   on that element with the path yields anything other than an empty sequence.
 * 
 * The input path may be parameterized, in which case the result of filterer
 * will be parameterized in the order of which the parameterized selectors
 * were declared.
 */
com.rpl.specter.filterer = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function() { 
var G__28906__delegate = function (path){
var G__28904 = com.rpl.specter.ALL;
var G__28905 = (com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.selected_QMARK_.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.selected_QMARK_.call(null,path));
return (com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.subselect.cljs$core$IFn$_invoke$arity$2(G__28904,G__28905) : com.rpl.specter.subselect.call(null,G__28904,G__28905));
};
var G__28906 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__28907__i = 0, G__28907__a = new Array(arguments.length -  0);
while (G__28907__i < G__28907__a.length) {G__28907__a[G__28907__i] = arguments[G__28907__i + 0]; ++G__28907__i;}
  path = new cljs.core.IndexedSeq(G__28907__a,0);
} 
return G__28906__delegate.call(this,path);};
G__28906.cljs$lang$maxFixedArity = 0;
G__28906.cljs$lang$applyTo = (function (arglist__28908){
var path = cljs.core.seq(arglist__28908);
return G__28906__delegate(path);
});
G__28906.cljs$core$IFn$_invoke$arity$variadic = G__28906__delegate;
return G__28906;
})()
,cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
/**
 * Navigates to a view of the current value by transforming it with the
 * specified path and update-fn.
 * 
 * The input path may be parameterized, in which case the result of transformed
 * will be parameterized in the order of which the parameterized navigators
 * were declared.
 */
com.rpl.specter.transformed = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function (path,update_fn){
var builder__10563__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late,late_fn){
if(typeof com.rpl.specter.t_com$rpl$specter28909 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28909 = (function (path,update_fn,late,late_fn,meta28910){
this.path = path;
this.update_fn = update_fn;
this.late = late;
this.late_fn = late_fn;
this.meta28910 = meta28910;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28909.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28911,meta28910__$1){
var self__ = this;
var _28911__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28909(self__.path,self__.update_fn,self__.late,self__.late_fn,meta28910__$1));
});

com.rpl.specter.t_com$rpl$specter28909.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28911){
var self__ = this;
var _28911__$1 = this;
return self__.meta28910;
});

com.rpl.specter.t_com$rpl$specter28909.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28909.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
});

com.rpl.specter.t_com$rpl$specter28909.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn((com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.compiled_transform.cljs$core$IFn$_invoke$arity$3(self__.late,self__.late_fn,structure) : com.rpl.specter.compiled_transform.call(null,self__.late,self__.late_fn,structure)));
});

com.rpl.specter.t_com$rpl$specter28909.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$path,cljs.core.cst$sym$update_DASH_fn,cljs.core.cst$sym$late,cljs.core.cst$sym$late_DASH_fn,cljs.core.cst$sym$meta28910], null);
});

com.rpl.specter.t_com$rpl$specter28909.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28909.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28909";

com.rpl.specter.t_com$rpl$specter28909.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28909");
});

com.rpl.specter.__GT_t_com$rpl$specter28909 = (function com$rpl$specter$__GT_t_com$rpl$specter28909(path__$1,update_fn__$1,late__$1,late_fn__$1,meta28910){
return (new com.rpl.specter.t_com$rpl$specter28909(path__$1,update_fn__$1,late__$1,late_fn__$1,meta28910));
});

}

return (new com.rpl.specter.t_com$rpl$specter28909(path,update_fn,late,late_fn,null));
}));
var curr_params__10564__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path)),update_fn], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__10564__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__10563__auto__,curr_params__10564__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__10563__auto__,curr_params__10564__auto__);
}
}),cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
/**
 * Keeps the element only if it matches the supplied predicate. This is the
 *        late-bound parameterized version of using a function directly in a path.
 */
com.rpl.specter.pred = com.rpl.specter.impl.pred_STAR_;
(com.rpl.specter.protocols.ImplicitNav["null"] = true);

(com.rpl.specter.protocols.implicit_nav["null"] = (function (this$){
return com.rpl.specter.STAY;
}));
cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.Keyword.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.keypath.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.keypath.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.keypath.call(null,this$__$1));
});
(com.rpl.specter.protocols.ImplicitNav["function"] = true);

(com.rpl.specter.protocols.implicit_nav["function"] = (function (this$){
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$) : com.rpl.specter.pred.call(null,this$));
}));
cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.PersistentHashSet.prototype.com$rpl$specter$protocols$ImplicitNav$implicit_nav$arity$1 = (function (this$){
var this$__$1 = this;
return (com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.pred.cljs$core$IFn$_invoke$arity$1(this$__$1) : com.rpl.specter.pred.call(null,this$__$1));
});


com.rpl.specter.nil__GT_val_select_STAR_ = (function com$rpl$specter$nil__GT_val_select_STAR_(v,structure,next_fn){
var G__28913 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28913) : next_fn.call(null,G__28913));
});

com.rpl.specter.nil__GT_val_transform_STAR_ = (function com$rpl$specter$nil__GT_val_transform_STAR_(v,structure,next_fn){
var G__28915 = (((structure == null))?v:structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28915) : next_fn.call(null,G__28915));
});

/**
 * Navigates to the provided val if the structure is nil. Otherwise it stays
 *        navigated at the structure.
 */
com.rpl.specter.nil__GT_val = com.rpl.specter.impl.direct_nav_obj((function (v){
if(typeof com.rpl.specter.t_com$rpl$specter28916 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28916 = (function (v,meta28917){
this.v = v;
this.meta28917 = meta28917;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28916.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28918,meta28917__$1){
var self__ = this;
var _28918__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28916(self__.v,meta28917__$1));
});

com.rpl.specter.t_com$rpl$specter28916.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28918){
var self__ = this;
var _28918__$1 = this;
return self__.meta28917;
});

com.rpl.specter.t_com$rpl$specter28916.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28916.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn((((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter28916.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn((((structure == null))?self__.v:structure));
});

com.rpl.specter.t_com$rpl$specter28916.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$v,cljs.core.cst$sym$meta28917], null);
});

com.rpl.specter.t_com$rpl$specter28916.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28916.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28916";

com.rpl.specter.t_com$rpl$specter28916.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28916");
});

com.rpl.specter.__GT_t_com$rpl$specter28916 = (function com$rpl$specter$__GT_t_com$rpl$specter28916(v__$1,meta28917){
return (new com.rpl.specter.t_com$rpl$specter28916(v__$1,meta28917));
});

}

return (new com.rpl.specter.t_com$rpl$specter28916(v,null));
}));
/**
 * Navigates to #{} if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_SET = (function (){var G__28919 = cljs.core.PersistentHashSet.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__28919) : com.rpl.specter.nil__GT_val.call(null,G__28919));
})();
/**
 * Navigates to '() if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_LIST = (function (){var G__28920 = cljs.core.List.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__28920) : com.rpl.specter.nil__GT_val.call(null,G__28920));
})();
/**
 * Navigates to [] if the value is nil. Otherwise it stays
 *        navigated at the current value.
 */
com.rpl.specter.NIL__GT_VECTOR = (function (){var G__28921 = cljs.core.PersistentVector.EMPTY;
return (com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.nil__GT_val.cljs$core$IFn$_invoke$arity$1(G__28921) : com.rpl.specter.nil__GT_val.call(null,G__28921));
})();


com.rpl.specter.META_select_STAR_ = (function com$rpl$specter$META_select_STAR_(structure,next_fn){
var G__28923 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28923) : next_fn.call(null,G__28923));
});

com.rpl.specter.META_transform_STAR_ = (function com$rpl$specter$META_transform_STAR_(structure,next_fn){
return cljs.core.with_meta(structure,(function (){var G__28925 = cljs.core.meta(structure);
return (next_fn.cljs$core$IFn$_invoke$arity$1 ? next_fn.cljs$core$IFn$_invoke$arity$1(G__28925) : next_fn.call(null,G__28925));
})());
});

/**
 * Navigates to the metadata of the structure, or nil if
 *   the structure has no metadata or may not contain metadata.
 */
com.rpl.specter.META = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter28926 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28926 = (function (meta28927){
this.meta28927 = meta28927;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28926.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28928,meta28927__$1){
var self__ = this;
var _28928__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28926(meta28927__$1));
});

com.rpl.specter.t_com$rpl$specter28926.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28928){
var self__ = this;
var _28928__$1 = this;
return self__.meta28927;
});

com.rpl.specter.t_com$rpl$specter28926.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28926.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return next_fn(cljs.core.meta(structure));
});

com.rpl.specter.t_com$rpl$specter28926.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__9904__auto__,vals__9905__auto__,structure,next_fn__9906__auto__){
var self__ = this;
var this__9904__auto____$1 = this;
var next_fn = ((function (this__9904__auto____$1){
return (function (s__9907__auto__){
return (next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__9906__auto__.cljs$core$IFn$_invoke$arity$2(vals__9905__auto__,s__9907__auto__) : next_fn__9906__auto__.call(null,vals__9905__auto__,s__9907__auto__));
});})(this__9904__auto____$1))
;
return cljs.core.with_meta(structure,next_fn(cljs.core.meta(structure)));
});

com.rpl.specter.t_com$rpl$specter28926.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta28927], null);
});

com.rpl.specter.t_com$rpl$specter28926.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28926.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28926";

com.rpl.specter.t_com$rpl$specter28926.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28926");
});

com.rpl.specter.__GT_t_com$rpl$specter28926 = (function com$rpl$specter$__GT_t_com$rpl$specter28926(meta28927){
return (new com.rpl.specter.t_com$rpl$specter28926(meta28927));
});

}

return (new com.rpl.specter.t_com$rpl$specter28926(null));
})()
;
/**
 * Adds the result of running select with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function() { 
var G__28936__delegate = function (path){
var builder__10563__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if(typeof com.rpl.specter.t_com$rpl$specter28929 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28929 = (function (path,late,meta28930){
this.path = path;
this.late = late;
this.meta28930 = meta28930;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28929.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28931,meta28930__$1){
var self__ = this;
var _28931__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28929(self__.path,self__.late,meta28930__$1));
});

com.rpl.specter.t_com$rpl$specter28929.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28931){
var self__ = this;
var _28931__$1 = this;
return self__.meta28930;
});

com.rpl.specter.t_com$rpl$specter28929.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28929.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__10560__auto__,vals__10561__auto__,structure,next_fn__10562__auto__){
var self__ = this;
var this__10560__auto____$1 = this;
var G__28932 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__10561__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__28933 = structure;
return (next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2(G__28932,G__28933) : next_fn__10562__auto__.call(null,G__28932,G__28933));
});

com.rpl.specter.t_com$rpl$specter28929.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__10560__auto__,vals__10561__auto__,structure,next_fn__10562__auto__){
var self__ = this;
var this__10560__auto____$1 = this;
var G__28934 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__10561__auto__,(com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select.call(null,self__.late,structure)));
var G__28935 = structure;
return (next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2(G__28934,G__28935) : next_fn__10562__auto__.call(null,G__28934,G__28935));
});

com.rpl.specter.t_com$rpl$specter28929.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$path,cljs.core.cst$sym$late,cljs.core.cst$sym$meta28930], null);
});

com.rpl.specter.t_com$rpl$specter28929.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28929.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28929";

com.rpl.specter.t_com$rpl$specter28929.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28929");
});

com.rpl.specter.__GT_t_com$rpl$specter28929 = (function com$rpl$specter$__GT_t_com$rpl$specter28929(path__$1,late__$1,meta28930){
return (new com.rpl.specter.t_com$rpl$specter28929(path__$1,late__$1,meta28930));
});

}

return (new com.rpl.specter.t_com$rpl$specter28929(path,late,null));
}));
var curr_params__10564__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__10564__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__10563__auto__,curr_params__10564__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__10563__auto__,curr_params__10564__auto__);
}
};
var G__28936 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__28937__i = 0, G__28937__a = new Array(arguments.length -  0);
while (G__28937__i < G__28937__a.length) {G__28937__a[G__28937__i] = arguments[G__28937__i + 0]; ++G__28937__i;}
  path = new cljs.core.IndexedSeq(G__28937__a,0);
} 
return G__28936__delegate.call(this,path);};
G__28936.cljs$lang$maxFixedArity = 0;
G__28936.cljs$lang$applyTo = (function (arglist__28938){
var path = cljs.core.seq(arglist__28938);
return G__28936__delegate(path);
});
G__28936.cljs$core$IFn$_invoke$arity$variadic = G__28936__delegate;
return G__28936;
})()
,cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
/**
 * Adds the result of running select-one with the given path on the
 *        current value to the collected vals.
 */
com.rpl.specter.collect_one = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function() { 
var G__28946__delegate = function (path){
var builder__10563__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late){
if(typeof com.rpl.specter.t_com$rpl$specter28939 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28939 = (function (path,late,meta28940){
this.path = path;
this.late = late;
this.meta28940 = meta28940;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28939.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28941,meta28940__$1){
var self__ = this;
var _28941__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28939(self__.path,self__.late,meta28940__$1));
});

com.rpl.specter.t_com$rpl$specter28939.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28941){
var self__ = this;
var _28941__$1 = this;
return self__.meta28940;
});

com.rpl.specter.t_com$rpl$specter28939.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28939.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__10560__auto__,vals__10561__auto__,structure,next_fn__10562__auto__){
var self__ = this;
var this__10560__auto____$1 = this;
var G__28942 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__10561__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__28943 = structure;
return (next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2(G__28942,G__28943) : next_fn__10562__auto__.call(null,G__28942,G__28943));
});

com.rpl.specter.t_com$rpl$specter28939.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__10560__auto__,vals__10561__auto__,structure,next_fn__10562__auto__){
var self__ = this;
var this__10560__auto____$1 = this;
var G__28944 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__10561__auto__,(com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.compiled_select_one.cljs$core$IFn$_invoke$arity$2(self__.late,structure) : com.rpl.specter.compiled_select_one.call(null,self__.late,structure)));
var G__28945 = structure;
return (next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2(G__28944,G__28945) : next_fn__10562__auto__.call(null,G__28944,G__28945));
});

com.rpl.specter.t_com$rpl$specter28939.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$path,cljs.core.cst$sym$late,cljs.core.cst$sym$meta28940], null);
});

com.rpl.specter.t_com$rpl$specter28939.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28939.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28939";

com.rpl.specter.t_com$rpl$specter28939.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28939");
});

com.rpl.specter.__GT_t_com$rpl$specter28939 = (function com$rpl$specter$__GT_t_com$rpl$specter28939(path__$1,late__$1,meta28940){
return (new com.rpl.specter.t_com$rpl$specter28939(path__$1,late__$1,meta28940));
});

}

return (new com.rpl.specter.t_com$rpl$specter28939(path,late,null));
}));
var curr_params__10564__auto__ = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path) : com.rpl.specter.late_path.call(null,path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__10564__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__10563__auto__,curr_params__10564__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__10563__auto__,curr_params__10564__auto__);
}
};
var G__28946 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__28947__i = 0, G__28947__a = new Array(arguments.length -  0);
while (G__28947__i < G__28947__a.length) {G__28947__a[G__28947__i] = arguments[G__28947__i + 0]; ++G__28947__i;}
  path = new cljs.core.IndexedSeq(G__28947__a,0);
} 
return G__28946__delegate.call(this,path);};
G__28946.cljs$lang$maxFixedArity = 0;
G__28946.cljs$lang$applyTo = (function (arglist__28948){
var path = cljs.core.seq(arglist__28948);
return G__28946__delegate(path);
});
G__28946.cljs$core$IFn$_invoke$arity$variadic = G__28946__delegate;
return G__28946;
})()
,cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
/**
 * Adds an external value to the collected vals. Useful when additional arguments
 *   are required to the transform function that would otherwise require partial
 *   application or a wrapper function.
 * 
 *   e.g., incrementing val at path [:a :b] by 3:
 *   (transform [:a :b (putval 3)] + some-map)
 */
com.rpl.specter.putval = com.rpl.specter.impl.direct_nav_obj((function (val){
if(typeof com.rpl.specter.t_com$rpl$specter28949 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28949 = (function (val,meta28950){
this.val = val;
this.meta28950 = meta28950;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28949.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28951,meta28950__$1){
var self__ = this;
var _28951__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28949(self__.val,meta28950__$1));
});

com.rpl.specter.t_com$rpl$specter28949.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28951){
var self__ = this;
var _28951__$1 = this;
return self__.meta28950;
});

com.rpl.specter.t_com$rpl$specter28949.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28949.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this__10560__auto__,vals__10561__auto__,structure,next_fn__10562__auto__){
var self__ = this;
var this__10560__auto____$1 = this;
var G__28952 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__10561__auto__,self__.val);
var G__28953 = structure;
return (next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2(G__28952,G__28953) : next_fn__10562__auto__.call(null,G__28952,G__28953));
});

com.rpl.specter.t_com$rpl$specter28949.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this__10560__auto__,vals__10561__auto__,structure,next_fn__10562__auto__){
var self__ = this;
var this__10560__auto____$1 = this;
var G__28954 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(vals__10561__auto__,self__.val);
var G__28955 = structure;
return (next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2 ? next_fn__10562__auto__.cljs$core$IFn$_invoke$arity$2(G__28954,G__28955) : next_fn__10562__auto__.call(null,G__28954,G__28955));
});

com.rpl.specter.t_com$rpl$specter28949.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$val,cljs.core.cst$sym$meta28950], null);
});

com.rpl.specter.t_com$rpl$specter28949.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28949.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28949";

com.rpl.specter.t_com$rpl$specter28949.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28949");
});

com.rpl.specter.__GT_t_com$rpl$specter28949 = (function com$rpl$specter$__GT_t_com$rpl$specter28949(val__$1,meta28950){
return (new com.rpl.specter.t_com$rpl$specter28949(val__$1,meta28950));
});

}

return (new com.rpl.specter.t_com$rpl$specter28949(val,null));
}));
/**
 * Drops all collected values for subsequent navigation.
 */
com.rpl.specter.DISPENSE = (function (){
if(typeof com.rpl.specter.t_com$rpl$specter28956 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28956 = (function (meta28957){
this.meta28957 = meta28957;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28956.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28958,meta28957__$1){
var self__ = this;
var _28958__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28956(meta28957__$1));
});

com.rpl.specter.t_com$rpl$specter28956.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28958){
var self__ = this;
var _28958__$1 = this;
return self__.meta28957;
});

com.rpl.specter.t_com$rpl$specter28956.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28956.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__28959 = cljs.core.PersistentVector.EMPTY;
var G__28960 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__28959,G__28960) : next_fn.call(null,G__28959,G__28960));
});

com.rpl.specter.t_com$rpl$specter28956.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var G__28961 = cljs.core.PersistentVector.EMPTY;
var G__28962 = structure;
return (next_fn.cljs$core$IFn$_invoke$arity$2 ? next_fn.cljs$core$IFn$_invoke$arity$2(G__28961,G__28962) : next_fn.call(null,G__28961,G__28962));
});

com.rpl.specter.t_com$rpl$specter28956.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$meta28957], null);
});

com.rpl.specter.t_com$rpl$specter28956.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28956.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28956";

com.rpl.specter.t_com$rpl$specter28956.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28956");
});

com.rpl.specter.__GT_t_com$rpl$specter28956 = (function com$rpl$specter$__GT_t_com$rpl$specter28956(meta28957){
return (new com.rpl.specter.t_com$rpl$specter28956(meta28957));
});

}

return (new com.rpl.specter.t_com$rpl$specter28956(null));
})()
;
/**
 * Like cond-path, but with if semantics.
 */
com.rpl.specter.if_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function() {
var G__28971 = null;
var G__28971__2 = (function (cond_p,then_path){
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(cond_p,then_path,com.rpl.specter.STOP) : com.rpl.specter.if_path.call(null,cond_p,then_path,com.rpl.specter.STOP));
});
var G__28971__3 = (function (cond_p,then_path,else_path){
var temp__6751__auto__ = com.rpl.specter.navs.extract_basic_filter_fn(cond_p);
if(cljs.core.truth_(temp__6751__auto__)){
var afn = temp__6751__auto__;
var builder__10563__auto__ = com.rpl.specter.impl.direct_nav_obj(((function (afn,temp__6751__auto__){
return (function (late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter28965 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28965 = (function (cond_p,then_path,else_path,temp__6751__auto__,afn,late_then,late_else,meta28966){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__6751__auto__ = temp__6751__auto__;
this.afn = afn;
this.late_then = late_then;
this.late_else = late_else;
this.meta28966 = meta28966;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28965.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (afn,temp__6751__auto__){
return (function (_28967,meta28966__$1){
var self__ = this;
var _28967__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28965(self__.cond_p,self__.then_path,self__.else_path,self__.temp__6751__auto__,self__.afn,self__.late_then,self__.late_else,meta28966__$1));
});})(afn,temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28965.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (afn,temp__6751__auto__){
return (function (_28967){
var self__ = this;
var _28967__$1 = this;
return self__.meta28966;
});})(afn,temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28965.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28965.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (afn,temp__6751__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28965.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (afn,temp__6751__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,self__.afn,self__.late_then,self__.late_else);
});})(afn,temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28965.getBasis = ((function (afn,temp__6751__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cond_DASH_p,cljs.core.cst$sym$then_DASH_path,cljs.core.cst$sym$else_DASH_path,cljs.core.cst$sym$temp__6751__auto__,cljs.core.cst$sym$afn,cljs.core.cst$sym$late_DASH_then,cljs.core.cst$sym$late_DASH_else,cljs.core.cst$sym$meta28966], null);
});})(afn,temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28965.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28965.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28965";

com.rpl.specter.t_com$rpl$specter28965.cljs$lang$ctorPrWriter = ((function (afn,temp__6751__auto__){
return (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28965");
});})(afn,temp__6751__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter28965 = ((function (afn,temp__6751__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter28965(cond_p__$1,then_path__$1,else_path__$1,temp__6751__auto____$1,afn__$1,late_then__$1,late_else__$1,meta28966){
return (new com.rpl.specter.t_com$rpl$specter28965(cond_p__$1,then_path__$1,else_path__$1,temp__6751__auto____$1,afn__$1,late_then__$1,late_else__$1,meta28966));
});})(afn,temp__6751__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter28965(cond_p,then_path,else_path,temp__6751__auto__,afn,late_then,late_else,null));
});})(afn,temp__6751__auto__))
);
var curr_params__10564__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__10564__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__10563__auto__,curr_params__10564__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__10563__auto__,curr_params__10564__auto__);
}
} else {
var builder__10563__auto__ = com.rpl.specter.impl.direct_nav_obj(((function (temp__6751__auto__){
return (function (late_cond,late_then,late_else){
if(typeof com.rpl.specter.t_com$rpl$specter28968 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28968 = (function (cond_p,then_path,else_path,temp__6751__auto__,late_cond,late_then,late_else,meta28969){
this.cond_p = cond_p;
this.then_path = then_path;
this.else_path = else_path;
this.temp__6751__auto__ = temp__6751__auto__;
this.late_cond = late_cond;
this.late_then = late_then;
this.late_else = late_else;
this.meta28969 = meta28969;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28968.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (temp__6751__auto__){
return (function (_28970,meta28969__$1){
var self__ = this;
var _28970__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28968(self__.cond_p,self__.then_path,self__.else_path,self__.temp__6751__auto__,self__.late_cond,self__.late_then,self__.late_else,meta28969__$1));
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28968.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (temp__6751__auto__){
return (function (_28970){
var self__ = this;
var _28970__$1 = this;
return self__.meta28969;
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28968.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28968.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = ((function (temp__6751__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_select(vals,structure,next_fn,((function (this$__$1,temp__6751__auto__){
return (function (p1__28963_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,p1__28963_SHARP_);
});})(this$__$1,temp__6751__auto__))
,self__.late_then,self__.late_else);
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28968.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = ((function (temp__6751__auto__){
return (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
return com.rpl.specter.navs.if_transform(vals,structure,next_fn,((function (this$__$1,temp__6751__auto__){
return (function (p1__28964_SHARP_){
return com.rpl.specter.navs.selected_QMARK__STAR_(self__.late_cond,p1__28964_SHARP_);
});})(this$__$1,temp__6751__auto__))
,self__.late_then,self__.late_else);
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28968.getBasis = ((function (temp__6751__auto__){
return (function (){
return new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cond_DASH_p,cljs.core.cst$sym$then_DASH_path,cljs.core.cst$sym$else_DASH_path,cljs.core.cst$sym$temp__6751__auto__,cljs.core.cst$sym$late_DASH_cond,cljs.core.cst$sym$late_DASH_then,cljs.core.cst$sym$late_DASH_else,cljs.core.cst$sym$meta28969], null);
});})(temp__6751__auto__))
;

com.rpl.specter.t_com$rpl$specter28968.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28968.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28968";

com.rpl.specter.t_com$rpl$specter28968.cljs$lang$ctorPrWriter = ((function (temp__6751__auto__){
return (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28968");
});})(temp__6751__auto__))
;

com.rpl.specter.__GT_t_com$rpl$specter28968 = ((function (temp__6751__auto__){
return (function com$rpl$specter$__GT_t_com$rpl$specter28968(cond_p__$1,then_path__$1,else_path__$1,temp__6751__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta28969){
return (new com.rpl.specter.t_com$rpl$specter28968(cond_p__$1,then_path__$1,else_path__$1,temp__6751__auto____$1,late_cond__$1,late_then__$1,late_else__$1,meta28969));
});})(temp__6751__auto__))
;

}

return (new com.rpl.specter.t_com$rpl$specter28968(cond_p,then_path,else_path,temp__6751__auto__,late_cond,late_then,late_else,null));
});})(temp__6751__auto__))
);
var curr_params__10564__auto__ = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(cond_p) : com.rpl.specter.late_path.call(null,cond_p)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(then_path) : com.rpl.specter.late_path.call(null,then_path)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(else_path) : com.rpl.specter.late_path.call(null,else_path))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__10564__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__10563__auto__,curr_params__10564__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__10563__auto__,curr_params__10564__auto__);
}
}
});
G__28971 = function(cond_p,then_path,else_path){
switch(arguments.length){
case 2:
return G__28971__2.call(this,cond_p,then_path);
case 3:
return G__28971__3.call(this,cond_p,then_path,else_path);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28971.cljs$core$IFn$_invoke$arity$2 = G__28971__2;
G__28971.cljs$core$IFn$_invoke$arity$3 = G__28971__3;
return G__28971;
})()
,cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
/**
 * Takes in alternating cond-path path cond-path path...
 * Tests the structure if selecting with cond-path returns anything.
 * If so, it uses the following path for this portion of the navigation.
 * Otherwise, it tries the next cond-path. If nothing matches, then the structure
 * is not selected.
 * 
 * The input paths may be parameterized, in which case the result of cond-path
 * will be parameterized in the order of which the parameterized navigators
 * were declared.
 */
com.rpl.specter.cond_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function() { 
var G__28976__delegate = function (conds){
var pairs = cljs.core.reverse(cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),conds));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (pairs){
return (function (p,p__28972){
var vec__28973 = p__28972;
var tester = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28973,(0),null);
var apath = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28973,(1),null);
return (com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3 ? com.rpl.specter.if_path.cljs$core$IFn$_invoke$arity$3(tester,apath,p) : com.rpl.specter.if_path.call(null,tester,apath,p));
});})(pairs))
,com.rpl.specter.STOP,pairs);
};
var G__28976 = function (var_args){
var conds = null;
if (arguments.length > 0) {
var G__28977__i = 0, G__28977__a = new Array(arguments.length -  0);
while (G__28977__i < G__28977__a.length) {G__28977__a[G__28977__i] = arguments[G__28977__i + 0]; ++G__28977__i;}
  conds = new cljs.core.IndexedSeq(G__28977__a,0);
} 
return G__28976__delegate.call(this,conds);};
G__28976.cljs$lang$maxFixedArity = 0;
G__28976.cljs$lang$applyTo = (function (arglist__28978){
var conds = cljs.core.seq(arglist__28978);
return G__28976__delegate(conds);
});
G__28976.cljs$core$IFn$_invoke$arity$variadic = G__28976__delegate;
return G__28976;
})()
,cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
/**
 * A path that branches on multiple paths. For updates,
 * applies updates to the paths in order.
 */
com.rpl.specter.multi_path = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function() {
var G__28986 = null;
var G__28986__0 = (function (){
return com.rpl.specter.STAY;
});
var G__28986__1 = (function (path){
return path;
});
var G__28986__2 = (function (path1,path2){
var builder__10563__auto__ = com.rpl.specter.impl.direct_nav_obj((function (late1,late2){
if(typeof com.rpl.specter.t_com$rpl$specter28979 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {com.rpl.specter.protocols.RichNavigator}
 * @implements {cljs.core.IWithMeta}
*/
com.rpl.specter.t_com$rpl$specter28979 = (function (path1,path2,late1,late2,meta28980){
this.path1 = path1;
this.path2 = path2;
this.late1 = late1;
this.late2 = late2;
this.meta28980 = meta28980;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
com.rpl.specter.t_com$rpl$specter28979.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_28981,meta28980__$1){
var self__ = this;
var _28981__$1 = this;
return (new com.rpl.specter.t_com$rpl$specter28979(self__.path1,self__.path2,self__.late1,self__.late2,meta28980__$1));
});

com.rpl.specter.t_com$rpl$specter28979.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_28981){
var self__ = this;
var _28981__$1 = this;
return self__.meta28980;
});

com.rpl.specter.t_com$rpl$specter28979.prototype.com$rpl$specter$protocols$RichNavigator$ = cljs.core.PROTOCOL_SENTINEL;

com.rpl.specter.t_com$rpl$specter28979.prototype.com$rpl$specter$protocols$RichNavigator$select_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var res1 = (function (){var G__28982 = self__.late1;
return G__28982.select_STAR_(vals,structure,next_fn);
})();
var res2 = (function (){var G__28983 = self__.late2;
return G__28983.select_STAR_(vals,structure,next_fn);
})();
if((com.rpl.specter.NONE === res2)){
return res1;
} else {
return res2;
}
});

com.rpl.specter.t_com$rpl$specter28979.prototype.com$rpl$specter$protocols$RichNavigator$transform_STAR_$arity$4 = (function (this$,vals,structure,next_fn){
var self__ = this;
var this$__$1 = this;
var s1 = (function (){var G__28984 = self__.late1;
return G__28984.transform_STAR_(vals,structure,next_fn);
})();
var G__28985 = self__.late2;
return G__28985.transform_STAR_(vals,s1,next_fn);
});

com.rpl.specter.t_com$rpl$specter28979.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$path1,cljs.core.cst$sym$path2,cljs.core.cst$sym$late1,cljs.core.cst$sym$late2,cljs.core.cst$sym$meta28980], null);
});

com.rpl.specter.t_com$rpl$specter28979.cljs$lang$type = true;

com.rpl.specter.t_com$rpl$specter28979.cljs$lang$ctorStr = "com.rpl.specter/t_com$rpl$specter28979";

com.rpl.specter.t_com$rpl$specter28979.cljs$lang$ctorPrWriter = (function (this__7871__auto__,writer__7872__auto__,opt__7873__auto__){
return cljs.core._write(writer__7872__auto__,"com.rpl.specter/t_com$rpl$specter28979");
});

com.rpl.specter.__GT_t_com$rpl$specter28979 = (function com$rpl$specter$__GT_t_com$rpl$specter28979(path1__$1,path2__$1,late1__$1,late2__$1,meta28980){
return (new com.rpl.specter.t_com$rpl$specter28979(path1__$1,path2__$1,late1__$1,late2__$1,meta28980));
});

}

return (new com.rpl.specter.t_com$rpl$specter28979(path1,path2,late1,late2,null));
}));
var curr_params__10564__auto__ = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path1) : com.rpl.specter.late_path.call(null,path1)),(com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1 ? com.rpl.specter.late_path.cljs$core$IFn$_invoke$arity$1(path2) : com.rpl.specter.late_path.call(null,path2))], null);
if(cljs.core.every_QMARK_(cljs.core.complement(com.rpl.specter.impl.dynamic_param_QMARK_),curr_params__10564__auto__)){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(builder__10563__auto__,curr_params__10564__auto__);
} else {
return com.rpl.specter.impl.__GT_DynamicFunction(builder__10563__auto__,curr_params__10564__auto__);
}
});
var G__28986__3 = (function() { 
var G__28987__delegate = function (path1,path2,paths){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(com.rpl.specter.multi_path,(com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path1,path2) : com.rpl.specter.multi_path.call(null,path1,path2)),paths);
};
var G__28987 = function (path1,path2,var_args){
var paths = null;
if (arguments.length > 2) {
var G__28988__i = 0, G__28988__a = new Array(arguments.length -  2);
while (G__28988__i < G__28988__a.length) {G__28988__a[G__28988__i] = arguments[G__28988__i + 2]; ++G__28988__i;}
  paths = new cljs.core.IndexedSeq(G__28988__a,0);
} 
return G__28987__delegate.call(this,path1,path2,paths);};
G__28987.cljs$lang$maxFixedArity = 2;
G__28987.cljs$lang$applyTo = (function (arglist__28989){
var path1 = cljs.core.first(arglist__28989);
arglist__28989 = cljs.core.next(arglist__28989);
var path2 = cljs.core.first(arglist__28989);
var paths = cljs.core.rest(arglist__28989);
return G__28987__delegate(path1,path2,paths);
});
G__28987.cljs$core$IFn$_invoke$arity$variadic = G__28987__delegate;
return G__28987;
})()
;
G__28986 = function(path1,path2,var_args){
var paths = var_args;
switch(arguments.length){
case 0:
return G__28986__0.call(this);
case 1:
return G__28986__1.call(this,path1);
case 2:
return G__28986__2.call(this,path1,path2);
default:
var G__28990 = null;
if (arguments.length > 2) {
var G__28991__i = 0, G__28991__a = new Array(arguments.length -  2);
while (G__28991__i < G__28991__a.length) {G__28991__a[G__28991__i] = arguments[G__28991__i + 2]; ++G__28991__i;}
G__28990 = new cljs.core.IndexedSeq(G__28991__a,0);
}
return G__28986__3.cljs$core$IFn$_invoke$arity$variadic(path1,path2, G__28990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28986.cljs$lang$maxFixedArity = 2;
G__28986.cljs$lang$applyTo = G__28986__3.cljs$lang$applyTo;
G__28986.cljs$core$IFn$_invoke$arity$0 = G__28986__0;
G__28986.cljs$core$IFn$_invoke$arity$1 = G__28986__1;
G__28986.cljs$core$IFn$_invoke$arity$2 = G__28986__2;
G__28986.cljs$core$IFn$_invoke$arity$variadic = G__28986__3.cljs$core$IFn$_invoke$arity$variadic;
return G__28986;
})()
,cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
/**
 * Navigates to the current element and then navigates via the provided path.
 * This can be used to implement pre-order traversal.
 */
com.rpl.specter.stay_then_continue = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function() { 
var G__28992__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(com.rpl.specter.STAY,path) : com.rpl.specter.multi_path.call(null,com.rpl.specter.STAY,path));
};
var G__28992 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__28993__i = 0, G__28993__a = new Array(arguments.length -  0);
while (G__28993__i < G__28993__a.length) {G__28993__a[G__28993__i] = arguments[G__28993__i + 0]; ++G__28993__i;}
  path = new cljs.core.IndexedSeq(G__28993__a,0);
} 
return G__28992__delegate.call(this,path);};
G__28992.cljs$lang$maxFixedArity = 0;
G__28992.cljs$lang$applyTo = (function (arglist__28994){
var path = cljs.core.seq(arglist__28994);
return G__28992__delegate(path);
});
G__28992.cljs$core$IFn$_invoke$arity$variadic = G__28992__delegate;
return G__28992;
})()
,cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
/**
 * Navigates to the provided path and then to the current element. This can be used
 * to implement post-order traversal.
 */
com.rpl.specter.continue_then_stay = cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4((function() { 
var G__28995__delegate = function (path){
return (com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2 ? com.rpl.specter.multi_path.cljs$core$IFn$_invoke$arity$2(path,com.rpl.specter.STAY) : com.rpl.specter.multi_path.call(null,path,com.rpl.specter.STAY));
};
var G__28995 = function (var_args){
var path = null;
if (arguments.length > 0) {
var G__28996__i = 0, G__28996__a = new Array(arguments.length -  0);
while (G__28996__i < G__28996__a.length) {G__28996__a[G__28996__i] = arguments[G__28996__i + 0]; ++G__28996__i;}
  path = new cljs.core.IndexedSeq(G__28996__a,0);
} 
return G__28995__delegate.call(this,path);};
G__28995.cljs$lang$maxFixedArity = 0;
G__28995.cljs$lang$applyTo = (function (arglist__28997){
var path = cljs.core.seq(arglist__28997);
return G__28995__delegate(path);
});
G__28995.cljs$core$IFn$_invoke$arity$variadic = G__28995__delegate;
return G__28995;
})()
,cljs.core.assoc,cljs.core.cst$kw$dynamicnav,true);
