// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.components.idresolver.views');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('redgenes.components.icons');
goog.require('redgenes.components.lighttable');
goog.require('redgenes.components.ui.results_preview');
goog.require('redgenes.components.imcontrols.views');
goog.require('dommy.core');
goog.require('redgenes.components.loader');
goog.require('json_html.core');
goog.require('redgenes.components.idresolver.events');
goog.require('redgenes.components.idresolver.subs');
goog.require('re_frame.core');
redgenes.components.idresolver.views.separators = cljs.core.set(",; ");
redgenes.components.idresolver.views.timeout = (1500);
/**
 * UI component allowing user to choose which organisms to search. Defaults to all.
 */
redgenes.components.idresolver.views.organism_selection = (function redgenes$components$idresolver$views$organism_selection(){
var selected_organism = (function (){var G__31345 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_selected_DASH_organism], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31345) : re_frame.core.subscribe.call(null,G__31345));
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,"Organism"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.imcontrols.views.organism_dropdown,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$selected_DASH_value,((cljs.core.some_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selected_organism) : cljs.core.deref.call(null,selected_organism))))?(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selected_organism) : cljs.core.deref.call(null,selected_organism)):"Any"),cljs.core.cst$kw$on_DASH_change,((function (selected_organism){
return (function (organism){
var G__31346 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_set_DASH_selected_DASH_organism,organism], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31346) : re_frame.core.dispatch.call(null,G__31346));
});})(selected_organism))
], null)], null)], null);
});
/**
 * UI component allowing user to choose which object type to search. Defaults to the first one configured for a mine.
 */
redgenes.components.idresolver.views.object_type_selection = (function redgenes$components$idresolver$views$object_type_selection(){
var selected_object_type = (function (){var G__31350 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_selected_DASH_object_DASH_type], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31350) : re_frame.core.subscribe.call(null,G__31350));
})();
var values = (function (){var G__31351 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_object_DASH_types], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31351) : re_frame.core.subscribe.call(null,G__31351));
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label,"Type"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.imcontrols.views.object_type_dropdown,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$values,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(values) : cljs.core.deref.call(null,values)),cljs.core.cst$kw$selected_DASH_value,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selected_object_type) : cljs.core.deref.call(null,selected_object_type)),cljs.core.cst$kw$on_DASH_change,((function (selected_object_type,values){
return (function (object_type){
var G__31352 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_set_DASH_selected_DASH_object_DASH_type,object_type], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31352) : re_frame.core.dispatch.call(null,G__31352));
});})(selected_object_type,values))
], null)], null)], null);
});
/**
 * Splits a string on any one of a set of strings.
 */
redgenes.components.idresolver.views.splitter = (function redgenes$components$idresolver$views$splitter(string){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2((function (p1__31353_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",p1__31353_SHARP_);
}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,clojure.string.split.cljs$core$IFn$_invoke$arity$2(string,cljs.core.re_pattern([cljs.core.str("["),cljs.core.str(cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,redgenes.components.idresolver.views.separators)),cljs.core.str("\\r?\\n]")].join('')))));
});
/**
 * Returns true if a string contains any one of a set of strings.
 */
redgenes.components.idresolver.views.has_separator_QMARK_ = (function redgenes$components$idresolver$views$has_separator_QMARK_(str){
return cljs.core.some_QMARK_(cljs.core.some(redgenes.components.idresolver.views.separators,str));
});
redgenes.components.idresolver.views.controls = (function redgenes$components$idresolver$views$controls(){
var results = (function (){var G__31360 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_results], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31360) : re_frame.core.subscribe.call(null,G__31360));
})();
var matches = (function (){var G__31361 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_results_DASH_matches], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31361) : re_frame.core.subscribe.call(null,G__31361));
})();
var selected = (function (){var G__31362 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_selected], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31362) : re_frame.core.subscribe.call(null,G__31362));
})();
return ((function (results,matches,selected){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$btn_DASH_toolbar$controls,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_warning,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,((((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(results) : cljs.core.deref.call(null,results)) == null))?"disabled":null),cljs.core.cst$kw$on_DASH_click,((function (results,matches,selected){
return (function (){
var G__31363 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_clear], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31363) : re_frame.core.dispatch.call(null,G__31363));
});})(results,matches,selected))
], null),"Clear all"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_warning,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,((cljs.core.empty_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selected) : cljs.core.deref.call(null,selected))))?"disabled":null),cljs.core.cst$kw$on_DASH_click,((function (results,matches,selected){
return (function (){
var G__31364 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_delete_DASH_selected], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31364) : re_frame.core.dispatch.call(null,G__31364));
});})(results,matches,selected))
], null),[cljs.core.str("Remove selected ("),cljs.core.str(cljs.core.count((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selected) : cljs.core.deref.call(null,selected)))),cljs.core.str(")")].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$button$btn$btn_DASH_primary$btn_DASH_raised,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$disabled,((cljs.core.empty_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(matches) : cljs.core.deref.call(null,matches))))?"disabled":null),cljs.core.cst$kw$on_DASH_click,((function (results,matches,selected){
return (function (){
if(cljs.core.some_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(matches) : cljs.core.deref.call(null,matches)))){
var G__31365 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_analyse,true], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31365) : re_frame.core.dispatch.call(null,G__31365));
} else {
return null;
}
});})(results,matches,selected))
], null),"View Results"], null)], null);
});
;})(results,matches,selected))
});
redgenes.components.idresolver.views.submit_input = (function redgenes$components$idresolver$views$submit_input(var_args){
var args31366 = [];
var len__8435__auto___31370 = arguments.length;
var i__8436__auto___31371 = (0);
while(true){
if((i__8436__auto___31371 < len__8435__auto___31370)){
args31366.push((arguments[i__8436__auto___31371]));

var G__31372 = (i__8436__auto___31371 + (1));
i__8436__auto___31371 = G__31372;
continue;
} else {
}
break;
}

var G__31368 = args31366.length;
switch (G__31368) {
case 2:
return redgenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return redgenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args31366.length)].join('')));

}
});

redgenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$2 = (function (input,val){
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(val,"") : cljs.core.reset_BANG_.call(null,val,""));

return redgenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$1(input);
});

redgenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$1 = (function (input){
var G__31369 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_resolve,redgenes.components.idresolver.views.splitter(input)], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31369) : re_frame.core.dispatch.call(null,G__31369));
});

redgenes.components.idresolver.views.submit_input.cljs$lang$maxFixedArity = 2;

redgenes.components.idresolver.views.input_box = (function redgenes$components$idresolver$views$input_box(){
return reagent.core.create_class((function (){var val = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var timer = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$reagent_DASH_render,((function (val,timer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input_SHARP_identifierinput$freeform,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$type,"text",cljs.core.cst$kw$placeholder,"Type or paste identifiers here...",cljs.core.cst$kw$value,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(val) : cljs.core.deref.call(null,val)),cljs.core.cst$kw$on_DASH_key_DASH_press,((function (val,timer){
return (function (e){
var keycode = e.charCode;
var input = e.target.value;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(keycode,(13))){
return redgenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$2(input,val);
} else {
return null;
}
});})(val,timer))
,cljs.core.cst$kw$on_DASH_change,((function (val,timer){
return (function (e){
var input = e.target.value;
var G__31380_31386 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(timer) : cljs.core.deref.call(null,timer));
clearInterval(G__31380_31386);

var G__31381_31387 = timer;
var G__31382_31388 = (function (){var G__31383 = ((function (G__31381_31387,input,val,timer){
return (function (){
return redgenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$2(input,val);
});})(G__31381_31387,input,val,timer))
;
var G__31384 = redgenes.components.idresolver.views.timeout;
return setTimeout(G__31383,G__31384);
})();
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__31381_31387,G__31382_31388) : cljs.core.reset_BANG_.call(null,G__31381_31387,G__31382_31388));

if(cljs.core.truth_(redgenes.components.idresolver.views.has_separator_QMARK_(input))){
var G__31385_31389 = (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(timer) : cljs.core.deref.call(null,timer));
clearInterval(G__31385_31389);

return redgenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$2(input,val);
} else {
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(val,input) : cljs.core.reset_BANG_.call(null,val,input));
}
});})(val,timer))
], null)], null);
});})(val,timer))
,cljs.core.cst$kw$component_DASH_did_DASH_mount,((function (val,timer){
return (function (this$){
return reagent.core.dom_node(this$).focus();
});})(val,timer))
], null);
})());
});
/**
 * Sometimes the ambiguity we're resolving with duplicate ids is the sme symbol from two similar organisms, so we'll need to ass organism name where known.
 */
redgenes.components.idresolver.views.organism_identifier = (function redgenes$components$idresolver$views$organism_identifier(summary){
if(cljs.core.truth_(cljs.core.cst$kw$organism$name.cljs$core$IFn$_invoke$arity$1(summary))){
return [cljs.core.str(" ("),cljs.core.str(cljs.core.cst$kw$organism$name.cljs$core$IFn$_invoke$arity$1(summary)),cljs.core.str(")")].join('');
} else {
return "";
}
});
/**
 * Different objects types have different summary fields. Try to select one intelligently or fall back to primary identifier if the others ain't there.
 */
redgenes.components.idresolver.views.build_duplicate_identifier = (function redgenes$components$idresolver$views$build_duplicate_identifier(result){
var summary = cljs.core.cst$kw$summary.cljs$core$IFn$_invoke$arity$1(result);
var symbol = cljs.core.cst$kw$symbol.cljs$core$IFn$_invoke$arity$1(summary);
var accession = cljs.core.cst$kw$primaryAccession.cljs$core$IFn$_invoke$arity$1(summary);
var primaryId = cljs.core.cst$kw$primaryId.cljs$core$IFn$_invoke$arity$1(summary);
return [cljs.core.str(cljs.core.first(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [symbol,accession,primaryId], null)))),cljs.core.str(redgenes.components.idresolver.views.organism_identifier(summary))].join('');
});
redgenes.components.idresolver.views.input_item_duplicate = (function redgenes$components$idresolver$views$input_item_duplicate(){

return (function (p__31395){
var vec__31396 = p__31395;
var oid = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31396,(0),null);
var data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31396,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$id_DASH_item,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$dropdown,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$dropdown_DASH_toggle,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$type,"button",cljs.core.cst$kw$data_DASH_toggle,"dropdown"], null),cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(data),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$caret], null)], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ul$dropdown_DASH_menu], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__31396,oid,data){
return (function (result){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$li,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (vec__31396,oid,data){
return (function (e){
e.preventDefault();

var G__31399 = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_resolve_DASH_duplicate,cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(data),result], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31399) : re_frame.core.dispatch.call(null,G__31399));
});})(vec__31396,oid,data))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,redgenes.components.idresolver.views.build_duplicate_identifier(result)], null)], null);
});})(vec__31396,oid,data))
,cljs.core.cst$kw$matches.cljs$core$IFn$_invoke$arity$1(data)))], null)], null);
});
});
redgenes.components.idresolver.views.get_icon = (function redgenes$components$idresolver$views$get_icon(icon_type){
var G__31401 = (((icon_type instanceof cljs.core.Keyword))?icon_type.fqn:null);
switch (G__31401) {
case "MATCH":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_check$MATCH], null);

break;
case "UNRESOLVED":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg$icon$icon_DASH_sad$UNRESOLVED,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$use,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$xlinkHref,"#icon-sad"], null)], null)], null);

break;
case "DUPLICATE":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_clone$DUPLICATE], null);

break;
case "TYPE_CONVERTED":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$i$fa$fa_DASH_random$TYPE_CONVERTED], null);

break;
case "OTHER":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg$icon$icon_DASH_arrow_DASH_right$OTHER,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$use,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$xlinkHref,"#icon-arrow-right"], null)], null)], null);

break;
default:
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.loader.mini_loader,"tiny"], null);

}
});
redgenes.components.idresolver.views.reasons = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$TYPE_CONVERTED,"we're searching for genes and you input a protein (or vice versa).",cljs.core.cst$kw$OTHER," the synonym you input is out of date."], null);
redgenes.components.idresolver.views.input_item_converted = (function redgenes$components$idresolver$views$input_item_converted(original,results){
var new_primary_id = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(results,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$matches,(0),cljs.core.cst$kw$summary,cljs.core.cst$kw$primaryIdentifier], null));
var conversion_reason = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(results).call(null,redgenes.components.idresolver.views.reasons);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$id_DASH_item,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$title,[cljs.core.str("You input '"),cljs.core.str(original),cljs.core.str("', but we converted it to '"),cljs.core.str(new_primary_id),cljs.core.str("', because "),cljs.core.str(conversion_reason)].join('')], null),original," -> ",new_primary_id], null);
});
redgenes.components.idresolver.views.input_item = (function redgenes$components$idresolver$views$input_item(p__31403){
var map__31410 = p__31403;
var map__31410__$1 = ((((!((map__31410 == null)))?((((map__31410.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31410.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31410):map__31410);
var i = map__31410__$1;
var input = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31410__$1,cljs.core.cst$kw$input);

var result = (function (){var G__31412 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_results_DASH_item,input], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31412) : re_frame.core.subscribe.call(null,G__31412));
})();
var selected = (function (){var G__31413 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_selected], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31413) : re_frame.core.subscribe.call(null,G__31413));
})();
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$component_DASH_did_DASH_mount,((function (result,selected,map__31410,map__31410__$1,i,input){
return (function (){
return null;
});})(result,selected,map__31410,map__31410__$1,i,input))
,cljs.core.cst$kw$reagent_DASH_render,((function (result,selected,map__31410,map__31410__$1,i,input){
return (function (i__$1){
var result_vals = cljs.core.second(cljs.core.first((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(result) : cljs.core.deref.call(null,result))));
var class$ = ((cljs.core.empty_QMARK_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(result) : cljs.core.deref.call(null,result))))?"inactive":cljs.core.name(cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(result_vals)));
var class$__$1 = (cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.fromArray([input], true),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selected) : cljs.core.deref.call(null,selected))))?[cljs.core.str(class$),cljs.core.str(" selected")].join(''):class$);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$id_DASH_resolver_DASH_item_DASH_container,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.fromArray([input], true),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selected) : cljs.core.deref.call(null,selected))))?"selected":null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$id_DASH_resolver_DASH_item,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,class$__$1,cljs.core.cst$kw$on_DASH_click,((function (result_vals,class$,class$__$1,result,selected,map__31410,map__31410__$1,i,input){
return (function (e){
e.preventDefault();

e.stopPropagation();

var G__31414 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_toggle_DASH_selected,input], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31414) : re_frame.core.dispatch.call(null,G__31414));
});})(result_vals,class$,class$__$1,result,selected,map__31410,map__31410__$1,i,input))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.get_icon,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(result_vals)], null),(function (){var G__31415 = (((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(result_vals) instanceof cljs.core.Keyword))?cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(result_vals).fqn:null);
switch (G__31415) {
case "DUPLICATE":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.input_item_duplicate,cljs.core.first((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(result) : cljs.core.deref.call(null,result)))], null);

break;
case "TYPE_CONVERTED":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.input_item_converted,cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(i__$1),result_vals], null);

break;
case "OTHER":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.input_item_converted,cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(i__$1),result_vals], null);

break;
case "MATCH":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$id_DASH_item,cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(i__$1)], null);

break;
default:
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$id_DASH_item,cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(i__$1)], null);

}
})()], null)], null);
});})(result,selected,map__31410,map__31410__$1,i,input))
], null));
});
redgenes.components.idresolver.views.input_items = (function redgenes$components$idresolver$views$input_items(){
var bank = (function (){var G__31418 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_bank], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31418) : re_frame.core.subscribe.call(null,G__31418));
})();
return ((function (bank){
return (function (){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$input_DASH_items], null),cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (bank){
return (function (i){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.input_item,i], null),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key,cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(i)], null));
});})(bank))
,cljs.core.reverse((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(bank) : cljs.core.deref.call(null,bank)))));
});
;})(bank))
});
redgenes.components.idresolver.views.parse_files = (function redgenes$components$idresolver$views$parse_files(files){
var n__8235__auto__ = files.length;
var i = (0);
while(true){
if((i < n__8235__auto__)){
var rdr_31419 = (new FileReader());
var the_file_31420 = (files[i]);
rdr_31419.onload = ((function (i,rdr_31419,the_file_31420,n__8235__auto__){
return (function (e){
var file_content = e.target.result;
var file_name = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(";;; ",file_content.substr((0),(4))))?(function (){var idx = file_content.indexOf("\n\n");
return file_content.slice((4),idx);
})():the_file_31420.name);
return redgenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$1(file_content);
});})(i,rdr_31419,the_file_31420,n__8235__auto__))
;

rdr_31419.readAsText(the_file_31420);

var G__31421 = (i + (1));
i = G__31421;
continue;
} else {
return null;
}
break;
}
});
redgenes.components.idresolver.views.handle_drag_over = (function redgenes$components$idresolver$views$handle_drag_over(state_atom,evt){
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(state_atom,true) : cljs.core.reset_BANG_.call(null,state_atom,true));

evt.stopPropagation();

evt.preventDefault();

return evt.dataTransfer.dropEffect = "copy";
});
redgenes.components.idresolver.views.handle_drop_over = (function redgenes$components$idresolver$views$handle_drop_over(state_atom,evt){
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(state_atom,false) : cljs.core.reset_BANG_.call(null,state_atom,false));

evt.stopPropagation();

evt.preventDefault();

var files = evt.dataTransfer.files;
return redgenes.components.idresolver.views.parse_files(files);
});
redgenes.components.idresolver.views.drag_and_drop_prompt = (function redgenes$components$idresolver$views$drag_and_drop_prompt(){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$upload_DASH_file,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg$icon$icon_DASH_file,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$use,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$xlinkHref,"#icon-file"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"All your identifiers in a text file? Try dragging and dropping it here, or ",new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$label$browseforfile,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,(function (e){
return e.stopPropagation();
})], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$type,"file",cljs.core.cst$kw$multiple,true,cljs.core.cst$kw$on_DASH_click,(function (e){
return e.stopPropagation();
}),cljs.core.cst$kw$on_DASH_change,(function (e){
return redgenes.components.idresolver.views.parse_files(e.target.files);
})], null)], null),"browse for a file"], null)], null)], null);
});
redgenes.components.idresolver.views.input_div = (function redgenes$components$idresolver$views$input_div(){
var drag_state = reagent.core.atom.cljs$core$IFn$_invoke$arity$1(false);
return ((function (drag_state){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$resolvey,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div_SHARP_dropzone1,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$on_DASH_drop,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(redgenes.components.idresolver.views.handle_drop_over,drag_state),cljs.core.cst$kw$on_DASH_click,((function (drag_state){
return (function (evt){
evt.preventDefault();

evt.stopPropagation();

var G__31423_31424 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_clear_DASH_selected], null);
(re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31423_31424) : re_frame.core.dispatch.call(null,G__31423_31424));

return document.getElementById("identifierinput").focus();
});})(drag_state))
,cljs.core.cst$kw$on_DASH_drag_DASH_over,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(redgenes.components.idresolver.views.handle_drag_over,drag_state),cljs.core.cst$kw$on_DASH_drag_DASH_leave,((function (drag_state){
return (function (){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(drag_state,false) : cljs.core.reset_BANG_.call(null,drag_state,false));
});})(drag_state))
,cljs.core.cst$kw$on_DASH_drag_DASH_end,((function (drag_state){
return (function (){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(drag_state,false) : cljs.core.reset_BANG_.call(null,drag_state,false));
});})(drag_state))
,cljs.core.cst$kw$on_DASH_drag_DASH_exit,((function (drag_state){
return (function (){
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(drag_state,false) : cljs.core.reset_BANG_.call(null,drag_state,false));
});})(drag_state))
], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$eenput,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(drag_state) : cljs.core.deref.call(null,drag_state)))?"dragging":null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$idresolver,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$type_DASH_and_DASH_organism,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.organism_selection], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.object_type_selection], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.input_items], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.input_box], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.controls], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.drag_and_drop_prompt], null)], null)], null)], null);
});
;})(drag_state))
});
redgenes.components.idresolver.views.stats = (function redgenes$components$idresolver$views$stats(){
var bank = (function (){var G__31431 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_bank], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31431) : re_frame.core.subscribe.call(null,G__31431));
})();
var no_matches = (function (){var G__31432 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_results_DASH_no_DASH_matches], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31432) : re_frame.core.subscribe.call(null,G__31432));
})();
var matches = (function (){var G__31433 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_results_DASH_matches], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31433) : re_frame.core.subscribe.call(null,G__31433));
})();
var type_converted = (function (){var G__31434 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_results_DASH_type_DASH_converted], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31434) : re_frame.core.subscribe.call(null,G__31434));
})();
var duplicates = (function (){var G__31435 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_results_DASH_duplicates], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31435) : re_frame.core.subscribe.call(null,G__31435));
})();
var other = (function (){var G__31436 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_results_DASH_other], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31436) : re_frame.core.subscribe.call(null,G__31436));
})();
return ((function (bank,no_matches,matches,type_converted,duplicates,other){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$legend,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h3,"Legend & Stats:"], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$results,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$MATCH,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tab_DASH_index,(-5)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$type_DASH_head,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.get_icon,cljs.core.cst$kw$MATCH], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$title,"Matches"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg$icon$icon_DASH_question,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$use,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$xlinkHref,"#icon-question"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$details,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$count,cljs.core.count((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(matches) : cljs.core.deref.call(null,matches)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"The input you entered was successfully matched to a known ID"], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$TYPE_CONVERTED,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tab_DASH_index,(-4)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$type_DASH_head,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.get_icon,cljs.core.cst$kw$TYPE_CONVERTED], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$title,"Converted"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg$icon$icon_DASH_question,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$use,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$xlinkHref,"#icon-question"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$details,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$count,cljs.core.count((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(type_converted) : cljs.core.deref.call(null,type_converted)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"Input protein IDs resolved to gene (or vice versa)"], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$OTHER,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tab_DASH_index,(-2)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$type_DASH_head,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.get_icon,cljs.core.cst$kw$OTHER], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$title,"Synonyms"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg$icon$icon_DASH_question,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$use,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$xlinkHref,"#icon-question"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$details,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$count,cljs.core.count((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(other) : cljs.core.deref.call(null,other)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"The ID you input matches an old synonym of an ID. We've used the most up-to-date one instead."], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$DUPLICATE,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tab_DASH_index,(-3)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$type_DASH_head,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.get_icon,cljs.core.cst$kw$DUPLICATE], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$title,"Partial\u00A0Match"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg$icon$icon_DASH_question,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$use,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$xlinkHref,"#icon-question"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$details,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$count,cljs.core.count((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(duplicates) : cljs.core.deref.call(null,duplicates)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"The ID you input matched more than one item. Click on the down arrow beside IDs with this icon to fix this."], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$UNRESOLVED,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tab_DASH_index,(-1)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$type_DASH_head,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.get_icon,cljs.core.cst$kw$UNRESOLVED], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$title,"Not\u00A0Found"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg$icon$icon_DASH_question,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$use,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$xlinkHref,"#icon-question"], null)], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$details,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$count,cljs.core.count((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(no_matches) : cljs.core.deref.call(null,no_matches)))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$p,"The ID provided isn't one that's known for your chosen organism"], null)], null)], null)], null)], null);
});
;})(bank,no_matches,matches,type_converted,duplicates,other))
});
redgenes.components.idresolver.views.debugger$ = (function redgenes$components$idresolver$views$debugger(){
var everything = (function (){var G__31438 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_everything], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31438) : re_frame.core.subscribe.call(null,G__31438));
})();
return ((function (everything){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,json_html.core.edn__GT_hiccup((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(everything) : cljs.core.deref.call(null,everything)))], null);
});
;})(everything))
});
redgenes.components.idresolver.views.selected = (function redgenes$components$idresolver$views$selected(){
var selected = (function (){var G__31440 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_selected], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31440) : re_frame.core.subscribe.call(null,G__31440));
})();
return ((function (selected){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,"selected: ",[cljs.core.str((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selected) : cljs.core.deref.call(null,selected)))].join('')], null);
});
;})(selected))
});
redgenes.components.idresolver.views.delete_selected_handler = (function redgenes$components$idresolver$views$delete_selected_handler(e){
var keycode = e.charCode;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(keycode,(127))){
var G__31442 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_delete_DASH_selected], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31442) : re_frame.core.dispatch.call(null,G__31442));
} else {
return null;

}
});
redgenes.components.idresolver.views.key_down_handler = (function redgenes$components$idresolver$views$key_down_handler(e){
var G__31446 = e.keyIdentifier;
switch (G__31446) {
case "Control":
var G__31447 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_toggle_DASH_select_DASH_multi,true], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31447) : re_frame.core.dispatch.call(null,G__31447));

break;
case "Shift":
var G__31448 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_toggle_DASH_select_DASH_range,true], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31448) : re_frame.core.dispatch.call(null,G__31448));

break;
default:
return null;

}
});
redgenes.components.idresolver.views.key_up_handler = (function redgenes$components$idresolver$views$key_up_handler(e){
var G__31453 = e.keyIdentifier;
switch (G__31453) {
case "Control":
var G__31454 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_toggle_DASH_select_DASH_multi,false], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31454) : re_frame.core.dispatch.call(null,G__31454));

break;
case "Shift":
var G__31455 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_toggle_DASH_select_DASH_range,false], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31455) : re_frame.core.dispatch.call(null,G__31455));

break;
default:
return null;

}
});
redgenes.components.idresolver.views.attach_body_events = (function redgenes$components$idresolver$views$attach_body_events(){
dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(document.body,cljs.core.array_seq([cljs.core.cst$kw$keypress,redgenes.components.idresolver.views.delete_selected_handler], 0));

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(document.body,cljs.core.array_seq([cljs.core.cst$kw$keypress,redgenes.components.idresolver.views.delete_selected_handler], 0));

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(document.body,cljs.core.array_seq([cljs.core.cst$kw$keydown,redgenes.components.idresolver.views.key_down_handler], 0));

dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(document.body,cljs.core.array_seq([cljs.core.cst$kw$keydown,redgenes.components.idresolver.views.key_down_handler], 0));

dommy.core.unlisten_BANG_.cljs$core$IFn$_invoke$arity$variadic(document.body,cljs.core.array_seq([cljs.core.cst$kw$keyup,redgenes.components.idresolver.views.key_up_handler], 0));

return dommy.core.listen_BANG_.cljs$core$IFn$_invoke$arity$variadic(document.body,cljs.core.array_seq([cljs.core.cst$kw$keyup,redgenes.components.idresolver.views.key_up_handler], 0));
});
redgenes.components.idresolver.views.preview = (function redgenes$components$idresolver$views$preview(result_count){
var results_preview = (function (){var G__31460 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_results_DASH_preview], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31460) : re_frame.core.subscribe.call(null,G__31460));
})();
var fetching_preview_QMARK_ = (function (){var G__31461 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_fetching_DASH_preview_QMARK_], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31461) : re_frame.core.subscribe.call(null,G__31461));
})();
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h4$title,"Results preview:",new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$small$pull_DASH_right,"Showing ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$count,(function (){var x__7559__auto__ = (5);
var y__7560__auto__ = result_count;
return ((x__7559__auto__ < y__7560__auto__) ? x__7559__auto__ : y__7560__auto__);
})()], null)," of ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$span$count,result_count], null)," Total Good Identifiers. ",(((result_count > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (results_preview,fetching_preview_QMARK_){
return (function (){
var G__31462 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_analyse,true], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31462) : re_frame.core.dispatch.call(null,G__31462));
});})(results_preview,fetching_preview_QMARK_))
], null),"View all >>"], null):null)], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.ui.results_preview.preview_table,cljs.core.cst$kw$loading_QMARK_,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(fetching_preview_QMARK_) : cljs.core.deref.call(null,fetching_preview_QMARK_)),cljs.core.cst$kw$query_DASH_results,(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(results_preview) : cljs.core.deref.call(null,results_preview))], null)], null);
});
redgenes.components.idresolver.views.main = (function redgenes$components$idresolver$views$main(){
return reagent.core.create_class(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$component_DASH_did_DASH_mount,redgenes.components.idresolver.views.attach_body_events,cljs.core.cst$kw$reagent_DASH_render,(function (){
var bank = (function (){var G__31466 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_bank], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31466) : re_frame.core.subscribe.call(null,G__31466));
})();
var no_matches = (function (){var G__31467 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_results_DASH_no_DASH_matches], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__31467) : re_frame.core.subscribe.call(null,G__31467));
})();
var result_count = (cljs.core.count((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(bank) : cljs.core.deref.call(null,bank))) - cljs.core.count((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(no_matches) : cljs.core.deref.call(null,no_matches))));
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$container$idresolverupload,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div$headerwithguidance,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$h1,"List Upload"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a$guidance,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$on_DASH_click,((function (bank,no_matches,result_count){
return (function (){
var G__31468 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_example,redgenes.components.idresolver.views.splitter], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__31468) : re_frame.core.dispatch.call(null,G__31468));
});})(bank,no_matches,result_count))
], null),"[Show me an example]"], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.input_div], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.stats], null),(((result_count > (0)))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.idresolver.views.preview,result_count], null):null)], null);
})], null));
});
