// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.components.idresolver.events');
goog.require('cljs.core');
goog.require('com.rpl.specter');
goog.require('redgenes.db');
goog.require('imcljs.fetch');
goog.require('imcljsold.search');
goog.require('clojure.zip');
goog.require('imcljsold.idresolver');
goog.require('cljs.core.async');
goog.require('imcljsold.filters');
goog.require('accountant.core');
goog.require('re_frame.core');
redgenes.components.idresolver.events.ns__GT_kw = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.keyword,cljs.core.namespace);
/**
 * returns either the currently selected object-type or the default if none has been selected
 */
redgenes.components.idresolver.events.get_object_type = (function redgenes$components$idresolver$events$get_object_type(db){
var object_type = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected_DASH_object_DASH_type], null));
var object_type_default = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$current_DASH_mine),cljs.core.cst$kw$default_DASH_selected_DASH_object_DASH_type], null));
if(cljs.core.some_QMARK_(object_type)){
return object_type;
} else {
return object_type_default;
}
});
/**
 * returns either the currently selected organism or the default if none has been selected
 */
redgenes.components.idresolver.events.get_organism_type = (function redgenes$components$idresolver$events$get_organism_type(db){
var organism = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected_DASH_organism,cljs.core.cst$kw$shortName], null));
if(cljs.core.some_QMARK_(organism)){
return organism;
} else {
return cljs.core.cst$kw$any;
}
});
/**
 * Dissociates an entry from a nested associative structure returning a new
 *   nested structure. keys is a sequence of keys. Any empty maps that result
 *   will not be present in the new structure.
 */
redgenes.components.idresolver.events.dissoc_in = (function redgenes$components$idresolver$events$dissoc_in(m,p__30968){
var vec__30972 = p__30968;
var seq__30973 = cljs.core.seq(vec__30972);
var first__30974 = cljs.core.first(seq__30973);
var seq__30973__$1 = cljs.core.next(seq__30973);
var k = first__30974;
var ks = seq__30973__$1;
var keys = vec__30972;
if(ks){
var temp__6751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(temp__6751__auto__)){
var nextmap = temp__6751__auto__;
var newmap = (redgenes.components.idresolver.events.dissoc_in.cljs$core$IFn$_invoke$arity$2 ? redgenes.components.idresolver.events.dissoc_in.cljs$core$IFn$_invoke$arity$2(nextmap,ks) : redgenes.components.idresolver.events.dissoc_in.call(null,nextmap,ks));
if(cljs.core.seq(newmap)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,newmap);
} else {
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
}
} else {
return m;
}
} else {
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(m,k);
}
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$handle_DASH_id,(function (p__30975,p__30976){
var map__30977 = p__30975;
var map__30977__$1 = ((((!((map__30977 == null)))?((((map__30977.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30977.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30977):map__30977);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30977__$1,cljs.core.cst$kw$db);
var vec__30978 = p__30976;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30978,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30978,(1),null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,(function (){var map__30982 = id;
var map__30982__$1 = ((((!((map__30982 == null)))?((((map__30982.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30982.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30982):map__30982);
var map__30983 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30982__$1,cljs.core.cst$kw$matches);
var map__30983__$1 = ((((!((map__30983 == null)))?((((map__30983.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30983.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30983):map__30983);
var resolved = map__30983__$1;
var MATCH = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30983__$1,cljs.core.cst$kw$MATCH);
var TYPE_CONVERTED = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30983__$1,cljs.core.cst$kw$TYPE_CONVERTED);
var OTHER = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30983__$1,cljs.core.cst$kw$OTHER);
var WILDCARD = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30983__$1,cljs.core.cst$kw$WILDCARD);
var DUPLICATE = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30983__$1,cljs.core.cst$kw$DUPLICATE);
var unresolved = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30982__$1,cljs.core.cst$kw$unresolved);
var tagged = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.empty_QMARK_,cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(((function (map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,map__30977,map__30977__$1,db,vec__30978,_,id){
return (function (p__30986){
var vec__30987 = p__30986;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30987,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30987,(1),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (vec__30987,k,v,map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,map__30977,map__30977__$1,db,vec__30978,_,id){
return (function (r){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(r,cljs.core.cst$kw$status,k);
});})(vec__30987,k,v,map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,map__30977,map__30977__$1,db,vec__30978,_,id))
,v);
});})(map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,map__30977,map__30977__$1,db,vec__30978,_,id))
,cljs.core.array_seq([resolved], 0)));
var tagged_un = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,tagged,map__30977,map__30977__$1,db,vec__30978,_,id){
return (function (total,next){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(total,next,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$input,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [next], null),cljs.core.cst$kw$status,cljs.core.cst$kw$UNRESOLVED], null));
});})(map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,tagged,map__30977,map__30977__$1,db,vec__30978,_,id))
,cljs.core.PersistentArrayMap.EMPTY,unresolved);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$results], null),((function (map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,tagged,tagged_un,map__30977,map__30977__$1,db,vec__30978,_,id){
return (function (results){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([tagged_un,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,tagged,tagged_un,map__30977,map__30977__$1,db,vec__30978,_,id){
return (function (total,next_id){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([total,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,tagged,tagged_un,map__30977,map__30977__$1,db,vec__30978,_,id){
return (function (n,next_input){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(n,next_input,next_id);
});})(map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,tagged,tagged_un,map__30977,map__30977__$1,db,vec__30978,_,id))
,cljs.core.PersistentArrayMap.EMPTY,((cljs.core.vector_QMARK_(cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(next_id)))?cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(next_id):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(next_id)], null)))], 0));
});})(map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,tagged,tagged_un,map__30977,map__30977__$1,db,vec__30978,_,id))
,results,tagged)], 0));
});})(map__30982,map__30982__$1,map__30983,map__30983__$1,resolved,MATCH,TYPE_CONVERTED,OTHER,WILDCARD,DUPLICATE,unresolved,tagged,tagged_un,map__30977,map__30977__$1,db,vec__30978,_,id))
);
})(),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_analyse,false], null)], null);
}));
var G__30990_31014 = cljs.core.cst$kw$idresolver_SLASH_resolve_DASH_id;
var G__30991_31015 = ((function (G__30990_31014){
return (function (p__30992){
var vec__30993 = p__30992;
var ids = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30993,(0),null);
var service = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30993,(1),null);
var db = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30993,(2),null);
var organism = redgenes.components.idresolver.events.get_organism_type(db);
var object_type = redgenes.components.idresolver.events.get_object_type(db);
var job = imcljsold.idresolver.resolve(service,(function (){var G__30996 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$identifiers,((cljs.core.seq(ids))?ids:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ids], null)),cljs.core.cst$kw$type,object_type], null);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(organism,cljs.core.cst$kw$any)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__30996,cljs.core.cst$kw$extra,organism);
} else {
return G__30996;
}
})());
var c__14702__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14702__auto__,organism,object_type,job,vec__30993,ids,service,db,G__30990_31014){
return (function (){
var f__14703__auto__ = (function (){var switch__14623__auto__ = ((function (c__14702__auto__,organism,object_type,job,vec__30993,ids,service,db,G__30990_31014){
return (function (state_31004){
var state_val_31005 = (state_31004[(1)]);
if((state_val_31005 === (1))){
var inst_30997 = cljs.core.PersistentVector.EMPTY_NODE;
var state_31004__$1 = (function (){var statearr_31006 = state_31004;
(statearr_31006[(7)] = inst_30997);

return statearr_31006;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31004__$1,(2),job);
} else {
if((state_val_31005 === (2))){
var inst_30997 = (state_31004[(7)]);
var inst_30999 = (state_31004[(2)]);
var inst_31000 = [cljs.core.cst$kw$handle_DASH_id,inst_30999];
var inst_31001 = (new cljs.core.PersistentVector(null,2,(5),inst_30997,inst_31000,null));
var inst_31002 = (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(inst_31001) : re_frame.core.dispatch.call(null,inst_31001));
var state_31004__$1 = state_31004;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31004__$1,inst_31002);
} else {
return null;
}
}
});})(c__14702__auto__,organism,object_type,job,vec__30993,ids,service,db,G__30990_31014))
;
return ((function (switch__14623__auto__,c__14702__auto__,organism,object_type,job,vec__30993,ids,service,db,G__30990_31014){
return (function() {
var redgenes$components$idresolver$events$state_machine__14624__auto__ = null;
var redgenes$components$idresolver$events$state_machine__14624__auto____0 = (function (){
var statearr_31010 = [null,null,null,null,null,null,null,null];
(statearr_31010[(0)] = redgenes$components$idresolver$events$state_machine__14624__auto__);

(statearr_31010[(1)] = (1));

return statearr_31010;
});
var redgenes$components$idresolver$events$state_machine__14624__auto____1 = (function (state_31004){
while(true){
var ret_value__14625__auto__ = (function (){try{while(true){
var result__14626__auto__ = switch__14623__auto__(state_31004);
if(cljs.core.keyword_identical_QMARK_(result__14626__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14626__auto__;
}
break;
}
}catch (e31011){if((e31011 instanceof Object)){
var ex__14627__auto__ = e31011;
var statearr_31012_31016 = state_31004;
(statearr_31012_31016[(5)] = ex__14627__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31004);

return cljs.core.cst$kw$recur;
} else {
throw e31011;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14625__auto__,cljs.core.cst$kw$recur)){
var G__31017 = state_31004;
state_31004 = G__31017;
continue;
} else {
return ret_value__14625__auto__;
}
break;
}
});
redgenes$components$idresolver$events$state_machine__14624__auto__ = function(state_31004){
switch(arguments.length){
case 0:
return redgenes$components$idresolver$events$state_machine__14624__auto____0.call(this);
case 1:
return redgenes$components$idresolver$events$state_machine__14624__auto____1.call(this,state_31004);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
redgenes$components$idresolver$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$0 = redgenes$components$idresolver$events$state_machine__14624__auto____0;
redgenes$components$idresolver$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$1 = redgenes$components$idresolver$events$state_machine__14624__auto____1;
return redgenes$components$idresolver$events$state_machine__14624__auto__;
})()
;})(switch__14623__auto__,c__14702__auto__,organism,object_type,job,vec__30993,ids,service,db,G__30990_31014))
})();
var state__14704__auto__ = (function (){var statearr_31013 = (f__14703__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14703__auto__.cljs$core$IFn$_invoke$arity$0() : f__14703__auto__.call(null));
(statearr_31013[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14702__auto__);

return statearr_31013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14704__auto__);
});})(c__14702__auto__,organism,object_type,job,vec__30993,ids,service,db,G__30990_31014))
);

return c__14702__auto__;
});})(G__30990_31014))
;
(re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2(G__30990_31014,G__30991_31015) : re_frame.core.reg_fx.call(null,G__30990_31014,G__30991_31015));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_resolve,(function (p__31018,p__31019){
var map__31020 = p__31018;
var map__31020__$1 = ((((!((map__31020 == null)))?((((map__31020.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31020.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31020):map__31020);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31020__$1,cljs.core.cst$kw$db);
var vec__31021 = p__31019;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31021,(0),null);
var ids = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31021,(1),null);
var service = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$current_DASH_mine),cljs.core.cst$kw$service], null));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$resolving_QMARK_], null),true),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$bank], null),((function (service,map__31020,map__31020__$1,db,vec__31021,_,ids){
return (function (bank){
return cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (service,map__31020,map__31020__$1,db,vec__31021,_,ids){
return (function (total,next){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(total,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$input,next,cljs.core.cst$kw$status,cljs.core.cst$kw$inactive], null));
});})(service,map__31020,map__31020__$1,db,vec__31021,_,ids))
,bank,ids));
});})(service,map__31020,map__31020__$1,db,vec__31021,_,ids))
),cljs.core.cst$kw$idresolver_SLASH_resolve_DASH_id,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [ids,service,db], null)], null);
}));
redgenes.components.idresolver.events.toggle_into_collection = (function redgenes$components$idresolver$events$toggle_into_collection(coll,val){
var temp__6751__auto__ = cljs.core.some(cljs.core.PersistentHashSet.fromArray([val], true),coll);
if(cljs.core.truth_(temp__6751__auto__)){
var found = temp__6751__auto__;
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(((function (found,temp__6751__auto__){
return (function (p1__31025_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31025_SHARP_,found);
});})(found,temp__6751__auto__))
,coll);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,val);
}
});
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_toggle_DASH_selected,(function (db,p__31026){
var vec__31027 = p__31026;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31027,(0),null);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31027,(1),null);
var multi_select_QMARK_ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$select_DASH_multi], null));
if(cljs.core.truth_(multi_select_QMARK_)){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected], null),redgenes.components.idresolver.events.toggle_into_collection,id);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.first(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected], null))))){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected], null),cljs.core.PersistentVector.EMPTY);
} else {
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [id], null));
}
}
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_remove_DASH_from_DASH_bank,(function (db,p__31030){
var vec__31031 = p__31030;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31031,(0),null);
var selected = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31031,(1),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$bank], null),cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (vec__31031,_,selected){
return (function (total,next){
if(!(cljs.core.some_QMARK_(cljs.core.some(cljs.core.PersistentHashSet.fromArray([cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(next)], true),selected)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(total,next);
} else {
return total;
}
});})(vec__31031,_,selected))
,cljs.core.PersistentVector.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$bank], null))));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_remove_DASH_from_DASH_results,(function (db,p__31034){
var vec__31035 = p__31034;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31035,(0),null);
var selected = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31035,(1),null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$results], null),cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.apply,cljs.core.dissoc),selected);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_delete_DASH_selected,(function (p__31038){
var map__31039 = p__31038;
var map__31039__$1 = ((((!((map__31039 == null)))?((((map__31039.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31039.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31039):map__31039);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31039__$1,cljs.core.cst$kw$db);
var selected = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected], null));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected], null),cljs.core.List.EMPTY),cljs.core.cst$kw$dispatch_DASH_n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_remove_DASH_from_DASH_bank,selected], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_remove_DASH_from_DASH_results,selected], null)], null)], null);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_clear_DASH_selected,(function (db){
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected], null),cljs.core.List.EMPTY);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_clear,(function (db){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver], null),cljs.core.assoc,cljs.core.cst$kw$bank,null,cljs.core.cst$kw$results,cljs.core.array_seq([null,cljs.core.cst$kw$resolving_QMARK_,false,cljs.core.cst$kw$selected,cljs.core.List.EMPTY], 0));
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_toggle_DASH_select_DASH_multi,(function (db,p__31041){
var vec__31042 = p__31041;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31042,(0),null);
var tf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31042,(1),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$select_DASH_multi], null),tf);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_toggle_DASH_select_DASH_range,(function (db,p__31045){
var vec__31046 = p__31045;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31046,(0),null);
var tf = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31046,(1),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$select_DASH_range], null),tf);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_set_DASH_selected_DASH_organism,(function (db,p__31049){
var vec__31050 = p__31049;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31050,(0),null);
var organism = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31050,(1),null);
return cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected_DASH_organism], null),organism);
}));
redgenes.components.idresolver.events.pull_inputs_from_id_resolver = (function redgenes$components$idresolver$events$pull_inputs_from_id_resolver(db){
var bank = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$bank], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (bank){
return (function (new_idlist,id){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(new_idlist,cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(id));
});})(bank))
,cljs.core.PersistentVector.EMPTY,bank);
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_set_DASH_selected_DASH_object_DASH_type,(function (p__31053,p__31054){
var map__31055 = p__31053;
var map__31055__$1 = ((((!((map__31055 == null)))?((((map__31055.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31055.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31055):map__31055);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31055__$1,cljs.core.cst$kw$db);
var vec__31056 = p__31054;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31056,(0),null);
var object_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31056,(1),null);
var service = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db),cljs.core.cst$kw$service], null));
var ids = redgenes.components.idresolver.events.pull_inputs_from_id_resolver(db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.assoc_in(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected_DASH_object_DASH_type], null),object_type),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$bank], null),null),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_resolve,ids], null)], null);
}));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_save_DASH_results,(function (p__31060){
var map__31061 = p__31060;
var map__31061__$1 = ((((!((map__31061 == null)))?((((map__31061.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31061.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31061):map__31061);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31061__$1,cljs.core.cst$kw$db);
var ids = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__31061,map__31061__$1,db){
return (function (p__31063){
var vec__31064 = p__31063;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31064,(0),null);
var map__31067 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31064,(1),null);
var map__31067__$1 = ((((!((map__31067 == null)))?((((map__31067.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31067.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31067):map__31067);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31067__$1,cljs.core.cst$kw$id);
return id;
});})(map__31061,map__31061__$1,db))
,cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$idresolver.cljs$core$IFn$_invoke$arity$1(db))));
var results = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$sd_SLASH_type,cljs.core.cst$kw$query,cljs.core.cst$kw$sd_SLASH_service,cljs.core.cst$kw$flymine,cljs.core.cst$kw$sd_SLASH_label,[cljs.core.str("Uploaded "),cljs.core.str(cljs.core.count(ids)),cljs.core.str(" Genes")].join(''),cljs.core.cst$kw$sd_SLASH_value,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$from,"Gene",cljs.core.cst$kw$title,[cljs.core.str("Uploaded "),cljs.core.str(cljs.core.count(ids)),cljs.core.str(" Genes")].join(''),cljs.core.cst$kw$select,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$summary_DASH_fields,cljs.core.cst$kw$Gene], null)),cljs.core.cst$kw$where,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$path,"Gene.id",cljs.core.cst$kw$op,"ONE OF",cljs.core.cst$kw$values,ids], null)], null)], null)], null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$save_DASH_data,results], null)], null);
}));
/**
 * Returns IDs from the idresolver data set. straight matches have an id at a lower level than the converted and duplicate types so we need to do some deep digging. Right now if the user doesn't choose an option for the duplicate, we automatically serve up the first one in all future lists.
 */
redgenes.components.idresolver.events.pull_ids_from_idresolver = (function redgenes$components$idresolver$events$pull_ids_from_idresolver(results){
return cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__31075){
var vec__31076 = p__31075;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31076,(0),null);
var map__31079 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31076,(1),null);
var map__31079__$1 = ((((!((map__31079 == null)))?((((map__31079.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31079.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31079):map__31079);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31079__$1,cljs.core.cst$kw$id);
var matches = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31079__$1,cljs.core.cst$kw$matches);
if(cljs.core.some_QMARK_(id)){
return id;
} else {
return cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(cljs.core.first(matches));
}
}),results));
});
/**
 * Builds the structure for the preview results query, given a set of successfully identified IDs
 */
redgenes.components.idresolver.events.build_query = (function redgenes$components$idresolver$events$build_query(ids,object_type,summary_fields){
var object_type__$1 = cljs.core.name(object_type);
var plural_QMARK_ = (cljs.core.count(ids) > (1));
var label = [cljs.core.str("Uploaded "),cljs.core.str(cljs.core.count(ids)),cljs.core.str(" "),cljs.core.str(object_type__$1),cljs.core.str(((plural_QMARK_)?"s":null))].join('');
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$type,cljs.core.cst$kw$query,cljs.core.cst$kw$label,label,cljs.core.cst$kw$value,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$title,label,cljs.core.cst$kw$from,object_type__$1,cljs.core.cst$kw$select,summary_fields,cljs.core.cst$kw$where,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$path,[cljs.core.str(object_type__$1),cljs.core.str(".id")].join(''),cljs.core.cst$kw$op,"ONE OF",cljs.core.cst$kw$values,ids], null)], null)], null)], null);
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_analyse,(function (p__31081,p__31082){
var map__31083 = p__31081;
var map__31083__$1 = ((((!((map__31083 == null)))?((((map__31083.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31083.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31083):map__31083);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31083__$1,cljs.core.cst$kw$db);
var vec__31084 = p__31082;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31084,(0),null);
var navigate_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31084,(1),null);
var uid = [cljs.core.str(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0())].join('');
var ids = redgenes.components.idresolver.events.pull_ids_from_idresolver(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$idresolver.cljs$core$IFn$_invoke$arity$1(db)));
var current_mine = cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db);
var object_type = redgenes.components.idresolver.events.get_object_type(db);
var summary_fields = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$assets,cljs.core.cst$kw$summary_DASH_fields,current_mine,object_type], null));
var results = redgenes.components.idresolver.events.build_query(ids,object_type,summary_fields);
var G__31088 = cljs.core.PersistentArrayMap.EMPTY;
var G__31088__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31088,cljs.core.cst$kw$dispatch_DASH_n,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$results_SLASH_set_DASH_query,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$source,cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,cljs.core.cst$kw$current_DASH_mine),cljs.core.cst$kw$type,cljs.core.cst$kw$query,cljs.core.cst$kw$value,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(results)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_fetch_DASH_preview,results], null)], null))
;
if(cljs.core.truth_(navigate_QMARK_)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31088__$1,cljs.core.cst$kw$navigate,[cljs.core.str("results")].join(''));
} else {
return G__31088__$1;
}
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_resolve_DASH_duplicate,(function (db,p__31089){
var vec__31090 = p__31089;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31090,(0),null);
var input = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31090,(1),null);
var result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31090,(2),null);
var symbol = cljs.core.cst$kw$symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$summary.cljs$core$IFn$_invoke$arity$1(result));
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(redgenes.components.idresolver.events.dissoc_in(cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$results,symbol], null),cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(result,cljs.core.cst$kw$input,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [symbol], null),cljs.core.array_seq([cljs.core.cst$kw$status,cljs.core.cst$kw$MATCH], 0))),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$results,input], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$bank], null),((function (symbol,vec__31090,_,input,result){
return (function (bank){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (symbol,vec__31090,_,input,result){
return (function (next){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(input,cljs.core.cst$kw$input.cljs$core$IFn$_invoke$arity$1(next))){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$input,symbol,cljs.core.cst$kw$status,cljs.core.cst$kw$inactive], null);
} else {
return next;
}
});})(symbol,vec__31090,_,input,result))
,bank);
});})(symbol,vec__31090,_,input,result))
);
}));
re_frame.core.reg_event_db.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_store_DASH_results_DASH_preview,(function (db,p__31093){
var vec__31094 = p__31093;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31094,(0),null);
var results = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31094,(1),null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver], null),cljs.core.assoc,cljs.core.cst$kw$results_DASH_preview,results,cljs.core.cst$kw$fetching_DASH_preview_QMARK_,cljs.core.array_seq([false], 0));
}));
var G__31097_31116 = cljs.core.cst$kw$idresolver_SLASH_pipe_DASH_preview;
var G__31098_31117 = ((function (G__31097_31116){
return (function (preview_chan){
var c__14702__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__14702__auto__,G__31097_31116){
return (function (){
var f__14703__auto__ = (function (){var switch__14623__auto__ = ((function (c__14702__auto__,G__31097_31116){
return (function (state_31106){
var state_val_31107 = (state_31106[(1)]);
if((state_val_31107 === (1))){
var inst_31099 = cljs.core.PersistentVector.EMPTY_NODE;
var state_31106__$1 = (function (){var statearr_31108 = state_31106;
(statearr_31108[(7)] = inst_31099);

return statearr_31108;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31106__$1,(2),preview_chan);
} else {
if((state_val_31107 === (2))){
var inst_31099 = (state_31106[(7)]);
var inst_31101 = (state_31106[(2)]);
var inst_31102 = [cljs.core.cst$kw$idresolver_SLASH_store_DASH_results_DASH_preview,inst_31101];
var inst_31103 = (new cljs.core.PersistentVector(null,2,(5),inst_31099,inst_31102,null));
var inst_31104 = (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(inst_31103) : re_frame.core.dispatch.call(null,inst_31103));
var state_31106__$1 = state_31106;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31106__$1,inst_31104);
} else {
return null;
}
}
});})(c__14702__auto__,G__31097_31116))
;
return ((function (switch__14623__auto__,c__14702__auto__,G__31097_31116){
return (function() {
var redgenes$components$idresolver$events$state_machine__14624__auto__ = null;
var redgenes$components$idresolver$events$state_machine__14624__auto____0 = (function (){
var statearr_31112 = [null,null,null,null,null,null,null,null];
(statearr_31112[(0)] = redgenes$components$idresolver$events$state_machine__14624__auto__);

(statearr_31112[(1)] = (1));

return statearr_31112;
});
var redgenes$components$idresolver$events$state_machine__14624__auto____1 = (function (state_31106){
while(true){
var ret_value__14625__auto__ = (function (){try{while(true){
var result__14626__auto__ = switch__14623__auto__(state_31106);
if(cljs.core.keyword_identical_QMARK_(result__14626__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__14626__auto__;
}
break;
}
}catch (e31113){if((e31113 instanceof Object)){
var ex__14627__auto__ = e31113;
var statearr_31114_31118 = state_31106;
(statearr_31114_31118[(5)] = ex__14627__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_31106);

return cljs.core.cst$kw$recur;
} else {
throw e31113;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__14625__auto__,cljs.core.cst$kw$recur)){
var G__31119 = state_31106;
state_31106 = G__31119;
continue;
} else {
return ret_value__14625__auto__;
}
break;
}
});
redgenes$components$idresolver$events$state_machine__14624__auto__ = function(state_31106){
switch(arguments.length){
case 0:
return redgenes$components$idresolver$events$state_machine__14624__auto____0.call(this);
case 1:
return redgenes$components$idresolver$events$state_machine__14624__auto____1.call(this,state_31106);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
redgenes$components$idresolver$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$0 = redgenes$components$idresolver$events$state_machine__14624__auto____0;
redgenes$components$idresolver$events$state_machine__14624__auto__.cljs$core$IFn$_invoke$arity$1 = redgenes$components$idresolver$events$state_machine__14624__auto____1;
return redgenes$components$idresolver$events$state_machine__14624__auto__;
})()
;})(switch__14623__auto__,c__14702__auto__,G__31097_31116))
})();
var state__14704__auto__ = (function (){var statearr_31115 = (f__14703__auto__.cljs$core$IFn$_invoke$arity$0 ? f__14703__auto__.cljs$core$IFn$_invoke$arity$0() : f__14703__auto__.call(null));
(statearr_31115[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__14702__auto__);

return statearr_31115;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__14704__auto__);
});})(c__14702__auto__,G__31097_31116))
);

return c__14702__auto__;
});})(G__31097_31116))
;
(re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2(G__31097_31116,G__31098_31117) : re_frame.core.reg_fx.call(null,G__31097_31116,G__31098_31117));
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_fetch_DASH_preview,(function (p__31120,p__31121){
var map__31122 = p__31120;
var map__31122__$1 = ((((!((map__31122 == null)))?((((map__31122.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31122.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31122):map__31122);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31122__$1,cljs.core.cst$kw$db);
var vec__31123 = p__31121;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31123,(0),null);
var query = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31123,(1),null);
var mine = cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db);
var service = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,mine,cljs.core.cst$kw$service], null));
var count_chan = imcljs.fetch.table_rows.cljs$core$IFn$_invoke$arity$variadic(service,cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(query),cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(5)], null)], 0));
var new_db = cljs.core.update_in.cljs$core$IFn$_invoke$arity$variadic(db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver], null),cljs.core.assoc,cljs.core.cst$kw$preview_DASH_chan,count_chan,cljs.core.cst$kw$fetching_DASH_preview_QMARK_,cljs.core.array_seq([true], 0));
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,new_db,cljs.core.cst$kw$idresolver_SLASH_pipe_DASH_preview,count_chan], null);
}));
/**
 * Fallback for scenarios where soem one's using the id resolver nd it's not well configured
 */
redgenes.components.idresolver.events.get_default_example = (function redgenes$components$idresolver$events$get_default_example(db){
var current_mine = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db)], null));
var object_type_default = cljs.core.cst$kw$default_DASH_selected_DASH_object_DASH_type.cljs$core$IFn$_invoke$arity$1(current_mine);
var examples = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(current_mine,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_DASH_example], null));
var example_text_default = (object_type_default.cljs$core$IFn$_invoke$arity$1 ? object_type_default.cljs$core$IFn$_invoke$arity$1(examples) : object_type_default.call(null,examples));
var use_default_QMARK_ = cljs.core.some_QMARK_(example_text_default);
var any_example_type = cljs.core.first(cljs.core.keys(examples));
var any_example_text = (any_example_type.cljs$core$IFn$_invoke$arity$1 ? any_example_type.cljs$core$IFn$_invoke$arity$1(examples) : any_example_type.call(null,examples));
var example_keys = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$selected_DASH_object_DASH_type], null);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,(function (){var G__31128 = cljs.core.assoc_in(db,example_keys,any_example_type);
if(use_default_QMARK_){
return cljs.core.assoc_in(G__31128,example_keys,object_type_default);
} else {
return G__31128;
}
})(),cljs.core.cst$kw$text,((use_default_QMARK_)?example_text_default:any_example_text)], null);
});
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$idresolver_SLASH_example,(function (p__31129,p__31130){
var map__31131 = p__31129;
var map__31131__$1 = ((((!((map__31131 == null)))?((((map__31131.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__31131.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__31131):map__31131);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31131__$1,cljs.core.cst$kw$db);
var vec__31132 = p__31130;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31132,(0),null);
var splitter = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31132,(1),null);
var current_mine = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$mines,cljs.core.cst$kw$current_DASH_mine.cljs$core$IFn$_invoke$arity$1(db)], null));
var object_type = redgenes.components.idresolver.events.get_object_type(db);
var cleared_db = cljs.core.assoc_in(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver,cljs.core.cst$kw$bank], null),cljs.core.PersistentVector.EMPTY);
var examples = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(current_mine,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_DASH_example], null));
var example_text = (object_type.cljs$core$IFn$_invoke$arity$1 ? object_type.cljs$core$IFn$_invoke$arity$1(examples) : object_type.call(null,examples));
if(cljs.core.some_QMARK_(example_text)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cleared_db,cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_resolve,(splitter.cljs$core$IFn$_invoke$arity$1 ? splitter.cljs$core$IFn$_invoke$arity$1(example_text) : splitter.call(null,example_text))], null)], null);
} else {
var fallback_example = redgenes.components.idresolver.events.get_default_example(cleared_db);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$db,cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(fallback_example),cljs.core.cst$kw$dispatch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$idresolver_SLASH_resolve,(function (){var G__31136 = cljs.core.cst$kw$text.cljs$core$IFn$_invoke$arity$1(fallback_example);
return (splitter.cljs$core$IFn$_invoke$arity$1 ? splitter.cljs$core$IFn$_invoke$arity$1(G__31136) : splitter.call(null,G__31136));
})()], null)], null);
}
}));
