// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('day8.re_frame.async_flow_fx');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('clojure.set');
goog.require('day8.re_frame.forward_events_fx');
day8.re_frame.async_flow_fx.seen_all_of_QMARK_ = (function day8$re_frame$async_flow_fx$seen_all_of_QMARK_(required_events,seen_events){
return cljs.core.empty_QMARK_(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(required_events,seen_events));
});
day8.re_frame.async_flow_fx.seen_any_of_QMARK_ = (function day8$re_frame$async_flow_fx$seen_any_of_QMARK_(required_events,seen_events){
return cljs.core.some_QMARK_(cljs.core.seq(clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(seen_events,required_events)));
});
/**
 * Given the accumulated set of seen events and the set of rules already started,
 *   return the list of rules which should now be started
 */
day8.re_frame.async_flow_fx.startable_rules = (function day8$re_frame$async_flow_fx$startable_rules(rules,now_seen_events,rules_fired){
return cljs.core.filterv((function (task){
return cljs.core.cst$kw$when.cljs$core$IFn$_invoke$arity$1(task).call(null,cljs.core.cst$kw$events.cljs$core$IFn$_invoke$arity$1(task),now_seen_events);
}),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(rules_fired,cljs.core.cst$kw$id),rules));
});
day8.re_frame.async_flow_fx.map_when__GT_fn = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$seen_QMARK_,day8.re_frame.async_flow_fx.seen_all_of_QMARK_,cljs.core.cst$kw$seen_DASH_both_QMARK_,day8.re_frame.async_flow_fx.seen_all_of_QMARK_,cljs.core.cst$kw$seen_DASH_all_DASH_of_QMARK_,day8.re_frame.async_flow_fx.seen_all_of_QMARK_,cljs.core.cst$kw$seen_DASH_any_DASH_of_QMARK_,day8.re_frame.async_flow_fx.seen_any_of_QMARK_], null);
day8.re_frame.async_flow_fx.when__GT_fn = (function day8$re_frame$async_flow_fx$when__GT_fn(when_kw){
var temp__6751__auto__ = (day8.re_frame.async_flow_fx.map_when__GT_fn.cljs$core$IFn$_invoke$arity$1 ? day8.re_frame.async_flow_fx.map_when__GT_fn.cljs$core$IFn$_invoke$arity$1(when_kw) : day8.re_frame.async_flow_fx.map_when__GT_fn.call(null,when_kw));
if(cljs.core.truth_(temp__6751__auto__)){
var when_fn = temp__6751__auto__;
return when_fn;
} else {
var G__30247 = cljs.core.cst$kw$error;
var G__30248 = "async-flow: got bad value for :when - ";
var G__30249 = when_kw;
return (re_frame.core.console.cljs$core$IFn$_invoke$arity$3 ? re_frame.core.console.cljs$core$IFn$_invoke$arity$3(G__30247,G__30248,G__30249) : re_frame.core.console.call(null,G__30247,G__30248,G__30249));
}
});
/**
 * Massage the supplied rules as follows:
 *  - replace `:when` keyword value with a function implementing the predicate
 *  - ensure that only `:dispatch` or `:dispatch-n` is provided
 *  - add a unique :id, if one not already present
 */
day8.re_frame.async_flow_fx.massage_rules = (function day8$re_frame$async_flow_fx$massage_rules(rules){
return cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (index,p__30256){
var map__30257 = p__30256;
var map__30257__$1 = ((((!((map__30257 == null)))?((((map__30257.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30257.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30257):map__30257);
var rule = map__30257__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30257__$1,cljs.core.cst$kw$id);
var when = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30257__$1,cljs.core.cst$kw$when);
var events = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30257__$1,cljs.core.cst$kw$events);
var dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30257__$1,cljs.core.cst$kw$dispatch);
var dispatch_n = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30257__$1,cljs.core.cst$kw$dispatch_DASH_n);
var halt_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30257__$1,cljs.core.cst$kw$halt_QMARK_);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$id,(function (){var or__7219__auto__ = id;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return index;
}
})(),cljs.core.cst$kw$halt_QMARK_,(function (){var or__7219__auto__ = halt_QMARK_;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$when,day8.re_frame.async_flow_fx.when__GT_fn(when),cljs.core.cst$kw$events,((cljs.core.coll_QMARK_(events))?cljs.core.set(events):cljs.core.PersistentHashSet.fromArray([events],true)),cljs.core.cst$kw$dispatch_DASH_n,(cljs.core.truth_(dispatch_n)?(cljs.core.truth_(dispatch)?(function (){var G__30259 = cljs.core.cst$kw$error;
var G__30260 = "async-flow: rule can only specify one of :dispatch and :dispatch-n. Got both: ";
var G__30261 = rule;
return (re_frame.core.console.cljs$core$IFn$_invoke$arity$3 ? re_frame.core.console.cljs$core$IFn$_invoke$arity$3(G__30259,G__30260,G__30261) : re_frame.core.console.call(null,G__30259,G__30260,G__30261));
})():dispatch_n):(cljs.core.truth_(dispatch)?(function (){var x__8148__auto__ = dispatch;
return cljs.core._conj(cljs.core.List.EMPTY,x__8148__auto__);
})():cljs.core.List.EMPTY
))], null);
}),rules);
});
/**
 * Given a flow definitiion, returns an event handler which implements this definition
 */
day8.re_frame.async_flow_fx.make_flow_event_handler = (function day8$re_frame$async_flow_fx$make_flow_event_handler(p__30262){
var map__30311 = p__30262;
var map__30311__$1 = ((((!((map__30311 == null)))?((((map__30311.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30311.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30311):map__30311);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30311__$1,cljs.core.cst$kw$id);
var db_path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30311__$1,cljs.core.cst$kw$db_DASH_path);
var rules = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30311__$1,cljs.core.cst$kw$rules);
var first_dispatch = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30311__$1,cljs.core.cst$kw$first_DASH_dispatch);
var _ = ((((db_path == null)) || (cljs.core.vector_QMARK_(db_path)))?null:(function(){throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("aync-flow: db-path must be a vector"),cljs.core.str("\n"),cljs.core.str("(or (nil? db-path) (vector? db-path))")].join('')))})());
var local_store = (function (){var G__30313 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__30313) : cljs.core.atom.call(null,G__30313));
})();
var set_state = (cljs.core.truth_(db_path)?((function (_,local_store,map__30311,map__30311__$1,id,db_path,rules,first_dispatch){
return (function (db,seen,started){
return cljs.core.assoc_in(db,db_path,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$seen_DASH_events,seen,cljs.core.cst$kw$rules_DASH_fired,started], null));
});})(_,local_store,map__30311,map__30311__$1,id,db_path,rules,first_dispatch))
:((function (_,local_store,map__30311,map__30311__$1,id,db_path,rules,first_dispatch){
return (function (db,seen,started){
var G__30314_30359 = local_store;
var G__30315_30360 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$seen_DASH_events,seen,cljs.core.cst$kw$rules_DASH_fired,started], null);
(cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__30314_30359,G__30315_30360) : cljs.core.reset_BANG_.call(null,G__30314_30359,G__30315_30360));

return db;
});})(_,local_store,map__30311,map__30311__$1,id,db_path,rules,first_dispatch))
);
var get_state = (cljs.core.truth_(db_path)?((function (_,local_store,set_state,map__30311,map__30311__$1,id,db_path,rules,first_dispatch){
return (function (db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,db_path);
});})(_,local_store,set_state,map__30311,map__30311__$1,id,db_path,rules,first_dispatch))
:((function (_,local_store,set_state,map__30311,map__30311__$1,id,db_path,rules,first_dispatch){
return (function (___$1){
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(local_store) : cljs.core.deref.call(null,local_store));
});})(_,local_store,set_state,map__30311,map__30311__$1,id,db_path,rules,first_dispatch))
);
var rules__$1 = day8.re_frame.async_flow_fx.massage_rules(rules);
return ((function (_,local_store,set_state,get_state,rules__$1,map__30311,map__30311__$1,id,db_path,rules,first_dispatch){
return (function day8$re_frame$async_flow_fx$make_flow_event_handler_$_async_flow_event_hander(p__30316,event_v){
var map__30338 = p__30316;
var map__30338__$1 = ((((!((map__30338 == null)))?((((map__30338.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30338.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30338):map__30338);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30338__$1,cljs.core.cst$kw$db);
var pred__30340 = cljs.core._EQ_;
var expr__30341 = cljs.core.second(event_v);
if(cljs.core.truth_((function (){var G__30343 = cljs.core.cst$kw$setup;
var G__30344 = expr__30341;
return (pred__30340.cljs$core$IFn$_invoke$arity$2 ? pred__30340.cljs$core$IFn$_invoke$arity$2(G__30343,G__30344) : pred__30340.call(null,G__30343,G__30344));
})())){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$db,(function (){var G__30345 = db;
var G__30346 = cljs.core.PersistentHashSet.EMPTY;
var G__30347 = cljs.core.PersistentHashSet.EMPTY;
return (set_state.cljs$core$IFn$_invoke$arity$3 ? set_state.cljs$core$IFn$_invoke$arity$3(G__30345,G__30346,G__30347) : set_state.call(null,G__30345,G__30346,G__30347));
})(),cljs.core.cst$kw$dispatch,first_dispatch,cljs.core.cst$kw$forward_DASH_events,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$register,id,cljs.core.cst$kw$events,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(clojure.set.union,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$events,rules__$1)),cljs.core.cst$kw$dispatch_DASH_to,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [id], null)], null)], null);
} else {
if(cljs.core.truth_((function (){var G__30348 = cljs.core.cst$kw$halt_DASH_flow;
var G__30349 = expr__30341;
return (pred__30340.cljs$core$IFn$_invoke$arity$2 ? pred__30340.cljs$core$IFn$_invoke$arity$2(G__30348,G__30349) : pred__30340.call(null,G__30348,G__30349));
})())){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$forward_DASH_events,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$unregister,id], null),cljs.core.cst$kw$deregister_DASH_event_DASH_handler,id], null);
} else {
var vec__30350 = event_v;
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30350,(0),null);
var vec__30353 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30350,(1),null);
var seq__30354 = cljs.core.seq(vec__30353);
var first__30355 = cljs.core.first(seq__30354);
var seq__30354__$1 = cljs.core.next(seq__30354);
var forwarded_event_id = first__30355;
var args = seq__30354__$1;
var map__30356 = (get_state.cljs$core$IFn$_invoke$arity$1 ? get_state.cljs$core$IFn$_invoke$arity$1(db) : get_state.call(null,db));
var map__30356__$1 = ((((!((map__30356 == null)))?((((map__30356.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__30356.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__30356):map__30356);
var seen_events = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30356__$1,cljs.core.cst$kw$seen_DASH_events);
var rules_fired = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__30356__$1,cljs.core.cst$kw$rules_DASH_fired);
var new_seen_events = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen_events,forwarded_event_id);
var ready_rules = day8.re_frame.async_flow_fx.startable_rules(rules__$1,new_seen_events,rules_fired);
var add_halt_QMARK_ = cljs.core.some(cljs.core.cst$kw$halt_QMARK_,ready_rules);
var ready_rules_ids = cljs.core.set(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$id,ready_rules));
var new_rules_fired = clojure.set.union.cljs$core$IFn$_invoke$arity$2(rules_fired,ready_rules_ids);
var new_dispatches = (function (){var G__30358 = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$dispatch_DASH_n,cljs.core.array_seq([ready_rules], 0));
var G__30358__$1 = (cljs.core.truth_(add_halt_QMARK_)?cljs.core.vec(G__30358):G__30358);
if(cljs.core.truth_(add_halt_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(G__30358__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,cljs.core.cst$kw$halt_DASH_flow], null));
} else {
return G__30358__$1;
}
})();
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$db,(set_state.cljs$core$IFn$_invoke$arity$3 ? set_state.cljs$core$IFn$_invoke$arity$3(db,new_seen_events,new_rules_fired) : set_state.call(null,db,new_seen_events,new_rules_fired))], null),((cljs.core.seq(new_dispatches))?new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$dispatch_DASH_n,new_dispatches], null):null)], 0));
}
}
});
;})(_,local_store,set_state,get_state,rules__$1,map__30311,map__30311__$1,id,db_path,rules,first_dispatch))
});
/**
 * Ensure `flow` has an id.
 * 	Return a vector of [id flow]
 */
day8.re_frame.async_flow_fx.ensure_has_id = (function day8$re_frame$async_flow_fx$ensure_has_id(flow){
var temp__6751__auto__ = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(flow);
if(cljs.core.truth_(temp__6751__auto__)){
var id = temp__6751__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,flow], null);
} else {
var new_id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1([cljs.core.str("async-flow/"),cljs.core.str(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("id-"))].join(''));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new_id,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(flow,cljs.core.cst$kw$id,new_id)], null);
}
});
/**
 * Action the given flow effect
 */
day8.re_frame.async_flow_fx.flow__GT_handler = (function day8$re_frame$async_flow_fx$flow__GT_handler(flow){
var vec__30365 = day8.re_frame.async_flow_fx.ensure_has_id(flow);
var id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30365,(0),null);
var flow_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30365,(1),null);
re_frame.core.reg_event_fx.cljs$core$IFn$_invoke$arity$2(id,day8.re_frame.async_flow_fx.make_flow_event_handler(flow_SINGLEQUOTE_));

var G__30368 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,cljs.core.cst$kw$setup], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__30368) : re_frame.core.dispatch.call(null,G__30368));
});
var G__30369_30371 = cljs.core.cst$kw$async_DASH_flow;
var G__30370_30372 = day8.re_frame.async_flow_fx.flow__GT_handler;
(re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2 ? re_frame.core.reg_fx.cljs$core$IFn$_invoke$arity$2(G__30369_30371,G__30370_30372) : re_frame.core.reg_fx.call(null,G__30369_30371,G__30370_30372));
