// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.sections.saveddata.views.venn');
goog.require('cljs.core');
goog.require('cljs_time.core');
goog.require('reagent.core');
goog.require('redgenes.sections.saveddata.subs');
goog.require('redgenes.sections.saveddata.events');
goog.require('json_html.core');
goog.require('accountant.core');
goog.require('cljs_time.format');
goog.require('inflections.core');
goog.require('clojure.string');
goog.require('re_frame.core');
/**
 * Determines the pair of X and Y coordinates where two circles intersect.
 */
redgenes.sections.saveddata.views.venn.circle_intersections = (function redgenes$sections$saveddata$views$venn$circle_intersections(x0,y0,r0,x1,y1,r1){
var dx = (x1 - x0);
var dy = (y1 - y0);
var d = Math.sqrt(((dy * dy) + (dx * dx)));
var a = ((((r0 * r0) - (r1 * r1)) + (d * d)) / ((2) * d));
var x2 = (x0 + (dx * (a / d)));
var y2 = (y0 + (dy * (a / d)));
var h = Math.sqrt(((r0 * r0) - (a * a)));
var rx = (((-1) * dy) * (h / d));
var ry = (dx * (h / d));
var xi = (x2 + rx);
var xi_prime = (x2 - rx);
var yi = (y2 + ry);
var yi_prime = (y2 - ry);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [xi,xi_prime,yi,yi_prime], null);
});
redgenes.sections.saveddata.views.venn.width = (300);
redgenes.sections.saveddata.views.venn.circle_width = (300);
redgenes.sections.saveddata.views.venn.height = (200);
redgenes.sections.saveddata.views.venn.bracket_width = (10);
redgenes.sections.saveddata.views.venn.bracket_padding = (10);
redgenes.sections.saveddata.views.venn.anchor1 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$x,((.33 * redgenes.sections.saveddata.views.venn.circle_width) - (redgenes.sections.saveddata.views.venn.width / (2))),cljs.core.cst$kw$y,(0)], null);
redgenes.sections.saveddata.views.venn.anchor2 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$x,((.66 * redgenes.sections.saveddata.views.venn.circle_width) - (redgenes.sections.saveddata.views.venn.width / (2))),cljs.core.cst$kw$y,(0)], null);
redgenes.sections.saveddata.views.venn.radius = (.25 * (redgenes.sections.saveddata.views.venn.circle_width - ((2) * redgenes.sections.saveddata.views.venn.bracket_width)));
redgenes.sections.saveddata.views.venn.overlap = (function redgenes$sections$saveddata$views$venn$overlap(){
var selected_QMARK_ = (function (){var G__34079 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data_SLASH_merge_DASH_intersection], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__34079) : re_frame.core.subscribe.call(null,G__34079));
})();
var intersection_points = redgenes.sections.saveddata.views.venn.circle_intersections(cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(redgenes.sections.saveddata.views.venn.anchor1),(0),redgenes.sections.saveddata.views.venn.radius,cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(redgenes.sections.saveddata.views.venn.anchor2),(0),redgenes.sections.saveddata.views.venn.radius);
return ((function (selected_QMARK_,intersection_points){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$path$part,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,(cljs.core.truth_((cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(selected_QMARK_) : cljs.core.deref.call(null,selected_QMARK_)))?"selected":null),cljs.core.cst$kw$d,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, ["M",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(intersection_points,(1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(intersection_points,(3)),"A",redgenes.sections.saveddata.views.venn.radius,redgenes.sections.saveddata.views.venn.radius,(0),(0),(1),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(intersection_points,(0)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(intersection_points,(2)),"A",redgenes.sections.saveddata.views.venn.radius,redgenes.sections.saveddata.views.venn.radius,(0),(0),(1),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(intersection_points,(1)),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(intersection_points,(3)),"Z"], null)),cljs.core.cst$kw$on_DASH_click,((function (selected_QMARK_,intersection_points){
return (function (){
var G__34080 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data_SLASH_toggle_DASH_keep_DASH_intersections], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__34080) : re_frame.core.dispatch.call(null,G__34080));
});})(selected_QMARK_,intersection_points))
], null)], null);
});
;})(selected_QMARK_,intersection_points))
});
redgenes.sections.saveddata.views.venn.left_bracket = (function redgenes$sections$saveddata$views$venn$left_bracket(){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$path,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$stroke,"#808080",cljs.core.cst$kw$fill,"transparent",cljs.core.cst$kw$d,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, ["M",(0),redgenes.sections.saveddata.views.venn.bracket_padding,"L",redgenes.sections.saveddata.views.venn.bracket_width,redgenes.sections.saveddata.views.venn.bracket_padding,"L",redgenes.sections.saveddata.views.venn.bracket_width,(redgenes.sections.saveddata.views.venn.height - redgenes.sections.saveddata.views.venn.bracket_padding),"L",(0),(redgenes.sections.saveddata.views.venn.height - redgenes.sections.saveddata.views.venn.bracket_padding)], null))], null)], null);
});
});
redgenes.sections.saveddata.views.venn.right_bracket = (function redgenes$sections$saveddata$views$venn$right_bracket(){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$path,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$stroke,"#808080",cljs.core.cst$kw$fill,"transparent",cljs.core.cst$kw$d,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, ["M",redgenes.sections.saveddata.views.venn.circle_width,redgenes.sections.saveddata.views.venn.bracket_padding,"L",(redgenes.sections.saveddata.views.venn.circle_width - redgenes.sections.saveddata.views.venn.bracket_width),redgenes.sections.saveddata.views.venn.bracket_padding,"L",(redgenes.sections.saveddata.views.venn.circle_width - redgenes.sections.saveddata.views.venn.bracket_width),(redgenes.sections.saveddata.views.venn.height - redgenes.sections.saveddata.views.venn.bracket_padding),"L",redgenes.sections.saveddata.views.venn.circle_width,(redgenes.sections.saveddata.views.venn.height - redgenes.sections.saveddata.views.venn.bracket_padding)], null))], null)], null);
});
});
redgenes.sections.saveddata.views.venn.top_bracket = (function redgenes$sections$saveddata$views$venn$top_bracket(){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$path,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$stroke,"#808080",cljs.core.cst$kw$fill,"transparent",cljs.core.cst$kw$d,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, ["M",((2) * redgenes.sections.saveddata.views.venn.bracket_padding),(0),"L",((2) * redgenes.sections.saveddata.views.venn.bracket_padding),redgenes.sections.saveddata.views.venn.bracket_padding,"L",(redgenes.sections.saveddata.views.venn.circle_width - ((2) * redgenes.sections.saveddata.views.venn.bracket_padding)),redgenes.sections.saveddata.views.venn.bracket_padding,"L",(redgenes.sections.saveddata.views.venn.circle_width - ((2) * redgenes.sections.saveddata.views.venn.bracket_padding)),(0)], null))], null)], null);
});
});
redgenes.sections.saveddata.views.venn.circ = (function redgenes$sections$saveddata$views$venn$circ(){
return (function (p__34085){
var map__34086 = p__34085;
var map__34086__$1 = ((((!((map__34086 == null)))?((((map__34086.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__34086.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__34086):map__34086);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34086__$1,cljs.core.cst$kw$type);
var path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34086__$1,cljs.core.cst$kw$path);
var keep = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34086__$1,cljs.core.cst$kw$keep);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34086__$1,cljs.core.cst$kw$id);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$circle$part,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,(cljs.core.truth_(cljs.core.cst$kw$self.cljs$core$IFn$_invoke$arity$1(keep))?"selected":null),cljs.core.cst$kw$r,redgenes.sections.saveddata.views.venn.radius,cljs.core.cst$kw$on_DASH_click,((function (map__34086,map__34086__$1,type,path,keep,id){
return (function (x){
var G__34088 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data_SLASH_toggle_DASH_keep,id], null);
return (re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.dispatch.cljs$core$IFn$_invoke$arity$1(G__34088) : re_frame.core.dispatch.call(null,G__34088));
});})(map__34086,map__34086__$1,type,path,keep,id))
], null)], null)], null);
});
});
redgenes.sections.saveddata.views.venn.main = (function redgenes$sections$saveddata$views$venn$main(){
var editable_ids = (function (){var G__34093 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$saved_DASH_data_SLASH_editable_DASH_ids], null);
return (re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1 ? re_frame.core.subscribe.cljs$core$IFn$_invoke$arity$1(G__34093) : re_frame.core.subscribe.call(null,G__34093));
})();
return ((function (editable_ids){
return (function (){
var vec__34094 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((2),(cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(editable_ids) : cljs.core.deref.call(null,editable_ids)));
var item_1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34094,(0),null);
var item_2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34094,(1),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$svg$venn,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$width,redgenes.sections.saveddata.views.venn.width,cljs.core.cst$kw$height,redgenes.sections.saveddata.views.venn.height], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,[cljs.core.str("translate("),cljs.core.str((redgenes.sections.saveddata.views.venn.width / (2))),cljs.core.str(","),cljs.core.str((redgenes.sections.saveddata.views.venn.height / (2))),cljs.core.str(")")].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,[cljs.core.str("translate("),cljs.core.str(cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(redgenes.sections.saveddata.views.venn.anchor1)),cljs.core.str(",0)")].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.saveddata.views.venn.circ,item_1], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$g,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transform,[cljs.core.str("translate("),cljs.core.str(cljs.core.cst$kw$x.cljs$core$IFn$_invoke$arity$1(redgenes.sections.saveddata.views.venn.anchor2)),cljs.core.str(",0)")].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.saveddata.views.venn.circ,item_2], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.saveddata.views.venn.overlap], null)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.saveddata.views.venn.left_bracket], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.sections.saveddata.views.venn.right_bracket], null)], null);
});
;})(editable_ids))
});
