// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('redgenes.components.querybuilder.core');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.tools.reader.edn');
goog.require('cljs.spec');
redgenes.components.querybuilder.core.ops = new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, ["=","!=","CONTAINS","<","<=",">",">=","LIKE","NOT LIKE","ONE OF","NONE OF"], null);
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_op,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, ["!=",null,"=",null,"<=",null,"NONE OF",null,"CONTAINS",null,"NOT LIKE",null,"ONE OF",null,">=",null,"<",null,"LIKE",null,">",null], null), null),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, ["!=",null,"=",null,"<=",null,"NONE OF",null,"CONTAINS",null,"NOT LIKE",null,"ONE OF",null,">=",null,"<",null,"LIKE",null,">",null], null), null));
redgenes.components.querybuilder.core.logicops = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$OR,null,cljs.core.cst$sym$AND,null], null), null);
redgenes.components.querybuilder.core.alphabet = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.char$),cljs.core.take.cljs$core$IFn$_invoke$arity$2((26),cljs.core.iterate(cljs.core.inc,(65))));
redgenes.components.querybuilder.core.alphabet_symbols = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,redgenes.components.querybuilder.core.alphabet);
redgenes.components.querybuilder.core.next_letter = (function redgenes$components$querybuilder$core$next_letter(letter){
return cljs.core.first(cljs.core.rest(cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2((function (n){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(n,letter);
}),redgenes.components.querybuilder.core.alphabet)));
});
redgenes.components.querybuilder.core.alphabet_symbol_QMARK_ = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,redgenes.components.querybuilder.core.alphabet_symbols);
redgenes.components.querybuilder.core.alphabet_QMARK_ = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,redgenes.components.querybuilder.core.alphabet);
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_code,cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_comp,cljs.core.cst$sym$redgenes$components$querybuilder$core_SLASH_alphabet_QMARK_,cljs.core.cst$sym$cljs$core_SLASH_name),cljs.core.comp.cljs$core$IFn$_invoke$arity$2(redgenes.components.querybuilder.core.alphabet_QMARK_,cljs.core.name));
redgenes.components.querybuilder.core.next_code = (function redgenes$components$querybuilder$core$next_code(code){
return redgenes.components.querybuilder.core.next_letter(code);
});
redgenes.components.querybuilder.core.used_codes = (function redgenes$components$querybuilder$core$used_codes(db){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$q_SLASH_code,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_builder,cljs.core.cst$kw$query,cljs.core.cst$kw$q_SLASH_where], null)));
});
redgenes.components.querybuilder.core.where_tree = (function redgenes$components$querybuilder$core$where_tree(p__29342){
var map__29351 = p__29342;
var map__29351__$1 = ((((!((map__29351 == null)))?((((map__29351.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29351.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29351):map__29351);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29351__$1,cljs.core.cst$kw$q_SLASH_where);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (map__29351,map__29351__$1,where){
return (function (r,p__29353){
var vec__29354 = p__29353;
var map__29357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29354,(0),null);
var map__29357__$1 = ((((!((map__29357 == null)))?((((map__29357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29357.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29357):map__29357);
var c = map__29357__$1;
var path = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29357__$1,cljs.core.cst$kw$q_SLASH_path);
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29354,(1),null);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(r,path,((function (vec__29354,map__29357,map__29357__$1,c,path,i,map__29351,map__29351__$1,where){
return (function (z){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__7219__auto__ = z;
if(cljs.core.truth_(or__7219__auto__)){
return or__7219__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cljs.core.cst$kw$index,i));
});})(vec__29354,map__29357,map__29357__$1,c,path,i,map__29351,map__29351__$1,where))
);
});})(map__29351,map__29351__$1,where))
,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,where,cljs.core.range.cljs$core$IFn$_invoke$arity$0()));
});
redgenes.components.querybuilder.core.to_list = (function redgenes$components$querybuilder$core$to_list(s){
return cljs.tools.reader.edn.read_string.cljs$core$IFn$_invoke$arity$1(clojure.string.upper_case(s));
});
redgenes.components.querybuilder.core.maybe_unwrap = (function redgenes$components$querybuilder$core$maybe_unwrap(x){
if(((cljs.core.vector_QMARK_(x)) || (cljs.core.list_QMARK_(x))) && (((1) === cljs.core.count(x)))){
return cljs.core.first(x);
} else {
return x;
}
});
/**
 * 
 *   This is the existing
 *   way the old QB does things
 *   e.g.
 * 
 *   A or B and C or D becomes
 *   A or (B and C) or D
 *   
 */
redgenes.components.querybuilder.core.group_ands = (function redgenes$components$querybuilder$core$group_ands(l){
return redgenes.components.querybuilder.core.maybe_unwrap((((l instanceof cljs.core.Symbol))?l:cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (r,l__$1){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$AND,cljs.core.second(l__$1))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(r,cljs.core.map.cljs$core$IFn$_invoke$arity$2(redgenes.components.querybuilder.core.group_ands,l__$1));
} else {
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(r,cljs.core.map.cljs$core$IFn$_invoke$arity$2(redgenes.components.querybuilder.core.group_ands,l__$1));
}
}),cljs.core.PersistentVector.EMPTY,cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$sym$OR,null], null), null),l))));
});
redgenes.components.querybuilder.core.nested_infix = (function redgenes$components$querybuilder$core$nested_infix(p__29359){
var vec__29363 = p__29359;
var seq__29364 = cljs.core.seq(vec__29363);
var first__29365 = cljs.core.first(seq__29364);
var seq__29364__$1 = cljs.core.next(seq__29364);
var f = first__29365;
var first__29365__$1 = cljs.core.first(seq__29364__$1);
var seq__29364__$2 = cljs.core.next(seq__29364__$1);
var o = first__29365__$1;
var r = seq__29364__$2;
if(r){
var x__8148__auto__ = f;
return cljs.core._conj((function (){var x__8148__auto____$1 = o;
return cljs.core._conj((function (){var x__8148__auto____$2 = (redgenes.components.querybuilder.core.nested_infix.cljs$core$IFn$_invoke$arity$1 ? redgenes.components.querybuilder.core.nested_infix.cljs$core$IFn$_invoke$arity$1(r) : redgenes.components.querybuilder.core.nested_infix.call(null,r));
return cljs.core._conj(cljs.core.List.EMPTY,x__8148__auto____$2);
})(),x__8148__auto____$1);
})(),x__8148__auto__);
} else {
if(cljs.core.truth_(o)){
var x__8148__auto__ = f;
return cljs.core._conj((function (){var x__8148__auto____$1 = o;
return cljs.core._conj(cljs.core.List.EMPTY,x__8148__auto____$1);
})(),x__8148__auto__);
} else {
return f;
}
}
});
/**
 * Returns the prefix representation of the given infix expression
 */
redgenes.components.querybuilder.core.infix_prefix = (function redgenes$components$querybuilder$core$infix_prefix(x){
if((x instanceof cljs.core.Symbol)){
return x;
} else {
return cljs.core.cons(cljs.core.second(x),cljs.core.map.cljs$core$IFn$_invoke$arity$2(redgenes.components.querybuilder.core.infix_prefix,cljs.core.take_nth.cljs$core$IFn$_invoke$arity$2((2),x)));
}
});
/**
 * Returns 
 */
redgenes.components.querybuilder.core.simplify = (function redgenes$components$querybuilder$core$simplify(var_args){
var args29366 = [];
var len__8435__auto___29369 = arguments.length;
var i__8436__auto___29370 = (0);
while(true){
if((i__8436__auto___29370 < len__8435__auto___29369)){
args29366.push((arguments[i__8436__auto___29370]));

var G__29371 = (i__8436__auto___29370 + (1));
i__8436__auto___29370 = G__29371;
continue;
} else {
}
break;
}

var G__29368 = args29366.length;
switch (G__29368) {
case 1:
return redgenes.components.querybuilder.core.simplify.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return redgenes.components.querybuilder.core.simplify.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args29366.length)].join('')));

}
});

redgenes.components.querybuilder.core.simplify.cljs$core$IFn$_invoke$arity$1 = (function (x){
if((x instanceof cljs.core.Symbol)){
return x;
} else {
if((cljs.core.count(x) === (2))){
return cljs.core.last(x);
} else {
if(cljs.core.truth_((function (){var and__7207__auto__ = (cljs.core.count(x) > (1));
if(and__7207__auto__){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$sym$and,null,cljs.core.cst$sym$OR,null,cljs.core.cst$sym$AND,null,cljs.core.cst$sym$or,null], null), null).call(null,cljs.core.first(x));
} else {
return and__7207__auto__;
}
})())){
return redgenes.components.querybuilder.core.simplify.cljs$core$IFn$_invoke$arity$2(x,cljs.core.cons(cljs.core.first(x),cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.map.cljs$core$IFn$_invoke$arity$2(redgenes.components.querybuilder.core.simplify,cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.rest(x))))));
} else {
return cljs.core.last(x);

}
}
}
});

redgenes.components.querybuilder.core.simplify.cljs$core$IFn$_invoke$arity$2 = (function (x,y){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
return x;
} else {
return redgenes.components.querybuilder.core.simplify.cljs$core$IFn$_invoke$arity$1(y);
}
});

redgenes.components.querybuilder.core.simplify.cljs$lang$maxFixedArity = 2;

/**
 * Returns the infix representation of the given prefix expression
 */
redgenes.components.querybuilder.core.prefix_infix = (function redgenes$components$querybuilder$core$prefix_infix(x){
if((x instanceof cljs.core.Symbol)){
return x;
} else {
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(cljs.core.first(x),cljs.core.map.cljs$core$IFn$_invoke$arity$2(redgenes.components.querybuilder.core.prefix_infix,cljs.core.rest(x)));
}
});
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_logicop,cljs.core.cst$sym$redgenes$components$querybuilder$core_SLASH_logicops,redgenes.components.querybuilder.core.logicops);
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_listy,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_or,cljs.core.cst$kw$simple,cljs.core.cst$sym$redgenes$components$querybuilder$core_SLASH_alphabet_DASH_symbol_QMARK_,cljs.core.cst$kw$complex,cljs.core.cst$kw$q_SLASH_logic),cljs.spec.or_spec_impl(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$simple,cljs.core.cst$kw$complex], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$redgenes$components$querybuilder$core_SLASH_alphabet_DASH_symbol_QMARK_,cljs.core.cst$kw$q_SLASH_logic], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.querybuilder.core.alphabet_symbol_QMARK_,cljs.core.cst$kw$q_SLASH_logic], null),null));
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_logic,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_or,cljs.core.cst$kw$exp,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_cat,cljs.core.cst$kw$op,cljs.core.cst$kw$q_SLASH_logicop,cljs.core.cst$kw$args,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH__PLUS_,cljs.core.cst$kw$q_SLASH_listy)),cljs.core.cst$kw$nil,cljs.core.cst$sym$cljs$core_SLASH_nil_QMARK_),cljs.spec.or_spec_impl(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$exp,cljs.core.cst$kw$nil], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_cat,cljs.core.cst$kw$op,cljs.core.cst$kw$q_SLASH_logicop,cljs.core.cst$kw$args,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH__PLUS_,cljs.core.cst$kw$q_SLASH_listy)),cljs.core.cst$sym$cljs$core_SLASH_nil_QMARK_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.cat_impl(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$op,cljs.core.cst$kw$args], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_logicop,cljs.spec.rep_PLUS_impl(cljs.core.cst$kw$q_SLASH_listy,cljs.core.cst$kw$q_SLASH_listy)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_logicop,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH__PLUS_,cljs.core.cst$kw$q_SLASH_listy)], null)),cljs.core.nil_QMARK_], null),null));
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_infix_DASH_list,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_or,cljs.core.cst$kw$simple,cljs.core.cst$sym$redgenes$components$querybuilder$core_SLASH_alphabet_DASH_symbol_QMARK_,cljs.core.cst$kw$complex,cljs.core.cst$kw$q_SLASH_infix_DASH_exp),cljs.spec.or_spec_impl(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$simple,cljs.core.cst$kw$complex], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$redgenes$components$querybuilder$core_SLASH_alphabet_DASH_symbol_QMARK_,cljs.core.cst$kw$q_SLASH_infix_DASH_exp], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [redgenes.components.querybuilder.core.alphabet_symbol_QMARK_,cljs.core.cst$kw$q_SLASH_infix_DASH_exp], null),null));
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_infix_DASH_exp,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_or,cljs.core.cst$kw$exp,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_cat,cljs.core.cst$kw$a_DASH_list,cljs.core.cst$kw$q_SLASH_infix_DASH_list,cljs.core.cst$kw$op,cljs.core.cst$kw$q_SLASH_logicop,cljs.core.cst$kw$b_DASH_list,cljs.core.cst$kw$q_SLASH_infix_DASH_list),cljs.core.cst$kw$nil,cljs.core.cst$sym$cljs$core_SLASH_nil_QMARK_),cljs.spec.or_spec_impl(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$exp,cljs.core.cst$kw$nil], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_cat,cljs.core.cst$kw$a_DASH_list,cljs.core.cst$kw$q_SLASH_infix_DASH_list,cljs.core.cst$kw$op,cljs.core.cst$kw$q_SLASH_logicop,cljs.core.cst$kw$b_DASH_list,cljs.core.cst$kw$q_SLASH_infix_DASH_list),cljs.core.cst$sym$cljs$core_SLASH_nil_QMARK_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.spec.cat_impl(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$a_DASH_list,cljs.core.cst$kw$op,cljs.core.cst$kw$b_DASH_list], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_infix_DASH_list,cljs.core.cst$kw$q_SLASH_logicop,cljs.core.cst$kw$q_SLASH_infix_DASH_list], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_infix_DASH_list,cljs.core.cst$kw$q_SLASH_logicop,cljs.core.cst$kw$q_SLASH_infix_DASH_list], null)),cljs.core.nil_QMARK_], null),null));
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_path,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_coll_DASH_of,cljs.core.cst$sym$cljs$core_SLASH_string_QMARK_),cljs.spec.every_impl.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$sym$string_QMARK_,cljs.core.string_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$cljs$spec_SLASH_conform_DASH_all,true,cljs.core.cst$kw$cljs$spec_SLASH_kind_DASH_form,null], null),null));
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_value,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_or,cljs.core.cst$kw$string,cljs.core.cst$sym$cljs$core_SLASH_string_QMARK_,cljs.core.cst$kw$number,cljs.core.cst$sym$cljs$core_SLASH_number_QMARK_),cljs.spec.or_spec_impl(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$string,cljs.core.cst$kw$number], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cljs$core_SLASH_string_QMARK_,cljs.core.cst$sym$cljs$core_SLASH_number_QMARK_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.string_QMARK_,cljs.core.number_QMARK_], null),null));
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_clause,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_keys,cljs.core.cst$kw$req,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_path,cljs.core.cst$kw$q_SLASH_op,cljs.core.cst$kw$q_SLASH_value,cljs.core.cst$kw$q_SLASH_code], null),cljs.core.cst$kw$opt_DASH_un,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$redgenes$components$querybuilder$core_SLASH_type], null)),cljs.spec.map_spec_impl(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$req_DASH_un,cljs.core.cst$kw$opt_DASH_un,cljs.core.cst$kw$gfn,cljs.core.cst$kw$pred_DASH_exprs,cljs.core.cst$kw$opt_DASH_keys,cljs.core.cst$kw$req_DASH_specs,cljs.core.cst$kw$req,cljs.core.cst$kw$req_DASH_keys,cljs.core.cst$kw$opt_DASH_specs,cljs.core.cst$kw$pred_DASH_forms,cljs.core.cst$kw$opt],[null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$redgenes$components$querybuilder$core_SLASH_type], null),null,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map_QMARK_,(function (p1__25019__25020__auto__){
return cljs.core.contains_QMARK_(p1__25019__25020__auto__,cljs.core.cst$kw$q_SLASH_path);
}),(function (p1__25019__25020__auto__){
return cljs.core.contains_QMARK_(p1__25019__25020__auto__,cljs.core.cst$kw$q_SLASH_op);
}),(function (p1__25019__25020__auto__){
return cljs.core.contains_QMARK_(p1__25019__25020__auto__,cljs.core.cst$kw$q_SLASH_value);
}),(function (p1__25019__25020__auto__){
return cljs.core.contains_QMARK_(p1__25019__25020__auto__,cljs.core.cst$kw$q_SLASH_code);
})], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$type], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_path,cljs.core.cst$kw$q_SLASH_op,cljs.core.cst$kw$q_SLASH_value,cljs.core.cst$kw$q_SLASH_code], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_path,cljs.core.cst$kw$q_SLASH_op,cljs.core.cst$kw$q_SLASH_value,cljs.core.cst$kw$q_SLASH_code], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_path,cljs.core.cst$kw$q_SLASH_op,cljs.core.cst$kw$q_SLASH_value,cljs.core.cst$kw$q_SLASH_code], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$redgenes$components$querybuilder$core_SLASH_type], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cljs$core_SLASH_map_QMARK_,cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_PERCENT_], null),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_contains_QMARK_,cljs.core.cst$sym$_PERCENT_,cljs.core.cst$kw$q_SLASH_path)),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_PERCENT_], null),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_contains_QMARK_,cljs.core.cst$sym$_PERCENT_,cljs.core.cst$kw$q_SLASH_op)),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_PERCENT_], null),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_contains_QMARK_,cljs.core.cst$sym$_PERCENT_,cljs.core.cst$kw$q_SLASH_value)),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_PERCENT_], null),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_contains_QMARK_,cljs.core.cst$sym$_PERCENT_,cljs.core.cst$kw$q_SLASH_code))], null),null])));
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_view,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_coll_DASH_of,cljs.core.cst$sym$cljs$core_SLASH_string_QMARK_),cljs.spec.every_impl.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$sym$string_QMARK_,cljs.core.string_QMARK_,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$cljs$spec_SLASH_conform_DASH_all,true,cljs.core.cst$kw$cljs$spec_SLASH_kind_DASH_form,null], null),null));
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_select,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH__PLUS_,cljs.core.cst$kw$q_SLASH_view),cljs.spec.rep_PLUS_impl(cljs.core.cst$kw$q_SLASH_view,cljs.core.cst$kw$q_SLASH_view));
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_where,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_coll_DASH_of,cljs.core.cst$kw$q_SLASH_clause),cljs.spec.every_impl.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$q_SLASH_clause,cljs.core.cst$kw$q_SLASH_clause,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$cljs$spec_SLASH_conform_DASH_all,true,cljs.core.cst$kw$cljs$spec_SLASH_kind_DASH_form,null], null),null));
cljs.spec.def_impl(cljs.core.cst$kw$q_SLASH_query,cljs.core.list(cljs.core.cst$sym$cljs$spec_SLASH_keys,cljs.core.cst$kw$req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_select,cljs.core.cst$kw$q_SLASH_where], null),cljs.core.cst$kw$opt,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_logic], null),cljs.core.cst$kw$opt_DASH_un,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$redgenes$components$querybuilder$core_SLASH_constraint_DASH_paths], null)),cljs.spec.map_spec_impl(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$req_DASH_un,cljs.core.cst$kw$opt_DASH_un,cljs.core.cst$kw$gfn,cljs.core.cst$kw$pred_DASH_exprs,cljs.core.cst$kw$opt_DASH_keys,cljs.core.cst$kw$req_DASH_specs,cljs.core.cst$kw$req,cljs.core.cst$kw$req_DASH_keys,cljs.core.cst$kw$opt_DASH_specs,cljs.core.cst$kw$pred_DASH_forms,cljs.core.cst$kw$opt],[null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$redgenes$components$querybuilder$core_SLASH_constraint_DASH_paths], null),null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.map_QMARK_,(function (p1__25019__25020__auto__){
return cljs.core.contains_QMARK_(p1__25019__25020__auto__,cljs.core.cst$kw$q_SLASH_select);
}),(function (p1__25019__25020__auto__){
return cljs.core.contains_QMARK_(p1__25019__25020__auto__,cljs.core.cst$kw$q_SLASH_where);
})], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_logic,cljs.core.cst$kw$constraint_DASH_paths], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_select,cljs.core.cst$kw$q_SLASH_where], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_select,cljs.core.cst$kw$q_SLASH_where], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_select,cljs.core.cst$kw$q_SLASH_where], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_logic,cljs.core.cst$kw$redgenes$components$querybuilder$core_SLASH_constraint_DASH_paths], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$cljs$core_SLASH_map_QMARK_,cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_PERCENT_], null),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_contains_QMARK_,cljs.core.cst$sym$_PERCENT_,cljs.core.cst$kw$q_SLASH_select)),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_fn,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_PERCENT_], null),cljs.core.list(cljs.core.cst$sym$cljs$core_SLASH_contains_QMARK_,cljs.core.cst$sym$_PERCENT_,cljs.core.cst$kw$q_SLASH_where))], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$q_SLASH_logic], null)])));
redgenes.components.querybuilder.core.ors = (function redgenes$components$querybuilder$core$ors(where){
var codes = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$q_SLASH_code,where));
if((cljs.core.count(codes) > (1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$OR,codes)));
} else {
return "";
}
});
/**
 * Returns a query for the webservice
 *   from the given Spec validatable query map
 */
redgenes.components.querybuilder.core.build_query = (function redgenes$components$querybuilder$core$build_query(p__29373){
var map__29376 = p__29373;
var map__29376__$1 = ((((!((map__29376 == null)))?((((map__29376.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__29376.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__29376):map__29376);
var query = map__29376__$1;
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29376__$1,cljs.core.cst$kw$q_SLASH_select);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29376__$1,cljs.core.cst$kw$q_SLASH_where);
var logic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29376__$1,cljs.core.cst$kw$q_SLASH_logic);
var logic_str = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__29376__$1,cljs.core.cst$kw$logic_DASH_str);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$select,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__29376,map__29376__$1,query,select,where,logic,logic_str){
return (function (view){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",view);
});})(map__29376,map__29376__$1,query,select,where,logic,logic_str))
,select)),cljs.core.cst$kw$where,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (map__29376,map__29376__$1,query,select,where,logic,logic_str){
return (function (constraint){
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$path,clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.cst$kw$q_SLASH_path.cljs$core$IFn$_invoke$arity$1(constraint)),cljs.core.cst$kw$op,cljs.core.cst$kw$q_SLASH_op.cljs$core$IFn$_invoke$arity$1(constraint),cljs.core.cst$kw$value,cljs.core.cst$kw$q_SLASH_value.cljs$core$IFn$_invoke$arity$1(constraint)], null);
});})(map__29376,map__29376__$1,query,select,where,logic,logic_str))
,where)),cljs.core.cst$kw$constraintLogic,(cljs.core.truth_(logic)?logic_str:redgenes.components.querybuilder.core.ors(where)));
});
