// Compiled by ClojureScript 1.9.293 {:static-fns true, :optimize-constants true}
goog.provide('imcljs.query');
goog.require('cljs.core');
goog.require('imcljs.path');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('imcljs.internal.utils');
imcljs.query.value = (function imcljs$query$value(x){
return [cljs.core.str("<value>"),cljs.core.str(x),cljs.core.str("</value>")].join('');
});
imcljs.query.rename_key = (function imcljs$query$rename_key(m,old_k,new_k){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,new_k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,old_k)),old_k);
});
imcljs.query.add_id = (function imcljs$query$add_id(s){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(".id",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(cljs.core.count(s) - cljs.core.count(".id"))))){
return s;
} else {
return [cljs.core.str(s),cljs.core.str(".id")].join('');
}
});
imcljs.query.ids__GT_constraint = (function imcljs$query$ids__GT_constraint(c){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(imcljs.query.rename_key(c,cljs.core.cst$kw$ids,cljs.core.cst$kw$values),cljs.core.cst$kw$op,"ONE OF"),cljs.core.cst$kw$path,imcljs.query.add_id);
});
imcljs.query.html_entities = new cljs.core.PersistentArrayMap(null, 4, ["<","&lt;","<=","&lt;=",">","&gt;",">=","&gt;="], null);
/**
 * xml string representation of an edn map.
 *   (map->xlmstr constraint {:key1 val1 key2 val2}) => <constraint key1=val1 key2=val2 />
 */
imcljs.query.map__GT_xmlstr = (function imcljs$query$map__GT_xmlstr(elem,m){
var m__$1 = (function (){var G__23952 = m;
if(cljs.core.contains_QMARK_(m,cljs.core.cst$kw$ids)){
return imcljs.query.ids__GT_constraint(G__23952);
} else {
return G__23952;
}
})();
var m__$2 = cljs.core.select_keys(m__$1,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$path,cljs.core.cst$kw$value,cljs.core.cst$kw$values,cljs.core.cst$kw$type,cljs.core.cst$kw$op,cljs.core.cst$kw$code], null));
var values = cljs.core.cst$kw$values.cljs$core$IFn$_invoke$arity$1(m__$2);
return [cljs.core.str("<"),cljs.core.str(elem),cljs.core.str(" "),cljs.core.str(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (m__$1,m__$2,values){
return (function (total,p__23953){
var vec__23954 = p__23953;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23954,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23954,(1),null);
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(k,cljs.core.cst$kw$values)){
return [cljs.core.str(total),cljs.core.str((cljs.core.truth_(total)?" ":null)),cljs.core.str(cljs.core.name(k)),cljs.core.str("="),cljs.core.str([cljs.core.str("\""),cljs.core.str(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,cljs.core.cst$kw$op))?cljs.core.get.cljs$core$IFn$_invoke$arity$3(imcljs.query.html_entities,v,v):v)),cljs.core.str("\"")].join(''))].join('');
} else {
return total;
}
});})(m__$1,m__$2,values))
,null,m__$2)),cljs.core.str((cljs.core.truth_(values)?[cljs.core.str(">"),cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2(imcljs.query.value,values))),cljs.core.str("</"),cljs.core.str(elem),cljs.core.str(">")].join(''):"/>"))].join('');
});
imcljs.query.stringiy_map = (function imcljs$query$stringiy_map(m){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (total,p__23961){
var vec__23962 = p__23961;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23962,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__23962,(1),null);
return [cljs.core.str(total),cljs.core.str((cljs.core.truth_(total)?" ":null)),cljs.core.str(cljs.core.name(k)),cljs.core.str("="),cljs.core.str([cljs.core.str("\""),cljs.core.str(v),cljs.core.str("\"")].join(''))].join('');
}),null,m);
});
imcljs.query.enforce_origin = (function imcljs$query$enforce_origin(query){
if((cljs.core.cst$kw$from.cljs$core$IFn$_invoke$arity$1(query) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query,cljs.core.cst$kw$from,cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(query)),".")));
} else {
return query;
}
});
imcljs.query.enforce_views_have_class = (function imcljs$query$enforce_views_have_class(query){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(query,cljs.core.cst$kw$select,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.mapv,(function (path){
var path__$1 = cljs.core.name(path);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$from.cljs$core$IFn$_invoke$arity$1(query),cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(path__$1,".")))){
return path__$1;
} else {
return [cljs.core.str(cljs.core.cst$kw$from.cljs$core$IFn$_invoke$arity$1(query)),cljs.core.str("."),cljs.core.str(path__$1)].join('');
}
})));
});
imcljs.query.enforce_constraints_have_class = (function imcljs$query$enforce_constraints_have_class(query){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(query,cljs.core.cst$kw$where,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.mapv,(function (constraint){
var path = cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(constraint);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$from.cljs$core$IFn$_invoke$arity$1(query),cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(path,".")))){
return constraint;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(constraint,cljs.core.cst$kw$path,[cljs.core.str(cljs.core.cst$kw$from.cljs$core$IFn$_invoke$arity$1(query)),cljs.core.str("."),cljs.core.str(path)].join(''));
}
})));
});
imcljs.query.enforce_constraints_have_code = (function imcljs$query$enforce_constraints_have_code(query){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(query,cljs.core.cst$kw$where,(function (constraints){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (total,p__23968){
var map__23969 = p__23968;
var map__23969__$1 = ((((!((map__23969 == null)))?((((map__23969.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__23969.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__23969):map__23969);
var constraint = map__23969__$1;
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__23969__$1,cljs.core.cst$kw$code);
if(cljs.core.some_QMARK_(code)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(total,constraint);
} else {
var existing_codes = cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$code,constraints),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$code,total))));
var next_available_code = cljs.core.first(clojure.set.difference.cljs$core$IFn$_invoke$arity$2(imcljs.internal.utils.alphabet,existing_codes));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(total,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(constraint,cljs.core.cst$kw$code,next_available_code));
}
}),cljs.core.PersistentVector.EMPTY,constraints);
}));
});
imcljs.query.enforce_sorting = (function imcljs$query$enforce_sorting(query){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(query,cljs.core.cst$kw$orderBy,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.map,(function (order){
var order__$1 = (((cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(order) == null))?new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$path,[cljs.core.str(cljs.core.name(cljs.core.first(cljs.core.first(cljs.core.seq(order)))))].join(''),cljs.core.cst$kw$direction,cljs.core.second(cljs.core.first(cljs.core.seq(order)))], null):order);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$from.cljs$core$IFn$_invoke$arity$1(query),cljs.core.first(clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(order__$1),".")))){
return order__$1;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(order__$1,cljs.core.cst$kw$path,[cljs.core.str(cljs.core.cst$kw$from.cljs$core$IFn$_invoke$arity$1(query)),cljs.core.str("."),cljs.core.str(cljs.core.cst$kw$path.cljs$core$IFn$_invoke$arity$1(order__$1))].join(''));
}
})));
});
imcljs.query.sterilize_query = cljs.core.comp.cljs$core$IFn$_invoke$arity$variadic(imcljs.query.enforce_sorting,imcljs.query.enforce_constraints_have_class,imcljs.query.enforce_constraints_have_code,cljs.core.array_seq([imcljs.query.enforce_views_have_class,imcljs.query.enforce_origin], 0));
/**
 * Returns the stringfied XML representation of an EDN intermine query.
 */
imcljs.query.__GT_xml = (function imcljs$query$__GT_xml(model,query){
var query__$1 = (imcljs.query.sterilize_query.cljs$core$IFn$_invoke$arity$1 ? imcljs.query.sterilize_query.cljs$core$IFn$_invoke$arity$1(query) : imcljs.query.sterilize_query.call(null,query));
var head_attributes = (function (){var G__23972 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$model,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(model),cljs.core.cst$kw$view,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(query__$1))], null);
var G__23972__$1 = (cljs.core.truth_(cljs.core.cst$kw$constraintLogic.cljs$core$IFn$_invoke$arity$1(query__$1))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__23972,cljs.core.cst$kw$constraintLogic,cljs.core.cst$kw$constraintLogic.cljs$core$IFn$_invoke$arity$1(query__$1)):G__23972);
if(cljs.core.truth_(cljs.core.cst$kw$sortOrder.cljs$core$IFn$_invoke$arity$1(query__$1))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__23972__$1,cljs.core.cst$kw$sortOrder,clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.flatten(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$path,cljs.core.cst$kw$direction),cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(query__$1)))));
} else {
return G__23972__$1;
}
})();
return [cljs.core.str("<query "),cljs.core.str(imcljs.query.stringiy_map(head_attributes)),cljs.core.str(">"),cljs.core.str(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$2(imcljs.query.map__GT_xmlstr,"constraint"),cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(query__$1)))),cljs.core.str("</query>")].join('');
});
/**
 * Deconstructs a query by its views and groups them by class.
 *   (deconstruct-by-class model query)
 *   {:Gene {Gene.homologues.homologue {:from Gene :select [Gene.homologues.homologue.id] :where [...]}
 *       {Gene {:from Gene :select [Gene.id] :where [...]}}}
 */
imcljs.query.deconstruct_by_class = (function imcljs$query$deconstruct_by_class(model,query){
var query__$1 = (imcljs.query.sterilize_query.cljs$core$IFn$_invoke$arity$1 ? imcljs.query.sterilize_query.cljs$core$IFn$_invoke$arity$1(query) : imcljs.query.sterilize_query.call(null,query));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (query__$1){
return (function (path_map,next_path){
return cljs.core.update.cljs$core$IFn$_invoke$arity$5(path_map,imcljs.path.class$(model,next_path),cljs.core.assoc,imcljs.path.trim_to_last_class(model,next_path),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query__$1,cljs.core.cst$kw$select,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(imcljs.path.trim_to_last_class(model,next_path)),cljs.core.str(".id")].join('')], null))], null));
});})(query__$1))
,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(query__$1));
});
