// Compiled by ClojureScript 1.10.520 {}
goog.provide('im_tables.views.graphs.histogram');
goog.require('cljs.core');
im_tables.views.graphs.histogram.linear_scale = (function im_tables$views$graphs$histogram$linear_scale(p__17162,p__17163){
var vec__17164 = p__17162;
var r1_lower = cljs.core.nth.call(null,vec__17164,(0),null);
var r1_upper = cljs.core.nth.call(null,vec__17164,(1),null);
var vec__17167 = p__17163;
var r2_lower = cljs.core.nth.call(null,vec__17167,(0),null);
var r2_upper = cljs.core.nth.call(null,vec__17167,(1),null);
return ((function (vec__17164,r1_lower,r1_upper,vec__17167,r2_lower,r2_upper){
return (function (v){
return ((((v - r1_lower) * (r2_upper - r2_lower)) / (r1_upper - r1_lower)) + r2_lower);
});
;})(vec__17164,r1_lower,r1_upper,vec__17167,r2_lower,r2_upper))
});
/**
 * A single scaled bar for the histogram
 */
im_tables.views.graphs.histogram.datum = (function im_tables$views$graphs$histogram$datum(){
return (function (height_scale,idx,p__17170){
var map__17171 = p__17170;
var map__17171__$1 = (((((!((map__17171 == null))))?(((((map__17171.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17171.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17171):map__17171);
var item = cljs.core.get.call(null,map__17171__$1,new cljs.core.Keyword(null,"item","item",249373802));
var count = cljs.core.get.call(null,map__17171__$1,new cljs.core.Keyword(null,"count","count",2139924085));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.histo-bar","div.histo-bar",1298395053),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"height","height",1025178622),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(height_scale.call(null,count)),"px"].join('')], null),new cljs.core.Keyword(null,"title","title",636505583),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(item),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(count)].join('')], null)], null);
});
});
im_tables.views.graphs.histogram.main = (function im_tables$views$graphs$histogram$main(){
return (function (points){
var only_one_column_QMARK_ = cljs.core._EQ_.call(null,cljs.core.count.call(null,cljs.core.distinct.call(null,points)),(1));
var unique_results = cljs.core.reduce.call(null,((function (only_one_column_QMARK_){
return (function (new_set,point){
return cljs.core.conj.call(null,new_set,new cljs.core.Keyword(null,"count","count",2139924085).cljs$core$IFn$_invoke$arity$1(point));
});})(only_one_column_QMARK_))
,cljs.core.PersistentHashSet.EMPTY,points);
var only_one_count_result_QMARK_ = cljs.core._EQ_.call(null,cljs.core.count.call(null,unique_results),(1));
var show_graph_QMARK_ = (!(((only_one_column_QMARK_) || (only_one_count_result_QMARK_))));
var height_scale = im_tables.views.graphs.histogram.linear_scale.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),cljs.core.apply.call(null,cljs.core.max,cljs.core.map.call(null,new cljs.core.Keyword(null,"count","count",2139924085),points))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(50)], null));
if(show_graph_QMARK_){
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.graph.histogram","div.graph.histogram",306422486)], null),cljs.core.map_indexed.call(null,((function (only_one_column_QMARK_,unique_results,only_one_count_result_QMARK_,show_graph_QMARK_,height_scale){
return (function (idx,d){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.graphs.histogram.datum,height_scale,idx,d,cljs.core.count.call(null,points)], null);
});})(only_one_column_QMARK_,unique_results,only_one_count_result_QMARK_,show_graph_QMARK_,height_scale))
,points));
} else {
if(only_one_column_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.no-histogram","div.no-histogram",330114022),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-bar-chart","i.fa.fa-bar-chart",-359321590)], null)," No histogram; only one value in entire column"], null);
} else {
if(only_one_count_result_QMARK_){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.no-histogram","div.no-histogram",330114022),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"i.fa.fa-bar-chart","i.fa.fa-bar-chart",-359321590)], null)," No histogram; all values occur exactly ",cljs.core.first.call(null,unique_results)," time(s)"], null);
} else {
return null;
}
}
}
});
});
im_tables.views.graphs.histogram.bucket = (function im_tables$views$graphs$histogram$bucket(){
return (function (bucket_number,data_points){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.histo-bucket","div.histo-bucket",-1978400504),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(data_points)?"full":"empty")], null),cljs.core.max], null);
});
});
im_tables.views.graphs.histogram.percent_of = (function im_tables$views$graphs$histogram$percent_of(min,max,number){
return ((100) * ((number - min) / (max - min)));
});
im_tables.views.graphs.histogram.clj_min = cljs.core.min;
im_tables.views.graphs.histogram.clj_max = cljs.core.max;
im_tables.views.graphs.histogram.numerical_histogram = (function im_tables$views$graphs$histogram$numerical_histogram(){
return (function (data_points,trim){
var map__17173 = cljs.core.first.call(null,data_points);
var map__17173__$1 = (((((!((map__17173 == null))))?(((((map__17173.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17173.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17173):map__17173);
var buckets = cljs.core.get.call(null,map__17173__$1,new cljs.core.Keyword(null,"buckets","buckets",-1916554731));
var min = cljs.core.get.call(null,map__17173__$1,new cljs.core.Keyword(null,"min","min",444991522));
var max = cljs.core.get.call(null,map__17173__$1,new cljs.core.Keyword(null,"max","max",61366548));
var map__17174 = trim;
var map__17174__$1 = (((((!((map__17174 == null))))?(((((map__17174.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__17174.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__17174):map__17174);
var from = cljs.core.get.call(null,map__17174__$1,new cljs.core.Keyword(null,"from","from",1815293044));
var to = cljs.core.get.call(null,map__17174__$1,new cljs.core.Keyword(null,"to","to",192099007));
var by_bucket = cljs.core.group_by.call(null,new cljs.core.Keyword(null,"bucket","bucket",1126218366),data_points);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.histo","div.histo",-1421343718),(cljs.core.truth_((function (){var or__4131__auto__ = from;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return to;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.trimmer","div.trimmer",691400943),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"left","left",-399115937),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(im_tables.views.graphs.histogram.clj_max.call(null,(0),im_tables.views.graphs.histogram.percent_of.call(null,min,max,(function (){var or__4131__auto__ = from;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return min;
}
})()))),"%"].join(''),new cljs.core.Keyword(null,"right","right",-452581833),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(im_tables.views.graphs.histogram.clj_min.call(null,(100),((100) - im_tables.views.graphs.histogram.percent_of.call(null,min,max,(function (){var or__4131__auto__ = to;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return max;
}
})())))),"%"].join('')], null)], null)], null):null),cljs.core.map.call(null,((function (map__17173,map__17173__$1,buckets,min,max,map__17174,map__17174__$1,from,to,by_bucket){
return (function (bucket_number){
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [im_tables.views.graphs.histogram.bucket,bucket_number,cljs.core.get.call(null,by_bucket,bucket_number)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),bucket_number], null));
});})(map__17173,map__17173__$1,buckets,min,max,map__17174,map__17174__$1,from,to,by_bucket))
,cljs.core.range.call(null,(1),(buckets + (1))))], null);
});
});

//# sourceMappingURL=histogram.js.map
