// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.pages.mymine.events');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('cljs.core.async');
goog.require('imcljs.send');
goog.require('imcljs.fetch');
goog.require('imcljs.save');
goog.require('bluegenes.effects');
goog.require('clojure.string');
goog.require('bluegenes.pages.mymine.subs');
goog.require('oops.core');
goog.require('clojure.walk');
goog.require('cljs_uuid_utils.core');
goog.require('bluegenes.route');
/**
 * Dissociates an entry from a nested associative structure returning a new
 *   nested structure. keys is a sequence of keys. Any empty maps that result
 *   will not be present in the new structure.
 */
bluegenes.pages.mymine.events.dissoc_in = (function bluegenes$pages$mymine$events$dissoc_in(m,p__21917){
var vec__21918 = p__21917;
var seq__21919 = cljs.core.seq.call(null,vec__21918);
var first__21920 = cljs.core.first.call(null,seq__21919);
var seq__21919__$1 = cljs.core.next.call(null,seq__21919);
var k = first__21920;
var ks = seq__21919__$1;
var keys = vec__21918;
if(ks){
var temp__5455__auto__ = cljs.core.get.call(null,m,k);
if(cljs.core.truth_(temp__5455__auto__)){
var nextmap = temp__5455__auto__;
var newmap = bluegenes.pages.mymine.events.dissoc_in.call(null,nextmap,ks);
if(cljs.core.seq.call(null,newmap)){
return cljs.core.assoc.call(null,m,k,newmap);
} else {
return cljs.core.dissoc.call(null,m,k);
}
} else {
return m;
}
} else {
return cljs.core.dissoc.call(null,m,k);
}
});
/**
 * Find the location of the parent folder for a given path
 */
bluegenes.pages.mymine.events.parent_folder = (function bluegenes$pages$mymine$events$parent_folder(var_args){
var G__21922 = arguments.length;
switch (G__21922) {
case 2:
return bluegenes.pages.mymine.events.parent_folder.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return bluegenes.pages.mymine.events.parent_folder.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

bluegenes.pages.mymine.events.parent_folder.cljs$core$IFn$_invoke$arity$2 = (function (tree,path){
return bluegenes.pages.mymine.events.parent_folder.call(null,tree,path,cljs.core.PersistentVector.EMPTY);
});

bluegenes.pages.mymine.events.parent_folder.cljs$core$IFn$_invoke$arity$3 = (function (tree,p__21923,trail){
while(true){
var vec__21924 = p__21923;
var seq__21925 = cljs.core.seq.call(null,vec__21924);
var first__21926 = cljs.core.first.call(null,seq__21925);
var seq__21925__$1 = cljs.core.next.call(null,seq__21925);
var head = first__21926;
var first__21926__$1 = cljs.core.first.call(null,seq__21925__$1);
var seq__21925__$2 = cljs.core.next.call(null,seq__21925__$1);
var children_key = first__21926__$1;
var remaining = seq__21925__$2;
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"file-type","file-type",1274948820).cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,tree,head)),new cljs.core.Keyword(null,"folder","folder",1515881736))){
var G__21928 = cljs.core.get_in.call(null,tree,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [head,children_key], null));
var G__21929 = remaining;
var G__21930 = cljs.core.vec.call(null,cljs.core.conj.call(null,trail,head));
tree = G__21928;
p__21923 = G__21929;
trail = G__21930;
continue;
} else {
return cljs.core.interpose.call(null,new cljs.core.Keyword(null,"children","children",-940561982),trail);
}
break;
}
});

bluegenes.pages.mymine.events.parent_folder.cljs$lang$maxFixedArity = 3;

bluegenes.pages.mymine.events.in_or_out = (function bluegenes$pages$mymine$events$in_or_out(haystack,needle){
if((!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack) == null)))){
return cljs.core.remove.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack);
} else {
return cljs.core.conj.call(null,haystack,needle);
}
});
bluegenes.pages.mymine.events.in_QMARK_ = (function bluegenes$pages$mymine$events$in_QMARK_(haystack,needle){
return (!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([needle]),haystack) == null)));
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","toggle-folder-open","bluegenes.pages.mymine.events/toggle-folder-open",-982618130),(function (db,p__21931){
var vec__21932 = p__21931;
var _ = cljs.core.nth.call(null,vec__21932,(0),null);
var location_trail = cljs.core.nth.call(null,vec__21932,(1),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"tree","tree",-196312028)], null),cljs.core.update_in,location_trail,cljs.core.update,new cljs.core.Keyword(null,"open","open",-1763596448),cljs.core.not);
}));
/**
 * Makes a growing collection like the following:
 *   (snowball [1 2 3 4 5])
 *   => [[1] [1 2] [1 2 3] [1 2 3 4] [1 2 3 4 5]]
 */
bluegenes.pages.mymine.events.snowball = (function bluegenes$pages$mymine$events$snowball(coll){
if(cljs.core.seqable_QMARK_.call(null,coll)){
return cljs.core.reduce.call(null,(function (total,next){
return cljs.core.conj.call(null,total,cljs.core.vec.call(null,cljs.core.conj.call(null,cljs.core.last.call(null,total),next)));
}),cljs.core.PersistentVector.EMPTY,coll);
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll], null);
}
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","set-action-target","bluegenes.pages.mymine.events/set-action-target",1565773020),(function (db,p__21935){
var vec__21936 = p__21935;
var _ = cljs.core.nth.call(null,vec__21936,(0),null);
var path_vec = cljs.core.nth.call(null,vec__21936,(1),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"action-target","action-target",2104192791)], null),path_vec);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","set-focus","bluegenes.pages.mymine.events/set-focus",566826648),(function (db,p__21939){
var vec__21940 = p__21939;
var _ = cljs.core.nth.call(null,vec__21940,(0),null);
var location_trail = cljs.core.nth.call(null,vec__21940,(1),null);
var expand_QMARK_ = cljs.core.nth.call(null,vec__21940,(2),null);
var G__21943 = db;
var G__21943__$1 = cljs.core.assoc_in.call(null,G__21943,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"focus","focus",234677911)], null),location_trail)
;
if(cljs.core.truth_(expand_QMARK_)){
return cljs.core.update_in.call(null,G__21943__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"tree","tree",-196312028)], null),((function (G__21943,G__21943__$1,vec__21940,_,location_trail,expand_QMARK_){
return (function (tree){
return cljs.core.reduce.call(null,((function (G__21943,G__21943__$1,vec__21940,_,location_trail,expand_QMARK_){
return (function (total,next){
if(cljs.core.not_EQ_.call(null,cljs.core.last.call(null,next),new cljs.core.Keyword(null,"children","children",-940561982))){
return cljs.core.update_in.call(null,total,next,cljs.core.assoc,new cljs.core.Keyword(null,"open","open",-1763596448),true);
} else {
return total;
}
});})(G__21943,G__21943__$1,vec__21940,_,location_trail,expand_QMARK_))
,tree,cljs.core.butlast.call(null,bluegenes.pages.mymine.events.snowball.call(null,location_trail)));
});})(G__21943,G__21943__$1,vec__21940,_,location_trail,expand_QMARK_))
);
} else {
return G__21943__$1;
}
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","update-value","bluegenes.pages.mymine.events/update-value",-1106222979),(function (db,p__21944){
var vec__21945 = p__21944;
var _ = cljs.core.nth.call(null,vec__21945,(0),null);
var location_trail = cljs.core.nth.call(null,vec__21945,(1),null);
var key = cljs.core.nth.call(null,vec__21945,(2),null);
var value = cljs.core.nth.call(null,vec__21945,(3),null);
var action_target = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"action-target","action-target",2104192791)], null));
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"tree","tree",-196312028)], null),cljs.core.update_in,action_target,cljs.core.assoc,key,value,new cljs.core.Keyword(null,"editing?","editing?",1646440800),false);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","new-folder","bluegenes.pages.mymine.events/new-folder",357098697),(function (db,p__21948){
var vec__21949 = p__21948;
var _ = cljs.core.nth.call(null,vec__21949,(0),null);
var location_trail = cljs.core.nth.call(null,vec__21949,(1),null);
var name = cljs.core.nth.call(null,vec__21949,(2),null);
var action_target = cljs.core.not_empty.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"action-target","action-target",2104192791)], null)));
var uuid = cljs.core.keyword.call(null,["tag-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_uuid_utils.core.make_random_uuid.call(null))].join(''));
if(cljs.core.not.call(null,action_target)){
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"tree","tree",-196312028),uuid], null),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),name,new cljs.core.Keyword(null,"file-type","file-type",1274948820),new cljs.core.Keyword(null,"folder","folder",1515881736)], null));
} else {
return cljs.core.assoc_in.call(null,cljs.core.update_in.call(null,cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"tree","tree",-196312028)], null),cljs.core.update_in,(function (){var or__4131__auto__ = location_trail;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.update,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.assoc,uuid,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1718410804),name,new cljs.core.Keyword(null,"file-type","file-type",1274948820),new cljs.core.Keyword(null,"folder","folder",1515881736)], null)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"tree","tree",-196312028)], null),cljs.core.update_in,(function (){var or__4131__auto__ = location_trail;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.assoc,new cljs.core.Keyword(null,"open","open",-1763596448),true),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"focus","focus",234677911)], null),(((location_trail == null))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [uuid], null):cljs.core.conj.call(null,cljs.core.vec.call(null,location_trail),new cljs.core.Keyword(null,"children","children",-940561982),uuid)));
}
}));
bluegenes.pages.mymine.events.parent_container = (function bluegenes$pages$mymine$events$parent_container(path){
while(true){
if(cljs.core._EQ_.call(null,cljs.core.last.call(null,cljs.core.butlast.call(null,path)),new cljs.core.Keyword(null,"children","children",-940561982))){
var G__21952 = cljs.core.butlast.call(null,path);
path = G__21952;
continue;
} else {
return cljs.core.butlast.call(null,path);
}
break;
}
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","delete-folder","bluegenes.pages.mymine.events/delete-folder",-944071166),(function (db,p__21953){
var vec__21954 = p__21953;
var _ = cljs.core.nth.call(null,vec__21954,(0),null);
var location_trail = cljs.core.nth.call(null,vec__21954,(1),null);
var name = cljs.core.nth.call(null,vec__21954,(2),null);
var action_target = cljs.core.not_empty.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"action-target","action-target",2104192791)], null)));
return cljs.core.assoc_in.call(null,cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"tree","tree",-196312028)], null),bluegenes.pages.mymine.events.dissoc_in,action_target),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"focus","focus",234677911)], null),bluegenes.pages.mymine.events.parent_container.call(null,action_target));
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","toggle-selected","bluegenes.pages.mymine.events/toggle-selected",40717265),(function (db,p__21957){
var vec__21958 = p__21957;
var _ = cljs.core.nth.call(null,vec__21958,(0),null);
var location_trail = cljs.core.nth.call(null,vec__21958,(1),null);
var options = cljs.core.nth.call(null,vec__21958,(2),null);
var map__21961 = cljs.core.nth.call(null,vec__21958,(3),null);
var map__21961__$1 = (((((!((map__21961 == null))))?(((((map__21961.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21961.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21961):map__21961);
var selected = map__21961__$1;
var id = cljs.core.get.call(null,map__21961__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var file_type = cljs.core.get.call(null,map__21961__$1,new cljs.core.Keyword(null,"file-type","file-type",1274948820));
var db__$1 = cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"details","details",1956795411)], null),cljs.core.select_keys.call(null,selected,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"file-type","file-type",1274948820)], null)));
if(cljs.core.truth_(new cljs.core.Keyword(null,"force?","force?",1839038675).cljs$core$IFn$_invoke$arity$1(options))){
return cljs.core.assoc_in.call(null,db__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"selected","selected",574897764)], null),cljs.core.PersistentHashSet.createAsIfByAssoc([location_trail]));
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"single?","single?",-593061958).cljs$core$IFn$_invoke$arity$1(options))){
if(bluegenes.pages.mymine.events.in_QMARK_.call(null,cljs.core.get_in.call(null,db__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"selected","selected",574897764)], null)),location_trail)){
return cljs.core.assoc_in.call(null,db__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"selected","selected",574897764)], null),cljs.core.PersistentHashSet.EMPTY);
} else {
return cljs.core.assoc_in.call(null,db__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"selected","selected",574897764)], null),cljs.core.PersistentHashSet.createAsIfByAssoc([location_trail]));
}
} else {
return null;
}
}
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","toggle-sort","bluegenes.pages.mymine.events/toggle-sort",-1957884727),(function (db,p__21963){
var vec__21964 = p__21963;
var _ = cljs.core.nth.call(null,vec__21964,(0),null);
var key = cljs.core.nth.call(null,vec__21964,(1),null);
var type = cljs.core.nth.call(null,vec__21964,(2),null);
var direction = cljs.core.nth.call(null,vec__21964,(3),null);
if(cljs.core._EQ_.call(null,key,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"sort-by","sort-by",-322599303),new cljs.core.Keyword(null,"key","key",-1516042587)], null)))){
return cljs.core.assoc_in.call(null,cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"sort-by","sort-by",-322599303),new cljs.core.Keyword(null,"asc?","asc?",891093427)], null),cljs.core.not),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"sort-by","sort-by",-322599303),new cljs.core.Keyword(null,"type","type",1174270348)], null),type);
} else {
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"sort-by","sort-by",-322599303)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"key","key",-1516042587),key,new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"asc?","asc?",891093427),true], null));
}
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","drag-start","bluegenes.pages.mymine.events/drag-start",1240281418),(function (db,p__21967){
var vec__21968 = p__21967;
var _ = cljs.core.nth.call(null,vec__21968,(0),null);
var file_details = cljs.core.nth.call(null,vec__21968,(1),null);
return cljs.core.update.call(null,db,new cljs.core.Keyword(null,"mymine","mymine",279449182),cljs.core.assoc,new cljs.core.Keyword(null,"dragging","dragging",1185097613),file_details,new cljs.core.Keyword(null,"dragging-node","dragging-node",-888671283),file_details);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","fetch-one-list-success","bluegenes.pages.mymine.events/fetch-one-list-success",540582469),(function (p__21971,p__21972){
var map__21973 = p__21971;
var map__21973__$1 = (((((!((map__21973 == null))))?(((((map__21973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21973.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21973):map__21973);
var db = cljs.core.get.call(null,map__21973__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__21974 = p__21972;
var _ = cljs.core.nth.call(null,vec__21974,(0),null);
var trail = cljs.core.nth.call(null,vec__21974,(1),null);
var parent_id = cljs.core.nth.call(null,vec__21974,(2),null);
var map__21977 = cljs.core.nth.call(null,vec__21974,(3),null);
var map__21977__$1 = (((((!((map__21977 == null))))?(((((map__21977.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21977.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21977):map__21977);
var list_details = map__21977__$1;
var id = cljs.core.get.call(null,map__21977__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var name = cljs.core.get.call(null,map__21977__$1,new cljs.core.Keyword(null,"name","name",1843675177));
var G__21980 = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-lists","assets/fetch-lists",833336064)], null)], null);
var G__21980__$1 = (cljs.core.truth_((function (){var and__4120__auto__ = trail;
if(cljs.core.truth_(and__4120__auto__)){
return (!((cljs.core.first.call(null,trail) instanceof cljs.core.Keyword)));
} else {
return and__4120__auto__;
}
})())?cljs.core.assoc.call(null,G__21980,new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"tree","tree",-196312028)], null),cljs.core.update_in,bluegenes.pages.mymine.events.parent_container.call(null,trail),cljs.core.update,new cljs.core.Keyword(null,"children","children",-940561982),cljs.core.assoc,id,cljs.core.assoc.call(null,list_details,new cljs.core.Keyword(null,"file-type","file-type",1274948820),new cljs.core.Keyword(null,"list","list",765357683),new cljs.core.Keyword(null,"label","label",1718410804),name))):G__21980);
if(cljs.core.truth_(parent_id)){
return cljs.core.assoc.call(null,G__21980__$1,new cljs.core.Keyword("bluegenes.effects","http","bluegenes.effects/http",-1911287329),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"transit-params","transit-params",357261095),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"im-obj-type","im-obj-type",-1527355172),"list",new cljs.core.Keyword(null,"im-obj-id","im-obj-id",-1488125551),id,new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131),parent_id], null),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","success-store-tag","bluegenes.pages.mymine.events/success-store-tag",-740280429)], null),new cljs.core.Keyword(null,"uri","uri",-774711847),"/api/mymine/entries"], null));
} else {
return G__21980__$1;
}
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","fetch-one-list","bluegenes.pages.mymine.events/fetch-one-list",-451697849),(function (p__21981,p__21982){
var map__21983 = p__21981;
var map__21983__$1 = (((((!((map__21983 == null))))?(((((map__21983.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21983.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21983):map__21983);
var db = cljs.core.get.call(null,map__21983__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__21984 = p__21982;
var _ = cljs.core.nth.call(null,vec__21984,(0),null);
var trail = cljs.core.nth.call(null,vec__21984,(1),null);
var map__21987 = cljs.core.nth.call(null,vec__21984,(2),null);
var map__21987__$1 = (((((!((map__21987 == null))))?(((((map__21987.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21987.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21987):map__21987);
var list_name = cljs.core.get.call(null,map__21987__$1,new cljs.core.Keyword(null,"listName","listName",849054384));
var parent_id = cljs.core.nth.call(null,vec__21984,(3),null);
console.log("fetching one list",list_name);

var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.fetch.one_list.call(null,service,list_name),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","fetch-one-list-success","bluegenes.pages.mymine.events/fetch-one-list-success",540582469),trail,parent_id], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","copy-failure","bluegenes.pages.mymine.events/copy-failure",-575316683)], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","copy-success","bluegenes.pages.mymine.events/copy-success",-746901815),(function (p__21990,p__21991){
var map__21992 = p__21990;
var map__21992__$1 = (((((!((map__21992 == null))))?(((((map__21992.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21992.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21992):map__21992);
var db = cljs.core.get.call(null,map__21992__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__21993 = p__21991;
var _ = cljs.core.nth.call(null,vec__21993,(0),null);
var response = cljs.core.nth.call(null,vec__21993,(1),null);
console.log("copy success",response);

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","clear-checked","bluegenes.pages.mymine.events/clear-checked",986072818)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","fetch-one-list","bluegenes.pages.mymine.events/fetch-one-list",-451697849),response], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","copy-n","bluegenes.pages.mymine.events/copy-n",738960782),(function (p__21998){
var map__21999 = p__21998;
var map__21999__$1 = (((((!((map__21999 == null))))?(((((map__21999.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21999.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21999):map__21999);
var db = cljs.core.get.call(null,map__21999__$1,new cljs.core.Keyword(null,"db","db",993250759));
var ids = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"checked","checked",-50955819)], null));
var lists = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"lists","lists",-884730684),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086))], null));
var names_to_copy = cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.filter.call(null,cljs.core.comp.call(null,ids,new cljs.core.Keyword(null,"id","id",-1388402092)),lists));
var focus = (function (){var or__4131__auto__ = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"focus","focus",234677911)], null));
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"unsorted","unsorted",-1127017994)], null);
}
})();
var parent_id = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"entry-id","entry-id",591934358)], null));
var evts = cljs.core.reduce.call(null,((function (ids,lists,names_to_copy,focus,parent_id,map__21999,map__21999__$1,db){
return (function (total,next){
var temp__5455__auto__ = cljs.core.first.call(null,cljs.core.not_empty.call(null,cljs.core.filter.call(null,((function (ids,lists,names_to_copy,focus,parent_id,map__21999,map__21999__$1,db){
return (function (p1__21997_SHARP_){
return clojure.string.starts_with_QMARK_.call(null,p1__21997_SHARP_,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(next),"_"].join(''));
});})(ids,lists,names_to_copy,focus,parent_id,map__21999,map__21999__$1,db))
,cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),lists))));
if(cljs.core.truth_(temp__5455__auto__)){
var previous = temp__5455__auto__;
return cljs.core.conj.call(null,total,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","copy-focus","bluegenes.pages.mymine.events/copy-focus",-173912672),focus,next,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(previous),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1((parseInt(cljs.core.last.call(null,previous)) + (1)))].join(''),parent_id], null));
} else {
return cljs.core.conj.call(null,total,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","copy-focus","bluegenes.pages.mymine.events/copy-focus",-173912672),focus,next,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(next),"_1"].join(''),parent_id], null));
}
});})(ids,lists,names_to_copy,focus,parent_id,map__21999,map__21999__$1,db))
,cljs.core.PersistentVector.EMPTY,names_to_copy);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),evts], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","copy-focus","bluegenes.pages.mymine.events/copy-focus",-173912672),(function (p__22001,p__22002){
var map__22003 = p__22001;
var map__22003__$1 = (((((!((map__22003 == null))))?(((((map__22003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22003.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22003):map__22003);
var db = cljs.core.get.call(null,map__22003__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22004 = p__22002;
var _ = cljs.core.nth.call(null,vec__22004,(0),null);
var trail = cljs.core.nth.call(null,vec__22004,(1),null);
var old_list_name = cljs.core.nth.call(null,vec__22004,(2),null);
var new_list_name = cljs.core.nth.call(null,vec__22004,(3),null);
var parent_id = cljs.core.nth.call(null,vec__22004,(4),null);
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
var target_file = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"menu-file-details","menu-file-details",-1885807542)], null));
var lists = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"lists","lists",-884730684),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086))], null));
var target_list_name = new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,cljs.core.filter.call(null,((function (service,target_file,lists,map__22003,map__22003__$1,db,vec__22004,_,trail,old_list_name,new_list_name,parent_id){
return (function (l){
return cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(target_file),new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(l));
});})(service,target_file,lists,map__22003,map__22003__$1,db,vec__22004,_,trail,old_list_name,new_list_name,parent_id))
,lists)));
var location = cljs.core.butlast.call(null,new cljs.core.Keyword(null,"trail","trail",-272340561).cljs$core$IFn$_invoke$arity$1(target_file));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.save.im_list_copy.call(null,service,old_list_name,new_list_name),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","copy-success","bluegenes.pages.mymine.events/copy-success",-746901815),location,parent_id], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","copy-failure","bluegenes.pages.mymine.events/copy-failure",-575316683)], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","delete-lists-success","bluegenes.pages.mymine.events/delete-lists-success",802061929),(function (p__22008,p__22009){
var map__22010 = p__22008;
var map__22010__$1 = (((((!((map__22010 == null))))?(((((map__22010.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22010.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22010):map__22010);
var db = cljs.core.get.call(null,map__22010__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22011 = p__22009;
var _ = cljs.core.nth.call(null,vec__22011,(0),null);
var returned = cljs.core.nth.call(null,vec__22011,(1),null);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-success","bluegenes.pages.mymine.events/lo-success",-1703730790)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","delete-lists","bluegenes.pages.mymine.events/delete-lists",266603975),(function (p__22015,p__22016){
var map__22017 = p__22015;
var map__22017__$1 = (((((!((map__22017 == null))))?(((((map__22017.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22017.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22017):map__22017);
var db = cljs.core.get.call(null,map__22017__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22018 = p__22016;
var _ = cljs.core.nth.call(null,vec__22018,(0),null);
var lists = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"lists","lists",-884730684),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086))], null));
var checked = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"checked","checked",-50955819)], null));
var selected_lists = cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.filter.call(null,((function (lists,checked,map__22017,map__22017__$1,db,vec__22018,_){
return (function (l){
return cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(l)]),checked);
});})(lists,checked,map__22017,map__22017__$1,db,vec__22018,_))
,lists));
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.save.im_list_delete.call(null,service,selected_lists),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","delete-lists-success","bluegenes.pages.mymine.events/delete-lists-success",802061929)], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","delete-lists-success","bluegenes.pages.mymine.events/delete-lists-success",802061929)], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","copy","bluegenes.pages.mymine.events/copy",-1773850281),(function (p__22022,p__22023){
var map__22024 = p__22022;
var map__22024__$1 = (((((!((map__22024 == null))))?(((((map__22024.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22024.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22024):map__22024);
var db = cljs.core.get.call(null,map__22024__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22025 = p__22023;
var _ = cljs.core.nth.call(null,vec__22025,(0),null);
var old_list_name = cljs.core.nth.call(null,vec__22025,(1),null);
var new_list_name = cljs.core.nth.call(null,vec__22025,(2),null);
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.save.im_list_copy.call(null,service,old_list_name,new_list_name),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-lists","assets/fetch-lists",833336064)], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","copy-failure","bluegenes.pages.mymine.events/copy-failure",-575316683)], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","delete-success","bluegenes.pages.mymine.events/delete-success",274261939),(function (p__22029,p__22030){
var map__22031 = p__22029;
var map__22031__$1 = (((((!((map__22031 == null))))?(((((map__22031.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22031.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22031):map__22031);
var db = cljs.core.get.call(null,map__22031__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22032 = p__22030;
var _ = cljs.core.nth.call(null,vec__22032,(0),null);
var trail = cljs.core.nth.call(null,vec__22032,(1),null);
var response = cljs.core.nth.call(null,vec__22032,(2),null);
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-lists","assets/fetch-lists",833336064),trail,response], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","rename-list","bluegenes.pages.mymine.events/rename-list",-872539888),(function (p__22036,p__22037){
var map__22038 = p__22036;
var map__22038__$1 = (((((!((map__22038 == null))))?(((((map__22038.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22038.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22038):map__22038);
var db = cljs.core.get.call(null,map__22038__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22039 = p__22037;
var _ = cljs.core.nth.call(null,vec__22039,(0),null);
var old_list_name = cljs.core.nth.call(null,vec__22039,(1),null);
var new_list_name = cljs.core.nth.call(null,vec__22039,(2),null);
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.save.im_list_rename.call(null,service,old_list_name,new_list_name),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-lists","assets/fetch-lists",833336064)], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","copy-failure","bluegenes.pages.mymine.events/copy-failure",-575316683)], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","delete","bluegenes.pages.mymine.events/delete",1058365344),(function (p__22043,p__22044){
var map__22045 = p__22043;
var map__22045__$1 = (((((!((map__22045 == null))))?(((((map__22045.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22045.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22045):map__22045);
var db = cljs.core.get.call(null,map__22045__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22046 = p__22044;
var _ = cljs.core.nth.call(null,vec__22046,(0),null);
var list_name = cljs.core.nth.call(null,vec__22046,(1),null);
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.send.delete_list.call(null,service,list_name),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-lists","assets/fetch-lists",833336064)], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","delete-failure","bluegenes.pages.mymine.events/delete-failure",1274745223)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","drag-over-old","bluegenes.pages.mymine.events/drag-over-old",-864418837),(function (db,p__22050){
var vec__22051 = p__22050;
var _ = cljs.core.nth.call(null,vec__22051,(0),null);
var trail = cljs.core.nth.call(null,vec__22051,(1),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"dragging-over","dragging-over",2079018400)], null),trail);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","drag-end","bluegenes.pages.mymine.events/drag-end",1563517332),(function (db,p__22054){
var vec__22055 = p__22054;
var _ = cljs.core.nth.call(null,vec__22055,(0),null);
var trail = cljs.core.nth.call(null,vec__22055,(1),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"dragging-over","dragging-over",2079018400)], null),null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","set-context-menu-target","bluegenes.pages.mymine.events/set-context-menu-target",-2127818399),(function (db,p__22058){
var vec__22059 = p__22058;
var _ = cljs.core.nth.call(null,vec__22059,(0),null);
var entity = cljs.core.nth.call(null,vec__22059,(1),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182)], null),cljs.core.assoc,new cljs.core.Keyword(null,"context-menu-target","context-menu-target",1544805853),entity);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","drop","bluegenes.pages.mymine.events/drop",-582694785),(function (p__22063,p__22064){
var map__22065 = p__22063;
var map__22065__$1 = (((((!((map__22065 == null))))?(((((map__22065.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22065.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22065):map__22065);
var db = cljs.core.get.call(null,map__22065__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22066 = p__22064;
var _ = cljs.core.nth.call(null,vec__22066,(0),null);
var trail = cljs.core.nth.call(null,vec__22066,(1),null);
var map__22070 = new cljs.core.Keyword(null,"mymine","mymine",279449182).cljs$core$IFn$_invoke$arity$1(db);
var map__22070__$1 = (((((!((map__22070 == null))))?(((((map__22070.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22070.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22070):map__22070);
var dragging = cljs.core.get.call(null,map__22070__$1,new cljs.core.Keyword(null,"dragging","dragging",1185097613));
var dragging_over = cljs.core.get.call(null,map__22070__$1,new cljs.core.Keyword(null,"dragging-over","dragging-over",2079018400));
var dragging_node = cljs.core.get.call(null,map__22070__$1,new cljs.core.Keyword(null,"dragging-node","dragging-node",-888671283));
var tree = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"tree","tree",-196312028)], null));
var drop_parent_folder = bluegenes.pages.mymine.events.parent_folder.call(null,tree,dragging_over);
var drag_type = new cljs.core.Keyword(null,"file-type","file-type",1274948820).cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,tree,dragging));
var drop_type = new cljs.core.Keyword(null,"file-type","file-type",1274948820).cljs$core$IFn$_invoke$arity$1(cljs.core.get_in.call(null,tree,dragging_over));
var dragging_id = cljs.core.keyword.call(null,[cljs.core.name.call(null,new cljs.core.Keyword(null,"file-type","file-type",1274948820).cljs$core$IFn$_invoke$arity$1(dragging_node)),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(dragging_node))].join(''));
if(cljs.core._EQ_.call(null,dragging,dragging_over)){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","drag-end","bluegenes.pages.mymine.events/drag-end",1563517332)], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"tree","tree",-196312028)], null),((function (tree,drop_parent_folder,drag_type,drop_type,dragging_id,map__22070,map__22070__$1,dragging,dragging_over,dragging_node,map__22065,map__22065__$1,db,vec__22066,_,trail){
return (function (p1__22062_SHARP_){
return cljs.core.update_in.call(null,bluegenes.pages.mymine.events.dissoc_in.call(null,p1__22062_SHARP_,new cljs.core.Keyword(null,"trail","trail",-272340561).cljs$core$IFn$_invoke$arity$1(dragging_node)),drop_parent_folder,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"children","children",-940561982),dragging_id], null),cljs.core.select_keys.call(null,dragging_node,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"file-type","file-type",1274948820),new cljs.core.Keyword(null,"id","id",-1388402092)], null)));
});})(tree,drop_parent_folder,drag_type,drop_type,dragging_id,map__22070,map__22070__$1,dragging,dragging_over,dragging_node,map__22065,map__22065__$1,db,vec__22066,_,trail))
),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","drag-end","bluegenes.pages.mymine.events/drag-end",1563517332)], null)], null)], null);

}
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","op-select-item","bluegenes.pages.mymine.events/op-select-item",1638460942),(function (db,p__22072){
var vec__22073 = p__22072;
var _ = cljs.core.nth.call(null,vec__22073,(0),null);
var id = cljs.core.nth.call(null,vec__22073,(1),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"list-operations","list-operations",149632779),new cljs.core.Keyword(null,"selected","selected",574897764)], null),((function (vec__22073,_,id){
return (function (s){
if((!((cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([id]),s) == null)))){
return cljs.core.remove.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([id]),s);
} else {
return cljs.core.conj.call(null,s,id);
}
});})(vec__22073,_,id))
);
}));
bluegenes.pages.mymine.events.toggle_set = (function bluegenes$pages$mymine$events$toggle_set(coll,k){
var s = cljs.core.set.call(null,coll);
if(cljs.core.contains_QMARK_.call(null,s,k)){
return cljs.core.set.call(null,cljs.core.remove.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([k]),s));
} else {
return cljs.core.set.call(null,cljs.core.conj.call(null,s,k));
}
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","toggle-checked","bluegenes.pages.mymine.events/toggle-checked",-1364553221),(function (db,p__22076){
var vec__22077 = p__22076;
var _ = cljs.core.nth.call(null,vec__22077,(0),null);
var id = cljs.core.nth.call(null,vec__22077,(1),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"checked","checked",-50955819)], null),bluegenes.pages.mymine.events.toggle_set,id);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","set-modal","bluegenes.pages.mymine.events/set-modal",-602136717),(function (db,p__22080){
var vec__22081 = p__22080;
var _ = cljs.core.nth.call(null,vec__22081,(0),null);
var modal_kw = cljs.core.nth.call(null,vec__22081,(1),null);
var a = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"checked","checked",-50955819)], null));
var lists = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("lists","filtered-lists","lists/filtered-lists",-1449136066)], null));
var sorted_lists = cljs.core.reverse.call(null,cljs.core.sort_by.call(null,new cljs.core.Keyword(null,"size","size",1098693007),cljs.core.filter.call(null,((function (a,lists,vec__22081,_,modal_kw){
return (function (l){
return cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(l)]),a);
});})(a,lists,vec__22081,_,modal_kw))
,cljs.core.deref.call(null,lists))));
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182)], null),cljs.core.assoc,new cljs.core.Keyword(null,"modal","modal",-1031880850),modal_kw,new cljs.core.Keyword(null,"suggested-state","suggested-state",1725521497),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.butlast.call(null,sorted_lists),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.last.call(null,sorted_lists)], null)], null));
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-combine","bluegenes.pages.mymine.events/lo-combine",-1894281563),(function (p__22084,p__22085){
var map__22086 = p__22084;
var map__22086__$1 = (((((!((map__22086 == null))))?(((((map__22086.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22086.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22086):map__22086);
var db = cljs.core.get.call(null,map__22086__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22087 = p__22085;
var _ = cljs.core.nth.call(null,vec__22087,(0),null);
var list_name = cljs.core.nth.call(null,vec__22087,(1),null);
var lists = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"lists","lists",-884730684),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086))], null));
var checked = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"checked","checked",-50955819)], null));
var selected_lists = cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.filter.call(null,((function (lists,checked,map__22086,map__22086__$1,db,vec__22087,_,list_name){
return (function (l){
return cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(l)]),checked);
});})(lists,checked,map__22086,map__22086__$1,db,vec__22087,_,list_name))
,lists));
var parent_id = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"entry-id","entry-id",591934358)], null));
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.save.im_list_union.call(null,service,list_name,selected_lists),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-success","bluegenes.pages.mymine.events/lo-success",-1703730790),parent_id], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-success","bluegenes.pages.mymine.events/lo-success",-1703730790)], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-intersect","bluegenes.pages.mymine.events/lo-intersect",803767098),(function (p__22091,p__22092){
var map__22093 = p__22091;
var map__22093__$1 = (((((!((map__22093 == null))))?(((((map__22093.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22093.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22093):map__22093);
var db = cljs.core.get.call(null,map__22093__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22094 = p__22092;
var _ = cljs.core.nth.call(null,vec__22094,(0),null);
var list_name = cljs.core.nth.call(null,vec__22094,(1),null);
var lists = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"lists","lists",-884730684),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086))], null));
var checked = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"checked","checked",-50955819)], null));
var selected_lists = cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.filter.call(null,((function (lists,checked,map__22093,map__22093__$1,db,vec__22094,_,list_name){
return (function (l){
return cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(l)]),checked);
});})(lists,checked,map__22093,map__22093__$1,db,vec__22094,_,list_name))
,lists));
var parent_id = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"entry-id","entry-id",591934358)], null));
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.save.im_list_intersect.call(null,service,list_name,selected_lists),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-success","bluegenes.pages.mymine.events/lo-success",-1703730790),parent_id], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-success","bluegenes.pages.mymine.events/lo-success",-1703730790)], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-difference","bluegenes.pages.mymine.events/lo-difference",2019487827),(function (p__22098,p__22099){
var map__22100 = p__22098;
var map__22100__$1 = (((((!((map__22100 == null))))?(((((map__22100.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22100.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22100):map__22100);
var db = cljs.core.get.call(null,map__22100__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22101 = p__22099;
var _ = cljs.core.nth.call(null,vec__22101,(0),null);
var list_name = cljs.core.nth.call(null,vec__22101,(1),null);
var lists = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"lists","lists",-884730684),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086))], null));
var checked = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"checked","checked",-50955819)], null));
var selected_lists = cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),cljs.core.filter.call(null,((function (lists,checked,map__22100,map__22100__$1,db,vec__22101,_,list_name){
return (function (l){
return cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([new cljs.core.Keyword(null,"id","id",-1388402092).cljs$core$IFn$_invoke$arity$1(l)]),checked);
});})(lists,checked,map__22100,map__22100__$1,db,vec__22101,_,list_name))
,lists));
var parent_id = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"entry-id","entry-id",591934358)], null));
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.save.im_list_difference.call(null,service,list_name,selected_lists),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-success","bluegenes.pages.mymine.events/lo-success",-1703730790),parent_id], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-success","bluegenes.pages.mymine.events/lo-success",-1703730790)], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-subtract","bluegenes.pages.mymine.events/lo-subtract",-200319930),(function (p__22105,p__22106){
var map__22107 = p__22105;
var map__22107__$1 = (((((!((map__22107 == null))))?(((((map__22107.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22107.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22107):map__22107);
var db = cljs.core.get.call(null,map__22107__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22108 = p__22106;
var _ = cljs.core.nth.call(null,vec__22108,(0),null);
var list_name = cljs.core.nth.call(null,vec__22108,(1),null);
var lists = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"lists","lists",-884730684),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086))], null));
var vec__22112 = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"suggested-state","suggested-state",1725521497)], null));
var lists_a = cljs.core.nth.call(null,vec__22112,(0),null);
var lists_b = cljs.core.nth.call(null,vec__22112,(1),null);
var selected_lists_a = cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),lists_a);
var selected_lists_b = cljs.core.map.call(null,new cljs.core.Keyword(null,"name","name",1843675177),lists_b);
var parent_id = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"cursor","cursor",1011937484),new cljs.core.Keyword(null,"entry-id","entry-id",591934358)], null));
var service = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)),new cljs.core.Keyword(null,"service","service",-1963054559)], null));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.save.im_list_subtraction.call(null,service,list_name,selected_lists_a,selected_lists_b),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-success","bluegenes.pages.mymine.events/lo-success",-1703730790),parent_id], null),new cljs.core.Keyword(null,"on-failure","on-failure",842888245),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-success","bluegenes.pages.mymine.events/lo-success",-1703730790)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-reverse-order","bluegenes.pages.mymine.events/lo-reverse-order",200265983),(function (db,p__22115){
var vec__22116 = p__22115;
var _ = cljs.core.nth.call(null,vec__22116,(0),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"suggested-state","suggested-state",1725521497)], null),cljs.core.comp.call(null,cljs.core.vec,cljs.core.reverse));
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-move-bucket","bluegenes.pages.mymine.events/lo-move-bucket",-2102811771),(function (db,p__22121){
var vec__22122 = p__22121;
var _ = cljs.core.nth.call(null,vec__22122,(0),null);
var from_pos = cljs.core.nth.call(null,vec__22122,(1),null);
var id = cljs.core.nth.call(null,vec__22122,(2),null);
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"suggested-state","suggested-state",1725521497),from_pos], null),((function (vec__22122,_,from_pos,id){
return (function (p1__22119_SHARP_){
return cljs.core.set.call(null,cljs.core.remove.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([id]),p1__22119_SHARP_));
});})(vec__22122,_,from_pos,id))
),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"suggested-state","suggested-state",1725521497),((cljs.core._EQ_.call(null,from_pos,(0)))?(1):(0))], null),((function (vec__22122,_,from_pos,id){
return (function (p1__22120_SHARP_){
return cljs.core.set.call(null,cljs.core.conj.call(null,p1__22120_SHARP_,id));
});})(vec__22122,_,from_pos,id))
);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","clear-checked","bluegenes.pages.mymine.events/clear-checked",986072818),(function (db){
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"checked","checked",-50955819)], null),cljs.core.PersistentHashSet.EMPTY);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","set-menu-target","bluegenes.pages.mymine.events/set-menu-target",-1863946198),(function (db,p__22125){
var vec__22126 = p__22125;
var _ = cljs.core.nth.call(null,vec__22126,(0),null);
var file_details = cljs.core.nth.call(null,vec__22126,(1),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182)], null),cljs.core.assoc,new cljs.core.Keyword(null,"menu-file-details","menu-file-details",-1885807542),file_details);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","lo-success","bluegenes.pages.mymine.events/lo-success",-1703730790),(function (p__22129,p__22130){
var map__22131 = p__22129;
var map__22131__$1 = (((((!((map__22131 == null))))?(((((map__22131.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22131.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22131):map__22131);
var db = cljs.core.get.call(null,map__22131__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22132 = p__22130;
var _ = cljs.core.nth.call(null,vec__22132,(0),null);
var parent_id = cljs.core.nth.call(null,vec__22132,(1),null);
var m = cljs.core.nth.call(null,vec__22132,(2),null);
var focus = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"focus","focus",234677911)], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","clear-checked","bluegenes.pages.mymine.events/clear-checked",986072818)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-lists","assets/fetch-lists",833336064)], null)], null),new cljs.core.Keyword("bluegenes.effects","http","bluegenes.effects/http",-1911287329),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"transit-params","transit-params",357261095),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"im-obj-type","im-obj-type",-1527355172),"list",new cljs.core.Keyword(null,"im-obj-id","im-obj-id",-1488125551),new cljs.core.Keyword(null,"listId","listId",1483084563).cljs$core$IFn$_invoke$arity$1(m),new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131),parent_id], null),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","success-store-tag","bluegenes.pages.mymine.events/success-store-tag",-740280429)], null),new cljs.core.Keyword(null,"uri","uri",-774711847),"/api/mymine/entries"], null)], null);
}));
/**
 * Recursively dissociate keys from a deep map
 *   (dissoc-nested-keys
 *    {:a {:x {:b {:c {}}}}, :d {:e {:x {:g {}}}, :h {}}}
 *    #{:x :h})
 *   => {:a {}, :d {:e {}}}
 */
bluegenes.pages.mymine.events.dissoc_nested_keys = (function bluegenes$pages$mymine$events$dissoc_nested_keys(m,key_col){
return clojure.walk.postwalk.call(null,(function (p1__22136_SHARP_){
if(cljs.core.map_QMARK_.call(null,p1__22136_SHARP_)){
return cljs.core.apply.call(null,cljs.core.dissoc,p1__22136_SHARP_,key_col);
} else {
return p1__22136_SHARP_;
}
}),m);
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","remove-ids-from-tree","bluegenes.pages.mymine.events/remove-ids-from-tree",-1800827243),(function (db,p__22137){
var vec__22138 = p__22137;
var _ = cljs.core.nth.call(null,vec__22138,(0),null);
var list_ids = cljs.core.nth.call(null,vec__22138,(1),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"tree","tree",-196312028)], null),bluegenes.pages.mymine.events.dissoc_nested_keys,list_ids);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","store-tag","bluegenes.pages.mymine.events/store-tag",1702035826),cljs.core.PersistentVector.EMPTY,(function (p__22141,p__22142){
var map__22143 = p__22141;
var map__22143__$1 = (((((!((map__22143 == null))))?(((((map__22143.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22143.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22143):map__22143);
var db = cljs.core.get.call(null,map__22143__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22144 = p__22142;
var _ = cljs.core.nth.call(null,vec__22144,(0),null);
var label = cljs.core.nth.call(null,vec__22144,(1),null);
var context_menu_target = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"context-menu-target","context-menu-target",1544805853)], null));
var mine_id = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword("bluegenes.effects","http","bluegenes.effects/http",-1911287329),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"transit-params","transit-params",357261095),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"im-obj-type","im-obj-type",-1527355172),"tag",new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131),new cljs.core.Keyword(null,"entry-id","entry-id",591934358).cljs$core$IFn$_invoke$arity$1(context_menu_target),new cljs.core.Keyword(null,"label","label",1718410804),label,new cljs.core.Keyword(null,"mine","mine",-130428525),cljs.core.name.call(null,mine_id),new cljs.core.Keyword(null,"open?","open?",1238443125),true], null),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","success-store-tag","bluegenes.pages.mymine.events/success-store-tag",-740280429)], null),new cljs.core.Keyword(null,"uri","uri",-774711847),"/api/mymine/entries"], null)], null);
}));
re_frame.core.reg_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","rederive-tags","bluegenes.pages.mymine.events/rederive-tags",833385168),(function (tags){
cljs.core.println.call(null,"rederiving",cljs.core.count.call(null,tags));

var seq__22148_22188 = cljs.core.seq.call(null,tags);
var chunk__22149_22189 = null;
var count__22150_22190 = (0);
var i__22151_22191 = (0);
while(true){
if((i__22151_22191 < count__22150_22190)){
var map__22164_22192 = cljs.core._nth.call(null,chunk__22149_22189,i__22151_22191);
var map__22164_22193__$1 = (((((!((map__22164_22192 == null))))?(((((map__22164_22192.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22164_22192.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22164_22192):map__22164_22192);
var entry_id_22194 = cljs.core.get.call(null,map__22164_22193__$1,new cljs.core.Keyword(null,"entry-id","entry-id",591934358));
var parent_id_22195 = cljs.core.get.call(null,map__22164_22193__$1,new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131));
var seq__22166_22196 = cljs.core.seq.call(null,cljs.core.ancestors.call(null,cljs.core.keyword.call(null,"tag",entry_id_22194)));
var chunk__22167_22197 = null;
var count__22168_22198 = (0);
var i__22169_22199 = (0);
while(true){
if((i__22169_22199 < count__22168_22198)){
var ancestor_22200 = cljs.core._nth.call(null,chunk__22167_22197,i__22169_22199);
cljs.core.underive.call(null,cljs.core.keyword.call(null,"tag",entry_id_22194),ancestor_22200);


var G__22201 = seq__22166_22196;
var G__22202 = chunk__22167_22197;
var G__22203 = count__22168_22198;
var G__22204 = (i__22169_22199 + (1));
seq__22166_22196 = G__22201;
chunk__22167_22197 = G__22202;
count__22168_22198 = G__22203;
i__22169_22199 = G__22204;
continue;
} else {
var temp__5457__auto___22205 = cljs.core.seq.call(null,seq__22166_22196);
if(temp__5457__auto___22205){
var seq__22166_22206__$1 = temp__5457__auto___22205;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22166_22206__$1)){
var c__4550__auto___22207 = cljs.core.chunk_first.call(null,seq__22166_22206__$1);
var G__22208 = cljs.core.chunk_rest.call(null,seq__22166_22206__$1);
var G__22209 = c__4550__auto___22207;
var G__22210 = cljs.core.count.call(null,c__4550__auto___22207);
var G__22211 = (0);
seq__22166_22196 = G__22208;
chunk__22167_22197 = G__22209;
count__22168_22198 = G__22210;
i__22169_22199 = G__22211;
continue;
} else {
var ancestor_22212 = cljs.core.first.call(null,seq__22166_22206__$1);
cljs.core.underive.call(null,cljs.core.keyword.call(null,"tag",entry_id_22194),ancestor_22212);


var G__22213 = cljs.core.next.call(null,seq__22166_22206__$1);
var G__22214 = null;
var G__22215 = (0);
var G__22216 = (0);
seq__22166_22196 = G__22213;
chunk__22167_22197 = G__22214;
count__22168_22198 = G__22215;
i__22169_22199 = G__22216;
continue;
}
} else {
}
}
break;
}


var G__22217 = seq__22148_22188;
var G__22218 = chunk__22149_22189;
var G__22219 = count__22150_22190;
var G__22220 = (i__22151_22191 + (1));
seq__22148_22188 = G__22217;
chunk__22149_22189 = G__22218;
count__22150_22190 = G__22219;
i__22151_22191 = G__22220;
continue;
} else {
var temp__5457__auto___22221 = cljs.core.seq.call(null,seq__22148_22188);
if(temp__5457__auto___22221){
var seq__22148_22222__$1 = temp__5457__auto___22221;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22148_22222__$1)){
var c__4550__auto___22223 = cljs.core.chunk_first.call(null,seq__22148_22222__$1);
var G__22224 = cljs.core.chunk_rest.call(null,seq__22148_22222__$1);
var G__22225 = c__4550__auto___22223;
var G__22226 = cljs.core.count.call(null,c__4550__auto___22223);
var G__22227 = (0);
seq__22148_22188 = G__22224;
chunk__22149_22189 = G__22225;
count__22150_22190 = G__22226;
i__22151_22191 = G__22227;
continue;
} else {
var map__22170_22228 = cljs.core.first.call(null,seq__22148_22222__$1);
var map__22170_22229__$1 = (((((!((map__22170_22228 == null))))?(((((map__22170_22228.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22170_22228.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22170_22228):map__22170_22228);
var entry_id_22230 = cljs.core.get.call(null,map__22170_22229__$1,new cljs.core.Keyword(null,"entry-id","entry-id",591934358));
var parent_id_22231 = cljs.core.get.call(null,map__22170_22229__$1,new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131));
var seq__22172_22232 = cljs.core.seq.call(null,cljs.core.ancestors.call(null,cljs.core.keyword.call(null,"tag",entry_id_22230)));
var chunk__22173_22233 = null;
var count__22174_22234 = (0);
var i__22175_22235 = (0);
while(true){
if((i__22175_22235 < count__22174_22234)){
var ancestor_22236 = cljs.core._nth.call(null,chunk__22173_22233,i__22175_22235);
cljs.core.underive.call(null,cljs.core.keyword.call(null,"tag",entry_id_22230),ancestor_22236);


var G__22237 = seq__22172_22232;
var G__22238 = chunk__22173_22233;
var G__22239 = count__22174_22234;
var G__22240 = (i__22175_22235 + (1));
seq__22172_22232 = G__22237;
chunk__22173_22233 = G__22238;
count__22174_22234 = G__22239;
i__22175_22235 = G__22240;
continue;
} else {
var temp__5457__auto___22241__$1 = cljs.core.seq.call(null,seq__22172_22232);
if(temp__5457__auto___22241__$1){
var seq__22172_22242__$1 = temp__5457__auto___22241__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22172_22242__$1)){
var c__4550__auto___22243 = cljs.core.chunk_first.call(null,seq__22172_22242__$1);
var G__22244 = cljs.core.chunk_rest.call(null,seq__22172_22242__$1);
var G__22245 = c__4550__auto___22243;
var G__22246 = cljs.core.count.call(null,c__4550__auto___22243);
var G__22247 = (0);
seq__22172_22232 = G__22244;
chunk__22173_22233 = G__22245;
count__22174_22234 = G__22246;
i__22175_22235 = G__22247;
continue;
} else {
var ancestor_22248 = cljs.core.first.call(null,seq__22172_22242__$1);
cljs.core.underive.call(null,cljs.core.keyword.call(null,"tag",entry_id_22230),ancestor_22248);


var G__22249 = cljs.core.next.call(null,seq__22172_22242__$1);
var G__22250 = null;
var G__22251 = (0);
var G__22252 = (0);
seq__22172_22232 = G__22249;
chunk__22173_22233 = G__22250;
count__22174_22234 = G__22251;
i__22175_22235 = G__22252;
continue;
}
} else {
}
}
break;
}


var G__22253 = cljs.core.next.call(null,seq__22148_22222__$1);
var G__22254 = null;
var G__22255 = (0);
var G__22256 = (0);
seq__22148_22188 = G__22253;
chunk__22149_22189 = G__22254;
count__22150_22190 = G__22255;
i__22151_22191 = G__22256;
continue;
}
} else {
}
}
break;
}

var seq__22176 = cljs.core.seq.call(null,tags);
var chunk__22177 = null;
var count__22178 = (0);
var i__22179 = (0);
while(true){
if((i__22179 < count__22178)){
var map__22184 = cljs.core._nth.call(null,chunk__22177,i__22179);
var map__22184__$1 = (((((!((map__22184 == null))))?(((((map__22184.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22184.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22184):map__22184);
var entry_id = cljs.core.get.call(null,map__22184__$1,new cljs.core.Keyword(null,"entry-id","entry-id",591934358));
var parent_id = cljs.core.get.call(null,map__22184__$1,new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131));
if(cljs.core.truth_((function (){var and__4120__auto__ = entry_id;
if(cljs.core.truth_(and__4120__auto__)){
return parent_id;
} else {
return and__4120__auto__;
}
})())){
cljs.core.derive.call(null,cljs.core.keyword.call(null,"tag",entry_id),cljs.core.keyword.call(null,"tag",parent_id));
} else {
}


var G__22257 = seq__22176;
var G__22258 = chunk__22177;
var G__22259 = count__22178;
var G__22260 = (i__22179 + (1));
seq__22176 = G__22257;
chunk__22177 = G__22258;
count__22178 = G__22259;
i__22179 = G__22260;
continue;
} else {
var temp__5457__auto__ = cljs.core.seq.call(null,seq__22176);
if(temp__5457__auto__){
var seq__22176__$1 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22176__$1)){
var c__4550__auto__ = cljs.core.chunk_first.call(null,seq__22176__$1);
var G__22261 = cljs.core.chunk_rest.call(null,seq__22176__$1);
var G__22262 = c__4550__auto__;
var G__22263 = cljs.core.count.call(null,c__4550__auto__);
var G__22264 = (0);
seq__22176 = G__22261;
chunk__22177 = G__22262;
count__22178 = G__22263;
i__22179 = G__22264;
continue;
} else {
var map__22186 = cljs.core.first.call(null,seq__22176__$1);
var map__22186__$1 = (((((!((map__22186 == null))))?(((((map__22186.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22186.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22186):map__22186);
var entry_id = cljs.core.get.call(null,map__22186__$1,new cljs.core.Keyword(null,"entry-id","entry-id",591934358));
var parent_id = cljs.core.get.call(null,map__22186__$1,new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131));
if(cljs.core.truth_((function (){var and__4120__auto__ = entry_id;
if(cljs.core.truth_(and__4120__auto__)){
return parent_id;
} else {
return and__4120__auto__;
}
})())){
cljs.core.derive.call(null,cljs.core.keyword.call(null,"tag",entry_id),cljs.core.keyword.call(null,"tag",parent_id));
} else {
}


var G__22265 = cljs.core.next.call(null,seq__22176__$1);
var G__22266 = null;
var G__22267 = (0);
var G__22268 = (0);
seq__22176 = G__22265;
chunk__22177 = G__22266;
count__22178 = G__22267;
i__22179 = G__22268;
continue;
}
} else {
return null;
}
}
break;
}
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","rederive","bluegenes.pages.mymine.events/rederive",-1066549170),(function (db,p__22269){
var vec__22270 = p__22269;
var _ = cljs.core.nth.call(null,vec__22270,(0),null);
var hierarchy = cljs.core.reduce.call(null,((function (vec__22270,_){
return (function (h,p__22273){
var map__22274 = p__22273;
var map__22274__$1 = (((((!((map__22274 == null))))?(((((map__22274.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22274.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22274):map__22274);
var entry_id = cljs.core.get.call(null,map__22274__$1,new cljs.core.Keyword(null,"entry-id","entry-id",591934358));
var parent_id = cljs.core.get.call(null,map__22274__$1,new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131));
if(cljs.core.truth_((function (){var and__4120__auto__ = entry_id;
if(cljs.core.truth_(and__4120__auto__)){
return parent_id;
} else {
return and__4120__auto__;
}
})())){
return cljs.core.derive.call(null,h,cljs.core.keyword.call(null,"tag",entry_id),cljs.core.keyword.call(null,"tag",parent_id));
} else {
return h;
}
});})(vec__22270,_))
,cljs.core.make_hierarchy.call(null),cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"entries","entries",-86943161)], null)));
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182)], null),cljs.core.assoc,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),hierarchy);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","success-store-tag","bluegenes.pages.mymine.events/success-store-tag",-740280429),(function (p__22277,p__22278){
var map__22279 = p__22277;
var map__22279__$1 = (((((!((map__22279 == null))))?(((((map__22279.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22279.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22279):map__22279);
var db = cljs.core.get.call(null,map__22279__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22280 = p__22278;
var _ = cljs.core.nth.call(null,vec__22280,(0),null);
var new_tags = cljs.core.nth.call(null,vec__22280,(1),null);
var new_db = cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"entries","entries",-86943161)], null),((function (map__22279,map__22279__$1,db,vec__22280,_,new_tags){
return (function (p1__22276_SHARP_){
return cljs.core.apply.call(null,cljs.core.conj,p1__22276_SHARP_,new_tags);
});})(map__22279,map__22279__$1,db,vec__22280,_,new_tags))
);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),new_db,new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","rederive","bluegenes.pages.mymine.events/rederive",-1066549170)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","delete-tag","bluegenes.pages.mymine.events/delete-tag",1310669384),cljs.core.PersistentVector.EMPTY,(function (p__22284,p__22285){
var map__22286 = p__22284;
var map__22286__$1 = (((((!((map__22286 == null))))?(((((map__22286.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22286.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22286):map__22286);
var db = cljs.core.get.call(null,map__22286__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22287 = p__22285;
var _ = cljs.core.nth.call(null,vec__22287,(0),null);
var label = cljs.core.nth.call(null,vec__22287,(1),null);
var context_menu_target = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"context-menu-target","context-menu-target",1544805853)], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword("bluegenes.effects","http","bluegenes.effects/http",-1911287329),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","success-delete-tag","bluegenes.pages.mymine.events/success-delete-tag",-1029624307)], null),new cljs.core.Keyword(null,"uri","uri",-774711847),["/api/mymine/entries/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"entry-id","entry-id",591934358).cljs$core$IFn$_invoke$arity$1(context_menu_target))].join('')], null)], null);
}));
bluegenes.pages.mymine.events.isa_filter = (function bluegenes$pages$mymine$events$isa_filter(root_id,entry){
var temp__5455__auto__ = new cljs.core.Keyword(null,"entry-id","entry-id",591934358).cljs$core$IFn$_invoke$arity$1(entry);
if(cljs.core.truth_(temp__5455__auto__)){
var entry_id = temp__5455__auto__;
return cljs.core.isa_QMARK_.call(null,cljs.core.keyword.call(null,"tag",entry_id),cljs.core.keyword.call(null,"tag",root_id));
} else {
return false;
}
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","success-delete-tag","bluegenes.pages.mymine.events/success-delete-tag",-1029624307),(function (p__22292,p__22293){
var map__22294 = p__22292;
var map__22294__$1 = (((((!((map__22294 == null))))?(((((map__22294.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22294.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22294):map__22294);
var db = cljs.core.get.call(null,map__22294__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22295 = p__22293;
var _ = cljs.core.nth.call(null,vec__22295,(0),null);
var vec__22298 = cljs.core.nth.call(null,vec__22295,(1),null);
var map__22301 = cljs.core.nth.call(null,vec__22298,(0),null);
var map__22301__$1 = (((((!((map__22301 == null))))?(((((map__22301.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22301.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22301):map__22301);
var entry_id = cljs.core.get.call(null,map__22301__$1,new cljs.core.Keyword(null,"entry-id","entry-id",591934358));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"entries","entries",-86943161)], null),((function (map__22294,map__22294__$1,db,vec__22295,_,vec__22298,map__22301,map__22301__$1,entry_id){
return (function (p1__22291_SHARP_){
return cljs.core.remove.call(null,cljs.core.partial.call(null,bluegenes.pages.mymine.events.isa_filter,entry_id),p1__22291_SHARP_);
});})(map__22294,map__22294__$1,db,vec__22295,_,vec__22298,map__22301,map__22301__$1,entry_id))
),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","rederive","bluegenes.pages.mymine.events/rederive",-1066549170)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","rename-tag","bluegenes.pages.mymine.events/rename-tag",1403202301),cljs.core.PersistentVector.EMPTY,(function (p__22304,p__22305){
var map__22306 = p__22304;
var map__22306__$1 = (((((!((map__22306 == null))))?(((((map__22306.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22306.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22306):map__22306);
var db = cljs.core.get.call(null,map__22306__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22307 = p__22305;
var _ = cljs.core.nth.call(null,vec__22307,(0),null);
var label = cljs.core.nth.call(null,vec__22307,(1),null);
var context_menu_target = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"context-menu-target","context-menu-target",1544805853)], null));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword("bluegenes.effects","http","bluegenes.effects/http",-1911287329),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","success-rename-tag","bluegenes.pages.mymine.events/success-rename-tag",-1333787315)], null),new cljs.core.Keyword(null,"uri","uri",-774711847),["/api/mymine/entries/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"entry-id","entry-id",591934358).cljs$core$IFn$_invoke$arity$1(context_menu_target)),"/rename/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(label)].join('')], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","success-rename-tag","bluegenes.pages.mymine.events/success-rename-tag",-1333787315),(function (db,p__22312){
var vec__22313 = p__22312;
var _ = cljs.core.nth.call(null,vec__22313,(0),null);
var vec__22316 = cljs.core.nth.call(null,vec__22313,(1),null);
var map__22319 = cljs.core.nth.call(null,vec__22316,(0),null);
var map__22319__$1 = (((((!((map__22319 == null))))?(((((map__22319.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22319.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22319):map__22319);
var response = map__22319__$1;
var entry_id = cljs.core.get.call(null,map__22319__$1,new cljs.core.Keyword(null,"entry-id","entry-id",591934358));
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"entries","entries",-86943161)], null),((function (vec__22313,_,vec__22316,map__22319,map__22319__$1,response,entry_id){
return (function (p1__22311_SHARP_){
return cljs.core.map.call(null,((function (vec__22313,_,vec__22316,map__22319,map__22319__$1,response,entry_id){
return (function (e){
if(cljs.core._EQ_.call(null,entry_id,new cljs.core.Keyword(null,"entry-id","entry-id",591934358).cljs$core$IFn$_invoke$arity$1(e))){
return response;
} else {
return e;
}
});})(vec__22313,_,vec__22316,map__22319,map__22319__$1,response,entry_id))
,p1__22311_SHARP_);
});})(vec__22313,_,vec__22316,map__22319,map__22319__$1,response,entry_id))
);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","fetch-tree","bluegenes.pages.mymine.events/fetch-tree",509161713),cljs.core.PersistentVector.EMPTY,(function (p__22321){
var map__22322 = p__22321;
var map__22322__$1 = (((((!((map__22322 == null))))?(((((map__22322.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22322.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22322):map__22322);
var db = cljs.core.get.call(null,map__22322__$1,new cljs.core.Keyword(null,"db","db",993250759));
var current_mine = cljs.core.name.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null)));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword("bluegenes.effects","http","bluegenes.effects/http",-1911287329),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","echo-tree","bluegenes.pages.mymine.events/echo-tree",2098059603)], null),new cljs.core.Keyword(null,"uri","uri",-774711847),["/api/mymine/entries/",current_mine].join('')], null)], null);
}));
bluegenes.pages.mymine.events.toggle_open = (function bluegenes$pages$mymine$events$toggle_open(entries,entry_id,status){
return cljs.core.map.call(null,(function (e){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"entry-id","entry-id",591934358).cljs$core$IFn$_invoke$arity$1(e),entry_id)){
return cljs.core.assoc.call(null,e,new cljs.core.Keyword(null,"open","open",-1763596448),status);
} else {
return e;
}
}),entries);
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","toggle-tag-open","bluegenes.pages.mymine.events/toggle-tag-open",1876220714),cljs.core.PersistentVector.EMPTY,(function (p__22324,p__22325){
var map__22326 = p__22324;
var map__22326__$1 = (((((!((map__22326 == null))))?(((((map__22326.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22326.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22326):map__22326);
var db = cljs.core.get.call(null,map__22326__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22327 = p__22325;
var _ = cljs.core.nth.call(null,vec__22327,(0),null);
var entry_id = cljs.core.nth.call(null,vec__22327,(1),null);
var status = cljs.core.nth.call(null,vec__22327,(2),null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"entries","entries",-86943161)], null),bluegenes.pages.mymine.events.toggle_open,entry_id,status),new cljs.core.Keyword("bluegenes.effects","http","bluegenes.effects/http",-1911287329),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"uri","uri",-774711847),["/api/mymine/entries/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(entry_id),"/open/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join('')], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","set-cursor","bluegenes.pages.mymine.events/set-cursor",1385503366),(function (db,p__22331){
var vec__22332 = p__22331;
var _ = cljs.core.nth.call(null,vec__22332,(0),null);
var entry = cljs.core.nth.call(null,vec__22332,(1),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"cursor","cursor",1011937484)], null),entry);
}));
/**
 * Recursively keywordize a value for a given key in a map
 *   (keywordize-filetypes {:one {:type folder :children {:three {:type file}}}
 *                       :two {:type file}}
 *   => {:one {:type :folder :children {:three {:type :file}}
 *    :two {:type :file}}
 */
bluegenes.pages.mymine.events.keywordize_value = (function bluegenes$pages$mymine$events$keywordize_value(m,kw){
return clojure.walk.postwalk.call(null,(function (p1__22335_SHARP_){
if(((cljs.core.map_QMARK_.call(null,p1__22335_SHARP_)) && (cljs.core.contains_QMARK_.call(null,p1__22335_SHARP_,new cljs.core.Keyword(null,"file-type","file-type",1274948820))))){
return cljs.core.update.call(null,p1__22335_SHARP_,kw,cljs.core.keyword);
} else {
return p1__22335_SHARP_;
}
}),m);
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","echo-tree","bluegenes.pages.mymine.events/echo-tree",2098059603),(function (db,p__22336){
var vec__22337 = p__22336;
var _ = cljs.core.nth.call(null,vec__22337,(0),null);
var response = cljs.core.nth.call(null,vec__22337,(1),null);
var hierarchy = cljs.core.reduce.call(null,((function (vec__22337,_,response){
return (function (h,p__22340,response__$1){
var map__22341 = p__22340;
var map__22341__$1 = (((((!((map__22341 == null))))?(((((map__22341.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22341.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22341):map__22341);
var entry_id = cljs.core.get.call(null,map__22341__$1,new cljs.core.Keyword(null,"entry-id","entry-id",591934358));
var parent_id = cljs.core.get.call(null,map__22341__$1,new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131));
if(cljs.core.truth_((function (){var and__4120__auto__ = entry_id;
if(cljs.core.truth_(and__4120__auto__)){
return parent_id;
} else {
return and__4120__auto__;
}
})())){
return cljs.core.derive.call(null,h,cljs.core.keyword.call(null,"tag",entry_id),cljs.core.keyword.call(null,"tag",parent_id));
} else {
return h;
}
});})(vec__22337,_,response))
,cljs.core.make_hierarchy.call(null),response);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182)], null),cljs.core.assoc,new cljs.core.Keyword(null,"entries","entries",-86943161),response,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),hierarchy);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","dragging","bluegenes.pages.mymine.events/dragging",102886225),(function (db,p__22343){
var vec__22344 = p__22343;
var _ = cljs.core.nth.call(null,vec__22344,(0),null);
var tag = cljs.core.nth.call(null,vec__22344,(1),null);
return cljs.core.update_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"drag","drag",449951290)], null),cljs.core.assoc,new cljs.core.Keyword(null,"dragging","dragging",1185097613),tag,new cljs.core.Keyword(null,"dragging?","dragging?",-995941410),true);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","dragging?","bluegenes.pages.mymine.events/dragging?",220356778),(function (db,p__22347){
var vec__22348 = p__22347;
var _ = cljs.core.nth.call(null,vec__22348,(0),null);
var value = cljs.core.nth.call(null,vec__22348,(1),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"drag","drag",449951290),new cljs.core.Keyword(null,"dragging?","dragging?",-995941410)], null),value);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","dragging-over","bluegenes.pages.mymine.events/dragging-over",577411444),(function (db,p__22351){
var vec__22352 = p__22351;
var _ = cljs.core.nth.call(null,vec__22352,(0),null);
var tag = cljs.core.nth.call(null,vec__22352,(1),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"drag","drag",449951290),new cljs.core.Keyword(null,"dragging-over","dragging-over",2079018400)], null),tag);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","dropping-on","bluegenes.pages.mymine.events/dropping-on",-2126491446),(function (p__22355,p__22356){
var map__22357 = p__22355;
var map__22357__$1 = (((((!((map__22357 == null))))?(((((map__22357.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22357.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22357):map__22357);
var db = cljs.core.get.call(null,map__22357__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22358 = p__22356;
var _ = cljs.core.nth.call(null,vec__22358,(0),null);
var tag = cljs.core.nth.call(null,vec__22358,(1),null);
var map__22362 = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"drag","drag",449951290),new cljs.core.Keyword(null,"dragging","dragging",1185097613)], null));
var map__22362__$1 = (((((!((map__22362 == null))))?(((((map__22362.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22362.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22362):map__22362);
var dragging = map__22362__$1;
var dragging_id = cljs.core.get.call(null,map__22362__$1,new cljs.core.Keyword(null,"entry-id","entry-id",591934358));
var map__22363 = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"drag","drag",449951290),new cljs.core.Keyword(null,"dragging-over","dragging-over",2079018400)], null));
var map__22363__$1 = (((((!((map__22363 == null))))?(((((map__22363.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22363.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22363):map__22363);
var dropping = map__22363__$1;
var dropping_id = cljs.core.get.call(null,map__22363__$1,new cljs.core.Keyword(null,"entry-id","entry-id",591934358));
var hierarchy = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341)], null));
var current_mine = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-mine","current-mine",-697419086)], null));
var noop = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"drag","drag",449951290)], null),null)], null);
if(cljs.core.isa_QMARK_.call(null,hierarchy,cljs.core.keyword.call(null,"tag",new cljs.core.Keyword(null,"entry-id","entry-id",591934358).cljs$core$IFn$_invoke$arity$1(dropping)),cljs.core.keyword.call(null,"tag",new cljs.core.Keyword(null,"entry-id","entry-id",591934358).cljs$core$IFn$_invoke$arity$1(dragging)))){
return noop;
} else {
if(cljs.core.not_EQ_.call(null,"tag",new cljs.core.Keyword(null,"im-obj-type","im-obj-type",-1527355172).cljs$core$IFn$_invoke$arity$1(dropping))){
return noop;
} else {
if((dragging_id == null)){
return cljs.core.assoc.call(null,noop,new cljs.core.Keyword("bluegenes.effects","http","bluegenes.effects/http",-1911287329),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"transit-params","transit-params",357261095),cljs.core.assoc.call(null,dragging,new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131),dropping_id,new cljs.core.Keyword(null,"mine","mine",-130428525),current_mine),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","success-store-tag","bluegenes.pages.mymine.events/success-store-tag",-740280429)], null),new cljs.core.Keyword(null,"uri","uri",-774711847),"/api/mymine/entries"], null));
} else {
if(cljs.core.not_EQ_.call(null,dragging_id,dropping_id)){
return cljs.core.assoc.call(null,noop,new cljs.core.Keyword("bluegenes.effects","http","bluegenes.effects/http",-1911287329),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","success-move-entry","bluegenes.pages.mymine.events/success-move-entry",-573152647)], null),new cljs.core.Keyword(null,"uri","uri",-774711847),["/api/mymine/entries/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dragging_id),"/move/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dropping_id)].join('')], null));
} else {
return noop;

}
}
}
}
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("bluegenes.pages.mymine.events","success-move-entry","bluegenes.pages.mymine.events/success-move-entry",-573152647),(function (p__22366,p__22367){
var map__22368 = p__22366;
var map__22368__$1 = (((((!((map__22368 == null))))?(((((map__22368.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22368.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22368):map__22368);
var db = cljs.core.get.call(null,map__22368__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__22369 = p__22367;
var _ = cljs.core.nth.call(null,vec__22369,(0),null);
var vec__22372 = cljs.core.nth.call(null,vec__22369,(1),null);
var map__22375 = cljs.core.nth.call(null,vec__22372,(0),null);
var map__22375__$1 = (((((!((map__22375 == null))))?(((((map__22375.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22375.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22375):map__22375);
var item = map__22375__$1;
var entry_id = cljs.core.get.call(null,map__22375__$1,new cljs.core.Keyword(null,"entry-id","entry-id",591934358));
var parent_id = cljs.core.get.call(null,map__22375__$1,new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131));
var new_entries = cljs.core.map.call(null,((function (map__22368,map__22368__$1,db,vec__22369,_,vec__22372,map__22375,map__22375__$1,item,entry_id,parent_id){
return (function (e){
if(cljs.core._EQ_.call(null,entry_id,new cljs.core.Keyword(null,"entry-id","entry-id",591934358).cljs$core$IFn$_invoke$arity$1(e))){
return cljs.core.assoc.call(null,e,new cljs.core.Keyword(null,"parent-id","parent-id",-1400729131),parent_id);
} else {
return e;
}
});})(map__22368,map__22368__$1,db,vec__22369,_,vec__22372,map__22375,map__22375__$1,item,entry_id,parent_id))
,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"entries","entries",-86943161)], null)));
var parent_tag = cljs.core.first.call(null,cljs.core.filter.call(null,cljs.core.comp.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([parent_id]),new cljs.core.Keyword(null,"entry-id","entry-id",591934358)),new_entries));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mymine","mymine",279449182),new cljs.core.Keyword(null,"entries","entries",-86943161)], null),new_entries),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","rederive","bluegenes.pages.mymine.events/rederive",-1066549170)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.pages.mymine.events","set-cursor","bluegenes.pages.mymine.events/set-cursor",1385503366),parent_tag], null)], null)], null);
}));

//# sourceMappingURL=events.js.map
