// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.components.idresolver.views');
goog.require('cljs.core');
goog.require('reagent.core');
goog.require('re_frame.core');
goog.require('json_html.core');
goog.require('dommy.core');
goog.require('clojure.string');
goog.require('bluegenes.components.icons');
goog.require('bluegenes.components.ui.results_preview');
goog.require('bluegenes.components.loader');
goog.require('bluegenes.components.imcontrols.views');
goog.require('bluegenes.components.lighttable');
goog.require('bluegenes.components.idresolver.events');
goog.require('bluegenes.components.idresolver.subs');
goog.require('oops.core');
goog.require('imcljs.path');
goog.require('bluegenes.route');
bluegenes.components.idresolver.views.separators = cljs.core.set.call(null,",; ");
bluegenes.components.idresolver.views.timeout = (1500);
bluegenes.components.idresolver.views.allowed_number_of_results = new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [(5),(10),(20),(50),(100),(250),(500)], null);
/**
 * Splits a string on any one of a set of strings.
 */
bluegenes.components.idresolver.views.splitter = (function bluegenes$components$idresolver$views$splitter(string){
return cljs.core.remove.call(null,(function (p1__16442_SHARP_){
return cljs.core._EQ_.call(null,"",p1__16442_SHARP_);
}),cljs.core.remove.call(null,cljs.core.nil_QMARK_,clojure.string.split.call(null,string,cljs.core.re_pattern.call(null,["[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.reduce.call(null,cljs.core.str,bluegenes.components.idresolver.views.separators)),"\\r?\\n]"].join('')))));
});
/**
 * Returns true if a string contains any one of a set of strings.
 */
bluegenes.components.idresolver.views.has_separator_QMARK_ = (function bluegenes$components$idresolver$views$has_separator_QMARK_(str){
return (!((cljs.core.some.call(null,bluegenes.components.idresolver.views.separators,str) == null)));
});
bluegenes.components.idresolver.views.controls = (function bluegenes$components$idresolver$views$controls(){
var results = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","results","idresolver/results",-1260032544)], null));
var matches = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","results-matches","idresolver/results-matches",-687985727)], null));
var selected = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","selected","idresolver/selected",986038403)], null));
return ((function (results,matches,selected){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.btn-toolbar.controls","div.btn-toolbar.controls",1700521048),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-warning","button.btn.btn-warning",1403209115),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),(((cljs.core.deref.call(null,results) == null))?"disabled":null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (results,matches,selected){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","clear","idresolver/clear",-2023765218)], null));
});})(results,matches,selected))
], null),"Clear all"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-warning","button.btn.btn-warning",1403209115),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),((cljs.core.empty_QMARK_.call(null,cljs.core.deref.call(null,selected)))?"disabled":null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (results,matches,selected){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","delete-selected","idresolver/delete-selected",1686185059)], null));
});})(results,matches,selected))
], null),["Remove selected (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count.call(null,cljs.core.deref.call(null,selected))),")"].join('')], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-primary.btn-raised","button.btn.btn-primary.btn-raised",1169755725),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),((cljs.core.empty_QMARK_.call(null,cljs.core.deref.call(null,matches)))?"disabled":null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (results,matches,selected){
return (function (){
if((!((cljs.core.deref.call(null,matches) == null)))){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","analyse","idresolver/analyse",121885821),true], null));
} else {
return null;
}
});})(results,matches,selected))
], null),"View Results"], null)], null);
});
;})(results,matches,selected))
});
bluegenes.components.idresolver.views.submit_input = (function bluegenes$components$idresolver$views$submit_input(var_args){
var G__16444 = arguments.length;
switch (G__16444) {
case 2:
return bluegenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return bluegenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

bluegenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$2 = (function (input,val){
cljs.core.reset_BANG_.call(null,val,"");

return bluegenes.components.idresolver.views.submit_input.call(null,input);
});

bluegenes.components.idresolver.views.submit_input.cljs$core$IFn$_invoke$arity$1 = (function (input){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","resolve","idresolver/resolve",-687028747),bluegenes.components.idresolver.views.splitter.call(null,input)], null));
});

bluegenes.components.idresolver.views.submit_input.cljs$lang$maxFixedArity = 2;

bluegenes.components.idresolver.views.input_box = (function bluegenes$components$idresolver$views$input_box(){
return reagent.core.create_class.call(null,(function (){var val = reagent.core.atom.call(null,null);
var timer = reagent.core.atom.call(null,null);
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (val,timer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input#identifierinput.freeform","input#identifierinput.freeform",-917091068),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"text",new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),"Type or paste identifiers here...",new cljs.core.Keyword(null,"value","value",305978217),cljs.core.deref.call(null,val),new cljs.core.Keyword(null,"on-key-press","on-key-press",-399563677),((function (val,timer){
return (function (e){
var keycode = e.charCode;
var input = e.target.value;
if(cljs.core._EQ_.call(null,keycode,(13))){
return bluegenes.components.idresolver.views.submit_input.call(null,input,val);
} else {
return null;
}
});})(val,timer))
,new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (val,timer){
return (function (e){
var input = e.target.value;
clearInterval(cljs.core.deref.call(null,timer));

cljs.core.reset_BANG_.call(null,timer,setTimeout(((function (input,val,timer){
return (function (){
return bluegenes.components.idresolver.views.submit_input.call(null,input,val);
});})(input,val,timer))
,bluegenes.components.idresolver.views.timeout));

if(bluegenes.components.idresolver.views.has_separator_QMARK_.call(null,input)){
clearInterval(cljs.core.deref.call(null,timer));

return bluegenes.components.idresolver.views.submit_input.call(null,input,val);
} else {
return cljs.core.reset_BANG_.call(null,val,input);
}
});})(val,timer))
], null)], null);
});})(val,timer))
,new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (val,timer){
return (function (this$){
return reagent.core.dom_node.call(null,this$).focus();
});})(val,timer))
], null);
})());
});
/**
 * Sometimes the ambiguity we're resolving with duplicate ids is the same symbol from two similar organisms, so we'll need to add organism name where known.
 */
bluegenes.components.idresolver.views.organism_identifier = (function bluegenes$components$idresolver$views$organism_identifier(summary){
if(cljs.core.truth_(new cljs.core.Keyword(null,"organism.name","organism.name",-38990119).cljs$core$IFn$_invoke$arity$1(summary))){
return [" (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"organism.name","organism.name",-38990119).cljs$core$IFn$_invoke$arity$1(summary)),")"].join('');
} else {
return "";
}
});
/**
 * Different objects types have different summary fields. Try to select one intelligently or fall back to primary identifier if the others ain't there.
 */
bluegenes.components.idresolver.views.build_duplicate_identifier = (function bluegenes$components$idresolver$views$build_duplicate_identifier(result){
var summary = new cljs.core.Keyword(null,"summary","summary",380847952).cljs$core$IFn$_invoke$arity$1(result);
var symbol = new cljs.core.Keyword(null,"symbol","symbol",-1038572696).cljs$core$IFn$_invoke$arity$1(summary);
var accession = new cljs.core.Keyword(null,"primaryAccession","primaryAccession",903870118).cljs$core$IFn$_invoke$arity$1(summary);
var primaryId = new cljs.core.Keyword(null,"primaryId","primaryId",-879235003).cljs$core$IFn$_invoke$arity$1(summary);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.first.call(null,cljs.core.remove.call(null,cljs.core.nil_QMARK_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [symbol,accession,primaryId], null)))),bluegenes.components.idresolver.views.organism_identifier.call(null,summary)].join('');
});
bluegenes.components.idresolver.views.input_item_duplicate = (function bluegenes$components$idresolver$views$input_item_duplicate(){

return (function (p__16446){
var vec__16447 = p__16446;
var oid = cljs.core.nth.call(null,vec__16447,(0),null);
var data = cljs.core.nth.call(null,vec__16447,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.id-item","span.id-item",-262191001),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.dropdown","span.dropdown",-220576694),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.dropdown-toggle","span.dropdown-toggle",1938356109),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"button",new cljs.core.Keyword(null,"data-toggle","data-toggle",436966687),"dropdown"], null),new cljs.core.Keyword(null,"input","input",556931961).cljs$core$IFn$_invoke$arity$1(data),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.caret","span.caret",-1405994877)], null)], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul.dropdown-menu","ul.dropdown-menu",-867384656)], null),cljs.core.map.call(null,((function (vec__16447,oid,data){
return (function (result){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (vec__16447,oid,data){
return (function (e){
e.preventDefault();

return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","resolve-duplicate","idresolver/resolve-duplicate",1623669668),new cljs.core.Keyword(null,"input","input",556931961).cljs$core$IFn$_invoke$arity$1(data),result], null));
});})(vec__16447,oid,data))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),bluegenes.components.idresolver.views.build_duplicate_identifier.call(null,result)], null)], null);
});})(vec__16447,oid,data))
,new cljs.core.Keyword(null,"matches","matches",635497998).cljs$core$IFn$_invoke$arity$1(data)))], null)], null);
});
});
bluegenes.components.idresolver.views.get_icon = (function bluegenes$components$idresolver$views$get_icon(icon_type){
var G__16450 = icon_type;
var G__16450__$1 = (((G__16450 instanceof cljs.core.Keyword))?G__16450.fqn:null);
switch (G__16450__$1) {
case "MATCH":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-checkmark.MATCH","svg.icon.icon-checkmark.MATCH",1989995608),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-checkmark"], null)], null)], null);

break;
case "UNRESOLVED":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-sad.UNRESOLVED","svg.icon.icon-sad.UNRESOLVED",-525280183),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-sad"], null)], null)], null);

break;
case "DUPLICATE":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-duplicate.DUPLICATE","svg.icon.icon-duplicate.DUPLICATE",-1988226297),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-duplicate"], null)], null)], null);

break;
case "TYPE_CONVERTED":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-converted.TYPE_CONVERTED","svg.icon.icon-converted.TYPE_CONVERTED",903653311),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-converted"], null)], null)], null);

break;
case "OTHER":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-arrow-right.OTHER","svg.icon.icon-arrow-right.OTHER",1016217138),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-arrow-right"], null)], null)], null);

break;
default:
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.loader.mini_loader,"tiny"], null);

}
});
bluegenes.components.idresolver.views.reasons = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"TYPE_CONVERTED","TYPE_CONVERTED",-1734724129),"we're searching for genes and you input a protein (or vice versa).",new cljs.core.Keyword(null,"OTHER","OTHER",-632033057)," the synonym you input is out of date."], null);
bluegenes.components.idresolver.views.input_item_converted = (function bluegenes$components$idresolver$views$input_item_converted(original,results){
var new_primary_id = cljs.core.get_in.call(null,results,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"matches","matches",635497998),(0),new cljs.core.Keyword(null,"summary","summary",380847952),new cljs.core.Keyword(null,"primaryIdentifier","primaryIdentifier",1592261948)], null));
var conversion_reason = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(results).call(null,bluegenes.components.idresolver.views.reasons);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.id-item","span.id-item",-262191001),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"title","title",636505583),["You input '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(original),"', but we converted it to '",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new_primary_id),"', because ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(conversion_reason)].join('')], null),original," -> ",new_primary_id], null);
});
bluegenes.components.idresolver.views.input_item = (function bluegenes$components$idresolver$views$input_item(p__16452){
var map__16453 = p__16452;
var map__16453__$1 = (((((!((map__16453 == null))))?(((((map__16453.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16453.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16453):map__16453);
var i = map__16453__$1;
var input = cljs.core.get.call(null,map__16453__$1,new cljs.core.Keyword(null,"input","input",556931961));

var result = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","results-item","idresolver/results-item",1437139681),input], null));
var selected = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","selected","idresolver/selected",986038403)], null));
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (result,selected,map__16453,map__16453__$1,i,input){
return (function (){
return null;
});})(result,selected,map__16453,map__16453__$1,i,input))
,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (result,selected,map__16453,map__16453__$1,i,input){
return (function (i__$1){
var result_vals = cljs.core.second.call(null,cljs.core.first.call(null,cljs.core.deref.call(null,result)));
var class$ = ((cljs.core.empty_QMARK_.call(null,cljs.core.deref.call(null,result)))?"inactive":cljs.core.name.call(null,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(result_vals)));
var class$__$1 = (cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([input]),cljs.core.deref.call(null,selected)))?[class$," selected"].join(''):class$);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.id-resolver-item-container","div.id-resolver-item-container",-2043176461),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(cljs.core.some.call(null,cljs.core.PersistentHashSet.createAsIfByAssoc([input]),cljs.core.deref.call(null,selected)))?"selected":null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.id-resolver-item","div.id-resolver-item",262679076),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),class$__$1,new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (result_vals,class$,class$__$1,result,selected,map__16453,map__16453__$1,i,input){
return (function (e){
e.preventDefault();

e.stopPropagation();

return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","toggle-selected","idresolver/toggle-selected",-1284989402),input], null));
});})(result_vals,class$,class$__$1,result,selected,map__16453,map__16453__$1,i,input))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.get_icon,new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(result_vals)], null),(function (){var G__16455 = new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(result_vals);
var G__16455__$1 = (((G__16455 instanceof cljs.core.Keyword))?G__16455.fqn:null);
switch (G__16455__$1) {
case "DUPLICATE":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.input_item_duplicate,cljs.core.first.call(null,cljs.core.deref.call(null,result))], null);

break;
case "TYPE_CONVERTED":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.input_item_converted,new cljs.core.Keyword(null,"input","input",556931961).cljs$core$IFn$_invoke$arity$1(i__$1),result_vals], null);

break;
case "OTHER":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.input_item_converted,new cljs.core.Keyword(null,"input","input",556931961).cljs$core$IFn$_invoke$arity$1(i__$1),result_vals], null);

break;
case "MATCH":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.id-item","span.id-item",-262191001),new cljs.core.Keyword(null,"input","input",556931961).cljs$core$IFn$_invoke$arity$1(i__$1)], null);

break;
default:
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.id-item","span.id-item",-262191001),new cljs.core.Keyword(null,"input","input",556931961).cljs$core$IFn$_invoke$arity$1(i__$1)], null);

}
})()], null)], null);
});})(result,selected,map__16453,map__16453__$1,i,input))
], null));
});
bluegenes.components.idresolver.views.parse_files = (function bluegenes$components$idresolver$views$parse_files(files){
var n__4607__auto__ = files.length;
var i = (0);
while(true){
if((i < n__4607__auto__)){
var rdr_16457 = (new FileReader());
var the_file_16458 = (files[i]);
rdr_16457.onload = ((function (i,rdr_16457,the_file_16458,n__4607__auto__){
return (function (e){
var file_content = e.target.result;
var file_name = ((cljs.core._EQ_.call(null,";;; ",file_content.substr((0),(4))))?(function (){var idx = file_content.indexOf("\n\n");
return file_content.slice((4),idx);
})():the_file_16458.name);
return bluegenes.components.idresolver.views.submit_input.call(null,file_content);
});})(i,rdr_16457,the_file_16458,n__4607__auto__))
;

rdr_16457.readAsText(the_file_16458);

var G__16459 = (i + (1));
i = G__16459;
continue;
} else {
return null;
}
break;
}
});
bluegenes.components.idresolver.views.handle_drag_over = (function bluegenes$components$idresolver$views$handle_drag_over(state_atom,evt){
cljs.core.reset_BANG_.call(null,state_atom,true);

evt.stopPropagation();

evt.preventDefault();

return evt.dataTransfer.dropEffect = "copy";
});
bluegenes.components.idresolver.views.handle_drop_over = (function bluegenes$components$idresolver$views$handle_drop_over(state_atom,evt){
cljs.core.reset_BANG_.call(null,state_atom,false);

evt.stopPropagation();

evt.preventDefault();

var files = evt.dataTransfer.files;
return bluegenes.components.idresolver.views.parse_files.call(null,files);
});
/**
 * Convert the top level of a javascript object to clojurescript.
 *   Unconditionally attempts on any js property, unlike js->clj
 */
bluegenes.components.idresolver.views.obj__GT_clj = (function bluegenes$components$idresolver$views$obj__GT_clj(obj){
return cljs.core.reduce.call(null,(function (m,k){
return cljs.core.assoc.call(null,m,cljs.core.keyword.call(null,k),(function (){var target_obj_16460 = obj;
var _STAR_runtime_state_STAR__orig_val__16461 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16462 = oops.state.prepare_state.call(null,target_obj_16460,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16462;

try{return oops.core.get_selector_dynamically.call(null,target_obj_16460,k);
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16461;
}})());
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.js_keys.call(null,obj));
});
bluegenes.components.idresolver.views.bytes__GT_size = (function bluegenes$components$idresolver$views$bytes__GT_size(bytes){
var sizes = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bytes","KB","MB","GB","TB"], null);
if(cljs.core._EQ_.call(null,bytes,(0))){
return "0 bytes";
} else {
var idx = parseInt(Math.floor((Math.log(bytes) / Math.log((1000)))));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(Math.round((bytes / Math.pow((1000),idx)),(2)))," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.nth.call(null,sizes,idx))].join('');
}
});
bluegenes.components.idresolver.views.file = (function bluegenes$components$idresolver$views$file(){
return (function (js_File){
var file = bluegenes.components.idresolver.views.obj__GT_clj.call(null,js_File);
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr.file","tr.file",1127839198),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.file-name","td.file-name",-1518837968),new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(file)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.file-size","td.file-size",1569342049),bluegenes.components.idresolver.views.bytes__GT_size.call(null,new cljs.core.Keyword(null,"size","size",1098693007).cljs$core$IFn$_invoke$arity$1(file))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td.remove-file","td.remove-file",-2111080253),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (file){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","unstage-file","bluegenes.components.idresolver.events/unstage-file",-892329081),js_File], null));
});})(file))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-close","svg.icon.icon-close",1818295028),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-close"], null)], null)], null)], null)], null)], null);
});
});
bluegenes.components.idresolver.views.file_manager = (function bluegenes$components$idresolver$views$file_manager(){
var files = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","staged-files","bluegenes.components.idresolver.subs/staged-files",1965321262)], null));
var textbox_identifiers = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","textbox-identifiers","bluegenes.components.idresolver.subs/textbox-identifiers",-1613979036)], null));
var stage_options = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","stage-options","bluegenes.components.idresolver.subs/stage-options",-575862054)], null));
var stage_status = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","stage-status","bluegenes.components.idresolver.subs/stage-status",-1857712359)], null));
var upload_elem = reagent.core.atom.call(null,null);
return ((function (files,textbox_identifiers,stage_options,stage_status,upload_elem){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.file-manager","div.file-manager",-2119545101),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input.hidden","input.hidden",798529811),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"file",new cljs.core.Keyword(null,"ref","ref",1289896967),((function (files,textbox_identifiers,stage_options,stage_status,upload_elem){
return (function (e){
return cljs.core.reset_BANG_.call(null,upload_elem,e);
});})(files,textbox_identifiers,stage_options,stage_status,upload_elem))
,new cljs.core.Keyword(null,"multiple","multiple",1244445549),true,new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (files,textbox_identifiers,stage_options,stage_status,upload_elem){
return (function (e){
return e.stopPropagation();
});})(files,textbox_identifiers,stage_options,stage_status,upload_elem))
,new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (files,textbox_identifiers,stage_options,stage_status,upload_elem){
return (function (e){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","stage-files","bluegenes.components.idresolver.events/stage-files",-1712075782),(function (){var target_obj_16463 = e;
var _STAR_runtime_state_STAR__orig_val__16466 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16467 = oops.state.prepare_state.call(null,target_obj_16463,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16467;

try{var next_obj_16464 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_16463,(0),"target",true))?(target_obj_16463["target"]):null);
var next_obj_16465 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_16464,(0),"files",true))?(next_obj_16464["files"]):null);
return next_obj_16465;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16466;
}})()], null));
});})(files,textbox_identifiers,stage_options,stage_status,upload_elem))
], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form-group.file-list","div.form-group.file-list",-1888009364),(cljs.core.truth_(cljs.core.deref.call(null,files))?cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.files","table.files",206217284),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),"File name"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),"Size"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566)], null)], null)], null)], null),cljs.core.map.call(null,((function (files,textbox_identifiers,stage_options,stage_status,upload_elem){
return (function (js_File){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.file,js_File], null);
});})(files,textbox_identifiers,stage_options,stage_status,upload_elem))
,cljs.core.deref.call(null,files))):null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-default.btn-raised","button.btn.btn-default.btn-raised",-821049047),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (files,textbox_identifiers,stage_options,stage_status,upload_elem){
return (function (){
var target_obj_16468 = $(cljs.core.deref.call(null,upload_elem));
var _STAR_runtime_state_STAR__orig_val__16472 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16473 = oops.state.prepare_state.call(null,target_obj_16468,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16473;

try{var call_info_16470 = [target_obj_16468,(function (){var next_obj_16471 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_16468,(0),"click",true))?(target_obj_16468["click"]):null);
return next_obj_16471;
})()];
var fn_16469 = (call_info_16470[(1)]);
if(oops.core.validate_fn_call_dynamically.call(null,fn_16469,oops.state.get_last_access_modifier.call(null))){
if((!((fn_16469 == null)))){
return fn_16469.call((call_info_16470[(0)]));
} else {
return null;
}
} else {
return null;
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16472;
}});})(files,textbox_identifiers,stage_options,stage_status,upload_elem))
,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),cljs.core.deref.call(null,textbox_identifiers)], null),(cljs.core.truth_(cljs.core.deref.call(null,files))?"Add more files":"Browse")], null)], null)], null);
});
;})(files,textbox_identifiers,stage_options,stage_status,upload_elem))
});
bluegenes.components.idresolver.views.debugger$ = (function bluegenes$components$idresolver$views$debugger(){
var everything = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","everything","idresolver/everything",-1333535266)], null));
return ((function (everything){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),json_html.core.edn__GT_hiccup.call(null,cljs.core.deref.call(null,everything))], null);
});
;})(everything))
});
bluegenes.components.idresolver.views.selected = (function bluegenes$components$idresolver$views$selected(){
var selected = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","selected","idresolver/selected",986038403)], null));
return ((function (selected){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"selected: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,selected))], null);
});
;})(selected))
});
bluegenes.components.idresolver.views.delete_selected_handler = (function bluegenes$components$idresolver$views$delete_selected_handler(e){
var keycode = e.charCode;
if(cljs.core._EQ_.call(null,keycode,(127))){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","delete-selected","idresolver/delete-selected",1686185059)], null));
} else {
return null;

}
});
bluegenes.components.idresolver.views.key_down_handler = (function bluegenes$components$idresolver$views$key_down_handler(e){
var G__16474 = e.keyIdentifier;
switch (G__16474) {
case "Control":
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","toggle-select-multi","idresolver/toggle-select-multi",-902411003),true], null));

break;
case "Shift":
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","toggle-select-range","idresolver/toggle-select-range",-569308805),true], null));

break;
default:
return null;

}
});
bluegenes.components.idresolver.views.key_up_handler = (function bluegenes$components$idresolver$views$key_up_handler(e){
var G__16476 = e.keyIdentifier;
switch (G__16476) {
case "Control":
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","toggle-select-multi","idresolver/toggle-select-multi",-902411003),false], null));

break;
case "Shift":
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","toggle-select-range","idresolver/toggle-select-range",-569308805),false], null));

break;
default:
return null;

}
});
bluegenes.components.idresolver.views.attach_body_events = (function bluegenes$components$idresolver$views$attach_body_events(){
dommy.core.unlisten_BANG_.call(null,document.body,new cljs.core.Keyword(null,"keypress","keypress",1625181642),bluegenes.components.idresolver.views.delete_selected_handler);

dommy.core.listen_BANG_.call(null,document.body,new cljs.core.Keyword(null,"keypress","keypress",1625181642),bluegenes.components.idresolver.views.delete_selected_handler);

dommy.core.unlisten_BANG_.call(null,document.body,new cljs.core.Keyword(null,"keydown","keydown",-629268186),bluegenes.components.idresolver.views.key_down_handler);

dommy.core.listen_BANG_.call(null,document.body,new cljs.core.Keyword(null,"keydown","keydown",-629268186),bluegenes.components.idresolver.views.key_down_handler);

dommy.core.unlisten_BANG_.call(null,document.body,new cljs.core.Keyword(null,"keyup","keyup",-794526927),bluegenes.components.idresolver.views.key_up_handler);

return dommy.core.listen_BANG_.call(null,document.body,new cljs.core.Keyword(null,"keyup","keyup",-794526927),bluegenes.components.idresolver.views.key_up_handler);
});
bluegenes.components.idresolver.views.preview = (function bluegenes$components$idresolver$views$preview(result_count){
var results_preview = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","results-preview","idresolver/results-preview",-261870087)], null));
var fetching_preview_QMARK_ = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","fetching-preview?","idresolver/fetching-preview?",-1510187608)], null));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4.title","h4.title",-103059385),"Results preview:",new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"small.pull-right","small.pull-right",-2103656636),"Showing ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.count","span.count",1779679026),(function (){var x__4222__auto__ = (5);
var y__4223__auto__ = result_count;
return ((x__4222__auto__ < y__4223__auto__) ? x__4222__auto__ : y__4223__auto__);
})()], null)," of ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.count","span.count",1779679026),result_count], null)," Total Good Identifiers. ",(((result_count > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (results_preview,fetching_preview_QMARK_){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("idresolver","analyse","idresolver/analyse",121885821),true], null));
});})(results_preview,fetching_preview_QMARK_))
], null),"View all >>"], null):null)], null)], null),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.ui.results_preview.preview_table,new cljs.core.Keyword(null,"loading?","loading?",1905707049),cljs.core.deref.call(null,fetching_preview_QMARK_),new cljs.core.Keyword(null,"query-results","query-results",-1517559354),cljs.core.deref.call(null,results_preview)], null)], null);
});
bluegenes.components.idresolver.views.select_organism_option = (function bluegenes$components$idresolver$views$select_organism_option(){
return (function (organism,disable_organism_QMARK_){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form-group","div.form-group",-1721134770),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),"Organism"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.imcontrols.views.select_organism,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"value","value",305978217),organism,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disable_organism_QMARK_,new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(disable_organism_QMARK_)?"disabled":null),new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (organism__$1){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-option","bluegenes.components.idresolver.events/update-option",-193211275),new cljs.core.Keyword(null,"organism","organism",-896952862),organism__$1], null));
})], null)], null)], null);
});
});
bluegenes.components.idresolver.views.select_type_option = (function bluegenes$components$idresolver$views$select_type_option(){
var model = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-model","current-model",-1288511749)], null));
return ((function (model){
return (function (type){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form-group","div.form-group",-1721134770),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),"List type"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.imcontrols.views.select_type,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"value","value",305978217),type,new cljs.core.Keyword(null,"qualified?","qualified?",-1340522244),true,new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (model){
return (function (type__$1){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-type","bluegenes.components.idresolver.events/update-type",-897326475),cljs.core.deref.call(null,model),type__$1], null));
});})(model))
], null)], null)], null);
});
;})(model))
});
bluegenes.components.idresolver.views.case_sensitive_option = (function bluegenes$components$idresolver$views$case_sensitive_option(){
return (function (bool){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.clearfix","div.clearfix",1775605822),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form-group","div.form-group",-1721134770),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"for","for",-1323786319),"caseSensitiveCheckbox"], null),"Identifiers are case sensitive"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input#caseSensitiveCheckbox","input#caseSensitiveCheckbox",843251110),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"checked","checked",-50955819),bool,new cljs.core.Keyword(null,"on-change","on-change",-732046149),(function (e){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-option","bluegenes.components.idresolver.events/update-option",-193211275),new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404),(function (){var target_obj_16478 = e;
var _STAR_runtime_state_STAR__orig_val__16481 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16482 = oops.state.prepare_state.call(null,target_obj_16478,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16482;

try{var next_obj_16479 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_16478,(0),"target",true))?(target_obj_16478["target"]):null);
var next_obj_16480 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_16479,(0),"checked",true))?(next_obj_16479["checked"]):null);
return next_obj_16480;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16481;
}})()], null));
})], null)], null)], null)], null);
});
});
bluegenes.components.idresolver.views.guidance = (function bluegenes$components$idresolver$views$guidance(){

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.guidance-and-title","div.guidance-and-title",-65528406),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h2","h2",-372662728),"Create a new list"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.list-upload-guidance","div.list-upload-guidance",1970092995),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-info","svg.icon.icon-info",-297708043),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-info"], null)], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"Select the type of list to create and then enter your identifiers or upload them from a file."], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),"Separate identifiers by a comma, space, tab or new line"], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),"Qualify any identifiers that contain whitespace with double quotes like so: \"even skipped\""], null)], null)], null)], null)], null);
});
bluegenes.components.idresolver.views.upload_step = (function bluegenes$components$idresolver$views$upload_step(){
var files = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","staged-files","bluegenes.components.idresolver.subs/staged-files",1965321262)], null));
var textbox_identifiers = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","textbox-identifiers","bluegenes.components.idresolver.subs/textbox-identifiers",-1613979036)], null));
var options = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","stage-options","bluegenes.components.idresolver.subs/stage-options",-575862054)], null));
var tab = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","upload-tab","bluegenes.components.idresolver.subs/upload-tab",865745514)], null));
return ((function (files,textbox_identifiers,options,tab){
return (function (){
var map__16483 = cljs.core.deref.call(null,options);
var map__16483__$1 = (((((!((map__16483 == null))))?(((((map__16483.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16483.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16483):map__16483);
var organism = cljs.core.get.call(null,map__16483__$1,new cljs.core.Keyword(null,"organism","organism",-896952862));
var type = cljs.core.get.call(null,map__16483__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var case_sensitive = cljs.core.get.call(null,map__16483__$1,new cljs.core.Keyword(null,"case-sensitive","case-sensitive",-1005239404));
var disable_organism_QMARK_ = cljs.core.get.call(null,map__16483__$1,new cljs.core.Keyword(null,"disable-organism?","disable-organism?",-1464416122));
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.id-resolver","div.id-resolver",-86662680),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.guidance], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.input-info","div.input-info",1701661822),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.select-organism-and-list-type","div.select-organism-and-list-type",-657602540),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.select_type_option,type], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.select_organism_option,organism,disable_organism_QMARK_], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.case_sensitive_option,case_sensitive], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.identifier-input","div.identifier-input",1364262378),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul.nav.nav-tabs","ul.nav.nav-tabs",1865557319),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),(function (){var G__16485 = "";
var G__16485__$1 = ((cljs.core._EQ_.call(null,cljs.core.deref.call(null,tab),null))?[G__16485," active"].join(''):G__16485);
if(cljs.core.truth_(cljs.core.deref.call(null,files))){
return [G__16485__$1,"disabled"].join('');
} else {
return G__16485__$1;
}
})(),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab){
return (function (){
if(cljs.core.truth_(cljs.core.deref.call(null,files))){
return null;
} else {
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-option","bluegenes.components.idresolver.events/update-option",-193211275),new cljs.core.Keyword(null,"upload-tab","upload-tab",1083528988),null], null));
}
});})(map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab))
,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),true], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-free-text","svg.icon.icon-free-text",-1148900077),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-free-text"], null)], null)], null)," Free Text"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"class","class",-2030961996),(function (){var G__16486 = "";
var G__16486__$1 = ((cljs.core._EQ_.call(null,cljs.core.deref.call(null,tab),new cljs.core.Keyword(null,"file","file",-1269645878)))?[G__16486," active"].join(''):G__16486);
if(cljs.core.truth_(cljs.core.deref.call(null,textbox_identifiers))){
return [G__16486__$1,"disabled"].join('');
} else {
return G__16486__$1;
}
})(),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab){
return (function (){
if(cljs.core.truth_(cljs.core.deref.call(null,textbox_identifiers))){
return null;
} else {
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-option","bluegenes.components.idresolver.events/update-option",-193211275),new cljs.core.Keyword(null,"upload-tab","upload-tab",1083528988),new cljs.core.Keyword(null,"file","file",-1269645878)], null));
}
});})(map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab))
,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),true], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-upload","svg.icon.icon-upload",1211481110),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-upload"], null)], null)], null)," File Upload"], null)], null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form-group.nav-tab-body","div.form-group.nav-tab-body",-335702547),(function (){var G__16487 = cljs.core.deref.call(null,tab);
var G__16487__$1 = (((G__16487 instanceof cljs.core.Keyword))?G__16487.fqn:null);
switch (G__16487__$1) {
case "file":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.file_manager], null);

break;
default:
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea.form-control","textarea.form-control",-1690362789),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (G__16487,G__16487__$1,map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab){
return (function (e){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-textbox-identifiers","bluegenes.components.idresolver.events/update-textbox-identifiers",381203856),(function (){var target_obj_16488 = e;
var _STAR_runtime_state_STAR__orig_val__16491 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16492 = oops.state.prepare_state.call(null,target_obj_16488,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16492;

try{var next_obj_16489 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_16488,(0),"target",true))?(target_obj_16488["target"]):null);
var next_obj_16490 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_16489,(0),"value",true))?(next_obj_16489["value"]):null);
return next_obj_16490;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16491;
}})()], null));
});})(G__16487,G__16487__$1,map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab))
,new cljs.core.Keyword(null,"value","value",305978217),cljs.core.deref.call(null,textbox_identifiers),new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(cljs.core.deref.call(null,files))?"disabled":null),new cljs.core.Keyword(null,"spellCheck","spellCheck",331078550),false,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),cljs.core.deref.call(null,files),new cljs.core.Keyword(null,"rows","rows",850049680),(5)], null)], null);

}
})()], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.btn-toolbar.wizard-toolbar","div.btn-toolbar.wizard-toolbar",1596558885),(function (){var example_QMARK_ = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","example?","bluegenes.components.idresolver.subs/example?",1854722474)], null));
if(cljs.core.truth_(cljs.core.deref.call(null,example_QMARK_))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-default.btn-raised","button.btn.btn-default.btn-raised",-821049047),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (example_QMARK_,map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","load-example","bluegenes.components.idresolver.events/load-example",1995179979)], null));
});})(example_QMARK_,map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab))
], null),"Example"], null);
} else {
return console.debug("No example button available due to missing or misconfigured example in the InterMine properties");
}
})(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-default.btn-raised","button.btn.btn-default.btn-raised",-821049047),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","reset","bluegenes.components.idresolver.events/reset",-1099948562)], null));
});})(map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab))
], null),"Reset"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-primary.btn-raised","button.btn.btn-primary.btn-raised",1169755725),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","parse-staged-files","bluegenes.components.idresolver.events/parse-staged-files",72538523),cljs.core.deref.call(null,files),cljs.core.deref.call(null,textbox_identifiers),cljs.core.deref.call(null,options)], null));
});})(map__16483,map__16483__$1,organism,type,case_sensitive,disable_organism_QMARK_,files,textbox_identifiers,options,tab))
,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),(((((cljs.core.deref.call(null,files) == null)) && ((cljs.core.deref.call(null,textbox_identifiers) == null))))?true:null)], null),"Continue"], null)], null)], null)], null)], null);
});
;})(files,textbox_identifiers,options,tab))
});
bluegenes.components.idresolver.views.paginator = (function bluegenes$components$idresolver$views$paginator(){
return (function (pager,results){
var pages = Math.ceil((cljs.core.count.call(null,results) / new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))));
var rows_in_view = cljs.core.take.call(null,new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)),cljs.core.drop.call(null,(new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)) * new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))),results));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.paginator","div.paginator",1793323420),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.previous-next-buttons","div.previous-next-buttons",-1703793397),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-default.previous-button","button.btn.btn-default.previous-button",-1699690996),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (pages,rows_in_view){
return (function (){
return cljs.core.swap_BANG_.call(null,pager,cljs.core.update,new cljs.core.Keyword(null,"page","page",849072397),cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.max,(0)),cljs.core.dec));
});})(pages,rows_in_view))
,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),(new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)) < (1))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-circle-left","svg.icon.icon-circle-left",339211738),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-circle-left"], null)], null)], null),"Previous"], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.btn.btn-default.next-button","button.btn.btn-default.next-button",1646016489),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (pages,rows_in_view){
return (function (){
return cljs.core.swap_BANG_.call(null,pager,cljs.core.update,new cljs.core.Keyword(null,"page","page",849072397),cljs.core.comp.call(null,cljs.core.partial.call(null,cljs.core.min,(pages - (1))),cljs.core.inc));
});})(pages,rows_in_view))
,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)),(pages - (1)))], null),"Next",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-circle-right","svg.icon.icon-circle-right",1967312548),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-circle-right"], null)], null)], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.results-count","div.results-count",-430024566),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),"Show"], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select.form-control","select.form-control",696610397),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (pages,rows_in_view){
return (function (e){
return cljs.core.swap_BANG_.call(null,pager,cljs.core.assoc,new cljs.core.Keyword(null,"show","show",-576705889),parseInt((function (){var target_obj_16494 = e;
var _STAR_runtime_state_STAR__orig_val__16497 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16498 = oops.state.prepare_state.call(null,target_obj_16494,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16498;

try{var next_obj_16495 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_16494,(0),"target",true))?(target_obj_16494["target"]):null);
var next_obj_16496 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_16495,(0),"value",true))?(next_obj_16495["value"]):null);
return next_obj_16496;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16497;
}})()),new cljs.core.Keyword(null,"page","page",849072397),(0));
});})(pages,rows_in_view))
,new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))], null)], null),cljs.core.map.call(null,((function (pages,rows_in_view){
return (function (p){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),p], null),p], null);
});})(pages,rows_in_view))
,(function (){var to_show = (cljs.core.count.call(null,cljs.core.take_while.call(null,((function (pages,rows_in_view){
return (function (v){
return (v <= cljs.core.count.call(null,results));
});})(pages,rows_in_view))
,bluegenes.components.idresolver.views.allowed_number_of_results)) + (1));
return cljs.core.take.call(null,to_show,bluegenes.components.idresolver.views.allowed_number_of_results);
})())),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),"results on page "], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.page-selector","div.page-selector",-797212572),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select.form-control","select.form-control",696610397),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (pages,rows_in_view){
return (function (e){
return cljs.core.swap_BANG_.call(null,pager,cljs.core.assoc,new cljs.core.Keyword(null,"page","page",849072397),parseInt((function (){var target_obj_16499 = e;
var _STAR_runtime_state_STAR__orig_val__16502 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16503 = oops.state.prepare_state.call(null,target_obj_16499,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16503;

try{var next_obj_16500 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_16499,(0),"target",true))?(target_obj_16499["target"]):null);
var next_obj_16501 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_16500,(0),"value",true))?(next_obj_16500["value"]):null);
return next_obj_16501;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16502;
}})()));
});})(pages,rows_in_view))
,new cljs.core.Keyword(null,"disabled","disabled",-1529784218),(pages < (2)),new cljs.core.Keyword(null,"class","class",-2030961996),(((pages < (2)))?"disabled":null),new cljs.core.Keyword(null,"value","value",305978217),new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))], null)], null),cljs.core.map.call(null,((function (pages,rows_in_view){
return (function (p){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"value","value",305978217),p], null),["Page ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((p + (1)))].join('')], null);
});})(pages,rows_in_view))
,cljs.core.range.call(null,pages))),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),["of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pages)].join('')], null)], null)], null);
});
});
bluegenes.components.idresolver.views.matches_table = (function bluegenes$components$idresolver$views$matches_table(){
var pager = reagent.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"show","show",-576705889),(10),new cljs.core.Keyword(null,"page","page",849072397),(0)], null));
var summary_fields = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-summary-fields","current-summary-fields",-1180467631)], null));
var model = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-model","current-model",-1288511749)], null));
return ((function (pager,summary_fields,model){
return (function (type,results,show_keep_QMARK_){
var pages = Math.ceil((cljs.core.count.call(null,results) / new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))));
var rows_in_view = cljs.core.take.call(null,new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)),cljs.core.drop.call(null,(new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)) * new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))),results));
var type_summary_fields = cljs.core.get.call(null,cljs.core.deref.call(null,summary_fields),cljs.core.keyword.call(null,type));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.alert.alert-result-table.alert-info","div.alert.alert-result-table.alert-info",1744156559),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-info","svg.icon.icon-info",-297708043),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-info"], null)], null)], null),"An exact match was found for the following identifiers"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.paginator,pager,results], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.table.table-condensed.table-striped","table.table.table-condensed.table-striped",-1579287519),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"row-span","row-span",-365554241),(2)], null),"Your Identifier"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(6)], null),"Matches"], null)], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646)], null),cljs.core.map.call(null,((function (pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (f){
var path = imcljs.path.friendly.call(null,cljs.core.deref.call(null,model),f);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),clojure.string.join.call(null," > ",cljs.core.rest.call(null,clojure.string.split.call(null,path," > ")))], null);
});})(pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,type_summary_fields))], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300)], null),cljs.core.map_indexed.call(null,((function (pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (row_idx,p__16504){
var map__16505 = p__16504;
var map__16505__$1 = (((((!((map__16505 == null))))?(((((map__16505.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16505.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16505):map__16505);
var summary = cljs.core.get.call(null,map__16505__$1,new cljs.core.Keyword(null,"summary","summary",380847952));
var input = cljs.core.get.call(null,map__16505__$1,new cljs.core.Keyword(null,"input","input",556931961));
var id = cljs.core.get.call(null,map__16505__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),clojure.string.join.call(null,", ",input)], null)], null),cljs.core.map.call(null,((function (map__16505,map__16505__$1,summary,input,id,pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (field){
var without_prefix = cljs.core.keyword.call(null,clojure.string.join.call(null,".",cljs.core.rest.call(null,clojure.string.split.call(null,field,"."))));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),cljs.core.get.call(null,summary,without_prefix)], null);
});})(map__16505,map__16505__$1,summary,input,id,pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,type_summary_fields));
});})(pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,rows_in_view))], null)], null);
});
;})(pager,summary_fields,model))
});
bluegenes.components.idresolver.views.converted_table = (function bluegenes$components$idresolver$views$converted_table(){
var pager = reagent.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"show","show",-576705889),(10),new cljs.core.Keyword(null,"page","page",849072397),(0)], null));
var summary_fields = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-summary-fields","current-summary-fields",-1180467631)], null));
var model = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-model","current-model",-1288511749)], null));
return ((function (pager,summary_fields,model){
return (function (type,results,category_kw){
var pages = Math.floor((cljs.core.count.call(null,results) / new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))));
var rows_in_view = cljs.core.take.call(null,new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)),cljs.core.drop.call(null,(new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)) * new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))),results));
var type_summary_fields = cljs.core.get.call(null,cljs.core.deref.call(null,summary_fields),cljs.core.keyword.call(null,type));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),(function (){var G__16507 = category_kw;
var G__16507__$1 = (((G__16507 instanceof cljs.core.Keyword))?G__16507.fqn:null);
switch (G__16507__$1) {
case "converted":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.alert.alert-result-table.alert-info","div.alert.alert-result-table.alert-info",1744156559),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-info","svg.icon.icon-info",-297708043),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-info"], null)], null)], null),["These identifiers matched non-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," records from which a relationship to a ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," was found"].join('')], null)], null);

break;
case "other":
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.alert.alert-result-table.alert-info","div.alert.alert-result-table.alert-info",1744156559),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-info","svg.icon.icon-info",-297708043),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-info"], null)], null)], null),"These identifiers matched old identifiers"], null)], null);

break;
default:
return null;

}
})(),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.paginator,pager,results], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.table.table-condensed.table-striped","table.table.table-condensed.table-striped",-1579287519),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"row-span","row-span",-365554241),(2)], null),"Your Identifier"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(5)], null),"Matches"], null)], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646)], null),cljs.core.map.call(null,((function (pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (f){
var path = imcljs.path.friendly.call(null,cljs.core.deref.call(null,model),f);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),clojure.string.join.call(null," > ",cljs.core.rest.call(null,clojure.string.split.call(null,path," > ")))], null);
});})(pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,type_summary_fields))], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300)], null),cljs.core.apply.call(null,cljs.core.concat,cljs.core.map_indexed.call(null,((function (pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (duplicate_idx,p__16508){
var map__16509 = p__16508;
var map__16509__$1 = (((((!((map__16509 == null))))?(((((map__16509.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16509.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16509):map__16509);
var duplicate = map__16509__$1;
var input = cljs.core.get.call(null,map__16509__$1,new cljs.core.Keyword(null,"input","input",556931961));
var reason = cljs.core.get.call(null,map__16509__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
var matches = cljs.core.get.call(null,map__16509__$1,new cljs.core.Keyword(null,"matches","matches",635497998));
return cljs.core.map_indexed.call(null,((function (map__16509,map__16509__$1,duplicate,input,reason,matches,pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (match_idx,p__16511){
var map__16512 = p__16511;
var map__16512__$1 = (((((!((map__16512 == null))))?(((((map__16512.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16512.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16512):map__16512);
var match = map__16512__$1;
var summary = cljs.core.get.call(null,map__16512__$1,new cljs.core.Keyword(null,"summary","summary",380847952));
var keep_QMARK_ = cljs.core.get.call(null,map__16512__$1,new cljs.core.Keyword(null,"keep?","keep?",418688464));
return cljs.core.into.call(null,((cljs.core._EQ_.call(null,match_idx,(0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(keep_QMARK_)?"success":null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"row-span","row-span",-365554241),cljs.core.count.call(null,matches)], null),input], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(keep_QMARK_)?"success":null)], null)], null)),cljs.core.map.call(null,((function (map__16512,map__16512__$1,match,summary,keep_QMARK_,map__16509,map__16509__$1,duplicate,input,reason,matches,pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (field){
var without_prefix = cljs.core.keyword.call(null,clojure.string.join.call(null,".",cljs.core.rest.call(null,clojure.string.split.call(null,field,"."))));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),cljs.core.get.call(null,summary,without_prefix)], null);
});})(map__16512,map__16512__$1,match,summary,keep_QMARK_,map__16509,map__16509__$1,duplicate,input,reason,matches,pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,type_summary_fields));
});})(map__16509,map__16509__$1,duplicate,input,reason,matches,pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,matches);
});})(pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,rows_in_view)))], null)], null);
});
;})(pager,summary_fields,model))
});
bluegenes.components.idresolver.views.not_found_table = (function bluegenes$components$idresolver$views$not_found_table(){
var pager = reagent.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"show","show",-576705889),(10),new cljs.core.Keyword(null,"page","page",849072397),(0)], null));
var summary_fields = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-summary-fields","current-summary-fields",-1180467631)], null));
var model = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-model","current-model",-1288511749)], null));
return ((function (pager,summary_fields,model){
return (function (type,results,show_keep_QMARK_){
var pages = Math.floor((cljs.core.count.call(null,results) / new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))));
var rows_in_view = cljs.core.take.call(null,new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)),cljs.core.drop.call(null,(new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)) * new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))),results));
var type_summary_fields = cljs.core.get.call(null,cljs.core.deref.call(null,summary_fields),cljs.core.keyword.call(null,type));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.alert.alert-result-table.alert-info","div.alert.alert-result-table.alert-info",1744156559),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-info","svg.icon.icon-info",-297708043),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-info"], null)], null)], null),"These identifiers returned no matches"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.paginator,pager,results], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.table.table-condensed.table-striped","table.table.table-condensed.table-striped",-1579287519),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),"Your Identifier"], null)], null)], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300)], null),cljs.core.map_indexed.call(null,((function (pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (row_idx,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),value], null)], null);
});})(pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,rows_in_view))], null)], null);
});
;})(pager,summary_fields,model))
});
bluegenes.components.idresolver.views.review_table = (function bluegenes$components$idresolver$views$review_table(){
var pager = reagent.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"show","show",-576705889),(5),new cljs.core.Keyword(null,"page","page",849072397),(0)], null));
var summary_fields = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-summary-fields","current-summary-fields",-1180467631)], null));
var model = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"current-model","current-model",-1288511749)], null));
return ((function (pager,summary_fields,model){
return (function (type,results,show_keep_QMARK_){
var pages = Math.floor((cljs.core.count.call(null,results) / new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))));
var rows_in_view = cljs.core.take.call(null,new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)),cljs.core.drop.call(null,(new cljs.core.Keyword(null,"show","show",-576705889).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager)) * new cljs.core.Keyword(null,"page","page",849072397).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,pager))),results));
var type_summary_fields = cljs.core.get.call(null,cljs.core.deref.call(null,summary_fields),cljs.core.keyword.call(null,type));
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.form","div.form",-425204148),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.alert.alert-result-table.alert-info","div.alert.alert-result-table.alert-info",1744156559),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-info","svg.icon.icon-info",-297708043),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-info"], null)], null)], null),["These identifiers matched more than one ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.paginator,pager,results], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"table.table.table-condensed.table-striped","table.table.table-condensed.table-striped",-1579287519),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"thead","thead",-291875296),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"row-span","row-span",-365554241),(2)], null),"Your Identifier"], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"col-span","col-span",-232603210),(6)], null),"Matches"], null)], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),"Keep?"], null)], null),cljs.core.map.call(null,((function (pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (f){
var path = imcljs.path.friendly.call(null,cljs.core.deref.call(null,model),f);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"th","th",-545608566),clojure.string.join.call(null," > ",cljs.core.rest.call(null,clojure.string.split.call(null,path," > ")))], null);
});})(pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,type_summary_fields))], null),cljs.core.into.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tbody","tbody",-80678300)], null),cljs.core.apply.call(null,cljs.core.concat,cljs.core.map_indexed.call(null,((function (pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (duplicate_idx,p__16515){
var map__16516 = p__16515;
var map__16516__$1 = (((((!((map__16516 == null))))?(((((map__16516.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16516.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16516):map__16516);
var duplicate = map__16516__$1;
var input = cljs.core.get.call(null,map__16516__$1,new cljs.core.Keyword(null,"input","input",556931961));
var reason = cljs.core.get.call(null,map__16516__$1,new cljs.core.Keyword(null,"reason","reason",-2070751759));
var matches = cljs.core.get.call(null,map__16516__$1,new cljs.core.Keyword(null,"matches","matches",635497998));
return cljs.core.map_indexed.call(null,((function (map__16516,map__16516__$1,duplicate,input,reason,matches,pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (match_idx,p__16518){
var map__16519 = p__16518;
var map__16519__$1 = (((((!((map__16519 == null))))?(((((map__16519.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16519.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16519):map__16519);
var match = map__16519__$1;
var summary = cljs.core.get.call(null,map__16519__$1,new cljs.core.Keyword(null,"summary","summary",380847952));
var keep_QMARK_ = cljs.core.get.call(null,map__16519__$1,new cljs.core.Keyword(null,"keep?","keep?",418688464));
return cljs.core.into.call(null,((cljs.core._EQ_.call(null,match_idx,(0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(keep_QMARK_)?"success":null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"row-span","row-span",-365554241),cljs.core.count.call(null,matches)], null),input], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"tr","tr",-1424774646),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),(cljs.core.truth_(keep_QMARK_)?"success":null)], null)], null)),cljs.core.conj.call(null,cljs.core.map.call(null,((function (map__16519,map__16519__$1,match,summary,keep_QMARK_,map__16516,map__16516__$1,duplicate,input,reason,matches,pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (field){
var without_prefix = cljs.core.keyword.call(null,clojure.string.join.call(null,".",cljs.core.rest.call(null,clojure.string.split.call(null,field,"."))));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),cljs.core.get.call(null,summary,without_prefix)], null);
});})(map__16519,map__16519__$1,match,summary,keep_QMARK_,map__16516,map__16516__$1,duplicate,input,reason,matches,pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,type_summary_fields),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"td","td",1479933353),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"checked","checked",-50955819),keep_QMARK_,new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (map__16519,map__16519__$1,match,summary,keep_QMARK_,map__16516,map__16516__$1,duplicate,input,reason,matches,pages,rows_in_view,type_summary_fields,pager,summary_fields,model){
return (function (e){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","toggle-keep-duplicate","bluegenes.components.idresolver.events/toggle-keep-duplicate",-277855960),duplicate_idx,match_idx], null));
});})(map__16519,map__16519__$1,match,summary,keep_QMARK_,map__16516,map__16516__$1,duplicate,input,reason,matches,pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
], null)], null)], null)], null)], null)));
});})(map__16516,map__16516__$1,duplicate,input,reason,matches,pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,matches);
});})(pages,rows_in_view,type_summary_fields,pager,summary_fields,model))
,rows_in_view)))], null)], null);
});
;})(pager,summary_fields,model))
});
bluegenes.components.idresolver.views.success_message = (function bluegenes$components$idresolver$views$success_message(){
return (function (count,total){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.alert.alert-success.stat","div.alert.alert-success.stat",-1126976590),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-checkmark","svg.icon.icon-checkmark",636717824),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-checkmark"], null)], null)], null),[" ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(count)," matching objects were found"].join('')], null)], null)], null);
});
});
bluegenes.components.idresolver.views.issues_message = (function bluegenes$components$idresolver$views$issues_message(){
return (function (count,total){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.alert.alert-warning.stat","div.alert.alert-warning.stat",-293581763),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-duplicate","svg.icon.icon-duplicate",-623513743),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-duplicate"], null)], null)], null),[" ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(count)," identifiers returned multiple objects"].join('')], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),"Please"], null)], null)], null);
});
});
bluegenes.components.idresolver.views.not_found_message = (function bluegenes$components$idresolver$views$not_found_message(){
return (function (count,total){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.alert.alert-danger.stat","div.alert.alert-danger.stat",-1318947903),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-wondering","svg.icon.icon-wondering",-1400649319),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-wondering"], null)], null)], null),[" ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(count)," identifiers were not found"].join('')], null)], null);
});
});
bluegenes.components.idresolver.views.review_step = (function bluegenes$components$idresolver$views$review_step(){
var resolution_response = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","resolution-response","bluegenes.components.idresolver.subs/resolution-response",1565088781)], null));
var list_name = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","list-name","bluegenes.components.idresolver.subs/list-name",-353914014)], null));
var stats = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","stats","bluegenes.components.idresolver.subs/stats",1244269923)], null));
var tab = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","review-tab","bluegenes.components.idresolver.subs/review-tab",-1217435191)], null));
return ((function (resolution_response,list_name,stats,tab){
return (function (){
var map__16521 = cljs.core.deref.call(null,stats);
var map__16521__$1 = (((((!((map__16521 == null))))?(((((map__16521.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16521.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16521):map__16521);
var matches = cljs.core.get.call(null,map__16521__$1,new cljs.core.Keyword(null,"matches","matches",635497998));
var issues = cljs.core.get.call(null,map__16521__$1,new cljs.core.Keyword(null,"issues","issues",1989874693));
var notFound = cljs.core.get.call(null,map__16521__$1,new cljs.core.Keyword(null,"notFound","notFound",-1530050180));
var converted = cljs.core.get.call(null,map__16521__$1,new cljs.core.Keyword(null,"converted","converted",1590204425));
var duplicates = cljs.core.get.call(null,map__16521__$1,new cljs.core.Keyword(null,"duplicates","duplicates",1265485699));
var all = cljs.core.get.call(null,map__16521__$1,new cljs.core.Keyword(null,"all","all",892129742));
var other = cljs.core.get.call(null,map__16521__$1,new cljs.core.Keyword(null,"other","other",995793544));
if(cljs.core._EQ_.call(null,null,cljs.core.deref.call(null,resolution_response))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.loader.loader], null)], null);
} else {
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div","div",1057191632),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.flex-progressbar","div.flex-progressbar",1605503568),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.title","div.title",-1929547732),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),[cljs.core.str.cljs$core$IFn$_invoke$arity$1((matches + other))," of your ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(all)," identifiers matched a ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response)))].join('')], null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.bars","div.bars",1163850895),((((matches - converted) > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.bar.bar-success","div.bar.bar-success",-516082151),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"flex","flex",-1425124628),((100) * ((matches + converted) / all))], null)], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1((matches - converted)),[" Match",((((matches - converted) > (1)))?"es":null)].join('')].join('')], null):null),(((converted > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.bar.bar-success","div.bar.bar-success",-516082151),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"flex","flex",-1425124628),((100) * ((matches + converted) / all))], null)], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(converted)," Converted"].join('')], null):null),(((other > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.bar.bar-success","div.bar.bar-success",-516082151),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"flex","flex",-1425124628),((100) * (other / all))], null)], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(other)," Synonym",(((other > (1)))?"s":null)].join('')], null):null),(((duplicates > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.bar.bar-warning","div.bar.bar-warning",326782520),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"flex","flex",-1425124628),((100) * (duplicates / all))], null)], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(duplicates)," Ambiguous"].join('')], null):null),(((notFound > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.bar.bar-danger","div.bar.bar-danger",416460623),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"flex","flex",-1425124628),((100) * (notFound / all))], null)], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(notFound)," Not Found"].join('')], null):null)], null)], null),((cljs.core.not_EQ_.call(null,duplicates,(0)))?(function (){
re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-option","bluegenes.components.idresolver.events/update-option",-193211275),new cljs.core.Keyword(null,"review-tab","review-tab",-872263809),new cljs.core.Keyword(null,"issues","issues",1989874693)], null));

return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.alert.alert-warning.guidance","div.alert.alert-warning.guidance",-1338728022),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4","h4",2004862993),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-info","svg.icon.icon-info",-297708043),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-info"], null)], null)], null),[" ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(duplicates)," of your identifiers resolved to more than one ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response)))].join('')], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"p","p",151049309),"Please select which objects you want to keep from the ",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span.label.label-warning","span.label.label-warning",-681742177),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-duplicate","svg.icon.icon-duplicate",-623513743),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-duplicate"], null)], null)], null),[" Ambiguous (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(duplicates),")"].join('')], null)," tab"], null)], null);
})()
:null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.save-list","div.save-list",403976813),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),"List Name",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text",new cljs.core.Keyword(null,"value","value",305978217),cljs.core.deref.call(null,list_name),new cljs.core.Keyword(null,"on-change","on-change",-732046149),((function (map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab){
return (function (e){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-list-name","bluegenes.components.idresolver.events/update-list-name",-363252007),(function (){var target_obj_16523 = e;
var _STAR_runtime_state_STAR__orig_val__16526 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__16527 = oops.state.prepare_state.call(null,target_obj_16523,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__16527;

try{var next_obj_16524 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_16523,(0),"target",true))?(target_obj_16523["target"]):null);
var next_obj_16525 = ((oops.core.validate_object_access_dynamically.call(null,next_obj_16524,(0),"value",true))?(next_obj_16524["value"]):null);
return next_obj_16525;
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__16526;
}})()], null));
});})(map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab))
], null)], null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"button.cta","button.cta",862355088),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","save-list","bluegenes.components.idresolver.events/save-list",-1100555896)], null));
});})(map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab))
], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-floppy-disk","svg.icon.icon-floppy-disk",-322187039),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-floppy-disk"], null)], null)], null),"Save List"], null)], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul.nav.nav-tabs.id-resolver-tabs","ul.nav.nav-tabs.id-resolver-tabs",1813013842),(((matches > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),((cljs.core._EQ_.call(null,cljs.core.deref.call(null,tab),new cljs.core.Keyword(null,"matches","matches",635497998)))?"active":null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-option","bluegenes.components.idresolver.events/update-option",-193211275),new cljs.core.Keyword(null,"review-tab","review-tab",-872263809),new cljs.core.Keyword(null,"matches","matches",635497998)], null));
});})(map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.matches.all-ok","a.matches.all-ok",-1707974503),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-checkmark","svg.icon.icon-checkmark",636717824),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-checkmark"], null)], null)], null),[" Matches (",cljs.core.str.cljs$core$IFn$_invoke$arity$1((matches - converted)),")"].join('')], null)], null):null),(((converted > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),((cljs.core._EQ_.call(null,cljs.core.deref.call(null,tab),new cljs.core.Keyword(null,"converted","converted",1590204425)))?"active":null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-option","bluegenes.components.idresolver.events/update-option",-193211275),new cljs.core.Keyword(null,"review-tab","review-tab",-872263809),new cljs.core.Keyword(null,"converted","converted",1590204425)], null));
});})(map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.converted.all-ok","a.converted.all-ok",1087034498),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-converted","svg.icon.icon-converted",-1960531468),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-converted"], null)], null)], null),["Converted (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(converted),")"].join('')], null)], null):null),(((other > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),((cljs.core._EQ_.call(null,cljs.core.deref.call(null,tab),new cljs.core.Keyword(null,"other","other",995793544)))?"active":null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-option","bluegenes.components.idresolver.events/update-option",-193211275),new cljs.core.Keyword(null,"review-tab","review-tab",-872263809),new cljs.core.Keyword(null,"other","other",995793544)], null));
});})(map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.synonyms.all-ok","a.synonyms.all-ok",-929026352),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-info","svg.icon.icon-info",-297708043),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-info"], null)], null)], null),["Synonyms (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(other),")"].join('')], null)], null):null),(((duplicates > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),((cljs.core._EQ_.call(null,cljs.core.deref.call(null,tab),new cljs.core.Keyword(null,"issues","issues",1989874693)))?"active":null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-option","bluegenes.components.idresolver.events/update-option",-193211275),new cljs.core.Keyword(null,"review-tab","review-tab",-872263809),new cljs.core.Keyword(null,"issues","issues",1989874693)], null));
});})(map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.ambiguous.needs-attention","a.ambiguous.needs-attention",542024854),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-duplicate","svg.icon.icon-duplicate",-623513743),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-duplicate"], null)], null)], null),[" Ambiguous (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(duplicates),")"].join('')], null)], null):null),(((notFound > (0)))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"class","class",-2030961996),((cljs.core._EQ_.call(null,cljs.core.deref.call(null,tab),new cljs.core.Keyword(null,"notFound","notFound",-1530050180)))?"active":null),new cljs.core.Keyword(null,"on-click","on-click",1632826543),((function (map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab){
return (function (){
return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","update-option","bluegenes.components.idresolver.events/update-option",-193211275),new cljs.core.Keyword(null,"review-tab","review-tab",-872263809),new cljs.core.Keyword(null,"notFound","notFound",-1530050180)], null));
});})(map__16521,map__16521__$1,matches,issues,notFound,converted,duplicates,all,other,resolution_response,list_name,stats,tab))
], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a.error.not-found","a.error.not-found",198884213),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-wondering","svg.icon.icon-wondering",-1400649319),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-wondering"], null)], null)], null),["Not Found (",cljs.core.str.cljs$core$IFn$_invoke$arity$1(notFound),")"].join('')], null)], null):null)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.table-container","div.table-container",-1574957621),(function (){var G__16528 = cljs.core.deref.call(null,tab);
var G__16528__$1 = (((G__16528 instanceof cljs.core.Keyword))?G__16528.fqn:null);
switch (G__16528__$1) {
case "issues":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.review_table,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response)),new cljs.core.Keyword(null,"DUPLICATE","DUPLICATE",-1038895754).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"matches","matches",635497998).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response)))], null);

break;
case "notFound":
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.not_found_table,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response)),new cljs.core.Keyword(null,"unresolved","unresolved",833458441).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response))], null);

break;
case "converted":
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.converted_table,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response)),new cljs.core.Keyword(null,"TYPE_CONVERTED","TYPE_CONVERTED",-1734724129).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"matches","matches",635497998).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response))),new cljs.core.Keyword(null,"converted","converted",1590204425)], null);

break;
case "other":
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.converted_table,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response)),new cljs.core.Keyword(null,"OTHER","OTHER",-632033057).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"matches","matches",635497998).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response))),new cljs.core.Keyword(null,"other","other",995793544)], null);

break;
default:
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.matches_table,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response)),new cljs.core.Keyword(null,"MATCH","MATCH",-1047463535).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"matches","matches",635497998).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,resolution_response)))], null);

}
})()], null)], null);
}
});
;})(resolution_response,list_name,stats,tab))
});
bluegenes.components.idresolver.views.breadcrumbs = (function bluegenes$components$idresolver$views$breadcrumbs(){
var response = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","resolution-response","bluegenes.components.idresolver.subs/resolution-response",1565088781)], null));
return ((function (response){
return (function (view){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"h4.breadcrumbs","h4.breadcrumbs",-1357352579),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol.breadcrumb","ol.breadcrumb",-488493135),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),((((cljs.core._EQ_.call(null,view,null)) || (cljs.core._EQ_.call(null,view,new cljs.core.Keyword(null,"input","input",556931961)))))?"active":null)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","upload-step","bluegenes.route/upload-step",-286508008),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"step","step",1288888124),"input"], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-upload","svg.icon.icon-upload",1211481110),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-upload"], null)], null)], null),"Upload"], null)], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li.disabled","li.disabled",1847081483),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"class","class",-2030961996),((cljs.core._EQ_.call(null,view,new cljs.core.Keyword(null,"save","save",1850079149)))?"active":null)], null),(cljs.core.truth_(cljs.core.deref.call(null,response))?new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),bluegenes.route.href.call(null,new cljs.core.Keyword("bluegenes.route","upload-step","bluegenes.route/upload-step",-286508008),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"step","step",1288888124),"save"], null))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-floppy-disk","svg.icon.icon-floppy-disk",-322187039),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-floppy-disk"], null)], null)], null),"Save"], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg.icon.icon-floppy-disk","svg.icon.icon-floppy-disk",-322187039),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"use","use",-1846382424),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"xlinkHref","xlinkHref",-1814059639),"#icon-floppy-disk"], null)], null)], null),"Save"], null))], null)], null)], null);
});
;})(response))
});
bluegenes.components.idresolver.views.wizard = (function bluegenes$components$idresolver$views$wizard(){
var view = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","view","bluegenes.components.idresolver.subs/view",536838256)], null));
var panel_params = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"panel-params","panel-params",1099672237)], null));
return ((function (view,panel_params){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.wizard","div.wizard",-1691541406),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.breadcrumbs,new cljs.core.Keyword(null,"step","step",1288888124).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,panel_params))], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.wizard-body","div.wizard-body",-715706907),(function (){var G__16530 = new cljs.core.Keyword(null,"step","step",1288888124).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,panel_params));
var G__16530__$1 = (((G__16530 instanceof cljs.core.Keyword))?G__16530.fqn:null);
switch (G__16530__$1) {
case "save":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.review_step], null);

break;
default:
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.upload_step], null);

}
})()], null)], null);
});
;})(view,panel_params))
});
bluegenes.components.idresolver.views.main = (function bluegenes$components$idresolver$views$main(){
var options = re_frame.core.subscribe.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.subs","stage-options","bluegenes.components.idresolver.subs/stage-options",-575862054)], null));
return reagent.core.create_class.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"component-did-mount","component-did-mount",-1126910518),((function (options){
return (function (e){
bluegenes.components.idresolver.views.attach_body_events.call(null);

return re_frame.core.dispatch.call(null,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.components.idresolver.events","reset","bluegenes.components.idresolver.events/reset",-1099948562)], null));
});})(options))
,new cljs.core.Keyword(null,"reagent-render","reagent-render",-985383853),((function (options){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"div.container.idresolverupload","div.container.idresolverupload",2019841487),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [bluegenes.components.idresolver.views.wizard], null)], null);
});})(options))
], null));
});

//# sourceMappingURL=views.js.map
