// Compiled by ClojureScript 1.10.520 {}
goog.provide('re_com.typeahead');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('re_com.misc');
goog.require('re_com.util');
goog.require('re_com.popover');
goog.require('re_com.box');
goog.require('re_com.validate');
goog.require('reagent.core');
goog.require('goog.events.KeyCodes');

/**
 * Return an initial value for the typeahead state, given `args`.
 */
re_com.typeahead.make_typeahead_state = (function re_com$typeahead$make_typeahead_state(p__20521){
var map__20522 = p__20521;
var map__20522__$1 = (((((!((map__20522 == null))))?(((((map__20522.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20522.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20522):map__20522);
var args = map__20522__$1;
var on_change = cljs.core.get.call(null,map__20522__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
var rigid_QMARK_ = cljs.core.get.call(null,map__20522__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__20522__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var data_source = cljs.core.get.call(null,map__20522__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var suggestion_to_string = cljs.core.get.call(null,map__20522__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var debounce_delay = cljs.core.get.call(null,map__20522__$1,new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982));
var model = cljs.core.get.call(null,map__20522__$1,new cljs.core.Keyword(null,"model","model",331153215));
var external_model_value = re_com.util.deref_or_value.call(null,model);
var G__20524 = (function (){var c_input = cljs.core.async.chan.call(null);
return cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"c-search","c-search",1832536180),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),new cljs.core.Keyword(null,"c-input","c-input",-1821004232),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"external-model","external-model",506095421),new cljs.core.Keyword(null,"model","model",331153215)],[false,(function (){var or__4131__auto__ = suggestion_to_string;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return cljs.core.str;
}
})(),false,"",rigid_QMARK_,data_source,re_com.typeahead.debounce.call(null,c_input,debounce_delay),change_on_blur_QMARK_,cljs.core.PersistentVector.EMPTY,c_input,on_change,re_com.util.deref_or_value.call(null,model),re_com.util.deref_or_value.call(null,model)]);
})();
if(cljs.core.truth_(external_model_value)){
return re_com.typeahead.display_suggestion.call(null,G__20524,external_model_value);
} else {
return G__20524;
}
});
/**
 * Should `event` update the `typeahead` `model`?
 */
re_com.typeahead.event_updates_model_QMARK_ = (function re_com$typeahead$event_updates_model_QMARK_(p__20525,event){
var map__20526 = p__20525;
var map__20526__$1 = (((((!((map__20526 == null))))?(((((map__20526.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20526.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20526):map__20526);
var state = map__20526__$1;
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__20526__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var rigid_QMARK_ = cljs.core.get.call(null,map__20526__$1,new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value.call(null,change_on_blur_QMARK_);
var rigid_QMARK___$1 = re_com.util.deref_or_value.call(null,rigid_QMARK_);
var G__20528 = event;
var G__20528__$1 = (((G__20528 instanceof cljs.core.Keyword))?G__20528.fqn:null);
switch (G__20528__$1) {
case "input-text-blurred":
var and__4120__auto__ = change_on_blur_QMARK___$1;
if(cljs.core.truth_(and__4120__auto__)){
return cljs.core.not.call(null,rigid_QMARK___$1);
} else {
return and__4120__auto__;
}

break;
case "suggestion-activated":
return cljs.core.not.call(null,change_on_blur_QMARK___$1);

break;
case "input-text-changed":
return cljs.core.not.call(null,(function (){var or__4131__auto__ = change_on_blur_QMARK___$1;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return rigid_QMARK___$1;
}
})());

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__20528__$1)].join('')));

}
});
/**
 * Should `event` cause the `input-text` value to be used to show the active suggestion?
 */
re_com.typeahead.event_displays_suggestion_QMARK_ = (function re_com$typeahead$event_displays_suggestion_QMARK_(p__20530,event){
var map__20531 = p__20530;
var map__20531__$1 = (((((!((map__20531 == null))))?(((((map__20531.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20531.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20531):map__20531);
var state = map__20531__$1;
var change_on_blur_QMARK_ = cljs.core.get.call(null,map__20531__$1,new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925));
var change_on_blur_QMARK___$1 = re_com.util.deref_or_value.call(null,change_on_blur_QMARK_);
var G__20533 = event;
var G__20533__$1 = (((G__20533 instanceof cljs.core.Keyword))?G__20533.fqn:null);
switch (G__20533__$1) {
case "suggestion-activated":
return cljs.core.not.call(null,change_on_blur_QMARK___$1);

break;
default:
return false;

}
});
/**
 * Change the `typeahead` `model` value to `new-value`
 */
re_com.typeahead.update_model = (function re_com$typeahead$update_model(p__20535,new_value){
var map__20536 = p__20535;
var map__20536__$1 = (((((!((map__20536 == null))))?(((((map__20536.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20536.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20536):map__20536);
var state = map__20536__$1;
var on_change = cljs.core.get.call(null,map__20536__$1,new cljs.core.Keyword(null,"on-change","on-change",-732046149));
if(cljs.core.truth_(on_change)){
on_change.call(null,new_value);
} else {
}

return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"model","model",331153215),new_value);
});
/**
 * Change the `input-text` `model` to the string representation of `suggestion`
 */
re_com.typeahead.display_suggestion = (function re_com$typeahead$display_suggestion(p__20538,suggestion){
var map__20539 = p__20538;
var map__20539__$1 = (((((!((map__20539 == null))))?(((((map__20539.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20539.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20539):map__20539);
var state = map__20539__$1;
var suggestion_to_string = cljs.core.get.call(null,map__20539__$1,new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962));
var suggestion_string = suggestion_to_string.call(null,suggestion);
var G__20541 = state;
if(cljs.core.truth_(suggestion_string)){
return cljs.core.assoc.call(null,G__20541,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),suggestion_string,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),true);
} else {
return G__20541;
}
});
re_com.typeahead.clear_suggestions = (function re_com$typeahead$clear_suggestions(state){
return cljs.core.dissoc.call(null,state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
});
/**
 * Make the suggestion at `index` the active suggestion
 */
re_com.typeahead.activate_suggestion_by_index = (function re_com$typeahead$activate_suggestion_by_index(p__20542,index){
var map__20543 = p__20542;
var map__20543__$1 = (((((!((map__20543 == null))))?(((((map__20543.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20543.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20543):map__20543);
var state = map__20543__$1;
var suggestions = cljs.core.get.call(null,map__20543__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.call(null,suggestions,index);
var G__20545 = state;
var G__20545__$1 = cljs.core.assoc.call(null,G__20545,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),index)
;
var G__20545__$2 = (cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))?re_com.typeahead.update_model.call(null,G__20545__$1,suggestion):G__20545__$1);
if(cljs.core.truth_(re_com.typeahead.event_displays_suggestion_QMARK_.call(null,state,new cljs.core.Keyword(null,"suggestion-activated","suggestion-activated",316961778)))){
return re_com.typeahead.display_suggestion.call(null,G__20545__$2,suggestion);
} else {
return G__20545__$2;
}
});
/**
 * Choose the suggestion at `index`
 */
re_com.typeahead.choose_suggestion_by_index = (function re_com$typeahead$choose_suggestion_by_index(p__20546,index){
var map__20547 = p__20546;
var map__20547__$1 = (((((!((map__20547 == null))))?(((((map__20547.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20547.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20547):map__20547);
var state = map__20547__$1;
var suggestions = cljs.core.get.call(null,map__20547__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion = cljs.core.nth.call(null,suggestions,index);
return re_com.typeahead.clear_suggestions.call(null,re_com.typeahead.display_suggestion.call(null,re_com.typeahead.update_model.call(null,re_com.typeahead.activate_suggestion_by_index.call(null,state,index),suggestion),suggestion));
});
re_com.typeahead.choose_suggestion_active = (function re_com$typeahead$choose_suggestion_active(p__20549){
var map__20550 = p__20549;
var map__20550__$1 = (((((!((map__20550 == null))))?(((((map__20550.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20550.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20550):map__20550);
var state = map__20550__$1;
var suggestion_active_index = cljs.core.get.call(null,map__20550__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__20552 = state;
if(cljs.core.truth_(suggestion_active_index)){
return re_com.typeahead.choose_suggestion_by_index.call(null,G__20552,suggestion_active_index);
} else {
return G__20552;
}
});
re_com.typeahead.wrap = (function re_com$typeahead$wrap(index,count){
return cljs.core.mod.call(null,(count + index),count);
});
re_com.typeahead.activate_suggestion_next = (function re_com$typeahead$activate_suggestion_next(p__20553){
var map__20554 = p__20553;
var map__20554__$1 = (((((!((map__20554 == null))))?(((((map__20554.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20554.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20554):map__20554);
var state = map__20554__$1;
var suggestions = cljs.core.get.call(null,map__20554__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.call(null,map__20554__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__20556 = state;
if(cljs.core.truth_(suggestions)){
return re_com.typeahead.activate_suggestion_by_index.call(null,G__20556,re_com.typeahead.wrap.call(null,((function (){var or__4131__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (-1);
}
})() + (1)),cljs.core.count.call(null,suggestions)));
} else {
return G__20556;
}
});
re_com.typeahead.activate_suggestion_prev = (function re_com$typeahead$activate_suggestion_prev(p__20557){
var map__20558 = p__20557;
var map__20558__$1 = (((((!((map__20558 == null))))?(((((map__20558.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20558.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20558):map__20558);
var state = map__20558__$1;
var suggestions = cljs.core.get.call(null,map__20558__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var suggestion_active_index = cljs.core.get.call(null,map__20558__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var G__20560 = state;
if(cljs.core.truth_(suggestions)){
return re_com.typeahead.activate_suggestion_by_index.call(null,G__20560,re_com.typeahead.wrap.call(null,((function (){var or__4131__auto__ = suggestion_active_index;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return (0);
}
})() - (1)),cljs.core.count.call(null,suggestions)));
} else {
return G__20560;
}
});
re_com.typeahead.reset_typeahead = (function re_com$typeahead$reset_typeahead(state){
var G__20561 = state;
var G__20561__$1 = re_com.typeahead.clear_suggestions.call(null,G__20561)
;
var G__20561__$2 = cljs.core.assoc.call(null,G__20561__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),"",new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false)
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model.call(null,G__20561__$2,null);
} else {
return G__20561__$2;
}
});
/**
 * Update state when new suggestions are available
 */
re_com.typeahead.got_suggestions = (function re_com$typeahead$got_suggestions(state,suggestions){
return cljs.core.assoc.call(null,state,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618),suggestions,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),false,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728),null);
});
/**
 * Update state when the `input-text` is about to lose focus.
 */
re_com.typeahead.input_text_will_blur = (function re_com$typeahead$input_text_will_blur(p__20562){
var map__20563 = p__20562;
var map__20563__$1 = (((((!((map__20563 == null))))?(((((map__20563.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20563.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20563):map__20563);
var state = map__20563__$1;
var input_text = cljs.core.get.call(null,map__20563__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var displaying_suggestion_QMARK_ = cljs.core.get.call(null,map__20563__$1,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862));
var G__20565 = state;
if(cljs.core.truth_((function (){var and__4120__auto__ = cljs.core.not.call(null,displaying_suggestion_QMARK_);
if(and__4120__auto__){
return re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-blurred","input-text-blurred",-501892307));
} else {
return and__4120__auto__;
}
})())){
return re_com.typeahead.update_model.call(null,G__20565,input_text);
} else {
return G__20565;
}
});
/**
 * Update `state` given a new `data-source`. Resets the typeahead since any existing suggestions
 *   came from the old `data-source`.
 */
re_com.typeahead.change_data_source = (function re_com$typeahead$change_data_source(state,data_source){
return cljs.core.assoc.call(null,re_com.typeahead.reset_typeahead.call(null,state),new cljs.core.Keyword(null,"data-source","data-source",-658934676),data_source);
});
/**
 * Update state when the external model value has changed.
 */
re_com.typeahead.external_model_changed = (function re_com$typeahead$external_model_changed(state,new_value){
return re_com.typeahead.clear_suggestions.call(null,re_com.typeahead.display_suggestion.call(null,re_com.typeahead.update_model.call(null,state,new_value),new_value));
});
/**
 * Call the `data-source` fn with `text`, and then call `got-suggestions` with the result
 *   (asynchronously, if `data-source` does not return a truthy value).
 */
re_com.typeahead.search_data_source_BANG_ = (function re_com$typeahead$search_data_source_BANG_(data_source,state_atom,text){
var temp__5455__auto__ = data_source.call(null,text,(function (p1__20566_SHARP_){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.got_suggestions,p1__20566_SHARP_);
}));
if(cljs.core.truth_(temp__5455__auto__)){
var return_value = temp__5455__auto__;
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.got_suggestions,return_value);
} else {
return cljs.core.swap_BANG_.call(null,state_atom,cljs.core.assoc,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215),true);
}
});
/**
 * For every value arriving on the `c-search` channel, call `search-data-source!`.
 */
re_com.typeahead.search_data_source_loop_BANG_ = (function re_com$typeahead$search_data_source_loop_BANG_(state_atom,c_search){
var c__2429__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto__){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto__){
return (function (state_20583){
var state_val_20584 = (state_20583[(1)]);
if((state_val_20584 === (1))){
var state_20583__$1 = state_20583;
var statearr_20585_20597 = state_20583__$1;
(statearr_20585_20597[(2)] = null);

(statearr_20585_20597[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20584 === (2))){
var state_20583__$1 = state_20583;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20583__$1,(4),c_search);
} else {
if((state_val_20584 === (3))){
var inst_20581 = (state_20583[(2)]);
var state_20583__$1 = state_20583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20583__$1,inst_20581);
} else {
if((state_val_20584 === (4))){
var inst_20569 = (state_20583[(7)]);
var inst_20569__$1 = (state_20583[(2)]);
var inst_20570 = cljs.core.deref.call(null,state_atom);
var inst_20571 = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(inst_20570);
var inst_20572 = cljs.core._EQ_.call(null,"",inst_20569__$1);
var state_20583__$1 = (function (){var statearr_20586 = state_20583;
(statearr_20586[(7)] = inst_20569__$1);

(statearr_20586[(8)] = inst_20571);

return statearr_20586;
})();
if(inst_20572){
var statearr_20587_20598 = state_20583__$1;
(statearr_20587_20598[(1)] = (5));

} else {
var statearr_20588_20599 = state_20583__$1;
(statearr_20588_20599[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20584 === (5))){
var inst_20574 = cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.reset_typeahead);
var state_20583__$1 = state_20583;
var statearr_20589_20600 = state_20583__$1;
(statearr_20589_20600[(2)] = inst_20574);

(statearr_20589_20600[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20584 === (6))){
var inst_20569 = (state_20583[(7)]);
var inst_20571 = (state_20583[(8)]);
var inst_20576 = re_com.typeahead.search_data_source_BANG_.call(null,inst_20571,state_atom,inst_20569);
var state_20583__$1 = state_20583;
var statearr_20590_20601 = state_20583__$1;
(statearr_20590_20601[(2)] = inst_20576);

(statearr_20590_20601[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20584 === (7))){
var inst_20578 = (state_20583[(2)]);
var state_20583__$1 = (function (){var statearr_20591 = state_20583;
(statearr_20591[(9)] = inst_20578);

return statearr_20591;
})();
var statearr_20592_20602 = state_20583__$1;
(statearr_20592_20602[(2)] = null);

(statearr_20592_20602[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(c__2429__auto__))
;
return ((function (switch__2334__auto__,c__2429__auto__){
return (function() {
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto__ = null;
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto____0 = (function (){
var statearr_20593 = [null,null,null,null,null,null,null,null,null,null];
(statearr_20593[(0)] = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto__);

(statearr_20593[(1)] = (1));

return statearr_20593;
});
var re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto____1 = (function (state_20583){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_20583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e20594){if((e20594 instanceof Object)){
var ex__2338__auto__ = e20594;
var statearr_20595_20603 = state_20583;
(statearr_20595_20603[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20583);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20594;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20604 = state_20583;
state_20583 = G__20604;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto__ = function(state_20583){
switch(arguments.length){
case 0:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto____0.call(this);
case 1:
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto____1.call(this,state_20583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto____0;
re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto____1;
return re_com$typeahead$search_data_source_loop_BANG__$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto__))
})();
var state__2431__auto__ = (function (){var statearr_20596 = f__2430__auto__.call(null);
(statearr_20596[(6)] = c__2429__auto__);

return statearr_20596;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto__))
);

return c__2429__auto__;
});
/**
 * Update state in response to `input-text` `on-change`, and put text on the `c-input` channel
 */
re_com.typeahead.input_text_on_change_BANG_ = (function re_com$typeahead$input_text_on_change_BANG_(state_atom,new_text){
var map__20606 = cljs.core.deref.call(null,state_atom);
var map__20606__$1 = (((((!((map__20606 == null))))?(((((map__20606.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20606.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20606):map__20606);
var state = map__20606__$1;
var input_text = cljs.core.get.call(null,map__20606__$1,new cljs.core.Keyword(null,"input-text","input-text",-1336297114));
var c_input = cljs.core.get.call(null,map__20606__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
if(cljs.core._EQ_.call(null,new_text,input_text)){
return state;
} else {
if(clojure.string.blank_QMARK_.call(null,new_text)){
} else {
cljs.core.async.put_BANG_.call(null,c_input,new_text);
}

return cljs.core.swap_BANG_.call(null,state_atom,((function (map__20606,map__20606__$1,state,input_text,c_input){
return (function (p1__20605_SHARP_){
var G__20608 = p1__20605_SHARP_;
var G__20608__$1 = cljs.core.assoc.call(null,G__20608,new cljs.core.Keyword(null,"input-text","input-text",-1336297114),new_text,new cljs.core.Keyword(null,"displaying-suggestion?","displaying-suggestion?",1244493862),false)
;
if(cljs.core.truth_(re_com.typeahead.event_updates_model_QMARK_.call(null,state,new cljs.core.Keyword(null,"input-text-changed","input-text-changed",-1906799535)))){
return re_com.typeahead.update_model.call(null,G__20608__$1,new_text);
} else {
return G__20608__$1;
}
});})(map__20606,map__20606__$1,state,input_text,c_input))
);
}
});
re_com.typeahead.input_text_on_key_down_BANG_ = (function re_com$typeahead$input_text_on_key_down_BANG_(state_atom,event){
var pred__20609 = cljs.core._EQ_;
var expr__20610 = event.which;
if(cljs.core.truth_(pred__20609.call(null,goog.events.KeyCodes.UP,expr__20610))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_prev);
} else {
if(cljs.core.truth_(pred__20609.call(null,goog.events.KeyCodes.DOWN,expr__20610))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_next);
} else {
if(cljs.core.truth_(pred__20609.call(null,goog.events.KeyCodes.ENTER,expr__20610))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_active);
} else {
if(cljs.core.truth_(pred__20609.call(null,goog.events.KeyCodes.ESC,expr__20610))){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.reset_typeahead);
} else {
if(cljs.core.truth_(pred__20609.call(null,goog.events.KeyCodes.TAB,expr__20610))){
if(cljs.core.truth_(cljs.core.not_empty.call(null,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state_atom))))){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_next);

return event.preventDefault();
} else {
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.input_text_will_blur);
}
} else {
return true;
}
}
}
}
}
});
re_com.typeahead.typeahead_args_desc = new cljs.core.PersistentVector(null, 18, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"data-source","data-source",-658934676),new cljs.core.Keyword(null,"required","required",1807647006),true,new cljs.core.Keyword(null,"type","type",1174270348),"fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null)," supplies suggestion objects. This can either accept a single string argument (the search term), or a string and a callback. For the first case, the fn should return a collection of suggestion objects (which can be anything). For the second case, the fn should return ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil"], null),", and eventually result in a call to the callback with a collection of suggestion objects."], null)], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"on-change","on-change",-732046149),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"string -> nil",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":change-on-blur?"], null)," controls when it is called. It is passed a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 8, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, invoke ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-change"], null)," when the user chooses a suggestion, otherwise invoke it on every change (navigating through suggestions with the mouse or keyboard, or if ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"rigid?"], null)," is also ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null),", invoke it on every character typed.)"], null)], null),cljs.core.PersistentArrayMap.createAsIfByAssoc([new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"model","model",331153215),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),null,new cljs.core.Keyword(null,"type","type",1174270348),"object | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"The initial value of the typeahead (should match the suggestion objects returned by ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),")."]),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"debounce-delay","debounce-delay",-608187982),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),(250),new cljs.core.Keyword(null,"type","type",1174270348),"integer",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.integer_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"After receiving input, the typeahead will wait this many milliseconds without receiving new input before calling ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),"."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"render fn",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"override the rendering of the suggestion items by passing a fn that returns hiccup forms. The fn will receive two arguments: the search term, and the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"suggestion-to-string","suggestion-to-string",1991188962),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"suggestion -> string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.fn_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"When a suggestion is chosen, the input-text value will be set to the result of calling this fn with the suggestion object."], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"rigid?","rigid?",-1498832118),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),true,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"If ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"false"], null)," the user will be allowed to choose arbitrary text input rather than a suggestion from ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":data-source"], null),". In this case, a string will be supplied in lieu of a suggestion object."], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"keyword",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.input_status_type_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"validation status. ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),"nil/omitted"], null)," for normal status or one of: ",re_com.validate.input_status_types_list], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean",new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"when true, display an icon to match ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":status"], null)," (no icon for nil)"], null)], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"displayed in status icon's tooltip"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"background text shown when empty"], null),new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"width","width",-384071477),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),"250px",new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS width setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"height","height",1025178622),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"standard CSS height setting for this input"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"default","default",-1987822328),false,new cljs.core.Keyword(null,"type","type",1174270348),"boolean | atom",new cljs.core.Keyword(null,"description","description",-1428560544),"if true, the user can't interact (input anything)"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"class","class",-2030961996),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"string",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),cljs.core.string_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS class names, space separated"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"CSS style map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.css_style_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),"CSS styles to add or override"], null),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"name","name",1843675177),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.Keyword(null,"required","required",1807647006),false,new cljs.core.Keyword(null,"type","type",1174270348),"HTML attr map",new cljs.core.Keyword(null,"validate-fn","validate-fn",1430169944),re_com.validate.html_attr_QMARK_,new cljs.core.Keyword(null,"description","description",-1428560544),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),"HTML attributes, like ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":on-mouse-move"], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"br","br",934104792)], null),"No ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":class"], null)," or ",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"code","code",1586293142),":style"], null),"allowed"], null)], null)], null);
/**
 * typeahead reagent component
 */
re_com.typeahead.typeahead = (function re_com$typeahead$typeahead(var_args){
var args__4736__auto__ = [];
var len__4730__auto___20634 = arguments.length;
var i__4731__auto___20635 = (0);
while(true){
if((i__4731__auto___20635 < len__4730__auto___20634)){
args__4736__auto__.push((arguments[i__4731__auto___20635]));

var G__20636 = (i__4731__auto___20635 + (1));
i__4731__auto___20635 = G__20636;
continue;
} else {
}
break;
}

var argseq__4737__auto__ = ((((0) < args__4736__auto__.length))?(new cljs.core.IndexedSeq(args__4736__auto__.slice((0)),(0),null)):null);
return re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic(argseq__4737__auto__);
});

re_com.typeahead.typeahead.cljs$core$IFn$_invoke$arity$variadic = (function (p__20614){
var map__20615 = p__20614;
var map__20615__$1 = (((((!((map__20615 == null))))?(((((map__20615.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20615.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20615):map__20615);
var args = map__20615__$1;
if((((!(goog.DEBUG)))?true:re_com.validate.validate_args.call(null,re_com.validate.extract_arg_data.call(null,re_com.typeahead.typeahead_args_desc),args,"typeahead"))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__20617 = re_com.typeahead.make_typeahead_state.call(null,args);
var map__20617__$1 = (((((!((map__20617 == null))))?(((((map__20617.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20617.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20617):map__20617);
var state = map__20617__$1;
var c_search = cljs.core.get.call(null,map__20617__$1,new cljs.core.Keyword(null,"c-search","c-search",1832536180));
var c_input = cljs.core.get.call(null,map__20617__$1,new cljs.core.Keyword(null,"c-input","c-input",-1821004232));
var state_atom = reagent.core.atom.call(null,state);
var input_text_model = reagent.core.cursor.call(null,state_atom,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input-text","input-text",-1336297114)], null));
re_com.typeahead.search_data_source_loop_BANG_.call(null,state_atom,c_search);

return ((function (map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args){
return (function() { 
var G__20637__delegate = function (p__20619){
var map__20620 = p__20619;
var map__20620__$1 = (((((!((map__20620 == null))))?(((((map__20620.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20620.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20620):map__20620);
var args__$1 = map__20620__$1;
var disabled_QMARK_ = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181));
var status_icon_QMARK_ = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612));
var height = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"height","height",1025178622));
var status_tooltip = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007));
var model = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"model","model",331153215));
var _debounce_delay = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"_debounce-delay","_debounce-delay",-1476744225));
var _on_change = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"_on-change","_on-change",156649312));
var placeholder = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083));
var render_suggestion = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"render-suggestion","render-suggestion",1472406503));
var _suggestion_to_string = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"_suggestion-to-string","_suggestion-to-string",795407399));
var width = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var data_source = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"data-source","data-source",-658934676));
var _rigid_QMARK_ = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"_rigid?","_rigid?",1424449294));
var style = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"style","style",-496642736));
var _change_on_blur_QMARK_ = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"_change-on-blur?","_change-on-blur?",1219941073));
var status = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"status","status",-1997798413));
var class$ = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var _attr = cljs.core.get.call(null,map__20620__$1,new cljs.core.Keyword(null,"_attr","_attr",299438964));
if((((!(goog.DEBUG)))?true:re_com.validate.validate_args.call(null,re_com.validate.extract_arg_data.call(null,re_com.typeahead.typeahead_args_desc),args__$1,"typeahead"))){
} else {
throw (new Error("Assert failed: (validate-args-macro typeahead-args-desc args \"typeahead\")"));
}

var map__20622 = cljs.core.deref.call(null,state_atom);
var map__20622__$1 = (((((!((map__20622 == null))))?(((((map__20622.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__20622.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__20622):map__20622);
var state__$1 = map__20622__$1;
var suggestions = cljs.core.get.call(null,map__20622__$1,new cljs.core.Keyword(null,"suggestions","suggestions",-859472618));
var waiting_QMARK_ = cljs.core.get.call(null,map__20622__$1,new cljs.core.Keyword(null,"waiting?","waiting?",-2117257215));
var suggestion_active_index = cljs.core.get.call(null,map__20622__$1,new cljs.core.Keyword(null,"suggestion-active-index","suggestion-active-index",-1593564728));
var external_model = cljs.core.get.call(null,map__20622__$1,new cljs.core.Keyword(null,"external-model","external-model",506095421));
var last_data_source = new cljs.core.Keyword(null,"data-source","data-source",-658934676).cljs$core$IFn$_invoke$arity$1(state__$1);
var latest_external_model = re_com.util.deref_or_value.call(null,model);
var width__$1 = (function (){var or__4131__auto__ = width;
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return "250px";
}
})();
if(cljs.core.not_EQ_.call(null,last_data_source,data_source)){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.change_data_source,data_source);
} else {
}

if(cljs.core.not_EQ_.call(null,latest_external_model,external_model)){
cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.external_model_changed,latest_external_model);
} else {
}

return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 27, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.input_text,new cljs.core.Keyword(null,"model","model",331153215),input_text_model,new cljs.core.Keyword(null,"class","class",-2030961996),class$,new cljs.core.Keyword(null,"style","style",-496642736),style,new cljs.core.Keyword(null,"disabled?","disabled?",-1523234181),disabled_QMARK_,new cljs.core.Keyword(null,"status-icon?","status-icon?",1328423612),status_icon_QMARK_,new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"status-tooltip","status-tooltip",1912159007),status_tooltip,new cljs.core.Keyword(null,"width","width",-384071477),width__$1,new cljs.core.Keyword(null,"height","height",1025178622),height,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),placeholder,new cljs.core.Keyword(null,"on-change","on-change",-732046149),cljs.core.partial.call(null,re_com.typeahead.input_text_on_change_BANG_,state_atom),new cljs.core.Keyword(null,"change-on-blur?","change-on-blur?",854283925),false,new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-key-down","on-key-down",-1374733765),cljs.core.partial.call(null,re_com.typeahead.input_text_on_key_down_BANG_,state_atom)], null)], null),(cljs.core.truth_((function (){var or__4131__auto__ = cljs.core.not_empty.call(null,suggestions);
if(cljs.core.truth_(or__4131__auto__)){
return or__4131__auto__;
} else {
return waiting_QMARK_;
}
})())?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"position","position",-2011731912),"relative"], null),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.v_box,new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-suggestions-container",new cljs.core.Keyword(null,"children","children",-940561982),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(waiting_QMARK_)?new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"align","align",1964212802),new cljs.core.Keyword(null,"center","center",-748944368),new cljs.core.Keyword(null,"child","child",623967545),new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.misc.throbber,new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"small","small",2133478704),new cljs.core.Keyword(null,"class","class",-2030961996),"rc-typeahead-throbber"], null)], null):null),(function (){var iter__4523__auto__ = ((function (map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args){
return (function re_com$typeahead$iter__20624(s__20625){
return (new cljs.core.LazySeq(null,((function (map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args){
return (function (){
var s__20625__$1 = s__20625;
while(true){
var temp__5457__auto__ = cljs.core.seq.call(null,s__20625__$1);
if(temp__5457__auto__){
var s__20625__$2 = temp__5457__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__20625__$2)){
var c__4521__auto__ = cljs.core.chunk_first.call(null,s__20625__$2);
var size__4522__auto__ = cljs.core.count.call(null,c__4521__auto__);
var b__20627 = cljs.core.chunk_buffer.call(null,size__4522__auto__);
if((function (){var i__20626 = (0);
while(true){
if((i__20626 < size__4522__auto__)){
var vec__20628 = cljs.core._nth.call(null,c__4521__auto__,i__20626);
var i = cljs.core.nth.call(null,vec__20628,(0),null);
var s = cljs.core.nth.call(null,vec__20628,(1),null);
var selected_QMARK_ = cljs.core._EQ_.call(null,suggestion_active_index,i);
cljs.core.chunk_append.call(null,b__20627,cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?render_suggestion.call(null,s):s),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-typeahead-suggestion",((selected_QMARK_)?" active":null)].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (i__20626,selected_QMARK_,vec__20628,i,s,c__4521__auto__,size__4522__auto__,b__20627,s__20625__$2,temp__5457__auto__,map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args){
return (function (){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(i__20626,selected_QMARK_,vec__20628,i,s,c__4521__auto__,size__4522__auto__,b__20627,s__20625__$2,temp__5457__auto__,map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (i__20626,selected_QMARK_,vec__20628,i,s,c__4521__auto__,size__4522__auto__,b__20627,s__20625__$2,temp__5457__auto__,map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args){
return (function (p1__20612_SHARP_){
p1__20612_SHARP_.preventDefault();

return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(i__20626,selected_QMARK_,vec__20628,i,s,c__4521__auto__,size__4522__auto__,b__20627,s__20625__$2,temp__5457__auto__,map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)));

var G__20638 = (i__20626 + (1));
i__20626 = G__20638;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20627),re_com$typeahead$iter__20624.call(null,cljs.core.chunk_rest.call(null,s__20625__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__20627),null);
}
} else {
var vec__20631 = cljs.core.first.call(null,s__20625__$2);
var i = cljs.core.nth.call(null,vec__20631,(0),null);
var s = cljs.core.nth.call(null,vec__20631,(1),null);
var selected_QMARK_ = cljs.core._EQ_.call(null,suggestion_active_index,i);
return cljs.core.cons.call(null,cljs.core.with_meta(new cljs.core.PersistentVector(null, 7, 5, cljs.core.PersistentVector.EMPTY_NODE, [re_com.box.box,new cljs.core.Keyword(null,"child","child",623967545),(cljs.core.truth_(render_suggestion)?render_suggestion.call(null,s):s),new cljs.core.Keyword(null,"class","class",-2030961996),["rc-typeahead-suggestion",((selected_QMARK_)?" active":null)].join(''),new cljs.core.Keyword(null,"attr","attr",-604132353),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-mouse-over","on-mouse-over",-858472552),((function (selected_QMARK_,vec__20631,i,s,s__20625__$2,temp__5457__auto__,map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args){
return (function (){
return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.activate_suggestion_by_index,i);
});})(selected_QMARK_,vec__20631,i,s,s__20625__$2,temp__5457__auto__,map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args))
,new cljs.core.Keyword(null,"on-mouse-down","on-mouse-down",1147755470),((function (selected_QMARK_,vec__20631,i,s,s__20625__$2,temp__5457__auto__,map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args){
return (function (p1__20612_SHARP_){
p1__20612_SHARP_.preventDefault();

return cljs.core.swap_BANG_.call(null,state_atom,re_com.typeahead.choose_suggestion_by_index,i);
});})(selected_QMARK_,vec__20631,i,s,s__20625__$2,temp__5457__auto__,map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args))
], null)], null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),i], null)),re_com$typeahead$iter__20624.call(null,cljs.core.rest.call(null,s__20625__$2)));
}
} else {
return null;
}
break;
}
});})(map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args))
,null,null));
});})(map__20622,map__20622__$1,state__$1,suggestions,waiting_QMARK_,suggestion_active_index,external_model,last_data_source,latest_external_model,width__$1,map__20620,map__20620__$1,args__$1,disabled_QMARK_,status_icon_QMARK_,height,status_tooltip,model,_debounce_delay,_on_change,placeholder,render_suggestion,_suggestion_to_string,width,data_source,_rigid_QMARK_,style,_change_on_blur_QMARK_,status,class$,_attr,map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args))
;
return iter__4523__auto__.call(null,cljs.core.map.call(null,cljs.core.vector,cljs.core.range.call(null),suggestions));
})()], null)], null)], null):null)], null)], null);
};
var G__20637 = function (var_args){
var p__20619 = null;
if (arguments.length > 0) {
var G__20639__i = 0, G__20639__a = new Array(arguments.length -  0);
while (G__20639__i < G__20639__a.length) {G__20639__a[G__20639__i] = arguments[G__20639__i + 0]; ++G__20639__i;}
  p__20619 = new cljs.core.IndexedSeq(G__20639__a,0,null);
} 
return G__20637__delegate.call(this,p__20619);};
G__20637.cljs$lang$maxFixedArity = 0;
G__20637.cljs$lang$applyTo = (function (arglist__20640){
var p__20619 = cljs.core.seq(arglist__20640);
return G__20637__delegate(p__20619);
});
G__20637.cljs$core$IFn$_invoke$arity$variadic = G__20637__delegate;
return G__20637;
})()
;
;})(map__20617,map__20617__$1,state,c_search,c_input,state_atom,input_text_model,map__20615,map__20615__$1,args))
});

re_com.typeahead.typeahead.cljs$lang$maxFixedArity = (0);

/** @this {Function} */
re_com.typeahead.typeahead.cljs$lang$applyTo = (function (seq20613){
var self__4718__auto__ = this;
return self__4718__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq20613));
});

/**
 * Return a channel which will receive a value from the `in` channel only
 *   if no further value is received on the `in` channel in the next `ms` milliseconds.
 */
re_com.typeahead.debounce = (function re_com$typeahead$debounce(in$,ms){
var out = cljs.core.async.chan.call(null);
var c__2429__auto___20721 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__2429__auto___20721,out){
return (function (){
var f__2430__auto__ = (function (){var switch__2334__auto__ = ((function (c__2429__auto___20721,out){
return (function (state_20691){
var state_val_20692 = (state_20691[(1)]);
if((state_val_20692 === (7))){
var inst_20646 = (state_20691[(2)]);
var state_20691__$1 = state_20691;
var statearr_20693_20722 = state_20691__$1;
(statearr_20693_20722[(2)] = inst_20646);

(statearr_20693_20722[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (1))){
var inst_20641 = null;
var state_20691__$1 = (function (){var statearr_20694 = state_20691;
(statearr_20694[(7)] = inst_20641);

return statearr_20694;
})();
var statearr_20695_20723 = state_20691__$1;
(statearr_20695_20723[(2)] = null);

(statearr_20695_20723[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (4))){
var state_20691__$1 = state_20691;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_20691__$1,(7),in$);
} else {
if((state_val_20692 === (15))){
var inst_20676 = (state_20691[(2)]);
var state_20691__$1 = (function (){var statearr_20696 = state_20691;
(statearr_20696[(8)] = inst_20676);

return statearr_20696;
})();
var statearr_20697_20724 = state_20691__$1;
(statearr_20697_20724[(2)] = null);

(statearr_20697_20724[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (13))){
var inst_20664 = (state_20691[(9)]);
var inst_20678 = cljs.core._EQ_.call(null,inst_20664,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_20691__$1 = state_20691;
if(inst_20678){
var statearr_20698_20725 = state_20691__$1;
(statearr_20698_20725[(1)] = (16));

} else {
var statearr_20699_20726 = state_20691__$1;
(statearr_20699_20726[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (6))){
var inst_20650 = (state_20691[(10)]);
var inst_20649 = (state_20691[(2)]);
var inst_20650__$1 = cljs.core.async.timeout.call(null,ms);
var inst_20658 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_20659 = [in$,inst_20650__$1];
var inst_20660 = (new cljs.core.PersistentVector(null,2,(5),inst_20658,inst_20659,null));
var state_20691__$1 = (function (){var statearr_20700 = state_20691;
(statearr_20700[(10)] = inst_20650__$1);

(statearr_20700[(11)] = inst_20649);

return statearr_20700;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_20691__$1,(8),inst_20660);
} else {
if((state_val_20692 === (17))){
var state_20691__$1 = state_20691;
var statearr_20701_20727 = state_20691__$1;
(statearr_20701_20727[(2)] = null);

(statearr_20701_20727[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (3))){
var inst_20689 = (state_20691[(2)]);
var state_20691__$1 = state_20691;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_20691__$1,inst_20689);
} else {
if((state_val_20692 === (12))){
var inst_20649 = (state_20691[(11)]);
var state_20691__$1 = state_20691;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_20691__$1,(15),out,inst_20649);
} else {
if((state_val_20692 === (2))){
var inst_20641 = (state_20691[(7)]);
var inst_20643 = (inst_20641 == null);
var state_20691__$1 = state_20691;
if(cljs.core.truth_(inst_20643)){
var statearr_20702_20728 = state_20691__$1;
(statearr_20702_20728[(1)] = (4));

} else {
var statearr_20703_20729 = state_20691__$1;
(statearr_20703_20729[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (11))){
var inst_20686 = (state_20691[(2)]);
var inst_20641 = inst_20686;
var state_20691__$1 = (function (){var statearr_20704 = state_20691;
(statearr_20704[(7)] = inst_20641);

return statearr_20704;
})();
var statearr_20705_20730 = state_20691__$1;
(statearr_20705_20730[(2)] = null);

(statearr_20705_20730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (9))){
var inst_20662 = (state_20691[(12)]);
var inst_20670 = cljs.core.nth.call(null,inst_20662,(0),null);
var inst_20671 = cljs.core.nth.call(null,inst_20662,(1),null);
var state_20691__$1 = (function (){var statearr_20706 = state_20691;
(statearr_20706[(13)] = inst_20671);

return statearr_20706;
})();
var statearr_20707_20731 = state_20691__$1;
(statearr_20707_20731[(2)] = inst_20670);

(statearr_20707_20731[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (5))){
var inst_20641 = (state_20691[(7)]);
var state_20691__$1 = state_20691;
var statearr_20708_20732 = state_20691__$1;
(statearr_20708_20732[(2)] = inst_20641);

(statearr_20708_20732[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (14))){
var inst_20684 = (state_20691[(2)]);
var state_20691__$1 = state_20691;
var statearr_20709_20733 = state_20691__$1;
(statearr_20709_20733[(2)] = inst_20684);

(statearr_20709_20733[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (16))){
var inst_20663 = (state_20691[(14)]);
var state_20691__$1 = state_20691;
var statearr_20710_20734 = state_20691__$1;
(statearr_20710_20734[(2)] = inst_20663);

(statearr_20710_20734[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (10))){
var inst_20664 = (state_20691[(9)]);
var inst_20650 = (state_20691[(10)]);
var inst_20673 = cljs.core._EQ_.call(null,inst_20664,inst_20650);
var state_20691__$1 = state_20691;
if(inst_20673){
var statearr_20711_20735 = state_20691__$1;
(statearr_20711_20735[(1)] = (12));

} else {
var statearr_20712_20736 = state_20691__$1;
(statearr_20712_20736[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (18))){
var inst_20682 = (state_20691[(2)]);
var state_20691__$1 = state_20691;
var statearr_20713_20737 = state_20691__$1;
(statearr_20713_20737[(2)] = inst_20682);

(statearr_20713_20737[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_20692 === (8))){
var inst_20662 = (state_20691[(12)]);
var inst_20664 = (state_20691[(9)]);
var inst_20662__$1 = (state_20691[(2)]);
var inst_20663 = cljs.core.nth.call(null,inst_20662__$1,(0),null);
var inst_20664__$1 = cljs.core.nth.call(null,inst_20662__$1,(1),null);
var inst_20665 = cljs.core._EQ_.call(null,inst_20664__$1,in$);
var state_20691__$1 = (function (){var statearr_20714 = state_20691;
(statearr_20714[(12)] = inst_20662__$1);

(statearr_20714[(9)] = inst_20664__$1);

(statearr_20714[(14)] = inst_20663);

return statearr_20714;
})();
if(inst_20665){
var statearr_20715_20738 = state_20691__$1;
(statearr_20715_20738[(1)] = (9));

} else {
var statearr_20716_20739 = state_20691__$1;
(statearr_20716_20739[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__2429__auto___20721,out))
;
return ((function (switch__2334__auto__,c__2429__auto___20721,out){
return (function() {
var re_com$typeahead$debounce_$_state_machine__2335__auto__ = null;
var re_com$typeahead$debounce_$_state_machine__2335__auto____0 = (function (){
var statearr_20717 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_20717[(0)] = re_com$typeahead$debounce_$_state_machine__2335__auto__);

(statearr_20717[(1)] = (1));

return statearr_20717;
});
var re_com$typeahead$debounce_$_state_machine__2335__auto____1 = (function (state_20691){
while(true){
var ret_value__2336__auto__ = (function (){try{while(true){
var result__2337__auto__ = switch__2334__auto__.call(null,state_20691);
if(cljs.core.keyword_identical_QMARK_.call(null,result__2337__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2337__auto__;
}
break;
}
}catch (e20718){if((e20718 instanceof Object)){
var ex__2338__auto__ = e20718;
var statearr_20719_20740 = state_20691;
(statearr_20719_20740[(5)] = ex__2338__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_20691);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e20718;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__2336__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__20741 = state_20691;
state_20691 = G__20741;
continue;
} else {
return ret_value__2336__auto__;
}
break;
}
});
re_com$typeahead$debounce_$_state_machine__2335__auto__ = function(state_20691){
switch(arguments.length){
case 0:
return re_com$typeahead$debounce_$_state_machine__2335__auto____0.call(this);
case 1:
return re_com$typeahead$debounce_$_state_machine__2335__auto____1.call(this,state_20691);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
re_com$typeahead$debounce_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$0 = re_com$typeahead$debounce_$_state_machine__2335__auto____0;
re_com$typeahead$debounce_$_state_machine__2335__auto__.cljs$core$IFn$_invoke$arity$1 = re_com$typeahead$debounce_$_state_machine__2335__auto____1;
return re_com$typeahead$debounce_$_state_machine__2335__auto__;
})()
;})(switch__2334__auto__,c__2429__auto___20721,out))
})();
var state__2431__auto__ = (function (){var statearr_20720 = f__2430__auto__.call(null);
(statearr_20720[(6)] = c__2429__auto___20721);

return statearr_20720;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__2431__auto__);
});})(c__2429__auto___20721,out))
);


return out;
});

//# sourceMappingURL=typeahead.js.map
