// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.events.boot');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('bluegenes.db');
goog.require('imcljs.fetch');
goog.require('bluegenes.persistence');
goog.require('bluegenes.events.webproperties');
goog.require('bluegenes.events.registry');
goog.require('bluegenes.route');
/**
 * Produces a set of re-frame instructions that load all of InterMine's assets into BlueGenes
 *   See https://github.com/Day8/re-frame-async-flow-fx
 *   The idea is that any URL routing (such as entering BlueGenes at the home page or a subsection)
 *   is queued until all of the assets (data model, lists, templates etc) are fetched.
 *   When finished, an event called :finished-loading-assets is dispatch which tells BlueGenes
 *   it can continue routing.
 */
bluegenes.events.boot.boot_flow = (function bluegenes$events$boot$boot_flow(){
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"first-dispatch","first-dispatch",128561923),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("bluegenes.events.registry","load-other-mines","bluegenes.events.registry/load-other-mines",-899464853)], null),new cljs.core.Keyword(null,"rules","rules",1198912366),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"when","when",-576417306),new cljs.core.Keyword(null,"seen?","seen?",-1677689856),new cljs.core.Keyword(null,"events","events",1792552201),new cljs.core.Keyword(null,"success-init-mine","success-init-mine",-864345299),new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("authentication","init","authentication/init",1028540718)], null)], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"when","when",-576417306),new cljs.core.Keyword(null,"seen?","seen?",-1677689856),new cljs.core.Keyword(null,"events","events",1792552201),new cljs.core.Keyword("authentication","store-token","authentication/store-token",-1603552296),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-web-properties","assets/fetch-web-properties",-1351896981)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-model","assets/fetch-model",-1338935552)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-lists","assets/fetch-lists",833336064)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-class-keys","assets/fetch-class-keys",-252663573)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-templates","assets/fetch-templates",-1183621769)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-widgets","assets/fetch-widgets",-1748076788)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-summary-fields","assets/fetch-summary-fields",-1838330087)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-intermine-version","assets/fetch-intermine-version",-1791303773)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-web-service-version","assets/fetch-web-service-version",-1026252895)], null)], null)], null),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"when","when",-576417306),new cljs.core.Keyword(null,"seen-all-of?","seen-all-of?",-651402557),new cljs.core.Keyword(null,"events","events",1792552201),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","success-fetch-model","assets/success-fetch-model",689324044),new cljs.core.Keyword("assets","success-fetch-web-properties","assets/success-fetch-web-properties",-1669887773),new cljs.core.Keyword("assets","success-fetch-lists","assets/success-fetch-lists",-513441218),new cljs.core.Keyword("assets","success-fetch-class-keys","assets/success-fetch-class-keys",804782056),new cljs.core.Keyword("assets","success-fetch-templates","assets/success-fetch-templates",1754466448),new cljs.core.Keyword("assets","success-fetch-summary-fields","assets/success-fetch-summary-fields",888030039),new cljs.core.Keyword("assets","success-fetch-widgets","assets/success-fetch-widgets",-97144362),new cljs.core.Keyword("assets","success-fetch-intermine-version","assets/success-fetch-intermine-version",1964989384),new cljs.core.Keyword("assets","success-fetch-web-service-version","assets/success-fetch-web-service-version",-42494710)], null),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"verify-web-service-version","verify-web-service-version",1396752845)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"start-analytics","start-analytics",1396555627)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"finished-loading-assets","finished-loading-assets",-1153301787)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"save-state","save-state",-1689196426)], null)], null),new cljs.core.Keyword(null,"halt?","halt?",-1110658247),true], null)], null)], null);
});
/**
 * Creates instructions for listening in on im-tables events.
 *   Why? im-tables is its own re-frame application and it can save query results.
 *   When its save-list-success event is seen, fire a BlueGenes event to re-fetch lists
 */
bluegenes.events.boot.im_tables_events_forwarder = (function bluegenes$events$boot$im_tables_events_forwarder(){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"register","register",1968522516),new cljs.core.Keyword(null,"im-tables-events","im-tables-events",79541413),new cljs.core.Keyword(null,"events","events",1792552201),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword("imt.io","save-list-success","imt.io/save-list-success",-1476333664),null], null), null),new cljs.core.Keyword(null,"dispatch-to","dispatch-to",-354764401),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"intercept-save-list","intercept-save-list",-1999716198)], null)], null);
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword(null,"intercept-save-list","intercept-save-list",-1999716198),(function (p__16580,p__16581){
var map__16582 = p__16580;
var map__16582__$1 = (((((!((map__16582 == null))))?(((((map__16582.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16582.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16582):map__16582);
var db = cljs.core.get.call(null,map__16582__$1,new cljs.core.Keyword(null,"db","db",993250759));
var vec__16583 = p__16581;
var _ = cljs.core.nth.call(null,vec__16583,(0),null);
var vec__16586 = cljs.core.nth.call(null,vec__16583,(1),null);
var ___$1 = cljs.core.nth.call(null,vec__16586,(0),null);
var map__16589 = cljs.core.nth.call(null,vec__16586,(1),null);
var map__16589__$1 = (((((!((map__16589 == null))))?(((((map__16589.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16589.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16589):map__16589);
var evt = map__16589__$1;
var listName = cljs.core.get.call(null,map__16589__$1,new cljs.core.Keyword(null,"listName","listName",849054384));
var listSize = cljs.core.get.call(null,map__16589__$1,new cljs.core.Keyword(null,"listSize","listSize",-89176038));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.update.call(null,db,new cljs.core.Keyword(null,"messages","messages",345434482),cljs.core.conj),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","fetch-lists","assets/fetch-lists",833336064)], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("messages","add","messages/add",294859927),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"markup","markup",2143234544),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"span","span",1394872991),["Saved list to My Data: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(listName)].join('')], null),new cljs.core.Keyword(null,"style","style",-496642736),"success"], null)], null)], null)], null);
}));
/**
 * If this bluegenes instance is coupled with InterMine, load the intermine's
 *   config directly from env variables passed to bluegenes. Otherwise, create a
 *   default mine config.
 */
bluegenes.events.boot.init_mine_defaults = (function bluegenes$events$boot$init_mine_defaults(){
var map__16592 = new cljs.core.Keyword(null,"intermineDefaults","intermineDefaults",-638859257).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,serverVars,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
var map__16592__$1 = (((((!((map__16592 == null))))?(((((map__16592.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16592.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16592):map__16592);
var serverVars = map__16592__$1;
var serviceRoot = cljs.core.get.call(null,map__16592__$1,new cljs.core.Keyword(null,"serviceRoot","serviceRoot",1887843538));
var mineName = cljs.core.get.call(null,map__16592__$1,new cljs.core.Keyword(null,"mineName","mineName",1661647254));
if(cljs.core.seq.call(null,serverVars)){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword(null,"name","name",1843675177),mineName,new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"root","root",-448657453),serviceRoot], null)], null);
} else {
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"default","default",-1987822328),new cljs.core.Keyword(null,"name","name",1843675177),null,new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"root","root",-448657453),"http://www.flymine.org/flymine",new cljs.core.Keyword(null,"token","token",-1211463215),null], null)], null);
}
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword(null,"boot","boot",2007860585),(function (_world,p__16594){
var vec__16595 = p__16594;
var _ = cljs.core.nth.call(null,vec__16595,(0),null);
var provided_identity = cljs.core.nth.call(null,vec__16595,(1),null);
var db = cljs.core.update.call(null,cljs.core.assoc_in.call(null,bluegenes.db.default_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),new cljs.core.Keyword(null,"default","default",-1987822328)], null),bluegenes.events.boot.init_mine_defaults.call(null)),new cljs.core.Keyword(null,"auth","auth",1389754926),cljs.core.assoc,new cljs.core.Keyword(null,"thinking?","thinking?",731614708),false,new cljs.core.Keyword(null,"identity","identity",1647396035),provided_identity,new cljs.core.Keyword(null,"message","message",-406056002),null,new cljs.core.Keyword(null,"error?","error?",-460689159),false);
var map__16598 = bluegenes.persistence.get_state_BANG_.call(null);
var map__16598__$1 = (((((!((map__16598 == null))))?(((((map__16598.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16598.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16598):map__16598);
var state = map__16598__$1;
var current_mine = cljs.core.get.call(null,map__16598__$1,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086));
var mines = cljs.core.get.call(null,map__16598__$1,new cljs.core.Keyword(null,"mines","mines",-1960796490));
var assets = cljs.core.get.call(null,map__16598__$1,new cljs.core.Keyword(null,"assets","assets",210278279));
var version = cljs.core.get.call(null,map__16598__$1,new cljs.core.Keyword(null,"version","version",425292698));
var updated_mines = cljs.core.assoc.call(null,mines,new cljs.core.Keyword(null,"default","default",-1987822328),bluegenes.events.boot.init_mine_defaults.call(null));
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"db","db",993250759),(function (){var G__16600 = db;
if(((cljs.core.seq.call(null,state)) && (cljs.core._EQ_.call(null,bluegenes.core.version,version)))){
return cljs.core.assoc.call(null,G__16600,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086),current_mine,new cljs.core.Keyword(null,"mines","mines",-1960796490),updated_mines,new cljs.core.Keyword(null,"assets","assets",210278279),assets,new cljs.core.Keyword(null,"fetching-assets?","fetching-assets?",-1083188189),true);
} else {
return G__16600;
}
})(),new cljs.core.Keyword(null,"async-flow","async-flow",1464712702),bluegenes.events.boot.boot_flow.call(null),new cljs.core.Keyword(null,"forward-events","forward-events",1216790539),bluegenes.events.boot.im_tables_events_forwarder.call(null)], null);
}));
/**
 * Any tools / components that have mine-specific state should lose that
 * state if we switch mines. For example, in list upload (ID Resolver),
 * drosophila IDs are no longer valid when using humanmine.
 */
bluegenes.events.boot.remove_stateful_keys_from_db = (function bluegenes$events$boot$remove_stateful_keys_from_db(db){
return cljs.core.dissoc.call(null,db,new cljs.core.Keyword(null,"regions","regions",-1023815958),new cljs.core.Keyword(null,"idresolver","idresolver",-897787),new cljs.core.Keyword(null,"results","results",-1134170113),new cljs.core.Keyword(null,"qb","qb",-1714166232));
});
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword(null,"reboot","reboot",-551992237),(function (p__16601){
var map__16602 = p__16601;
var map__16602__$1 = (((((!((map__16602 == null))))?(((((map__16602.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16602.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16602):map__16602);
var db = cljs.core.get.call(null,map__16602__$1,new cljs.core.Keyword(null,"db","db",993250759));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),bluegenes.events.boot.remove_stateful_keys_from_db.call(null,db),new cljs.core.Keyword(null,"async-flow","async-flow",1464712702),bluegenes.events.boot.boot_flow.call(null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword(null,"finished-loading-assets","finished-loading-assets",-1153301787),(function (p__16604){
var map__16605 = p__16604;
var map__16605__$1 = (((((!((map__16605 == null))))?(((((map__16605.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16605.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16605):map__16605);
var db = cljs.core.get.call(null,map__16605__$1,new cljs.core.Keyword(null,"db","db",993250759));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"fetching-assets?","fetching-assets?",-1083188189),false),new cljs.core.Keyword(null,"dispatch-n","dispatch-n",-504469236),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("cache","fetch-organisms","cache/fetch-organisms",-1779776279)], null),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("regions","select-all-feature-types","regions/select-all-feature-types",-282414240)], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword(null,"verify-web-service-version","verify-web-service-version",1396752845),(function (p__16607){
var map__16608 = p__16607;
var map__16608__$1 = (((((!((map__16608 == null))))?(((((map__16608.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16608.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16608):map__16608);
var db = cljs.core.get.call(null,map__16608__$1,new cljs.core.Keyword(null,"db","db",993250759));
var mine_16610 = cljs.core.get.call(null,db,new cljs.core.Keyword(null,"current-mine","current-mine",-697419086));
var version_16611 = Number(cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"web-service-version","web-service-version",1822428804),mine_16610], null)));
if((((version_16611 < (26))) && ((!((version_16611 === (0))))))){
alert(["You are using an outdated InterMine WebService version: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version_16611),". Unexpected behaviour may occur. We recommend updating to version 26 or above."].join(''));
} else {
}

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),db], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword(null,"start-analytics","start-analytics",1396555627),(function (p__16612){
var map__16613 = p__16612;
var map__16613__$1 = (((((!((map__16613 == null))))?(((((map__16613.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16613.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16613):map__16613);
var db = cljs.core.get.call(null,map__16613__$1,new cljs.core.Keyword(null,"db","db",993250759));
var analytics_id = new cljs.core.Keyword(null,"googleAnalytics","googleAnalytics",-70045672).cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.call(null,serverVars,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true));
var analytics_enabled_QMARK_ = (!(clojure.string.blank_QMARK_.call(null,analytics_id)));
if(analytics_enabled_QMARK_){
ga("create",analytics_id,"auto");

ga("send","pageview");

console.info("Google Analytics enabled. Tracking ID:",analytics_id);
} else {
console.info("Google Analytics disabled. No tracking ID.");
}

return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"db","db",993250759),cljs.core.assoc.call(null,db,new cljs.core.Keyword(null,"google-analytics","google-analytics",-232541620),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"enabled?","enabled?",-1376075057),analytics_enabled_QMARK_,new cljs.core.Keyword(null,"analytics-id","analytics-id",-1098830374),analytics_id], null))], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("authentication","init","authentication/init",1028540718),(function (p__16615,_){
var map__16616 = p__16615;
var map__16616__$1 = (((((!((map__16616 == null))))?(((((map__16616.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16616.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16616):map__16616);
var db = cljs.core.get.call(null,map__16616__$1,new cljs.core.Keyword(null,"db","db",993250759));
var has_identity_QMARK_ = cljs.core.map_QMARK_.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"identity","identity",1647396035)], null)));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dispatch","dispatch",1319337009),((has_identity_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("authentication","store-token","authentication/store-token",-1603552296)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("authentication","fetch-anonymous-token","authentication/fetch-anonymous-token",-123225696)], null))], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("authentication","store-token","authentication/store-token",-1603552296),(function (db,_){
var mine_kw = new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db);
var token = cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"auth","auth",1389754926),new cljs.core.Keyword(null,"identity","identity",1647396035),new cljs.core.Keyword(null,"token","token",-1211463215)], null));
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),mine_kw,new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"token","token",-1211463215)], null),token);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("authentication","fetch-anonymous-token","authentication/fetch-anonymous-token",-123225696),(function (p__16618,_){
var map__16619 = p__16618;
var map__16619__$1 = (((((!((map__16619 == null))))?(((((map__16619.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16619.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16619):map__16619);
var db = cljs.core.get.call(null,map__16619__$1,new cljs.core.Keyword(null,"db","db",993250759));
var mine_kw = new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db);
var mine_name = ((cljs.core.contains_QMARK_.call(null,cljs.core.get.call(null,db,new cljs.core.Keyword(null,"mines","mines",-1960796490)),mine_kw))?mine_kw:new cljs.core.Keyword(null,"default","default",-1987822328));
var mine = cljs.core.dissoc.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),mine_name,new cljs.core.Keyword(null,"service","service",-1963054559)], null)),new cljs.core.Keyword(null,"token","token",-1211463215));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("authentication","store-token","authentication/store-token",-1603552296)], null),new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.fetch.session.call(null,mine)], null)], null);
}));
bluegenes.events.boot.preferred_tag = "im:preferredBagType";
/**
 * extricate preferred fields (e.g. default field types for dropdowns, usually protein and gene) from the model
 */
bluegenes.events.boot.preferred_fields = (function bluegenes$events$boot$preferred_fields(model){
return cljs.core.keys.call(null,cljs.core.filter.call(null,cljs.core.comp.call(null,(function (p1__16621_SHARP_){
return cljs.core.contains_QMARK_.call(null,p1__16621_SHARP_,bluegenes.events.boot.preferred_tag);
}),cljs.core.set,new cljs.core.Keyword(null,"tags","tags",1771418977),cljs.core.second),new cljs.core.Keyword(null,"classes","classes",2037804510).cljs$core$IFn$_invoke$arity$1(model)));
});
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("assets","success-fetch-model","assets/success-fetch-model",689324044),(function (db,p__16622){
var vec__16623 = p__16622;
var _ = cljs.core.nth.call(null,vec__16623,(0),null);
var mine_kw = cljs.core.nth.call(null,vec__16623,(1),null);
var model = cljs.core.nth.call(null,vec__16623,(2),null);
return cljs.core.assoc_in.call(null,cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),mine_kw,new cljs.core.Keyword(null,"service","service",-1963054559),new cljs.core.Keyword(null,"model","model",331153215)], null),model),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),mine_kw,new cljs.core.Keyword(null,"default-object-types","default-object-types",525632084)], null),cljs.core.sort.call(null,bluegenes.events.boot.preferred_fields.call(null,model)));
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("assets","fetch-model","assets/fetch-model",-1338935552),(function (p__16626){
var map__16627 = p__16626;
var map__16627__$1 = (((((!((map__16627 == null))))?(((((map__16627.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16627.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16627):map__16627);
var db = cljs.core.get.call(null,map__16627__$1,new cljs.core.Keyword(null,"db","db",993250759));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.fetch.model.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db),new cljs.core.Keyword(null,"service","service",-1963054559)], null))),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","success-fetch-model","assets/success-fetch-model",689324044),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("assets","success-fetch-lists","assets/success-fetch-lists",-513441218),(function (db,p__16629){
var vec__16630 = p__16629;
var _ = cljs.core.nth.call(null,vec__16630,(0),null);
var mine_kw = cljs.core.nth.call(null,vec__16630,(1),null);
var lists = cljs.core.nth.call(null,vec__16630,(2),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"lists","lists",-884730684),mine_kw], null),lists);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("assets","fetch-lists","assets/fetch-lists",833336064),(function (p__16633){
var map__16634 = p__16633;
var map__16634__$1 = (((((!((map__16634 == null))))?(((((map__16634.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16634.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16634):map__16634);
var db = cljs.core.get.call(null,map__16634__$1,new cljs.core.Keyword(null,"db","db",993250759));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.fetch.lists.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db),new cljs.core.Keyword(null,"service","service",-1963054559)], null))),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","success-fetch-lists","assets/success-fetch-lists",-513441218),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("assets","success-fetch-class-keys","assets/success-fetch-class-keys",804782056),(function (db,p__16636){
var vec__16637 = p__16636;
var _ = cljs.core.nth.call(null,vec__16637,(0),null);
var mine_kw = cljs.core.nth.call(null,vec__16637,(1),null);
var class_keys = cljs.core.nth.call(null,vec__16637,(2),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),mine_kw,new cljs.core.Keyword(null,"class-keys","class-keys",106917605)], null),class_keys);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("assets","fetch-class-keys","assets/fetch-class-keys",-252663573),(function (p__16640){
var map__16641 = p__16640;
var map__16641__$1 = (((((!((map__16641 == null))))?(((((map__16641.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16641.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16641):map__16641);
var db = cljs.core.get.call(null,map__16641__$1,new cljs.core.Keyword(null,"db","db",993250759));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.fetch.class_keys.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db),new cljs.core.Keyword(null,"service","service",-1963054559)], null))),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","success-fetch-class-keys","assets/success-fetch-class-keys",804782056),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("assets","success-fetch-templates","assets/success-fetch-templates",1754466448),(function (db,p__16643){
var vec__16644 = p__16643;
var _ = cljs.core.nth.call(null,vec__16644,(0),null);
var mine_kw = cljs.core.nth.call(null,vec__16644,(1),null);
var lists = cljs.core.nth.call(null,vec__16644,(2),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"templates","templates",-1237401733),mine_kw], null),lists);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("assets","fetch-templates","assets/fetch-templates",-1183621769),(function (p__16647){
var map__16648 = p__16647;
var map__16648__$1 = (((((!((map__16648 == null))))?(((((map__16648.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16648.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16648):map__16648);
var db = cljs.core.get.call(null,map__16648__$1,new cljs.core.Keyword(null,"db","db",993250759));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.fetch.templates.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db),new cljs.core.Keyword(null,"service","service",-1963054559)], null))),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","success-fetch-templates","assets/success-fetch-templates",1754466448),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("assets","success-fetch-summary-fields","assets/success-fetch-summary-fields",888030039),(function (db,p__16650){
var vec__16651 = p__16650;
var _ = cljs.core.nth.call(null,vec__16651,(0),null);
var mine_kw = cljs.core.nth.call(null,vec__16651,(1),null);
var lists = cljs.core.nth.call(null,vec__16651,(2),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"summary-fields","summary-fields",-51287384),mine_kw], null),lists);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("assets","fetch-summary-fields","assets/fetch-summary-fields",-1838330087),(function (p__16654){
var map__16655 = p__16654;
var map__16655__$1 = (((((!((map__16655 == null))))?(((((map__16655.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16655.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16655):map__16655);
var db = cljs.core.get.call(null,map__16655__$1,new cljs.core.Keyword(null,"db","db",993250759));
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"db","db",993250759),db,new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.fetch.summary_fields.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db),new cljs.core.Keyword(null,"service","service",-1963054559)], null))),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","success-fetch-summary-fields","assets/success-fetch-summary-fields",888030039),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("assets","fetch-widgets","assets/fetch-widgets",-1748076788),(function (p__16657){
var map__16658 = p__16657;
var map__16658__$1 = (((((!((map__16658 == null))))?(((((map__16658.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16658.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16658):map__16658);
var db = cljs.core.get.call(null,map__16658__$1,new cljs.core.Keyword(null,"db","db",993250759));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.fetch.widgets.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db),new cljs.core.Keyword(null,"service","service",-1963054559)], null))),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","success-fetch-widgets","assets/success-fetch-widgets",-97144362),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("assets","success-fetch-widgets","assets/success-fetch-widgets",-97144362),(function (db,p__16660){
var vec__16661 = p__16660;
var _ = cljs.core.nth.call(null,vec__16661,(0),null);
var mine_kw = cljs.core.nth.call(null,vec__16661,(1),null);
var widgets = cljs.core.nth.call(null,vec__16661,(2),null);
var widget_type = "enrichment";
var filtered_widgets = cljs.core.doall.call(null,cljs.core.filter.call(null,((function (widget_type,vec__16661,_,mine_kw,widgets){
return (function (widget){
return cljs.core._EQ_.call(null,widget_type,new cljs.core.Keyword(null,"widgetType","widgetType",1044398909).cljs$core$IFn$_invoke$arity$1(widget));
});})(widget_type,vec__16661,_,mine_kw,widgets))
,widgets));
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"widgets","widgets",-159098978),mine_kw], null),filtered_widgets);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("assets","fetch-intermine-version","assets/fetch-intermine-version",-1791303773),(function (p__16664){
var map__16665 = p__16664;
var map__16665__$1 = (((((!((map__16665 == null))))?(((((map__16665.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16665.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16665):map__16665);
var db = cljs.core.get.call(null,map__16665__$1,new cljs.core.Keyword(null,"db","db",993250759));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.fetch.version_intermine.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db),new cljs.core.Keyword(null,"service","service",-1963054559)], null))),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","success-fetch-intermine-version","assets/success-fetch-intermine-version",1964989384),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("assets","success-fetch-intermine-version","assets/success-fetch-intermine-version",1964989384),(function (db,p__16667){
var vec__16668 = p__16667;
var _ = cljs.core.nth.call(null,vec__16668,(0),null);
var mine_kw = cljs.core.nth.call(null,vec__16668,(1),null);
var version = cljs.core.nth.call(null,vec__16668,(2),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"intermine-version","intermine-version",-920199031),mine_kw], null),version);
}));
re_frame.core.reg_event_fx.call(null,new cljs.core.Keyword("assets","fetch-web-service-version","assets/fetch-web-service-version",-1026252895),(function (p__16671){
var map__16672 = p__16671;
var map__16672__$1 = (((((!((map__16672 == null))))?(((((map__16672.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__16672.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__16672):map__16672);
var db = cljs.core.get.call(null,map__16672__$1,new cljs.core.Keyword(null,"db","db",993250759));
return new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"im-chan","im-chan",583536683),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"chan","chan",-2103021695),imcljs.fetch.version_web_service.call(null,cljs.core.get_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"mines","mines",-1960796490),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db),new cljs.core.Keyword(null,"service","service",-1963054559)], null))),new cljs.core.Keyword(null,"on-success","on-success",1786904109),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("assets","success-fetch-web-service-version","assets/success-fetch-web-service-version",-42494710),new cljs.core.Keyword(null,"current-mine","current-mine",-697419086).cljs$core$IFn$_invoke$arity$1(db)], null)], null)], null);
}));
re_frame.core.reg_event_db.call(null,new cljs.core.Keyword("assets","success-fetch-web-service-version","assets/success-fetch-web-service-version",-42494710),(function (db,p__16674){
var vec__16675 = p__16674;
var _ = cljs.core.nth.call(null,vec__16675,(0),null);
var mine_kw = cljs.core.nth.call(null,vec__16675,(1),null);
var version = cljs.core.nth.call(null,vec__16675,(2),null);
return cljs.core.assoc_in.call(null,db,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"assets","assets",210278279),new cljs.core.Keyword(null,"web-service-version","web-service-version",1822428804),mine_kw], null),version);
}));

//# sourceMappingURL=boot.js.map
