// Compiled by ClojureScript 1.10.520 {}
goog.provide('bluegenes.interceptors');
goog.require('cljs.core');
goog.require('re_frame.core');
goog.require('cljs.spec.alpha');
goog.require('oops.core');
/**
 * Provides a re-frame interceptor that accepts a Clojure spec. When the event fires it uses the provided spec
 *   to validate the first value proceeding the event name in the event vector. If the spec does not validate
 *   the data then the event is rolled back.
 *   Note: I wrote this as an experiment to combine spec / interceptors but it's actually useful because it enqueues
 *   events rather than letting them fail. A good use case would be: dispatching an event that runs a query. If the query
 *   doesn't match the query spec then the event is rolled back, and when used in combination with an Undo effect you won't
 *   need to manage an extra 'bad' dispatch.
 */
bluegenes.interceptors.abort_spec = (function bluegenes$interceptors$abort_spec(spec){
return re_frame.core.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"stopper","stopper",-304934685),new cljs.core.Keyword(null,"before","before",-1633692388),(function (context){
var vec__22832 = cljs.core.get_in.call(null,context,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"coeffects","coeffects",497912985),new cljs.core.Keyword(null,"event","event",301435442)], null));
var _ = cljs.core.nth.call(null,vec__22832,(0),null);
var data = cljs.core.nth.call(null,vec__22832,(1),null);
if((!(cljs.spec.alpha.valid_QMARK_.call(null,spec,data)))){
throw cljs.spec.alpha.explain_str.call(null,spec,data);

return re_frame.core.enqueue.call(null,cljs.core.dissoc.call(null,context,new cljs.core.Keyword(null,"queue","queue",1455835879)),cljs.core.PersistentVector.EMPTY);
} else {
return context;
}
}));
});
/**
 * This interceptor is an example of something you do when you want to beat Bootstrap with a hammer.
 *   It will look for any popovers in the DOM and force them to close. Sticky popovers
 *   are a common problem for us because Bootstrap doesn't know when a React component that triggered
 *   a popover unmounts.
 */
bluegenes.interceptors.clear_tooltips = (function bluegenes$interceptors$clear_tooltips(){
return re_frame.core.__GT_interceptor.call(null,new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"clear-tooltips","clear-tooltips",370200898),new cljs.core.Keyword(null,"after","after",594996914),(function (context){
var target_obj_22835_22841 = $(".popover");
var _STAR_runtime_state_STAR__orig_val__22839_22842 = oops.state._STAR_runtime_state_STAR_;
var _STAR_runtime_state_STAR__temp_val__22840_22843 = oops.state.prepare_state.call(null,target_obj_22835_22841,(new Error()),function(){arguments[0].apply(console,Array.prototype.slice.call(arguments,1))});
oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__temp_val__22840_22843;

try{var call_info_22837_22844 = [target_obj_22835_22841,(function (){var next_obj_22838 = ((oops.core.validate_object_access_dynamically.call(null,target_obj_22835_22841,(0),"remove",true))?(target_obj_22835_22841["remove"]):null);
return next_obj_22838;
})()];
var fn_22836_22845 = (call_info_22837_22844[(1)]);
if(oops.core.validate_fn_call_dynamically.call(null,fn_22836_22845,oops.state.get_last_access_modifier.call(null))){
if((!((fn_22836_22845 == null)))){
fn_22836_22845.call((call_info_22837_22844[(0)]));
} else {
}
} else {
}
}finally {oops.state._STAR_runtime_state_STAR_ = _STAR_runtime_state_STAR__orig_val__22839_22842;
}
return context;
}));
});

//# sourceMappingURL=interceptors.js.map
