/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.web;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class ReusableInputStream
extends InputStream {
    private InputStream source;
    private File tmpFile;
    private RandomAccessFile data;

    public ReusableInputStream(InputStream src) {
        this.source = src;
    }

    private RandomAccessFile data() throws IOException {
        if (this.data == null) {
            int bytesRead;
            File tmpDir = new File(System.getProperty("jboss.server.temp.dir"));
            this.tmpFile = File.createTempFile("ImmutantReusableInputStream", null, tmpDir);
            this.data = new RandomAccessFile(this.tmpFile, "rw");
            byte[] bytes = new byte[4096];
            while ((bytesRead = this.source.read(bytes, 0, 4096)) > 0) {
                this.data.write(bytes, 0, bytesRead);
            }
            this.data.seek(0L);
            this.source.close();
        }
        return this.data;
    }

    @Override
    public int read() throws IOException {
        return this.data().read();
    }

    @Override
    public void close() throws IOException {
        if (this.data != null) {
            this.data.seek(0L);
        }
    }

    public void hardClose() throws IOException {
        this.source.close();
        if (this.tmpFile != null) {
            this.data.close();
            this.tmpFile.delete();
        }
    }

    public Closeable closer() {
        return new Closeable(){

            @Override
            public void close() throws IOException {
                ReusableInputStream.this.hardClose();
            }
        };
    }
}

