/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.web.ring.processors;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.immutant.web.ring.RingMetaData;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.web.SharedTldsMetaDataBuilder;
import org.jboss.as.web.deployment.TldsMetaData;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.EmptyMetaData;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.javaee.support.MappableMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.MimeMappingMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.msc.service.ServiceName;
import org.projectodd.polyglot.web.servlet.FiveHundredServlet;
import org.projectodd.polyglot.web.servlet.StaticResourceServlet;

public class RingWebApplicationInstaller
implements DeploymentUnitProcessor {
    public static final String RING_FILTER_NAME = "immutant.ring";
    public static final String STATIC_RESROUCE_SERVLET_NAME = "immutant.static";
    public static final String STATIC_RESOURCE_SERVLET_CLASS_NAME = StaticResourceServlet.class.getName();
    public static final String FIVE_HUNDRED_SERVLET_NAME = "immutant.500";
    public static final String FIVE_HUNDRED_SERVLET_CLASS_NAME = FiveHundredServlet.class.getName();
    private static final Logger log = Logger.getLogger((String)"org.immutant.web.ring");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        RingMetaData ringMetaData = (RingMetaData)((Object)unit.getAttachment(RingMetaData.ATTACHMENT_KEY));
        if (ringMetaData == null) {
            return;
        }
        this.attachResourceRoot(unit);
        this.attachTldsMetaData(unit);
        WarMetaData warMetaData = this.getWarMetaData(unit);
        JBossWebMetaData jbossWebMetaData = this.getJBossWebMetaData(phaseContext, warMetaData);
        String deploymentName = unit.getName();
        if (deploymentName.endsWith(".clj")) {
            deploymentName = deploymentName.substring(0, deploymentName.length() - ".clj".length());
        } else if (deploymentName.endsWith(".ima")) {
            deploymentName = deploymentName.substring(0, deploymentName.length() - ".ima".length());
        }
        jbossWebMetaData.setModuleName(deploymentName);
        DeploymentTypeMarker.setType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)unit);
        this.setUpMimeTypes(jbossWebMetaData);
        this.setUpStaticResourceServlet(ringMetaData, jbossWebMetaData);
        this.ensureSomeServlet(ringMetaData, jbossWebMetaData);
        jbossWebMetaData.setContextRoot(ringMetaData.getContextPath());
        jbossWebMetaData.setVirtualHosts(ringMetaData.getHosts());
    }

    private void attachResourceRoot(DeploymentUnit unit) {
        ResourceRoot resourceRoot = (ResourceRoot)unit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        unit.addToAttachmentList(Attachments.RESOURCE_ROOTS, (Object)resourceRoot);
    }

    private JBossWebMetaData getJBossWebMetaData(DeploymentPhaseContext phaseContext, WarMetaData warMetaData) {
        ArrayList servletMappings;
        JBossServletsMetaData servlets;
        JBossWebMetaData jbossWebMetaData;
        HashMap webFragmentsMetaData;
        WebMetaData webMetaData = warMetaData.getWebMetaData();
        if (webMetaData == null) {
            webMetaData = new WebMetaData();
            ServiceName jgroups = ChannelFactoryService.getServiceName(null);
            if (phaseContext.getServiceRegistry().getService(jgroups) != null) {
                webMetaData.setDistributable(new EmptyMetaData());
            }
            warMetaData.setWebMetaData(webMetaData);
        }
        if ((webFragmentsMetaData = warMetaData.getWebFragmentsMetaData()) == null) {
            webFragmentsMetaData = new HashMap();
            warMetaData.setWebFragmentsMetaData(webFragmentsMetaData);
        }
        if ((jbossWebMetaData = warMetaData.getJbossWebMetaData()) == null) {
            jbossWebMetaData = new JBossWebMetaData();
            warMetaData.setJbossWebMetaData(jbossWebMetaData);
        }
        if ((servlets = jbossWebMetaData.getServlets()) == null) {
            servlets = new JBossServletsMetaData();
            jbossWebMetaData.setServlets(servlets);
        }
        if ((servletMappings = jbossWebMetaData.getServletMappings()) == null) {
            servletMappings = new ArrayList();
            jbossWebMetaData.setServletMappings(servletMappings);
        }
        return jbossWebMetaData;
    }

    private WarMetaData getWarMetaData(DeploymentUnit unit) {
        WarMetaData warMetaData = new WarMetaData();
        unit.putAttachment(WarMetaData.ATTACHMENT_KEY, (Object)warMetaData);
        return warMetaData;
    }

    private void attachTldsMetaData(DeploymentUnit unit) throws DeploymentUnitProcessingException {
        TldsMetaData tldsMetaData = new TldsMetaData();
        try {
            Constructor ctor = SharedTldsMetaDataBuilder.class.getDeclaredConstructor(ModelNode.class);
            ctor.setAccessible(true);
            tldsMetaData.setSharedTlds((SharedTldsMetaDataBuilder)ctor.newInstance(new Object[]{null}));
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        unit.putAttachment(TldsMetaData.ATTACHMENT_KEY, (Object)tldsMetaData);
    }

    protected void setUpStaticResourceServlet(RingMetaData ringAppMetaData, JBossWebMetaData jbossWebMetaData) {
        ArrayList<ServletMappingMetaData> servletMappings;
        JBossServletsMetaData servlets = jbossWebMetaData.getServlets();
        if (servlets == null) {
            servlets = new JBossServletsMetaData();
            jbossWebMetaData.setServlets(servlets);
        }
        if ((servletMappings = jbossWebMetaData.getServletMappings()) == null) {
            servletMappings = new ArrayList<ServletMappingMetaData>();
            jbossWebMetaData.setServletMappings(servletMappings);
        }
        if (ringAppMetaData.getStaticPathPrefix() != null) {
            JBossServletMetaData staticServlet = new JBossServletMetaData();
            staticServlet.setServletClass(STATIC_RESOURCE_SERVLET_CLASS_NAME);
            staticServlet.setServletName(STATIC_RESROUCE_SERVLET_NAME);
            staticServlet.setId(STATIC_RESROUCE_SERVLET_NAME);
            ParamValueMetaData resourceRootParam = new ParamValueMetaData();
            resourceRootParam.setParamName("resource.root");
            resourceRootParam.setParamValue(ringAppMetaData.getStaticPathPrefix());
            staticServlet.setInitParam(Collections.singletonList(resourceRootParam));
            servlets.add((MappableMetaData)staticServlet);
            ServletMappingMetaData staticMapping = new ServletMappingMetaData();
            staticMapping.setServletName(STATIC_RESROUCE_SERVLET_NAME);
            staticMapping.setUrlPatterns(Collections.singletonList("/*"));
            servletMappings.add(staticMapping);
        }
    }

    protected void ensureSomeServlet(RingMetaData ringAppMetaData, JBossWebMetaData jbossWebMetaData) {
        JBossServletsMetaData servlets = jbossWebMetaData.getServlets();
        if (servlets.isEmpty()) {
            JBossServletMetaData fiveHundredServlet = new JBossServletMetaData();
            fiveHundredServlet.setServletClass(FIVE_HUNDRED_SERVLET_CLASS_NAME);
            fiveHundredServlet.setServletName(FIVE_HUNDRED_SERVLET_NAME);
            fiveHundredServlet.setId(FIVE_HUNDRED_SERVLET_NAME);
            servlets.add((MappableMetaData)fiveHundredServlet);
            ServletMappingMetaData fiveHundredMapping = new ServletMappingMetaData();
            fiveHundredMapping.setServletName(FIVE_HUNDRED_SERVLET_NAME);
            fiveHundredMapping.setUrlPatterns(Collections.singletonList("/*"));
            List servletMappings = jbossWebMetaData.getServletMappings();
            servletMappings.add(fiveHundredMapping);
        }
    }

    protected MimeMappingMetaData createMimeMapping(String extension, String mimeType) {
        MimeMappingMetaData mapping = new MimeMappingMetaData();
        mapping.setExtension(extension);
        mapping.setMimeType(mimeType);
        return mapping;
    }

    protected void setUpMimeTypes(JBossWebMetaData jbossWebMetaData) {
        ArrayList<MimeMappingMetaData> mappings = new ArrayList<MimeMappingMetaData>();
        mappings.add(this.createMimeMapping("abs", "audio/x-mpeg"));
        mappings.add(this.createMimeMapping("ai", "application/postscript"));
        mappings.add(this.createMimeMapping("aif", "audio/x-aiff"));
        mappings.add(this.createMimeMapping("aifc", "audio/x-aiff"));
        mappings.add(this.createMimeMapping("aiff", "audio/x-aiff"));
        mappings.add(this.createMimeMapping("aim", "application/x-aim"));
        mappings.add(this.createMimeMapping("art", "image/x-jg"));
        mappings.add(this.createMimeMapping("asf", "video/x-ms-asf"));
        mappings.add(this.createMimeMapping("asx", "video/x-ms-asf"));
        mappings.add(this.createMimeMapping("au", "audio/basic"));
        mappings.add(this.createMimeMapping("avi", "video/x-msvideo"));
        mappings.add(this.createMimeMapping("avx", "video/x-rad-screenplay"));
        mappings.add(this.createMimeMapping("bcpio", "application/x-bcpio"));
        mappings.add(this.createMimeMapping("bin", "application/octet-stream"));
        mappings.add(this.createMimeMapping("bmp", "image/bmp"));
        mappings.add(this.createMimeMapping("body", "text/html"));
        mappings.add(this.createMimeMapping("cdf", "application/x-cdf"));
        mappings.add(this.createMimeMapping("cer", "application/x-x509-ca-cert"));
        mappings.add(this.createMimeMapping("class", "application/java"));
        mappings.add(this.createMimeMapping("cpio", "application/x-cpio"));
        mappings.add(this.createMimeMapping("csh", "application/x-csh"));
        mappings.add(this.createMimeMapping("css", "text/css"));
        mappings.add(this.createMimeMapping("dib", "image/bmp"));
        mappings.add(this.createMimeMapping("doc", "application/msword"));
        mappings.add(this.createMimeMapping("dtd", "application/xml-dtd"));
        mappings.add(this.createMimeMapping("dv", "video/x-dv"));
        mappings.add(this.createMimeMapping("dvi", "application/x-dvi"));
        mappings.add(this.createMimeMapping("eps", "application/postscript"));
        mappings.add(this.createMimeMapping("etx", "text/x-setext"));
        mappings.add(this.createMimeMapping("exe", "application/octet-stream"));
        mappings.add(this.createMimeMapping("gif", "image/gif"));
        mappings.add(this.createMimeMapping("gtar", "application/x-gtar"));
        mappings.add(this.createMimeMapping("gz", "application/x-gzip"));
        mappings.add(this.createMimeMapping("hdf", "application/x-hdf"));
        mappings.add(this.createMimeMapping("hqx", "application/mac-binhex40"));
        mappings.add(this.createMimeMapping("htc", "text/x-component"));
        mappings.add(this.createMimeMapping("htm", "text/html"));
        mappings.add(this.createMimeMapping("html", "text/html"));
        mappings.add(this.createMimeMapping("hqx", "application/mac-binhex40"));
        mappings.add(this.createMimeMapping("ief", "image/ief"));
        mappings.add(this.createMimeMapping("jad", "text/vnd.sun.j2me.app-descriptor"));
        mappings.add(this.createMimeMapping("jar", "application/java-archive"));
        mappings.add(this.createMimeMapping("java", "text/plain"));
        mappings.add(this.createMimeMapping("jnlp", "application/x-java-jnlp-file"));
        mappings.add(this.createMimeMapping("jpe", "image/jpeg"));
        mappings.add(this.createMimeMapping("jpeg", "image/jpeg"));
        mappings.add(this.createMimeMapping("jpg", "image/jpeg"));
        mappings.add(this.createMimeMapping("js", "text/javascript"));
        mappings.add(this.createMimeMapping("jsf", "text/plain"));
        mappings.add(this.createMimeMapping("jspf", "text/plain"));
        mappings.add(this.createMimeMapping("kar", "audio/x-midi"));
        mappings.add(this.createMimeMapping("latex", "application/x-latex"));
        mappings.add(this.createMimeMapping("m3u", "audio/x-mpegurl"));
        mappings.add(this.createMimeMapping("mac", "image/x-macpaint"));
        mappings.add(this.createMimeMapping("man", "application/x-troff-man"));
        mappings.add(this.createMimeMapping("mathml", "application/mathml+xml"));
        mappings.add(this.createMimeMapping("me", "application/x-troff-me"));
        mappings.add(this.createMimeMapping("mid", "audio/x-midi"));
        mappings.add(this.createMimeMapping("midi", "audio/x-midi"));
        mappings.add(this.createMimeMapping("mif", "application/x-mif"));
        mappings.add(this.createMimeMapping("mov", "video/quicktime"));
        mappings.add(this.createMimeMapping("movie", "video/x-sgi-movie"));
        mappings.add(this.createMimeMapping("mp1", "audio/x-mpeg"));
        mappings.add(this.createMimeMapping("mp2", "audio/x-mpeg"));
        mappings.add(this.createMimeMapping("mp3", "audio/x-mpeg"));
        mappings.add(this.createMimeMapping("mp4", "video/mp4"));
        mappings.add(this.createMimeMapping("mpa", "audio/x-mpeg"));
        mappings.add(this.createMimeMapping("mpe", "video/mpeg"));
        mappings.add(this.createMimeMapping("mpeg", "video/mpeg"));
        mappings.add(this.createMimeMapping("mpega", "audio/x-mpeg"));
        mappings.add(this.createMimeMapping("mpg", "video/mpeg"));
        mappings.add(this.createMimeMapping("mpv2", "video/mpeg2"));
        mappings.add(this.createMimeMapping("ms", "application/x-wais-source"));
        mappings.add(this.createMimeMapping("nc", "application/x-netcdf"));
        mappings.add(this.createMimeMapping("oda", "application/oda"));
        mappings.add(this.createMimeMapping("odb", "application/vnd.oasis.opendocument.database"));
        mappings.add(this.createMimeMapping("odc", "application/vnd.oasis.opendocument.chart"));
        mappings.add(this.createMimeMapping("odf", "application/vnd.oasis.opendocument.formula"));
        mappings.add(this.createMimeMapping("odg", "application/vnd.oasis.opendocument.graphics"));
        mappings.add(this.createMimeMapping("odi", "application/vnd.oasis.opendocument.image"));
        mappings.add(this.createMimeMapping("odm", "application/vnd.oasis.opendocument.text-master"));
        mappings.add(this.createMimeMapping("odp", "application/vnd.oasis.opendocument.presentation"));
        mappings.add(this.createMimeMapping("ods", "application/vnd.oasis.opendocument.spreadsheet"));
        mappings.add(this.createMimeMapping("odt", "application/vnd.oasis.opendocument.text"));
        mappings.add(this.createMimeMapping("otg ", "application/vnd.oasis.opendocument.graphics-template"));
        mappings.add(this.createMimeMapping("oth", "application/vnd.oasis.opendocument.text-web"));
        mappings.add(this.createMimeMapping("otp", "application/vnd.oasis.opendocument.presentation-template"));
        mappings.add(this.createMimeMapping("ots", "application/vnd.oasis.opendocument.spreadsheet-template "));
        mappings.add(this.createMimeMapping("ott", "application/vnd.oasis.opendocument.text-template"));
        mappings.add(this.createMimeMapping("ogx", "application/ogg"));
        mappings.add(this.createMimeMapping("ogv", "video/ogg"));
        mappings.add(this.createMimeMapping("oga", "audio/ogg"));
        mappings.add(this.createMimeMapping("ogg", "audio/ogg"));
        mappings.add(this.createMimeMapping("spx", "audio/ogg"));
        mappings.add(this.createMimeMapping("flac", "audio/flac"));
        mappings.add(this.createMimeMapping("anx", "application/annodex"));
        mappings.add(this.createMimeMapping("axa", "audio/annodex"));
        mappings.add(this.createMimeMapping("axv", "video/annodex"));
        mappings.add(this.createMimeMapping("xspf", "application/xspf+xml"));
        mappings.add(this.createMimeMapping("pbm", "image/x-portable-bitmap"));
        mappings.add(this.createMimeMapping("pct", "image/pict"));
        mappings.add(this.createMimeMapping("pdf", "application/pdf"));
        mappings.add(this.createMimeMapping("pgm", "image/x-portable-graymap"));
        mappings.add(this.createMimeMapping("pic", "image/pict"));
        mappings.add(this.createMimeMapping("pict", "image/pict"));
        mappings.add(this.createMimeMapping("pls", "audio/x-scpls"));
        mappings.add(this.createMimeMapping("png", "image/png"));
        mappings.add(this.createMimeMapping("pnm", "image/x-portable-anymap"));
        mappings.add(this.createMimeMapping("pnt", "image/x-macpaint"));
        mappings.add(this.createMimeMapping("ppm", "image/x-portable-pixmap"));
        mappings.add(this.createMimeMapping("ppt", "application/powerpoint"));
        mappings.add(this.createMimeMapping("ps", "application/postscript"));
        mappings.add(this.createMimeMapping("psd", "image/x-photoshop"));
        mappings.add(this.createMimeMapping("qt", "video/quicktime"));
        mappings.add(this.createMimeMapping("qti", "image/x-quicktime"));
        mappings.add(this.createMimeMapping("qtif", "image/x-quicktime"));
        mappings.add(this.createMimeMapping("ras", "image/x-cmu-raster"));
        mappings.add(this.createMimeMapping("rdf", "application/rdf+xml"));
        mappings.add(this.createMimeMapping("rgb", "image/x-rgb"));
        mappings.add(this.createMimeMapping("rm", "application/vnd.rn-realmedia"));
        mappings.add(this.createMimeMapping("roff", "application/x-troff"));
        mappings.add(this.createMimeMapping("rtf", "application/rtf"));
        mappings.add(this.createMimeMapping("rtx", "text/richtext"));
        mappings.add(this.createMimeMapping("sh", "application/x-sh"));
        mappings.add(this.createMimeMapping("shar", "application/x-shar"));
        mappings.add(this.createMimeMapping("smf", "audio/x-midi"));
        mappings.add(this.createMimeMapping("sit", "application/x-stuffit"));
        mappings.add(this.createMimeMapping("snd", "audio/basic"));
        mappings.add(this.createMimeMapping("src", "application/x-wais-source"));
        mappings.add(this.createMimeMapping("sv4cpio", "application/x-sv4cpio"));
        mappings.add(this.createMimeMapping("sv4crc", "application/x-sv4crc"));
        mappings.add(this.createMimeMapping("swf", "application/x-shockwave-flash"));
        mappings.add(this.createMimeMapping("t", "application/x-troff"));
        mappings.add(this.createMimeMapping("tar", "application/x-tar"));
        mappings.add(this.createMimeMapping("tcl", "application/x-tcl"));
        mappings.add(this.createMimeMapping("tex", "application/x-tex"));
        mappings.add(this.createMimeMapping("texi", "application/x-texinfo"));
        mappings.add(this.createMimeMapping("texinfo", "application/x-texinfo"));
        mappings.add(this.createMimeMapping("tif", "image/tiff"));
        mappings.add(this.createMimeMapping("tiff", "image/tiff"));
        mappings.add(this.createMimeMapping("tr", "application/x-troff"));
        mappings.add(this.createMimeMapping("tsv", "text/tab-separated-values"));
        mappings.add(this.createMimeMapping("txt", "text/plain"));
        mappings.add(this.createMimeMapping("ulw", "audio/basic"));
        mappings.add(this.createMimeMapping("ustar", "application/x-ustar"));
        mappings.add(this.createMimeMapping("vxml", "application/voicexml+xml"));
        mappings.add(this.createMimeMapping("xbm", "image/x-xbitmap"));
        mappings.add(this.createMimeMapping("xht", "application/xhtml+xml"));
        mappings.add(this.createMimeMapping("xhtml", "application/xhtml+xml"));
        mappings.add(this.createMimeMapping("xml", "application/xml"));
        mappings.add(this.createMimeMapping("xpm", "image/x-xpixmap"));
        mappings.add(this.createMimeMapping("xsl", "application/xml"));
        mappings.add(this.createMimeMapping("xslt", "application/xslt+xml"));
        mappings.add(this.createMimeMapping("xul", "application/vnd.mozilla.xul+xml"));
        mappings.add(this.createMimeMapping("xwd", "image/x-xwindowdump"));
        mappings.add(this.createMimeMapping("wav", "audio/x-wav"));
        mappings.add(this.createMimeMapping("svg", "image/svg+xml"));
        mappings.add(this.createMimeMapping("svgz", "image/svg+xml"));
        mappings.add(this.createMimeMapping("vsd", "application/x-visio"));
        mappings.add(this.createMimeMapping("wbmp", "image/vnd.wap.wbmp"));
        mappings.add(this.createMimeMapping("wml", "text/vnd.wap.wml"));
        mappings.add(this.createMimeMapping("wmlc", "application/vnd.wap.wmlc"));
        mappings.add(this.createMimeMapping("wmls", "text/vnd.wap.wmlscript"));
        mappings.add(this.createMimeMapping("wmlscriptc", "application/vnd.wap.wmlscriptc"));
        mappings.add(this.createMimeMapping("wmv", "video/x-ms-wmv"));
        mappings.add(this.createMimeMapping("wrl", "x-world/x-vrml"));
        mappings.add(this.createMimeMapping("wsdl", "text/xml"));
        mappings.add(this.createMimeMapping("xsd", "text/xml"));
        mappings.add(this.createMimeMapping("Z", "application/x-compress"));
        mappings.add(this.createMimeMapping("z", "application/x-compress"));
        mappings.add(this.createMimeMapping("zip", "application/zip"));
        mappings.add(this.createMimeMapping("xls", "application/vnd.ms-excel"));
        mappings.add(this.createMimeMapping("doc", "application/vnd.ms-word"));
        mappings.add(this.createMimeMapping("ppt", "application/vnd.ms-powerpoint"));
        jbossWebMetaData.setMimeMappings(mappings);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

