/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.messaging;

import java.util.Map;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.XAConnection;
import org.immutant.core.HasImmutantRuntimeInjector;
import org.immutant.messaging.MessageProcessor;
import org.immutant.messaging.MessageProcessorGroupMBean;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.value.InjectedValue;
import org.projectodd.polyglot.core.AtRuntimeInstaller;
import org.projectodd.polyglot.core.ServiceSynchronizationManager;
import org.projectodd.polyglot.messaging.BaseMessageProcessor;
import org.projectodd.polyglot.messaging.BaseMessageProcessorGroup;
import org.projectodd.polyglot.messaging.destinations.DestinationUtils;
import org.projectodd.shimdandy.ClojureRuntimeShim;

public class MessageProcessorGroup
extends BaseMessageProcessorGroup
implements MessageProcessorGroupMBean,
HasImmutantRuntimeInjector {
    private final InjectedValue<ClojureRuntimeShim> clojureRuntimeInjector = new InjectedValue();
    private Object setupHandler;
    private Map setupData;

    public MessageProcessorGroup(ServiceRegistry registry, ServiceName baseServiceName, String destinationName, Connection connection, Object setupHandler) {
        super(registry, baseServiceName, destinationName, MessageProcessor.class);
        this.setStartAsynchronously(false);
        this.setConnection(connection);
        this.setXAEnabled(connection instanceof XAConnection);
        this.setupHandler = setupHandler;
    }

    protected BaseMessageProcessor instantiateProcessor() {
        return new MessageProcessor(this.getRuntime());
    }

    protected void startConnection(StartContext context) {
        try {
            this.getConnection().start();
        }
        catch (JMSException e) {
            context.failed(new StartException((Throwable)e));
        }
    }

    protected Session createSession() {
        this.setupData = (Map)this.getRuntime().invoke(this.setupHandler);
        return (Session)this.setupData.get("session");
    }

    protected MessageConsumer createConsumer(Session session) {
        return (MessageConsumer)this.getRuntime().invoke(this.setupData.get("consumer-fn"), (Object)session);
    }

    protected void startConsumer(BaseMessageProcessor processor) throws Exception {
        super.startConsumer(processor);
        ((MessageProcessor)processor).setHandler(this.setupData.get("handler"));
    }

    public boolean remove(boolean wait) {
        ServiceController service = this.getServiceRegistry().getService(this.getBaseServiceName());
        AtRuntimeInstaller.removeMBeanFor((ServiceRegistry)this.getServiceRegistry(), (ServiceName)this.getBaseServiceName());
        if (service != null) {
            service.setMode(ServiceController.Mode.REMOVE);
            if (wait && !ServiceSynchronizationManager.INSTANCE.waitForServiceRemove(this.getBaseServiceName(), DestinationUtils.destinationWaitTimeout())) {
                log.warn((Object)("Timed out waiting for " + this.getName() + " listener to stop."));
            }
            return true;
        }
        return false;
    }

    public boolean remove() {
        return this.remove(false);
    }

    public ClojureRuntimeShim getRuntime() {
        return (ClojureRuntimeShim)this.clojureRuntimeInjector.getValue();
    }

    public Injector<ClojureRuntimeShim> getClojureRuntimeInjector() {
        return this.clojureRuntimeInjector;
    }
}

