/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.messaging;

import javax.jms.Message;
import javax.jms.XASession;
import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.projectodd.polyglot.messaging.BaseMessageProcessor;
import org.tcrawley.clojure.runtime.shim.ClojureRuntimeShim;

public class MessageProcessor
extends BaseMessageProcessor {
    private ClojureRuntimeShim runtime;
    private Object handler;
    private TransactionManager tm;
    static final Logger log = Logger.getLogger(MessageProcessor.class);

    public MessageProcessor(ClojureRuntimeShim runtime) {
        this.runtime = runtime;
    }

    protected void prepareTransaction() {
        try {
            this.getTransactionManager().begin();
            this.getTransactionManager().getTransaction().enlistResource(((XASession)this.getSession()).getXAResource());
        }
        catch (Throwable e) {
            log.error((Object)"Failed to prepare transaction for message", e);
        }
    }

    public void onMessage(Message message) {
        try {
            try {
                this.runtime.invoke(this.handler, (Object)message);
                if (this.isXAEnabled()) {
                    this.getTransactionManager().commit();
                }
            }
            catch (RollbackException ignored) {
            }
            catch (Throwable e) {
                if (this.isXAEnabled()) {
                    this.getTransactionManager().rollback();
                }
                throw e;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Unexpected error processing message from: " + this.getGroup().getName(), e);
        }
    }

    public void setHandler(Object handler) {
        this.handler = handler;
    }

    protected TransactionManager getTransactionManager() {
        if (this.tm == null) {
            this.tm = (TransactionManager)this.runtime.invoke("immutant.registry/get", (Object)"jboss.txn.TransactionManager");
        }
        return this.tm;
    }
}

