/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.jobs.as;

import org.immutant.core.ClojureMetaData;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class JobsDependenciesProcessor
implements DeploymentUnitProcessor {
    private static ModuleIdentifier IMMUTANT_JOBS_ID = ModuleIdentifier.create((String)"org.immutant.jobs");
    private static ModuleIdentifier POLYGLOT_JOBS_ID = ModuleIdentifier.create((String)"org.projectodd.polyglot.jobs");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        if (unit.hasAttachment(ClojureMetaData.ATTACHMENT_KEY)) {
            this.addDependency(moduleSpecification, moduleLoader, IMMUTANT_JOBS_ID);
            this.addDependency(moduleSpecification, moduleLoader, POLYGLOT_JOBS_ID);
        }
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) {
        moduleSpecification.addLocalDependency(new ModuleDependency(moduleLoader, moduleIdentifier, false, false, false, false));
    }

    public void undeploy(DeploymentUnit context) {
    }
}

