/*
 * Decompiled with CFR 0.152.
 */
package org.immutant.jobs;

import java.util.concurrent.Callable;
import org.immutant.core.as.CoreServices;
import org.immutant.jobs.JobScheduler;
import org.immutant.jobs.ScheduledJob;
import org.immutant.jobs.as.JobsServices;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.projectodd.polyglot.core_extensions.AtRuntimeInstaller;

public class JobSchedulizer
extends AtRuntimeInstaller<JobSchedulizer> {
    private static final Logger log = Logger.getLogger((String)"org.immutant.jobs");

    public JobSchedulizer(DeploymentUnit unit) {
        super(unit);
    }

    public JobScheduler createScheduler(boolean singleton) {
        JobScheduler scheduler = new JobScheduler("JobScheduler$" + this.getUnit().getName());
        ServiceName serviceName = JobsServices.scheduler(this.getUnit(), singleton);
        this.deploy(serviceName, (Service)scheduler, singleton);
        return scheduler;
    }

    public ScheduledJob createJob(Callable handler, String name, String cronExpression, final boolean singleton) {
        final ScheduledJob job = new ScheduledJob(handler, this.getUnit().getName(), name, cronExpression, singleton);
        final ServiceName serviceName = JobsServices.job(this.getUnit(), name);
        this.replaceService(serviceName, new Runnable(){

            @Override
            public void run() {
                ServiceBuilder builder = JobSchedulizer.this.build(serviceName, (Service)job, false);
                builder.addDependency(CoreServices.runtime((DeploymentUnit)JobSchedulizer.this.getUnit()), job.getClojureRuntimeInjector()).addDependency(JobsServices.scheduler(JobSchedulizer.this.getUnit(), singleton), job.getJobSchedulerInjector()).install();
            }
        });
        this.installMBean(serviceName, "immutant.jobs", job);
        return job;
    }
}

