/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import org.apache.hadoop.conf.Configuration;

public class CqlConfigHelper {
    private static final String INPUT_CQL_COLUMNS_CONFIG = "cassandra.input.columnfamily.columns";
    private static final String INPUT_CQL_PAGE_ROW_SIZE_CONFIG = "cassandra.input.page.row.size";
    private static final String INPUT_CQL_WHERE_CLAUSE_CONFIG = "cassandra.input.where.clause";
    private static final String OUTPUT_CQL = "cassandra.output.cql";

    public static void setInputColumns(Configuration conf, String columns) {
        if (columns == null || columns.isEmpty()) {
            return;
        }
        conf.set(INPUT_CQL_COLUMNS_CONFIG, columns);
    }

    public static void setInputCQLPageRowSize(Configuration conf, String cqlPageRowSize) {
        if (cqlPageRowSize == null) {
            throw new UnsupportedOperationException("cql page row size may not be null");
        }
        conf.set(INPUT_CQL_PAGE_ROW_SIZE_CONFIG, cqlPageRowSize);
    }

    public static void setInputWhereClauses(Configuration conf, String clauses) {
        if (clauses == null || clauses.isEmpty()) {
            return;
        }
        conf.set(INPUT_CQL_WHERE_CLAUSE_CONFIG, clauses);
    }

    public static void setOutputCql(Configuration conf, String cql) {
        if (cql == null || cql.isEmpty()) {
            return;
        }
        conf.set(OUTPUT_CQL, cql);
    }

    public static String getInputcolumns(Configuration conf) {
        return conf.get(INPUT_CQL_COLUMNS_CONFIG);
    }

    public static String getInputPageRowSize(Configuration conf) {
        return conf.get(INPUT_CQL_PAGE_ROW_SIZE_CONFIG);
    }

    public static String getInputWhereClauses(Configuration conf) {
        return conf.get(INPUT_CQL_WHERE_CLAUSE_CONFIG);
    }

    public static String getOutputCql(Configuration conf) {
        return conf.get(OUTPUT_CQL);
    }
}

