/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.utils.ByteBufferUtil;

class SliceByNamesReadCommandSerializer
implements IVersionedSerializer<ReadCommand> {
    SliceByNamesReadCommandSerializer() {
    }

    @Override
    public void serialize(ReadCommand cmd, DataOutput dos, int version) throws IOException {
        SliceByNamesReadCommand command = (SliceByNamesReadCommand)cmd;
        dos.writeBoolean(command.isDigestQuery());
        dos.writeUTF(command.table);
        ByteBufferUtil.writeWithShortLength(command.key, dos);
        command.queryPath.serialize(dos);
        NamesQueryFilter.serializer.serialize(command.filter, dos, version);
    }

    @Override
    public SliceByNamesReadCommand deserialize(DataInput dis, int version) throws IOException {
        boolean isDigest = dis.readBoolean();
        String table = dis.readUTF();
        ByteBuffer key = ByteBufferUtil.readWithShortLength(dis);
        QueryPath columnParent = QueryPath.deserialize(dis);
        AbstractType<?> comparator = ColumnFamily.getComparatorFor(table, columnParent.columnFamilyName, columnParent.superColumnName);
        NamesQueryFilter filter = NamesQueryFilter.serializer.deserialize(dis, version, comparator);
        SliceByNamesReadCommand command = new SliceByNamesReadCommand(table, key, columnParent, filter);
        command.setDigestQuery(isDigest);
        return command;
    }

    @Override
    public long serializedSize(ReadCommand cmd, int version) {
        TypeSizes sizes = TypeSizes.NATIVE;
        SliceByNamesReadCommand command = (SliceByNamesReadCommand)cmd;
        int size = sizes.sizeof(command.isDigestQuery());
        int keySize = command.key.remaining();
        size += sizes.sizeof(command.table);
        size += sizes.sizeof((short)keySize) + keySize;
        size += command.queryPath.serializedSize(sizes);
        size = (int)((long)size + NamesQueryFilter.serializer.serializedSize(command.filter, version));
        return size;
    }
}

