/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.concurrency;

import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import java.util.concurrent.Callable;

public class HystrixContextRunnable
implements Runnable {
    private final Callable<Void> actual;
    private final HystrixRequestContext parentThreadState;

    public HystrixContextRunnable(Runnable actual) {
        this(HystrixPlugins.getInstance().getConcurrencyStrategy(), actual);
    }

    public HystrixContextRunnable(HystrixConcurrencyStrategy concurrencyStrategy, Runnable actual) {
        this(concurrencyStrategy, HystrixRequestContext.getContextForCurrentThread(), actual);
    }

    public HystrixContextRunnable(HystrixConcurrencyStrategy concurrencyStrategy, HystrixRequestContext hystrixRequestContext, final Runnable actual) {
        this.actual = concurrencyStrategy.wrapCallable(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                actual.run();
                return null;
            }
        });
        this.parentThreadState = hystrixRequestContext;
    }

    @Override
    public void run() {
        HystrixRequestContext existingState = HystrixRequestContext.getContextForCurrentThread();
        try {
            HystrixRequestContext.setContextOnCurrentThread(this.parentThreadState);
            try {
                this.actual.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            HystrixRequestContext.setContextOnCurrentThread(existingState);
        }
    }
}

