/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesChainedProperty;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class HystrixThreadPoolProperties {
    static int default_coreSize = 10;
    static int default_maximumSize = 10;
    static int default_keepAliveTimeMinutes = 1;
    static int default_maxQueueSize = -1;
    static boolean default_allow_maximum_size_to_diverge_from_core_size = false;
    static int default_queueSizeRejectionThreshold = 5;
    static int default_threadPoolRollingNumberStatisticalWindow = 10000;
    static int default_threadPoolRollingNumberStatisticalWindowBuckets = 10;
    private final HystrixProperty<Integer> corePoolSize;
    private final HystrixProperty<Integer> maximumPoolSize;
    private final HystrixProperty<Integer> keepAliveTime;
    private final HystrixProperty<Integer> maxQueueSize;
    private final HystrixProperty<Integer> queueSizeRejectionThreshold;
    private final HystrixProperty<Boolean> allowMaximumSizeToDivergeFromCoreSize;
    private final HystrixProperty<Integer> threadPoolRollingNumberStatisticalWindowInMilliseconds;
    private final HystrixProperty<Integer> threadPoolRollingNumberStatisticalWindowBuckets;

    protected HystrixThreadPoolProperties(HystrixThreadPoolKey key) {
        this(key, new Setter(), "hystrix");
    }

    protected HystrixThreadPoolProperties(HystrixThreadPoolKey key, Setter builder) {
        this(key, builder, "hystrix");
    }

    protected HystrixThreadPoolProperties(HystrixThreadPoolKey key, Setter builder, String propertyPrefix) {
        this.allowMaximumSizeToDivergeFromCoreSize = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "allowMaximumSizeToDivergeFromCoreSize", builder.getAllowMaximumSizeToDivergeFromCoreSize(), default_allow_maximum_size_to_diverge_from_core_size);
        this.corePoolSize = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "coreSize", builder.getCoreSize(), default_coreSize);
        this.maximumPoolSize = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "maximumSize", builder.getMaximumSize(), default_maximumSize);
        this.keepAliveTime = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "keepAliveTimeMinutes", builder.getKeepAliveTimeMinutes(), default_keepAliveTimeMinutes);
        this.maxQueueSize = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "maxQueueSize", builder.getMaxQueueSize(), default_maxQueueSize);
        this.queueSizeRejectionThreshold = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "queueSizeRejectionThreshold", builder.getQueueSizeRejectionThreshold(), default_queueSizeRejectionThreshold);
        this.threadPoolRollingNumberStatisticalWindowInMilliseconds = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "metrics.rollingStats.timeInMilliseconds", builder.getMetricsRollingStatisticalWindowInMilliseconds(), default_threadPoolRollingNumberStatisticalWindow);
        this.threadPoolRollingNumberStatisticalWindowBuckets = HystrixThreadPoolProperties.getProperty(propertyPrefix, key, "metrics.rollingStats.numBuckets", builder.getMetricsRollingStatisticalWindowBuckets(), default_threadPoolRollingNumberStatisticalWindowBuckets);
    }

    private static HystrixProperty<Integer> getProperty(String propertyPrefix, HystrixThreadPoolKey key, String instanceProperty, Integer builderOverrideValue, Integer defaultValue) {
        return HystrixPropertiesChainedProperty.forInteger().add(propertyPrefix + ".threadpool." + key.name() + "." + instanceProperty, builderOverrideValue).add(propertyPrefix + ".threadpool.default." + instanceProperty, defaultValue).build();
    }

    private static HystrixProperty<Boolean> getProperty(String propertyPrefix, HystrixThreadPoolKey key, String instanceProperty, Boolean builderOverrideValue, Boolean defaultValue) {
        return HystrixPropertiesChainedProperty.forBoolean().add(propertyPrefix + ".threadpool." + key.name() + "." + instanceProperty, builderOverrideValue).add(propertyPrefix + ".threadpool.default." + instanceProperty, defaultValue).build();
    }

    public HystrixProperty<Integer> coreSize() {
        return this.corePoolSize;
    }

    public HystrixProperty<Integer> maximumSize() {
        return this.maximumPoolSize;
    }

    public Integer actualMaximumSize() {
        int coreSize = this.coreSize().get();
        int maximumSize = this.maximumSize().get();
        if (this.getAllowMaximumSizeToDivergeFromCoreSize().get().booleanValue()) {
            if (coreSize > maximumSize) {
                return coreSize;
            }
            return maximumSize;
        }
        return coreSize;
    }

    public HystrixProperty<Integer> keepAliveTimeMinutes() {
        return this.keepAliveTime;
    }

    public HystrixProperty<Integer> maxQueueSize() {
        return this.maxQueueSize;
    }

    public HystrixProperty<Integer> queueSizeRejectionThreshold() {
        return this.queueSizeRejectionThreshold;
    }

    public HystrixProperty<Boolean> getAllowMaximumSizeToDivergeFromCoreSize() {
        return this.allowMaximumSizeToDivergeFromCoreSize;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowInMilliseconds() {
        return this.threadPoolRollingNumberStatisticalWindowInMilliseconds;
    }

    public HystrixProperty<Integer> metricsRollingStatisticalWindowBuckets() {
        return this.threadPoolRollingNumberStatisticalWindowBuckets;
    }

    public static Setter Setter() {
        return new Setter();
    }

    public static Setter defaultSetter() {
        return HystrixThreadPoolProperties.Setter();
    }

    public static class Setter {
        private Integer coreSize = null;
        private Integer maximumSize = null;
        private Integer keepAliveTimeMinutes = null;
        private Integer maxQueueSize = null;
        private Integer queueSizeRejectionThreshold = null;
        private Boolean allowMaximumSizeToDivergeFromCoreSize = null;
        private Integer rollingStatisticalWindowInMilliseconds = null;
        private Integer rollingStatisticalWindowBuckets = null;

        private Setter() {
        }

        public Integer getCoreSize() {
            return this.coreSize;
        }

        public Integer getMaximumSize() {
            return this.maximumSize;
        }

        public Integer getKeepAliveTimeMinutes() {
            return this.keepAliveTimeMinutes;
        }

        public Integer getMaxQueueSize() {
            return this.maxQueueSize;
        }

        public Integer getQueueSizeRejectionThreshold() {
            return this.queueSizeRejectionThreshold;
        }

        public Boolean getAllowMaximumSizeToDivergeFromCoreSize() {
            return this.allowMaximumSizeToDivergeFromCoreSize;
        }

        public Integer getMetricsRollingStatisticalWindowInMilliseconds() {
            return this.rollingStatisticalWindowInMilliseconds;
        }

        public Integer getMetricsRollingStatisticalWindowBuckets() {
            return this.rollingStatisticalWindowBuckets;
        }

        public Setter withCoreSize(int value) {
            this.coreSize = value;
            return this;
        }

        public Setter withMaximumSize(int value) {
            this.maximumSize = value;
            return this;
        }

        public Setter withKeepAliveTimeMinutes(int value) {
            this.keepAliveTimeMinutes = value;
            return this;
        }

        public Setter withMaxQueueSize(int value) {
            this.maxQueueSize = value;
            return this;
        }

        public Setter withQueueSizeRejectionThreshold(int value) {
            this.queueSizeRejectionThreshold = value;
            return this;
        }

        public Setter withAllowMaximumSizeToDivergeFromCoreSize(boolean value) {
            this.allowMaximumSizeToDivergeFromCoreSize = value;
            return this;
        }

        public Setter withMetricsRollingStatisticalWindowInMilliseconds(int value) {
            this.rollingStatisticalWindowInMilliseconds = value;
            return this;
        }

        public Setter withMetricsRollingStatisticalWindowBuckets(int value) {
            this.rollingStatisticalWindowBuckets = value;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Setter setter = (Setter)o;
            return new EqualsBuilder().append((Object)this.coreSize, (Object)setter.coreSize).append((Object)this.maximumSize, (Object)setter.maximumSize).append((Object)this.keepAliveTimeMinutes, (Object)setter.keepAliveTimeMinutes).append((Object)this.maxQueueSize, (Object)setter.maxQueueSize).append((Object)this.queueSizeRejectionThreshold, (Object)setter.queueSizeRejectionThreshold).append((Object)this.allowMaximumSizeToDivergeFromCoreSize, (Object)setter.allowMaximumSizeToDivergeFromCoreSize).append((Object)this.rollingStatisticalWindowInMilliseconds, (Object)setter.rollingStatisticalWindowInMilliseconds).append((Object)this.rollingStatisticalWindowBuckets, (Object)setter.rollingStatisticalWindowBuckets).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.coreSize).append((Object)this.maximumSize).append((Object)this.keepAliveTimeMinutes).append((Object)this.maxQueueSize).append((Object)this.queueSizeRejectionThreshold).append((Object)this.allowMaximumSizeToDivergeFromCoreSize).append((Object)this.rollingStatisticalWindowInMilliseconds).append((Object)this.rollingStatisticalWindowBuckets).toHashCode();
        }
    }
}

