/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.HystrixCollapserKey;
import com.netflix.hystrix.HystrixCollapserMetrics;
import com.netflix.hystrix.HystrixCollapserProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.metric.HystrixCollapserEvent;
import com.netflix.hystrix.metric.HystrixCollapserEventStream;
import com.netflix.hystrix.metric.consumer.BucketedCumulativeCounterStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.functions.Func2;

public class CumulativeCollapserEventCounterStream
extends BucketedCumulativeCounterStream<HystrixCollapserEvent, long[], long[]> {
    private static final ConcurrentMap<String, CumulativeCollapserEventCounterStream> streams = new ConcurrentHashMap<String, CumulativeCollapserEventCounterStream>();
    private static final int NUM_EVENT_TYPES = HystrixEventType.Collapser.values().length;

    public static CumulativeCollapserEventCounterStream getInstance(HystrixCollapserKey collapserKey, HystrixCollapserProperties properties) {
        int counterMetricWindow = properties.metricsRollingStatisticalWindowInMilliseconds().get();
        int numCounterBuckets = properties.metricsRollingStatisticalWindowBuckets().get();
        int counterBucketSizeInMs = counterMetricWindow / numCounterBuckets;
        return CumulativeCollapserEventCounterStream.getInstance(collapserKey, numCounterBuckets, counterBucketSizeInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CumulativeCollapserEventCounterStream getInstance(HystrixCollapserKey collapserKey, int numBuckets, int bucketSizeInMs) {
        CumulativeCollapserEventCounterStream initialStream = (CumulativeCollapserEventCounterStream)streams.get(collapserKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<CumulativeCollapserEventCounterStream> clazz = CumulativeCollapserEventCounterStream.class;
        synchronized (CumulativeCollapserEventCounterStream.class) {
            CumulativeCollapserEventCounterStream existingStream = (CumulativeCollapserEventCounterStream)streams.get(collapserKey.name());
            if (existingStream == null) {
                CumulativeCollapserEventCounterStream newStream = new CumulativeCollapserEventCounterStream(collapserKey, numBuckets, bucketSizeInMs, HystrixCollapserMetrics.appendEventToBucket, HystrixCollapserMetrics.bucketAggregator);
                streams.putIfAbsent(collapserKey.name(), newStream);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return existingStream;
        }
    }

    public static void reset() {
        streams.clear();
    }

    private CumulativeCollapserEventCounterStream(HystrixCollapserKey collapserKey, int numCounterBuckets, int counterBucketSizeInMs, Func2<long[], HystrixCollapserEvent, long[]> appendEventToBucket, Func2<long[], long[], long[]> reduceBucket) {
        super(HystrixCollapserEventStream.getInstance(collapserKey), numCounterBuckets, counterBucketSizeInMs, appendEventToBucket, reduceBucket);
    }

    @Override
    long[] getEmptyBucketSummary() {
        return new long[NUM_EVENT_TYPES];
    }

    @Override
    long[] getEmptyOutputValue() {
        return new long[NUM_EVENT_TYPES];
    }

    public long getLatest(HystrixEventType.Collapser eventType) {
        return ((long[])this.getLatest())[eventType.ordinal()];
    }
}

